/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.listener;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.theme.event.ThemeChangeEvent;
import com.github.weisj.darklaf.theme.event.ThemeChangeListener;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class UIUpdater
implements ThemeChangeListener {
    private static final String KEY_UPDATER = "JComponent.uiUpdaterLister";
    private final Component component;

    public static void registerComponent(JComponent component) {
        if (component == null) {
            return;
        }
        UIUpdater.removeComponent(component);
        UIUpdater updater = new UIUpdater(component);
        component.putClientProperty(KEY_UPDATER, updater);
        LafManager.addThemeChangeListener(new UIUpdater(component));
    }

    public static void removeComponent(JComponent component) {
        Object updater = component.getClientProperty(KEY_UPDATER);
        if (updater instanceof UIUpdater) {
            UIUpdater.removeComponent(component, (UIUpdater)updater);
        }
    }

    private static void removeComponent(JComponent component, UIUpdater updater) {
        component.putClientProperty(KEY_UPDATER, null);
        LafManager.removeThemeChangeListener(updater);
    }

    public UIUpdater(Component component) {
        this.component = component;
    }

    public void themeChanged(ThemeChangeEvent e) {
    }

    public void themeInstalled(ThemeChangeEvent e) {
        if (this.component != null) {
            SwingUtilities.updateComponentTreeUI(this.component);
        }
    }
}

