/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.ENewLineMode;
import com.helger.commons.system.SystemProperties;
import java.io.PrintStream;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ClassPathHelper {
    private static final ClassPathHelper s_aInstance = new ClassPathHelper();

    private ClassPathHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getAllClassPathEntries() {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        ClassPathHelper.forAllClassPathEntries(commonsArrayList::add);
        return commonsArrayList;
    }

    public static void forAllClassPathEntries(@Nonnull Consumer<? super String> consumer) {
        ValueEnforcer.notNull(consumer, "Consumer");
        StringHelper.explode(SystemProperties.getPathSeparator(), SystemProperties.getJavaClassPath(), consumer);
    }

    public static void printClassPathEntries(@Nonnull PrintStream printStream) {
        ClassPathHelper.printClassPathEntries(printStream, ENewLineMode.DEFAULT.getText());
    }

    public static void printClassPathEntries(@Nonnull PrintStream printStream, @Nonnull String string) {
        ClassPathHelper.forAllClassPathEntries(string2 -> {
            printStream.print((String)string2);
            printStream.print(string);
        });
    }
}

