/*
 * Decompiled with CFR 0.152.
 */
package jodd.log;

import java.util.function.Supplier;

public interface Logger {
    public String getName();

    public boolean isEnabled(Level var1);

    public void log(Level var1, String var2);

    default public void log(Level level, Supplier<String> messageSupplier) {
        if (this.isEnabled(level)) {
            this.log(level, messageSupplier.get());
        }
    }

    public void log(Level var1, String var2, Throwable var3);

    default public void log(Level level, Supplier<String> messageSupplier, Throwable throwable) {
        if (this.isEnabled(level)) {
            this.log(level, messageSupplier.get(), throwable);
        }
    }

    public void setLevel(Level var1);

    public boolean isTraceEnabled();

    public void trace(String var1);

    default public void trace(Supplier<String> messageSupplier) {
        if (this.isTraceEnabled()) {
            this.trace(messageSupplier.get());
        }
    }

    public boolean isDebugEnabled();

    public void debug(String var1);

    default public void debug(Supplier<String> messageSupplier) {
        if (this.isDebugEnabled()) {
            this.debug(messageSupplier.get());
        }
    }

    public boolean isInfoEnabled();

    public void info(String var1);

    default public void info(Supplier<String> messageSupplier) {
        if (this.isInfoEnabled()) {
            this.info(messageSupplier.get());
        }
    }

    public boolean isWarnEnabled();

    public void warn(String var1);

    public void warn(String var1, Throwable var2);

    default public void warn(Supplier<String> messageSupplier) {
        if (this.isWarnEnabled()) {
            this.warn(messageSupplier.get());
        }
    }

    default public void warn(Supplier<String> messageSupplier, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.warn(messageSupplier.get(), throwable);
        }
    }

    public boolean isErrorEnabled();

    public void error(String var1);

    public void error(String var1, Throwable var2);

    default public void error(Supplier<String> messageSupplier) {
        if (this.isErrorEnabled()) {
            this.error(messageSupplier.get());
        }
    }

    default public void error(Supplier<String> messageSupplier, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.error(messageSupplier.get(), throwable);
        }
    }

    public static enum Level {
        TRACE(1),
        DEBUG(2),
        INFO(3),
        WARN(4),
        ERROR(5);

        private final int value;

        private Level(int value) {
            this.value = value;
        }

        public boolean isEnabledFor(Level level) {
            return this.value >= level.value;
        }
    }
}

