/*
 * (C) Copyright IBM Corp. 2001
 */
//$Id: LargeAlloc.java,v 1.7 2003/12/05 23:44:59 augart-oss Exp $
/*
 * @author Perry Cheng
 */

class LargeAlloc {

  static long allocSize = 0;  // in megabytes
  static int itemSize = 16 * 1024; 
  static int sizeCount = 10;
  static double sizeRatio = 1.5;
  public static byte [] junk;

  public static void main(String args[])  throws Throwable {
    boolean base = true;
    if (args.length == 0)
      System.out.println("No argument.  Assuming base");
    if (args[0].compareTo("opt") == 0 ||
        args[0].compareTo("perf") == 0)
      base = true;
    allocSize = base ? 500 : 3000;
    runTest();

    System.exit(0);
  }

  static double timeLimit = 300.0;

  public static void runTest() throws Throwable {

    System.out.println("LargeAlloc running with " + allocSize + " Mb of allocation");
    System.out.println("Run with verbose GC on and make sure space accounting is not leaking");
    System.out.println();

    long lastUsed = 0;
    long used = 0;
    long limit = allocSize * 1024 * 1024;
    long start = System.currentTimeMillis();
    System.gc();
    long startUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    while (used < limit) {
      int curSize = itemSize;
      for (int i=0; i<sizeCount; i++) {
        junk = new byte[curSize];
        used += itemSize;
        curSize = (int) (curSize * sizeRatio);
      }
      if (used - lastUsed > 100 * 1024 * 1024) {
        long cur = System.currentTimeMillis();
        System.out.println("Allocated " + (used >> 20) + " Mb at time " + ((cur - start) / 1000.0) + " sec");
        lastUsed = used;
      }
      long cur = System.currentTimeMillis();
      double elapsed = (cur - start) / 1000.0;
      if (elapsed > timeLimit) {
        System.out.println("Exitting because exceeded time limit of " + timeLimit + " seconds");
        break;
      }
    }
    System.gc();
    long endUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    System.out.print("\nOverall: after allocation, usedMemory has increased by ");
    System.out.println(((endUsed - startUsed) / (1024.0 * 1024.0)) + " Mb");
  }
}
