/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class TimeSeriesDemo4
extends ApplicationFrame {
    static /* synthetic */ Class class$org$jfree$data$time$Hour;

    public TimeSeriesDemo4(String string) {
        super(string);
        XYDataset xYDataset = TimeSeriesDemo4.createDataset();
        JFreeChart jFreeChart = TimeSeriesDemo4.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane((Container)chartPanel);
    }

    private static XYDataset createDataset() {
        TimeSeries timeSeries = new TimeSeries("Random Data", class$org$jfree$data$time$Hour == null ? (class$org$jfree$data$time$Hour = TimeSeriesDemo4.class$("org.jfree.data.time.Hour")) : class$org$jfree$data$time$Hour);
        Day day = new Day();
        timeSeries.add((RegularTimePeriod)new Hour(1, day), 500.2);
        timeSeries.add((RegularTimePeriod)new Hour(2, day), 694.1);
        timeSeries.add((RegularTimePeriod)new Hour(3, day), 734.4);
        timeSeries.add((RegularTimePeriod)new Hour(4, day), 453.2);
        timeSeries.add((RegularTimePeriod)new Hour(7, day), 500.2);
        timeSeries.add((RegularTimePeriod)new Hour(8, day), null);
        timeSeries.add((RegularTimePeriod)new Hour(12, day), 734.4);
        timeSeries.add((RegularTimePeriod)new Hour(16, day), 453.2);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeSeries);
        return timeSeriesCollection;
    }

    private static JFreeChart createChart(XYDataset xYDataset) {
        String string = "\u20a2\u20a2\u20a3\u20a4\u20a5\u20a6\u20a7\u20a8\u20a9\u20aa";
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart((String)string, (String)"Time", (String)"Value", (XYDataset)xYDataset, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setInsets(new Insets(0, 0, 0, 20));
        ValueMarker valueMarker = new ValueMarker(700.0);
        valueMarker.setPaint((Paint)Color.blue);
        valueMarker.setAlpha(0.8f);
        xYPlot.addRangeMarker((Marker)valueMarker);
        xYPlot.setBackgroundPaint(null);
        xYPlot.setBackgroundImage(JFreeChart.INFO.getLogo());
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (xYItemRenderer instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)xYItemRenderer;
            standardXYItemRenderer.setPlotShapes(true);
            standardXYItemRenderer.setShapesFilled(true);
        }
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = TimeSeriesDemo4.createChart(TimeSeriesDemo4.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        TimeSeriesDemo4 timeSeriesDemo4 = new TimeSeriesDemo4("Time Series Demo 4");
        timeSeriesDemo4.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)timeSeriesDemo4));
        timeSeriesDemo4.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

