/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class BarChartDemo5
extends ApplicationFrame {
    public BarChartDemo5(String string) {
        super(string);
        CategoryDataset categoryDataset = BarChartDemo5.createDataset();
        JFreeChart jFreeChart = BarChartDemo5.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)chartPanel);
    }

    private static CategoryDataset createDataset() {
        double[][] dArrayArray = new double[][]{{1.0, 43.0, 35.0, 58.0, 54.0, 77.0, 71.0, 89.0}, {54.0, 75.0, 63.0, 83.0, 43.0, 46.0, 27.0, 13.0}, {41.0, 33.0, 22.0, 34.0, 62.0, 32.0, 42.0, 34.0}};
        return DatasetUtilities.createCategoryDataset((String)"Series ", (String)"Factor ", (double[][])dArrayArray);
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart((String)"Bar Chart", (String)"Category", (String)"Score (%)", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.getRenderer().setSeriesPaint(0, (Paint)new Color(0, 0, 255));
        categoryPlot.getRenderer().setSeriesPaint(1, (Paint)new Color(75, 75, 255));
        categoryPlot.getRenderer().setSeriesPaint(2, (Paint)new Color(150, 150, 255));
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setRange(0.0, 100.0);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = BarChartDemo5.createChart(BarChartDemo5.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        BarChartDemo5 barChartDemo5 = new BarChartDemo5("Bar Chart Demo 5");
        barChartDemo5.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)barChartDemo5));
        barChartDemo5.setVisible(true);
    }
}

