/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class BarChartDemo3
extends ApplicationFrame {
    public BarChartDemo3(String string) {
        super(string);
        CategoryDataset categoryDataset = BarChartDemo3.createDataset();
        JFreeChart jFreeChart = BarChartDemo3.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)chartPanel);
    }

    private static CategoryDataset createDataset() {
        double[][] dArrayArray = new double[][]{{4.0, 3.0, -2.0, 3.0, 6.0}};
        return DatasetUtilities.createCategoryDataset((String)"Series ", (String)"Category ", (double[][])dArrayArray);
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart((String)"Bar Chart Demo 3", (String)"Category", (String)"Value", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)Color.lightGray);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setNoDataMessage("NO DATA!");
        CustomRenderer customRenderer = new CustomRenderer(new Paint[]{Color.red, Color.blue, Color.green, Color.yellow, Color.orange, Color.cyan, Color.magenta, Color.blue});
        customRenderer.setLabelGenerator((CategoryLabelGenerator)new StandardCategoryLabelGenerator());
        customRenderer.setItemLabelsVisible(true);
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 45.0);
        customRenderer.setPositiveItemLabelPosition(itemLabelPosition);
        categoryPlot.setRenderer((CategoryItemRenderer)customRenderer);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setLowerMargin(0.15);
        numberAxis.setUpperMargin(0.15);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = BarChartDemo3.createChart(BarChartDemo3.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        BarChartDemo3 barChartDemo3 = new BarChartDemo3("Bar Chart Demo 3");
        barChartDemo3.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)barChartDemo3));
        barChartDemo3.setVisible(true);
    }

    static class CustomRenderer
    extends BarRenderer {
        private Paint[] colors;

        public CustomRenderer(Paint[] paintArray) {
            this.colors = paintArray;
        }

        public Paint getItemPaint(int n, int n2) {
            return this.colors[n2 % this.colors.length];
        }
    }
}

