 
#!/bin/sh
#
# init script for the Jetty Web Server and Servlet Engine
# Compatible with SuSe 7+
# This script is intended to be run by root as part of the init process
# If not run as root or the chosen JETTY_USER it will twice demand a password
# Chris Haynes 2002/03/14
#

# Set the classpath to where the java classes are
export CLASSPATH=/home/admin/classes

# Set USER to the name of the user who is to run jetty (NOT root for max. security)

export JETTY_USER=admin

# Setup JETTY_HOME to the root directory for Jetty
export JETTY_HOME=/opt/jetty


# Setup JAVA_HOME to your JDK home dir
export JAVA_HOME=/usr/java/j2sdk1.4.0

# Add Java paths so Jetty can find them
export PATH=$PATH:$JAVA_HOME/bin:$JAVA_HOME/jre/bin

# Point to the allocated directory in /var
export JETTY_VAR=/var/opt/jetty

# Put the logs in a sub-directory of this
export JETTY_LOG=$JETTY_VAR/logs

# Send the jetty console output into a file
export JETTY_CONSOLE=$JETTY_VAR/console


# See how we were called.
case "$1" in
  start)
	if [ $(whoami) = $JETTY_USER ];
	then  	$JETTY_HOME/bin/jetty.sh start
        else	su -c "$JETTY_HOME/bin/jetty.sh start" $JETTY_USER
	fi
        touch /var/lock/subsys/jetty
	;;
  stop)
	if [ $(whoami) = $JETTY_USER ];
	then 	$JETTY_HOME/bin/jetty.sh stop
        else	su -c "$JETTY_HOME/bin/jetty.sh stop" $JETTY_USER
        fi
	rm -f /var/lock/subsys/jetty
        rm -f /var/run/jetty.pid
        ;;
  restart)
        $0 stop
        sleep 2
        $0 start
        ;;
  *)
        echo "Usage: $0 {start|stop|restart}"
        exit 1
esac

exit 0




