/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.configuration;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.objectweb.carol.util.configuration.CarolConfiguration;
import org.objectweb.carol.util.configuration.RMIConfiguration;
import org.objectweb.carol.util.configuration.TraceCarol;

public class CarolCurrentConfiguration {
    private static Hashtable prodHashtable = null;
    private static Hashtable icHashtable = null;
    private static String defaultRMI;
    private static InheritableThreadLocal threadCtx;
    private static CarolCurrentConfiguration current;

    private CarolCurrentConfiguration() {
        block4: {
            try {
                threadCtx = new InheritableThreadLocal();
                prodHashtable = new Hashtable();
                icHashtable = new Hashtable();
                Hashtable allRMIConfiguration = CarolConfiguration.getAllRMIConfiguration();
                int nbProtocol = allRMIConfiguration.size();
                Enumeration e = allRMIConfiguration.elements();
                while (e.hasMoreElements()) {
                    RMIConfiguration currentConf = (RMIConfiguration)e.nextElement();
                    String rmiName = currentConf.getName();
                    prodHashtable.put(rmiName, (PortableRemoteObjectDelegate)Class.forName(currentConf.getPro()).newInstance());
                    icHashtable.put(rmiName, currentConf.getJndiProperties());
                }
                defaultRMI = CarolConfiguration.getDefaultProtocol().getName();
                threadCtx.set(defaultRMI);
                if (TraceCarol.isDebugCarol()) {
                    TraceCarol.debugCarol("CarolCurrentConfiguration.CarolCurrentConfiguration()");
                    TraceCarol.debugCarol("Number of rmi:" + icHashtable.size());
                    TraceCarol.debugCarol("Default:" + defaultRMI);
                }
            }
            catch (Exception e) {
                if (!TraceCarol.isDebugCarol()) break block4;
                TraceCarol.debugCarol("CarolCurrentConfiguration.CarolCurrentConfiguration() Exception:" + e);
            }
        }
    }

    public static CarolCurrentConfiguration getCurrent() {
        return current;
    }

    public void setRMI(String s) {
        threadCtx.set(s);
    }

    public void setDefault() {
        threadCtx.set(defaultRMI);
    }

    public Hashtable getPortableRemoteObjectHashtable() {
        return prodHashtable;
    }

    public Hashtable getNewContextHashtable() throws NamingException {
        Hashtable<String, InitialContext> result = new Hashtable<String, InitialContext>();
        Enumeration e = icHashtable.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            result.put(k, new InitialContext((Properties)icHashtable.get(k)));
        }
        return result;
    }

    public PortableRemoteObjectDelegate getCurrentPortableRemoteObject() {
        if (threadCtx.get() == null) {
            return (PortableRemoteObjectDelegate)prodHashtable.get(defaultRMI);
        }
        return (PortableRemoteObjectDelegate)prodHashtable.get((String)threadCtx.get());
    }

    public Context getCurrentInitialContext() throws NamingException {
        if (threadCtx.get() == null) {
            return new InitialContext((Properties)icHashtable.get(defaultRMI));
        }
        return new InitialContext((Properties)icHashtable.get((String)threadCtx.get()));
    }

    public Properties getRMIProperties(String name) throws NamingException {
        return (Properties)icHashtable.get(name);
    }

    public String getCurrentRMIName() {
        if (threadCtx.get() == null) {
            return defaultRMI;
        }
        return (String)threadCtx.get();
    }

    public String toString() {
        return "\nnumber of rmi:" + icHashtable.size() + "\ndefault:" + defaultRMI;
    }

    static {
        current = new CarolCurrentConfiguration();
    }
}

