/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet.jsr77.jmx;

import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.ServletStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.jetty.servlet.jsr77.Jsr77Filter;
import org.mortbay.util.jmx.ModelMBeanImpl;

public class Jsr77ServletHolderMBean
extends ModelMBeanImpl {
    private static final Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$servlet$jsr77$jmx$Jsr77ServletHolderMBean == null ? (class$org$mortbay$jetty$servlet$jsr77$jmx$Jsr77ServletHolderMBean = Jsr77ServletHolderMBean.class$("org.mortbay.jetty.servlet.jsr77.jmx.Jsr77ServletHolderMBean")) : class$org$mortbay$jetty$servlet$jsr77$jmx$Jsr77ServletHolderMBean));
    private ServletHolder _servletHolder = null;
    private ServletStats _stats = null;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$jsr77$jmx$Jsr77ServletHolderMBean;

    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("stats", false, true);
        this.defineAttribute("statisticsProvider", false, true);
        this.defineAttribute("processingTime", false, true);
        this.defineAttribute("requestCount", false, true);
        this.defineAttribute("minTime", false, true);
        this.defineAttribute("maxTime", false, true);
        this._servletHolder = (ServletHolder)this.getManagedResource();
    }

    public boolean getStatisticsProvider() {
        return true;
    }

    public ServletStats getStats() {
        this.getJsr77Stats();
        return this._stats;
    }

    public Long getMaxTime() {
        this.getJsr77Stats();
        if (null == this._stats) {
            return new Long(0L);
        }
        return new Long(this._stats.getServiceTime().getMaxTime());
    }

    public Long getMinTime() {
        this.getJsr77Stats();
        if (null == this._stats) {
            return new Long(0L);
        }
        return new Long(this._stats.getServiceTime().getMinTime());
    }

    public Long getProcessingTime() {
        return new Long(this.getTotalTime());
    }

    public Integer getRequestCount() {
        return new Integer((int)this.getCount());
    }

    private long getCount() {
        this.getJsr77Stats();
        if (null == this._stats) {
            return 0L;
        }
        return this._stats.getServiceTime().getCount();
    }

    private long getTotalTime() {
        this.getJsr77Stats();
        if (null == this._stats) {
            return 0L;
        }
        return this._stats.getServiceTime().getTotalTime();
    }

    private void getJsr77Stats() {
        if (null == this._stats) {
            if (null == this._servletHolder) {
                return;
            }
            String servletName = this._servletHolder.getName();
            WebApplicationHandler handler = (WebApplicationHandler)this._servletHolder.getHttpHandler();
            if (null == handler) {
                return;
            }
            FilterHolder filterHolder = handler.getFilter("JSR77Filter-" + servletName);
            if (null != filterHolder) {
                Jsr77Filter filter = (Jsr77Filter)filterHolder.getFilter();
                if (null == filter) {
                    return;
                }
                this._stats = filter.getServletStats();
            }
        }
    }

    public synchronized ObjectName uniqueObjectName(MBeanServer server, String on) {
        ObjectName jsr77Name = null;
        String context = this._servletHolder.getHttpContext().getContextPath();
        if (context.length() == 0) {
            context = "/";
        }
        try {
            jsr77Name = new ObjectName(Jsr77ServletHolderMBean.getDefaultDomain() + ":J2EEServer=null,J2EEApplication=null,J2EEWebModule=" + context + ",j2EEType=Servlet,name=" + this._servletHolder.getName());
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        return jsr77Name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

