/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.util.HashMap;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import mx4j.server.MBeanMetaData;
import mx4j.server.interceptor.DefaultMBeanServerInterceptor;

public class NotificationListenerMBeanServerInterceptor
extends DefaultMBeanServerInterceptor {
    private Map wrappers = new HashMap();

    public String getType() {
        return "notificationlistener";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerWrapper getListenerWrapper(MBeanMetaData metadata, NotificationListener listener) {
        ListenerWrapperKey key = new ListenerWrapperKey(listener, metadata.getMBean());
        ListenerWrapper wrapper = null;
        Map map = this.wrappers;
        synchronized (map) {
            wrapper = (ListenerWrapper)this.wrappers.get(key);
            if (wrapper == null) {
                wrapper = new ListenerWrapper(listener, metadata.getObjectName());
                this.wrappers.put(key, wrapper);
            }
        }
        return wrapper;
    }

    public void addNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        if (this.isEnabled()) {
            ListenerWrapper wrapper = this.getListenerWrapper(metadata, listener);
            super.addNotificationListener(metadata, wrapper, filter, handback);
        } else {
            super.addNotificationListener(metadata, listener, filter, handback);
        }
    }

    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener) throws ListenerNotFoundException {
        if (this.isEnabled()) {
            ListenerWrapper wrapper = this.getListenerWrapper(metadata, listener);
            super.removeNotificationListener(metadata, wrapper);
        } else {
            super.removeNotificationListener(metadata, listener);
        }
    }

    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (this.isEnabled()) {
            ListenerWrapper wrapper = this.getListenerWrapper(metadata, listener);
            super.removeNotificationListener(metadata, wrapper, filter, handback);
        } else {
            super.removeNotificationListener(metadata, listener, filter, handback);
        }
    }

    private static class ListenerWrapperKey {
        private final NotificationListener listener;
        private final Object mbean;

        private ListenerWrapperKey(NotificationListener listener, Object mbean) {
            this.listener = listener;
            this.mbean = mbean;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ListenerWrapperKey)) {
                return false;
            }
            ListenerWrapperKey other = (ListenerWrapperKey)obj;
            if (this.listener != other.listener) {
                return false;
            }
            return this.mbean == other.mbean;
        }

        public int hashCode() {
            int result = this.listener.hashCode();
            result = 29 * result + this.mbean.hashCode();
            return result;
        }
    }

    private static class ListenerWrapper
    implements NotificationListener {
        private final NotificationListener listener;
        private final ObjectName objectName;

        private ListenerWrapper(NotificationListener listener, ObjectName name) {
            this.listener = listener;
            this.objectName = name;
        }

        public void handleNotification(Notification notification, Object handback) {
            Object src = notification.getSource();
            if (!(src instanceof ObjectName)) {
                notification.setSource(this.objectName);
            }
            NotificationListener listener = this.getTargetListener();
            listener.handleNotification(notification, handback);
        }

        private NotificationListener getTargetListener() {
            return this.listener;
        }

        public int hashCode() {
            return this.getTargetListener().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            try {
                ListenerWrapper other = (ListenerWrapper)obj;
                return this.getTargetListener().equals(other.getTargetListener());
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public String toString() {
            return this.getTargetListener().toString();
        }
    }
}

