 
open Char
open Int32

exception InternalError
exception Todo

(* call this from debug code if you want the debugger to stop *)
val stop_here : unit -> unit

(* trace entry and exit of a function for printf debugging *)
val trace : string -> ('a -> 'b) -> 'a -> 'b

(* raise an exception and die *)
val fail : unit -> 'a

(* Lookup value of environment var *)
val lookup : ('a*'b) list -> 'a -> 'b option

(* Remove first occurrence of x from env *)
val remove : ('a*'b) list -> 'a -> ('a*'b) list

(* Remove occurrences of everything in s from env *)
val subtract : ('a*'b) list -> 'a list -> ('a*'b) list

(* Replace first occurence of x with y *)
val substFirst : ('a*'b) list -> 'a -> 'b -> ('a*'b) list

(* Remove first occurence of x in list, l *)
val remove_first : 'a -> 'a list -> 'a list

(* Remove option type wrapper *)
val valof : 'a option -> 'a

(* Set membership *)
val member : 'a -> 'a list -> bool

(* Set intersection *)
val intersect : 'a list -> 'a list -> 'a list

(* Subset: s1 subset of s2? *)
val subset : 'a list -> 'a list -> bool

(* Set equivalence *)
val equiv : 'a list -> 'a list -> bool

(* haskell-style function application operator *)
val ($) : ('a -> 'b) -> 'a -> 'b

(* map that also passes a count *)
val map_from_int : int -> (int -> 'a -> 'b) -> 'a list -> 'b list
val count_map : (int -> 'a -> 'b) -> 'a list -> 'b list
val iter_from_int : int -> (int -> 'a -> unit) -> 'a list -> unit
val fold_from_int : int -> (int -> 'a -> 'b -> 'b) -> 'a list -> 'b -> 'b

val map_int_range : (int -> 'a) -> int -> int -> 'a list

(* map over a list, and concaternate results together *)
val concat_map : ('a -> 'b list) -> 'a list -> 'b list
val concat_map2 : ('a -> 'b -> 'c list) -> 'a list -> 'b list -> 'c list


(* the standard identity function *)
val identity : 'a -> 'a

(* is character a letter rather than a symbol? *)
val is_alpha : char -> bool

(* split one list into two, using the given unpacking function *)
val unzipwith : ('a -> 'b * 'c) -> 'a list -> ('b list * 'c list) 

(* zip two lists *)
val zip : 'a list -> 'b list -> ('a * 'b) list

(* unzip one list into two lists *)
val unzip : ('a * 'b) list -> ('a list * 'b list)

(* zip three lists *)

val zip3 : 'a list -> 'b list -> 'c list -> ('a * 'b * 'c) list

(* get the only element of a list - asserting that it is indeed the only element *)
val onlyelement : 'a list -> 'a

(* replace the single instance of oldelem with newelem *)
val replace_one : cmp:('a -> 'a -> bool) -> list:'a list -> oldelem:'a -> newelem:'a -> 'a list

(* is this string an operator, rather than an alphabetic word *)
val is_op : string -> bool

(* apply f to (option type) x if x is Some... *)
val option_apply : ('a -> 'b) -> 'a option -> 'b option

(* apply f to the option if it is Some *)
val option_iter : ('a -> unit) -> 'a option -> unit

(* map a function, but ignore any None results *)
val option_map : ('a -> 'b option) -> 'a list -> 'b list

(* remove all None elements in an option list *)
val option_list_collapse : ('a option list) -> 'a list

(* convert an option type into a 0 or 1 element list *)
val list_of_option : 'a option -> 'a list

(* return the result of the first application that doesn't return None *)
val list_first_option : ('a -> 'b option) -> 'a list -> 'b option

val list_first_match : ('a -> bool) -> 'a list -> 'a option

(* apply func to elements until returns "true". Return true if any returned true *)
val iter_until_succeeds : ('a -> bool) -> 'a list -> bool

val list_iter3 : ('a -> 'b -> 'c -> unit) -> 'a list -> 'b list -> 'c list -> unit

(* like map, but also passing an accumulating paramater *)
val list_acmap : ('a -> 'b -> ('c * 'b)) -> 'b -> 'a list -> 'c list


(* intersperse <sep> between the elements of <list> *)
val intersperse : 'a -> 'a list -> 'a list

(* see if all elements are the same, using the given comparator *)
val all_equal : ('a -> 'a -> bool) -> 'a list -> bool

(* apply an equality check function to pairs of elements *)
val check_all_equal : ('a -> 'a -> unit) -> 'a list -> unit

(* return one of a list of elements, asserting that all elements are 
   equal, using the given comparator. 
   If the list is empty, return the given default value *)
val one_of_equals : ('a -> 'a -> bool) -> 'a -> 'a list -> 'a

(*Generate a simple sequence from 0 to n - 1*)
val seq : int -> int list

module type EQTYPE = sig
	type t
	val equal : t -> t -> bool
end

(* the prev/next word aligned address *)
val word_align_down : int -> int
val word_align_up : int -> int

(* convert between int64 and int32 *)
val split_long : int64 -> (int32 * int32)

(* index of the first element having a property *)
val index_of : ('a -> bool) -> 'a list -> int

(* replace the element at the given index with the given list *)
val list_replace : 'a list -> int -> 'a list -> 'a list

(* set the element at the given index, adding an extra item if needed *)
val list_set : 'a -> int -> 'a list -> 'a list

(* remove the element at the given index *)
val list_remove : int -> 'a list -> 'a list

(* return the matching element, if it exists *)
val list_maybe_find : ('a -> bool) -> 'a list -> 'a option

(* repeat an item the given number of times *)
val list_repeat : 'a -> int -> 'a list

(* Removes all duplicates from a list, sorting with the '<' predicate *)
val remove_duplicates : 'a list -> 'a list

(* first list is equal to the second *)
val list_equal : ('a -> 'a -> bool) -> 'a list -> 'a list -> bool

(* first list is a prefix/suffix of the second *)
val list_prefix : 'a list -> 'a list -> bool
val list_suffix : 'a list -> 'a list -> bool

val list_strip_suffix : 'a list -> 'a list -> 'a list

(* common prefix of the two lists *)
val list_common_prefix : 'a list -> 'a list -> 'a list

(* nth element, or dflt if there is no nth element *)
val list_nth_dflt : 'a list -> 'a -> int -> 'a

(* last element of a list *)
val list_last : 'a list -> 'a

(* list with the last element removed *)
val all_but_last : 'a list -> 'a list

(* split a list at the nth element *)
val list_divide : int -> 'a list -> 'a list * 'a list
val list_n_tail : int -> 'a list -> 'a list
val list_n_head : int -> 'a list -> 'a list

(*Count the size of a hashtable*)
val hash_size : ('a, 'b) Hashtbl.t -> int

(*Directory containing our libraries*)
val libdir : string

(* int32 operations, shift, or, conversion, mult, add *)
val (<<*) : int32 -> int -> int32
val (|*) : int32 -> int32 -> int32
val (!*) : int -> int32
val ($**) : int32 -> int32 -> int32
val (+*) : int32 -> int32 -> int32
val (-*) : int32 -> int32 -> int32

(* integer operations on lists *)
val list_sum : int list -> int
val list_max : int list -> int

val logbase2 : int32 -> int
val pow : int -> int -> int

val intcounter : int -> (unit -> int)

val string_map : string -> (char -> char) -> string

(* convert all tabs to spaces - used when printing lines*)
val strip_tabs : string -> string
(* convert repeated spaces to single spaces - used when printing includes *)
val collapse_spaces : string -> string

val strip_comments : string -> string
val contains_comment : string -> bool

val is_prefix : string -> string -> bool
val is_suffix : string -> string -> bool
val strip_prefix : string -> string -> string
val strip_suffix : string -> string -> string

val list_to_string : char list -> string
val string_to_list : string -> char list

val list_extract : 'a -> 'a list -> 'a list option

(* do two lists have the same elements - ignoring order *)
val same_elements : 'a list -> 'a list -> bool

val opt_equal : ('a -> 'a -> bool) -> 'a option -> 'a option -> bool

(* each time an exception is raised, we try with the next element *)
val exception_iter : ('a -> 'b) -> 'a list -> 'b 

val tailiter : ('a -> 'a list -> unit) -> 'a list -> unit

val string_longest : string -> string -> string

