
open Location

type pretty
type key
type namevar


(* ------------------------------------------------------------
 * Core Combinators
 * ------------------------------------------------------------ *)

val empty : pretty
val (<+>) : pretty -> pretty -> pretty
val twin : string -> string -> pretty


(* ------------------------------------------------------------
 * Non Determinism
 * ------------------------------------------------------------ *)

val new_key : unit -> key
val new_namevar : string -> string -> namevar
val new_fixed_namevar : string -> namevar
val jkl_choice : key -> pretty list -> pretty -> pretty


(* ------------------------------------------------------------
 * Distinguishing between C and Jekyll
 * ------------------------------------------------------------ *)

val extract_c : pretty -> pretty
val extract_jkl : pretty -> pretty
val onlyc : string -> pretty
val onlyjkl : string -> pretty
val onlyc_block : pretty -> pretty
val onlyjkl_block : pretty -> pretty
val onlyc_var : namevar -> pretty
val onlyjkl_var : namevar -> pretty
val decodejkl_var : namevar -> string -> pretty

(* ------------------------------------------------------------
 * Special ways for twinning up tokens
 * ------------------------------------------------------------ *)

val onlyc_prefix : string list -> pretty -> pretty


(* ------------------------------------------------------------
 * Derived combinators
 * ------------------------------------------------------------ *)

val str : string -> pretty
val int : int -> pretty
val (<++>) : pretty -> pretty -> pretty
val parens : pretty -> pretty
val braceblock : pretty -> pretty
val indent : pretty -> pretty
val space : pretty
val forcespace : pretty
val newline : pretty
val break : pretty

val pprint_list_sep : 
	(unit -> pretty) -> ('a -> pretty) -> 'a list -> pretty
val pprint_list : ('a -> pretty) -> 'a list -> pretty
val pprint_seq : ('a -> pretty) -> 'a list -> pretty


(* ------------------------------------------------------------
 * Output
 * ------------------------------------------------------------ *)

val dos_endings : bool ref
val line_break : unit -> string

val pretty_to_string : pretty -> string
val output_pretty : out_channel -> pretty -> unit

val output_preserving_whitespace 
	: out_channel -> lextoken list list -> pretty -> lextoken list list -> unit
	
	
