/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.kordamp.jarviz.core.processors.EntriesFindJarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;

public class EntriesExtractJarProcessor
extends EntriesFindJarProcessor {
    private boolean flatten;
    private Path targetDirectory;

    public EntriesExtractJarProcessor(JarFileResolver jarFileResolver) {
        super(jarFileResolver);
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public Path getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(Path targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    @Override
    protected void processJarEntry(JarFile jarFile, FileSystem zipfs, Path path, Set<String> entries) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        String entryName = path.toString();
        if (entryName.startsWith("/")) {
            entryName = entryName.substring(1);
        }
        if (this.isFlatten()) {
            entryName = Paths.get(entryName, new String[0]).getFileName().toString();
        }
        String fileName = Path.of(jarFile.getName(), new String[0]).getFileName().toString();
        fileName = fileName.substring(0, fileName.length() - 4);
        Path destination = this.targetDirectory.resolve(fileName).resolve(entryName);
        try {
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            Files.copy(path, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.processJarEntry(jarFile, zipfs, path, entries);
    }

    @Override
    protected void processJarEntry(JarFile jarFile, JarEntry entry, Set<String> entries) {
        String entryName = entry.getName();
        if (this.isFlatten()) {
            entryName = Paths.get(entryName, new String[0]).getFileName().toString();
        }
        String fileName = Path.of(jarFile.getName(), new String[0]).getFileName().toString();
        fileName = fileName.substring(0, fileName.length() - 4);
        Path destination = this.targetDirectory.resolve(fileName).resolve(entryName);
        try (InputStream in = jarFile.getInputStream(entry);){
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            Files.copy(in, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.processJarEntry(jarFile, entry, entries);
    }
}

