import sys
import re
from xml.etree.ElementTree import ElementTree
# Currency.xml is from http://www.currency-iso.org/dl_iso_table_a1.xml

HEADER = """
// This file is auto-generated header by tools/generate-currency.py.
// So do not edit this file.
#ifndef IV_I18N_CURRENCY_H_
#define IV_I18N_CURRENCY_H_
#include <iv/detail/array.h>
#include <iv/detail/unordered_map.h>
namespace iv {
namespace core {
namespace i18n {

struct CurrencyData {
  static const int kMaxCurrencyCodeSize = %d;
  const char* code;
  const char* name;
  int digits;
  struct CurrencyCode {
    std::size_t size;
    uint16_t data[kMaxCurrencyCodeSize];
  } symbol;

  int CurrencyDigits() const {
    return (digits == -1) ? 2 : digits;
  }
};

typedef std::array<CurrencyData, %d> CurrencyDataArray;
static const CurrencyDataArray kCurrencyData = { {
%s
} };

class Currency {
 public:
  enum Type {
%s,
    NUM_OF_CURRENCIES
  };

  enum Display {
    CODE,
    SYMBOL,
    NAME
  };

  typedef CurrencyData Data;
  typedef std::unordered_map<std::string, const Data*> CurrencyMap;

  static const Data* Lookup(StringPiece name) {
    const CurrencyMap::const_iterator it = Map().find(name);
    if (it != Map().end()) {
      return it->second;
    }
    return NULL;
  }

  static const Data* Lookup(Type type) {
    assert(type < NUM_OF_CURRENCIES);
    return kCurrencyData.data() + type;
  }

 private:
  static const CurrencyMap& Map() {
    static const CurrencyMap map = InitMap();
    return map;
  }

  static CurrencyMap InitMap() {
    CurrencyMap map;
    for (const Data* it = kCurrencyData.data(),  // NOLINT
         *last = kCurrencyData.data() + kCurrencyData.size();
         it != last; ++it) {
      map.insert(std::make_pair(it->code, it));
    }
    return map;
  }
};

} } }  // namespace iv::core::i18n
#endif  // IV_I18N_CURRENCY_H_
"""

def is_ascii(s):
  return all(ord(c) < 128 for c in s)

def dump_line_currency(u):
  res = []
  for c in u:
    res.append(hex(ord(c)))
  return "{ %s }" % (', '.join(res))

def main(source, s2):
  PATTERN = re.compile('^\d+$')

  digits = { }
  with open(s2) as c:
    xml = ElementTree(file=c)
    for currency in xml.findall('.//ISO_CURRENCY'):
      code = currency.find('ALPHABETIC_CODE').text
      digit = currency.find('MINOR_UNIT').text
      if code is not None and digit is not None:
        if PATTERN.match(digit):
          digits[code] = int(digit);

  xml = None
  with open(source) as c:
    xml = ElementTree(file=c)

  max_len = 0
  currencies = []
  for currency in xml.findall('.//currency'):
    symbol = None
    code = currency.get('type')

    elm = currency.find('symbol')
    digit = -1;
    if elm is not None:
      symbol = unicode(elm.text)
      if max_len < len(symbol):
        max_len = len(symbol)
    else:
      symbol = u""

    elm2 = currency.find('displayName')
    name = ""
    if elm2 is not None:
      t = elm2.text
      # TODO(Constellation) more good method...
      if is_ascii(unicode(name)):
        name = '"' + t.encode('utf-8') + '"'
      else:
        name = 'NULL'

    if digits.has_key(code):
      digit = digits[code]

    currencies.append((code, symbol, name, digit))

  print (HEADER %
      (
        max_len,
        len(currencies),
        ',  // NOLINT\n'.join([ '  { "' + c[0] + '", ' + c[2] + ', ' + str(c[3]) + ', { ' + str(len(c[1])) + 'U, ' + dump_line_currency(c[1]) + ' } }' for c in currencies]) + '  // NOLINT',
        ',\n'.join([ '    CURRENCY_' + c[0].upper() for c in currencies])
       )
      ).strip()

if __name__ == '__main__':
  main(sys.argv[1], sys.argv[2])
