#include "dtoa_shortest.h"

const ShortestTestContainerType& ShortestTestContainer() {
  static const ShortestTestContainerType kShortestTestNumbers = { {
    {1.3252057186783201350530603e-106, "13252057186783201", -105},
    {1.6899223998841386493367055e-33, "16899223998841386", -32},
    {1.0077972445720390730768089e+138, "1007797244572039", 139},
    {9.1867519315348420150084539e+98, "9186751931534842", 99},
    {2.3806039266050926162811123e-63, "23806039266050926", -62},
    {4.5919976932520640180577270e-133, "4591997693252064", -132},
    {1.7272067615194015698157467e-111, "17272067615194016", -110},
    {5.5137913707606126062645371e-233, "5513791370760613", -232},
    {3.2990959928362161509020688e+106, "3299095992836216", 107},
    {1.4315689338832699942723483e-149, "143156893388327", -148},
    {2.1841362436256955784396205e-129, "21841362436256956", -128},
    {2.7845681172104227200000000e+17, "27845681172104227", 18},
    {6.1380231397114677888087326e-101, "6138023139711468", -100},
    {2.6204368415809849050731729e+163, "2620436841580985", 164},
    {1.7091289481331723262072421e+248, "17091289481331723", 249},
    {1.0348922753222980178028204e-132, "1034892275322298", -131},
    {2.6497752476476071150763197e-308, "2649775247647607", -307},
    {7.4822449050560397764297518e+124, "748224490505604", 125},
    {3.1026387904896850915478513e-296, "3102638790489685", -295},
    {3.0231537206859015977526118e+223, "30231537206859016", 224},
    {4.2924296430489070452237882e+156, "4292429643048907", 157},
    {7.5066627297459170218149505e-172, "7506662729745917", -171},
    {3.9313879893508392414664459e+207, "3931387989350839", 208},
    {2.0394747354404426895631238e-131, "20394747354404427", -130},
    {1.0371609095992628396338671e+68, "10371609095992628", 69},
    {4.1825395055009590456043130e+49, "4182539505500959", 50},
    {8.8906970003163962680840814e+176, "8890697000316396", 177},
    {3.1682120479001465281493074e+27, "31682120479001465", 28},
    {3.3116594354284591857730425e-214, "3311659435428459", -213},
    {5.8270435531819559300172525e+69, "5827043553181956", 70},
    {1.2905525787704977015088061e+159, "12905525787704977", 160},
    {1.2656408067594076914048263e+106, "12656408067594077", 107},
    {1.3566244872012328498948729e-288, "13566244872012328", -287},
    {2.7189207429747740999183962e-107, "2718920742974774", -106},
    {5.4962310232325185587188125e+29, "54962310232325186", 30},
    {1.2039901566595156659979987e-60, "12039901566595157", -59},
    {2.4361855217773568894543135e-04, "2436185521777357", -3},
    {1.0431384611214260049484168e-260, "1043138461121426", -259},
    {2.3080541526474416462282047e-04, "23080541526474416", -3},
    {2.4147405619576335917152168e-103, "24147405619576336", -102},
    {1.6834823230746819719710365e-22, "1683482323074682", -21},
    {8.7080426599052213999982265e+203, "8708042659905221", 204},
    {1.3880272487448827645468711e+106, "13880272487448828", 107},
    {3.6283981275999341881623758e-298, "3628398127599934", -297},
    {1.2965691469567775539200000e+20, "12965691469567776", 21},
    {2.6560940581538802992023386e-148, "26560940581538803", -147},
    {1.5137554749791916790439891e+137, "15137554749791917", 138},
    {1.9939019983446637744028162e-199, "19939019983446638", -198},
    {6.5866443194645517284957075e+76, "6586644319464552", 77},
    {1.4468397671540319106137213e-226, "1446839767154032", -225},
    {6.2743981634636702802989226e-259, "627439816346367", -258},
    {1.1167753989761870020118527e+42, "1116775398976187", 43},
    {1.5742696534217655244510617e+57, "15742696534217655", 58},
    {6.1830190683754924654362154e+266, "6183019068375492", 267},
    {1.6357186464312246507080816e+53, "16357186464312247", 54},
    {8.7626385386502853568828445e-150, "8762638538650285", -149},
    {1.2782686851947397819540970e-177, "12782686851947398", -176},
    {8.5901443961849337528564932e+250, "8590144396184934", 251},
    {2.6498343354321504725755135e-105, "26498343354321505", -104},
    {1.9578020164117920559234815e-131, "1957802016411792", -130},
    {1.5497642141088722240759558e-123, "15497642141088722", -122},
    {9.1691319521469439820480937e+30, "9169131952146944", 31},
    {3.9046157151871221406982948e-249, "3904615715187122", -248},
    {6.3064007483917435584145024e+136, "6306400748391744", 137},
    {3.1146877595590063968280143e+118, "31146877595590064", 119},
    {1.1407354149089334218097764e+226, "11407354149089334", 227},
    {1.8748608908459399556547457e-33, "187486089084594", -32},
    {7.7011469944270716098450498e+113, "7701146994427072", 114},
    {1.0708849188837334385389633e-78, "10708849188837334", -77},
    {2.8944690604304663858832854e-249, "28944690604304664", -248},
    {2.6865407799434139442608004e-258, "2686540779943414", -257},
    {8.8414360974336110614156311e-158, "8841436097433611", -157},
    {1.7580203265464267510859745e-40, "17580203265464268", -39},
    {6.9915284536696885330088396e+274, "6991528453669689", 275},
    {2.4993141214540274193423965e-194, "24993141214540274", -193},
    {6.8639377438681806661307185e+102, "6863937743868181", 103},
    {2.2421757386952627812710621e-144, "22421757386952628", -143},
    {5.4469612778255034041278577e+36, "5446961277825503", 37},
    {3.4699675909567793999507957e-42, "34699675909567794", -41},
    {3.5656964266388477887743263e+286, "3565696426638848", 287},
    {1.7214351947097940980141862e-235, "1721435194709794", -234},
    {5.7740510393095364965734792e+293, "57740510393095365", 294},
    {1.0683867728180228303032941e+168, "10683867728180228", 169},
    {7.8417136330884926964837217e+254, "7841713633088493", 255},
    {1.4353998706496625043748034e-145, "14353998706496625", -144},
    {1.4386299828739290835809455e-143, "1438629982873929", -142},
    {2.8752786000759308226406574e+06, "2875278600075931", 7},
    {4.5926340384863042757898849e-111, "4592634038486304", -110},
    {5.7265970248538070500226413e+55, "5726597024853807", 56},
    {5.9786442728733652833279224e+66, "5978644272873365", 67},
    {2.1610430481656253174589602e+64, "21610430481656253", 65},
    {1.3165548307748377288297995e-212, "13165548307748377", -211},
    {2.6807666160328904391718750e-225, "26807666160328904", -224},
    {6.2697618655586380144002860e+173, "6269761865558638", 174},
    {1.1751204576545737366175117e+214, "11751204576545737", 215},
    {3.9941186333645135164260864e+07, "39941186333645135", 8},
    {8.7717014790955747616795566e+279, "8771701479095575", 280},
    {3.2875202783733892752405113e-211, "32875202783733893", -210},
    {1.1451502816849844010621653e-106, "11451502816849844", -105},
    {2.6669985486807822575683670e-180, "26669985486807823", -179},
    {8.3970396132495299351252042e+304, "839703961324953", 305},
    {7.1585056056422905113411816e+59, "71585056056422905", 60},
    {1.3301611505256969880162151e+223, "1330161150525697", 224},
    {6.3974810337750397518136181e-117, "639748103377504", -116},
    {2.9014002836541182296833307e-73, "2901400283654118", -72},
    {4.1012657428634783268682669e+252, "4101265742863478", 253},
    {3.3909780920685604278184908e-177, "33909780920685604", -176},
    {2.9832462266190784382086972e+277, "29832462266190784", 278},
    {4.2408967264679168771670036e-220, "4240896726467917", -219},
    {5.6511412945945582648522759e+205, "5651141294594558", 206},
    {3.3971922549971354909761837e-36, "33971922549971355", -35},
    {7.0346265078421031435910822e-290, "7034626507842103", -289},
    {5.9838017187523983194475693e+71, "5983801718752398", 72},
    {8.5944520215508656515553637e-221, "8594452021550866", -220},
    {9.8253671983518666267337231e-26, "9825367198351867", -25},
    {4.9976903291979702696563389e+29, "499769032919797", 30},
    {1.4981662868141252485847889e-23, "14981662868141252", -22},
    {8.6456899086484619304903297e-208, "8645689908648462", -207},
    {8.0925324193140830925919377e-75, "8092532419314083", -74},
    {1.6679947374739701263842679e-251, "16679947374739701", -250},
    {1.2201596791532746727239656e+58, "12201596791532747", 59},
    {1.5749712412767631889730583e+209, "15749712412767632", 210},
    {1.4725958730903781571358689e+126, "14725958730903782", 127},
    {1.1839979122061201231667441e+198, "11839979122061201", 199},
    {4.7885777022264868428508820e-235, "4788577702226487", -234},
    {1.7672793056482473436836944e+101, "17672793056482473", 102},
    {4.1045125029672000177155657e-94, "41045125029672", -93},
    {8.8494629544539611950448208e+238, "8849462954453961", 239},
    {4.2572035464283417650401276e-126, "4257203546428342", -125},
    {2.0845392765739245845328976e+64, "20845392765739246", 65},
    {1.0673343360022037066815679e-286, "10673343360022037", -285},
    {8.1458016967241863465387808e-110, "8145801696724186", -109},
    {1.5730426911871395345970039e+224, "15730426911871395", 225},
    {3.2397607690678853408245583e-225, "32397607690678853", -224},
    {3.8503078828071335276527576e+210, "38503078828071335", 211},
    {7.8715148646758174089130261e+68, "7871514864675817", 69},
    {4.2948212304455311869537911e-174, "4294821230445531", -173},
    {5.5987737471607980995008864e+73, "5598773747160798", 74},
    {2.4110773802390139039879055e-08, "2411077380239014", -7},
    {6.0827061913910494875452396e+164, "6082706191391049", 165},
    {2.5679453321965104563373886e+69, "25679453321965105", 70},
    {9.3050261252337594470967564e-162, "930502612523376", -161},
    {6.0036483954760353105202525e-284, "6003648395476035", -283},
    {4.9008085273929314003182709e+239, "4900808527392931", 240},
    {7.1154848273122389191788161e-302, "7115484827312239", -301},
    {1.3765551283886802237534895e-47, "13765551283886802", -46},
    {1.9947604895103773888671955e+301, "19947604895103774", 302},
    {1.7543955487025116793382849e-242, "17543955487025117", -241},
    {9.1940018232811127944349757e+242, "9194001823281113", 243},
    {8.3226879676322187322903194e+186, "8322687967632219", 187},
    {2.6288951130064901865100714e-22, "262889511300649", -21},
    {3.6862697189529755927824960e-269, "36862697189529756", -268},
    {2.9934715763669705995337155e+111, "29934715763669706", 112},
    {2.0019772311429112433350107e+45, "20019772311429112", 46},
    {4.0439995860910020123459794e-237, "4043999586091002", -236},
    {1.0056583368560327315803436e+47, "10056583368560327", 48},
    {1.7440064841366835624908004e-269, "17440064841366836", -268},
    {8.8238215144632038603425857e+300, "8823821514463204", 301},
    {3.3957896799542624016579082e-69, "33957896799542624", -68},
    {9.3904761476493451819929495e+118, "9390476147649345", 119},
    {2.9139225283507267794304964e+274, "29139225283507268", 275},
    {4.4089423687311979044201468e+91, "4408942368731198", 92},
    {3.7420283999949003439003602e-13, "37420283999949003", -12},
    {7.6949782844885924222778243e+292, "7694978284488592", 293},
    {2.3291631607680878914834466e+03, "2329163160768088", 4},
    {2.3148026010073740800000000e+17, "2314802601007374", 18},
    {2.0924594697637957933806894e+274, "20924594697637958", 275},
    {1.4775302249571262161984658e-52, "14775302249571262", -51},
    {1.6852886819551390499669317e-137, "1685288681955139", -136},
    {7.1358147922548688364036103e-286, "7135814792254869", -285},
    {3.3640750280940265534133815e-175, "33640750280940266", -174},
    {1.1940149073145245295197018e+55, "11940149073145245", 56},
    {1.3765352886315735453816318e-264, "13765352886315735", -263},
    {5.2180151399660783288863712e+258, "5218015139966078", 259},
    {3.8340371652071558098737002e+62, "3834037165207156", 63},
    {1.6795754942307571200000000e+17, "1679575494230757", 18},
    {3.0011308867511879858156509e+134, "3001130886751188", 135},
    {2.3205070222768115984966479e-244, "23205070222768116", -243},
    {3.9573627874437583596378053e+191, "39573627874437584", 192},
    {4.2010848277248547078450142e-239, "4201084827724855", -238},
    {3.6657561704524470303989042e-277, "3665756170452447", -276},
    {1.6567675466054302072787539e+277, "16567675466054302", 278},
    {4.3002681129545479983449793e-290, "4300268112954548", -289},
    {7.3234034973052321104363563e-239, "7323403497305232", -238},
    {2.3753491948884897000397567e-105, "23753491948884897", -104},
    {4.6393260658001027977636281e+214, "4639326065800103", 215},
    {6.6056349255730775801653708e-29, "6605634925573078", -28},
    {1.3206090017038846169726906e+203, "13206090017038846", 204},
    {5.6212788756490541517070043e+166, "5621278875649054", 167},
    {2.9943470266563074836804375e-182, "29943470266563075", -181},
    {2.9979419023068198522067633e-127, "299794190230682", -126},
    {2.3613624594416414918440045e-113, "23613624594416415", -112},
    {2.2679340090603675931502780e+182, "22679340090603676", 183},
    {2.5193879420328525830036754e-185, "25193879420328526", -184},
    {8.1693690246447407450728184e+55, "8169369024644741", 56},
    {1.8225253590724578509078175e+60, "1822525359072458", 61},
    {1.0632829755946747626324997e-24, "10632829755946748", -23},
    {9.3565528112577019143757304e+274, "9356552811257702", 275},
    {9.2528769754649527721596127e-29, "9252876975464953", -28},
    {1.4337254461439105295285346e-136, "14337254461439105", -135},
    {1.5675691438267007812500000e+13, "15675691438267008", 14},
    {3.1999783212022610888088857e-125, "3199978321202261", -124},
    {9.4331487981794005751778628e-22, "94331487981794", -21},
    {1.7791144681413448789681551e-152, "17791144681413449", -151},
    {3.6290147402545625740967630e-192, "36290147402545626", -191},
    {9.1273184870709221328461553e-187, "9127318487070922", -186},
    {7.7204396160415584956468932e-202, "77204396160415585", -201},
    {2.3426246409716591228540274e+217, "2342624640971659", 218},
    {6.0224366743815028025460928e+133, "6022436674381503", 134},
    {9.8104575775120268590987183e-95, "9810457577512027", -94},
    {5.7895514907226678504750269e-22, "5789551490722668", -21},
    {6.5620814525753232128877560e-92, "6562081452575323", -91},
    {4.4805247500091707488232353e+274, "4480524750009171", 275},
    {1.0197729527772740793139200e+23, "1019772952777274", 24},
    {5.3398680403612418059890062e+159, "5339868040361242", 160},
    {4.3907618565429465661115873e+91, "43907618565429466", 92},
    {6.2591978877513264260333927e-09, "62591978877513264", -8},
    {1.1149808193914085915428913e-170, "11149808193914086", -169},
    {1.6938872881912762420833190e+143, "16938872881912762", 144},
    {8.4897938948854400536919754e-198, "848979389488544", -197},
    {5.7164050671861360729309610e-237, "5716405067186136", -236},
    {1.9643049965985094137304425e+70, "19643049965985094", 71},
    {1.7269543333610141105090324e+65, "1726954333361014", 66},
    {8.4344440984995319202775251e-42, "8434444098499532", -41},
    {1.6956345772669280833734374e+184, "1695634577266928", 185},
    {1.4099601372939799403584370e+221, "140996013729398", 222},
    {2.2877695154204962822453601e-144, "22877695154204963", -143},
    {9.5378710456576656034651542e-220, "9537871045657666", -219},
    {2.6405977645278990468645084e+65, "2640597764527899", 66},
    {3.8135884544654157609049951e+290, "3813588454465416", 291},
    {1.3864867002913154896034389e-244, "13864867002913155", -243},
    {9.3016111937743540802913357e-66, "9301611193774354", -65},
    {2.7320159386501704296258634e+246, "27320159386501704", 247},
    {1.8730212880140122369636650e-225, "18730212880140122", -224},
    {2.9243114702788914695715846e-25, "29243114702788915", -24},
    {9.1493526734852750992166777e+243, "9149352673485275", 244},
    {1.3706459914872642294577831e-210, "13706459914872642", -209},
    {8.3830900726156487341175765e+92, "8383090072615649", 93},
    {3.6274987391260146465496544e-186, "36274987391260146", -185},
    {5.2527773393499212278957185e+170, "5252777339349921", 171},
    {2.3033053883872619541746901e-170, "2303305388387262", -169},
    {1.0674795856319614536244163e-290, "10674795856319615", -289},
    {3.3075658190529578641434144e+152, "3307565819052958", 153},
    {8.2284368698769321563041121e-212, "8228436869876932", -211},
    {1.7695886122563230043947922e+44, "1769588612256323", 45},
    {1.4948354835673943670787729e+276, "14948354835673944", 277},
    {1.0650165563502843228560019e-44, "10650165563502843", -43},
    {2.0582851275965257560811431e-38, "20582851275965258", -37},
    {1.9657847291383164735904734e-290, "19657847291383165", -289},
    {1.5972980781200403938676589e+231, "15972980781200404", 232},
    {9.0856277731029841064930709e+77, "9085627773102984", 78},
    {1.5332316306800722167923968e+190, "15332316306800722", 191},
    {8.7769785228931220042703224e+125, "8776978522893122", 126},
    {1.2811454655361097989521366e-263, "12811454655361098", -262},
    {1.3196177062668286151385272e-107, "13196177062668286", -106},
    {5.6144145182662648149442701e+76, "5614414518266265", 77},
    {1.0602367830533640635081495e-100, "10602367830533641", -99},
    {5.9569777711915523853361396e+199, "5956977771191552", 200},
    {5.8306951824467266526583336e-297, "58306951824467267", -296},
    {5.2353381655782170863398368e-34, "5235338165578217", -33},
    {2.8667373008924498365651965e+133, "286673730089245", 134},
    {2.2451044144700913279991520e-73, "22451044144700913", -72},
    {8.9138313911807540000000000e+15, "8913831391180754", 16},
    {7.3949535592016293615199862e-85, "7394953559201629", -84},
    {3.5329273900521720030536020e-194, "3532927390052172", -193},
    {3.4052859735811495393463106e+218, "34052859735811495", 219},
    {5.9554903686026828816938837e+136, "5955490368602683", 137},
    {2.7233637031983152035047798e-112, "2723363703198315", -111},
    {5.7099571744669313056242073e+57, "5709957174466931", 58},
    {6.3124625620363610712578438e+98, "6312462562036361", 99},
    {1.9429933146147794357066926e+257, "19429933146147794", 258},
    {3.6822094159788695577371537e+212, "36822094159788696", 213},
    {1.2008407861188531610962982e-26, "12008407861188532", -25},
    {1.4574601711861583590507507e+08, "14574601711861584", 9},
    {1.4281374532351969938706988e-204, "1428137453235197", -203},
    {3.1297253250876101758688193e+105, "312972532508761", 106},
    {7.9008614361011299355583218e+96, "790086143610113", 97},
    {3.3658993920806136719180783e+162, "33658993920806137", 163},
    {2.8148504311867329814200320e+24, "2814850431186733", 25},
    {4.0804444112510600613838829e+53, "408044441125106", 54},
    {2.5987191656465419749644984e+204, "2598719165646542", 205},
    {1.7755910877244279401132892e-232, "1775591087724428", -231},
    {9.0042891538943494877601996e-306, "900428915389435", -305},
    {8.2345615000236948497122831e-196, "8234561500023695", -195},
    {9.3941615218173532453345837e+229, "9394161521817353", 230},
    {1.1656022500445791916818334e-71, "11656022500445792", -70},
    {3.8220813638371666128690838e-110, "38220813638371666", -109},
    {1.0221208419415078660416365e+67, "10221208419415079", 68},
    {2.8588958441501509987356350e-242, "2858895844150151", -241},
    {5.8626889367815562354159417e-100, "5862688936781556", -99},
    {5.2520036446576433218736820e-123, "5252003644657643", -122},
    {9.3064612587456103507487921e-73, "930646125874561", -72},
    {5.3230943658826290287923496e+177, "5323094365882629", 178},
    {1.6405915050260188518496344e-205, "16405915050260189", -204},
    {1.0885349434248826456288872e+245, "10885349434248826", 246},
    {2.6735980089604353478343077e-215, "26735980089604353", -214},
    {3.4029025444239711860366291e-66, "3402902544423971", -65},
    {3.2363908614883664121469106e-06, "32363908614883664", -5},
    {2.8099998301161225331681943e+296, "28099998301161225", 297},
    {6.0888515011957304008215861e+252, "608885150119573", 253},
    {5.6804892302371442831127980e-16, "5680489230237144", -15},
    {1.2590192242462608366000161e-40, "12590192242462608", -39},
    {5.5696683540652885018545137e-294, "55696683540652885", -293},
    {7.5505577644580230411179316e+131, "7550557764458023", 132},
    {2.0861010975800398498678387e-161, "208610109758004", -160},
    {3.6281112161146322885224760e+202, "36281112161146323", 203},
    {1.0999837613072358765857653e-43, "10999837613072359", -42},
    {4.8974031643957995891002677e-85, "48974031643957996", -84},
    {1.2641761925335491586373335e-163, "12641761925335492", -162},
    {3.1452261719733290773515577e-104, "3145226171973329", -103},
    {3.4813495175878636276889744e-184, "34813495175878636", -183},
    {3.8880123631253744346385103e-295, "38880123631253744", -294},
    {6.2181315417350826240306514e-11, "6218131541735083", -10},
    {5.3122894656197237843921288e+139, "5312289465619724", 140},
    {2.8051913769853345220045176e+190, "28051913769853345", 191},
    {1.4115591302520511185893589e+134, "14115591302520511", 135},
    {6.6403928137032886081290311e+155, "6640392813703289", 156},
    {2.0510457808167118262306742e-162, "20510457808167118", -161},
    {6.3433821675948999202706142e+74, "63433821675949", 75},
    {2.1597948310181604671751123e-42, "21597948310181605", -41},
    {4.6087504720802515176509891e-241, "46087504720802515", -240},
    {1.1618031865207346719015627e+274, "11618031865207347", 275},
    {2.2197111805315254517246131e-45, "22197111805315255", -44},
    {8.3306381428188699586711279e-243, "833063814281887", -242},
    {2.2553814893672579278035822e-16, "2255381489367258", -15},
    {1.1383158867467207544339894e+170, "11383158867467208", 171},
    {1.3179686186941692273348227e-246, "13179686186941692", -245},
    {2.6196445384213365332474316e-68, "26196445384213365", -67},
    {2.5651782433184743402618698e+180, "25651782433184743", 181},
    {1.2411074551472883878915418e+61, "12411074551472884", 62},
    {2.8904479504291041227916980e+79, "2890447950429104", 80},
    {4.0858279177176430880176025e-235, "4085827917717643", -234},
    {5.9182974888171418765253305e+78, "5918297488817142", 79},
    {2.1450652291411297881467874e-147, "21450652291411298", -146},
    {1.7743964420165806202533993e+144, "17743964420165806", 145},
    {2.5755156021775778627804936e-153, "2575515602177578", -152},
    {6.2224624441102606287642360e-246, "6222462444110261", -245},
    {4.1343331894051861984187808e+91, "4134333189405186", 92},
    {4.8977627680081415429002180e+140, "48977627680081415", 141},
    {2.6517668888408229234864253e+47, "2651766888840823", 48},
    {6.0113635388444954089136991e-50, "6011363538844495", -49},
    {2.6516973875067384000617005e+273, "26516973875067384", 274},
    {2.0675046880686599988981001e-57, "206750468806866", -56},
    {5.7114629942576782722137713e-05, "5711462994257678", -4},
    {9.8732675248275036314113039e-165, "9873267524827504", -164},
    {1.0642492068899332198481196e+54, "10642492068899332", 55},
    {5.9770417558475865820313450e+286, "5977041755847587", 287},
    {5.8299302485204621110832196e-301, "5829930248520462", -300},
    {2.7711436225184635289600000e+21, "27711436225184635", 22},
    {2.7812024034878119597916069e+266, "2781202403487812", 267},
    {1.3844552700007161580704430e-06, "13844552700007162", -5},
    {2.6699752866454406983991632e+281, "26699752866454407", 282},
    {1.2506469925279883953283414e+303, "12506469925279884", 304},
    {2.6901893400805121960909579e+272, "26901893400805122", 273},
    {6.4627928393532497022301168e-141, "646279283935325", -140},
    {3.7834709694125076962501886e+240, "3783470969412508", 241},
    {8.6165072585899351733564477e-177, "8616507258589935", -176},
    {1.5989766238677316038550755e-54, "15989766238677316", -53},
    {1.1135503750103456439633341e-271, "11135503750103456", -270},
    {1.6786972416304121250633976e+275, "1678697241630412", 276},
    {1.7525993295292375390366030e+279, "17525993295292375", 280},
    {3.3758762009532524254613987e+208, "33758762009532524", 209},
    {1.4308413986092842318730549e+246, "14308413986092842", 247},
    {7.9257020633449467823228672e-81, "7925702063344947", -80},
    {1.0381606967749571745034079e+225, "10381606967749572", 226},
    {1.5584746605051994224423064e+49, "15584746605051994", 50},
    {4.0945071469165036871009261e+40, "40945071469165037", 41},
    {3.4788884492661548190271703e+58, "3478888449266155", 59},
    {3.7913074367570616304874420e+07, "3791307436757062", 8},
    {3.5191680399655924715483530e-202, "35191680399655925", -201},
    {3.7129358676425799207232025e-145, "371293586764258", -144},
    {2.5157703037259128792042172e-128, "2515770303725913", -127},
    {8.4361337428253461640754818e-283, "8436133742825346", -282},
    {5.1309145165592348765935815e-05, "5130914516559235", -4},
    {5.1753011855212564695675390e-40, "51753011855212565", -39},
    {3.4767813788043530273437500e+11, "3476781378804353", 12},
    {6.0816432888155057705118080e+180, "6081643288815506", 181},
    {3.5096653519759345254698625e+243, "35096653519759345", 244},
    {1.0767456584389425554746499e+247, "10767456584389426", 248},
    {9.2578335248671716780904670e+139, "9257833524867172", 140},
    {2.6741441465878269096324149e-106, "2674144146587827", -105},
    {9.8517230925556538321329031e-22, "9851723092555654", -21},
    {7.6894718816011098807754726e-301, "768947188160111", -300},
    {2.1625402869387663277873702e-10, "21625402869387663", -9},
    {2.3244327647522847297657903e+52, "23244327647522847", 53},
    {1.6917892719065736328125000e+13, "16917892719065736", 14},
    {5.4748582584446826686681102e+169, "5474858258444683", 170},
    {5.6639088167476574113759232e+25, "5663908816747657", 26},
    {1.1217498477746025908736885e+211, "11217498477746026", 212},
    {2.7075358135717521535737552e+77, "2707535813571752", 78},
    {5.1565256345536258720551924e-211, "5156525634553626", -210},
    {4.4262555033399625527702614e-260, "44262555033399626", -259},
    {4.2291132739164204071617588e-34, "422911327391642", -33},
    {2.0051867495428615286936252e+75, "20051867495428615", 76},
    {1.6540405537750354036688805e+07, "16540405537750354", 8},
    {2.9131755915711620413416698e+53, "2913175591571162", 54},
    {1.1275970447866644680614918e+42, "11275970447866645", 43},
    {4.9038676046464966730870270e+82, "4903867604646497", 83},
    {1.5362233488231069500277957e-287, "1536223348823107", -286},
    {1.9144107332383576344729005e+300, "19144107332383576", 301},
    {4.8953294810489273431279708e-154, "48953294810489273", -153},
    {4.1323322357955800251957467e-33, "413233223579558", -32},
    {1.3672863781794655016070163e-92, "13672863781794655", -91},
    {9.0210701764702896466616487e-15, "902107017647029", -14},
    {4.2779354131733019389495677e-143, "4277935413173302", -142},
    {2.0077236953884845000000000e+15, "20077236953884845", 16},
    {8.2423566843110209102261004e-254, "8242356684311021", -253},
    {2.8374839180324989296644417e-306, "2837483918032499", -305},
    {1.0863088088923758545974858e+163, "10863088088923759", 164},
    {4.5523497487425281342150868e+205, "4552349748742528", 206},
    {4.4953676175959275114010220e+191, "44953676175959275", 192},
    {2.9427451907764411317100499e+196, "2942745190776441", 197},
    {7.6699919703835149888177450e-233, "7669991970383515", -232},
    {4.6580315823938870396129880e-43, "4658031582393887", -42},
    {1.0987556715645650658861781e+167, "10987556715645651", 168},
    {1.0749736425755690766206558e+164, "10749736425755691", 165},
    {6.6173072327145658522127567e-55, "6617307232714566", -54},
    {1.2275185050714253630548086e+135, "12275185050714254", 136},
    {1.6349169464601635913322008e-275, "16349169464601636", -274},
    {1.7123557765453176148355230e+192, "17123557765453176", 193},
    {8.6340136402841409178401118e+210, "8634013640284141", 211},
    {1.5257657045162972398148670e+254, "15257657045162972", 255},
    {2.1029849313517603840000000e+18, "21029849313517604", 19},
    {7.3422818894470990896651583e-298, "7342281889447099", -297},
    {7.5590585943362931937043894e+260, "7559058594336293", 261},
    {2.0775062265271774616558304e+265, "20775062265271775", 266},
    {2.7317592624323236224177115e+286, "27317592624323236", 287},
    {3.1500530495933574608801893e+221, "31500530495933575", 222},
    {5.2513348511282718712686651e+76, "5251334851128272", 77},
    {5.8698124552951402098575871e-10, "586981245529514", -9},
    {3.4622692588980170173196399e+42, "3462269258898017", 43},
    {2.1523483692190352140652079e+288, "21523483692190352", 289},
    {5.8296731159582415966149785e+208, "5829673115958242", 209},
    {1.0072603220354225080980585e-174, "10072603220354225", -173},
    {1.1603052873949141973225169e+253, "11603052873949142", 254},
    {9.9829243314917017349833156e-275, "9982924331491702", -274},
    {3.0009450290491049713707256e-89, "3000945029049105", -88},
    {1.0723482790406715879224608e-292, "10723482790406716", -291},
    {1.3116758729464698421966677e-60, "13116758729464698", -59},
    {1.4016140692684562252261860e-87, "14016140692684562", -86},
    {5.4552900320945399698737684e-30, "545529003209454", -29},
    {9.3525469055159624998555744e+198, "9352546905515962", 199},
    {9.4179786632506302945625019e+263, "941797866325063", 264},
    {1.4843588195359611190683962e-237, "1484358819535961", -236},
    {1.1635872661479794393215193e+282, "11635872661479794", 283},
    {4.2256254816510638733933678e+187, "4225625481651064", 188},
    {2.4722010210174776524740949e-258, "24722010210174777", -257},
    {1.8430713666767045405591597e-25, "18430713666767045", -24},
    {1.0455610956240624028511886e+144, "10455610956240624", 145},
    {9.0973200795416116240149442e+230, "9097320079541612", 231},
    {3.6719417471913218476431960e-07, "3671941747191322", -6},
    {3.5685857666358427655923211e+195, "3568585766635843", 196},
    {2.4135660910273678131343544e-204, "24135660910273678", -203},
    {1.8600057133731834829556152e-235, "18600057133731835", -234},
    {7.1383973908915359804782029e-171, "7138397390891536", -170},
    {2.1968263453344398702544771e-145, "219682634533444", -144},
    {4.1773408659714710608496485e+96, "4177340865971471", 97},
    {1.3606285459499637370480235e+227, "13606285459499637", 228},
    {1.1131695833405029444762116e-249, "1113169583340503", -248},
    {2.8436207238864485410078671e-25, "28436207238864485", -24},
    {1.3490043849982425419481269e+43, "13490043849982425", 44},
    {1.3965556339529240741856433e-170, "1396555633952924", -169},
    {2.4416458930674931113779563e+182, "2441645893067493", 183},
    {5.7085328486597789457568102e-127, "5708532848659779", -126},
    {3.9004043973976580209665507e-42, "3900404397397658", -41},
    {2.1459742907869920318772900e-186, "2145974290786992", -185},
    {7.6721078672264546434880541e+179, "7672107867226455", 180},
    {1.8605356050124399149137683e-180, "186053560501244", -179},
    {2.1007649898328759513185104e-74, "2100764989832876", -73},
    {2.1830676446380416412226900e+49, "21830676446380416", 50},
    {7.7873659980474211183867106e-302, "7787365998047421", -301},
    {2.0363650457144260191071724e-52, "2036365045714426", -51},
    {1.4602130467049420652637411e-268, "1460213046704942", -267},
    {8.2008533075077323732900219e+265, "8200853307507732", 266},
    {6.6424869952349991759710481e-301, "6642486995234999", -300},
    {2.2028908070352474416272152e+302, "22028908070352474", 303},
    {3.1491441980797487475288714e-60, "3149144198079749", -59},
    {5.5668717247567810866357979e-117, "5566871724756781", -116},
    {6.8899892084968992753763423e-189, "6889989208496899", -188},
    {8.5320682348894343980086422e-180, "8532068234889434", -179},
    {1.4361615265157197303777671e-221, "14361615265157197", -220},
    {1.6136842514045886098164114e-292, "16136842514045886", -291},
    {2.3816093291014615430004680e-265, "23816093291014615", -264},
    {3.8424346023913397887905975e-106, "384243460239134", -105},
    {7.3096914491769312269505782e-160, "7309691449176931", -159},
    {2.6397666438556662529826716e-93, "26397666438556663", -92},
    {8.5759619722993585398372397e+82, "8575961972299359", 83},
    {2.0593186136355680553869025e+303, "2059318613635568", 304},
    {1.0535591729634440134931986e-254, "1053559172963444", -253},
    {2.1477493498222501486459717e+223, "21477493498222501", 224},
    {3.9163236424504972536386230e+47, "3916323642450497", 48},
    {1.8152134371209147500000000e+15, "18152134371209148", 16},
    {1.2526281259648992695868324e-132, "12526281259648993", -131},
    {3.6989552989579744473714054e-272, "36989552989579744", -271},
    {6.5256887845227895261971110e-257, "65256887845227895", -256},
    {4.5964313829629227498534429e-278, "4596431382962923", -277},
    {1.0429841874152707104688387e+181, "10429841874152707", 182},
    {2.0308124628577242190245672e-239, "20308124628577242", -238},
    {2.6988491023784264125141484e+27, "26988491023784264", 28},
    {1.0273006801248830660396493e+127, "10273006801248831", 128},
    {6.8422302892959303515504683e+234, "684223028929593", 235},
    {2.7781086478904628432405088e+257, "2778108647890463", 258},
    {1.0540294975491971825676970e+196, "10540294975491972", 197},
    {8.2205363278578959439779306e-201, "8220536327857896", -200},
    {1.1870205672126785725480075e+205, "11870205672126786", 206},
    {2.1802629531850213577036136e+28, "21802629531850214", 29},
    {1.0899213558935850708356364e+231, "1089921355893585", 232},
    {1.7538817643896664039140824e+184, "17538817643896664", 185},
    {1.9834494884230872482727672e+79, "19834494884230872", 80},
    {3.5013552605346451251663220e-260, "3501355260534645", -259},
    {3.9753904376403247271164286e+282, "39753904376403247", 283},
    {4.4078175690560219995430478e-162, "4407817569056022", -161},
    {2.0366452072486408769899460e-201, "2036645207248641", -200},
    {1.6108437237209144897807353e+285, "16108437237209145", 286},
    {6.2111804455537607764242412e+202, "6211180445553761", 203},
    {3.0950353634665868267001288e-47, "3095035363466587", -46},
    {2.7026690026038819816243130e-22, "2702669002603882", -21},
    {8.1330378627320255854820094e+288, "8133037862732026", 289},
    {3.9659952549629960394018484e+184, "3965995254962996", 185},
    {1.4847762397973917202572001e+287, "14847762397973917", 288},
    {1.2516260097679597892066539e-123, "12516260097679598", -122},
    {9.9377353498016420222350512e-140, "9937735349801642", -139},
    {2.7066423582217504530544856e-192, "27066423582217505", -191},
    {8.6814696082155275320486845e-58, "8681469608215528", -57},
    {2.6218588804914351421686690e-46, "2621858880491435", -45},
    {4.9497276772153642657010513e+164, "4949727677215364", 165},
    {5.9391926068859515214701567e+112, "59391926068859515", 113},
    {4.5004266656065335345684331e-107, "45004266656065335", -106},
    {9.5573892049034581705200907e+155, "9557389204903458", 156},
    {3.0781135923553783384333116e-125, "30781135923553783", -124},
    {5.1064187991350534476470941e+105, "5106418799135053", 106},
    {7.4206483379278181536455996e-37, "7420648337927818", -36},
    {3.5980874425121345261402439e+00, "35980874425121345", 1},
    {4.9214367351217734813690186e+08, "49214367351217735", 9},
    {1.5134354377891934445307617e+178, "15134354377891934", 179},
    {4.1185611809512004678137379e+89, "41185611809512005", 90},
    {1.3684229710921207832608420e-117, "13684229710921208", -116},
    {1.6108611632904279442612960e-01, "1610861163290428", 0},
    {2.0514708066051097962246313e-104, "20514708066051098", -103},
    {4.9975938377417102331852183e-266, "499759383774171", -265},
    {2.9142870452623561656474546e+105, "2914287045262356", 106},
    {3.1882150336694038830354740e-268, "3188215033669404", -267},
    {2.3450991022645954850696357e+289, "23450991022645955", 290},
    {1.5152297213133222824868731e-223, "15152297213133223", -222},
    {7.4883584824729053530756897e-191, "7488358482472905", -190},
    {1.9353237313133502005786060e-279, "19353237313133502", -278},
    {3.2827790871328487656422950e-228, "3282779087132849", -227},
    {4.3303680025356081035128059e+275, "4330368002535608", 276},
    {3.5237324814143355750832948e-184, "35237324814143356", -183},
    {1.1255976693164556034460525e-264, "11255976693164556", -263},
    {1.5580499262130915131828266e+59, "15580499262130915", 60},
    {5.3284296709467959149704014e-192, "5328429670946796", -191},
    {4.4032853398707042673090972e-140, "4403285339870704", -139},
    {4.7123747347050985801773077e+285, "47123747347050986", 286},
    {2.1333003194917812202048983e-35, "21333003194917812", -34},
    {7.8860049292165095798581481e+43, "788600492921651", 44},
    {2.2280552673677283278341884e+115, "22280552673677283", 116},
    {3.3736045835999768534321042e+231, "3373604583599977", 232},
    {1.4905366343982321883185586e-261, "14905366343982322", -260},
    {6.8040811677802860736846924e+08, "6804081167780286", 9},
    {4.7592431482429127199712870e+27, "47592431482429127", 28},
    {3.0858007856668262592203302e-214, "30858007856668263", -213},
    {1.0612800803323668476047014e+57, "10612800803323668", 58},
    {5.2208908682067687567609979e+166, "5220890868206769", 167},
    {2.2773701968943883509119626e-187, "22773701968943884", -186},
    {4.2534271988230189242817133e-273, "4253427198823019", -272},
    {5.1988347461953751953351776e+279, "5198834746195375", 280},
    {2.2533006421223974788495242e-130, "22533006421223975", -129},
    {7.5827913439042593009313256e-174, "7582791343904259", -173},
    {4.8857594080063271359544232e-89, "4885759408006327", -88},
    {6.5589626419466284801274014e+00, "65589626419466285", 1},
    {5.1836047088116497525402494e+223, "518360470881165", 224},
    {6.0148462733850683778722909e-66, "6014846273385068", -65},
    {4.5453580299440796868504536e-239, "454535802994408", -238},
    {1.6042678753041807220272034e+79, "16042678753041807", 80},
    {3.5958825840309125384339668e-206, "35958825840309125", -205},
    {3.5557143666711580437691260e+147, "3555714366671158", 148},
    {2.0104787891369734702397479e+74, "20104787891369735", 75},
    {4.9768211817455067464099479e+273, "4976821181745507", 274},
    {1.7809278467943286682834726e-262, "17809278467943287", -261},
    {3.1030633069555300933855626e+48, "310306330695553", 49},
    {7.4014831958371614720000000e+18, "7401483195837161", 19},
    {6.9586250964710515672064245e+159, "69586250964710516", 160},
    {1.9636505292244308000000000e+16, "19636505292244308", 17},
    {7.0744202787192557678600608e-127, "7074420278719256", -126},
    {3.3446140934341212423306616e+187, "33446140934341212", 188},
    {7.5474245079758011278660892e-196, "7547424507975801", -195},
    {6.1803564091497348830232741e+201, "6180356409149735", 202},
    {3.2820127213056162554848726e-80, "32820127213056163", -79},
    {6.0561431829999420770582881e-80, "6056143182999942", -79},
    {4.8661918575977485264043207e+179, "48661918575977485", 180},
    {1.1636030303301013519088073e-14, "11636030303301014", -13},
    {1.7256307622535892404875005e+207, "17256307622535892", 208},
    {4.7270649763859016839236511e-34, "4727064976385902", -33},
    {6.0495517498358452354743042e+203, "6049551749835845", 204},
    {2.3705102570735323609825280e+25, "23705102570735324", 26},
    {8.7978450097147003351772922e+182, "87978450097147", 183},
    {2.9749173135401334059306322e+71, "29749173135401334", 72},
    {5.7276357269393017287956617e-282, "5727635726939302", -281},
    {1.1302793603695105476493432e+83, "11302793603695105", 84},
    {7.5921402820781118182291821e-159, "7592140282078112", -158},
    {1.6254081055625022066240257e-194, "16254081055625022", -193},
    {8.4226278529053413390753441e-68, "8422627852905341", -67},
    {1.6409077777504151603780459e+199, "16409077777504152", 200},
    {3.2880141509905740528391138e-134, "3288014150990574", -133},
    {1.4105383991895487607372848e-06, "14105383991895488", -5},
    {1.3861607558441971540125073e-222, "13861607558441972", -221},
    {2.3300064307139133030447706e+99, "23300064307139133", 100},
    {2.8231754200179377148982970e+57, "28231754200179377", 58},
    {1.0056248895492101959444525e-28, "10056248895492102", -27},
    {5.4235655420446036959238482e+251, "5423565542044604", 252},
    {6.9275966803491959837414974e-142, "6927596680349196", -141},
    {3.2841114592571477757268143e-35, "3284111459257148", -34},
    {5.0441601892866781580441578e+193, "5044160189286678", 194},
    {3.9429343459095874230251600e+278, "39429343459095874", 279},
    {1.4944465126427461917759781e+249, "14944465126427462", 250},
    {9.0288988951850115439536270e+281, "9028898895185012", 282},
    {9.4137420595313971440929903e+59, "9413742059531397", 60},
    {3.2552503361919121710031985e+132, "3255250336191912", 133},
    {8.0453035852275756522243483e+35, "8045303585227576", 36},
    {3.1326039939940154713594019e+286, "31326039939940155", 287},
    {4.1615911959553047045708418e+299, "4161591195955305", 300},
    {1.7294011234418034838078418e-269, "17294011234418035", -268},
    {8.4558180246379399249395854e+100, "845581802463794", 101},
    {1.2054774268784735818318992e+50, "12054774268784736", 51},
    {9.2977922877318535208164046e-123, "9297792287731854", -122},
    {5.7374756476823698063127137e-298, "573747564768237", -297},
    {9.6031584417104526995349068e+207, "9603158441710453", 208},
    {6.3294429628802055619480273e-23, "6329442962880206", -22},
    {8.9026658387256498187147673e+229, "890266583872565", 230},
    {3.9339105271336171584748218e-278, "3933910527133617", -277},
    {3.6965692930481016029349269e-48, "36965692930481016", -47},
    {2.4118081430191125066064607e-132, "24118081430191125", -131},
    {3.5754963395914710614641004e-107, "3575496339591471", -106},
    {2.1634023919552813973449354e-120, "21634023919552814", -119},
    {2.0029495601737256645110369e-181, "20029495601737257", -180},
    {5.9387611698050335432687774e-91, "5938761169805034", -90},
    {4.7684224147159045229408185e-116, "47684224147159045", -115},
    {1.8069139035182560263087199e+211, "1806913903518256", 212},
    {9.3632020316495968458317338e-58, "9363202031649597", -57},
    {9.0644077243372618631737114e-284, "9064407724337262", -283},
    {3.2152681309691837679890438e+246, "32152681309691838", 247},
    {3.6518335146218788841839550e-98, "3651833514621879", -97},
    {4.4170370059383524465032067e-244, "44170370059383524", -243},
    {5.2576869294174541640323068e-181, "5257686929417454", -180},
    {9.9457708976588919867985982e-154, "9945770897658892", -153},
    {9.6730871331012804954501503e-201, "967308713310128", -200},
    {4.1992198868871932718756818e+305, "4199219886887193", 306},
    {2.0393912899191427874246777e-75, "20393912899191428", -74},
    {1.3611957738673203008251221e+206, "13611957738673203", 207},
    {6.6879869905497771569554736e+283, "6687986990549777", 284},
    {4.0137184015767043937069475e+228, "40137184015767044", 229},
    {9.7078553929519084935759665e-214, "9707855392951908", -213},
    {1.5620532604527217086125128e-47, "15620532604527217", -46},
    {8.6963226310449810817198527e+131, "8696322631044981", 132},
    {1.9101298103395454976000000e+19, "19101298103395455", 20},
    {2.0324357502070080051734310e+253, "2032435750207008", 254},
    {2.2470365506360581981406671e+263, "22470365506360582", 264},
    {5.5067460447218554751265254e+200, "55067460447218555", 201},
    {3.9961463836622550967338855e+275, "3996146383662255", 276},
    {1.1917788104884457060539452e-46, "11917788104884457", -45},
    {6.7484586515027347965263845e-109, "6748458651502735", -108},
    {7.6825881102077401837652966e+274, "768258811020774", 275},
    {1.8058171060559254018114212e+300, "18058171060559254", 301},
    {6.8785315046320305723169168e-75, "6878531504632031", -74},
    {8.7734060543049402955618332e+49, "877340605430494", 50},
    {1.6692309132804079158107768e-02, "1669230913280408", -1},
    {2.8187938589807857862044508e-244, "28187938589807858", -243},
    {6.2656747277698818120365414e-200, "6265674727769882", -199},
    {5.7855084666075759667281332e+228, "5785508466607576", 229},
    {6.6472356215367193922787588e+201, "6647235621536719", 202},
    {2.8786441537235603681273049e+154, "28786441537235604", 155},
    {2.7016902463684271037839650e+229, "2701690246368427", 230},
    {5.0396113427444918577079311e-111, "5039611342744492", -110},
    {7.1817209373229604726409811e+86, "718172093732296", 87},
    {8.3108003158133969260144281e+85, "8310800315813397", 86},
    {5.7455133833488578752349988e+112, "5745513383348858", 113},
    {7.6844923260261058198799070e+223, "7684492326026106", 224},
    {1.1387720646996824535836223e+59, "11387720646996825", 60},
    {8.9806469261406009123934768e-304, "8980646926140601", -303},
    {1.0954532193965921776129159e-216, "10954532193965922", -215},
    {3.8236584917552931250000000e+14, "3823658491755293", 15},
    {1.7429282123717299187938238e-272, "174292821237173", -271},
    {3.0157612538717755805592769e+294, "30157612538717756", 295},
    {9.9654546669667527121576345e-75, "9965454666966753", -74},
    {2.9750053573037065200881067e+146, "29750053573037065", 147},
    {2.5222426596007685690447866e-55, "25222426596007686", -54},
    {7.1436285878658417405727939e-94, "7143628587865842", -93},
    {1.7186910084171140811034415e+79, "1718691008417114", 80},
    {1.4086354841246821414600424e-307, "14086354841246821", -306},
    {4.3974494647591318753065842e-113, "4397449464759132", -112},
    {7.0356348296234220196550914e+135, "7035634829623422", 136},
    {3.4524342942878488259379449e-181, "3452434294287849", -180},
    {1.2875581235989579607019271e-258, "1287558123598958", -257},
    {1.3808161986894217552592896e+25, "13808161986894218", 26},
    {2.0065943485147973017076236e+30, "20065943485147973", 31},
    {2.4825555639633685184883033e-59, "24825555639633685", -58},
    {1.9897649776974680163880072e+189, "1989764977697468", 190},
    {2.7279179234722659837095885e+76, "2727917923472266", 77},
    {3.3923896264508526134184746e-13, "33923896264508526", -12},
    {2.2010647836620163743752765e+285, "22010647836620164", 286},
    {3.3879773183063512484018038e+42, "3387977318306351", 43},
    {2.7214103533527500117623843e-41, "272141035335275", -40},
    {1.1048134857521495311083989e+93, "11048134857521495", 94},
    {1.4771786287198834025949272e+134, "14771786287198834", 135},
    {1.7556814575234142041425215e+263, "17556814575234142", 264},
    {1.5608494605150308752271094e-103, "15608494605150309", -102},
    {5.0034884046144098626720632e+305, "500348840461441", 306},
    {2.9481197245916468551352320e+26, "2948119724591647", 27},
    {3.1286845347922742834000513e-53, "31286845347922743", -52},
    {2.7329301014605288305666843e-83, "2732930101460529", -82},
    {4.2811880283797362432734645e+180, "4281188028379736", 181},
    {2.6807038560196646734243935e+127, "26807038560196647", 128},
    {1.3642072207081474550865755e-238, "13642072207081475", -237},
    {5.1236173182082259806609497e-137, "5123617318208226", -136},
    {2.0743654539899040335881089e-129, "2074365453989904", -128},
    {4.0115924376071069844237516e+65, "4011592437607107", 66},
    {1.9644705059867296921351871e-188, "19644705059867297", -187},
    {2.0942348989218174542354036e-168, "20942348989218175", -167},
    {2.7221402419376932249028053e-254, "27221402419376932", -253},
    {2.1227121891912381010529366e+138, "2122712189191238", 139},
    {1.3837940376173655366680014e+65, "13837940376173655", 66},
    {2.0147127312825119431829487e-57, "2014712731282512", -56},
    {1.1255733111190901647945399e+133, "11255733111190902", 134},
    {6.7476048317306985867983868e-254, "67476048317306986", -253},
    {3.5757356546869148948177675e-65, "3575735654686915", -64},
    {5.3476709588039491298613803e+103, "5347670958803949", 104},
    {3.1596961735802702749722765e+241, "315969617358027", 242},
    {2.6164848772947258622766134e+167, "2616484877294726", 168},
    {1.2011948183863013203243921e+105, "12011948183863013", 106},
    {1.6771175509144391596610546e+184, "16771175509144392", 185},
    {2.8738932548427247337766382e-307, "28738932548427247", -306},
    {5.3289032991237255048211997e-245, "53289032991237255", -244},
    {3.4375817854061215152484470e-102, "34375817854061215", -101},
    {5.4214868809504171591961146e+57, "5421486880950417", 58},
    {2.7281876863165128906250000e+13, "2728187686316513", 14},
    {8.0965761368958679680770668e+303, "8096576136895868", 304},
    {2.3990419087008743924860779e-197, "23990419087008744", -196},
    {7.6987252286507301362231339e+251, "769872522865073", 252},
    {3.6661051597895799053959734e+291, "366610515978958", 292},
    {5.2670407563704927951714137e+42, "5267040756370493", 43},
    {1.6661198438998280352028232e-113, "1666119843899828", -112},
    {5.6863394138990843558179623e+102, "5686339413899084", 103},
    {1.9186046494112488327848268e+224, "1918604649411249", 225},
    {2.4178663566179458454923745e-204, "2417866356617946", -203},
    {1.1303439789125948816103287e-184, "11303439789125949", -183},
    {1.5740755060072737557166065e+183, "15740755060072738", 184},
    {1.9869146963617893760275833e-60, "19869146963617894", -59},
    {3.6451692179176789333931098e-158, "3645169217917679", -157},
    {2.1892940164898723351207493e+291, "21892940164898723", 292},
    {2.2198213877514254583614963e-64, "22198213877514255", -63},
    {3.5923149055039747681668317e+142, "3592314905503975", 143},
    {1.0573720297151749940669783e+73, "1057372029715175", 74},
    {3.8672544238899761034168088e-250, "3867254423889976", -249},
    {1.1400051084220270402241326e+154, "1140005108422027", 155},
    {7.4849086924474008448757065e-32, "7484908692447401", -31},
    {5.6541057387778690196219376e+261, "5654105738777869", 262},
    {6.2281026819658877217468356e-57, "6228102681965888", -56},
    {5.3163798653829711776317447e-290, "5316379865382971", -289},
    {2.0497398548964914067397552e+244, "20497398548964914", 245},
    {1.6480189999274608466609946e-155, "16480189999274608", -154},
    {6.0735558518917897302959585e-116, "607355585189179", -115},
    {6.1472378655360530682132890e-73, "6147237865536053", -72},
    {1.1792393298661614754251977e+186, "11792393298661615", 187},
    {2.0981718768435202598854285e+261, "20981718768435203", 262},
    {3.3058188954143413453999732e-265, "33058188954143413", -264},
    {6.8174628553579902699509832e-154, "681746285535799", -153},
    {4.6019731827548075127492591e+196, "46019731827548075", 197},
    {2.2495325646558485470602371e+67, "22495325646558485", 68},
    {2.5505620001445034168034824e-193, "25505620001445034", -192},
    {4.2742651215850609082899625e-293, "4274265121585061", -292},
    {2.7045162024290951517455911e+281, "2704516202429095", 282},
    {2.0912163577310935756235654e-212, "20912163577310936", -211},
    {9.9141711953564291625373329e-17, "9914171195356429", -16},
    {3.6096320124781622886657715e+09, "36096320124781623", 10},
    {5.5773068171843111051089115e+212, "5577306817184311", 213},
    {1.8131632712258855857931032e+33, "18131632712258856", 34},
    {2.5613692304085285042869045e+241, "25613692304085285", 242},
    {5.2857715541376620531082153e+06, "5285771554137662", 7},
    {3.2682088290881328967767445e-229, "3268208829088133", -228},
    {6.3909599041466698329082701e-39, "639095990414667", -38},
    {2.4027937059394691111957621e+226, "2402793705939469", 227},
    {8.5916491882086466875298658e+298, "8591649188208647", 299},
    {8.8884819229654865533469058e+194, "8888481922965487", 195},
    {3.0026541032662238470006101e-286, "3002654103266224", -285},
    {8.7888163527927742387847032e-295, "8788816352792774", -294},
    {8.2009546871925967638374788e+68, "8200954687192597", 69},
    {2.0444673693579852208720652e-281, "20444673693579852", -280},
    {3.9393539600809555552069123e-115, "39393539600809556", -114},
    {3.0803785553975217216023654e-214, "30803785553975217", -213},
    {1.2907796482762249883074841e-168, "1290779648276225", -167},
    {1.8902325974245726735021906e+234, "18902325974245727", 235},
    {4.1535824500087913078729562e-266, "4153582450008791", -265},
    {1.7598860931129253253826623e-103, "17598860931129253", -102},
    {2.0995336182393240978532175e+259, "2099533618239324", 260},
    {5.9690343940075563100577938e-01, "5969034394007556", 0},
    {1.0205637861901978457631122e-31, "10205637861901978", -30},
    {2.2738096161702265286257301e-55, "22738096161702265", -54},
    {1.8867771141804993655643495e+133, "18867771141804994", 134},
    {3.0372531387043330656709384e+101, "3037253138704333", 102},
    {1.6932861219322357285603570e+226, "16932861219322357", 227},
    {1.4849983127095263798341132e+87, "14849983127095264", 88},
    {9.1201334505827886308532149e-04, "9120133450582789", -3},
    {1.1372724746171669149511536e+60, "1137272474617167", 61},
    {5.7091472713197507599684066e+169, "5709147271319751", 170},
    {4.7075121063754156443475062e-299, "47075121063754156", -298},
    {2.2511738156532974400930504e-253, "22511738156532974", -252},
    {4.1800880028840342640453641e+125, "4180088002884034", 126},
    {7.1436445321426872423486998e-02, "7143644532142687", -1},
    {5.2040093546068113973510621e+175, "52040093546068114", 176},
    {1.5135095738532524103625722e+151, "15135095738532524", 152},
    {1.1641915941515764500352603e+147, "11641915941515765", 148},
    {3.4896209960276145537870189e+236, "34896209960276146", 237},
    {1.4468701714921936253135559e-09, "14468701714921936", -8},
    {2.0072711679287834800485652e-197, "20072711679287835", -196},
    {2.7481993362792816929664101e-83, "27481993362792817", -82},
    {2.5799686161132505925653320e+303, "25799686161132506", 304},
    {1.8340618031658417439303503e+292, "18340618031658417", 293},
    {9.1652484461142518698610844e-182, "9165248446114252", -181},
    {1.9953411464078682019743160e-161, "19953411464078682", -160},
    {2.3232675743970475957845398e+160, "23232675743970476", 161},
    {3.9188381941620187006746373e+77, "39188381941620187", 78},
    {1.1387157282632062911987305e+10, "11387157282632063", 11},
    {9.4993276251154197563507060e-121, "949932762511542", -120},
    {1.9010926521692247393337353e+292, "19010926521692247", 293},
    {3.5474028323843935300579224e-100, "35474028323843935", -99},
    {5.7176685817857561533165531e-277, "5717668581785756", -276},
    {3.3741938634502666107943101e+108, "33741938634502666", 109},
    {1.7456436491387906518809141e+44, "17456436491387907", 45},
    {2.4824878056564076607293054e+58, "24824878056564077", 59},
    {7.8466940460756903770548570e-197, "784669404607569", -196},
    {1.8700357296194009956352000e+22, "1870035729619401", 23},
    {5.5714584387371756612905093e+238, "5571458438737176", 239},
    {8.5151701038721837319752979e+186, "8515170103872184", 187},
    {3.4834493416561995541750321e+272, "34834493416561996", 273},
    {6.0965560910799208706576948e-17, "6096556091079921", -16},
    {6.3519261319691547957002240e+24, "6351926131969155", 25},
    {6.6909096364736425093356120e+146, "66909096364736425", 147},
    {9.8362769261505859432319046e+137, "9836276926150586", 138},
    {9.0217327054609436430728496e-182, "9021732705460944", -181},
    {5.0558696146554739686052294e-295, "5055869614655474", -294},
    {4.6861144719161040860696221e-82, "4686114471916104", -81},
    {3.3605851447041528699325137e-303, "3360585144704153", -302},
    {1.9723341459929370690577175e-259, "1972334145992937", -258},
    {4.2957641173641149100335990e+186, "4295764117364115", 187},
    {1.2355894394329637544265336e+179, "12355894394329638", 180},
    {1.0308766991103956829375190e-166, "10308766991103957", -165},
    {1.6539231935744669231153322e+57, "1653923193574467", 58},
    {1.7089862299671835205199749e-223, "17089862299671835", -222},
    {1.4264192482594090542648149e+208, "1426419248259409", 209},
    {5.1232653624384342570101843e-35, "5123265362438434", -34},
    {9.1516496191408620380140427e+175, "9151649619140862", 176},
    {1.9780193799915671557881707e+196, "1978019379991567", 197},
    {1.1853836414995119569987059e-09, "1185383641499512", -8},
    {2.2596892935182304173642037e-74, "22596892935182304", -73},
    {2.6167029744626260553533870e-292, "2616702974462626", -291},
    {1.7187874614222420737087211e-141, "1718787461422242", -140},
    {7.4513714551024437162698670e+194, "7451371455102444", 195},
    {3.2406065906361539165177889e-93, "3240606590636154", -92},
    {6.2770315375605163532388015e-66, "6277031537560516", -65},
    {6.4060091533057107961275902e-146, "6406009153305711", -145},
    {2.4745211214995314505766996e-292, "24745211214995315", -291},
    {3.3248302667111527025646292e+30, "33248302667111527", 31},
    {7.4467817937100875150514561e+168, "74467817937100875", 169},
    {1.1708576008855669731687276e-73, "1170857600885567", -72},
    {4.5182409908336197635917451e+106, "451824099083362", 107},
    {2.8855124793485796409767867e-66, "28855124793485796", -65},
    {2.5178790177353879132975822e+51, "2517879017735388", 52},
    {2.0877894555635177128132560e+189, "20877894555635177", 190},
    {1.0131922384752667424905803e+171, "10131922384752667", 172},
    {1.0888625663118925209804603e+250, "10888625663118925", 251},
    {2.9116617358370312689507645e+269, "2911661735837031", 270},
    {2.2269882380928733653243094e-139, "22269882380928734", -138},
    {5.4929172017084430547150113e+176, "5492917201708443", 177},
    {1.1330490931993441465431926e-194, "11330490931993441", -193},
    {2.3486010344141669533337174e+76, "2348601034414167", 77},
    {6.1130385487857184000000000e+16, "6113038548785718", 17},
    {4.0521949798916609416335211e-150, "4052194979891661", -149},
    {1.0824899623146905964364780e-274, "10824899623146906", -273},
    {1.1970666601565364202637503e+205, "11970666601565364", 206},
    {1.7720054176358666810085413e-43, "17720054176358667", -42},
    {4.8334984670945800138473260e-196, "483349846709458", -195},
    {2.9202184705044473099906248e-58, "29202184705044473", -57},
    {9.3159760130978225856333478e+173, "9315976013097823", 174},
    {2.9965820892098839837809197e-171, "2996582089209884", -170},
    {5.7767815100826441760571994e+187, "5776781510082644", 188},
    {2.9391254199718084958569076e-247, "29391254199718085", -246},
    {2.6508734636879739696193004e+264, "2650873463687974", 265},
    {3.3081684840588372871844908e+289, "33081684840588373", 290},
    {7.0312076315037519081131699e+214, "7031207631503752", 215},
    {8.1290970321979435643402060e+34, "8129097032197944", 35},
    {4.3359419004571735518994720e+120, "43359419004571736", 121},
    {3.4556693590395541525073633e+57, "3455669359039554", 58},
    {3.1141889474879827481046206e-133, "31141889474879827", -132},
    {3.3010238337108989364513098e-33, "3301023833710899", -32},
    {3.7892594930709304529589954e-252, "37892594930709305", -251},
    {2.2110089000919883342659744e+159, "22110089000919883", 160},
    {2.5368207925184071746648495e+151, "25368207925184072", 152},
    {4.5498180978136769032645032e-221, "4549818097813677", -220},
    {5.5452416115258278834239846e-260, "5545241611525828", -259},
    {1.4562473921284788333387120e-58, "14562473921284788", -57},
    {2.5563619187771035157714624e-72, "25563619187771035", -71},
    {3.9495081297416403204609686e+68, "39495081297416403", 69},
    {5.7051301620212512442963191e-19, "5705130162021251", -18},
    {1.0569337929722703413585742e+32, "10569337929722703", 33},
    {2.3199407379716585523894952e+296, "23199407379716586", 297},
    {2.2764552722549805439259407e-177, "22764552722549805", -176},
    {6.7176201645241527881709057e+258, "6717620164524153", 259},
    {9.7644793506755902255213094e+147, "976447935067559", 148},
    {4.6701426397633949043569806e+53, "4670142639763395", 54},
    {6.8183305849875323707991641e-38, "6818330584987532", -37},
    {9.9866882536578022958072000e+294, "9986688253657802", 295},
    {9.8118994034748566179793272e-02, "9811899403474857", -1},
    {6.9981734071505505729185304e-225, "699817340715055", -224},
    {3.3395769350969929166617919e-61, "3339576935096993", -60},
    {5.8347567683276308002978798e-210, "5834756768327631", -209},
    {1.0021061566680697107979175e-55, "10021061566680697", -54},
    {5.0077676436275131255315943e+230, "5007767643627513", 231},
    {1.8861710043777578045320079e-60, "18861710043777578", -59},
    {1.5467759893756816548720182e+264, "15467759893756817", 265},
    {6.3788455736403722344596602e+267, "6378845573640372", 268},
    {4.2980091470728228287671782e-103, "4298009147072823", -102},
    {2.6865298625225955585388795e-76, "26865298625225956", -75},
    {5.9426732506617235448102108e+287, "59426732506617235", 288},
    {3.5198420163679050367339405e-145, "3519842016367905", -144},
    {2.9525511663688744182250248e+65, "29525511663688744", 66},
    {8.6861363789271775903471941e-94, "8686136378927178", -93},
    {3.2054603619295294034347362e+59, "32054603619295294", 60},
    {7.2217728808994052975667033e-77, "7221772880899405", -76},
    {4.6173366333150373066925458e+271, "4617336633315037", 272},
    {1.8967180780127829678139429e+265, "1896718078012783", 266},
    {2.8513228553715588823887358e-96, "2851322855371559", -95},
    {1.0219767068434721785261962e-268, "10219767068434722", -267},
    {1.8984369716043205664806471e-16, "18984369716043206", -15},
    {1.2653118175378037769300707e+170, "12653118175378038", 171},
    {1.8321259992245574514138882e+211, "18321259992245575", 212},
    {2.5158282764157380534187425e-30, "2515828276415738", -29},
    {2.5569194153364598471370358e-301, "255691941533646", -300},
    {1.1469220360480353183009362e-179, "11469220360480353", -178},
    {3.6888458108200878197096194e-280, "3688845810820088", -279},
    {7.0067811939605278332798755e+139, "7006781193960528", 140},
    {8.0197603052058892163343483e-30, "8019760305205889", -29},
    {1.4605611071465004742727247e-153, "14605611071465005", -152},
    {2.7008273765632454018165934e-248, "27008273765632454", -247},
    {1.9815327403636706802746776e-195, "19815327403636707", -194},
    {1.5419758375255137534208515e+152, "15419758375255138", 153},
    {5.2452870785550060699570320e-111, "5245287078555006", -110},
    {7.3347158032722124484286090e-303, "7334715803272212", -302},
    {2.0507845792850676957638498e-185, "20507845792850677", -184},
    {3.8535298226333487998298968e-271, "3853529822633349", -270},
    {3.0547520137446686836703662e-250, "30547520137446687", -249},
    {5.2431780043205920145765975e-17, "5243178004320592", -16},
    {1.8908023796288588485737953e+170, "18908023796288588", 171},
    {4.1295510399768061717255748e-210, "4129551039976806", -209},
    {1.8833567702098789159208536e+06, "1883356770209879", 7},
    {5.8380439776091971814195573e-26, "5838043977609197", -25},
    {4.8085366130731823097922834e+104, "4808536613073182", 105},
    {1.1802072995116952216831287e-64, "11802072995116952", -63},
    {7.9988025469102520110227172e+105, "7998802546910252", 106},
    {6.1612912445810842487097610e-226, "6161291244581084", -225},
    {4.1965161940367485778472149e+278, "41965161940367486", 279},
    {1.1576125150255336652800000e+21, "11576125150255337", 22},
    {9.9262986704658985049597889e+281, "9926298670465899", 282},
    {1.6011958219556102394143924e-156, "16011958219556102", -155},
    {1.1721617090812578550132665e-62, "11721617090812579", -61},
    {3.6906411194035375184476326e-242, "36906411194035375", -241},
    {2.0460132789146983894284194e-231, "20460132789146984", -230},
    {4.1351985452792606814651174e+165, "4135198545279261", 166},
    {3.2370754073386987502341328e+221, "32370754073386988", 222},
    {1.0426594797596559621068626e+186, "1042659479759656", 187},
    {4.8156771644369269442976006e+190, "4815677164436927", 191},
    {1.3206407929344789672099840e+24, "1320640792934479", 25},
    {5.4532898765625042558298567e-260, "5453289876562504", -259},
    {5.9408791568208287929306576e+236, "5940879156820829", 237},
    {3.9404685030386387144613246e+293, "3940468503038639", 294},
    {1.5026372890301841441692345e-89, "15026372890301841", -88},
    {3.8478190407428177240588708e-123, "3847819040742818", -122},
    {1.4718026076466209363661080e+134, "1471802607646621", 135},
    {6.7041201513122017951855292e-208, "6704120151312202", -207},
    {4.5839557135322494538726856e-243, "45839557135322495", -242},
    {1.7207897946602303885831800e-305, "17207897946602304", -304},
    {1.9604139032161201307463799e+167, "196041390321612", 168},
    {1.9246089407989488977954609e-75, "1924608940798949", -74},
    {2.9632855506624488579655433e-115, "2963285550662449", -114},
    {2.5096867107286982656000000e+19, "25096867107286983", 20},
    {2.1822271790447417761655380e-234, "21822271790447418", -233},
    {4.0489627207467218354377932e+172, "4048962720746722", 173},
    {1.4010321940677539496871806e-187, "1401032194067754", -186},
    {4.2327662096906741554997077e+90, "4232766209690674", 91},
    {5.6622678560823200410281598e-180, "566226785608232", -179},
    {3.3792875529452238927665584e+104, "3379287552945224", 105},
    {1.0007457053565162676094468e+39, "10007457053565163", 40},
    {6.9420955324836812800000000e+17, "6942095532483681", 18},
    {1.0375568272143978301472793e+244, "10375568272143978", 245},
    {1.9237568152496744098647327e-147, "19237568152496744", -146},
    {8.6492531444344250051264167e-119, "8649253144434425", -118},
    {8.2458537609570476929922339e-222, "8245853760957048", -221},
    {4.3390924335054150997124638e-255, "4339092433505415", -254},
    {4.6286090765086721270375477e+148, "4628609076508672", 149},
    {1.0744070084892460318720000e+21, "1074407008489246", 22},
    {5.3291985888837447851064732e+203, "5329198588883745", 204},
    {6.8325628529860918529062026e-137, "6832562852986092", -136},
    {5.2891582618178166166651076e+221, "5289158261817817", 222},
    {1.2536991163602116433453917e-185, "12536991163602116", -184},
    {2.2271606771079911644184854e+175, "2227160677107991", 176},
    {5.4331578160589665878436419e-245, "54331578160589666", -244},
    {1.3358668451953350391121169e-41, "1335866845195335", -40},
    {3.1371808161527677742829076e-203, "3137180816152768", -202},
    {1.7858498845158154453950238e-121, "17858498845158154", -120},
    {4.3754479840556452517798280e-281, "4375447984055645", -280},
    {5.4213354383801197350058308e+179, "542133543838012", 180},
    {3.2152601744206109978276853e-38, "3215260174420611", -37},
    {9.4169838162293414801793547e-185, "9416983816229341", -184},
    {1.4013115914615414297155104e+80, "14013115914615414", 81},
    {7.1263963758163149366328871e+51, "7126396375816315", 52},
    {2.3469041158269360457438306e-102, "2346904115826936", -101},
    {1.6528232264373550786235697e+257, "1652823226437355", 258},
    {9.1099608462152740577016160e-13, "9109960846215274", -12},
    {1.0542666852547930390629116e-54, "1054266685254793", -53},
    {8.6225594436390638027963092e-145, "8622559443639064", -144},
    {4.5893888083290946353714561e-184, "45893888083290946", -183},
    {1.3697735760104449621978014e-102, "1369773576010445", -101},
    {1.5283564998816136585161228e+235, "15283564998816137", 236},
    {7.6836307703944078817548240e-12, "7683630770394408", -11},
    {3.8208605023111774978830393e-150, "38208605023111775", -149},
    {1.9626449854372133909077579e-236, "19626449854372134", -235},
    {2.8282670810926512387816156e-154, "28282670810926512", -153},
    {7.2031673591321332126603973e-240, "7203167359132133", -239},
    {9.9088584479669436931830905e-143, "9908858447966944", -142},
    {9.8362864831035309092570807e+38, "9836286483103531", 39},
    {1.0974118067264197987446118e-296, "10974118067264198", -295},
    {1.6123755896435815712277230e+163, "16123755896435816", 164},
    {5.7045832184818133700252306e+69, "5704583218481813", 70},
    {9.8229526773639028088941725e-237, "9822952677363903", -236},
    {9.5596213642514705928799823e-166, "955962136425147", -165},
    {3.8971978425279419247048917e+74, "3897197842527942", 75},
    {4.7739346262836109324855410e-222, "4773934626283611", -221},
    {2.1450962857136447885454410e+136, "21450962857136448", 137},
    {3.3334079936045735891175382e-119, "33334079936045736", -118},
    {6.5136872940664660945905077e+229, "6513687294066466", 230},
    {7.5804828870773324946911374e+300, "7580482887077332", 301},
    {1.1248075703456099715293976e-139, "112480757034561", -138},
    {1.0629128981424451941872353e+193, "10629128981424452", 194},
    {1.8358956508002222401965747e+139, "18358956508002222", 140},
    {5.7078631784847183940436747e+128, "57078631784847184", 129},
    {2.8041849493439041374819280e-307, "2804184949343904", -306},
    {5.3461448298071530217162401e-49, "5346144829807153", -48},
    {4.6722580794292647794236630e-54, "4672258079429265", -53},
    {8.0481510468279647128459221e+97, "8048151046827965", 98},
    {3.2223729770599608870070334e+283, "3222372977059961", 284},
    {2.3782167131344176004876656e+210, "23782167131344176", 211},
    {8.3779189508499139043649147e+294, "8377918950849914", 295},
    {4.0451915659259938884148799e+189, "4045191565925994", 190},
    {1.1301287093016426930028317e+229, "11301287093016427", 230},
    {8.0262782921970751220836011e-270, "8026278292197075", -269},
    {8.2044327760951178192007910e-119, "8204432776095118", -118},
    {7.6328178703280874506376108e-02, "7632817870328087", -1},
    {6.8854497647926055768493489e+43, "6885449764792606", 44},
    {8.7036590394386919029536367e+176, "8703659039438692", 177},
    {2.5941620605753531561637841e-194, "25941620605753532", -193},
    {1.0451819640314440504780258e-129, "1045181964031444", -128},
    {1.3604716314396409208739885e+224, "1360471631439641", 225},
    {7.9185786294436732890737178e+177, "7918578629443673", 178},
    {1.4681736907393420876578816e+25, "1468173690739342", 26},
    {7.0247113120859784760356477e-241, "7024711312085978", -240},
    {3.0293868644045645315890133e+266, "30293868644045645", 267},
    {2.9221863306595993808681423e-252, "29221863306595994", -251},
    {9.6693556994667780533917356e+233, "9669355699466778", 234},
    {1.5841062607638813737828577e+217, "15841062607638814", 218},
    {8.0293533499507159691617933e+272, "8029353349950716", 273},
    {5.3136935045797308734437791e+179, "5313693504579731", 180},
    {1.9631515389232944758105148e-144, "19631515389232945", -143},
    {2.6046582378339704326957958e+101, "26046582378339704", 102},
    {2.4611843811625579954282356e-108, "2461184381162558", -107},
    {2.7644197042529818141173595e-67, "27644197042529818", -66},
    {1.9038473525488376698406273e-259, "19038473525488377", -258},
    {2.9916496295015965502377134e+210, "29916496295015966", 211},
    {1.5277123772646204290063730e-140, "15277123772646204", -139},
    {5.5417299971291780658176762e-155, "5541729997129178", -154},
    {8.5817020870327169692493807e-77, "8581702087032717", -76},
    {1.6868507389905160273846950e+153, "1686850738990516", 154},
    {2.5713604826204290957729909e+54, "2571360482620429", 55},
    {2.1370576989374894828024545e+113, "21370576989374895", 114},
    {8.9230531066812457802323435e-208, "8923053106681246", -207},
    {1.5386942824881083625937414e-136, "15386942824881084", -135},
    {3.3840067490366078355965404e+61, "3384006749036608", 62},
    {1.7824904494778712465876088e-50, "17824904494778712", -49},
    {3.7166636322688623382791560e-72, "37166636322688623", -71},
    {7.8871327912588090228007220e-140, "7887132791258809", -139},
    {8.5812246232859854334355468e-156, "8581224623285985", -155},
    {1.6986743830811041438826081e+243, "16986743830811041", 244},
    {2.4176242586472405572694372e-44, "24176242586472406", -43},
    {7.2325780565609088735673023e-18, "7232578056560909", -17},
    {4.1923309167578729240412473e-187, "4192330916757873", -186},
    {1.1076005418612767208082260e+155, "11076005418612767", 156},
    {6.2432901346236679793341057e-291, "6243290134623668", -290},
    {9.7611970042603424876904002e+124, "9761197004260342", 125},
    {4.5990453871990102850791052e+285, "45990453871990103", 286},
    {2.6985680890256322125372600e+104, "26985680890256322", 105},
    {1.2531483765294019800393967e-11, "1253148376529402", -10},
    {1.0426985688750015924770079e-129, "10426985688750016", -128},
    {6.4653902742150674811336866e+217, "6465390274215067", 218},
    {9.2375085659825538182358117e-110, "9237508565982554", -109},
    {7.9295057435760186668548542e+251, "7929505743576019", 252},
    {2.6709615762043859720693424e-264, "2670961576204386", -263},
    {9.8233981154814822822635811e+198, "9823398115481482", 199},
    {1.2393024557017377705005386e+182, "12393024557017378", 183},
    {8.1538499029025559570861261e+26, "8153849902902556", 27},
    {4.3719364809124419597084625e+139, "4371936480912442", 140},
    {7.1996622580839633761638587e+221, "7199662258083963", 222},
    {5.4936022645308364386525357e-217, "54936022645308364", -216},
    {6.7622832639414469098058728e-190, "6762283263941447", -189},
    {2.3078167343011420153393044e+223, "2307816734301142", 224},
    {7.8174471037448672468217977e+296, "7817447103744867", 297},
    {6.2054934572952793340991351e+95, "6205493457295279", 96},
    {1.9643204323746612960248804e+98, "19643204323746613", 99},
    {2.5816588130100219645997355e-11, "2581658813010022", -10},
    {1.0492865364300151354190220e-102, "10492865364300151", -101},
    {7.2428811587722008840786706e-60, "7242881158772201", -59},
    {2.0898648258289543054860741e+128, "20898648258289543", 129},
    {8.9777056648065632699679626e+107, "8977705664806563", 108},
    {9.3851556981158490773907939e+137, "9385155698115849", 138},
    {2.8905003785708204855985727e+176, "28905003785708205", 177},
    {4.3778359418297442030620867e+210, "4377835941829744", 211},
    {2.3302592665317623560201113e+227, "23302592665317624", 228},
    {4.6063278373000369526684716e-267, "4606327837300037", -266},
    {2.7343388838435768752095035e+156, "2734338883843577", 157},
    {2.1815042339858825419862232e-272, "21815042339858825", -271},
    {5.6707083736838410068910962e+195, "5670708373683841", 196},
    {3.6221988959020504924581791e-276, "36221988959020505", -275},
    {5.5342118279682958808081884e-161, "5534211827968296", -160},
    {3.6414838467770064756732500e+92, "36414838467770065", 93},
    {1.7672619332876751867369135e+96, "17672619332876752", 97},
    {7.5026854288996850865814525e+269, "7502685428899685", 270},
    {5.7777072108788380632184955e-242, "5777707210878838", -241},
    {3.9765491052977118969341298e+132, "3976549105297712", 133},
    {2.6593302565509531396424037e+87, "2659330256550953", 88},
    {1.4998936493466558593750000e+13, "14998936493466559", 14},
    {3.5515807737730479341077580e-208, "3551580773773048", -207},
    {7.0121054810602461860986880e+24, "7012105481060246", 25},
    {4.6375920633736717439706267e+175, "4637592063373672", 176},
    {1.6042794650961588987462094e-242, "1604279465096159", -241},
    {1.6868361234445976412423176e+255, "16868361234445976", 256},
    {1.3327196025214308223429389e-264, "13327196025214308", -263},
    {5.8477805484244631750582419e+196, "5847780548424463", 197},
    {5.5594085052985159515972040e-44, "5559408505298516", -43},
    {1.5106740127948433202179640e-177, "15106740127948433", -176},
    {4.7904236358140316230177428e-162, "4790423635814032", -161},
    {1.0693270137169565625000000e+14, "10693270137169566", 15},
    {5.9064846061072385099726416e-300, "59064846061072385", -299},
    {2.6689789833023025272924455e-191, "26689789833023025", -190},
    {2.4270168574935937840152452e+49, "2427016857493594", 50},
    {4.1026962477420426016207232e+263, "41026962477420426", 264},
    {4.2082888881055798738203843e-109, "420828888810558", -108},
    {1.8560438087379260049270599e+153, "1856043808737926", 154},
    {5.7184261044598433962367217e+132, "5718426104459843", 133},
    {2.5258851060860268423115818e-151, "2525885106086027", -150},
    {3.4766170330361416644323175e-79, "34766170330361417", -78},
    {6.1059016067956920769332355e-89, "6105901606795692", -88},
    {2.1763750805863206056568453e+300, "21763750805863206", 301},
    {5.0030196259562205478912000e+22, "50030196259562205", 23},
    {1.1670559018423963395048619e+121, "11670559018423963", 122},
    {1.0757592648931728500889509e-187, "10757592648931729", -186},
    {5.6845824999634022308666094e+202, "5684582499963402", 203},
    {2.0473735651209506504484947e-259, "20473735651209507", -258},
    {6.6810695130603786107745483e-41, "6681069513060379", -40},
    {2.7571530703721327011338458e+199, "27571530703721327", 200},
    {2.9191348441301859961881355e-172, "2919134844130186", -171},
    {5.1598492876979001403131012e+71, "51598492876979", 72},
    {5.1507427062552362041427386e+54, "5150742706255236", 55},
    {3.3095749520324676539664825e-166, "33095749520324677", -165},
    {7.6990439092057462236688105e+250, "7699043909205746", 251},
    {6.0745272076261427742395011e+265, "6074527207626143", 266},
    {3.2510880631181247982659498e+243, "32510880631181248", 244},
    {2.6084973390798776164407452e-219, "26084973390798776", -218},
    {1.4576409501444372848965401e+253, "14576409501444373", 254},
    {7.2194218941568459145984378e+130, "7219421894156846", 131},
    {1.2645415504791979314520890e-143, "1264541550479198", -142},
    {3.9539706907815447840191584e+90, "3953970690781545", 91},
    {1.7216712000565340936807877e-253, "1721671200056534", -252},
    {5.9734860163767613440000000e+18, "5973486016376761", 19},
    {6.9797274320287622367782748e+33, "6979727432028762", 34},
    {4.4211720409610693440946101e-256, "44211720409610693", -255},
    {5.8037341296648818489028086e-123, "5803734129664882", -122},
    {5.4066876184510315785780136e+82, "54066876184510316", 83},
    {1.4720920555305589078590218e-87, "1472092055530559", -86},
    {5.7592528821869278782694954e-63, "5759252882186928", -62},
    {2.3072254772649203926808175e+151, "23072254772649204", 152},
    {3.4495385799905326498744935e-77, "34495385799905326", -76},
    {8.9334901069731191824985217e+00, "893349010697312", 1},
    {3.0597102214405583488921674e+92, "30597102214405583", 93},
    {7.5978747436221014658382485e+60, "7597874743622101", 61},
    {1.2795501105192118439705943e-261, "12795501105192118", -260},
    {5.3190015262381030989615962e+282, "5319001526238103", 283},
    {9.0918293399998382150471279e-151, "9091829339999838", -150},
    {1.7264340737818786000000000e+16, "17264340737818786", 17},
    {1.0314141019455524042711288e-05, "10314141019455524", -4},
    {4.2055270092720296428734581e-265, "42055270092720296", -264},
    {3.5217403859490337114268272e+188, "3521740385949034", 189},
    {2.3802337496408179868850132e+235, "2380233749640818", 236},
    {1.8214182351875138279249382e-199, "18214182351875138", -198},
    {2.4199203066077928957830729e-110, "2419920306607793", -109},
    {1.0379951087268111100804132e+244, "10379951087268111", 245},
    {1.1489167416497917440000000e+18, "11489167416497917", 19},
    {1.7326397670268967843999909e-188, "17326397670268968", -187},
    {5.8973383924355892586162322e-266, "5897338392435589", -265},
    {9.2779232024572754732956652e+160, "9277923202457275", 161},
    {1.6946780703350964832311261e+90, "16946780703350965", 91},
    {7.0028692650362870321276297e-138, "7002869265036287", -137},
    {1.7772175961409085972784648e+298, "17772175961409086", 299},
    {2.2748525331821691447026934e-237, "22748525331821691", -236},
    {3.0524096436934187469643461e-231, "3052409643693419", -230},
    {1.7075836238672720932394675e-223, "1707583623867272", -222},
    {1.5858273812749126707299677e+173, "15858273812749127", 174},
    {2.6021353797645173689770335e-33, "26021353797645174", -32},
    {1.0175423348320388195124202e-258, "10175423348320388", -257},
    {6.5830683706422896356741511e+78, "658306837064229", 79},
    {2.9521007510909915496288932e-263, "29521007510909915", -262},
    {1.8728540000971021336331050e+264, "18728540000971021", 265},
    {1.5594379738766255963766223e-265, "15594379738766256", -264},
    {2.9626344503126269205826395e-176, "2962634450312627", -175},
    {4.7123654978741445113566470e+122, "47123654978741445", 123},
    {1.5976513494798925674931349e+176, "15976513494798926", 177},
    {4.1793904429212541349520033e+70, "4179390442921254", 71},
    {4.8683685610090740742459350e+42, "4868368561009074", 43},
    {1.3914323593420918920918513e+308, "13914323593420919", 309},
    {2.7713120038066503391679056e-236, "27713120038066503", -235},
    {6.0039361209944780237658992e-149, "6003936120994478", -148},
    {6.3071555245389356167892425e-133, "6307155524538936", -132},
    {1.0320734936086769900674164e-112, "1032073493608677", -111},
    {3.4961896267525478063001163e-137, "3496189626752548", -136},
    {2.4830978643780902827030205e-165, "24830978643780903", -164},
    {5.3148770003078746988457065e+98, "5314877000307875", 99},
    {3.9665180643215329745387882e-52, "3966518064321533", -51},
    {4.1302997037828901852583208e-134, "413029970378289", -133},
    {1.4538828095147216355358149e+274, "14538828095147216", 275},
    {3.2675431440120367404470565e-186, "32675431440120367", -185},
    {9.5822496014802810963555921e-82, "9582249601480281", -81},
    {3.0868506405480110764547460e-243, "3086850640548011", -242},
    {2.3876488751713308172642680e+279, "2387648875171331", 280},
    {2.5825269570386746607988423e-209, "25825269570386747", -208},
    {1.6851921836105803690994916e-42, "16851921836105804", -41},
    {7.0760766223767538785452419e+227, "7076076622376754", 228},
    {1.5965689514572396390049864e+151, "15965689514572396", 152},
    {2.4650958725235153888190959e+97, "24650958725235154", 98},
    {4.5566239023340888318861050e-297, "4556623902334089", -296},
    {5.9918413046956593844775268e-05, "59918413046956594", -4},
    {1.1031854187530889142175848e-24, "1103185418753089", -23},
    {4.2352825122518060808543554e-107, "4235282512251806", -106},
    {2.3448891661409115993732917e+160, "23448891661409116", 161},
    {1.1365879654792738675684590e+235, "11365879654792739", 236},
    {4.8876210771198349482681607e-308, "4887621077119835", -307},
    {7.6798019685093840171190802e-80, "7679801968509384", -79},
    {5.8896206179789787328835016e+89, "5889620617978979", 90},
    {5.8991863694939168522425117e-231, "5899186369493917", -230},
    {9.0201247750686415209052868e-12, "9020124775068642", -11},
    {9.4243187877357630204563972e+295, "9424318787735763", 296},
    {7.2003368357463026073047536e+189, "7200336835746303", 190},
    {1.1170632727531784473971004e-274, "11170632727531784", -273},
    {5.3735411226304952813189316e-127, "5373541122630495", -126},
    {3.5219169927312058208265772e+102, "3521916992731206", 103},
    {6.7168899843950858341281468e+127, "6716889984395086", 128},
    {3.0309462208205359202458634e-187, "3030946220820536", -186},
    {1.0373931412354675038728606e-65, "10373931412354675", -64},
    {3.9458435465879835946426221e+285, "39458435465879836", 286},
    {1.4899549997721200061660803e-167, "148995499977212", -166},
    {3.4529583136115808311333368e-193, "3452958313611581", -192},
    {1.1313946880638896633174594e+78, "11313946880638897", 79},
    {8.9862149234587008281091782e+110, "8986214923458701", 111},
    {1.7299523869574012723192537e-54, "17299523869574013", -53},
    {1.7245846944308662831420487e-235, "17245846944308663", -234},
    {7.9138704257349515820841204e+116, "7913870425734952", 117},
    {1.2715105087267376068296974e+287, "12715105087267376", 288},
    {4.5753495160352513483372355e-123, "45753495160352513", -122},
    {3.2329523306050968116249993e+152, "3232952330605097", 153},
    {2.6265177995828270320131955e-239, "2626517799582827", -238},
    {1.1513178992183675054333251e-237, "11513178992183675", -236},
    {6.7608104536792123731319874e+124, "6760810453679212", 125},
    {2.1745482296660209702925073e-49, "2174548229666021", -48},
    {1.2270519034602948872661179e-250, "12270519034602949", -249},
    {3.0749159605144014307855425e+146, "30749159605144014", 147},
    {1.4490535577081743844967310e-150, "14490535577081744", -149},
    {4.9286713163349009141146994e+240, "4928671316334901", 241},
    {1.2067400953892218480327490e+135, "12067400953892218", 136},
    {6.1307103188752867000320000e+22, "6130710318875287", 23},
    {3.6683317886113335321119175e-268, "36683317886113335", -267},
    {9.1046711179409162241514525e-74, "9104671117940916", -73},
    {4.9004345856058831163976720e+228, "4900434585605883", 229},
    {6.1248543885420155684265601e-239, "61248543885420156", -238},
    {6.1437370567884149543576030e+143, "6143737056788415", 144},
    {1.7852802090295616515753769e-217, "17852802090295617", -216},
    {1.2364043610711455589990400e+24, "12364043610711456", 25},
    {4.2116138581338930042780887e+126, "4211613858133893", 127},
    {4.3132247750150698394948563e-15, "431322477501507", -14},
    {2.2403258527489977836926366e-55, "22403258527489978", -54},
    {1.4707160233626557924265644e+305, "14707160233626558", 306},
    {1.3272554880727198499845957e-33, "13272554880727198", -32},
    {2.4017319707056034807731152e+33, "24017319707056035", 34},
    {8.5490443842463515625000000e+13, "8549044384246352", 14},
    {3.2841732888645166830759199e-122, "32841732888645167", -121},
    {6.0553207759369165441612851e-261, "60553207759369165", -260},
    {2.4966234353959714303919918e-135, "24966234353959714", -134},
    {6.3775136435710311580493741e-46, "6377513643571031", -45},
    {8.2352162551656804403408678e-19, "823521625516568", -18},
    {6.3353691404632144946057988e-156, "6335369140463214", -155},
    {2.6247580156228524029090391e-162, "26247580156228524", -161},
    {3.6199514556255047018555586e-237, "36199514556255047", -236},
    {2.5793134407573432784019577e-27, "25793134407573433", -26},
    {1.9843576487255036151189771e-153, "19843576487255036", -152},
    {4.5488956349296282540711412e+111, "4548895634929628", 112},
    {9.1635960653964563534543075e+82, "9163596065396456", 83},
    {4.8857425312593887859827782e-189, "4885742531259389", -188},
    {8.3598813015674832937289992e+284, "8359881301567483", 285},
    {1.8810213526805035064385125e+104, "18810213526805035", 105},
    {7.2348174429511901347716328e-16, "723481744295119", -15},
    {1.9394591706193233662961935e-86, "19394591706193234", -85},
    {4.1741588709020050381940265e+136, "4174158870902005", 137},
    {2.0055319014110377572131181e-172, "20055319014110378", -171},
    {2.2243362547244120352594837e-26, "2224336254724412", -25},
    {2.0360939297106500150941390e-255, "203609392971065", -254},
    {3.5574098160094475635363024e-82, "35574098160094476", -81},
    {6.8077336865054852289212566e-100, "6807733686505485", -99},
    {2.9736116942996882585136132e+280, "29736116942996883", 281},
    {1.2156969796251729777162279e-276, "1215696979625173", -275},
    {1.3014796747852566962715969e+155, "13014796747852567", 156},
    {2.8326045826568663330697952e+50, "28326045826568663", 51},
    {3.3209812531585725648344786e-283, "33209812531585726", -282},
    {1.8194247718815661268378159e+206, "1819424771881566", 207},
    {1.3645640014547106451977228e+80, "13645640014547106", 81},
    {2.7673864163325878061340552e+189, "2767386416332588", 190},
    {1.2651256573456803699740860e-16, "12651256573456804", -15},
    {1.1580282267981062932819981e-58, "11580282267981063", -57},
    {3.6349907950526645342571125e+297, "36349907950526645", 298},
    {5.2831778907079194066590770e-274, "5283177890707919", -273},
    {1.2430136559101756901187249e+140, "12430136559101757", 141},
    {3.1382834977905056802126321e-249, "31382834977905057", -248},
    {8.1123725819653615190458320e+292, "8112372581965362", 293},
    {1.7946265597570823070154752e+27, "17946265597570823", 28},
    {4.2450258361813740533363682e+304, "4245025836181374", 305},
    {6.5534075287062330276379706e+142, "6553407528706233", 143},
    {2.3973663580268130000000000e+15, "2397366358026813", 16},
    {5.7627398434521208683808034e+214, "5762739843452121", 215},
    {1.2619433183830903940709403e+161, "12619433183830904", 162},
    {7.1455959810388411624940655e-123, "7145595981038841", -122},
    {5.3549529255015675893234348e+182, "5354952925501568", 183},
    {6.1566971844088445025902360e+286, "61566971844088445", 287},
    {5.2639876143348738307779184e-73, "5263987614334874", -72},
    {3.1610703517288669978849828e+201, "3161070351728867", 202},
    {1.9841312505166199371419090e+142, "198413125051662", 143},
    {6.6619330073225482902911968e-200, "6661933007322548", -199},
    {5.4428093119260043951520347e+65, "5442809311926004", 66},
    {1.5434645248684403532982825e+80, "15434645248684404", 81},
    {5.7714339622189672207926214e-129, "5771433962218967", -128},
    {2.3150022150636492676658495e+38, "23150022150636493", 39},
    {1.5351279933355663471720318e-99, "15351279933355663", -98},
    {5.9581455944493754283566252e+150, "59581455944493754", 151},
    {2.1465973758200831756265918e-44, "21465973758200832", -43},
    {1.0473398398260730417582223e-265, "1047339839826073", -264},
    {3.1480223215279580251033677e-93, "3148022321527958", -92},
    {6.2851635048880900865982434e+214, "628516350488809", 215},
    {5.3891776698755073970262484e-217, "5389177669875507", -216},
    {2.3317873837637293810856264e+118, "23317873837637294", 119},
    {1.8445652466184327176335075e-196, "18445652466184327", -195},
    {3.8852316893799485207544147e-290, "38852316893799485", -289},
    {2.7489071980627971463695250e-126, "2748907198062797", -125},
    {4.3060926430871974246716356e+31, "4306092643087197", 32},
    {6.9710099655627787296386522e+72, "6971009965562779", 73},
    {2.6715515935255577038595039e+209, "26715515935255577", 210},
    {1.3198547037308311737865705e+250, "13198547037308312", 251},
    {3.2856143578991818889834912e+305, "3285614357899182", 306},
    {1.3236965921418290688910744e+291, "1323696592141829", 292},
    {6.3396181582354529717041664e-212, "6339618158235453", -211},
    {5.4477972828462108845583099e+66, "5447797282846211", 67},
    {4.1692490429493367831750191e-182, "4169249042949337", -181},
    {6.2101478978352904830208129e+99, "621014789783529", 100},
    {3.9365794386108922545494287e+161, "39365794386108923", 162},
    {2.4970336864268171507967078e-207, "2497033686426817", -206},
    {6.1271693004874148437500000e+13, "6127169300487415", 14},
    {5.9414032646666864682040314e-83, "59414032646666865", -82},
    {1.4491309089752366585576590e+291, "14491309089752367", 292},
    {4.6229818425893396946335761e+54, "462298184258934", 55},
    {1.9156656853391755014998283e-208, "19156656853391755", -207},
    {1.5500216503754383775508228e+300, "15500216503754384", 301},
    {1.5078658935136574875285434e+40, "15078658935136575", 41},
    {1.2059892613743625073613763e-222, "12059892613743625", -221},
    {1.6999114002062628079088944e-109, "16999114002062628", -108},
    {2.4487444126481221886790569e-48, "24487444126481222", -47},
    {4.0387329653179702778555229e-196, "40387329653179703", -195},
    {1.3323516624237511250542592e+26, "13323516624237511", 27},
    {4.4858681602285250000000000e+15, "4485868160228525", 16},
    {1.8316745673206093888809726e+245, "18316745673206094", 246},
    {7.0987538323600602275208296e+196, "709875383236006", 197},
    {1.2681044054648717476718742e-56, "12681044054648717", -55},
    {3.2686902068309606750829632e-38, "32686902068309607", -37},
    {1.6404606396808615903519445e+87, "16404606396808616", 88},
    {2.9703757731321959209558874e+80, "2970375773132196", 81},
    {1.2083572722924902540858824e-135, "12083572722924903", -134},
    {5.5528317370655967066936091e-272, "5552831737065597", -271},
    {3.5093985819518573318347208e+55, "35093985819518573", 56},
    {2.8047536527597312586849112e+62, "28047536527597313", 63},
    {2.2251691334349594116210938e+10, "22251691334349594", 11},
    {1.1142849989492641902315029e-41, "11142849989492642", -40},
    {1.5535440909109525659408711e-192, "15535440909109526", -191},
    {1.1930479550592345609933937e-182, "11930479550592346", -181},
    {1.6979344220091822414318828e+185, "16979344220091822", 186},
    {1.2700275129188527255817396e+72, "12700275129188527", 73},
    {1.0029183813603940103018672e+91, "1002918381360394", 92},
    {2.9820690957331878590634217e-58, "2982069095733188", -57},
    {3.5968272097135512940947752e-304, "35968272097135513", -303},
    {5.2179981822642182115038970e+80, "5217998182264218", 81},
    {3.7811354957839527165141158e+186, "37811354957839527", 187},
    {2.5574351647057701381895895e+236, "255743516470577", 237},
    {1.2680674487130067085929855e-308, "12680674487130067", -307},
    {7.1130805109332939579185707e-309, "7113080510933294", -308},
    {6.9651618185544344000000000e+16, "69651618185544344", 17},
    {6.7842691696090040096513336e-292, "6784269169609004", -291},
    {1.2989552226982332282550584e-205, "12989552226982332", -204},
    {7.2144242469238519220171131e+52, "7214424246923852", 53},
    {1.7492130788013063872410525e-114, "17492130788013064", -113},
    {1.4670539688045423701563698e-200, "14670539688045424", -199},
    {2.2006567722909413258833669e-154, "22006567722909413", -153},
    {5.8588089873797264345781279e+70, "5858808987379726", 71},
    {1.1483344720436903500239914e-85, "11483344720436904", -84},
    {3.5787435963594623334436354e+136, "35787435963594623", 137},
    {3.4962574359129475786989726e+89, "34962574359129476", 90},
    {4.5928820679242726706283458e-156, "45928820679242727", -155},
    {2.1149206413164683342020929e+176, "21149206413164683", 177},
    {1.3459794689358877851255657e+84, "13459794689358878", 85},
    {3.1695442643458008169410993e-169, "3169544264345801", -168},
    {1.3312355428913746684103348e-273, "13312355428913747", -272},
    {4.8849187269279564964555567e-217, "48849187269279565", -216},
    {9.8617885370290550917633064e-15, "9861788537029055", -14},
    {1.7823487685051355834094901e-144, "17823487685051356", -143},
    {3.7982325416929531684509854e+44, "3798232541692953", 45},
    {7.2657025899176696934839642e+127, "726570258991767", 128},
    {1.2184167065380715575845187e-48, "12184167065380716", -47},
    {4.4188039956041900377812744e-271, "441880399560419", -270},
    {3.5359840966055521227924405e-39, "3535984096605552", -38},
    {2.6662925346384808615234215e-125, "2666292534638481", -124},
    {1.0342637459640459198833021e+75, "1034263745964046", 76},
    {2.6173811897228897186186410e-139, "26173811897228897", -138},
    {3.5668514041596207084409701e+71, "35668514041596207", 72},
    {4.3775101360399681296246918e-117, "4377510136039968", -116},
    {2.1631615506868754202163907e-175, "21631615506868754", -174},
    {2.0631976984424742515087951e+101, "20631976984424743", 102},
    {2.4669879753910743517759204e+189, "24669879753910744", 190},
    {2.5772062754457251395330869e-36, "2577206275445725", -35},
    {8.8938906665174614046075398e+248, "8893890666517461", 249},
    {2.3409259241328514708724767e+61, "23409259241328515", 62},
    {5.5440712047673087225155841e+62, "5544071204767309", 63},
    {5.3117780171076958945530839e-217, "5311778017107696", -216},
    {3.2973993268063365211263058e+54, "32973993268063365", 55},
    {3.5788207631611559032278530e+288, "3578820763161156", 289},
    {8.3016163757104402516685235e-63, "830161637571044", -62},
    {4.3039754723356706127808257e+275, "43039754723356706", 276},
    {6.0603982728541691537281669e-216, "6060398272854169", -215},
    {9.6120014540667150000000000e+14, "9612001454066715", 15},
    {7.3907630653458325687932372e+111, "7390763065345833", 112},
    {2.8395632037985301519827081e+262, "283956320379853", 263},
    {8.1055914704888502517515661e-130, "810559147048885", -129},
    {6.0734791564834315254573162e-229, "60734791564834315", -228},
    {3.9194876763000356593272353e+257, "39194876763000357", 258},
    {1.5770756425871036632538464e-195, "15770756425871037", -194},
    {8.3264556009988792724937303e-289, "832645560099888", -288},
    {2.5802611775897681268958071e-285, "2580261177589768", -284},
    {1.2722878352559876476937732e+66, "12722878352559876", 67},
    {4.8062653201200269007259260e+39, "4806265320120027", 40},
    {1.4870727660702827364304358e-282, "14870727660702827", -281},
    {1.8708047058511867692892043e+149, "18708047058511868", 150},
    {2.7463175755435065936246821e+283, "27463175755435066", 284},
    {8.6107676152238853033479466e-297, "8610767615223885", -296},
    {1.0303182862655795262420323e-138, "10303182862655795", -137},
    {1.3845472089856465447985379e+107, "13845472089856465", 108},
    {3.5527799707819721271653374e-203, "3552779970781972", -202},
    {2.3203990294695002661203201e+253, "23203990294695003", 254},
    {1.5146912429420203585013135e-06, "15146912429420204", -5},
    {1.1556840141820213545202220e-294, "11556840141820214", -293},
    {1.3233853696674460571785895e+40, "1323385369667446", 41},
    {1.4755343692140195258898635e+304, "14755343692140195", 305},
    {3.1384338573218960676746918e+212, "3138433857321896", 213},
    {2.9210340967140866664843748e+251, "29210340967140867", 252},
    {2.6413250187480575804843225e-121, "26413250187480576", -120},
    {6.9137218596197129805502565e-89, "6913721859619713", -88},
    {2.2377014817559497014927813e+57, "22377014817559497", 58},
    {1.2794305985656031066363517e+289, "1279430598565603", 290},
    {1.5566909077324293430688030e+126, "15566909077324293", 127},
    {4.4235921724750306666907710e-132, "44235921724750307", -131},
    {6.3036245871807115003660141e+255, "63036245871807115", 256},
    {6.5539176876979625193727204e+169, "6553917687697963", 170},
    {2.0695260206014591352958994e+68, "20695260206014591", 69},
    {2.9712884040822986940474905e+212, "29712884040822987", 213},
    {2.4400817425085366640083337e-292, "24400817425085367", -291},
    {8.3001416924086760392243196e+130, "8300141692408676", 131},
    {1.5939734913107947729294847e+30, "15939734913107948", 31},
    {3.0704792183237480927116300e-186, "3070479218323748", -185},
    {1.6307777884033076016240629e-145, "16307777884033076", -144},
    {5.4283461144465329344270829e-118, "5428346114446533", -117},
    {2.5810491396697076288970357e-180, "25810491396697076", -179},
    {9.5003526337801934250911686e-296, "9500352633780193", -295},
    {8.4650964181766939842858518e+113, "8465096418176694", 114},
    {1.8751389107848104879433859e-28, "18751389107848105", -27},
    {2.6833186308225770425332208e+168, "2683318630822577", 169},
    {2.6677480687637455931878298e+185, "26677480687637456", 186},
    {5.8785263165187411463372800e+23, "5878526316518741", 24},
    {3.4542385990142302662379316e-220, "34542385990142303", -219},
    {1.0451944940360034894764794e-192, "10451944940360035", -191},
    {6.0173175772288236712519719e+168, "6017317577228824", 169},
    {4.4709430461261932373046875e+10, "4470943046126193", 11},
    {1.2674442192057354666002762e+129, "12674442192057355", 130},
    {1.2157524499690070841450372e-120, "1215752449969007", -119},
    {7.1985465508047686472955179e-101, "7198546550804769", -100},
    {5.6627914482045985350217686e+77, "5662791448204599", 78},
    {7.7792683202741635139046672e+92, "7779268320274164", 93},
    {1.3894758157597031020492248e+137, "1389475815759703", 138},
    {3.3595797750214672214291161e-102, "33595797750214672", -101},
    {2.9161838116899776742810899e+224, "29161838116899777", 225},
    {2.0394386071014953489342212e+165, "20394386071014953", 166},
    {5.1886693782764842964668518e+190, "5188669378276484", 191},
    {2.6116520075431991888407355e+151, "26116520075431992", 152},
    {5.1665822568685836023003360e+209, "51665822568685836", 210},
    {2.6614583478042802092260610e+49, "266145834780428", 50},
    {2.1155401884905221175245254e+145, "2115540188490522", 146},
    {3.7365645107826543913631667e+00, "37365645107826544", 1},
    {4.3291626566363515074538173e-141, "43291626566363515", -140},
    {4.9809487174652510930984874e-205, "4980948717465251", -204},
    {3.4469293855236511839416426e+202, "3446929385523651", 203},
    {4.0580420719497646988069256e+110, "4058042071949765", 111},
    {3.5612637045023791300638520e-265, "3561263704502379", -264},
    {8.6598556145948970256213769e+45, "8659855614594897", 46},
    {5.0407699299686635885721731e-140, "5040769929968664", -139},
    {1.5368449339356787578573132e-177, "15368449339356788", -176},
    {1.1780791527861243926768930e-227, "11780791527861244", -226},
    {1.3122524257373844955606027e+76, "13122524257373845", 77},
    {1.0895198203820014375154942e+176, "10895198203820014", 177},
    {9.9403355134342290027146486e+157, "9940335513434229", 158},
    {2.1981808414138154300012374e-158, "21981808414138154", -157},
    {1.0947104890762156161995563e-281, "10947104890762156", -280},
    {1.3795257715475015369923041e-77, "13795257715475015", -76},
    {3.8545729915999568952884409e-161, "3854572991599957", -160},
    {5.3018246187373198637919989e+166, "530182461873732", 167},
    {6.0884891808639765833246157e+251, "6088489180863977", 252},
    {5.0516749088287079167606012e-95, "5051674908828708", -94},
    {1.3460292605078235553651694e+37, "13460292605078236", 38},
    {1.7342046860741005465209974e-267, "17342046860741005", -266},
    {1.6358492707576588767487157e-171, "16358492707576589", -170},
    {2.4483881140840124395014027e+234, "24483881140840124", 235},
    {2.3721577651334162864675260e-201, "23721577651334163", -200},
    {3.3675062079155673414077959e-223, "33675062079155673", -222},
    {7.3849391069303238647245920e+118, "7384939106930324", 119},
    {2.0195258906294205379492435e-301, "20195258906294205", -300},
    {1.1082069235066596268800730e-161, "11082069235066596", -160},
    {1.6657954847363196453906587e+74, "16657954847363196", 75},
    {5.8459756997670643056170495e-299, "5845975699767064", -298},
    {3.1482145650583209001420863e+239, "3148214565058321", 240},
    {3.4364384823330160280801596e+252, "3436438482333016", 253},
    {1.0875079753564315904583412e-288, "10875079753564316", -287},
    {4.3031504000158025182925474e+223, "43031504000158025", 224},
    {8.1676320549240192000000000e+16, "816763205492402", 17},
    {1.6093486561672280645365034e+209, "1609348656167228", 210},
    {1.7120839887562374455616630e-237, "17120839887562374", -236},
    {8.5572577060395135234053657e+247, "8557257706039514", 248},
    {2.0700776952111330087610678e-62, "2070077695211133", -61},
    {2.1756230546717057860939684e+35, "21756230546717058", 36},
    {1.1271961887218589702546762e+71, "1127196188721859", 72},
    {2.5930902115674347372052777e+169, "25930902115674347", 170},
    {8.9570458990611587432425825e-173, "8957045899061159", -172},
    {1.9887867738577362892835406e+139, "19887867738577363", 140},
    {2.7452842975820774378630028e+63, "27452842975820774", 64},
    {2.7993193693310803590177507e+218, "27993193693310804", 219},
    {1.5915232898324035200000000e+17, "15915232898324035", 18},
    {6.4714722288567513367251666e+209, "6471472228856751", 210},
    {4.9932460163269635982132062e+145, "49932460163269636", 146},
    {6.9442262218196952425356847e-211, "6944226221819695", -210},
    {4.6231481982029212012264759e-208, "4623148198202921", -207},
    {1.0081970125366064618405888e+25, "10081970125366065", 26},
    {8.1969033127096864814413825e+126, "8196903312709686", 127},
    {2.2894277503466728865143307e+236, "2289427750346673", 237},
    {4.8842729838559543059816173e-179, "4884272983855954", -178},
    {1.4703713269272574329456116e-192, "14703713269272574", -191},
    {2.5038229144736320104808910e+190, "2503822914473632", 191},
    {1.9616318209537901253501834e+32, "196163182095379", 33},
    {4.1746947289019663452055473e-107, "41746947289019663", -106},
    {1.8098378974921201830100544e-257, "180983789749212", -256},
    {2.0062199532912928626687577e-181, "20062199532912929", -180},
    {1.7796487930198364849122332e+198, "17796487930198365", 199},
    {2.9818395767278140724560749e-105, "2981839576727814", -104},
    {1.5327430991555972877405678e+40, "15327430991555973", 41},
    {1.7781649657351119730508377e+151, "1778164965735112", 152},
    {1.7311759553961070668031308e-220, "1731175955396107", -219},
    {6.0426988443539753456735413e-16, "6042698844353975", -15},
    {5.0307123115307487619794017e+217, "5030712311530749", 218},
    {4.1460358853277510400000000e+17, "4146035885327751", 18},
    {8.0798619212042556064945185e+99, "8079861921204256", 100},
    {6.2057855544472364323510128e-10, "6205785554447236", -9},
    {4.8590399392956275251706052e-219, "48590399392956275", -218},
    {1.5946178192397528613620465e+179, "1594617819239753", 180},
    {4.4307768436732159893294021e-14, "4430776843673216", -13},
    {2.2370433921967989796721904e-45, "2237043392196799", -44},
    {6.1634180989557387874743218e-285, "6163418098955739", -284},
    {1.6899541404892080206395984e-190, "1689954140489208", -189},
    {6.4468156867546869232626492e+128, "6446815686754687", 129},
    {7.5461993562421301269531250e+11, "754619935624213", 12},
    {3.4805568325871225406815351e+146, "34805568325871225", 147},
    {5.6653678950904954880000000e+18, "5665367895090495", 19},
    {5.1075010574393785467356649e-227, "5107501057439379", -226},
    {6.1071202689751395944529577e-174, "610712026897514", -173},
    {5.8961376339231235976071795e-248, "58961376339231236", -247},
    {3.2852564100528391899140347e+233, "3285256410052839", 234},
    {3.9021450774866991350183092e-192, "3902145077486699", -191},
    {6.7343568903959636171333162e+41, "6734356890395964", 42},
    {7.7901699137073559686541557e+06, "7790169913707356", 7},
    {5.6610174317286852845457933e+176, "5661017431728685", 177},
    {5.5692523543545275508763191e+194, "55692523543545276", 195},
    {1.6487343031938505732619038e-201, "16487343031938506", -200},
    {1.0860770718785332281402601e+306, "10860770718785332", 307},
    {6.4602158128703099391467594e-240, "646021581287031", -239},
    {1.2261487338548765806964729e+271, "12261487338548766", 272},
    {1.4348131309954168100535391e+52, "14348131309954168", 53},
    {1.6564456619661211639550948e+186, "16564456619661212", 187},
    {1.9152444706095153010359261e-271, "19152444706095153", -270},
    {3.8474607844291171761427245e+87, "3847460784429117", 88},
    {9.5509214702432584066297844e+81, "9550921470243258", 82},
    {4.9383566992237461616943946e-198, "4938356699223746", -197},
    {1.0300617390763055785193695e-269, "10300617390763056", -268},
    {1.0654522939466963596637936e+61, "10654522939466964", 62},
    {2.1034025355418483377434313e+05, "21034025355418483", 6},
    {7.7772803804907562142821867e-10, "7777280380490756", -9},
    {6.8390440258845398128981458e+286, "683904402588454", 287},
    {2.9065874828268880038447304e-305, "2906587482826888", -304},
    {1.5179548663895316677171751e+122, "15179548663895317", 123},
    {2.1977247875569743144062106e+119, "21977247875569743", 120},
    {1.8220421060930586257821652e+293, "18220421060930586", 294},
    {6.1663850764343919436238116e-128, "6166385076434392", -127},
    {9.4983563980323989680769746e+61, "9498356398032399", 62},
    {6.6288522681614489573398430e-03, "6628852268161449", -2},
    {1.7089572306726119198470895e-247, "1708957230672612", -246},
    {6.5430789796122923359647169e-06, "6543078979612292", -5},
    {3.5483542283106370571146085e-124, "3548354228310637", -123},
    {7.2052637252289022966431735e-59, "7205263725228902", -58},
    {1.4313756898363504359171783e-196, "14313756898363504", -195},
    {3.4655141392444926181724419e-10, "34655141392444926", -9},
    {3.4724562451630269044492475e+148, "3472456245163027", 149},
    {8.7666014162950511093818070e+56, "8766601416295051", 57},
    {3.2745340703112085582372802e+62, "32745340703112086", 63},
    {2.9135899904127195456227755e+264, "29135899904127195", 265},
    {1.4082099222357189785253619e-130, "1408209922235719", -129},
    {7.3255721252100913527480324e-238, "7325572125210091", -237},
    {6.9451381554481127810456315e-302, "6945138155448113", -301},
    {1.2486375571176442282072520e-77, "12486375571176442", -76},
    {2.8524785420301743901263460e+122, "28524785420301744", 123},
    {1.6400707237685886522427268e-137, "16400707237685887", -136},
    {7.7852520106262909638239478e-02, "7785252010626291", -1},
    {1.9399744354310813869087541e-21, "19399744354310814", -20},
    {1.1671542230450894673349821e-247, "11671542230450895", -246},
    {1.6747551448586005133793970e-191, "16747551448586005", -190},
    {1.0857799645479816253916047e-73, "10857799645479816", -72},
    {7.4921085500687665810243594e-69, "7492108550068767", -68},
    {6.4858108729651811561268095e-226, "6485810872965181", -225},
    {1.8199101028971336725230172e+265, "18199101028971337", 266},
    {6.3911927975135696026526508e-65, "639119279751357", -64},
    {6.7630465967118726896898501e-95, "6763046596711873", -94},
    {1.8976119772948733813644517e+67, "18976119772948734", 68},
    {7.5592179487110771625862223e+240, "7559217948711077", 241},
    {5.4445581202182434584985282e+48, "54445581202182435", 49},
    {1.9100912810111587182141670e-44, "19100912810111587", -43},
    {1.2719967448203130419753795e+108, "1271996744820313", 109},
    {7.5689851267001306747711512e-104, "7568985126700131", -103},
    {1.2615628621413901273242997e+161, "12615628621413901", 162},
    {1.5461290978212199236487260e-182, "154612909782122", -181},
    {4.7809215731004573210048067e-115, "4780921573100457", -114},
    {5.7003127793928933044275380e-08, "5700312779392893", -7},
    {4.1171364679651542935288803e-232, "4117136467965154", -231},
    {1.9935738559041702660473284e-221, "19935738559041703", -220},
    {4.7179370790554681680914767e+173, "4717937079055468", 174},
    {8.8183845665950273246560158e-85, "8818384566595027", -84},
    {1.7502701518179288228728723e-07, "17502701518179288", -6},
    {1.0580519510304023136187348e+53, "10580519510304023", 54},
    {1.0046458999682004926236145e+93, "10046458999682005", 94},
    {1.5968422770783808564174614e-75, "15968422770783809", -74},
    {6.9796569024975959095743395e-46, "6979656902497596", -45},
    {1.8048248462608527913832158e+235, "18048248462608528", 236},
    {2.7292938805041167044040818e-92, "27292938805041167", -91},
    {1.5753847202045295126534142e+142, "15753847202045295", 143},
    {1.9728162282909304175585967e+65, "19728162282909304", 66},
    {4.6387587982365456904016447e+119, "4638758798236546", 120},
    {1.5059749130634311449865870e-292, "15059749130634311", -291},
    {5.1978883613415730726815858e+111, "5197888361341573", 112},
    {2.4248350137208067096176498e+182, "24248350137208067", 183},
    {8.4489864313620555064921345e-240, "8448986431362056", -239},
    {3.7148821155406442602679419e+174, "37148821155406443", 175},
    {9.6543214996538199926178405e-154, "965432149965382", -153},
    {2.6643383375050534399270140e-280, "26643383375050534", -279},
    {5.1861194150713359074588333e+237, "5186119415071336", 238},
    {2.8876109473948031864961467e+71, "2887610947394803", 72},
    {1.5321081894902134355977912e+249, "15321081894902134", 250},
    {8.1877462583387261474746814e+249, "8187746258338726", 250},
    {5.4121107133518155795271848e-59, "5412110713351816", -58},
    {1.3021593959778977579489615e-11, "13021593959778978", -10},
    {1.0137677854058306026730486e-203, "10137677854058306", -202},
    {4.5105145759740388647506759e-26, "4510514575974039", -25},
    {2.3509052533516117727066133e-191, "23509052533516118", -190},
    {6.5435691523376597619559257e-08, "654356915233766", -7},
    {1.3383101316252945384155382e-02, "13383101316252945", -1},
    {4.3681053193692674084932960e+242, "4368105319369267", 243},
    {7.9003194895224528201214705e+106, "7900319489522453", 107},
    {2.9793609314001381383016471e+283, "2979360931400138", 284},
    {1.0384647404751641432506521e+71, "10384647404751641", 72},
    {2.7050424302160370685261949e+64, "2705042430216037", 65},
    {4.1824324438801010420405474e+160, "4182432443880101", 161},
    {3.3876617811183462434986256e+68, "33876617811183462", 69},
    {5.1007572915189364508288110e-202, "5100757291518936", -201},
    {1.4414188109767746703268875e-10, "14414188109767747", -9},
    {1.4707991103581251065861368e-130, "14707991103581251", -129},
    {7.2087029240094740992189326e+35, "7208702924009474", 36},
    {7.2189969764142874196637105e-261, "7218996976414287", -260},
    {1.1340586087880326434969902e+07, "11340586087880326", 8},
    {5.8156027389340141914635762e+43, "5815602738934014", 44},
    {4.4770902980387611662005827e+298, "4477090298038761", 299},
    {5.0781110255448667765043783e+272, "5078111025544867", 273},
    {5.5020210737341007535124466e-282, "5502021073734101", -281},
    {4.7909562674806075945250046e-306, "47909562674806076", -305},
    {2.1690343895694046440442045e+244, "21690343895694046", 245},
    {2.9215321592720666284990910e-175, "29215321592720666", -174},
    {6.4020560096411644183564303e+232, "6402056009641164", 233},
    {4.9023398450705318789947076e+112, "4902339845070532", 113},
    {1.0896032858177345192425708e-197, "10896032858177345", -196},
    {5.3878683111340581878315845e+209, "5387868311134058", 210},
    {3.7817275881750310038205852e-74, "3781727588175031", -73},
    {3.1933920350974356667391500e+123, "31933920350974357", 124},
    {1.7880175309787250520760461e+294, "1788017530978725", 295},
    {1.3183567170336652808021601e+123, "13183567170336653", 124},
    {9.2469964960722567522779064e-89, "9246996496072257", -88},
    {3.5646630274509017560214488e+76, "3564663027450902", 77},
    {5.2413717711840563092631084e-76, "52413717711840563", -75},
    {1.1258214925960858510703434e-161, "11258214925960859", -160},
    {3.1831963689540043139887713e+268, "31831963689540043", 269},
    {5.1578535352048236195750112e-95, "51578535352048236", -94},
    {1.6721515992121482849121094e+10, "16721515992121483", 11},
    {4.8579542201968839884800000e+20, "4857954220196884", 21},
    {8.2119595739006765499363665e-122, "8211959573900677", -121},
    {8.0366707074680096458324465e-117, "803667070746801", -116},
    {2.2848299482661580324096976e-260, "2284829948266158", -259},
    {8.4248832449436688020559123e-88, "8424883244943669", -87},
    {2.5660663030000378666290258e-244, "2566066303000038", -243},
    {2.6574500714464377395349331e-124, "26574500714464377", -123},
    {1.9268698488522545560328404e+178, "19268698488522546", 179},
    {4.8213345170961817168451934e+178, "4821334517096182", 179},
    {3.2218214879279163333218116e+155, "32218214879279163", 156},
    {9.7818498344781318547469510e+78, "9781849834478132", 79},
    {3.2076855574875034502725440e-256, "32076855574875035", -255},
    {6.1745483775296386723914277e-300, "6174548377529639", -299},
    {2.1119238727562145238486149e+244, "21119238727562145", 245},
    {4.8108075120505669716593970e+213, "4810807512050567", 214},
    {1.5693361765301174500072775e+106, "15693361765301175", 107},
    {1.2449195852992973608109013e-57, "12449195852992974", -56},
    {9.0862535274189892224776532e-256, "9086253527418989", -255},
    {8.4106551188558421875000000e+13, "8410655118855842", 14},
    {1.3820253780247688905319506e+89, "1382025378024769", 90},
    {1.0483636139525581090615661e-214, "10483636139525581", -213},
    {3.3196818786821738651123215e+48, "3319681878682174", 49},
    {1.0384998881944749587539199e-07, "1038499888194475", -6},
    {7.8909971073190814795564342e+180, "78909971073190815", 181},
    {1.0778114025450442925913871e-80, "10778114025450443", -79},
    {1.2094240261458982770108564e-88, "12094240261458983", -87},
    {2.9284587327092106658806593e-141, "29284587327092107", -140},
    {3.6062143025573113215675525e+272, "36062143025573113", 273},
    {4.9864021269803191266085210e+211, "4986402126980319", 212},
    {4.4866251124496825086518628e-129, "44866251124496825", -128},
    {3.8856305110320043080159827e-292, "38856305110320043", -291},
    {6.1256879448008517716837549e-137, "6125687944800852", -136},
    {5.8058775682401009263645561e-173, "5805877568240101", -172},
    {2.8140959207353292189669190e+295, "2814095920735329", 296},
    {1.9072052972291645558798990e-260, "19072052972291646", -259},
    {2.8064279886585418882812539e-14, "2806427988658542", -13},
    {4.2068406834093350476392217e+288, "4206840683409335", 289},
    {2.3350575825745844881868149e+55, "23350575825745845", 56},
    {1.3208939144023966181650099e+273, "13208939144023966", 274},
    {7.3617488080166628589425745e+293, "7361748808016663", 294},
    {3.6462351378911858996346638e+233, "3646235137891186", 234},
    {4.1778052530162898195799109e-70, "417780525301629", -69},
    {4.2804029352036359981731848e-213, "4280402935203636", -212},
    {2.2207855440971462136575172e+131, "22207855440971462", 132},
    {3.1624430974175549505233995e-04, "3162443097417555", -3},
    {9.8309635150712823480282945e+74, "9830963515071282", 75},
    {1.5252431733353320415922263e-256, "1525243173335332", -255},
    {1.2391376119835762043532527e+53, "12391376119835762", 54},
    {1.8613510017561994027346373e+05, "18613510017561994", 6},
    {6.4569908206478396856976365e-110, "645699082064784", -109},
    {8.6650392245839631091223493e+305, "8665039224583963", 306},
    {4.9890693616602837723947357e-152, "4989069361660284", -151},
    {1.2964506221335332122580655e-28, "12964506221335332", -27},
    {1.2258018691138390639690390e-79, "1225801869113839", -78},
    {2.4143123032316689482365969e-121, "2414312303231669", -120},
    {1.9222818041004585095748191e+43, "19222818041004585", 44},
    {3.3850018568140458174439706e-122, "3385001856814046", -121},
    {1.1713849961319158197839250e-219, "11713849961319158", -218},
    {1.7082535701639156992009899e+301, "17082535701639157", 302},
    {1.8617718656505047364184465e+240, "18617718656505047", 241},
    {5.0858484129748603663756512e+01, "50858484129748604", 2},
    {1.4865242036476745370457928e+78, "14865242036476745", 79},
    {9.2583174700061428596058460e-93, "9258317470006143", -92},
    {2.7963409533014073759106970e+141, "27963409533014074", 142},
    {5.3584044745276026375471469e-248, "5358404474527603", -247},
    {2.9222560217470839391187785e+115, "2922256021747084", 116},
    {3.1388194000793760895193626e+150, "3138819400079376", 151},
    {1.4527184804159141073449236e+209, "14527184804159141", 210},
    {2.7343360831275407352042200e-261, "27343360831275407", -260},
    {2.6914561916278420885885114e-116, "2691456191627842", -115},
    {3.3001618905688454966755556e-293, "33001618905688455", -292},
    {6.7427124044142956436397794e+236, "6742712404414296", 237},
    {3.2371821642201087504280384e-64, "3237182164220109", -63},
    {2.6895994417415935664123283e-77, "26895994417415936", -76},
    {3.9326587229006890732721919e-125, "3932658722900689", -124},
    {9.6679242349967572720971605e-250, "9667924234996757", -249},
    {1.9244221320403727694221735e-88, "19244221320403728", -87},
    {5.5532019403204308419598255e-187, "5553201940320431", -186},
    {1.7167115000632933259770033e+260, "17167115000632933", 261},
    {2.7940603816999078547771612e+43, "2794060381699908", 44},
    {1.4110105228238952095341385e+237, "14110105228238952", 238},
    {2.8075102904311790283764466e+115, "2807510290431179", 116},
    {4.1634252360796263718124061e-175, "41634252360796264", -174},
    {4.7202629444520382545993588e-205, "4720262944452038", -204},
    {3.9988572075507467317372719e+37, "39988572075507467", 38},
    {7.0913990242747371816945164e-243, "7091399024274737", -242},
    {3.6491355211537438746865563e+110, "3649135521153744", 111},
    {1.2786188645812729264783277e+179, "12786188645812729", 180},
    {5.2747742849312580442426137e+64, "5274774284931258", 65},
    {2.6761005887546451136041753e-253, "2676100588754645", -252},
    {1.0890899989241711691426777e+71, "10890899989241712", 72},
    {4.6022894915770761903690287e+144, "4602289491577076", 145},
    {6.5386001024525053799152374e+05, "6538600102452505", 6},
    {8.3416095190419218150473481e-09, "8341609519041922", -8},
    {2.8726757114104648502136382e+134, "2872675711410465", 135},
    {3.2734848877137007266019727e-87, "32734848877137007", -86},
    {1.7599550981553736589214101e+53, "17599550981553737", 54},
    {1.4092293480411619546967177e-285, "1409229348041162", -284},
    {1.6332000740101821585360754e+260, "16332000740101822", 261},
    {1.3923030167864300220996837e-173, "139230301678643", -172},
    {4.9802907839001903701375975e-222, "49802907839001904", -221},
    {8.6051683297290361591065179e+272, "8605168329729036", 273},
    {1.2932712952503615141403436e-219, "12932712952503615", -218},
    {9.4585012483773886718750000e+12, "9458501248377389", 13},
    {6.7249200510173677016812343e+32, "6724920051017368", 33},
    {7.8272154950046411519643566e+251, "7827215495004641", 252},
    {5.5975084864734629544407203e-229, "5597508486473463", -228},
    {1.5585937659604863875552323e+150, "15585937659604864", 151},
    {2.0232666209979828352270594e-99, "2023266620997983", -98},
    {1.3599865038329992519854374e-44, "13599865038329993", -43},
    {5.0366750015542039881344920e+46, "5036675001554204", 47},
    {1.5971990428236674360669781e-84, "15971990428236674", -83},
    {7.8592100159068119073518227e-150, "7859210015906812", -149},
    {1.8527601851145893065749389e-250, "18527601851145893", -249},
    {3.1452633070571007151010329e+94, "31452633070571007", 95},
    {9.4174097187316820054547861e+03, "9417409718731682", 4},
    {3.0227822366677531138793204e-142, "3022782236667753", -141},
    {1.0157340172878417441040567e-07, "10157340172878417", -6},
    {7.8425171645813920688598699e-23, "7842517164581392", -22},
    {5.4743823739166098653639282e+178, "547438237391661", 179},
    {6.7820825878375872891237905e+182, "6782082587837587", 183},
    {2.3380729782293143927837474e-100, "23380729782293144", -99},
    {2.3754384592665220637968385e+176, "2375438459266522", 177},
    {1.3055646701316589635732330e-49, "1305564670131659", -48},
    {6.7698209065607458217848359e-43, "6769820906560746", -42},
    {8.4989934601003180632757778e+223, "8498993460100318", 224},
    {1.1991764890146712366036337e+63, "11991764890146712", 64},
    {1.0607173929869320987897654e+140, "1060717392986932", 141},
    {7.9370372551833101582019481e-02, "793703725518331", -1},
    {9.1566172674316477916110864e+67, "9156617267431648", 68},
    {4.4238237313590187151050217e-39, "4423823731359019", -38},
    {5.6085511583090640392386873e-101, "5608551158309064", -100},
    {1.3678869492074642382832685e-157, "13678869492074642", -156},
    {1.8335038944514616687797570e+00, "18335038944514617", 1},
    {5.8139294069333137766934037e+251, "5813929406933314", 252},
    {4.1287967294778648105733720e-18, "4128796729477865", -17},
    {9.3681880703523160488566626e+259, "9368188070352316", 260},
    {1.7939739969666920653591417e-91, "1793973996966692", -90},
    {2.3983321515677894423612336e-48, "23983321515677894", -47},
    {4.2233058723025352692499549e+39, "4223305872302535", 40},
    {5.2013884668422196144942143e-199, "520138846684222", -198},
    {4.4248164356789941787719727e+09, "4424816435678994", 10},
    {2.5250932529675455110617081e+38, "25250932529675455", 39},
    {1.3171925567397904815386825e-288, "13171925567397905", -287},
    {1.0554487027929699168140202e+96, "10554487027929699", 97},
    {6.1842389968179163262007267e-172, "6184238996817916", -171},
    {1.4392362509484948868007547e+171, "14392362509484949", 172},
    {2.5429835856653808178610973e+99, "2542983585665381", 100},
    {3.6071607208367726608994471e+232, "36071607208367727", 233},
    {5.6620814809946665211377370e-278, "5662081480994667", -277},
    {4.5315981740318084236562868e-01, "45315981740318084", 0},
    {3.3019080910889056268900072e+272, "33019080910889056", 273},
    {5.5460199398691428120094255e+119, "5546019939869143", 120},
    {6.2801689583509509255117486e-158, "6280168958350951", -157},
    {7.2100920410635079431303268e+292, "7210092041063508", 293},
    {6.8346676672125427700768052e+93, "6834667667212543", 94},
    {1.3205346936768347977714131e-229, "13205346936768348", -228},
    {3.3165027715285466383739783e-118, "33165027715285466", -117},
    {1.8363241063450416326311862e-17, "18363241063450416", -16},
    {1.3700829067172576836789856e+266, "13700829067172577", 267},
    {1.5735511849514278530339560e+99, "15735511849514279", 100},
    {2.7736649723300961855962208e-301, "2773664972330096", -300},
    {6.5777226712427165783947543e+50, "65777226712427166", 51},
    {1.6883081215120417780988265e+61, "16883081215120418", 62},
    {1.5825202098850134181009706e+240, "15825202098850134", 241},
    {1.1962085152478373764126515e-105, "11962085152478374", -104},
    {8.1334740109436116516257453e-05, "8133474010943612", -4},
    {1.5236341362053712156729359e-167, "15236341362053712", -166},
    {1.6819742148164654318573106e+113, "16819742148164654", 114},
    {4.8816720184249804443814427e-307, "48816720184249804", -306},
    {1.5252629652164728861901512e+275, "1525262965216473", 276},
    {3.0370394229533813826720588e-56, "30370394229533814", -55},
    {6.0400182669927087103374926e+113, "6040018266992709", 114},
    {1.9142541628765492381363193e-168, "19142541628765492", -167},
    {3.7605300718090027563682330e-50, "37605300718090028", -49},
    {9.7180291395201711971243393e-67, "9718029139520171", -66},
    {3.3237019399657722560394424e+100, "33237019399657723", 101},
    {4.7054806696159246835659693e-94, "47054806696159247", -93},
    {4.3717250776740881003076439e-141, "4371725077674088", -140},
    {3.8365462937525817261582299e+32, "3836546293752582", 33},
    {7.5768422985963830646856263e-139, "7576842298596383", -138},
    {3.9988629642870583512268800e+23, "39988629642870584", 24},
    {1.1693602728826603561125260e-173, "11693602728826604", -172},
    {8.6418512508342938149019463e+100, "8641851250834294", 101},
    {7.9454927344432027359358412e+159, "7945492734443203", 160},
    {1.0854884746291417488877406e+108, "10854884746291417", 109},
    {1.6552056942585991113155929e+290, "1655205694258599", 291},
    {8.2505025272888034738369662e+111, "8250502527288803", 112},
    {2.4523274674407489708561265e-94, "2452327467440749", -93},
    {1.1016459634555898264420658e+218, "11016459634555898", 219},
    {1.7635423040993018926742238e-39, "1763542304099302", -38},
    {3.5065653745367326226559327e+51, "35065653745367326", 52},
    {3.2315872219674953081268827e-108, "32315872219674953", -107},
    {2.3239086182998319312565494e-82, "2323908618299832", -81},
    {1.4122627789035431799846355e-300, "14122627789035432", -299},
    {3.5304041304568315047999022e-206, "35304041304568315", -205},
    {3.9237034721380988693495520e-263, "3923703472138099", -262},
    {9.8320722149373337500000000e+14, "9832072214937334", 15},
    {5.1760660932845289798170776e-187, "5176066093284529", -186},
    {5.7301525886139557371004317e+87, "5730152588613956", 88},
    {4.1663027006453225787549940e-202, "4166302700645323", -201},
    {3.9033489929994191429796282e-65, "3903348992999419", -64},
    {2.1377669513870751601568679e-60, "21377669513870752", -59},
    {3.4338052043254346591751435e-158, "34338052043254347", -157},
    {2.4088456699461189583151943e-115, "2408845669946119", -114},
    {4.1640252405614204773141468e-103, "41640252405614205", -102},
    {1.1653476519423717435425633e+206, "11653476519423717", 207},
    {1.6878176179153542827437767e-91, "16878176179153543", -90},
    {2.2690257739588937055043628e+236, "22690257739588937", 237},
    {6.4855037644870452582836151e+07, "6485503764487045", 8},
    {1.2086274663811928139075477e+154, "12086274663811928", 155},
    {3.2110557463066809999542611e+122, "3211055746306681", 123},
    {3.7902612035464362592681386e-166, "3790261203546436", -165},
    {3.6524382178926821967365949e-162, "3652438217892682", -161},
    {1.2775307109933909586295442e+194, "1277530710993391", 195},
    {5.2057468250032565107342227e-13, "5205746825003257", -12},
    {9.6102644982597254504138597e-124, "9610264498259725", -123},
    {1.4650506062401609624199589e-19, "1465050606240161", -18},
    {7.5328729774166205467764666e-09, "753287297741662", -8},
    {1.9770346043638059002321794e+132, "1977034604363806", 133},
    {3.6152694765667953115904452e-47, "36152694765667953", -46},
    {1.3017268443467134521850434e-92, "13017268443467135", -91},
    {1.0834394887547268406448665e-114, "10834394887547268", -113},
    {1.2225169916287053112173604e+101, "12225169916287053", 102},
    {6.1236151731299399359204125e-64, "612361517312994", -63},
    {7.1890717463226681709758298e-40, "7189071746322668", -39},
    {2.4688988316081859948171339e-89, "2468898831608186", -88},
    {1.4409066975222826805212580e-53, "14409066975222827", -52},
    {4.0871060290156832726018830e+48, "4087106029015683", 49},
    {7.4108216499618953302102842e+104, "7410821649961895", 105},
    {1.8483117087233420418527488e+193, "1848311708723342", 194},
    {4.0192405541984625623290270e-81, "40192405541984626", -80},
    {2.5826388815703516998672441e+219, "25826388815703517", 220},
    {6.4870425420984007602539420e+130, "6487042542098401", 131},
    {7.4434107495815197908133081e+151, "744341074958152", 152},
    {4.1334442585943995154367266e-129, "41334442585943995", -128},
    {4.1670870698662864812123570e-279, "41670870698662865", -278},
    {5.5163260932920512926355619e+196, "5516326093292051", 197},
    {8.7775893351080043370101277e+98, "8777589335108004", 99},
    {1.1599403991755554088106070e-20, "11599403991755554", -19},
    {3.5519014827499723368814422e+180, "35519014827499723", 181},
    {1.0758579457252688777401138e-236, "10758579457252689", -235},
    {2.5788596864423736776959757e-30, "25788596864423737", -29},
    {7.8977371607288008950231864e+91, "7897737160728801", 92},
    {3.2305956838069611198472121e+74, "3230595683806961", 75},
    {3.8902237796695642286893142e-151, "3890223779669564", -150},
    {3.2379002808730423207657472e+25, "32379002808730423", 26},
    {4.9279853855253747651136329e+211, "4927985385525375", 212},
    {3.4579960918414791906803059e-134, "3457996091841479", -133},
    {6.3470524976577221999975915e-273, "6347052497657722", -272},
    {3.6147113765366848796649062e+26, "3614711376536685", 27},
    {7.3563796917279110499080238e-218, "7356379691727911", -217},
    {6.0192359285799831262157822e-241, "6019235928579983", -240},
    {1.4368414392379145717204905e-289, "14368414392379146", -288},
    {6.6720372943192484286060136e-293, "6672037294319248", -292},
    {4.7519021590314176000000000e+17, "47519021590314176", 18},
    {5.3568635240406023984802347e+152, "5356863524040602", 153},
    {3.9538932229860933285895567e+200, "3953893222986093", 201},
    {1.2829097967201873434381495e-284, "12829097967201873", -283},
    {1.5419592729842843750000000e+14, "15419592729842844", 15},
    {1.1170132770655750000000000e+13, "1117013277065575", 14},
    {3.6139885429558537818360788e-215, "3613988542955854", -214},
    {2.5442708038520180284801779e-186, "2544270803852018", -185},
    {9.7005375033251732407296437e-279, "9700537503325173", -278},
    {1.9340273488397006190097059e+104, "19340273488397006", 105},
    {8.3210130138703558150787687e-11, "8321013013870356", -10},
    {1.9876885052553167345839468e-117, "19876885052553167", -116},
    {4.7714690896451465967908646e+231, "47714690896451466", 232},
    {1.1753224485535143045780083e+236, "11753224485535143", 237},
    {1.9679092665273664004835425e-07, "19679092665273664", -6},
    {5.0702792688310734776787347e-93, "50702792688310735", -92},
    {4.7957300436228909773959462e-51, "4795730043622891", -50},
    {1.6219460360367044813150301e-289, "16219460360367045", -288},
    {3.4621012530730281303695703e-305, "3462101253073028", -304},
    {4.3972573810636238094099185e+69, "4397257381063624", 70},
    {3.9094451121743535075544269e+26, "39094451121743535", 27},
    {2.8983519978693043455312028e-86, "28983519978693043", -85},
    {1.4276885458499699227840245e+135, "142768854584997", 136},
    {8.1424483417601676732275346e-240, "8142448341760168", -239},
    {7.6812915336911581248870309e+118, "7681291533691158", 119},
    {4.3942993700024977399296126e-293, "4394299370002498", -292},
    {8.1142864814514673033052361e-02, "8114286481451467", -1},
    {3.2001797765355984988904125e+278, "32001797765355985", 279},
    {1.3718687183618339993639299e-210, "1371868718361834", -209},
    {1.4502214534413017282293741e-301, "14502214534413017", -300},
    {1.3510843953944860326442558e+120, "1351084395394486", 121},
    {7.5951842579574636981661246e-161, "7595184257957464", -160},
    {5.8282080915023134432072652e+123, "5828208091502313", 124},
    {1.9457293596733258543234092e-298, "1945729359673326", -297},
    {7.8053354953350832000000000e+16, "7805335495335083", 17},
    {4.0837401216865372174561320e-109, "4083740121686537", -108},
    {1.9481457790425483091165779e-199, "19481457790425483", -198},
    {2.7114169943291054882322186e-45, "27114169943291055", -44},
    {1.2638670609922155305224569e-188, "12638670609922155", -187},
    {2.0090511193460411160337891e+224, "2009051119346041", 225},
    {2.3340440774161371126924906e-193, "2334044077416137", -192},
    {3.2255482211312114132165077e-164, "32255482211312114", -163},
    {1.9177166536305262671761797e-16, "19177166536305263", -15},
    {6.6762277485439577092650143e+255, "6676227748543958", 256},
    {2.0981361326444801604493535e-289, "209813613264448", -288},
    {4.9855199026486553981231910e+161, "4985519902648655", 162},
    {2.2787110335050254868679990e+209, "22787110335050255", 210},
    {1.2107275753382450588608793e+196, "1210727575338245", 197},
    {1.0342829513785960367928878e-61, "1034282951378596", -60},
    {1.2915271183891931487735769e-229, "12915271183891931", -228},
    {2.4770484858416096751058189e-26, "24770484858416097", -25},
    {5.8834787141711107801606624e+306, "5883478714171111", 307},
    {6.5540638159915622735595391e+239, "6554063815991562", 240},
    {3.4772851916209036111831665e+08, "34772851916209036", 9},
    {6.4480355622336432138210357e+34, "6448035562233643", 35},
    {2.8741000335340013539519876e+127, "28741000335340014", 128},
    {4.9146982550148414149902445e+182, "49146982550148414", 183},
    {9.1280712021813949903055688e+251, "9128071202181395", 252},
    {2.1418616591363449544562774e-279, "2141861659136345", -278},
    {1.0362180184894959399150510e+281, "1036218018489496", 282},
    {1.3556689511133099274998884e+184, "135566895111331", 185},
    {1.0087159170105736810670136e+53, "10087159170105737", 54},
    {1.2219706762625801471822906e-109, "12219706762625801", -108},
    {7.2262465258265214070845326e-73, "7226246525826521", -72},
    {7.9239602604991647775709759e-133, "7923960260499165", -132},
    {2.8847708761132974833306905e+307, "28847708761132975", 308},
    {1.7037802615887541145925401e-12, "17037802615887541", -11},
    {1.0742678989774105760652274e-248, "10742678989774106", -247},
    {1.0088322516805741677752139e-41, "10088322516805742", -40},
    {7.5173181224960826765976378e+70, "7517318122496083", 71},
    {2.8486543433871786519475633e+186, "28486543433871787", 187},
    {6.3802563214099795252305133e+212, "63802563214099795", 213},
    {3.9417716501513654992184103e-94, "39417716501513655", -93},
    {3.6988333741496242192964188e-227, "3698833374149624", -226},
    {9.8024049836567287451290990e+124, "9802404983656729", 125},
    {5.6330153565227379105895564e-250, "5633015356522738", -249},
    {1.3660372744980724591432039e-201, "13660372744980725", -200},
    {1.8605966281797526412980546e+92, "18605966281797526", 93},
    {9.0552272726879373349173468e-119, "9055227272687937", -118},
    {1.2456704714849356923690308e+48, "12456704714849357", 49},
    {8.0953850995300705587031828e+207, "809538509953007", 208},
    {4.3776508275901479602119258e+123, "4377650827590148", 124},
    {1.6855556257147624321863376e+70, "16855556257147624", 71},
    {1.2893001820269392627971161e-03, "12893001820269393", -2},
    {6.7210426659260031193210643e-239, "6721042665926003", -238},
    {3.1026695824331064796573506e+163, "31026695824331065", 164},
    {5.4376792797885493361792162e-259, "5437679279788549", -258},
    {9.7015289470101480315448149e-166, "9701528947010148", -165},
    {1.7920049920867948937730635e+133, "1792004992086795", 134},
    {2.8743155463358490489695270e-287, "2874315546335849", -286},
    {3.2809882731634037592575168e-195, "32809882731634038", -194},
    {8.6118433944293315034238988e+157, "8611843394429332", 158},
    {5.2108688074593239598743124e+33, "5210868807459324", 34},
    {1.8889250440209064184225673e-63, "18889250440209064", -62},
    {4.9844141270776763558387756e+06, "4984414127077676", 7},
    {9.6576770504249135558113279e+130, "9657677050424914", 131},
    {1.8530161533027035388093459e-253, "18530161533027035", -252},
    {4.0392916680871317794838307e-248, "4039291668087132", -247},
    {7.6490815378538759785536681e-222, "7649081537853876", -221},
    {3.4455356653552616747680406e+50, "34455356653552617", 51},
    {7.5087969967819713842527582e+105, "7508796996781971", 106},
    {4.2836361776315433942124781e+272, "42836361776315434", 273},
    {1.9263388869855029979124611e+156, "1926338886985503", 157},
    {4.2405721453072370002836943e+178, "4240572145307237", 179},
    {1.9484642445919718951385325e-276, "1948464244591972", -275},
    {1.8734081969728912000000000e+17, "18734081969728912", 18},
    {2.8940516295674526538944994e+240, "28940516295674527", 241},
    {4.3319803654251584341322711e+114, "43319803654251584", 115},
    {6.0933006462878921018067164e+109, "6093300646287892", 110},
    {2.6075886164371219083909748e-136, "2607588616437122", -135},
    {1.0153616425748073105282198e-291, "10153616425748073", -290},
    {5.2336541422926305079339497e+68, "52336541422926305", 69},
    {1.7233000720963831509673015e-200, "17233000720963832", -199},
    {5.0444614603456048839320094e+149, "5044461460345605", 150},
    {3.7076545971330514735013909e+290, "37076545971330515", 291},
    {1.1127945794395121517453095e+36, "11127945794395122", 37},
    {9.2426915359648059082031250e+11, "9242691535964806", 12},
    {5.2533302928361538190584409e-105, "5253330292836154", -104},
    {5.6178915751115478203491500e+125, "5617891575111548", 126},
    {6.7628222815300740947700390e+277, "6762822281530074", 278},
    {5.8273016200382073769837769e-10, "5827301620038207", -9},
    {1.7565098890358562203144330e+136, "17565098890358562", 137},
    {8.4222328279689448007331948e-30, "8422232827968945", -29},
    {2.3459290196002489211737768e+59, "2345929019600249", 60},
    {2.5081595496710542283321766e+79, "25081595496710542", 80},
    {9.4675511643255063148276757e+216, "9467551164325506", 217},
    {2.2063311336266132509549745e-59, "22063311336266133", -58},
    {1.2610861754822845430402692e-37, "12610861754822845", -36},
    {2.7041532510596421675646976e+25, "2704153251059642", 26},
    {2.4031383712512535232585771e-108, "24031383712512535", -107},
    {2.1499827774669038372882100e-22, "2149982777466904", -21},
    {2.7405965208201651643592369e-179, "2740596520820165", -178},
    {1.8542336005837174811840590e+31, "18542336005837175", 32},
    {2.0542615070661391138847613e+263, "2054261507066139", 264},
    {6.2463000927789766314468523e-02, "62463000927789766", -1},
    {3.1733297951657611591855246e-04, "3173329795165761", -3},
    {1.0765669937041190054455791e+35, "1076566993704119", 36},
    {6.2885209670860216524365052e+138, "6288520967086022", 139},
    {2.8689805042418936124762280e-288, "28689805042418936", -287},
    {1.8272040053110420697886361e+231, "1827204005311042", 232},
    {1.6420381765464600373091573e+289, "164203817654646", 290},
    {6.0559507218805448286576033e+144, "6055950721880545", 145},
    {4.1877226433751424101658713e-286, "41877226433751424", -285},
    {3.0536068952806242417231564e+288, "3053606895280624", 289},
    {1.9277554002776541908980204e+28, "19277554002776542", 29},
    {1.5799939066762181761119366e-04, "15799939066762182", -3},
    {1.8743917240980036155108648e-155, "18743917240980036", -154},
    {2.0339534628483233504235656e+202, "20339534628483234", 203},
    {5.8133857249348334387200000e+20, "58133857249348334", 21},
    {4.5950722344969590000000000e+15, "4595072234496959", 16},
    {1.0252932377234532900008951e-225, "10252932377234533", -224},
    {2.7268880782838553485529402e-167, "27268880782838553", -166},
    {1.4623140785878385172869792e-210, "14623140785878385", -209},
    {1.0614782960184317949796848e+225, "10614782960184318", 226},
    {2.4568486243152450769737856e+63, "2456848624315245", 64},
    {1.3196885717727739525672558e+287, "1319688571772774", 288},
    {4.0915485490936680854922176e+258, "4091548549093668", 259},
    {1.3786850053926465061605437e-305, "13786850053926465", -304},
    {4.5350774432208757812500000e+13, "4535077443220876", 14},
    {3.8389991016588808656291914e+287, "3838999101658881", 288},
    {3.9396347068542250760318513e-107, "3939634706854225", -106},
    {2.3486785373354976613973105e+261, "23486785373354977", 262},
    {6.2387609197801166633751937e-11, "6238760919780117", -10},
    {1.0328573266281174427145415e-59, "10328573266281174", -58},
    {4.7179685749167881228527399e-04, "4717968574916788", -3},
    {1.2354232585125748129295098e+259, "12354232585125748", 260},
    {8.3853264169977021479894598e-29, "8385326416997702", -28},
    {9.4572432201552498080844143e+37, "945724322015525", 38},
    {1.3344930761857313264685520e-126, "13344930761857313", -125},
    {1.0287837378814401600000000e+17, "10287837378814402", 18},
    {1.5324822080688293790471273e+183, "15324822080688294", 184},
    {3.6913938767859603900521156e-151, "36913938767859604", -150},
    {1.0807740074546391701975060e-290, "10807740074546392", -289},
    {4.3139440977413661236739929e-97, "4313944097741366", -96},
    {1.6970294364210480642731040e+124, "1697029436421048", 125},
    {1.5744319855206305171528250e+39, "15744319855206305", 40},
    {2.2905324978665183076177585e-238, "22905324978665183", -237},
    {1.7196778953736696619359121e+151, "17196778953736697", 152},
    {4.3888625235630291284457138e+158, "4388862523563029", 159},
    {3.6883341346755421243991864e+29, "3688334134675542", 30},
    {9.3658956308717918108344033e+116, "9365895630871792", 117},
    {6.4626107826300447430091649e+253, "6462610782630045", 254},
    {1.8862875810013062896433000e-52, "18862875810013063", -51},
    {1.7684851337110502290406760e-60, "17684851337110502", -59},
    {2.0243012515756401640486667e+69, "202430125157564", 70},
    {9.7789400090529006207258107e-289, "97789400090529", -288},
    {1.7436762350089123388029587e+294, "17436762350089123", 295},
    {4.3882188442690124800000000e+18, "43882188442690125", 19},
    {1.2601333162253728049754332e+89, "12601333162253728", 90},
    {1.6796447348182419811997322e+83, "1679644734818242", 84},
    {6.2901800993753214877787034e-170, "62901800993753215", -169},
    {7.4860964378276392817497253e+07, "748609643782764", 8},
    {1.8460002119030610417417420e+241, "1846000211903061", 242},
    {1.1545918185938116955017797e-290, "11545918185938117", -289},
    {3.0017553534794881759596490e-215, "3001755353479488", -214},
    {1.5960500530445223828274268e+158, "15960500530445224", 159},
    {1.2124948224725861735182947e-154, "12124948224725862", -153},
    {3.0730667308850668478384830e+121, "3073066730885067", 122},
    {3.6866724306756125712447840e-59, "36866724306756126", -58},
    {3.4059814926014982494674577e+98, "3405981492601498", 99},
    {1.1436915212286048042363893e-10, "11436915212286048", -9},
    {3.9424503826953730816912708e+229, "3942450382695373", 230},
    {5.1687135082900734837690874e+197, "51687135082900735", 198},
    {2.2778847591170551039656234e-75, "2277884759117055", -74},
    {7.6277406679561940788224909e-38, "7627740667956194", -37},
    {8.8029102446160716403903875e+132, "8802910244616072", 133},
    {4.6552699322855073181510753e-135, "46552699322855073", -134},
    {2.7202658786317864870938396e-289, "27202658786317865", -288},
    {2.0781310780985193948859859e-38, "20781310780985194", -37},
    {1.8019625593232128482307510e+130, "18019625593232128", 131},
    {1.5593707280528000471029044e+215, "15593707280528", 216},
    {2.0323424150362618285708640e-301, "2032342415036262", -300},
    {1.0777485403369308179893529e-78, "10777485403369308", -77},
    {4.9401290970355990438953726e-199, "4940129097035599", -198},
    {3.1182150574898764119893585e-234, "31182150574898764", -233},
    {9.6165779048119541371524220e-141, "9616577904811954", -140},
    {9.8708891241668173095528865e-281, "9870889124166817", -280},
    {1.9161264748366315318086349e-63, "19161264748366315", -62},
    {2.0940709638473898426153120e-88, "20940709638473898", -87},
    {1.7109153942937037523961030e+274, "17109153942937038", 275},
    {9.4783632474423456663518487e+34, "9478363247442346", 35},
    {1.5523036538654105153880956e-99, "15523036538654105", -98},
    {3.9152545451779392265912170e+46, "3915254545177939", 47},
    {6.3620320553317353033012363e+138, "6362032055331735", 139},
    {3.2292008919430946460334760e+91, "32292008919430946", 92},
    {3.3141570303299820109308945e+79, "3314157030329982", 80},
    {2.2309191216585987887511324e+237, "22309191216585988", 238},
    {7.4857724318299275618959732e+81, "74857724318299276", 82},
    {7.9760996842389418554181074e-86, "7976099684238942", -85},
    {3.2498882789352469706592360e-238, "3249888278935247", -237},
    {8.6436366901181114509080248e+203, "8643636690118111", 204},
    {9.7462414782175554624628126e+104, "9746241478217555", 105},
    {1.1420822529456058952227161e-281, "11420822529456059", -280},
    {2.3168222970703006740715665e+181, "23168222970703007", 182},
    {2.8522677461534228266153766e+247, "2852267746153423", 248},
    {9.4350947738955085688071965e-41, "9435094773895509", -40},
    {4.6432886908188017006832701e+81, "4643288690818802", 82},
    {4.5780123712776788570350210e+87, "4578012371277679", 88},
    {3.6254898808021285148908802e+287, "36254898808021285", 288},
    {3.4376584002058591695025354e-180, "3437658400205859", -179},
    {4.2991913719415459116849562e+26, "4299191371941546", 27},
    {3.0115361390123952945726891e-109, "30115361390123953", -108},
    {6.5950826454125078508600794e-199, "6595082645412508", -198},
    {6.7482481857690978289836981e-123, "6748248185769098", -122},
    {4.4399003248087375173277375e-68, "44399003248087375", -67},
    {5.9426204265305235934586414e-270, "5942620426530524", -269},
    {7.8614263097954373539170566e-136, "7861426309795437", -135},
    {1.7647273198166810728002537e+174, "1764727319816681", 175},
    {2.5161484799779026209837085e-40, "25161484799779026", -39},
    {2.3233167487965873575655253e+137, "23233167487965874", 138},
    {5.2196214074413346170346408e-298, "5219621407441335", -297},
    {2.4580543236259367175272424e-39, "24580543236259367", -38},
    {2.5730375381261529550407104e-265, "2573037538126153", -264},
    {2.4636684290183660724425393e+160, "2463668429018366", 161},
    {1.8152338029853438024066254e-94, "18152338029853438", -93},
    {3.1470792751102361829454766e-280, "3147079275110236", -279},
    {9.7915151232011718199852240e+229, "9791515123201172", 230},
    {2.4662988888549044772554130e-135, "24662988888549045", -134},
    {3.0927420407411100685185980e+34, "309274204074111", 35},
    {2.3459848970484382260624943e+130, "2345984897048438", 131},
    {4.8661333753386867064426849e-51, "4866133375338687", -50},
    {8.4549442390727501314059874e-227, "845494423907275", -226},
    {3.1828569525188114531964041e+279, "31828569525188115", 280},
    {6.1156707601690868511488116e-194, "6115670760169087", -193},
    {4.1426819150546480569267576e-70, "4142681915054648", -69},
    {3.6516149260540701731616420e-67, "365161492605407", -66},
    {6.8771986108114977349517901e+43, "6877198610811498", 44},
    {8.3437729627502785828626383e+160, "8343772962750279", 161},
    {4.0070303319994055241320229e-108, "40070303319994055", -107},
    {3.8346320715710995483006129e-214, "38346320715710995", -213},
    {9.2073189070633475952171368e-127, "9207318907063348", -126},
    {1.2243679508574744503910400e+23, "12243679508574745", 24},
    {6.1241826598287582176434844e+88, "6124182659828758", 89},
    {1.1555051863624551707541105e+124, "11555051863624552", 125},
    {1.0042464440189470573552326e+111, "1004246444018947", 112},
    {1.3492486122203610774101356e+228, "1349248612220361", 229},
    {6.1484383147971289418245641e+171, "6148438314797129", 172},
    {1.0917922602894520350906195e+80, "1091792260289452", 81},
    {5.1634862055377761188686793e+278, "5163486205537776", 279},
    {4.2666899299352520195288378e+60, "4266689929935252", 61},
    {5.2243660199206391981836856e-123, "5224366019920639", -122},
    {6.6507591259919704995695611e+00, "66507591259919705", 1},
    {1.3980323899215374090355558e+289, "13980323899215374", 290},
    {1.4899106797816156778894000e-288, "14899106797816157", -287},
    {9.2426089765657587559738060e-94, "9242608976565759", -93},
    {4.4566978739488994363722247e-203, "44566978739488994", -202},
    {3.2157944589339019581322732e-04, "3215794458933902", -3},
    {3.2207233428004095831998528e-70, "32207233428004096", -69},
    {2.4920032943624630272694543e+174, "2492003294362463", 175},
    {1.4623675411046833415113138e+165, "14623675411046833", 166},
    {6.8894417628624905044113619e+135, "688944176286249", 136},
    {4.3400058762842883202825972e+224, "4340005876284288", 225},
    {6.8211721135247267254065450e-63, "6821172113524727", -62},
    {1.5926038679305568654991467e+243, "15926038679305569", 244},
    {1.1620898060822574976985854e-247, "11620898060822575", -246},
    {6.3404929726617238935586040e+131, "6340492972661724", 132},
    {3.8677038249926629095939499e+293, "3867703824992663", 294},
    {4.8181016847220067652435265e+109, "4818101684722007", 110},
    {1.5253338984959568673734829e+168, "15253338984959569", 169},
    {4.4381123639925612465306221e-65, "4438112363992561", -64},
    {4.9640294440692245937651396e-275, "49640294440692246", -274},
    {1.9790099946792774602387341e-247, "19790099946792775", -246},
    {2.6298797770253795859229391e+102, "26298797770253796", 103},
    {4.7962554286097375541274287e+116, "47962554286097376", 117},
    {9.6891382742893648962957023e+218, "9689138274289365", 219},
    {1.2569413673898460585296232e+148, "1256941367389846", 149},
    {2.7331272277147256769838882e+286, "27331272277147257", 287},
    {7.9938327978968575364036484e-197, "7993832797896858", -196},
    {6.9077530545091011411220896e-72, "6907753054509101", -71},
    {3.1474907917961116780789942e-139, "31474907917961117", -138},
    {6.9846989995605750704710982e-305, "6984698999560575", -304},
    {6.1302320897364848782971637e-171, "6130232089736485", -170},
    {1.5023718288907385803558937e-249, "15023718288907386", -248},
    {3.5281191399065270682792862e+195, "3528119139906527", 196},
    {1.0251189275830737500000000e+14, "10251189275830738", 15},
    {1.3707959620096356918442646e-195, "13707959620096357", -194},
    {7.1629433778880004712527607e-05, "7162943377888", -4},
    {2.0854559736631838016156402e+130, "20854559736631838", 131},
    {7.8753384884609716038430473e-13, "7875338488460972", -12},
    {7.8056088587620195094689373e+264, "78056088587620195", 265},
    {1.6216116834032689006844252e-166, "1621611683403269", -165},
    {3.8707253679800868781998066e+244, "3870725367980087", 245},
    {1.1201710078292840589241605e-51, "1120171007829284", -50},
    {8.4113865961374441057074325e-224, "8411386596137444", -223},
    {5.2187071794875975486464550e+167, "5218707179487598", 168},
    {1.1221561467009620826327873e-257, "1122156146700962", -256},
    {2.9056935620065306271823986e-225, "29056935620065306", -224},
    {8.3831138824142496122128217e+266, "838311388241425", 267},
    {4.1497349068154594604498025e+164, "41497349068154595", 165},
    {3.0463742409862029276867777e+88, "3046374240986203", 89},
    {7.0784073021684919102057329e+233, "7078407302168492", 234},
    {1.9989399352536845604005390e-234, "19989399352536846", -233},
    {3.8430357549443778228723717e+244, "3843035754944378", 245},
    {7.3092155073858419861936620e-239, "7309215507385842", -238},
    {5.6569879868352720612881669e-31, "5656987986835272", -30},
    {8.3994764219286560019108531e+32, "8399476421928656", 33},
    {3.5680709545601248951199481e+66, "3568070954560125", 67},
    {1.1231526478261936583110852e+58, "11231526478261937", 59},
    {1.2371238238478237975870252e+231, "12371238238478238", 232},
    {3.5201150166028084042025668e-174, "35201150166028084", -173},
    {1.2934101296612768842611500e+124, "1293410129661277", 125},
    {8.5449284741880283201341213e-222, "8544928474188028", -221},
    {2.1839301180158113141334092e-206, "21839301180158113", -205},
    {2.1509917456457187639420244e-83, "21509917456457188", -82},
    {7.4316838789783101444757605e+125, "743168387897831", 126},
    {6.2343897980251279916257125e-307, "6234389798025128", -306},
    {4.3865226502242964744382752e+294, "43865226502242965", 295},
    {3.3872775268483647991467625e-132, "3387277526848365", -131},
    {2.0983249526587749493395600e+64, "2098324952658775", 65},
    {2.6731296810166026659787088e-293, "26731296810166027", -292},
    {8.1847446231210745494552817e-12, "8184744623121075", -11},
    {1.2764867291699019614702323e+161, "1276486729169902", 162},
    {1.2345480092436014821693859e-97, "12345480092436015", -96},
    {1.2515865367846232270032658e-01, "12515865367846232", 0},
    {1.5659440690509532957852869e+73, "15659440690509533", 74},
    {5.5441600436628388706594706e+05, "5544160043662839", 6},
    {4.9928099274119318675423739e-250, "4992809927411932", -249},
    {1.9109473142211539182088006e-272, "1910947314221154", -271},
    {3.3919277690925924334455530e+225, "33919277690925924", 226},
    {1.3288883922473156727159545e+212, "13288883922473157", 213},
    {1.6769674334261766846371871e-23, "16769674334261767", -22},
    {2.4181914266637855118371078e+39, "24181914266637855", 40},
    {7.0363963825743134099665471e-40, "70363963825743134", -39},
    {5.9347783917503953012434889e-92, "5934778391750395", -91},
    {1.2712417396453596651554108e+07, "12712417396453597", 8},
    {1.3616435386365601228732498e+54, "13616435386365601", 55},
    {5.4927038772904660527706933e-38, "5492703877290466", -37},
    {9.9737774121372415121270594e+203, "9973777412137242", 204},
    {5.2468246533921284012959173e+291, "5246824653392128", 292},
    {5.0890287210601570016751949e-05, "5089028721060157", -4},
    {2.7663518327491048057180871e+221, "2766351832749105", 222},
    {2.3019376598610145293297321e-167, "23019376598610145", -166},
    {6.1403145192178946942801050e+271, "6140314519217895", 272},
    {6.4858771642183675094191781e-52, "64858771642183675", -51},
    {1.7056495684214485720566607e-73, "17056495684214486", -72},
    {3.9893646323746174445105462e-299, "39893646323746174", -298},
    {2.1580618062232941733796887e-162, "21580618062232942", -161},
    {1.4531939562145873747154136e-297, "14531939562145874", -296},
    {4.1486972250796454930721501e-218, "41486972250796455", -217},
    {1.0127835873548030993081439e-266, "10127835873548031", -265},
    {3.0322695016841751173724209e-193, "3032269501684175", -192},
    {1.8362578914546676402846112e-78, "18362578914546676", -77},
    {1.0089916148160329830383024e-263, "1008991614816033", -262},
    {1.9761875023377208436530762e-275, "1976187502337721", -274},
    {6.7709450309918942090270377e-02, "6770945030991894", -1},
    {1.9700392567882407197044164e-302, "19700392567882407", -301},
    {1.6950451907681876223234843e+171, "16950451907681876", 172},
    {1.4806725373928389748880444e+263, "1480672537392839", 264},
    {6.7600401771517308309697387e-236, "6760040177151731", -235},
    {2.7562594766533547790677319e+168, "27562594766533548", 169},
    {2.0355058220795578507930322e-296, "20355058220795579", -295},
    {4.6426526024806454101312846e+156, "46426526024806454", 157},
    {1.7913280306271772669122922e-280, "17913280306271773", -279},
    {1.9017546006208523832440364e+58, "19017546006208524", 59},
    {1.7513175799485854153866686e-06, "17513175799485854", -5},
    {3.7954907209331104891907278e+289, "37954907209331105", 290},
    {5.2510387824465941381207222e+121, "5251038782446594", 122},
    {4.7002775765742512165694236e-278, "4700277576574251", -277},
    {7.2747330840056296513047024e-287, "727473308400563", -286},
    {8.3416488020030323264460601e-142, "8341648802003032", -141},
    {8.8904856885636088148296717e-13, "8890485688563609", -12},
    {1.6827528961955022168694995e+02, "16827528961955022", 3},
    {6.1337239294348633059379579e-57, "6133723929434863", -56},
    {3.3596697954163221178451467e+157, "3359669795416322", 158},
    {1.9209936913172182819673008e-172, "19209936913172183", -171},
    {1.6007853619872017631749671e+164, "16007853619872018", 165},
    {5.1606720203246572440084349e-169, "5160672020324657", -168},
    {1.5315981570775718912209024e-195, "15315981570775719", -194},
    {4.7925451273826343988953579e+192, "4792545127382634", 193},
    {1.5597730987367632827200212e+88, "15597730987367633", 89},
    {5.3309383451576566441986399e-183, "5330938345157657", -182},
    {6.1034879820443981830798121e-253, "6103487982044398", -252},
    {3.1840412224494598126032513e-283, "318404122244946", -282},
    {2.7941952752445885266861513e+222, "27941952752445885", 223},
    {4.9640205750740839368443893e+223, "4964020575074084", 224},
    {3.9193551785536510689498227e-87, "3919355178553651", -86},
    {3.8836340795058838846656598e+234, "3883634079505884", 235},
    {4.1696498515550418393358957e+206, "4169649851555042", 207},
    {2.2350712079478341872543447e+174, "2235071207947834", 175},
    {1.4992810159027787998640757e-101, "14992810159027788", -100},
    {1.5931277531665860977265219e+173, "1593127753166586", 174},
    {1.9333357802093969307055343e+124, "1933335780209397", 125},
    {1.1885045762518267039566898e+124, "11885045762518267", 125},
    {8.5582903199885224627041398e+49, "8558290319988522", 50},
    {3.0407987353673819495691264e-286, "3040798735367382", -285},
    {1.7913472827921016095906451e+128, "17913472827921016", 129},
    {4.3535261489526191744774165e+126, "4353526148952619", 127},
    {3.2960937592709801110250264e-265, "329609375927098", -264},
    {4.4206441762126913157412175e+251, "44206441762126913", 252},
    {1.1303773534952525515109301e+06, "11303773534952526", 7},
    {4.6842869583820586605972539e-37, "4684286958382059", -36},
    {1.2711287054278908691094952e-73, "12711287054278909", -72},
    {3.5719194029229399934408321e+252, "357191940292294", 253},
    {1.0633228435903701398514237e-276, "10633228435903701", -275},
    {3.9173038990480459315493714e+190, "3917303899048046", 191},
    {3.1017819886903955361515556e+209, "31017819886903955", 210},
    {2.1138146509530130456393288e-230, "2113814650953013", -229},
    {4.7169146532094091429066136e+225, "4716914653209409", 226},
    {2.2083325574661339839571649e-212, "2208332557466134", -211},
    {2.4305064487553591968064724e+129, "24305064487553592", 130},
    {4.4983124983808258746334629e+152, "4498312498380826", 153},
    {3.7735713232181828563085925e+183, "3773571323218183", 184},
    {8.1353586009714425058568448e+82, "8135358600971443", 83},
    {1.4635332260148940763826851e+111, "1463533226014894", 112},
    {1.3023901996430522418732315e+92, "13023901996430522", 93},
    {3.3090983273680968747602012e-212, "3309098327368097", -211},
    {2.8094226567560071452448640e+105, "2809422656756007", 106},
    {9.0802821361090856956005998e-216, "9080282136109086", -215},
    {1.4644928503759859068101023e+290, "14644928503759859", 291},
    {5.5234125665168160720691362e-75, "5523412566516816", -74},
    {5.7782487733914776596941675e-64, "57782487733914777", -63},
    {4.9245826305279690137082204e-271, "4924582630527969", -270},
    {1.1400938985628273277375770e-246, "11400938985628273", -245},
    {1.5133461922460444541014797e-149, "15133461922460445", -148},
    {1.8144362250878865536529163e+40, "18144362250878866", 41},
    {1.1941508119590216185912368e-01, "11941508119590216", 0},
    {1.0242942161623132228851318e+08, "10242942161623132", 9},
    {7.1701951737987611325246704e-305, "7170195173798761", -304},
    {4.3508885331278208201195732e+92, "4350888533127821", 93},
    {8.1253727625220644196913556e-268, "8125372762522064", -267},
    {7.6590269841095394872959396e-144, "765902698410954", -143},
    {5.2173691826261489928279476e-42, "5217369182626149", -41},
    {2.8120686230580042968750000e+13, "28120686230580043", 14},
    {3.7188169627909889533274977e+260, "3718816962790989", 261},
    {6.1120568200602709676531261e-59, "6112056820060271", -58},
    {1.1280876459042229529142539e-182, "1128087645904223", -181},
    {6.8555804833509070061551489e-40, "6855580483350907", -39},
    {4.6133183315928850090316892e-186, "4613318331592885", -185},
    {6.7046538160031469368371431e+134, "6704653816003147", 135},
    {1.8892820199074400275107687e-14, "188928201990744", -13},
    {1.6080894169262749051372394e+62, "1608089416926275", 63},
    {1.7957345769131850276915171e-10, "1795734576913185", -9},
    {1.2134643487691305732123384e+286, "12134643487691306", 287},
    {3.8885153727968104305045318e-180, "38885153727968104", -179},
    {1.5549506593798175921655411e+277, "15549506593798176", 278},
    {3.5699856895995510225944658e+70, "3569985689599551", 71},
    {9.3039150618260458861583906e+100, "9303915061826046", 101},
    {9.7366849721221400953974757e+156, "973668497212214", 157},
    {6.4264428509378234463137154e-130, "64264428509378234", -129},
    {1.9672430674052509231814563e+292, "1967243067405251", 293},
    {3.2992843442525948700671932e+219, "3299284344252595", 220},
    {2.0921884094336964989267007e-178, "20921884094336965", -177},
    {4.9737542877807617556284141e+40, "4973754287780762", 41},
    {6.1248914375088565302079612e+99, "6124891437508857", 100},
    {6.1839002829162613326860117e-118, "6183900282916261", -117},
    {9.2125693976611791646208273e+120, "9212569397661179", 121},
    {1.5691106282509040355304694e+66, "1569110628250904", 67},
    {1.6632357196808397965640343e-237, "16632357196808398", -236},
    {3.7570840370255457986199121e-112, "3757084037025546", -111},
    {2.5869201764306185924166190e+162, "25869201764306186", 163},
    {2.3254813599995365632916172e-210, "23254813599995366", -209},
    {7.5722071082727984106186280e-182, "7572207108272798", -181},
    {3.1333797187329482287168503e+07, "31333797187329482", 8},
    {3.4631617151263995522259119e-124, "34631617151263996", -123},
    {4.4505505789300319078630457e+77, "4450550578930032", 78},
    {2.7834468584089507026124721e-02, "27834468584089507", -1},
    {3.0409486047698588070008661e-219, "3040948604769859", -218},
    {1.3269433815228064629554711e+31, "13269433815228065", 32},
    {1.8731342751581068853017129e-207, "1873134275158107", -206},
    {5.9071116087888574289134994e+127, "5907111608788857", 128},
    {8.4433818592320824754127297e-225, "8443381859232082", -224},
    {1.8381844438923066413701318e+288, "18381844438923066", 289},
    {3.0184454657019258305756823e+210, "3018445465701926", 211},
    {1.1508866629115624370068092e+38, "11508866629115624", 39},
    {1.4580894488668100089163358e+60, "145808944886681", 61},
    {1.3294933867595711990192818e-101, "13294933867595712", -100},
    {1.1380627425760601246395270e+64, "11380627425760601", 65},
    {6.5944553385606020314237918e-282, "6594455338560602", -281},
    {2.2533492783192685144749232e+300, "22533492783192685", 301},
    {8.3272035937474822998046875e+08, "8327203593747482", 9},
    {4.4976315458099746393944194e+205, "4497631545809975", 206},
    {4.1094154035530830078508659e+180, "4109415403553083", 181},
    {2.5158271557959386089617595e-17, "25158271557959386", -16},
    {4.1097380387935278035799554e+53, "4109738038793528", 54},
    {1.0010059180553018798828125e+12, "10010059180553019", 13},
    {1.8096831070390827608595784e+133, "18096831070390828", 134},
    {4.3298118658252681942358157e-237, "4329811865825268", -236},
    {2.6820683988334506700451407e-294, "26820683988334507", -293},
    {8.5278840278226518097010482e+96, "8527884027822652", 97},
    {3.4907139843676869451981048e+249, "3490713984367687", 250},
    {1.2192400510683256171213627e+212, "12192400510683256", 213},
    {6.7789682187377429621913096e+283, "6778968218737743", 284},
    {4.6184037774260654480481424e-102, "46184037774260654", -101},
    {2.4900326253680337662587769e-69, "2490032625368034", -68},
    {1.9620780855747686002242430e+217, "19620780855747686", 218},
    {1.2092452008780889374306242e+36, "1209245200878089", 37},
    {2.5021866197127322064201046e+252, "25021866197127322", 253},
    {1.9250437204911822572567714e-279, "19250437204911823", -278},
    {1.0782498783314412060364238e+178, "10782498783314412", 179},
    {1.5063245606455140078603271e+263, "1506324560645514", 264},
    {1.1261631537457284820436152e-173, "11261631537457285", -172},
    {1.5376488406421243166999805e-20, "15376488406421243", -19},
    {4.8326360967323080502984531e+291, "4832636096732308", 292},
    {7.3951863160313736733573102e-275, "7395186316031374", -274},
    {7.2641508539628946694628057e-75, "7264150853962895", -74},
    {1.5900081838080843964730734e+263, "15900081838080844", 264},
    {1.5375881046216687992581913e+184, "15375881046216688", 185},
    {7.0365050428380789934467527e+117, "7036505042838079", 118},
    {3.5208652321994970851983292e-160, "3520865232199497", -159},
    {2.2698023301905779138444193e+72, "2269802330190578", 73},
    {8.9937377521973452857107760e+190, "8993737752197345", 191},
    {3.3623388973026288317021935e-306, "3362338897302629", -305},
    {7.2565587727376961169056813e+00, "7256558772737696", 1},
    {6.0841627137060631574996356e-14, "6084162713706063", -13},
    {1.2255149725452948447696401e+104, "12255149725452948", 105},
    {1.1950552297790469651644483e-246, "1195055229779047", -245},
    {1.0557126844758346065811819e-128, "10557126844758346", -127},
    {5.9979267281865554783969781e-175, "5997926728186555", -174},
    {8.5261154335488114341723758e+169, "8526115433548811", 170},
    {3.2943684623977164032965096e+257, "32943684623977164", 258},
    {2.9636262716979234609138736e-137, "29636262716979235", -136},
    {1.4901452558877062250342428e+249, "14901452558877062", 250},
    {2.0409406153914362684065417e-51, "20409406153914363", -50},
    {3.1638920326346707679649609e-293, "3163892032634671", -292},
    {1.0787221589313895476139427e-180, "10787221589313895", -179},
    {6.1218210091280898728664447e-06, "612182100912809", -5},
    {1.5309748755056345085220013e+186, "15309748755056345", 187},
    {7.5336942222891894505832322e+291, "753369422228919", 292},
    {3.8058003828402487455925897e-22, "38058003828402487", -21},
    {2.5741343878867646490932212e+86, "25741343878867646", 87},
    {2.9643788985265650907389343e+66, "2964378898526565", 67},
    {3.4344539944242660472693200e-297, "3434453994424266", -296},
    {1.2075927997492895236891557e-260, "12075927997492895", -259},
    {6.6271651667618755650920661e+115, "6627165166761876", 116},
    {9.7587493210787819896638972e+142, "9758749321078782", 143},
    {1.6535582290304309081054506e-174, "1653558229030431", -173},
    {1.2258673125709878228650328e+124, "12258673125709878", 125},
    {1.1900071311323810449151068e+236, "1190007131132381", 237},
    {2.7152766835289521887152207e+80, "2715276683528952", 81},
    {2.8672698767264375249175083e-240, "28672698767264375", -239},
    {1.0354836842491846905481742e-12, "10354836842491847", -11},
    {7.3537540538557473951937433e-65, "7353754053855747", -64},
    {1.6790303661406536572219255e-07, "16790303661406537", -6},
    {7.6726474406340755193856000e+22, "7672647440634076", 23},
    {1.1835778544008184303999901e-190, "11835778544008184", -189},
    {7.7400261093398379118843973e+184, "7740026109339838", 185},
    {7.5418154350165400009124478e+242, "754181543501654", 243},
    {1.0195579651538951786475663e-266, "10195579651538952", -265},
    {6.1441696519997900155512525e+94, "614416965199979", 95},
    {8.1576186754855936755269098e-156, "8157618675485594", -155},
    {4.3910138212435159133299490e-75, "4391013821243516", -74},
    {1.7168274030916461837487880e+245, "17168274030916462", 246},
    {2.3116495180891688360362478e+302, "2311649518089169", 303},
    {1.3216260865587141008914840e+95, "13216260865587141", 96},
    {3.2436565751615091557005121e+187, "3243656575161509", 188},
    {3.5194596654612065448841193e+278, "35194596654612065", 279},
    {2.5502852581114855134117543e+78, "25502852581114855", 79},
    {3.3422307979348030059437880e+181, "3342230797934803", 182},
    {5.6137345522030624337526509e-244, "56137345522030624", -243},
    {1.3606737205812535904752523e-250, "13606737205812536", -249},
    {1.1870081012151778780832467e-275, "11870081012151779", -274},
    {1.3242558949552861352698922e+157, "13242558949552861", 158},
    {8.5422768404952069138950016e+192, "8542276840495207", 193},
    {9.0327756595313168770209686e-36, "9032775659531317", -35},
    {3.1855602803831988921350358e-74, "3185560280383199", -73},
    {2.1386689020440580556396157e+87, "2138668902044058", 88},
    {1.0903514873596853640947571e-292, "10903514873596854", -291},
    {1.7783972882918643641074088e-245, "17783972882918644", -244},
    {4.2815368760839657369174425e-148, "4281536876083966", -147},
    {1.7551067660356780775698509e-96, "1755106766035678", -95},
    {8.6316020855446122119225160e-99, "8631602085544612", -98},
    {1.6299209949195310695950509e-164, "1629920994919531", -163},
    {1.2215413980458960539781135e+167, "1221541398045896", 168},
    {1.0511960120746382549353940e+284, "10511960120746383", 285},
    {3.0601264770277686448044111e+130, "30601264770277686", 131},
    {1.2185042229003172233865490e+120, "12185042229003172", 121},
    {1.7199439648016563668157858e-244, "17199439648016564", -243},
    {2.2269900608139566497177726e-184, "22269900608139566", -183},
    {1.7594126655462812649073593e+245, "17594126655462813", 246},
    {1.1077427044076860062034879e+269, "1107742704407686", 270},
    {7.2854814751239085555870957e+192, "7285481475123909", 193},
    {9.4003736243080790554141209e-260, "9400373624308079", -259},
    {2.5074053776531392941251397e+04, "25074053776531393", 5},
    {4.0565813392718387245643431e+144, "4056581339271839", 145},
    {7.0255433641710712129741875e+247, "7025543364171071", 248},
    {3.2428398914291959367040353e-159, "3242839891429196", -158},
    {9.9512463703701345940328541e-43, "9951246370370135", -42},
    {5.0491010547487819484364800e+23, "5049101054748782", 24},
    {1.2004506749001401489993710e+262, "12004506749001401", 263},
    {6.3471087767303293426573171e+84, "6347108776730329", 85},
    {1.3725790804056111162686941e-216, "13725790804056111", -215},
    {1.1314566242369712334001371e-66, "11314566242369712", -65},
    {2.7097985446771484583502326e-187, "27097985446771485", -186},
    {4.4504234154012762365497289e-116, "4450423415401276", -115},
    {9.7504341259756393026917168e-179, "9750434125975639", -178},
    {4.0294854179021499582912472e-252, "402948541790215", -251},
    {6.1537767073873815082949147e-263, "61537767073873815", -262},
    {4.1009127939479388026097663e+110, "4100912793947939", 111},
    {1.8442723196950839551006190e+303, "1844272319695084", 304},
    {3.1535748004369686794727513e+293, "31535748004369687", 294},
    {1.1001174442068454975503872e-21, "11001174442068455", -20},
    {9.6054683539474318119082861e-290, "9605468353947432", -289},
    {4.9753878302952917538190298e+264, "4975387830295292", 265},
    {2.1740946146492093994911940e+248, "21740946146492094", 249},
    {6.3669997826717464328716289e-02, "6366999782671746", -1},
    {1.0154952733994010000410816e+101, "1015495273399401", 102},
    {1.8668950339581889545535050e+272, "1866895033958189", 273},
    {1.0500223436097463727010545e+286, "10500223436097464", 287},
    {9.7928898158433643402531743e+04, "9792889815843364", 5},
    {6.1764027544419101562500000e+12, "617640275444191", 13},
    {4.0920897394744985435847610e-134, "40920897394744985", -133},
    {2.8462860695110168188509738e+40, "2846286069511017", 41},
    {6.6211453657825730737773894e-249, "6621145365782573", -248},
    {8.4183864442561942294812569e-111, "8418386444256194", -110},
    {7.3937631713959686576603771e-144, "7393763171395969", -143},
    {3.0811543313467375722297009e-205, "30811543313467376", -204},
    {9.2672403049846561669183882e-146, "9267240304984656", -145},
    {2.7216477177502443050342330e-62, "27216477177502443", -61},
    {2.9497598366309704659940756e-210, "29497598366309705", -209},
    {3.1838603603935107083984133e-234, "31838603603935107", -233},
    {3.1884400811381064315156373e-81, "31884400811381064", -80},
    {3.1249006193530672881308874e+00, "31249006193530673", 1},
    {2.9665192584492600237318984e+48, "296651925844926", 49},
    {9.9583192033460475693678940e+204, "9958319203346048", 205},
    {8.7401933378650968166052463e-70, "8740193337865097", -69},
    {4.9341471686674995845901457e+65, "49341471686675", 66},
    {5.2797963443500980306595591e-49, "5279796344350098", -48},
    {8.4942945592910804250222448e+234, "849429455929108", 235},
    {2.0503681378011906198700933e+142, "20503681378011906", 143},
    {1.8011598379646640685725043e-242, "1801159837964664", -241},
    {1.1203035901751855322469839e+84, "11203035901751855", 85},
    {9.5504497854318471537095956e-170, "9550449785431847", -169},
    {1.0533615432355620219412128e+174, "1053361543235562", 175},
    {1.3505758775717654545858556e+48, "13505758775717655", 49},
    {1.6245262039924463235834645e-121, "16245262039924463", -120},
    {1.0080374283743060915820642e-121, "1008037428374306", -120},
    {6.5630101264210065028073097e+167, "6563010126421007", 168},
    {3.3842328810164890779422074e+152, "3384232881016489", 153},
    {7.8546498596949081674095618e-197, "7854649859694908", -196},
    {6.4870569297471947963894289e-254, "6487056929747195", -253},
    {1.3146491673228000602261229e+249, "13146491673228", 250},
    {2.7526582866655514129834493e-158, "27526582866655514", -157},
    {1.3813271140347626365827993e+29, "13813271140347626", 30},
    {6.7926402757775128179362298e+276, "6792640275777513", 277},
    {1.9339352472795442835770122e-218, "19339352472795443", -217},
    {7.8033447798906357759535765e+184, "7803344779890636", 185},
    {1.4533531001183489240147742e+110, "1453353100118349", 111},
    {1.0465481741418472942535572e+91, "10465481741418473", 92},
    {1.8952600181933604516278544e-295, "18952600181933605", -294},
    {3.7726973367438838271937909e+243, "3772697336743884", 244},
    {1.2791548267345198944548251e+178, "12791548267345199", 179},
    {6.5340809444043342960157351e+162, "6534080944404334", 163},
    {1.9711854900851263728420904e-22, "19711854900851264", -21},
    {7.3743162253830145814089707e+229, "7374316225383015", 230},
    {1.2196978728215853164366929e-66, "12196978728215853", -65},
    {4.3601702322938959987484077e+150, "4360170232293896", 151},
    {9.5646705611477931772428325e-84, "9564670561147793", -83},
    {2.4684513395986046576201615e-48, "24684513395986047", -47},
    {3.3062629434746769151462623e-171, "3306262943474677", -170},
    {1.6447439800219148998222807e+214, "1644743980021915", 215},
    {1.4706194212292278446068520e-269, "14706194212292278", -268},
    {2.3121877693259557541324233e+128, "23121877693259558", 129},
    {9.2890134202936313139889660e+280, "9289013420293631", 281},
    {1.6178066045074087888354975e+280, "16178066045074088", 281},
    {1.3133049685107234432436517e-79, "13133049685107234", -78},
    {4.5679107705896193377462368e+241, "45679107705896193", 242},
    {3.2641481944171138988657536e+168, "3264148194417114", 169},
    {4.5389303839523961698407474e+278, "4538930383952396", 279},
    {7.7610324094674194214353030e-128, "7761032409467419", -127},
    {3.7476033065413951619072000e+22, "3747603306541395", 23},
    {1.8222243636983956766184039e-166, "18222243636983957", -165},
    {1.8601083809079626952679345e-252, "18601083809079627", -251},
    {3.6606294692568829300180122e-42, "3660629469256883", -41},
    {1.5121904137286259792745113e+06, "1512190413728626", 7},
    {2.7946574467327669108834044e+234, "2794657446732767", 235},
    {5.7479797662370905938803566e+139, "5747979766237091", 140},
    {9.9504002842264804775872385e-225, "995040028422648", -224},
    {1.3726218028935591573495032e-116, "13726218028935592", -115},
    {4.2688959415990163188222491e-269, "4268895941599016", -268},
    {3.9746816109365013533092390e-84, "39746816109365014", -83},
    {2.4019146395745821072218969e+92, "2401914639574582", 93},
    {1.4186114847621022453930139e-101, "14186114847621022", -100},
    {2.1853535871417464191854344e-218, "21853535871417464", -217},
    {4.8405358377531912743704711e+46, "4840535837753191", 47},
    {6.3164282629785872112274298e-34, "6316428262978587", -33},
    {4.9280698955801191056149295e+220, "4928069895580119", 221},
    {1.7812412482162703343117198e+167, "17812412482162703", 168},
    {7.4970667687905459089814728e-268, "7497066768790546", -267},
    {7.4794654435365606477619121e+135, "7479465443536561", 136},
    {1.0406326180702414525878296e+90, "10406326180702415", 91},
    {3.4522921373949406593171382e+71, "34522921373949407", 72},
    {1.2998121014783758138559232e+294, "12998121014783758", 295},
    {4.3381076954245282800157508e+103, "4338107695424528", 104},
    {3.6280392873497133156772035e-93, "36280392873497133", -92},
    {1.3233685819732971579873525e-86, "13233685819732972", -85},
    {1.5283997321258060077315995e-222, "1528399732125806", -221},
    {1.8952281443264232773615606e+239, "18952281443264233", 240},
    {1.6430749448610908411743267e+62, "16430749448610908", 63},
    {2.8377404481871366024569798e-264, "28377404481871366", -263},
    {3.5432874039335989838224237e+165, "3543287403933599", 166},
    {6.8769796273536092336798400e-36, "6876979627353609", -35},
    {2.4998015320263251165807040e-111, "2499801532026325", -110},
    {6.3821578116325895051808908e+57, "638215781163259", 58},
    {7.9949723806010583153216833e-217, "7994972380601058", -216},
    {2.8176883436796557617792687e+64, "2817688343679656", 65},
    {5.7604488984671055650018437e-300, "57604488984671056", -299},
    {2.8829537794537223927644009e+135, "28829537794537224", 136},
    {1.7759480569407245767592205e-175, "17759480569407246", -174},
    {2.3056244044506030707712588e+117, "2305624404450603", 118},
    {1.5042800735533037621296275e+85, "15042800735533038", 86},
    {1.6899455457374140014118212e+97, "1689945545737414", 98},
    {6.7457075164675868655973826e+72, "6745707516467587", 73},
    {9.5845246422782819574595003e-280, "9584524642278282", -279},
    {1.7556134781009300677459968e+25, "175561347810093", 26},
    {2.6029013134649309841255665e-244, "2602901313464931", -243},
    {6.7479937586875616807592699e-234, "6747993758687562", -233},
    {2.4222658756627943419492536e-46, "24222658756627943", -45},
    {3.9908174113734802822521495e-308, "39908174113734803", -307},
    {5.8575678116327250198528000e+22, "5857567811632725", 23},
    {6.9747107169823022758765136e+60, "6974710716982302", 61},
    {2.3354803917061078260835241e+173, "23354803917061078", 174},
    {3.3574715398075298070684285e+176, "335747153980753", 177},
    {1.1259195482699664735347505e-198, "11259195482699665", -197},
    {3.8364501953458377541433883e-30, "3836450195345838", -29},
    {1.6966856928173477889434482e-76, "16966856928173478", -75},
    {3.7243759195334317945708385e-162, "3724375919533432", -161},
    {1.5247892967444660598603377e-99, "1524789296744466", -98},
    {8.9918055351681947081540746e+277, "8991805535168195", 278},
    {1.2242491247414505430178890e+270, "12242491247414505", 271},
    {6.4222641746444781733041322e-113, "6422264174644478", -112},
    {4.1620179666114167854747968e-243, "4162017966611417", -242},
    {5.3641522570989200175972655e+03, "536415225709892", 4},
    {2.3405603809622894258909331e+100, "23405603809622894", 101},
    {2.8265405250330690464455544e+141, "2826540525033069", 142},
    {3.0998094546826664682562939e-44, "30998094546826665", -43},
    {1.1326439627325960934950730e-11, "11326439627325961", -10},
    {7.9270570742774741557476605e+202, "7927057074277474", 203},
    {1.0768167088995977019536641e-285, "10768167088995977", -284},
    {8.9774121180024628994557379e+149, "8977412118002463", 150},
    {1.0113124045159803085407144e+198, "10113124045159803", 199},
    {6.5480304408148245131615794e+35, "65480304408148245", 36},
    {1.5234970069030311601571707e+177, "15234970069030312", 178},
    {5.3398622903482751538759778e-208, "5339862290348275", -207},
    {1.4528121112295611854010761e-156, "14528121112295612", -155},
    {9.9865202213500026363618023e-290, "9986520221350003", -289},
    {4.8906903400534659600057644e-199, "4890690340053466", -198},
    {1.5194520165473282510526737e+252, "15194520165473283", 253},
    {8.4797258846606416021492021e-159, "8479725884660642", -158},
    {7.0712402209412776131343016e-130, "7071240220941278", -129},
    {2.6795287685206036724239362e+98, "26795287685206037", 99},
    {4.3706590762611484105679295e+303, "43706590762611484", 304},
    {3.7990655985681569366010757e+27, "3799065598568157", 28},
    {3.2632129104247254380862319e-115, "32632129104247254", -114},
    {8.6414499060052889071494031e-05, "8641449906005289", -4},
    {1.0425652034901670172183344e-221, "1042565203490167", -220},
    {8.4872369857344184442042569e-110, "8487236985734418", -109},
    {2.6807642879869331454839852e+266, "2680764287986933", 267},
    {2.9246687268240315826210800e+233, "29246687268240316", 234},
    {9.5265926767097592084543984e-101, "9526592676709759", -100},
    {4.6833763246996281824032567e-78, "4683376324699628", -77},
    {3.8085977732425004807433895e-137, "38085977732425005", -136},
    {1.0404438537521536255980345e+307, "10404438537521536", 308},
    {3.6872466476543227112469339e+78, "36872466476543227", 79},
    {4.4877320566442908254320689e-197, "4487732056644291", -196},
    {1.0401931363705238264400814e+228, "10401931363705238", 229},
    {7.5955162624568944000000000e+16, "7595516262456894", 17},
    {8.9415842387917732990136060e-76, "8941584238791773", -75},
    {4.1692481672598174380305108e+137, "41692481672598174", 138},
    {6.5463130057440926650648630e-164, "6546313005744093", -163},
    {2.1728883948439960938555268e+184, "2172888394843996", 185},
    {8.0113636702532454449004538e+73, "8011363670253245", 74},
    {2.3293818851753715796248351e+108, "23293818851753716", 109},
    {5.8103998755801322121718637e+183, "5810399875580132", 184},
    {9.6749223930040392681246036e+218, "967492239300404", 219},
    {1.6332081788400338024678767e-197, "16332081788400338", -196},
    {1.8620760879526340233724117e+280, "1862076087952634", 281},
    {6.3469798565195839221316475e+202, "6346979856519584", 203},
    {2.1254439768141819513402879e+04, "2125443976814182", 5},
    {8.4086860159075650445128324e-16, "8408686015907565", -15},
    {1.5143443787358443570302751e+69, "15143443787358444", 70},
    {7.9887072179957911169571062e+31, "7988707217995791", 32},
    {5.1689376762683632601692545e-15, "5168937676268363", -14},
    {1.3958045915693901474940716e+137, "13958045915693901", 138},
    {1.1111357254919099538550128e-69, "111113572549191", -68},
    {1.2417869703028717985318838e+161, "12417869703028718", 162},
    {1.1982174343848530477956723e+117, "1198217434384853", 118},
    {3.2335053240123388186024234e+223, "3233505324012339", 224},
    {1.3953830836636331203163383e-286, "13953830836636331", -285},
    {8.0890227241009793739259497e-308, "8089022724100979", -307},
    {9.3069637026133462574469935e+51, "9306963702613346", 52},
    {5.8528595555915677310424855e-248, "5852859555591568", -247},
    {3.8788634120520307257427381e-80, "3878863412052031", -79},
    {2.6602592265806257106733808e-205, "26602592265806257", -204},
    {2.1546696945233593937814611e+173, "21546696945233594", 174},
    {5.5927926357424715047470747e-39, "55927926357424715", -38},
    {4.8731179545627336554355300e-190, "4873117954562734", -189},
    {1.2616537840625258434065369e-62, "12616537840625258", -61},
    {3.9423597040124894958289240e-37, "39423597040124895", -36},
    {1.0235159601446300818874746e-231, "10235159601446301", -230},
    {3.3548449178575277321265472e+47, "33548449178575277", 48},
    {3.9122928559833989588052577e-86, "3912292855983399", -85},
    {6.8663664912321221397201161e+95, "6866366491232122", 96},
    {1.2570650085863859119192504e-224, "1257065008586386", -223},
    {3.3338901501719749416835884e+124, "3333890150171975", 125},
    {1.7037671289499772524168862e+133, "17037671289499773", 134},
    {3.0531228698047868726378811e+174, "3053122869804787", 175},
    {4.6001063007609171766736206e-107, "4600106300760917", -106},
    {5.0801125426121110866623208e-54, "5080112542612111", -53},
    {1.1531876135809136617841466e+160, "11531876135809137", 161},
    {5.0416120340708464781204312e+303, "50416120340708465", 304},
    {4.2301359293037949552594320e-301, "4230135929303795", -300},
    {9.4080924435995112521779471e-110, "9408092443599511", -109},
    {5.3978770779048674492044416e-165, "5397877077904867", -164},
    {2.4851426838465489952587021e-85, "2485142683846549", -84},
    {1.0014384978780857176238087e-270, "10014384978780857", -269},
    {2.6273543158700797075758376e+166, "26273543158700797", 167},
    {1.3635956888135145615016088e+204, "13635956888135146", 205},
    {9.6484447542491024668567903e-29, "9648444754249102", -28},
    {5.0116319180288921149876617e-62, "5011631918028892", -61},
    {1.4243590582868831744059935e+71, "14243590582868832", 72},
    {9.0067047936386829869418485e+164, "9006704793638683", 165},
    {2.1720850672997328035133632e-163, "21720850672997328", -162},
    {1.3056344707532763928521706e+296, "13056344707532764", 297},
    {5.7929889835814347076505916e+236, "5792988983581435", 237},
    {2.5426936686868742754086270e+01, "25426936686868743", 2},
    {6.1536651895131092424228986e-94, "6153665189513109", -93},
    {9.6018821576509201428653237e-06, "960188215765092", -5},
    {2.1831342646381432030722013e-95, "21831342646381432", -94},
    {3.1231558459693832715650353e+283, "31231558459693833", 284},
    {2.3834638492808123304732748e-279, "23834638492808123", -278},
    {6.5281047196168422081872346e+141, "6528104719616842", 142},
    {1.1308934729004637460199794e+202, "11308934729004637", 203},
    {4.6577137749449088466481178e-163, "4657713774944909", -162},
    {7.7300863370111923841981194e+250, "7730086337011192", 251},
    {3.5776737020907523179597361e-38, "35776737020907523", -37},
    {1.4802581553471476009248009e+69, "14802581553471476", 70},
    {6.7550207548891886691575806e-278, "6755020754889189", -277},
    {5.2009830131816358543891393e-222, "5200983013181636", -221},
    {2.6278804650501719040000000e+18, "2627880465050172", 19},
    {3.4582987971483178045049782e+126, "3458298797148318", 127},
    {3.0391310529070296556746358e+175, "30391310529070297", 176},
    {6.8014448196124634364091933e-167, "6801444819612463", -166},
    {2.8050211097131994261892121e-52, "28050211097131994", -51},
    {1.2523595925968426126497841e+86, "12523595925968426", 87},
    {3.7220103058354581287602663e-65, "3722010305835458", -64},
    {3.6280600508038836269483658e-120, "36280600508038836", -119},
    {3.8226189127783535929880064e+252, "38226189127783536", 253},
    {1.7369424051000073918986073e+159, "17369424051000074", 160},
    {2.3724632582564445689384935e-283, "23724632582564446", -282},
    {8.6865738118302169294238173e+145, "8686573811830217", 146},
    {4.0860478266629683126071552e-44, "40860478266629683", -43},
    {1.2132300486880666595481462e-264, "12132300486880667", -263},
    {1.2512479628311719934206972e-43, "1251247962831172", -42},
    {8.5251302559105415157343563e-248, "8525130255910542", -247},
    {7.3972863425011110643202128e-05, "7397286342501111", -4},
    {2.7595394147228421671284234e-257, "2759539414722842", -256},
    {7.6001292887742874766342656e+219, "7600129288774287", 220},
    {2.0766933487627472817002657e+286, "20766933487627473", 287},
    {1.4301698571815975613673276e+246, "14301698571815976", 247},
    {1.8420574400012705691771624e+242, "18420574400012706", 243},
    {1.4999847344740272746118960e+272, "14999847344740273", 273},
    {6.1346426582105465265720546e+220, "6134642658210547", 221},
    {1.4215484300206774303682393e+194, "14215484300206774", 195},
    {5.6978018756435727365456841e-174, "5697801875643573", -173},
    {1.5506710368791246225067144e+193, "15506710368791246", 194},
    {7.9551910559667800305344691e+34, "795519105596678", 35},
    {4.1970988703693607244767530e+251, "41970988703693607", 252},
    {3.6325835856351758104873523e-176, "3632583585635176", -175},
    {1.4106058777303898121857628e+00, "14106058777303898", 1},
    {2.0342526196750139365945697e-53, "2034252619675014", -52},
    {1.2588652861025573484417496e+140, "12588652861025573", 141},
    {6.5006477010633367930863455e-174, "6500647701063337", -173},
    {7.9720780928398681864039780e+250, "7972078092839868", 251},
    {2.7979358679530772557995880e-155, "27979358679530773", -154},
    {2.9867797259345275825590076e-14, "29867797259345276", -13},
    {8.1588919647857521570085209e+141, "8158891964785752", 142},
    {2.6345801109393296362729136e+172, "26345801109393296", 173},
    {6.5688054893838406037537891e+39, "656880548938384", 40},
    {8.6191998263505700552556322e+197, "861919982635057", 198},
    {2.7220047579375083641150938e-150, "27220047579375084", -149},
    {1.4264724176043053145965285e-281, "14264724176043053", -280},
    {3.8050304129431964077149166e+263, "38050304129431964", 264},
    {7.2985653327853625726111662e+195, "7298565332785363", 196},
    {1.4651307470127788649469626e+113, "14651307470127789", 114},
    {3.3496395442238105696367837e+242, "33496395442238106", 243},
    {5.2237042193632326880619773e-152, "5223704219363233", -151},
    {2.2274626298033217790417635e-287, "22274626298033218", -286},
    {1.6202590274846860890318976e-95, "1620259027484686", -94},
    {2.1760333637153931924553487e+71, "21760333637153932", 72},
    {1.5891234622227754021638739e+194, "15891234622227754", 195},
    {3.5262872529079328125000000e+13, "3526287252907933", 14},
    {2.5471473920471145382504310e-204, "25471473920471145", -203},
    {4.8185579685528124006231092e+227, "4818557968552812", 228},
    {6.7539947284766625305517333e+264, "67539947284766625", 265},
    {3.8240460581117590684814474e-90, "3824046058111759", -89},
    {2.0557622466455474576125635e-92, "20557622466455475", -91},
    {1.1448652702538497703736313e+83, "11448652702538498", 84},
    {3.1993741887437735138575045e-199, "31993741887437735", -198},
    {3.9833602921958489013088880e-70, "3983360292195849", -69},
    {8.8541125260780210630834780e-29, "8854112526078021", -28},
    {3.9815096236145117949466389e-205, "3981509623614512", -204},
    {4.8441194507035929937851282e-206, "4844119450703593", -205},
    {3.3761331827455647169921991e+289, "33761331827455647", 290},
    {2.8829166399198684054545928e-307, "28829166399198684", -306},
    {1.3683611180575341573153078e-18, "13683611180575342", -17},
    {3.2600425774133043020312673e+148, "32600425774133043", 149},
    {8.1834605692745676016715671e+291, "8183460569274568", 292},
    {1.2465531073343788648344344e+02, "12465531073343789", 3},
    {1.1926954476360688335476851e-118, "11926954476360688", -117},
    {4.6157181847416162488780547e-88, "4615718184741616", -87},
    {2.7560159713009492587255741e-08, "27560159713009493", -7},
    {2.3739013557586565016383526e+218, "23739013557586565", 219},
    {4.3992410699577593483214360e-84, "4399241069957759", -83},
    {4.6596579782939755680658217e+62, "4659657978293976", 63},
    {8.0238731142600924172119731e-165, "8023873114260092", -164},
    {3.9693618349154204787731111e+248, "39693618349154205", 249},
    {1.4315531913150153265261209e+174, "14315531913150153", 175},
    {4.6708240083028019308158512e-105, "4670824008302802", -104},
    {4.6350798276287340733447216e-235, "4635079827628734", -234},
    {5.2170937536397393719796589e-115, "5217093753639739", -114},
    {3.0762184576377856779508333e-130, "30762184576377857", -129},
    {8.7663909138399783568373169e-51, "8766390913839978", -50},
    {8.9285135109777084692899105e-25, "8928513510977708", -24},
    {1.7790142535657016184563688e+61, "17790142535657016", 62},
    {6.5918841075690706062243453e-208, "6591884107569071", -207},
    {1.8531729134040194854196407e-12, "18531729134040195", -11},
    {3.0429912360904916033318060e-183, "30429912360904916", -182},
    {1.3645606885495547950139516e-178, "13645606885495548", -177},
    {3.0856038668728574181305911e-11, "30856038668728574", -10},
    {1.1719425072910557259613049e-24, "11719425072910557", -23},
    {1.9837213418863764058925413e+278, "19837213418863764", 279},
    {9.4090046768912832808595681e-02, "9409004676891283", -1},
    {4.5019598876377953668524561e-302, "45019598876377954", -301},
    {9.9663861652122948771170784e-305, "9966386165212295", -304},
    {6.8766755976776410747176755e-233, "6876675597677641", -232},
    {1.0201990418358300409999592e-216, "102019904183583", -215},
    {8.3869653629479811693916221e+44, "8386965362947981", 45},
    {5.7025316426288208421438095e+27, "5702531642628821", 28},
    {1.2443871299057722821413926e-298, "12443871299057723", -297},
    {1.9037622664465612876238226e+213, "19037622664465613", 214},
    {9.1777212878291831514726400e+23, "9177721287829183", 24},
    {1.1783590282047182952829277e-73, "11783590282047183", -72},
    {3.0139292482872153517422376e+280, "30139292482872154", 281},
    {4.9603119727721014693736033e+284, "49603119727721015", 285},
    {2.5782193245419478777778995e-66, "2578219324541948", -65},
    {3.9206149296464573184676292e-266, "3920614929646457", -265},
    {9.5720086809876532397160643e-26, "9572008680987653", -25},
    {1.0027377039870293292790354e-210, "10027377039870293", -209},
    {2.4934211398755259128284898e+235, "2493421139875526", 236},
    {3.3997825218637419629114856e+161, "3399782521863742", 162},
    {9.6966889541793247842301555e-184, "9696688954179325", -183},
    {5.4116286526607703397903477e+263, "541162865266077", 264},
    {3.9790902257677760541976091e+225, "3979090225767776", 226},
    {3.2684600224962781768300378e-52, "3268460022496278", -51},
    {2.7634723607007133090512842e-229, "27634723607007133", -228},
    {1.2847726500091758564412551e-179, "12847726500091759", -178},
    {1.1190892614447534707628180e+95, "11190892614447535", 96},
    {2.2939944549733919059263087e-139, "2293994454973392", -138},
    {1.2308617513383697179347675e+93, "12308617513383697", 94},
    {1.6406854020165094545758615e+37, "16406854020165095", 38},
    {7.7146134021899920524121888e-283, "7714613402189992", -282},
    {1.8426524052082687244248413e-104, "18426524052082687", -103},
    {2.7593102251726512894448279e+109, "27593102251726513", 110},
    {2.1943533917061218613065736e-111, "2194353391706122", -110},
    {1.3892774607617381189539077e+304, "1389277460761738", 305},
    {5.7078340609516415319522843e-69, "5707834060951642", -68},
    {6.0747218865329672607642101e-157, "6074721886532967", -156},
    {3.6781836669176088505253037e+201, "3678183666917609", 202},
    {2.4300523671864231470259139e-302, "2430052367186423", -301},
    {2.6962274045169434778283787e-231, "26962274045169435", -230},
    {8.8061697541690299127217171e-09, "880616975416903", -8},
    {7.2051833370645451766825370e+146, "7205183337064545", 147},
    {9.4666471120704972275794906e-35, "9466647112070497", -34},
    {5.6284149828746194039212229e+170, "5628414982874619", 171},
    {1.6820415649043967669646945e+289, "16820415649043968", 290},
    {5.5101128492255528736320810e+234, "5510112849225553", 235},
    {1.1543143325110263762125413e+73, "11543143325110264", 74},
    {1.1591878313288584332750302e-116, "11591878313288584", -115},
    {9.0385208956796400356463461e+44, "903852089567964", 45},
    {4.6164622707092791795730591e+07, "4616462270709279", 8},
    {1.5678937880100143432617188e+11, "15678937880100143", 12},
    {1.0201222744549423162164852e+105, "10201222744549423", 106},
    {1.8633013127628788809798412e+165, "1863301312762879", 166},
    {5.1397725087420342893890204e+305, "5139772508742034", 306},
    {1.1002751403302639619575349e+70, "1100275140330264", 71},
    {1.0318442493417856440054612e-07, "10318442493417856", -6},
    {7.3444711583823457255652921e+232, "7344471158382346", 233},
    {8.4343783937302531432826180e+244, "8434378393730253", 245},
    {2.2810647933863900522111531e+187, "228106479338639", 188},
    {3.6675745118443340531499659e+271, "3667574511844334", 272},
    {1.8385262039844872377519600e-11, "18385262039844872", -10},
    {2.0581751034114433871158265e+137, "20581751034114434", 138},
    {3.5840009967180681092845624e+124, "3584000996718068", 125},
    {1.0337696813159386454309015e-252, "10337696813159386", -251},
    {3.4099146905270088050366895e-216, "3409914690527009", -215},
    {5.6935578444684384655489184e+292, "56935578444684385", 293},
    {4.0773142736574117925826371e+232, "4077314273657412", 233},
    {1.1098010096103826525629893e-126, "11098010096103827", -125},
    {4.7431784340063674924412754e-30, "47431784340063675", -29},
    {4.1966304535684557884300263e+38, "4196630453568456", 39},
    {1.9039653163981348419257758e-215, "19039653163981348", -214},
    {1.5720259329155585599610955e-303, "15720259329155586", -302},
    {3.1343249914426261625087039e-145, "3134324991442626", -144},
    {5.4734096017792380060575540e+176, "5473409601779238", 177},
    {6.2059741582298081596094031e-28, "6205974158229808", -27},
    {1.0161249726279773543114673e-87, "10161249726279774", -86},
    {1.6228955586199255811629933e+291, "16228955586199256", 292},
    {2.0452347516668213127522008e+111, "20452347516668213", 112},
    {9.1441227948727045032272302e-285, "9144122794872705", -284},
    {5.3517923191829090000000000e+15, "5351792319182909", 16},
    {7.5542231471588938438332808e+291, "7554223147158894", 292},
    {2.4264407183173659671355923e-271, "2426440718317366", -270},
    {2.4240985944155052258901228e-08, "24240985944155052", -7},
    {4.7905103076957861328125000e+12, "4790510307695786", 13},
    {2.0152461162939860297407928e-82, "2015246116293986", -81},
    {2.5006154607462756250000000e+14, "25006154607462756", 15},
    {6.3709237766916602631118666e+155, "637092377669166", 156},
    {7.6221680070161693222616868e+161, "7622168007016169", 162},
    {3.6334215820810798035436985e+92, "363342158208108", 93},
    {1.3095035557756808868671113e-23, "13095035557756809", -22},
    {1.4994311576040500564551916e-69, "149943115760405", -68},
    {3.0356588399527189972573031e+131, "3035658839952719", 132},
    {5.7958958095504208827127170e-50, "5795895809550421", -49},
    {3.3408504540742285042850354e-145, "33408504540742285", -144},
    {7.9793908752671425007230302e-53, "79793908752671425", -52},
    {6.4714195317366025847920262e+218, "64714195317366026", 219},
    {4.9473512085506899444081291e+253, "494735120855069", 254},
    {7.6711282200496731817243017e-54, "7671128220049673", -53},
    {5.1521977498882131531078432e-238, "5152197749888213", -237},
    {9.8885393042071856113865902e-70, "9888539304207186", -69},
    {2.1081541941744870994847252e+83, "2108154194174487", 84},
    {2.6767243453016752389647459e+188, "26767243453016752", 189},
    {2.7592862942099910600006942e-280, "2759286294209991", -279},
    {1.1256129979566786840805208e+200, "11256129979566787", 201},
    {7.1248286903123560407377781e+307, "7124828690312356", 308},
    {1.6243120407982751185442735e+260, "1624312040798275", 261},
    {7.6817550889468375872518617e-222, "7681755088946838", -221},
    {1.0836357361452257191621276e+117, "10836357361452257", 118},
    {1.8999394665918813603593758e+209, "18999394665918814", 210},
    {6.2628011908707866199529157e-125, "6262801190870787", -124},
    {9.0724186968279848515905020e-44, "9072418696827985", -43},
    {6.0878023230744954741305578e-158, "60878023230744955", -157},
    {7.3225316849106630395695015e-118, "7322531684910663", -117},
    {6.3354431541497680049596195e-54, "6335443154149768", -53},
    {1.2631863564409722615817947e-45, "12631863564409723", -44},
    {1.4587947574930857043541908e+210, "14587947574930857", 211},
    {2.4683698873011476143551183e+287, "24683698873011476", 288},
    {2.1839842544472129219134247e-293, "2183984254447213", -292},
    {3.9803303019287130207073486e+220, "3980330301928713", 221},
    {3.9753415655212913146706283e-218, "39753415655212913", -217},
    {2.5791460275021710736637310e-37, "2579146027502171", -36},
    {2.8482205260050278619735679e+133, "2848220526005028", 134},
    {2.3007523811414265723352139e-77, "23007523811414266", -76},
    {3.1278885025262644337866641e-109, "31278885025262644", -108},
    {2.7895193768502327551125009e-15, "27895193768502328", -14},
    {1.0699558636250043986805991e-290, "10699558636250044", -289},
    {1.9387423678780213286896768e-252, "19387423678780213", -251},
    {1.6797146822951924511736010e-93, "16797146822951925", -92},
    {1.3462518359311536309541804e+198, "13462518359311536", 199},
    {3.3897666152353925076515603e+186, "33897666152353925", 187},
    {4.6091767657597280018064241e+264, "4609176765759728", 265},
    {5.7778620001604054927023580e-139, "57778620001604055", -138},
    {1.0579275675347942075622464e-262, "10579275675347942", -261},
    {5.6096178436901278056448000e+23, "5609617843690128", 24},
    {4.9858761482012071419087191e-263, "4985876148201207", -262},
    {7.3788111186666360623768693e-246, "7378811118666636", -245},
    {5.6435395555691471651830175e+142, "5643539555569147", 143},
    {1.6581683464175192420042275e+79, "16581683464175192", 80},
    {1.8109926652259562900993958e-247, "18109926652259563", -246},
    {1.9339552539826438318649100e+74, "19339552539826438", 75},
    {2.0555127522206464854815900e+139, "20555127522206465", 140},
    {2.2234223059914960490340440e-80, "2223422305991496", -79},
    {3.1309524596605444548449527e+159, "31309524596605445", 160},
    {9.0686111288313509740133493e+213, "9068611128831351", 214},
    {8.2045465603882710728275061e-139, "8204546560388271", -138},
    {4.4223364532291062570046538e+222, "4422336453229106", 223},
    {9.7484871074357930695804749e+64, "9748487107435793", 65},
    {5.0450992194582828389532795e+263, "5045099219458283", 264},
    {9.0467828975283741838378918e+224, "9046782897528374", 225},
    {1.8227451773925384683135718e+30, "18227451773925385", 31},
    {7.3930523453486963961249332e+122, "7393052345348696", 123},
    {2.6914712437389206303818533e+100, "26914712437389206", 101},
    {2.3141180509803577367530220e+125, "23141180509803577", 126},
    {3.5379559354544497781247784e+116, "353795593545445", 117},
    {3.0390158552142705605757258e-34, "30390158552142706", -33},
    {6.3572334466014831135671256e+52, "6357233446601483", 53},
    {8.2615510910716776948144476e-186, "8261551091071678", -185},
    {5.7131502842714025007844595e-27, "57131502842714025", -26},
    {2.4016186869936582420967159e+120, "24016186869936582", 121},
    {2.3655039501623992116252751e+227, "23655039501623992", 228},
    {5.1839081151713754959106201e-186, "51839081151713755", -185},
    {1.5111190380458837417639073e-219, "15111190380458837", -218},
    {1.5480572905830690149565532e-91, "1548057290583069", -90},
    {1.7981398208263837448923081e-37, "17981398208263837", -36},
    {2.3219377307076412217673990e-246, "2321937730707641", -245},
    {4.0153413758084743036312542e+250, "4015341375808474", 251},
    {3.9195283372659593090556188e+102, "39195283372659593", 103},
    {2.4247282952717682100934996e-132, "24247282952717682", -131},
    {8.6899147046896948750063784e+138, "8689914704689695", 139},
    {5.1333123474516791069146897e-49, "5133312347451679", -48},
    {1.3578373326942535194411708e+45, "13578373326942535", 46},
    {3.6265626989815575878559880e-233, "36265626989815576", -232},
    {8.4169405839069940990234159e-129, "8416940583906994", -128},
    {2.7945090992731813903734639e-36, "27945090992731814", -35},
    {2.0530694429180888799328715e+93, "20530694429180889", 94},
    {1.3192734546714460665752012e+68, "1319273454671446", 69},
    {3.0231252841750316338990167e+191, "30231252841750316", 192},
    {1.2719797146190158762188523e-231, "12719797146190159", -230},
    {2.9031774570172834506629710e+29, "29031774570172835", 30},
    {1.3279702599710627042523405e-135, "13279702599710627", -134},
    {1.4038510846507834307781662e+220, "14038510846507834", 221},
    {3.2565670314339154563329657e-105, "32565670314339155", -104},
    {2.3962439062615048301318301e+293, "2396243906261505", 294},
    {9.1434737920550782510789814e+67, "9143473792055078", 68},
    {5.2488433956554578331931840e+236, "5248843395655458", 237},
    {2.5477931832199036082133577e-281, "25477931832199036", -280},
    {2.0179195568771072809524991e+278, "20179195568771073", 279},
    {5.1034911937176547765930689e+272, "5103491193717655", 273},
    {4.9167509478075613724395716e+265, "49167509478075614", 266},
    {1.3680693775680387810866631e+153, "13680693775680388", 154},
    {2.6818934909641455031005691e-273, "26818934909641455", -272},
    {1.0463008222781197365052011e-71, "10463008222781197", -70},
    {4.5718676603214630960701605e-252, "4571867660321463", -251},
    {9.9619649338802088616485589e-172, "9961964933880209", -171},
    {2.7829681394474581276015899e-41, "2782968139447458", -40},
    {1.7037138521368408385478829e-194, "17037138521368408", -193},
    {3.7499422187615315079209586e-299, "37499422187615315", -298},
    {1.8344996160843278342085527e+128, "1834499616084328", 129},
    {2.5732653269119560718536377e+06, "2573265326911956", 7},
    {3.9147175780455997353767964e-250, "39147175780456", -249},
    {3.4033086235506650994705484e-164, "3403308623550665", -163},
    {4.9575967608383035819761449e-78, "4957596760838304", -77},
    {1.7758743772132916708975822e-299, "17758743772132917", -298},
    {2.0773756707950057442512697e-73, "20773756707950057", -72},
    {2.2564628896166642728641573e+151, "22564628896166643", 152},
    {2.5313791244574757006155095e+185, "25313791244574757", 186},
    {2.0097120100616969458879252e+261, "2009712010061697", 262},
    {1.6055535487721070895952545e-195, "1605553548772107", -194},
    {3.5410452347598870278812484e+143, "3541045234759887", 144},
    {6.3588983405366104753856049e-276, "63588983405366105", -275},
    {3.9598249591223803766763749e+32, "39598249591223804", 33},
    {9.5607543760949364715539846e-278, "9560754376094936", -277},
    {9.6279620638839826138393878e-284, "9627962063883983", -283},
    {1.1250139927199100897220036e+232, "11250139927199101", 233},
    {8.7005717157483556588534885e-248, "8700571715748356", -247},
    {1.2682171486811642692374636e+66, "12682171486811643", 67},
    {1.8022011532748359817216883e+179, "1802201153274836", 180},
    {2.2218408393515613737614578e+31, "22218408393515614", 32},
    {3.7867515842180847802040499e+33, "3786751584218085", 34},
    {1.1053448339737070210744546e-266, "1105344833973707", -265},
    {1.2407370421589839672265702e+278, "1240737042158984", 279},
    {2.7992082100806850652949017e+183, "2799208210080685", 184},
    {3.8625024425350475820196457e+211, "38625024425350476", 212},
    {4.2334254928415632170664427e-48, "4233425492841563", -47},
    {1.8135234253886396252298462e+130, "18135234253886396", 131},
    {7.0124814896455516611208974e-83, "7012481489645552", -82},
    {2.1558841921461052412879336e+215, "21558841921461052", 216},
    {2.5939650687555257452322661e+179, "2593965068755526", 180},
    {4.2592515451716868131339522e+264, "4259251545171687", 265},
    {4.8480249641208166189536808e-199, "4848024964120817", -198},
    {1.9461810175013087436238541e+264, "19461810175013087", 265},
    {9.8525706492313856341258451e-273, "9852570649231386", -272},
    {2.0709929939560242058236000e+188, "20709929939560242", 189},
    {2.8211580457992180516869331e+49, "2821158045799218", 50},
    {3.3548859083533484146886766e+184, "33548859083533484", 185},
    {5.0614288553557141888707383e+307, "5061428855355714", 308},
    {1.5131484137025959759623718e-110, "1513148413702596", -109},
    {3.5045334698241835925162776e-253, "35045334698241836", -252},
    {8.3486757888122726311226103e-130, "8348675788812273", -129},
    {1.2348108552588147560693096e+120, "12348108552588148", 121},
    {7.4579907102332712353987639e-219, "7457990710233271", -218},
    {2.9311995822355501752641583e+54, "29311995822355502", 55},
    {8.4458667518064898116527905e+40, "844586675180649", 41},
    {1.5498941737372586556644284e-06, "15498941737372587", -5},
    {9.4372323459178650515604283e-179, "9437232345917865", -178},
    {7.1921888583794321213835299e+186, "7192188858379432", 187},
    {1.1634146165769126148389422e+67, "11634146165769126", 68},
    {8.8816230933115147167058753e+267, "8881623093311515", 268},
    {2.1669260832656637887477323e-191, "21669260832656638", -190},
    {5.7923425300338385498024706e-218, "5792342530033839", -217},
    {8.4110852779661240207124157e-144, "8411085277966124", -143},
    {5.4486588961443431889196824e+166, "5448658896144343", 167},
    {1.0246068885391622727902603e+40, "10246068885391623", 41},
    {1.1526747319780811701770933e+90, "11526747319780812", 91},
    {6.7972623230123467979897308e+244, "6797262323012347", 245},
    {5.3694613737102065648188317e+57, "53694613737102066", 58},
    {9.8918001475903701465584427e-129, "989180014759037", -128},
    {1.9175192907016282983789779e+00, "19175192907016283", 1},
    {3.0118226806064616078635774e+246, "30118226806064616", 247},
    {2.8759351252516005466259306e+110, "28759351252516005", 111},
    {4.1649405960856119960552029e-40, "4164940596085612", -39},
    {3.5500502207996193496440016e-280, "35500502207996193", -279},
    {1.0017667383147083039205482e-207, "10017667383147083", -206},
    {1.0635893279421622593506709e+242, "10635893279421623", 243},
    {4.5692896617516498029314779e+302, "456928966175165", 303},
    {8.0701137716582810972109495e+268, "8070113771658281", 269},
    {7.6404443103194183536604857e+169, "7640444310319418", 170},
    {6.8855999858351423124972290e-307, "6885599985835142", -306},
    {1.3053060916233994646935270e+114, "13053060916233995", 115},
    {4.2066725577162452289058253e-46, "4206672557716245", -45},
    {1.0960547083765075416597987e-267, "10960547083765075", -266},
    {1.7564308392674300089264584e+224, "175643083926743", 225},
    {3.6954454783888253972648336e+58, "36954454783888254", 59},
    {5.7019205917848125387084125e-283, "5701920591784813", -282},
    {2.4357720358226758953028211e+274, "2435772035822676", 275},
    {2.6173735943560706683641728e-241, "26173735943560707", -240},
    {2.4762595671190423206905383e-137, "24762595671190423", -136},
    {3.1253517552515520095031690e+169, "3125351755251552", 170},
    {1.8744584369090801224908800e+23, "187445843690908", 24},
    {5.2383007926706421114470766e+231, "5238300792670642", 232},
    {2.0743452342675530872070572e-200, "2074345234267553", -199},
    {1.4985841361165202791528411e+257, "14985841361165203", 258},
    {9.7976735010317169319684136e+276, "9797673501031717", 277},
    {7.6467728984197038733560425e+111, "7646772898419704", 112},
    {4.3950641165033653058669802e+248, "43950641165033653", 249},
    {2.6680339977215444383687452e-285, "26680339977215444", -284},
    {6.5083128726021525835025848e+230, "6508312872602153", 231},
    {1.1820455149712127957112004e-110, "11820455149712128", -109},
    {6.7838926851041453075971305e-128, "6783892685104145", -127},
    {1.8314549588165507376658070e-01, "18314549588165507", 0},
    {1.1099996465600955388296998e+266, "11099996465600955", 267},
    {7.6542141443623532876389977e+96, "7654214144362353", 97},
    {6.1224510696700711552880946e+62, "6122451069670071", 63},
    {1.0409634077542114648877423e+283, "10409634077542115", 284},
    {1.7288840338514270223822488e+224, "1728884033851427", 225},
    {2.3947117145211145669389679e-238, "23947117145211146", -237},
    {3.6241841661328563425231905e+148, "36241841661328563", 149},
    {6.8429114052845063759548966e-163, "6842911405284506", -162},
    {1.8982367856068465321463710e-132, "18982367856068465", -131},
    {2.7786537041896985405827453e-208, "27786537041896985", -207},
    {1.9811073435773328226677031e-213, "19811073435773328", -212},
    {8.8431331373355429876130990e+246, "8843133137335543", 247},
    {2.9211143427403026166082043e-294, "29211143427403026", -293},
    {2.3207972427213500558180683e-226, "232079724272135", -225},
    {6.7008082372806732254691028e+138, "6700808237280673", 139},
    {4.5961974611223799877633292e-48, "459619746112238", -47},
    {2.9388798817123065313200631e+50, "29388798817123065", 51},
    {4.7594383363532746266702126e+266, "47594383363532746", 267},
    {4.1831748431092815593102551e-59, "4183174843109282", -58},
    {1.5592606337191596258999675e+31, "15592606337191596", 32},
    {7.1826524035047961580835572e-215, "7182652403504796", -214},
    {1.1352163816576253621810237e+159, "11352163816576254", 160},
    {2.8041021084987642561724533e+52, "2804102108498764", 53},
    {3.8304994831278830329504379e-81, "3830499483127883", -80},
    {2.3214730490014665406632575e+150, "23214730490014665", 151},
    {7.1076698580818768071328219e-209, "7107669858081877", -208},
    {1.3657842871996620528409536e-61, "1365784287199662", -60},
    {1.4957268639222139967925523e+270, "1495726863922214", 271},
    {1.8412075638882424646717003e-72, "18412075638882425", -71},
    {1.8958340852936242995185103e+50, "18958340852936243", 51},
    {1.7780421067261071837070380e-214, "17780421067261072", -213},
    {7.3101557425878595250523364e-152, "73101557425878595", -151},
    {1.3301846358711786078163712e-287, "13301846358711786", -286},
    {7.7998014624006140324015886e-195, "7799801462400614", -194},
    {2.4934533174500740151098422e-10, "2493453317450074", -9},
    {4.7727970208906756261970639e-191, "47727970208906756", -190},
    {1.6071453032300984089881223e+237, "16071453032300984", 238},
    {1.4723272681800050813367620e-121, "1472327268180005", -120},
    {1.0374356800673271967570067e-218, "10374356800673272", -217},
    {1.2620419763242237495452551e-296, "12620419763242237", -295},
    {2.3397422583556266538186372e-92, "23397422583556267", -91},
    {2.3201400280461815738447102e+156, "23201400280461816", 157},
    {1.0625255735171027121883312e+123, "10625255735171027", 124},
    {7.5540800124355752121701809e-307, "7554080012435575", -306},
    {2.9478116811018413678999271e-58, "29478116811018414", -57},
    {3.0901655832744587262977162e-225, "3090165583274459", -224},
    {5.7058695375495238990980030e+252, "5705869537549524", 253},
    {3.9006773805682237817782339e-118, "3900677380568224", -117},
    {4.2201592554117146552260313e-250, "42201592554117147", -249},
    {5.5322641213391261020395487e-81, "5532264121339126", -80},
    {1.8641881132747180377776668e-193, "1864188113274718", -192},
    {2.6586101050769952481648040e+139, "2658610105076995", 140},
    {6.8732504694037020064676736e-220, "6873250469403702", -219},
    {7.0609242156652272228149456e+49, "7060924215665227", 50},
    {2.6781106807597439093641060e-193, "2678110680759744", -192},
    {1.0364574135441660977290773e+99, "10364574135441661", 100},
    {7.6144713231803032635343859e-276, "7614471323180303", -275},
    {6.0528615132519068944907617e+245, "6052861513251907", 246},
    {9.3648978217781666096305501e+115, "9364897821778167", 116},
    {6.1832439158589428074251632e-140, "6183243915858943", -139},
    {5.1162942478971422832175094e-143, "5116294247897142", -142},
    {2.8808295324317101900673540e-23, "288082953243171", -22},
    {2.6973698416809724549638286e+169, "26973698416809725", 170},
    {1.0410645162031286251683549e+88, "10410645162031286", 89},
    {8.1114071994798866298917828e+108, "8111407199479887", 109},
    {2.3530958444965484224572535e+288, "23530958444965484", 289},
    {1.5884808972999702009425634e-165, "15884808972999702", -164},
    {1.1725655333208046080000000e+18, "11725655333208046", 19},
    {1.2592852220315330885119127e+174, "1259285222031533", 175},
    {3.0095784291568120272812631e-233, "3009578429156812", -232},
    {7.2169421362366830000000000e+15, "7216942136236683", 16},
    {9.7594066970791891681883135e-206, "9759406697079189", -205},
    {4.6215018354576739129729356e+142, "4621501835457674", 143},
    {9.3682944994498219442424519e-47, "9368294499449822", -46},
    {1.6178066290831900777473134e-131, "161780662908319", -130},
    {9.1521627995516378492413593e+232, "9152162799551638", 233},
    {2.7880424830233961662621872e-31, "2788042483023396", -30},
    {1.3654034539661279128243418e+258, "1365403453966128", 259},
    {3.1570416788057627528487082e-130, "31570416788057628", -129},
    {2.9627398949014484453050626e+41, "29627398949014484", 42},
    {2.7643298408877675228355626e-222, "27643298408877675", -221},
    {7.3257743028093766819452310e+196, "7325774302809377", 197},
    {4.7451619190933502573915852e+298, "474516191909335", 299},
    {1.8050576068645524194927754e-03, "18050576068645524", -2},
    {3.9935269787733077472941316e+93, "39935269787733077", 94},
    {3.6782764797337505609158307e-286, "36782764797337506", -285},
    {1.1212087500286683761602238e+172, "11212087500286684", 173},
    {1.8227647863422588226098788e-26, "18227647863422588", -25},
    {2.2926449740840201218465834e+92, "229264497408402", 93},
    {8.6028084477430407825958029e-156, "8602808447743041", -155},
    {1.3620741814404413804244221e-67, "13620741814404414", -66},
    {9.7882288572808704157973942e+287, "978822885728087", 288},
    {1.1640490670507310346865397e+72, "1164049067050731", 73},
    {1.7632198164204230786489798e-236, "1763219816420423", -235},
    {3.2080940004641603303333912e-192, "32080940004641603", -191},
    {7.2796660424992339853149868e-112, "7279666042499234", -111},
    {1.0382783239826911738137965e-106, "10382783239826912", -105},
    {1.2430279827224472852120649e+213, "12430279827224473", 214},
    {1.2395990576707163080060387e-289, "12395990576707163", -288},
    {1.5681188377867633956703081e+114, "15681188377867634", 115},
    {1.0874872131806859899769289e-119, "1087487213180686", -118},
    {5.9403590313095526592318338e-21, "5940359031309553", -20},
    {3.0042540966938439130854588e-96, "3004254096693844", -95},
    {6.9137732548962512488076636e+245, "6913773254896251", 246},
    {2.1388868757563381598480216e+65, "2138886875756338", 66},
    {4.4370050003287735458727191e-84, "4437005000328774", -83},
    {2.0810677888731911214999043e-171, "2081067788873191", -170},
    {2.1497072203295559428764693e-116, "2149707220329556", -115},
    {8.2101783660795518930591536e-273, "8210178366079552", -272},
    {2.3645025166502022170523902e+275, "23645025166502022", 276},
    {1.0481309181438226155915391e-118, "10481309181438226", -117},
    {9.8177667941628799458819682e+232, "981776679416288", 233},
    {2.7210317113820828497409821e+07, "2721031711382083", 8},
    {3.9037343287250849531675590e+219, "3903734328725085", 220},
    {7.2500266400997768106436187e+193, "7250026640099777", 194},
    {8.4128189316261796844569183e+64, "841281893162618", 65},
    {1.3512132459343151325015242e+00, "13512132459343151", 1},
    {1.0638913283712193889005095e+123, "10638913283712194", 124},
    {9.8571058418801480932457862e-53, "9857105841880148", -52},
    {9.9822648158691777513593911e-200, "9982264815869178", -199},
    {8.5352586243097070427845951e-278, "8535258624309707", -277},
    {7.7461222814076742494566532e-257, "7746122281407674", -256},
    {2.0461967938863672122510935e-194, "20461967938863672", -193},
    {5.4739747361762713693194026e-221, "5473974736176271", -220},
    {6.4687904854635189447539182e+290, "6468790485463519", 291},
    {1.5059512514040048899945616e+137, "15059512514040049", 138},
    {8.1160074656512325887625144e+250, "8116007465651233", 251},
    {2.5534150524195009538475535e-303, "2553415052419501", -302},
    {3.0663672550344430817235222e+227, "3066367255034443", 228},
    {7.6568940045010636017027084e-183, "7656894004501064", -182},
    {1.9861642518731045082498790e+210, "19861642518731045", 211},
    {1.3932812528988372841780802e-183, "13932812528988373", -182},
    {7.2959129631733199901361084e+201, "729591296317332", 202},
    {1.5266587241187247508657029e-79, "15266587241187248", -78},
    {6.1536228377087634650821924e-152, "61536228377087635", -151},
    {7.3366100580086731975668670e-65, "7336610058008673", -64},
    {2.2424880979669863828765941e-62, "22424880979669864", -61},
    {3.2604512715169751826446519e+96, "3260451271516975", 97},
    {1.1031259494898811736944456e+94, "11031259494898812", 95},
    {5.4389090515801398101206933e-54, "543890905158014", -53},
    {3.5369396998017872569192032e-177, "35369396998017873", -176},
    {3.2911664117121923287867892e-308, "32911664117121923", -307},
    {4.5129193712054816567919761e+54, "45129193712054817", 55},
    {5.9349937658966455073114460e+190, "59349937658966455", 191},
    {6.2257747566909177175372573e+44, "6225774756690918", 45},
    {1.6077069932248712822922563e-92, "16077069932248713", -91},
    {3.3697407028191073745185018e-95, "33697407028191074", -94},
    {2.4202465747545572769547043e+189, "24202465747545573", 190},
    {9.5074137597391644761841408e-90, "9507413759739164", -89},
    {4.3424461824221576549169737e+250, "43424461824221577", 251},
    {4.5818023041605746944188618e+104, "4581802304160575", 105},
    {2.4521037801041348911790215e+235, "2452103780104135", 236},
    {4.3279660099391474099679127e+106, "43279660099391474", 107},
    {1.8113049632635250764873773e-256, "1811304963263525", -255},
    {2.9985251842002518417817367e-200, "2998525184200252", -199},
    {5.4340211394995793986637029e-196, "5434021139499579", -195},
    {5.2265292074564573405567347e-202, "5226529207456457", -201},
    {4.8691044196753261555158035e+171, "4869104419675326", 172},
    {7.0982800790211513069736410e-187, "7098280079021151", -186},
    {9.5088727867140670875629862e-132, "9508872786714067", -131},
    {1.7759436086852110677394239e+200, "1775943608685211", 201},
    {2.4372216212723478666025595e+265, "2437221621272348", 266},
    {4.0611256470376555313360591e+172, "40611256470376555", 173},
    {7.3800106578319901007202872e-106, "738001065783199", -105},
    {1.5056246006374508476540676e-167, "15056246006374508", -166},
    {8.0511150413356212011170774e+90, "8051115041335621", 91},
    {4.5472532820434342614928593e+251, "45472532820434343", 252},
    {8.2029840914294870220755356e+275, "8202984091429487", 276},
    {7.4409211126427048052517763e-22, "7440921112642705", -21},
    {1.3676260779138889961101793e-247, "1367626077913889", -246},
    {1.9519474076466683812380607e+253, "19519474076466684", 254},
    {1.4866317930039240359438307e-120, "1486631793003924", -119},
    {6.6871347827847586700971448e+173, "6687134782784759", 174},
    {1.5250021902248472867269719e+159, "15250021902248473", 160},
    {4.1898185019169342920812207e-237, "41898185019169343", -236},
    {2.2455464465277916078962891e-65, "22455464465277916", -64},
    {5.2831693864470847536442945e+125, "5283169386447085", 126},
    {3.6214741219222597369216209e+109, "36214741219222597", 110},
    {2.0093038048874423980712891e+10, "20093038048874424", 11},
    {1.4307957633363239662142874e-282, "1430795763336324", -281},
    {1.8564595774652625378908035e-274, "18564595774652625", -273},
    {1.8826694779828348867298184e+66, "1882669477982835", 67},
    {1.8133168659038785111377537e-12, "18133168659038785", -11},
    {4.1511901013675624048172808e+79, "41511901013675624", 80},
    {9.5908913999568075263312681e-141, "9590891399956808", -140},
    {3.0154957290838051513230098e+42, "3015495729083805", 43},
    {2.6437370902019167113003618e-197, "26437370902019167", -196},
    {1.4416585376092254434472373e+246, "14416585376092254", 247},
    {2.7353593137114844315808196e+198, "27353593137114844", 199},
    {6.5237827707170338653942874e+221, "6523782770717034", 222},
    {1.7591958047044609465132021e-33, "1759195804704461", -32},
    {5.9563403315039086823646444e+233, "5956340331503909", 234},
    {8.3471016291801327112971025e-304, "8347101629180133", -303},
    {6.9331278985766825323948585e+289, "69331278985766825", 290},
    {5.1628001534805314021436931e-169, "51628001534805314", -168},
    {3.1948749981178426154153174e-47, "31948749981178426", -46},
    {1.5120720029015635138221274e-224, "15120720029015635", -223},
    {2.1340596255345720405945650e-25, "2134059625534572", -24},
    {4.7922656978790250635387144e-17, "4792265697879025", -16},
    {6.5207047931784583440500831e-52, "6520704793178458", -51},
    {4.4492397386658914901532173e+110, "44492397386658915", 111},
    {8.3613144704186083616682817e+121, "8361314470418608", 122},
    {1.1702634579280161302504222e-182, "11702634579280161", -181},
    {4.4752642256112507681725637e-137, "4475264225611251", -136},
    {3.6131720478989386237479368e-214, "36131720478989386", -213},
    {1.0468115819439463336389216e-144, "10468115819439463", -143},
    {4.6123254292012293199943392e+97, "4612325429201229", 98},
    {7.7813317530439460488172515e-165, "7781331753043946", -164},
    {3.3835532824644451393129732e-07, "3383553282464445", -6},
    {3.0205221944890707968247942e-195, "30205221944890708", -194},
    {1.5227249358913861114956498e+41, "15227249358913861", 42},
    {4.3976857393010572307562350e-262, "4397685739301057", -261},
    {1.8241505532701942561990375e-15, "18241505532701943", -14},
    {1.6706727381173279849463046e+164, "1670672738117328", 165},
    {2.2207274263528439236654658e-209, "2220727426352844", -208},
    {9.7024040644049291820445001e+143, "970240406440493", 144},
    {1.1219925423326120401482434e+232, "1121992542332612", 233},
    {3.7150145855678440856022693e-07, "3715014585567844", -6},
    {2.4795211665505871284695465e-63, "2479521166550587", -62},
    {5.9252371186743131059037143e+27, "5925237118674313", 28},
    {6.3231009981263010342159725e+230, "6323100998126301", 231},
    {5.2361450106212401755820838e-255, "523614501062124", -254},
    {2.4640292892114810833308733e+93, "2464029289211481", 94},
    {7.3799411868039650613100574e+195, "7379941186803965", 196},
    {1.1230065628044954619013513e-212, "11230065628044955", -211},
    {5.5988465295541125396646604e-195, "55988465295541125", -194},
    {1.1810819607022092703937223e+285, "11810819607022093", 286},
    {3.2752495333313843924596367e+94, "32752495333313844", 95},
    {6.5950186019179409177526457e-59, "6595018601917941", -58},
    {4.5747678361469129571291523e-250, "4574767836146913", -249},
    {2.7110113708757684455115900e-250, "27110113708757684", -249},
    {2.5792750167748489356818606e+183, "2579275016774849", 184},
    {1.0408236840716717156203501e+169, "10408236840716717", 170},
    {2.8788792333492666121367821e-18, "28788792333492666", -17},
    {6.8483460416254619834238288e-273, "6848346041625462", -272},
    {4.2822810454844618750000000e+14, "4282281045484462", 15},
    {5.8636470472083081009669649e+183, "5863647047208308", 184},
    {7.3200763671679568742465807e+252, "7320076367167957", 253},
    {6.7688717601813061216023404e-05, "6768871760181306", -4},
    {2.7639506873007861328125000e+12, "2763950687300786", 13},
    {7.8340000797991580546612929e-38, "7834000079799158", -37},
    {2.0404009960842068382104151e+278, "20404009960842068", 279},
    {1.5223084330421960507126708e-282, "1522308433042196", -281},
    {4.1348873065793434439417714e+296, "41348873065793434", 297},
    {4.7485093530481175323230685e-177, "47485093530481175", -176},
    {4.0267312680706524973236118e-25, "40267312680706525", -24},
    {1.0414385111648520312500000e+14, "1041438511164852", 15},
    {2.0598805657668794501409103e-187, "20598805657668795", -186},
    {5.4611290943074056246900720e-95, "54611290943074056", -94},
    {4.2132900200174888484760180e+166, "4213290020017489", 167},
    {6.5505656514087231698795222e+03, "6550565651408723", 4},
    {2.1510889955707119123971234e-60, "2151088995570712", -59},
    {2.4318239648442073818480969e-137, "24318239648442074", -136},
    {1.1266028243966000281368083e+306, "11266028243966", 307},
    {1.6593478508265576790475533e+234, "16593478508265577", 235},
    {2.3485159718860437414587569e-172, "23485159718860437", -171},
    {1.5076206893682639560977777e-276, "1507620689368264", -275},
    {2.1046792697227625820640671e+71, "21046792697227626", 72},
    {1.2805644206423274435258018e-267, "12805644206423274", -266},
    {1.9926771915471293969968049e-188, "19926771915471294", -187},
    {2.4443846275980368567434287e+222, "2444384627598037", 223},
    {9.4939286827999676942120400e+140, "9493928682799968", 141},
    {9.4508798952821206946129547e+30, "9450879895282121", 31},
    {2.0434414667339913277143449e-59, "20434414667339913", -58},
    {8.0337126432713795080959321e+195, "803371264327138", 196},
    {8.5931289650662124243482867e+209, "8593128965066212", 210},
    {4.8981828640934654025653557e+306, "48981828640934654", 307},
    {7.1675952846143438150915475e-52, "7167595284614344", -51},
    {7.5512010413287705412196770e+87, "75512010413287705", 88},
    {5.0556050229864976036806395e+272, "50556050229864976", 273},
    {9.3624972082184748743112013e+58, "9362497208218475", 59},
    {1.3946901498902920841138744e-251, "1394690149890292", -250},
    {2.8643900175665135481910548e+200, "28643900175665135", 201},
    {6.1371045075339189079411047e-152, "6137104507533919", -151},
    {1.9161986816221366300630680e-102, "19161986816221366", -101},
    {4.8021587332344505815826938e-62, "4802158733234451", -61},
    {2.3711471605563217680770370e+299, "23711471605563218", 300},
    {2.0111874788866915672102494e+90, "20111874788866916", 91},
    {7.5166092007390190484958020e+186, "7516609200739019", 187},
    {1.2502422573824663849856795e+281, "12502422573824664", 282},
    {6.7306194714059032651555468e+40, "6730619471405903", 41},
    {1.6702401478306968497293027e+163, "1670240147830697", 164},
    {3.4680320136868132593043159e+142, "3468032013686813", 143},
    {3.6110520922700385784919236e-206, "36110520922700386", -205},
    {1.5132964778327167597184473e+117, "15132964778327168", 118},
    {5.1428206374916614731773734e+05, "51428206374916615", 6},
    {9.6972340032561441179174424e+63, "9697234003256144", 64},
    {3.4862662878905073188087704e-207, "3486266287890507", -206},
    {4.6841135569824410661642643e-46, "4684113556982441", -45},
    {4.8389839736186215779515804e-220, "48389839736186216", -219},
    {1.4038139061830494618253699e-255, "14038139061830495", -254},
    {9.9145127866363683458730576e-275, "9914512786636368", -274},
    {4.6068012311966327121435270e+66, "4606801231196633", 67},
    {4.1797598592960487587230191e+35, "4179759859296049", 36},
    {1.9531136292570708296390310e-195, "1953113629257071", -194},
    {1.7011640146605806044688123e+223, "17011640146605806", 224},
    {4.1770512857079740802386241e-87, "4177051285707974", -86},
    {1.9267403624948910115271489e+199, "1926740362494891", 200},
    {3.3056970397505779910033509e-253, "3305697039750578", -252},
    {1.2017967890570151804419517e+287, "12017967890570152", 288},
    {4.1507080126913579322335399e+166, "4150708012691358", 167},
    {1.4589206091682355255185742e-267, "14589206091682355", -266},
    {5.7625503885564428109716832e+143, "5762550388556443", 144},
    {4.8708600214488312573437624e-95, "4870860021448831", -94},
    {6.6382893014675401222335692e+232, "663828930146754", 233},
    {1.6055525665416000942318582e+102, "16055525665416", 103},
    {4.0685208865477352670710407e-173, "4068520886547735", -172},
    {3.1110876739281809481196314e-219, "3111087673928181", -218},
    {8.0912078137568584373286042e-199, "8091207813756858", -198},
    {1.6309008675773441752064453e-84, "16309008675773442", -83},
    {7.2518967868012186317888635e-308, "7251896786801219", -307},
    {2.2451356015210148835700068e-66, "2245135601521015", -65},
    {4.4954180736043173933526990e+301, "4495418073604317", 302},
    {2.8932695854635619792472045e+204, "2893269585463562", 205},
    {5.4647378591723801857630306e-112, "546473785917238", -111},
    {1.6326739883606536880935594e-225, "16326739883606537", -224},
    {2.2456819371711777262918895e-305, "22456819371711777", -304},
    {6.3710853208541975178675391e+266, "6371085320854198", 267},
    {1.1781214025465227174213563e+123, "11781214025465227", 124},
    {1.2577828252074657392342453e+33, "12577828252074657", 34},
    {1.7416661898791134679873623e-194, "17416661898791135", -193},
    {1.9318600981387908217798711e-263, "19318600981387908", -262},
    {4.2100317720386543207623531e+194, "4210031772038654", 195},
    {2.6810352688797997757664115e+125, "26810352688797998", 126},
    {1.7863769441496128561213425e-40, "17863769441496129", -39},
    {5.4132039134296387258307108e-139, "5413203913429639", -138},
    {3.2311880037870525003728761e+252, "32311880037870525", 253},
    {1.6443869791641890153033190e-131, "1644386979164189", -130},
    {3.6673569979043199363793472e+152, "366735699790432", 153},
    {3.0185620620939078985001646e+296, "3018562062093908", 297},
    {1.5086362138862335162836416e-63, "15086362138862335", -62},
    {1.8613091798889944758131868e-223, "18613091798889945", -222},
    {1.0352296477440972646382032e+96, "10352296477440973", 97},
    {6.8858257309099212479455785e-50, "6885825730909921", -49},
    {2.3714046547093949587611086e+107, "2371404654709395", 108},
    {1.1165400065438768634122057e+168, "11165400065438769", 169},
    {3.3442589429806612316630946e-106, "3344258942980661", -105},
    {2.0433905492927220295509022e+249, "2043390549292722", 250},
    {3.0196471430843399675440635e+128, "301964714308434", 129},
    {2.1788245235003221984690868e+62, "2178824523500322", 63},
    {1.1570425689558333684715657e+300, "11570425689558334", 301},
    {1.1594895140999253969108940e+29, "11594895140999254", 30},
    {6.5958528461109803616519981e+37, "659585284611098", 38},
    {1.5954712425021302750449130e-153, "15954712425021303", -152},
    {5.0724866324965770000995697e+78, "5072486632496577", 79},
    {2.5893051992719946550834570e-226, "25893051992719947", -225},
    {6.2590309048915232179624270e-37, "6259030904891523", -36},
    {1.2689843382955189238709586e-200, "12689843382955189", -199},
    {6.6691989881129723032671795e+290, "6669198988112972", 291},
    {2.6392975104830904153385518e+166, "26392975104830904", 167},
    {1.9676623390268282352480031e-102, "19676623390268282", -101},
    {4.8298397053392923475029214e-180, "4829839705339292", -179},
    {7.9195447800510240396286997e+31, "7919544780051024", 32},
    {1.4909099407914316135543203e-97, "14909099407914316", -96},
    {2.8269424514059756158830057e+175, "28269424514059756", 176},
    {5.8198428828614572230130616e+187, "5819842882861457", 188},
    {2.5180120573440491520000000e+19, "2518012057344049", 20},
    {1.0140164178766774764587003e+129, "10140164178766775", 130},
    {9.7497108252686244709943496e+304, "9749710825268624", 305},
    {2.9595242736291821118253474e-239, "2959524273629182", -238},
    {3.2612894549439597248410690e+115, "32612894549439597", 116},
    {4.1054518384604788927818616e-257, "4105451838460479", -256},
    {1.9257386627748443709591282e-119, "19257386627748444", -118},
    {4.0556962875019715778343489e+217, "40556962875019716", 218},
    {1.9822537088351985333816525e+185, "19822537088351985", 186},
    {8.8784327833667783226536411e+95, "8878432783366778", 96},
    {1.2327924727904994602275772e+185, "12327924727904995", 186},
    {2.7746286881126427203553885e-211, "27746286881126427", -210},
    {9.6478856602098387404291858e-91, "9647885660209839", -90},
    {2.4663933836225161578521680e+218, "2466393383622516", 219},
    {3.0955036895834343261885571e-31, "30955036895834343", -30},
    {9.5402337848496414946773664e-139, "9540233784849641", -138},
    {7.8906586559349927090513665e+165, "7890658655934993", 166},
    {1.0900038890727368677959928e-215, "10900038890727369", -214},
    {1.8614076922737990849726630e-03, "1861407692273799", -2},
    {1.2943726237627543838461007e-64, "12943726237627544", -63},
    {1.1934424687818469918506527e-204, "1193442468781847", -203},
    {3.9402818624728082632782520e-63, "3940281862472808", -62},
    {3.0644109862532488861969513e-235, "3064410986253249", -234},
    {8.1546728369069674172737816e+55, "8154672836906967", 56},
    {4.8007660384659499603539564e-110, "480076603846595", -109},
    {2.2742538402403078973293304e+07, "2274253840240308", 8},
    {2.8527161643912046132812250e-80, "28527161643912046", -79},
    {9.8874595876476355630500298e+155, "9887459587647636", 156},
    {1.8962393162027473902294784e+264, "18962393162027474", 265},
    {2.3175058879872145328347110e-197, "23175058879872145", -196},
    {3.2825032895831803566127505e+154, "32825032895831804", 155},
    {4.9061594310571137930722234e-156, "4906159431057114", -155},
    {4.9279338004028450544440927e-197, "4927933800402845", -196},
    {1.1571717273257895028403807e+300, "11571717273257895", 301},
    {4.1214880401125528940632777e-172, "4121488040112553", -171},
    {1.6053680326773634170394541e+217, "16053680326773634", 218},
    {1.3001264636225501600420297e-271, "13001264636225502", -270},
    {5.1923122378298557766069999e+105, "5192312237829856", 106},
    {2.1025725254911570212494292e-31, "2102572525491157", -30},
    {4.0687067655758717911040000e+21, "4068706765575872", 22},
    {4.2959924712442653660479528e+289, "4295992471244265", 290},
    {3.5229423122093703125000000e+13, "352294231220937", 14},
    {7.7627739294084582805446215e-95, "7762773929408458", -94},
    {1.6998303399300671464874695e+40, "16998303399300671", 41},
    {3.2680424052626329923746047e-270, "3268042405262633", -269},
    {3.5796117606973036563067878e-293, "35796117606973037", -292},
    {1.1721850139018626194386418e-201, "11721850139018626", -200},
    {7.5051592697660389117336528e+260, "7505159269766039", 261},
    {1.2893102745229221721507554e-18, "12893102745229222", -17},
    {3.9145331177696312629429081e-77, "3914533117769631", -76},
    {5.3910540743045415673104100e+103, "53910540743045416", 104},
    {1.8042799819311299927755075e+37, "180427998193113", 38},
    {1.4481079188319352987133152e+254, "14481079188319353", 255},
    {6.9488599022022913561727599e-270, "6948859902202291", -269},
    {2.2395605301402730092269687e+107, "2239560530140273", 108},
    {4.5427283275329239324342711e+114, "4542728327532924", 115},
    {1.1836012668294746470192663e-141, "11836012668294746", -140},
    {2.1018033121653616155348002e+111, "21018033121653616", 112},
    {2.1821890124536931274578402e+108, "2182189012453693", 109},
    {3.9840001977769955129651608e-227, "39840001977769955", -226},
    {2.1881845765559180693367085e+57, "2188184576555918", 58},
    {1.2263865025223327846683652e-274, "12263865025223328", -273},
    {2.9658872920237289423431016e+221, "2965887292023729", 222},
    {1.2634961484666511543204544e-182, "12634961484666512", -181},
    {1.0852847940557708083957626e-126, "10852847940557708", -125},
    {6.9008615397995294459126113e-103, "6900861539799529", -102},
    {6.1885671375041048970147314e+94, "6188567137504105", 95},
    {1.3093852781253759525627100e+59, "1309385278125376", 60},
    {2.2851044278522861464554022e-175, "22851044278522861", -174},
    {4.1134961669598121526412611e+175, "4113496166959812", 176},
    {1.0272700967364251290173440e+24, "10272700967364251", 25},
    {4.2422657933075072000000000e+18, "4242265793307507", 19},
    {1.0211893594843055541850907e+31, "10211893594843056", 32},
    {8.4975543039914881465874742e-110, "8497554303991488", -109},
    {8.8474250037072387343721494e-45, "8847425003707239", -44},
    {1.7921902178595720273147432e-308, "1792190217859572", -307},
    {6.7494833575030314687929204e-56, "67494833575030315", -55},
    {3.1751393474789242187500000e+13, "31751393474789242", 14},
    {4.8331828367356147766113281e+10, "4833182836735615", 11},
    {1.2106415384154964483314952e-98, "12106415384154964", -97},
    {8.2749175541717954011717755e+92, "8274917554171795", 93},
    {3.4570150450911474486819737e+81, "34570150450911474", 82},
    {3.6089536333158916778969184e-60, "36089536333158917", -59},
    {1.9851939027695344792447802e-292, "19851939027695345", -291},
    {6.4200590779127113311091907e-109, "6420059077912711", -108},
    {8.7857603477904917992867163e+281, "8785760347790492", 282},
    {8.8035641721006591023057359e+154, "8803564172100659", 155},
    {2.3634248774625907773153497e-269, "23634248774625908", -268},
    {2.3083416595932878103646599e-287, "23083416595932878", -286},
    {5.8554958157302080734857751e+188, "5855495815730208", 189},
    {2.5612032038548703248642347e+103, "25612032038548703", 104},
    {9.2931977460065970640936064e+290, "9293197746006597", 291},
    {2.2125737464496579748761630e-229, "2212573746449658", -228},
    {1.5717142867816689828090330e-282, "1571714286781669", -281},
    {5.4583107561572656862836084e+00, "5458310756157266", 1},
    {1.5975520047578168355368730e-254, "15975520047578168", -253},
    {3.2235526126747786235666072e+35, "32235526126747786", 36},
    {1.0323330396237062999782717e-218, "10323330396237063", -217},
    {1.0412182792406601530445977e+251, "10412182792406602", 252},
    {1.6501760059735776704255870e-30, "16501760059735777", -29},
    {3.2423630733363399164687344e+164, "324236307333634", 165},
    {1.6373678283815044956262704e-106, "16373678283815045", -105},
    {5.5556703534736475874470725e+60, "55556703534736476", 61},
    {1.8295987303354416542412216e-91, "18295987303354417", -90},
    {1.9421721888119497654075344e+292, "19421721888119498", 293},
    {8.0661668985218166898602201e+214, "8066166898521817", 215},
    {1.0405389972514466578163573e+259, "10405389972514467", 260},
    {2.0741116289571345612066521e-185, "20741116289571346", -184},
    {1.5946466567140859569225718e+36, "1594646656714086", 37},
    {1.8705608149919020000000000e+15, "1870560814991902", 16},
    {6.3456771436592048210324429e+119, "6345677143659205", 120},
    {5.3328666582436206293195055e+35, "53328666582436206", 36},
    {9.5931239937152637668775246e+235, "9593123993715264", 236},
    {6.8877777260837807575359529e+215, "6887777726083781", 216},
    {6.8422517984076086630412853e+230, "6842251798407609", 231},
    {5.7946520848059006003743932e+112, "5794652084805901", 113},
    {2.7966764602454371100262400e+23, "2796676460245437", 24},
    {2.0699810380588085688357199e-278, "20699810380588086", -277},
    {3.4514160990375120086071092e-01, "3451416099037512", 0},
    {9.0170604865329773869784710e-185, "9017060486532977", -184},
    {3.4069715196520650316388316e+259, "3406971519652065", 260},
    {5.1265123632049402989679576e+82, "512651236320494", 83},
    {4.0893838400451020549142711e+299, "4089383840045102", 300},
    {1.0108326328576025123091614e+169, "10108326328576025", 170},
    {3.1164803950585403000851326e+243, "31164803950585403", 244},
    {1.5043153790427249081993131e+237, "15043153790427249", 238},
    {9.7268490533645568847656250e+10, "9726849053364557", 11},
    {5.0982029356554692702293609e-106, "5098202935655469", -105},
    {7.2527213741411800350685927e+258, "725272137414118", 259},
    {5.1260326428685484488307994e-285, "51260326428685484", -284},
    {3.7268181737024792198330782e+35, "3726818173702479", 36},
    {5.8351798559270601545700673e-113, "583517985592706", -112},
    {1.8164467950992734865504885e-170, "18164467950992735", -169},
    {3.9691193516084420648516148e+55, "3969119351608442", 56},
    {3.6802493767119480851443948e+171, "3680249376711948", 172},
    {2.8118449907654644007548080e-275, "28118449907654644", -274},
    {1.0877091659877964617074536e+129, "10877091659877965", 130},
    {2.6488809236960066955825069e-102, "26488809236960067", -101},
    {5.2085001824757480162951821e+185, "5208500182475748", 186},
    {1.7835412891706218591031236e-236, "17835412891706219", -235},
    {1.3184848290297557916556855e+229, "13184848290297558", 230},
    {1.2003632558669152615911899e-88, "12003632558669153", -87},
    {1.4483693949394182915231340e-214, "14483693949394183", -213},
    {7.0730107490000656892724744e+52, "7073010749000066", 53},
    {2.8696858529019499754029132e-261, "286968585290195", -260},
    {2.3048148979557041196438492e-33, "2304814897955704", -32},
    {1.5883547287570582266196508e+126, "15883547287570582", 127},
    {1.2637266656244386512228339e-251, "12637266656244387", -250},
    {5.4208368459522777354879422e+237, "5420836845952278", 238},
    {3.6533401811633106644723203e+163, "36533401811633107", 164},
    {2.7753271821019207398335567e-175, "2775327182101921", -174},
    {1.7619155799997633182241593e-152, "17619155799997633", -151},
    {8.5648223338177812131009084e-287, "8564822333817781", -286},
    {1.7822975813429400908927484e+225, "178229758134294", 226},
    {9.5423865308149436101990071e+150, "9542386530814944", 151},
    {2.7236515844716846716275765e-291, "27236515844716847", -290},
    {1.8719225550318517932791868e-156, "18719225550318518", -155},
    {5.5222971361666273449678568e+66, "5522297136166627", 67},
    {1.2181057707270493916692357e-62, "12181057707270494", -61},
    {6.9156293487797996374943313e-24, "69156293487798", -23},
    {1.8333033933695369061206712e+109, "1833303393369537", 110},
    {1.3619248161550375908149648e-249, "13619248161550376", -248},
    {1.1372593829285235033131858e+113, "11372593829285235", 114},
    {8.5478201523616023365843794e-42, "8547820152361602", -41},
    {5.6490911946210684178405711e+144, "56490911946210684", 145},
    {1.3745797946720477184000000e+20, "13745797946720477", 21},
    {1.8721586108642472183053149e-224, "18721586108642472", -223},
    {2.6252354879086283188650742e+73, "26252354879086283", 74},
    {4.3771437227818338057112131e+264, "4377143722781834", 265},
    {5.1963002449759197366664398e-182, "519630024497592", -181},
    {1.0484371560644529128246683e+207, "10484371560644529", 208},
    {1.7706405086348237892754137e-118, "17706405086348238", -117},
    {2.5153519941198490688074338e+160, "2515351994119849", 161},
    {1.0156030665011052223683519e+193, "10156030665011052", 194},
    {4.4915032377240062369796032e+202, "4491503237724006", 203},
    {1.4235469112979148477549352e-188, "14235469112979148", -187},
    {3.0619610102116639345762231e+75, "3061961010211664", 76},
    {5.8581239636713809745394173e+299, "5858123963671381", 300},
    {7.8807392224573375911037393e+171, "7880739222457338", 172},
    {1.0062213888429198096470164e-172, "10062213888429198", -171},
    {1.7317796475385368401138873e+284, "1731779647538537", 285},
    {7.7875237690241166088738086e-105, "7787523769024117", -104},
    {5.3665270345012089436017072e+32, "5366527034501209", 33},
    {5.7620368208158721566293151e-74, "5762036820815872", -73},
    {7.2657497762318045609715590e+145, "7265749776231805", 146},
    {7.6113618772290622817183318e+207, "7611361877229062", 208},
    {5.0948959254822372650514525e+128, "5094895925482237", 129},
    {4.0400506218259608492567965e-201, "4040050621825961", -200},
    {1.6216135994645668091873396e-202, "16216135994645668", -201},
    {9.3802446732293377133597712e-06, "9380244673229338", -5},
    {4.3284175346720119942727232e-282, "4328417534672012", -281},
    {1.2091493619836599397412684e-54, "120914936198366", -53},
    {4.8018170979656098594694502e+238, "480181709796561", 239},
    {3.8473640643587216956476342e-230, "38473640643587217", -229},
    {8.1051375936615147404616554e+161, "8105137593661515", 162},
    {4.7440056454248065240663925e-290, "47440056454248065", -289},
    {1.0764715864115541662804729e-121, "10764715864115542", -120},
    {6.1707755895882045459694544e-34, "61707755895882045", -33},
    {7.6119581902360738597682463e-172, "7611958190236074", -171},
    {1.7173896724766421474108199e-160, "1717389672476642", -159},
    {4.7799659682542750545191879e+252, "4779965968254275", 253},
    {9.9600210632798811701113976e-224, "9960021063279881", -223},
    {3.6511917900664910788047051e+201, "3651191790066491", 202},
    {3.4305280527947887106108295e+46, "34305280527947887", 47},
    {7.2581036793255279748379047e-272, "7258103679325528", -271},
    {3.3447371987551797641216000e+23, "334473719875518", 24},
    {9.4111777040865922152807633e-29, "9411177704086592", -28},
    {9.5765352769223027870015827e-66, "9576535276922303", -65},
    {6.6248131350114096429264271e-245, "662481313501141", -244},
    {1.2936360122680473267007932e-117, "12936360122680473", -116},
    {7.5444703829696054219573064e+279, "7544470382969605", 280},
    {5.9154929510053945030761095e+234, "59154929510053945", 235},
    {4.2357146132827182514360282e-171, "4235714613282718", -170},
    {2.3613411400359502343107898e+302, "23613411400359502", 303},
    {8.6339836737476461040168260e+55, "8633983673747646", 56},
    {8.8111239574861939709547828e+173, "8811123957486194", 174},
    {1.4979602682568270977020025e-89, "14979602682568271", -88},
    {2.1108828957828524664217347e+114, "21108828957828525", 115},
    {1.3873172729874254240121753e+220, "13873172729874254", 221},
    {2.0190170749603382338659059e+284, "20190170749603382", 285},
    {2.9580910314958103779570490e+120, "29580910314958104", 121},
    {9.7094277890318276780561461e-148, "9709427789031828", -147},
    {7.2828864089658702614928724e+223, "728288640896587", 224},
    {4.8514135226615461508260684e-175, "4851413522661546", -174},
    {1.9192231217275279559816594e-189, "1919223121727528", -188},
    {2.2197901857005840206810054e+303, "2219790185700584", 304},
    {6.2094021048585360978054627e-226, "6209402104858536", -225},
    {3.8180708527627208450692923e-80, "3818070852762721", -79},
    {2.6722139462560714165693708e+52, "26722139462560714", 53},
    {8.1795330154279472178855049e+121, "8179533015427947", 122},
    {6.9048708526493248698192591e+118, "6904870852649325", 119},
    {2.8506842201167389447904025e-240, "2850684220116739", -239},
    {3.5441755533570462168723002e-257, "3544175553357046", -256},
    {5.1383568029605408185156340e-152, "5138356802960541", -151},
    {1.1815134500781419457622471e+96, "1181513450078142", 97},
    {7.6865297369028016388573455e+301, "7686529736902802", 302},
    {3.3588859191128571525522619e-35, "3358885919112857", -34},
    {3.5500204494016222338341768e-78, "3550020449401622", -77},
    {3.5096236347771417374599686e-84, "35096236347771417", -83},
    {4.6144623206662320490726320e+293, "4614462320666232", 294},
    {5.3793337341525858104009735e-140, "5379333734152586", -139},
    {9.9719013588381052447337790e-88, "9971901358838105", -87},
    {1.4169410351202381774783134e+07, "14169410351202382", 8},
    {1.8298350677805388413101890e-134, "18298350677805388", -133},
    {1.1513641940385974521529449e+76, "11513641940385975", 77},
    {1.5131039489196168019540839e+174, "15131039489196168", 175},
    {1.4465642675136401777437605e-265, "14465642675136402", -264},
    {1.0949283803800487655331174e+153, "10949283803800488", 154},
    {7.0373807556390802579171070e+120, "703738075563908", 121},
    {5.3759754214551618289874568e+00, "5375975421455162", 1},
    {6.0389515690301998885304198e+152, "60389515690302", 153},
    {4.0169853490076694165856610e+148, "40169853490076694", 149},
    {4.9883594805497222551823962e-39, "4988359480549722", -38},
    {2.0390200451153234629936012e+131, "20390200451153235", 132},
    {1.9344064499915989937262278e-268, "1934406449991599", -267},
    {2.3510282403825004474511966e-35, "23510282403825004", -34},
    {1.1556552760004375940177795e+198, "11556552760004376", 199},
    {8.4499934479949985404539175e+78, "8449993447994999", 79},
    {9.0433681578906656370989157e+163, "9043368157890666", 164},
    {1.1910787420661906989922381e+299, "11910787420661907", 300},
    {7.4982955633516711017742753e-39, "7498295563351671", -38},
    {4.8618184163855463325802732e-104, "48618184163855463", -103},
    {1.3649427592220837556404667e+35, "13649427592220838", 36},
    {3.9714092148515531601073650e-207, "3971409214851553", -206},
    {3.7930897494913180394161038e-295, "3793089749491318", -294},
    {6.8379435632429117288842404e-32, "6837943563242912", -31},
    {5.8272044213700475145250829e-285, "58272044213700475", -284},
    {1.7785496036932040416871268e-162, "1778549603693204", -161},
    {9.0299212028721352727577932e+78, "9029921202872135", 79},
    {9.0017877067630225063801214e-256, "9001787706763023", -255},
    {2.3321077475488672101015575e-202, "2332107747548867", -201},
    {3.2189633270593462695418095e-211, "32189633270593463", -210},
    {2.2786482486539913394368595e-18, "22786482486539913", -17},
    {5.1916801186006881705817134e+46, "5191680118600688", 47},
    {7.7437580724913888339777421e-183, "7743758072491389", -182},
    {3.6696981583718865524482314e+77, "36696981583718866", 78},
    {1.9364621261163388839550072e+186, "1936462126116339", 187},
    {8.3853935236756863089461149e-40, "8385393523675686", -39},
    {5.5672015761652599223301752e-18, "556720157616526", -17},
    {1.2922367337138568908901890e-116, "1292236733713857", -115},
    {5.1698715105501714612330804e-305, "5169871510550171", -304},
    {1.4738280880153443984485931e-181, "14738280880153444", -180},
    {1.1328277011820827515499823e+85, "11328277011820828", 86},
    {1.0386069643337486898998883e-32, "10386069643337487", -31},
    {1.2949901951997916762323978e+305, "12949901951997917", 306},
    {2.3468659534271739405263875e-164, "2346865953427174", -163},
    {1.8450207262452396337899497e-146, "18450207262452396", -145},
    {1.1082588124240349465865408e+30, "1108258812424035", 31},
    {2.4814325734055008850168470e+160, "2481432573405501", 161},
    {2.1996408962542991162635202e-194, "2199640896254299", -193},
    {1.5646730589100716818232146e-30, "15646730589100717", -29},
    {1.6146220160741855679700725e-171, "16146220160741856", -170},
    {2.8192509385274213858880221e+97, "28192509385274214", 98},
    {3.0845580518738370370219259e-36, "3084558051873837", -35},
    {8.0534363759168115756755819e+195, "8053436375916812", 196},
    {5.8505397739052996926499987e-248, "58505397739053", -247},
    {7.3257396553298948915200000e+21, "7325739655329895", 22},
    {1.7225129021593573093414307e+09, "17225129021593573", 10},
    {1.0873452857913325763731151e-126, "10873452857913326", -125},
    {5.1268217360800538068229601e+60, "5126821736080054", 61},
    {1.0793009253609140532530360e-222, "1079300925360914", -221},
    {1.1332793267352014848000000e+19, "11332793267352015", 20},
    {1.3328087913834937549466636e-148, "13328087913834938", -147},
    {4.9186874387370259429751161e-114, "4918687438737026", -113},
    {1.2032652964601620830326094e-194, "12032652964601621", -193},
    {2.0317269898542571981521925e-43, "2031726989854257", -42},
    {5.3671579037694138853142218e-263, "5367157903769414", -262},
    {7.1843581642191733677984796e+105, "7184358164219173", 106},
    {1.5823203797718376727374541e+229, "15823203797718377", 230},
    {9.1398961111577040567913823e+139, "9139896111157704", 140},
    {9.2669740328104026538398553e+177, "9266974032810403", 178},
    {2.9008076576373267956674381e+182, "2900807657637327", 183},
    {1.0279769352129479668807945e+189, "1027976935212948", 190},
    {2.2724816295263195637051911e+183, "22724816295263196", 184},
    {4.7634583212179946684491154e+112, "4763458321217995", 113},
    {3.9122191247316680737921764e+160, "3912219124731668", 161},
    {1.9110076484670996346585815e-12, "19110076484670996", -11},
    {1.7802934270278109212536820e-163, "1780293427027811", -162},
    {7.8478292301093941789686426e+135, "7847829230109394", 136},
    {3.8419946500202969359482527e-108, "3841994650020297", -107},
    {1.7586268988646280342017345e-288, "1758626898864628", -287},
    {5.2048893971499542361708796e+73, "5204889397149954", 74},
    {4.8624800438964738814900291e+245, "4862480043896474", 246},
    {3.5635674387752638960190169e+71, "3563567438775264", 72},
    {7.5943494778752419914050659e+178, "7594349477875242", 179},
    {9.6142312061026636013898123e-46, "9614231206102664", -45},
    {8.7446026452800817985178128e-01, "8744602645280082", 0},
    {3.9946004164499969287086126e-297, "3994600416449997", -296},
    {5.6005012393377726207442819e+194, "56005012393377726", 195},
    {4.5723910495943130686319947e+181, "4572391049594313", 182},
    {1.5064638647853439744057475e-221, "1506463864785344", -220},
    {1.4141452768865123701402808e+00, "14141452768865124", 1},
    {4.3094951667456627562058146e-164, "4309495166745663", -163},
    {1.9804172372304196345426886e-72, "19804172372304196", -71},
    {2.6744625952149199469252634e-91, "267446259521492", -90},
    {2.5566817850302643844463381e+250, "25566817850302644", 251},
    {1.0783343889021825160156858e+192, "10783343889021825", 193},
    {1.9534116402011035980212467e+72, "19534116402011036", 73},
    {2.0926387206757129025321642e-105, "2092638720675713", -104},
    {6.0802382147382250832663370e+204, "6080238214738225", 205},
    {1.4351740787815576119804996e-122, "14351740787815576", -121},
    {3.3791162906434643401163241e+143, "33791162906434643", 144},
    {1.3338200934315011738341020e-85, "13338200934315012", -84},
    {9.5567491977339904491779423e+206, "955674919773399", 207},
    {9.1923912658660522293627823e+98, "9192391265866052", 99},
    {2.6735540662138548571311060e-103, "2673554066213855", -102},
    {2.6254601981034550124343611e-193, "2625460198103455", -192},
    {1.9055530720689897871941096e-205, "19055530720689898", -204},
    {5.0220587553292940924662835e-231, "5022058755329294", -230},
    {1.5327705885220532877610822e+02, "15327705885220533", 3},
    {4.5660536848344661081275112e+283, "4566053684834466", 284},
    {3.9731675419379935840595634e-59, "39731675419379936", -58},
    {7.9257728709863056594210267e+33, "7925772870986306", 34},
    {2.9397914385858531894547421e-264, "2939791438585853", -263},
    {2.2022292106119231553306925e-79, "22022292106119232", -78},
    {7.0098610914322562437142104e-132, "7009861091432256", -131},
    {1.4792628538883352508082474e-111, "14792628538883353", -110},
    {5.1260883661921026576154798e-28, "5126088366192103", -27},
    {1.0233503820991993851970420e+139, "10233503820991994", 140},
    {5.0616879583941229351293323e+280, "5061687958394123", 281},
    {3.8971773804602373032089292e-32, "38971773804602373", -31},
    {9.8364286764534381653183194e-149, "9836428676453438", -148},
    {3.7799622152095745317688213e-183, "37799622152095745", -182},
    {6.9271738490330586870258587e-211, "6927173849033059", -210},
    {7.8506355293351458022475984e-288, "7850635529335146", -287},
    {1.9915961442966956654810017e-23, "19915961442966957", -22},
    {1.1765105273385500694804470e-62, "117651052733855", -61},
    {9.8460498109763876024263337e-109, "9846049810976388", -108},
    {1.1076196023152907223602755e+129, "11076196023152907", 130},
    {1.4592515617467590723295391e+166, "1459251561746759", 167},
    {8.9964151866621400449024000e+23, "899641518666214", 24},
    {1.3740146206712191115737288e-83, "13740146206712191", -82},
    {1.8698290471721408207198134e-289, "18698290471721408", -288},
    {1.3573610264881725937333798e+243, "13573610264881726", 244},
    {6.5394763102954047575125914e+171, "6539476310295405", 172},
    {2.0114875190351737765010663e-266, "20114875190351738", -265},
    {1.6407725503428329473803576e-108, "1640772550342833", -107},
    {4.7910888264913595010531778e+278, "47910888264913595", 279},
    {1.3665794356682625640101961e+217, "13665794356682626", 218},
    {3.6782687356576041040717833e-109, "3678268735657604", -108},
    {2.5348091717284749045917246e-185, "2534809171728475", -184},
    {2.4360164235669834445687204e-40, "24360164235669834", -39},
    {5.3996549695324629908870092e-92, "5399654969532463", -91},
    {1.0526619754480161026206133e-07, "10526619754480161", -6},
    {1.2082247582463386945855228e-129, "12082247582463387", -128},
    {3.1464180207608518755638211e-86, "3146418020760852", -85},
    {1.2296700541144848908952282e+245, "1229670054114485", 246},
    {5.0292533104773498556206606e+111, "502925331047735", 112},
    {1.4281889212950926797838866e+293, "14281889212950927", 294},
    {3.8940188328420704950576742e+27, "38940188328420705", 28},
    {2.4120665220895337382135020e-127, "24120665220895337", -126},
    {1.2513049650944668203902338e+178, "12513049650944668", 179},
    {1.6495656900649183414817485e-301, "16495656900649183", -300},
    {3.2446106553577447237604478e+74, "32446106553577447", 75},
    {8.7417518975562034891419372e-30, "8741751897556203", -29},
    {5.6808905988379922863407145e-04, "5680890598837992", -3},
    {4.5757417511303292172750539e+262, "4575741751130329", 263},
    {1.1706348337557982958489740e+168, "11706348337557983", 169},
    {6.6693424200426728930324316e+05, "6669342420042673", 6},
    {2.6828994524119759805308576e-108, "2682899452411976", -107},
    {2.8471840409712533695661779e+134, "28471840409712534", 135},
    {8.2531193526553200000000000e+15, "825311935265532", 16},
    {1.1837733563757292981853828e+237, "11837733563757293", 238},
    {7.4967081744024106228824920e+124, "7496708174402411", 125},
    {2.6424551791454638772371771e+53, "2642455179145464", 54},
    {1.2293779562417317853714245e-64, "12293779562417318", -63},
    {1.2338830408974041814663710e+125, "12338830408974042", 126},
    {2.5898192614644340362657887e+113, "2589819261464434", 114},
    {2.9717164945374288931374872e+189, "2971716494537429", 190},
    {2.5218858322910729863771532e+113, "2521885832291073", 114},
    {3.2416515727499994881100065e+00, "32416515727499995", 1},
    {2.5351069785209390876396973e-261, "2535106978520939", -260},
    {8.0008856421545325929222615e+209, "8000885642154533", 210},
    {1.7048987979551376287254020e-261, "17048987979551376", -260},
    {1.7176384565154910552829032e-199, "1717638456515491", -198},
    {9.5977150585869162899750172e-278, "9597715058586916", -277},
    {7.2735385942072760161598523e+196, "7273538594207276", 197},
    {2.3238604380578396220497832e-306, "23238604380578396", -305},
    {7.1733420667528667968676097e-300, "7173342066752867", -299},
    {5.4907315685353299791156881e-180, "549073156853533", -179},
    {8.2236113763926159715191462e+220, "8223611376392616", 221},
    {4.8236614016790710820145422e-23, "4823661401679071", -22},
    {5.6132166808739492844672025e-289, "5613216680873949", -288},
    {6.4389620966508199266342898e-201, "643896209665082", -200},
    {1.2033151250360086348698108e-292, "12033151250360086", -291},
    {5.4978071566067584112409591e-50, "5497807156606758", -49},
    {1.5146023359070848607643156e-287, "1514602335907085", -286},
    {9.5506861685257220241286516e+205, "9550686168525722", 206},
    {2.3416829589221086860833640e-219, "23416829589221087", -218},
    {2.7902937234771851753145224e-65, "2790293723477185", -64},
    {4.8669220993302721742858581e+180, "4866922099330272", 181},
    {3.6717375862485726130587354e-159, "36717375862485726", -158},
    {2.2538042049851821750044947e-92, "22538042049851822", -91},
    {3.4672106863880804346423802e+307, "34672106863880804", 308},
    {1.0433787070573929873404655e-148, "1043378707057393", -147},
    {1.0880557804912599299239007e+156, "108805578049126", 157},
    {2.3397960218370559134501478e-130, "2339796021837056", -129},
    {2.3059334399087812163885144e+81, "23059334399087812", 82},
    {2.1105687989146312821596774e-192, "21105687989146313", -191},
    {1.4974194788424993494844739e-172, "14974194788424993", -171},
    {2.0621109979779845259337873e-253, "20621109979779845", -252},
    {2.1670382932929508256483349e-123, "21670382932929508", -122},
    {1.6606431072194817476630998e+128, "16606431072194817", 129},
    {5.7160022504645246731266228e+186, "5716002250464525", 187},
    {1.6995889345826749551157947e-59, "1699588934582675", -58},
    {1.5404053715551662022935059e+48, "15404053715551662", 49},
    {1.3380743675438689351573885e-42, "1338074367543869", -41},
    {2.2370876731726711723689074e-12, "2237087673172671", -11},
    {4.5152588285712480736204398e+248, "4515258828571248", 249},
    {4.8978661470144365996497173e-183, "4897866147014437", -182},
    {4.6632870584233543084509355e-154, "4663287058423354", -153},
    {1.3686602519995050623718003e-289, "1368660251999505", -288},
    {6.2718055255988272998095010e-112, "6271805525598827", -111},
    {6.6968553888914611965317920e+214, "6696855388891461", 215},
    {4.2036848973630943940255024e-31, "4203684897363094", -30},
    {1.0666335089663789655782584e+56, "1066633508966379", 57},
    {4.6709130480691032520950093e+244, "4670913048069103", 245},
    {1.6370129018384688611165479e-164, "16370129018384689", -163},
    {1.6302353785702477695846714e+203, "16302353785702478", 204},
    {3.2025184219491900039357214e+217, "320251842194919", 218},
    {9.1956686053140301117221478e-245, "919566860531403", -244},
    {2.8060224706045507546622015e-201, "28060224706045508", -200},
    {1.4870004111799860841790243e-67, "1487000411179986", -66},
    {7.1854199718995178107995823e+82, "7185419971899518", 83},
    {1.0972573441628242210353311e-172, "10972573441628242", -171},
    {5.1568807160825127429042499e-232, "5156880716082513", -231},
    {8.4299415579831097819630866e-178, "842994155798311", -177},
    {1.0037698183112782414176208e+156, "10037698183112782", 157},
    {5.7968097377872275066588427e-198, "57968097377872275", -197},
    {1.0974753598969427493731155e-233, "10974753598969427", -232},
    {5.2933705789450391943767871e-05, "5293370578945039", -4},
    {8.4416028109919086119975676e+255, "8441602810991909", 256},
    {2.5920416117830482636368907e+80, "25920416117830483", 81},
    {2.5345880735978398012169749e-302, "253458807359784", -301},
    {1.2219651938984676256731969e-139, "12219651938984676", -138},
    {1.0517833299562782024326519e-62, "10517833299562782", -61},
    {8.1537807174497385480712005e+106, "8153780717449739", 107},
    {4.4578547972283219538454679e+259, "4457854797228322", 260},
    {1.3105469238005728970249195e-155, "1310546923800573", -154},
    {5.1026764386347493708103051e-136, "5102676438634749", -135},
    {1.0251490084844852484679869e-303, "10251490084844852", -302},
    {1.4449215083579018808804525e+62, "14449215083579019", 63},
    {8.1910605580949580589028569e-04, "8191060558094958", -3},
    {1.3712149262285771236562432e-48, "1371214926228577", -47},
    {6.8882326530351287515267607e+70, "6888232653035129", 71},
    {7.4226813084974502188787607e+231, "742268130849745", 232},
    {1.6599606262673922604661416e-45, "16599606262673923", -44},
    {4.9801295726246993200928705e-36, "4980129572624699", -35},
    {1.8001296735166054219007492e+07, "18001296735166054", 8},
    {1.0380787305719134923223120e+108, "10380787305719135", 109},
    {1.1232194160797771454687252e-40, "11232194160797771", -39},
    {1.2437190168042845572764214e-17, "12437190168042846", -16},
    {1.0080464981173672037961776e-178, "10080464981173672", -177},
    {7.2364574786149580023859620e-13, "7236457478614958", -12},
    {1.7803804627662683688358595e+39, "17803804627662684", 40},
    {1.5762956368684295836364220e+55, "15762956368684296", 56},
    {7.7395215382054821009816766e+138, "7739521538205482", 139},
    {1.3932298902578353576033735e+102, "13932298902578354", 103},
    {3.2943598840111197537617331e+78, "32943598840111198", 79},
    {3.8675661178382364538537108e+112, "38675661178382365", 113},
    {1.7749489391544330092458693e+182, "1774948939154433", 183},
    {1.7091016495728041384761843e+154, "1709101649572804", 155},
    {1.5380590254734341890580983e+52, "15380590254734342", 53},
    {8.8805973223088814606859985e+163, "8880597322308881", 164},
    {1.3934141671834487197439867e+80, "13934141671834487", 81},
    {4.7960831048585696670336826e-301, "479608310485857", -300},
    {1.6709571259637311037702022e-139, "16709571259637311", -138},
    {8.8077672170491876187105756e-64, "8807767217049188", -63},
    {3.8464749086297650326861385e+235, "3846474908629765", 236},
    {6.5337856397177516649332083e+254, "6533785639717752", 255},
    {3.7154956108153091692461840e+276, "3715495610815309", 277},
    {5.2983266703857870985657922e+110, "5298326670385787", 111},
    {2.2708803840232348322531321e-197, "22708803840232348", -196},
    {6.4984722076309425885571616e+34, "6498472207630943", 35},
    {2.1195141590667412037700661e+179, "21195141590667412", 180},
    {1.3185208768295181354127247e+77, "13185208768295181", 78},
    {1.7205620037874346855810469e-12, "17205620037874347", -11},
    {2.7563239216007029994610359e+73, "2756323921600703", 74},
    {5.2501026176083256030751896e-56, "5250102617608326", -55},
    {8.4956652689912737616608342e+48, "8495665268991274", 49},
    {5.2531685316623553619017568e-217, "5253168531662355", -216},
    {1.0157603188743370217218603e-277, "1015760318874337", -276},
    {1.1302536988284363938826038e-219, "11302536988284364", -218},
    {4.0354466214112741898803844e+295, "4035446621411274", 296},
    {6.4456489617474181081157631e+165, "6445648961747418", 166},
    {2.1747297681069693230070798e-150, "21747297681069693", -149},
    {4.0823122358736768807973769e+95, "4082312235873677", 96},
    {1.2536729004158951867373127e+103, "12536729004158952", 104},
    {7.4331861843975976887090729e+205, "7433186184397598", 206},
    {3.2070033423347115844161261e-254, "32070033423347116", -253},
    {3.6166247299888466208487919e-147, "36166247299888466", -146},
    {1.3875740501844956461313510e-51, "13875740501844956", -50},
    {1.7753195507582752940553828e+292, "17753195507582753", 293},
    {3.6685740643179031163405257e-181, "3668574064317903", -180},
    {8.5813689355936762076534216e+254, "8581368935593676", 255},
    {3.8002864529298315898003666e-152, "38002864529298316", -151},
    {1.2329793690961293376333148e+226, "12329793690961293", 227},
    {2.2315204493450513949985103e+303, "22315204493450514", 304},
    {1.4305344561815433484468266e-137, "14305344561815433", -136},
    {4.1351467871896148800048647e-91, "4135146787189615", -90},
    {1.2940566725093172488134097e-05, "12940566725093172", -4},
    {9.6040449636443408329418847e-173, "9604044963644341", -172},
    {2.3107569944525027298577884e-272, "23107569944525027", -271},
    {1.7884238680866767938574202e+297, "17884238680866768", 298},
    {1.9056147012294236220477805e-231, "19056147012294236", -230},
    {7.7187519497405090659015874e-226, "7718751949740509", -225},
    {2.5583525916320735148941643e-228, "25583525916320735", -227},
    {1.1304722887844378372338241e+145, "11304722887844378", 146},
    {2.2843127929577701637273235e+170, "22843127929577702", 171},
    {1.3357814514793636577497099e+194, "13357814514793637", 195},
    {4.4536156361829579235030238e-131, "4453615636182958", -130},
    {9.9178522384803427881692535e+101, "9917852238480343", 102},
    {2.8828035043720178016769017e+41, "28828035043720178", 42},
    {4.7598991027531936940416751e-97, "4759899102753194", -96},
    {4.9304446089894058193039259e+288, "4930444608989406", 289},
    {3.6493520556707811097351668e+240, "3649352055670781", 241},
    {1.7268555540542615313038207e+100, "17268555540542615", 101},
    {2.5760561209608738661617024e-82, "2576056120960874", -81},
    {2.0819861070326738149058099e+211, "20819861070326738", 212},
    {4.0888228042201219568571230e-207, "4088822804220122", -206},
    {2.2192749818316676843327966e-281, "22192749818316677", -280},
    {1.1377718022751823424009743e-292, "11377718022751823", -291},
    {2.8697226611382521396765467e-191, "2869722661138252", -190},
    {1.2276238397882745844891450e-292, "12276238397882746", -291},
    {1.9588558506979096233800570e+115, "19588558506979096", 116},
    {1.4489580633457990119442637e-89, "1448958063345799", -88},
    {6.4756561826956404038189743e-185, "647565618269564", -184},
    {1.1357117424235910644531250e+12, "1135711742423591", 13},
    {5.2045060888287628059711452e+290, "5204506088828763", 291},
    {5.0014350440589761750701143e-288, "5001435044058976", -287},
    {1.6062964467301976123193422e+170, "16062964467301976", 171},
    {1.3916569969497448528920660e-235, "13916569969497449", -234},
    {1.6854632016263227938848504e-203, "16854632016263228", -202},
    {7.8715364656579273070520019e-78, "7871536465657927", -77},
    {7.1909604520997437337247248e-188, "7190960452099744", -187},
    {2.1115597967290950595715987e+116, "2111559796729095", 117},
    {3.4779483741586523076722099e+183, "34779483741586523", 184},
    {2.8642567254651060430951699e-83, "2864256725465106", -82},
    {3.5642564658521939679283748e-66, "3564256465852194", -65},
    {1.2528448381857167548052115e+150, "12528448381857168", 151},
    {1.1314842753915225775954858e+231, "11314842753915226", 232},
    {1.1986186217013772639661262e-03, "11986186217013773", -2},
    {2.8323568192841637897843772e+63, "28323568192841638", 64},
    {5.5215191350816995177067212e+51, "55215191350816995", 52},
    {6.8264543295369560571695279e-153, "6826454329536956", -152},
    {5.7456781600565013632545082e-45, "5745678160056501", -44},
    {5.0117810971649512139309192e-189, "5011781097164951", -188},
    {1.3681816749684279637837157e-78, "1368181674968428", -77},
    {1.3074917870375277945871945e-146, "13074917870375278", -145},
    {4.3630640198991296386718750e+11, "43630640198991296", 12},
    {4.5725219656921523386741385e-271, "45725219656921523", -270},
    {2.0773818501600807763582157e+232, "20773818501600808", 233},
    {1.6633416199162176004073604e-111, "16633416199162176", -110},
    {2.9909210130509644794533591e+64, "29909210130509645", 65},
    {5.5318977396391871376720634e+262, "5531897739639187", 263},
    {8.0978876750173126058848222e-116, "8097887675017313", -115},
    {1.2783076555611911716504511e-295, "12783076555611912", -294},
    {8.3278886728459266444025055e-129, "8327888672845927", -128},
    {2.2870548321039163701417974e-131, "22870548321039164", -130},
    {1.9724507597886691278744175e-246, "19724507597886691", -245},
    {5.8526874343783015650382338e+292, "5852687434378302", 293},
    {5.3063001422615781945096793e+263, "5306300142261578", 264},
    {8.1058954283935094494566810e+147, "810589542839351", 148},
    {6.4597995027232021790005482e-180, "6459799502723202", -179},
    {8.4078233390415778156770065e+108, "8407823339041578", 109},
    {2.5773628119227243600165429e+209, "25773628119227244", 210},
    {6.9574298555334700527156115e-140, "695742985553347", -139},
    {8.6729179593486108831448465e+167, "8672917959348611", 168},
    {4.2444257926725188805052534e-241, "4244425792672519", -240},
    {7.3953799870487550140663708e-167, "7395379987048755", -166},
    {8.0646170278428040048537944e-13, "8064617027842804", -12},
    {3.6315528045323834076359254e-98, "36315528045323834", -97},
    {2.4925406761749203176652800e+24, "24925406761749203", 25},
    {1.0725283438798030300062613e+54, "1072528343879803", 55},
    {3.2341971122763896877409699e-21, "32341971122763897", -20},
    {1.6861228475640931055486270e-269, "1686122847564093", -268},
    {2.3348036051969160718000019e-94, "2334803605196916", -93},
    {6.4514662039073193237822437e-277, "6451466203907319", -276},
    {2.3959701626439876887218209e+142, "23959701626439877", 143},
    {6.9886923531359740793719125e+110, "6988692353135974", 111},
    {2.6680499968853912760679030e-183, "26680499968853913", -182},
    {2.7320818939070885121098113e+255, "27320818939070885", 256},
    {4.6428400464453277211052140e-08, "4642840046445328", -7},
    {1.7709996946288434652796847e-296, "17709996946288435", -295},
    {3.2888627013048411273605576e-255, "3288862701304841", -254},
    {1.8131423291284462940425870e-04, "18131423291284463", -3},
    {3.1293111491450273676892883e-131, "31293111491450274", -130},
    {9.7350518761184462711161897e-100, "9735051876118446", -99},
    {1.6042549273449272668128043e-242, "16042549273449273", -241},
    {2.8792347708201219994827867e+191, "2879234770820122", 192},
    {1.2655595321084907950550937e+184, "12655595321084908", 185},
    {5.9829383777697237831753075e+215, "5982938377769724", 216},
    {1.5176944200733498424445691e-252, "15176944200733498", -251},
    {7.8897650913264546064120720e+151, "7889765091326455", 152},
    {1.5409864122093046520006142e-64, "15409864122093047", -63},
    {6.3387553705539615423100608e-115, "63387553705539615", -114},
    {6.2384534816780949197528751e+177, "6238453481678095", 178},
    {3.3710059091502359382529190e+203, "3371005909150236", 204},
    {1.7868706373964780595997581e+03, "1786870637396478", 4},
    {9.1584908909854190083840559e-200, "9158490890985419", -199},
    {6.2147142589642040715412688e+278, "6214714258964204", 279},
    {3.0677083519967800800148011e+75, "306770835199678", 76},
    {2.9041577198783558732699081e-162, "2904157719878356", -161},
    {3.3181003056906693758076209e-126, "33181003056906694", -125},
    {1.4189038975026049704264705e+276, "1418903897502605", 277},
    {1.7715684628939234199843056e-308, "17715684628939234", -307},
    {2.8947445733314162644992327e-176, "28947445733314163", -175},
    {1.3931325732149673315632382e-247, "13931325732149673", -246},
    {1.3784561201664248067709107e-96, "13784561201664248", -95},
    {3.2914374320203010948545882e-282, "3291437432020301", -281},
    {3.5158137628449935274537638e-101, "35158137628449935", -100},
    {1.7125966736073938734173925e-202, "17125966736073939", -201},
    {1.1434818761262837096886662e+204, "11434818761262837", 205},
    {1.3544687567822677195784595e+209, "13544687567822677", 210},
    {4.7825699391724967054489926e-72, "4782569939172497", -71},
    {1.2261691911832524853782386e+80, "12261691911832525", 81},
    {1.2834544723579505932538712e-197, "12834544723579506", -196},
    {2.2318594445077259558350614e+82, "2231859444507726", 83},
    {7.2858783499593196886685555e-191, "728587834995932", -190},
    {1.2478169142101404362668396e-232, "12478169142101404", -231},
    {3.7293510928981833716028946e-24, "37293510928981834", -23},
    {1.2456681674324785882303820e-40, "12456681674324786", -39},
    {1.1262247915040660334945360e-48, "1126224791504066", -47},
    {1.1661696626092746552535164e+134, "11661696626092747", 135},
    {1.2554020632495354551899393e+285, "12554020632495355", 286},
    {1.0038296834152746922587743e-127, "10038296834152747", -126},
    {1.1045342429010635220227997e-215, "11045342429010635", -214},
    {2.7506215184895269534074979e-67, "2750621518489527", -66},
    {2.5825647816506667256508017e+167, "25825647816506667", 168},
    {6.4520219292862975382737797e+253, "6452021929286298", 254},
    {2.1844770783697481517593168e+153, "2184477078369748", 154},
    {1.4341796914231177510515627e-252, "14341796914231178", -251},
    {1.5877881861181821476923944e-274, "15877881861181821", -273},
    {2.0473183895894039435655538e+126, "2047318389589404", 127},
    {1.4332126998404281873203200e+23, "14332126998404282", 24},
    {8.0311650569856838214926814e+283, "8031165056985684", 284},
    {1.0859398854840917286740188e+225, "10859398854840917", 226},
    {2.3550916420308781165844095e-77, "2355091642030878", -76},
    {1.3089961052379846041750284e+250, "13089961052379846", 251},
    {1.9679942830173715439986097e+292, "19679942830173715", 293},
    {4.5506189331749800312013204e+151, "455061893317498", 152},
    {7.5800944972956652534063966e-134, "7580094497295665", -133},
    {1.1070349969633736083549576e+218, "11070349969633736", 219},
    {4.6523292453630443830874355e-266, "46523292453630444", -265},
    {1.5729909578346735622532022e+148, "15729909578346736", 149},
    {5.5721752209778390157031917e+250, "5572175220977839", 251},
    {1.3833052496376451094940523e+53, "13833052496376451", 54},
    {1.0446287683678079247174761e-05, "1044628768367808", -4},
    {1.2736741933019433542829809e-294, "12736741933019434", -293},
    {2.1963106401794434605911114e+279, "21963106401794435", 280},
    {2.1023194348014118882070061e+109, "2102319434801412", 110},
    {2.9175430066663957446731077e-65, "29175430066663957", -64},
    {1.0455241503577705635668013e-20, "10455241503577706", -19},
    {1.1863610995687560487938309e+204, "1186361099568756", 205},
    {3.3251166733668619060221718e+210, "3325116673366862", 211},
    {3.4186000200089671798968762e+165, "3418600020008967", 166},
    {1.0373929048709185554512420e-37, "10373929048709186", -36},
    {1.0200447283956908385218457e+46, "10200447283956908", 47},
    {4.1574564642467821541643959e+268, "4157456464246782", 269},
    {1.9045931102628056043299304e-100, "19045931102628056", -99},
    {7.6400505597732784775620338e+297, "7640050559773278", 298},
    {6.7290330986918671110775382e-227, "6729033098691867", -226},
    {2.0207351080269343325711726e-81, "20207351080269343", -80},
    {3.5764439155193740757481615e+235, "3576443915519374", 236},
    {4.8883469516781900024571583e+194, "488834695167819", 195},
    {8.2197604806466550454706524e-132, "8219760480646655", -131},
    {2.8027351756945872764684481e-244, "28027351756945873", -243},
    {3.1532311425374805146151016e-148, "31532311425374805", -147},
    {2.6715888949552985588475278e+265, "26715888949552986", 266},
    {1.1443823791696399343506353e+235, "114438237916964", 236},
    {4.5879911171788405558947310e+140, "45879911171788406", 141},
    {5.6187987416436058507995456e+171, "5618798741643606", 172},
    {1.5515787577130243328080578e-235, "15515787577130243", -234},
    {5.6636034620457291432594374e-49, "5663603462045729", -48},
    {1.5971904756249467787411551e-136, "15971904756249468", -135},
    {2.2897954684950440256777898e+38, "2289795468495044", 39},
    {6.6134811812361020038370561e+174, "6613481181236102", 175},
    {4.8598560178601785301450960e+34, "48598560178601785", 35},
    {2.3556900867432734045828963e+232, "23556900867432734", 233},
    {1.0025121860077949433641747e+152, "1002512186007795", 153},
    {2.9746722962902046849711645e-294, "29746722962902047", -293},
    {2.5558498352840094870212482e-90, "25558498352840095", -89},
    {3.1620918978148941896282142e+274, "3162091897814894", 275},
    {3.6110229042925451132490800e-84, "3611022904292545", -83},
    {8.3103147311081377187647268e+71, "8310314731108138", 72},
    {1.1184986977080930308374900e-252, "1118498697708093", -251},
    {1.2095216681470519411998665e+199, "1209521668147052", 200},
    {2.1869104833645769526868340e+85, "2186910483364577", 86},
    {2.3770310565098876193491033e+131, "23770310565098876", 132},
    {2.5494858355846014642965173e+136, "25494858355846015", 137},
    {6.2923714668348703735648499e+117, "629237146683487", 118},
    {1.6048237576304423767135285e-58, "16048237576304424", -57},
    {1.0567110572099619218696182e+226, "10567110572099619", 227},
    {7.2066303394549738125082302e-112, "7206630339454974", -111},
    {1.6413805796960802312442977e+29, "16413805796960802", 30},
    {4.1529712323740360352476083e+228, "4152971232374036", 229},
    {5.8240994078968816533213158e-67, "58240994078968817", -66},
    {1.1260193983544749439451964e-207, "1126019398354475", -206},
    {8.7979913057227606168858343e-88, "8797991305722761", -87},
    {4.8240432255269586162913745e-90, "4824043225526959", -89},
    {1.8833073953609966121326064e+283, "18833073953609966", 284},
    {3.7115966060455796085635905e+209, "37115966060455796", 210},
    {1.2876467320107213592584757e-46, "12876467320107214", -45},
    {2.6149391522353740999161276e+171, "2614939152235374", 172},
    {3.1360255400481140242163747e+01, "3136025540048114", 2},
    {1.5552096448604130702389965e-162, "1555209644860413", -161},
    {1.5741954862263348969344174e-67, "1574195486226335", -66},
    {3.2104055263305149676898041e+139, "3210405526330515", 140},
    {5.5183184105360058380121378e+124, "5518318410536006", 125},
    {8.3261586370180013624749758e+279, "8326158637018001", 280},
    {6.0815531387199453931186109e+255, "6081553138719945", 256},
    {5.3272568390728028344131329e-241, "5327256839072803", -240},
    {2.4137029886896665556091631e-46, "24137029886896666", -45},
    {4.2565425330796840000000000e+15, "4256542533079684", 16},
    {4.3019361729303997503964026e+118, "43019361729304", 119},
    {1.7494767582005611130823445e-198, "1749476758200561", -197},
    {8.5737682183426591699589373e+61, "8573768218342659", 62},
    {1.3316799922813578122721952e-83, "13316799922813578", -82},
    {2.0416596600594227324745918e-203, "20416596600594227", -202},
    {1.4418279070418875149217354e+233, "14418279070418875", 234},
    {3.7300118091847911383496239e-01, "3730011809184791", 0},
    {2.7241298172350163011508881e-215, "27241298172350163", -214},
    {7.6410731888612677225334535e+207, "7641073188861268", 208},
    {4.4800651032076378856671191e-10, "4480065103207638", -9},
    {1.3431589483270179482991708e+52, "1343158948327018", 53},
    {2.7907616373042363730340186e+120, "27907616373042364", 121},
    {2.2710811000668456097944113e+147, "22710811000668456", 148},
    {1.0310560928498461222216328e-294, "10310560928498461", -293},
    {7.2490165473126326951192344e-53, "7249016547312633", -52},
    {1.0295489694222769265578160e+151, "10295489694222769", 152},
    {1.0823327104346081955654491e+198, "10823327104346082", 199},
    {3.3313652616036699972878513e+265, "333136526160367", 266},
    {2.3508855252504645385339549e+54, "23508855252504645", 55},
    {2.3241864083989877000878785e+96, "23241864083989877", 97},
    {1.5828067696288259656290140e+28, "1582806769628826", 29},
    {4.8316008110280653902495271e-150, "48316008110280654", -149},
    {5.4498967375931205026698815e+57, "54498967375931205", 58},
    {1.2077989674335671697559230e-299, "12077989674335672", -298},
    {1.5130662048737783773850142e+49, "15130662048737784", 50},
    {3.1940200155804224816629378e-255, "31940200155804225", -254},
    {3.5787725697923128677269242e+28, "3578772569792313", 29},
    {1.5630570913225700024895559e+01, "156305709132257", 2},
    {3.2051299605611737898920967e+274, "32051299605611738", 275},
    {5.3201350964635862350719217e-92, "5320135096463586", -91},
    {6.8578443025946729860395944e-79, "6857844302594673", -78},
    {2.4844668760201505505258379e-278, "24844668760201506", -277},
    {9.3906824332938343237560278e+102, "9390682433293834", 103},
    {1.2388060222883643582463264e+06, "12388060222883644", 7},
    {1.1870565312296102423958800e+193, "11870565312296102", 194},
    {1.2993325684730348119746620e-125, "12993325684730348", -124},
    {2.3142389714674421227700934e-192, "2314238971467442", -191},
    {1.0252342337259344000000000e+17, "10252342337259344", 18},
    {3.0706396631779025795447603e+271, "30706396631779026", 272},
    {3.2910882673307369128314728e+165, "3291088267330737", 166},
    {2.5385666607238424931511705e-192, "25385666607238425", -191},
    {4.2723502526216069363163734e-80, "4272350252621607", -79},
    {2.5498530988893162857831024e-241, "25498530988893163", -240},
    {7.9822387718079191516445188e-58, "7982238771807919", -57},
    {4.3748790608993785321724108e-19, "4374879060899379", -18},
    {2.5759947123686376171226425e+37, "25759947123686376", 38},
    {3.6070905821138078346582968e+42, "3607090582113808", 43},
    {9.1786002719024120837128634e+52, "9178600271902412", 53},
    {1.2929007859771770654333523e+03, "1292900785977177", 4},
    {2.3932972988524930935857066e+106, "2393297298852493", 107},
    {4.8224854431179834500929189e-63, "48224854431179835", -62},
    {2.1083686098835173551382899e-234, "21083686098835174", -233},
    {3.3931346174876987230297512e+101, "3393134617487699", 102},
    {7.3039971930680739404542907e-252, "7303997193068074", -251},
    {3.0159177631111513884547794e-228, "30159177631111514", -227},
    {3.5658982496006919133127913e+253, "3565898249600692", 254},
    {1.9870734557738651297622343e+37, "19870734557738651", 38},
    {2.5441518091202804029543547e-175, "25441518091202804", -174},
    {3.3098565127990029296875000e+12, "3309856512799003", 13},
    {2.9297104460733678194826266e+209, "2929710446073368", 210},
    {3.5887452809618842657928663e+283, "35887452809618843", 284},
    {1.2583813826128782231918558e+299, "12583813826128782", 300},
    {2.3430802544919475133049149e+97, "23430802544919475", 98},
    {1.0699319674466580650619429e+106, "1069931967446658", 107},
    {7.7120998891592054929466507e+153, "7712099889159205", 154},
    {3.2602438200357537981993461e+136, "3260243820035754", 137},
    {1.0187631880525138867129273e-143, "10187631880525139", -142},
    {1.5328407850720861093107581e-88, "1532840785072086", -87},
    {3.4579297026652092700831989e+171, "34579297026652093", 172},
    {1.9201374552908948847902627e-146, "19201374552908949", -145},
    {1.7048464136605360591368434e-10, "1704846413660536", -9},
    {1.2705548576760517323935361e-99, "12705548576760517", -98},
    {4.8189570231821192830747803e+215, "4818957023182119", 216},
    {3.9203435688380840792496101e+61, "3920343568838084", 62},
    {8.0291959263391781375833448e+181, "8029195926339178", 182},
    {9.3271641354028354785748526e-140, "9327164135402835", -139},
    {1.7849043806769745406840015e-235, "17849043806769745", -234},
    {7.0518574577015735031632868e+198, "7051857457701574", 199},
    {1.3888890270053560418825041e-241, "1388889027005356", -240},
    {1.6103609612427716050439460e-256, "16103609612427716", -255},
    {1.2672088454952548282459156e+152, "12672088454952548", 153},
    {9.2404704558170455076524027e+177, "9240470455817046", 178},
    {3.5949166124815484790744335e-01, "35949166124815485", 0},
    {1.4549582425175392270022608e+169, "14549582425175392", 170},
    {2.7695758209639347920541083e-62, "2769575820963935", -61},
    {1.4418870338269085305219687e+276, "14418870338269085", 277},
    {4.5384568260903475958866939e+149, "4538456826090348", 150},
    {5.6163592415280372909895525e-290, "5616359241528037", -289},
    {2.4599152193917854780550787e+251, "24599152193917855", 252},
    {6.4181145470329030009602211e+266, "6418114547032903", 267},
    {4.2006275467212993305373197e+193, "4200627546721299", 194},
    {3.5667082999864399475376370e+103, "356670829998644", 104},
    {8.1891572416450722699716406e+83, "8189157241645072", 84},
    {6.4099460480360877015527995e+70, "6409946048036088", 71},
    {3.3011649780854439534074995e-189, "3301164978085444", -188},
    {3.0939500831445450214206341e+27, "3093950083144545", 28},
    {2.5551406954762394546844226e-281, "25551406954762395", -280},
    {1.2571340784883075692898326e-247, "12571340784883076", -246},
    {2.1141574916880846127704839e+84, "21141574916880846", 85},
    {6.6307215526876167812503588e+111, "6630721552687617", 112},
    {1.2823735601354231573662315e+229, "12823735601354232", 230},
    {5.3213834064871075814729636e-79, "53213834064871076", -78},
    {2.2691417179680408171856956e-282, "2269141717968041", -281},
    {3.1347865377825150646262786e+180, "3134786537782515", 181},
    {2.4722091700032225535998420e+296, "24722091700032226", 297},
    {8.4228933590021692131696198e+235, "8422893359002169", 236},
    {1.9361273508369237983912950e+295, "19361273508369238", 296},
    {2.1691733703165866602531604e-220, "21691733703165867", -219},
    {2.1632510942957254310898425e-154, "21632510942957254", -153},
    {1.6642615413336633169122196e+288, "16642615413336633", 289},
    {1.0047649101924601793289185e+09, "10047649101924602", 10},
    {3.6949874262709164462877489e+208, "36949874262709164", 209},
    {2.3068518289222095935918661e-141, "23068518289222096", -140},
    {9.2538939860757228223570235e-85, "9253893986075723", -84},
    {1.4351474948172877050363633e-242, "14351474948172877", -241},
    {1.0227528861471770115418321e+144, "1022752886147177", 145},
    {2.6066563338506520527167937e-15, "2606656333850652", -14},
    {2.0044036609430168379450008e-197, "20044036609430168", -196},
    {4.8415577861082801591513954e+271, "484155778610828", 272},
    {2.8714736530498304598025252e+60, "28714736530498305", 61},
    {2.1499981176027202820505600e+23, "21499981176027203", 24},
    {6.9282258310189716590266661e-87, "6928225831018972", -86},
    {7.1114103118085160910573141e-11, "7111410311808516", -10},
    {8.4125690643417218723720002e-248, "8412569064341722", -247},
    {1.6496244685865051291504486e+176, "1649624468586505", 177},
    {4.7824115304916004009771111e+254, "47824115304916", 255},
    {8.1083635912965722907462920e-258, "8108363591296572", -257},
    {1.8463859791436577621129479e+112, "18463859791436578", 113},
    {1.4897707021159453737435890e+284, "14897707021159454", 285},
    {1.2222755401352029963914013e-194, "1222275540135203", -193},
    {1.7759596951488690472772177e-152, "1775959695148869", -151},
    {8.4725720518289298320223247e+224, "847257205182893", 225},
    {1.9359286102542397914951784e+116, "19359286102542398", 117},
    {5.2081322674474006000830263e-70, "52081322674474006", -69},
    {4.6787786416116557698666915e+237, "4678778641611656", 238},
    {6.4876217477530478653783230e-242, "6487621747753048", -241},
    {2.1765804410048995374331396e+74, "21765804410048995", 75},
    {1.0883296984852713351706819e+108, "10883296984852713", 109},
    {4.1542335815197927462061578e+239, "41542335815197927", 240},
    {2.7919604700034939009243257e+60, "2791960470003494", 61},
    {7.9845436772009690594565971e+163, "7984543677200969", 164},
    {3.4398602811151935688044144e-111, "34398602811151936", -110},
    {5.0119640551735662237132412e+208, "5011964055173566", 209},
    {5.7437049433225587340318395e+50, "5743704943322559", 51},
    {1.1957310856598127530213682e-71, "11957310856598128", -70},
    {2.8677735315372504846003970e+270, "28677735315372505", 271},
    {9.7483659002845124893526407e+109, "9748365900284512", 110},
    {2.9945709892043747863192799e+181, "29945709892043748", 182},
    {4.1892465552318927760719575e-184, "4189246555231893", -183},
    {1.0580178112988619971275893e-178, "1058017811298862", -177},
    {3.6696123519788545322370813e+257, "36696123519788545", 258},
    {5.3444384352004311804862305e-187, "5344438435200431", -186},
    {3.2436427737318768825803986e-63, "3243642773731877", -62},
    {9.3999337200112486409519179e-180, "9399933720011249", -179},
    {3.2404623557192859740734243e-229, "3240462355719286", -228},
    {1.0119962202130607798500784e-184, "10119962202130608", -183},
    {6.9775040683772913582201817e+254, "6977504068377291", 255},
    {5.8283062097740832006434145e+161, "5828306209774083", 162},
    {9.4962630000862230201233587e+46, "9496263000086223", 47},
    {1.3661001405811489552864590e+303, "1366100140581149", 304},
    {3.1358703290894435423707725e-55, "31358703290894435", -54},
    {1.2494645551433285312964347e+41, "12494645551433285", 42},
    {1.7821352289057997725757819e+163, "17821352289057998", 164},
    {1.3986124931844046334399318e-270, "13986124931844046", -269},
    {3.1326666771612175392530409e-205, "31326666771612175", -204},
    {1.1552908910040437425646820e+108, "11552908910040437", 109},
    {1.6770173371893914619716755e+308, "16770173371893915", 309},
    {2.2457608583726900412366848e+52, "224576085837269", 53},
    {3.7650752889721785380104357e-50, "37650752889721785", -49},
    {1.1342138098591327741867025e+277, "11342138098591328", 278},
    {1.0250486533280972316276539e-275, "10250486533280972", -274},
    {9.3034354567229058143569408e-79, "9303435456722906", -78},
    {2.4193911468821106093397116e+36, "24193911468821106", 37},
    {8.9642638742171936109838425e-243, "8964263874217194", -242},
    {1.3380174986702797779863848e+217, "13380174986702798", 218},
    {2.1465380452336318685201851e+136, "21465380452336319", 137},
    {1.0655222970586518662170732e+102, "10655222970586519", 103},
    {5.3768351053623008209553697e+106, "5376835105362301", 107},
    {8.4690779484391250000000000e+13, "8469077948439125", 14},
    {1.4598515654540823171603999e-107, "14598515654540823", -106},
    {2.1862706998309638977050781e+10, "2186270699830964", 11},
    {6.0987714562539472889506700e+234, "6098771456253947", 235},
    {6.2895048344100362639454469e+221, "6289504834410036", 222},
    {1.7539937845753437096081507e+86, "17539937845753437", 87},
    {2.0648394719688287131110508e+42, "20648394719688287", 43},
    {8.4473976013926649608925214e-151, "8447397601392665", -150},
    {1.6858787024362275566426322e+92, "16858787024362276", 93},
    {3.4535627435594652749921698e-37, "34535627435594653", -36},
    {3.9030925021062851439165591e+246, "3903092502106285", 247},
    {3.0296091745666057119606588e-26, "30296091745666057", -25},
    {1.8006829694083760957737593e-221, "1800682969408376", -220},
    {5.2337317203192587856246049e-70, "5233731720319259", -69},
    {1.2254817934710482956976756e+253, "12254817934710483", 254},
    {2.7116810084651542183691676e+178, "27116810084651542", 179},
    {2.0256219005299287142640737e+42, "20256219005299287", 43},
    {6.2332618149392692562045656e+271, "6233261814939269", 272},
    {3.6146092129428222894500460e-199, "36146092129428223", -198},
    {1.3623341788024230395383152e+154, "1362334178802423", 155},
    {5.6623475730945825335995339e-125, "5662347573094583", -124},
    {1.3254294932178411416032543e-306, "13254294932178411", -305},
    {2.7714302490195828030282936e-306, "27714302490195828", -305},
    {1.9908423423583853946183808e+03, "19908423423583854", 4},
    {3.1429927223148811733018748e-145, "3142992722314881", -144},
    {2.0323672673667112498208098e+00, "20323672673667112", 1},
    {6.9176381983545679735488705e-205, "6917638198354568", -204},
    {9.7895406304405568675974791e+01, "9789540630440557", 2},
    {1.5178295993494748904413089e-87, "1517829599349475", -86},
    {3.8492246834903406388340788e+147, "38492246834903406", 148},
    {5.8776338351525550125684126e-43, "5877633835152555", -42},
    {1.7152608243139203235265449e+61, "17152608243139203", 62},
    {1.0406434567089427019192074e+28, "10406434567089427", 29},
    {3.4717676146149704710542634e-52, "34717676146149705", -51},
    {5.2803191902816072481454065e-59, "5280319190281607", -58},
    {7.4502755745878791509234192e-266, "7450275574587879", -265},
    {9.7360325519296955248557703e-228, "9736032551929696", -227},
    {9.4013789926425266265869141e+08, "9401378992642527", 9},
    {3.9253788933728237125402689e+260, "39253788933728237", 261},
    {1.4957055321777055755870939e+246, "14957055321777056", 247},
    {5.1392330693531703587340649e-98, "51392330693531704", -97},
    {4.4693975706205242005882068e-223, "4469397570620524", -222},
    {2.9409626499270552977593970e-258, "29409626499270553", -257},
    {2.1452718552333166023037001e+288, "21452718552333166", 289},
    {1.4236233594222478095069825e-145, "14236233594222478", -144},
    {6.3586190242901117787155080e+255, "6358619024290112", 256},
    {5.0692011825459599527713364e+307, "506920118254596", 308},
    {6.6301563879740342796288000e+22, "6630156387974034", 23},
    {5.2423449479287219860035287e-62, "5242344947928722", -61},
    {3.4125401191916784097857183e+275, "34125401191916784", 276},
    {6.7614024102341288293235204e-07, "6761402410234129", -6},
    {1.4004520282448756355603325e+139, "14004520282448756", 140},
    {6.0596633486361295257782463e+51, "605966334863613", 52},
    {1.1305460604046284696972385e+146, "11305460604046285", 147},
    {5.2077151723595084164304149e+134, "52077151723595084", 135},
    {1.4398717776259946586643248e+302, "14398717776259947", 303},
    {7.8345720900916196670566351e-79, "783457209009162", -78},
    {6.0857808613662644710260100e-275, "6085780861366264", -274},
    {3.3331325515489060846182873e+265, "3333132551548906", 266},
    {3.1581868047780786479547381e-232, "31581868047780786", -231},
    {2.8594348801090051737092785e-166, "2859434880109005", -165},
    {7.3154640764314135594759136e+03, "7315464076431414", 4},
    {2.3129621388410579811136042e+34, "2312962138841058", 35},
    {6.6547064997801221111685265e-77, "6654706499780122", -76},
    {1.3023783734502107197257288e-24, "13023783734502107", -23},
    {9.2250383393559573240574760e+62, "9225038339355957", 63},
    {2.9347059451970556915093717e-269, "29347059451970557", -268},
    {4.0488100310781706524000068e+141, "40488100310781707", 142},
    {4.7631980308208841447615684e+109, "4763198030820884", 110},
    {1.9498881445969895791171028e-41, "19498881445969896", -40},
    {5.1627539072617576868700368e-20, "51627539072617577", -19},
    {3.9159777114118488172332178e+80, "3915977711411849", 81},
    {2.1048932435978121922367572e-143, "2104893243597812", -142},
    {8.0581356172719961768831736e+241, "8058135617271996", 242},
    {2.9080347427632466852133551e-273, "29080347427632467", -272},
    {2.1352558024149495363235474e+08, "21352558024149495", 9},
    {4.4624359845581279355257486e+53, "4462435984558128", 54},
    {5.4520699822202213595668283e+32, "5452069982220221", 33},
    {5.3075861733386993491189778e-183, "5307586173338699", -182},
    {1.4543587032839968340523523e+258, "14543587032839968", 259},
    {1.2919282941928371399507401e+231, "12919282941928371", 232},
    {2.8446180269832977338374653e+199, "28446180269832977", 200},
    {3.1705149401452883599578222e+39, "31705149401452884", 40},
    {4.0886549587346185523519101e-07, "40886549587346186", -6},
    {2.1737282809889681252589528e-146, "2173728280988968", -145},
    {1.4286920498629489550466730e-95, "1428692049862949", -94},
    {3.4131019125956860493036063e-19, "3413101912595686", -18},
    {2.4140910326786196893685028e-82, "24140910326786197", -81},
    {1.4170403484590351481714093e-229, "14170403484590351", -228},
    {4.8895138734635121886338160e-57, "4889513873463512", -56},
    {1.5965762569265529632568359e+10, "1596576256926553", 11},
    {1.2651335549326629180268611e+36, "12651335549326629", 37},
    {2.3414667441481467802012347e+211, "2341466744148147", 212},
    {3.9806674001157917254348702e+30, "3980667400115792", 31},
    {1.3116312109466950901361855e-253, "13116312109466951", -252},
    {3.1558647309512854670904817e+91, "31558647309512855", 92},
    {1.6622166273678936387666017e-155, "16622166273678936", -154},
    {9.2515412080167683461057748e+192, "9251541208016768", 193},
    {4.7394184510182103195665772e+112, "473941845101821", 113},
    {6.4395360336828510720841061e-164, "6439536033682851", -163},
    {4.4117144215910088756104283e+257, "4411714421591009", 258},
    {3.0925652310821640014648438e+10, "3092565231082164", 11},
    {1.6964300555928413451847591e-77, "16964300555928413", -76},
    {3.8434944157700274077429678e-255, "38434944157700274", -254},
    {2.0605217262118358397889461e-83, "2060521726211836", -82},
    {6.8971913091359979658684712e-292, "6897191309135998", -291},
    {1.3537977541948473798930984e+86, "13537977541948474", 87},
    {2.8091138903639587412391678e+280, "28091138903639587", 281},
    {2.2332452206391684100045588e+207, "22332452206391684", 208},
    {2.0828668046731704519929718e+283, "20828668046731705", 284},
    {2.0844090704458807985264601e-136, "20844090704458808", -135},
    {6.9175582648628143284981349e+125, "6917558264862814", 126},
    {2.3351384582739612321319851e+61, "23351384582739612", 62},
    {1.7246677224331184696462173e-260, "17246677224331185", -259},
    {5.2905803860440595990503852e-220, "52905803860440596", -219},
    {3.6693802287874076415570739e+27, "36693802287874076", 28},
    {5.1669506767021623760971494e-02, "51669506767021624", -1},
    {1.7329005133431413311210172e-267, "17329005133431413", -266},
    {1.5215337544453136285697354e-283, "15215337544453136", -282},
    {6.0539918869571233738459496e-199, "6053991886957123", -198},
    {1.1380950229772953471061999e+228, "11380950229772953", 229},
    {6.5822776146040509140711057e-121, "6582277614604051", -120},
    {4.5537372077149309765350387e-41, "4553737207714931", -40},
    {1.4912034245691936687205873e-207, "14912034245691937", -206},
    {9.1457038680395044139004312e+02, "9145703868039504", 3},
    {1.5577573728774399332337010e+227, "155775737287744", 228},
    {2.3728909570834189037537963e+62, "2372890957083419", 63},
    {1.1157974192048910648391072e+34, "1115797419204891", 35},
    {2.3252097196439904806137496e+28, "23252097196439905", 29},
    {3.6975674068918186885827174e+48, "3697567406891819", 49},
    {1.7737102106096123387052032e+25, "17737102106096123", 26},
    {1.4114721168473339862864759e-46, "1411472116847334", -45},
    {6.2686287869204601931209566e+116, "626862878692046", 117},
    {2.3528921755514240021143289e-243, "2352892175551424", -242},
    {3.4109533230890246736847334e+256, "3410953323089025", 257},
    {3.3357230615579518247207687e+67, "3335723061557952", 68},
    {6.4607331945676849919067668e+164, "6460733194567685", 165},
    {2.4532355372092901174883592e+101, "245323553720929", 102},
    {1.2479749013690290254703321e-194, "1247974901369029", -193},
    {5.1336081014552536000000000e+16, "51336081014552536", 17},
    {1.7009792226882871566531838e+41, "17009792226882872", 42},
    {1.7653257963242097129264360e-124, "17653257963242097", -123},
    {3.0714848869647936312433258e-242, "30714848869647936", -241},
    {3.7021136557047858101753017e-35, "3702113655704786", -34},
    {1.2180161647224799677948567e-120, "121801616472248", -119},
    {5.0788873094144129428234980e-184, "5078887309414413", -183},
    {5.0862523013448208103367615e-67, "5086252301344821", -66},
    {5.8036796129785501260027021e-69, "580367961297855", -68},
    {1.7526568249148261101483585e+142, "1752656824914826", 143},
    {2.0748682003342676282361027e+167, "20748682003342676", 168},
    {3.8474107245047546551600153e+28, "38474107245047547", 29},
    {7.6599146054029126552324168e-292, "7659914605402913", -291},
    {2.2071144928068338193208343e+106, "2207114492806834", 107},
    {1.3695763862211334738790947e+100, "13695763862211335", 101},
    {2.9588256527568386868843934e+136, "29588256527568387", 137},
    {5.0272699021773296426643245e+80, "502726990217733", 81},
    {2.5640377275169392011239407e+294, "2564037727516939", 295},
    {6.2405666107781234169896201e+139, "6240566610778123", 140},
    {4.8782332131937597543351044e+205, "487823321319376", 206},
    {4.3603432112231278688988374e-08, "4360343211223128", -7},
    {1.5997624409645498437123728e+52, "15997624409645498", 53},
    {6.3911150545471313807480851e-10, "6391115054547131", -9},
    {8.6521485237742596265690271e+158, "865214852377426", 159},
    {6.9368607271598581159730122e+132, "6936860727159858", 133},
    {1.3418798000877363123502255e-272, "13418798000877363", -271},
    {2.2318099831103312829267839e-163, "22318099831103313", -162},
    {6.8883047303577201610129284e-148, "688830473035772", -147},
    {3.9691206062567839873696525e-20, "3969120606256784", -19},
    {1.3014622728180935675880441e-279, "13014622728180936", -278},
    {4.8086925822690292452461637e+296, "4808692582269029", 297},
    {2.6456818878545239738492427e+35, "2645681887854524", 36},
    {9.3090832485456808853334141e-14, "9309083248545681", -13},
    {1.6995725974274493420818800e-35, "16995725974274493", -34},
    {7.3573619316445402863690468e+236, "735736193164454", 237},
    {1.0940635781089289240832012e+164, "10940635781089289", 165},
    {5.8810760098583191459233760e+213, "5881076009858319", 214},
    {1.3212992324331150913621197e+27, "1321299232433115", 28},
    {4.4940727214202322044321792e+25, "4494072721420232", 26},
    {1.3895223787093717644369871e-183, "13895223787093718", -182},
    {2.3215147670524204562024698e-241, "23215147670524205", -240},
    {2.2337610267865546055514125e+74, "22337610267865546", 75},
    {2.2905660956536543500566379e-54, "22905660956536544", -53},
    {3.3242496068494357797353387e-162, "3324249606849436", -161},
    {2.0718371896260129736939300e+174, "2071837189626013", 175},
    {1.4474505048193907754225237e+204, "14474505048193908", 205},
    {2.9809694832061729789590700e+276, "2980969483206173", 277},
    {1.6681592556497899149288835e-37, "166815925564979", -36},
    {4.3215848960844852621279556e+148, "4321584896084485", 149},
    {2.5673188041814610275128707e-215, "2567318804181461", -214},
    {1.9541976000754895570291304e+45, "19541976000754896", 46},
    {4.0930136393440908933398692e-211, "4093013639344091", -210},
    {3.2396263534614567704522690e-234, "3239626353461457", -233},
    {4.4185573594312566367497425e+182, "44185573594312566", 183},
    {4.8100667669494280000000000e+16, "4810066766949428", 17},
    {1.3220837356138565739775264e+294, "13220837356138566", 295},
    {2.8458886858884118566068243e+226, "2845888685888412", 227},
    {1.4981393044533096833477999e-31, "14981393044533097", -30},
    {2.2762545820721230851997869e-70, "2276254582072123", -69},
    {1.1743652983917233684654551e+201, "11743652983917234", 202},
    {9.4119927373630059219962825e+287, "9411992737363006", 288},
    {5.2399473301763956634653273e-101, "52399473301763957", -100},
    {6.5452138940535611493094376e+221, "6545213894053561", 222},
    {5.0660783055558925365823293e+31, "50660783055558925", 32},
    {4.9344132726234906502932272e-57, "49344132726234907", -56},
    {1.9433451482086164205876926e+178, "19433451482086164", 179},
    {2.2011633577514898967767137e-280, "220116335775149", -279},
    {1.3921718275156961323181863e+71, "13921718275156961", 72},
    {4.0032143766531063609321533e+223, "40032143766531064", 224},
    {7.5165699138922977930071858e-10, "7516569913892298", -9},
    {9.1213641175907807860510556e-184, "9121364117590781", -183},
    {9.0532882744825688794164324e+228, "9053288274482569", 229},
    {8.3991695482794217515787828e-161, "8399169548279422", -160},
    {3.6945960952970418108263053e+46, "3694596095297042", 47},
    {7.6448880243026988039509471e+57, "7644888024302699", 58},
    {3.8740163636101017548274417e-03, "38740163636101018", -2},
    {1.2644198687688763833137061e+238, "12644198687688764", 239},
    {1.0015313653012155068831992e+239, "10015313653012155", 240},
    {3.7718870172808853154585554e-115, "37718870172808853", -114},
    {1.6497621173981158148032819e-52, "16497621173981158", -51},
    {3.9313062718413712032540798e+254, "3931306271841371", 255},
    {3.7028794133392239140315765e-264, "3702879413339224", -263},
    {3.9816917110939807302446960e-37, "3981691711093981", -36},
    {1.9429715702074781831451965e-224, "19429715702074782", -223},
    {1.3328715163763417370764766e+42, "13328715163763417", 43},
    {1.8371149834140289884812669e+86, "1837114983414029", 87},
    {6.6585843557823113699841685e-93, "6658584355782311", -92},
    {1.9144479339738163360914270e-123, "19144479339738163", -122},
    {6.0622666350521515725030480e+59, "6062266635052152", 60},
    {3.2525589358780836050040840e+283, "32525589358780836", 284},
    {1.1265060629336396578001063e-119, "11265060629336397", -118},
    {3.8989848168103383014449539e-30, "3898984816810338", -29},
    {8.7647970296520387222080600e+132, "8764797029652039", 133},
    {2.2549102522499428654579820e-130, "2254910252249943", -129},
    {2.1776000640399713475436950e-55, "21776000640399713", -54},
    {6.6988499841816160000000000e+16, "6698849984181616", 17},
    {4.9343622656767927743497378e-96, "4934362265676793", -95},
    {4.8647387387836755508177069e-169, "48647387387836756", -168},
    {1.3768502370354549280285129e+250, "1376850237035455", 251},
    {1.4618571919693056408629163e+126, "14618571919693056", 127},
    {1.0900931114180763621452223e+148, "10900931114180764", 149},
    {3.2626824119535453064600006e+04, "32626824119535453", 5},
    {8.1837526496507707019372259e-12, "818375264965077", -11},
    {9.6383853707349411392867029e-295, "9638385370734941", -294},
    {2.4092293204532669594649434e+260, "2409229320453267", 261},
    {2.4321972308646492029943921e-46, "24321972308646492", -45},
    {2.8219393413044696078761395e-50, "28219393413044696", -49},
    {3.1069074258874259476072092e-167, "3106907425887426", -166},
    {1.3958229637534013756940016e-279, "13958229637534014", -278},
    {2.5282141235492944018822004e+183, "25282141235492944", 184},
    {4.8809680404495568205983198e+98, "4880968040449557", 99},
    {4.5995864100181262773956544e-192, "4599586410018126", -191},
    {5.1560973411431140345720552e-38, "5156097341143114", -37},
    {4.1913915594993527278935439e+126, "4191391559499353", 127},
    {7.1115369963315636535865906e+302, "7111536996331564", 303},
    {2.0964635919654008296848017e-80, "2096463591965401", -79},
    {1.4789541497874423248910750e+230, "14789541497874423", 231},
    {1.7457401865653333492390370e+50, "17457401865653333", 51},
    {6.0796322469801093827467159e+214, "6079632246980109", 215},
    {2.3330107022053008524132897e+142, "23330107022053009", 143},
    {7.0546738900840487837812120e-301, "7054673890084049", -300},
    {8.6137210672347328959925034e-64, "8613721067234733", -63},
    {1.9772077911309181069060668e-139, "1977207791130918", -138},
    {4.9468784365153060700965863e+233, "4946878436515306", 234},
    {3.6584391549359897600000000e+17, "365843915493599", 18},
    {3.1388059847386114150153440e-161, "31388059847386114", -160},
    {1.7093384495898820555572813e+235, "1709338449589882", 236},
    {4.0511269278581780066309594e+50, "4051126927858178", 51},
    {7.3636437317741153816066935e-05, "7363643731774115", -4},
    {1.5322656133409262455979039e+123, "15322656133409262", 124},
    {9.7832835993625810733220760e-01, "9783283599362581", 0},
    {5.8728500210275729594557120e+33, "5872850021027573", 34},
    {9.6960572953980489273467650e+233, "9696057295398049", 234},
    {7.1515647766991206905342304e+54, "7151564776699121", 55},
    {3.9727277558100947016453819e-274, "39727277558100947", -273},
    {6.7112289087021323428951926e-215, "6711228908702132", -214},
    {7.0098455561400310229932013e+125, "7009845556140031", 126},
    {3.3213295322015120081937372e-102, "3321329532201512", -101},
    {5.6577096529460071609291358e+43, "5657709652946007", 44},
    {8.7532692828192540435474689e-149, "8753269282819254", -148},
    {5.5390160258795958501983508e-288, "5539016025879596", -287},
    {1.4496264635953445363405938e-249, "14496264635953445", -248},
    {1.8004205814301907163910073e+40, "18004205814301907", 41},
    {1.5059168054537660861057124e-55, "1505916805453766", -54},
    {2.7726359523295257023344138e-238, "27726359523295257", -237},
    {3.4721741673584361149402145e-105, "3472174167358436", -104},
    {7.3141826688402179176679798e-137, "7314182668840218", -136},
    {1.1097777004759128887474458e+206, "11097777004759129", 207},
    {2.3530663938539266203316850e+134, "23530663938539266", 135},
    {5.0833182419359608503301832e+259, "5083318241935961", 260},
    {1.6588703133929193298748129e+106, "16588703133929193", 107},
    {5.2672071143098837972499979e+84, "5267207114309884", 85},
    {6.7502478511351324528233753e+255, "67502478511351325", 256},
    {3.5115826334761939935329375e-159, "3511582633476194", -158},
    {1.4533642823245295776174002e+227, "14533642823245296", 228},
    {5.7836635092821311002130380e+256, "5783663509282131", 257},
    {9.2314301184217641700340790e-82, "9231430118421764", -81},
    {4.9068452479558156878500329e-136, "4906845247955816", -135},
    {5.1123019472650421564674139e-208, "5112301947265042", -207},
    {1.8879010028286942127407997e+68, "18879010028286942", 69},
    {3.6710810241477416800575825e+260, "36710810241477417", 261},
    {1.1027818543661468577722402e+148, "11027818543661469", 149},
    {1.0055655858521744809501373e+125, "10055655858521745", 126},
    {1.4694825100033648921407874e+212, "14694825100033649", 213},
    {5.6553731702997766839688384e+274, "5655373170299777", 275},
    {3.6107452714958492556069180e-128, "3610745271495849", -127},
    {5.2902674048369786074595234e+48, "52902674048369786", 49},
    {7.5220461377275638995218969e+199, "7522046137727564", 200},
    {5.9398623303454645258158728e-279, "59398623303454645", -278},
    {1.5107665413609682206756181e+60, "15107665413609682", 61},
    {9.9874017513317024230544681e-102, "9987401751331702", -101},
    {3.1641739597813011147086356e+66, "3164173959781301", 67},
    {4.1247756577227093217088177e-10, "41247756577227093", -9},
    {9.7684598805253970733174222e-91, "9768459880525397", -90},
    {8.2550389999566726504832019e+62, "8255038999956673", 63},
    {1.8834177246769638234864016e-190, "18834177246769638", -189},
    {2.7204793126980588890492685e+147, "2720479312698059", 148},
    {1.9588564979627755106196498e-127, "19588564979627755", -126},
    {6.2006976309771361494799672e-171, "6200697630977136", -170},
    {3.1009315747081043031061287e-306, "3100931574708104", -305},
    {8.9158512381100703573404808e-108, "891585123811007", -107},
    {6.8474900651896549272836175e+129, "6847490065189655", 130},
    {2.0582030949110197360004975e+164, "20582030949110197", 165},
    {6.7533733926977842446787159e-04, "6753373392697784", -3},
    {3.7026440413664394452730610e+64, "37026440413664394", 65},
    {1.8738352745135542238229018e+67, "18738352745135542", 68},
    {1.1065302412307638080086269e+152, "11065302412307638", 153},
    {2.0918297972329527643017491e-272, "20918297972329528", -271},
    {1.8923936819015548763994082e+142, "1892393681901555", 143},
    {8.0395364181086927758188159e+154, "8039536418108693", 155},
    {5.6060026191067262591845270e+178, "5606002619106726", 179},
    {1.9131879455443493264821083e-201, "19131879455443493", -200},
    {1.9010786526775559296984661e-82, "1901078652677556", -81},
    {1.2730024239968301848253276e-278, "12730024239968302", -277},
    {1.2276123213977269103906345e-217, "1227612321397727", -216},
    {5.7229177538689923321198982e-244, "57229177538689923", -243},
    {8.5536177330664403594079116e+137, "855361773306644", 138},
    {4.0872429891311945368114714e+149, "40872429891311945", 150},
    {1.3986086967020892685369620e-206, "13986086967020893", -205},
    {1.3523962503899634732306305e-198, "13523962503899635", -197},
    {1.1382922676546753516916700e+236, "11382922676546754", 237},
    {1.5386217981443536569579266e-294, "15386217981443537", -293},
    {6.0640323091241563433181011e-106, "6064032309124156", -105},
    {1.0533822747163174724340687e-74, "10533822747163175", -73},
    {5.5507863069258241013357388e-244, "5550786306925824", -243},
    {5.1734424535975136885500125e-34, "5173442453597514", -33},
    {2.4318369330956779534691059e-54, "2431836933095678", -53},
    {5.9983570967461376747683649e-206, "5998357096746138", -205},
    {4.9341948795672601188920286e-33, "493419487956726", -32},
    {1.2295921940968864626909049e-45, "12295921940968865", -44},
    {3.4789767823724573963534753e+227, "34789767823724574", 228},
    {1.8793835050783816749512132e+273, "18793835050783817", 274},
    {4.9844478545033074459414246e+202, "49844478545033074", 203},
    {2.3069554562106861583647238e-206, "23069554562106862", -205},
    {2.0503197079976482763277289e-103, "20503197079976483", -102},
    {2.2762972644066995759939883e+262, "22762972644066996", 263},
    {4.4599581281141073607447195e-251, "4459958128114107", -250},
    {1.4008157664727263793348582e+110, "14008157664727264", 111},
    {8.9170287109166134823133570e-95, "8917028710916613", -94},
    {1.6678041215872951271408892e+93, "16678041215872951", 94},
    {1.6569120465130101291912365e-133, "16569120465130101", -132},
    {3.4305059439666555880014866e-203, "34305059439666556", -202},
    {9.0497296650263449957421507e+224, "9049729665026345", 225},
    {7.4797504109179970249563337e-307, "7479750410917997", -306},
    {2.7478236838294400188249841e-177, "274782368382944", -176},
    {3.0756947915554638746764835e-08, "3075694791555464", -7},
    {3.8041585071815901397907484e+281, "380415850718159", 282},
    {5.1400567140732615562793349e-151, "51400567140732616", -150},
    {2.3858183091291466541116160e+138, "23858183091291467", 139},
    {2.5119588762591740677116317e+164, "2511958876259174", 165},
    {8.4255577972527409984047761e-99, "8425557797252741", -98},
    {2.6116753129681410254911687e-213, "2611675312968141", -212},
    {1.1578476075194924057010231e-78, "11578476075194924", -77},
    {9.1026217675684075244793712e+47, "9102621767568408", 48},
    {6.4942297511104725925195966e-169, "6494229751110473", -168},
    {9.3480720024285231022392971e+38, "9348072002428523", 39},
    {3.1271784649738168371788229e+123, "3127178464973817", 124},
    {2.4833756820983942737238181e-04, "24833756820983943", -3},
    {5.2973540183127874290165360e+153, "52973540183127874", 154},
    {2.4076503405912776380306468e-74, "24076503405912776", -73},
    {6.7686668689699987792968750e+11, "6768666868969999", 12},
    {1.0120976612834742328144716e-123, "10120976612834742", -122},
    {6.0615697546642588534196954e-309, "606156975466426", -308},
    {1.9367184351449304776231789e-100, "19367184351449305", -99},
    {5.7389700448943737196260830e+263, "5738970044894374", 264},
    {1.7282671003290183005454858e-09, "17282671003290183", -8},
    {1.0273301937914072642352794e+229, "10273301937914073", 230},
    {1.5375766635305663051386323e+44, "15375766635305663", 45},
    {2.0388320798327038445606666e+27, "20388320798327038", 28},
    {1.6396816897218256469777793e-99, "16396816897218256", -98},
    {5.9195664489436506916794474e+54, "5919566448943651", 55},
    {5.4915380448963354954188864e-306, "54915380448963355", -305},
    {7.4714437001041909641283560e+99, "7471443700104191", 100},
    {2.7030104518032346902819807e+280, "27030104518032347", 281},
    {6.9565010019884100047524165e+103, "695650100198841", 104},
    {1.3302028450467983451668893e-194, "13302028450467983", -193},
    {2.7542819805759092359268103e-234, "2754281980575909", -233},
    {2.7055101998427065539341216e-147, "27055101998427066", -146},
    {5.1558982564723696309084730e+175, "51558982564723696", 176},
    {5.5768044885236403806893652e-216, "55768044885236404", -215},
    {5.5326748674619296465380269e+85, "55326748674619296", 86},
    {9.9555462843355454692799762e-111, "9955546284335545", -110},
    {4.8164316360548711970980168e-48, "4816431636054871", -47},
    {2.6129502617104755351242603e-217, "26129502617104755", -216},
    {1.3938534172158133403406279e-287, "13938534172158133", -286},
    {4.9741634622267236597723898e+137, "4974163462226724", 138},
    {4.6631821693749353103901640e-249, "4663182169374935", -248},
    {7.2592743658055719196344443e+140, "7259274365805572", 141},
    {3.6268797217952153388864645e-01, "36268797217952153", 0},
    {4.7606818774631451512780175e+76, "4760681877463145", 77},
    {4.6327380924644183463888054e+194, "46327380924644183", 195},
    {1.5187657433192362584640621e-80, "15187657433192363", -79},
    {1.5674698046101089846866006e-280, "1567469804610109", -279},
    {2.8281452430399477927076588e-198, "28281452430399478", -197},
    {1.6335572164805661364827305e-233, "16335572164805661", -232},
    {1.2529277187156239316067114e-42, "1252927718715624", -41},
    {1.9718602149973551468338299e+184, "1971860214997355", 185},
    {1.3327480227489767567447858e-202, "13327480227489768", -201},
    {4.9097891028497909000588439e-54, "4909789102849791", -53},
    {2.0036976625650151982542535e-07, "20036976625650152", -6},
    {1.9390998434743525305387696e-281, "19390998434743525", -280},
    {2.9008842999837613644563526e+305, "29008842999837614", 306},
    {1.1540470154889394193435616e-57, "11540470154889394", -56},
    {2.3085630751422418055422353e-165, "2308563075142242", -164},
    {4.5088322804952583660806353e-04, "45088322804952584", -3},
    {3.6381577180484036580229099e+139, "36381577180484037", 140},
    {5.1108563994254129266943357e-227, "5110856399425413", -226},
    {4.5142248479407585843842771e+301, "4514224847940759", 302},
    {6.7331669895612405174360712e+68, "67331669895612405", 69},
    {3.9256211568676047019098684e+121, "39256211568676047", 122},
    {2.7305016804887567062640698e+103, "27305016804887567", 104},
    {6.5674642514574764266933842e+295, "6567464251457476", 296},
    {1.1607794119923716314365613e-185, "11607794119923716", -184},
    {1.2375128895841740131615017e-97, "1237512889584174", -96},
    {1.4539177288836410785617010e+132, "1453917728883641", 133},
    {1.2087611810078182367996762e-27, "12087611810078182", -26},
    {9.6576577612136430261705312e-265, "9657657761213643", -264},
    {1.5323129665627872454164869e+141, "15323129665627872", 142},
    {7.0743836244761879344369078e+257, "7074383624476188", 258},
    {1.4196499859157736185962288e-272, "14196499859157736", -271},
    {3.5120188572232192845259388e-45, "3512018857223219", -44},
    {3.3957067760048546144365013e-139, "33957067760048546", -138},
    {2.3458461652986153365805396e-34, "23458461652986153", -33},
    {1.3850281154606499716960731e-263, "138502811546065", -262},
    {5.7884605953261081295598724e-89, "5788460595326108", -88},
    {2.9585819336348700843704320e+25, "295858193363487", 26},
    {2.7721652180910867799306617e+83, "2772165218091087", 84},
    {4.9014368117605544626712799e+07, "49014368117605545", 8},
    {1.9778367505190008424055314e-244, "1977836750519001", -243},
    {6.4745105905618216874836613e+152, "6474510590561822", 153},
    {1.6022107114063557673944160e+04, "16022107114063558", 5},
    {5.6393257989655093294382358e+232, "5639325798965509", 233},
    {6.2743316240428894857330627e+121, "62743316240428895", 122},
    {7.8186219641429245010131971e-137, "78186219641429245", -136},
    {2.4444943664407436685343985e+247, "24444943664407437", 248},
    {8.0155980659615081472137367e-163, "8015598065961508", -162},
    {3.4576015364947058322284424e+199, "3457601536494706", 200},
    {2.4325682187837644832328064e-262, "24325682187837645", -261},
    {5.5207300137152506327396138e+224, "5520730013715251", 225},
    {1.1822417888992981250000000e+14, "11822417888992981", 15},
    {2.6981069828503049588668517e+63, "2698106982850305", 64},
    {7.7389019145880187881857355e+162, "7738901914588019", 163},
    {6.7145812516485063423158937e+198, "6714581251648506", 199},
    {6.8938908846761988755463496e-211, "6893890884676199", -210},
    {1.7084328225737011306300573e+69, "17084328225737011", 70},
    {1.4797684590479058148439604e-236, "14797684590479058", -235},
    {5.5549742878218766721374040e-127, "5554974287821877", -126},
    {8.9574444780963083392003260e+49, "8957444478096308", 50},
    {1.1023189132992955796120977e-273, "11023189132992956", -272},
    {1.1186315507514670932674870e+90, "1118631550751467", 91},
    {3.3318362177544805971959198e-232, "33318362177544806", -231},
    {5.6513094429026713332509647e-120, "5651309442902671", -119},
    {2.8674051756221901556898529e-272, "286740517562219", -271},
    {1.2565040639655168152761133e-61, "12565040639655168", -60},
    {9.2060548327690603791202442e-263, "920605483276906", -262},
    {2.9954510064121549547356876e+184, "2995451006412155", 185},
    {6.8286171546805858578896216e-21, "6828617154680586", -20},
    {4.7325047650861374542931946e-151, "47325047650861375", -150},
    {7.6182119149223554407562742e+53, "76182119149223554", 54},
    {2.5900963017580836774560214e-186, "25900963017580837", -185},
    {5.0026730838418752166374636e-293, "5002673083841875", -292},
    {9.1465221384655021259062550e-248, "9146522138465502", -247},
    {3.0698658816580675460244594e-286, "30698658816580675", -285},
    {6.0163312170111149817029318e+282, "6016331217011115", 283},
    {1.9568022014002405455800143e-196, "19568022014002405", -195},
    {2.6216628811325652350205928e+04, "26216628811325652", 5},
    {5.7257701748651439672287176e-192, "5725770174865144", -191},
    {2.1521466828561302040011316e+149, "215214668285613", 150},
    {7.2046927195993738511397559e+293, "7204692719599374", 294},
    {1.4611792203573371804262793e+43, "14611792203573372", 44},
    {4.2176240661621926984796756e-244, "4217624066162193", -243},
    {9.4408474957330702509260366e-61, "944084749573307", -60},
    {1.3935902489647991692400712e+202, "13935902489647992", 203},
    {1.1978098979285171509197238e+235, "11978098979285172", 236},
    {2.3761477166609109401567632e+95, "2376147716660911", 96},
    {1.8829125965052709218688252e-206, "1882912596505271", -205},
    {2.0206767390501504178052545e+227, "20206767390501504", 228},
    {3.3244423679901805967215234e-212, "33244423679901806", -211},
    {2.2560575858138835901771669e+83, "22560575858138836", 84},
    {1.9308040102547878789908695e+184, "1930804010254788", 185},
    {5.7187811519793491859982371e-86, "5718781151979349", -85},
    {4.0656656879883882903024573e+117, "40656656879883883", 118},
    {8.3763580922343029839160476e+61, "8376358092234303", 62},
    {2.2272158714013024675465185e+35, "22272158714013025", 36},
    {5.3341241727775530521803548e+135, "5334124172777553", 136},
    {1.4453550683591474757567485e-104, "14453550683591475", -103},
    {1.0982857359029847692061448e+219, "10982857359029848", 220},
    {5.1900716088158515049144626e+03, "51900716088158515", 4},
    {2.5173989694452397677668061e-222, "25173989694452398", -221},
    {3.5289077203494270455622047e-208, "3528907720349427", -207},
    {1.0894718208385935546875000e+13, "10894718208385936", 14},
    {1.7655099504056769855297483e+40, "1765509950405677", 41},
    {2.1826654597865659479769576e+238, "2182665459786566", 239},
    {1.3521482659847414456693754e+268, "13521482659847414", 269},
    {5.0310689622169092919825355e-192, "5031068962216909", -191},
    {1.8987181810341763775795698e+05, "18987181810341764", 6},
    {4.8544840241217105231451208e+176, "48544840241217105", 177},
    {6.2823412607082655242461876e+146, "62823412607082655", 147},
    {1.8675174738258564453125000e+12, "18675174738258564", 13},
    {1.1684947797061813566777743e+45, "11684947797061814", 46},
    {7.9645297622768113816537023e-162, "7964529762276811", -161},
    {7.9016731479687043557993964e+34, "7901673147968704", 35},
    {8.7162880705048776884568756e+244, "8716288070504878", 245},
    {3.2950748278088992404456165e+230, "32950748278088992", 231},
    {3.3442770730170297902200052e+260, "334427707301703", 261},
    {1.1922466493335948266188588e+252, "11922466493335948", 253},
    {3.2523118728593719521769916e-45, "3252311872859372", -44},
    {1.1947928210049327740370181e+264, "11947928210049328", 265},
    {2.2119445197994278631996883e+120, "2211944519799428", 121},
    {5.3352225371188968459218882e-298, "5335222537118897", -297},
    {6.0532939628843103839415044e-68, "605329396288431", -67},
    {1.3767004218756686942587514e+264, "13767004218756687", 265},
    {1.0815040412666347518618452e+245, "10815040412666348", 246},
    {4.3246308870345774327822252e+46, "43246308870345774", 47},
    {5.3542035967304981645523871e-78, "5354203596730498", -77},
    {6.6004893529062994284538259e+196, "66004893529062994", 197},
    {1.6938533556468050872982357e+268, "1693853355646805", 269},
    {6.7285313560395960746511296e+88, "6728531356039596", 89},
    {1.5663725297005482304482767e-209, "15663725297005482", -208},
    {9.6134859606537124778326084e+98, "9613485960653712", 99},
    {1.5371849716250502292574855e-56, "15371849716250502", -55},
    {1.0808247049391259228527209e-215, "10808247049391259", -214},
    {1.3285034790290610353413671e-149, "1328503479029061", -148},
    {1.8644917854706895666765422e+251, "18644917854706896", 252},
    {8.0102097855051648639441377e+78, "8010209785505165", 79},
    {8.0301106068331388679976424e+291, "8030110606833139", 292},
    {3.0075409733137650608406765e-71, "3007540973313765", -70},
    {4.9858562167732845377117261e-132, "49858562167732845", -131},
    {7.4643784870275719242317101e+91, "7464378487027572", 92},
    {8.0780897398529776474677914e-202, "8078089739852978", -201},
    {9.7871730362660222662811073e+305, "9787173036266022", 306},
    {1.2275994805783610071428921e-179, "1227599480578361", -178},
    {4.2497205928917129223785650e-70, "4249720592891713", -69},
    {1.8565114737563098421303926e-206, "18565114737563098", -205},
    {1.8306080291482877805625817e-66, "18306080291482878", -65},
    {1.4717553381509569193123220e+228, "1471755338150957", 229},
    {1.0145526077068653331990124e+62, "10145526077068653", 63},
    {5.7462483388182151629287856e+117, "5746248338818215", 118},
    {3.1291106957783787420441731e+305, "31291106957783787", 306},
    {1.6514506429962820018500287e-103, "1651450642996282", -102},
    {2.6923049167199685486660752e+103, "26923049167199685", 104},
    {8.1619886421990357374379384e+267, "8161988642199036", 268},
    {7.8225179265670206784324562e-78, "7822517926567021", -77},
    {6.0629932600127603006867335e-182, "606299326001276", -181},
    {1.3975647260511377006157268e+119, "13975647260511377", 120},
    {1.6045670768263827224152961e-181, "16045670768263827", -180},
    {7.6285944364247134204602403e-142, "7628594436424713", -141},
    {7.7367663574115668951690875e-232, "7736766357411567", -231},
    {1.6921960389109976612118097e-290, "16921960389109977", -289},
    {2.2155938992277835083007812e+11, "22155938992277835", 12},
    {2.2679380656587566502200343e-212, "22679380656587567", -211},
    {2.5685788010880357687191985e+114, "2568578801088036", 115},
    {4.7425329898345848334610004e-277, "4742532989834585", -276},
    {1.0138280789703423493563339e-209, "10138280789703423", -208},
    {1.6134420487761091113350279e-254, "16134420487761091", -253},
    {1.0524544635771775535904493e+240, "10524544635771776", 241},
    {7.0349187461616296722418992e-35, "703491874616163", -34},
    {9.0086250044334975512558495e-97, "9008625004433498", -96},
    {9.9517982861068925660851714e-20, "9951798286106893", -19},
    {3.6112757455197021968134123e-41, "3611275745519702", -40},
    {2.0879633139287152563171433e-269, "20879633139287153", -268},
    {7.3697069313720310175690582e+164, "7369706931372031", 165},
    {4.2649660516043396362177375e+57, "42649660516043396", 58},
    {4.3015191929961896771619442e-167, "430151919299619", -166},
    {2.0884583741350614449855182e-42, "20884583741350614", -41},
    {9.9726819677454244392592285e+91, "9972681967745424", 92},
    {2.6632437641221975747153408e+181, "26632437641221976", 182},
    {8.0766171434243400863076980e+48, "807661714342434", 49},
    {1.8283563743804888476218049e-184, "18283563743804888", -183},
    {2.9248801247446033225000331e+100, "29248801247446033", 101},
    {3.9388080373462786786167961e-63, "39388080373462787", -62},
    {7.7892602198869270057485710e+73, "7789260219886927", 74},
    {1.2487788774456061692860669e+83, "12487788774456062", 84},
    {1.0809974885604443728997482e-232, "10809974885604444", -231},
    {5.7562918178619356155395508e+09, "5756291817861936", 10},
    {7.9034047861489903426155072e+172, "790340478614899", 173},
    {6.6259579556677500141386229e+265, "662595795566775", 266},
    {4.4135721744009419387124260e-16, "4413572174400942", -15},
    {1.1614956725435240167035716e+61, "1161495672543524", 62},
    {6.1447836123661616721693341e-273, "6144783612366162", -272},
    {9.2493095276947482438329671e+168, "9249309527694748", 169},
    {2.2314563730152120851486250e-166, "2231456373015212", -165},
    {2.0734230764888033075842448e-191, "20734230764888033", -190},
    {7.3889142016681784082249910e-275, "7388914201668178", -274},
    {3.9976561678702754665798508e-246, "39976561678702755", -245},
    {1.2767874278276488939763359e-26, "12767874278276489", -25},
    {1.3573089683140097162276565e+166, "13573089683140097", 167},
    {1.6274184498814494765737482e+195, "16274184498814495", 196},
    {5.9634088080178983545562710e-117, "59634088080178984", -116},
    {1.1991820030470271098726637e+162, "11991820030470271", 163},
    {2.1657176701166314551142561e-272, "21657176701166315", -271},
    {1.5960513744553722666885358e+178, "15960513744553723", 179},
    {1.8541668846413897764037797e-101, "18541668846413898", -100},
    {5.6749015492245637083667833e+80, "5674901549224564", 81},
    {4.8030017758158160137485468e-13, "4803001775815816", -12},
    {2.7035983745449586749031741e+284, "27035983745449587", 285},
    {2.2854571935679108426865056e-250, "22854571935679108", -249},
    {2.0958813125746810880000000e+18, "2095881312574681", 19},
    {3.7376941768853046060609431e+189, "37376941768853046", 190},
    {1.4887468738750299537697677e+82, "148874687387503", 83},
    {2.6882290273819232135072886e+98, "26882290273819232", 99},
    {1.8751359116791073738104769e+67, "18751359116791074", 68},
    {1.1627806407133583965940872e+228, "11627806407133584", 229},
    {3.6771383329186656809857941e+238, "36771383329186657", 239},
    {1.3800643912624057829240304e-125, "13800643912624058", -124},
    {1.2250636291030488927512013e+181, "12250636291030489", 182},
    {1.7319297186059869272982582e+107, "1731929718605987", 108},
    {9.3562095812650326544505225e+199, "9356209581265033", 200},
    {2.3820561630712553614113878e-172, "23820561630712554", -171},
    {1.5127812019654031250000000e+13, "15127812019654031", 14},
    {1.0671541362972907241951566e+142, "10671541362972907", 143},
    {1.4249677914453756387313036e+90, "14249677914453756", 91},
    {3.8915857420033165770153801e+69, "38915857420033166", 70},
    {4.8452969752020510720000000e+18, "4845296975202051", 19},
    {5.0437673117713557633724757e+36, "5043767311771356", 37},
    {9.9379294213697237985325854e-187, "9937929421369724", -186},
    {9.5092391320048234732237555e-180, "9509239132004823", -179},
    {3.9659701345199794875302077e+110, "39659701345199795", 111},
    {7.4122716344608510987960063e-51, "7412271634460851", -50},
    {5.5500668761529025215001664e+234, "55500668761529025", 235},
    {3.2169956655043238971936814e+193, "3216995665504324", 194},
    {1.0539502639782366519580430e-72, "10539502639782367", -71},
    {3.0544055854057349987199976e+292, "3054405585405735", 293},
    {6.6539850709042241993194584e-268, "6653985070904224", -267},
    {6.2021955404051781156555929e+265, "6202195540405178", 266},
    {7.3367965118452578076569613e-124, "7336796511845258", -123},
    {1.6716002228586710834098576e-98, "1671600222858671", -97},
    {1.6098996222621286400000000e+20, "16098996222621286", 21},
    {4.4825320584122971322012298e+287, "4482532058412297", 288},
    {2.1295859189039218607991782e+306, "2129585918903922", 307},
    {3.2912259549604858779412027e-251, "3291225954960486", -250},
    {1.2224190733430724156426983e+246, "12224190733430724", 247},
    {7.1202453905901828760150441e+199, "7120245390590183", 200},
    {4.6492552825189675043542269e+50, "46492552825189675", 51},
    {4.3998163889972074285525008e+256, "43998163889972074", 257},
    {1.1405058974559339825067096e-257, "1140505897455934", -256},
    {8.6549836208961808113529736e-34, "865498362089618", -33},
    {1.4214422566548212504393032e-165, "14214422566548213", -164},
    {2.1834483106235748901917059e-25, "2183448310623575", -24},
    {4.6039921531175345953944415e-79, "46039921531175346", -78},
    {3.4302098046844416594647504e-105, "34302098046844417", -104},
    {1.1313070305707808054735991e+304, "11313070305707808", 305},
    {3.5136162436503347037195306e-83, "3513616243650335", -82},
    {4.9732881544516120825266141e+287, "4973288154451612", 288},
    {6.0686344015464958489421574e-130, "6068634401546496", -129},
    {2.8932813373448573772895186e-190, "28932813373448574", -189},
    {1.6781984241583223593210114e+152, "16781984241583224", 153},
    {1.8556576159971773114783821e-101, "18556576159971773", -100},
    {8.6494204847853523110175116e-281, "8649420484785352", -280},
    {2.2416345295511358153192199e+43, "2241634529551136", 44},
    {6.0931774881107443374214194e-198, "6093177488110744", -197},
    {5.3613213335695667241103513e-241, "5361321333569567", -240},
    {4.4724012982885662237375612e-02, "4472401298288566", -1},
    {2.2801530580596239604538831e-125, "2280153058059624", -124},
    {1.2704081607596635586493697e-40, "12704081607596636", -39},
    {1.1099224890467027669076270e+253, "11099224890467028", 254},
    {1.5902811046289918601072731e+187, "15902811046289919", 188},
    {1.1639254275973532804372759e+28, "11639254275973533", 29},
    {2.5068834366747039995465864e+249, "2506883436674704", 250},
    {1.8234202743301143527787644e+03, "18234202743301144", 4},
    {3.5391478960856073243515074e-72, "35391478960856073", -71},
    {2.2842764147062731871584334e-110, "22842764147062732", -109},
    {1.3342713637244639587402344e+11, "1334271363724464", 12},
    {4.2158210945284145256665779e-227, "42158210945284145", -226},
    {2.4045034187025934901179928e+208, "24045034187025935", 209},
    {1.4304064988794924000000000e+16, "14304064988794924", 17},
    {6.8469679486015999261038781e+304, "68469679486016", 305},
    {2.3047020438700883125250861e+112, "23047020438700883", 113},
    {2.6442381622377135089171733e-251, "26442381622377135", -250},
    {2.4372142587198793738174352e+105, "24372142587198794", 106},
    {8.0970439480008642175352934e+157, "8097043948000864", 158},
    {2.1965320417468746155728941e-111, "21965320417468746", -110},
    {7.2405633201632053101281844e-32, "7240563320163205", -31},
    {9.0949579929705249171651286e-32, "9094957992970525", -31},
    {1.7727684350671974977611435e+284, "17727684350671975", 285},
    {1.5217893869173178836173917e+95, "1521789386917318", 96},
    {6.5724405021744157647870421e+233, "6572440502174416", 234},
    {2.5355993234940245231094433e+235, "25355993234940245", 236},
    {1.0657722665046128513623571e-47, "10657722665046129", -46},
    {7.1950360596398960911489321e+208, "7195036059639896", 209},
    {4.1153585985981954089076445e+270, "41153585985981954", 271},
    {5.4021956407202013616537600e+23, "54021956407202014", 24},
    {2.2469801176518012388143578e+176, "22469801176518012", 177},
    {5.5120466098246237400125509e-06, "5512046609824624", -5},
    {8.9979945652578622716998575e+189, "8997994565257862", 190},
    {2.9639660043929648436631815e+270, "2963966004392965", 271},
    {5.9195787420847570417057126e+172, "5919578742084757", 173},
    {1.4812456051890698337366044e+65, "14812456051890698", 66},
    {1.3329719384875992185385329e-180, "13329719384875992", -179},
    {1.6474646648141532206296627e-65, "16474646648141532", -64},
    {1.5647535061319664973136203e+293, "15647535061319665", 294},
    {8.0100419523081542423990592e-103, "8010041952308154", -102},
    {7.2717520895005726587020701e-31, "7271752089500573", -30},
    {2.5720390848068022754561018e-285, "25720390848068023", -284},
    {2.1889683444187965722793030e+262, "21889683444187966", 263},
    {1.5123412899321003459690627e-48, "15123412899321003", -47},
    {2.0883045716494735727869810e+201, "20883045716494736", 202},
    {1.5278053416101377785800365e-40, "15278053416101378", -39},
    {7.3205487332023204558412780e-239, "73205487332023205", -238},
    {8.6413855038804139087281325e+77, "8641385503880414", 78},
    {4.8303523160866409426456991e+82, "4830352316086641", 83},
    {1.3720216531956289956831637e+82, "1372021653195629", 83},
    {3.9299539154210823299864384e-97, "39299539154210823", -96},
    {1.4886689000302471109811343e+196, "14886689000302471", 197},
    {2.8568665456138874201946014e+190, "28568665456138874", 191},
    {1.2756334518815078922470656e+306, "12756334518815079", 307},
    {1.0923604257958530646433953e+165, "1092360425795853", 166},
    {8.9786502187584427129457278e+236, "8978650218758443", 237},
    {3.8150578427581991313226683e-138, "3815057842758199", -137},
    {1.7046394545819310306099200e+23, "1704639454581931", 24},
    {8.7367852319253282047998219e-209, "8736785231925328", -208},
    {4.9422645445373787895962144e+306, "4942264544537379", 307},
    {1.8871144847420936131478768e+65, "18871144847420936", 66},
    {1.0802004682190158835156938e-153, "10802004682190159", -152},
    {2.3271292773514323476826235e+273, "23271292773514323", 274},
    {3.3080867575170986755264601e+34, "33080867575170987", 35},
    {2.0970718435159353342591169e-09, "20970718435159353", -8},
    {3.9709768418523970995592468e+72, "3970976841852397", 73},
    {2.9159348002593089665021716e-134, "2915934800259309", -133},
    {4.1921947603999845453284181e-16, "41921947603999845", -15},
    {3.8506367151772318970762534e+65, "3850636715177232", 66},
    {4.6802678860103939577305552e+57, "4680267886010394", 58},
    {6.4617821252062723930595826e-220, "6461782125206272", -219},
    {8.7049902959254410237078210e-69, "8704990295925441", -68},
    {1.2366903133129398025232844e-153, "12366903133129398", -152},
    {1.6822311454668234923913682e+196, "16822311454668235", 197},
    {3.9060294859550890439157584e+274, "3906029485955089", 275},
    {6.8377492927336700289068829e+259, "683774929273367", 260},
    {4.1940659155928799867076392e+201, "419406591559288", 202},
    {9.3442638229466288640255175e+163, "9344263822946629", 164},
    {7.7024486654822768030982832e-111, "7702448665482277", -110},
    {5.7950818402354548696931542e-08, "5795081840235455", -7},
    {6.5488181781877372733449035e-161, "6548818178187737", -160},
    {3.1121850811643475299556225e-178, "31121850811643475", -177},
    {4.6070635260329259433984000e+22, "4607063526032926", 23},
    {1.0498006942425564269454762e-191, "10498006942425564", -190},
    {3.4997891619450660884937313e+189, "3499789161945066", 190},
    {1.4843231956511078132924721e+100, "14843231956511078", 101},
    {8.1803370285478057072215291e+178, "8180337028547806", 179},
    {4.2122347051577784878246771e-154, "42122347051577785", -153},
    {1.2160542697837157706545893e-62, "12160542697837158", -61},
    {7.8272785603750367306020793e+49, "7827278560375037", 50},
    {8.9445563174192537356213206e+219, "8944556317419254", 220},
    {2.6176353737926215136881023e-226, "26176353737926215", -225},
    {1.5394464865018501419556878e+97, "15394464865018501", 98},
    {6.6473298754718427734375000e+12, "6647329875471843", 13},
    {7.9833409169240626683126021e-70, "7983340916924063", -69},
    {1.3782524724153425793768745e-137, "13782524724153426", -136},
    {1.9093882790810728580991396e-28, "19093882790810729", -27},
    {5.9940882376386823101469377e-99, "5994088237638682", -98},
    {6.4249603061571962443286007e-246, "6424960306157196", -245},
    {2.4168937663596253504576130e-71, "24168937663596254", -70},
    {3.5721540446975233324224246e+165, "35721540446975233", 166},
    {6.6880019407634127445729206e+205, "6688001940763413", 206},
    {1.0693395103842466140005469e-92, "10693395103842466", -91},
    {2.9157165794534485049194068e+100, "29157165794534485", 101},
    {1.8876458585912255551642273e-280, "18876458585912256", -279},
    {3.4378236791055895205395618e-279, "34378236791055895", -278},
    {4.9477697062008825995208402e+193, "4947769706200883", 194},
    {1.0667414231832885852348221e+216, "10667414231832886", 217},
    {5.7061759967034028255904098e+251, "5706175996703403", 252},
    {1.2843477342270626978399050e-308, "12843477342270627", -307},
    {3.9195273180796029258695911e-32, "3919527318079603", -31},
    {2.5094511608675467544109906e+119, "25094511608675468", 120},
    {2.2350532916987006579795812e+141, "22350532916987007", 142},
    {1.0549120181385527828854047e+105, "10549120181385528", 106},
    {7.2501826070116879803060036e-225, "7250182607011688", -224},
    {7.7731973245117390664435233e-114, "7773197324511739", -113},
    {2.6457023997715335418519730e+37, "26457023997715335", 38},
    {4.1737880541120089332954306e-135, "4173788054112009", -134},
    {4.5284400368741888965510229e-157, "4528440036874189", -156},
    {1.0159119772470023093619229e+169, "10159119772470023", 170},
    {9.1694593877915228818990450e+283, "9169459387791523", 284},
    {2.9787242208277306467477579e+135, "29787242208277306", 136},
    {6.7867170887115716959870910e+140, "6786717088711572", 141},
    {1.9779884257598259612805192e+180, "1977988425759826", 181},
    {9.9360846436552757212288001e+158, "9936084643655276", 159},
    {1.3829450441887006161244303e+253, "13829450441887006", 254},
    {5.0074884688322627067447227e-108, "5007488468832263", -107},
    {1.4307663366348007317487775e-37, "14307663366348007", -36},
    {3.4794173979451275790684783e+306, "34794173979451276", 307},
    {2.8419897058973409102264944e+205, "2841989705897341", 206},
    {3.9915227367830044593671489e+277, "39915227367830045", 278},
    {1.0793155897827607714404872e-220, "10793155897827608", -219},
    {1.0609938113576265629931258e-227, "10609938113576266", -226},
    {1.2895035547390944730991149e-216, "12895035547390945", -215},
    {1.2977969858246788632934692e-217, "12977969858246789", -216},
    {3.2790537298509245884462937e-197, "32790537298509246", -196},
    {1.2039237748300565967063541e+204, "12039237748300566", 205},
    {6.2924623717430118733830714e+32, "6292462371743012", 33},
    {1.0352613822956150033423147e+75, "1035261382295615", 76},
    {3.4472516821570303302701551e-208, "34472516821570303", -207},
    {1.3504044397151336596152750e+138, "13504044397151337", 139},
    {1.6975159227009194263780400e-214, "16975159227009194", -213},
    {1.1405677747893668930417056e+159, "11405677747893669", 160},
    {2.2279872704612620201166998e+166, "2227987270461262", 167},
    {3.0297238015819956206480280e-76, "30297238015819956", -75},
    {1.4558159819557844220653476e-155, "14558159819557844", -154},
    {9.4282690820030897979724184e-212, "942826908200309", -211},
    {6.0752255641253658555023892e+123, "6075225564125366", 124},
    {1.0371187169742459268565682e+139, "10371187169742459", 140},
    {1.8078992199873894349079698e-91, "18078992199873894", -90},
    {5.5363442627623210828388960e-248, "5536344262762321", -247},
    {1.2186489007916389768116563e+138, "1218648900791639", 139},
    {3.6743837280517382959388328e-01, "36743837280517383", 0},
    {8.6335994706517434971045884e-48, "8633599470651743", -47},
    {6.6046533104473362010296054e-80, "6604653310447336", -79},
    {5.4521599266706316232254919e-120, "54521599266706316", -119},
    {2.8336058078960901496871141e+279, "283360580789609", 280},
    {1.4827167264247044484804714e-15, "14827167264247044", -14},
    {1.7917407024460089458711870e+223, "1791740702446009", 224},
    {4.2356617323308690911396505e+228, "4235661732330869", 229},
    {1.7014858678438039873723009e-22, "1701485867843804", -21},
    {1.1076686601868761026502067e-85, "11076686601868761", -84},
    {2.7565485299372788198505153e+41, "2756548529937279", 42},
    {1.5217709999642574053321073e+260, "15217709999642574", 261},
    {1.1161375835912197717895393e-136, "11161375835912198", -135},
    {3.7554943035884195397698568e-126, "37554943035884195", -125},
    {7.3953240337764379110910928e-153, "7395324033776438", -152},
    {1.0517991557603400534983359e+106, "105179915576034", 107},
    {4.6226410910897623332815693e-259, "46226410910897623", -258},
    {1.4476759299974807896834753e-98, "14476759299974808", -97},
    {2.0590407411498577982755932e-260, "20590407411498578", -259},
    {7.5601634917912912837140962e+135, "7560163491791291", 136},
    {5.6545976771428225760591548e-146, "5654597677142823", -145},
    {1.6842806334257532057353099e-307, "16842806334257532", -306},
    {7.6349193636018572645649587e-276, "7634919363601857", -275},
    {3.7481912614027451960301709e+132, "3748191261402745", 133},
    {1.7092401313690731112567533e-17, "1709240131369073", -16},
    {3.2344853938212210357411619e-283, "3234485393821221", -282},
    {3.1384391471380321640959093e+199, "3138439147138032", 200},
    {1.1203574420289727244975795e+132, "11203574420289727", 133},
    {2.8129184549237054060470141e-230, "28129184549237054", -229},
    {1.3130657241376442598782811e-155, "13130657241376443", -154},
    {2.8439914872449895595122936e+84, "28439914872449896", 85},
    {2.7971727818598528766373777e+306, "2797172781859853", 307},
    {6.5782842995538620232743785e-55, "6578284299553862", -54},
    {1.4298093716743900608285055e-145, "142980937167439", -144},
    {6.3415744738326680000000000e+15, "6341574473832668", 16},
    {8.1775000685256114967669532e+169, "8177500068525611", 170},
    {1.0620081369663984078151968e-41, "10620081369663984", -40},
    {1.3720858350304722502439846e+53, "13720858350304723", 54},
    {4.4854399375581187585747367e+213, "4485439937558119", 214},
    {2.6067855360491719671091171e-66, "2606785536049172", -65},
    {1.3144177763153258193745147e+57, "13144177763153258", 58},
    {3.4772221821411246677050718e-109, "34772221821411247", -108},
    {2.8091905863356185923311778e-84, "28091905863356186", -83},
    {1.2725800380802970016795000e+55, "1272580038080297", 56},
    {2.4588866736646647062697312e-200, "24588866736646647", -199},
    {5.7200671304596746939505742e-280, "5720067130459675", -279},
    {5.9463471502837941920963765e+43, "5946347150283794", 44},
    {4.3723469925704219962794490e-293, "4372346992570422", -292},
    {1.1808215837187681376767575e-176, "11808215837187681", -175},
    {7.7679394117599637383933319e-66, "7767939411759964", -65},
    {1.7208915303710248567279370e+173, "17208915303710249", 174},
    {6.9151705365549046085696381e-159, "6915170536554905", -158},
    {2.2509440652044175587568723e-305, "22509440652044176", -304},
    {7.8763567497603867385717352e-91, "7876356749760387", -90},
    {8.0144435798958086884517560e-138, "8014443579895809", -137},
    {2.1092531259755224538680630e-154, "21092531259755225", -153},
    {1.8265236855283409993345086e-225, "1826523685528341", -224},
    {5.5250719666810210298352478e+184, "5525071966681021", 185},
    {5.6680843344739313272454965e-100, "5668084334473931", -99},
    {6.0973368433115749041029689e-207, "6097336843311575", -206},
    {3.3717386121299983869903372e+02, "33717386121299984", 3},
    {1.9201572411058938384754639e+289, "19201572411058938", 290},
    {1.7925274908190865903473478e+82, "17925274908190866", 83},
    {6.8511842999233427518841702e-292, "6851184299923343", -291},
    {1.6576737294051141861703978e-146, "16576737294051142", -145},
    {1.1804787888800154257735099e+286, "11804787888800154", 287},
    {1.3619910676034682155792713e-277, "13619910676034682", -276},
    {1.5305075176101222296024131e+251, "15305075176101222", 252},
    {6.4899435120668167410545815e-142, "6489943512066817", -141},
    {4.6404003220598075374362481e+39, "46404003220598075", 40},
    {1.8688007419834604919889537e+34, "18688007419834605", 35},
    {7.0259038506390739682608087e-165, "7025903850639074", -164},
    {2.9101837117494559873865115e-133, "2910183711749456", -132},
    {6.6512215971347445053733255e+224, "66512215971347445", 225},
    {9.5632195993046221658925331e-265, "9563219599304622", -264},
    {3.8764370307068734345933181e-109, "38764370307068734", -108},
    {8.5119823799848504483061793e+71, "851198237998485", 72},
    {4.2860460211174059947014188e+41, "4286046021117406", 42},
    {2.0142938344260937654724455e-160, "20142938344260938", -159},
    {4.8968647774285969743617952e-173, "4896864777428597", -172},
    {4.7881066133243809805890409e-275, "4788106613324381", -274},
    {1.4917708459392910617280443e+214, "1491770845939291", 215},
    {8.5189039657484192894738418e+145, "8518903965748419", 146},
    {1.2293605136813150224983722e+272, "1229360513681315", 273},
    {2.6457047242137132147208559e-56, "2645704724213713", -55},
    {2.3407770097668521423823166e+161, "2340777009766852", 162},
    {7.1830485418421418638891472e+260, "7183048541842142", 261},
    {1.2528674508458615586003011e+294, "12528674508458616", 295},
    {1.4079173661752673533085732e-123, "14079173661752674", -122},
    {1.2887203440678300941021042e-295, "128872034406783", -294},
    {7.9205851907335124366846611e+273, "7920585190733512", 274},
    {2.0348599232795922246184716e-74, "20348599232795922", -73},
    {7.9006832833822944482370158e-301, "7900683283382294", -300},
    {2.5180047457654130005328656e-71, "2518004745765413", -70},
    {6.4301496339437790005380893e+290, "6430149633943779", 291},
    {3.2868239675724373587160466e+152, "32868239675724374", 153},
    {1.9540184649712605112508079e-218, "19540184649712605", -217},
    {3.4699862098212082436807576e-228, "3469986209821208", -227},
    {7.6232423253502062670410585e+172, "7623242325350206", 173},
    {6.2529943624647659639473081e-291, "6252994362464766", -290},
    {4.5445036955871417892726834e-15, "4544503695587142", -14},
    {1.0758730976369471113310197e-135, "10758730976369471", -134},
    {3.0807914693325101732816080e-79, "308079146933251", -78},
    {1.1382634119253518405718980e-270, "11382634119253518", -269},
    {1.9205928551740793205139035e-232, "19205928551740793", -231},
    {7.0594859539950365610792287e+135, "7059485953995037", 136},
    {5.2011185320036729804091443e+262, "5201118532003673", 263},
    {4.4974020142740282608626104e+307, "4497402014274028", 308},
    {6.0033086742145897526045288e-65, "600330867421459", -64},
    {1.2861781504240544450188378e-261, "12861781504240544", -260},
    {9.4477808715429259307994928e+236, "9447780871542926", 237},
    {3.4009532390267971997611958e+246, "34009532390267972", 247},
    {5.8542811485482973618001915e-07, "5854281148548297", -6},
    {1.9504558581766940653324127e+07, "1950455858176694", 8},
    {6.9840861087773301415803632e+233, "698408610877733", 234},
    {9.9896285765458297455647459e+120, "998962857654583", 121},
    {3.4044327141035340540436977e+227, "3404432714103534", 228},
    {5.6925821570428128592005811e+164, "5692582157042813", 165},
    {2.7959608984891631010696519e-100, "2795960898489163", -99},
    {1.4497549293018365022598179e-244, "14497549293018365", -243},
    {5.9421407099822905516874018e+163, "594214070998229", 164},
    {2.2068232132448210700208980e-76, "2206823213244821", -75},
    {4.6087455207744812232757405e+265, "4608745520774481", 266},
    {5.3213006860987397310488905e-251, "532130068609874", -250},
    {8.4157096333395595979547626e-279, "841570963333956", -278},
    {1.7488029706014765417224953e+30, "17488029706014765", 31},
    {9.7876466533434260706973140e-94, "9787646653343426", -93},
    {2.4187820915204594531644647e-189, "24187820915204595", -188},
    {1.5621280648296823519267411e+243, "15621280648296824", 244},
    {1.2074579174354230987791135e-124, "1207457917435423", -123},
    {2.1605132479506986541370742e+88, "21605132479506987", 89},
    {5.0453485542738602243779790e+152, "504534855427386", 153},
    {1.0772400578957218164440163e-282, "10772400578957218", -281},
    {1.7491971462849774044770619e+131, "17491971462849774", 132},
    {5.7371137495203753933310509e+06, "5737113749520375", 7},
    {1.2110299230588843787336852e-176, "12110299230588844", -175},
    {2.6707758569332684330939585e-261, "26707758569332684", -260},
    {3.0771101738132922717283345e+257, "30771101738132923", 258},
    {3.6367137367772532881865336e+233, "36367137367772533", 234},
    {1.3392283009766124303097814e+100, "13392283009766124", 101},
    {1.1657886157302232679601413e-140, "11657886157302233", -139},
    {2.2465254123661723068017862e-294, "22465254123661723", -293},
    {1.0938256728019047560552263e+216, "10938256728019048", 217},
    {2.3847780216673661689692748e+52, "23847780216673662", 53},
    {1.3499276522778246196823290e-174, "13499276522778246", -173},
    {8.1499740368980956343289880e+66, "8149974036898096", 67},
    {1.4489731465348994751561342e-131, "14489731465348995", -130},
    {2.0262771934402089315377878e-59, "2026277193440209", -58},
    {1.0989682394177457839013737e-94, "10989682394177458", -93},
    {1.9469420401869353954717778e-258, "19469420401869354", -257},
    {1.1201861631641909651219332e-206, "1120186163164191", -205},
    {4.8937467988392231284234018e+189, "4893746798839223", 190},
    {8.5345852289093287002870262e-240, "8534585228909329", -239},
    {5.7753604538560779248470056e+266, "5775360453856078", 267},
    {3.7406802617622942406727063e-68, "3740680261762294", -67},
    {3.6512346962128196292129961e+294, "36512346962128196", 295},
    {2.7397321062685449590696328e-157, "2739732106268545", -156},
    {8.4698989087863228999975669e+48, "8469898908786323", 49},
    {9.8382468383099442660032554e+44, "9838246838309944", 45},
    {1.8248759117463506249779546e-112, "18248759117463506", -111},
    {7.7678669451091178060501014e+304, "7767866945109118", 305},
    {4.4792050402662664251985204e-195, "44792050402662664", -194},
    {3.7938170273020426960146397e+118, "37938170273020427", 119},
    {1.4292007218052197248338310e-73, "14292007218052197", -72},
    {1.9011166794456116323840364e-254, "19011166794456116", -253},
    {2.8702724587401486242508285e+85, "28702724587401486", 86},
    {2.0730547174202076341982604e-178, "20730547174202076", -177},
    {3.3325294920876193070733022e+215, "33325294920876193", 216},
    {4.9606223789234006381987104e-152, "4960622378923401", -151},
    {8.1682566994180423714706971e-45, "8168256699418042", -44},
    {1.6107595367119079588475315e+72, "1610759536711908", 73},
    {1.1004089365845894230768108e+154, "11004089365845894", 155},
    {6.6772001281734360221618526e+258, "6677200128173436", 259},
    {1.7773119085383484804388325e+68, "17773119085383485", 69},
    {1.2205206330819115396547769e+117, "12205206330819115", 118},
    {2.1592051059028014913786508e+145, "21592051059028015", 146},
    {3.3760654578289475054377271e-37, "33760654578289475", -36},
    {8.0168239732791075002692621e-173, "8016823973279108", -172},
    {3.1417426289713373291210984e-132, "31417426289713373", -131},
    {5.1351217927968817032007041e+48, "5135121792796882", 49},
    {5.0364924671310673006111835e-265, "5036492467131067", -264},
    {3.1257442303668143030219571e+26, "3125744230366814", 27},
    {4.5735002168207245845439544e+239, "4573500216820725", 240},
    {5.8939156084040403602197649e+301, "589391560840404", 302},
    {2.0244630974065708660010815e+191, "2024463097406571", 192},
    {8.1623383971730526090297344e+25, "8162338397173053", 26},
    {1.3864967395423988187307645e+208, "13864967395423988", 209},
    {2.2532518617588364597773130e-111, "22532518617588365", -110},
    {5.0282325782234356542425904e-20, "50282325782234357", -19},
    {6.5402186756759860453685645e-129, "6540218675675986", -128},
    {7.5584936681230738672158978e+146, "7558493668123074", 147},
    {1.1876548597417539054764784e-83, "11876548597417539", -82},
    {2.1707732061868426641037077e-44, "21707732061868427", -43},
    {5.1022441553182493537821731e-07, "5102244155318249", -6},
    {2.6789895128946785354787657e+171, "26789895128946785", 172},
    {1.1416065701096462363174724e+232, "11416065701096462", 233},
    {2.5922661045444142164223932e+266, "2592266104544414", 267},
    {1.4507587795990729279977414e-57, "1450758779599073", -56},
    {2.5190511948014994662145495e-279, "25190511948014995", -278},
    {2.4301824510504853803207346e+157, "24301824510504854", 158},
    {1.3714871948322574088921982e+278, "13714871948322574", 279},
    {1.1273397548185549635260406e-70, "1127339754818555", -69},
    {4.8137244020667899567712139e-107, "481372440206679", -106},
    {1.3841556451822506947062617e+192, "13841556451822507", 193},
    {3.7202618977570598550801142e-227, "372026189775706", -226},
    {5.8151115133849299488213678e-122, "581511151338493", -121},
    {5.1507999800838708909703285e-212, "5150799980083871", -211},
    {1.7447219502824899119105405e-97, "174472195028249", -96},
    {5.0784287144206449737815490e-02, "5078428714420645", -1},
    {4.2098189434117602426883596e-145, "420981894341176", -144},
    {6.0165970480458050515467266e+184, "6016597048045805", 185},
    {1.6535023808563807393045831e-198, "16535023808563807", -197},
    {2.0768371250660251955510641e+27, "20768371250660252", 28},
    {4.2329951196340550948274693e-264, "4232995119634055", -263},
    {3.7554177410815674217579322e+83, "37554177410815674", 84},
    {7.3065298088644011597413196e-131, "7306529808864401", -130},
    {9.8425142732558795610935216e-147, "984251427325588", -146},
    {4.1270140943537477019169497e+249, "4127014094353748", 250},
    {5.6662796048060360711418844e-69, "5666279604806036", -68},
    {3.5586532699366917108645867e-23, "3558653269936692", -22},
    {3.7388009752697115523694477e+202, "37388009752697116", 203},
    {5.1983336403853649120300084e+290, "5198333640385365", 291},
    {5.2972890599777395091587589e+252, "52972890599777395", 253},
    {4.3138241267532411492390891e-26, "4313824126753241", -25},
    {2.2864353988195850855871421e-29, "2286435398819585", -28},
    {3.9864358362323699610030623e-163, "398643583623237", -162},
    {8.4950210673484739119763281e-52, "8495021067348474", -51},
    {8.7485793715999417432625287e-111, "8748579371599942", -110},
    {2.2721627846599082518666690e+284, "22721627846599083", 285},
    {5.9071039992570319041826813e-59, "5907103999257032", -58},
    {1.1473917170506779939179749e+33, "1147391717050678", 34},
    {1.2404442289121851325035095e+08, "12404442289121851", 9},
    {6.9267042621561203677521703e-270, "692670426215612", -269},
    {5.5472409551966366709773465e-304, "5547240955196637", -303},
    {1.2651891488571342274753376e-179, "12651891488571342", -178},
    {1.4694236777576484380890593e+231, "14694236777576484", 232},
    {1.2460832150039935661589256e+243, "12460832150039936", 244},
    {5.1905616319723996307082668e-224, "51905616319724", -223},
    {3.1769443567929231283927269e-304, "3176944356792923", -303},
    {2.7113203415223078121725024e-99, "2711320341522308", -98},
    {3.6625092516007065057692671e+00, "36625092516007065", 1},
    {1.4279447273905725861656107e-180, "14279447273905726", -179},
    {1.5649553237754431997155355e+50, "15649553237754432", 51},
    {1.1408958944962027723538395e+207, "11408958944962028", 208},
    {7.0573751389081596779119959e-95, "705737513890816", -94},
    {9.0400246301085465647337411e+80, "9040024630108547", 81},
    {3.3874596445521740216654211e+85, "3387459644552174", 86},
    {3.9995085972798716505527637e-231, "39995085972798717", -230},
    {4.9098870179828692642009770e+68, "4909887017982869", 69},
    {3.7520953133728007441197050e-305, "37520953133728007", -304},
    {6.9075642139562823015793810e+269, "6907564213956282", 270},
    {1.0611549699972722491072729e-84, "10611549699972722", -83},
    {2.7230920927593326920049010e-253, "27230920927593327", -252},
    {3.5678525844040124658435077e+183, "35678525844040125", 184},
    {4.4031859384262003300506717e+113, "44031859384262", 114},
    {2.8835995776392060057169941e-243, "2883599577639206", -242},
    {3.7957600677788815415757281e+275, "37957600677788815", 276},
    {6.7082531258663263409197135e-112, "6708253125866326", -111},
    {1.9557985184703233039629714e+227, "19557985184703233", 228},
    {2.2779726354634577311042365e-89, "22779726354634577", -88},
    {4.1771819629425656628052706e-246, "41771819629425657", -245},
    {7.8430048746705537509865144e-266, "7843004874670554", -265},
    {1.6826975964873122199921801e-186, "16826975964873122", -185},
    {4.7568192808936721643767993e-115, "4756819280893672", -114},
    {5.7782764437495984228479613e+59, "5778276443749598", 60},
    {2.9860552708262584735177570e+298, "29860552708262585", 299},
    {9.9527245277442507976040387e-252, "995272452774425", -251},
    {1.1045078451317530997872508e+231, "11045078451317531", 232},
    {4.1716400692627206657895352e-09, "4171640069262721", -8},
    {1.1001276958004298186553236e+290, "11001276958004298", 291},
    {1.7070741174997308212499358e+222, "17070741174997308", 223},
    {3.4137735220261581717273109e+237, "3413773522026158", 238},
    {6.5908172332122087987998110e-135, "6590817233212209", -134},
    {1.6017831969763433989808407e-143, "16017831969763434", -142},
    {2.7839963443874368781885417e+184, "2783996344387437", 185},
    {4.4149592236247101032234376e+244, "441495922362471", 245},
    {4.4584871021574070567456097e-185, "4458487102157407", -184},
    {1.0607092763899848581604646e-05, "10607092763899849", -4},
    {2.5471176170503196860192390e+73, "25471176170503197", 74},
    {4.5407031645995202885996974e-303, "454070316459952", -302},
    {1.9349129984600744155269330e-230, "19349129984600744", -229},
    {1.5684905016842989353241160e+112, "1568490501684299", 113},
    {5.7045227997361579476683480e-34, "5704522799736158", -33},
    {2.2187384342638203067491980e-131, "22187384342638203", -130},
    {9.7716389415319258388173288e-12, "9771638941531926", -11},
    {1.5426834008504212896013978e-65, "15426834008504213", -64},
    {8.1899155523969018352143300e-40, "8189915552396902", -39},
    {1.3242747065506117959370637e-251, "13242747065506118", -250},
    {4.7386056259469896034383600e-282, "47386056259469896", -281},
    {3.9060714208377369167869763e+166, "3906071420837737", 167},
    {2.6619396812171427472455491e-135, "26619396812171427", -134},
    {7.3950254640566026444663593e-125, "7395025464056603", -124},
    {7.4029446381125283919517790e-200, "7402944638112528", -199},
    {1.7424947055949580234516818e-41, "1742494705594958", -40},
    {1.4626744797923826772079215e+228, "14626744797923827", 229},
    {1.8753103539842579016135121e+219, "1875310353984258", 220},
    {1.8794783245480176740490338e+184, "18794783245480177", 185},
    {2.3142407789955298534527798e+229, "23142407789955299", 230},
    {2.5469106740586291768853866e-77, "2546910674058629", -76},
    {3.4488910714173589745867866e+283, "3448891071417359", 284},
    {1.5449291831762954608701066e+187, "15449291831762955", 188},
    {2.7693844971290734038910593e-27, "27693844971290734", -26},
    {1.2245454569468106288689315e-172, "12245454569468106", -171},
    {2.1653370182778664657027558e-131, "21653370182778665", -130},
    {3.1397571485919966272171709e-127, "31397571485919966", -126},
    {4.8538566403002764682259456e-294, "48538566403002765", -293},
    {5.3727468172841827432983600e-65, "5372746817284183", -64},
    {2.5667977640342638563718947e-234, "2566797764034264", -233},
    {7.8762363633175003051757812e+10, "78762363633175", 11},
    {2.2881006192104820634722177e+284, "2288100619210482", 285},
    {7.2927972636026132711309947e-297, "7292797263602613", -296},
    {5.2936774313602956639078307e-47, "5293677431360296", -46},
    {2.7767177365110815759628417e-271, "27767177365110816", -270},
    {3.6305803643897341952950517e+208, "3630580364389734", 209},
    {6.3999815341414822822129883e-258, "6399981534141482", -257},
    {8.8905843394744441759386862e+225, "8890584339474444", 226},
    {3.3010690535608406492990469e-59, "33010690535608406", -58},
    {3.8435009650410501638070026e+158, "384350096504105", 159},
    {1.4084501879101554706954966e+293, "14084501879101555", 294},
    {2.5763378925524471970472777e-208, "2576337892552447", -207},
    {2.5448157279035187823066819e+284, "25448157279035188", 285},
    {8.8131110515744785412692690e+83, "8813111051574479", 84},
    {1.1595533579031497585694434e-272, "11595533579031498", -271},
    {2.2220127083873406589534125e-10, "22220127083873407", -9},
    {2.9750918365401700901255259e+293, "297509183654017", 294},
    {9.1228400406106572106777416e-248, "9122840040610657", -247},
    {1.0459233593366173680702677e-143, "10459233593366174", -142},
    {3.5340776736282812889337972e-286, "35340776736282813", -285},
    {1.5976286091842178344726562e+10, "15976286091842178", 11},
    {2.5258229390951171255571972e-298, "2525822939095117", -297},
    {9.8515899106919968309506416e-241, "9851589910691997", -240},
    {2.7479093099485303946711628e-224, "27479093099485304", -223},
    {7.9286552328997504768230997e-154, "792865523289975", -153},
    {2.7303723109670070765916974e-136, "2730372310967007", -135},
    {3.9740400709317844356424388e+39, "39740400709317844", 40},
    {3.5973007126719464783712109e+284, "35973007126719465", 285},
    {7.3719097372942902572871680e+172, "737190973729429", 173},
    {2.7561533812832666513307955e-302, "27561533812832667", -301},
    {5.3791661092340569265563809e+224, "5379166109234057", 225},
    {7.7442907452966195687014274e+228, "774429074529662", 229},
    {5.5011660526885219730366549e+95, "5501166052688522", 96},
    {7.1190400153385514961634409e-27, "7119040015338551", -26},
    {1.6336117693065204219994899e+247, "16336117693065204", 248},
    {4.1015294778171369216579478e+02, "4101529477817137", 3},
    {3.1205243524252021789506954e-82, "3120524352425202", -81},
    {4.5723741224839695964563162e-249, "457237412248397", -248},
    {9.1930808414000433945782413e-144, "9193080841400043", -143},
    {6.9463548840487081557750281e-46, "6946354884048708", -45},
    {1.6619808492232646656000000e+19, "16619808492232647", 20},
    {2.9887825900036411527485766e+256, "2988782590003641", 257},
    {1.4571776432373140981275057e-156, "1457177643237314", -155},
    {1.9796901032671586062763737e+297, "19796901032671586", 298},
    {1.4041777917211519828881005e-157, "1404177791721152", -156},
    {3.4052182739017685259255123e+120, "34052182739017685", 121},
    {1.0563298607271353518290579e-228, "10563298607271354", -227},
    {2.3309016271636438492623320e-50, "2330901627163644", -49},
    {3.6533786994632729002532647e+116, "3653378699463273", 117},
    {2.2679550363569166720062018e-172, "22679550363569167", -171},
    {3.2661739601425476451417681e-12, "32661739601425476", -11},
    {2.1730806821848875417160059e+30, "21730806821848875", 31},
    {2.6448764312629747570000085e+116, "26448764312629748", 117},
    {4.6478830730391413793201985e+112, "4647883073039141", 113},
    {1.1913978008016875400918321e+59, "11913978008016875", 60},
    {6.2201736026726156694570146e+306, "6220173602672616", 307},
    {2.3879746557985688462674605e+157, "23879746557985688", 158},
    {2.9599705209442924766800389e+235, "29599705209442925", 236},
    {4.9584436350455911381174889e+41, "4958443635045591", 42},
    {3.0965047140458339140249097e-181, "3096504714045834", -180},
    {8.0089728662991923831346006e+216, "8008972866299192", 217},
    {3.6522631549617745124415523e-245, "36522631549617745", -244},
    {6.3131960520683002321054299e-163, "63131960520683", -162},
    {4.1900659732897198985298779e+146, "419006597328972", 147},
    {3.1307037718632484071482152e+156, "31307037718632484", 157},
    {2.2774540539334912774883693e+233, "22774540539334913", 234},
    {2.3974646685880101809939977e-193, "239746466858801", -192},
    {2.3030876442242418870745832e-63, "2303087644224242", -62},
    {1.6112606712670856257552606e+237, "16112606712670856", 238},
    {4.6468906036542235675059940e-279, "46468906036542236", -278},
    {6.2707277116222882494721600e+62, "6270727711622288", 63},
    {9.7080545820431243547850678e+270, "9708054582043124", 271},
    {4.9697364470285641045417674e-233, "4969736447028564", -232},
    {3.8092670829646737590406518e-51, "3809267082964674", -50},
    {3.5114507826703633394612151e-14, "35114507826703633", -13},
    {2.7654281968613801662768540e+115, "276542819686138", 116},
    {7.5445974520497992450738019e-73, "7544597452049799", -72},
    {1.9529040720173738590327347e-105, "1952904072017374", -104},
    {2.9371515920001774833231910e+69, "29371515920001775", 70},
    {1.4211323864465867171155076e-115, "14211323864465867", -114},
    {9.6675924505149355799490195e-241, "9667592450514936", -240},
    {7.6310065016564472293139390e+145, "7631006501656447", 146},
    {3.8980418373025442270507776e+172, "3898041837302544", 173},
    {7.7846615772242255122577918e+171, "7784661577224226", 172},
    {3.3194907669656282119515815e+284, "3319490766965628", 285},
    {1.4396395457634180604903065e+160, "1439639545763418", 161},
    {1.6086929411010389243624798e-86, "1608692941101039", -85},
    {5.7755813638178627135161412e+132, "5775581363817863", 133},
    {1.6956740314455830414177745e+307, "1695674031445583", 308},
    {2.3215009941362395704201521e-209, "23215009941362396", -208},
    {2.1873690230485883775399849e-169, "21873690230485884", -168},
    {1.2920410087026132814200217e+61, "12920410087026133", 62},
    {2.7109535359399232925838056e-110, "2710953535939923", -109},
    {4.8368646897325745498241832e-124, "48368646897325745", -123},
    {9.0492459066891570910690964e+49, "9049245906689157", 50},
    {1.5223650219192116329681335e+229, "15223650219192116", 230},
    {7.3534878886353784519721925e+86, "7353487888635378", 87},
    {3.8961029796081872638963893e+48, "3896102979608187", 49},
    {7.7477233305223589781262402e-280, "7747723330522359", -279},
    {1.2819575790306754128978755e-216, "12819575790306754", -215},
    {1.2523402985314184481217211e+204, "12523402985314184", 205},
    {1.7037520219235142426806835e-263, "17037520219235142", -262},
    {3.8040820615775834798693672e-93, "38040820615775835", -92},
    {2.3395292667719740173421820e+154, "2339529266771974", 155},
    {2.6827833959994383303141126e+157, "26827833959994383", 158},
    {3.0732576515203952023423731e-61, "30732576515203952", -60},
    {2.5190810702069915707890827e+280, "25190810702069916", 281},
    {8.4389790322785452286474213e+166, "8438979032278545", 167},
    {5.4265021007064458787973816e-73, "5426502100706446", -72},
    {7.2142776672994511718750000e+12, "7214277667299451", 13},
    {3.6001282632816361334619470e+66, "3600128263281636", 67},
    {4.4128291249636933848562305e+122, "44128291249636934", 123},
    {4.5926409035690426864979202e+256, "4592640903569043", 257},
    {7.1536019149233216266813418e-225, "7153601914923322", -224},
    {9.3400863729075895730796511e+297, "934008637290759", 298},
    {1.0530410859210435195996909e+251, "10530410859210435", 252},
    {1.4189683920231878979441049e-96, "1418968392023188", -95},
    {1.1870877737974830937841738e+62, "1187087773797483", 63},
    {2.9338277856985719416943486e+266, "2933827785698572", 267},
    {4.0042687423616815415710309e+235, "40042687423616815", 236},
    {2.1268392657771718010504297e+40, "21268392657771718", 41},
    {4.2915361009684471352349812e-47, "4291536100968447", -46},
    {4.8506377027890287275260139e+84, "4850637702789029", 85},
    {1.1056015060549595952033997e+08, "11056015060549596", 9},
    {3.8731736804176023098106406e-23, "38731736804176023", -22},
    {2.8955601316096649147666419e-225, "2895560131609665", -224},
    {8.8312311361543849163203304e+281, "8831231136154385", 282},
    {2.8838302449645929814810230e+111, "2883830244964593", 112},
    {1.8313476873277296627588572e+295, "18313476873277297", 296},
    {2.7501031399263982170864511e+244, "2750103139926398", 245},
    {1.6325555316179367038999982e-215, "16325555316179367", -214},
    {2.3989292040505516407865739e+59, "23989292040505516", 60},
    {5.1958407639564923031541751e-103, "5195840763956492", -102},
    {8.7141442659499911147341730e+119, "8714144265949991", 120},
    {2.6657503019452445460028146e+239, "26657503019452445", 240},
    {9.6183957976099266321725432e+79, "9618395797609927", 80},
    {6.2365940994233630678548218e-83, "6236594099423363", -82},
    {9.4495698393566988651938324e+124, "9449569839356699", 125},
    {9.4232434414540320391477675e-139, "9423243441454032", -138},
    {9.8842389707248123762647346e+195, "9884238970724812", 196},
    {7.4464776759488526365895699e-252, "7446477675948853", -251},
    {2.9737065997104827019151434e+259, "29737065997104827", 260},
    {7.2091868163607092391678899e-276, "7209186816360709", -275},
    {7.3783756180958592759425306e-13, "7378375618095859", -12},
    {1.6617592144862877205014229e+07, "16617592144862877", 8},
    {4.8525815066496269402186975e+234, "4852581506649627", 235},
    {2.9937078492140678457776364e-185, "2993707849214068", -184},
    {1.5548127300050715823833762e-85, "15548127300050716", -84},
    {3.8472548215012630218696437e+188, "3847254821501263", 189},
    {5.8136193038694354557822501e+278, "5813619303869435", 279},
    {2.5979134299168945029521203e-55, "25979134299168945", -54},
    {6.3335187490750943516477773e-98, "6333518749075094", -97},
    {9.1522420855878928733310923e+48, "9152242085587893", 49},
    {2.5621939237795653752982616e+05, "25621939237795654", 6},
    {6.5748878946913746016486169e-75, "6574887894691375", -74},
    {1.1622802923828983748251774e+272, "11622802923828984", 273},
    {1.8052967604988737378273275e-186, "18052967604988737", -185},
    {1.3491911643519285284575847e-129, "13491911643519285", -128},
    {1.2975754891247685764638839e-294, "12975754891247686", -293},
    {3.1968666672440177489415594e-251, "31968666672440177", -250},
    {2.1120990830873735508717937e+301, "21120990830873736", 302},
    {2.7570494857942408918286094e-160, "2757049485794241", -159},
    {6.3700367990170381037880841e-242, "6370036799017038", -241},
    {1.7221389931254284174332746e-262, "17221389931254284", -261},
    {1.1812491071832916492288000e+22, "11812491071832916", 23},
    {3.4162743425311931500548011e-60, "3416274342531193", -59},
    {2.8025533428417005316117415e-111, "28025533428417005", -110},
    {8.3698122119587475954592972e+95, "8369812211958748", 96},
    {5.0279721215863904131295633e-216, "50279721215863904", -215},
    {1.4774493077369556402639086e+169, "14774493077369556", 170},
    {4.7265827114619079453450476e-201, "4726582711461908", -200},
    {5.3542387971818402705549169e-107, "535423879718184", -106},
    {3.9650266571352900441889292e+175, "396502665713529", 176},
    {1.8477885791494689466835862e-57, "1847788579149469", -56},
    {3.4701348610934341437627592e+208, "3470134861093434", 209},
    {8.1134441947540809191576431e-76, "8113444194754081", -75},
    {1.1748999136804203536529315e-259, "11748999136804204", -258},
    {4.2724119378239393307050062e+178, "4272411937823939", 179},
    {7.8249144774807984052763792e+185, "7824914477480798", 186},
    {2.7659638525182495000000000e+15, "27659638525182495", 16},
    {1.0404358051507034671430518e+251, "10404358051507035", 252},
    {1.6674822859129431493214891e+197, "1667482285912943", 198},
    {2.7884921344038761100602686e+159, "2788492134403876", 160},
    {2.3473774461246218672097377e-92, "2347377446124622", -91},
    {2.0847450177554143613676302e-85, "20847450177554144", -84},
    {6.9626221743593585142530848e-198, "6962622174359359", -197},
    {2.5682788250857970753366785e-46, "2568278825085797", -45},
    {1.4172865487846807304008129e-157, "14172865487846807", -156},
    {3.9981692445303785128254767e+28, "39981692445303785", 29},
    {4.2535560548512791339601289e+71, "4253556054851279", 72},
    {1.1473403733618649127132845e+132, "11473403733618649", 133},
    {4.0777111397378659779110463e-156, "4077711139737866", -155},
    {1.8254722698411904621925290e+101, "18254722698411905", 102},
    {6.3161415572580957316363530e+93, "6316141557258096", 94},
    {1.4029132355035248527501319e+262, "14029132355035249", 263},
    {1.3245691035552130656823666e-47, "1324569103555213", -46},
    {1.8993211194491387838580113e-166, "18993211194491388", -165},
    {9.2864393886011295279772980e+188, "928643938860113", 189},
    {5.8669152545301584079324446e-266, "58669152545301584", -265},
    {2.0308736856104097889996224e-100, "20308736856104098", -99},
    {8.4435275878922615037618604e-173, "8443527587892262", -172},
    {1.7843316248390822801691031e+290, "17843316248390823", 291},
    {5.5944086366942979508718976e-264, "5594408636694298", -263},
    {6.0116409975363789171554412e-104, "6011640997536379", -103},
    {4.9690689028836802429434094e-03, "496906890288368", -2},
    {3.1569723162134384370972274e-220, "31569723162134384", -219},
    {7.6038765766498710049480357e+76, "7603876576649871", 77},
    {6.7047843421070681468357511e-197, "6704784342107068", -196},
    {1.9786624627015078262590529e-218, "19786624627015078", -217},
    {1.5331148955180870305946100e+126, "1533114895518087", 127},
    {9.1008865316560342510235949e+134, "9100886531656034", 135},
    {1.4197339220456950690848227e-59, "1419733922045695", -58},
    {1.7931461904796710086326567e+221, "1793146190479671", 222},
    {5.0057265053887532374046843e+295, "5005726505388753", 296},
    {2.2747885137497111667116792e+297, "22747885137497112", 298},
    {1.7171073187412656522256905e-53, "17171073187412657", -52},
    {4.4628639936938954531839219e-156, "44628639936938955", -155},
    {1.0125379999767700540911455e-97, "101253799997677", -96},
    {6.0566378136672561741175847e+293, "6056637813667256", 294},
    {2.1118705740427045296645679e+293, "21118705740427045", 294},
    {7.9698729119867708240991544e+35, "7969872911986771", 36},
    {8.1910687786795613685533122e-92, "8191068778679561", -91},
    {1.3516086554521383387422565e+172, "13516086554521383", 173},
    {3.4610513820961766545501394e+99, "34610513820961767", 100},
    {1.7187703570999194457652124e+264, "17187703570999194", 265},
    {1.7838070011548396389449646e-123, "17838070011548396", -122},
    {8.4959315080851678586763274e+126, "8495931508085168", 127},
    {3.0135292130469873666625013e-135, "30135292130469874", -134},
    {1.4667578577559760122041990e+215, "1466757857755976", 216},
    {1.4661327945445296046080000e+21, "14661327945445296", 22},
    {3.5049029833038668461553550e+265, "3504902983303867", 266},
    {1.8380368836197747630334703e-198, "18380368836197748", -197},
    {2.3173341852402532636116149e-299, "23173341852402533", -298},
    {2.4422719409557281377845442e+89, "2442271940955728", 90},
    {1.6448106978463876916902448e-38, "16448106978463877", -37},
    {1.5906791712706780146749579e-146, "1590679171270678", -145},
    {1.1876384537640775238605677e-228, "11876384537640775", -227},
    {2.5526438666871296912757898e+212, "25526438666871297", 213},
    {2.7702899929509089376488232e-250, "2770289992950909", -249},
    {1.5702007910697077296620204e+279, "15702007910697077", 280},
    {1.1553876589564215488269945e+101, "11553876589564215", 102},
    {5.3850445538885281441631335e+46, "5385044553888528", 47},
    {3.8035168484994647292308469e-31, "38035168484994647", -30},
    {2.5594976543357702613890496e-23, "25594976543357703", -22},
    {1.2426542910111409858045813e+264, "1242654291011141", 265},
    {1.0105987622806051330953407e-12, "10105987622806051", -11},
    {1.0826378364118705185528825e+38, "10826378364118705", 39},
    {1.6135373239811294452904163e-55, "16135373239811294", -54},
    {1.2883899118762416640000000e+18, "12883899118762417", 19},
    {7.7611838901981550433538411e+189, "7761183890198155", 190},
    {3.2166291857158671376354563e-101, "3216629185715867", -100},
    {4.5635028504459217028842733e-78, "4563502850445922", -77},
    {3.1367834158453308712556307e-235, "3136783415845331", -234},
    {1.6079824164916414140211537e+129, "16079824164916414", 130},
    {1.2891745348664690191217130e+107, "1289174534866469", 108},
    {6.3134577944431449134272305e-63, "6313457794443145", -62},
    {3.4858378718164918975873761e+181, "3485837871816492", 182},
    {1.1936723918725724830563763e+252, "11936723918725725", 253},
    {4.6234916202006179695504245e-85, "4623491620200618", -84},
    {3.6619905272125370301795911e+143, "3661990527212537", 144},
    {3.8856983367836852683833734e+149, "38856983367836853", 150},
    {2.7813462264246669706350202e+141, "2781346226424667", 142},
    {8.6818536569148140855627453e+233, "8681853656914814", 234},
    {6.9402265935263797491474478e-84, "694022659352638", -83},
    {4.5782805719981824035963688e-122, "45782805719981824", -121},
    {5.7511877414469901104162066e-279, "575118774144699", -278},
    {1.8298133147738017093767000e+146, "18298133147738017", 147},
    {2.0694636280492222639283684e-169, "20694636280492223", -168},
    {7.9602241264014359497783059e-193, "7960224126401436", -192},
    {1.6490514316657457587124851e-71, "16490514316657458", -70},
    {3.9186962418117304320000000e+18, "39186962418117304", 19},
    {6.6969256743808521767107010e-261, "6696925674380852", -260},
    {2.9458951337612715039536363e-61, "29458951337612715", -60},
    {2.3448759399946843639361074e-92, "23448759399946844", -91},
    {1.3997981393313626446587130e-17, "13997981393313626", -16},
    {5.3159011912079595865691804e+275, "53159011912079596", 276},
    {9.8809215846625320936334828e+177, "9880921584662532", 178},
    {1.7483272365557015892035263e-73, "17483272365557016", -72},
    {1.5748274252529317133700571e+257, "15748274252529317", 258},
    {3.4066763721506966411257963e+276, "34066763721506966", 277},
    {1.1191935612109404715695023e-210, "11191935612109405", -209},
    {3.1279835323211970072374751e-09, "3127983532321197", -8},
    {3.0062636001034519910898282e+178, "3006263600103452", 179},
    {2.8812188727296731868132460e-117, "28812188727296732", -116},
    {2.0870590688976937193864088e-08, "20870590688976937", -7},
    {1.0433968508506029814385897e+263, "1043396850850603", 264},
    {5.7045402394079430273201409e-292, "5704540239407943", -291},
    {4.6462530878668616010092530e-125, "46462530878668616", -124},
    {2.2373666091550440231669157e-212, "2237366609155044", -211},
    {8.4041542282470965604112275e+107, "8404154228247097", 108},
    {2.8245057497133050778587345e-122, "2824505749713305", -121},
    {5.6154693627595332497362391e+119, "5615469362759533", 120},
    {1.1026251496752333614532453e+199, "11026251496752334", 200},
    {1.7268054722618657740297021e-174, "17268054722618658", -173},
    {1.0582228357923349345475176e+258, "1058222835792335", 259},
    {2.0086080953787600994110107e+08, "200860809537876", 9},
    {3.1089824676402053115674982e+105, "31089824676402053", 106},
    {2.6590708641767513734085676e-303, "26590708641767514", -302},
    {8.0422665692727554915370665e-283, "80422665692727555", -282},
    {2.2903294644964390116265423e+153, "2290329464496439", 154},
    {6.7559209258870142540122448e-195, "6755920925887014", -194},
    {6.0959070247027226038293345e+260, "6095907024702723", 261},
    {1.0281505387378920539796857e+227, "1028150538737892", 228},
    {6.1862255323449215195160348e+251, "6186225532344922", 252},
    {3.3146586143971324149833458e-118, "33146586143971324", -117},
    {4.6199888154889274810208979e-34, "46199888154889275", -33},
    {1.0678851522176980728859752e+216, "1067885152217698", 217},
    {1.9879357602011262854126626e+101, "19879357602011263", 102},
    {3.2611424903001931550217830e-19, "3261142490300193", -18},
    {3.7572517657551673995862999e+27, "37572517657551674", 28},
    {1.7581205362184744682234203e+285, "17581205362184745", 286},
    {3.0910719464174686934299087e+270, "30910719464174687", 271},
    {3.5044921085424759484453655e+121, "3504492108542476", 122},
    {1.0419968309967665158003098e+26, "10419968309967665", 27},
    {2.3176522969905049233567314e-215, "2317652296990505", -214},
    {1.5312640354497193667359646e+209, "15312640354497194", 210},
    {9.2049474161607132295124771e-206, "9204947416160713", -205},
    {1.3935313572812652793136627e+235, "13935313572812653", 236},
    {2.0412578514635644036383053e-152, "20412578514635644", -151},
    {4.5894062320436729004120026e+222, "4589406232043673", 223},
    {8.9829128095108357933093799e+279, "8982912809510836", 280},
    {4.8839486894952635780015633e-151, "48839486894952636", -150},
    {7.1220512066500190575756438e-308, "7122051206650019", -307},
    {4.4810769278223896462017229e-160, "44810769278223896", -159},
    {3.2327201708619732090880000e+24, "3232720170861973", 25},
    {3.5983129151472176553699936e+75, "35983129151472177", 76},
    {6.5332977544762294011136039e-263, "653329775447623", -262},
    {1.4651524277290128179200000e+20, "14651524277290128", 21},
    {5.3373778772182760797366048e-135, "5337377877218276", -134},
    {2.0702168213880621800052911e-56, "2070216821388062", -55},
    {6.4436681928074248781135207e-140, "6443668192807425", -139},
    {6.6431385215508774743820865e-191, "6643138521550877", -190},
    {2.9909330935994547517140230e-101, "2990933093599455", -100},
    {1.8892079480376554014789241e-89, "18892079480376554", -88},
    {4.7170427248705558921831297e+119, "4717042724870556", 120},
    {1.6264130866277517407468534e-306, "16264130866277517", -305},
    {5.1255823072650104406552311e+137, "51255823072650104", 138},
    {1.8108326900307246020528553e+80, "18108326900307246", 81},
    {2.0185567143932781807020628e+227, "2018556714393278", 228},
    {1.0382257045243145110806287e+298, "10382257045243145", 299},
    {2.3016996459028595809918625e-237, "23016996459028596", -236},
    {1.5843798667324526651990299e+216, "15843798667324527", 217},
    {8.6870460028880390625000000e+12, "8687046002888039", 13},
    {2.3487714389676817935611403e+245, "2348771438967682", 246},
    {6.0641821480086032716136448e+26, "6064182148008603", 27},
    {1.4783008727949053499444752e-235, "14783008727949053", -234},
    {3.3770693714702309023852806e+41, "3377069371470231", 42},
    {1.0570737518024085574357547e-280, "10570737518024086", -279},
    {9.2346913208243655149036547e-38, "9234691320824366", -37},
    {1.5790437457807446463961711e+185, "15790437457807446", 186},
    {1.2177882406677011252733065e-191, "12177882406677011", -190},
    {8.1553873913175301178260439e-77, "815538739131753", -76},
    {1.8707032188731064929495831e-270, "18707032188731065", -269},
    {1.5254095084462838862564437e+73, "1525409508446284", 74},
    {1.4217427508156859083829413e+118, "1421742750815686", 119},
    {2.2577476399899559244087940e-156, "2257747639989956", -155},
    {1.0482069205614983104700241e+242, "10482069205614983", 243},
    {4.1371688528296039120873742e-162, "4137168852829604", -161},
    {5.0709074094941555701228988e+212, "50709074094941556", 213},
    {6.4175797905357942818330811e+249, "6417579790535794", 250},
    {5.0316642168673124034984032e+215, "50316642168673124", 216},
    {1.0974612074890705374066594e+235, "10974612074890705", 236},
    {2.1381338481553932069800794e+04, "21381338481553932", 5},
    {5.4374492681946930264492199e+280, "5437449268194693", 281},
    {7.4619696618464948534501743e+259, "7461969661846495", 260},
    {9.0678344801046766686525235e-188, "9067834480104677", -187},
    {9.1289019671939983553602572e+73, "9128901967193998", 74},
    {4.4461932056736035691101588e-200, "44461932056736036", -199},
    {4.8233574224228789870656319e-124, "4823357422422879", -123},
    {1.0223800447256438749393395e+302, "10223800447256439", 303},
    {1.1103323684757435347542632e+32, "11103323684757435", 33},
    {1.3762464067223356924980202e-282, "13762464067223357", -281},
    {2.9205654011776799026092461e+96, "292056540117768", 97},
    {1.1192121787142260683307842e+190, "1119212178714226", 191},
    {2.1024977846224090802041509e+216, "2102497784622409", 217},
    {1.9518334545387649949696816e+301, "1951833454538765", 302},
    {1.2027502815148139382486754e-116, "1202750281514814", -115},
    {8.5763112950375430821159465e-273, "8576311295037543", -272},
    {2.2305160365646320629766857e+125, "2230516036564632", 126},
    {8.2072445185100180042164192e+294, "8207244518510018", 295},
    {1.8250607181116217662638653e-233, "18250607181116218", -232},
    {5.3690481597720273605484869e+78, "5369048159772027", 79},
    {7.7669548548853271277679452e-54, "7766954854885327", -53},
    {9.7564959880874882351431346e+281, "9756495988087488", 282},
    {8.6903715873069919449655877e+30, "8690371587306992", 31},
    {2.6158697733192884182205153e+219, "26158697733192884", 220},
    {7.6974909759911421586567993e+135, "7697490975991142", 136},
    {1.8784638153639637280773266e+229, "18784638153639637", 230},
    {3.1002193650745614070582105e+278, "31002193650745614", 279},
    {4.5018536157244681192847557e+40, "4501853615724468", 41},
    {1.1542469731303784765491404e-276, "11542469731303785", -275},
    {3.4239389366959354882178188e-122, "34239389366959355", -121},
    {1.0208369588335956624807997e-32, "10208369588335957", -31},
    {1.9981982638459865257266398e-171, "19981982638459865", -170},
    {5.9419605153367277244042175e+289, "5941960515336728", 290},
    {6.1353977059424726410512334e-269, "6135397705942473", -268},
    {2.2153104588594177932150938e+61, "22153104588594178", 62},
    {2.6214601970937295813195653e-286, "26214601970937296", -285},
    {8.0805886877992680297527292e-72, "8080588687799268", -71},
    {1.3879034131623263116423081e+212, "13879034131623263", 213},
    {3.3302557026352339606833717e-38, "3330255702635234", -37},
    {3.6734035899655387490898149e-243, "3673403589965539", -242},
    {8.0104998476674011658201733e-258, "8010499847667401", -257},
    {2.1826306397648110728090557e-258, "2182630639764811", -257},
    {9.6838226460683022576267234e-297, "9683822646068302", -296},
    {3.9732394683959704278859976e-222, "39732394683959704", -221},
    {3.2550176113791962353972199e-263, "3255017611379196", -262},
    {3.8417777865996391111911126e+174, "3841777786599639", 175},
    {1.3582527376157619218390586e+113, "1358252737615762", 114},
    {1.3501432462767792594030030e-211, "13501432462767793", -210},
    {2.5556514646010854951992742e+73, "25556514646010855", 74},
    {2.0849955671755450014904726e-287, "2084995567175545", -286},
    {2.0263956507441626281973213e+204, "20263956507441626", 205},
    {6.0309745957310613758613883e-92, "60309745957310614", -91},
    {7.2979869876272224602113659e+182, "7297986987627222", 183},
    {1.6022567189831946450834579e-05, "16022567189831946", -4},
    {1.4257989347838644800000000e+17, "14257989347838645", 18},
    {2.4053552349221724827584218e+225, "24053552349221725", 226},
    {6.0564163027113074901753693e+127, "60564163027113075", 128},
    {7.9594805115264198222130730e+118, "795948051152642", 119},
    {7.8138961612454057172972686e-57, "7813896161245406", -56},
    {2.2062423020648298028595293e-275, "22062423020648298", -274},
    {9.1566168054206572591234043e+164, "9156616805420657", 165},
    {7.6958932703219959988588661e-04, "7695893270321996", -3},
    {7.5177473679304425027423086e-159, "7517747367930443", -158},
    {9.3434040382152905301893497e-01, "934340403821529", 0},
    {1.7296399222463898469835443e+191, "172963992224639", 192},
    {2.0858182558275818295563239e+203, "2085818255827582", 204},
    {4.1331614688099836254650158e+272, "41331614688099836", 273},
    {2.0226204211858088515660964e+131, "2022620421185809", 132},
    {9.5268901525479516714952324e-52, "9526890152547952", -51},
    {3.6312112007963397819303637e+172, "363121120079634", 173},
    {1.3443192895738639814507607e+219, "1344319289573864", 220},
    {5.7459437175555252326306700e+258, "5745943717555525", 259},
    {6.4090381080777911125369950e-80, "6409038108077791", -79},
    {3.7134697190176416849904971e-148, "3713469719017642", -147},
    {4.7184900291454916408161017e+189, "4718490029145492", 190},
    {7.0230283968827255547238384e-290, "7023028396882726", -289},
    {1.9233039319021032333772463e-214, "19233039319021032", -213},
    {1.2052807063216759671750896e+219, "1205280706321676", 220},
    {9.5435170415617537443437302e+275, "9543517041561754", 276},
    {1.0362956450133558986650198e+229, "10362956450133559", 230},
    {1.0074731996588249505497290e-218, "1007473199658825", -217},
    {2.1661984626246836165309350e+62, "21661984626246836", 63},
    {1.7306807708943008662349530e+140, "17306807708943009", 141},
    {5.4081975545152715709376271e-155, "54081975545152716", -154},
    {2.7866865538914779603364391e+283, "2786686553891478", 284},
    {1.3635054345958425840691302e+216, "13635054345958426", 217},
    {4.3270240481892145133066457e-82, "43270240481892145", -81},
    {1.3547619055782443675557911e-19, "13547619055782444", -18},
    {2.6713003076435309797068955e-185, "2671300307643531", -184},
    {2.0548112847923602943490879e+98, "20548112847923603", 99},
    {6.8132689230246546713349373e-230, "6813268923024655", -229},
    {1.5385934395172586520576000e+22, "15385934395172587", 23},
    {1.7509878380226488851992067e+72, "17509878380226489", 73},
    {2.6366396328975761413574219e+10, "2636639632897576", 11},
    {6.3679023620387290873247892e+295, "6367902362038729", 296},
    {1.1517711629015126499148907e-288, "11517711629015126", -287},
    {2.5769803274780441600000000e+17, "2576980327478044", 18},
    {6.2831622232448920607566833e+07, "6283162223244892", 8},
    {1.1698033768847340464772331e-48, "1169803376884734", -47},
    {2.4539258747344320513331288e-197, "2453925874734432", -196},
    {1.4826872388444360130664296e-23, "1482687238844436", -22},
    {4.3600659814908915413852350e+276, "43600659814908915", 277},
    {1.2945325750680359073976258e-283, "1294532575068036", -282},
    {4.3876196701619571534804602e-271, "4387619670161957", -270},
    {1.0250999764211047921898160e+232, "10250999764211048", 233},
    {3.3382140756194642629219329e-61, "3338214075619464", -60},
    {3.5224507895883028950315420e-43, "3522450789588303", -42},
    {4.4435253694333775635849096e-93, "44435253694333776", -92},
    {6.8091967319003459359268724e+90, "6809196731900346", 91},
    {6.3209091323065195312675922e-287, "632090913230652", -286},
    {3.4092366525502481454281811e-06, "3409236652550248", -5},
    {1.5216023651478247721083177e+250, "15216023651478248", 251},
    {2.8274392158660153513661030e-103, "28274392158660154", -102},
    {2.8244861578310330833087119e-155, "2824486157831033", -154},
    {3.4890596450821042850231343e+202, "34890596450821043", 203},
    {1.0252341864522877390758213e-41, "10252341864522877", -40},
    {9.3932235858626319447856668e-150, "9393223585862632", -149},
    {5.7912826818207292973619804e-73, "5791282681820729", -72},
    {6.4479343176182887329025116e-06, "6447934317618289", -5},
    {1.8993462260244088329927049e+174, "18993462260244088", 175},
    {1.9646629008277041217613985e+238, "1964662900827704", 239},
    {5.2169720745092225527590190e+34, "5216972074509223", 35},
    {1.0215046143267487370757944e+79, "10215046143267487", 80},
    {3.6751842867362945381301071e-43, "36751842867362945", -42},
    {2.9147388039514225479473287e+256, "29147388039514225", 257},
    {1.5918731654234981489393849e+271, "15918731654234981", 272},
    {4.4040198788007187500000000e+12, "4404019878800719", 13},
    {4.2599845817771591077371787e-238, "4259984581777159", -237},
    {1.0685398236562237027409199e+218, "10685398236562237", 219},
    {2.9315749655127004282880000e+21, "29315749655127004", 22},
    {1.3743186396943700968764044e+229, "137431863969437", 230},
    {1.0820892154715615220294455e-259, "10820892154715615", -258},
    {7.9913813924736302371183912e+256, "799138139247363", 257},
    {8.8947697503633440611852942e+225, "8894769750363344", 226},
    {1.6812099179385489309780831e-282, "1681209917938549", -281},
    {2.6784240002053890423304362e+164, "2678424000205389", 165},
    {4.1823394619813737992435035e+33, "4182339461981374", 34},
    {1.0884322232092625973454870e-182, "10884322232092626", -181},
    {1.7914534289215478302820245e+136, "17914534289215478", 137},
    {7.7199068029921287220511269e-101, "7719906802992129", -100},
    {9.8023732289927173700570339e-128, "9802373228992717", -127},
    {1.8820702707321847500000000e+15, "18820702707321848", 16},
    {5.9206446849195749474255922e+232, "5920644684919575", 233},
    {1.0579348706314144134521484e+09, "10579348706314144", 10},
    {2.1820400014617597117310300e+158, "21820400014617597", 159},
    {9.3070522821140373626654245e+148, "9307052282114037", 149},
    {1.1527686842473303003142576e+303, "11527686842473303", 304},
    {9.3529349202355377042567822e+194, "9352934920235538", 195},
    {6.1033396841219742782413960e+04, "6103339684121974", 5},
    {8.9068729988513715455969787e+45, "8906872998851372", 46},
    {2.8669138216724228240634241e-189, "2866913821672423", -188},
    {1.8350528188916152495529549e+120, "18350528188916152", 121},
    {2.9558900672494061800215655e+72, "2955890067249406", 73},
    {9.6394083444500606664888251e-198, "963940834445006", -197},
    {9.8664618681954322649292739e-27, "9866461868195432", -26},
    {8.6542905652868297019631532e-183, "865429056528683", -182},
    {7.2749093928967164247761286e-264, "7274909392896716", -263},
    {2.8219052727720555898296961e+203, "28219052727720556", 204},
    {8.5335178518294799109855024e+86, "853351785182948", 87},
    {3.9334524493476393564222581e+291, "39334524493476394", 292},
    {4.2216787624941523067518431e-226, "4221678762494152", -225},
    {5.9641692385948047642186295e+54, "5964169238594805", 55},
    {4.1500113203621148428945456e-98, "4150011320362115", -97},
    {1.3436876550949079687500000e+14, "1343687655094908", 15},
    {4.5200552713038470712315644e-290, "4520055271303847", -289},
    {1.9934999762905329093718774e-298, "1993499976290533", -297},
    {3.4663666094579950334433989e-110, "3466366609457995", -109},
    {3.0795002932349121859154568e+117, "3079500293234912", 118},
    {2.0974771929924669265747070e+09, "2097477192992467", 10},
    {2.7727933413259421524329059e+155, "2772793341325942", 156},
    {1.0392807635032991526195531e+181, "10392807635032992", 182},
    {2.6581361822371529696120610e-139, "2658136182237153", -138},
    {1.1887534523261494161171887e+151, "11887534523261494", 152},
    {6.5365717167584719561335767e+27, "6536571716758472", 28},
    {1.3446497367935733488039075e+81, "13446497367935733", 82},
    {5.3142433651546021043576655e+274, "5314243365154602", 275},
    {1.1812965117990224139445948e+202, "11812965117990224", 203},
    {3.6910500337772441784237753e-282, "3691050033777244", -281},
    {7.8070317670127659813292329e-107, "7807031767012766", -106},
    {6.4261687269512413255163115e-258, "6426168726951241", -257},
    {1.5187024898470385543170918e+220, "15187024898470386", 221},
    {4.0164819214724421368576486e+184, "4016481921472442", 185},
    {1.8191900217862624152917942e-283, "18191900217862624", -282},
    {3.7864804065537523081280149e-243, "37864804065537523", -242},
    {5.5658441187524214421724159e+126, "5565844118752421", 127},
    {1.2595558797615114809471110e+71, "12595558797615115", 72},
    {3.4323474722468657872687166e+47, "34323474722468658", 48},
    {1.8484348996028414495620335e-237, "18484348996028414", -236},
    {2.9115332095716918712921163e-228, "2911533209571692", -227},
    {1.8037401669939054251499471e-130, "18037401669939054", -129},
    {1.9084850254668077019131494e-227, "19084850254668077", -226},
    {2.2222767104746567136260086e-126, "22222767104746567", -125},
    {1.6383122932009594846371233e-293, "16383122932009595", -292},
    {7.8286551604110979686651534e-81, "7828655160411098", -80},
    {5.1198349023810554451300369e+137, "51198349023810554", 138},
    {1.5118587909486289587089385e-151, "1511858790948629", -150},
    {3.8832124998585088651189341e+62, "3883212499858509", 63},
    {1.5934394330602737702203790e+74, "15934394330602738", 75},
    {1.3302127549013722991293947e-113, "13302127549013723", -112},
    {1.1977322178407165529512564e-237, "11977322178407166", -236},
    {2.1094943081850958867702159e-151, "2109494308185096", -150},
    {9.0029629426669831643650131e-229, "9002962942666983", -228},
    {9.3691265350660514667407806e+98, "9369126535066051", 99},
    {9.0457395345568454587825893e-14, "9045739534556845", -13},
    {2.7186099985841793947362727e-234, "27186099985841794", -233},
    {3.2322749846064892866938814e+195, "32322749846064893", 196},
    {5.8298424996694381593777807e-37, "5829842499669438", -36},
    {3.6379418635086904484854556e-248, "36379418635086904", -247},
    {2.5114047126006814002159629e-225, "25114047126006814", -224},
    {3.2623970179200228545435030e+258, "3262397017920023", 259},
    {5.0512341550812189062319311e-235, "5051234155081219", -234},
    {1.6221652275976655539105490e+144, "16221652275976656", 145},
    {2.9612600432185971716592651e+234, "2961260043218597", 235},
    {3.3065864266366787431350372e+160, "3306586426636679", 161},
    {4.0318944030078933744638330e-193, "40318944030078934", -192},
    {3.2286784495854522532162664e+190, "32286784495854523", 191},
    {5.8508786306865632245833843e+273, "5850878630686563", 274},
    {3.7927931058763254350794826e+300, "37927931058763254", 301},
    {5.9113413484536208714383824e+225, "5911341348453621", 226},
    {6.1981914423347832645376990e+47, "6198191442334783", 48},
    {6.0847241438408991882345997e+159, "6084724143840899", 160},
    {8.2712046666765780445063619e-239, "8271204666676578", -238},
    {1.5974914940903898003541956e+209, "15974914940903898", 210},
    {4.6910909857074589525339072e+87, "4691090985707459", 88},
    {1.2296826505288926642340127e+243, "12296826505288927", 244},
    {4.6321998451406481801144311e+194, "4632199845140648", 195},
    {1.0876485957955525895919532e-80, "10876485957955526", -79},
    {1.0321698463249352960000000e+18, "10321698463249353", 19},
    {4.4675285362792310000000000e+15, "4467528536279231", 16},
    {1.1970271181261007919157333e-53, "11970271181261008", -52},
    {6.6825553292238845434904340e+193, "66825553292238845", 194},
    {5.4396914192088870277062972e+38, "5439691419208887", 39},
    {3.0886540893435237343952516e+178, "30886540893435237", 179},
    {4.8352014377079582330762791e+307, "4835201437707958", 308},
    {4.3693417266016027694582015e+226, "4369341726601603", 227},
    {9.7511817764729194868052021e+71, "975118177647292", 72},
    {4.5374849219783262752534865e+191, "4537484921978326", 192},
    {3.9146420615507498996007291e-05, "391464206155075", -4},
    {8.3111353355172450081912437e-49, "8311135335517245", -48},
    {6.1677413807602833106480333e-165, "6167741380760283", -164},
    {5.7741728296491451385015013e-72, "5774172829649145", -71},
    {1.8696912524941833892792090e-30, "18696912524941834", -29},
    {1.3952049244090008879567109e+126, "1395204924409001", 127},
    {9.5154211993500955119552787e+305, "9515421199350096", 306},
    {2.1570272182812164878087420e-302, "21570272182812165", -301},
    {2.0106285171659948936832371e-215, "2010628517165995", -214},
    {2.0526041665578721771650679e-259, "20526041665578722", -258},
    {3.6589547314757319392883908e+224, "3658954731475732", 225},
    {1.3440815459672695998953706e+104, "13440815459672696", 105},
    {6.2668009273665507812500000e+13, "6266800927366551", 14},
    {6.2107390351538905482903798e+259, "621073903515389", 260},
    {2.4669907065357627092848102e-191, "24669907065357627", -190},
    {5.5778291543031021015928843e-97, "5577829154303102", -96},
    {7.3590863231884856977378771e+233, "7359086323188486", 234},
    {2.1422631286501330162770975e-149, "2142263128650133", -148},
    {3.0864165531096668539295492e-162, "3086416553109667", -161},
    {1.4957477313139534652666468e-167, "14957477313139535", -166},
    {3.2698383064318095966240862e-57, "32698383064318096", -56},
    {5.1646083953587492945239794e-308, "5164608395358749", -307},
    {1.3264209442617080549854448e-31, "1326420944261708", -30},
    {2.3185181292951220680941648e-245, "2318518129295122", -244},
    {7.8796145328227229996502245e-254, "7879614532822723", -253},
    {4.0267392217549008105575379e-26, "4026739221754901", -25},
    {2.7295888352662385870452814e-09, "27295888352662386", -8},
    {1.6010539611073712354736571e-301, "16010539611073712", -300},
    {1.7875545944088978425214563e-75, "17875545944088978", -74},
    {9.1341335724461485515542084e-156, "9134133572446149", -155},
    {4.9917036607654782541171811e-134, "4991703660765478", -133},
    {1.3234569799624434356666903e+118, "13234569799624434", 119},
    {6.5071378416843699276553508e+93, "650713784168437", 94},
    {1.5436297492444674261093023e-270, "15436297492444674", -269},
    {8.0274725705776945750056171e-100, "8027472570577695", -99},
    {1.2531606867454138868278740e-241, "12531606867454139", -240},
    {1.1831437534332381059094965e-83, "11831437534332381", -82},
    {7.4665747417860453595368634e+265, "7466574741786045", 266},
    {3.1609129661704922231775398e-176, "3160912966170492", -175},
    {3.8352877610192217907554213e+116, "3835287761019222", 117},
    {4.1583976404174974948833569e+230, "41583976404174975", 231},
    {1.2424699058367602770203850e+82, "12424699058367603", 83},
    {5.6045606447110428063358412e-171, "5604560644711043", -170},
    {2.9717762908099348774124442e-66, "2971776290809935", -65},
    {7.5146428630170749422480980e-88, "7514642863017075", -87},
    {1.1423613612777487402442615e+121, "11423613612777487", 122},
    {1.7057075273536681551454158e+128, "17057075273536682", 129},
    {4.5528810698577626609229719e-69, "45528810698577627", -68},
    {2.3038676383287774431714052e+268, "23038676383287774", 269},
    {7.5453142054275650000000000e+14, "7545314205427565", 15},
    {1.7060381599302887870248696e+189, "17060381599302888", 190},
    {5.0088466434355651615000834e+273, "5008846643435565", 274},
    {1.6911191686483656700072749e+184, "16911191686483657", 185},
    {1.4713708357458723101728175e-83, "14713708357458723", -82},
    {2.1301605877515992566916518e-274, "21301605877515993", -273},
    {1.0723168026123346906257869e-188, "10723168026123347", -187},
    {3.1949950938981308446631158e+227, "3194995093898131", 228},
    {3.2637273951795588194933326e-301, "3263727395179559", -300},
    {1.7834841390785762621505977e-55, "17834841390785763", -54},
    {1.5304971500147688759952605e+35, "15304971500147689", 36},
    {7.0116265881476426789380945e+269, "7011626588147643", 270},
    {6.4711554015345826174149281e-16, "6471155401534583", -15},
    {1.5462392924542461559136461e+248, "15462392924542462", 249},
    {3.1076086090353180835626418e-54, "3107608609035318", -53},
    {1.0665225617070789051028874e+303, "10665225617070789", 304},
    {1.8610476516758581941244788e+259, "18610476516758582", 260},
    {2.3281748185960761362239362e+53, "2328174818596076", 54},
    {4.3073381942031385618726176e-153, "43073381942031386", -152},
    {9.5110378260683816480730127e+104, "9511037826068382", 105},
    {4.1303259074216149747371674e+07, "4130325907421615", 8},
    {1.6549736651589996351641315e-176, "16549736651589996", -175},
    {1.2804169651822251486249657e+78, "12804169651822251", 79},
    {7.3138074543981524562712870e-80, "7313807454398152", -79},
    {1.0803344119470063399553860e-300, "10803344119470063", -299},
    {4.0257261099333115840047230e-211, "4025726109933312", -210},
    {1.6028238177352607891489509e+134, "16028238177352608", 135},
    {3.5697374774714657927841995e-71, "35697374774714658", -70},
    {8.5673139083151961006971200e-123, "8567313908315196", -122},
    {5.8737138919203559876454409e+169, "5873713891920356", 170},
    {2.1467033676309006585409224e-176, "21467033676309007", -175},
    {6.0606064990733080169229116e-283, "6060606499073308", -282},
    {7.0125902493648307295732408e-240, "7012590249364831", -239},
    {7.2499848305531193497420236e+80, "7249984830553119", 81},
    {2.1313980746729382385288504e-117, "21313980746729382", -116},
    {7.3250789503576791748984867e-137, "7325078950357679", -136},
    {3.8292205650198964899370900e-107, "38292205650198965", -106},
    {2.2057692208319147574362932e+57, "22057692208319148", 58},
    {2.1296682992101446006147771e-111, "21296682992101446", -110},
    {2.6819575285738587744764661e+59, "26819575285738588", 60},
    {7.1595703465421304550492498e-118, "71595703465421305", -117},
    {5.5326809785839159664904594e-184, "5532680978583916", -183},
    {4.3731177746273491715749656e-35, "4373117774627349", -34},
    {2.5885140924109410787011880e+119, "2588514092410941", 120},
    {3.2630289088145013019914882e+191, "3263028908814501", 192},
    {4.4668368988312342053145842e-196, "4466836898831234", -195},
    {7.7258043242321340399900400e+74, "7725804324232134", 75},
    {2.8605576300475644611003257e+210, "28605576300475645", 211},
    {1.6729522613727579931651674e+195, "1672952261372758", 196},
    {1.4741202343973162436850455e+138, "14741202343973162", 139},
    {3.3251046037890294097514426e-204, "33251046037890294", -203},
    {2.2514157382187461517100116e+31, "2251415738218746", 32},
    {5.3787773833196900545388044e+151, "537877738331969", 152},
    {1.8447598082476659200943709e+289, "1844759808247666", 290},
    {9.9706610517287662199730659e+104, "9970661051728766", 105},
    {1.1512658956423663558741348e+69, "11512658956423664", 70},
    {9.5305958710284516215116454e+81, "9530595871028452", 82},
    {1.6731484422257699441942574e+175, "167314844222577", 176},
    {6.7229993028951173495011084e-68, "6722999302895117", -67},
    {1.5415604126431757799977729e+39, "15415604126431758", 40},
    {2.6196477477087789554995879e-185, "2619647747708779", -184},
    {1.1161525935931508252898950e+102, "11161525935931508", 103},
    {1.8198382062977103780414130e-250, "18198382062977104", -249},
    {4.6996281324404834501489190e-144, "46996281324404835", -143},
    {6.5565742339961840657983949e+266, "6556574233996184", 267},
    {8.2191555713278111475941792e-98, "8219155571327811", -97},
    {9.4828402089929930451298289e-153, "9482840208992993", -152},
    {4.4490070639404831696691988e-280, "4449007063940483", -279},
    {2.6843516607358166105139959e+75, "26843516607358166", 76},
    {9.9055422734655226237743762e+179, "9905542273465523", 180},
    {1.3901080059412231939838166e+255, "13901080059412232", 256},
    {3.8773079845240555129975277e-19, "38773079845240555", -18},
    {3.6225871976745147543609533e+260, "3622587197674515", 261},
    {1.3885538892980489692165331e-53, "1388553889298049", -52},
    {4.8026376135960669387015006e+61, "4802637613596067", 62},
    {4.0998384702945977096318192e+257, "40998384702945977", 258},
    {2.7524816939666069625863168e-159, "2752481693966607", -158},
    {1.5821915808544422216284575e-50, "15821915808544422", -49},
    {2.7673996878128275178843115e+251, "27673996878128275", 252},
    {7.4982590653707648546762375e-241, "7498259065370765", -240},
    {5.7987002173918882297822157e+269, "5798700217391888", 270},
    {2.8018290702748905594140744e+268, "28018290702748906", 269},
    {2.0868490971267526298471964e-255, "20868490971267526", -254},
    {1.3058662976722597151871398e-89, "13058662976722597", -88},
    {9.2829170764987288093263161e-137, "9282917076498729", -136},
    {3.6921042284075089771578036e+228, "3692104228407509", 229},
    {2.5644997511056678457080135e+36, "25644997511056678", 37},
    {1.0500980341818824015579612e+91, "10500980341818824", 92},
    {1.3865332438210732385643891e+243, "13865332438210732", 244},
    {1.3296206509920233605889061e-161, "13296206509920234", -160},
    {2.2430431711445725767456792e-209, "22430431711445726", -208},
    {2.5678643595452497045457436e-243, "25678643595452497", -242},
    {3.6297891958037561159727615e-199, "3629789195803756", -198},
    {9.8115237931385219400451884e+126, "9811523793138522", 127},
    {4.8154480127826195354642857e+123, "48154480127826195", 124},
    {1.1524190122023155605138070e-122, "11524190122023156", -121},
    {1.0504531066064726521583096e+234, "10504531066064727", 235},
    {6.7274867534776832225220248e+74, "6727486753477683", 75},
    {1.0546721821258802355029987e-268, "10546721821258802", -267},
    {1.7393258428678266294113966e-230, "17393258428678266", -229},
    {5.5936647937842797851562500e+11, "559366479378428", 12},
    {1.2466683413487690864731784e-33, "12466683413487691", -32},
    {8.2393151858930945323366139e+119, "8239315185893095", 120},
    {1.7251333284837875906249978e+206, "17251333284837876", 207},
    {2.5478008157336308730131550e+65, "2547800815733631", 66},
    {3.1353706632482614368200302e+06, "31353706632482614", 7},
    {1.4002473048105505916934832e-30, "14002473048105506", -29},
    {1.2652307690449321635797884e+193, "12652307690449322", 194},
    {1.9592782174750243458884222e+224, "19592782174750243", 225},
    {1.7885963191348867345362261e-180, "17885963191348867", -179},
    {7.4309601072026396092008824e-15, "743096010720264", -14},
    {4.9258843130634153349381383e-197, "49258843130634153", -196},
    {1.1209176943519656868607789e-172, "11209176943519657", -171},
    {8.8989307556124206208122155e-271, "8898930755612421", -270},
    {2.9472329463481482439044503e-70, "2947232946348148", -69},
    {2.9086436136068020536048046e+228, "2908643613606802", 229},
    {1.3138858638609649130386758e-37, "1313885863860965", -36},
    {2.9556337155608465896490811e+183, "29556337155608466", 184},
    {3.3585593121633876476453291e-274, "33585593121633876", -273},
    {1.3860472973954021834615533e-265, "13860472973954022", -264},
    {1.1698128427317774869236186e-53, "11698128427317775", -52},
    {4.8750196590636728032021349e+170, "4875019659063673", 171},
    {8.2529251342992491604680587e-86, "8252925134299249", -85},
    {7.2947025208532623211105741e-52, "7294702520853262", -51},
    {1.6747696480508015622766443e+307, "16747696480508016", 308},
    {2.8925568197544305960289239e+113, "28925568197544306", 114},
    {7.2105320453321242238774069e+116, "7210532045332124", 117},
    {1.8980376706403012047676531e-235, "18980376706403012", -234},
    {5.4501167459592130499656866e+82, "5450116745959213", 83},
    {1.7088030340447561008216940e-217, "17088030340447561", -216},
    {1.1891514608893881002767170e-269, "11891514608893881", -268},
    {7.0454013010394304066606298e-227, "704540130103943", -226},
    {1.6758973534509026347240982e-220, "16758973534509026", -219},
    {5.1915816556764536482542101e-204, "5191581655676454", -203},
    {1.2758364502001452401444794e+239, "12758364502001452", 240},
    {1.1790709811579627440880444e-22, "11790709811579627", -21},
    {1.1498115571510212567532811e-60, "11498115571510213", -59},
    {5.4959787896558909848313456e+130, "5495978789655891", 131},
    {1.0636125824319373678983492e+114, "10636125824319374", 115},
    {5.7928888946959565994124196e-65, "5792888894695957", -64},
    {5.4161009318540046397991393e-193, "5416100931854005", -192},
    {6.8178652279334422262533394e+155, "6817865227933442", 156},
    {2.0025514778047176128695924e-249, "20025514778047176", -248},
    {1.6483386591902839473036579e-258, "1648338659190284", -257},
    {8.1561572182116053721161189e+74, "8156157218211605", 75},
    {1.9482201006141802245441703e-186, "19482201006141802", -185},
    {1.1301882100041497795851919e+194, "11301882100041498", 195},
    {1.2408094307363322726647937e-76, "12408094307363323", -75},
    {2.0753469420869178460818442e+232, "20753469420869178", 233},
    {5.4708286454835173032816054e-230, "5470828645483517", -229},
    {1.6124614498736460276136688e+306, "1612461449873646", 307},
    {2.1600250238949445377439758e+145, "21600250238949445", 146},
    {7.2033235054858710487953399e-112, "7203323505485871", -111},
    {3.9495335456430192729291147e+221, "3949533545643019", 222},
    {1.1317937345935590476819869e-21, "1131793734593559", -20},
    {2.3260612041800526438575067e+126, "23260612041800526", 127},
    {1.7492705391319613922896420e+268, "17492705391319614", 269},
    {2.4781538646298035562070736e-173, "24781538646298036", -172},
    {1.7643612784022837676652958e+84, "17643612784022838", 85},
    {9.1897727219534076274807467e-26, "9189772721953408", -25},
    {4.4695878743116712335517495e+275, "4469587874311671", 276},
    {5.0716278643190743140763437e-278, "50716278643190743", -277},
    {2.9845137711517998971099419e-10, "29845137711518", -9},
    {2.2403651315286876032303660e+298, "22403651315286876", 299},
    {1.4660832495556687041647508e+301, "14660832495556687", 302},
    {1.4907560599862611345380475e-190, "14907560599862611", -189},
    {1.0407915544180905215854327e-187, "10407915544180905", -186},
    {4.0759335679146744911489812e+67, "40759335679146745", 68},
    {2.8163798151232037751426792e+51, "28163798151232038", 52},
    {1.5116854165991556820122753e+168, "15116854165991557", 169},
    {1.7100500672852013007630548e+117, "17100500672852013", 118},
    {1.4047387619076034249364300e-290, "14047387619076034", -289},
    {2.8114700248647556685804204e+143, "28114700248647557", 144},
    {3.3026242360780919954725206e-307, "3302624236078092", -306},
    {1.7827220067857208156224541e-13, "17827220067857208", -12},
    {1.2523884908856742691095905e+195, "12523884908856743", 196},
    {2.1111457688780921627806682e+279, "21111457688780922", 280},
    {1.9619065766335053985873467e-11, "19619065766335054", -10},
    {3.1387287732033790839500017e+237, "3138728773203379", 238},
    {4.4302629691638529371533770e-40, "4430262969163853", -39},
    {1.4316214390995219265917862e-201, "1431621439099522", -200},
    {2.1566614862579406210382196e+40, "21566614862579406", 41},
    {1.3359989202011881942718083e-201, "13359989202011882", -200},
    {4.2730941254961429298616567e-248, "4273094125496143", -247},
    {5.5946979730346411095608683e+82, "5594697973034641", 83},
    {1.2709034965009805297315192e-257, "12709034965009805", -256},
    {1.1122603203788615613378306e-269, "11122603203788616", -268},
    {9.1571473854695662618255529e+136, "9157147385469566", 137},
    {9.4640992607687392337742503e-95, "9464099260768739", -94},
    {6.3399258189959620198400000e+20, "6339925818995962", 21},
    {2.5149691763132806242245739e-76, "25149691763132806", -75},
    {2.9074763768226401461575517e-05, "290747637682264", -4},
    {5.4557554071208817169203594e+85, "5455755407120882", 86},
    {1.9961774166831552201986670e-102, "19961774166831552", -101},
    {4.6505362397613166923805818e+127, "4650536239761317", 128},
    {1.3839073237307056221032637e-107, "13839073237307056", -106},
    {1.2268617080453113938798319e+258, "12268617080453114", 259},
    {8.1881924631502028921605951e+158, "8188192463150203", 159},
    {5.1314544612827552875835874e-212, "5131454461282755", -211},
    {2.7194485801319328826172210e+49, "2719448580131933", 50},
    {3.8008220195929735161099920e-237, "38008220195929735", -236},
    {7.3809977066999679859263977e-42, "7380997706699968", -41},
    {7.2399447545480735199136112e-261, "72399447545480735", -260},
    {8.9001358604818941206727811e-139, "8900135860481894", -138},
    {5.0138355927843573876949058e+263, "50138355927843574", 264},
    {1.7559910438464888069161830e+71, "17559910438464888", 72},
    {6.7244478190016972209884209e-285, "6724447819001697", -284},
    {8.8416922641818398477154189e+223, "884169226418184", 224},
    {2.8674652500633851060900962e-63, "2867465250063385", -62},
    {8.6998259383839788173170549e-04, "8699825938383979", -3},
    {3.1370500556820794867271628e+162, "31370500556820795", 163},
    {5.7415752051975066664453795e-242, "5741575205197507", -241},
    {2.4578456624005756448012912e-241, "24578456624005756", -240},
    {2.0328810134400904794103113e+157, "20328810134400905", 158},
    {1.2758651918475128647761849e-274, "12758651918475129", -273},
    {1.7472859200691664115171486e+44, "17472859200691664", 45},
    {4.5154189932957801667357657e+216, "451541899329578", 217},
    {5.8940697497938323235916334e+153, "5894069749793832", 154},
    {4.0214379906946010082401524e+161, "4021437990694601", 162},
    {1.2281744637139354842605340e+119, "12281744637139355", 120},
    {1.1001027620874285686802406e+263, "11001027620874286", 264},
    {7.6610186227799543931762306e+281, "7661018622779954", 282},
    {2.4127517826165893090162621e+188, "24127517826165893", 189},
    {5.8406116044122354006040255e-66, "5840611604412235", -65},
    {8.1053478680458053390516590e-216, "8105347868045805", -215},
    {9.5636671102660585191464910e-149, "9563667110266059", -148},
    {3.9954878177330349319536593e-247, "3995487817733035", -246},
    {2.1903335037147172279429366e+27, "21903335037147172", 28},
    {2.4027028801225092767876896e+202, "24027028801225093", 203},
    {3.5516712693923504042571716e+208, "35516712693923504", 209},
    {7.4913462506173560920637901e+288, "7491346250617356", 289},
    {1.5359146664721254294297080e-139, "15359146664721254", -138},
    {2.2204403369594823751256509e+80, "22204403369594824", 81},
    {1.9566777404270243965186962e+139, "19566777404270244", 140},
    {4.6324161774433025000000000e+14, "46324161774433025", 15},
    {2.0046219972771396090893692e-03, "20046219972771396", -2},
    {8.6010685684399794508009543e-277, "8601068568439979", -276},
    {3.6962307585403167481730606e-256, "3696230758540317", -255},
    {5.8938656113383981065033043e-239, "5893865611338398", -238},
    {2.6929084215645967800945274e-250, "26929084215645968", -249},
    {1.6734658093805287161575387e-150, "16734658093805287", -149},
    {3.3564602750383400373958883e+215, "335646027503834", 216},
    {8.9724182836817840000000000e+15, "8972418283681784", 16},
    {2.4420160824783726362460705e-72, "24420160824783726", -71},
    {1.4878080454375754486327254e+225, "14878080454375754", 226},
    {3.1207062870626232115258721e-09, "31207062870626232", -8},
    {6.6025839996597259571572418e-14, "6602583999659726", -13},
    {1.2583002467391070091615368e+149, "1258300246739107", 150},
    {2.2419427120379290381326277e-129, "2241942712037929", -128},
    {1.6847487210964385807101427e-261, "16847487210964386", -260},
    {4.6631228539309680884585917e-259, "4663122853930968", -258},
    {2.9487804262453150888742137e-63, "2948780426245315", -62},
    {7.0565071371769038766080000e+21, "7056507137176904", 22},
    {1.1497019669366750317802447e-86, "1149701966936675", -85},
    {2.6747361942148095158028382e+162, "26747361942148095", 163},
    {5.7507813961896970244047515e-307, "5750781396189697", -306},
    {1.4112995857586830121636978e+197, "1411299585758683", 198},
    {3.4187737278125988986761448e+137, "3418773727812599", 138},
    {2.5814245632044035885830018e-272, "25814245632044036", -271},
    {5.5102122814798616498924753e-39, "55102122814798616", -38},
    {2.5015275201035136939914547e+101, "25015275201035137", 102},
    {3.4942362901098480292220795e-56, "3494236290109848", -55},
    {8.9562597888162451920095841e-36, "8956259788816245", -35},
    {1.3990434500003092902117487e+255, "13990434500003093", 256},
    {1.4085911777160679386103810e-162, "1408591177716068", -161},
    {3.8551808784010692128523707e-32, "3855180878401069", -31},
    {7.5272722712389850042280288e+188, "7527272271238985", 189},
    {2.4816519497989657450679059e+224, "24816519497989657", 225},
    {1.8637926212757736398563143e-278, "18637926212757736", -277},
    {1.3082850857714387118003657e-239, "13082850857714387", -238},
    {4.8876363714709736105884093e+53, "4887636371470974", 54},
    {1.2270181006096582231239398e-188, "12270181006096582", -187},
    {6.9295884820234331640200797e-190, "6929588482023433", -189},
    {1.1104544643121601598263367e+122, "11104544643121602", 123},
    {1.4470616044872445220041881e-268, "14470616044872445", -267},
    {9.8070989047747469333579832e+298, "9807098904774747", 299},
    {1.2919628452326268957129573e+207, "1291962845232627", 208},
    {3.9072340145624990001365059e+94, "3907234014562499", 95},
    {2.2712381233075380709037738e+270, "2271238123307538", 271},
    {3.9929076194798744473247253e+164, "39929076194798744", 165},
    {5.8777952326215972431593448e+203, "5877795232621597", 204},
    {1.4999692099811957821059403e-140, "14999692099811958", -139},
    {3.1702420004612994595893327e+168, "31702420004612995", 169},
    {2.9634960747069467441338103e+127, "29634960747069467", 128},
    {1.3938552386005609135702068e+29, "1393855238600561", 30},
    {3.9952472308621590867138300e-41, "3995247230862159", -40},
    {6.2799561389731073096127383e+270, "6279956138973107", 271},
    {5.4966708883610318114126568e+95, "5496670888361032", 96},
    {9.6084269897013948948865926e+248, "9608426989701395", 249},
    {1.9079387271434776680859780e+188, "19079387271434777", 189},
    {3.4781598990403766919653571e+124, "34781598990403767", 125},
    {3.3246480836695989826667986e-246, "3324648083669599", -245},
    {4.0510543128077519867662465e+121, "4051054312807752", 122},
    {2.6420008817308264438518751e-215, "26420008817308264", -214},
    {3.8031217340222618424220876e-282, "3803121734022262", -281},
    {1.6578373066091170855423904e-137, "1657837306609117", -136},
    {6.3620180905154762076111911e+148, "6362018090515476", 149},
    {2.9967209541366824535776306e-07, "29967209541366825", -6},
    {6.8952311104598643499787976e+81, "6895231110459864", 82},
    {3.8101949911805516426074841e+178, "3810194991180552", 179},
    {5.2155727011986237174429496e-214, "5215572701198624", -213},
    {9.0717338253895528301441700e+209, "9071733825389553", 210},
    {6.6167725297994620632380247e+05, "6616772529799462", 6},
    {3.1121519747213489637231452e-268, "3112151974721349", -267},
    {1.5888719492259464744261010e+247, "15888719492259465", 248},
    {3.4933817697933223561812335e-165, "34933817697933224", -164},
    {5.7547505777136124442010107e+249, "57547505777136124", 250},
    {4.8749079055608937395714470e-61, "4874907905560894", -60},
    {8.1129647684135365039600272e-168, "81129647684135365", -167},
    {1.6751943258099346525106209e-171, "16751943258099347", -170},
    {5.0220655267409348146628364e+30, "5022065526740935", 31},
    {6.2313961767644118165245916e+262, "6231396176764412", 263},
    {6.4963742057353043977923838e+269, "6496374205735304", 270},
    {5.6590343808179246698096040e+152, "5659034380817925", 153},
    {8.6088036984749988060454659e-294, "8608803698474999", -293},
    {1.3357626070751911077995885e+203, "13357626070751911", 204},
    {6.5926748880081608096099877e-249, "6592674888008161", -248},
    {5.2898623704841290076646455e+307, "5289862370484129", 308},
    {2.1284679770614866729385153e+70, "21284679770614867", 71},
    {2.7741311554493760564854170e-30, "2774131155449376", -29},
    {9.3503692348320960000000000e+16, "9350369234832096", 17},
    {1.2218825265265907558227788e+56, "12218825265265908", 57},
    {7.0128382985601465911716900e-309, "7012838298560147", -308},
    {2.4827964976241734397632832e+149, "24827964976241734", 150},
    {1.0881634151334604045652021e-36, "10881634151334604", -35},
    {6.0239856372380595249772665e+256, "602398563723806", 257},
    {1.4593096062672271123664459e+214, "1459309606267227", 215},
    {8.5852114529985386096271420e+237, "8585211452998539", 238},
    {7.6285409263203374858240000e+21, "7628540926320337", 22},
    {1.4765657920298223225400188e+212, "14765657920298223", 213},
    {2.5421365915681178668158141e+94, "2542136591568118", 95},
    {1.9182580362949328344754160e-153, "19182580362949328", -152},
    {1.1833425291014714387076643e-282, "11833425291014714", -281},
    {2.0192434604947188335179865e+206, "2019243460494719", 207},
    {3.2084142719530914426622110e-282, "32084142719530914", -281},
    {7.4331748846355299369329766e-103, "743317488463553", -102},
    {1.8923796045998151635030887e-200, "18923796045998152", -199},
    {7.8181200651284853815486368e-139, "7818120065128485", -138},
    {7.2251360358072417002245072e-31, "7225136035807242", -30},
    {2.0629889898966959312768281e-255, "2062988989896696", -254},
    {1.0574406832880055937462708e+204, "10574406832880056", 205},
    {3.9739616138330574706364111e+155, "39739616138330575", 156},
    {2.1824987883587336709143308e-93, "21824987883587337", -92},
    {1.8581802402640270947922226e-84, "1858180240264027", -83},
    {2.6325757399551437160736169e+42, "26325757399551437", 43},
    {2.8481633731070404521690402e-203, "28481633731070405", -202},
    {2.4904856354880178719903087e+243, "2490485635488018", 244},
    {3.4175757430414600060242292e+269, "341757574304146", 270},
    {3.6724664623630036705819430e-60, "36724664623630037", -59},
    {1.0165447200224783834396297e-23, "10165447200224784", -22},
    {5.2757470642249821872796799e+67, "5275747064224982", 68},
    {1.3240983543243455296580676e-39, "13240983543243455", -38},
    {1.2461796269596226688002345e+67, "12461796269596227", 68},
    {1.0694520465719643876713678e-263, "10694520465719644", -262},
    {1.0299269087003094364320780e-57, "10299269087003094", -56},
    {4.7753317781929454172604643e+165, "47753317781929454", 166},
    {1.0687380618970533586339000e+127, "10687380618970534", 128},
    {1.1044587729667648243406564e-103, "11044587729667648", -102},
    {4.7295323717747946035273392e-250, "47295323717747946", -249},
    {4.2490911939809705825248582e+194, "42490911939809706", 195},
    {9.0309756501156653706313764e+83, "9030975650115665", 84},
    {7.6371586181167112377404923e+88, "7637158618116711", 89},
    {5.0006760148148019361529966e-96, "5000676014814802", -95},
    {6.4921211475050588706639763e+68, "6492121147505059", 69},
    {1.4581062534818953218679146e-26, "14581062534818953", -25},
    {4.8377289409916298582939827e-104, "483772894099163", -103},
    {8.6070189768158288669255718e+239, "8607018976815829", 240},
    {2.5467312117617264384633648e-85, "25467312117617264", -84},
    {1.2735797802638466175223692e-243, "12735797802638466", -242},
    {2.7867346293345046411700880e-112, "27867346293345046", -111},
    {2.5649269584742463687088895e-196, "25649269584742464", -195},
    {7.7265641236233447210574777e+115, "7726564123623345", 116},
    {6.3566471005031739023777085e+110, "6356647100503174", 111},
    {1.6847370236179439804343045e-36, "1684737023617944", -35},
    {5.5102788359242149161189353e-251, "5510278835924215", -250},
    {2.8270486424862017932933482e-204, "28270486424862018", -203},
    {1.6075999147888803017379163e+123, "16075999147888803", 124},
    {7.5554562250244392954480456e-284, "7555456225024439", -283},
    {2.2158737157830447219649956e-07, "22158737157830447", -6},
    {1.3240604979798949123715399e-56, "1324060497979895", -55},
    {2.1192439411718496174318687e+171, "21192439411718496", 172},
    {7.4126800015238617439902670e+221, "7412680001523862", 222},
    {1.9080775635035689920186996e+07, "1908077563503569", 8},
    {1.6624226663561933209236288e+303, "16624226663561933", 304},
    {8.1349375142716067765140095e+242, "8134937514271607", 243},
    {8.4181805806439519933699925e-278, "8418180580643952", -277},
    {6.0495285617131556725518034e-275, "6049528561713156", -274},
    {8.1584004466924114722103933e-05, "8158400446692411", -4},
    {3.5643858213029319696723216e-209, "3564385821302932", -208},
    {3.6406733146712260877834350e+109, "3640673314671226", 110},
    {7.0250945860617855938211819e+72, "70250945860617856", 73},
    {2.0129161929034696025282801e-207, "20129161929034696", -206},
    {1.0219057218507547096006094e+299, "10219057218507547", 300},
    {9.5968166337707824540792669e-271, "9596816633770782", -270},
    {6.2786712860085623871561238e-196, "6278671286008562", -195},
    {1.2251366797249037623501335e-169, "12251366797249038", -168},
    {7.5580874916030108346299435e-84, "7558087491603011", -83},
    {1.5058306573847122470012524e-163, "15058306573847122", -162},
    {5.7768786061594973834524019e+114, "5776878606159497", 115},
    {7.5509423718315480322698447e+78, "7550942371831548", 79},
    {5.4870332963835829423168313e-159, "5487033296383583", -158},
    {3.5396895461615902103466162e+89, "353968954616159", 90},
    {2.0405594742718788355205464e+53, "2040559474271879", 54},
    {2.4987331051221966878110952e-210, "24987331051221967", -209},
    {1.5154589352396029343322414e-219, "1515458935239603", -218},
    {8.2772536682963789798414769e+96, "8277253668296379", 97},
    {1.4520307338368440889207756e-04, "1452030733836844", -3},
    {3.8410812504067019448923738e-235, "3841081250406702", -234},
    {1.8661651076292320000000000e+17, "1866165107629232", 18},
    {1.5849371611709143747836491e-183, "15849371611709144", -182},
    {5.1192156911291953096335900e-101, "5119215691129195", -100},
    {1.0350636023039608144807496e+191, "10350636023039608", 192},
    {1.2155150893650932687174701e-124, "12155150893650933", -123},
    {6.5699796718591675676919506e-282, "65699796718591676", -281},
    {8.9783960388710704194367989e-35, "897839603887107", -34},
    {6.1177088092611790736876164e+279, "6117708809261179", 280},
    {9.5399489404170246124267578e+09, "9539948940417025", 10},
    {3.2096872871165214976516729e+240, "32096872871165215", 241},
    {2.5238453215752949626632132e+145, "2523845321575295", 146},
    {2.3883541742701199334149898e+281, "238835417427012", 282},
    {1.2890385859584528952836990e+06, "1289038585958453", 7},
    {2.9730427798972063744860904e+150, "29730427798972064", 151},
    {8.1570234962327631116163097e+287, "8157023496232763", 288},
    {5.1652678894707878862499728e-235, "5165267889470788", -234},
    {2.7469090883088029156045406e+194, "2746909088308803", 195},
    {2.2784885363648106737539735e-120, "22784885363648107", -119},
    {2.1385809251327713220743106e+40, "21385809251327713", 41},
    {6.8030211385547592051772939e-71, "6803021138554759", -70},
    {1.5105481300971496338635919e+297, "15105481300971496", 298},
    {3.6977031618808729172321223e-188, "3697703161880873", -187},
    {2.7262996520456562508038374e+50, "27262996520456563", 51},
    {2.0578763243462042059506304e+31, "2057876324346204", 32},
    {1.0184481342128753848126644e+180, "10184481342128754", 181},
    {5.5102649816748030598491228e+206, "5510264981674803", 207},
    {9.8818378312923675424048837e+111, "9881837831292368", 112},
    {5.5732346071598547363281250e+11, "5573234607159855", 12},
    {2.4427464625978895301295737e+144, "24427464625978895", 145},
    {6.3878964832398135857346505e-111, "63878964832398136", -110},
    {1.3178269316877963903314688e+39, "13178269316877964", 40},
    {3.6616858353667133367176434e-299, "36616858353667133", -298},
    {1.4103127341662892103923125e+218, "14103127341662892", 219},
    {6.9931012333180198605654090e-43, "699310123331802", -42},
    {9.3435194691398634303670368e+144, "9343519469139863", 145},
    {3.2338483798602722448948508e-109, "32338483798602722", -108},
    {2.5507349892485839243210704e-50, "2550734989248584", -49},
    {5.9401192237921556865265204e-24, "5940119223792156", -23},
    {2.3393155188982959140658808e+53, "2339315518898296", 54},
    {1.6721950871729278055318195e+96, "16721950871729278", 97},
    {1.1772869410933941760000000e+18, "11772869410933942", 19},
    {1.1652332719318894938389256e+151, "11652332719318895", 152},
    {1.2700763050458907217479651e-228, "12700763050458907", -227},
    {8.8124969102147303057611972e+99, "881249691021473", 100},
    {8.7506281396459398314149973e+188, "875062813964594", 189},
    {8.2524552718375023516499419e-294, "8252455271837502", -293},
    {2.8684585117473578149861875e+42, "2868458511747358", 43},
    {3.2222791217155512526877307e+47, "32222791217155513", 48},
    {1.0550811525018492287875094e-56, "10550811525018492", -55},
    {7.8733091377302995977904843e-03, "78733091377303", -2},
    {9.7352009080277439001810996e+79, "9735200908027744", 80},
    {5.1252646361100378271657974e+03, "5125264636110038", 4},
    {2.6672873901315590865711217e-300, "2667287390131559", -299},
    {1.9317136736522710603087398e+302, "1931713673652271", 303},
    {4.9466605939196990436785491e-131, "4946660593919699", -130},
    {1.4809174118868706346356613e-06, "14809174118868706", -5},
    {1.7986087721214821795001626e+05, "17986087721214822", 6},
    {4.0767962609133190292430113e-30, "4076796260913319", -29},
    {1.8308347757712211837858832e-115, "18308347757712212", -114},
    {1.6720086660571588873564698e+31, "16720086660571589", 32},
    {4.2493682010768901952066282e+118, "424936820107689", 119},
    {7.4578201706716332063617719e+279, "7457820170671633", 280},
    {6.5893571078405921949974154e+254, "6589357107840592", 255},
    {2.5313794312758547036804702e+257, "25313794312758547", 258},
    {1.8873655449833616799724479e-270, "18873655449833617", -269},
    {4.9482196963096579249060473e+85, "4948219696309658", 86},
    {3.2295260318084717623138316e+46, "3229526031808472", 47},
    {5.4799070767635887204036585e+304, "5479907076763589", 305},
    {6.0663548736544801832396990e-308, "606635487365448", -307},
    {9.0348815646298640545328821e+260, "9034881564629864", 261},
    {3.0433864701059131421944644e-204, "3043386470105913", -203},
    {2.0881452631035967015936918e-213, "20881452631035967", -212},
    {2.5857299181647305511356921e+160, "25857299181647306", 161},
    {2.0704559671859571942802152e-75, "20704559671859572", -74},
    {2.5182245988692514993343030e-62, "25182245988692515", -61},
    {3.0632870192646348539455261e+47, "3063287019264635", 48},
    {4.7634768042291229678159582e+305, "4763476804229123", 306},
    {6.1477713919327715299879788e-95, "6147771391932772", -94},
    {2.1313206695014179501140913e-102, "2131320669501418", -101},
    {1.2945681079990456964065899e-86, "12945681079990457", -85},
    {2.7407963303174823237375189e-160, "27407963303174823", -159},
    {9.0978787534748508939174111e-166, "9097878753474851", -165},
    {1.2475125949664576910436153e+06, "12475125949664577", 7},
    {1.7869843425346747235106864e+195, "17869843425346747", 196},
    {1.1411386943206858885416013e+171, "11411386943206859", 172},
    {8.8502449222556486307988998e+74, "8850244922255649", 75},
    {6.5590474329353210484069721e-172, "6559047432935321", -171},
    {1.8489187008591595653717984e+272, "18489187008591596", 273},
    {4.6697367117004018633529232e+235, "4669736711700402", 236},
    {1.2957794636630668808567456e-254, "12957794636630669", -253},
    {2.5865677313591185838134949e-234, "25865677313591186", -233},
    {4.3586494328236312056815533e+167, "4358649432823631", 168},
    {7.2855234798962972753380066e+186, "7285523479896297", 187},
    {7.3500421925304735751522679e+214, "7350042192530474", 215},
    {1.6142829055605516723575283e+165, "16142829055605517", 166},
    {1.8650278613534743003250750e-131, "18650278613534743", -130},
    {3.2449421190472184364925419e-237, "32449421190472184", -236},
    {6.7459716494577910414940195e+187, "6745971649457791", 188},
    {2.7379428906024787684860454e-263, "27379428906024788", -262},
    {5.7441983927768212720143683e-180, "5744198392776821", -179},
    {1.1990362206792384523643526e-49, "11990362206792385", -48},
    {8.4729294250908307978643369e-291, "8472929425090831", -290},
    {3.3045597996544127320846776e+237, "3304559799654413", 238},
    {8.9920009424236987131205746e-63, "8992000942423699", -62},
    {1.1408472269992767432982227e-297, "11408472269992767", -296},
    {2.0259530535758764778475037e+40, "20259530535758765", 41},
    {2.1916059624060590311685648e-84, "2191605962406059", -83},
    {1.3333396490288543835911704e+58, "13333396490288544", 59},
    {1.8573237249049301257328648e-165, "18573237249049301", -164},
    {4.5238900567822134600600862e+123, "45238900567822135", 124},
    {7.2199624882197595422720000e+21, "721996248821976", 22},
    {1.2972246614117812193775152e+157, "12972246614117812", 158},
    {3.8170185574713614443224428e+90, "38170185574713614", 91},
    {3.0069267813444351522091136e+217, "3006926781344435", 218},
    {1.1691160249379562369741215e-40, "11691160249379562", -39},
    {2.4122159689650395254020557e+297, "24122159689650395", 298},
    {1.2587605645056112490652548e-181, "12587605645056112", -180},
    {6.7505426677262858403242950e-300, "6750542667726286", -299},
    {6.0405437880801338684655163e+186, "6040543788080134", 187},
    {1.3687319630225714017989089e+98, "13687319630225714", 99},
    {2.4164959315375357892793437e+50, "24164959315375358", 51},
    {2.3655706562098521051721305e-305, "2365570656209852", -304},
    {1.0906254299284054345270616e-103, "10906254299284054", -102},
    {1.4875473585591762082573309e+171, "14875473585591762", 172},
    {3.7170990597468533022868583e-58, "3717099059746853", -57},
    {3.4947592788348963295151573e+262, "3494759278834896", 263},
    {4.6526536414545054278797468e-111, "46526536414545054", -110},
    {3.2392399974583807355410016e+53, "32392399974583807", 54},
    {2.1599685870411263581059112e+200, "21599685870411264", 201},
    {5.8522050282183883434557673e+125, "5852205028218388", 126},
    {1.8666471816175831713891002e+249, "1866647181617583", 250},
    {8.5955198318821713366398907e-135, "8595519831882171", -134},
    {1.8417482067898032362054428e+150, "18417482067898032", 151},
    {1.3298816027560401477069786e+109, "13298816027560401", 110},
    {6.5389323801468245747904156e-121, "6538932380146825", -120},
    {5.0143671712874588289315000e-121, "5014367171287459", -120},
    {4.2841068888538544589461699e+195, "42841068888538545", 196},
    {5.3812007659475484997827023e+120, "5381200765947548", 121},
    {6.6065656572558457212139562e+242, "6606565657255846", 243},
    {4.6804214687624336604370523e-68, "4680421468762434", -67},
    {5.1811447343241446166831528e+43, "5181144734324145", 44},
    {1.7795340281362306810946777e+236, "17795340281362307", 237},
    {1.8519009383691427013227253e-119, "18519009383691427", -118},
    {1.2628225195107762136530176e-179, "12628225195107762", -178},
    {1.2846601432545054327668623e+157, "12846601432545054", 158},
    {1.6985513325623628699829545e-18, "16985513325623629", -17},
    {1.3176166307125588848916539e-154, "13176166307125589", -153},
    {1.3344526786319324437705638e-120, "13344526786319324", -119},
    {3.3381398809776997463990500e-198, "33381398809776997", -197},
    {4.1268773045746418005878337e+247, "4126877304574642", 248},
    {5.1353054199199125873682634e-104, "51353054199199126", -103},
    {3.7167470646408964133572504e+99, "37167470646408964", 100},
    {2.8007932853330759783217005e-164, "2800793285333076", -163},
    {2.5011971777116539631340742e-114, "2501197177711654", -113},
    {1.4521879023230966940822288e+121, "14521879023230967", 122},
    {9.4357232953991727150862349e-136, "9435723295399173", -135},
    {1.8040561571422980406708667e+252, "1804056157142298", 253},
    {2.9912614429417363316245274e-215, "29912614429417363", -214},
    {2.1924546781273002076231648e+129, "21924546781273002", 130},
    {5.6096503628871395622444393e+194, "56096503628871396", 195},
    {8.3281037666305892856093509e-243, "8328103766630589", -242},
    {1.5273593416636434033084875e-209, "15273593416636434", -208},
    {1.1888156456011831991380619e-107, "11888156456011832", -106},
    {2.3322116007133516934204145e-45, "23322116007133517", -44},
    {3.1522792308384694154747173e+283, "31522792308384694", 284},
    {5.0903091685711545155589030e-97, "5090309168571155", -96},
    {2.1329152985020403035698407e-233, "21329152985020403", -232},
    {3.0374824669937585034044180e-243, "30374824669937585", -242},
    {5.7229322091671903913238993e+178, "57229322091671904", 179},
    {7.9798666550330211627696058e-247, "7979866655033021", -246},
    {8.6292096113098589325468486e-122, "8629209611309859", -121},
    {7.0644425665699939710104291e-246, "7064442566569994", -245},
    {1.4324465678960016690246491e-108, "14324465678960017", -107},
    {5.1394539484321391107488343e-73, "5139453948432139", -72},
    {5.5122355562082921014868852e-65, "5512235556208292", -64},
    {2.4511474762605848176823012e-249, "2451147476260585", -248},
    {1.1570531288785846435091083e+167, "11570531288785846", 168},
    {5.9347111326533282795041302e+220, "5934711132653328", 221},
    {2.3673997639726258959269185e-93, "2367399763972626", -92},
    {1.5506300128038074158032762e-75, "15506300128038074", -74},
    {9.5236490915333412725625061e+36, "9523649091533341", 37},
    {5.4328956386027621963000721e-126, "5432895638602762", -125},
    {8.9492785821087730068653984e-184, "8949278582108773", -183},
    {2.6728868185223414797242665e-106, "26728868185223415", -105},
    {2.9025108646528309562204908e+232, "2902510864652831", 233},
    {2.7182088716672823800668850e-265, "27182088716672824", -264},
    {3.5777847280458366609177395e-132, "35777847280458367", -131},
    {1.4774666378826047316686726e+181, "14774666378826047", 182},
    {1.4945794343820660932148936e-35, "1494579434382066", -34},
    {5.4870877672265318029122761e+255, "5487087767226532", 256},
    {9.6078902980607608333230019e+05, "9607890298060761", 6},
    {7.0129398777487824121361645e+68, "7012939877748782", 69},
    {1.2977189067842643818294774e-39, "12977189067842644", -38},
    {3.2816466306110069947004630e+54, "3281646630611007", 55},
    {1.9492256022177858910329833e-100, "1949225602217786", -99},
    {1.8482440381073438118164631e+01, "18482440381073438", 2},
    {1.8010156611381357721633520e+112, "18010156611381358", 113},
    {1.1151012173262055003732002e-209, "11151012173262055", -208},
    {5.6948157079611111249362038e+271, "5694815707961111", 272},
    {3.5819885124756293185040809e+90, "35819885124756293", 91},
    {5.6207127158828361612630808e+122, "5620712715882836", 123},
    {8.1306895293321506040394290e-85, "8130689529332151", -84},
    {9.1177110688930203070893074e-71, "911771106889302", -70},
    {1.1199831674347830801402407e-145, "1119983167434783", -144},
    {2.9689409331207923889160156e+10, "29689409331207924", 11},
    {7.7517389307565578555228160e+24, "7751738930756558", 25},
    {8.0914616799130861138406281e+285, "8091461679913086", 286},
    {3.3811900089728442325709423e-04, "3381190008972844", -3},
    {4.6454144469579597558984383e-108, "464541444695796", -107},
    {8.0794936262448575436184923e-08, "8079493626244858", -7},
    {1.4125452177677108619263095e-137, "14125452177677109", -136},
    {2.6800573688480512228874733e-213, "26800573688480512", -212},
    {9.0376366967529603404219567e-298, "903763669675296", -297},
    {2.1580303641135428613721026e-85, "2158030364113543", -84},
    {8.8368644081995996417572041e-98, "88368644081996", -97},
    {2.3944871811478932955482091e-192, "23944871811478933", -191},
    {4.6008761690846864054864060e-249, "4600876169084686", -248},
    {5.7908059095982027863912487e+293, "5790805909598203", 294},
    {5.2098024463046062762195491e-250, "5209802446304606", -249},
    {4.1826675128723203125000000e+13, "418266751287232", 14},
    {1.7203973018946419035966728e+141, "1720397301894642", 142},
    {4.4094115132507601430880547e-211, "440941151325076", -210},
    {7.3657298841059919141116552e+03, "7365729884105992", 4},
    {4.9015148401886538591826981e+242, "4901514840188654", 243},
    {1.6463533271318771200045339e+208, "16463533271318771", 209},
    {2.7543452917730178124875713e-129, "27543452917730178", -128},
    {1.3059987324809528417154797e-84, "13059987324809528", -83},
    {7.8701848854595344294000632e+209, "7870184885459534", 210},
    {6.3453266139147438739646560e+202, "6345326613914744", 203},
    {4.8809979413374702486455992e+104, "488099794133747", 105},
    {2.2541887028124122243551717e-301, "22541887028124122", -300},
    {3.0024586780013551829035261e+272, "3002458678001355", 273},
    {9.9242000627864976464596306e-65, "9924200062786498", -64},
    {1.3001277901928521161717323e-70, "13001277901928521", -69},
    {2.1667263866178111748742073e+238, "21667263866178112", 239},
    {2.2222932419649828331458284e+281, "22222932419649828", 282},
    {5.1811008235815265912936216e+136, "5181100823581527", 137},
    {1.1046411852227349804160759e+226, "1104641185222735", 227},
    {2.1516641990734531126467511e+127, "2151664199073453", 128},
    {4.1698280130113259218770505e-41, "4169828013011326", -40},
    {1.6968931021428262969942784e+47, "16968931021428263", 48},
    {4.9528112301088924143183438e-10, "4952811230108892", -9},
    {1.3876001050922197794991594e-132, "13876001050922198", -131},
    {3.9550679235634061945198433e-143, "3955067923563406", -142},
    {1.7412863792422788096178097e-278, "17412863792422788", -277},
    {3.0197725802529984695909067e+214, "30197725802529985", 215},
    {3.5663403333522592220106162e+03, "3566340333352259", 4},
    {1.3244015893293853457973957e-259, "13244015893293853", -258},
    {5.1646762283613545023552456e-199, "51646762283613545", -198},
    {3.8160959557430634223992762e-94, "38160959557430634", -93},
    {9.1769172000578255648179129e+53, "9176917200057826", 54},
    {7.4351296197043201521170118e-91, "743512961970432", -90},
    {2.8897853357199236851080748e-304, "28897853357199237", -303},
    {1.5791405575618359215883306e-290, "1579140557561836", -289},
    {5.8972498757235027125992713e-172, "5897249875723503", -171},
    {2.8747816426885245175353372e+166, "28747816426885245", 167},
    {2.5881062288420331250000000e+14, "2588106228842033", 15},
    {4.7446965176434999711978760e+288, "47446965176435", 289},
    {5.3598035986524656250000000e+13, "5359803598652466", 14},
    {2.9829455003326609947590222e-138, "2982945500332661", -137},
    {3.1707301254521365052596593e+00, "31707301254521365", 1},
    {7.8047782983640265526466644e+198, "7804778298364027", 199},
    {2.2846792981863537331084116e+234, "22846792981863537", 235},
    {8.8749306932760229374763512e-244, "8874930693276023", -243},
    {5.0174961184012099730137462e+176, "501749611840121", 177},
    {4.7719636786372985368198291e+303, "47719636786372985", 304},
    {4.0971191350069560603633071e-145, "4097119135006956", -144},
    {3.3121500370828385646600377e-128, "33121500370828386", -127},
    {9.2744035956461501152553913e+111, "927440359564615", 112},
    {1.3980384055785591464414689e-46, "13980384055785591", -45},
    {1.2283987211604651639479607e+255, "12283987211604652", 256},
    {1.2296017757041605128364647e-148, "12296017757041605", -147},
    {1.6402698293572348198897742e+82, "16402698293572348", 83},
    {1.5992139185483741602560919e+35, "15992139185483742", 36},
    {1.1526630517353954913935906e-155, "11526630517353955", -154},
    {3.1198864953577414945798724e+29, "31198864953577415", 30},
    {1.3336867006600687173443586e-114, "13336867006600687", -113},
    {4.7262052673416724233248424e-31, "4726205267341672", -30},
    {1.1986513140906978058808363e+00, "11986513140906978", 1},
    {1.0211120039693912012468710e-131, "10211120039693912", -130},
    {6.8468587320370411622371943e+41, "6846858732037041", 42},
    {4.4626304893241647946801548e+207, "4462630489324165", 208},
    {1.5616587150114691931344705e+207, "15616587150114692", 208},
    {1.2628944021591873827047914e+213, "12628944021591874", 214},
    {8.5940100901151743031597178e+285, "8594010090115174", 286},
    {1.6148934138857994537773456e+83, "16148934138857995", 84},
    {1.9142891292217767426205276e-303, "19142891292217767", -302},
    {3.2186852569976832701956825e+155, "32186852569976833", 156},
    {1.1509539853852253314507025e-111, "11509539853852253", -110},
    {1.6522368959859558400000000e+17, "1652236895985956", 18},
    {7.0380627795970698141823206e-246, "703806277959707", -245},
    {5.0045074537766477104097999e-270, "5004507453776648", -269},
    {1.5356032763485192625910067e-244, "15356032763485193", -243},
    {1.4814155586452024786019717e-291, "14814155586452025", -290},
    {1.4371290687291113483568272e-148, "14371290687291113", -147},
    {2.8513249592345562367650667e+234, "28513249592345562", 235},
    {2.9968982068588801882452717e-91, "299689820685888", -90},
    {1.2639897467197973156365699e+64, "12639897467197973", 65},
    {2.0832888649659510874605749e-184, "2083288864965951", -183},
    {2.6318423016760098740062242e+185, "263184230167601", 186},
    {3.2996024358512366699423542e+272, "32996024358512367", 273},
    {1.8054614725060370221828380e+236, "1805461472506037", 237},
    {2.3730895640314480800188722e-202, "2373089564031448", -201},
    {6.1740283782248896000000000e+16, "617402837822489", 17},
    {1.0774912057806586311200186e+198, "10774912057806586", 199},
    {1.0666788482818538588903116e-211, "10666788482818539", -210},
    {7.8881257238120898959801958e+33, "788812572381209", 34},
    {2.9143173986272341719992766e-95, "29143173986272342", -94},
    {4.0705942647279847285745603e-63, "40705942647279847", -62},
    {1.9770335829636118359378015e-108, "1977033582963612", -107},
    {3.2413579752804324942850035e+204, "32413579752804325", 205},
    {1.6342573890118771325602972e+161, "16342573890118771", 162},
    {3.9241326038183843622070836e+149, "39241326038183844", 150},
    {1.6605635434655536276722432e+155, "16605635434655536", 156},
    {3.0961584992817897727945819e+04, "30961584992817898", 5},
    {7.8964021644544836195603421e+216, "7896402164454484", 217},
    {3.1213622265371832560369926e-186, "31213622265371833", -185},
    {9.6890001688951221475789600e+190, "9689000168895122", 191},
    {9.7524347363411682197942570e+68, "9752434736341168", 69},
    {6.6940044254764848906240000e+21, "6694004425476485", 22},
    {4.8847746036869748052825051e+96, "4884774603686975", 97},
    {4.0079617279632644876272185e-73, "40079617279632645", -72},
    {7.5958097736582473151122746e+235, "7595809773658247", 236},
    {1.9130079793237291986952700e+198, "19130079793237292", 199},
    {1.9088030466009582096650256e+243, "19088030466009582", 244},
    {4.3448664703405186027924732e+243, "43448664703405186", 244},
    {8.4858269583782504348990046e-211, "848582695837825", -210},
    {8.0439669738385673061558115e+148, "8043966973838567", 149},
    {6.9827123848681598161647344e+00, "698271238486816", 1},
    {1.7598659304961754091018317e+67, "17598659304961754", 68},
    {1.5342774216442163443541151e-142, "15342774216442163", -141},
    {2.4393830361829339545370039e-259, "2439383036182934", -258},
    {2.5021750064017708921176391e+101, "2502175006401771", 102},
    {2.6433344831291051229576840e-282, "2643334483129105", -281},
    {8.4404529860855709395440848e-72, "8440452986085571", -71},
    {8.5973100130237545283656094e-123, "8597310013023755", -122},
    {1.9821976616052073119403213e+27, "19821976616052073", 28},
    {7.2195276366395585900757993e-96, "7219527636639559", -95},
    {2.2568469535497757812500000e+13, "22568469535497758", 14},
    {6.2184196663321676878591462e-69, "6218419666332168", -68},
    {5.0600508774911319979284538e-240, "5060050877491132", -239},
    {2.1011838276567391364264020e-109, "21011838276567391", -108},
    {1.8601334932225663468310902e-98, "18601334932225663", -97},
    {7.7307229881251441011309533e-121, "7730722988125144", -120},
    {2.3729364608603477262595448e+91, "23729364608603477", 92},
    {2.5975853890711715348513419e-58, "25975853890711715", -57},
    {2.1574939265011084331955142e+119, "21574939265011084", 120},
    {8.5971742332260460814360787e+216, "8597174233226046", 217},
    {2.3643087001958053720262574e+155, "23643087001958054", 156},
    {5.7958082633934155766737796e-302, "5795808263393416", -301},
    {2.6091628089381271835652637e+238, "2609162808938127", 239},
    {3.9126307939459154257784038e-269, "39126307939459154", -268},
    {7.2610214153314962983131409e+07, "7261021415331496", 8},
    {8.1585098155894575157576319e+307, "8158509815589458", 308},
    {6.8791665438964443766494110e-270, "6879166543896444", -269},
    {2.1413162669755980563472517e-256, "2141316266975598", -255},
    {9.6011049518721554147979752e-34, "9601104951872155", -33},
    {3.4127338966300169701195651e+55, "3412733896630017", 56},
    {2.1767857701464620771538658e+106, "2176785770146462", 107},
    {1.1022509063774978567179856e-292, "11022509063774979", -291},
    {1.1933280694499510845164048e+234, "1193328069449951", 235},
    {2.9855621265616632181752595e+188, "2985562126561663", 189},
    {1.0639320987641310201878120e-185, "1063932098764131", -184},
    {6.0653388058758815189776636e-232, "60653388058758815", -231},
    {2.3407213879998438060283661e+06, "2340721387999844", 7},
    {1.0763225327481885413346569e-28, "10763225327481885", -27},
    {2.8794908555818034380660421e-145, "28794908555818034", -144},
    {1.5095404545600134045844619e-276, "15095404545600134", -275},
    {7.9271772940072926516563712e-01, "7927177294007293", 0},
    {7.9068366553876445004460056e+272, "7906836655387645", 273},
    {8.4327911940705562646659071e-204, "8432791194070556", -203},
    {1.0719702637176841549892845e+117, "10719702637176842", 118},
    {5.3797120424281620767048029e-98, "5379712042428162", -97},
    {1.1609592086172637341913378e-253, "11609592086172637", -252},
    {3.3522348721501594961868525e-293, "33522348721501595", -292},
    {3.9689955587780402324241929e-169, "396899555877804", -168},
    {1.8789357372835788951021875e-206, "1878935737283579", -205},
    {3.8565268119405156952649741e-198, "3856526811940516", -197},
    {8.5448450421794215998685901e-38, "8544845042179422", -37},
    {4.2181683149437195877800354e+71, "42181683149437196", 72},
    {4.8000483889137739920366514e-200, "4800048388913774", -199},
    {1.3814785250559246449666808e-241, "13814785250559246", -240},
    {3.5408921987042049987750412e-253, "3540892198704205", -252},
    {6.0165215281397950617418675e+204, "6016521528139795", 205},
    {1.7623201647419368142032656e-105, "1762320164741937", -104},
    {2.2740488017761879085141211e-228, "2274048801776188", -227},
    {4.8596454807053666975686934e-256, "48596454807053667", -255},
    {2.1194749130552160409550577e-283, "2119474913055216", -282},
    {2.8377662733670645547197098e-304, "28377662733670646", -303},
    {7.1529106122641965832617329e+27, "7152910612264197", 28},
    {7.4593175713049779551149730e-61, "7459317571304978", -60},
    {4.8520762457836479174032484e+280, "4852076245783648", 281},
    {7.4999233283405783987459540e-269, "7499923328340578", -268},
    {3.7528011929360427347209742e-112, "37528011929360427", -111},
    {3.8249800600752331465582941e-184, "3824980060075233", -183},
    {9.8239556649774773625510436e+185, "9823955664977477", 186},
    {2.1902510148508649312782984e-283, "2190251014850865", -282},
    {1.2249413129734002688000000e+19, "12249413129734003", 20},
    {5.3005981217475052819048091e+29, "5300598121747505", 30},
    {2.5091170750584170286458046e+276, "2509117075058417", 277},
    {2.5580357815299515827082414e+68, "25580357815299516", 69},
    {2.4246712722364781514611622e+169, "2424671272236478", 170},
    {8.7782110635637793605675274e+184, "877821106356378", 185},
    {6.7573723514928497889457268e+185, "675737235149285", 186},
    {1.7790604733775801537533566e+140, "17790604733775802", 141},
    {2.4891964158006332910204136e+94, "24891964158006333", 95},
    {2.6561732777949050903320312e+11, "2656173277794905", 12},
    {4.2057049717032288557232740e+99, "4205704971703229", 100},
    {1.0716036391481506163582381e+172, "10716036391481506", 173},
    {3.5537011642489087514130921e-252, "35537011642489088", -251},
    {9.9957294622624968206646213e-304, "9995729462262497", -303},
    {6.6964654324485192213413186e+57, "6696465432448519", 58},
    {2.1236562624284004911367026e+294, "21236562624284005", 295},
    {4.1693237150761548867990934e-72, "4169323715076155", -71},
    {1.5740799111809645742393819e-206, "15740799111809646", -205},
    {1.0926580690295235760795518e+107, "10926580690295236", 108},
    {4.0782093381399379811909006e-37, "4078209338139938", -36},
    {1.0553232298037507976409667e-275, "10553232298037508", -274},
    {9.2759898386793265228966420e+136, "9275989838679327", 137},
    {6.7436289731747377901903487e-127, "6743628973174738", -126},
    {1.3682872294180954451260430e+159, "13682872294180954", 160},
    {1.8371864066336182776933803e-151, "18371864066336183", -150},
    {1.1587818595394437829499189e+36, "11587818595394438", 37},
    {6.7249943041309384777194013e-242, "67249943041309385", -241},
    {4.1023874152225905210289268e+48, "41023874152225905", 49},
    {7.2493979381116223924681982e+119, "7249397938111622", 120},
    {4.4980064126906627657749151e+186, "4498006412690663", 187},
    {3.5815875776887888387206692e-248, "3581587577688789", -247},
    {4.1974194876805267789695032e-113, "4197419487680527", -112},
    {4.0437391649758749672042901e-25, "4043739164975875", -24},
    {3.4079937701966217216000000e+19, "34079937701966217", 20},
    {6.1640260348874386412645464e+295, "6164026034887439", 296},
    {1.1575875723612508750713050e+149, "11575875723612509", 150},
    {2.6392819200949486578439164e+169, "26392819200949487", 170},
    {1.6660446753959902185062736e+193, "16660446753959902", 194},
    {8.3303850362325905369759036e+158, "8330385036232591", 159},
    {1.8465085720999042500000000e+15, "18465085720999042", 16},
    {4.1208245830442856341063132e-106, "41208245830442856", -105},
    {7.7007722463950645600312696e+50, "7700772246395065", 51},
    {1.6939177674449349015162414e-67, "1693917767444935", -66},
    {1.5404228702253036069307522e+148, "15404228702253036", 149},
    {2.0876133627617327748897820e+201, "20876133627617328", 202},
    {1.8372611241799036503065831e-230, "18372611241799037", -229},
    {6.1864060120027212787408131e+102, "6186406012002721", 103},
    {5.1428110746083093750000000e+13, "5142811074608309", 14},
    {9.0704218349504511023941174e-173, "9070421834950451", -172},
    {4.5997620935738177736825834e+235, "4599762093573818", 236},
    {4.9467938076805315268891271e-45, "49467938076805315", -44},
    {3.4084169484637319617006161e-289, "3408416948463732", -288},
    {3.0061932074393614582477680e-26, "30061932074393615", -25},
    {1.7454312593616826192677691e+64, "17454312593616826", 65},
    {9.5262530174977110930568127e-200, "9526253017497711", -199},
    {1.5923657245204828579713942e+135, "1592365724520483", 136},
    {5.8489531381500733820704816e+134, "5848953138150073", 135},
    {4.3412047573196719914738319e+133, "4341204757319672", 134},
    {3.1813821190132286721938809e-221, "31813821190132287", -220},
    {2.8347166415950304094145732e+223, "28347166415950304", 224},
    {6.0922923394995288697282028e+86, "6092292339499529", 87},
    {7.4869149167640858255623471e-01, "7486914916764086", 0},
    {5.4452197875922038325640639e-196, "5445219787592204", -195},
    {1.0238223765883455573980375e+282, "10238223765883456", 283},
    {2.0562420455804369791846599e+123, "2056242045580437", 124},
    {3.0663304849994813074980254e-170, "30663304849994813", -169},
    {3.7175798069910279284024659e+196, "3717579806991028", 197},
    {1.4198081029104559266737355e-64, "1419808102910456", -63},
    {2.0506311801691510089415367e+143, "2050631180169151", 144},
    {8.5916824534430723041536079e+105, "8591682453443072", 106},
    {5.0152943602281373544112992e-166, "50152943602281374", -165},
    {1.0444861687483179183998377e-32, "10444861687483179", -31},
    {2.0401485339538520259618575e-178, "2040148533953852", -177},
    {3.7284693574700984450595684e-75, "37284693574700984", -74},
    {5.7072956279734722521320361e+166, "5707295627973472", 167},
    {3.8930309721403688165538279e-119, "3893030972140369", -118},
    {1.0946015652611614846153782e+182, "10946015652611615", 183},
    {7.9815102897241957093680248e+139, "7981510289724196", 140},
    {2.1752202285540670455335654e+121, "2175220228554067", 122},
    {1.1878816102212475432810693e+219, "11878816102212475", 220},
    {1.6213832093427790773774747e+207, "1621383209342779", 208},
    {7.6427234119975750975024952e-95, "7642723411997575", -94},
    {3.9775951807680806100916177e-73, "39775951807680806", -72},
    {1.5341077549519647507354802e-71, "15341077549519648", -70},
    {4.2505368097445448139973222e-148, "4250536809744545", -147},
    {1.9762253460040749480851766e-43, "1976225346004075", -42},
    {7.1761999807620537450061199e-208, "7176199980762054", -207},
    {7.5377578597218635076555025e-270, "75377578597218635", -269},
    {2.4859411807508402453188898e+94, "24859411807508402", 95},
    {6.6412458477631975910562159e-226, "66412458477631976", -225},
    {4.5384827821752231270357660e+96, "4538482782175223", 97},
    {4.7801428004594041847556758e-288, "4780142800459404", -287},
    {3.2219008403454941251226943e-169, "3221900840345494", -168},
    {1.7927196410469802209646923e-65, "17927196410469802", -64},
    {9.7855647061230419151921223e-32, "9785564706123042", -31},
    {8.8791047275295308838913066e+253, "8879104727529531", 254},
    {2.7183420051695075517919712e+47, "27183420051695076", 48},
    {1.7538077955239995343813611e+101, "17538077955239995", 102},
    {4.3555725765316192086878570e-257, "4355572576531619", -256},
    {9.6890490130565053528177624e+241, "9689049013056505", 242},
    {3.8374542594908743761546025e-107, "38374542594908744", -106},
    {9.0551902241548470101981850e-20, "9055190224154847", -19},
    {3.6270508380161010116686085e+155, "3627050838016101", 156},
    {3.7370084983857244788195571e-79, "37370084983857245", -78},
    {2.7124858813091115373064606e-289, "27124858813091115", -288},
    {1.9213264723777046495763097e-234, "19213264723777046", -233},
    {9.3555370292703491927830712e+270, "935553702927035", 271},
    {4.6812702309978159318840467e+241, "4681270230997816", 242},
    {1.6657381893930060824368235e-191, "1665738189393006", -190},
    {8.9191740133798045885488275e-194, "8919174013379805", -193},
    {7.7497860982022511914210132e+160, "7749786098202251", 161},
    {6.1986097415252770694388233e-164, "6198609741525277", -163},
    {1.4120195405322035181603948e-242, "14120195405322035", -241},
    {1.8998633134166668675393442e+154, "1899863313416667", 155},
    {5.6653965672283666517159118e-147, "5665396567228367", -146},
    {1.3193671211419711133811697e-152, "13193671211419711", -151},
    {9.0494628830615948116727290e-246, "9049462883061595", -245},
    {1.9065777491925492080036226e-298, "19065777491925492", -297},
    {1.3527819293430181227686519e-297, "13527819293430181", -296},
    {3.8899763240471695999166642e-244, "38899763240471696", -243},
    {1.3843016593996820800000000e+17, "13843016593996821", 18},
    {1.0950436074368080453765328e+76, "1095043607436808", 77},
    {2.0172688725540882195809698e-67, "20172688725540882", -66},
    {4.4798450175086320053966699e+230, "4479845017508632", 231},
    {1.1055066599610662189465801e+83, "11055066599610662", 84},
    {7.5358786184670752270455719e-118, "7535878618467075", -117},
    {2.0740481183158901760000000e+18, "20740481183158902", 19},
    {2.6504192727216727376371234e-88, "2650419272721673", -87},
    {8.5070474804026263403756838e+301, "8507047480402626", 302},
    {1.5545586344243473614495874e+48, "15545586344243474", 49},
    {4.6125054400109417581746410e-23, "4612505440010942", -22},
    {2.8888693917003742776140989e+205, "28888693917003743", 206},
    {3.7434016079395353610638266e-132, "37434016079395354", -131},
    {3.0422084760014731821954616e-15, "3042208476001473", -14},
    {1.1611923359557861155433837e-57, "11611923359557861", -56},
    {1.1622319635309663012420998e+259, "11622319635309663", 260},
    {4.8331986179444109805428689e-34, "4833198617944411", -33},
    {1.2654835646371694084051438e+181, "12654835646371694", 182},
    {4.2474254797065550494144723e-07, "4247425479706555", -6},
    {5.5737639093904413828661189e+199, "5573763909390441", 200},
    {2.0338379554783977549958970e-209, "20338379554783978", -208},
    {5.9069497790851699937997332e+201, "590694977908517", 202},
    {1.6559148683151119893881265e+135, "1655914868315112", 136},
    {3.1959677250007656097601283e+111, "31959677250007656", 112},
    {6.5203127401290444160383058e+179, "6520312740129044", 180},
    {3.7082302128051219809846237e+143, "3708230212805122", 144},
    {4.0694096507368965460758535e+208, "40694096507368965", 209},
    {1.1660168539701642701262904e-243, "11660168539701643", -242},
    {6.2096311644677494898613135e-140, "62096311644677495", -139},
    {8.7320798144191589009263036e+133, "8732079814419159", 134},
    {1.7775905682795438049885672e-275, "17775905682795438", -274},
    {6.2940335621852487069449820e+207, "6294033562185249", 208},
    {1.3469361566257023160637269e-250, "13469361566257023", -249},
    {1.4782846371196657813047157e+240, "14782846371196658", 241},
    {3.5655266532020646076757614e+264, "35655266532020646", 265},
    {3.2200461645241506356660664e-172, "32200461645241506", -171},
    {6.1471130473075678011570097e+144, "6147113047307568", 145},
    {1.8757148711662478182166231e+125, "1875714871166248", 126},
    {9.1457729467131906250000000e+13, "914577294671319", 14},
    {1.8495805747098881282996652e+114, "1849580574709888", 115},
    {1.4552973583472835075707777e-103, "14552973583472835", -102},
    {7.9298306693465120052205255e+145, "7929830669346512", 146},
    {2.9975589230685736765735783e+03, "29975589230685737", 4},
    {4.3999336992606946262413733e+87, "4399933699260695", 88},
    {4.0060620476211616370074297e+120, "40060620476211616", 121},
    {1.2230088879619698743602165e-263, "12230088879619699", -262},
    {2.0934262704955171306792957e-111, "2093426270495517", -110},
    {1.3531218480378367537726989e+140, "13531218480378368", 141},
    {3.1351470771842333586757756e+67, "31351470771842334", 68},
    {2.9513269880434572505301234e+181, "29513269880434573", 182},
    {6.7550655290325787079616760e+237, "6755065529032579", 238},
    {1.2291216795118697105557678e+259, "12291216795118697", 260},
    {1.8314722320787043101294431e-118, "18314722320787043", -117},
    {5.8886215922023528306076380e-149, "5888621592202353", -148},
    {3.8459104069600718021990065e-202, "3845910406960072", -201},
    {7.0963949885763200980970301e+147, "709639498857632", 148},
    {2.9341424353633112025039493e-143, "2934142435363311", -142},
    {5.9768442055552170000000000e+15, "5976844205555217", 16},
    {4.8126400903090978079245832e+140, "4812640090309098", 141},
    {2.3276933787926472396943353e+167, "23276933787926472", 168},
    {1.6191266358259729805618616e-62, "1619126635825973", -61},
    {2.1506931864958941776846198e+259, "21506931864958942", 260},
    {5.8590257453630635848391024e-286, "5859025745363064", -285},
    {1.6348175438651996872296171e+205, "16348175438651997", 206},
    {8.8419832974678516949580877e+160, "8841983297467852", 161},
    {2.4822775228607471309424872e+279, "2482277522860747", 280},
    {1.1901426361995717282528335e-35, "11901426361995717", -34},
    {5.9598319076657443758072454e-142, "59598319076657444", -141},
    {6.5979121454914630419049363e-146, "6597912145491463", -145},
    {4.3087563613893754859157072e+148, "43087563613893755", 149},
    {2.0840161808937631718451986e-281, "20840161808937632", -280},
    {6.5285254722642376939066935e+148, "6528525472264238", 149},
    {1.1618767328375296907874624e+125, "11618767328375297", 126},
    {8.6418502935311142525162910e-245, "8641850293531114", -244},
    {1.2928819807771334559787516e-233, "12928819807771335", -232},
    {2.9867373136836981430481999e-132, "2986737313683698", -131},
    {1.3207004719313234148422266e+171, "13207004719313234", 172},
    {2.8645559837932971431500874e+230, "2864555983793297", 231},
    {8.4654570090259398929521226e-226, "846545700902594", -225},
    {1.2619359706600222911134267e+157, "12619359706600223", 158},
    {7.0370532963592891581417735e+139, "7037053296359289", 140},
    {2.9884649847055260757083987e+84, "2988464984705526", 85},
    {2.7388713769805275840886780e+271, "27388713769805276", 272},
    {2.5742922951020032486353746e-231, "25742922951020032", -230},
    {1.6997012103823357832202629e-264, "16997012103823358", -263},
    {3.5288607844920762666693406e-37, "35288607844920763", -36},
    {6.3181787763578382266810629e-260, "6318178776357838", -259},
    {5.5671813403263639087805770e+50, "5567181340326364", 51},
    {1.0224414652173739881418907e-296, "1022441465217374", -295},
    {1.1629737688912100529018380e+146, "116297376889121", 147},
    {1.7411155867623020973063584e+249, "1741115586762302", 250},
    {4.4703141173787399963299912e-207, "447031411737874", -206},
    {9.6679077088311981483131582e-290, "9667907708831198", -289},
    {6.4203081486689709528157354e-129, "6420308148668971", -128},
    {4.4250419535408100698093408e-201, "442504195354081", -200},
    {1.2805091025287814471971873e-247, "12805091025287814", -246},
    {2.7437459752405062400000000e+17, "27437459752405062", 18},
    {4.4730557586686839449324085e+266, "4473055758668684", 267},
    {3.2623451654887336635082842e+45, "32623451654887337", 46},
    {2.6720693413084806296566183e-92, "26720693413084806", -91},
    {5.8464860061501640986550244e+101, "5846486006150164", 102},
    {2.8555909344726493450381988e+299, "28555909344726493", 300},
    {3.0896557257012838572791275e+160, "3089655725701284", 161},
    {2.0632363441617341356441600e+24, "20632363441617341", 25},
    {3.9036672106003135395457394e+273, "39036672106003135", 274},
    {1.0833905343442918275244302e+107, "10833905343442918", 108},
    {2.7187989576410781180556119e+117, "2718798957641078", 118},
    {2.1128478524734187209811567e+122, "21128478524734187", 123},
    {4.7040485489703068057671882e-41, "4704048548970307", -40},
    {5.5380719258618080381369409e+198, "5538071925861808", 199},
    {1.1276125729373616760991697e-210, "11276125729373617", -209},
    {1.1088893572912189516248944e-211, "1108889357291219", -210},
    {3.1614463514532099243615374e+221, "316144635145321", 222},
    {5.0073557425667504882812500e+11, "50073557425667505", 12},
    {7.7790076857268918875241932e-213, "7779007685726892", -212},
    {4.1589700161192951808000000e+19, "4158970016119295", 20},
    {4.3152408604273541563858808e+280, "4315240860427354", 281},
    {2.6294059825724932029101345e-32, "2629405982572493", -31},
    {2.3443237611801654309366241e-159, "23443237611801654", -158},
    {1.4204856984808274507889463e+99, "14204856984808275", 100},
    {1.5721507382485243198825250e-60, "15721507382485243", -59},
    {2.9673276754506544076238805e+94, "29673276754506544", 95},
    {2.6124646829729426153943518e-303, "26124646829729426", -302},
    {7.8325059367519164446893535e-105, "7832505936751916", -104},
    {8.7926624150868187204743644e+286, "8792662415086819", 287},
    {4.8203355131346236995579529e-297, "4820335513134624", -296},
    {3.3456339369578296988889208e+264, "33456339369578297", 265},
    {3.6877474708137935478825527e+205, "36877474708137935", 206},
    {4.6282307054390208054135648e-45, "4628230705439021", -44},
    {1.2684825909276171437186435e+54, "12684825909276171", 55},
    {2.0165319224992386052676642e-276, "20165319224992386", -275},
    {2.1078334479309895032929609e-132, "21078334479309895", -131},
    {1.0369176108595360414012358e+206, "1036917610859536", 207},
    {4.2144410479053015384701450e+30, "42144410479053015", 31},
    {3.4540263820481776761527986e+210, "34540263820481777", 211},
    {2.4558975309811897735908723e+45, "24558975309811898", 46},
    {2.1606874143396483533090034e-283, "21606874143396484", -282},
    {2.1715711813978300713934799e-120, "217157118139783", -119},
    {3.2970411296265423118740563e+128, "32970411296265423", 129},
    {9.2332311711344184238655043e-35, "9233231171134418", -34},
    {5.2985237018966093312640904e-288, "5298523701896609", -287},
    {5.0371731266839194126338810e+180, "5037173126683919", 181},
    {3.4223044697434029035229529e-126, "3422304469743403", -125},
    {4.2643958676970004458409117e-16, "42643958676970004", -15},
    {1.6399864903910602090081995e-17, "16399864903910602", -16},
    {9.5046586016266940091403882e+154, "9504658601626694", 155},
    {1.3993869328019171222008240e-91, "1399386932801917", -90},
    {3.7426297126585888658888764e-255, "3742629712658589", -254},
    {2.1485755957153032520161745e-94, "21485755957153033", -93},
    {3.6667132742695430457230441e+286, "3666713274269543", 287},
    {6.4665055429492823436069320e+229, "6466505542949282", 230},
    {5.2334356875105831784392890e+87, "5233435687510583", 88},
    {1.7670421449442792689126696e-174, "17670421449442793", -173},
    {2.8263849529783399844455537e+275, "282638495297834", 276},
    {1.2274099999233751268118920e+154, "12274099999233751", 155},
    {6.9838076851970424365308513e+295, "6983807685197042", 296},
    {4.1466493345068195298321011e+146, "41466493345068195", 147},
    {3.8276569297911126298667303e-267, "38276569297911126", -266},
    {7.8773239786425110168349701e-156, "7877323978642511", -155},
    {1.4745419609202451516237481e-55, "14745419609202452", -54},
    {1.2954572758441080554815236e-51, "1295457275844108", -50},
    {3.1629794004741603685062676e+234, "31629794004741604", 235},
    {1.2166845639215858552390783e-303, "12166845639215859", -302},
    {1.3205997137061594841062348e+263, "13205997137061595", 264},
    {3.0288841240217726009711345e+202, "30288841240217726", 203},
    {1.2071631221967062233327646e+156, "12071631221967062", 157},
    {5.3171724226870825708214326e-242, "53171724226870826", -241},
    {2.5505874129549657267385001e+182, "25505874129549657", 183},
    {4.6464601497077161901679072e-125, "4646460149707716", -124},
    {4.9485708354448469549983700e+51, "4948570835444847", 52},
    {1.6553549184280491246757763e+213, "1655354918428049", 214},
    {1.6852077789600051598589417e-298, "16852077789600052", -297},
    {2.1414432458560227126031410e-31, "21414432458560227", -30},
    {3.4765188274149350691582545e-71, "3476518827414935", -70},
    {8.8268464806831890610437851e+215, "8826846480683189", 216},
    {7.7220264497590321151117964e+272, "7722026449759032", 273},
    {7.5386556049064290509439191e-282, "7538655604906429", -281},
    {3.6630807969593057976195593e-89, "3663080796959306", -88},
    {1.1973679805810624595083067e-287, "11973679805810625", -286},
    {7.2461362616694115284727987e-146, "72461362616694115", -145},
    {2.6059633665993903055480209e-35, "26059633665993903", -34},
    {9.4090899126245749357622117e+03, "9409089912624575", 4},
    {1.0673195189381798188208684e-159, "10673195189381798", -158},
    {1.5314711158791318444259567e+29, "15314711158791318", 30},
    {9.5300734728594970573608387e+207, "9530073472859497", 208},
    {1.4697878888599260626685017e-254, "1469787888859926", -253},
    {2.8495519002299687493191882e+34, "28495519002299687", 35},
    {6.9426619516363547885235279e+285, "6942661951636355", 286},
    {2.5511673163395699858665466e+08, "255116731633957", 9},
    {3.8493873885781778933438855e+304, "3849387388578178", 305},
    {6.3911886127024156985371961e-34, "6391188612702416", -33},
    {6.1574935590222482052490576e-85, "6157493559022248", -84},
    {2.0738666625897480717028781e+79, "2073866662589748", 80},
    {9.7923813773463104701474886e-129, "979238137734631", -128},
    {1.1683449424166188628577562e+34, "11683449424166189", 35},
    {4.9697579430952900210122889e-239, "496975794309529", -238},
    {1.9175199364436469445282717e-186, "1917519936443647", -185},
    {6.7077966297848247347244392e+101, "6707796629784825", 102},
    {2.0756005202635477707047367e-137, "20756005202635478", -136},
    {1.1057496229480814248902901e-104, "11057496229480814", -103},
    {1.1566829529834443004933307e-27, "11566829529834443", -26},
    {1.4789195711298031198779052e+206, "14789195711298031", 207},
    {2.0164463824324089882677222e-194, "2016446382432409", -193},
    {2.7750865238833242633310776e-261, "27750865238833243", -260},
    {2.4642038661206608199737384e+109, "2464203866120661", 110},
    {1.9436459421026198585581509e+64, "194364594210262", 65},
    {4.1848590257168904948014174e-110, "41848590257168905", -109},
    {8.8710561828936203177608664e+262, "887105618289362", 263},
    {2.4886078424497569418254682e+200, "2488607842449757", 201},
    {9.8290923290467192065630881e-201, "9829092329046719", -200},
    {1.2795936801425637591080154e+277, "12795936801425638", 278},
    {1.2723575638477608349891962e+67, "12723575638477608", 68},
    {1.0318972492579487480989485e+59, "10318972492579487", 60},
    {1.6499522322269909036723643e-145, "1649952232226991", -144},
    {1.0478146382999677956104279e+08, "10478146382999678", 9},
    {9.8837271806430819406654609e-82, "9883727180643082", -81},
    {3.2023446517454402450826865e+153, "32023446517454402", 154},
    {6.1735022538889155839569867e+04, "61735022538889156", 5},
    {2.8230664047242576272029593e-22, "28230664047242576", -21},
    {2.2180522520327052769762716e+141, "22180522520327053", 142},
    {2.1680164421627851814641366e+260, "21680164421627852", 261},
    {6.2948635872780086998957465e-211, "6294863587278009", -210},
    {1.4951828234911853255371162e+215, "14951828234911853", 216},
    {1.9096534081592966753535134e+84, "19096534081592967", 85},
    {1.7619132822973669687634567e+134, "1761913282297367", 135},
    {5.9140915446008530517646604e+266, "5914091544600853", 267},
    {1.1903263529600512764877387e-32, "11903263529600513", -31},
    {3.3692167238264928035041454e+302, "33692167238264928", 303},
    {5.4037963413918325537950539e+140, "54037963413918326", 141},
    {4.7393977895063909296297216e+109, "4739397789506391", 110},
    {8.7721917149908983859553129e-262, "8772191714990898", -261},
    {1.2125454246185494949158778e-113, "12125454246185495", -112},
    {1.2017295952403373514716153e-147, "12017295952403374", -146},
    {1.5522326728804782160974747e+60, "15522326728804782", 61},
    {1.7709480796050923573867481e+276, "17709480796050924", 277},
    {1.1416561471542909955442163e-176, "1141656147154291", -175},
    {3.7227682112281138764266215e+71, "3722768211228114", 72},
    {4.7942304007348110261964302e-121, "4794230400734811", -120},
    {8.1493196492974475026130676e+07, "8149319649297448", 8},
    {1.3387769975646929005689360e+154, "13387769975646929", 155},
    {1.2082067865472973644275222e+64, "12082067865472974", 65},
    {1.0870005589406355308338604e+136, "10870005589406355", 137},
    {2.5389866494390637863139244e+292, "2538986649439064", 293},
    {1.3797713426846180952754487e-188, "13797713426846181", -187},
    {5.2388076177601968183048395e-13, "5238807617760197", -12},
    {8.8323264448272993681336526e+287, "88323264448273", 288},
    {2.1350368851607084972509733e-239, "21350368851607085", -238},
    {2.2346330282068985391677790e-56, "22346330282068985", -55},
    {6.4121474770375456404107687e+225, "6412147477037546", 226},
    {4.4100276132292530469586568e+106, "4410027613229253", 107},
    {3.9992472988051824931954249e-143, "39992472988051825", -142},
    {3.1972338974794102579474995e-13, "31972338974794103", -12},
    {1.7883758699085566624108682e-55, "17883758699085567", -54},
    {1.1692431887699447026219637e+290, "11692431887699447", 291},
    {7.3491907881022021135529549e+239, "7349190788102202", 240},
    {2.7023962171164071216217332e+132, "2702396217116407", 133},
    {1.8837968629734849990203802e+27, "1883796862973485", 28},
    {3.6993653380473476213558450e+214, "36993653380473476", 215},
    {4.9795018060824675760404039e-24, "49795018060824676", -23},
    {1.3534007210212891085239583e+244, "13534007210212891", 245},
    {3.9441154538405014240674992e+140, "39441154538405014", 141},
    {2.6173420355300357897126088e-273, "26173420355300358", -272},
    {2.1374652756593965406862281e-151, "21374652756593965", -150},
    {4.2236234743897596076318191e-97, "42236234743897596", -96},
    {2.3757240760265679336425849e+32, "2375724076026568", 33},
    {1.9865132824820708155688490e-151, "19865132824820708", -150},
    {8.3002792895551212767863756e-278, "8300279289555121", -277},
    {1.0061138609094569733920571e-88, "1006113860909457", -87},
    {1.2320204444721736383234702e+144, "12320204444721736", 145},
    {2.3325816670479004455367955e+169, "23325816670479004", 170},
    {1.5999072229458768377157724e-128, "15999072229458768", -127},
    {7.6110518102122431227427756e-141, "7611051810212243", -140},
    {1.9379338899656362791587325e+276, "19379338899656363", 277},
    {1.4059043157685778582083362e+150, "14059043157685779", 151},
    {2.2847912616173852840965537e-12, "22847912616173853", -11},
    {1.4591567798446475675079737e-111, "14591567798446476", -110},
    {2.0825763957410982053165931e+186, "20825763957410982", 187},
    {4.4649427315384999391508308e-160, "44649427315385", -159},
    {6.9965499869220312897895339e+255, "6996549986922031", 256},
    {1.9850603450265389383468489e+268, "1985060345026539", 269},
    {2.0502502514331759859029853e+297, "2050250251433176", 298},
    {1.2538167674007569750417044e+52, "1253816767400757", 53},
    {5.0902463341917306880000000e+20, "5090246334191731", 21},
    {1.9593186987459699535519085e+67, "195931869874597", 68},
    {7.3916513852846249276786476e+244, "7391651385284625", 245},
    {4.5367167639423671765948473e-250, "4536716763942367", -249},
    {8.7905828827254204954782282e-150, "879058288272542", -149},
    {4.4153437345947328812502243e+110, "4415343734594733", 111},
    {5.5721438092468714339682991e+255, "55721438092468714", 256},
    {2.4875995139637847561978792e+85, "24875995139637848", 86},
    {1.6270135232887985175530984e+292, "16270135232887985", 293},
    {3.1562634971918080780000733e-137, "3156263497191808", -136},
    {9.9219166642554200058958622e+181, "992191666425542", 182},
    {2.8051743194261712912793150e-04, "28051743194261713", -3},
    {3.2865378759810171454162221e+82, "3286537875981017", 83},
    {3.5989343931439031868527892e-305, "3598934393143903", -304},
    {1.5848662485216139308098577e+243, "1584866248521614", 244},
    {7.2197207133787577303874208e+300, "7219720713378758", 301},
    {6.9861894407410442779357454e-173, "6986189440741044", -172},
    {4.4414443862460421040229252e-19, "4441444386246042", -18},
    {5.6406965022637460502790749e+96, "5640696502263746", 97},
    {2.4131083189422525493652872e-269, "24131083189422525", -268},
    {1.5652427836186556144904998e-227, "15652427836186556", -226},
    {8.0103648806145788148556485e-48, "8010364880614579", -47},
    {5.0756680519832536901958520e+02, "50756680519832537", 3},
    {7.9975260348353297385443466e+295, "799752603483533", 296},
    {3.0775235237938645024654412e-52, "30775235237938645", -51},
    {2.8903833693237393495099152e+188, "28903833693237393", 189},
    {2.4120192419718745544509629e+282, "24120192419718746", 283},
    {1.5312354854041000264193887e+133, "15312354854041", 134},
    {7.6465793141556865484857120e+88, "7646579314155687", 89},
    {1.2553104574536569307579337e+228, "1255310457453657", 229},
    {3.8852025936643645005528052e+187, "38852025936643645", 188},
    {3.4237274181195566152148711e-40, "34237274181195566", -39},
    {9.9405406481619023790847185e-157, "9940540648161902", -156},
    {6.0640299906552659408060416e+25, "6064029990655266", 26},
    {8.4004048369684577688988110e-24, "8400404836968458", -23},
    {1.2145424966250676228197203e-40, "12145424966250676", -39},
    {1.2133518472414546373059236e-272, "12133518472414546", -271},
    {3.0560101558996838832560941e+110, "3056010155899684", 111},
    {7.2626204199649331905607121e-69, "7262620419964933", -68},
    {3.4727910564258260825295551e-279, "3472791056425826", -278},
    {9.4586504291699533778848018e-89, "9458650429169953", -88},
    {1.3003956286957877874374390e+08, "13003956286957878", 9},
    {1.6059994407227315200000000e+17, "16059994407227315", 18},
    {1.3676516992252697855843810e+205, "13676516992252698", 206},
    {9.3757019205364780724374403e+145, "9375701920536478", 146},
    {4.7186884019803953896294020e-296, "47186884019803954", -295},
    {5.7678326752917683257485489e+76, "57678326752917683", 77},
    {3.4366570337924053383374017e+192, "34366570337924053", 193},
    {1.3472602780170306342233825e-303, "13472602780170306", -302},
    {4.8760292132120539422969944e+64, "4876029213212054", 65},
    {5.2418371503697259960017348e-255, "5241837150369726", -254},
    {5.4100465925927980600567924e-78, "5410046592592798", -77},
    {1.8954121327580919223005397e-162, "1895412132758092", -161},
    {6.5755907547744057126470008e-113, "6575590754774406", -112},
    {3.6823749082468316280683178e-140, "36823749082468316", -139},
    {1.7607579250221227260316241e-09, "17607579250221227", -8},
    {4.1274298235132760531375946e+182, "4127429823513276", 183},
    {4.4374344880999235602196906e-282, "44374344880999236", -281},
    {1.7356461989810067313675611e+206, "17356461989810067", 207},
    {7.9830393048063253221028284e+295, "7983039304806325", 296},
    {2.2841826729264472669647883e-126, "22841826729264473", -125},
    {1.2626371408440547975732492e-271, "12626371408440548", -270},
    {1.9191021624176837151767730e-277, "19191021624176837", -276},
    {6.9545329900043736528798512e-50, "6954532990004374", -49},
    {1.2840264812784151623528629e+119, "12840264812784152", 120},
    {1.1886228374216013943155426e-34, "11886228374216014", -33},
    {3.0487069958006378364845517e+205, "3048706995800638", 206},
    {2.3324263489822235209218109e-286, "23324263489822235", -285},
    {1.4647735901025953138477277e+119, "14647735901025953", 120},
    {2.4100385852005125000710808e-05, "24100385852005125", -4},
    {8.8627906563513417139560380e-06, "8862790656351342", -5},
    {2.6291106391653280815551149e+99, "2629110639165328", 100},
    {5.5310198389042274745693641e-145, "55310198389042275", -144},
    {1.0582607575841355506277389e+92, "10582607575841356", 93},
    {8.3737297019832954321778789e+224, "8373729701983295", 225},
    {4.5207778126724004611432506e+296, "45207778126724005", 297},
    {1.9731025104787473747601247e-265, "19731025104787474", -264},
    {3.4646670714510332915458957e-03, "34646670714510333", -2},
    {8.2556941593282467759132323e-232, "8255694159328247", -231},
    {1.6616314503406473682636914e+90, "16616314503406474", 91},
    {1.4469219707329526466728078e+221, "14469219707329526", 222},
    {3.0957777391942014385060446e+295, "30957777391942014", 296},
    {4.2822620809071324477679491e-249, "42822620809071324", -248},
    {4.1915183858142123918401854e+146, "4191518385814212", 147},
    {1.0422540159205801022612371e-260, "10422540159205801", -259},
    {6.2125736368199430681409788e-60, "6212573636819943", -59},
    {8.2394221259620575834666359e-64, "8239422125962058", -63},
    {8.3141681658389538129636074e+118, "8314168165838954", 119},
    {5.8233262003707995329935608e+33, "58233262003708", 34},
    {6.0871400927652666290567374e+285, "6087140092765267", 286},
    {5.4790539214482441354777114e+275, "5479053921448244", 276},
    {8.0629635864733617776114868e-160, "8062963586473362", -159},
    {3.1762313518778505756961284e-252, "31762313518778506", -251},
    {1.0313507381610094707920548e+130, "10313507381610095", 131},
    {1.5218276708661986212013836e+226, "15218276708661986", 227},
    {3.7114517459001293346855441e+143, "37114517459001293", 144},
    {6.2412949902136065675825831e+218, "62412949902136066", 219},
    {4.0452441117289097152848230e-88, "40452441117289097", -87},
    {2.1630878751842367314086626e+163, "21630878751842367", 164},
    {2.2474657597886831236265785e+131, "2247465759788683", 132},
    {7.7978727308640309400941586e-59, "7797872730864031", -58},
    {3.8921110114289464214331042e-139, "38921110114289464", -138},
    {1.1127520933133368440796549e-88, "11127520933133368", -87},
    {6.5451351307109877178627429e+69, "6545135130710988", 70},
    {8.5945701236523544826968752e+59, "8594570123652354", 60},
    {1.4642971784802938842773438e+11, "1464297178480294", 12},
    {3.9803011333626106190060376e+117, "39803011333626106", 118},
    {1.3317992795994283490225624e+126, "13317992795994283", 127},
    {3.7757005754155249654362808e+203, "3775700575415525", 204},
    {8.7150040059040341859077830e-22, "8715004005904034", -21},
    {2.9614818124391644599664357e+93, "29614818124391645", 94},
    {1.5456778942911860667108068e-166, "1545677894291186", -165},
    {1.8924598938133914822111129e-290, "18924598938133915", -289},
    {1.9592335529285115910957876e-71, "19592335529285116", -70},
    {5.3598655214879022798934697e-33, "5359865521487902", -32},
    {1.4734785954581137501261979e+151, "14734785954581138", 152},
    {1.0365872310450121321227823e+58, "10365872310450121", 59},
    {7.9732157563950387600614879e+266, "7973215756395039", 267},
    {7.4175154715543487741978588e+272, "7417515471554349", 273},
    {1.4208968834220720793557692e+128, "1420896883422072", 129},
    {4.9639465806599780014458069e-200, "4963946580659978", -199},
    {1.2168451083168467443467654e+35, "12168451083168467", 36},
    {9.1130082803185995690803200e+23, "91130082803186", 24},
    {1.5040406147113011028829928e-66, "1504040614711301", -65},
    {9.9554834995810308757502219e+269, "9955483499581031", 270},
    {3.3461653138123700123377346e+127, "334616531381237", 128},
    {5.6282943773351227055057553e-201, "5628294377335123", -200},
    {1.8309006901569584926861157e+145, "18309006901569585", 146},
    {3.6600565073961927862028372e-249, "3660056507396193", -248},
    {1.3177264861500055292273802e-205, "13177264861500055", -204},
    {1.5829202011918450582084244e-09, "1582920201191845", -8},
    {4.7908812618489694787193182e-191, "47908812618489695", -190},
    {8.5924345958915264026199709e+150, "8592434595891526", 151},
    {5.2346688818917202381103342e-213, "523466888189172", -212},
    {2.2641772398237702558774505e+106, "22641772398237703", 107},
    {3.2246699449409906879978991e-157, "3224669944940991", -156},
    {9.2112007594466713178110884e-265, "9211200759446671", -264},
    {8.9845114384077331365888000e+22, "8984511438407733", 23},
    {3.4172611579481083158365484e+131, "34172611579481083", 132},
    {6.4053679546084155650921211e+157, "6405367954608416", 158},
    {9.1090495408537299484352040e+177, "910904954085373", 178},
    {1.6085466561132362146488979e-79, "16085466561132362", -78},
    {3.1376865957093312628055468e+85, "3137686595709331", 86},
    {1.0369279809419754980990304e+99, "10369279809419755", 100},
    {8.8562871062679083799167254e+191, "8856287106267908", 192},
    {2.3631880051210071937905649e+276, "2363188005121007", 277},
    {5.7304521000536192474600281e-141, "5730452100053619", -140},
    {1.0074853234417056837942975e+61, "10074853234417057", 62},
    {5.2361532391931981753624257e-106, "5236153239193198", -105},
    {1.5656947688180691150990921e+36, "1565694768818069", 37},
    {3.6235070552057681660651323e+105, "3623507055205768", 106},
    {3.5263253333381014844841405e-144, "35263253333381015", -143},
    {5.8316509536420453074748164e+91, "5831650953642045", 92},
    {1.7110195972919819381721452e+251, "1711019597291982", 252},
    {1.2643656815254947706965917e-158, "12643656815254948", -157},
    {4.3576434004833426985703205e+232, "43576434004833427", 233},
    {2.7995427498402949942224531e+100, "2799542749840295", 101},
    {4.1875282915816619684548030e+228, "4187528291581662", 229},
    {1.8698861081158729130117147e-170, "1869886108115873", -169},
    {4.0573336655346827540014351e-286, "40573336655346828", -285},
    {2.5339850673088896269494772e+103, "25339850673088896", 104},
    {4.4623551362166087517467850e-275, "4462355136216609", -274},
    {9.5343893046411385862507314e+173, "9534389304641139", 174},
    {7.7849796470501772014435449e-149, "7784979647050177", -148},
    {3.2050798350045324573324996e-238, "32050798350045325", -237},
    {1.6645502541636321779506502e-259, "16645502541636322", -258},
    {7.0389021865754294097691589e-283, "7038902186575429", -282},
    {1.0145636395050969277055162e-127, "1014563639505097", -126},
    {4.4000863011752092734332344e-55, "4400086301175209", -54},
    {1.5294395580995136000000000e+18, "15294395580995136", 19},
    {2.4710587755785483711663832e-197, "24710587755785484", -196},
    {3.7767285311765996653231230e+98, "37767285311765997", 99},
    {1.7581381710648567663714295e-63, "17581381710648568", -62},
    {2.0781308489570839169325690e-198, "2078130848957084", -197},
    {3.7570281595825613224985940e+243, "3757028159582561", 244},
    {5.1732000496670967457996000e+100, "5173200049667097", 101},
    {1.3072188340133809650058958e+155, "1307218834013381", 156},
    {1.6742265258034916161845089e-241, "16742265258034916", -240},
    {1.5403437107825827614975441e+82, "15403437107825828", 83},
    {3.9923524471950903267696961e+88, "399235244719509", 89},
    {5.5116686869602291323232744e-64, "5511668686960229", -63},
    {6.1027852826177380071640590e-279, "6102785282617738", -278},
    {4.8036646429934131652603788e-199, "4803664642993413", -198},
    {3.8640436495318767285672167e+182, "3864043649531877", 183},
    {4.1048002167195142146284868e+163, "4104800216719514", 164},
    {5.2617441244204131214327189e+48, "5261744124420413", 49},
    {6.6155018811337935379571887e-203, "6615501881133794", -202},
    {3.5652421915030330269417780e+133, "3565242191503033", 134},
    {2.2666944496090157198837292e+179, "22666944496090157", 180},
    {8.0806796099366163833867110e+152, "8080679609936616", 153},
    {2.2949521426780434589474384e+166, "22949521426780435", 167},
    {1.7949029630832286484753293e+255, "17949029630832286", 256},
    {4.2139347259617897006580958e-141, "42139347259617897", -140},
    {1.9457006508960371017456055e+09, "1945700650896037", 10},
    {1.8196174771432740054683665e-71, "1819617477143274", -70},
    {4.1522046835374129007633912e+87, "4152204683537413", 88},
    {9.5147913812484958396182160e+68, "9514791381248496", 69},
    {6.5233214832617612087687135e-290, "6523321483261761", -289},
    {2.1976443032900029725827622e+229, "2197644303290003", 230},
    {7.7945494123935994766136967e-137, "7794549412393599", -136},
    {8.2489133131573459394076595e+89, "8248913313157346", 90},
    {4.8463917161044124830727399e-53, "48463917161044125", -52},
    {2.6063179910917043195876454e-197, "26063179910917043", -196},
    {1.1534374731134831884282528e+98, "11534374731134832", 99},
    {9.6848108601248715664810536e-249, "9684810860124872", -248},
    {1.8151432624368661050734893e-139, "1815143262436866", -138},
    {4.8529274606854961376006889e-252, "4852927460685496", -251},
    {6.4690791441008866495362505e+151, "6469079144100887", 152},
    {2.5435769881081616696848503e-23, "25435769881081617", -22},
    {4.8653321386461015801692357e+232, "48653321386461016", 233},
    {3.7420972383650163576040659e-91, "37420972383650164", -90},
    {8.3446789266170258150226952e+48, "8344678926617026", 49},
    {6.3938712025623135813320022e+300, "6393871202562314", 301},
    {3.5700800810926413488499601e+58, "35700800810926413", 59},
    {9.7718299270913900711641499e+31, "977182992709139", 32},
    {1.1550161432438211845034689e-77, "11550161432438212", -76},
    {2.0964331650552929530757658e+218, "2096433165055293", 219},
    {2.2454983172384996597383434e+106, "22454983172384997", 107},
    {2.1444860345112284014708511e+105, "21444860345112284", 106},
    {1.1633741829442079412650245e+303, "1163374182944208", 304},
    {3.5466608488876978528610955e-215, "3546660848887698", -214},
    {6.5769584954769103685527886e-29, "657695849547691", -28},
    {4.8974529925882863733864417e-91, "48974529925882864", -90},
    {8.0254047096588487682218884e-16, "8025404709658849", -15},
    {8.9037824557449211111237601e-30, "8903782455744921", -29},
    {3.6618664795389382548936611e-122, "3661866479538938", -121},
    {2.1151283574963047553969054e-120, "21151283574963048", -119},
    {1.3986803306353937738594265e+58, "13986803306353938", 59},
    {1.0577243148255164430318093e-88, "10577243148255164", -87},
    {2.6430862838399377172382615e-273, "26430862838399377", -272},
    {1.2596059602833056524371011e-160, "12596059602833057", -159},
    {5.4588272976231225897627041e+212, "54588272976231226", 213},
    {1.5770082549604798992892692e-59, "157700825496048", -58},
    {2.1636919277782875993378627e+78, "21636919277782876", 79},
    {2.4017993593469032725105567e+79, "24017993593469033", 80},
    {1.8048727565534694610935250e+58, "18048727565534695", 59},
    {1.0243444966115229906761809e-286, "1024344496611523", -285},
    {6.0768827239239811789624535e-40, "6076882723923981", -39},
    {7.5118802614114227450004146e+251, "7511880261411423", 252},
    {1.9840504188757587212448598e+111, "19840504188757587", 112},
    {2.2838574066435595529063974e-85, "22838574066435596", -84},
    {7.2178869303959375246717360e+55, "7217886930395938", 56},
    {3.1541038478088714460379347e-219, "31541038478088714", -218},
    {5.2628491503919035427399292e+176, "5262849150391904", 177},
    {2.2347616447433604493813370e-123, "22347616447433604", -122},
    {1.1962299518289295549737626e-23, "11962299518289296", -22},
    {2.4128772673323365763307005e+97, "24128772673323366", 98},
    {9.9694233526446660444480696e+238, "9969423352644666", 239},
    {2.1466555463748508774235185e-112, "2146655546374851", -111},
    {3.1814474861631254040568758e+88, "31814474861631254", 89},
    {1.4604124571886264424632725e+270, "14604124571886264", 271},
    {1.7048502652936137750096168e-183, "17048502652936138", -182},
    {1.1445735176145482232809592e+106, "11445735176145482", 107},
    {1.4142365298012764385752020e-106, "14142365298012764", -105},
    {5.4670193927856419217797773e-45, "5467019392785642", -44},
    {4.2081230957248699031901272e-230, "420812309572487", -229},
    {1.3743265348195393101679890e-43, "13743265348195393", -42},
    {2.8407395932204538144023160e+231, "28407395932204538", 232},
    {8.5915043806138368693435897e-113, "8591504380613837", -112},
    {2.0860413333466250202158798e-187, "2086041333346625", -186},
    {1.8007849345179137821536975e-124, "18007849345179138", -123},
    {9.8262478733735338184635191e-64, "9826247873373534", -63},
    {5.9546095820614946905580690e+292, "5954609582061495", 293},
    {1.1810588903253426887628636e+174, "11810588903253427", 175},
    {4.3001554134733173571283430e-222, "43001554134733174", -221},
    {1.7899744607452887093383933e+57, "17899744607452887", 58},
    {5.0641884802156356378140684e-18, "5064188480215636", -17},
    {5.3393101842169916791322559e+257, "5339310184216992", 258},
    {9.8707392104373540911603260e-11, "9870739210437354", -10},
    {3.8900777961748975117882870e+195, "38900777961748975", 196},
    {2.1112282752977617954541902e+253, "21112282752977618", 254},
    {1.2940295822330719901031878e+88, "1294029582233072", 89},
    {4.8254314659307079861309532e+142, "4825431465930708", 143},
    {1.7619360172605266516695271e+291, "17619360172605267", 292},
    {8.6899669776839534614898829e+71, "8689966977683953", 72},
    {4.7374863655510006991807601e-113, "47374863655510007", -112},
    {9.4055091944424228638068546e-116, "9405509194442423", -115},
    {4.8914343909883674635238603e+62, "48914343909883675", 63},
    {5.0664669555609976668882494e-16, "5066466955560998", -15},
    {7.5882774773623168112541896e+251, "7588277477362317", 252},
    {1.4526237351335001900554408e+242, "14526237351335002", 243},
    {2.5817418824090038283980800e-205, "2581741882409004", -204},
    {2.4739871686571666717529297e+10, "24739871686571667", 11},
    {1.7534846492009051735353476e+105, "17534846492009052", 106},
    {4.6711485140276328491326120e-20, "4671148514027633", -19},
    {4.2865848623862801179351777e+250, "428658486238628", 251},
    {2.5344406885200331043302813e+163, "2534440688520033", 164},
    {1.8358017108669295973687204e-16, "18358017108669296", -15},
    {1.6583065591423431442615064e-298, "16583065591423431", -297},
    {8.5654542794774322548336013e+277, "8565454279477432", 278},
    {7.5112699219003518170444844e-300, "7511269921900352", -299},
    {6.0944046104444079293980774e+292, "6094404610444408", 293},
    {3.2506580993658211975898577e-220, "32506580993658212", -219},
    {3.9524654183636877415247602e-53, "39524654183636877", -52},
    {5.0138493710604038698648682e+36, "5013849371060404", 37},
    {1.4080636886649504321411059e-101, "14080636886649504", -100},
    {9.9036526722090275006744973e+306, "9903652672209028", 307},
    {2.3555385378796554930135694e+301, "23555385378796555", 302},
    {1.0112141980269663071523464e-204, "10112141980269663", -203},
    {3.0290047197111419401412482e+134, "3029004719711142", 135},
    {1.1354593504043559959868727e-144, "1135459350404356", -143},
    {2.4883271938614049421226897e-210, "2488327193861405", -209},
    {9.6686998328254865732273381e-116, "9668699832825487", -115},
    {3.1094140026364565240264859e-130, "31094140026364565", -129},
    {9.0823629416207947597558997e+281, "9082362941620795", 282},
    {8.7034291066060888671875000e+12, "8703429106606089", 13},
    {1.9042976389632997721841853e+290, "19042976389632998", 291},
    {1.7563706424764311961401456e+259, "17563706424764312", 260},
    {9.4921810030404312533317910e+142, "9492181003040431", 143},
    {1.2089663127877382007846069e-59, "12089663127877382", -58},
    {1.4469356111345664566215730e+122, "14469356111345665", 123},
    {1.4977809341681369129359414e+247, "1497780934168137", 248},
    {3.3990430994674378997759458e+144, "3399043099467438", 145},
    {3.0269669687368269358389583e-111, "3026966968736827", -110},
    {4.0715401139163591634266886e-97, "4071540113916359", -96},
    {1.8589265557672794438108411e-223, "18589265557672794", -222},
    {1.1542062835246560633418106e+249, "1154206283524656", 250},
    {8.0490555634320063079772969e-81, "8049055563432006", -80},
    {1.8358021903413464944976204e+138, "18358021903413465", 139},
    {1.5815921112068750665131812e+283, "1581592111206875", 284},
    {5.4227042783541314869712952e-189, "54227042783541315", -188},
    {3.0718588627211624446945882e-111, "30718588627211624", -110},
    {1.5313848517900089110768546e+308, "1531384851790009", 309},
    {1.1834884360308147367472323e-283, "11834884360308147", -282},
    {2.8978988125260438007463652e-120, "28978988125260438", -119},
    {1.1969572189575810090525337e+147, "1196957218957581", 148},
    {1.1355685615981931569351349e-222, "11355685615981932", -221},
    {3.3052843914487280325332257e+212, "3305284391448728", 213},
    {6.7895112020473639606903119e+292, "6789511202047364", 293},
    {1.0151562114879216364772953e-197, "10151562114879216", -196},
    {1.1416831292151290015139403e-31, "1141683129215129", -30},
    {3.9792961633799714880753434e-251, "39792961633799715", -250},
    {4.9002650551234936700928000e+22, "4900265055123494", 23},
    {2.8076259362008390478312601e+133, "2807625936200839", 134},
    {7.4927286848894017045447086e-276, "7492728684889402", -275},
    {8.7660428713613993094179098e-219, "8766042871361399", -218},
    {1.4290951618234987632877821e+101, "14290951618234988", 102},
    {1.6216077806097861345938396e+100, "16216077806097861", 101},
    {2.5619837548515227437019348e+08, "25619837548515227", 9},
    {8.6766107839968097264875168e-154, "867661078399681", -153},
    {1.1658418103392724734016235e+179, "11658418103392725", 180},
    {1.3090517911521279609857869e+272, "1309051791152128", 273},
    {2.7584272950196149169516563e-24, "2758427295019615", -23},
    {5.1626635700932304619996100e-26, "51626635700932305", -25},
    {3.4049294726779835654843413e+113, "34049294726779836", 114},
    {8.4103285921977341455262756e+186, "8410328592197734", 187},
    {2.5178997924540150701445445e+270, "2517899792454015", 271},
    {7.8766408317266803263026316e-111, "787664083172668", -110},
    {1.0661486182343001104107882e-79, "10661486182343001", -78},
    {2.2894232034635636215334804e+58, "22894232034635636", 59},
    {8.9903814661106791239646547e-125, "8990381466110679", -124},
    {1.9291874163562946860600523e-168, "19291874163562947", -167},
    {2.4574001648183823302267307e+305, "24574001648183823", 306},
    {4.0328314492089627112123580e-219, "4032831449208963", -218},
    {4.4394875632510253685646882e-215, "44394875632510254", -214},
    {9.1817529471245310962967287e+176, "9181752947124531", 177},
    {9.1647260660355466563847447e+173, "9164726066035547", 174},
    {1.6229555809366062926296920e-136, "16229555809366063", -135},
    {1.1947866559231906756718405e-148, "11947866559231907", -147},
    {7.7600788885494544196843363e-96, "7760078888549454", -95},
    {1.2495943831258008445772978e+44, "12495943831258008", 45},
    {3.4003131317283795847202432e-163, "34003131317283796", -162},
    {2.3948834073484400003246558e+197, "239488340734844", 198},
    {1.1903845255110258439317278e-299, "11903845255110258", -298},
    {4.4182282117291205053165279e+213, "44182282117291205", 214},
    {3.7617438921354231998466555e+245, "3761743892135423", 246},
    {6.9553377524282628745977386e+209, "6955337752428263", 210},
    {1.8439320923651650614255674e-196, "1843932092365165", -195},
    {7.4996457818657178315282716e-11, "7499645781865718", -10},
    {1.4859113502498132460892085e+153, "14859113502498132", 154},
    {5.1208662632089307663824454e-08, "5120866263208931", -7},
    {7.4005994787447957984981381e-73, "7400599478744796", -72},
    {9.7553304520934274179751655e+98, "9755330452093427", 99},
    {1.9591956338020400872376127e+276, "195919563380204", 277},
    {1.4492194955378723069031337e-51, "14492194955378723", -50},
    {6.3846926023003147158843741e-80, "6384692602300315", -79},
    {1.5307615951202371253106542e-131, "15307615951202371", -130},
    {8.2667179933639221719112026e+258, "8266717993363922", 259},
    {4.8967801293654807773280623e+270, "4896780129365481", 271},
    {4.6148531472438699051915685e-181, "461485314724387", -180},
    {1.3994389602197589516302890e-146, "1399438960219759", -145},
    {1.4844762958722027221670298e+257, "14844762958722027", 258},
    {1.1929638696826631287096060e-76, "11929638696826631", -75},
    {1.6118104799312544582457025e+100, "16118104799312545", 101},
    {1.1847744384326373954798355e-252, "11847744384326374", -251},
    {1.3230718615615033711466063e+84, "13230718615615034", 85},
    {2.4992530962642093558560878e-194, "24992530962642094", -193},
    {4.8990451489834009365095399e-269, "4899045148983401", -268},
    {3.5078544965688974284685312e+25, "35078544965688974", 26},
    {2.1317025053266303622732038e-261, "21317025053266304", -260},
    {8.3587114884018589298053169e-146, "8358711488401859", -145},
    {8.7121764131295054241129139e-97, "8712176413129505", -96},
    {8.3041678473313073704042234e+163, "8304167847331307", 164},
    {2.9557854595156496711009081e+197, "29557854595156497", 198},
    {1.5486097397489590288877454e-223, "1548609739748959", -222},
    {1.5538565971935107500000000e+15, "15538565971935108", 16},
    {1.2951199480933062031151335e+303, "12951199480933062", 304},
    {9.9431075396191490615348527e+71, "994310753961915", 72},
    {7.9645546300286655965333598e-115, "7964554630028666", -114},
    {1.5071956719294002026417579e+37, "15071956719294002", 38},
    {4.6353687594214688636671988e+112, "4635368759421469", 113},
    {6.6454296587047300162741927e+193, "664542965870473", 194},
    {1.1440215263487521634843456e+261, "11440215263487522", 262},
    {2.0776007930474145212570604e+84, "20776007930474145", 85},
    {8.8158596543553112667907471e-249, "8815859654355311", -248},
    {1.5220618864489179525050516e+185, "1522061886448918", 186},
    {3.9902494063643796496911312e+55, "39902494063643796", 56},
    {3.2619231947528671556131785e-13, "3261923194752867", -12},
    {2.3767816579351483210912300e-241, "23767816579351483", -240},
    {1.9533680036482635566239849e+288, "19533680036482636", 289},
    {2.1032697454195555937852023e-293, "21032697454195556", -292},
    {2.5321309333207120769206255e+217, "2532130933320712", 218},
    {4.9433188705190287542956540e-03, "4943318870519029", -2},
    {2.2325648011040336148850984e+196, "22325648011040336", 197},
    {1.0961074157850901122713711e+200, "10961074157850901", 201},
    {6.9274530284400445925504306e-179, "6927453028440045", -178},
    {4.7022405644019126251534119e-288, "47022405644019126", -287},
    {1.7323732960723453428050579e-112, "17323732960723453", -111},
    {1.1300458063935775805319652e-38, "11300458063935776", -37},
    {3.4311085450284580837475414e+49, "3431108545028458", 50},
    {8.0467249377805771112854633e+35, "8046724937780577", 36},
    {4.9086513820951348551255956e-43, "4908651382095135", -42},
    {5.2517333739689107724439592e-189, "5251733373968911", -188},
    {1.1941194848784749865331091e+144, "1194119484878475", 145},
    {2.7277792154204747219985750e+117, "2727779215420475", 118},
    {1.9582477979134173695053974e+234, "19582477979134174", 235},
    {2.3594641728894794032636282e-150, "23594641728894794", -149},
    {6.4846014055290018497321373e-175, "6484601405529002", -174},
    {4.0711512844170760740559592e+57, "4071151284417076", 58},
    {3.2014280331182714878142120e-290, "32014280331182715", -289},
    {7.2926889951138633471382140e+68, "7292688995113863", 69},
    {1.0319019952381898697968332e-184, "10319019952381899", -183},
    {3.3501604915083420585749533e-262, "3350160491508342", -261},
    {8.3826953388143310000745462e-252, "8382695338814331", -251},
    {4.2089664769314116349070439e+62, "4208966476931412", 63},
    {5.7085901154548471250027245e+74, "5708590115454847", 75},
    {1.6336444209648464508182008e-21, "16336444209648465", -20},
    {9.5818993448346502990563725e-301, "958189934483465", -300},
    {2.4002503581141415747726105e+138, "24002503581141416", 139},
    {1.5387158694756567561926513e-129, "15387158694756568", -128},
    {7.0077658384341297513299142e-62, "700776583843413", -61},
    {1.7672069017171508124627797e+166, "17672069017171508", 167},
    {9.4006119699742445096956024e-136, "9400611969974245", -135},
    {1.1061820924289408376887121e-231, "11061820924289408", -230},
    {4.9833574228012135607412471e-197, "49833574228012136", -196},
    {2.8450199817421740491389729e-103, "2845019981742174", -102},
    {5.6511629689006070211546637e+164, "5651162968900607", 165},
    {1.7712782408526032192990771e-276, "17712782408526032", -275},
    {1.5997733211966522976936875e+220, "15997733211966523", 221},
    {5.7826273105528667569160461e+07, "5782627310552867", 8},
    {7.9550895089476002341209448e+292, "79550895089476", 293},
    {2.5225817575926618645656976e+31, "2522581757592662", 32},
    {1.8342235615865737417438306e+186, "18342235615865737", 187},
    {2.2930333107795512582035046e-97, "22930333107795513", -96},
    {9.3569694415963137817672151e-44, "9356969441596314", -43},
    {1.4249867879754859252941521e-71, "1424986787975486", -70},
    {6.5198529625633134924917362e-27, "6519852962563313", -26},
    {4.8623939884832516023325999e+78, "4862393988483252", 79},
    {6.2452627239405643654518139e-167, "6245262723940564", -166},
    {1.1214340919457906737163145e-302, "11214340919457907", -301},
    {1.6630045687832599853359040e+41, "166300456878326", 42},
    {2.8148446786070218668261897e-16, "2814844678607022", -15},
    {2.4765623827879792930358230e+245, "24765623827879793", 246},
    {7.4638830619269054077209922e+239, "7463883061926905", 240},
    {8.8694052997368653176861633e+305, "8869405299736865", 306},
    {2.2929464162341411784411604e-164, "2292946416234141", -163},
    {1.1384461863337220573205843e+229, "1138446186333722", 230},
    {2.4761785119133077159858658e+02, "24761785119133077", 3},
    {1.3256427371973339871822972e+81, "1325642737197334", 82},
    {7.4536481107187260014660947e+303, "7453648110718726", 304},
    {8.0562051538959821115665737e-196, "8056205153895982", -195},
    {9.4012071011097135129585965e+83, "9401207101109714", 84},
    {3.8757558910208736991234325e+77, "38757558910208737", 78},
    {1.7717997245495830106458070e-72, "1771799724549583", -71},
    {2.6195547675156102847791771e+151, "261955476751561", 152},
    {4.3412866096727998159702838e+55, "43412866096728", 56},
    {3.3990722727299154352038684e-249, "33990722727299154", -248},
    {9.5027528093179980671645423e-91, "9502752809317998", -90},
    {2.1939416454820721759353016e-166, "21939416454820722", -165},
    {1.8387203810433924849131627e+158, "18387203810433925", 159},
    {6.8734185397835230374266274e-70, "6873418539783523", -69},
    {4.9495422780246614538383792e+199, "49495422780246615", 200},
    {1.8126025170350720000000000e+17, "1812602517035072", 18},
    {8.0526853259046229160708936e+150, "8052685325904623", 151},
    {1.1583189857484390946001035e+294, "11583189857484391", 295},
    {1.4122910642474236307330456e+93, "14122910642474236", 94},
    {4.1521331981083927590266929e+100, "4152133198108393", 101},
    {2.3914023927532408798243981e-28, "2391402392753241", -27},
    {9.2705759543525456193616211e+253, "9270575954352546", 254},
    {2.2150082064630795986886066e-138, "22150082064630796", -137},
    {3.5312621242332003049688707e+187, "35312621242332", 188},
    {1.8675840375690294970853940e+241, "18675840375690295", 242},
    {4.7795354061747348911432218e-44, "4779535406174735", -43},
    {2.3064046829700458698058783e-197, "2306404682970046", -196},
    {1.0901433298115705213078977e+123, "10901433298115705", 124},
    {1.2780205647333043522218473e+290, "12780205647333044", 291},
    {1.8890915472080278963443835e+89, "1889091547208028", 90},
    {1.4881899326323494534958982e-211, "14881899326323495", -210},
    {2.1131644849513366457996794e+30, "21131644849513366", 31},
    {2.6029880161451058351747361e-186, "2602988016145106", -185},
    {1.3742464984317560605742539e-272, "1374246498431756", -271},
    {1.5837363540641711065710958e+275, "1583736354064171", 276},
    {2.1093169604346467263266549e+153, "21093169604346467", 154},
    {2.8885337005963698877803796e-44, "288853370059637", -43},
    {5.3450560804723132252427587e+124, "5345056080472313", 125},
    {7.1520304246628463421239326e+70, "7152030424662846", 71},
    {8.8681707947220837407577489e-208, "8868170794722084", -207},
    {4.1267091160170640929166395e+121, "4126709116017064", 122},
    {4.6676537774939401521421543e+173, "466765377749394", 174},
    {1.5922362236893642980608678e-80, "15922362236893643", -79},
    {1.8423381702395691531627885e+257, "18423381702395692", 258},
    {1.0275571047959861559536536e+54, "10275571047959862", 55},
    {1.9269339661797980856609846e-22, "1926933966179798", -21},
    {8.8560950021270261233456546e-149, "8856095002127026", -148},
    {9.5970767463550435334880641e-200, "9597076746355044", -199},
    {5.8515848240813815987282701e-39, "58515848240813816", -38},
    {1.4038230720065263560000616e-293, "14038230720065264", -292},
    {9.1298348338581765566222566e-156, "9129834833858177", -155},
    {1.7123777232125132043112957e-275, "17123777232125132", -274},
    {3.2252618520123793933438058e-291, "32252618520123794", -290},
    {1.3694431485161165408684211e-28, "13694431485161165", -27},
    {5.2317696756232782695034785e-210, "5231769675623278", -209},
    {1.4106828845190717642468837e+191, "14106828845190718", 192},
    {2.8215927329155232522827362e-238, "28215927329155233", -237},
    {1.7664462632197097656250000e+13, "17664462632197098", 14},
    {7.2323381109425823565821460e-75, "7232338110942582", -74},
    {1.9265707982383565724086088e+232, "19265707982383566", 233},
    {3.5326023431131573328525270e+258, "35326023431131573", 259},
    {3.0711828464869572616283676e-204, "30711828464869573", -203},
    {2.4684479815178263773985565e+151, "24684479815178264", 152},
    {4.0992209612304163219371939e+73, "40992209612304163", 74},
    {3.4124111386965340452439199e-263, "3412411138696534", -262},
    {2.4768323320691341907499623e+294, "24768323320691342", 295},
    {1.7097363538552820837430597e-192, "1709736353855282", -191},
    {3.2772218385117444395587956e+75, "32772218385117444", 76},
    {6.2526254856199400195678587e+260, "625262548561994", 261},
    {4.3695952276166981625125873e-134, "4369595227616698", -133},
    {1.2666323094604264979633282e+111, "12666323094604265", 112},
    {2.1302982676259943438205950e+155, "21302982676259943", 156},
    {2.4111981839625571916932693e-13, "2411198183962557", -12},
    {1.5161618590395672847365655e+235, "15161618590395673", 236},
    {4.8049029791263518112824502e+153, "4804902979126352", 154},
    {1.4567902250655457920890690e+90, "14567902250655458", 91},
    {5.7771774290917748269107862e-96, "5777177429091775", -95},
    {2.5348216628253574952029705e+244, "25348216628253575", 245},
    {2.4185478226299690806640771e-293, "2418547822629969", -292},
    {4.9648727061183940489175394e+209, "4964872706118394", 210},
    {8.6306011409953680087853927e-297, "8630601140995368", -296},
    {9.5456194932876062680526982e+131, "9545619493287606", 132},
    {4.2910430913845556917219483e+244, "42910430913845557", 245},
    {1.5432793214728335252483776e-67, "15432793214728335", -66},
    {6.7091940845056418356644956e+171, "6709194084505642", 172},
    {1.5299789487649325921483912e-04, "15299789487649326", -3},
    {8.4465734805535016682713116e-172, "8446573480553502", -171},
    {2.3786930330208679422340437e-204, "2378693033020868", -203},
    {7.2901130360162256004248457e-303, "7290113036016226", -302},
    {3.3568351638301159424000000e+19, "3356835163830116", 20},
    {4.4294429892226025307511939e+75, "44294429892226025", 76},
    {1.6964448725837987506405435e-04, "16964448725837988", -3},
    {5.5102237749717651017091054e+131, "5510223774971765", 132},
    {1.3100547205732081451663360e+24, "13100547205732081", 25},
    {1.4113464579471229161392644e+307, "1411346457947123", 308},
    {9.8848921144472821473331636e-265, "9884892114447282", -264},
    {1.0878420495346451575363357e+241, "10878420495346452", 242},
    {2.1405582717205158182562455e+151, "21405582717205158", 152},
    {3.4085992734992344164099572e+291, "34085992734992344", 292},
    {1.7555614742582598634641013e+148, "175556147425826", 149},
    {1.6786167887571010174158104e-210, "1678616788757101", -209},
    {1.6998581700822921892850949e-272, "16998581700822922", -271},
    {1.0880667752634010611964064e-44, "1088066775263401", -43},
    {2.7657749724124257084182400e-186, "27657749724124257", -185},
    {4.8407236167194100987586178e-32, "484072361671941", -31},
    {9.0969921053214956266806121e+36, "9096992105321496", 37},
    {1.4844733341275963202870808e-140, "14844733341275963", -139},
    {7.8882820037313192073805066e+270, "7888282003731319", 271},
    {3.0905400640489360482792915e-217, "3090540064048936", -216},
    {1.0155637514521071356656933e-189, "10155637514521071", -188},
    {1.6812214823136291369456823e+114, "16812214823136291", 115},
    {1.2569002856458300057064069e-140, "125690028564583", -139},
    {2.3720452863568083672226284e-57, "23720452863568084", -56},
    {2.0774568235110362844852999e+51, "20774568235110363", 52},
    {3.3532490944098398146607764e+153, "335324909440984", 154},
    {7.2495808551521559751699889e+211, "7249580855152156", 212},
    {3.8277654779462587633133356e-136, "3827765477946259", -135},
    {3.7814134505781931351598897e+160, "3781413450578193", 161},
    {8.3411050942927466699948019e+61, "8341105094292747", 62},
    {2.6841036518245287927471586e-142, "26841036518245288", -141},
    {2.0126394306591682749207109e-258, "20126394306591683", -257},
    {1.0701638968418098358263753e+30, "10701638968418098", 31},
    {4.6769936119083069869080750e-207, "4676993611908307", -206},
    {6.4143948868118579675659289e-259, "6414394886811858", -258},
    {4.2942936869515184609451468e+34, "4294293686951518", 35},
    {3.5930344006359693811714369e+140, "35930344006359694", 141},
    {3.7838259629738818613816805e+202, "3783825962973882", 203},
    {7.6511041109044846971024454e+141, "7651104110904485", 142},
    {2.8576902965056371929589478e+159, "2857690296505637", 160},
    {3.0647505012235120470057259e-19, "3064750501223512", -18},
    {9.8998994104886802223789732e-210, "989989941048868", -209},
    {3.3818221600630124923498522e-192, "33818221600630125", -191},
    {1.2462878649152217130203238e+185, "12462878649152217", 186},
    {8.6340708706496048803742096e+95, "8634070870649605", 96},
    {3.0152691133084718484690613e-243, "3015269113308472", -242},
    {3.2410508037446057391563273e+156, "32410508037446057", 157},
    {1.3201512475748614862497377e+224, "13201512475748615", 225},
    {1.5450890743909638442954540e+188, "15450890743909638", 189},
    {5.8291393340304569922509468e+163, "5829139334030457", 164},
    {3.5756640883611839886784707e-64, "3575664088361184", -63},
    {2.6757285653944088758869393e+207, "2675728565394409", 208},
    {1.2863822335243169196784700e+72, "1286382233524317", 73},
    {1.7764786461982790745096995e-197, "1776478646198279", -196},
    {2.3489268127844627269900972e-243, "23489268127844627", -242},
    {9.8313512339916246546706938e-45, "9831351233991625", -44},
    {2.0119162628600507854038003e-166, "20119162628600508", -165},
    {6.8435574685045724186902799e-60, "6843557468504572", -59},
    {3.7164640786809479203673901e+51, "3716464078680948", 52},
    {2.5929300480772608668253428e+52, "2592930048077261", 53},
    {5.5970650627071575157661561e-205, "55970650627071575", -204},
    {6.3904622480919599696057210e-299, "639046224809196", -298},
    {4.7322732380535229265827119e-141, "4732273238053523", -140},
    {2.5825839425247520699847045e+216, "2582583942524752", 217},
    {8.2968238672707305135261787e+43, "8296823867270731", 44},
    {5.7374447120474033613758098e+75, "5737444712047403", 76},
    {4.3145575979376194192753331e-186, "43145575979376194", -185},
    {7.5904887411384834597757560e-90, "75904887411384835", -89},
    {1.2494089971132642794220145e-222, "12494089971132643", -221},
    {5.8831515396171550650456399e+102, "5883151539617155", 103},
    {1.4663496956744753450018657e-238, "14663496956744753", -237},
    {1.7081834025836339485567188e+253, "1708183402583634", 254},
    {6.3220460897624033407683253e-193, "6322046089762403", -192},
    {5.7678215684588949443423189e+03, "5767821568458895", 4},
    {1.6964371039064662859712148e+140, "16964371039064663", 141},
    {2.2974996482197829391598962e-210, "2297499648219783", -209},
    {1.4326790803950112528753476e+93, "14326790803950113", 94},
    {1.3802950571156913539291412e+174, "13802950571156914", 175},
    {9.7667722447385283328594982e+137, "9766772244738528", 138},
    {1.0089761595128308904644142e-93, "10089761595128309", -92},
    {1.2738096723808032100311728e+63, "12738096723808032", 64},
    {1.5829563203354289347514981e+209, "1582956320335429", 210},
    {4.8661284122880301549811507e+289, "486612841228803", 290},
    {4.6526684110074924951368161e-245, "46526684110074925", -244},
    {2.2543084987266629530515639e+207, "2254308498726663", 208},
    {1.3285708273560239347737594e-308, "1328570827356024", -307},
    {7.1618139158848086222836051e-55, "7161813915884809", -54},
    {1.2560581541284540355248563e-140, "1256058154128454", -139},
    {3.2588673321501323237354959e+125, "32588673321501323", 126},
    {3.3378477830071589493964061e-222, "3337847783007159", -221},
    {3.5912967243707563385851906e-34, "35912967243707563", -33},
    {6.6014708427560359424100363e+34, "6601470842756036", 35},
    {7.3533579698829944660804106e+96, "7353357969882994", 97},
    {3.7891591641072059934161487e+175, "3789159164107206", 176},
    {6.7482214711791977861372387e-224, "6748221471179198", -223},
    {2.5796375267069056478992544e-111, "25796375267069056", -110},
    {1.3746266305338180846113667e-192, "1374626630533818", -191},
    {5.3773249041711034061479535e-239, "5377324904171103", -238},
    {1.5551894950380952500000000e+15, "15551894950380952", 16},
    {8.2479364463857645274777987e-170, "8247936446385765", -169},
    {3.9783294810005045519923938e-214, "39783294810005046", -213},
    {1.0166777113157568527079664e+212, "10166777113157569", 213},
    {1.5585241465563126182413923e-276, "15585241465563126", -275},
    {1.2488109100233040438890476e+264, "1248810910023304", 265},
    {1.7292302053093558614318852e-306, "1729230205309356", -305},
    {3.6068996708815556991301102e+214, "36068996708815557", 215},
    {4.0961367529650512369403106e-277, "4096136752965051", -276},
    {3.2482151978840191272974284e-125, "3248215197884019", -124},
    {3.2429926448865099969970757e-14, "324299264488651", -13},
    {1.3641704259055487608206996e+170, "13641704259055488", 171},
    {1.7444406252449689063866377e-249, "1744440625244969", -248},
    {2.1703971967132196111177387e+74, "21703971967132196", 75},
    {1.4551132600919646983418561e-248, "14551132600919647", -247},
    {4.6724414732218964666586687e+37, "4672441473221896", 38},
    {5.2143900748928936059647209e-193, "5214390074892894", -192},
    {4.5852629045946275118908509e+42, "45852629045946275", 43},
    {2.5349585634569180252507405e-280, "2534958563456918", -279},
    {3.2242191368585340124416807e+107, "3224219136858534", 108},
    {6.1590167197603768657898318e-155, "6159016719760377", -154},
    {1.0682836392086917163926071e+52, "10682836392086917", 53},
    {3.2814325308953291373359923e+27, "3281432530895329", 28},
    {4.7288883179816222132623178e-138, "4728888317981622", -137},
    {2.4524378364030979420047453e+259, "2452437836403098", 260},
    {3.6576630503702727393000226e-92, "3657663050370273", -91},
    {3.7951798848665208036687880e+262, "3795179884866521", 263},
    {5.0662650004625394849874810e-244, "50662650004625395", -243},
    {4.7624788044242779196666233e+90, "4762478804424278", 91},
    {2.1466548052629976248834024e-242, "21466548052629976", -241},
    {3.1918733705763582452083115e-283, "31918733705763582", -282},
    {1.5093864175097734976779552e+200, "15093864175097735", 201},
    {6.4304520871634948813014438e-251, "6430452087163495", -250},
    {1.1852930827487957690553083e+207, "11852930827487958", 208},
    {1.7973151782374515515971894e+76, "17973151782374516", 77},
    {3.7732346501589614418237654e-69, "37732346501589614", -68},
    {7.1137053684324750723129432e+84, "7113705368432475", 85},
    {1.1540017495178232773007282e+97, "11540017495178233", 98},
    {6.1560570002178982394349205e+186, "6156057000217898", 187},
    {4.0952080063887436057921198e-249, "40952080063887436", -248},
    {3.9664683062650894648569697e+257, "39664683062650895", 258},
    {1.4642064038849960396043632e-246, "1464206403884996", -245},
    {2.6048530800282846936201213e-276, "26048530800282847", -275},
    {7.9704322366253680371073768e+30, "7970432236625368", 31},
    {7.5669087152710517723456724e-83, "7566908715271052", -82},
    {1.0417662774901595968305368e-252, "10417662774901596", -251},
    {1.5099819064788926989471187e+121, "15099819064788927", 122},
    {3.3002936525055728912353516e+10, "3300293652505573", 11},
    {8.1880070500183088280735674e-200, "8188007050018309", -199},
    {3.2251788045615608853941806e+98, "3225178804561561", 99},
    {5.2897000237352452062875871e+265, "5289700023735245", 266},
    {3.7858353409250167970387661e+108, "3785835340925017", 109},
    {1.1471074330611964218864343e-169, "11471074330611964", -168},
    {1.5463156844689152909311479e+205, "15463156844689153", 206},
    {1.8761843918797504418419930e+282, "18761843918797504", 283},
    {1.3449947024570960500603140e-250, "1344994702457096", -249},
    {2.4041015796447045731397483e+261, "24041015796447046", 262},
    {2.9244566407124857786988033e-19, "2924456640712486", -18},
    {4.7307973570316476685881532e+194, "47307973570316477", 195},
    {6.3707217622166901344060719e-05, "637072176221669", -4},
    {1.4345272113446919707932835e+181, "1434527211344692", 182},
    {1.2047672648243253305133852e-104, "12047672648243253", -103},
    {1.7271841494939072388612671e+301, "17271841494939072", 302},
    {5.4678537900567326770576961e-183, "5467853790056733", -182},
    {4.9537950789166814213148907e+36, "49537950789166814", 37},
    {1.7427426004254100806804058e+244, "174274260042541", 245},
    {1.5427495323438822870907678e+239, "15427495323438823", 240},
    {1.6391203418861610148735736e-95, "1639120341886161", -94},
    {2.4393894260981972521746006e+255, "24393894260981973", 256},
    {6.8601549019325866231143827e+249, "6860154901932587", 250},
    {4.6524101981307831382155810e-245, "4652410198130783", -244},
    {3.7801585188665971627385918e-174, "3780158518866597", -173},
    {1.2250604063275450552921962e-288, "1225060406327545", -287},
    {1.6039460223298327690043787e-218, "16039460223298328", -217},
    {1.2160128473611616565376846e+137, "12160128473611617", 138},
    {1.2051473113984424591064453e+10, "12051473113984425", 11},
    {1.0494437193215525696508217e+264, "10494437193215526", 265},
    {9.2842247474719792269898817e+216, "9284224747471979", 217},
    {2.6225752313311145604591509e+172, "26225752313311146", 173},
    {3.2870837073722512220876786e+38, "32870837073722512", 39},
    {1.0313166040630441715705508e-264, "10313166040630442", -263},
    {1.6751951628893896836683903e+234, "16751951628893897", 235},
    {1.6898146717425787459834851e+201, "16898146717425787", 202},
    {3.5326236077041623317184013e+297, "35326236077041623", 298},
    {3.5112445009373043530633488e-65, "35112445009373044", -64},
    {4.3421512944262651137954441e+39, "4342151294426265", 40},
    {4.7268206104814853753536182e+64, "47268206104814854", 65},
    {3.6528734949184413268656467e-31, "36528734949184413", -30},
    {2.3233319303641885213580454e-167, "23233319303641885", -166},
    {1.4435233803191452124157938e+162, "14435233803191452", 163},
    {1.3096880923170202865923430e+83, "13096880923170203", 84},
    {2.7243486025907011446980895e+165, "2724348602590701", 166},
    {6.8485048754826156317709696e-18, "6848504875482616", -17},
    {2.1642428296487152099609375e+11, "21642428296487152", 12},
    {5.0524365361691237259496396e+133, "5052436536169124", 134},
    {5.4734374735354559323429344e-43, "5473437473535456", -42},
    {3.4674496387573227872354626e-19, "3467449638757323", -18},
    {1.2359748225237098482563899e+294, "12359748225237098", 295},
    {1.5954828819108812757846592e-197, "15954828819108813", -196},
    {1.4801672229646027944764523e-08, "14801672229646028", -7},
    {1.1299656846487700282034846e+189, "112996568464877", 190},
    {4.5394996344752613849724665e-279, "4539499634475261", -278},
    {1.2993712817539462794778776e+252, "12993712817539463", 253},
    {1.1044949583879870053364891e+176, "1104494958387987", 177},
    {5.1712741519099038625553469e-50, "5171274151909904", -49},
    {7.9709309772664600346167949e-99, "797093097726646", -98},
    {5.3168191603953480296514379e+190, "5316819160395348", 191},
    {5.9708011720890598398502054e-264, "597080117208906", -263},
    {5.7691145407115384448364382e-18, "57691145407115384", -17},
    {2.5993986405024298421112731e-139, "259939864050243", -138},
    {8.0227444038341231517146545e-141, "8022744403834123", -140},
    {2.6299040621826697869029927e-172, "262990406218267", -171},
    {4.7860591670607623021684994e-164, "4786059167060762", -163},
    {9.2171325453303142774132571e+220, "9217132545330314", 221},
    {2.7513373095813157354592059e-126, "27513373095813157", -125},
    {2.3052158968891334662796731e+136, "23052158968891335", 137},
    {2.1964119216699887953213534e-114, "21964119216699888", -113},
    {4.3180813354479699573781753e+307, "431808133544797", 308},
    {6.5146534232250556728275632e-293, "6514653423225056", -292},
    {2.1037799209991183078291439e-259, "21037799209991183", -258},
    {2.8917088458473033968536255e+300, "28917088458473034", 301},
    {7.8357318713548999710037934e-230, "78357318713549", -229},
    {6.0568511697453411882664068e-127, "6056851169745341", -126},
    {1.1299324621317241621239967e+270, "11299324621317242", 271},
    {1.8719240129955831326376415e-168, "18719240129955831", -167},
    {2.8885610702070665389840087e+00, "28885610702070665", 1},
    {3.7807944715467822265625000e+12, "3780794471546782", 13},
    {1.1036971690385305917050759e-130, "11036971690385306", -129},
    {8.8851121094892371686265172e-262, "8885112109489237", -261},
    {8.6884046134358891870768977e-155, "868840461343589", -154},
    {5.3644682417985013481489396e+289, "5364468241798501", 290},
    {7.6819835570891403165500453e+65, "768198355708914", 66},
    {1.4050856949686658786499824e+161, "1405085694968666", 162},
    {5.8283430495948496479610470e+26, "58283430495948496", 27},
    {4.8570033740624529580652093e+55, "4857003374062453", 56},
    {2.3827084962187201770029429e+111, "23827084962187202", 112},
    {3.8916429463325944605735369e-304, "38916429463325945", -303},
    {8.7782594656648364434967479e+222, "8778259465664836", 223},
    {1.1817751661014852800000000e+17, "11817751661014853", 18},
    {8.3407637819836229713976466e-85, "8340763781983623", -84},
    {1.2048109152673417030645470e+92, "12048109152673417", 93},
    {1.8476754999931715660909440e+161, "18476754999931716", 162},
    {3.7653350889447619792192012e-247, "3765335088944762", -246},
    {9.8583835016577369223097309e+63, "9858383501657737", 64},
    {5.8294323186309843732556004e+296, "58294323186309844", 297},
    {2.5469091624844338027476446e-228, "25469091624844338", -227},
    {4.4978903029302717638935110e-69, "4497890302930272", -68},
    {1.1909192843495099493111470e-240, "119091928434951", -239},
    {2.1292541772315760142059364e+39, "2129254177231576", 40},
    {3.6242082661452448697100199e-181, "3624208266145245", -180},
    {7.1842684744960276925008678e+299, "7184268474496028", 300},
    {3.5403860106252484921179478e+244, "35403860106252485", 245},
    {1.6611832786234801897786858e+210, "16611832786234802", 211},
    {1.4472763683403944015502930e+10, "14472763683403944", 11},
    {1.0719773512015880984267760e+60, "10719773512015881", 61},
    {1.8532362292522132524435828e+297, "18532362292522133", 298},
    {4.8631121429054659645782818e+64, "4863112142905466", 65},
    {5.8592287712364509742584200e-213, "5859228771236451", -212},
    {1.0295566638274059686635466e-72, "1029556663827406", -71},
    {1.3070986621357403940044427e-107, "13070986621357404", -106},
    {7.2585747906111383438860705e-46, "7258574790611138", -45},
    {4.3900335933958006454392308e+141, "43900335933958006", 142},
    {4.4311822172838296441513758e-98, "44311822172838296", -97},
    {2.6205265168143904463844182e-251, "26205265168143904", -250},
    {2.3965019854619641250828259e-191, "2396501985461964", -190},
    {5.6253809372029111702901453e+252, "5625380937202911", 253},
    {3.3410026052412855028998824e+169, "33410026052412855", 170},
    {1.4600551649874894493096650e+87, "14600551649874894", 88},
    {2.4967401379714969188721130e-150, "2496740137971497", -149},
    {3.1897532899433222363691940e-158, "31897532899433222", -157},
    {3.7635404435444961954097123e-233, "3763540443544496", -232},
    {1.3975675134242363106701833e+248, "13975675134242363", 249},
    {6.2843440129331022426548665e+197, "6284344012933102", 198},
    {1.7234789449145075400981883e-15, "17234789449145075", -14},
    {5.7387591349142189768204918e-71, "5738759134914219", -70},
    {1.7847639729361632812500000e+13, "17847639729361633", 14},
    {5.7091350593920076536185344e+176, "5709135059392008", 177},
    {7.0815552381536138112916312e-03, "7081555238153614", -2},
    {1.3083546111555723638769332e+52, "13083546111555724", 53},
    {9.1392634381506149238918019e+156, "9139263438150615", 157},
    {6.6819002471680867671966553e+08, "6681900247168087", 9},
    {3.6189578998195089793328951e+119, "3618957899819509", 120},
    {3.0655217203217617399927671e-183, "30655217203217617", -182},
    {2.6865913306584219681860582e+141, "2686591330658422", 142},
    {2.7217746756756359056413093e-70, "2721774675675636", -69},
    {2.0652763625701778474512365e-228, "20652763625701778", -227},
    {2.0623193262715294271603224e-131, "20623193262715294", -130},
    {5.7588897349521680298528409e-226, "5758889734952168", -225},
    {3.7443527609918896814679020e+126, "37443527609918897", 127},
    {1.6970712667458726719121524e-294, "16970712667458727", -293},
    {1.1171482705293191169885519e+178, "11171482705293191", 179},
    {2.7774383138490663049535944e-66, "27774383138490663", -65},
    {1.2112346055983392683376401e-201, "12112346055983393", -200},
    {8.3305792254062336365029488e-222, "8330579225406234", -221},
    {4.3740698069621103853208710e-172, "43740698069621104", -171},
    {1.9404702817267448658481272e+189, "19404702817267449", 190},
    {1.3088544239732825743839666e-92, "13088544239732826", -91},
    {2.0918913040482658955525221e-275, "2091891304048266", -274},
    {2.6603596507679488597151382e+102, "2660359650767949", 103},
    {3.2354308959560926268750336e+03, "32354308959560926", 4},
    {7.0868414038575580343604088e+06, "7086841403857558", 7},
    {1.6573147351822561379464105e+00, "16573147351822561", 1},
    {2.1023981168419436152236896e+157, "21023981168419436", 158},
    {3.6543437060657742515492418e+246, "3654343706065774", 247},
    {3.4458540499766626666551042e-138, "34458540499766627", -137},
    {8.2087897941571977939692182e+59, "8208789794157198", 60},
    {3.6792734705991523206423688e-277, "36792734705991523", -276},
    {2.5897799531815868775965510e-235, "2589779953181587", -234},
    {3.2062000952569354571665794e-179, "32062000952569355", -178},
    {1.0488950715748809122842482e+148, "10488950715748809", 149},
    {1.3456143374062711389379038e+101, "13456143374062711", 102},
    {5.4667883201766713383919475e+302, "5466788320176671", 303},
    {1.6297897998875701312382357e-13, "16297897998875701", -12},
    {4.8578686779407710685816137e+210, "4857868677940771", 211},
    {5.5949129215229271940787760e+93, "5594912921522927", 94},
    {2.6695420122212924974838705e-79, "26695420122212925", -78},
    {1.5697790377471762751057570e-218, "15697790377471763", -217},
    {8.2799961841066222874840269e+26, "8279996184106622", 27},
    {7.5589186939177370861611929e+233, "7558918693917737", 234},
    {3.4019059641978241999207434e-97, "3401905964197824", -96},
    {8.1817159311519106446974881e-10, "8181715931151911", -9},
    {2.0185854252048902812931881e-183, "20185854252048903", -182},
    {3.3335252369378433289667060e-86, "3333525236937843", -85},
    {1.3604358660898241310652345e-22, "13604358660898241", -21},
    {1.1036546774614350710119895e+298, "1103654677461435", 299},
    {4.3142389760930245175026328e+280, "43142389760930245", 281},
    {2.6589227465194063606698286e+258, "26589227465194064", 259},
    {7.5288882853587735139559943e-101, "7528888285358774", -100},
    {1.8863647207658455260389978e-192, "18863647207658455", -191},
    {2.3531100491828020269717095e+260, "2353110049182802", 261},
    {1.2709853021075695222503036e-67, "12709853021075695", -66},
    {2.1310640910635857018809610e-126, "21310640910635857", -125},
    {3.4913338298334628528673897e+260, "3491333829833463", 261},
    {1.1189095265341475519428251e-78, "11189095265341476", -77},
    {1.6017774980997225170446393e-262, "16017774980997225", -261},
    {3.0266535336929222189270442e+38, "30266535336929222", 39},
    {5.4694920139741207013698657e+59, "5469492013974121", 60},
    {9.1241174100268117541033468e-83, "9124117410026812", -82},
    {5.5565882778206275823149958e+196, "55565882778206276", 197},
    {5.7384491189754858467941138e-238, "5738449118975486", -237},
    {1.6437376178323901635416621e+122, "16437376178323902", 123},
    {6.2351489361514973721325118e-257, "62351489361514974", -256},
    {6.1508962151510697805410886e+111, "615089621515107", 112},
    {4.2155827346461579322627526e+127, "4215582734646158", 128},
    {4.3857881692901864432739699e+276, "43857881692901864", 277},
    {3.6692633607014617266786459e+294, "3669263360701462", 295},
    {7.1472116112578112841350046e+286, "7147211611257811", 287},
    {4.4464660951008292880820168e-281, "4446466095100829", -280},
    {4.0466922903201031982978186e-03, "4046692290320103", -2},
    {3.2806332513715486537143388e+47, "32806332513715487", 48},
    {2.5036480778795305639505386e+07, "25036480778795306", 8},
    {2.2691764597456329718484483e-83, "2269176459745633", -82},
    {8.8671461555369628787515168e-03, "8867146155536963", -2},
    {1.2298755011003951163532902e+26, "12298755011003951", 27},
    {9.0658460122532777082735953e+88, "9065846012253278", 89},
    {1.0172808433297538807273824e-296, "10172808433297539", -295},
    {1.3163227201714287059020351e-242, "13163227201714287", -241},
    {9.9224732257199177085105631e+229, "9922473225719918", 230},
    {9.8394148290150679535125971e+46, "9839414829015068", 47},
    {8.6502638263302015731859013e-122, "8650263826330202", -121},
    {2.9560409815101236932799513e+132, "2956040981510124", 133},
    {9.9787941336830206616135728e-182, "997879413368302", -181},
    {4.5486003988448000875369687e-187, "45486003988448", -186},
    {2.2531321587080801092619067e-125, "225313215870808", -124},
    {1.5167516199217666401414744e+193, "15167516199217666", 194},
    {6.2661779268091936049373248e+235, "6266177926809194", 236},
    {6.1116145329391169517870954e+271, "6111614532939117", 272},
    {5.4286127160926182937875518e+233, "5428612716092618", 234},
    {2.6234217317040061389825318e+35, "2623421731704006", 36},
    {6.3482291725027389369439716e-263, "6348229172502739", -262},
    {8.1604423819007191644026942e-260, "8160442381900719", -259},
    {4.0458951198212502002953270e+303, "404589511982125", 304},
    {1.2016815336021884282442831e-214, "12016815336021884", -213},
    {1.6429959130483702175512971e-307, "16429959130483702", -306},
    {4.6245041762156164668615281e+185, "46245041762156165", 186},
    {2.6880374383457181475318451e+48, "2688037438345718", 49},
    {9.1174076052211390970154085e-60, "9117407605221139", -59},
    {1.1006446520465508966649176e+61, "11006446520465509", 62},
    {7.6247167434974055746451305e+47, "7624716743497406", 48},
    {1.2227425438825473056003233e-225, "12227425438825473", -224},
    {3.4523821083966953381243864e-176, "3452382108396695", -175},
    {1.2459689727171874393737951e-104, "12459689727171874", -103},
    {7.8483730710468793760238996e-162, "7848373071046879", -161},
    {9.3084040464267268400717225e+56, "9308404046426727", 57},
    {9.3222677240484958400147411e-69, "9322267724048496", -68},
    {7.7856767967724637570052298e+193, "7785676796772464", 194},
    {1.5655868217758591946933860e+117, "15655868217758592", 118},
    {1.4939409803496082484876265e+205, "14939409803496082", 206},
    {3.7611915549187153912833924e+267, "37611915549187154", 268},
    {3.3013782106180464399984245e+274, "33013782106180464", 275},
    {2.5500930821196989925264023e+52, "2550093082119699", 53},
    {2.4588966848873241376172045e-166, "2458896684887324", -165},
    {3.9576190496336689027148923e+175, "3957619049633669", 176},
    {2.3835830727941237277996687e+62, "23835830727941237", 63},
    {1.5664097774012344289801022e+76, "15664097774012344", 77},
    {1.7167915887911404873456559e-199, "17167915887911405", -198},
    {5.8145203841104853261926557e+192, "5814520384110485", 193},
    {4.7202293066953080769923445e-122, "4720229306695308", -121},
    {6.0908820648251048279618736e-94, "6090882064825105", -93},
    {9.2058732203807238758113387e-103, "9205873220380724", -102},
    {3.6958569308019285429903991e+188, "36958569308019285", 189},
    {3.0827198200204988610074386e-77, "3082719820020499", -76},
    {6.3006383836943489371116541e+184, "6300638383694349", 185},
    {5.3302825483526102786087167e+162, "533028254835261", 163},
    {3.0793620300015732325776406e+277, "30793620300015732", 278},
    {1.1474383337041357400773352e-75, "11474383337041357", -74},
    {4.8613573800578694318926946e+168, "48613573800578694", 169},
    {1.3150996461310607588511166e-251, "13150996461310608", -250},
    {1.2912521605102465665529807e+251, "12912521605102466", 252},
    {8.4205197481506821060927638e-26, "8420519748150682", -25},
    {3.7027712313857508244456374e+75, "3702771231385751", 76},
    {9.8444436810360109397991740e+146, "9844443681036011", 147},
    {1.0127519786578992111704719e-234, "10127519786578992", -233},
    {1.7182517669574580166370908e-177, "1718251766957458", -176},
    {2.5841922010681282008031725e+296, "25841922010681282", 297},
    {2.3889901967993592128650516e-204, "23889901967993592", -203},
    {3.0456674792460897600452740e-147, "304566747924609", -146},
    {9.0207636256343639674892360e+154, "9020763625634364", 155},
    {2.6689888884062760671443092e+292, "2668988888406276", 293},
    {6.9876245149401975249736963e+302, "6987624514940198", 303},
    {4.0445326480012674752419288e-218, "40445326480012675", -217},
    {1.4847777792393583793052341e+197, "14847777792393584", 198},
    {2.1648964382741505024586485e+42, "21648964382741505", 43},
    {1.5098514026280780645215527e-295, "1509851402628078", -294},
    {5.9016208030610798365126783e+76, "590162080306108", 77},
    {1.2909125139908359875393338e-133, "1290912513990836", -132},
    {1.1052837137504708989044718e-302, "11052837137504709", -301},
    {1.6642397732300503183810451e+252, "16642397732300503", 253},
    {1.6159172299679434375000000e+14, "16159172299679434", 15},
    {1.4023054216697664755389065e+29, "14023054216697665", 30},
    {2.1581628032178207566846540e+252, "21581628032178208", 253},
    {1.1921550259788531810045242e+07, "11921550259788532", 8},
    {3.7956072727049638443261570e-65, "3795607272704964", -64},
    {3.6875060081329286120071562e+303, "36875060081329286", 304},
    {1.1564820244162631344712696e+108, "11564820244162631", 109},
    {4.4350913131540328979492188e+10, "4435091313154033", 11},
    {4.2490483556339900724037886e+183, "424904835563399", 184},
    {2.7745499693350086375078963e-192, "27745499693350086", -191},
    {2.1618952772831526226694472e-27, "21618952772831526", -26},
    {9.9685903563624455744876884e+256, "9968590356362446", 257},
    {2.2230908789598409765531033e-72, "2223090878959841", -71},
    {8.4393220612556889358327054e-12, "8439322061255689", -11},
    {3.4067013112426791126855986e+105, "3406701311242679", 106},
    {4.2705359719208316651884543e-67, "42705359719208317", -66},
    {7.7880260669163605863984960e-122, "7788026066916361", -121},
    {4.2042357539537067247702633e-74, "4204235753953707", -73},
    {4.3135822942006881848335985e+51, "4313582294200688", 52},
    {2.5542425896124889387638613e+75, "2554242589612489", 76},
    {6.7922272150277601047832858e-11, "679222721502776", -10},
    {9.9153866934033748626370372e-291, "9915386693403375", -290},
    {1.8880066847605063229047497e+37, "18880066847605063", 38},
    {6.0911903600337284514019820e-238, "60911903600337285", -237},
    {2.0480540937110222471659694e-141, "20480540937110222", -140},
    {1.6693811773758106317728259e+187, "16693811773758106", 188},
    {3.8172748064004042992056195e+286, "3817274806400404", 287},
    {4.7567723986566428719686719e+92, "4756772398656643", 93},
    {1.8975682276383314636297863e+264, "18975682276383315", 265},
    {1.0007400651199260482633020e-302, "1000740065119926", -301},
    {2.1617543982435644277635574e+208, "21617543982435644", 209},
    {1.1735585977737000291068900e+253, "11735585977737", 254},
    {1.7170843405094633027374584e+01, "17170843405094633", 2},
    {4.5363202764050064255920051e+236, "4536320276405006", 237},
    {4.2223584758969908129619345e-107, "4222358475896991", -106},
    {7.7880403440487687769564866e-245, "7788040344048769", -244},
    {8.6686868426201172373667840e+24, "8668686842620117", 25},
    {1.2306975295994954375809591e+149, "12306975295994954", 150},
    {2.0480883010335922647470033e-187, "20480883010335923", -186},
    {4.7560268254520548913737533e+201, "4756026825452055", 202},
    {1.3256563832942638454491341e-160, "13256563832942638", -159},
    {2.1124700624041332736000000e+19, "21124700624041333", 20},
    {1.8451778846983456547592030e+155, "18451778846983457", 156},
    {6.1759693409360822692960306e-145, "6175969340936082", -144},
    {1.6940612170133661360838695e-130, "16940612170133661", -129},
    {1.9428802314079116691035296e-51, "19428802314079117", -50},
    {8.8548169235918179569593975e-209, "8854816923591818", -208},
    {2.3417357403817481096837131e-265, "2341735740381748", -264},
    {4.7504489867703559286026800e+150, "4750448986770356", 151},
    {9.7100867681404628990488210e-53, "9710086768140463", -52},
    {1.1966476842782897167109496e-241, "11966476842782897", -240},
    {9.0759689592862819099657128e-97, "9075968959286282", -96},
    {1.9780131538729472630467312e+175, "19780131538729473", 176},
    {1.7194393749973833188997457e-305, "17194393749973833", -304},
    {6.1429120421121571452571652e+133, "6142912042112157", 134},
    {8.6483272214813403248652823e+220, "864832722148134", 221},
    {2.0313966410944209590519858e-243, "2031396641094421", -242},
    {3.6463826122244622856499130e+251, "36463826122244623", 252},
    {3.4335753231274373384534120e+123, "34335753231274373", 124},
    {6.5521094724576590289357209e+146, "6552109472457659", 147},
    {5.1240697483106770128511176e+103, "5124069748310677", 104},
    {4.6328683972447752614362865e-243, "46328683972447753", -242},
    {7.6113291138861565070834393e-107, "7611329113886157", -106},
    {8.2889958269783032991649729e-247, "8288995826978303", -246},
    {4.8068750865139401254704884e+143, "480687508651394", 144},
    {4.0909904343129022948039448e+303, "4090990434312902", 304},
    {2.1139302734036099408687210e+172, "211393027340361", 173},
    {3.7919191343928990299630532e+93, "3791919134392899", 94},
    {1.7206931849093282200750389e-21, "17206931849093282", -20},
    {1.6626648279663980302396845e-241, "1662664827966398", -240},
    {7.7682135111914409262204706e+75, "7768213511191441", 76},
    {2.4181368954093424665234633e-38, "24181368954093425", -37},
    {1.3374587270390061990296579e+303, "13374587270390062", 304},
    {1.9112917325567685414204463e-23, "19112917325567685", -22},
    {7.3367398497048516314090786e-178, "7336739849704852", -177},
    {3.1568707985017723748285793e+249, "31568707985017724", 250},
    {4.8513247473545297884025486e-53, "485132474735453", -52},
    {2.3627362321058086599392717e+35, "23627362321058087", 36},
    {2.1235141811702775290457185e+171, "21235141811702775", 172},
    {2.4410642025691354521065013e-179, "24410642025691355", -178},
    {4.8551116389070304000000000e+16, "485511163890703", 17},
    {3.3341997856582019159988368e-299, "3334199785658202", -298},
    {1.2572732894832213167713272e-233, "12572732894832213", -232},
    {6.0518684204651341325562064e+262, "6051868420465134", 263},
    {2.7928458866237050262970127e+246, "2792845886623705", 247},
    {1.4227365183718212068250478e-12, "14227365183718212", -11},
    {3.2277752098793120421596802e-188, "3227775209879312", -187},
    {2.9906616987613272292545567e-131, "2990661698761327", -130},
    {6.6327138269302122240847419e+148, "6632713826930212", 149},
    {4.6918953277171604611154682e+142, "46918953277171605", 143},
    {2.3424640107345662637791166e+72, "23424640107345663", 73},
    {5.1682703238665334759519563e-151, "51682703238665335", -150},
    {1.8183931462675342901954042e-103, "18183931462675343", -102},
    {3.8314852095138256664330443e-126, "38314852095138257", -125},
    {9.2009897689670636290846165e-82, "9200989768967064", -81},
    {1.8170023332023000795819473e-103, "18170023332023", -102},
    {2.2670828183044211784072901e-303, "22670828183044212", -302},
    {2.2781781652003199212823944e+157, "227817816520032", 158},
    {2.9810702300997132843561025e-241, "29810702300997133", -240},
    {7.5722811886202822274903149e+238, "7572281188620282", 239},
    {2.4231099708202270817077506e+163, "2423109970820227", 164},
    {1.0436709586106858217643415e+171, "10436709586106858", 172},
    {2.0980072593147143751501579e+123, "20980072593147144", 124},
    {2.2699923110215808999423960e+186, "2269992311021581", 187},
    {1.8454592122373507977951786e-276, "18454592122373508", -275},
    {6.2439765067331795323730196e-71, "62439765067331795", -70},
    {4.7180285957420582542151178e+122, "4718028595742058", 123},
    {3.7094381836018868442863552e+102, "3709438183601887", 103},
    {1.7736893824260541376671025e+238, "1773689382426054", 239},
    {8.4000007669090428006934946e-35, "8400000766909043", -34},
    {6.9208299140154518129837674e+95, "6920829914015452", 96},
    {5.5864956230293397596880745e-305, "558649562302934", -304},
    {1.0357205403568010772012253e-252, "10357205403568011", -251},
    {3.7903433040253947534453368e-304, "3790343304025395", -303},
    {4.3218046392538182878766825e+257, "43218046392538183", 258},
    {1.9248248657029554371115218e+77, "19248248657029554", 78},
    {6.2234817854399940975519653e-255, "6223481785439994", -254},
    {1.0002251478000623824802149e+96, "10002251478000624", 97},
    {1.3928118825176683690880083e-211, "13928118825176684", -210},
    {3.4663773607788723509655592e+41, "34663773607788724", 42},
    {5.1830344250382593556480000e+21, "5183034425038259", 22},
    {8.8591681436318433526491160e-117, "8859168143631843", -116},
    {4.0149974423204144901263188e+142, "40149974423204145", 143},
    {1.5051457156524247147936271e+149, "15051457156524247", 150},
    {1.8393084535648063808807534e-229, "18393084535648064", -228},
    {5.3162381186120043210267552e-249, "5316238118612004", -248},
    {5.5663631426526723145086450e-97, "5566363142652672", -96},
    {1.0876944434101294061102135e+307, "10876944434101294", 308},
    {6.9927906805125559201522917e+70, "6992790680512556", 71},
    {8.5335515286452947383210292e-61, "8533551528645295", -60},
    {3.5493891577697320394108703e+307, "3549389157769732", 308},
    {6.3732532355202429858708660e-189, "6373253235520243", -188},
    {6.0253826914038223114441005e+96, "6025382691403822", 97},
    {7.4576394771320002311618122e+250, "7457639477132", 251},
    {6.5666425762947608161097610e+166, "6566642576294761", 167},
    {8.3250148845262037064962344e-234, "8325014884526204", -233},
    {1.5608245010970659375000000e+14, "1560824501097066", 15},
    {2.1517920498870552090027974e+113, "21517920498870552", 114},
    {4.2530078553883114841191221e-23, "42530078553883115", -22},
    {1.3962889176294813461455600e+182, "13962889176294813", 183},
    {3.7372101734297899459651030e-292, "373721017342979", -291},
    {7.2351366353748766009666941e+219, "7235136635374877", 220},
    {1.4255149152080356174561449e-04, "14255149152080356", -3},
    {7.3200448132339446749952173e-41, "7320044813233945", -40},
    {1.9236824323424774712237580e-160, "19236824323424775", -159},
    {1.7779944983376350118754298e+219, "1777994498337635", 220},
    {3.4083822968924938207723431e-54, "3408382296892494", -53},
    {3.4600277597325536000000000e+17, "34600277597325536", 18},
    {2.4497935467980608314524428e+204, "24497935467980608", 205},
    {2.3217298078193552765230537e-99, "23217298078193553", -98},
    {5.2563740569328947538069323e+46, "5256374056932895", 47},
    {9.0869559734157003487593465e-228, "90869559734157", -227},
    {4.5344789072490204735122362e-104, "45344789072490205", -103},
    {1.0749070362061835937500000e+14, "10749070362061836", 15},
    {7.0356301479700543198944204e+81, "7035630147970054", 82},
    {5.5626588164683076129437368e-245, "5562658816468308", -244},
    {9.0285989050973350066785469e+302, "9028598905097335", 303},
    {6.3805978828712800142399182e+233, "638059788287128", 234},
    {3.5981553883978875191890792e-164, "35981553883978875", -163},
    {5.0457538600227164010116977e+266, "50457538600227164", 267},
    {2.0562533712589736679712199e+266, "20562533712589737", 267},
    {2.9257739462394938063743133e-281, "2925773946239494", -280},
    {1.9635676805189060631983744e+95, "1963567680518906", 96},
    {4.0547783411541268229631542e+121, "4054778341154127", 122},
    {5.6836451795706151042475988e+43, "5683645179570615", 44},
    {2.0139855905318513890227590e-203, "20139855905318514", -202},
    {2.0802489581670030748012719e-171, "2080248958167003", -170},
    {1.2252116185566564577418561e-111, "12252116185566565", -110},
    {2.2854126348137689399128515e-192, "2285412634813769", -191},
    {7.0980030879335912535904411e-239, "7098003087933591", -238},
    {2.1695485481902442950264223e-249, "21695485481902443", -248},
    {7.1995326353128388463825942e+267, "7199532635312839", 268},
    {1.2532788672605847352772144e+63, "12532788672605847", 64},
    {1.6854950527591953679451338e-190, "16854950527591954", -189},
    {2.0301085953203738760651025e-231, "2030108595320374", -230},
    {1.3236036468351298322909169e-23, "13236036468351298", -22},
    {1.2908630634933333105522768e-41, "12908630634933333", -40},
    {2.4427633214234168111547108e+271, "24427633214234168", 272},
    {2.8936732184372107715452767e-150, "2893673218437211", -149},
    {4.1569115710936584185556368e+201, "41569115710936584", 202},
    {4.9441618885151271108855115e-102, "4944161888515127", -101},
    {3.1242507488545791000751521e-87, "3124250748854579", -86},
    {4.6005823865856989385986877e+208, "4600582386585699", 209},
    {1.5264281927290508185289491e-306, "15264281927290508", -305},
    {2.0215822614800028395220522e+264, "2021582261480003", 265},
    {2.0199869745043370607064288e+154, "2019986974504337", 155},
    {1.3114983164254150809948574e-96, "1311498316425415", -95},
    {2.2984861411686185397713991e-134, "22984861411686185", -133},
    {1.4689578870812479825623993e-76, "1468957887081248", -75},
    {5.8575667866821832056861065e-196, "5857566786682183", -195},
    {1.7530338508799334244274131e-270, "17530338508799334", -269},
    {3.2708511035812927822121634e+138, "3270851103581293", 139},
    {1.5403955500446632247090247e+204, "15403955500446632", 205},
    {2.7368417458056354351877620e+110, "27368417458056354", 111},
    {4.6712369622324013071652764e-211, "4671236962232401", -210},
    {1.3843371501471881498317029e+104, "13843371501471881", 105},
    {3.1122945351043590401544897e-254, "3112294535104359", -253},
    {2.7820048401676971929134880e-257, "27820048401676972", -256},
    {2.6381842872974585062141106e-152, "26381842872974585", -151},
    {7.9101020378253183105999780e-139, "7910102037825318", -138},
    {1.0532030901143295183941465e+50, "10532030901143295", 51},
    {7.2384177868631366368300860e-47, "7238417786863137", -46},
    {3.7178257208164057118737088e-41, "37178257208164057", -40},
    {2.7738766413410624250419904e-279, "27738766413410624", -278},
    {8.7489324794601549179336883e-169, "8748932479460155", -168},
    {2.2957436668399397422261744e+169, "22957436668399397", 170},
    {7.0018289058470069397675960e+59, "7001828905847007", 60},
    {3.4316031730140435082417956e-13, "34316031730140435", -12},
    {1.3299334097378621025164614e-45, "13299334097378621", -44},
    {1.6359386297306727893806133e-164, "16359386297306728", -163},
    {8.7065413865146678680377002e+247, "8706541386514668", 248},
    {3.6312704615822554163028821e+211, "36312704615822554", 212},
    {9.1075510124654468676477100e+229, "9107551012465447", 230},
    {1.8802020812939434505770564e-225, "18802020812939435", -224},
    {2.9648727622241272126457302e-62, "2964872762224127", -61},
    {1.4582581663622240949113585e+261, "1458258166362224", 262},
    {9.9654121825480486409567431e-62, "9965412182548049", -61},
    {4.7136973920038644612221225e+185, "47136973920038645", 186},
    {1.5907510075804612096455129e-130, "15907510075804612", -129},
    {8.8917531952033596351037237e+210, "889175319520336", 211},
    {1.2010168376124457004874796e-256, "12010168376124457", -255},
    {2.1953985008236801113254341e-257, "219539850082368", -256},
    {3.1676027583254220650334439e-94, "3167602758325422", -93},
    {7.3700948253593269061430352e+177, "7370094825359327", 178},
    {2.9048230867692459470989329e-63, "2904823086769246", -62},
    {9.3458357569183314679618444e-92, "9345835756918331", -91},
    {4.6573287010976268415299704e-86, "4657328701097627", -85},
    {4.2199430557094959443852542e+119, "4219943055709496", 120},
    {1.5732034582369084428513868e+264, "15732034582369084", 265},
    {1.7716385434186620271160960e+250, "1771638543418662", 251},
    {2.0396302996530402739348511e-206, "20396302996530403", -205},
    {1.2536968662455987919990990e-146, "12536968662455988", -145},
    {1.4563161618585806032406826e+285, "14563161618585806", 286},
    {3.4545744062591879111301805e+306, "3454574406259188", 307},
    {2.0270585461178518038129767e+272, "20270585461178518", 273},
    {7.0257181667268067373449050e+126, "7025718166726807", 127},
    {4.9745874440339981241297070e-245, "4974587444033998", -244},
    {3.0139733642201286392740450e-189, "30139733642201286", -188},
    {4.9713243129178804498383658e-188, "49713243129178804", -187},
    {5.4342430137455667932375811e-84, "5434243013745567", -83},
    {6.0608761668879916102934951e+242, "6060876166887992", 243},
    {1.8788404870319477366469912e-152, "18788404870319477", -151},
    {2.2874779601847324086155836e-191, "22874779601847324", -190},
    {8.8757773330385348552215959e-152, "8875777333038535", -151},
    {2.0815278329198088659825851e-272, "2081527832919809", -271},
    {5.9592732941260875131769105e-271, "5959273294126088", -270},
    {6.9499380385081413969021135e-100, "6949938038508141", -99},
    {1.6479039405509049718709221e+118, "1647903940550905", 119},
    {1.9724151621516866323406754e+267, "19724151621516866", 268},
    {1.4468086078865072252597201e+00, "14468086078865072", 1},
    {2.1909609330636550339477253e+02, "2190960933063655", 3},
    {1.2598473343488223008534987e+01, "12598473343488223", 2},
    {2.4054746795332581994080541e-264, "2405474679533258", -263},
    {2.8568856750391146501950389e-100, "28568856750391147", -99},
    {8.6100820175010977760427790e-293, "8610082017501098", -292},
    {9.1983670800159322532389727e-90, "9198367080015932", -89},
    {1.5903329839729399364546130e-242, "159033298397294", -241},
    {3.3931097779213401880543462e-277, "339310977792134", -276},
    {2.8830918534285442352294922e+10, "28830918534285442", 11},
    {1.8627068336719115090133563e-251, "18627068336719115", -250},
    {1.1258250031481405654229704e-133, "11258250031481406", -132},
    {8.4654105758730480331607022e-274, "8465410575873048", -273},
    {4.6918237440562207405809841e-279, "4691823744056221", -278},
    {2.7339736919952255530335045e+77, "27339736919952256", 78},
    {2.1275951997983768564786364e+182, "2127595199798377", 183},
    {3.0557555203684797428234083e-239, "30557555203684797", -238},
    {7.8476285671394314426769345e+197, "7847628567139431", 198},
    {2.3244293403502309352963940e+240, "2324429340350231", 241},
    {5.1689993591026285045596831e+219, "51689993591026285", 220},
    {7.6330881395442979293885536e+62, "7633088139544298", 63},
    {1.5516001189814153007322742e+224, "15516001189814153", 225},
    {3.4302409553530367859471421e-169, "3430240955353037", -168},
    {8.6408866974583604246818728e-82, "864088669745836", -81},
    {1.2014383110966435140118288e-11, "12014383110966435", -10},
    {1.0580596018659279577987495e+164, "1058059601865928", 165},
    {8.1157240184259826405527037e+307, "8115724018425983", 308},
    {2.6355701342103037266203113e+81, "26355701342103037", 82},
    {5.3264051152535335732182712e+149, "5326405115253534", 150},
    {6.2949042540226055549900615e+283, "62949042540226056", 284},
    {3.4988913556864571151904609e-188, "3498891355686457", -187},
    {1.7259293952011205936373933e+224, "17259293952011206", 225},
    {1.5951125238987056443207558e+249, "15951125238987056", 250},
    {8.6359181732792670928404147e+109, "8635918173279267", 110},
    {7.6150772866270537896783099e-289, "7615077286627054", -288},
    {4.4963499990364421362239675e+229, "4496349999036442", 230},
    {6.7114554610986724517910112e-91, "6711455461098672", -90},
    {1.8483047333281187628176087e+62, "18483047333281188", 63},
    {1.3114470332738359952662756e+304, "1311447033273836", 305},
    {8.3093965844458523373326666e-292, "8309396584445852", -291},
    {9.4487028129615510632266499e+288, "9448702812961551", 289},
    {1.9855080225504894125079958e+137, "19855080225504894", 138},
    {5.2100785508907467587022311e-257, "5210078550890747", -256},
    {2.2050434754503143801222931e+157, "22050434754503144", 158},
    {5.7012059608756848679342695e-65, "5701205960875685", -64},
    {1.4166789347790452531636045e-125, "14166789347790453", -124},
    {3.1460768958158972220646059e-302, "3146076895815897", -301},
    {7.4175172614394906501113584e-73, "7417517261439491", -72},
    {7.8363805603377598413475419e-143, "783638056033776", -142},
    {3.4625468378749666810307661e-261, "34625468378749667", -260},
    {2.7247835477069082379988978e+181, "27247835477069082", 182},
    {7.3903718237628025950662006e+282, "7390371823762803", 283},
    {3.2969493982323711410765775e+44, "3296949398232371", 45},
    {5.8739985547601359154135137e-174, "5873998554760136", -173},
    {1.5102305918464656226434419e+155, "15102305918464656", 156},
    {2.6342593622540463533965330e+168, "26342593622540464", 169},
    {4.8801502652193656798468190e-169, "48801502652193657", -168},
    {1.0533856471602017788909427e-138, "10533856471602018", -137},
    {3.3900510746665931885524885e-161, "3390051074666593", -160},
    {5.0589213734632734996999682e+131, "50589213734632735", 132},
    {2.3701927629492077310715660e-38, "23701927629492077", -37},
    {7.3408725728197994806372539e+259, "73408725728198", 260},
    {2.0720958459884290141102526e+72, "2072095845988429", 73},
    {3.1057881192903083328531269e+280, "31057881192903083", 281},
    {2.8016498947358866866945592e-103, "28016498947358867", -102},
    {1.5490942631873602755496405e+29, "15490942631873603", 30},
    {3.7597607785794991477057066e-90, "3759760778579499", -89},
    {6.7621245978543640880454241e-103, "6762124597854364", -102},
    {2.3476213502082866076875954e+165, "23476213502082866", 166},
    {4.1940605011174798995071042e+37, "419406050111748", 38},
    {3.8218755203476838948307850e-284, "3821875520347684", -283},
    {3.0226747633581275804841213e+57, "30226747633581276", 58},
    {3.2420597398097703464173830e+28, "32420597398097703", 29},
    {4.7597401687420360348218369e+187, "4759740168742036", 188},
    {1.2599430885098601375393261e+211, "12599430885098601", 212},
    {1.9349066778830150561476248e-108, "1934906677883015", -107},
    {8.4565676226668523103082693e+305, "8456567622666852", 306},
    {2.0443010278095688435352566e-299, "20443010278095688", -298},
    {2.3573001700714282547290876e-95, "23573001700714283", -94},
    {9.1207469040881053842225598e-305, "9120746904088105", -304},
    {2.0943444278702615388819463e-28, "20943444278702615", -27},
    {1.3979119386897255305701928e-242, "13979119386897255", -241},
    {3.6064372481875486073967084e+27, "36064372481875486", 28},
    {2.9159725188794052124023438e+10, "29159725188794052", 11},
    {3.0180107632318812160000000e+18, "3018010763231881", 19},
    {7.3399645989762957646577623e+304, "7339964598976296", 305},
    {2.5921352936581047378656078e+172, "25921352936581047", 173},
    {1.6008213079317988360115841e-271, "16008213079317988", -270},
    {8.1055782281638257717717462e-191, "8105578228163826", -190},
    {8.5101659239798032698433696e-55, "8510165923979803", -54},
    {3.9606815568063894536272844e-293, "39606815568063895", -292},
    {2.2944602631598382577179346e-242, "22944602631598383", -241},
    {1.3357324531579438164476093e-219, "13357324531579438", -218},
    {1.2068788706634269745978816e+101, "1206878870663427", 102},
    {6.8201595666409900863208159e-54, "682015956664099", -53},
    {2.4352692842621496791546460e+39, "24352692842621497", 40},
    {3.8590969501250635128791666e-305, "38590969501250635", -304},
    {1.8737945735169083264601301e-218, "18737945735169083", -217},
    {1.7308495277502884990883765e+238, "17308495277502885", 239},
    {1.6699285579411321455086353e+186, "16699285579411321", 187},
    {2.1885428234514831328956097e+130, "21885428234514831", 131},
    {4.2130050580132271124964533e+235, "4213005058013227", 236},
    {2.7973301247559143789689794e+170, "27973301247559144", 171},
    {3.2239080634150049554475581e-195, "3223908063415005", -194},
    {1.1999626595522686631270820e-287, "11999626595522687", -286},
    {4.3225489203368714960051972e+293, "43225489203368715", 294},
    {1.3383092355817688763102139e-261, "13383092355817689", -260},
    {5.0201433414803998296674465e-158, "50201433414804", -157},
    {1.7646051859753900609384406e-43, "176460518597539", -42},
    {4.3662297427881017292200346e+26, "4366229742788102", 27},
    {1.0435293636724236070744732e-202, "10435293636724236", -201},
    {1.4961988918206978063349739e+40, "14961988918206978", 41},
    {9.7905094756490729373821928e+148, "9790509475649073", 149},
    {1.0482872801582993729634873e+180, "10482872801582994", 181},
    {3.7822231204004653535941143e-185, "37822231204004654", -184},
    {2.2153959330346505672222210e-232, "22153959330346506", -231},
    {1.8518837941864733081600000e+20, "18518837941864733", 21},
    {1.3563759957453942084270263e-141, "13563759957453942", -140},
    {4.7425148113321040352908697e+272, "4742514811332104", 273},
    {2.6189899590655944811910349e-07, "26189899590655945", -6},
    {9.2297578084380726521631084e-20, "9229757808438073", -19},
    {1.1744328408626375545286240e+245, "11744328408626376", 246},
    {1.7500540906683624626987283e-28, "17500540906683625", -27},
    {3.3558101615485268030010132e+130, "3355810161548527", 131},
    {1.8838293743329501723749172e-196, "18838293743329502", -195},
    {2.0265265178301138803362846e+05, "2026526517830114", 6},
    {4.9932813955020539733268043e-281, "4993281395502054", -280},
    {1.9690626281783510505053940e+304, "1969062628178351", 305},
    {6.1834063743180603999065069e-231, "618340637431806", -230},
    {7.4005521299947501056654684e-230, "740055212999475", -229},
    {8.0774156589522801707775900e+275, "807741565895228", 276},
    {1.6652409497245656289024659e+121, "16652409497245656", 122},
    {2.2872267379697596972756302e+193, "22872267379697597", 194},
    {2.4843179733183335577325576e-260, "24843179733183336", -259},
    {2.5729877951662816066378172e+158, "25729877951662816", 159},
    {9.2803094265023007352548206e-27, "9280309426502301", -26},
    {1.8688060765911396084580885e+222, "18688060765911396", 223},
    {1.3569346227282714802132637e-276, "13569346227282715", -275},
    {7.7210936113875060551267868e+138, "7721093611387506", 139},
    {8.6069188252797993236445447e-305, "8606918825279799", -304},
    {3.2711834646748013769757600e+97, "32711834646748014", 98},
    {3.6437000704507649203823071e-304, "3643700070450765", -303},
    {4.5875736959615678959133284e+37, "4587573695961568", 38},
    {1.0158275726942320718071417e+169, "1015827572694232", 170},
    {1.1055183974753768327105460e-49, "11055183974753768", -48},
    {2.7152799139447200788734548e+306, "271527991394472", 307},
    {1.4854683415192967486857638e-67, "14854683415192967", -66},
    {6.6591872248712373805088446e+104, "6659187224871237", 105},
    {8.8457665244882852747749817e+295, "8845766524488285", 296},
    {1.6622872603501984213650876e+232, "16622872603501984", 233},
    {2.5612525356878186946940506e+45, "25612525356878187", 46},
    {1.0412423972430479971751437e-221, "1041242397243048", -220},
    {7.5621860530954068841964787e-75, "7562186053095407", -74},
    {2.2777771324469868727596033e-29, "2277777132446987", -28},
    {7.3507214906645723907773548e-211, "7350721490664572", -210},
    {4.0435968415801539004931362e+264, "4043596841580154", 265},
    {1.0012767435861487889919883e+96, "10012767435861488", 97},
    {1.2068930075284970948914951e-231, "12068930075284971", -230},
    {2.4857117673269781270996620e+155, "2485711767326978", 156},
    {8.8926509163539434816785793e-88, "8892650916353943", -87},
    {3.3821002575622639660721934e-93, "3382100257562264", -92},
    {9.2440486840880582099034894e+97, "9244048684088058", 98},
    {2.7735555954018114308325966e-179, "27735555954018114", -178},
    {4.3754573720998926941799168e+236, "4375457372099893", 237},
    {7.9251559697018696726841019e-98, "792515596970187", -97},
    {5.8510349145511919171879538e-27, "5851034914551192", -26},
    {3.6176364538051981621617107e-118, "3617636453805198", -117},
    {1.2260685621474487462968243e-275, "12260685621474487", -274},
    {4.3806186925042518023802632e+294, "4380618692504252", 295},
    {6.4584674210318250000000000e+14, "6458467421031825", 15},
    {1.3195997410170333733200390e-68, "13195997410170334", -67},
    {5.8868542126542250990813559e+36, "5886854212654225", 37},
    {1.6148513066991176730542080e+24, "16148513066991177", 25},
    {2.0992977921807052627000929e+207, "20992977921807053", 208},
    {3.1667429952052167416377740e-145, "31667429952052167", -144},
    {5.7369361691533985574070554e-174, "5736936169153399", -173},
    {6.4637245238944789378003874e-87, "6463724523894479", -86},
    {9.0198174037327772200741098e+84, "9019817403732777", 85},
    {1.0318999957855085058952355e-87, "10318999957855085", -86},
    {5.9470082044383856902158889e-148, "5947008204438386", -147},
    {4.8355861373748493864603678e-160, "48355861373748494", -159},
    {2.5485395899580117049843388e-82, "25485395899580117", -81},
    {6.1855423813870417922086685e-227, "6185542381387042", -226},
    {1.2554093626026107742422643e+284, "12554093626026108", 285},
    {7.9679780789930742444525968e-299, "7967978078993074", -298},
    {6.8404479494612847197566118e-190, "6840447949461285", -189},
    {1.4436392419163873794986160e+172, "14436392419163874", 173},
    {6.1791201467513382521016053e+66, "6179120146751338", 67},
    {1.2601065859574771406561130e-33, "12601065859574771", -32},
    {7.1722161015705542403570578e-265, "7172216101570554", -264},
    {1.6392849533035759080500238e-264, "1639284953303576", -263},
    {3.4020793152811861866276733e-292, "3402079315281186", -291},
    {1.2922482727825151496722150e-86, "12922482727825151", -85},
    {1.5241176775915191530135830e-297, "15241176775915192", -296},
    {1.0702995135485561284967137e+120, "10702995135485561", 121},
    {1.4223509984570248804348635e-270, "14223509984570249", -269},
    {2.3615524081120618529050376e-216, "2361552408112062", -215},
    {1.3751445633070499324129258e-248, "137514456330705", -247},
    {5.1594984089681402630488761e+180, "515949840896814", 181},
    {1.8086300469902875830354162e-250, "18086300469902876", -249},
    {8.3578786214286951999092854e+121, "8357878621428695", 122},
    {4.5007766778323250438632234e-31, "4500776677832325", -30},
    {4.3870734291879844768905705e-146, "43870734291879845", -145},
    {7.0387812446159587250370844e-133, "7038781244615959", -132},
    {1.7838900724586305299159920e+212, "17838900724586305", 213},
    {1.2862423740125451247874784e-177, "12862423740125451", -176},
    {7.0591224672710058972660253e+271, "7059122467271006", 272},
    {6.8368203163755025311019797e+273, "6836820316375503", 274},
    {4.8514098998688388978308386e-190, "4851409899868839", -189},
    {6.0601160896345646100832006e+234, "60601160896345646", 235},
    {2.3258831871415177458925313e-36, "23258831871415177", -35},
    {1.3414766275321517136906065e+99, "13414766275321517", 100},
    {3.0430494267740615857562148e+226, "30430494267740616", 227},
    {1.8325720652129132723298749e-230, "18325720652129133", -229},
    {2.9364231161565113339405497e+82, "29364231161565113", 83},
    {3.8504590705921742402426652e-56, "38504590705921742", -55},
    {2.2139608859416079243306535e+99, "2213960885941608", 100},
    {1.9534966245429062615815744e-91, "19534966245429063", -90},
    {8.3872445539825843036663373e+115, "8387244553982584", 116},
    {3.6422846978576025600000000e+17, "36422846978576026", 18},
    {3.9359650279860384915378471e+52, "39359650279860385", 53},
    {1.2640301769466137718691356e-254, "12640301769466138", -253},
    {1.5480777174772656293633128e+37, "15480777174772656", 38},
    {3.4896109803145566094488477e-19, "34896109803145566", -18},
    {1.7911528990804104614257812e+11, "17911528990804105", 12},
    {5.9606714832765088317009354e+85, "5960671483276509", 86},
    {1.0718891781709480979353589e+265, "10718891781709481", 266},
    {4.9761007601058607101440430e+09, "4976100760105861", 10},
    {1.1087338203132853623392829e+27, "11087338203132854", 28},
    {7.5716517696266696767275619e+211, "757165176962667", 212},
    {1.6878879199572990341361096e+200, "1687887919957299", 201},
    {4.3696500210640591446564772e+45, "4369650021064059", 46},
    {1.5661835715538007870547793e-22, "15661835715538008", -21},
    {4.7665180014625382244530043e+99, "4766518001462538", 100},
    {3.1482621866224730363872480e-97, "3148262186622473", -96},
    {2.7453612925241266402484252e+54, "27453612925241266", 55},
    {9.7860005183828625749387671e+67, "9786000518382863", 68},
    {3.0216568654038449174289367e-290, "3021656865403845", -289},
    {7.3642468357002490212242192e+301, "7364246835700249", 302},
    {2.7589196616872305305069483e+274, "27589196616872305", 275},
    {1.1851478042828522985770785e+227, "11851478042828523", 228},
    {2.1694150392291598789099472e-36, "216941503922916", -35},
    {4.9767559850086940593356800e+23, "4976755985008694", 24},
    {8.4959978494404383020467319e-299, "8495997849440438", -298},
    {2.4661407161714552994159504e-217, "24661407161714553", -216},
    {2.4147778919942843162243751e+270, "24147778919942843", 271},
    {5.6534861226409909765379228e-306, "5653486122640991", -305},
    {1.0463369229845290359672654e+138, "1046336922984529", 139},
    {5.9128451191455319065996242e+187, "5912845119145532", 188},
    {1.2134785653562834858894348e+08, "12134785653562835", 9},
    {7.1338848422818521793815214e-62, "7133884842281852", -61},
    {6.9852196282000048002808151e-222, "6985219628200005", -221},
    {5.2351987176941898943634838e+38, "523519871769419", 39},
    {7.3386916004742739522249591e-237, "7338691600474274", -236},
    {2.2030960263033159195693159e-169, "2203096026303316", -168},
    {3.7176517362831362354127537e-129, "3717651736283136", -128},
    {4.0729971365157841183934009e+159, "4072997136515784", 160},
    {2.6806482857007053043153473e+211, "26806482857007053", 212},
    {6.0627720011820159634458150e+148, "6062772001182016", 149},
    {6.4525907054598556508393117e+59, "6452590705459856", 60},
    {1.4978980857673438098187177e-27, "14978980857673438", -26},
    {4.4460775206913667111910198e+227, "4446077520691367", 228},
    {7.9919478862905847876530609e+64, "7991947886290585", 65},
    {4.0638580960278959872764990e+142, "4063858096027896", 143},
    {1.5422701522277966313471748e+125, "15422701522277966", 126},
    {9.7287077901227743011458768e-98, "9728707790122774", -97},
    {8.2011867433488520669435238e+248, "8201186743348852", 249},
    {8.6405340947678398844160009e-57, "864053409476784", -56},
    {1.1799764786330796271706941e+70, "11799764786330796", 71},
    {1.4255953197495302551430653e-99, "14255953197495303", -98},
    {5.5179644504304914517103188e+177, "55179644504304915", 178},
    {1.6731039582208882253894941e-45, "16731039582208882", -44},
    {2.5803479865069307514786374e+190, "25803479865069308", 191},
    {8.2246980079166479683982816e+158, "8224698007916648", 159},
    {5.7065064580322540090619376e+55, "5706506458032254", 56},
    {3.3916220072773060050553105e+34, "3391622007277306", 35},
    {7.8976834171763453704672564e-57, "7897683417176345", -56},
    {3.1616335052411854373143818e-70, "31616335052411854", -69},
    {2.4084350653629978542980726e-79, "2408435065362998", -78},
    {3.1796390094196385584928308e-114, "31796390094196386", -113},
    {3.3679562738127230989977751e-32, "3367956273812723", -31},
    {8.2092268727324759936518730e+202, "8209226872732476", 203},
    {5.2615360798375585087023484e+133, "5261536079837559", 134},
    {5.1052403602746888683827055e-121, "5105240360274689", -120},
    {8.8555700431165224238205838e-184, "8855570043116522", -183},
    {2.6183437587632306877215066e+33, "26183437587632307", 34},
    {1.3897013775332313881562958e+277, "13897013775332314", 278},
    {7.7196907049059158270412980e-91, "7719690704905916", -90},
    {6.3856657429426327564209255e-105, "6385665742942633", -104},
    {1.0871893316136393233933923e+48, "10871893316136393", 49},
    {4.6617043472385917317354362e-39, "4661704347238592", -38},
    {1.0857053294548400974659270e-14, "10857053294548401", -13},
    {7.9034199600475798982355714e+245, "790341996004758", 246},
    {8.6133246979511230401496747e-181, "8613324697951123", -180},
    {3.3164832352743159244426920e+247, "3316483235274316", 248},
    {1.8635868103056234112073477e+154, "18635868103056234", 155},
    {1.0984063786465515406801567e+205, "10984063786465515", 206},
    {2.5540224116384657206358088e+75, "25540224116384657", 76},
    {3.4148197476369326819892437e+123, "34148197476369327", 124},
    {6.7000348456930662916841084e-133, "6700034845693066", -132},
    {6.9640530206379418319941283e-300, "6964053020637942", -299},
    {3.6588134742474291839368521e-19, "3658813474247429", -18},
    {5.7262320566275613020835110e-80, "5726232056627561", -79},
    {6.0015888178531465595288565e+189, "6001588817853147", 190},
    {1.4922907390081682545717839e-85, "14922907390081683", -84},
    {3.2803562311366419614883250e-103, "3280356231136642", -102},
    {4.2473192667936709471149550e+74, "4247319266793671", 75},
    {6.2987897483565026581674014e+42, "6298789748356503", 43},
    {1.4590181822428439878427694e-231, "1459018182242844", -230},
    {1.8216530557334523216563583e+230, "18216530557334523", 231},
    {8.2274201571224172461293071e-19, "8227420157122417", -18},
    {1.1750553312856029764590757e+243, "1175055331285603", 244},
    {4.9571052481300047791918975e+306, "4957105248130005", 307},
    {1.1259329148732791638351459e-39, "11259329148732792", -38},
    {6.5960623829391173758641918e+108, "6596062382939117", 109},
    {1.6390723537168329830687522e-75, "1639072353716833", -74},
    {8.1413124702942930740032447e+85, "8141312470294293", 86},
    {3.9773530136813656969544290e-171, "39773530136813657", -170},
    {1.7773141157402320932011678e+227, "1777314115740232", 228},
    {1.0245276736832646778775066e+48, "10245276736832647", 49},
    {2.0824804274777382232204776e-24, "20824804274777382", -23},
    {1.5878127911501423894520618e-28, "15878127911501424", -27},
    {6.5718664950166117386275521e+221, "6571866495016612", 222},
    {1.3445401911572997306385463e-104, "13445401911572997", -103},
    {1.8051458248197781637074055e+204, "18051458248197782", 205},
    {7.9954548231886621685321316e-168, "7995454823188662", -167},
    {4.2952184404783083316309621e-129, "42952184404783083", -128},
    {8.0068461217053733572220169e-157, "8006846121705373", -156},
    {2.4980434803229741208580177e-272, "2498043480322974", -271},
    {2.3601418841284359432679805e+137, "2360141884128436", 138},
    {6.2686592523317990000000000e+15, "6268659252331799", 16},
    {7.5937332964855980025225944e+274, "7593733296485598", 275},
    {4.8171777149612305547315654e-187, "4817177714961231", -186},
    {1.3226889618037235058375198e+306, "13226889618037235", 307},
    {3.0293180136622136752814152e-14, "30293180136622137", -13},
    {1.7003516754245220469252405e-215, "1700351675424522", -214},
    {1.2881385525909983882159275e+211, "12881385525909984", 212},
    {2.3874273354544087836396311e+44, "23874273354544088", 45},
    {6.1033046988326740429382328e+178, "6103304698832674", 179},
    {1.8193623509863789062500000e+12, "1819362350986379", 13},
    {2.4275938903638383444625833e-23, "24275938903638383", -22},
    {5.0066074937915686543008789e-305, "5006607493791569", -304},
    {7.7125389711906105997473598e-132, "771253897119061", -131},
    {1.3534931420816396325314223e+195, "13534931420816396", 196},
    {3.4334007519875684094149689e+226, "34334007519875684", 227},
    {2.4974438268051842814081525e+45, "24974438268051843", 46},
    {1.9223049678813972882174072e+56, "19223049678813973", 57},
    {7.7701701775739923704599439e+30, "7770170177573992", 31},
    {2.8739625970715427142403233e-183, "28739625970715427", -182},
    {2.9644579320895271663142964e-235, "2964457932089527", -234},
    {4.2687078599514017540408469e-292, "4268707859951402", -291},
    {7.2519217799230910912044809e-75, "7251921779923091", -74},
    {1.1809228005401827975928554e-163, "11809228005401828", -162},
    {4.2822596547742984622129617e-74, "42822596547742985", -73},
    {3.8298628578714073390636292e+186, "38298628578714073", 187},
    {2.8358896611209657950232650e-22, "2835889661120966", -21},
    {6.5812356538509998787498645e-42, "6581235653851", -41},
    {1.1580425213147963253589113e-208, "11580425213147963", -207},
    {9.7062726079453389107515382e+117, "9706272607945339", 118},
    {6.6556760741012298941448902e+274, "665567607410123", 275},
    {8.4921479547032170295213258e+91, "8492147954703217", 92},
    {3.3672155481596172734743790e-305, "33672155481596173", -304},
    {3.4676577311816828044083525e+116, "3467657731181683", 117},
    {8.1575733120963580502851125e-111, "8157573312096358", -110},
    {6.5784003198941982693030404e+69, "6578400319894198", 70},
    {1.2894513448834388794940333e+180, "12894513448834389", 181},
    {3.3082393660868762317710381e+128, "33082393660868762", 129},
    {1.4682660466566877551418473e+230, "14682660466566878", 231},
    {4.1412022521276433762894862e-35, "41412022521276434", -34},
    {1.2097139310096780366471768e-277, "1209713931009678", -276},
    {5.5415198032948563220140271e+52, "5541519803294856", 53},
    {9.1862316902218095990012106e+104, "918623169022181", 105},
    {4.3534002079859130056131108e-38, "4353400207985913", -37},
    {4.5177380703572138789810015e-151, "4517738070357214", -150},
    {1.1944809077679514026123866e+168, "11944809077679514", 169},
    {5.4681253943486291479991641e+247, "5468125394348629", 248},
    {5.9813293308426290770796665e-237, "5981329330842629", -236},
    {3.6889735979070210012297348e-167, "3688973597907021", -166},
    {1.2711431386369470544206816e-106, "1271143138636947", -105},
    {9.9681276925873321405745817e+35, "9968127692587332", 36},
    {3.0656402451239689699396571e-164, "3065640245123969", -163},
    {1.5224425502883859095959451e+01, "15224425502883859", 2},
    {6.1999749417382967234265929e-38, "6199974941738297", -37},
    {2.0197217772615804784823436e-156, "20197217772615805", -155},
    {7.2257146077632624936010951e-25, "72257146077632625", -24},
    {6.7201879335031587474505063e+201, "6720187933503159", 202},
    {9.0508943624269670506435459e-61, "9050894362426967", -60},
    {2.4300314920184525253258255e+291, "24300314920184525", 292},
    {1.1123379105009321594238281e+11, "11123379105009322", 12},
    {3.6526775377797453634316874e-159, "36526775377797454", -158},
    {3.4548068305496650619599917e-290, "3454806830549665", -289},
    {2.9312716438975457839646112e-74, "29312716438975458", -73},
    {3.0242233496696897876414935e-298, "30242233496696898", -297},
    {5.7982082089579874425955147e+238, "5798208208957987", 239},
    {2.0234086448158756426368016e-59, "20234086448158756", -58},
    {2.6396504243790784344130149e+210, "26396504243790784", 211},
    {1.1900756146285760413643744e+282, "1190075614628576", 283},
    {1.8406754244898765174091110e-37, "18406754244898765", -36},
    {1.1557967936586493229162510e+32, "11557967936586493", 33},
    {8.5506173247298145407758452e-275, "8550617324729815", -274},
    {2.8378425179917745229729739e+148, "28378425179917745", 149},
    {2.9320935963376388069071541e-222, "2932093596337639", -221},
    {7.6930977943111109798289529e+158, "7693097794311111", 159},
    {2.0915596880097873692494690e-281, "20915596880097874", -280},
    {9.5573947296943068638011358e+211, "9557394729694307", 212},
    {5.7826656401217575678210008e-34, "57826656401217576", -33},
    {1.8603387900214511660816823e-217, "1860338790021451", -216},
    {4.6583785881206695309138920e-253, "46583785881206695", -252},
    {4.3277660624078773909471763e+258, "4327766062407877", 259},
    {5.3706972398485216251612887e-162, "5370697239848522", -161},
    {2.0915066968696391126279402e-72, "2091506696869639", -71},
    {1.8682837432657662940692024e+132, "18682837432657663", 133},
    {8.1423838798035328943650758e-120, "8142383879803533", -119},
    {1.6455326460493684758492411e+193, "16455326460493685", 194},
    {6.3721801281738190636972820e-257, "6372180128173819", -256},
    {3.5078098426013336855821008e-200, "35078098426013337", -199},
    {1.3189130248080746148627867e+161, "13189130248080746", 162},
    {7.9768431953295045094617282e-273, "7976843195329505", -272},
    {1.9137445249528824055308912e-87, "19137445249528824", -86},
    {1.2304129884132407005593412e+232, "12304129884132407", 233},
    {2.5109880043674101116254199e+238, "251098800436741", 239},
    {7.3122952338407865822694609e+155, "7312295233840787", 156},
    {1.1478766963134165169800222e-290, "11478766963134165", -289},
    {3.7327616705551366367895584e+195, "37327616705551366", 196},
    {7.0662553441067648503903150e-103, "7066255344106765", -102},
    {2.9362636797785042692122179e-124, "29362636797785043", -123},
    {4.2438732308458787753176367e+139, "4243873230845879", 140},
    {1.2220153722741728500381925e+160, "12220153722741729", 161},
    {6.6278100479997192223062864e+201, "6627810047999719", 202},
    {2.0507539862173454301632827e+243, "20507539862173454", 244},
    {2.6754404737472400289334819e+220, "267544047374724", 221},
    {1.8375052173896010750234464e-43, "1837505217389601", -42},
    {1.2067004986594884405885752e-15, "12067004986594884", -14},
    {1.6315889016147728213765897e+53, "16315889016147728", 54},
    {1.0759174592196475375647295e-131, "10759174592196475", -130},
    {3.6194801052954213776916100e+137, "36194801052954214", 138},
    {1.2130584708286403588578153e-137, "12130584708286404", -136},
    {3.4557473321958684091611516e+64, "34557473321958684", 65},
    {6.7052430324981213976334585e-257, "6705243032498121", -256},
    {1.3063615185486764178651458e-53, "13063615185486764", -52},
    {1.4577649221915147259923020e+69, "14577649221915147", 70},
    {9.2875157478708408048668664e+244, "9287515747870841", 245},
    {5.9769822794446531968355782e-110, "5976982279444653", -109},
    {6.3142646583873732015490532e+05, "6314264658387373", 6},
    {1.2765300526333540830010641e+65, "1276530052633354", 66},
    {7.1588656923337764256330493e+279, "7158865692333776", 280},
    {4.9860465312656457737244391e-132, "4986046531265646", -131},
    {3.6796274382048545739371254e-224, "36796274382048546", -223},
    {5.1724990764435983027745602e-178, "5172499076443598", -177},
    {2.8889728379104753311503736e-145, "28889728379104753", -144},
    {4.2278478923341770725730518e-10, "4227847892334177", -9},
    {4.4466144932641309646175184e+145, "4446614493264131", 146},
    {3.2293159536859883072884586e+118, "32293159536859883", 119},
    {6.6208772834105400579090321e-40, "662087728341054", -39},
    {2.6033521655403048660709379e-301, "2603352165540305", -300},
    {2.2225921852449364059690220e+209, "22225921852449364", 210},
    {2.2741504454661283369237178e+235, "22741504454661283", 236},
    {9.1988928870783096443189655e+123, "919889288707831", 124},
    {7.3474734006044462881773535e+94, "7347473400604446", 95},
    {5.7672190207394109908171379e+202, "5767219020739411", 203},
    {1.7650343559710484921407276e-274, "17650343559710485", -273},
    {8.7015498336403446664962932e+239, "8701549833640345", 240},
    {1.3026859600582796071732638e-123, "13026859600582796", -122},
    {4.0688824205060390382495467e+276, "4068882420506039", 277},
    {4.5504053522881568659590386e+256, "4550405352288157", 257},
    {7.0781939323565234299989004e+208, "7078193932356523", 209},
    {6.6660466334116338424769347e+40, "6666046633411634", 41},
    {8.8123269230373691075964634e-102, "8812326923037369", -101},
    {1.8393294739799014693287177e-21, "18393294739799015", -20},
    {1.4872495802540397271513939e+06, "14872495802540397", 7},
    {1.0424084583880004679828143e+246, "10424084583880005", 247},
    {7.3400581463543197535035800e-177, "734005814635432", -176},
    {4.6262817666739443359375000e+12, "4626281766673944", 13},
    {2.4239731030106242807697418e-58, "24239731030106243", -57},
    {3.6504959814460810475015457e+167, "3650495981446081", 168},
    {2.4102108900402246875000000e+14, "24102108900402247", 15},
    {1.8752867409219501321281926e-120, "187528674092195", -119},
    {3.8713303364781792845384147e-165, "38713303364781793", -164},
    {1.6696006557014180163634357e+180, "1669600655701418", 181},
    {7.6497803195572644910718199e+123, "7649780319557264", 124},
    {8.4808222711736889259028952e+255, "8480822271173689", 256},
    {3.8174393425410180475495122e+100, "3817439342541018", 101},
    {1.4424644685834057549913756e+175, "14424644685834058", 176},
    {7.9062643784558146082474419e-228, "7906264378455815", -227},
    {1.2616939969634937369846739e+04, "12616939969634937", 5},
    {1.2539224148390033324150941e-13, "12539224148390033", -12},
    {6.7850637076830804389852213e-305, "678506370768308", -304},
    {4.4681798871702063071413660e-11, "4468179887170206", -10},
    {5.3144527282076718253398552e-238, "5314452728207672", -237},
    {1.6694096739833358393503516e-16, "16694096739833358", -15},
    {1.5068178295183509659243563e+258, "1506817829518351", 259},
    {1.2094670716345992247931745e-89, "12094670716345992", -88},
    {6.9867218147074302529672320e+96, "698672181470743", 97},
    {5.5579321333758579851340792e+107, "5557932133375858", 108},
    {4.8196894797566050127954851e-255, "4819689479756605", -254},
    {2.5431684295166410009100430e+262, "2543168429516641", 263},
    {4.4983205042593369210510715e-14, "4498320504259337", -13},
    {8.5462840610635008900976856e+155, "8546284061063501", 156},
    {5.6970971056999963813859887e-249, "5697097105699996", -248},
    {2.4415098541720361752698897e-209, "2441509854172036", -208},
    {9.2126019071796181014438322e-47, "9212601907179618", -46},
    {4.0096123007313456259544128e-113, "40096123007313456", -112},
    {5.7657878194493934929279115e+162, "57657878194493935", 163},
    {4.3076206676313216907462846e-262, "43076206676313217", -261},
    {8.7993904983025731065541475e-233, "8799390498302573", -232},
    {4.4682944012693356347827685e+72, "4468294401269336", 73},
    {1.9766914981751430325184160e+41, "1976691498175143", 42},
    {1.8928809562720254092047387e+235, "18928809562720254", 236},
    {3.5153057730759563990471102e+306, "35153057730759564", 307},
    {1.2238008622040985556774641e+150, "12238008622040986", 151},
    {9.0861583562153267202637193e+76, "9086158356215327", 77},
    {6.8270833968709258167496289e-251, "6827083396870926", -250},
    {1.0144928383823737147475435e+251, "10144928383823737", 252},
    {7.0596714667535778743137561e+49, "7059671466753578", 50},
    {5.8306230729411924658882540e+91, "58306230729411925", 92},
    {2.0893103576306870205533818e+67, "2089310357630687", 68},
    {2.3401757131123345315708741e+145, "23401757131123345", 146},
    {2.2244069094851902396222075e-158, "22244069094851902", -157},
    {2.9706773145224330873769111e+196, "2970677314522433", 197},
    {2.5689345224126226308397596e+266, "25689345224126226", 267},
    {1.6635142482347770996093750e+12, "1663514248234777", 13},
    {4.5313208014646703286680542e+256, "453132080146467", 257},
    {3.3758020452617548010120470e+274, "33758020452617548", 275},
    {7.5565957203960030020137506e+181, "7556595720396003", 182},
    {7.4045687371048311746876994e-106, "7404568737104831", -105},
    {6.2637775235109892463567402e-229, "6263777523510989", -228},
    {3.7214219045829773296171032e+91, "3721421904582977", 92},
    {1.7035579839389336926260933e+53, "17035579839389337", 54},
    {2.3439131909781551253336985e+262, "2343913190978155", 263},
    {7.2505577229664973271241306e+43, "7250557722966497", 44},
    {3.1158104063455410455084325e-55, "3115810406345541", -54},
    {1.6547647687744487338750406e+88, "16547647687744487", 89},
    {3.8531603620789666931047137e+27, "38531603620789667", 28},
    {1.1109703348722180748867547e-198, "1110970334872218", -197},
    {2.4036594893496085121531449e-25, "24036594893496085", -24},
    {6.6980580719618731752336659e-135, "6698058071961873", -134},
    {8.2158504183551115358300640e+275, "8215850418355112", 276},
    {8.2175063004892445209615430e+167, "8217506300489245", 168},
    {1.9505549312091063318597519e+245, "19505549312091063", 246},
    {4.4760013747348606815965606e-212, "44760013747348607", -211},
    {4.0662714922255395604728855e-92, "40662714922255396", -91},
    {6.2682237582975305176940353e-267, "62682237582975305", -266},
    {2.4463862773618743437193104e+304, "24463862773618743", 305},
    {1.6090834305704465146686263e+276, "16090834305704465", 277},
    {8.7594383813119407083901367e+218, "875943838131194", 219},
    {2.0630880356546784342674170e+66, "20630880356546784", 67},
    {1.0925470405908664823183677e+42, "10925470405908665", 43},
    {1.7311599060319016425686159e-304, "17311599060319016", -303},
    {5.8450226655391197796700425e+262, "584502266553912", 263},
    {4.6663656705287636530921518e-18, "4666365670528764", -17},
    {6.8773285734425444623982864e-304, "68773285734425445", -303},
    {5.7682024636731632137976460e-87, "5768202463673163", -86},
    {3.4448197747944128120539226e-205, "3444819774794413", -204},
    {1.6610986927548945753955932e-28, "16610986927548946", -27},
    {2.5602986676803744143815542e-33, "25602986676803744", -32},
    {1.5531537773343129134089835e-09, "1553153777334313", -8},
    {3.9416366636352347469243440e+236, "39416366636352347", 237},
    {4.8995162479715024388913303e+60, "48995162479715024", 61},
    {1.4584285249540800950361820e-258, "145842852495408", -257},
    {9.3314115999061315028603964e-88, "9331411599906132", -87},
    {1.5159796196368010923734077e-110, "1515979619636801", -109},
    {1.2440800904182418428989214e+266, "12440800904182418", 267},
    {1.6879145252253318156481716e-216, "16879145252253318", -215},
    {3.6533207572990018146580194e-105, "3653320757299002", -104},
    {8.2160613841859080110249614e-268, "8216061384185908", -267},
    {5.6145011156115590124224889e-192, "5614501115611559", -191},
    {1.4103404605344686882878356e+262, "14103404605344687", 263},
    {3.3616144684724527210873917e+271, "33616144684724527", 272},
    {8.8008305839826298703545150e-244, "880083058398263", -243},
    {1.7161144253508833590572770e-159, "17161144253508834", -158},
    {1.0723291585705385402753279e-23, "10723291585705385", -22},
    {4.6906470486691717841238819e+48, "4690647048669172", 49},
    {4.1188217126021186302363909e+290, "41188217126021186", 291},
    {1.2282057882189281614466055e+253, "12282057882189282", 254},
    {4.6510448545579610136922797e+257, "4651044854557961", 258},
    {8.8331740396947042280145353e-23, "8833174039694704", -22},
    {1.9280431369457002639232060e-62, "19280431369457003", -61},
    {1.8570096132761347620835521e-241, "18570096132761348", -240},
    {7.6508948113891517741769080e-08, "7650894811389152", -7},
    {1.4889745782629727222700586e-226, "14889745782629727", -225},
    {8.5301724739951787798167298e+103, "8530172473995179", 104},
    {5.0903391218624002762132879e-141, "50903391218624", -140},
    {1.0656520165181298251805788e+273, "10656520165181298", 274},
    {1.1208437719097923718310062e+206, "11208437719097924", 207},
    {6.1295416378059357024521697e-130, "6129541637805936", -129},
    {1.1038669130534252322314400e-306, "11038669130534252", -305},
    {8.2717921151319422426474539e-292, "8271792115131942", -291},
    {2.8221439945149477021414524e-43, "28221439945149477", -42},
    {1.9807334154903027363039971e+116, "19807334154903027", 117},
    {1.7922662634885303446425092e+168, "17922662634885303", 169},
    {3.0325963455965705447460996e+155, "30325963455965705", 156},
    {1.6461879867960011096311622e+278, "1646187986796001", 279},
    {3.2173195770534552440972313e-257, "32173195770534552", -256},
    {2.4866748357530626173035077e+113, "24866748357530626", 114},
    {1.3500208284634864000000000e+17, "13500208284634864", 18},
    {1.6044942239662572122601599e-65, "16044942239662572", -64},
    {1.1277418145723059262051728e+50, "1127741814572306", 51},
    {2.3489204790949634654336965e+122, "23489204790949635", 123},
    {2.6008095663864672664747015e-186, "26008095663864673", -185},
    {3.7419774848834990154819586e-278, "3741977484883499", -277},
    {1.3782408708255448035641158e+259, "13782408708255448", 260},
    {2.3482785483162170195668786e-298, "2348278548316217", -297},
    {3.7180242438838276733200604e+292, "37180242438838277", 293},
    {7.6343278359867041950183055e+234, "7634327835986704", 235},
    {2.2306175785647601729377159e+170, "22306175785647602", 171},
    {2.3733855235875910749392784e-197, "2373385523587591", -196},
    {1.8801596994042762691451019e-171, "18801596994042763", -170},
    {4.2594023581058204905009805e-11, "42594023581058205", -10},
    {2.0784286703268548740349063e+108, "2078428670326855", 109},
    {8.4366786568430953735297774e+164, "8436678656843095", 165},
    {4.1931913907129462265521042e+283, "4193191390712946", 284},
    {1.0466639106081284096351115e+181, "10466639106081284", 182},
    {4.6953521373059748526817453e+274, "4695352137305975", 275},
    {1.3575260684157400609602984e-98, "135752606841574", -97},
    {4.1023383513483974467911680e+24, "41023383513483974", 25},
    {5.3773280928700256000000000e+16, "5377328092870026", 17},
    {6.3242382228562711588280833e+288, "6324238222856271", 289},
    {3.6819066998894434458375081e-70, "36819066998894434", -69},
    {1.9842732539517534482737073e+147, "19842732539517534", 148},
    {1.3536269444375062625410817e+220, "13536269444375063", 221},
    {6.6927896686737428689630216e-291, "6692789668673743", -290},
    {1.4758240547081572491272847e-209, "14758240547081572", -208},
    {2.2500594710702426106830153e+249, "22500594710702426", 250},
    {8.2389073321829509170576445e-164, "8238907332182951", -163},
    {7.1765872725133281178289659e-273, "7176587272513328", -272},
    {5.3989854809956231014019987e+124, "5398985480995623", 125},
    {5.4000640609162489149961719e+290, "5400064060916249", 291},
    {5.6602498871045816731547742e-95, "5660249887104582", -94},
    {2.4348493946120194329283854e+180, "24348493946120194", 181},
    {7.2365696495360668356768073e-278, "7236569649536067", -277},
    {5.1649347559337740403558829e+307, "5164934755933774", 308},
    {1.3589252229958428222877877e-128, "13589252229958428", -127},
    {8.9882062270086750332589021e-259, "8988206227008675", -258},
    {2.5127690442841272931892318e-300, "25127690442841273", -299},
    {5.1542221079642650985360915e+138, "5154222107964265", 139},
    {3.5861702061388992055640523e-04, "3586170206138899", -3},
    {1.6290238445698383641604538e+236, "16290238445698384", 237},
    {2.4958234848277495647193974e-253, "24958234848277496", -252},
    {1.7866090765989919624900412e+121, "1786609076598992", 122},
    {2.9937707359199852610191360e+24, "2993770735919985", 25},
    {1.6801190806410785513873916e-158, "16801190806410786", -157},
    {1.5595207352797480852406539e-209, "1559520735279748", -208},
    {9.2151634320293761629242742e-284, "9215163432029376", -283},
    {1.3886139797922612276861003e+217, "13886139797922612", 218},
    {4.8318494185826914777745303e+159, "48318494185826915", 160},
    {1.1673031316293736948671913e+154, "11673031316293737", 155},
    {7.8860954966615204590103219e-275, "788609549666152", -274},
    {1.6420277541308578135161624e-234, "16420277541308578", -233},
    {3.4270366931897086071354379e-282, "34270366931897086", -281},
    {1.9473401611339865505197239e-90, "19473401611339866", -89},
    {6.8464443767627000692728561e+157, "68464443767627", 158},
    {1.9156155352773653537618375e-202, "19156155352773654", -201},
    {1.1335597213279433971838987e-267, "11335597213279434", -266},
    {1.4237411709568716274580729e+271, "14237411709568716", 272},
    {1.1595337315235105362376355e-297, "11595337315235105", -296},
    {2.2754952483178623980190736e+299, "22754952483178624", 300},
    {1.7203737183343312630707738e+201, "17203737183343313", 202},
    {9.6633782110565760778944199e-75, "9663378211056576", -74},
    {1.7141885939062424159463111e-183, "17141885939062424", -182},
    {1.1351646950966823188511999e+31, "11351646950966823", 32},
    {2.7553851016670614030927583e-159, "27553851016670614", -158},
    {1.7334031258217582766360610e-244, "17334031258217583", -243},
    {4.5524498806089617088309461e-121, "4552449880608962", -120},
    {1.5557381689695298221784676e+96, "15557381689695298", 97},
    {2.6914251084402154839288536e+138, "26914251084402155", 139},
    {3.3731973132477958866463177e-198, "3373197313247796", -197},
    {6.5887666996781960660405203e+179, "6588766699678196", 180},
    {1.0063393035630825468746513e-25, "10063393035630825", -24},
    {2.1206107168641413186981498e-157, "21206107168641413", -156},
    {1.1031294174658341837794497e-28, "11031294174658342", -27},
    {4.2797761945425583974635025e-61, "42797761945425584", -60},
    {5.9336070991845828055293432e-65, "5933607099184583", -64},
    {1.6328701120313230032051532e+152, "1632870112031323", 153},
    {7.2142713361542252309889634e-228, "7214271336154225", -227},
    {1.3036149999206118673174481e+126, "13036149999206119", 127},
    {4.7702595824900982039898416e+125, "4770259582490098", 126},
    {1.0818597282660653472786846e+87, "10818597282660653", 88},
    {3.6559828966586257113221895e+265, "3655982896658626", 266},
    {7.7316408401841733230767223e+153, "7731640840184173", 154},
    {1.1262784507657197969416682e-302, "11262784507657198", -301},
    {1.8742126600433607227743356e+259, "18742126600433607", 260},
    {3.7919387440461414934773760e+24, "37919387440461415", 25},
    {1.0432456107978264480748821e-252, "10432456107978264", -251},
    {6.0785128152617631348862654e-265, "6078512815261763", -264},
    {7.2597578601315086858475892e-37, "7259757860131509", -36},
    {2.9484943855353673971601573e+73, "29484943855353674", 74},
    {2.4124433229796468143116612e+281, "24124433229796468", 282},
    {1.7024474119389866719957811e+105, "17024474119389867", 106},
    {4.0491196407716739735060547e-175, "4049119640771674", -174},
    {1.0394304228557689555827686e+221, "1039430422855769", 222},
    {3.2560361253795237674551558e-288, "32560361253795238", -287},
    {5.1171228167294496599883327e-77, "511712281672945", -76},
    {8.5543145838774353146150912e+26, "8554314583877435", 27},
    {4.3188140259973421126846760e-234, "4318814025997342", -233},
    {2.6873876108707274381076665e+157, "26873876108707274", 158},
    {8.9532683889697006751617891e-01, "8953268388969701", 0},
    {5.1922562626393148721148574e-234, "5192256262639315", -233},
    {4.0704586788836534632621489e-222, "40704586788836535", -221},
    {2.3885569323509253527627268e-240, "23885569323509254", -239},
    {1.4805091025196209211232370e+301, "1480509102519621", 302},
    {1.5717030764407477010660407e+307, "15717030764407477", 308},
    {8.4944821222369741879577445e+125, "8494482122236974", 126},
    {3.1557929951327670016526378e-153, "3155792995132767", -152},
    {2.9946679717379689718391511e+215, "2994667971737969", 216},
    {1.3271331623779969898894540e-39, "1327133162377997", -38},
    {2.2103955139368050001884625e-282, "2210395513936805", -281},
    {6.6692041477435222125307424e-21, "6669204147743522", -20},
    {1.0629002034637489529644332e-30, "1062900203463749", -29},
    {1.4898426467337039474727014e+183, "1489842646733704", 184},
    {1.4830296701357837710878835e+28, "14830296701357838", 29},
    {1.5556218696053514327422354e+66, "15556218696053514", 67},
    {1.3222347275715410466987784e-112, "1322234727571541", -111},
    {1.3764156336067943767442795e+153, "13764156336067944", 154},
    {3.2460343680686929313611095e+56, "3246034368068693", 57},
    {5.4900089272413846581956259e+113, "54900089272413847", 114},
    {1.3157935211585225389839461e+173, "13157935211585225", 174},
    {1.8940891720399684127373607e-255, "18940891720399684", -254},
    {1.0432476149271781817476987e+72, "10432476149271782", 73},
    {2.3993979220006270718512399e+246, "2399397922000627", 247},
    {3.1385451134292590622772804e+157, "3138545113429259", 158},
    {9.4394895045127590400106767e-180, "9439489504512759", -179},
    {4.7032096868177078188175297e+151, "4703209686817708", 152},
    {2.0215213139493105085205050e+141, "20215213139493105", 142},
    {1.4801623488669945189199561e+263, "14801623488669945", 264},
    {4.5443318929238524904936323e+173, "45443318929238525", 174},
    {1.1532274634396153704086044e+117, "11532274634396154", 118},
    {1.9256117378970840444123469e+114, "1925611737897084", 115},
    {1.2168428102539720769529315e+157, "12168428102539721", 158},
    {2.0938643559389624897448812e+03, "20938643559389625", 4},
    {3.4661620403340104619782642e-184, "34661620403340105", -183},
    {1.3231592971655162021391052e-108, "13231592971655162", -107},
    {1.3144605846645122801928167e-118, "13144605846645123", -117},
    {5.0631394728012907545538703e-228, "5063139472801291", -227},
    {5.2140757280137678349612626e-159, "5214075728013768", -158},
    {9.5435039663586157690564551e+147, "9543503966358616", 148},
    {8.2602235014362529293308847e+236, "8260223501436253", 237},
    {3.0275961720583780684742985e+146, "3027596172058378", 147},
    {1.0121056784113596343625994e+87, "10121056784113596", 88},
    {1.1967204849515347202142123e-31, "11967204849515347", -30},
    {3.9893296695897847846816375e+258, "3989329669589785", 259},
    {1.5475954262826148354867928e-193, "15475954262826148", -192},
    {3.5503273491464298954752000e+25, "355032734914643", 26},
    {1.7132648788578932147893033e-295, "17132648788578932", -294},
    {2.8230656431353175756553508e-272, "28230656431353176", -271},
    {7.2653877746191125942252241e-186, "7265387774619113", -185},
    {2.5045584848422605327826813e+75, "25045584848422605", 76},
    {1.9995381421350967271709152e-57, "19995381421350967", -56},
    {5.3976539192071306995357530e-177, "5397653919207131", -176},
    {2.6479400778230989292411290e+26, "2647940077823099", 27},
    {2.2382426300537178669612948e-76, "2238242630053718", -75},
    {1.8272561506708900428261172e-29, "182725615067089", -28},
    {7.1533412638606575801191971e+44, "7153341263860658", 45},
    {3.8415385675051334788710400e+23, "38415385675051335", 24},
    {3.1999114646309000862287966e-140, "31999114646309", -139},
    {4.0079174888961901847657089e-37, "400791748889619", -36},
    {1.4098194887986789874851078e-87, "1409819488798679", -86},
    {6.3677481257582126690430560e-47, "6367748125758213", -46},
    {1.5132609958588325408851249e+49, "15132609958588325", 50},
    {6.5049457518030623599873028e+70, "6504945751803062", 71},
    {1.8054205167512407505269026e-170, "18054205167512408", -169},
    {4.9758971105663298095001069e+46, "497589711056633", 47},
    {4.5301346021418199626742887e+99, "453013460214182", 100},
    {3.5123008392609092002928159e+44, "35123008392609092", 45},
    {2.7801358052777644775333590e+236, "27801358052777645", 237},
    {1.2905173787791868107207216e+129, "12905173787791868", 130},
    {3.8244217074243066901154153e+99, "38244217074243067", 100},
    {7.7870757425495646193482590e+304, "7787075742549565", 305},
    {6.0334551106992799069568445e+297, "603345511069928", 298},
    {1.3884040644770904668710332e+306, "13884040644770905", 307},
    {9.3255110913450179900564833e+41, "9325511091345018", 42},
    {6.0961791547016139634341037e+168, "6096179154701614", 169},
    {1.8237263789087620422475787e-307, "1823726378908762", -306},
    {1.6990202275560474292445673e-188, "16990202275560474", -187},
    {1.7846940797379891566925344e-06, "17846940797379892", -5},
    {1.8458947892386955657303251e-301, "18458947892386956", -300},
    {4.0316893820637790859271574e-64, "4031689382063779", -63},
    {5.8317358903359050685125797e+294, "5831735890335905", 295},
    {1.1564305062929106263138979e+106, "11564305062929106", 107},
    {5.3302607315947058709518516e+87, "5330260731594706", 88},
    {4.0815789784187490184863218e-200, "4081578978418749", -199},
    {1.5295003843499008065043727e+107, "15295003843499008", 108},
    {4.2692965468364044505347422e-139, "42692965468364045", -138},
    {2.0992779386717224545506173e+282, "20992779386717225", 283},
    {2.7047297750088750035502017e+04, "2704729775008875", 5},
    {1.7330390901766517807776219e-279, "17330390901766518", -278},
    {3.3247283646522642994107626e-64, "3324728364652264", -63},
    {1.8488924476729154249367600e-106, "18488924476729154", -105},
    {6.8543794638222898412384181e+129, "685437946382229", 130},
    {2.7171328112744918438310915e-35, "2717132811274492", -34},
    {2.0900611176949825326106949e-20, "20900611176949825", -19},
    {9.3510433150106620943578957e-27, "9351043315010662", -26},
    {4.4668979114341278185955082e-291, "4466897911434128", -290},
    {3.2770618021002261625930177e+118, "3277061802100226", 119},
    {6.7699472631234118184430924e-91, "6769947263123412", -90},
    {4.4674663701597614464152661e+281, "44674663701597614", 282},
    {4.2093448886559480055865369e-144, "4209344888655948", -143},
    {5.5763860677636283851154810e+62, "5576386067763628", 63},
    {1.8948630548019122163182056e+239, "18948630548019122", 240},
    {8.2877558973580594642944000e+22, "828775589735806", 23},
    {4.5593461032296057718920979e-190, "4559346103229606", -189},
    {2.9144544056065973343176663e-91, "29144544056065973", -90},
    {3.1621908983975512840734791e-106, "31621908983975513", -105},
    {1.9912253781516556965533130e+293, "19912253781516557", 294},
    {3.5577701159830271025136196e+220, "3557770115983027", 221},
    {9.9258802100885363256542051e+33, "9925880210088536", 34},
    {6.1115116656665877245133623e-255, "6111511665666588", -254},
    {4.1227247240501555167723888e-265, "41227247240501555", -264},
    {2.0142919142515672105781619e+45, "20142919142515672", 46},
    {7.9174431187953696391735378e-220, "791744311879537", -219},
    {1.4032757496563391434669922e+288, "14032757496563391", 289},
    {5.9681641495560188255293849e-244, "5968164149556019", -243},
    {3.7237881684723654629444654e+37, "37237881684723655", 38},
    {3.1092458519645487717655572e+74, "3109245851964549", 75},
    {3.3785567690301832512522868e-216, "3378556769030183", -215},
    {2.2540041214772020819400260e+216, "2254004121477202", 217},
    {2.1297468894072824021046542e-247, "21297468894072824", -246},
    {3.6805080879571138013735435e-28, "3680508087957114", -27},
    {2.5943169254000483362671403e-160, "25943169254000483", -159},
    {3.6396775217838242206447084e-211, "36396775217838242", -210},
    {3.5697128608776568412740904e-247, "3569712860877657", -246},
    {1.7778071107740364253887566e+249, "17778071107740364", 250},
    {6.6219363128066547119487950e+01, "6621936312806655", 2},
    {1.2748282421826072216996537e+173, "12748282421826072", 174},
    {9.6864865632378209655330575e-68, "9686486563237821", -67},
    {6.5279277391660311402104268e-184, "6527927739166031", -183},
    {1.6702876884443896646574072e-130, "16702876884443897", -129},
    {4.3189371650235996160000000e+18, "43189371650235996", 19},
    {9.8384680132028332720283914e-265, "9838468013202833", -264},
    {3.0812767161733945136159910e-14, "30812767161733945", -13},
    {3.7368685247001367727308800e+23, "3736868524700137", 24},
    {1.5032823406482632945737957e+173, "15032823406482633", 174},
    {1.9091505154805626379456841e+64, "19091505154805626", 65},
    {3.6246570487907904053301445e+35, "36246570487907904", 36},
    {2.3032889857954664267425115e+263, "23032889857954664", 264},
    {2.8192534292901662874692422e-226, "28192534292901663", -225},
    {2.6118826051663203369537061e-250, "26118826051663203", -249},
    {7.3626312216488454182066229e-44, "7362631221648845", -43},
    {1.0853645660151994335285284e-41, "10853645660151994", -40},
    {1.5075072469043573905100998e-295, "15075072469043574", -294},
    {3.7442494503377873492036979e-100, "37442494503377873", -99},
    {5.2037762521118925942902265e-45, "52037762521118926", -44},
    {8.6203300855037753108549063e+70, "8620330085503775", 71},
    {4.6776504805510688879132477e-57, "4677650480551069", -56},
    {1.0716699486452334433248618e-277, "10716699486452334", -276},
    {9.3085721678915006625567626e-187, "93085721678915", -186},
    {3.0457087129088073728000000e+19, "30457087129088074", 20},
    {2.3078364292524167325536613e-06, "23078364292524167", -5},
    {3.1301253003133427709048251e-280, "3130125300313343", -279},
    {2.2223055797585710066239368e-124, "2222305579758571", -123},
    {4.5087218873731919843210424e+37, "4508721887373192", 38},
    {1.6929831862784607718258779e-160, "16929831862784608", -159},
    {2.8709431944662660868750275e+240, "2870943194466266", 241},
    {2.4290664668427732932624982e+151, "24290664668427733", 152},
    {2.4364826595180839335842808e+28, "2436482659518084", 29},
    {3.1259423716822652839472175e+123, "3125942371682265", 124},
    {5.8346610067855725134356835e+188, "5834661006785573", 189},
    {1.6222727459150918492953000e-74, "16222727459150918", -73},
    {3.3724870669896653874714107e-258, "33724870669896654", -257},
    {7.6723333457392021349346472e-273, "7672333345739202", -272},
    {2.2574177097672838751231493e+60, "2257417709767284", 61},
    {5.6550937019853791522832895e-275, "5655093701985379", -274},
    {3.9010300977187458342554541e-193, "3901030097718746", -192},
    {1.9106049231375161490099958e+232, "19106049231375161", 233},
    {1.0411473087687627980400680e+33, "10411473087687628", 34},
    {1.3839921434185791478883031e+79, "13839921434185791", 80},
    {4.9375580926589384225982492e+208, "4937558092658938", 209},
    {1.0194158748700493286286522e+224, "10194158748700493", 225},
    {4.3181950864206493581055383e-41, "43181950864206494", -40},
    {1.0837907459120224532414224e+299, "10837907459120225", 300},
    {2.7827300942604513838887215e+06, "27827300942604514", 7},
    {3.6804552362848400799265136e-302, "368045523628484", -301},
    {3.1681325764001535404106899e-73, "31681325764001535", -72},
    {2.1098850012634912840792039e-229, "21098850012634913", -228},
    {7.3574008617344321393610774e+53, "7357400861734432", 54},
    {3.8242568829549285693144366e+53, "38242568829549286", 54},
    {6.6813197651731310711098999e-174, "6681319765173131", -173},
    {4.7365911180959287275015893e-142, "4736591118095929", -141},
    {2.0888057531228748422528806e-183, "2088805753122875", -182},
    {2.4344950376227196278642748e-145, "24344950376227196", -144},
    {4.7302784840127773231749757e+140, "4730278484012777", 141},
    {8.4647612433915190366539824e-229, "8464761243391519", -228},
    {4.5654841024783473260816541e+88, "4565484102478347", 89},
    {7.1292501608469174487149903e+95, "7129250160846917", 96},
    {2.7958097819098007932922113e-60, "2795809781909801", -59},
    {9.2460852972428706588466519e-280, "924608529724287", -279},
    {3.4902464906877768257510816e-57, "3490246490687777", -56},
    {3.8620946140162974596023560e+07, "38620946140162975", 8},
    {2.2978737729339399998905171e-77, "229787377293394", -76},
    {4.9277237141877698013558984e+05, "492772371418777", 6},
    {5.8541960240284936072342672e-260, "58541960240284936", -259},
    {5.4556222355848424064223011e+255, "5455622235584842", 256},
    {1.6352918425256847565703058e+92, "16352918425256848", 93},
    {1.1146393328693328733501154e-287, "11146393328693329", -286},
    {6.9007976242146569019474788e+274, "6900797624214657", 275},
    {4.0993405346260228206592334e-265, "4099340534626023", -264},
    {2.6534281309228910912013142e+75, "2653428130922891", 76},
    {5.7408543741699515425935707e-184, "5740854374169952", -183},
    {7.7381622404845941800391230e-54, "7738162240484594", -53},
    {2.6965951759252264361327888e-253, "26965951759252264", -252},
    {6.7481521571180105293779451e-10, "6748152157118011", -9},
    {2.4377467352399027444423171e+71, "24377467352399027", 72},
    {5.4797420914468827813891692e-210, "5479742091446883", -209},
    {9.2353214647457078210835549e+161, "9235321464745708", 162},
    {8.7009607004623115203286028e-288, "8700960700462312", -287},
    {4.0995132131766540783562287e-71, "4099513213176654", -70},
    {1.9131666132042600335967743e+138, "191316661320426", 139},
    {5.7033808454748011548663999e-235, "5703380845474801", -234},
    {1.0779820344266718006802803e+301, "10779820344266718", 302},
    {5.5303487944683684416636444e-208, "55303487944683684", -207},
    {1.9420292921731593034183703e-76, "19420292921731593", -75},
    {1.6048114915854164297168376e-98, "16048114915854164", -97},
    {1.3645530405888042996871809e-27, "13645530405888043", -26},
    {9.5718685537682304511137597e-30, "957186855376823", -29},
    {5.8463733024316997204451600e-154, "58463733024317", -153},
    {2.3144095625922767410585174e-192, "23144095625922767", -191},
    {1.7528569169570918217792241e-11, "17528569169570918", -10},
    {7.0415494766510011147467827e+131, "7041549476651001", 132},
    {4.0986763753576653045286190e+307, "40986763753576653", 308},
    {2.1790540385951535878571808e+218, "21790540385951536", 219},
    {6.4261266429869725103298852e-158, "64261266429869725", -157},
    {1.7858428469934197998598737e-204, "17858428469934198", -203},
    {6.1423717718920243484827207e-100, "6142371771892024", -99},
    {4.1031141056088224813015785e+183, "41031141056088225", 184},
    {2.2388824375620817507820061e-33, "22388824375620818", -32},
    {2.3289456690396100359618560e+24, "232894566903961", 25},
    {2.0327305113811246356780287e+76, "20327305113811246", 77},
    {2.4648321589032717466260879e+98, "24648321589032717", 99},
    {7.0274544526092629653201412e+217, "7027454452609263", 218},
    {5.8812957184831200126904708e-250, "588129571848312", -249},
    {8.2644181455462828178300481e+182, "8264418145546283", 183},
    {1.7090249615894414562070443e-41, "17090249615894415", -40},
    {2.0260521912628038825614556e+183, "2026052191262804", 184},
    {1.1788608821435787489952277e-216, "11788608821435787", -215},
    {2.9708532177149820203866750e+128, "2970853217714982", 129},
    {2.7414605589701273114416096e-297, "27414605589701273", -296},
    {1.3216946524537471368344712e-70, "13216946524537471", -69},
    {6.0062733764886050126439993e-242, "6006273376488605", -241},
    {3.7895056192669143383702838e+247, "37895056192669143", 248},
    {5.3790101478874370088263127e-211, "5379010147887437", -210},
    {2.2623666872605262065593931e+269, "22623666872605262", 270},
    {8.2273361830766964693892940e-187, "8227336183076696", -186},
    {1.2308459625095860821110390e+153, "1230845962509586", 154},
    {3.2277887683432088765705999e+148, "3227788768343209", 149},
    {2.3468346324076339820138875e-39, "2346834632407634", -38},
    {4.2283954794170672539810513e-282, "4228395479417067", -281},
    {2.1701951416783397583764192e+189, "21701951416783398", 190},
    {6.4689715243441821426486735e-217, "6468971524344182", -216},
    {4.2494589943153536483930054e+256, "42494589943153536", 257},
    {4.9957010909350432765552878e-270, "4995701090935043", -269},
    {9.3944017965934137483515976e-178, "9394401796593414", -177},
    {5.0942422515123978509600469e+133, "5094242251512398", 134},
    {8.4546319908191657267807101e+79, "8454631990819166", 80},
    {4.6964993614522731632426438e-47, "4696499361452273", -46},
    {1.8742626257388972147041340e+118, "18742626257388972", 119},
    {3.6159886102810104065203963e-225, "36159886102810104", -224},
    {1.0186889588345099238162868e+91, "101868895883451", 92},
    {2.5516644195772147887826852e-279, "25516644195772148", -278},
    {1.1544762929762569351396536e-83, "1154476292976257", -82},
    {1.3295181505590535907995326e-120, "13295181505590536", -119},
    {6.0792828205346475519312529e+71, "6079282820534648", 72},
    {3.3099095617505730792831991e-252, "3309909561750573", -251},
    {9.3819646767694742209734515e+261, "9381964676769474", 262},
    {4.8642205860791592311723835e-14, "4864220586079159", -13},
    {3.5928243113212845493729469e-235, "35928243113212845", -234},
    {6.3526690625313674663792402e-232, "63526690625313675", -231},
    {4.3363032009299023694889092e+34, "4336303200929902", 35},
    {4.5392074769159852597445983e-219, "4539207476915985", -218},
    {6.3758846307984015303976110e-138, "6375884630798402", -137},
    {1.0636640739923477128569659e-206, "10636640739923477", -205},
    {7.3087375753189021185656004e-301, "7308737575318902", -300},
    {1.0483691774187468965520175e-132, "10483691774187469", -131},
    {2.4845455051333235614157378e+211, "24845455051333236", 212},
    {1.5257204703916088516294164e-92, "15257204703916089", -91},
    {9.0091603351998323348916047e+144, "9009160335199832", 145},
    {7.8833357334683868379049496e-305, "7883335733468387", -304},
    {5.7471803705814841043624525e+112, "5747180370581484", 113},
    {1.4867350913356986952937090e+95, "14867350913356987", 96},
    {7.5990629058543897975092556e-249, "759906290585439", -248},
    {6.1757931255330792006006356e+291, "6175793125533079", 292},
    {7.9416095748196372891236312e-194, "7941609574819637", -193},
    {1.5775111761104793073329233e-01, "15775111761104793", 0},
    {1.3975067879214025545252475e+242, "13975067879214026", 243},
    {8.8058728466536207981702079e+67, "8805872846653621", 68},
    {9.3560156855939861803496366e+206, "9356015685593986", 207},
    {4.7075481238502817273396730e-270, "4707548123850282", -269},
    {1.0350238287431730363291442e-187, "1035023828743173", -186},
    {1.8564086325973967878564147e-183, "18564086325973968", -182},
    {9.2316382014887109844723207e-99, "9231638201488711", -98},
    {2.8424588041612293960327610e-276, "28424588041612294", -275},
    {5.6136428386715808166455976e+259, "5613642838671581", 260},
    {2.1721367959749971673989448e-221, "21721367959749972", -220},
    {7.4720235232232354860570922e+01, "7472023523223235", 2},
    {6.7549368256081368983789103e-19, "6754936825608137", -18},
    {3.8920445950804961641037178e+95, "3892044595080496", 96},
    {1.5428908901650242374681459e-288, "15428908901650242", -287},
    {1.1960858485766921146616738e-276, "11960858485766921", -275},
    {2.9739633554546597365457912e+92, "297396335545466", 93},
    {1.0295476495513828413867573e-187, "10295476495513828", -186},
    {3.5382586445555403946561582e-157, "35382586445555404", -156},
    {1.4628697420649860526780636e-261, "1462869742064986", -260},
    {1.8984977632218406721657980e+163, "18984977632218407", 164},
    {1.1457121522657958756570111e+304, "11457121522657959", 305},
    {4.2869172855403259004507478e-263, "4286917285540326", -262},
    {3.0152679382546119323052744e+257, "3015267938254612", 258},
    {2.3907171210381989336247834e-307, "2390717121038199", -306},
    {7.4177536815356484955900710e+236, "74177536815356485", 237},
    {1.3039690163068474624212552e-129, "13039690163068475", -128},
    {1.6641337799305603501450211e-94, "16641337799305604", -93},
    {2.8587005015706729597374093e-107, "2858700501570673", -106},
    {2.4377189924037072018906904e+68, "2437718992403707", 69},
    {2.8260866668920463647245265e+97, "28260866668920464", 98},
    {2.1512627511026961818288969e+66, "2151262751102696", 67},
    {1.4887437512296996870043483e-227, "14887437512296997", -226},
    {2.2102345923810377572905312e-82, "22102345923810378", -81},
    {5.7077621532737135282526640e-08, "57077621532737135", -7},
    {2.4776713993146591342355036e+107, "2477671399314659", 108},
    {3.7826394029684242456878656e+184, "3782639402968424", 185},
    {4.5522078308979449874897152e-101, "4552207830897945", -100},
    {4.5726492289594219281824992e+175, "4572649228959422", 176},
    {4.7350472461663422738627076e-122, "47350472461663423", -121},
    {1.5141318540785175987425607e-12, "15141318540785176", -11},
    {1.0539924709315018596331463e+299, "10539924709315019", 300},
    {6.0858586223667358229591065e+80, "6085858622366736", 81},
    {7.1942604793000434333568061e-287, "7194260479300043", -286},
    {8.9487114343671627213542869e-231, "8948711434367163", -230},
    {5.1762685501271034030071789e+97, "51762685501271034", 98},
    {9.3473542592202043024592537e-267, "9347354259220204", -266},
    {6.4507917866750396964483027e-271, "645079178667504", -270},
    {6.5437301882262236324500791e-294, "6543730188226224", -293},
    {5.0524729564605411038255444e-290, "5052472956460541", -289},
    {2.8238940766395666030415513e+163, "28238940766395666", 164},
    {9.4402268297524721071202531e-130, "9440226829752472", -129},
    {7.5356353251659406139510505e+32, "753563532516594", 33},
    {2.5278623558220794210847202e-203, "25278623558220794", -202},
    {6.2839266279472561358362822e-119, "6283926627947256", -118},
    {1.4435359467978690625000000e+14, "1443535946797869", 15},
    {1.1223409732312799746564448e-44, "112234097323128", -43},
    {4.1759028920889633819477776e-05, "41759028920889634", -4},
    {2.5137821520607724219224532e+53, "25137821520607724", 54},
    {6.2335209395372806946924993e+73, "6233520939537281", 74},
    {2.7939605665936113250518919e-71, "27939605665936113", -70},
    {4.4258586633528636058085203e-281, "44258586633528636", -280},
    {2.2984625097483179487036455e+259, "2298462509748318", 260},
    {5.5200838336898961492783152e-284, "5520083833689896", -283},
    {1.0047087017280105054712456e+262, "10047087017280105", 263},
    {6.2801916857794218347587053e+280, "6280191685779422", 281},
    {1.0362710808697927768304180e-12, "10362710808697928", -11},
    {2.3350930710546610438468487e+115, "2335093071054661", 116},
    {9.6443228885631651531725011e+240, "9644322888563165", 241},
    {6.3309799839641608807695552e+184, "6330979983964161", 185},
    {7.9121612707135523276982321e+28, "7912161270713552", 29},
    {3.9549348097818781772857440e+68, "3954934809781878", 69},
    {1.2999154974402178855857003e+128, "12999154974402179", 129},
    {9.8776633146262407011875690e+226, "987766331462624", 227},
    {2.4419822903093267517803522e+85, "24419822903093268", 86},
    {4.0305334778399068741439775e-271, "4030533477839907", -270},
    {1.1735474357108663400604408e-91, "11735474357108663", -90},
    {4.3950965940696495620280299e+222, "43950965940696496", 223},
    {2.5152265701785830231009306e-79, "2515226570178583", -78},
    {8.3788887856769328134955080e-225, "8378888785676933", -224},
    {6.6649903796050138099346441e+206, "6664990379605014", 207},
    {1.9365058510848892763485710e-07, "19365058510848893", -6},
    {3.9938144591721187730105723e-210, "3993814459172119", -209},
    {4.4828700491125391174234005e-225, "4482870049112539", -224},
    {8.0605058365503327406105154e-61, "8060505836550333", -60},
    {9.5059316812380305608385096e+284, "950593168123803", 285},
    {3.9560334706181372286377029e-100, "3956033470618137", -99},
    {7.0358977894616744945839552e-204, "7035897789461674", -203},
    {1.7681875874914587769926173e+244, "17681875874914588", 245},
    {2.1638043182501837643183694e+216, "21638043182501838", 217},
    {1.5144885106776872876225006e-73, "15144885106776873", -72},
    {8.5829055139570807006452522e-199, "858290551395708", -198},
    {3.0866197632444742902914680e+292, "30866197632444743", 293},
    {2.4692801009155550608327186e+148, "2469280100915555", 149},
    {7.3793279831121626299747872e+114, "7379327983112163", 115},
    {2.2124167013961736293121280e+255, "22124167013961736", 256},
    {7.0734041946853295388731662e+256, "707340419468533", 257},
    {5.9849480029922123450297313e-33, "59849480029922123", -32},
    {6.3977506414035682415313614e-308, "6397750641403568", -307},
    {1.7924388188531628123983321e+273, "17924388188531628", 274},
    {2.5044199796851713189945486e+33, "25044199796851713", 34},
    {9.8776895043899895356062885e+268, "987768950438999", 269},
    {4.8386223971768413768908800e+23, "48386223971768414", 24},
    {3.1231431718759506330316494e-201, "31231431718759506", -200},
    {4.2116370987433606132670974e+300, "42116370987433606", 301},
    {3.0462367954155704685960683e-143, "30462367954155705", -142},
    {4.6741856462521872203392644e+273, "4674185646252187", 274},
    {2.8584778582286232155098629e+165, "28584778582286232", 166},
    {1.9138930453550812269452411e-123, "19138930453550812", -122},
    {7.9137013702564228676232285e+303, "7913701370256423", 304},
    {1.6876192482479421771394303e+272, "16876192482479422", 273},
    {6.3062699874705498869483673e+227, "630626998747055", 228},
    {6.3064329918375500023798636e+156, "630643299183755", 157},
    {1.1116174216497010534344522e-83, "1111617421649701", -82},
    {6.1224431846646492559886239e-37, "6122443184664649", -36},
    {9.5875896260052454653332161e-86, "9587589626005245", -85},
    {2.1592080656080343531519504e-213, "21592080656080344", -212},
    {7.5186189939323158666596993e-191, "7518618993932316", -190},
    {8.7120640456417511057658055e+69, "8712064045641751", 70},
    {4.7852870706847095591731243e-139, "47852870706847096", -138},
    {4.0941210154840281854297578e+251, "4094121015484028", 252},
    {1.7866428129383526738010376e+202, "17866428129383527", 203},
    {6.6812522726876330440068519e-252, "6681252272687633", -251},
    {1.4590219844158901129941529e-215, "145902198441589", -214},
    {5.6855634480706396864863194e-59, "568556344807064", -58},
    {3.9872442179943213704973459e+05, "39872442179943214", 6},
    {6.0524316629786428406254219e-55, "6052431662978643", -54},
    {1.0469876073536398396078071e-249, "10469876073536398", -248},
    {2.9580991984556654132638505e-220, "29580991984556654", -219},
    {1.0491216533754321136055407e-05, "10491216533754321", -4},
    {7.3103939561630993827827272e+148, "7310393956163099", 149},
    {1.8254118898830210142107565e-24, "1825411889883021", -23},
    {5.4294778992083585732370847e-286, "5429477899208359", -285},
    {2.8078930029766455483819092e-144, "28078930029766455", -143},
    {6.8851894983774062674561512e-283, "6885189498377406", -282},
    {3.3923878302806216387954969e-160, "33923878302806216", -159},
    {1.5233475273157470226287842e+09, "1523347527315747", 10},
    {1.3529068948873750483542874e+259, "1352906894887375", 260},
    {3.8388023188472148943670750e+289, "3838802318847215", 290},
    {2.5590701067051180816234047e-294, "2559070106705118", -293},
    {1.9720093143056055148539606e-117, "19720093143056055", -116},
    {1.2192822909109117461621558e+109, "12192822909109117", 110},
    {5.2794149330817090419390850e+56, "5279414933081709", 57},
    {6.0748667902525568574838416e+199, "6074866790252557", 200},
    {1.5397507574653699542984002e-192, "153975075746537", -191},
    {4.6042065597058584765171050e-184, "46042065597058585", -183},
    {5.4494910726077904017605568e-58, "54494910726077904", -57},
    {4.9102395036863753861207107e-261, "4910239503686375", -260},
    {2.9740965288116914763122038e-117, "29740965288116915", -116},
    {4.9183266732685772155045614e+280, "4918326673268577", 281},
    {1.3601777654995340929518893e-15, "1360177765499534", -14},
    {5.0866982778034451377452993e+163, "5086698277803445", 164},
    {4.7242659729783131332926960e-123, "4724265972978313", -122},
    {1.6783288815156761108940407e-188, "1678328881515676", -187},
    {1.3508822768288890556512106e-283, "1350882276828889", -282},
    {1.5553836269004816288197963e-172, "15553836269004816", -171},
    {6.1159530372706147721337054e+63, "6115953037270615", 64},
    {1.3089515150291235963101333e+247, "13089515150291236", 248},
    {6.9595313297688920576973845e+137, "6959531329768892", 138},
    {1.5774908467678374154202852e-80, "15774908467678374", -79},
    {2.0533825980164911203882725e+67, "2053382598016491", 68},
    {1.1348677934531508991542693e-113, "11348677934531509", -112},
    {1.1552865134554559809322890e+260, "1155286513455456", 261},
    {2.3797756884861226256042495e-241, "23797756884861226", -240},
    {2.6009856529022435079029451e+272, "26009856529022435", 273},
    {1.1941349691092522225631484e+30, "11941349691092522", 31},
    {1.2045176250852576025824777e-207, "12045176250852576", -206},
    {1.8743248869502112235520000e+21, "18743248869502112", 22},
    {3.4328533428126352665876860e-289, "34328533428126353", -288},
    {2.0134237133896766108015333e-86, "20134237133896766", -85},
    {1.9724846603988506090669124e+193, "19724846603988506", 194},
    {9.0980767919223287331250141e-178, "9098076791922329", -177},
    {1.4291493665735968022106251e+66, "14291493665735968", 67},
    {2.2454928386992477545779471e+35, "22454928386992478", 36},
    {6.4944593515641575756609206e-298, "6494459351564158", -297},
    {3.8854301538516686120393752e-140, "38854301538516686", -139},
    {5.3461164591762554453363585e-79, "53461164591762554", -78},
    {7.7984159931193950019570537e-52, "7798415993119395", -51},
    {5.1992025034364272956055776e+109, "5199202503436427", 110},
    {3.3626856914099185193719543e-159, "33626856914099185", -158},
    {6.1098032064334752240777961e+147, "6109803206433475", 148},
    {3.4912440729944098861089459e-181, "349124407299441", -180},
    {5.7108238731895625836081600e+208, "5710823873189563", 209},
    {1.5380403020723627399342695e-84, "15380403020723627", -83},
    {3.2539778244528009063886107e+248, "3253977824452801", 249},
    {1.4169695872336945631554171e-265, "14169695872336946", -264},
    {1.1579537933111920207849774e-78, "1157953793311192", -77},
    {2.1715394511877635476009076e-207, "21715394511877635", -206},
    {2.2647411321017159845232762e+44, "2264741132101716", 45},
    {1.2906423059706458815867265e-273, "12906423059706459", -272},
    {1.4630825693639467648499545e-164, "14630825693639468", -163},
    {8.6826763893009714465744122e-172, "8682676389300971", -171},
    {2.2795583992208648227103383e+128, "2279558399220865", 129},
    {4.8168550938771903243226247e+87, "481685509387719", 88},
    {7.3588121725680632720992893e-259, "7358812172568063", -258},
    {1.0165178458787772288378417e-123, "10165178458787772", -122},
    {8.4376100998897253001471142e+131, "8437610099889725", 132},
    {1.4825527159309689020031952e+251, "1482552715930969", 252},
    {3.1841543260571113160443705e+203, "3184154326057111", 204},
    {8.4094544449326574904503518e-59, "8409454444932657", -58},
    {2.2624591714972098137567076e+300, "22624591714972098", 301},
    {7.4249167824373987832119614e+73, "7424916782437399", 74},
    {2.2820669274480629882812500e+12, "2282066927448063", 13},
    {2.9548380114177071729305503e+133, "2954838011417707", 134},
    {1.0800802846363275445192062e+157, "10800802846363275", 158},
    {2.3767181110023525319522508e-296, "23767181110023525", -295},
    {3.9351186094358089156772755e+114, "3935118609435809", 115},
    {6.6262842336344144280960782e+257, "6626284233634414", 258},
    {1.2295955503461183509168696e-172, "12295955503461184", -171},
    {5.4544200418479467779744923e-282, "5454420041847947", -281},
    {9.1805253308237082352709856e-82, "9180525330823708", -81},
    {1.2455501679291048866538008e+282, "1245550167929105", 283},
    {2.2753193070904464355342971e+269, "22753193070904464", 270},
    {4.2881688707509846941037006e-247, "4288168870750985", -246},
    {6.9323075336000950328985527e-145, "6932307533600095", -144},
    {4.3265117849557862400000000e+17, "4326511784955786", 18},
    {3.0743401304629180005286299e+87, "3074340130462918", 88},
    {5.4854185743544428930851627e+233, "5485418574354443", 234},
    {7.1547738470881804505105432e-25, "715477384708818", -24},
    {1.5496742432518170394003879e-42, "1549674243251817", -41},
    {6.2777543503250137228719439e+190, "6277754350325014", 191},
    {1.5851414336779669196419914e-160, "1585141433677967", -159},
    {3.1064476780979916783481421e+127, "31064476780979917", 128},
    {3.0293867118741880387954480e+237, "3029386711874188", 238},
    {3.3535898855942088205519455e-138, "3353589885594209", -137},
    {1.9057465033871686076792501e+175, "19057465033871686", 176},
    {2.4318041077383045640943542e+171, "24318041077383046", 172},
    {7.8283344478329762190351360e+105, "7828334447832976", 106},
    {6.0549275300776997884005202e+184, "60549275300777", 185},
    {9.0126788988610902044874857e+83, "901267889886109", 84},
    {3.8727087661520312121397016e+35, "3872708766152031", 36},
    {4.3622116865453498425787800e-44, "436221168654535", -43},
    {5.3752138791607318115234375e+11, "5375213879160732", 12},
    {5.5711053611542447470128536e+03, "5571105361154245", 4},
    {8.6281010306935685120000000e+21, "8628101030693569", 22},
    {9.9426356508783569636026911e+55, "9942635650878357", 56},
    {2.5163100048827552877619731e+269, "25163100048827553", 270},
    {5.0344165090617445964700026e-52, "50344165090617446", -51},
    {1.9548139899202615619590525e+232, "19548139899202616", 233},
    {1.9511690843651186574770727e-87, "19511690843651187", -86},
    {2.2545413819701244027430449e-306, "22545413819701244", -305},
    {1.5194243979202373138638644e-145, "15194243979202373", -144},
    {3.1773032765899348228938342e+236, "3177303276589935", 237},
    {3.7206528125292903702035756e-148, "37206528125292904", -147},
    {1.7554497586148768376889149e+301, "17554497586148768", 302},
    {7.8348631258264293052855264e+115, "7834863125826429", 116},
    {1.1544366382167317772531746e-58, "11544366382167318", -57},
    {2.9063027346907932915409768e+49, "29063027346907933", 50},
    {3.4049516337085780076212979e-292, "3404951633708578", -291},
    {3.4682004314040347676682344e+87, "34682004314040348", 88},
    {7.2798547136756136418907892e-39, "7279854713675614", -38},
    {3.0586408558270705034703138e-80, "30586408558270705", -79},
    {8.2022921117916431439630517e-134, "8202292111791643", -133},
    {1.3597071194937402803546942e-52, "13597071194937403", -51},
    {2.3058554495347973378643317e+165, "23058554495347973", 166},
    {1.1168084117322720759010188e+302, "1116808411732272", 303},
    {5.4485571255785940582400000e+20, "5448557125578594", 21},
    {1.1308135255089849269657982e+267, "1130813525508985", 268},
    {3.6477524194700217776698992e+03, "3647752419470022", 4},
    {3.8464275843634984960000000e+18, "38464275843634985", 19},
    {3.6081843936110686994940810e+133, "36081843936110687", 134},
    {8.9281976699629424220093261e-151, "8928197669962942", -150},
    {2.4168839813689080838756464e-53, "2416883981368908", -52},
    {4.9249315042481134341301185e-01, "49249315042481134", 0},
    {4.8177217151450301907518490e+74, "481772171514503", 75},
    {6.1312176665549303854247790e-224, "613121766655493", -223},
    {7.4648682043718523891424542e-47, "7464868204371852", -46},
    {3.0150179740166263576256569e+95, "30150179740166264", 96},
    {6.1886205217524172775933134e-262, "6188620521752417", -261},
    {3.8401699092284757253996513e+37, "38401699092284757", 38},
    {2.5719847614800597921242078e-200, "25719847614800598", -199},
    {1.3390381074648968762950783e+299, "13390381074648969", 300},
    {2.7747221561118585428390794e+246, "27747221561118585", 247},
    {1.7221511505874121792812185e-92, "17221511505874122", -91},
    {2.1208077175690001361920880e-83, "2120807717569", -82},
    {7.7669850489234027336330188e-186, "7766985048923403", -185},
    {8.7301816459321679061827648e-175, "8730181645932168", -174},
    {3.5724318075147488565208465e-292, "3572431807514749", -291},
    {3.2300012740772014466596070e-239, "32300012740772014", -238},
    {7.6314243561281526119077149e+110, "7631424356128153", 111},
    {1.3111822600295509205497646e-306, "13111822600295509", -305},
    {8.1637297676386585471512125e+123, "8163729767638659", 124},
    {5.0725716554266496843680103e+222, "507257165542665", 223},
    {2.7320580433175872832461419e-213, "27320580433175873", -212},
    {4.2262676525355732940308147e-130, "4226267652535573", -129},
    {8.7581314692977846890327480e-256, "8758131469297785", -255},
    {1.0410017438156120105239923e-38, "1041001743815612", -37},
    {1.6291245111562946651988936e-142, "16291245111562947", -141},
    {5.8111218299377156573774399e+264, "5811121829937716", 265},
    {1.3516423408280655017697442e+97, "13516423408280655", 98},
    {5.5699830879323361799987561e+118, "5569983087932336", 119},
    {5.3310235771744778280072340e-123, "5331023577174478", -122},
    {9.3481121131538307666778564e+08, "9348112113153831", 9},
    {2.5412902127297455072402954e+08, "25412902127297455", 9},
    {1.3433005841154329043543379e-145, "13433005841154329", -144},
    {1.1550395809051260433822334e-126, "1155039580905126", -125},
    {5.4218056349864840884658990e-254, "5421805634986484", -253},
    {3.1437559781603301584309409e+291, "314375597816033", 292},
    {1.0525800987026800080343747e+37, "105258009870268", 38},
    {8.2211929054634786598624576e-244, "8221192905463479", -243},
    {4.0992695455169251528265155e+48, "4099269545516925", 49},
    {3.7158804322651657680188281e-240, "3715880432265166", -239},
    {2.3619612224984126027868800e-73, "23619612224984126", -72},
    {1.7497987383890545421623788e-177, "17497987383890545", -176},
    {1.2394293125266370454112760e+270, "1239429312526637", 271},
    {2.3695475762591721251856188e-251, "2369547576259172", -250},
    {2.8221844959637926164575106e-01, "28221844959637926", 0},
    {4.7343088415835019369494256e-220, "4734308841583502", -219},
    {2.3765248349398248124119834e+272, "23765248349398248", 273},
    {6.2764494076603766043100884e-150, "6276449407660377", -149},
    {8.1663364282120743255857343e+285, "8166336428212074", 286},
    {1.2647756841601471508125470e+166, "12647756841601472", 167},
    {7.7736756146688034857590382e-113, "7773675614668803", -112},
    {5.2637475727670755269342390e-160, "52637475727670755", -159},
    {1.2499615082597586412679091e-149, "12499615082597586", -148},
    {2.6740594124019907842739297e+197, "26740594124019908", 198},
    {1.8908330155080133236672867e+75, "18908330155080133", 76},
    {2.6289033102607251822657962e+194, "26289033102607252", 195},
    {2.6567406598115547873231696e+168, "26567406598115548", 169},
    {1.3213608724923616370490708e+202, "13213608724923616", 203},
    {2.2889935506802141710986103e+36, "22889935506802142", 37},
    {2.8446611107483848663313667e-245, "2844661110748385", -244},
    {9.6438259692597983239445039e-61, "9643825969259798", -60},
    {1.7225789565333392232335835e+272, "17225789565333392", 273},
    {2.0226792317313897476188770e-152, "20226792317313897", -151},
    {7.7593162648885032353841719e+252, "7759316264888503", 253},
    {9.7593700753028659631551730e+123, "9759370075302866", 124},
    {1.8139470076568429520013766e+128, "1813947007656843", 129},
    {2.2891983198539890145906709e-222, "2289198319853989", -221},
    {1.7775563255894493722647674e+308, "17775563255894494", 309},
    {1.2426470619071860549463610e-59, "1242647061907186", -58},
    {1.5584173157418350084732061e-46, "1558417315741835", -45},
    {6.6831448213798336111579218e+121, "6683144821379834", 122},
    {2.2545978999144376516718967e+86, "22545978999144377", 87},
    {3.3897639193363043586570167e+172, "33897639193363044", 173},
    {3.8678268019206698523145960e-138, "386782680192067", -137},
    {2.5267290812536830587093228e-305, "2526729081253683", -304},
    {9.6249075170804535978826845e+96, "9624907517080454", 97},
    {4.0758161096380014217059047e-225, "40758161096380014", -224},
    {1.6388963035541359996083081e+280, "1638896303554136", 281},
    {3.2050764433298097718710423e+184, "32050764433298098", 185},
    {1.1178261630142718331901296e+60, "11178261630142718", 61},
    {1.1796595983600349976733854e+197, "1179659598360035", 198},
    {6.4865043224559021887292732e+231, "6486504322455902", 232},
    {3.9286011025338285803005013e+252, "39286011025338286", 253},
    {1.8834051164283828624805390e+207, "1883405116428383", 208},
    {4.9382709451820054796699370e-279, "49382709451820055", -278},
    {5.0292782835146679927509307e-135, "5029278283514668", -134},
    {5.9616710013003811232369393e+109, "5961671001300381", 110},
    {2.6545149052546671743910080e-237, "2654514905254667", -236},
    {3.6900028725853818318847676e+115, "3690002872585382", 116},
    {8.2052843484727305840194761e+139, "8205284348472731", 140},
    {3.2582243862364141028090007e+143, "3258224386236414", 144},
    {2.2924095301644525229074846e+176, "22924095301644525", 177},
    {1.5789369216914822467939099e+197, "15789369216914822", 198},
    {4.9464282453587619715256472e-166, "4946428245358762", -165},
    {8.3594647695007592254396170e-10, "8359464769500759", -9},
    {5.8168236264771049884665035e-261, "5816823626477105", -260},
    {6.3738622746233397564813811e-86, "637386227462334", -85},
    {4.1044136968915153829295710e+147, "41044136968915154", 148},
    {4.6015248577101056993883899e+209, "4601524857710106", 210},
    {3.8325420192052811940023633e-15, "3832542019205281", -14},
    {7.2898919322115788005924413e+130, "7289891932211579", 131},
    {6.2072556057734693934733818e+37, "6207255605773469", 38},
    {1.4646374394407292651664973e-245, "14646374394407293", -244},
    {6.6390788589897898581396860e-192, "663907885898979", -191},
    {3.7651328686592213533472353e+53, "37651328686592214", 54},
    {4.7685244458678341523395055e+256, "4768524445867834", 257},
    {4.7737888988976558727435846e-52, "4773788898897656", -51},
    {9.1002099572691643720096215e-200, "9100209957269164", -199},
    {3.5011454291414047681747147e-72, "3501145429141405", -71},
    {2.6271943493657418323658290e+115, "2627194349365742", 116},
    {7.6985985813213325718074469e+47, "7698598581321333", 48},
    {7.8910956996357093155221240e+36, "7891095699635709", 37},
    {2.2599682697713980477104692e+303, "2259968269771398", 304},
    {3.5203572506712721423838275e-01, "3520357250671272", 0},
    {2.4123376783470102401647939e+211, "24123376783470102", 212},
    {5.2614889719738744717855607e-103, "5261488971973874", -102},
    {1.4169848315984105845319105e+237, "14169848315984106", 238},
    {1.2795128134431813131124899e-75, "12795128134431813", -74},
    {1.1014760879811920556880084e+75, "1101476087981192", 76},
    {4.7567618141795474270169745e-150, "47567618141795474", -149},
    {7.9281828456628872055293690e-166, "7928182845662887", -165},
    {6.1966888027211121909713044e-167, "6196688802721112", -166},
    {2.3142640452214134751584927e+204, "23142640452214135", 205},
    {3.6860839029101421489754196e-256, "3686083902910142", -255},
    {3.7829538947462320907451867e-194, "3782953894746232", -193},
    {2.1206294041383840559648490e+212, "2120629404138384", 213},
    {2.3762125939085244760923875e+193, "23762125939085245", 194},
    {2.3916817028451388984833435e+295, "2391681702845139", 296},
    {2.2540216240600261665983908e+180, "2254021624060026", 181},
    {5.0830554021666013299431356e-79, "50830554021666013", -78},
    {1.9201048116381255467008000e+23, "19201048116381255", 24},
    {1.8525027410829693451582813e-51, "18525027410829693", -50},
    {1.1181907491528829111790406e+121, "1118190749152883", 122},
    {8.0754239710610062616023153e-284, "8075423971061006", -283},
    {1.3588934497389299524975597e-35, "135889344973893", -34},
    {8.8590866351075936646401652e-135, "8859086635107594", -134},
    {4.5182973635791499692888179e-297, "451829736357915", -296},
    {1.1007341475216695106009176e+83, "11007341475216695", 84},
    {1.6623767881768252180928313e-215, "16623767881768252", -214},
    {2.1763468319598054330066995e+240, "21763468319598054", 241},
    {2.1638207283964363201427893e+152, "21638207283964363", 153},
    {1.1459038099550746919504504e+137, "11459038099550747", 138},
    {6.6284422150697940008737421e+85, "6628442215069794", 86},
    {4.3985986601394087957674016e+267, "4398598660139409", 268},
    {1.1299219651593258639182680e-262, "11299219651593259", -261},
    {4.7852377911535096746923822e-22, "478523779115351", -21},
    {7.2215769938334293933789099e-107, "7221576993833429", -106},
    {8.7567176983670620214479690e+95, "8756717698367062", 96},
    {2.7896584943246278324586622e+63, "2789658494324628", 64},
    {2.9776364246904483928031461e+232, "29776364246904484", 233},
    {2.8995005286320394085895691e+197, "28995005286320394", 198},
    {2.8030960932364458306764687e-86, "2803096093236446", -85},
    {4.1021039456414150701761025e-140, "4102103945641415", -139},
    {5.1975123103715675194217538e-203, "5197512310371568", -202},
    {8.9488570661577870548628530e+257, "8948857066157787", 258},
    {2.5404504589270734744585266e+191, "25404504589270735", 192},
    {2.5288743153409963939183199e+158, "25288743153409964", 159},
    {1.0479329405092643299183920e-154, "10479329405092643", -153},
    {2.5595061741363992692375987e+225, "25595061741363993", 226},
    {2.9386600975491522831551040e-153, "29386600975491523", -152},
    {1.6216572942149027632170494e-209, "16216572942149028", -208},
    {2.8377357165129894647282876e+253, "28377357165129895", 254},
    {4.3295154664909451384077437e-147, "4329515466490945", -146},
    {5.0902635095289139716449419e-67, "5090263509528914", -66},
    {3.7135143010496994458285323e-74, "37135143010496994", -73},
    {1.3174613340876313360482457e+216, "13174613340876313", 217},
    {3.9926140814902374914490446e-306, "39926140814902375", -305},
    {6.5953248534475081913989831e-229, "6595324853447508", -228},
    {4.7039014813533854460678809e-247, "47039014813533854", -246},
    {8.0608057567212619062583360e+264, "8060805756721262", 265},
    {7.0886416164111890078483115e+146, "7088641616411189", 147},
    {1.7121076348261185676452602e-236, "17121076348261186", -235},
    {6.5137691899836738539500630e-107, "6513769189983674", -106},
    {3.3972565504862567988999243e+204, "3397256550486257", 205},
    {7.1654168576936452330549202e-200, "7165416857693645", -199},
    {2.1707543902123615719582823e+191, "21707543902123616", 192},
    {3.2552605047215098664892362e+95, "325526050472151", 96},
    {3.4841192899928079044520181e+65, "3484119289992808", 66},
    {8.6595479498598589224514499e-05, "8659547949859859", -4},
    {1.6769667361873602853373446e-126, "16769667361873603", -125},
    {7.5892932514743121972784298e-230, "7589293251474312", -229},
    {1.9889475558036126421593424e+149, "19889475558036126", 150},
    {1.1086429727323679008146796e+121, "1108642972732368", 122},
    {4.7099203197325570144576314e+257, "4709920319732557", 258},
    {8.1591225827451571535529562e-192, "8159122582745157", -191},
    {9.0397503225566529913788281e-287, "9039750322556653", -286},
    {2.9154925537008182836286414e+263, "29154925537008183", 264},
    {2.7047105839954283231908006e-31, "27047105839954283", -30},
    {1.8533039286014973472966477e-304, "18533039286014973", -303},
    {1.8150530292634518836347723e-02, "1815053029263452", -1},
    {1.3357411706903812347185423e-83, "13357411706903812", -82},
    {4.3513440714501040402562623e-07, "4351344071450104", -6},
    {1.0224981313877888248260125e+117, "10224981313877888", 118},
    {1.8615009635694181350715596e-227, "18615009635694181", -226},
    {5.1858670545025339754797176e-114, "5185867054502534", -113},
    {3.9463363429525043572650957e+99, "39463363429525044", 100},
    {1.8689501029153088973131237e-248, "1868950102915309", -247},
    {1.3793631037269698894583982e+132, "13793631037269699", 133},
    {3.7368451310021389141469002e+269, "3736845131002139", 270},
    {1.5681273881372404793201934e-112, "15681273881372405", -111},
    {4.7415424518768466054676216e-78, "4741542451876847", -77},
    {1.0191898442252222768336830e-198, "10191898442252223", -197},
    {2.0537666795171367187500000e+12, "20537666795171367", 13},
    {1.6084123303062038639321841e+260, "1608412330306204", 261},
    {2.4875377917293204599538573e+256, "24875377917293205", 257},
    {2.8755231985027166267091701e-231, "28755231985027166", -230},
    {8.8869180510356814020960935e-60, "8886918051035681", -59},
    {2.3367925989312052298072311e+110, "23367925989312052", 111},
    {1.2898646458160604014430243e-138, "12898646458160604", -137},
    {1.5601654780814472783225741e+127, "15601654780814473", 128},
    {1.7574986049947475519797010e-296, "17574986049947476", -295},
    {3.2278381425608840800123289e+03, "3227838142560884", 4},
    {1.5832539556435311113804201e+93, "1583253955643531", 94},
    {3.0011299907980508537693543e-171, "3001129990798051", -170},
    {3.6662442988141426014065972e-85, "36662442988141426", -84},
    {1.8794516112671270348634181e-19, "1879451611267127", -18},
    {2.5910338145649718492859721e-210, "2591033814564972", -209},
    {6.8132336620959340953600000e+20, "6813233662095934", 21},
    {1.8161479553156097414059619e+40, "18161479553156097", 41},
    {2.2160925392909928784771245e-239, "2216092539290993", -238},
    {1.7987663733150742315462208e-278, "17987663733150742", -277},
    {9.1137460231904833487830969e-20, "9113746023190483", -19},
    {5.6118186173258787619184721e-73, "5611818617325879", -72},
    {3.3950543528175537109375000e+10, "33950543528175537", 11},
    {1.7909466849767154607076185e+174, "17909466849767155", 175},
    {1.1789256010977869292034250e+251, "1178925601097787", 252},
    {9.3658179172445197053478765e-125, "936581791724452", -124},
    {1.4379165964530465130818164e+283, "14379165964530465", 284},
    {2.3453889603065433093673586e-222, "23453889603065433", -221},
    {6.6249672082842469799630773e+134, "6624967208284247", 135},
    {1.3897025350413532947457694e+66, "13897025350413533", 67},
    {2.6481493922611972101533012e-51, "26481493922611972", -50},
    {6.4750926530462381132629050e-208, "6475092653046238", -207},
    {1.1755490691738191493448950e-292, "11755490691738191", -291},
    {2.5989344945532787396695729e+160, "25989344945532787", 161},
    {1.1405374156832959987229748e+38, "1140537415683296", 39},
    {1.0492962559381809082031250e+12, "10492962559381809", 13},
    {4.9001719834314571630518853e+48, "4900171983431457", 49},
    {4.1956833540060383933968380e-192, "41956833540060384", -191},
    {3.4824531960073362658176383e-56, "34824531960073363", -55},
    {2.3130225795651598096486913e+70, "23130225795651598", 71},
    {2.0945551491472241703868670e-158, "2094555149147224", -157},
    {9.9837631935833577255094973e-29, "9983763193583358", -28},
    {3.5742229631366699941391340e-275, "357422296313667", -274},
    {1.5581901893735301407238169e+118, "15581901893735301", 119},
    {2.2328170182283900602823144e+46, "223281701822839", 47},
    {7.3930789633617557687647560e+171, "7393078963361756", 172},
    {1.6845914455281046933399408e-80, "16845914455281047", -79},
    {3.8626362975387282843364575e-196, "38626362975387283", -195},
    {1.3740275210216206616649020e-204, "13740275210216207", -203},
    {1.1037675390600121271716484e-98, "11037675390600121", -97},
    {1.2220050930685271109159103e-204, "12220050930685271", -203},
    {1.8893434723478647244635418e-281, "18893434723478647", -280},
    {9.1772341353660921597629876e+150, "9177234135366092", 151},
    {2.5547341654859897003367444e-298, "25547341654859897", -297},
    {2.0284394127225941957527199e-162, "20284394127225942", -161},
    {5.9806595364963680975529765e-159, "5980659536496368", -158},
    {6.1446089020058651038352330e-304, "6144608902005865", -303},
    {3.5151018414683362260884516e-163, "3515101841468336", -162},
    {3.4609563773051812380504105e+246, "34609563773051812", 247},
    {5.6765288046277884621481601e+178, "56765288046277885", 179},
    {1.3043492370201005533978954e-253, "13043492370201006", -252},
    {1.5659176124976209356575559e-156, "1565917612497621", -155},
    {1.4935927320244307919493015e-263, "14935927320244308", -262},
    {5.8666883651304193354793802e-95, "58666883651304193", -94},
    {1.2652841734955810895430251e-32, "1265284173495581", -31},
    {6.6777236955418752245725524e+123, "6677723695541875", 124},
    {5.3916739221041564876800000e+20, "53916739221041565", 21},
    {7.7678938739060847129314813e+254, "7767893873906085", 255},
    {1.4967711042304606110755919e-285, "14967711042304606", -284},
    {1.2952750510447946990079655e+33, "12952750510447947", 34},
    {1.3564144476786884010297925e+78, "13564144476786884", 79},
    {1.4899276713037671468363126e+71, "14899276713037671", 72},
    {6.5260499275895421875000000e+13, "6526049927589542", 14},
    {2.8544043220374469185868446e-192, "2854404322037447", -191},
    {1.5088176388845958251821851e-153, "15088176388845958", -152},
    {2.5900225918181229214476252e-115, "2590022591818123", -114},
    {6.2105227056346266120810301e-279, "6210522705634627", -278},
    {7.4080966246508723590081596e-209, "7408096624650872", -208},
    {1.3904317799706759216967795e+109, "1390431779970676", 110},
    {2.7230669665447205632301667e+163, "27230669665447206", 164},
    {2.5539869339127186429938226e+224, "25539869339127186", 225},
    {1.7541517147405146317280038e+276, "17541517147405146", 277},
    {7.2068556077512162055860322e+46, "7206855607751216", 47},
    {3.7901294897790920619762957e-218, "3790129489779092", -217},
    {5.2518685165119813460097926e-148, "5251868516511981", -147},
    {2.6375776127927337670808346e-210, "26375776127927338", -209},
    {1.2159828884977275284759753e+176, "12159828884977275", 177},
    {4.4601894070722418765895723e-254, "4460189407072242", -253},
    {9.1009603805219136301129609e-237, "9100960380521914", -236},
    {3.9753356428269466786779235e-140, "39753356428269467", -139},
    {1.0671069596048551892630912e-258, "10671069596048552", -257},
    {1.7262421313797824007001440e+72, "17262421313797824", 73},
    {1.5392721143894325941801071e+07, "15392721143894326", 8},
    {7.3691404357854402573491497e-188, "736914043578544", -187},
    {2.1567483088712295710041950e-256, "21567483088712296", -255},
    {2.6465458552912494165601928e+116, "26465458552912494", 117},
    {1.5733787993023537615975525e-202, "15733787993023538", -201},
    {7.7822960357755694017782018e-275, "778229603577557", -274},
    {2.7134863302416116357562490e+119, "27134863302416116", 120},
    {1.2845595218877538541490515e+119, "12845595218877539", 120},
    {6.9292050504696483025433093e-89, "6929205050469648", -88},
    {1.9365484547371442977752152e-103, "19365484547371443", -102},
    {1.8900887580191382744480438e+77, "18900887580191383", 78},
    {1.3506693875781382982576243e-217, "13506693875781383", -216},
    {2.8192088203287625453279334e+226, "28192088203287625", 227},
    {1.1625095140983653951995958e-63, "11625095140983654", -62},
    {3.0923872183647088038247289e-102, "3092387218364709", -101},
    {6.8838698008231163680433779e-252, "6883869800823116", -251},
    {4.7752135517202431882131357e+300, "4775213551720243", 301},
    {8.0953689663209744896225281e+305, "8095368966320974", 306},
    {1.5730812934646151417513977e-258, "15730812934646151", -257},
    {1.8169635608125940076776709e+209, "1816963560812594", 210},
    {1.0535625527014485324541021e+145, "10535625527014485", 146},
    {4.3022460351920847648505870e+45, "4302246035192085", 46},
    {3.7662593118826801580833393e-32, "376625931188268", -31},
    {2.9185743713255980511224706e+265, "2918574371325598", 266},
    {3.7980780000580199335496709e-283, "379807800005802", -282},
    {1.7363424162294673615549584e-171, "17363424162294674", -170},
    {2.5659476735822388658054740e+271, "2565947673582239", 272},
    {8.8195065443231213926196064e-66, "8819506544323121", -65},
    {1.4948153018914135019863488e+84, "14948153018914135", 85},
    {7.6923232194211651398090190e+263, "7692323219421165", 264},
    {3.6335319512971771925592214e-248, "3633531951297177", -247},
    {5.7247975503699201944429724e-121, "572479755036992", -120},
    {8.4443076743942437978488377e-29, "8444307674394244", -28},
    {7.6652197518275573018917534e+127, "7665219751827557", 128},
    {2.3904564406280472062060965e-127, "23904564406280472", -126},
    {4.7520718373496453379579309e+216, "47520718373496453", 217},
    {3.7760835477865522651822254e-116, "3776083547786552", -115},
    {1.6842876975212922277214467e+121, "16842876975212922", 122},
    {1.1803794418869558277374285e-163, "11803794418869558", -162},
    {2.2116416972752633253471994e+152, "22116416972752633", 153},
    {1.6438207445783066997509541e-222, "16438207445783067", -221},
    {2.7099029338494855004184239e+196, "27099029338494855", 197},
    {3.0375363201776922826148865e-55, "30375363201776923", -54},
    {7.4536226770261629826091396e+123, "7453622677026163", 124},
    {8.2719425652264988472799242e-286, "8271942565226499", -285},
    {2.4670737244198970444564987e+99, "2467073724419897", 100},
    {3.7816314384908639634450215e-202, "3781631438490864", -201},
    {3.3545386525027226882834647e-250, "33545386525027227", -249},
    {3.7569367430488050980104457e-72, "3756936743048805", -71},
    {5.2532523972700632582882364e+297, "5253252397270063", 298},
    {7.9163963109087197491385055e-308, "791639631090872", -307},
    {2.5131112921338357941387270e-73, "25131112921338358", -72},
    {4.3862304961910489412804580e-141, "4386230496191049", -140},
    {1.2973925124338364205146513e-65, "12973925124338364", -64},
    {1.0784238393092159884387851e-230, "1078423839309216", -229},
    {1.4191514629935380042979887e+01, "1419151462993538", 2},
    {1.1635043689180190069071701e+204, "1163504368918019", 205},
    {8.7170818680892362690238780e-255, "8717081868089236", -254},
    {3.4580691938173936899434912e+31, "34580691938173937", 32},
    {8.0088550740775064351548141e-52, "8008855074077506", -51},
    {3.2740298085736389580417148e-263, "3274029808573639", -262},
    {1.2817411264379571278157713e-298, "12817411264379571", -297},
    {7.2697775405877890017020359e-92, "7269777540587789", -91},
    {1.1323686757243325028771728e-39, "11323686757243325", -38},
    {1.1030581024637794046706686e+116, "11030581024637794", 117},
    {1.0673185955682676905061248e-58, "10673185955682677", -57},
    {4.6294451596084586167417657e-93, "4629445159608459", -92},
    {1.7131318355465987217932858e+97, "17131318355465987", 98},
    {4.8661178604925136519193705e-191, "48661178604925137", -190},
    {5.2048842121253636988499051e-204, "5204884212125364", -203},
    {4.8184647468468127817844148e-81, "4818464746846813", -80},
    {4.4187247039765103728659843e+155, "441872470397651", 156},
    {1.1446285414158483548216745e+210, "11446285414158484", 211},
    {1.9973734047144395391790580e+146, "19973734047144395", 147},
    {3.9974726973874036648265463e-72, "39974726973874037", -71},
    {4.8030975674732053906772691e-39, "48030975674732054", -38},
    {1.5895033125087428460895665e+293, "15895033125087428", 294},
    {1.2851889227866878903610562e+140, "12851889227866879", 141},
    {6.0529018097025288719335842e-281, "6052901809702529", -280},
    {6.4422898947203062919564999e-240, "6442289894720306", -239},
    {4.5326904442188243618124047e-11, "45326904442188244", -10},
    {8.3839362118650822779444579e+272, "8383936211865082", 273},
    {6.7097751213211406359858146e-243, "6709775121321141", -242},
    {1.7181190635037713075738329e+66, "17181190635037713", 67},
    {4.0886054398474239575384608e-279, "4088605439847424", -278},
    {7.2718741441281228164948738e-112, "7271874144128123", -111},
    {2.4961488551628589665154756e-55, "2496148855162859", -54},
    {6.5907539597671628396016616e+161, "6590753959767163", 162},
    {2.8836700616200832919582887e+50, "28836700616200833", 51},
    {4.0328131337011438301066230e-203, "4032813133701144", -202},
    {9.4888742289621567293934568e-225, "9488874228962157", -224},
    {5.7707367031698649768751097e+113, "5770736703169865", 114},
    {2.0267840243589233398437500e+10, "20267840243589233", 11},
    {1.1545977795563052808603335e-40, "11545977795563053", -39},
    {4.1335321865460695444691172e+286, "41335321865460695", 287},
    {6.5772398264010885426897184e-265, "6577239826401089", -264},
    {6.7836834146870308068320388e-77, "6783683414687031", -76},
    {2.0319882543290525023314277e+207, "20319882543290525", 208},
    {1.2717636010414601162528676e-180, "12717636010414601", -179},
    {1.6849553806956508804776180e+37, "16849553806956509", 38},
    {5.2528691164421962295942784e-35, "5252869116442196", -34},
    {2.4357098934473678247218858e+51, "24357098934473678", 52},
    {6.4744957883558632673740947e+110, "6474495788355863", 111},
    {6.8855744140527824510710605e+112, "68855744140527825", 113},
    {9.1418188665839572379456800e+120, "9141818866583957", 121},
    {3.1724560160292879451323883e-46, "3172456016029288", -45},
    {3.0277718797801574692130089e+05, "30277718797801575", 6},
    {1.7682472005404853964843074e+125, "17682472005404854", 126},
    {1.1631926142125219822328873e+139, "1163192614212522", 140},
    {9.7088433924723966050654812e-76, "9708843392472397", -75},
    {7.6628855851962159494918519e-280, "7662885585196216", -279},
    {5.7071995388373758235932048e-224, "5707199538837376", -223},
    {6.0975159353591668184833978e+212, "6097515935359167", 213},
    {3.3728552314555478851357553e-36, "3372855231455548", -35},
    {7.0099747343330702278240250e+200, "700997473433307", 201},
    {2.2371366928360816000000000e+16, "22371366928360816", 17},
    {5.7915829286559594924483568e+105, "579158292865596", 106},
    {1.0515016633666118385046433e-21, "10515016633666118", -20},
    {2.9740794564746050260530910e+75, "2974079456474605", 76},
    {3.7056243347821469121243837e+95, "3705624334782147", 96},
    {2.9126083096736377198230997e-302, "29126083096736377", -301},
    {2.0376024438552717265857802e-67, "20376024438552717", -66},
    {2.8434305655485980710730443e+144, "2843430565548598", 145},
    {5.2192184166595123700464927e+93, "5219218416659512", 94},
    {1.2017279284144760691824585e+273, "1201727928414476", 274},
    {3.7498077792911711579760401e-209, "3749807779291171", -208},
    {5.8602362885924468476261150e-58, "5860236288592447", -57},
    {1.0889798078911260535300455e-294, "1088979807891126", -293},
    {1.8403831310240870305469746e-261, "1840383131024087", -260},
    {4.6735828156677603304743909e+81, "467358281566776", 82},
    {1.9429775110377027910350608e-99, "19429775110377028", -98},
    {7.0035411200319551494783056e+33, "7003541120031955", 34},
    {2.7546458782475101751477995e+194, "27546458782475102", 195},
    {2.1270980662727981183368394e+76, "2127098066272798", 77},
    {1.8853454109924647362164636e+269, "18853454109924647", 270},
    {1.8021330234330731121620979e-305, "1802133023433073", -304},
    {5.9744466735859000841804090e+245, "59744466735859", 246},
    {9.9418777725598281438227379e-31, "9941877772559828", -30},
    {1.0940522670959912765672333e+116, "10940522670959913", 117},
    {3.2573274740956361819648038e+252, "3257327474095636", 253},
    {2.8407395362018013141073882e-112, "28407395362018013", -111},
    {1.1302875241842865943908691e+07, "11302875241842866", 8},
    {2.9234254248041549660160000e+21, "2923425424804155", 22},
    {6.8792502554352692390607463e-35, "6879250255435269", -34},
    {8.5693685541237838887263837e-275, "8569368554123784", -274},
    {2.0217386579425224753869621e+136, "20217386579425225", 137},
    {1.7159367532618179537723234e+163, "1715936753261818", 164},
    {1.8239802757312364881021812e+75, "18239802757312365", 76},
    {1.4397778648298307465024442e+93, "14397778648298307", 94},
    {1.4843615557808576067750547e+299, "14843615557808576", 300},
    {1.1484317615911171503818923e-49, "11484317615911172", -48},
    {1.5210478393358464521472814e-05, "15210478393358465", -4},
    {9.5068381560703689248311158e-44, "9506838156070369", -43},
    {2.0899274603648372074682158e-10, "20899274603648372", -9},
    {5.4547345909396803522166735e-67, "54547345909396804", -66},
    {2.4408769987949945518764711e-121, "24408769987949946", -120},
    {4.8675967453873099636935012e-208, "486759674538731", -207},
    {1.1660973012527451680964713e+286, "11660973012527452", 287},
    {1.3584185296898794363785277e+283, "13584185296898794", 284},
    {1.3126361689355093606400000e+20, "13126361689355094", 21},
    {3.7629105623853834832952503e+51, "37629105623853835", 52},
    {4.7914087761862295933844118e-259, "47914087761862296", -258},
    {1.1122735425559756817588000e+285, "11122735425559757", 286},
    {4.6195439421935348647510937e+274, "4619543942193535", 275},
    {4.2273165484420319928208781e-147, "4227316548442032", -146},
    {4.3477202553551730695714119e-275, "4347720255355173", -274},
    {1.2449974377873191123336694e+220, "1244997437787319", 221},
    {2.3141184113195904994192523e-195, "23141184113195905", -194},
    {1.6971228699171440718266419e-192, "1697122869917144", -191},
    {1.9001715131175477656321009e+242, "19001715131175478", 243},
    {3.0264903766571463010799171e+106, "30264903766571463", 107},
    {1.6638576499268269197022135e-205, "1663857649926827", -204},
    {4.2920709317624843370720659e+215, "4292070931762484", 216},
    {3.4568072474300902303292883e+63, "345680724743009", 64},
    {9.5709519529625322609156512e-02, "9570951952962532", -1},
    {1.0377127508923743165252839e-46, "10377127508923743", -45},
    {3.1996280527536752881846548e+174, "31996280527536753", 175},
    {6.1837508642019688582554665e-145, "6183750864201969", -144},
    {6.0245103767155370802607199e+229, "6024510376715537", 230},
    {3.1028539673224164985391731e+224, "31028539673224165", 225},
    {5.2082193712686171191242299e-24, "5208219371268617", -23},
    {1.6780796089502572719199690e+144, "16780796089502573", 145},
    {1.2937409921797947097137177e+279, "12937409921797947", 280},
    {6.2781622143688742186070694e+141, "6278162214368874", 142},
    {6.9566345060895146422176180e+64, "6956634506089515", 65},
    {5.5534492758793791563991258e-295, "5553449275879379", -294},
    {1.7268574948107733731872512e-186, "17268574948107734", -185},
    {2.8091576609442482729727462e+293, "28091576609442483", 294},
    {2.0163903765817512758076191e+06, "20163903765817513", 7},
    {2.6529648956302100250489792e-08, "265296489563021", -7},
    {3.0172229899286433573390220e+287, "30172229899286434", 288},
    {1.5796525645105892070266619e+250, "15796525645105892", 251},
    {1.3899411024222675443294788e-305, "13899411024222675", -304},
    {1.6890622424991442032681541e-254, "16890622424991442", -253},
    {1.2248612394209346034980928e+164, "12248612394209346", 165},
    {5.5165788393241439222362584e-145, "5516578839324144", -144},
    {1.5025505254405001629551786e-234, "15025505254405002", -233},
    {9.4372584264545097806539162e-164, "943725842645451", -163},
    {2.8388713687749920626935039e-261, "2838871368774992", -260},
    {1.1107944625258623068136214e-107, "11107944625258623", -106},
    {1.1945140696640511603238471e+117, "11945140696640512", 118},
    {3.3464266337194187762543866e+42, "3346426633719419", 43},
    {2.6782039520676159848936535e+143, "2678203952067616", 144},
    {4.2546918512129378168144567e+143, "4254691851212938", 144},
    {4.1327178197465666005561809e+89, "41327178197465666", 90},
    {8.9898032657939288765192032e+06, "8989803265793929", 7},
    {4.4341311445476514619653924e-42, "44341311445476515", -41},
    {1.3311207255147909692991610e-139, "1331120725514791", -138},
    {3.5467900970497877279746765e-155, "35467900970497877", -154},
    {6.2898579787423062354204520e+291, "6289857978742306", 292},
    {2.3135281077319207670914974e+180, "23135281077319208", 181},
    {1.8186244957757851153848080e-197, "1818624495775785", -196},
    {1.9646389679865920750856450e-288, "1964638967986592", -287},
    {2.4777747335142575251053601e-269, "24777747335142575", -268},
    {2.6437045340917208144948560e-38, "2643704534091721", -37},
    {1.4846808047409345692020711e+61, "14846808047409346", 62},
    {2.7548685237750312766905062e+233, "27548685237750313", 234},
    {1.3227120738424102340623777e+112, "13227120738424102", 113},
    {3.9868648587449331005218516e+210, "3986864858744933", 211},
    {5.4026178215008098530295802e+32, "540261782150081", 33},
    {3.3103418043615805445315710e+53, "33103418043615805", 54},
    {1.9954065818229606513380060e+179, "19954065818229607", 180},
    {2.7636080934786004561101700e+243, "27636080934786005", 244},
    {7.6660014998239626830791684e+159, "7666001499823963", 160},
    {1.2443495714009270822933162e+125, "1244349571400927", 126},
    {3.3155158005917207528948346e+119, "3315515800591721", 120},
    {1.9922686533216012322759976e-149, "19922686533216012", -148},
    {1.0745297784336463065339218e+215, "10745297784336463", 216},
    {1.3400836305439350809300103e-179, "1340083630543935", -178},
    {2.4137428568914871652203945e-79, "24137428568914872", -78},
    {1.4379121747435068635343594e+111, "14379121747435069", 112},
    {5.8884859566077765384705926e+106, "58884859566077765", 107},
    {1.0400871546001037201104542e-25, "10400871546001037", -24},
    {1.0146418535776706616390368e+160, "10146418535776707", 161},
    {4.1248736658394838459666846e+80, "4124873665839484", 81},
    {1.9943905383026111965482498e-207, "19943905383026112", -206},
    {2.9880256541344247094823346e-73, "2988025654134425", -72},
    {1.0536785643209175014121197e-210, "10536785643209175", -209},
    {1.4613389594708695697550442e+150, "14613389594708696", 151},
    {2.6620456730591679943052221e+229, "2662045673059168", 230},
    {1.5835700498696073345589867e-41, "15835700498696073", -40},
    {5.8579823284429795468060162e-123, "58579823284429795", -122},
    {1.3862252186366451104770555e+151, "1386225218636645", 152},
    {9.7251832154064286837400161e-202, "9725183215406429", -201},
    {1.4695131275632726300594590e-198, "14695131275632726", -197},
    {1.4227545306465769980482191e-229, "1422754530646577", -228},
    {7.3315338180609749401864990e-107, "7331533818060975", -106},
    {5.2872558043729377399828112e+135, "5287255804372938", 136},
    {1.7812863375864898540790193e-01, "17812863375864899", 0},
    {4.1317740672934386961956281e-119, "41317740672934387", -118},
    {2.1893051033709809232373478e-275, "2189305103370981", -274},
    {1.6773636263468008296093121e+217, "16773636263468008", 218},
    {3.6867834885498045440000000e+18, "36867834885498045", 19},
    {1.2282865899061131280606220e-91, "1228286589906113", -90},
    {3.4958951298486624823477439e+72, "34958951298486625", 73},
    {4.6211137836993874647220172e-149, "46211137836993875", -148},
    {1.9518108617711995290583710e-78, "19518108617711995", -77},
    {9.7573833986696666811872242e+165, "9757383398669667", 166},
    {1.0769373397007478565706834e+212, "10769373397007479", 213},
    {1.6569070230247916491437535e+197, "16569070230247916", 198},
    {3.0080748103020847593078457e-13, "3008074810302085", -12},
    {1.6463981592218917833265355e+245, "16463981592218918", 246},
    {4.9196902129783203398780540e+136, "491969021297832", 137},
    {2.2933545113350868645019910e+28, "2293354511335087", 29},
    {2.5245092639892711014400000e+20, "2524509263989271", 21},
    {5.8366420046032519025970216e+154, "5836642004603252", 155},
    {1.3399496922373487052814145e-225, "13399496922373487", -224},
    {9.8921667068728284186247882e-113, "9892166706872828", -112},
    {4.2963218485320594540429469e-153, "42963218485320595", -152},
    {1.1477747235031443327132436e+89, "11477747235031443", 90},
    {2.6199891428247457410436017e+216, "26199891428247457", 217},
    {4.7068861265180428037443427e-20, "4706886126518043", -19},
    {2.7233876625138576811543174e-301, "27233876625138577", -300},
    {5.5534712517636705756975911e+40, "5553471251763671", 41},
    {1.0355585704670911070071733e+179, "10355585704670911", 180},
    {4.6152943795449861043333861e+232, "4615294379544986", 233},
    {4.4329949420965540989145998e+287, "4432994942096554", 288},
    {1.3734505197490912442677052e-25, "13734505197490912", -24},
    {3.4632177967625226665660958e-249, "34632177967625227", -248},
    {2.6468709840768083096525931e+300, "26468709840768083", 301},
    {3.1923023878675898504039024e-204, "319230238786759", -203},
    {9.6901067968313077120775817e-118, "9690106796831308", -117},
    {9.3552551619591468231799216e-78, "9355255161959147", -77},
    {3.1460874020515028836312608e-34, "3146087402051503", -33},
    {1.4834950310307608291041930e-30, "14834950310307608", -29},
    {9.1857054951564978114087159e-169, "9185705495156498", -168},
    {1.1311288890091720443283831e+95, "1131128889009172", 96},
    {1.1539039771515792301593931e+250, "11539039771515792", 251},
    {2.6695401568801215625000000e+14, "26695401568801216", 15},
    {6.4066203610888282709116709e+170, "6406620361088828", 171},
    {5.8931148809157406975900779e-32, "5893114880915741", -31},
    {3.3341406933131185831077253e-85, "33341406933131186", -84},
    {9.3647369097108657728642845e-304, "9364736909710866", -303},
    {2.6536793623486427577299296e-180, "26536793623486428", -179},
    {2.5954967276497974348258957e+63, "25954967276497974", 64},
    {1.5819459515473433228093976e-20, "15819459515473433", -19},
    {1.9209530465747910716519057e+139, "1920953046574791", 140},
    {4.5662500420945357335431743e+173, "4566250042094536", 174},
    {1.7669380159834469034171121e-160, "1766938015983447", -159},
    {3.7380443473152383326806551e+52, "37380443473152383", 53},
    {2.0791898903228667582689802e-145, "20791898903228668", -144},
    {1.3310054110364978533698403e-22, "13310054110364979", -21},
    {4.0172783010441669404389015e+188, "4017278301044167", 189},
    {4.2716484119817286874370386e-189, "4271648411981729", -188},
    {6.1638545488473871989627912e-301, "6163854548847387", -300},
    {6.3705330003954475161936005e-110, "6370533000395448", -109},
    {1.8646320357770553649989171e+261, "18646320357770554", 262},
    {1.1655898526867138297117260e+296, "11655898526867138", 297},
    {8.1025938232344751668279059e+03, "8102593823234475", 4},
    {1.1377556469259901331439831e-227, "11377556469259901", -226},
    {4.4674661579844711732702682e-272, "4467466157984471", -271},
    {2.0853776043942166057598609e+223, "20853776043942166", 224},
    {3.4855218111041911652884425e+205, "3485521811104191", 206},
    {2.1446929919814993395975891e+33, "21446929919814993", 34},
    {1.1691908887618759477518583e+69, "1169190888761876", 70},
    {1.6351818023830173756185833e+273, "16351818023830174", 274},
    {2.7681139420287080750437969e-03, "2768113942028708", -2},
    {8.0276435466714979279364427e-140, "8027643546671498", -139},
    {6.4261537916073617651969902e+268, "6426153791607362", 269},
    {1.7395519112764197595411903e-170, "17395519112764198", -169},
    {2.1544429726189412174576192e+86, "21544429726189412", 87},
    {1.2037635771303861833309814e+190, "12037635771303862", 191},
    {1.2004537597847666482853654e+214, "12004537597847666", 215},
    {3.7201588213049024934489631e-277, "37201588213049025", -276},
    {2.2001178169640559363077196e+203, "2200117816964056", 204},
    {7.3374223454398020876078331e-114, "7337422345439802", -113},
    {2.1987769059059621233543066e-74, "2198776905905962", -73},
    {9.5278297685757682325782250e-105, "9527829768575768", -104},
    {9.3813476709595888385943241e+213, "9381347670959589", 214},
    {3.1430143197630081371652352e-126, "3143014319763008", -125},
    {6.8948666284504164791627390e+263, "6894866628450416", 264},
    {7.0162036953892265908715366e-81, "7016203695389227", -80},
    {2.9714275385746265046064229e+160, "29714275385746265", 161},
    {1.2228067938667902454551865e-179, "12228067938667902", -178},
    {2.6138027007986976159601206e+176, "26138027007986976", 177},
    {3.5070879955424935276179920e-13, "35070879955424935", -12},
    {3.7390815724949309285685129e+85, "3739081572494931", 86},
    {2.9291699193342452080757816e+66, "29291699193342452", 67},
    {1.1341395567195355418883009e-255, "11341395567195355", -254},
    {1.5713002454750541889872393e-189, "15713002454750542", -188},
    {3.6665108996142571629542145e+303, "3666510899614257", 304},
    {1.1872931003302404247047154e+288, "11872931003302404", 289},
    {5.5756623982263770613859281e-86, "5575662398226377", -85},
    {2.2108343980810071081480608e-285, "2210834398081007", -284},
    {1.1231423081263346231073021e-44, "11231423081263346", -43},
    {2.8653576905844026648290110e-50, "28653576905844027", -49},
    {8.4145882320008782404714976e+158, "8414588232000878", 159},
    {2.8214910725854011682439618e+72, "2821491072585401", 73},
    {4.5779896109475229134935405e+53, "4577989610947523", 54},
    {7.1276627278812810463327913e-35, "7127662727881281", -34},
    {8.0650632171464944325230103e+87, "8065063217146494", 88},
    {8.1474687149718049008894100e-158, "8147468714971805", -157},
    {1.8428916542788583813580752e-287, "18428916542788584", -286},
    {4.1092905149931851268884433e-75, "4109290514993185", -74},
    {2.7237843484895322748735100e+278, "27237843484895323", 279},
    {9.5920696283496009959016774e+86, "9592069628349601", 87},
    {2.3944579190646871315847075e-257, "2394457919064687", -256},
    {1.3404903873965198371647162e+65, "13404903873965198", 66},
    {3.8095247325669666696138174e-137, "38095247325669667", -136},
    {1.2290778076535164185890538e+243, "12290778076535164", 244},
    {1.0454128454924612788829791e+185, "10454128454924613", 186},
    {7.1857014708679882394108654e+33, "7185701470867988", 34},
    {3.9205354190246769479609310e-154, "3920535419024677", -153},
    {1.7160628589332319241114864e+278, "1716062858933232", 279},
    {1.7273430637922576317247473e-259, "17273430637922576", -258},
    {6.0699861215638003943333779e+66, "60699861215638004", 67},
    {4.6737196465674546138489557e-144, "46737196465674546", -143},
    {3.1105418703434942257060429e-253, "3110541870343494", -252},
    {1.9621971870953496838829348e-238, "19621971870953497", -237},
    {5.4066828901336971970681689e+186, "5406682890133697", 187},
    {6.0361266368321733265409320e-47, "6036126636832173", -46},
    {6.0328618333528646239057210e-49, "6032861833352865", -48},
    {1.8509119939240546799079683e-156, "18509119939240547", -155},
    {7.4834143853937602747440741e+306, "748341438539376", 307},
    {2.7254961019116274549136591e+73, "27254961019116275", 74},
    {1.6425498471598394915390522e+255, "16425498471598395", 256},
    {1.0415390286525136000000000e+17, "10415390286525136", 18},
    {1.5386741452809281271168217e-263, "15386741452809281", -262},
    {4.0006281210056870729755590e+91, "4000628121005687", 92},
    {1.6810689252308630633875243e+28, "1681068925230863", 29},
    {1.4368166924510647433494589e-94, "14368166924510647", -93},
    {8.1218068372928262588955528e-173, "8121806837292826", -172},
    {1.5782007269759620683336267e-136, "1578200726975962", -135},
    {2.2487368333096221978278352e+249, "2248736833309622", 250},
    {4.7988812383288201202765030e+148, "479888123832882", 149},
    {1.1826697443920103136322403e+213, "11826697443920103", 214},
    {8.9165207018169758012383477e+244, "8916520701816976", 245},
    {1.0081389331840876714680919e+152, "10081389331840877", 153},
    {5.6851198324118778738991354e-25, "5685119832411878", -24},
    {4.4447260248374781020034435e-05, "4444726024837478", -4},
    {2.6897785308836145736930311e-288, "26897785308836146", -287},
    {1.0612564497033730436672436e-182, "1061256449703373", -181},
    {1.0519911743313860603740138e+86, "1051991174331386", 87},
    {1.9151618132216443329397879e-278, "19151618132216443", -277},
    {1.8943270826312224615385629e-228, "18943270826312225", -227},
    {3.6125248338667057098807180e+278, "3612524833866706", 279},
    {2.1232736931990566726746618e+279, "21232736931990567", 280},
    {5.2639709479804895915813865e-79, "52639709479804896", -78},
    {5.1521957416296443890166068e+51, "51521957416296444", 52},
    {2.3374468175574419180442040e-278, "2337446817557442", -277},
    {1.2586620722667789098441729e+54, "12586620722667789", 55},
    {6.9371817419201361068121650e+218, "6937181741920136", 219},
    {3.2539295285204505013919785e+70, "32539295285204505", 71},
    {1.8099912875042454464545014e-237, "18099912875042454", -236},
    {5.9415200589931037724328480e+256, "5941520058993104", 257},
    {2.7411828536569512276637912e-64, "27411828536569512", -63},
    {4.3590577907664571347708195e+276, "4359057790766457", 277},
    {2.7415661304148847382377386e-288, "27415661304148847", -287},
    {3.3338150666064231191842333e+225, "3333815066606423", 226},
    {4.3681094988977032609827407e-257, "4368109498897703", -256},
    {5.3428404128347327527258347e+154, "5342840412834733", 155},
    {1.1324517324954021931253760e+24, "11324517324954022", 25},
    {1.7171592367372444902777286e+105, "17171592367372445", 106},
    {7.7965676655614676861785438e-308, "7796567665561468", -307},
    {1.2711612785405927992915625e-91, "12711612785405928", -90},
    {1.3997911565693697839130702e-54, "13997911565693698", -53},
    {1.6077914666272515168696232e-49, "16077914666272515", -48},
    {1.7667153671151266546205554e+231, "17667153671151267", 232},
    {8.5100711771809092079553570e+251, "8510071177180909", 252},
    {9.6617889221432581543922424e+07, "9661788922143258", 8},
    {1.0441861993239653004953133e-68, "10441861993239653", -67},
    {2.2855101195932582230746160e+157, "22855101195932582", 158},
    {1.5288119518065143566942969e-258, "15288119518065144", -257},
    {2.8640298493673681476728063e-278, "2864029849367368", -277},
    {3.6709015186303273521689834e+83, "36709015186303274", 84},
    {7.4227194212543177534623190e-87, "7422719421254318", -86},
    {6.1349624450246155013024378e-154, "6134962445024616", -153},
    {3.4513657785464249528668020e-251, "3451365778546425", -250},
    {1.4192838371943571049002690e-85, "1419283837194357", -84},
    {4.3951458983310326049933906e-164, "43951458983310326", -163},
    {1.0719553952831258687799401e+298, "10719553952831259", 299},
    {4.2752486177073973446311157e-288, "4275248617707397", -287},
    {4.7218856750460104851080187e+35, "47218856750460105", 36},
    {4.1025419091588011289576913e-22, "4102541909158801", -21},
    {1.9166088471124847056306897e-88, "19166088471124847", -87},
    {3.8594323621233994392695107e+63, "38594323621233994", 64},
    {1.2413991746131849807490591e+51, "1241399174613185", 52},
    {2.0436123802739383608747817e+42, "20436123802739384", 43},
    {3.6257741267223763575151782e-297, "36257741267223764", -296},
    {1.7926746575357343881902209e+197, "17926746575357344", 198},
    {6.0828570217141255321827346e-273, "60828570217141255", -272},
    {2.8728340257814023437500000e+13, "28728340257814023", 14},
    {1.0744439201667634050234311e+304, "10744439201667634", 305},
    {7.3613771371468652412528609e+119, "7361377137146865", 120},
    {1.9515699151155892228035910e-269, "19515699151155892", -268},
    {1.7908333726001946897311174e-162, "17908333726001947", -161},
    {2.6362285509714438139155010e+219, "26362285509714438", 220},
    {6.8294331935070122065302966e+97, "6829433193507012", 98},
    {2.2264233551732494612297140e+222, "22264233551732495", 223},
    {1.6634055030923356186444858e-44, "16634055030923356", -43},
    {2.0409268435126235161761783e+171, "20409268435126235", 172},
    {6.3157299430501200290832277e-118, "631572994305012", -117},
    {1.2846917029834675502024853e-250, "12846917029834676", -249},
    {1.2327692482780222032190863e+108, "12327692482780222", 109},
    {8.1175776792309716258022797e+219, "8117577679230972", 220},
    {4.3995016545443816006152335e-40, "4399501654544382", -39},
    {5.4351490199911567170394553e-148, "5435149019991157", -147},
    {6.5683484060433919919015493e+74, "6568348406043392", 75},
    {2.5908992809122057800838141e-300, "25908992809122058", -299},
    {5.9341148717382363392279026e+66, "5934114871738236", 67},
    {1.5427829854337181502276182e+251, "15427829854337182", 252},
    {1.3595931855709284124129369e-83, "13595931855709284", -82},
    {6.0895398558161143851270900e+164, "6089539855816114", 165},
    {5.1227684442197701752325382e-198, "512276844421977", -197},
    {1.9805112508373722287395016e+147, "19805112508373722", 148},
    {4.5232671809414772146867464e-255, "4523267180941477", -254},
    {1.8850952944364249561748687e-289, "1885095294436425", -288},
    {2.7153007602306704437689036e-110, "27153007602306704", -109},
    {4.8002770243734736972355176e+65, "4800277024373474", 66},
    {1.4514678665440205742533701e-217, "14514678665440206", -216},
    {1.9228572913157492115655477e+250, "19228572913157492", 251},
    {6.0123269883898290739455174e+134, "6012326988389829", 135},
    {4.1985844635387283738438930e+45, "41985844635387284", 46},
    {3.4549485728050023305298853e+155, "34549485728050023", 156},
    {6.3320260222965452442312507e-102, "6332026022296545", -101},
    {1.9087385926636812586265680e+154, "19087385926636813", 155},
    {2.1040968071093964464019212e+133, "21040968071093964", 134},
    {3.3199938964371807985119579e+269, "3319993896437181", 270},
    {1.0003370056565257672919356e+278, "10003370056565258", 279},
    {3.9264912497331257755293224e-271, "3926491249733126", -270},
    {2.6253224902681215890964950e-01, "26253224902681216", 0},
    {3.5247167169998841800928555e+86, "3524716716999884", 87},
    {1.3656920725287266627451897e-169, "13656920725287267", -168},
    {1.8311586856117597045642959e+59, "18311586856117597", 60},
    {1.1207009221432407163929946e-106, "11207009221432407", -105},
    {4.8144284686841484428988129e-138, "48144284686841484", -137},
    {1.3682559951431350564138035e+111, "1368255995143135", 112},
    {2.8877706632656194926254072e-145, "28877706632656195", -144},
    {6.5854076878634640645509258e+219, "6585407687863464", 220},
    {5.1065029012877144382373228e+87, "5106502901287714", 88},
    {1.7874122017555521360669608e-234, "1787412201755552", -233},
    {1.9791096270618609930344437e+189, "1979109627061861", 190},
    {1.5951511411013570295313740e-160, "1595151141101357", -159},
    {1.9797095270340426433718297e-234, "19797095270340426", -233},
    {8.2707636419894972516011250e+30, "8270763641989497", 31},
    {2.4712857761093485339914625e-39, "24712857761093485", -38},
    {5.1898794001534287872000000e+19, "5189879400153429", 20},
    {7.1879786815367033638617912e+48, "7187978681536703", 49},
    {2.8887255796054993059102600e-126, "28887255796054993", -125},
    {1.1597378234802191698427893e-69, "11597378234802192", -68},
    {5.2662729467054248237846668e-163, "5266272946705425", -162},
    {1.7364386348294097886029735e+59, "17364386348294098", 60},
    {5.8853457286923720731468204e+73, "5885345728692372", 74},
    {3.4161168542852820381436172e+302, "3416116854285282", 303},
    {1.2651135265478225764366553e+132, "12651135265478226", 133},
    {1.6751564937208859558555334e+75, "1675156493720886", 76},
    {1.9984395039481344545853534e+114, "19984395039481345", 115},
    {1.7936714387060586521182248e+248, "17936714387060587", 249},
    {2.5101597067940929704538066e-242, "2510159706794093", -241},
    {5.0005149784693860819969913e+140, "5000514978469386", 141},
    {1.2243347502005350888642668e-110, "12243347502005351", -109},
    {2.9209650188845529840794116e-297, "2920965018884553", -296},
    {7.5731130662015528253781193e-203, "7573113066201553", -202},
    {1.4951882917186607866758996e+186, "14951882917186608", 187},
    {4.7111083987675178527832031e+10, "4711108398767518", 11},
    {2.2826135918904259038392210e-275, "2282613591890426", -274},
    {2.6739708693918896916053051e+67, "26739708693918897", 68},
    {4.6497302468782288790402803e+203, "4649730246878229", 204},
    {7.7520462436700500291756554e-214, "775204624367005", -213},
    {1.4629676489165535298990748e+259, "14629676489165535", 260},
    {1.2745128654233545031080182e-213, "12745128654233545", -212},
    {6.2338793214523264109146627e+183, "6233879321452326", 184},
    {3.9911460418457227026136889e+200, "3991146041845723", 201},
    {6.0993073093781197190116593e-241, "609930730937812", -240},
    {3.7495384828838131203417958e+291, "3749538482883813", 292},
    {1.8262041988888969626507551e-301, "1826204198888897", -300},
    {1.3805738608403174395505698e+29, "13805738608403174", 30},
    {2.0597252942991574956212973e-230, "20597252942991575", -229},
    {1.8529236245357188147138535e+263, "18529236245357188", 264},
    {1.5685086837519980266733555e-236, "1568508683751998", -235},
    {1.5593546616940302697982863e-143, "15593546616940303", -142},
    {1.4022770417725596415374349e-225, "14022770417725596", -224},
    {1.4735507570305322549477811e-09, "14735507570305323", -8},
    {3.5902410955316759762184140e+254, "3590241095531676", 255},
    {1.2001260453217925589863257e-99, "12001260453217926", -98},
    {4.9071855728700069041486863e-285, "4907185572870007", -284},
    {4.2081899903722901488784815e-300, "420818999037229", -299},
    {5.1656706299173945481771443e-213, "51656706299173945", -212},
    {3.9350908514438483596595639e+29, "39350908514438484", 30},
    {1.1797162212616072664038053e-228, "11797162212616073", -227},
    {6.0072562792595261510591993e+127, "6007256279259526", 128},
    {1.8459452411699039070196213e+203, "1845945241169904", 204},
    {2.5764525264771120073427258e-131, "2576452526477112", -130},
    {8.6738963542506075138830777e-100, "8673896354250608", -99},
    {1.5022791829692241416242682e+56, "15022791829692241", 57},
    {1.2662529217575012716357159e-287, "12662529217575013", -286},
    {9.0561088269981900154019097e+149, "905610882699819", 150},
    {2.1383572864770097732543945e+09, "21383572864770098", 10},
    {2.0646188756937535131845685e-48, "20646188756937535", -47},
    {5.1173477930774253128696754e-183, "5117347793077425", -182},
    {1.0627550208425529045818084e-196, "10627550208425529", -195},
    {2.4301712948124486392565728e-98, "24301712948124486", -97},
    {4.5201679349155980755957702e-144, "4520167934915598", -143},
    {2.3429307984365481865731926e-262, "23429307984365482", -261},
    {1.3555976156460274619231050e+65, "13555976156460275", 66},
    {1.2170441359051583093348352e-229, "12170441359051583", -228},
    {1.2784362148861178139204041e+92, "12784362148861178", 93},
    {5.9019327193200833751828270e+138, "59019327193200834", 139},
    {1.3230639823378753624075712e+127, "13230639823378754", 128},
    {7.1820335905070803840150589e+29, "718203359050708", 30},
    {1.6083246541022651935406602e-273, "16083246541022652", -272},
    {1.3416053922690366618522815e+98, "13416053922690367", 99},
    {8.6925583077103169806211766e+256, "8692558307710317", 257},
    {1.0469248660556873027853624e+73, "10469248660556873", 74},
    {1.6325984712937337339896557e+193, "16325984712937337", 194},
    {2.3653837868107516443084630e-283, "23653837868107516", -282},
    {6.9484862985221329179364169e-179, "6948486298522133", -178},
    {3.7676770640844134681400013e-220, "37676770640844135", -219},
    {1.2416664446528239734634884e+38, "1241666444652824", 39},
    {1.5996550919546377982559338e+260, "15996550919546378", 261},
    {6.7114110958633917508192097e-262, "6711411095863392", -261},
    {1.0104421320841170582283520e-69, "1010442132084117", -68},
    {7.5714287108723622455973769e+252, "7571428710872362", 253},
    {6.2860051329798108095488166e+117, "6286005132979811", 118},
    {5.9136712781411601682710199e+111, "591367127814116", 112},
    {1.9909655694713886191389681e+143, "19909655694713886", 144},
    {1.6763049362406006375064501e+127, "16763049362406006", 128},
    {4.5453248254736161509914874e-17, "4545324825473616", -16},
    {3.0216652590659199955558534e+115, "302166525906592", 116},
    {4.0015948958859477223569612e-276, "4001594895885948", -275},
    {9.9939181994854584015527185e+184, "9993918199485458", 185},
    {8.0983480385272149007635350e-119, "8098348038527215", -118},
    {2.6363572505528557133612635e+33, "2636357250552856", 34},
    {4.5163791265540963080992050e+227, "4516379126554096", 228},
    {1.0616440202636527587334844e+290, "10616440202636528", 291},
    {3.5622045755485289945008079e+208, "3562204575548529", 209},
    {1.3246690307838805018201745e+247, "13246690307838805", 248},
    {3.4241005496431455328646208e+291, "34241005496431455", 292},
    {1.2309146906421538345173013e-23, "12309146906421538", -22},
    {2.2561222795551787164227301e-204, "22561222795551787", -203},
    {4.3708378152534197064297225e+158, "43708378152534197", 159},
    {6.1269498455752321972690005e-77, "6126949845575232", -76},
    {1.5723601108909389030111476e+244, "1572360110890939", 245},
    {1.0623474769763127208106469e+291, "10623474769763127", 292},
    {7.2597699444021142769249039e-91, "7259769944402114", -90},
    {8.7286978520869621674013885e+213, "8728697852086962", 214},
    {6.2565789740333322343145932e+233, "6256578974033332", 234},
    {1.4403690140772781051084800e+23, "14403690140772781", 24},
    {1.1355898596591298412800121e-179, "11355898596591298", -178},
    {1.6385434669768593078692768e+162, "16385434669768593", 163},
    {4.9537176858357520273003160e-110, "4953717685835752", -109},
    {6.7727176856949066783796654e-281, "6772717685694907", -280},
    {7.2907321033602774287254868e-230, "7290732103360277", -229},
    {2.1891160397567632301216544e-184, "21891160397567632", -183},
    {3.0336432190557788218946596e-233, "3033643219055779", -232},
    {7.3002239123332005368850018e-134, "7300223912333201", -133},
    {2.0155384641631262517273097e-73, "20155384641631263", -72},
    {3.2678853651972656250000000e+10, "32678853651972656", 11},
    {1.7342067107525687495712284e+265, "17342067107525687", 266},
    {1.5762745217338244514619031e-157, "15762745217338245", -156},
    {1.9878353045907728969933463e-74, "1987835304590773", -73},
    {3.5039668837900396950953383e+252, "35039668837900397", 253},
    {1.6554532743037074035761123e+292, "16554532743037074", 293},
    {4.2097746648391552673889604e+32, "4209774664839155", 33},
    {5.6709464560900570819565599e-30, "5670946456090057", -29},
    {4.3554085221434010165115630e-240, "4355408522143401", -239},
    {6.3697929192155160814682810e-261, "6369792919215516", -260},
    {1.3707704416604943490187145e-102, "13707704416604943", -101},
    {2.6231390018301416456556807e+66, "26231390018301416", 67},
    {9.7902166357783372594617435e+58, "9790216635778337", 59},
    {4.6309240335783521464308771e+278, "4630924033578352", 279},
    {7.2682302428784141284203117e+223, "7268230242878414", 224},
    {1.2295309416547837677578592e+86, "12295309416547838", 87},
    {7.7538265171366776053585462e+283, "7753826517136678", 284},
    {4.7010985003285788689202700e-66, "4701098500328579", -65},
    {8.6735368652686678051812221e+245, "8673536865268668", 246},
    {1.2452102537108099486204431e+268, "124521025371081", 269},
    {2.3151775295647783128437142e-69, "23151775295647783", -68},
    {8.1308528928849964136974150e-209, "8130852892884996", -208},
    {2.0742532937606763929109904e-196, "20742532937606764", -195},
    {2.5269597502442629861185995e-247, "2526959750244263", -246},
    {1.4311725526457181568313082e+247, "14311725526457182", 248},
    {3.2845399250920024132014841e-130, "32845399250920024", -129},
    {1.2054257057344050463349679e-305, "1205425705734405", -304},
    {1.4879519419911943359375000e+13, "14879519419911943", 14},
    {1.0326613704353674487392621e-171, "10326613704353674", -170},
    {1.3501342063010524285819510e+64, "13501342063010524", 65},
    {2.8962134934834826368226817e-120, "28962134934834826", -119},
    {2.3945835272383143467727958e+291, "23945835272383143", 292},
    {1.2018384886960447289222344e-54, "12018384886960447", -53},
    {7.6024789519843184411877445e+98, "7602478951984318", 99},
    {1.2531929035728487675935935e-252, "12531929035728488", -251},
    {9.8253471035720369494409882e-98, "9825347103572037", -97},
    {6.3764467477921395059966157e+201, "637644674779214", 202},
    {2.5846666249006066139730950e+120, "25846666249006066", 121},
    {4.7807616093839803424542422e+141, "47807616093839803", 142},
    {8.6769194795726767250484949e+260, "8676919479572677", 261},
    {3.3758586549882071473107108e+193, "3375858654988207", 194},
    {5.7335358213430912547737435e-29, "5733535821343091", -28},
    {1.0416020964862737607671314e+297, "10416020964862738", 298},
    {2.1987124820834435126365326e+111, "21987124820834435", 112},
    {5.2493005299253948903991476e-114, "5249300529925395", -113},
    {2.8964337637399099316496024e+280, "289643376373991", 281},
    {1.1876674697453035819278040e-147, "11876674697453036", -146},
    {6.7456358696739343261718750e+11, "6745635869673934", 12},
    {1.2631309958488261708209402e+134, "12631309958488262", 135},
    {4.3448595076755144892715546e+178, "43448595076755145", 179},
    {9.3736098134618202588624403e+95, "937360981346182", 96},
    {1.2325740396663291422513601e-175, "12325740396663291", -174},
    {2.5845283941797899621354650e+204, "258452839417979", 205},
    {1.4535626070915057781987557e+307, "14535626070915058", 308},
    {4.1969553968894991902033907e-242, "4196955396889499", -241},
    {9.6795921792397777699590532e-272, "9679592179239778", -271},
    {3.0179466259238308176607014e-82, "3017946625923831", -81},
    {2.9297024029561854565521585e+48, "29297024029561855", 49},
    {1.2434318062183942557457782e-201, "12434318062183943", -200},
    {4.1035050497828631976740512e+286, "4103505049782863", 287},
    {6.8888457615035895852817564e+30, "688884576150359", 31},
    {2.3832254359868409430728270e-266, "2383225435986841", -265},
    {3.8698540465111673056850942e-160, "3869854046511167", -159},
    {5.1284049247263327530011801e+270, "5128404924726333", 271},
    {7.3681151219904565429687500e+11, "7368115121990457", 12},
    {2.0869354183648378880479658e+272, "2086935418364838", 273},
    {1.4680679756468388308270042e+296, "14680679756468388", 297},
    {4.3824721275569110000000000e+15, "4382472127556911", 16},
    {5.1354915087145871944826872e-64, "5135491508714587", -63},
    {2.9732900231086697920562855e+177, "297329002310867", 178},
    {1.1498466877187482163857076e-231, "11498466877187482", -230},
    {6.0758115345906582359774835e-294, "6075811534590658", -293},
    {6.8216810871889287591917815e-75, "6821681087188929", -74},
    {4.0426591759184228647983304e-243, "4042659175918423", -242},
    {6.2320298508993008521028975e+115, "6232029850899301", 116},
    {4.4804667886412214612784164e+52, "44804667886412215", 53},
    {5.4469859183721617935683890e+264, "5446985918372162", 265},
    {3.1466919382284485528245600e+134, "31466919382284486", 135},
    {1.7981017789223855684401011e-194, "17981017789223856", -193},
    {9.6633184915376210652649175e-77, "9663318491537621", -76},
    {6.2266441077614553064882282e+279, "6226644107761455", 280},
    {3.2581759315342755872627243e-231, "32581759315342756", -230},
    {7.9573996106890342211693694e+107, "7957399610689034", 108},
    {1.1368628927112399066375041e-246, "11368628927112399", -245},
    {3.4848495510709650325173631e-43, "3484849551070965", -42},
    {1.2489979624632059244035105e-263, "1248997962463206", -262},
    {8.0966641513609176802750506e+104, "8096664151360918", 105},
    {2.7210888369238411599552199e+263, "2721088836923841", 264},
    {7.0940516380103310517360075e-220, "7094051638010331", -219},
    {1.4844361126984149952811184e+301, "1484436112698415", 302},
    {1.5962388584985647823464294e+185, "15962388584985648", 186},
    {6.6517821520082623246430064e-08, "6651782152008262", -7},
    {3.3617032164925810491392693e-120, "3361703216492581", -119},
    {2.6818606212059920415704798e-168, "2681860621205992", -167},
    {3.7382765977433994753631283e+210, "37382765977433995", 211},
    {6.5309378699537262252321947e+116, "6530937869953726", 117},
    {1.0649812006481129908658226e+68, "1064981200648113", 69},
    {1.7557934881231949171323440e-38, "1755793488123195", -37},
    {5.0067001592146661620479760e+202, "5006700159214666", 203},
    {1.2279072910689168996010387e+264, "1227907291068917", 265},
    {1.1450389285599763870239258e+10, "11450389285599764", 11},
    {1.3233232310530132480000000e+18, "13233232310530132", 19},
    {2.0997632832693361691513137e-109, "20997632832693362", -108},
    {2.2431742619503221351673034e-297, "2243174261950322", -296},
    {3.1780288243749953728231148e+195, "31780288243749954", 196},
    {6.7324668452303695678710938e+10, "67324668452303696", 11},
    {5.0485895103353246121072677e-120, "50485895103353246", -119},
    {8.2245530401358995586633682e+06, "82245530401359", 7},
    {3.5679843857041065237356783e-196, "35679843857041065", -195},
    {1.8332711607517124337491819e-91, "18332711607517124", -90},
    {3.3622594609020142070835388e-101, "3362259460902014", -100},
    {1.2824371495385259157621965e-181, "1282437149538526", -180},
    {1.5983346046245861776829718e+266, "15983346046245862", 267},
    {1.4219012590255777589577298e-106, "14219012590255778", -105},
    {6.2683530250847520764181047e+235, "6268353025084752", 236},
    {2.4537323351902318749389263e-187, "2453732335190232", -186},
    {6.0837181171477445548581963e+81, "60837181171477446", 82},
    {1.2421466074489641151996700e-107, "12421466074489641", -106},
    {1.0008927434649436700605185e-154, "10008927434649437", -153},
    {2.9022179271470107052676725e+94, "29022179271470107", 95},
    {1.2821084833949549106016840e+92, "12821084833949549", 93},
    {3.5447697566966402998384164e-214, "35447697566966403", -213},
    {5.0464270808818182558752596e+03, "5046427080881818", 4},
    {1.3336146009286880926186444e-43, "1333614600928688", -42},
    {6.2132984937844817352470272e+01, "6213298493784482", 2},
    {4.1212736273679482675629288e-140, "41212736273679483", -139},
    {2.2298529293382668571601311e+114, "22298529293382669", 115},
    {3.2045616520899118107426924e-55, "32045616520899118", -54},
    {8.0014552744729743200378705e-203, "8001455274472974", -202},
    {2.2416840242363055505182539e-268, "22416840242363056", -267},
    {5.7258513074059551179449158e-06, "5725851307405955", -5},
    {2.6895983411455350644984817e+270, "2689598341145535", 271},
    {3.8045588307328852446798084e-03, "38045588307328852", -2},
    {1.3905360301997399356195780e+289, "139053603019974", 290},
    {1.3018557976251397349785618e-251, "13018557976251397", -250},
    {3.9205297603947627968423560e-197, "3920529760394763", -196},
    {4.1656761120481928146015980e-29, "4165676112048193", -28},
    {1.4868792629922747003117535e-31, "14868792629922747", -30},
    {3.7940620636439025911162682e+57, "37940620636439026", 58},
    {1.8658062802747844639511015e+39, "18658062802747845", 40},
    {4.6998729704998866592358609e+119, "4699872970499887", 120},
    {3.0343235186414934560335701e-271, "30343235186414935", -270},
    {1.3321980973012815126619937e+226, "13321980973012815", 227},
    {3.6732368932148985079946073e-40, "36732368932148985", -39},
    {6.8741261038505191589060270e-121, "6874126103850519", -120},
    {6.5798791397097349428262931e+74, "6579879139709735", 75},
    {1.1253865006522556447990221e-67, "11253865006522556", -66},
    {1.1639071809317358188733889e+111, "11639071809317358", 112},
    {9.2198605169968550584918433e-125, "9219860516996855", -124},
    {2.6006739155888732777416370e-157, "26006739155888733", -156},
    {3.1569359201923351553303545e-143, "3156935920192335", -142},
    {2.4500610349369827918253614e-151, "24500610349369828", -150},
    {1.7723601546928796944832727e-141, "17723601546928797", -140},
    {4.4519554543432871238011785e-80, "4451955454343287", -79},
    {3.6674448652981406346018674e-270, "36674448652981406", -269},
    {1.1237276426463982832514466e+125, "11237276426463983", 126},
    {7.4478621204017029125702736e+256, "7447862120401703", 257},
    {2.0226325498759899717635622e-63, "202263254987599", -62},
    {1.8208725233265601258134086e+284, "182087252332656", 285},
    {1.3316131196243014080168329e-33, "13316131196243014", -32},
    {1.1691231843041350848811361e-217, "1169123184304135", -216},
    {5.8015463690378581566191529e+122, "5801546369037858", 123},
    {2.2882315329782918529524369e+297, "22882315329782919", 298},
    {7.6157522709327532070509603e+256, "7615752270932753", 257},
    {1.9466731087760010080080273e-30, "1946673108776001", -29},
    {1.9209357222467640363924740e+259, "1920935722246764", 260},
    {3.9433673620863781408452712e-16, "3943367362086378", -15},
    {1.0236163729794401870555476e+52, "10236163729794402", 53},
    {1.2611213783927330278622492e-01, "1261121378392733", 0},
    {5.5623998042744684315340495e-198, "55623998042744684", -197},
    {3.2272650668861860849467992e-190, "3227265066886186", -189},
    {2.8016217407191740718955821e-84, "2801621740719174", -83},
    {4.7256536204626006906943830e-262, "47256536204626007", -261},
    {7.5128271746351712939978577e-31, "7512827174635171", -30},
    {3.2764242710928167505771814e-12, "32764242710928168", -11},
    {5.5916044152735418299110037e-152, "5591604415273542", -151},
    {1.5266502636813711446714758e-131, "15266502636813711", -130},
    {2.6836219713131078716087015e+220, "2683621971313108", 221},
    {4.9864317278824397547753315e-191, "498643172788244", -190},
    {1.5634174405050573788316193e-35, "15634174405050574", -34},
    {6.2761581885220571154505575e-229, "6276158188522057", -228},
    {9.7577963042994603225070048e+155, "975779630429946", 156},
    {2.3367908637120569298349484e-35, "2336790863712057", -34},
    {7.9852711418761402867492373e-258, "798527114187614", -257},
    {1.2295661487340927271791499e-142, "12295661487340927", -141},
    {7.8283359344673290553664921e-153, "7828335934467329", -152},
    {6.1458311773283511884154135e+55, "6145831177328351", 56},
    {8.3308814262142810579532434e+166, "8330881426214281", 167},
    {1.2235518661647789760808857e-199, "1223551866164779", -198},
    {2.6763963064838625885606682e-05, "26763963064838626", -4},
    {2.1678780156559423507441906e-261, "21678780156559424", -260},
    {4.9612484260294527322062251e-249, "4961248426029453", -248},
    {9.3100775433626034632671129e-262, "9310077543362603", -261},
    {6.3170910415176898236592646e-248, "631709104151769", -247},
    {1.0763931067182689765044911e+123, "1076393106718269", 124},
    {3.1053322142562276294458359e-47, "31053322142562276", -46},
    {2.8508381412968376081112909e+234, "28508381412968376", 235},
    {5.5013799785784841338888319e+121, "5501379978578484", 122},
    {1.5182873740166240801995456e-76, "1518287374016624", -75},
    {1.8381838278650484671466900e+146, "18381838278650485", 147},
    {5.0113607094366402202819118e+127, "501136070943664", 128},
    {5.7198317119552185442929899e-111, "57198317119552185", -110},
    {6.7620979537122819037944044e+113, "6762097953712282", 114},
    {1.8930562862615535696278745e+282, "18930562862615536", 283},
    {1.9430609024167720002289477e+31, "1943060902416772", 32},
    {3.1908475796045290904732946e+231, "3190847579604529", 232},
    {1.5700353677658854075507902e+307, "15700353677658854", 308},
    {3.8250110000520353329718919e+302, "3825011000052035", 303},
    {2.3968592867109471106623175e-60, "2396859286710947", -59},
    {8.2112887053965313327290518e+72, "8211288705396531", 73},
    {2.5686903522785568878006079e+235, "2568690352278557", 236},
    {1.2653426289154960485749329e-185, "1265342628915496", -184},
    {1.7397192690109527732758037e+298, "17397192690109528", 299},
    {5.5765975803422049345587431e+57, "5576597580342205", 58},
    {1.2119743233022981378047045e-65, "12119743233022981", -64},
    {2.0194325674841460498652987e-112, "2019432567484146", -111},
    {2.6559833158674974406100429e+270, "26559833158674974", 271},
    {1.2738910782213562909605195e+140, "12738910782213563", 141},
    {4.2659668921849951034097368e-123, "4265966892184995", -122},
    {6.7619956238718120428451814e-273, "6761995623871812", -272},
    {3.8230468414575806561737566e+96, "38230468414575807", 97},
    {5.5080440999421372544020414e+05, "5508044099942137", 6},
    {1.0814439830709084577945856e+233, "10814439830709085", 234},
    {2.9239629471920031581003589e-79, "2923962947192003", -78},
    {2.0083764821655122496419126e-68, "20083764821655122", -67},
    {4.9318690017024842403132959e-86, "4931869001702484", -85},
    {2.0279148529449686991304173e-186, "20279148529449687", -185},
    {4.0593730006166880603339827e-132, "4059373000616688", -131},
    {3.9959767169668920818989436e-94, "3995976716966892", -93},
    {3.8783564492575586951675154e+68, "38783564492575587", 69},
    {8.3947000772917809530392814e-166, "8394700077291781", -165},
    {2.7998816368476937032410511e-26, "27998816368476937", -25},
    {5.1024413377273120200580470e-206, "5102441337727312", -205},
    {5.8688838563800521106504145e-62, "5868883856380052", -61},
    {5.7460986605290959564606826e+74, "5746098660529096", 75},
    {1.0446196248534063096601834e-264, "10446196248534063", -263},
    {6.1646128642517862241212674e+57, "6164612864251786", 58},
    {4.4551982203588772600798220e-188, "4455198220358877", -187},
    {1.1344219403346160800576466e+277, "1134421940334616", 278},
    {1.0849982094774182265046584e+191, "10849982094774182", 192},
    {1.9318177972494138266043108e+112, "1931817797249414", 113},
    {7.2861607826475943179173701e+297, "7286160782647594", 298},
    {2.1177254383278681318902760e+138, "2117725438327868", 139},
    {9.4963068628203184444546817e-167, "9496306862820318", -166},
    {1.9298113831930033733985820e+280, "19298113831930034", 281},
    {1.7025825382288601776146278e-09, "17025825382288602", -8},
    {7.5247543590624009484513651e-217, "7524754359062401", -216},
    {2.1116915663193735039069800e-88, "21116915663193735", -87},
    {1.1580420723931351245178938e-208, "11580420723931351", -207},
    {7.2598986928541100669652105e+286, "725989869285411", 287},
    {6.2190892849910753765107866e+156, "6219089284991075", 157},
    {1.0875932883921498472584560e-250, "10875932883921498", -249},
    {5.7687430765364382328799985e+233, "5768743076536438", 234},
    {2.5165119132467870573042305e+256, "2516511913246787", 257},
    {3.5497601893061555308473586e-78, "35497601893061555", -77},
    {2.4705214312618243206368344e+297, "24705214312618243", 298},
    {2.4369326764628678871527052e-165, "2436932676462868", -164},
    {5.9993809569233962612960122e+36, "5999380956923396", 37},
    {9.7634025998644688820633600e+23, "9763402599864469", 24},
    {4.4445480684443579727591658e+40, "4444548068444358", 41},
    {4.1516643119744128286261877e-167, "4151664311974413", -166},
    {8.0988251067282158459113875e+202, "8098825106728216", 203},
    {1.0502720883865113869603019e-243, "10502720883865114", -242},
    {4.7021566509682672496854240e-36, "4702156650968267", -35},
    {7.4304870796864975248194693e+86, "7430487079686498", 87},
    {1.9751686525337534902587270e+280, "19751686525337535", 281},
    {1.8598583181649252863994392e-263, "18598583181649253", -262},
    {4.9165443437638840393199872e-169, "4916544343763884", -168},
    {4.1948403189073338642116185e-265, "4194840318907334", -264},
    {3.7480338132223659001018937e+43, "3748033813222366", 44},
    {2.4395203453573750828309936e+275, "2439520345357375", 276},
    {1.3840395794230272518573716e-109, "13840395794230273", -108},
    {4.6876384515846476886457598e+288, "46876384515846477", 289},
    {2.3347862965203866309875125e+100, "23347862965203866", 101},
    {1.4171669669315443720977998e+97, "14171669669315444", 98},
    {1.0710748219845974186489539e-296, "10710748219845974", -295},
    {3.2174586698148207356691089e-67, "3217458669814821", -66},
    {8.1922772707153846669684521e+307, "8192277270715385", 308},
    {3.7378776581586824930529491e-81, "37378776581586825", -80},
    {1.0017078774242460451534406e-265, "1001707877424246", -264},
    {6.7157102164568045835307621e+80, "6715710216456805", 81},
    {3.2976520477160884429902560e-271, "32976520477160884", -270},
    {1.3567442690235753726147806e-22, "13567442690235754", -21},
    {5.5925453867038609502227980e+69, "5592545386703861", 70},
    {3.5921183570473485502378753e-303, "35921183570473486", -302},
    {7.6417906515092627430204119e-202, "7641790651509263", -201},
    {2.2143332286797173735621680e+142, "22143332286797174", 143},
    {7.0630613177583878175150367e-262, "7063061317758388", -261},
    {2.2501230007718963127898244e+136, "22501230007718963", 137},
    {4.1553076357022793881488318e-292, "4155307635702279", -291},
    {2.5897604739785881160943587e-233, "2589760473978588", -232},
    {1.6096476667729191600194738e-210, "1609647666772919", -209},
    {1.1063704796985577709494927e-38, "11063704796985578", -37},
    {1.2512915494811800322942317e-243, "125129154948118", -242},
    {1.4829796393139822011054396e+86, "14829796393139822", 87},
    {4.3447733248118563043874911e-189, "4344773324811856", -188},
    {1.6269474949566677613280142e-290, "16269474949566678", -289},
    {7.8567852910368603835234912e-42, "785678529103686", -41},
    {1.9118261026093968793000682e+265, "1911826102609397", 266},
    {1.6540669852042079779612088e-78, "1654066985204208", -77},
    {1.9630598078769031566507519e+223, "19630598078769032", 224},
    {1.8621363729950790657815197e+138, "1862136372995079", 139},
    {2.4390385266009319921853817e+247, "2439038526600932", 248},
    {1.1016891279739240255780378e-161, "1101689127973924", -160},
    {4.5332078504673973018998575e-158, "4533207850467397", -157},
    {1.2012329822179048259878801e+67, "12012329822179048", 68},
    {3.8698866185837339889465794e-146, "3869886618583734", -145},
    {1.1799426425514895455742200e+236, "11799426425514895", 237},
    {1.3782648670895680360448369e+220, "1378264867089568", 221},
    {1.0781594587084062463688661e-25, "10781594587084062", -24},
    {9.4435269052272952213504000e+22, "9443526905227295", 23},
    {2.7631365097622759662346780e-226, "2763136509762276", -225},
    {2.9825444061318724627899287e-259, "29825444061318725", -258},
    {2.5981479340476442208196973e+92, "25981479340476442", 93},
    {1.5125467704115586059134566e+138, "15125467704115586", 139},
    {3.0443603991895432848508752e+184, "30443603991895433", 185},
    {2.9517631295931043925403755e-122, "29517631295931044", -121},
    {1.0824661875931700890324688e-226, "108246618759317", -225},
    {5.8598033067197061293670400e+23, "5859803306719706", 24},
    {3.0080583701688380297320803e+72, "3008058370168838", 73},
    {2.1213438196403582314139144e+56, "21213438196403582", 57},
    {1.7539074268307160001713982e+249, "1753907426830716", 250},
    {3.7576378300640923589062610e+121, "37576378300640924", 122},
    {2.5120030204710064753446651e+199, "25120030204710065", 200},
    {7.4485647375679491233313456e+00, "7448564737567949", 1},
    {4.9936359626410431382174155e-124, "4993635962641043", -123},
    {1.7640173972037325219464110e+261, "17640173972037325", 262},
    {2.6899683480393635456612053e-177, "26899683480393635", -176},
    {4.4911314401757520464614614e-29, "4491131440175752", -28},
    {1.5301148679832608864008055e+31, "15301148679832609", 32},
    {5.0155740960938943577964364e+163, "50155740960938944", 164},
    {6.7358034419183705121261868e+196, "67358034419183705", 197},
    {3.9330748694372713843834286e-138, "39330748694372714", -137},
    {5.2314508340745780942801975e-174, "5231450834074578", -173},
    {1.4535479428452333115429019e+139, "14535479428452333", 140},
    {7.7509880992824540858698475e+87, "7750988099282454", 88},
    {1.2213351100590038912317219e-297, "12213351100590039", -296},
    {7.6270699046195023975613793e+99, "7627069904619502", 100},
    {3.1461466976468358509610022e-89, "3146146697646836", -88},
    {2.3350236475348930025522655e-240, "2335023647534893", -239},
    {1.3314095010365801895234388e+57, "13314095010365802", 58},
    {9.8060470996941125210713282e+44, "9806047099694113", 45},
    {1.8231406961976019649577379e-198, "1823140696197602", -197},
    {3.5271184737664759405111969e-134, "3527118473766476", -133},
    {6.4066650537164773275995242e-107, "6406665053716477", -106},
    {2.6382110170119193419316998e+247, "26382110170119193", 248},
    {9.3725864905186642651391626e+220, "9372586490518664", 221},
    {2.0969675339775510693592816e+186, "2096967533977551", 187},
    {4.5207222665535762390536165e+262, "4520722266553576", 263},
    {3.6395072805852608509857812e-186, "3639507280585261", -185},
    {4.4900207129324131217683228e+127, "4490020712932413", 128},
    {4.6287309780277601121488390e-78, "462873097802776", -77},
    {2.3973058238491742175232000e+23, "23973058238491742", 24},
    {1.5995556957182440010192126e-223, "1599555695718244", -222},
    {3.2229659530800947102501279e+171, "32229659530800947", 172},
    {2.0082047409338434112863817e-187, "20082047409338434", -186},
    {6.9963361217826064251639384e-230, "6996336121782606", -229},
    {4.9991313691970358068902686e+110, "4999131369197036", 111},
    {2.2247938321218032769771173e-184, "22247938321218033", -183},
    {3.6116072853697735540773568e+238, "36116072853697736", 239},
    {2.6364232437111830018484968e-290, "2636423243711183", -289},
    {9.4179679927922256246968210e-101, "9417967992792226", -100},
    {7.0600434690845452465641504e+55, "7060043469084545", 56},
    {3.6969103025237040943643410e+299, "3696910302523704", 300},
    {8.8357314168980352189990580e-138, "8835731416898035", -137},
    {1.6713286197771718049897575e-273, "16713286197771718", -272},
    {9.6785909493605841430564742e-17, "9678590949360584", -16},
    {1.0729161315554067402741753e+277, "10729161315554067", 278},
    {7.1470772194432431973310842e+165, "7147077219443243", 166},
    {4.8350214334447965621948242e+09, "4835021433444797", 10},
    {8.5437421018747786862529920e-68, "8543742101874779", -67},
    {3.7625957958610257095484806e-107, "3762595795861026", -106},
    {3.7527852096010201479177167e-273, "375278520960102", -272},
    {8.0894569883573585021029642e-63, "8089456988357359", -62},
    {5.3051766197962889337613746e-02, "5305176619796289", -1},
    {5.6697081568297683852657313e+267, "5669708156829768", 268},
    {1.0919980098178357581917354e-62, "10919980098178358", -61},
    {3.8299449601777310667258937e-264, "3829944960177731", -263},
    {1.0160255150799934800518340e+42, "10160255150799935", 43},
    {1.9016854616719137475395584e+25, "19016854616719137", 26},
    {9.0083091050292868583123413e+130, "9008309105029287", 131},
    {2.9027983346795700892917103e-178, "290279833467957", -177},
    {7.5088991448975448943552739e+265, "7508899144897545", 266},
    {3.3012855210052213937246813e-287, "33012855210052214", -286},
    {4.2935706468120259714790551e+173, "4293570646812026", 174},
    {1.6780568939622716141654821e-248, "16780568939622716", -247},
    {4.6513405634613686802890491e+283, "4651340563461369", 284},
    {4.1217355898357487213031339e+270, "41217355898357487", 271},
    {3.0733460465020980642007640e+217, "3073346046502098", 218},
    {6.2616020979384624852245287e+244, "6261602097938462", 245},
    {1.0317969719814708372605168e+145, "10317969719814708", 146},
    {4.2646937307998465922307513e-203, "42646937307998466", -202},
    {9.0347114580233007719340213e-145, "9034711458023301", -144},
    {9.2438054982121953134796497e-248, "9243805498212195", -247},
    {1.2997236134744901953153217e-11, "12997236134744902", -10},
    {6.3086306807145919659537384e-58, "6308630680714592", -57},
    {1.4103743495923867977018842e+243, "14103743495923868", 244},
    {4.4964400578894989880718288e+166, "4496440057889499", 167},
    {1.8715299977794076316516955e+66, "18715299977794076", 67},
    {1.1646269145737423799984590e-121, "11646269145737424", -120},
    {6.5395297845026942529993618e-285, "6539529784502694", -284},
    {4.4656631634369144138046791e-302, "44656631634369144", -301},
    {2.4477115102454022242294733e+219, "24477115102454022", 220},
    {2.3499267975618624731655803e-49, "23499267975618625", -48},
    {3.0110244833709929864628830e+201, "3011024483370993", 202},
    {3.9153368154312233050801308e-300, "3915336815431223", -299},
    {1.5998956449497759962803785e-96, "1599895644949776", -95},
    {1.2089514157622702636718750e+12, "12089514157622703", 13},
    {8.9467284121767579702886096e-305, "8946728412176758", -304},
    {2.5979310694382696579232454e+96, "25979310694382697", 97},
    {7.3984115777061047417094034e+77, "7398411577706105", 78},
    {1.2332551697020640026805047e+265, "1233255169702064", 266},
    {2.7967896305462756999510113e+222, "27967896305462757", 223},
    {2.8100069352144471863784675e+153, "28100069352144472", 154},
    {4.6182317891895431914445816e-78, "4618231789189543", -77},
    {2.7853796786391718756628010e+255, "2785379678639172", 256},
    {7.7337761334237871208960111e-223, "7733776133423787", -222},
    {6.3097678504709688168948303e-294, "6309767850470969", -293},
    {1.1423679685878601677145418e+92, "11423679685878602", 93},
    {2.4850792385966876795666681e+305, "24850792385966877", 306},
    {1.1494758295214977185710725e+111, "11494758295214977", 112},
    {2.4727040838463842861739539e+182, "24727040838463843", 183},
    {2.9555859106572424517204837e+38, "29555859106572425", 39},
    {1.5014579616363089666073286e-29, "1501457961636309", -28},
    {2.3728435781863675699700296e-152, "23728435781863676", -151},
    {3.5864060670574021597760715e+146, "3586406067057402", 147},
    {6.9378849690201925226758928e-280, "6937884969020193", -279},
    {1.3095578288704595144304102e+236, "13095578288704595", 237},
    {1.2275594475971260758423238e+191, "1227559447597126", 192},
    {1.1430509736861583985918968e+280, "11430509736861584", 281},
    {5.9253440535581578454682680e+70, "5925344053558158", 71},
    {5.0009311863594200989588711e-254, "500093118635942", -253},
    {6.2505045705778876547661085e+52, "6250504570577888", 53},
    {2.2401400403216317079731356e+85, "22401400403216317", 86},
    {3.9662526407141283277168167e-143, "39662526407141283", -142},
    {2.3051220962404815107603550e-254, "23051220962404815", -253},
    {1.4661404003165384307762673e+137, "14661404003165384", 138},
    {9.8950190847671592689237088e+141, "9895019084767159", 142},
    {2.7020861827889081323363070e-267, "2702086182788908", -266},
    {6.6286797559008712043227523e+159, "6628679755900871", 160},
    {1.0007799738779623332632075e-162, "10007799738779623", -161},
    {6.3038955643307680463305800e-209, "6303895564330768", -208},
    {1.7334805452860384635289489e+245, "17334805452860385", 246},
    {3.3405452368888356731485356e+302, "33405452368888357", 303},
    {2.2485704483991188294194364e-232, "2248570448399119", -231},
    {7.4436012102530844239987252e+46, "7443601210253084", 47},
    {1.4542717002066602350467364e+272, "14542717002066602", 273},
    {2.9602207410189860249490731e-275, "2960220741018986", -274},
    {1.7881720122131803125000000e+14, "17881720122131803", 15},
    {8.7164116854269805762370615e+235, "8716411685426981", 236},
    {4.2053139037820482823653867e+193, "4205313903782048", 194},
    {1.4112044991372939322337582e-135, "1411204499137294", -134},
    {4.0450401076900783232979681e+127, "40450401076900783", 128},
    {1.6679752935114105410936940e-130, "16679752935114105", -129},
    {3.5324246403261847218948474e-108, "3532424640326185", -107},
    {6.2646548908620853874600232e-220, "6264654890862085", -219},
    {7.7568337875985876372963804e+105, "7756833787598588", 106},
    {1.1922409334894626911376300e-155, "11922409334894627", -154},
    {1.0007601566432063720415885e+39, "10007601566432064", 40},
    {1.6391503594708728633841653e+262, "1639150359470873", 263},
    {2.6432764108587172397281204e-156, "2643276410858717", -155},
    {2.6689854743621805049318902e-212, "26689854743621805", -211},
    {6.5616207728861220368499069e+230, "6561620772886122", 231},
    {1.2157384772497834580834872e+306, "12157384772497835", 307},
    {9.3689623984688593657811398e+197, "936896239846886", 198},
    {9.2071498229690264783266202e-169, "9207149822969026", -168},
    {6.0902363428036513464277334e+285, "6090236342803651", 286},
    {8.2124678024493364530830374e+40, "8212467802449336", 41},
    {5.1178249962167192231231730e-189, "5117824996216719", -188},
    {4.4936985880417472350730740e+210, "4493698588041747", 211},
    {3.3291847657706334549076946e+90, "33291847657706335", 91},
    {6.2819927893738202219573191e+73, "628199278937382", 74},
    {1.0175152900880150708044551e+171, "1017515290088015", 172},
    {7.0732501681801862052454375e+174, "7073250168180186", 175},
    {1.3062268034007768451089310e-216, "13062268034007768", -215},
    {1.7791797737521844875149067e-105, "17791797737521845", -104},
    {1.1601962563586904097192553e+182, "11601962563586904", 183},
    {2.6788429650680805647682379e-195, "26788429650680806", -194},
    {5.7534884814697865896787942e-182, "57534884814697866", -181},
    {1.0157398248698572017081185e-107, "10157398248698572", -106},
    {6.0106605899736099197516000e+274, "601066058997361", 275},
    {2.1724340752478274452208495e-01, "21724340752478274", 0},
    {1.5788919126865048950180853e-187, "1578891912686505", -186},
    {7.4463390660563082912334635e-193, "7446339066056308", -192},
    {3.6249164949984916130546016e-84, "36249164949984916", -83},
    {7.2866601882550124576502000e-21, "7286660188255012", -20},
    {2.2929031308470271755150349e+233, "2292903130847027", 234},
    {3.3728693332787093854727005e-70, "33728693332787094", -69},
    {1.8075125080928421905223795e-222, "18075125080928422", -221},
    {5.4730211989100581951347268e-173, "5473021198910058", -172},
    {1.1897234692427672080739818e+134, "11897234692427672", 135},
    {8.6170054251245504044221376e+48, "861700542512455", 49},
    {2.0035567169678207724882880e-66, "20035567169678208", -65},
    {3.9479886459197543289262059e-132, "39479886459197543", -131},
    {3.3604593051910155736159389e+303, "33604593051910156", 304},
    {2.9297235755332304920942318e-108, "29297235755332305", -107},
    {1.4099741590350684757906780e-56, "14099741590350685", -55},
    {8.7151683259612571992948900e+132, "8715168325961257", 133},
    {1.5182960238132190233269027e-303, "1518296023813219", -302},
    {1.0706441508297429231476638e+45, "1070644150829743", 46},
    {1.1142367642657652398380455e-94, "11142367642657652", -93},
    {3.2388991225357723086463194e+178, "32388991225357723", 179},
    {1.5586848064006485382044287e+299, "15586848064006485", 300},
    {8.3744286171711878852286285e+105, "8374428617171188", 106},
    {1.3185373305968884454318266e+237, "13185373305968884", 238},
    {1.3028421252742211775181681e+128, "13028421252742212", 129},
    {3.0019266778316531239577387e-300, "3001926677831653", -299},
    {8.7757910907387168801170809e+228, "8775791090738717", 229},
    {4.5752377423400709255476748e-29, "4575237742340071", -28},
    {7.9130567527660837266053488e-197, "7913056752766084", -196},
    {3.1959924222845471488409025e+152, "3195992422284547", 153},
    {6.6374549167819919958547439e-150, "6637454916781992", -149},
    {1.9149218740965516378708140e+188, "19149218740965516", 189},
    {9.1736816229770371409884997e+157, "9173681622977037", 158},
    {4.1547248167388319507068400e+99, "4154724816738832", 100},
    {1.1379333620661638972176769e-112, "1137933362066164", -111},
    {3.0711624456728746354010877e-222, "30711624456728746", -221},
    {1.4170090323862424282490843e-238, "14170090323862424", -237},
    {2.9181468847900189102783273e+130, "2918146884790019", 131},
    {1.5322060086534897358670050e-55, "15322060086534897", -54},
    {5.9170773929032610137732044e+233, "5917077392903261", 234},
    {9.0433310878154018128470359e-63, "9043331087815402", -62},
    {2.2088265521735216217180447e+191, "22088265521735216", 192},
    {2.1323402069833131001503123e+164, "2132340206983313", 165},
    {9.8203728188394585071996178e+57, "9820372818839459", 58},
    {2.0500523349884169390243787e-170, "2050052334988417", -169},
    {2.4469006863906198842537673e-220, "244690068639062", -219},
    {2.6799108440936566946425662e-117, "26799108440936567", -116},
    {6.3317488934413253432967724e-115, "6331748893441325", -114},
    {9.7131050983949563480206766e-201, "9713105098394956", -200},
    {1.2658273212651194169553780e-90, "12658273212651194", -89},
    {1.8526829908887845137989494e+267, "18526829908887845", 268},
    {2.6326947226392081478540969e-143, "2632694722639208", -142},
    {3.1262214841261405982717808e-255, "31262214841261406", -254},
    {5.3031249826148271895300574e+182, "5303124982614827", 183},
    {1.2749874629053079617536000e+22, "1274987462905308", 23},
    {7.4534914896405191027184442e+75, "7453491489640519", 76},
    {7.0072609238847923530276964e+143, "7007260923884792", 144},
    {2.8499387560980276612797358e+122, "28499387560980277", 123},
    {5.8621812300787312920167942e+188, "5862181230078731", 189},
    {1.0254509378914143887768702e-99, "10254509378914144", -98},
    {6.8400365482433635812751163e-224, "6840036548243364", -223},
    {2.2697178314886185431637512e-210, "22697178314886185", -209},
    {1.5182342147255225791973458e-274, "15182342147255226", -273},
    {3.4493470146733669898369986e+72, "3449347014673367", 73},
    {2.3511740589853524777756577e-54, "23511740589853525", -53},
    {6.9501435473905270154294658e-253, "6950143547390527", -252},
    {9.0698799461398808095520114e-51, "9069879946139881", -50},
    {4.3815112851279252009482097e-69, "4381511285127925", -68},
    {1.9588994637019803657899367e-286, "19588994637019804", -285},
    {6.6658639182147540055092216e-169, "6665863918214754", -168},
    {4.6712223678139925220232221e-69, "4671222367813993", -68},
    {8.2747430768033604757255236e+152, "82747430768033605", 153},
    {6.2897395810347852629037441e-301, "6289739581034785", -300},
    {1.6221724560476854342233128e-170, "16221724560476854", -169},
    {1.4428755866418666659394939e-59, "14428755866418667", -58},
    {1.8471435924210941019488485e+79, "1847143592421094", 80},
    {2.8320111671502669956998670e+75, "2832011167150267", 76},
    {1.0658110849876336908354854e+39, "10658110849876337", 40},
    {3.4934484246161328811125943e+141, "3493448424616133", 142},
    {4.3714158654222003792240150e-302, "43714158654222004", -301},
    {3.2319236954713132870350341e-43, "32319236954713133", -42},
    {4.0508008326937851755267426e-235, "4050800832693785", -234},
    {1.0688424916017317420456059e-233, "10688424916017317", -232},
    {1.1210323329024301351484022e+40, "11210323329024301", 41},
    {3.7170129788306573489863375e-130, "3717012978830657", -129},
    {4.4773083516592004836810802e+274, "44773083516592005", 275},
    {1.9898047236998723189145419e+285, "19898047236998723", 286},
    {4.1596721480151758675964338e+47, "4159672148015176", 48},
    {6.6617691630221390328290982e-286, "6661769163022139", -285},
    {1.1095601501934368828763978e-106, "1109560150193437", -105},
    {3.6714513838511465338113293e-155, "36714513838511465", -154},
    {3.9812969501004815346018708e-88, "39812969501004815", -87},
    {5.1465956129689217230192627e+69, "5146595612968922", 70},
    {1.1564918740373754219390932e-253, "11564918740373754", -252},
    {2.1505306549713440274783346e-165, "2150530654971344", -164},
    {9.8496638251249140493205151e-234, "9849663825124914", -233},
    {1.4514820306527879168000000e+19, "1451482030652788", 20},
    {1.6134670941200015867628290e-25, "16134670941200016", -24},
    {4.5687958527252488953957598e+254, "4568795852725249", 255},
    {2.7761539503044753868407094e+227, "27761539503044754", 228},
    {3.2354105309289404448108954e+191, "32354105309289404", 192},
    {1.6606501262264999281903856e-200, "16606501262265", -199},
    {7.5541128033706317346229753e-01, "7554112803370632", 0},
    {8.2733136942797518838915187e-107, "8273313694279752", -106},
    {2.3900893813381511296084225e-303, "2390089381338151", -302},
    {2.1405497170101073577265456e-108, "21405497170101074", -107},
    {8.1347126242081962890625000e+12, "8134712624208196", 13},
    {2.9318053178600364598371964e+277, "29318053178600365", 278},
    {2.6756911905445673923468721e-292, "26756911905445674", -291},
    {5.0496886486989445051043262e-87, "50496886486989445", -86},
    {2.3393407320238787256987484e-125, "23393407320238787", -124},
    {3.3019899110508256348260441e+260, "33019899110508256", 261},
    {1.3559719366726422408572061e-255, "13559719366726422", -254},
    {8.8825690782414804105971721e+50, "888256907824148", 51},
    {3.7701723371328505803112056e-287, "37701723371328506", -286},
    {1.2071193229680883440242630e-254, "12071193229680883", -253},
    {1.5679940766216737402279022e+93, "15679940766216737", 94},
    {2.3937922080900368418216541e+278, "23937922080900368", 279},
    {3.8486486650222380000000000e+15, "3848648665022238", 16},
    {6.6573543639907169646959854e+58, "6657354363990717", 59},
    {1.4070838668247429332245009e+203, "1407083866824743", 204},
    {1.0761273998099492715045358e-68, "10761273998099493", -67},
    {2.4856615952626303946101599e+238, "24856615952626304", 239},
    {1.6855921767877953702484941e-91, "16855921767877954", -90},
    {7.9348110722089456383991245e-130, "7934811072208946", -129},
    {1.3413441111820414760217014e-15, "13413441111820415", -14},
    {9.3268008425966767328862024e-86, "9326800842596677", -85},
    {1.0752610728068834653213766e-125, "10752610728068835", -124},
    {3.7188778904751799439810850e-113, "371887789047518", -112},
    {1.6512898034020462058321566e-288, "16512898034020462", -287},
    {4.3061700348725556693995632e-167, "4306170034872556", -166},
    {2.0829021883299297051350397e+82, "20829021883299297", 83},
    {3.5512444055139679495756290e-268, "3551244405513968", -267},
    {2.9278867632537894501677576e-102, "29278867632537895", -101},
    {6.1242190102750228863478261e+84, "6124219010275023", 85},
    {1.1812772279559754758157455e-121, "11812772279559755", -120},
    {2.4478004660720634254994416e+228, "24478004660720634", 229},
    {1.4744660093481499408556236e+245, "147446600934815", 246},
    {2.8859729105408119898479783e+121, "2885972910540812", 122},
    {1.7966665490362776765297410e-246, "17966665490362777", -245},
    {2.6063821077935611101446915e+149, "2606382107793561", 150},
    {2.2002987959080365472738766e+88, "22002987959080365", 89},
    {1.0529308670242690756022074e-55, "1052930867024269", -54},
    {5.5379837856278906383949615e+255, "5537983785627891", 256},
    {9.6635891122816834663828227e-89, "9663589112281683", -88},
    {5.8107755607395526287216586e-230, "5810775560739553", -229},
    {6.3692674292749934867214644e-21, "63692674292749935", -20},
    {2.5463369853328484140541877e-297, "25463369853328484", -296},
    {9.0531140031970189293718772e-217, "9053114003197019", -216},
    {8.8318251790392891476980893e-274, "8831825179039289", -273},
    {4.2407763486131848818288790e+200, "4240776348613185", 201},
    {2.7897683147370656694272000e+22, "27897683147370657", 23},
    {2.1431161064411272550957847e-96, "21431161064411273", -95},
    {7.1897896528131158801733483e-10, "7189789652813116", -9},
    {4.1221786828039459458562459e+65, "4122178682803946", 66},
    {1.9589958473152371313919145e+128, "1958995847315237", 129},
    {9.4090293833371251821517944e+03, "9409029383337125", 4},
    {1.0246838061890727530819533e+140, "10246838061890728", 141},
    {1.3569908554073988683834739e-101, "13569908554073989", -100},
    {1.7866462344470723110347405e+195, "17866462344470723", 196},
    {2.8224862377021133949808511e-83, "28224862377021134", -82},
    {1.2089144196491742552262389e-40, "12089144196491743", -39},
    {8.6233462194368226026709600e-23, "8623346219436823", -22},
    {3.4785842885186079707629317e+200, "3478584288518608", 201},
    {8.4132264132311829689421916e+177, "8413226413231183", 178},
    {4.0939866835734920777020949e-65, "4093986683573492", -64},
    {2.2037911072596491652299188e-234, "22037911072596492", -233},
    {9.8927678021836064460907255e-68, "9892767802183606", -67},
    {3.0192229129414567249233007e-87, "30192229129414567", -86},
    {1.7025369279084078682476273e-179, "1702536927908408", -178},
    {1.8758870063834282766304713e+248, "18758870063834283", 249},
    {8.7494532581945526252728428e-66, "8749453258194553", -65},
    {1.1193533643667675677010475e+79, "11193533643667676", 80},
    {3.0588982679482318784518989e-240, "3058898267948232", -239},
    {5.9065484895959769442658574e+91, "5906548489595977", 92},
    {1.2640379569946312645870505e-295, "12640379569946313", -294},
    {2.0203094015982050559054053e+105, "2020309401598205", 106},
    {3.5884721681184717286623335e+229, "35884721681184717", 230},
    {3.9220248012404480663463494e+76, "3922024801240448", 77},
    {6.4712223317281225346089097e-186, "64712223317281225", -185},
    {2.3536622399566242753231770e-199, "23536622399566243", -198},
    {1.0230210481289298208776426e+72, "10230210481289298", 73},
    {6.1143818844934657208238678e-55, "6114381884493466", -54},
    {7.2282416558248339256892077e+51, "7228241655824834", 52},
    {9.5559579964132449598815265e-282, "9555957996413245", -281},
    {9.6245767911090100871297772e+66, "962457679110901", 67},
    {2.7540094467279408912598349e-277, "2754009446727941", -276},
    {1.7309579498548317786336133e+27, "17309579498548318", 28},
    {2.3916413202796087584532741e-272, "23916413202796088", -271},
    {5.7022572962318694468970752e-276, "57022572962318694", -275},
    {1.6357057074159919718176362e+78, "1635705707415992", 79},
    {1.1559159890030622087308613e-175, "11559159890030622", -174},
    {4.3515984313572375609300013e-124, "43515984313572376", -123},
    {1.1116946184320440225082854e-146, "1111694618432044", -145},
    {1.1047360090944657846303639e-206, "11047360090944658", -205},
    {9.5659049533646938116105163e-29, "9565904953364694", -28},
    {5.4615466917411659925571304e-211, "5461546691741166", -210},
    {1.4545257827944040181142159e+279, "1454525782794404", 280},
    {4.0889957771180268226235682e-176, "4088995777118027", -175},
    {1.3794873500577990954438126e-99, "1379487350057799", -98},
    {2.8261532818011735285740979e+30, "28261532818011735", 31},
    {2.1131165202644427992317601e+126, "21131165202644428", 127},
    {2.7053856137435914398200653e-141, "27053856137435914", -140},
    {1.6216368750809740951472565e+300, "1621636875080974", 301},
    {1.9796067453804459349176402e+189, "1979606745380446", 190},
    {1.8433101230889908737614127e-19, "18433101230889909", -18},
    {4.4062512921094221502824981e+296, "4406251292109422", 297},
    {1.6437349517312573823738220e+244, "16437349517312574", 245},
    {1.6297419018654636593511657e+184, "16297419018654637", 185},
    {5.8572806483532103238098365e+59, "585728064835321", 60},
    {2.1061951917397707856716512e+146, "2106195191739771", 147},
    {1.6345691038106029916160000e+21, "1634569103810603", 22},
    {4.6237459092349632946229697e-203, "46237459092349633", -202},
    {4.4028872203154705378759528e+275, "44028872203154705", 276},
    {1.7707178945002033195068925e-301, "17707178945002033", -300},
    {1.2901861371145065516304459e+32, "12901861371145066", 33},
    {3.2441100812613962805071478e-180, "32441100812613963", -179},
    {1.4585157177456540003670983e+213, "1458515717745654", 214},
    {6.2024923687525979284820045e+246, "6202492368752598", 247},
    {1.8622921565842424423911686e+226, "18622921565842424", 227},
    {1.5570120849781977069885272e+296, "15570120849781977", 297},
    {5.1407596678870963425896507e+211, "5140759667887096", 212},
    {8.6938443158671339971579358e-270, "8693844315867134", -269},
    {3.6176728574496214605460409e+03, "36176728574496215", 4},
    {5.5541803195307760435385393e-63, "5554180319530776", -62},
    {6.6105739595214155314648314e-34, "66105739595214155", -33},
    {1.2140712177916359697415806e-42, "1214071217791636", -41},
    {1.0942179749124814929920000e+23, "10942179749124815", 24},
    {1.4056680055689308055968723e-43, "14056680055689308", -42},
    {7.8839564426171459754445635e-164, "7883956442617146", -163},
    {2.0113045312910448410548270e+05, "20113045312910448", 6},
    {1.3605524559582040495205001e-32, "1360552455958204", -31},
    {2.8965737250179547850799281e+255, "28965737250179548", 256},
    {1.0326417217887632709401367e+150, "10326417217887633", 151},
    {2.4042748299203535381724686e-84, "24042748299203535", -83},
    {6.9766001589289461163304894e-124, "6976600158928946", -123},
    {9.7909743272116504589442181e+166, "979097432721165", 167},
    {3.0749771177908043724934389e-230, "30749771177908044", -229},
    {9.8067711000330129233923706e+258, "9806771100033013", 259},
    {6.7056066128545131492464160e+283, "6705606612854513", 284},
    {5.5585883192048851353343752e+154, "5558588319204885", 155},
    {6.8226641043668087951218685e+252, "6822664104366809", 253},
    {9.7069492736794042326657140e-307, "9706949273679404", -306},
    {1.3953594862513770052581437e-286, "1395359486251377", -285},
    {1.8987729804143087823830593e+70, "18987729804143088", 71},
    {8.3741747834718495771195095e+304, "837417478347185", 305},
    {1.3826950285571279650007693e+202, "1382695028557128", 203},
    {1.7216054104614927051714231e+167, "17216054104614927", 168},
    {5.4093026192135951416162419e+91, "5409302619213595", 92},
    {1.4308233045130032640000000e+18, "14308233045130033", 19},
    {1.4211308106974830046454694e+113, "1421130810697483", 114},
    {7.4765741806538223254122864e-182, "7476574180653822", -181},
    {5.9348073556501776471233642e+61, "5934807355650178", 62},
    {1.1234489023804162650455974e+105, "11234489023804163", 106},
    {2.5523281647014960885030917e-158, "2552328164701496", -157},
    {5.6463018103045732366233868e-35, "5646301810304573", -34},
    {9.8642882070508709903840995e-38, "986428820705087", -37},
    {5.4616091862691215890484400e+211, "5461609186269122", 212},
    {2.5210730641659186653512406e-125, "25210730641659187", -124},
    {1.5245265542608773264194949e+127, "15245265542608773", 128},
    {6.1697340371148873132229190e-233, "6169734037114887", -232},
    {7.3119081692089934974684544e+252, "73119081692089935", 253},
    {1.9037730371413602208419539e-155, "19037730371413602", -154},
    {1.2387102268406493749353103e+04, "12387102268406494", 5},
    {1.5557144927638275064665642e+121, "15557144927638275", 122},
    {1.4455273113689971088780645e-53, "1445527311368997", -52},
    {2.8671909718176091936407794e-39, "28671909718176092", -38},
    {5.7996076032310074408960000e+21, "5799607603231007", 22},
    {8.2982175557813599704202682e+77, "829821755578136", 78},
    {2.2901516045218240775319286e-88, "2290151604521824", -87},
    {5.4196394210623135251012778e-70, "54196394210623135", -69},
    {2.5081840600806790244847987e-148, "2508184060080679", -147},
    {3.1460663818059600990648287e+35, "314606638180596", 36},
    {7.4285489843003435272680721e-160, "7428548984300344", -159},
    {1.1171694883285565519020687e+27, "11171694883285566", 28},
    {6.6101727685620840322393043e+61, "6610172768562084", 62},
    {3.4904277685733670996927131e-292, "3490427768573367", -291},
    {4.4994585764009461789010750e+294, "4499458576400946", 295},
    {1.8213629549472357383012981e+127, "18213629549472357", 128},
    {1.1662922404911454059446972e+34, "11662922404911454", 35},
    {8.2212151451046201745749105e-293, "822121514510462", -292},
    {3.7507258117815685222040405e-203, "37507258117815685", -202},
    {3.3414799552275190453643026e+115, "3341479955227519", 116},
    {2.9109479437988997339261161e-208, "29109479437988997", -207},
    {2.0697458797403693279667833e-136, "20697458797403693", -135},
    {1.2777979542748511777519613e+166, "12777979542748512", 167},
    {1.5045998139272093388690356e-102, "15045998139272093", -101},
    {1.9811420054936288671573904e-100, "19811420054936289", -99},
    {1.4210333265009629277070714e-297, "1421033326500963", -296},
    {9.8130576854075952798870591e-228, "9813057685407595", -227},
    {3.8663875003422416740881879e-62, "38663875003422417", -61},
    {1.1541900036697817231130568e+117, "11541900036697817", 118},
    {4.9990995582831269756429798e-131, "4999099558283127", -130},
    {9.5486154485339374995196256e-170, "9548615448533937", -169},
    {5.1957061731943469716425053e+275, "5195706173194347", 276},
    {1.0612045076573979200000000e+17, "10612045076573979", 18},
    {3.2846514146274759300542308e-205, "3284651414627476", -204},
    {8.3627192503100615224738076e+56, "8362719250310062", 57},
    {2.0017531990809370803216746e-183, "2001753199080937", -182},
    {3.9202397815743663579404596e-125, "39202397815743664", -124},
    {3.8984640859032886339718971e+01, "38984640859032886", 2},
    {1.1065039146894704796842909e+241, "11065039146894705", 242},
    {2.3347074367519712043424581e-248, "23347074367519712", -247},
    {5.7940631545748759728272114e-261, "5794063154574876", -260},
    {3.0696385818706048722757072e+261, "3069638581870605", 262},
    {3.0314190965515904834171522e+131, "30314190965515905", 132},
    {1.9792204066359763338738412e+126, "19792204066359763", 127},
    {8.6994567002817156662132399e-120, "8699456700281716", -119},
    {2.4006699639346631091295079e+196, "2400669963934663", 197},
    {5.8443686015364769412520075e+262, "5844368601536477", 263},
    {4.7348320232441195861088846e-174, "473483202324412", -173},
    {7.5073000023437289771150473e+126, "7507300002343729", 127},
    {1.3675728165636756297652658e-141, "13675728165636756", -140},
    {5.4943724457231813518358119e+88, "5494372445723181", 89},
    {6.9932943672815691206536649e-164, "6993294367281569", -163},
    {6.2979890972209627372379891e-71, "6297989097220963", -70},
    {1.6351592102001631081096139e-129, "1635159210200163", -128},
    {6.8079699272317279873048187e-123, "6807969927231728", -122},
    {2.7030629791048512087123743e+178, "27030629791048512", 179},
    {1.0579965054113731207874281e-48, "10579965054113731", -47},
    {2.5791071732343594805087612e+253, "25791071732343595", 254},
    {2.6729516195778790732985685e-102, "2672951619577879", -101},
    {7.5179490430277440679938348e+57, "7517949043027744", 58},
    {3.2414251097175196368533470e+36, "32414251097175196", 37},
    {4.5753741998468837860762629e+269, "4575374199846884", 270},
    {7.1943802613799055868680352e+174, "7194380261379906", 175},
    {9.3768721835070857552585469e+73, "9376872183507086", 74},
    {1.2148592184921493574255919e+90, "12148592184921494", 91},
    {3.9596386848018493191703949e+36, "39596386848018493", 37},
    {4.5784860125149978692150029e+142, "4578486012514998", 143},
    {4.5954278754709741623931238e+254, "4595427875470974", 255},
    {1.5835184247881581594876916e-178, "15835184247881582", -177},
    {8.7736599702315038539074171e+156, "8773659970231504", 157},
    {1.2425923766759794005849785e+277, "12425923766759794", 278},
    {2.0679112298249746086808235e-294, "20679112298249746", -293},
    {7.7834695457772298570578063e-212, "778346954577723", -211},
    {2.7225031074256785067211358e+188, "27225031074256785", 189},
    {2.1602418094402532564253232e-94, "21602418094402533", -93},
    {9.8819527833147409116839716e+192, "988195278331474", 193},
    {3.1781466573268915369987843e+306, "31781466573268915", 307},
    {5.4127164235878774373089280e+24, "5412716423587877", 25},
    {1.9794478475791985470677140e+241, "19794478475791985", 242},
    {2.2649852540948386696347629e-151, "22649852540948387", -150},
    {8.0351017210582931888053999e-102, "8035101721058293", -101},
    {1.6279725138301092680477535e+120, "16279725138301093", 121},
    {1.1629682626706737510270239e+180, "11629682626706738", 181},
    {9.1737263240245076000991612e+204, "9173726324024508", 205},
    {1.1573562645206163931619176e-255, "11573562645206164", -254},
    {5.8493031956912211910548649e+01, "5849303195691221", 2},
    {3.1958615303968927448902027e-143, "31958615303968927", -142},
    {1.0948207295848509417950388e-58, "1094820729584851", -57},
    {1.1457017019276840833046315e-306, "11457017019276841", -305},
    {1.3862082235862849753580846e-93, "1386208223586285", -92},
    {1.0308198394320762341459173e+173, "10308198394320762", 174},
    {5.6358513111624519863527359e-63, "5635851311162452", -62},
    {2.3295456826606063452681798e+120, "23295456826606063", 121},
    {4.6834319979583401561772393e-142, "468343199795834", -141},
    {7.4210258620752257744587914e+156, "7421025862075226", 157},
    {5.9830427705608063374405708e-291, "5983042770560806", -290},
    {2.3223498964424845396453569e-230, "23223498964424845", -229},
    {4.8959329225556090132954371e-269, "4895932922555609", -268},
    {5.9571607202880886091512953e+95, "5957160720288089", 96},
    {1.9770928987780847492400561e+204, "19770928987780847", 205},
    {9.2035336863542637914474131e+144, "9203533686354264", 145},
    {3.7814159563273356292112248e-80, "3781415956327336", -79},
    {4.5568761138874449526846076e+29, "4556876113887445", 30},
    {8.8927913939105693136198529e+128, "889279139391057", 129},
    {2.6330835789291952471534837e-241, "26330835789291952", -240},
    {5.6614046477983157498588834e-174, "5661404647798316", -173},
    {7.8993239450818259739527632e-20, "7899323945081826", -19},
    {2.2123720383902424971945607e+305, "22123720383902425", 306},
    {2.0014483989800206330185906e-250, "20014483989800206", -249},
    {3.5687940302790536102847836e+207, "35687940302790536", 208},
    {2.5338262690932557706613723e-114, "25338262690932558", -113},
    {2.2117510714582616793878185e-197, "22117510714582617", -196},
    {8.2167204198642065148877899e-269, "8216720419864207", -268},
    {3.4045494740065065047249136e+122, "34045494740065065", 123},
    {1.3906665572003735329835852e+132, "13906665572003735", 133},
    {1.3704753347588090291107596e+174, "1370475334758809", 175},
    {5.3916852854750814359456098e+38, "53916852854750814", 39},
    {4.3642869355591489950733240e+152, "4364286935559149", 153},
    {1.7407402555698850391790380e+253, "1740740255569885", 254},
    {3.1589087061860816723696897e-34, "31589087061860817", -33},
    {3.6514648043452874382163051e+292, "36514648043452874", 293},
    {3.5278102743078812982292749e-255, "35278102743078813", -254},
    {3.5818450811534665944557370e-115, "35818450811534666", -114},
    {1.4595179351922550672852986e-287, "1459517935192255", -286},
    {2.6905663592128181569033182e+29, "2690566359212818", 30},
    {7.0582805711815180680460184e-56, "7058280571181518", -55},
    {4.4306002358150581716308083e-252, "4430600235815058", -251},
    {7.3096262319961260072886944e+05, "7309626231996126", 6},
    {1.8194580929695109606968576e-158, "1819458092969511", -157},
    {5.2313409787232827279713004e+249, "5231340978723283", 250},
    {1.7471754954148363616306798e-115, "17471754954148364", -114},
    {1.4339551966614780558275656e-238, "1433955196661478", -237},
    {2.9940959496712376847601867e-201, "29940959496712377", -200},
    {1.9480581236234224191059277e-59, "19480581236234224", -58},
    {2.4347843920190946470660542e+34, "24347843920190946", 35},
    {8.1267505907291956230193847e-242, "8126750590729196", -241},
    {2.2973552114963100485124698e+271, "229735521149631", 272},
    {2.8690331298713370544624774e+136, "2869033129871337", 137},
    {5.1639545154324141507464802e+118, "5163954515432414", 119},
    {8.8002042751587163760102359e+128, "8800204275158716", 129},
    {5.4372040133702745570754844e-281, "54372040133702746", -280},
    {4.0222221241524554228560559e+76, "40222221241524554", 77},
    {8.1436877079684784211921882e-143, "8143687707968478", -142},
    {1.8776972633766588076680963e+114, "18776972633766588", 115},
    {6.0972403838021689492743951e-125, "6097240383802169", -124},
    {1.1067561144188783424851225e-207, "11067561144188783", -206},
    {1.8279609829122640938879171e-140, "1827960982912264", -139},
    {1.6875466757649342538048143e+148, "16875466757649343", 149},
    {2.7593265466333932354034594e+81, "27593265466333932", 82},
    {1.4343070148006097061916505e+259, "14343070148006097", 260},
    {2.2353003985628685377919454e+195, "22353003985628685", 196},
    {3.3256975615864480977819806e-140, "3325697561586448", -139},
    {1.0865096473238451712826524e+175, "10865096473238452", 176},
    {2.7086220516357894801034914e-58, "27086220516357895", -57},
    {1.6947829729363219531522751e+98, "1694782972936322", 99},
    {3.5717986521981041600710669e-92, "3571798652198104", -91},
    {8.3921616494102556496195072e+186, "8392161649410256", 187},
    {5.8814157442209321198987367e+277, "5881415744220932", 278},
    {5.5232175758905446134780544e-214, "5523217575890545", -213},
    {3.6802973710621722554370947e+117, "3680297371062172", 118},
    {2.8859952582874605812231182e+152, "28859952582874606", 153},
    {5.8519632632689234090803587e-258, "5851963263268923", -257},
    {2.6377064875282742949872686e+265, "26377064875282743", 266},
    {3.7324063687896138517679741e-21, "3732406368789614", -20},
    {6.9379182499208947351919977e+236, "6937918249920895", 237},
    {6.0030145861713303051770724e+36, "600301458617133", 37},
    {1.3019161346703045115915003e+121, "13019161346703045", 122},
    {3.0903653250263001021756426e-57, "30903653250263", -56},
    {2.2296175915983830136525185e-212, "2229617591598383", -211},
    {7.8945440376819113803763802e-98, "7894544037681911", -97},
    {6.4351387293718079165579749e-229, "6435138729371808", -228},
    {4.0388833777702532425399135e+299, "4038883377770253", 300},
    {7.5554822853764581573758818e-294, "7555482285376458", -293},
    {1.1427664047364360482223798e+43, "1142766404736436", 44},
    {9.9960611654740699840035259e+127, "999606116547407", 128},
    {1.7689364122921761603336369e+106, "17689364122921762", 107},
    {7.8356198215705569563457639e+276, "7835619821570557", 277},
    {2.7143292771478136613327703e+257, "27143292771478137", 258},
    {2.6748458099599765406028651e+155, "26748458099599765", 156},
    {1.5675000111121310675768000e-138, "1567500011112131", -137},
    {1.0409815320446925946346729e-48, "10409815320446926", -47},
    {2.7399592955092742218767787e-39, "27399592955092742", -38},
    {9.6165310682694418761075026e+30, "9616531068269442", 31},
    {1.5235019183855230357143001e-132, "1523501918385523", -131},
    {1.2432740862810650268442327e+255, "1243274086281065", 256},
    {3.7155523384944070092695730e+276, "3715552338494407", 277},
    {3.1037019831649756585539482e-165, "31037019831649757", -164},
    {7.7328204969300702301021429e+113, "773282049693007", 114},
    {1.6219648881622962208416593e-253, "16219648881622962", -252},
    {9.0901974127759512815598222e+185, "9090197412775951", 186},
    {1.2284857584304722318818153e+243, "12284857584304722", 244},
    {4.5614523446240936402997746e+170, "45614523446240936", 171},
    {2.3544162171653025908015573e+207, "23544162171653026", 208},
    {1.6205920394321256971130482e-204, "16205920394321257", -203},
    {8.4844598761410293663698778e-69, "8484459876141029", -68},
    {5.7745966351034620326001072e+212, "5774596635103462", 213},
    {3.9679309184900034611468015e+182, "39679309184900035", 183},
    {3.8667927148860822753812828e+205, "38667927148860823", 206},
    {1.2761493551568258523771548e+194, "12761493551568259", 195},
    {4.2513292597696099141638616e+274, "425132925976961", 275},
    {2.8608461707486305833330697e+303, "28608461707486306", 304},
    {1.5454421407838483798157241e-105, "15454421407838484", -104},
    {3.1281713961397522651414653e-262, "3128171396139752", -261},
    {9.1004488572625886497713061e-113, "9100448857262589", -112},
    {1.3213539347737116809109266e+289, "13213539347737117", 290},
    {3.6236533301901103489835992e-57, "36236533301901103", -56},
    {7.1182060996370174123091549e-242, "7118206099637017", -241},
    {8.5599206519680616858901108e-222, "8559920651968062", -221},
    {1.8534338584279056275828345e+291, "18534338584279056", 292},
    {1.8073797399071596490579974e+108, "18073797399071596", 109},
    {1.4191722113719014270511260e-102, "14191722113719014", -101},
    {9.9564132168363356233524902e+287, "9956413216836336", 288},
    {2.0048172587983099929192038e+26, "200481725879831", 27},
    {9.8916706693669303489538872e+57, "989167066936693", 58},
    {2.4456839744190712175482245e+197, "24456839744190712", 198},
    {4.4499935229931486520238730e+149, "4449993522993149", 150},
    {1.7080106419922087625128645e+198, "17080106419922088", 199},
    {3.5307317835512332577994740e-99, "35307317835512333", -98},
    {1.2213862605536107129988481e+51, "12213862605536107", 52},
    {3.3326920730851579340458403e+269, "3332692073085158", 270},
    {6.8065821403501786892649603e-141, "6806582140350179", -140},
    {1.2209078231140227948841761e-273, "12209078231140228", -272},
    {2.5132025751513622114493472e-254, "25132025751513622", -253},
    {2.2016275056305970291456652e+272, "2201627505630597", 273},
    {9.4366356346073059717704721e+134, "9436635634607306", 135},
    {1.9489031077772942892357378e+213, "19489031077772943", 214},
    {2.0683928264800590277534383e-185, "2068392826480059", -184},
    {1.0843395045336691507200000e+20, "10843395045336692", 21},
    {4.7281500728855487001891091e-98, "4728150072885549", -97},
    {4.5794370987744468751804480e-124, "4579437098774447", -123},
    {1.5090639140422972585095742e+256, "15090639140422973", 257},
    {4.4718953996885118815195837e-40, "4471895399688512", -39},
    {4.6085595533202824242088822e-120, "46085595533202824", -119},
    {5.1749863194979305341346327e+56, "51749863194979305", 57},
    {2.7130270988454732672615011e+136, "27130270988454733", 137},
    {8.3112404667867486755327380e-90, "8311240466786749", -89},
    {3.7512353389994364912592575e+164, "37512353389994365", 165},
    {2.3977814630613260493855049e-184, "2397781463061326", -183},
    {1.1775478255128588161354997e-10, "11775478255128588", -9},
    {2.3541473686258276784135092e-204, "23541473686258277", -203},
    {5.1093008776451534232068006e-282, "51093008776451534", -281},
    {2.4779984617478522880000000e+18, "24779984617478523", 19},
    {4.1215097030794024448460454e+45, "41215097030794024", 46},
    {1.9024416818511579702763490e+285, "1902441681851158", 286},
    {6.6110524712913905132273398e-201, "661105247129139", -200},
    {4.0821097292137117220178072e+191, "4082109729213712", 192},
    {2.7624746476398620911451430e-276, "2762474647639862", -275},
    {1.2553999180648834818147315e-73, "12553999180648835", -72},
    {7.5504008068143214823753338e+190, "7550400806814321", 191},
    {7.7487237484567510259040458e-91, "7748723748456751", -90},
    {6.3363176081778552398299850e-197, "6336317608177855", -196},
    {2.7202701738433076108914214e+253, "27202701738433076", 254},
    {7.3642996745130620461239937e-173, "7364299674513062", -172},
    {1.8846762261241156250000000e+13, "18846762261241156", 14},
    {2.0233382591203544648870022e-246, "20233382591203545", -245},
    {2.8522729561713392897771049e-297, "28522729561713393", -296},
    {1.1696692250715446890648146e+57, "11696692250715447", 58},
    {1.5031889628018401623927119e+284, "150318896280184", 285},
    {3.5251907108724746700964462e-217, "35251907108724747", -216},
    {5.0008212890370739639166849e-111, "5000821289037074", -110},
    {3.2941933917255522078861436e+185, "3294193391725552", 186},
    {2.3075599204257381301044133e-164, "2307559920425738", -163},
    {5.0596283565748975849683261e+259, "50596283565748976", 260},
    {3.3160041463408555463188917e-251, "33160041463408555", -250},
    {6.6235995649812942221633163e+233, "6623599564981294", 234},
    {4.9442885042301365026453067e+193, "49442885042301365", 194},
    {2.9437579937478598039961600e+24, "294375799374786", 25},
    {1.1597586796349094556434713e+49, "11597586796349095", 50},
    {4.2104669820261493706797928e+79, "42104669820261494", 80},
    {1.3543142609976336359977722e+07, "13543142609976336", 8},
    {5.3181546880089537851238962e-273, "5318154688008954", -272},
    {9.5562756973074364307009362e+148, "9556275697307436", 149},
    {2.1245369985536444078477341e-124, "21245369985536444", -123},
    {1.5280718507087755745621217e-153, "15280718507087756", -152},
    {4.7194066881838564491491671e+77, "4719406688183856", 78},
    {1.0131840174841242006707448e+51, "10131840174841242", 52},
    {7.2145944702900296551804780e+245, "721459447029003", 246},
    {9.6343092816412554308251864e+300, "9634309281641255", 301},
    {3.3786407358572498500363610e+160, "337864073585725", 161},
    {9.3524036310457402449963473e+144, "935240363104574", 145},
    {1.0167646765951919936511078e+238, "1016764676595192", 239},
    {1.5533664685253784053067295e+112, "15533664685253784", 113},
    {3.3923139951670555396528901e-236, "33923139951670555", -235},
    {1.0297804870284180990625977e-295, "1029780487028418", -294},
    {9.3509211311543247420943668e-165, "9350921131154325", -164},
    {6.9716465665325828142430645e+198, "6971646566532583", 199},
    {1.3655472115820896661204127e-89, "13655472115820897", -88},
    {1.7480375152690967417834905e-28, "17480375152690967", -27},
    {1.8883946639300263617510252e+278, "18883946639300264", 279},
    {1.0897194566719276959818280e+182, "10897194566719277", 183},
    {3.6778720831292127815084275e-165, "3677872083129213", -164},
    {1.2307287789117796660008568e-172, "12307287789117797", -171},
    {5.9615904470367078428630187e-155, "5961590447036708", -154},
    {4.0242908945602039243829538e-36, "4024290894560204", -35},
    {4.8294821812898010253743969e-98, "4829482181289801", -97},
    {3.1390867659237060356410255e-70, "3139086765923706", -69},
    {1.4308641268430125511171470e+125, "14308641268430126", 126},
    {1.4421689437666758926998522e+257, "1442168943766676", 258},
    {3.0442570453321522752009874e-239, "30442570453321523", -238},
    {2.4571057000950970697476012e+240, "2457105700095097", 241},
    {1.9302213991819317411204892e+113, "19302213991819317", 114},
    {1.0908573867690857418511224e+85, "10908573867690857", 86},
    {5.0145631132289545903859840e+155, "5014563113228955", 156},
    {4.7485945569584565413471055e-249, "4748594556958457", -248},
    {1.6434980323484842468278431e+123, "16434980323484842", 124},
    {7.0042259808633690282259746e+134, "7004225980863369", 135},
    {1.0667684108824273611546513e+289, "10667684108824274", 290},
    {1.2476140140492221926384039e-85, "12476140140492222", -84},
    {2.2205275460934492912498043e+289, "22205275460934493", 290},
    {8.3542490656647748662457316e-154, "8354249065664775", -153},
    {5.2278470455625962315427622e-194, "5227847045562596", -193},
    {5.2707840918361225809640300e-121, "5270784091836123", -120},
    {2.5702707938715036128609501e+186, "25702707938715036", 187},
    {1.7560583797234561553874903e+148, "17560583797234562", 149},
    {3.6764415786293198106917417e-214, "367644157862932", -213},
    {6.9645996642999016857185519e-204, "6964599664299902", -203},
    {3.0223034635950307873782545e-302, "3022303463595031", -301},
    {3.4838577362192481129761006e-11, "3483857736219248", -10},
    {1.3247692687498971390264716e+153, "13247692687498971", 154},
    {6.4568886815462285739001155e-273, "64568886815462286", -272},
    {2.8310121245976860162914640e-63, "2831012124597686", -62},
    {1.3516778479735041464439739e-85, "13516778479735041", -84},
    {5.2707289842761614605821632e-219, "52707289842761615", -218},
    {2.8586369569845986399505202e-136, "28586369569845986", -135},
    {8.3876608782042306560000000e+18, "8387660878204231", 19},
    {1.5767534195343635340009217e-225, "15767534195343635", -224},
    {2.1825138204648601356481149e-167, "218251382046486", -166},
    {3.4108287667611447288345813e-29, "3410828766761145", -28},
    {6.1152797805050074893433904e-47, "61152797805050075", -46},
    {3.3677370692955237623766277e-250, "3367737069295524", -249},
    {6.6888565448424819256757525e-90, "6688856544842482", -89},
    {1.0882272356979839038554182e-67, "10882272356979839", -66},
    {2.1806936655358473446814698e-253, "21806936655358473", -252},
    {1.7232500829578732100007943e-91, "17232500829578732", -90},
    {4.2884885365766218114090993e-47, "4288488536576622", -46},
    {6.4243698248233363501309179e+29, "6424369824823336", 30},
    {5.8459258558136597419052216e+95, "584592585581366", 96},
    {3.4091974515311205170589767e+187, "34091974515311205", 188},
    {8.9137052232166600121512155e-45, "891370522321666", -44},
    {3.0762197067961450952418412e-31, "3076219706796145", -30},
    {4.9750643237875545513550662e-292, "49750643237875546", -291},
    {9.4489555368888436743014352e-144, "9448955536888844", -143},
    {2.3464713387243746583038534e-26, "23464713387243747", -25},
    {5.1638347601947992272153180e-282, "5163834760194799", -281},
    {1.3272990627953111579555375e+162, "13272990627953112", 163},
    {3.4907766238916399324364748e-06, "349077662389164", -5},
    {5.3464781939184859025521218e-223, "5346478193918486", -222},
    {7.5963198005859110057824892e+104, "7596319800585911", 105},
    {3.0516789014902053412778482e-280, "30516789014902053", -279},
    {7.0340711626136473600000000e+17, "7034071162613647", 18},
    {1.2754416851169043988845907e-254, "12754416851169044", -253},
    {1.9456154934654393006253467e+143, "19456154934654393", 144},
    {9.1016725702049434137722128e-178, "9101672570204943", -177},
    {3.9654324300679201400881477e+304, "396543243006792", 305},
    {2.5057386894575321742221216e-175, "25057386894575322", -174},
    {1.7598972119129230120666737e+185, "1759897211912923", 186},
    {1.1796116519116489191213595e+184, "1179611651911649", 185},
    {1.9755397327121605101651731e-268, "19755397327121605", -267},
    {2.4511701284974568882543488e-281, "2451170128497457", -280},
    {2.5617627269603801676692788e+112, "256176272696038", 113},
    {3.8881773949184247370731470e-184, "38881773949184247", -183},
    {6.8523246039165513446465639e-26, "6852324603916551", -25},
    {1.0461135296388946588538667e+86, "10461135296388947", 87},
    {6.1630691890509695312500000e+13, "61630691890509695", 14},
    {5.8894795308469045994056675e-289, "5889479530846905", -288},
    {7.3116276982452229699925727e+34, "7311627698245223", 35},
    {1.9091387657116855900001272e+28, "19091387657116856", 29},
    {1.6694007807951783097172567e-139, "16694007807951783", -138},
    {3.6490973827559812491788439e-257, "3649097382755981", -256},
    {2.0019394433002143255989196e-97, "20019394433002143", -96},
    {1.5124979553982361542913259e-236, "15124979553982362", -235},
    {1.2225647215226808360709343e+112, "12225647215226808", 113},
    {1.6288736477211020507812500e+12, "1628873647721102", 13},
    {2.6936641467024190625000000e+14, "2693664146702419", 15},
    {9.4526448186775605033658649e-40, "945264481867756", -39},
    {8.7000795178850844199868723e-69, "8700079517885084", -68},
    {1.2267776109782598116690649e+211, "12267776109782598", 212},
    {8.9289140065542627507834733e-118, "8928914006554263", -117},
    {4.3855570045221484291104149e-250, "43855570045221484", -249},
    {3.4842081600001553177809841e+178, "3484208160000155", 179},
    {1.5411301017975457636361495e-291, "15411301017975458", -290},
    {7.6715025152232600198825740e+195, "767150251522326", 196},
    {7.5032312987669949109416190e-304, "7503231298766995", -303},
    {8.7714406442535628970899781e+258, "8771440644253563", 259},
    {6.3791320456062706383905064e-46, "6379132045606271", -45},
    {1.4615001537805525387263704e+95, "14615001537805525", 96},
    {4.7085355427092264601599539e+185, "47085355427092265", 186},
    {4.5074095580197930309665494e+179, "4507409558019793", 180},
    {4.0148597808475294021237677e-121, "4014859780847529", -120},
    {9.4362699253137093932526440e-55, "943626992531371", -54},
    {9.5763494356336101119176771e-138, "957634943563361", -137},
    {3.0733928142800352360936157e-35, "3073392814280035", -34},
    {6.4699223788053467286098676e-93, "6469922378805347", -92},
    {4.0646045355885029597824100e+197, "4064604535588503", 198},
    {2.3808629077800782655050830e-284, "23808629077800783", -283},
    {1.9090876396705493874315501e-247, "19090876396705494", -246},
    {1.0032180708945288844094486e+130, "10032180708945289", 131},
    {2.5294207821139577148550567e-27, "25294207821139577", -26},
    {1.6839703054453927078118414e-140, "16839703054453927", -139},
    {1.9295886036758831733163488e-107, "19295886036758832", -106},
    {3.5256075892809202788132225e-286, "35256075892809203", -285},
    {9.5349207687629019464006795e+205, "9534920768762902", 206},
    {1.2300268145728299093656629e-296, "123002681457283", -295},
    {8.8796246918281839042426813e+36, "8879624691828184", 37},
    {1.5328031305455290493142830e-187, "1532803130545529", -186},
    {1.8449523207728029011447465e-64, "1844952320772803", -63},
    {5.1905283589049231250000000e+14, "5190528358904923", 15},
    {1.1953875856010465739099339e-250, "11953875856010466", -249},
    {7.3114122320747918422082045e+102, "7311412232074792", 103},
    {9.9251520382001768754651654e-297, "9925152038200177", -296},
    {1.2142517183283705029833264e+126, "12142517183283705", 127},
    {1.5801808142955147784255892e-219, "15801808142955148", -218},
    {1.0538075342432583029360109e-196, "10538075342432583", -195},
    {1.3148922466227091179511838e-268, "1314892246622709", -267},
    {9.9211135492026708157689620e-208, "992111354920267", -207},
    {2.1514501830210930179576540e-303, "2151450183021093", -302},
    {7.0731880880481782713039639e+292, "7073188088048178", 293},
    {2.8495912767943568514222642e-270, "2849591276794357", -269},
    {2.1647830204644708167327524e+56, "2164783020464471", 57},
    {4.2733363253476293100305232e+298, "4273336325347629", 299},
    {3.1728205023080466452289851e+49, "31728205023080466", 50},
    {6.2010314006654184282131227e+38, "62010314006654184", 39},
    {5.5646429872460029683074490e-261, "5564642987246003", -260},
    {1.1181838237846954661973793e-93, "11181838237846955", -92},
    {5.0199384540282226973374009e-33, "5019938454028223", -32},
    {1.4431860495578557107029028e+259, "14431860495578557", 260},
    {1.1961251981524092574417026e-97, "11961251981524093", -96},
    {6.0096761904044109168392639e+40, "6009676190404411", 41},
    {1.1984720744643040577863165e+87, "1198472074464304", 88},
    {1.3711846117415990229205050e-177, "1371184611741599", -176},
    {2.1511773794989445204656518e+247, "21511773794989445", 248},
    {3.7594477940157311968505383e+06, "3759447794015731", 7},
    {1.2162525964576461573504013e-127, "12162525964576462", -126},
    {1.6883287544064976712003349e+264, "16883287544064977", 265},
    {1.5385646527512805429346169e-283, "15385646527512805", -282},
    {2.6099249134396810813952817e+187, "2609924913439681", 188},
    {3.2748343413597312117273941e+164, "3274834341359731", 165},
    {1.5764466989028092021291345e-182, "15764466989028092", -181},
    {1.2527555399308698906300137e-232, "12527555399308699", -231},
    {3.1565358406712423228877476e+185, "31565358406712423", 186},
    {2.2120283198664842119208153e-100, "22120283198664842", -99},
    {7.9829947566318695563017302e-258, "798299475663187", -257},
    {1.9723723002573242223625983e+146, "19723723002573242", 147},
    {2.7873517518147761255301896e+299, "2787351751814776", 300},
    {3.0698143883481498495401921e+158, "306981438834815", 159},
    {1.2456622821076354640782617e-37, "12456622821076355", -36},
    {4.8455200491512012536837258e+210, "4845520049151201", 211},
    {1.0152487076491444246602615e-177, "10152487076491444", -176},
    {5.7994832246172516586388052e-104, "5799483224617252", -103},
    {6.2470315449651078364608865e+285, "6247031544965108", 286},
    {9.5293086291309300000000000e+14, "952930862913093", 15},
    {5.7057607342382741000837072e+87, "5705760734238274", 88},
    {1.3374098349381581649360448e-195, "13374098349381582", -194},
    {1.5779866148700613542908357e+114, "15779866148700614", 115},
    {1.7208172983975561624162120e-168, "17208172983975562", -167},
    {1.3493586482774844738948705e+93, "13493586482774845", 94},
    {1.5267065469903297511819727e-294, "15267065469903298", -293},
    {2.5927684810600803223941104e+281, "25927684810600803", 282},
    {4.8417781210448520309535362e-79, "4841778121044852", -78},
    {5.1398421061755131304205377e+51, "5139842106175513", 52},
    {3.5580067133917420141381731e+124, "3558006713391742", 125},
    {2.8799438779838638404263428e-153, "2879943877983864", -152},
    {4.8612461797540353197460265e-88, "48612461797540353", -87},
    {1.8136268895549875335990704e-199, "18136268895549875", -198},
    {8.6740214578895971552448102e-131, "8674021457889597", -130},
    {3.3044627970113179113313914e-09, "3304462797011318", -8},
    {1.0525597062414378967987280e+44, "10525597062414379", 45},
    {1.8986409619285202765581744e+00, "18986409619285203", 1},
    {1.1509293846712915569557889e+92, "11509293846712916", 93},
    {2.7647295437177478847846364e+54, "2764729543717748", 55},
    {3.1669637088349489577980878e-240, "3166963708834949", -239},
    {5.1428714806071664763216550e+120, "51428714806071665", 121},
    {7.5464898066313318570688850e-90, "7546489806631332", -89},
    {4.8807698484987884160069558e+100, "48807698484987884", 101},
    {1.4084501239910224695546235e+119, "14084501239910225", 120},
    {1.5356833207767879939829205e-255, "1535683320776788", -254},
    {1.7471992445081604057730575e-104, "17471992445081604", -103},
    {3.1360907932537896429130459e+122, "31360907932537896", 123},
    {8.1173466860353695136244548e-215, "811734668603537", -214},
    {7.8642170341284439813733591e-92, "7864217034128444", -91},
    {1.7994871800439698259695549e-247, "17994871800439698", -246},
    {1.2443064958385975181118935e-242, "12443064958385975", -241},
    {1.3174907800409150242137202e+31, "1317490780040915", 32},
    {2.3681109802502900940800000e+21, "236811098025029", 22},
    {5.3326659551174765045640449e+207, "5332665955117477", 208},
    {7.7476116437847360761253528e-102, "7747611643784736", -101},
    {1.4188473457050922729482368e-119, "14188473457050923", -118},
    {1.3365859485385148519281601e-224, "13365859485385149", -223},
    {2.9365773684800935775375909e+47, "29365773684800936", 48},
    {4.9466966349454580067250203e+145, "4946696634945458", 146},
    {1.4026021093439359307450150e+219, "1402602109343936", 220},
    {2.6907793091187720873586245e-135, "2690779309118772", -134},
    {6.8867169674144630420187241e+00, "6886716967414463", 1},
    {9.7502276565433027308438372e-241, "9750227656543303", -240},
    {1.5041114120627816351245396e-234, "15041114120627816", -233},
    {4.6615073783037961777790479e+104, "4661507378303796", 105},
    {1.1108683042757235617448631e-293, "11108683042757236", -292},
    {1.8781916185626993279442083e+178, "18781916185626993", 179},
    {3.4082544962162990604021492e-270, "3408254496216299", -269},
    {2.3462078089931859754924593e+122, "2346207808993186", 123},
    {2.8304239486642616836360213e+172, "28304239486642617", 173},
    {6.3002941846686203343324342e-85, "630029418466862", -84},
    {2.2910637856009997845120998e+220, "2291063785601", 221},
    {1.0291040852425472467613670e+155, "10291040852425472", 156},
    {8.3665990665130841177615177e+58, "8366599066513084", 59},
    {8.5515657357141502858634320e-288, "855156573571415", -287},
    {1.3240252126972438837257356e+183, "1324025212697244", 184},
    {5.6641259863430836645562118e+263, "5664125986343084", 264},
    {4.0188584325517058721093474e-283, "4018858432551706", -282},
    {6.3036757765124408818899759e+254, "6303675776512441", 255},
    {1.3044395357459930200520515e-92, "1304439535745993", -91},
    {4.3614455565711696430470568e+178, "436144555657117", 179},
    {2.6834363124438252864261999e+270, "26834363124438253", 271},
    {2.3180169471252122582556288e-117, "23180169471252123", -116},
    {1.4993406704522007092917170e-121, "14993406704522007", -120},
    {1.1462442623814592663811428e+104, "11462442623814593", 105},
    {1.8227453179927396094142053e+149, "18227453179927396", 150},
    {1.1988066990780701971343147e+244, "11988066990780702", 245},
    {1.8071043302024649144255412e-225, "1807104330202465", -224},
    {2.9543154293519065132036726e+251, "29543154293519065", 252},
    {1.5549980526930294538788233e-109, "15549980526930295", -108},
    {1.8274271769132079614728310e-39, "1827427176913208", -38},
    {1.3810107202827942842487830e-103, "13810107202827943", -102},
    {5.5749409881707876463935385e+290, "55749409881707876", 291},
    {7.3430090669034144482985445e+36, "7343009066903414", 37},
    {2.1322464042861785710595427e+35, "21322464042861786", 36},
    {3.9580561390676480415390993e+40, "3958056139067648", 41},
    {1.0154250140642186161769100e-251, "10154250140642186", -250},
    {2.3424642749714572335927261e+204, "23424642749714572", 205},
    {6.1172645827547356795404539e-282, "6117264582754736", -281},
    {1.0610158400080946353315536e+138, "10610158400080946", 139},
    {8.9657951349759565405116383e+124, "8965795134975957", 125},
    {1.5134798917589811216420504e-202, "15134798917589811", -201},
    {9.3485228337501453716737446e+49, "9348522833750145", 50},
    {4.8035011086176809129948063e-208, "4803501108617681", -207},
    {4.5513688010097075914999171e+167, "45513688010097076", 168},
    {1.2531308861090296799311228e-253, "12531308861090297", -252},
    {2.1745039661389210219720818e-197, "2174503966138921", -196},
    {2.1525047073576418032088248e+276, "21525047073576418", 277},
    {2.0169716759030917451929429e-166, "20169716759030917", -165},
    {1.4993250609138410992696619e+205, "1499325060913841", 206},
    {3.0038154242070384669700638e-142, "30038154242070385", -141},
    {5.5886014442687426627968905e-80, "5588601444268743", -79},
    {3.9436190291602180840435148e-75, "3943619029160218", -74},
    {1.7407452964028699841160522e-59, "174074529640287", -58},
    {1.0964638338485583175374889e-213, "10964638338485583", -212},
    {8.6890034608084136987364308e+302, "8689003460808414", 303},
    {2.7396807014478504170159895e+252, "27396807014478504", 253},
    {2.7703408829318087875447920e+271, "27703408829318088", 272},
    {3.3491205638786693376503168e+119, "3349120563878669", 120},
    {7.0063224784017095565795898e+09, "700632247840171", 10},
    {3.3863169967561399793856704e-13, "338631699675614", -12},
    {5.9176177081987563181913079e+234, "5917617708198756", 235},
    {1.8573735615666151086710260e-112, "1857373561566615", -111},
    {2.1878640877329896911667200e+23, "21878640877329897", 24},
    {1.0503086801491255473440123e+224, "10503086801491255", 225},
    {7.7711329617806364128961520e+54, "7771132961780636", 55},
    {9.2459168659010683764744431e-117, "9245916865901068", -116},
    {2.1871920596349806911789466e+26, "21871920596349807", 27},
    {2.1524342510537635390794841e-89, "21524342510537635", -88},
    {5.5381874364331543538116545e+65, "5538187436433154", 66},
    {1.4650830632058054899350274e-148, "14650830632058055", -147},
    {2.7697670416224431464096386e-177, "2769767041622443", -176},
    {5.3749926487235491821542973e+98, "5374992648723549", 99},
    {4.3714878555130196911582103e+115, "437148785551302", 116},
    {5.0599199574693518160789357e+209, "5059919957469352", 210},
    {1.6276009476189220648373056e-233, "1627600947618922", -232},
    {1.5190539531103980865339689e+95, "1519053953110398", 96},
    {6.3319198855316820846022826e-250, "6331919885531682", -249},
    {4.1315941947397252770958934e-182, "4131594194739725", -181},
    {2.6095617502231881421031963e-63, "2609561750223188", -62},
    {5.8366841911932564959346726e-164, "58366841911932565", -163},
    {9.5335157289967350228451043e-268, "9533515728996735", -267},
    {2.5993585838924047253846877e+174, "25993585838924047", 175},
    {1.8854217048366160983922655e-283, "1885421704836616", -282},
    {5.1046181871682860282201973e+199, "5104618187168286", 200},
    {1.1285997375276347075711962e-54, "11285997375276347", -53},
    {1.3915047796088304147568406e-286, "13915047796088304", -285},
    {4.0202508282618112081140867e+285, "4020250828261811", 286},
    {4.8247360335664338419445289e+232, "4824736033566434", 233},
    {1.6663858129474624604680410e-233, "16663858129474625", -232},
    {1.3070959699257858881074263e-133, "13070959699257859", -132},
    {8.8978511173024176185100351e-92, "8897851117302418", -91},
    {1.3387335344422507345594516e+132, "13387335344422507", 133},
    {5.7915091417191416320605620e-44, "5791509141719142", -43},
    {6.4897898547098343802973793e-114, "64897898547098344", -113},
    {2.4166071598639571351749368e+289, "2416607159863957", 290},
    {1.7123066068291480818954687e-307, "1712306606829148", -306},
    {3.0847104657506518584327780e-55, "3084710465750652", -54},
    {3.0675761255486338018497278e+158, "3067576125548634", 159},
    {1.8572966457804716393111673e-110, "18572966457804716", -109},
    {1.1878493371500956963894610e-132, "11878493371500957", -131},
    {2.4038462439116277455891027e-249, "24038462439116277", -248},
    {1.1393168025620484866437897e+207, "11393168025620485", 208},
    {4.3672349964672808869804678e+124, "4367234996467281", 125},
    {6.8222924273483044917932732e+76, "6822292427348304", 77},
    {1.1582996408570265075650478e-20, "11582996408570265", -19},
    {1.0559817241736942931655562e+128, "10559817241736943", 129},
    {3.5788615033778944807536890e+56, "35788615033778945", 57},
    {5.8275022352319335763284160e+292, "5827502235231934", 293},
    {2.2002910661142468554522851e-12, "2200291066114247", -11},
    {4.6350293528567406098306277e+293, "46350293528567406", 294},
    {3.2525941665514912726545498e-234, "3252594166551491", -233},
    {2.1349467076650112500000000e+15, "21349467076650112", 16},
    {1.6375172697476343157827885e-298, "16375172697476343", -297},
    {3.1017078016347798911318738e-34, "310170780163478", -33},
    {1.4263545335855171539462431e+289, "14263545335855172", 290},
    {2.0787214323732110838878033e+67, "2078721432373211", 68},
    {2.5279984109292620743203965e-267, "2527998410929262", -266},
    {9.4855451342842269935146780e-196, "9485545134284227", -195},
    {6.4879726027109503371695016e+273, "648797260271095", 274},
    {8.3796927404620931531812570e+264, "8379692740462093", 265},
    {1.4082850268704200444919201e+155, "140828502687042", 156},
    {1.4462841601276173796274173e-151, "14462841601276174", -150},
    {1.1962925789679893158365300e+234, "11962925789679893", 235},
    {1.9339323342330411122359155e+40, "1933932334233041", 41},
    {5.2423998059685268931826799e+113, "5242399805968527", 114},
    {1.5422900352194024658203125e+11, "15422900352194025", 12},
    {4.4581934915585112805299631e-265, "44581934915585113", -264},
    {2.5021110878826049126214387e-43, "2502111087882605", -42},
    {4.9512111413562923091742429e+190, "4951211141356292", 191},
    {1.6303522345970074841144939e+231, "16303522345970075", 232},
    {1.6390587291851948949453285e+89, "1639058729185195", 90},
    {2.3728580775165716261812028e+131, "23728580775165716", 132},
    {2.5988338181201649724586089e-58, "2598833818120165", -57},
    {2.6380733414451283235039438e-279, "26380733414451283", -278},
    {1.2367561756521364624189264e-185, "12367561756521365", -184},
    {1.7366229287703668113445724e-257, "17366229287703668", -256},
    {3.0477304418518199248692629e-223, "304773044185182", -222},
    {1.4443557498255916567023503e-84, "14443557498255917", -83},
    {4.3633596029747756725492057e+250, "43633596029747757", 251},
    {1.0067482809941263780438076e-269, "10067482809941264", -268},
    {5.9779580380039724270978608e+63, "59779580380039724", 64},
    {7.4373380770250334901824521e-53, "74373380770250335", -52},
    {1.6137869966411950286417466e-153, "1613786996641195", -152},
    {1.0495541297005007888082806e-161, "10495541297005008", -160},
    {9.9379509113749811363729194e-259, "9937950911374981", -258},
    {3.5524823256825757303524624e+105, "35524823256825757", 106},
    {3.3069612491785612541989286e+92, "3306961249178561", 93},
    {7.4113567437940454645193621e-268, "7411356743794045", -267},
    {8.0001891157273921981469437e-128, "8000189115727392", -127},
    {1.6294721537696906498004921e+218, "16294721537696906", 219},
    {8.5044220114850854089202062e-76, "8504422011485085", -75},
    {6.2521124940150172242839016e-101, "6252112494015017", -100},
    {1.1950301408323847647716883e-269, "11950301408323848", -268},
    {1.0849502176529493674346852e+248, "10849502176529494", 249},
    {1.5419724425826233379766663e+227, "15419724425826233", 228},
    {1.8332447818914924875887596e+95, "18332447818914925", 96},
    {4.8566375198021295196354180e+231, "48566375198021295", 232},
    {9.3734850994071136977760069e+133, "9373485099407114", 134},
    {2.0042440281093205092647059e-190, "20042440281093205", -189},
    {5.8245468535678936417211716e+295, "5824546853567894", 296},
    {1.8163880851520554379699108e-164, "18163880851520554", -163},
    {1.0725118411163216058329562e-50, "10725118411163216", -49},
    {1.8253653169823111213248651e-169, "1825365316982311", -168},
    {3.6397152486439835134338083e-04, "36397152486439835", -3},
    {7.8927316697118428981867368e-57, "7892731669711843", -56},
    {5.5718067104118837607077528e+177, "5571806710411884", 178},
    {7.0939536875776941107550397e-36, "7093953687577694", -35},
    {3.4295415833849454982200971e+298, "34295415833849455", 299},
    {8.7698233160693142985456658e-244, "8769823316069314", -243},
    {7.4567711307382641361976351e-233, "7456771130738264", -232},
    {4.7027653799926070470011960e+136, "4702765379992607", 137},
    {3.3113831916224527702890952e-121, "33113831916224528", -120},
    {1.3611942700306061529201062e-288, "13611942700306062", -287},
    {3.3551008664050674730684240e-303, "33551008664050675", -302},
    {1.2948752683054787843982750e-84, "12948752683054788", -83},
    {1.1238905145897800863669395e-18, "112389051458978", -17},
    {1.6346570382316293414617699e-170, "16346570382316293", -169},
    {8.7346059700010168515242904e-35, "8734605970001017", -34},
    {4.8023343814960723072925646e+163, "4802334381496072", 164},
    {2.2653866644858707002935406e-18, "22653866644858707", -17},
    {5.9264263048138669181105683e-18, "5926426304813867", -17},
    {1.4000161277459658323847233e-117, "14000161277459658", -116},
    {3.2321589738818347059458574e+255, "32321589738818347", 256},
    {6.1854732687023295033885719e+125, "61854732687023295", 126},
    {1.8556546783397411632476473e+136, "18556546783397412", 137},
    {1.4576505493998219810934398e+124, "1457650549399822", 125},
    {2.2547484361268463540183344e+98, "22547484361268464", 99},
    {1.1124881960152268452696892e-186, "11124881960152268", -185},
    {6.1332086930051708368919704e+284, "6133208693005171", 285},
    {6.4353085046315187686030065e-91, "6435308504631519", -90},
    {3.2416337054378817014535176e-147, "32416337054378817", -146},
    {1.3629883254117623299758425e-136, "13629883254117623", -135},
    {4.0856738519067776006872461e+263, "40856738519067776", 264},
    {4.5700454789248637280105188e+78, "4570045478924864", 79},
    {5.5210324695334507436838152e+156, "5521032469533451", 157},
    {2.6587426452184723802746467e+84, "26587426452184724", 85},
    {6.3232744157189604186949644e-38, "632327441571896", -37},
    {6.5826801162005500537675637e-225, "658268011620055", -224},
    {1.4593283549018165465447965e-48, "14593283549018165", -47},
    {1.8779872945214948323217848e-167, "1877987294521495", -166},
    {4.4688057940039138904975316e-88, "4468805794003914", -87},
    {1.1762271881486422467233034e+297, "11762271881486422", 298},
    {7.9788174957197989824407527e-249, "7978817495719799", -248},
    {4.8794794290562146943374998e+66, "4879479429056215", 67},
    {3.5738044383934198513705360e-04, "357380443839342", -3},
    {3.2555488728322011540173244e-124, "3255548872832201", -123},
    {1.8722888431011629639039930e+97, "1872288843101163", 98},
    {8.6296100891550942575083596e+150, "8629610089155094", 151},
    {4.7173764596915424586738365e-210, "47173764596915425", -209},
    {6.1724683840399413730642866e-151, "6172468384039941", -150},
    {3.6230898849260933240098928e+134, "36230898849260933", 135},
    {3.2914317578036977453738769e+31, "32914317578036977", 32},
    {1.0383617596142816031244546e+293, "10383617596142816", 294},
    {3.3406521533045163216076800e+23, "3340652153304516", 24},
    {4.8377167055085830408359188e+189, "4837716705508583", 190},
    {1.1825398483825862402941240e-23, "11825398483825862", -22},
    {1.6105330017980262477153796e+81, "16105330017980262", 82},
    {6.2339204352582682573532795e-141, "6233920435258268", -140},
    {2.9286100483465165143838874e-10, "29286100483465165", -9},
    {1.2769985938812833251331236e-302, "12769985938812833", -301},
    {1.0537607682893197334152683e+51, "10537607682893197", 52},
    {1.5621314807672167918635115e+302, "15621314807672168", 303},
    {9.9792257058708591154596815e-67, "9979225705870859", -66},
    {1.0266174284600709465372389e+96, "1026617428460071", 97},
    {4.1032429812277965483353716e-129, "41032429812277965", -128},
    {7.9009353315830139377150931e-183, "7900935331583014", -182},
    {1.3494039653760648724349998e-159, "13494039653760649", -158},
    {3.4351849487712431249850620e-70, "3435184948771243", -69},
    {8.4900102454099066194123604e+293, "8490010245409907", 294},
    {5.8791187885740225508295782e+140, "58791187885740226", 141},
    {7.2596614682485478806809336e-98, "7259661468248548", -97},
    {2.8463039300858414446955670e-176, "28463039300858414", -175},
    {1.3227518614497134973497302e+305, "13227518614497135", 306},
    {2.7795643380425406295273688e-142, "27795643380425406", -141},
    {3.3144912484873173157650084e-98, "3314491248487317", -97},
    {1.5585215417284475169031886e-145, "15585215417284475", -144},
    {2.9105667591361850800878085e+234, "2910566759136185", 235},
    {3.1014709452902534001866983e-63, "31014709452902534", -62},
    {8.3361147177352006739279043e+250, "8336114717735201", 251},
    {4.7723455984093403767771230e-64, "47723455984093404", -63},
    {6.0666762014883993003877549e+01, "6066676201488399", 2},
    {3.2364477919871349266279011e-152, "3236447791987135", -151},
    {5.3526624266571243094829016e-247, "5352662426657124", -246},
    {6.1358783383197734613984026e+152, "6135878338319773", 153},
    {1.7923877488015085691586137e+05, "17923877488015086", 6},
    {1.0351114214623338471655404e+229, "10351114214623338", 230},
    {1.1941930405511582111682805e-150, "11941930405511582", -149},
    {3.6438516016010479803140968e+243, "3643851601601048", 244},
    {2.6673698694941954240237587e+44, "26673698694941954", 45},
    {5.1729917508767027200000000e+17, "5172991750876703", 18},
    {9.2470584746255548518284202e+178, "9247058474625555", 179},
    {2.3201983020738524414280639e+186, "23201983020738524", 187},
    {1.0443220164774108434777523e+294, "10443220164774108", 295},
    {4.6939213706773943906803519e-213, "46939213706773944", -212},
    {2.0681089284443302046093420e-80, "20681089284443302", -79},
    {8.6410037857233682678608894e+69, "8641003785723368", 70},
    {3.6294090406808625430360929e-224, "36294090406808625", -223},
    {5.4824883112972511674427800e+123, "5482488311297251", 124},
    {2.5901241513043673626155861e-247, "25901241513043674", -246},
    {4.2829550699382878190591432e+89, "4282955069938288", 90},
    {1.7522932624011204782921815e+100, "17522932624011205", 101},
    {3.1565082254744053876324710e+296, "31565082254744054", 297},
    {8.3370380546812783384671242e-17, "8337038054681278", -16},
    {7.7573346184282998792249249e-216, "77573346184283", -215},
    {6.2909041872877382966139974e-273, "6290904187287738", -272},
    {3.0557511862361309081083300e-153, "3055751186236131", -152},
    {8.9983092630155354956768780e-56, "8998309263015535", -55},
    {1.2133019480426314316915262e+38, "12133019480426314", 39},
    {1.0209455250936093644390790e-142, "10209455250936094", -141},
    {1.5392525837040853896189506e-223, "15392525837040854", -222},
    {3.8892485937260188674524555e+267, "3889248593726019", 268},
    {3.9271689029544532667748856e+233, "39271689029544533", 234},
    {1.1529282183319834375670100e+61, "11529282183319834", 62},
    {2.6827161493174629473433794e-243, "2682716149317463", -242},
    {2.6508938441716561916801904e-111, "26508938441716562", -110},
    {2.2377832951959788699364312e-243, "2237783295195979", -242},
    {7.0444266349696627579629436e+140, "7044426634969663", 141},
    {1.0558473721526769666279792e-21, "1055847372152677", -20},
    {2.0114110513411010748898915e-18, "2011411051341101", -17},
    {1.8688222032468481173956994e-251, "1868822203246848", -250},
    {2.0709044905166535609381713e+42, "20709044905166536", 43},
    {2.3415224765834191525322307e-186, "2341522476583419", -185},
    {7.5217219813860228292879517e+179, "7521721981386023", 180},
    {2.0946081293686701836405315e+187, "209460812936867", 188},
    {2.1878911403951197378573522e-172, "21878911403951197", -171},
    {4.4622609607651966635553906e+185, "44622609607651967", 186},
    {3.2056426216436565000000000e+15, "32056426216436565", 16},
    {2.5296162724342202974304505e+63, "25296162724342203", 64},
    {6.7622414155172366936834011e+197, "6762241415517237", 198},
    {3.4336945980252831931148045e-97, "3433694598025283", -96},
    {2.6049116311785295604500218e-231, "26049116311785296", -230},
    {1.7869530562323859672545916e-169, "1786953056232386", -168},
    {4.0903781362341306046521963e-259, "40903781362341306", -258},
    {7.0253474124228289590157660e-49, "7025347412422829", -48},
    {4.2436607608153824416067405e+33, "42436607608153824", 34},
    {2.7878339471976107464638136e+119, "27878339471976107", 120},
    {8.3261750785941656389241827e-155, "8326175078594166", -154},
    {1.6952418400519438806810624e+25, "16952418400519439", 26},
    {1.8963782253882965649254870e-64, "18963782253882966", -63},
    {6.6224502820051099194336037e+131, "662245028200511", 132},
    {1.0308771644020773480062119e-203, "10308771644020773", -202},
    {1.5429395115000750992421184e+33, "1542939511500075", 34},
    {1.4037270893154438000000000e+16, "14037270893154438", 17},
    {6.9074869739494318579129350e+191, "6907486973949432", 192},
    {3.8984949765592365513186825e-197, "38984949765592366", -196},
    {1.5186079528386197678409214e+215, "15186079528386198", 216},
    {1.6348932485107304683235603e+52, "16348932485107305", 53},
    {1.5367471347766153720480489e-280, "15367471347766154", -279},
    {7.1605923270528620000000000e+15, "7160592327052862", 16},
    {2.8651675850134179774118540e-129, "2865167585013418", -128},
    {3.8492466105979733409826646e+164, "38492466105979733", 165},
    {1.7642785045095791287980620e-268, "1764278504509579", -267},
    {3.8532016396984957122755719e+235, "38532016396984957", 236},
    {1.4194742534956220610429995e-261, "1419474253495622", -260},
    {1.1039691175783704349421245e-50, "11039691175783704", -49},
    {1.2063172723841142981860285e+170, "12063172723841143", 171},
    {5.8904704676868829592424435e-40, "5890470467686883", -39},
    {3.6863471279736782716819412e+226, "36863471279736783", 227},
    {9.8095439484822184586270610e+48, "9809543948482218", 49},
    {1.1813519137169702365265999e-256, "11813519137169702", -255},
    {1.7084437850753270692714948e-43, "1708443785075327", -42},
    {1.5469752058472955090268315e-220, "15469752058472955", -219},
    {1.5748459714475346780892953e-131, "15748459714475347", -130},
    {1.4759630329632704905301250e+295, "14759630329632705", 296},
    {1.1423571553848360693393518e-226, "1142357155384836", -225},
    {8.5813171455917575431416883e+112, "8581317145591758", 113},
    {1.5222010044675947075649827e-255, "15222010044675947", -254},
    {9.9808902455506573090218760e+196, "9980890245550657", 197},
    {5.5053443705287044171942366e+219, "55053443705287044", 220},
    {1.3929401060432494233127195e+304, "13929401060432494", 305},
    {3.2811318094938450783925044e-302, "3281131809493845", -301},
    {2.1494858041317560047826025e-237, "2149485804131756", -236},
    {4.5586430775283045563228402e+267, "4558643077528305", 268},
    {3.5223236486474603872543578e+300, "35223236486474604", 301},
    {8.1038375079725155990915519e+133, "8103837507972516", 134},
    {3.2890306186199480192204800e+23, "3289030618619948", 24},
    {1.9977079703459746907514115e-30, "19977079703459747", -29},
    {1.4006915653123681915806904e-166, "14006915653123682", -165},
    {1.2854935266903290557132509e+293, "1285493526690329", 294},
    {1.4010582050949874894140363e+197, "14010582050949875", 198},
    {3.1655379064744440114680999e+123, "3165537906474444", 124},
    {7.3986413217236280662689841e-156, "7398641321723628", -155},
    {6.6079512097461299556445390e+220, "660795120974613", 221},
    {2.0547760915527960694119365e-40, "2054776091552796", -39},
    {3.6693479773668705390382116e+54, "36693479773668705", 55},
    {3.2900094773616395440649213e-200, "32900094773616395", -199},
    {8.8286162160380265746913559e+235, "8828616216038027", 236},
    {1.7571893319085530627355502e-106, "1757189331908553", -105},
    {6.3157299515785330273372804e-103, "6315729951578533", -102},
    {1.4831855797649538491717706e+30, "14831855797649538", 31},
    {3.1962487609863593852098247e-112, "31962487609863594", -111},
    {2.0149368324075091231273524e-129, "2014936832407509", -128},
    {1.3149627968558414443944692e-171, "13149627968558414", -170},
    {2.8255606659979897289565069e-219, "28255606659979897", -218},
    {1.1834301717834499745810566e-44, "118343017178345", -43},
    {2.7041067555872917009782862e-276, "27041067555872917", -275},
    {1.0626848881338896885321644e-13, "10626848881338897", -12},
    {3.0958711819379546697789407e+81, "30958711819379547", 82},
    {1.2093194007342043417010453e-130, "12093194007342043", -129},
    {2.1838007676397573180861181e-247, "21838007676397573", -246},
    {4.7026590570973532608784139e-206, "4702659057097353", -205},
    {4.5984292431231242824392973e+291, "45984292431231243", 292},
    {6.7219869165375985688243539e-286, "6721986916537599", -285},
    {1.4711381842424799264674753e-231, "147113818424248", -230},
    {3.2338452029613870397886785e+272, "3233845202961387", 273},
    {1.2020787506661029287162452e+308, "1202078750666103", 309},
    {6.6250466796339820058117337e+165, "6625046679633982", 166},
    {1.6182845051766385092921697e+122, "16182845051766385", 123},
    {2.7261565534104272929709260e-112, "27261565534104273", -111},
    {1.0683114210469781447559111e+38, "10683114210469781", 39},
    {6.7214052288699832604685727e-32, "6721405228869983", -31},
    {4.5416046165422506890183402e-111, "4541604616542251", -110},
    {3.8283833269904010698780894e+00, "3828383326990401", 1},
    {1.5803476552116836474258091e+173, "15803476552116836", 174},
    {2.3832317731539046102240851e-178, "23832317731539046", -177},
    {6.8573212535003359282310206e-172, "6857321253500336", -171},
    {6.2601287939985227770005858e+109, "6260128793998523", 110},
    {1.6973049158797738550368072e+125, "1697304915879774", 126},
    {2.9719639605187382777605150e+125, "29719639605187383", 126},
    {3.4891171037471893657895453e-253, "34891171037471894", -252},
    {1.1364617930072393273767571e+47, "11364617930072393", 48},
    {1.2501266686971310338243281e+110, "1250126668697131", 111},
    {3.2528760949777219070776193e-81, "3252876094977722", -80},
    {5.2187629176826461205068672e-285, "5218762917682646", -284},
    {1.2274927189651194430530819e-210, "12274927189651194", -209},
    {2.1219177048672333409825329e+139, "21219177048672333", 140},
    {1.7059942138531220913992253e+128, "1705994213853122", 129},
    {6.3327234294270026410251219e+127, "6332723429427003", 128},
    {1.4241092909717715376028530e-87, "14241092909717715", -86},
    {1.1968074122616945770496000e+22, "11968074122616946", 23},
    {2.8600409723137664691876300e-48, "28600409723137665", -47},
    {5.4745034355708140250244019e+85, "5474503435570814", 86},
    {4.7896968830808673111074867e-122, "47896968830808673", -121},
    {8.6858902356605012761249149e-79, "8685890235660501", -78},
    {4.8376682803728783820074396e+154, "48376682803728784", 155},
    {1.0270084778372740345646588e+248, "1027008477837274", 249},
    {8.6292839563912261739596214e-54, "8629283956391226", -53},
    {3.2860695284274105748243002e-159, "32860695284274106", -158},
    {2.7087785145169567905206254e+279, "2708778514516957", 280},
    {4.3766506551278335827954893e+26, "43766506551278336", 27},
    {4.1757674335762796164508272e+61, "41757674335762796", 62},
    {3.0401596940714366354334259e+54, "30401596940714366", 55},
    {1.4139093193385662726533134e+36, "14139093193385663", 37},
    {2.4735565750805067187858625e-228, "24735565750805067", -227},
    {8.4519716197583927054127538e-306, "8451971619758393", -305},
    {5.2861451130849722806581606e-142, "5286145113084972", -141},
    {4.0013273726014390775727583e-222, "4001327372601439", -221},
    {4.3396537466238803176592701e+163, "433965374662388", 164},
    {9.9323120165956587328077859e+79, "9932312016595659", 80},
    {1.8558888992258427500000000e+15, "18558888992258428", 16},
    {4.2284755927771256443503159e+48, "42284755927771256", 49},
    {1.2456590218750179612876624e+256, "1245659021875018", 257},
    {3.4542956663605211889955239e+169, "3454295666360521", 170},
    {4.4806859407124061590250836e-28, "4480685940712406", -27},
    {6.8897654301851956379112655e-107, "6889765430185196", -106},
    {9.6500204915096431674670603e+79, "9650020491509643", 80},
    {2.9197320363231693046473824e-296, "29197320363231693", -295},
    {6.1794685323948053034169084e-24, "6179468532394805", -23},
    {4.4759624503433686983988853e-285, "4475962450343369", -284},
    {2.6381418340012594776111167e+103, "26381418340012595", 104},
    {1.6721817199582376026079499e+186, "16721817199582376", 187},
    {2.2448580217145574780158960e-210, "22448580217145575", -209},
    {1.0542685864285552787569219e-79, "10542685864285553", -78},
    {1.7513854970365225219726562e+11, "17513854970365225", 12},
    {3.2222058756728598330741403e+286, "322220587567286", 287},
    {6.5869831685912626007607428e-292, "6586983168591263", -291},
    {5.7408256259178344316290545e-224, "5740825625917834", -223},
    {9.9466038667672850942281153e-25, "9946603866767285", -24},
    {6.5105992006496258991336085e+288, "6510599200649626", 289},
    {9.5074961617481399832703832e-41, "950749616174814", -40},
    {3.2953528904008376753342024e-21, "32953528904008377", -20},
    {5.7791901505227732555796863e-142, "5779190150522773", -141},
    {3.2183868562381091317913027e+174, "3218386856238109", 175},
    {6.8050904756175269877616897e+286, "6805090475617527", 287},
    {8.6382385837166041056637628e-32, "8638238583716604", -31},
    {2.3212095293558939369368249e-287, "2321209529355894", -286},
    {4.0988605785215738100156007e-25, "4098860578521574", -24},
    {1.8300726959263840798591834e-162, "1830072695926384", -161},
    {9.2777440140689870861336055e-77, "9277744014068987", -76},
    {2.3457583504277968142457552e-128, "2345758350427797", -127},
    {3.3928495401559728486093634e+282, "3392849540155973", 283},
    {7.0564936043583196679302065e+268, "705649360435832", 269},
    {6.2307466269127426137052345e+127, "6230746626912743", 128},
    {1.8927375688406007516729810e-165, "18927375688406008", -164},
    {4.5053865689917727393409005e+150, "4505386568991773", 151},
    {2.8774505103752042774935539e-77, "28774505103752043", -76},
    {5.9308761612830682688186495e-182, "5930876161283068", -181},
    {1.1835757407381784745883689e-55, "11835757407381785", -54},
    {7.1793316533647108844579733e+35, "7179331653364711", 36},
    {4.4812414525592382587535360e+24, "4481241452559238", 25},
    {5.4189199474177299200000000e+17, "541891994741773", 18},
    {2.1574308901933809854751252e-19, "2157430890193381", -18},
    {1.6824822025110664829780853e-219, "16824822025110665", -218},
    {9.4966222297595679419031368e+250, "9496622229759568", 251},
    {5.9838972055676612500000000e+14, "5983897205567661", 15},
    {3.4890362991310100232392808e+202, "348903629913101", 203},
    {3.4614996065585585641084479e-27, "34614996065585586", -26},
    {3.5946080878753167474197061e-229, "3594608087875317", -228},
    {5.2009290088209569307900297e+148, "5200929008820957", 149},
    {2.7172680473679822022967617e+195, "2717268047367982", 196},
    {2.5979213980125282934451646e+296, "25979213980125283", 297},
    {2.0660443793443883006999559e+193, "20660443793443883", 194},
    {2.7176138612815348233500388e-11, "27176138612815348", -10},
    {6.4691203504940236924353876e+195, "6469120350494024", 196},
    {4.5051309264336153156069922e+267, "4505130926433615", 268},
    {1.8168512399424879364089142e-98, "1816851239942488", -97},
    {6.1091494021926806410708252e-211, "6109149402192681", -210},
    {6.8870340508761560857113990e+33, "6887034050876156", 34},
    {8.8703642119444168479319281e+74, "8870364211944417", 75},
    {1.4545115795301481948069307e-258, "14545115795301482", -257},
    {1.1270047916406373967821604e-240, "11270047916406374", -239},
    {1.1810471703639263838373947e+92, "11810471703639264", 93},
    {2.8377894369673795108958436e-284, "28377894369673795", -283},
    {5.0545262997188035325476480e+73, "50545262997188035", 74},
    {7.2524845794408070442921992e-143, "7252484579440807", -142},
    {7.0525184100129688489632320e-92, "7052518410012969", -91},
    {2.6425948728961380796238069e-137, "2642594872896138", -136},
    {1.2120326149256555734809454e+35, "12120326149256556", 36},
    {4.9618076188425870873094875e-149, "4961807618842587", -148},
    {1.8672581890835130301405297e+96, "1867258189083513", 97},
    {3.1643006067832657725134990e-07, "3164300606783266", -6},
    {1.7207346454090084172262920e-239, "17207346454090084", -238},
    {5.7388694607968122480758323e-97, "5738869460796812", -96},
    {1.1382609020025844632620706e-234, "11382609020025845", -233},
    {9.6133098004130729488306824e+247, "9613309800413073", 248},
    {1.6495113284663225897260471e+155, "16495113284663226", 156},
    {1.2355186290274432107026999e-54, "12355186290274432", -53},
    {2.2357427468587658214559814e-260, "2235742746858766", -259},
    {2.1131460430091335253973357e-179, "21131460430091335", -178},
    {2.8308051624405684328864396e-242, "28308051624405684", -241},
    {3.2831209743393747562980448e-256, "3283120974339375", -255},
    {5.7307354772884232898367661e+76, "5730735477288423", 77},
    {6.0384237574229504700302261e+115, "60384237574229505", 116},
    {2.7820956832468205659445623e+282, "27820956832468206", 283},
    {8.3411984300439966835736969e-138, "8341198430043997", -137},
    {5.6599347637779353361761959e-210, "5659934763777935", -209},
    {2.4735378918305467108884169e+52, "24735378918305467", 53},
    {2.8224248654639469456747085e-288, "2822424865463947", -287},
    {1.0619999824562942496608029e-28, "10619999824562942", -27},
    {8.0349762691947659832409955e-146, "8034976269194766", -145},
    {8.4053890241274784165286494e-109, "8405389024127478", -108},
    {4.9701823548458751659000984e+169, "4970182354845875", 170},
    {2.7713233323601690673828125e+11, "2771323332360169", 12},
    {2.4516486298133524168596699e+294, "24516486298133524", 295},
    {1.0928461735304017655449527e-93, "10928461735304018", -92},
    {2.9080428685590429302314524e-227, "2908042868559043", -226},
    {6.4280735202086008063420256e+114, "6428073520208601", 115},
    {1.4690430587453843107866207e+239, "14690430587453843", 240},
    {2.3335503155380031596674341e-09, "2333550315538003", -8},
    {3.0958368347469597635938165e-300, "309583683474696", -299},
    {9.1738342979007622404316140e+299, "9173834297900762", 300},
    {2.0656562693419854921304923e+161, "20656562693419855", 162},
    {1.8247140044256183589256181e+227, "18247140044256184", 228},
    {2.3305401711856192716800000e+20, "23305401711856193", 21},
    {8.5633667062274452826613641e+60, "8563366706227445", 61},
    {2.6518492378767270773566904e-172, "2651849237876727", -171},
    {3.8551181503043323152967176e-199, "38551181503043323", -198},
    {2.3494367568675894597518550e-01, "23494367568675895", 0},
    {3.7972969648023277748152853e+88, "3797296964802328", 89},
    {5.8559663986759314295394953e+100, "58559663986759314", 101},
    {1.0317824284678114449682893e+229, "10317824284678114", 230},
    {3.2779212587564215885418550e-230, "32779212587564216", -229},
    {1.0223478114644646276065448e+40, "10223478114644646", 41},
    {2.5829688808443132484114395e+126, "25829688808443132", 127},
    {3.4858953068346783233133093e+283, "34858953068346783", 284},
    {5.0567783281246617463803853e-300, "5056778328124662", -299},
    {3.5738642652450147401128862e+298, "35738642652450147", 299},
    {6.1097261021696625978692281e+206, "61097261021696626", 207},
    {1.0458339003390420176747006e+102, "1045833900339042", 103},
    {5.6143572104005915627406028e-272, "56143572104005916", -271},
    {2.5264825463502843566041603e-103, "25264825463502844", -102},
    {1.1298876210557381713099798e+86, "11298876210557382", 87},
    {2.0274713430926725942487282e+67, "20274713430926726", 68},
    {2.8277310674242256568567000e-49, "28277310674242257", -48},
    {1.2889768165549771685138969e+181, "12889768165549772", 182},
    {1.9103535413599832746234117e-298, "19103535413599833", -297},
    {2.2887873065549233601316570e+205, "22887873065549234", 206},
    {3.0348089588119681650211790e-204, "3034808958811968", -203},
    {9.8374601952682888243147093e+191, "9837460195268289", 192},
    {6.3402204215087003074560000e+22, "63402204215087", 23},
    {1.7121288952833372251324344e+231, "17121288952833372", 232},
    {5.4229276008904706020951006e-232, "54229276008904706", -231},
    {5.3318993658037734027155193e-85, "5331899365803773", -84},
    {1.1889553191043086298968928e+210, "11889553191043086", 211},
    {1.3153446762854864033506693e-227, "13153446762854864", -226},
    {5.8994821375882783266059124e+98, "5899482137588278", 99},
    {2.7795225150734697710710972e-256, "277952251507347", -255},
    {3.0603274359487681835612475e+233, "3060327435948768", 234},
    {3.3166504862350780170993331e-132, "3316650486235078", -131},
    {2.3924069799771219382603561e+33, "2392406979977122", 34},
    {1.1020972371299009018114843e-97, "11020972371299009", -96},
    {7.5097991642436255290389737e-292, "75097991642436255", -291},
    {1.5327234188414515634805655e+65, "15327234188414516", 66},
    {2.1674667405017018495527736e+01, "2167466740501702", 2},
    {5.4044403613907383353114128e-201, "5404440361390738", -200},
    {7.2428227066633902608434971e+76, "724282270666339", 77},
    {2.6724692608299111005692192e-167, "2672469260829911", -166},
    {1.6306016606544014496753739e-134, "16306016606544014", -133},
    {1.7222128095061024645063657e+40, "17222128095061025", 41},
    {1.6989143175983885106442041e-177, "16989143175983885", -176},
    {8.0492977717064741129962990e+239, "8049297771706474", 240},
    {4.0597141645271581457716263e-261, "4059714164527158", -260},
    {5.7647251279328231171341366e-235, "5764725127932823", -234},
    {1.5868714064943552831766947e+32, "15868714064943553", 33},
    {3.9633737196787493535174298e-224, "39633737196787494", -223},
    {1.4357683501053181770304973e+164, "14357683501053182", 165},
    {3.5033807108602544992071392e-07, "35033807108602545", -6},
    {1.1495511128551091029376322e-35, "11495511128551091", -34},
    {3.0454390494484537500000000e+14, "3045439049448454", 15},
    {1.0062612755622893998193522e+155, "10062612755622894", 156},
    {8.1804460877706179107111766e+156, "8180446087770618", 157},
    {1.2696488966862965440232244e-142, "12696488966862965", -141},
    {3.0591993641881048265067629e+77, "3059199364188105", 78},
    {1.7195358864443797999927344e+215, "17195358864443798", 216},
    {6.9841938748551599369426172e+230, "698419387485516", 231},
    {1.9287354390074293760035853e-98, "19287354390074294", -97},
    {1.5236874612592050873093499e+84, "1523687461259205", 85},
    {1.3100217171651343437303203e+96, "13100217171651343", 97},
    {5.3646193224190008282645629e+42, "5364619322419001", 43},
    {1.7241693891434781997486726e+73, "17241693891434782", 74},
    {9.6009125747766317159947698e-50, "9600912574776632", -49},
    {7.6957171004861823736110301e+75, "7695717100486182", 76},
    {4.4776257399649648292828594e+104, "4477625739964965", 105},
    {2.2543916883752927024668830e-89, "22543916883752927", -88},
    {4.2847268719722013751641931e+153, "42847268719722014", 154},
    {3.0775823184468796277878158e-55, "30775823184468796", -54},
    {3.4704292647807413342101115e-45, "34704292647807413", -44},
    {8.5909398458593571657285095e+118, "8590939845859357", 119},
    {2.0590531175845645839379167e-21, "20590531175845646", -20},
    {2.0483119953218857033444976e-100, "20483119953218857", -99},
    {1.9800516415275313836604663e-209, "19800516415275314", -208},
    {9.5952361253494265956616258e+109, "9595236125349427", 110},
    {2.9297025447118057854822837e+03, "2929702544711806", 4},
    {1.1491268397175686033045136e-94, "11491268397175686", -93},
    {1.4035410875650532164791818e-219, "14035410875650532", -218},
    {4.1594254429679331310873974e-50, "4159425442967933", -49},
    {4.6663519078987888919825188e+275, "4666351907898789", 276},
    {8.7143869042619013147294366e-132, "8714386904261901", -131},
    {2.3144591733269629717351580e-60, "2314459173326963", -59},
    {3.8186273410621296391842312e-65, "381862734106213", -64},
    {2.4738929825191442259468571e-277, "2473892982519144", -276},
    {1.0170229253403274372993760e+66, "10170229253403274", 67},
    {5.4939215484408547396933239e-51, "5493921548440855", -50},
    {8.2494938983426160354974285e+245, "8249493898342616", 246},
    {5.1173614640169709920883179e+08, "5117361464016971", 9},
    {8.5838119333216701476750056e-260, "858381193332167", -259},
    {1.4008004274670776465891941e+144, "14008004274670776", 145},
    {8.8671155331277909722975211e-163, "8867115533127791", -162},
    {3.4302031717383820730804258e+276, "3430203171738382", 277},
    {1.8373377711637947589016725e-07, "18373377711637948", -6},
    {1.7200910700292232538067082e+235, "17200910700292233", 236},
    {4.3923472768627621398986750e-297, "4392347276862762", -296},
    {5.0716667573949699018671013e-101, "507166675739497", -100},
    {4.3340606101334854693532156e+117, "43340606101334855", 118},
    {4.7398383746479940127229165e+87, "4739838374647994", 88},
    {1.1981731938178946124568200e+100, "11981731938178946", 101},
    {1.5710534953606553506013333e+142, "15710534953606554", 143},
    {3.0460932774874220864589742e-106, "3046093277487422", -105},
    {3.5649894430590074903210774e+301, "35649894430590075", 302},
    {4.7615984551992035845318643e-243, "4761598455199204", -242},
    {8.4309530053391034404044800e+23, "8430953005339103", 24},
    {1.1300178591703579453365308e+140, "1130017859170358", 141},
    {2.3398804973393175106388261e-248, "23398804973393175", -247},
    {3.5363411738291348419808554e-152, "3536341173829135", -151},
    {1.5935404888129069804603931e+54, "1593540488812907", 55},
    {2.2310997151433674693572100e+225, "22310997151433675", 226},
    {1.6712503411954640518165060e+176, "1671250341195464", 177},
    {6.5564188573550660840624457e+33, "6556418857355066", 34},
    {9.3244034985409764090061603e-184, "9324403498540976", -183},
    {1.1084004539856646530618185e+217, "11084004539856647", 218},
    {9.4241322227618648919872642e-88, "9424132222761865", -87},
    {2.2689522922410220254658560e+24, "2268952292241022", 25},
    {2.1797910926844807680000000e+18, "21797910926844808", 19},
    {8.0648404286596814374322357e-135, "8064840428659681", -134},
    {8.1934134551047877669354580e-228, "8193413455104788", -227},
    {1.0020731281068641311120172e-153, "10020731281068641", -152},
    {8.2917829991964362438396532e-110, "8291782999196436", -109},
    {3.0853223210339610630716292e-263, "3085322321033961", -262},
    {2.4290484980832281015276668e-113, "2429048498083228", -112},
    {1.1904999741899784754621278e-48, "11904999741899785", -47},
    {5.1657706310274555576251267e-119, "5165770631027456", -118},
    {3.8983939909296895854862527e-187, "38983939909296896", -186},
    {1.3948844822782082616574573e+180, "13948844822782083", 181},
    {1.6217566092428899643756952e-177, "162175660924289", -176},
    {2.0234528872916086031212817e-165, "20234528872916086", -164},
    {9.8622733244220673432335570e-54, "9862273324422067", -53},
    {8.8908586476535853023461903e+296, "8890858647653585", 297},
    {9.4645912495440908963793964e+145, "9464591249544091", 146},
    {1.0391166658110421370600697e-156, "10391166658110421", -155},
    {3.2070553673525665772103821e+01, "32070553673525666", 2},
    {4.4652637028469632657019757e-68, "4465263702846963", -67},
    {5.8473210599252575433550787e+255, "58473210599252575", 256},
    {3.4685590035743531519264807e-77, "3468559003574353", -76},
    {5.7483053777339010780568620e+103, "5748305377733901", 104},
    {1.2250549307845362657674336e+84, "12250549307845363", 85},
    {6.8066688801684745851572354e+208, "6806668880168475", 209},
    {9.9020979664819851019918207e-184, "9902097966481985", -183},
    {7.3815942134020314198437067e-16, "7381594213402031", -15},
    {2.9007821004824048885930507e-165, "2900782100482405", -164},
    {6.1822192858192023254197261e-264, "6182219285819202", -263},
    {6.9538371987043753541161618e-25, "6953837198704375", -24},
    {8.2484663402997510614007644e+75, "8248466340299751", 76},
    {9.3418163484119154648767583e-187, "9341816348411915", -186},
    {2.5922970174452381469640303e+95, "2592297017445238", 96},
    {2.2677179876265960858912939e-217, "2267717987626596", -216},
    {2.0611843183547287842136909e+79, "20611843183547288", 80},
    {9.8518126466807183399070893e-309, "985181264668072", -308},
    {6.9862726411648715344830883e-103, "6986272641164872", -102},
    {2.2334341992197884008591160e-253, "22334341992197884", -252},
    {6.8346566016820027392000000e+19, "6834656601682003", 20},
    {7.4080090115564932550276410e+235, "7408009011556493", 236},
    {1.3742559012342905605522482e-82, "13742559012342906", -81},
    {4.0269186249576462204557429e-151, "4026918624957646", -150},
    {2.5115421290597324796771415e+242, "25115421290597325", 243},
    {3.6920518551915777368220770e-240, "3692051855191578", -239},
    {1.0399140185638277710254928e+263, "10399140185638278", 264},
    {6.3239493794997738035564425e-137, "6323949379499774", -136},
    {4.7065883425798172234265460e+199, "4706588342579817", 200},
    {1.2423970708978640305269475e+86, "1242397070897864", 87},
    {9.1201959222601288221936019e+150, "9120195922260129", 151},
    {1.2014686943151177058749985e-294, "12014686943151177", -293},
    {7.0093146697607906228688158e+304, "7009314669760791", 305},
    {1.0361514232490700334433577e-240, "103615142324907", -239},
    {1.9169773788878128367534080e+24, "19169773788878128", 25},
    {7.4202761637860331229360459e-124, "7420276163786033", -123},
    {1.1716013249424116755482518e-107, "11716013249424117", -106},
    {2.3488994891052851453423500e+06, "2348899489105285", 7},
    {1.4962568458053497840851586e-210, "14962568458053498", -209},
    {1.0068254351777429811535053e-105, "1006825435177743", -104},
    {9.2818047240858150738096229e+171, "9281804724085815", 172},
    {8.7465438492786057531052339e-199, "8746543849278606", -198},
    {1.1628625981676045848430747e-174, "11628625981676046", -173},
    {8.1806936329387233743875038e+45, "8180693632938723", 46},
    {1.3429199176969961833200282e-73, "13429199176969962", -72},
    {1.4644683192766484264267777e-213, "14644683192766484", -212},
    {3.3372953927101210298292528e-44, "3337295392710121", -43},
    {1.5173334994238822154240000e+22, "15173334994238822", 23},
    {4.9553675823774013505595546e-187, "4955367582377401", -186},
    {5.7004858481705832225316324e-299, "5700485848170583", -298},
    {2.9361120207398639361918458e+298, "2936112020739864", 299},
    {4.9984122196244912495252842e-195, "4998412219624491", -194},
    {2.2204553022232868360154621e+302, "2220455302223287", 303},
    {2.3862273094598115006172598e-69, "23862273094598115", -68},
    {3.6235804400625984101064690e+251, "36235804400625984", 252},
    {9.6292870979611936449705696e+45, "9629287097961194", 46},
    {1.2417836617428586968776404e-128, "12417836617428587", -127},
    {3.4827747979834382447445510e-301, "34827747979834382", -300},
    {3.0660519434391951140959626e-25, "3066051943439195", -24},
    {2.3769907692260739666924700e+95, "2376990769226074", 96},
    {1.1289849837176174953302051e-272, "11289849837176175", -271},
    {2.1140872929484860808293720e-223, "2114087292948486", -222},
    {5.4512537844473361512933321e+233, "5451253784447336", 234},
    {2.7223222060278879723039742e+218, "2722322206027888", 219},
    {1.8188785347848519469076192e+180, "1818878534784852", 181},
    {4.5104755166802967607472486e-188, "4510475516680297", -187},
    {1.2063705276563970142701599e+86, "1206370527656397", 87},
    {1.0858940896575533143760588e-159, "10858940896575533", -158},
    {5.0830768336391911785714218e+89, "5083076833639191", 90},
    {9.8603518457591281599287177e+239, "9860351845759128", 240},
    {4.7126205741236250837783271e-180, "4712620574123625", -179},
    {2.4148039897857036476121716e-07, "24148039897857036", -6},
    {1.7047612701957981780058309e+28, "17047612701957982", 29},
    {1.3478292238889397381864370e+230, "13478292238889397", 231},
    {5.7127166246208509993984608e-217, "5712716624620851", -216},
    {6.4777912221946480269254674e+62, "6477791222194648", 63},
    {8.1513644918430580771215448e+116, "8151364491843058", 117},
    {7.5215320599962922428937014e-78, "7521532059996292", -77},
    {7.7768600708803327360587306e+168, "7776860070880333", 169},
    {3.2909762907173253072876981e-29, "32909762907173253", -28},
    {1.3698126349540026575539454e-26, "13698126349540027", -25},
    {2.4405430900615677808318938e-225, "24405430900615678", -224},
    {5.9014340521911546408916375e-62, "5901434052191155", -61},
    {3.6662911979990043198957959e-160, "36662911979990043", -159},
    {5.4723501767131388379108714e-241, "5472350176713139", -240},
    {3.0352440773869204457703002e+208, "30352440773869204", 209},
    {1.9384264314312002095252399e-198, "19384264314312002", -197},
    {3.5721413499842744175288316e+122, "35721413499842744", 123},
    {1.5272165022659269665206030e+236, "1527216502265927", 237},
    {2.8539722744662397748002683e-260, "28539722744662398", -259},
    {3.3729297445275423484023420e-214, "33729297445275423", -213},
    {9.0574641849821812904171069e-49, "9057464184982181", -48},
    {9.9079202198108646828770544e+221, "9907920219810865", 222},
    {1.8759459671851543357599976e+174, "18759459671851543", 175},
    {3.7713757480672010534000872e-285, "3771375748067201", -284},
    {3.3409800333564629634057598e-213, "3340980033356463", -212},
    {2.3946704914004126548398287e-286, "23946704914004127", -285},
    {7.4346461612416690358547697e+166, "7434646161241669", 167},
    {2.2131553177553316132046594e+147, "22131553177553316", 148},
    {4.4635180182285998555815718e-181, "44635180182286", -180},
    {2.6128741502987212849641017e+276, "26128741502987213", 277},
    {3.8925768700170797559094807e-75, "389257687001708", -74},
    {2.4664081655418232971414471e+28, "24664081655418233", 29},
    {6.9845538938118859683414748e+191, "6984553893811886", 192},
    {2.2045214766770743979937013e-295, "22045214766770744", -294},
    {3.7216164260680378931428013e+90, "3721616426068038", 91},
    {1.2589178367167801700177962e-26, "12589178367167802", -25},
    {1.0944021247756970965196580e-235, "10944021247756971", -234},
    {1.9239264181217576143635245e+218, "19239264181217576", 219},
    {1.3890600446611183542700019e+03, "13890600446611184", 4},
    {9.2431685500365462661753583e+188, "9243168550036546", 189},
    {3.0850032859867866363856592e+00, "30850032859867866", 1},
    {5.7904752214050294068315476e-95, "57904752214050294", -94},
    {3.7179012826430279284309023e+134, "3717901282643028", 135},
    {1.2780647751913038753791908e-269, "12780647751913039", -268},
    {7.6297425569169746001806088e+63, "7629742556916975", 64},
    {1.3321694962817489901152024e+116, "1332169496281749", 117},
    {1.4319784717564754728958302e-189, "14319784717564755", -188},
    {3.9248235386456199307595242e-80, "392482353864562", -79},
    {6.2622977074469366512916982e+93, "6262297707446937", 94},
    {1.4810490817283289999531731e-78, "1481049081728329", -77},
    {8.5512227163997304679424832e-279, "855122271639973", -278},
    {1.4529394673123087108181023e+50, "14529394673123087", 51},
    {1.4024658379704112645936371e-161, "14024658379704113", -160},
    {2.0379559525295052478794609e-16, "20379559525295052", -15},
    {3.5277126867321522774370579e-04, "35277126867321523", -3},
    {8.3021975741366965432420756e-64, "8302197574136697", -63},
    {1.1368529848717640426490191e+206, "1136852984871764", 207},
    {1.1962620967095574807223769e-227, "11962620967095575", -226},
    {1.4517988222772779667807800e-105, "1451798822277278", -104},
    {1.0796506532800789333355926e+248, "10796506532800789", 249},
    {7.2004445827564170735950476e-235, "7200444582756417", -234},
    {1.7269458510894692940791363e-196, "17269458510894693", -195},
    {6.5359796124808608966842658e-274, "6535979612480861", -273},
    {2.7669034730675739375689352e-144, "2766903473067574", -143},
    {2.6505059839047268033027649e+07, "26505059839047268", 8},
    {6.4137379817364044452582148e-46, "64137379817364044", -45},
    {2.0412898381442560281875337e-212, "2041289838144256", -211},
    {1.6202565480267871128555439e+142, "1620256548026787", 143},
    {3.0429035960382258501684991e+174, "3042903596038226", 175},
    {5.2645369926194243422721981e+179, "5264536992619424", 180},
    {5.2745954030217794286519776e-216, "52745954030217794", -215},
    {2.8667170864847452966120986e-25, "28667170864847453", -24},
    {5.6106586907962195409313384e-42, "56106586907962195", -41},
    {5.3454642642583105190808582e+295, "53454642642583105", 296},
    {4.5398415794195679319265502e+211, "4539841579419568", 212},
    {1.6337309409706669867371178e-87, "1633730940970667", -86},
    {3.5861562544913929449626806e-143, "3586156254491393", -142},
    {1.0406319546645755174117426e+190, "10406319546645755", 191},
    {9.2556223053329006538953138e+125, "92556223053329", 126},
    {9.4326700335108473463409555e-283, "9432670033510847", -282},
    {1.8341248476635415494736515e+273, "18341248476635415", 274},
    {7.2449833385056624480658307e+266, "7244983338505662", 267},
    {5.4009855491105789321032263e+158, "5400985549110579", 159},
    {8.8239980463182046189385783e+223, "8823998046318205", 224},
    {4.9909957515022875370782247e+144, "49909957515022875", 145},
    {1.1206777752444246463779839e-225, "11206777752444246", -224},
    {2.1565101317318530412137436e+237, "2156510131731853", 238},
    {3.9843259426014994724968274e-287, "39843259426014995", -286},
    {5.9042095970318534586107007e-202, "59042095970318535", -201},
    {6.2144968001664027502093856e-156, "6214496800166403", -155},
    {8.1061821028240074126214288e-209, "8106182102824007", -208},
    {1.0114312457291287959563359e-215, "10114312457291288", -214},
    {2.1978656602202186656946175e-157, "21978656602202187", -156},
    {7.8486946120892375734501538e-293, "7848694612089238", -292},
    {7.7474795577481670163488438e+94, "7747479557748167", 95},
    {1.8836196920707990284946385e+180, "1883619692070799", 181},
    {9.0251308011219457591839483e-25, "9025130801121946", -24},
    {1.5198535839431170972115416e-60, "1519853583943117", -59},
    {7.9823289865186597464158826e-113, "798232898651866", -112},
    {4.5444050155756041702722196e+196, "4544405015575604", 197},
    {2.6542236477458925722781659e-62, "26542236477458926", -61},
    {1.8274480254560295604563078e+59, "18274480254560296", 60},
    {9.1196370540711033136026288e+129, "9119637054071103", 130},
    {8.8302100553622374524690031e+51, "8830210055362237", 52},
    {2.5013947384562800507451800e+224, "250139473845628", 225},
    {4.8151053885972184626036232e-225, "48151053885972185", -224},
    {1.2194629474992385390343619e+27, "12194629474992385", 28},
    {1.8481299560659307578525197e+302, "18481299560659308", 303},
    {1.1111590471201242817664159e+252, "11111590471201243", 253},
    {3.5326368265873163368897649e-297, "3532636826587316", -296},
    {7.1895614245974936919344339e+50, "7189561424597494", 51},
    {2.2026438800511367361670989e-277, "22026438800511367", -276},
    {1.3559502873985513215306114e-138, "13559502873985513", -137},
    {1.2125948401073213811652580e+185, "12125948401073214", 186},
    {6.1989099493090995762146236e-302, "61989099493091", -301},
    {2.5877045253863108045046432e-307, "2587704525386311", -306},
    {2.1477042292850886644410331e+296, "21477042292850887", 297},
    {5.7748703866702804565429688e+09, "577487038667028", 10},
    {7.0572264675543887799091099e-227, "7057226467554389", -226},
    {4.5205105854346049228032249e-218, "4520510585434605", -217},
    {6.8875191158666717071444848e-75, "6887519115866672", -74},
    {3.5582845188172022668002752e+65, "35582845188172023", 66},
    {9.5095566964587040650395514e-20, "9509556696458704", -19},
    {1.5663442386456450037621675e+215, "1566344238645645", 216},
    {7.1818428075209989153752411e-146, "7181842807520999", -145},
    {3.3616165661936624025981304e+30, "33616165661936624", 31},
    {1.8922833828117552811702801e+228, "18922833828117553", 229},
    {2.4274412545264316284075480e+44, "24274412545264316", 45},
    {7.8490762998438250841488335e+242, "7849076299843825", 243},
    {7.1919608779213066565913332e+227, "7191960877921307", 228},
    {4.0824923489852985697236388e+239, "40824923489852986", 240},
    {4.0811785308866522726683603e-241, "4081178530886652", -240},
    {6.2414970373017996214719988e+65, "62414970373018", 66},
    {2.8694506947101633517789309e+287, "28694506947101634", 288},
    {2.5243014954555567074204018e-245, "25243014954555567", -244},
    {2.2697648622202938126735647e+93, "2269764862220294", 94},
    {2.8018840293719654783648473e-107, "28018840293719655", -106},
    {1.3053705077766598986941019e+105, "130537050777666", 106},
    {1.6232238034135793408872450e-102, "16232238034135793", -101},
    {2.0292399296723084222455005e+242, "20292399296723084", 243},
    {9.7035111694763602452186398e+128, "970351116947636", 129},
    {5.5085604760117902835712000e+22, "550856047601179", 23},
    {3.8714947952170950247944365e+157, "3871494795217095", 158},
    {8.5047858599438609444536246e-141, "8504785859943861", -140},
    {2.1374384286068571866445266e+187, "2137438428606857", 188},
    {4.8409944115106354595078823e-08, "48409944115106355", -7},
    {2.3120483046910084654553269e-54, "23120483046910085", -53},
    {6.1977342227250079306240349e-166, "6197734222725008", -165},
    {4.6315522379411672878741560e-273, "4631552237941167", -272},
    {6.2047519037461004956402549e-256, "62047519037461", -255},
    {3.1385308914522302280473072e-93, "31385308914522302", -92},
    {3.8101915729837868304720220e-275, "3810191572983787", -274},
    {1.6038310523808639857554501e-09, "1603831052380864", -8},
    {2.6182271783820785730349831e+258, "26182271783820786", 259},
    {1.8533237024415361917193747e+192, "18533237024415362", 193},
    {3.5748016013708652806131082e-137, "35748016013708653", -136},
    {2.5172775495484660985225649e+29, "2517277549548466", 30},
    {3.6589185374164847006537546e+253, "3658918537416485", 254},
    {1.9641710039679538381615062e+282, "19641710039679538", 283},
    {2.1452829664290500473465130e-120, "214528296642905", -119},
    {1.2632080020441712613814866e-83, "12632080020441713", -82},
    {2.9921186603124374115751866e+179, "29921186603124374", 180},
    {2.4273651131226752296443495e-244, "24273651131226752", -243},
    {1.1029077424258828111972628e-203, "11029077424258828", -202},
    {1.0851325595651009172260178e-82, "10851325595651009", -81},
    {2.2617315489585402753150769e+35, "22617315489585403", 36},
    {5.0416814092149253399175309e+228, "50416814092149253", 229},
    {4.5492639550228684703646602e-265, "45492639550228685", -264},
    {5.6419249084489587481561882e-150, "5641924908448959", -149},
    {2.5665426571459335606785111e-242, "25665426571459336", -241},
    {1.6702170820371324096352723e-42, "16702170820371324", -41},
    {2.1650612764327708023404886e-229, "21650612764327708", -228},
    {6.3288054578917330731611920e-245, "6328805457891733", -244},
    {4.3582026204998372074968499e+213, "4358202620499837", 214},
    {4.1700010194764686419414267e+68, "41700010194764686", 69},
    {4.2217064174012197426082144e-290, "422170641740122", -289},
    {1.9319180543313412551941035e+97, "19319180543313413", 98},
    {9.2233335808713221549987793e+08, "9223333580871322", 9},
    {7.0854728739945158815734977e-29, "7085472873994516", -28},
    {1.2803850057446809299894442e-125, "1280385005744681", -124},
    {7.6612472273082595548913378e+234, "766124722730826", 235},
    {7.6919069413272063311910623e+276, "7691906941327206", 277},
    {1.3264873140597409380688921e-294, "1326487314059741", -293},
    {1.3863993505767273977246844e+49, "13863993505767274", 50},
    {5.7936920529920849196751107e+41, "5793692052992085", 42},
    {3.0179465717130396834000760e+251, "30179465717130397", 252},
    {4.3591075184623702811634732e+256, "435910751846237", 257},
    {6.2458352925832908141479640e-116, "6245835292583291", -115},
    {2.2594007525119971706970338e-161, "2259400752511997", -160},
    {7.3573111421138399197159907e+121, "735731114211384", 122},
    {2.6527304689541603957357183e+78, "26527304689541604", 79},
    {6.7628248771752859284038364e+261, "6762824877175286", 262},
    {8.4634545479378953030694442e-257, "8463454547937895", -256},
    {7.5080640774345830025110261e-26, "7508064077434583", -25},
    {4.1612748636696744302579437e+234, "41612748636696744", 235},
    {5.7921812786802858539319861e+113, "5792181278680286", 114},
    {3.5644929657268732376584446e+74, "3564492965726873", 75},
    {2.2466618404191155216736693e-114, "22466618404191155", -113},
    {2.7620110187705102689778303e-301, "27620110187705103", -300},
    {3.3834218510902814323198399e+66, "33834218510902814", 67},
    {2.4364303564790076247875222e-238, "24364303564790076", -237},
    {1.9479391540746949228974154e+83, "1947939154074695", 84},
    {5.7888213226025400210265233e+48, "578882132260254", 49},
    {2.9725367319353356233849916e-208, "29725367319353356", -207},
    {2.1951468469112307099646688e+204, "21951468469112307", 205},
    {3.9874511136174132041756608e+88, "3987451113617413", 89},
    {3.7730410881928475293450171e+292, "37730410881928475", 293},
    {6.8614260088512609472639939e+148, "6861426008851261", 149},
    {8.0702311944086612829933616e+64, "8070231194408661", 65},
    {3.8250460991335078596802057e-302, "3825046099133508", -301},
    {2.9851670239897042072094123e+196, "2985167023989704", 197},
    {3.5974404702243533545468226e+55, "35974404702243534", 56},
    {6.2326552262764891640583805e+43, "6232655226276489", 44},
    {2.7113721611983041881804041e-285, "27113721611983042", -284},
    {1.0646633883761521675396655e-305, "10646633883761522", -304},
    {4.9880614006163795849335633e+153, "49880614006163796", 154},
    {9.4657493099200996136440044e+107, "94657493099201", 108},
    {1.0143463603185705000000000e+15, "10143463603185705", 16},
    {1.4506600967908444607872761e-307, "14506600967908445", -306},
    {7.4881827532884402611417958e+44, "748818275328844", 45},
    {7.6174426475780070720708046e-146, "7617442647578007", -145},
    {2.9687413121292225823381708e-29, "29687413121292226", -28},
    {7.3568320583921727426061659e+151, "7356832058392173", 152},
    {1.1046591322898526670658932e-97, "11046591322898527", -96},
    {7.3841833356062029350316963e-294, "7384183335606203", -293},
    {1.7236890683887879651175351e-243, "1723689068388788", -242},
    {1.4893119935194726556654314e+163, "14893119935194727", 164},
    {7.7599412029353256021957361e+152, "7759941202935326", 153},
    {1.1704570452705060527636441e+104, "1170457045270506", 105},
    {2.0742675157778751859950705e+145, "20742675157778752", 146},
    {1.3659498986747738865512105e-16, "1365949898674774", -15},
    {7.5203649967434751030320285e+115, "7520364996743475", 116},
    {9.5626687391958967054961249e+03, "9562668739195897", 4},
    {3.4050056805649812965206000e+118, "34050056805649813", 119},
    {5.7524302328546310408171649e-32, "5752430232854631", -31},
    {2.2845124062579832122738007e-284, "22845124062579832", -283},
    {8.9145663993353048549482019e-234, "8914566399335305", -233},
    {9.1526718098931777262495074e+130, "9152671809893178", 131},
    {7.1451552261972891091606228e-43, "7145155226197289", -42},
    {6.7271601966978145565844164e+216, "6727160196697815", 217},
    {1.1057292529017060179956231e+222, "1105729252901706", 223},
    {3.5879834779875652769839289e-37, "35879834779875653", -36},
    {1.5123237918686554273095213e-30, "15123237918686554", -29},
    {2.3684044667457400620927642e+179, "236840446674574", 180},
    {4.1263226202665328002064955e+245, "4126322620266533", 246},
    {1.5153070011165584773655061e+241, "15153070011165585", 242},
    {2.8494723680631350294034355e+63, "2849472368063135", 64},
    {1.4389893634321015363040874e-247, "14389893634321015", -246},
    {1.1662142952713340035344277e+298, "1166214295271334", 299},
    {5.9559021013721672484144932e+98, "5955902101372167", 99},
    {1.2410861666343819649567251e+262, "1241086166634382", 263},
    {1.4051292691043854984089307e+157, "14051292691043855", 158},
    {1.5566559548809562532026373e+50, "15566559548809563", 51},
    {4.5659587255144807646425631e+103, "4565958725514481", 104},
    {9.7673684247089521087991852e+160, "9767368424708952", 161},
    {5.5160719348315877743171907e+85, "5516071934831588", 86},
    {2.6920506972721977753600000e+20, "26920506972721978", 21},
    {5.7818886462485932938698208e-100, "5781888646248593", -99},
    {1.0593745213090047917332441e-38, "10593745213090048", -37},
    {2.7383021313040434214378877e+229, "27383021313040434", 230},
    {1.1513567366387845060245521e+50, "11513567366387845", 51},
    {2.3827177725903999020658954e+272, "23827177725904", 273},
    {3.0517098943788267002289915e+298, "30517098943788267", 299},
    {1.2498849696028508334849937e-207, "12498849696028508", -206},
    {1.2729074897018439003957468e-125, "1272907489701844", -124},
    {2.8983034889397708310819433e+270, "2898303488939771", 271},
    {1.7458887512089757409084491e+201, "17458887512089757", 202},
    {1.7340060941143500926345311e-59, "173400609411435", -58},
    {5.5049561208728208769984559e-78, "5504956120872821", -77},
    {1.9482818152656271154486742e+156, "1948281815265627", 157},
    {4.5825880436238330602645874e+08, "4582588043623833", 9},
    {7.8939512456342960690060962e-195, "7893951245634296", -194},
    {5.2034676273287804828081861e+297, "52034676273287805", 298},
    {1.8341962128199783744198808e-121, "18341962128199784", -120},
    {2.3874735641935325424932238e+268, "23874735641935325", 269},
    {1.3154409596987624847104637e-255, "13154409596987625", -254},
    {3.8052318884902938733586343e+121, "3805231888490294", 122},
    {6.5099037752948140093787990e-248, "6509903775294814", -247},
    {4.3771786944672996881385781e-158, "43771786944673", -157},
    {6.1269697407356882160902549e+91, "6126969740735688", 92},
    {3.5204521609672228415529235e-176, "3520452160967223", -175},
    {6.7717989134343978784025264e-04, "6771798913434398", -3},
    {2.8906998758891171632205987e-209, "2890699875889117", -208},
    {3.2060308877882255199501734e-12, "32060308877882255", -11},
    {1.7831613990173012683039454e-09, "17831613990173013", -8},
    {2.2510968557251318848847856e-244, "2251096855725132", -243},
    {7.2522470366241506276192538e-137, "7252247036624151", -136},
    {2.1783081952827888037970542e-296, "21783081952827888", -295},
    {3.3957622726069343760500564e+179, "33957622726069344", 180},
    {2.1132979863429915924295700e+254, "21132979863429916", 255},
    {3.6330173722031775391363756e-119, "36330173722031775", -118},
    {1.4406709838259222506730579e+124, "14406709838259223", 125},
    {7.4363494048863964115306735e-224, "7436349404886396", -223},
    {8.4977511222446203094007832e+194, "849775112224462", 195},
    {3.2781956440225011662306746e+279, "3278195644022501", 280},
    {1.1865870275425014653709447e-258, "11865870275425015", -257},
    {5.8983925963334795185639327e-297, "58983925963334795", -296},
    {2.2046195547328074084548043e+114, "22046195547328074", 115},
    {4.9080904133050830992930765e-155, "4908090413305083", -154},
    {9.1836714178242860396838415e-274, "9183671417824286", -273},
    {5.7664645403120399600192395e-150, "576646454031204", -149},
    {2.2304077918087111455721952e+233, "2230407791808711", 234},
    {4.2130717515913108354203642e-142, "4213071751591311", -141},
    {3.6030281837251069297588022e+62, "3603028183725107", 63},
    {6.2325903731085142089066197e-239, "6232590373108514", -238},
    {1.5911736154379044697565561e-204, "15911736154379045", -203},
    {6.1697273704973091488175326e-271, "6169727370497309", -270},
    {2.3081359979081211808798287e+200, "23081359979081212", 201},
    {1.7624830588208954818874342e-71, "17624830588208955", -70},
    {4.8818989591848022838918458e+219, "4881898959184802", 220},
    {3.2919962331777375053304300e+27, "32919962331777375", 28},
    {3.5345200792128781838199639e+79, "3534520079212878", 80},
    {2.0077053283601888624659911e-184, "20077053283601889", -183},
    {5.9704187018625345290973403e+256, "59704187018625345", 257},
    {1.8542355328863440683213664e-06, "1854235532886344", -5},
    {2.9293522209450030089011422e+166, "2929352220945003", 167},
    {1.3112645532423150587200862e-06, "1311264553242315", -5},
    {7.5261681166754112595165630e+99, "7526168116675411", 100},
    {7.3973468445944596475621902e-05, "739734684459446", -4},
    {5.7962384758675167838507845e+81, "5796238475867517", 82},
    {1.0898726809165482576662048e-228, "10898726809165483", -227},
    {1.1569723568589267172717479e+269, "11569723568589267", 270},
    {1.1774119278277840464040144e-211, "1177411927827784", -210},
    {2.0859932955843491658443667e+108, "20859932955843492", 109},
    {1.3214162507202089970012257e-148, "1321416250720209", -147},
    {6.6735281770810638335632019e-189, "6673528177081064", -188},
    {8.7618519619543476262697309e-168, "8761851961954348", -167},
    {7.6828454205838196336340475e+227, "768284542058382", 228},
    {1.3812430212077576132952214e-09, "13812430212077576", -8},
    {1.0816241112682669907359526e+217, "1081624111268267", 218},
    {6.4814023027024144804574843e-228, "6481402302702414", -227},
    {3.6297789738367989633734760e-22, "3629778973836799", -21},
    {5.4553491603889832950903541e-214, "5455349160388983", -213},
    {2.4668105609495715575972758e+28, "24668105609495716", 29},
    {9.9785381162406797173482200e+216, "997853811624068", 217},
    {1.2873066289582397197601248e-68, "12873066289582397", -67},
    {3.2568671826203706702677350e+50, "32568671826203707", 51},
    {5.6953404526113646327109355e-147, "5695340452611365", -146},
    {1.4450043366330009709912809e-282, "1445004336633001", -281},
    {1.6195838084477835288943948e-181, "16195838084477835", -180},
    {8.5158543046042680155865354e+111, "8515854304604268", 112},
    {9.7886898152437167379049051e-255, "9788689815243717", -254},
    {8.8065692485312366485595703e+08, "8806569248531237", 9},
    {2.6200738992488912747779134e+90, "26200738992488913", 91},
    {8.9692753183009918350149649e-227, "8969275318300992", -226},
    {1.0036369143280469801781699e-79, "1003636914328047", -78},
    {1.4795934492408123009291650e-282, "14795934492408123", -281},
    {2.8303285912965649777811317e+194, "2830328591296565", 195},
    {2.7908704265715942120276623e-70, "27908704265715942", -69},
    {6.2861629400771899778227202e-304, "628616294007719", -303},
    {2.4547499373949956034702244e-82, "24547499373949956", -81},
    {2.0812330450291661914120723e+119, "20812330450291662", 120},
    {7.3652714426858811086428919e-154, "7365271442685881", -153},
    {1.5142943160719242486745915e+209, "15142943160719242", 210},
    {6.8080501632576511528768114e+258, "6808050163257651", 259},
    {1.2640682115600374176691930e-22, "12640682115600374", -21},
    {5.8719319673210431439939732e-227, "5871931967321043", -226},
    {1.0581395258659983787096151e+187, "10581395258659984", 188},
    {9.0488904813141821013861042e+294, "9048890481314182", 295},
    {2.4558460379650371409404093e+281, "2455846037965037", 282},
    {2.2230615393344148508920667e-27, "2223061539334415", -26},
    {7.8882364185620835009278228e-225, "7888236418562084", -224},
    {6.0456656066492077720656190e+148, "6045665606649208", 149},
    {6.3233174548451653288302306e-282, "6323317454845165", -281},
    {1.8481183627850426747423001e+220, "18481183627850427", 221},
    {2.5721308390890993968830243e-272, "25721308390890994", -271},
    {6.5944746014268654614376869e-136, "65944746014268655", -135},
    {2.4372890081289071069218789e-25, "2437289008128907", -24},
    {7.9125249801883083734815087e-98, "7912524980188308", -97},
    {6.1787960412732088609753145e+144, "6178796041273209", 145},
    {1.1515443597460462094648218e+308, "11515443597460462", 309},
    {3.0512184498743381250000000e+14, "3051218449874338", 15},
    {2.7083096962102702620850181e-53, "27083096962102703", -52},
    {8.6812676552320296154048918e+205, "868126765523203", 206},
    {2.8759816470651752712960480e+203, "28759816470651753", 204},
    {1.7984298743440613425117700e+162, "17984298743440613", 163},
    {2.3957088903130591234849410e+155, "2395708890313059", 156},
    {3.1690422088466947622659444e-199, "31690422088466948", -198},
    {2.0354939197489048244546291e-173, "2035493919748905", -172},
    {3.6033432430287820640649536e-260, "3603343243028782", -259},
    {3.4160678188413342975726775e+143, "34160678188413343", 144},
    {1.2765928317311036274159675e-131, "12765928317311036", -130},
    {5.0644818093381502467638542e+222, "506448180933815", 223},
    {1.4749460335752567376168923e-91, "14749460335752567", -90},
    {2.9210576940704700548465754e+103, "292105769407047", 104},
    {8.7310576889721324109693622e+114, "8731057688972132", 115},
    {5.0185671664210131700107143e-213, "5018567166421013", -212},
    {8.1437628751030381122645982e+250, "8143762875103038", 251},
    {6.5553836719875836132516114e-225, "6555383671987584", -224},
    {3.3516830279209845309005283e+172, "33516830279209845", 173},
    {1.4202991339282933081096509e-264, "14202991339282933", -263},
    {1.3049953039647688798147773e-34, "13049953039647689", -33},
    {3.8922188522345930479886892e+150, "3892218852234593", 151},
    {1.4923327390828065047347670e-101, "14923327390828065", -100},
    {1.3531887861066262273112429e+289, "13531887861066262", 290},
    {6.0593476608960014343261719e+10, "60593476608960014", 11},
    {1.1662690909169800849004691e-53, "116626909091698", -52},
    {6.6489746627493665479559489e-278, "6648974662749367", -277},
    {8.6591545449519451878897437e+159, "8659154544951945", 160},
    {1.1439938958359159762863913e+155, "1143993895835916", 156},
    {3.5958889234424492777004464e+221, "35958889234424493", 222},
    {1.2893938578675734377489865e+172, "12893938578675734", 173},
    {3.4341565755993650496495639e-05, "3434156575599365", -4},
    {9.7951989950098388661737616e-246, "9795198995009839", -245},
    {1.2864590405487435207500657e-157, "12864590405487435", -156},
    {2.1524478186764955259038485e-18, "21524478186764955", -17},
    {3.4913805801994381468030727e-112, "3491380580199438", -111},
    {5.3287321741084807708988519e+236, "5328732174108481", 237},
    {5.9755009868740155039040814e+97, "59755009868740155", 98},
    {1.4751474828439298873661864e+69, "14751474828439299", 70},
    {5.0561434015955302196153083e+222, "505614340159553", 223},
    {2.3873930660115278824797652e-297, "2387393066011528", -296},
    {3.4311461821792596070977247e-79, "34311461821792596", -78},
    {4.3007667609037778816657676e-208, "4300766760903778", -207},
    {5.7693680012981152923441649e-130, "5769368001298115", -129},
    {7.6106362566827852779275054e+111, "7610636256682785", 112},
    {7.7508710152857271652189329e-154, "7750871015285727", -153},
    {8.8564192313786259533493633e-85, "8856419231378626", -84},
    {5.6345023794391119480133057e+08, "5634502379439112", 9},
    {4.7019696577472711382712875e-149, "4701969657747271", -148},
    {9.7847076788722643371468505e-81, "9784707678872264", -80},
    {2.8404967710069281467616582e+133, "2840496771006928", 134},
    {1.0451588997743149814178092e+206, "1045158899774315", 207},
    {1.0610873566406059085616721e+58, "10610873566406059", 59},
    {1.9021109625951580327557275e+189, "1902110962595158", 190},
    {1.1299570257694531370966850e-210, "11299570257694531", -209},
    {9.4354036300994035989936119e+174, "9435403630099404", 175},
    {2.2437528038386716653672269e+67, "22437528038386717", 68},
    {2.1904624808826637275462899e-268, "21904624808826637", -267},
    {1.1768813225451691963652323e-181, "11768813225451692", -180},
    {1.6617283449879986621203363e+239, "16617283449879987", 240},
    {8.2464827989481892501544410e+63, "8246482798948189", 64},
    {8.7363095768331437075698762e+236, "8736309576833144", 237},
    {1.6564024042303734673051348e-133, "16564024042303735", -132},
    {2.6826258628959693553316530e-33, "26826258628959694", -32},
    {1.5517305072929557141111347e-140, "15517305072929557", -139},
    {9.6149390089226700991584889e+290, "961493900892267", 291},
    {2.4065572580854262071472758e-123, "24065572580854262", -122},
    {2.9671217716408984744225040e+29, "29671217716408985", 30},
    {1.7145915684904713154687147e-32, "17145915684904713", -31},
    {1.1991798801944682195241531e+33, "11991798801944682", 34},
    {1.1555609520346506022248563e+191, "11555609520346506", 192},
    {2.4509864156280916654931172e-83, "24509864156280917", -82},
    {6.4152840796632609793185279e+96, "6415284079663261", 97},
    {7.4800132251943048847714930e+268, "7480013225194305", 269},
    {1.1716075868549624409900688e+141, "11716075868549624", 142},
    {6.1574978369995654844024196e-71, "61574978369995655", -70},
    {3.4080741496343741694056425e-303, "3408074149634374", -302},
    {4.6295591706378805534307632e-112, "4629559170637881", -111},
    {1.6485181389555465501736205e+87, "16485181389555466", 88},
    {1.5102552619276265347426019e+214, "15102552619276265", 215},
    {1.8144806705733618349785987e-98, "18144806705733618", -97},
    {5.8250881710745468510257730e+125, "5825088171074547", 126},
    {3.0490447811600001253275512e-280, "304904478116", -279},
    {2.1347990335293514579642811e-07, "21347990335293515", -6},
    {7.1884179854296434090444094e-23, "7188417985429643", -22},
    {1.3453249120606454805181368e+306, "13453249120606455", 307},
    {2.8657261786882522347983804e+225, "28657261786882522", 226},
    {3.3923709876612926160796252e-145, "33923709876612926", -144},
    {3.4188686737983491276800000e+20, "3418868673798349", 21},
    {1.2554565399953424746870600e+282, "12554565399953425", 283},
    {6.8667012082464722016049267e-131, "6866701208246472", -130},
    {2.5586586027230182043003202e-200, "25586586027230182", -199},
    {7.9725638078626848791638372e-302, "7972563807862685", -301},
    {5.5389911793128700859758304e-65, "553899117931287", -64},
    {6.2107580834877154399955339e-82, "6210758083487715", -81},
    {4.2049694220205326371977045e+193, "4204969422020533", 194},
    {1.7883441648683010772700191e-15, "1788344164868301", -14},
    {7.8643380034290367906061922e+307, "7864338003429037", 308},
    {2.8519660154021578752679670e+31, "2851966015402158", 32},
    {1.6336614940315371943750406e+218, "16336614940315372", 219},
    {3.0699402977016928933782435e-263, "3069940297701693", -262},
    {3.3572533322516692890178325e+81, "33572533322516693", 82},
    {1.5721678824470967158269688e+170, "15721678824470967", 171},
    {4.0092247539226055016391788e+157, "40092247539226055", 158},
    {8.4618617711088219644794439e-166, "8461861771108822", -165},
    {4.4433289895646561021697046e-101, "4443328989564656", -100},
    {3.3964403723913056817872639e+204, "33964403723913057", 205},
    {3.0042865187757037658053414e+129, "3004286518775704", 130},
    {2.4755153697197768620095306e-34, "2475515369719777", -33},
    {1.1022061783329228704629650e+237, "11022061783329229", 238},
    {5.7715038061820958285730621e-152, "5771503806182096", -151},
    {8.7431952344744694473059151e+259, "874319523447447", 260},
    {1.0190638461725438186846985e-52, "10190638461725438", -51},
    {4.4856419059752909353975431e+224, "4485641905975291", 225},
    {4.0085682021454485750283030e+46, "40085682021454486", 47},
    {3.3054425425633072122331786e-249, "3305442542563307", -248},
    {7.9895268206053174871244300e+157, "7989526820605317", 158},
    {9.2256771403495105914771557e+05, "9225677140349511", 6},
    {2.7207055641240875030904954e-72, "27207055641240875", -71},
    {1.1625984713108453365017709e-97, "11625984713108453", -96},
    {3.3065239092267572635827521e-66, "33065239092267573", -65},
    {1.8620829136468977638152467e-01, "18620829136468978", 0},
    {7.9646099343644832690907751e+183, "7964609934364483", 184},
    {4.0861077213416062680573782e+239, "40861077213416063", 240},
    {6.0522310231075702989222052e+27, "605223102310757", 28},
    {3.2571580357288526414093303e+257, "32571580357288526", 258},
    {1.6079799637764172201093954e-68, "16079799637764172", -67},
    {2.4387109595849104356667356e+92, "24387109595849104", 93},
    {3.9308317782292655674622549e-256, "39308317782292656", -255},
    {6.7174472407263457745270326e-234, "6717447240726346", -233},
    {2.0359067687486788279589171e-204, "2035906768748679", -203},
    {1.4434528617279073260739027e+48, "14434528617279073", 49},
    {1.0294237426907947832532662e+134, "10294237426907948", 135},
    {3.0833182597353414452342072e+276, "30833182597353414", 277},
    {3.5501362425279584565126942e+71, "35501362425279585", 72},
    {6.3391982328901003522596454e-105, "63391982328901", -104},
    {1.3292947733795644940822871e+291, "13292947733795645", 292},
    {9.7413116214136552770847271e+147, "9741311621413655", 148},
    {2.4430697604093692913036172e-278, "24430697604093693", -277},
    {4.3075830480397953483434300e-35, "43075830480397953", -34},
    {3.8491886760698295593261719e+10, "38491886760698296", 11},
    {2.4930944130352321734410940e+283, "2493094413035232", 284},
    {3.1792694646124446891845559e+92, "31792694646124447", 93},
    {5.8736749326314297435057491e-267, "587367493263143", -266},
    {2.4128013200689306346624814e+260, "24128013200689306", 261},
    {5.8295293702035948531345465e-248, "5829529370203595", -247},
    {1.3446432278107441504319525e-127, "13446432278107442", -126},
    {3.9102654103010467663057318e+297, "3910265410301047", 298},
    {7.2764179654176593498983084e+287, "727641796541766", 288},
    {2.7054728638244291237087433e+138, "2705472863824429", 139},
    {8.7211491241967669338919222e+03, "8721149124196767", 4},
    {4.4128704189163727001001135e-42, "4412870418916373", -41},
    {3.6836947304019286984136943e-155, "36836947304019287", -154},
    {2.7465370944320366441927523e+155, "27465370944320366", 156},
    {3.3260508644364765112735851e-68, "33260508644364765", -67},
    {1.9358039907233141704680825e+272, "19358039907233142", 273},
    {1.9304488331878095376905979e-271, "19304488331878095", -270},
    {1.5421492693941719178673787e+232, "1542149269394172", 233},
    {3.8019077961466126186329345e-84, "38019077961466126", -83},
    {1.3421497379673295660295631e+143, "13421497379673296", 144},
    {8.2834487275364743308587118e+136, "8283448727536474", 137},
    {1.7310963199661965083781693e+36, "17310963199661965", 37},
    {4.4608538122287278739928153e+157, "4460853812228728", 158},
    {2.2927130749193699996822762e+175, "229271307491937", 176},
    {5.6082666756152576423366282e+43, "5608266675615258", 44},
    {5.5841116610042315600127119e-110, "5584111661004232", -109},
    {1.3932282023366883755727114e-225, "13932282023366884", -224},
    {7.5568361912933698294684886e-103, "755683619129337", -102},
    {3.9759251574142277601454729e-154, "3975925157414228", -153},
    {2.1103723749500287835340085e+289, "21103723749500288", 290},
    {7.4842029113570709015850418e+100, "7484202911357071", 101},
    {5.6321857728784267135023563e+184, "5632185772878427", 185},
    {1.8423752714762877002249747e-232, "18423752714762877", -231},
    {5.8296501595886351062580037e-272, "5829650159588635", -271},
    {2.7361643349026060802929428e+53, "2736164334902606", 54},
    {5.7690584556915239127438392e+129, "5769058455691524", 130},
    {3.8814094745009845510506287e+265, "38814094745009846", 266},
    {3.2903051945445216356672486e-84, "32903051945445216", -83},
    {1.4440399195203904426503651e-302, "14440399195203904", -301},
    {1.4025611709884762982454625e-241, "14025611709884763", -240},
    {1.4363150090030437362607063e+27, "14363150090030437", 28},
    {5.0010948910952017468886751e-29, "5001094891095202", -28},
    {8.3896310651219972587668550e+148, "8389631065121997", 149},
    {1.6311939332436521316749525e+252, "16311939332436521", 253},
    {4.0800646830751896810330257e+140, "408006468307519", 141},
    {7.4738071489790665525407487e-80, "7473807148979067", -79},
    {7.8947336621139685503271640e-157, "7894733662113969", -156},
    {4.9146910153110549767044637e+121, "4914691015311055", 122},
    {3.6418177031858882749714968e-28, "36418177031858883", -27},
    {1.1984571841201969632332806e-100, "1198457184120197", -99},
    {4.5289424866317969629779883e-215, "4528942486631797", -214},
    {7.1418746630562176365464070e-125, "7141874663056218", -124},
    {1.0657966981222055042392202e-287, "10657966981222055", -286},
    {8.8729354196280401632589705e-161, "887293541962804", -160},
    {5.2517646810834395949549920e-119, "525176468108344", -118},
    {1.4306025667542218908033780e-16, "1430602566754222", -15},
    {5.0493543390096133731933216e+257, "5049354339009613", 258},
    {2.5892853036946165685441615e+234, "25892853036946166", 235},
    {1.8868816293162664956794018e-200, "18868816293162665", -199},
    {3.8237143413533184883246944e-34, "38237143413533185", -33},
    {4.9172850189343001579630225e-90, "49172850189343", -89},
    {2.9544346159286700764712403e+34, "295443461592867", 35},
    {5.1155470666300320882227422e-14, "5115547066630032", -13},
    {3.7289915742870732415625124e-83, "3728991574287073", -82},
    {4.4478063036595243392367410e-208, "4447806303659524", -207},
    {2.0128646704147793104308920e+176, "20128646704147793", 177},
    {5.7734023451866207699101195e-95, "5773402345186621", -94},
    {8.1661143894562096211302924e-56, "816611438945621", -55},
    {1.1508617805736823356710374e+04, "11508617805736823", 5},
    {1.2357195828637705180452662e+56, "12357195828637705", 57},
    {1.5986026278984174254328211e-183, "15986026278984174", -182},
    {1.6770488821497840552608876e-234, "1677048882149784", -233},
    {1.7845391065746802568472406e-183, "17845391065746803", -182},
    {1.3571252865952232339079181e-244, "13571252865952232", -243},
    {5.2577340936499560459110657e+48, "5257734093649956", 49},
    {2.1907624802165253580977492e-243, "21907624802165254", -242},
    {7.3520609773158741184076074e+217, "7352060977315874", 218},
    {8.3019569394217555658164721e-177, "8301956939421756", -176},
    {8.0403337433765374043568674e-10, "8040333743376537", -9},
    {4.5016132874599663467415830e+192, "45016132874599663", 193},
    {5.8581425350052413525800030e-220, "5858142535005241", -219},
    {1.7325614692536667077536244e-218, "17325614692536667", -217},
    {1.3305682286743861549282099e+26, "13305682286743862", 27},
    {2.7883379805698809662931042e+271, "2788337980569881", 272},
    {4.1029503741207882897523498e-231, "41029503741207883", -230},
    {1.6201129402769943119358712e-185, "16201129402769943", -184},
    {1.7785178139069355912573190e-52, "17785178139069356", -51},
    {2.6221154297130458605177352e-251, "2622115429713046", -250},
    {1.9518087393907475585937500e+12, "19518087393907476", 13},
    {1.0447654401593701617990684e-209, "10447654401593702", -208},
    {1.6083581738298672982347573e+118, "16083581738298673", 119},
    {5.4974539873281003743947402e+237, "54974539873281004", 238},
    {6.7980942424457735913460751e-299, "6798094242445774", -298},
    {3.1543346561780152322057768e-30, "31543346561780152", -29},
    {1.9756987090762206886495934e+189, "19756987090762207", 190},
    {3.2553822502993095062874823e+233, "32553822502993095", 234},
    {2.9253594614664713381593005e+122, "29253594614664713", 123},
    {9.7022932816741484104169631e+269, "9702293281674148", 270},
    {4.7273863393811867679695930e+111, "4727386339381187", 112},
    {5.2094996327515447296000000e+19, "5209499632751545", 20},
    {3.4445967926762916999901242e-246, "34445967926762917", -245},
    {5.3523060755076242547534119e-216, "5352306075507624", -215},
    {3.5663619176424634543099205e+160, "35663619176424635", 161},
    {8.7590793793233745710667792e-143, "8759079379323375", -142},
    {1.1103114281616632500160015e-49, "11103114281616633", -48},
    {3.3985687910152076655165431e+144, "3398568791015208", 145},
    {9.3079842924113616041801205e-308, "9307984292411362", -307},
    {4.1049673477384204806074903e-284, "41049673477384205", -283},
    {1.2502919516596685325563910e+138, "12502919516596685", 139},
    {8.5281572290037410976768309e-10, "8528157229003741", -9},
    {3.5578569082424621041767626e+172, "3557856908242462", 173},
    {1.8358690980889132702030601e-296, "18358690980889133", -295},
    {6.2141521649567595183599414e+244, "621415216495676", 245},
    {1.6740238951155621489891485e+169, "1674023895115562", 170},
    {2.4754622755585730381907424e-268, "2475462275558573", -267},
    {8.6798898120519609475003276e+304, "8679889812051961", 305},
    {2.3433441272806073044981322e+40, "23433441272806073", 41},
    {5.0884858328075762112550987e-249, "5088485832807576", -248},
    {1.0536191916197955399643262e-239, "10536191916197955", -238},
    {2.8130722472275043494117688e-254, "28130722472275043", -253},
    {6.1469657759267504733759742e+105, "614696577592675", 106},
    {3.7197013576722295437668125e+261, "37197013576722295", 262},
    {8.9702981859127776868040086e-271, "8970298185912778", -270},
    {8.5144198964037088706560000e+21, "8514419896403709", 22},
    {1.7138153182226943576940643e+215, "17138153182226944", 216},
    {2.8380762475831961676819409e-205, "2838076247583196", -204},
    {5.1362433072991033555046757e+254, "5136243307299103", 255},
    {1.1736707884127954771383615e-206, "11736707884127955", -205},
    {3.0693018908518388869350679e+249, "3069301890851839", 250},
    {2.6858894777650456742536136e-161, "26858894777650457", -160},
    {3.2551277987465255262132589e+272, "32551277987465255", 273},
    {4.5021028953334791526154240e+26, "4502102895333479", 27},
    {4.5590152075014778869702835e+207, "4559015207501478", 208},
    {1.7921995892222759409521118e+69, "1792199589222276", 70},
    {4.2786977872674451851959333e-143, "4278697787267445", -142},
    {5.5424338058014292900379789e+292, "5542433805801429", 293},
    {1.9904026435937854697139270e+161, "19904026435937855", 162},
    {2.3701680457237136875371836e+29, "23701680457237137", 30},
    {1.6958190795806326665811484e+221, "16958190795806327", 222},
    {4.4286280173773748500384121e-95, "4428628017377375", -94},
    {3.2514454439628312821075314e-187, "32514454439628313", -186},
    {1.9499478323316652389468377e-221, "19499478323316652", -220},
    {3.8130881680663201976144399e-17, "381308816806632", -16},
    {4.4208396144941617348096318e+246, "4420839614494162", 247},
    {3.6858107124566171988368977e+112, "3685810712456617", 113},
    {3.2737236611125093140275589e+239, "32737236611125093", 240},
    {1.4067453200327718452027591e-117, "14067453200327718", -116},
    {6.8466682431658765937685391e-287, "6846668243165877", -286},
    {4.1018805643229780196529477e+98, "4101880564322978", 99},
    {2.3195851583784337852702195e-141, "23195851583784338", -140},
    {8.9717161404945127673429199e-122, "8971716140494513", -121},
    {1.1125440036757694914906948e+258, "11125440036757695", 259},
    {1.2586766629384422904023741e-86, "12586766629384423", -85},
    {5.2120868214843249894139422e+146, "5212086821484325", 147},
    {2.5555885369738536231670220e-198, "25555885369738536", -197},
    {1.8072822164602622548844506e-159, "18072822164602623", -158},
    {1.8833583905292402367825695e-190, "18833583905292402", -189},
    {1.3116573568790528956670755e+129, "13116573568790529", 130},
    {4.4725849490707562350924166e+227, "4472584949070756", 228},
    {3.2651974673508026402253528e+72, "32651974673508026", 73},
    {3.7606466745366700027395582e-172, "376064667453667", -171},
    {4.8698457973240655424193080e+147, "48698457973240655", 148},
    {4.9416525669953998700210382e+81, "49416525669954", 82},
    {3.0894011198968215306433562e+193, "30894011198968215", 194},
    {1.1668456855392872557107577e+194, "11668456855392873", 195},
    {1.1349487054162573730821271e+300, "11349487054162574", 301},
    {1.5364902911040752375522245e-284, "15364902911040752", -283},
    {2.3030484850957401357648835e+216, "230304848509574", 217},
    {3.3040359412030191682742677e+214, "3304035941203019", 215},
    {1.9284218505150011014618796e-156, "1928421850515001", -155},
    {1.9821725275613928905021890e-116, "1982172527561393", -115},
    {6.3594069263690342365173761e-166, "6359406926369034", -165},
    {1.1685291961494432466185596e-164, "11685291961494432", -163},
    {1.2175528302960998981512409e-150, "12175528302960999", -149},
    {5.2988865745312784731028182e+212, "52988865745312785", 213},
    {7.5449865725199678993993698e-22, "7544986572519968", -21},
    {7.7214825862344212480000000e+18, "7721482586234421", 19},
    {4.1106903630268646274028243e+235, "41106903630268646", 236},
    {4.0173250231913769594721996e-233, "4017325023191377", -232},
    {5.3419703016698239209816719e+28, "5341970301669824", 29},
    {1.0611569234598791808821261e+03, "10611569234598792", 4},
    {2.7375548198695595808860332e+178, "27375548198695596", 179},
    {6.0975444814917629603451059e-56, "6097544481491763", -55},
    {5.2018631784798039785717168e-53, "5201863178479804", -52},
    {1.4323765570859530000000000e+15, "1432376557085953", 16},
    {2.0287534118442265731562914e+263, "20287534118442266", 264},
    {6.1203351271859251818715834e+30, "6120335127185925", 31},
    {6.4072231759974524557124855e+165, "64072231759974525", 166},
    {1.5334511274399801209011113e+178, "15334511274399801", 179},
    {4.1460946356846095957713284e+254, "41460946356846096", 255},
    {5.2194117330641133275520819e-298, "5219411733064113", -297},
    {4.4386951351463880914580687e-153, "4438695135146388", -152},
    {8.4936826634852433920000000e+20, "8493682663485243", 21},
    {4.8019054901004216642202154e+124, "4801905490100422", 125},
    {1.6029413102230287109375000e+13, "16029413102230287", 14},
    {3.9957748563370919427532665e+245, "3995774856337092", 246},
    {1.1553911836594247836544851e-257, "11553911836594248", -256},
    {5.6297962179201263725315812e-220, "5629796217920126", -219},
    {5.2916643315765506283648895e+244, "52916643315765506", 245},
    {9.5240140285875751976061518e-185, "9524014028587575", -184},
    {8.6975014755106425134052464e-241, "8697501475510643", -240},
    {1.3717852131495691988604648e+138, "13717852131495692", 139},
    {1.7231987346159161554175559e+87, "17231987346159162", 88},
    {8.9363021499207387816775547e+199, "8936302149920739", 200},
    {4.9797568217591501466616882e-113, "497975682175915", -112},
    {1.2403194497295049105960664e+243, "1240319449729505", 244},
    {3.2905657947583655440937388e+110, "32905657947583655", 111},
    {3.2520310768869659586147747e-301, "3252031076886966", -300},
    {4.3768531016889119398471961e+207, "4376853101688912", 208},
    {2.4160845520669937462590518e-216, "24160845520669937", -215},
    {1.8171943962199392634641625e-68, "18171943962199393", -67},
    {5.3788958616352902400000000e+17, "537889586163529", 18},
    {9.9660432255509426644861547e+47, "9966043225550943", 48},
    {7.2056195952477776187458910e+188, "7205619595247778", 189},
    {1.5468888811629511625735735e+229, "15468888811629512", 230},
    {1.3182940751256269962254919e+01, "1318294075125627", 2},
    {1.8653972569810052569554472e+175, "18653972569810053", 176},
    {9.0201923302353428737135776e+285, "9020192330235343", 286},
    {1.0386469408032983641524621e-296, "10386469408032984", -295},
    {3.6324003937802746789580123e-137, "36324003937802747", -136},
    {1.0913340987358360755473750e+138, "1091334098735836", 139},
    {7.4443181058253063406722616e+145, "7444318105825306", 146},
    {1.4244416491832207235967049e+189, "14244416491832207", 190},
    {4.2922865635012312048603415e+74, "4292286563501231", 75},
    {2.6307913998590419793707480e-73, "2630791399859042", -72},
    {1.2521260604657939396551916e+120, "1252126060465794", 121},
    {5.7241989648312798622428348e+32, "572419896483128", 33},
    {2.0458868118570690839177127e-257, "2045886811857069", -256},
    {3.0392859679560410832343143e+229, "3039285967956041", 230},
    {1.1743892534199425669823753e+242, "11743892534199426", 243},
    {1.3936834306688420397845666e-158, "1393683430668842", -157},
    {2.7643030736992442725942584e+190, "27643030736992443", 191},
    {1.4999770801344132319531784e-21, "14999770801344132", -20},
    {1.4263754565806662078924364e-86, "14263754565806662", -85},
    {5.5561717812746929507707755e+274, "5556171781274693", 275},
    {8.8797719389326347406666380e+254, "8879771938932635", 255},
    {1.5577191616931223789918242e+252, "15577191616931224", 253},
    {1.8033595360594376422938112e+73, "18033595360594376", 74},
    {2.9969497387834932120694284e+140, "29969497387834932", 141},
    {2.0473268968499646386092089e-207, "20473268968499646", -206},
    {1.4242470862521904403147086e+51, "14242470862521904", 52},
    {4.0720067562716614696244395e+144, "40720067562716615", 145},
    {1.8018325030138609802561173e+173, "1801832503013861", 174},
    {2.5506481709877728089947918e-219, "25506481709877728", -218},
    {1.1297466951691964322702597e-30, "11297466951691964", -29},
    {2.2532072066517235685994636e+197, "22532072066517236", 198},
    {1.7662637725415930175781250e+11, "1766263772541593", 12},
    {2.9524099492530473848510241e-150, "29524099492530474", -149},
    {5.4451313798350268418670732e+57, "5445131379835027", 58},
    {2.5437767655875130663645231e-50, "2543776765587513", -49},
    {1.5637578790746461868286133e+10, "15637578790746462", 11},
    {1.2678513972428752324423139e-191, "12678513972428752", -190},
    {1.1504493075322464783800285e+124, "11504493075322465", 125},
    {1.3249306383764145645696115e-226, "13249306383764146", -225},
    {1.0450634098845754604802085e-118, "10450634098845755", -117},
    {1.7901967590061112973592423e-147, "17901967590061113", -146},
    {1.0095738859758968501125432e-281, "10095738859758969", -280},
    {2.1012399770934725495910898e+305, "21012399770934725", 306},
    {3.9928537442456613492788780e+186, "39928537442456613", 187},
    {7.0630153391903360876644146e+140, "7063015339190336", 141},
    {1.1300476414672579545707691e+224, "1130047641467258", 225},
    {2.1303766067932885423308123e-211, "21303766067932885", -210},
    {1.0571494695706511760949056e+212, "10571494695706512", 213},
    {3.7454663904885934321910503e-240, "37454663904885934", -239},
    {3.6929396830381338211007114e+205, "3692939683038134", 206},
    {7.0651610720958968730173345e-84, "7065161072095897", -83},
    {7.5228504836402078447908945e+298, "7522850483640208", 299},
    {1.6966343183817344159235824e-255, "16966343183817344", -254},
    {9.6788964275128419473814936e-104, "9678896427512842", -103},
    {1.3259592143292919926248056e-123, "1325959214329292", -122},
    {8.9624282988671038907608739e+212, "8962428298867104", 213},
    {4.0273003708169363465221830e+186, "40273003708169363", 187},
    {4.6528339132802988281250000e+12, "4652833913280299", 13},
    {1.2124802599757710502511425e+92, "1212480259975771", 93},
    {1.1784747776021803595729678e+51, "11784747776021804", 52},
    {1.9672989473369520157492612e-210, "1967298947336952", -209},
    {2.8380487631507702172983460e-209, "283804876315077", -208},
    {2.3150799073125956167252524e-43, "23150799073125956", -42},
    {1.4891039904751228864938579e+216, "1489103990475123", 217},
    {6.4310945007457366070191521e+237, "64310945007457366", 238},
    {1.3691115512421472383359991e+239, "13691115512421472", 240},
    {6.4772782164378239347236985e+221, "6477278216437824", 222},
    {1.9361574856693681915554029e-176, "19361574856693682", -175},
    {3.0389629919680554348932384e-264, "30389629919680554", -263},
    {2.7753661549154504262279409e-307, "27753661549154504", -306},
    {4.3851561625753667522229436e+28, "4385156162575367", 29},
    {5.1788855402072104925510055e+101, "51788855402072105", 102},
    {1.0506616554286809829598795e+228, "1050661655428681", 229},
    {9.8194090005660595071978853e-47, "981940900056606", -46},
    {3.2043499155426853456389939e-279, "32043499155426853", -278},
    {7.3297312010688870191912227e-217, "7329731201068887", -216},
    {7.1245668890742762903713213e-35, "7124566889074276", -34},
    {8.2093977364245986174336238e+291, "8209397736424599", 292},
    {5.6947030455183453542595910e+116, "56947030455183454", 117},
    {2.2859331775956460830112485e+228, "2285933177595646", 229},
    {2.8620453906830709857543408e-149, "2862045390683071", -148},
    {2.1458380926021835105292091e-235, "21458380926021835", -234},
    {6.4244474299020611154105699e-189, "6424447429902061", -188},
    {1.3243879994296695295478584e-129, "13243879994296695", -128},
    {7.0237758759882541575130432e+165, "7023775875988254", 166},
    {1.2058977531419781359640269e-204, "12058977531419781", -203},
    {8.7873374373709437626242656e-290, "8787337437370944", -289},
    {1.0625596856202779754341481e-138, "1062559685620278", -137},
    {7.5747590893952093424258149e-161, "757475908939521", -160},
    {1.8779417812208710225229455e+179, "1877941781220871", 180},
    {3.4865419183147787924770748e+168, "3486541918314779", 169},
    {1.3301552633060428000000000e+16, "13301552633060428", 17},
    {1.7324856053707631548253887e-280, "17324856053707632", -279},
    {3.6827620142725605621760000e+21, "36827620142725606", 22},
    {1.4864421852587614286490061e+195, "14864421852587614", 196},
    {1.1990897739564449806113009e-171, "1199089773956445", -170},
    {1.6646326276043009281628310e-70, "1664632627604301", -69},
    {1.0108199607938896583062194e-275, "10108199607938897", -274},
    {3.3865511331131629393790377e-17, "3386551133113163", -16},
    {9.8641648667813565357427738e+47, "9864164866781357", 48},
    {3.6778040896192097775884654e+102, "367780408961921", 103},
    {3.0097389928617018012779741e+299, "30097389928617018", 300},
    {8.5627364693446262861215043e+214, "8562736469344626", 215},
    {1.8068320169234532704708040e-244, "18068320169234533", -243},
    {1.4435395571401019426413319e+82, "1443539557140102", 83},
    {2.1862890879555953979492188e+11, "21862890879555954", 12},
    {4.4458302023253276482850090e-248, "4445830202325328", -247},
    {1.2238363252477401772543464e+238, "12238363252477402", 239},
    {1.9438822147785633954113117e+44, "19438822147785634", 45},
    {1.7277318640877618896004204e-07, "1727731864087762", -6},
    {6.9959464079002860851202737e-256, "6995946407900286", -255},
    {2.7957481627850994853533486e-303, "27957481627850995", -302},
    {7.4083461664999458212728650e-308, "7408346166499946", -307},
    {2.0238281121252342634772192e-12, "20238281121252343", -11},
    {2.5139072168714867069481978e+93, "25139072168714867", 94},
    {6.9726561360392226603386737e+248, "6972656136039223", 249},
    {9.9792180281595772123391285e+99, "9979218028159577", 100},
    {1.9988014655535399614287527e-221, "199880146555354", -220},
    {1.9318205743058583468059358e-256, "19318205743058583", -255},
    {8.2475942508139014502188270e-42, "8247594250813901", -41},
    {2.6655960111213778014616071e-03, "2665596011121378", -2},
    {2.2626909758218460937500000e+13, "2262690975821846", 14},
    {4.6040330759073521034485987e+285, "4604033075907352", 286},
    {2.2709360601971783501270859e+100, "22709360601971784", 101},
    {3.5872616329641696287638460e+75, "35872616329641696", 76},
    {4.9791875789529303855938513e-25, "497918757895293", -24},
    {6.1936674744202106764915724e-253, "6193667474420211", -252},
    {9.4768845574511195621937006e-50, "947688455745112", -49},
    {8.1332666153596414063903113e-146, "8133266615359641", -145},
    {2.4620349638572500373061759e+232, "246203496385725", 233},
    {2.4394661228493976251870333e+186, "24394661228493976", 187},
    {7.3359626119339022781847791e-85, "7335962611933902", -84},
    {1.1359373638964561765001969e-50, "11359373638964562", -49},
    {3.4004363511152843823638172e-172, "34004363511152844", -171},
    {7.8586620202347151342721013e-152, "7858662020234715", -151},
    {2.0031157747634475110807944e-107, "20031157747634475", -106},
    {2.2528565738194591865593573e+201, "22528565738194592", 202},
    {6.6717608011792793768787123e+159, "6671760801179279", 160},
    {2.5311876990028956951742644e-231, "25311876990028957", -230},
    {4.7970938622048416778637787e-69, "4797093862204842", -68},
    {1.6101069661837815433637455e-276, "16101069661837815", -275},
    {1.4859293069704835414886475e+09, "14859293069704835", 10},
    {3.8777664069300798350225953e+65, "387776640693008", 66},
    {7.4949006589638003801972465e+238, "74949006589638", 239},
    {2.2389861366676571506576662e+234, "2238986136667657", 235},
    {6.6931125311275149406073260e+105, "6693112531127515", 106},
    {2.8594730762848586115204360e-301, "28594730762848586", -300},
    {1.1134826004476620708137983e-288, "1113482600447662", -287},
    {2.8005293465095199656127174e+102, "280052934650952", 103},
    {2.3194968249613200603844076e-97, "231949682496132", -96},
    {4.7018265342864021819384888e+78, "4701826534286402", 79},
    {8.7648555404075014358733973e-213, "8764855540407501", -212},
    {1.3998126839844308814053490e+286, "13998126839844309", 287},
    {8.1221562825608924671345843e+223, "8122156282560892", 224},
    {1.0884832151842278741786249e-164, "10884832151842279", -163},
    {4.9708319490710750763105802e-110, "4970831949071075", -109},
    {7.3431537778864280778380982e-235, "7343153777886428", -234},
    {5.4808503873354547931366780e+84, "5480850387335455", 85},
    {2.4330250114308668205326869e-238, "24330250114308668", -237},
    {2.4870600798811644176211300e-33, "24870600798811644", -32},
    {4.6626353402512594681913910e+228, "46626353402512595", 229},
    {1.3294760336643233399671789e-230, "13294760336643233", -229},
    {5.2635722894599146945339744e+37, "5263572289459915", 38},
    {2.2302762473516656245968851e-17, "22302762473516656", -16},
    {1.9751205766659886358606454e+126, "19751205766659886", 127},
    {1.6139978374565182431264860e-87, "16139978374565182", -86},
    {5.0002628022531995216329594e+143, "50002628022531995", 144},
    {6.7578178168935453691874169e-158, "6757817816893545", -157},
    {1.0669945088373611582423598e+174, "10669945088373612", 175},
    {6.4446715191849269883009745e+226, "6444671519184927", 227},
    {1.1572070424869388907587743e+308, "11572070424869389", 309},
    {6.1805007796603680176161529e+289, "6180500779660368", 290},
    {6.0795250886358361360599830e-106, "6079525088635836", -105},
    {1.8065624136236176476282045e-105, "18065624136236176", -104},
    {1.3643095573182609337816604e+132, "1364309557318261", 133},
    {2.6630837717262553125000000e+14, "26630837717262553", 15},
    {1.2606642506863840438492917e-69, "1260664250686384", -68},
    {2.3584845186288930875724270e-287, "2358484518628893", -286},
    {2.0402403866291861777064932e+145, "20402403866291862", 146},
    {2.3882972439211493347466558e-141, "23882972439211493", -140},
    {6.4678830044058628523067355e-216, "6467883004405863", -215},
    {1.0630110416746299232999473e-173, "106301104167463", -172},
    {3.7552610888854122562119292e+293, "3755261088885412", 294},
    {1.8784228822651205517682390e-287, "18784228822651206", -286},
    {6.8022954942988678830597722e+292, "6802295494298868", 293},
    {3.0864550023307267216464014e-216, "3086455002330727", -215},
    {3.4052317493509036160235097e-124, "34052317493509036", -123},
    {5.4799111593857602672461211e+295, "547991115938576", 296},
    {1.1092288226236521705618135e-214, "11092288226236522", -213},
    {1.2871875233536416983534990e+275, "12871875233536417", 276},
    {2.6806775864578898360438803e-275, "26806775864578898", -274},
    {9.6683198507687543576339955e+289, "9668319850768754", 290},
    {5.5556897143660390952256670e-180, "5555689714366039", -179},
    {1.9257904595707329387311290e-149, "1925790459570733", -148},
    {1.0838489517050333942067271e-240, "10838489517050334", -239},
    {4.6237483679125148983281797e-20, "4623748367912515", -19},
    {7.5698077705249816480467672e-170, "7569807770524982", -169},
    {2.6587076258069358715528544e-108, "2658707625806936", -107},
    {1.4117450146503308827343114e+302, "14117450146503309", 303},
    {3.7294702583168440904110509e+124, "3729470258316844", 125},
    {2.0032052352590071546842776e+59, "20032052352590072", 60},
    {6.2222740274817566517280940e-209, "6222274027481757", -208},
    {5.4592505564810308217579729e+163, "5459250556481031", 164},
    {1.9370737805066312322494755e-138, "19370737805066312", -137},
    {2.9201037715354460469928435e+41, "2920103771535446", 42},
    {9.1215031373365006140373212e-05, "91215031373365", -4},
    {4.4503772011357075854248387e+208, "4450377201135708", 209},
    {3.9569856827488943642218749e+65, "39569856827488944", 66},
    {3.1018304251778714102180221e-24, "31018304251778714", -23},
    {1.4979603466210307531885561e-25, "14979603466210308", -24},
    {9.3930467708356785650833390e+132, "9393046770835679", 133},
    {7.3868760851743505803042981e-298, "7386876085174351", -297},
    {1.0233025538708136113317879e-48, "10233025538708136", -47},
    {6.0506113417202233601609929e-218, "6050611341720223", -217},
    {5.0905917267835902184940032e-169, "509059172678359", -168},
    {2.1827374848003210398861701e-102, "2182737484800321", -101},
    {1.2129943571733231971273940e+295, "12129943571733232", 296},
    {3.7941950187328122395374087e+278, "3794195018732812", 279},
    {1.3487280348976707541135403e+219, "13487280348976708", 220},
    {2.6510856971443067742389195e+62, "2651085697144307", 63},
    {1.7953959386457551263631918e-200, "1795395938645755", -199},
    {1.1115458282173685296217753e-91, "11115458282173685", -90},
    {5.2875268903063075747676724e-176, "52875268903063076", -175},
    {6.2042161340583360582465679e-301, "6204216134058336", -300},
    {6.8392164870362387276404405e-288, "6839216487036239", -287},
    {2.4886560415594577852225083e+126, "24886560415594578", 127},
    {1.4769284795837603376226410e+217, "14769284795837603", 218},
    {1.2853129565253153575999540e-304, "12853129565253154", -303},
    {2.6616945155968357253557644e-64, "26616945155968357", -63},
    {4.0080970147821613665708788e+179, "40080970147821614", 180},
    {1.3463539936027766273852658e+297, "13463539936027766", 298},
    {3.1520339814321572238325510e-237, "3152033981432157", -236},
    {5.6837683331514968916111080e+105, "5683768333151497", 106},
    {8.0558489142458550627998106e+127, "8055848914245855", 128},
    {1.7614390410591826663034599e-200, "17614390410591827", -199},
    {9.3500969975513472481987152e-101, "9350096997551347", -100},
    {6.6204022774536698252233510e+212, "662040227745367", 213},
    {1.4730819366609028066707378e-37, "14730819366609028", -36},
    {4.1685897630216167315423168e-298, "4168589763021617", -297},
    {9.2619048093862712383270264e+07, "9261904809386271", 8},
    {3.6127863079361223278225539e+306, "36127863079361223", 307},
    {3.9507283992582546805929743e+192, "39507283992582547", 193},
    {2.6321830923746661900896249e-275, "26321830923746662", -274},
    {2.2626481330108744224384811e-114, "22626481330108744", -113},
    {1.1834761647672130577110548e+284, "1183476164767213", 285},
    {6.7168597864491351084608331e-10, "6716859786449135", -9},
    {2.6388352518697238394668066e+293, "2638835251869724", 294},
    {4.5536730425081336844957327e-265, "45536730425081337", -264},
    {1.4913809811188875544712539e-176, "14913809811188876", -175},
    {4.2657335502539552847391373e-226, "4265733550253955", -225},
    {3.7368559533615538725825900e+01, "3736855953361554", 2},
    {4.1372208414542678284903174e-308, "4137220841454268", -307},
    {2.1180390245266999325142656e-132, "21180390245267", -131},
    {2.6444939164036857604980469e+10, "26444939164036858", 11},
    {7.9446053857666180412226151e-64, "7944605385766618", -63},
    {5.9151605593170045303115200e+40, "5915160559317005", 41},
    {9.8085151358620752165780673e-63, "9808515135862075", -62},
    {2.0316426336246635394146490e-163, "20316426336246635", -162},
    {1.4377616003309025379582469e+158, "14377616003309025", 159},
    {1.3061177867929198528282342e+290, "13061177867929199", 291},
    {3.7674342099765775772786517e+161, "37674342099765776", 162},
    {1.0562815608281881519739079e+284, "10562815608281882", 285},
    {9.9776993836802547595133980e+126, "9977699383680255", 127},
    {1.9451375058519291389902106e-208, "19451375058519291", -207},
    {1.6482277777802652317432593e+44, "16482277777802652", 45},
    {5.0426144009744785990140152e+258, "5042614400974479", 259},
    {2.0193821426142988881133911e-117, "2019382142614299", -116},
    {3.5463652314719967538469438e-85, "3546365231471997", -84},
    {7.3860028292394568713976105e+283, "7386002829239457", 284},
    {1.2494858831833765999484589e+115, "12494858831833766", 116},
    {8.6346304578398884256182066e-27, "8634630457839888", -26},
    {2.3326520821679589201109317e-55, "2332652082167959", -54},
    {2.9015547476057496527169621e-240, "29015547476057497", -239},
    {3.4410317219822591523036981e-298, "3441031721982259", -297},
    {3.9511706315489604637635737e+281, "39511706315489605", 282},
    {1.0583609184764010919168577e+180, "1058360918476401", 181},
    {4.4784110572577653814660336e+229, "44784110572577654", 230},
    {1.8805431022620296048306831e-198, "18805431022620296", -197},
    {4.4256451712986176829233827e+197, "4425645171298618", 198},
    {2.8945725290836088445221713e+223, "2894572529083609", 224},
    {1.7260543116337805935768745e+188, "17260543116337806", 189},
    {1.1628787977781612303730886e+46, "11628787977781612", 47},
    {3.5467073551062239038627939e+258, "3546707355106224", 259},
    {2.5451573949249451367102935e+144, "2545157394924945", 145},
    {1.8384068749690815572521421e-213, "18384068749690816", -212},
    {1.0981124898857324624760971e+74, "10981124898857325", 75},
    {1.1647631941299187937286453e-155, "11647631941299188", -154},
    {4.3284251248515214073009000e+70, "43284251248515214", 71},
    {2.9498253537544326151789151e+38, "29498253537544326", 39},
    {4.3859852167921135970562359e-222, "43859852167921136", -221},
    {2.4939430022392763511765913e+145, "24939430022392764", 146},
    {3.4072266570271723675621218e-227, "34072266570271724", -226},
    {2.3350692189061791871532726e+143, "2335069218906179", 144},
    {3.3779879868003470500379616e-282, "3377987986800347", -281},
    {5.6983434484522465616831532e-123, "56983434484522466", -122},
    {1.8922668717231246610762481e+146, "18922668717231247", 147},
    {2.3947312388952817044794955e+268, "23947312388952817", 269},
    {5.9464579769068017331559770e+112, "5946457976906802", 113},
    {5.0092045048503205027387056e+166, "50092045048503205", 167},
    {4.5408227878388363351014294e+266, "45408227878388363", 267},
    {4.1296620993252914995641267e+89, "41296620993252915", 90},
    {1.4015705238276980219875916e-12, "1401570523827698", -11},
    {6.5387119147050934357455617e-170, "65387119147050934", -169},
    {3.7155977015614608543217855e+157, "3715597701561461", 158},
    {8.5482664254289006222818085e-290, "8548266425428901", -289},
    {3.0628519718695723516776375e+148, "30628519718695724", 149},
    {6.0835959176090959920802120e-179, "6083595917609096", -178},
    {2.3956362794708652485122854e-86, "23956362794708652", -85},
    {7.9760614736358385442741409e-57, "7976061473635839", -56},
    {7.1318368160276880777182550e+186, "7131836816027688", 187},
    {2.5380477894502478010242526e-300, "25380477894502478", -299},
    {3.1547731996022985651817462e+131, "31547731996022986", 132},
    {2.3487975086118523142654292e+138, "23487975086118523", 139},
    {1.7007902065273092357411244e-256, "17007902065273092", -255},
    {1.3887426263646144787172623e+108, "13887426263646145", 109},
    {5.3489180977683942958171761e-222, "5348918097768394", -221},
    {1.4117533390011461718412874e-26, "14117533390011462", -25},
    {3.7353973399516311884785148e+198, "3735397339951631", 199},
    {1.4401325980282575221658498e-240, "14401325980282575", -239},
    {7.2422709455525364319328219e+02, "7242270945552536", 3},
    {4.5351882407145008855400719e-281, "4535188240714501", -280},
    {4.5191810924743403622060564e-35, "45191810924743404", -34},
    {1.9762754229391765681357113e+170, "19762754229391766", 171},
    {6.9314064124446793762916378e+55, "6931406412444679", 56},
    {1.0825975487862963196360124e-197, "10825975487862963", -196},
    {5.3562282808904999660740367e-279, "53562282808905", -278},
    {4.7557180031164671508902065e-86, "4755718003116467", -85},
    {4.3610506441709139587008516e-226, "4361050644170914", -225},
    {6.1326259755501105947439629e+175, "61326259755501106", 176},
    {5.7786095192105311306454034e+29, "5778609519210531", 30},
    {4.2630027881077238023829714e+217, "4263002788107724", 218},
    {8.1817976872770066692328547e-206, "8181797687277007", -205},
    {1.1823480635956545307238213e-23, "11823480635956545", -22},
    {3.7957493200150921751244186e-293, "3795749320015092", -292},
    {1.6696765549298120190815659e+97, "1669676554929812", 98},
    {7.8392980702957188766249557e+74, "7839298070295719", 75},
    {2.7298953006145926267357345e-199, "27298953006145926", -198},
    {1.7241750940575855743173719e-105, "17241750940575856", -104},
    {4.9967185895202799467074358e+268, "499671858952028", 269},
    {8.7615864350568755984837903e+194, "8761586435056876", 195},
    {5.7957160474369012091443778e+94, "5795716047436901", 95},
    {6.6875406725490635815910864e+193, "66875406725490636", 194},
    {7.1132613866893005194964896e+292, "71132613866893005", 293},
    {2.6592448680752622686052090e-192, "26592448680752623", -191},
    {5.2615644808873983313132723e-207, "5261564480887398", -206},
    {3.2063168722098453312851077e-09, "32063168722098453", -8},
    {1.4465548863920916368546825e+64, "14465548863920916", 65},
    {2.1854088051207807470665916e+170, "21854088051207807", 171},
    {3.2235681488262294156118184e+165, "32235681488262294", 166},
    {7.6085467639697356104640771e-292, "7608546763969736", -291},
    {2.2155979611776914493627654e+149, "22155979611776914", 150},
    {2.6166274043098959810993157e-107, "2616627404309896", -106},
    {4.1250028723991649318773052e+42, "4125002872399165", 43},
    {8.7006341357023576782121216e-159, "8700634135702358", -158},
    {4.5904128675464264451593595e+170, "45904128675464264", 171},
    {2.4477245526027732371265941e-232, "24477245526027732", -231},
    {1.2496977758469294246620983e+175, "12496977758469294", 176},
    {3.3430105137220361642805441e-146, "3343010513722036", -145},
    {1.2801052530982956708363934e-157, "12801052530982957", -156},
    {5.4947783924572242734658242e-200, "5494778392457224", -199},
    {4.1163924116868965228185044e-47, "41163924116868965", -46},
    {3.8515974395987177131529524e+252, "3851597439598718", 253},
    {4.4911705751017895276700284e-153, "44911705751017895", -152},
    {8.8364878595238995063622312e+198, "88364878595239", 199},
    {2.7628373542276889027640076e+184, "2762837354227689", 185},
    {1.3987050272364295875766195e-248, "13987050272364296", -247},
    {3.8227468861778532728356640e-277, "38227468861778533", -276},
    {6.4137555274567031193600000e+20, "6413755527456703", 21},
    {8.3394742093438156250000000e+13, "8339474209343816", 14},
    {2.9786719033807176356922915e-180, "29786719033807176", -179},
    {5.9774504392616686850814792e-64, "5977450439261669", -63},
    {6.3642625371833348209689221e+220, "6364262537183335", 221},
    {5.4230040539398032801272083e-92, "5423004053939803", -91},
    {8.6183783405369079789948765e-237, "8618378340536908", -236},
    {1.1372340451459672659769492e-215, "11372340451459673", -214},
    {3.9752132147459698082072914e-277, "397521321474597", -276},
    {8.4143143573472432192226186e-72, "8414314357347243", -71},
    {1.4245796527156509375625715e+133, "1424579652715651", 134},
    {3.0500886652781503610289137e-48, "30500886652781504", -47},
    {5.0573248723188514914133984e+172, "50573248723188515", 173},
    {1.2801866425113912969074848e-09, "12801866425113913", -8},
    {5.9755070421208485057673336e-193, "59755070421208485", -192},
    {8.1206748483503662290906140e-202, "8120674848350366", -201},
    {1.6666673042841849125056399e-34, "1666667304284185", -33},
    {8.4272741113157535611540076e-148, "8427274111315754", -147},
    {1.0126799679248328270350871e-275, "10126799679248328", -274},
    {4.2373742485640704146632102e+281, "42373742485640704", 282},
    {1.6287766450778876254037887e-298, "16287766450778876", -297},
    {7.3969814265895901766737312e-228, "739698142658959", -227},
    {3.0689896800261579832599965e+50, "3068989680026158", 51},
    {4.9445962350961390411978466e-20, "4944596235096139", -19},
    {1.5050143909294381446922870e-51, "1505014390929438", -50},
    {1.0567378671009478587887382e-286, "10567378671009479", -285},
    {1.5436369777558892395199123e+286, "15436369777558892", 287},
    {8.1975545384572984363285269e+255, "8197554538457298", 256},
    {3.2510098968094583640925894e+272, "32510098968094584", 273},
    {6.6506090871418191308579420e+227, "6650609087141819", 228},
    {2.2036609919971921438724703e-288, "2203660991997192", -287},
    {2.0903939801032916434210819e+205, "20903939801032916", 206},
    {1.3467588072970769646112024e-88, "1346758807297077", -87},
    {1.3834174495555685888953087e-273, "13834174495555686", -272},
    {1.6936217983563323569224184e+198, "16936217983563324", 199},
    {1.8910109978120550402543913e+82, "1891010997812055", 83},
    {3.6953036902147592618553545e-199, "36953036902147593", -198},
    {6.7650495921504296307261440e+24, "676504959215043", 25},
    {1.9017152345582544024632493e-203, "19017152345582544", -202},
    {9.6785083656860448870231881e-57, "9678508365686045", -56},
    {2.6032704981001471023255614e-65, "2603270498100147", -64},
    {7.7983946210204996920647800e-113, "77983946210205", -112},
    {3.5794805494427415716117435e-270, "35794805494427416", -269},
    {2.6848555401082433650644245e+221, "26848555401082434", 222},
    {6.5331436806958636303568662e-283, "6533143680695864", -282},
    {2.1185866175553330043568941e-37, "2118586617555333", -36},
    {4.9660782270648134270779621e-107, "49660782270648134", -106},
    {2.7828096970067889785905031e-200, "2782809697006789", -199},
    {3.5849186654484263529380679e+59, "35849186654484264", 60},
    {6.0680467624602313121375720e-64, "6068046762460231", -63},
    {1.5141065749191032581863217e+214, "15141065749191033", 215},
    {1.4702855933915266484576010e-27, "14702855933915266", -26},
    {3.8605885057326076534619934e+230, "38605885057326077", 231},
    {6.2587751993311712980729924e+213, "6258775199331171", 214},
    {1.5054203746334048377889038e-19, "15054203746334048", -18},
    {3.2171994808246124877400688e+193, "32171994808246125", 194},
    {1.6908329729571649270841344e+25, "1690832972957165", 26},
    {2.5818728449515293083399836e-104, "25818728449515293", -103},
    {2.2020430976615627691585973e-96, "22020430976615628", -95},
    {4.8305283461000368010534712e+200, "4830528346100037", 201},
    {1.5505063632934265115181915e+04, "15505063632934265", 5},
    {3.5418443267735144531538490e-249, "35418443267735145", -248},
    {2.6447962576416478861182935e+39, "2644796257641648", 40},
    {3.6489893998472194369128350e-209, "36489893998472194", -208},
    {4.1339699480807554405775893e-146, "4133969948080755", -145},
    {4.6069075332544817979133529e-174, "4606907533254482", -173},
    {6.8428833861298773241444949e-112, "6842883386129877", -111},
    {5.0560717626320139650372369e+175, "5056071762632014", 176},
    {1.6276507089792342425600000e+20, "16276507089792342", 21},
    {1.6010488816801125966898204e-90, "16010488816801126", -89},
    {6.8036926664433520978133134e-53, "6803692666443352", -52},
    {3.6186447956413688551214034e+178, "3618644795641369", 179},
    {2.4616915836373005570050706e-180, "24616915836373006", -179},
    {3.6423331011700393119860759e+29, "3642333101170039", 30},
    {5.0852614545169006347656250e+10, "5085261454516901", 11},
    {3.9175245887056951056638370e-139, "3917524588705695", -138},
    {5.3506912080266126163337059e+64, "5350691208026613", 65},
    {2.2409373914932688500109753e+80, "22409373914932689", 81},
    {2.2608154784271777460611609e+282, "22608154784271777", 283},
    {4.4275936212483566595903858e-100, "44275936212483567", -99},
    {5.6893693285952456747922608e+76, "56893693285952457", 77},
    {3.4318732503500897280408509e+53, "34318732503500897", 54},
    {1.9102961421162538440961347e-177, "19102961421162538", -176},
    {5.8798268947268069373201746e+200, "5879826894726807", 201},
    {1.6060908037115636928760661e-50, "16060908037115637", -49},
    {4.8749328023244257464380957e+175, "4874932802324426", 176},
    {4.5963829361293838683688757e+289, "4596382936129384", 290},
    {4.2696071851618661367216284e-165, "4269607185161866", -164},
    {8.1773531357165021840610896e-46, "8177353135716502", -45},
    {2.2373473636108433320619264e+90, "22373473636108433", 91},
    {3.3766993821103376150131226e+08, "33766993821103376", 9},
    {3.3330860087332628377688582e-282, "3333086008733263", -281},
    {1.3868838546900236409427477e-206, "13868838546900236", -205},
    {2.0648915040281320208374860e-239, "2064891504028132", -238},
    {8.7211853270427013740118127e+02, "8721185327042701", 3},
    {5.3393797514048280985600000e+20, "5339379751404828", 21},
    {5.8147977942452407553207053e-116, "5814797794245241", -115},
    {7.5113448591390203571438270e-290, "751134485913902", -289},
    {1.5954632118109141474570148e+167, "15954632118109141", 168},
    {3.8841562760906631689740918e-131, "3884156276090663", -130},
    {2.7972203942824814870331287e+29, "27972203942824815", 30},
    {2.9121140305144053406283049e+113, "29121140305144053", 114},
    {1.1493799908252660637881802e+78, "1149379990825266", 79},
    {5.2940369165153144732617106e-157, "52940369165153145", -156},
    {1.2234410407812798724157691e+107, "12234410407812799", 108},
    {4.1817297387657998656889497e-10, "41817297387658", -9},
    {5.0484760864545056706662660e+140, "5048476086454506", 141},
    {1.2667001095894737987992056e-170, "12667001095894738", -169},
    {1.7563929411006402124279856e-238, "17563929411006402", -237},
    {2.5380381846430370172711203e+305, "2538038184643037", 306},
    {6.5568839222690110062956366e-223, "6556883922269011", -222},
    {5.2101990092123126981154030e-210, "5210199009212313", -209},
    {3.4161871105601808347830017e+152, "3416187110560181", 153},
    {4.1310378630322992013811756e-261, "4131037863032299", -260},
    {1.5025568096462087541166645e-92, "15025568096462088", -91},
    {1.9409998406736556851489807e+99, "19409998406736557", 100},
    {6.9863348271863401348386638e+68, "698633482718634", 69},
    {1.6870663383261654277146742e-261, "16870663383261654", -260},
    {1.7785487206222113565261530e+270, "17785487206222114", 271},
    {1.4405538102171544172985899e-161, "14405538102171544", -160},
    {3.4349266180022944064621022e+34, "34349266180022944", 35},
    {1.9278495612635554756360157e+42, "19278495612635555", 43},
    {1.0238070739750032017589208e+153, "10238070739750032", 154},
    {5.8448323467090631480807774e-37, "5844832346709063", -36},
    {1.3595014241044413193966101e-118, "13595014241044413", -117},
    {2.6604471174064015979124437e+69, "26604471174064016", 70},
    {1.4883147908160206314754181e-135, "14883147908160206", -134},
    {4.5080308306914694081134875e-67, "45080308306914694", -66},
    {2.6208911467596016000000000e+16, "26208911467596016", 17},
    {7.0758105332427007110525435e+106, "7075810533242701", 107},
    {6.4750058982550179397163369e-71, "6475005898255018", -70},
    {1.5974210726318117365520486e-236, "15974210726318117", -235},
    {1.1567356713971918200350303e-05, "11567356713971918", -4},
    {1.2546565227818604606562504e+93, "12546565227818605", 94},
    {5.8603621207780716151166399e-108, "58603621207780716", -107},
    {9.2483354721294220748734304e-101, "9248335472129422", -100},
    {4.9385274371893651595238519e+220, "4938527437189365", 221},
    {1.0534025104738417711639452e-109, "10534025104738418", -108},
    {2.0640382901005425927471158e+197, "20640382901005426", 198},
    {2.1694327261644070592242140e+195, "2169432726164407", 196},
    {8.7776605535297648958660844e+268, "8777660553529765", 269},
    {2.0367527523888624941361096e-133, "20367527523888625", -132},
    {6.2074975843727220774662782e+41, "6207497584372722", 42},
    {8.9852918022801132986924969e-194, "8985291802280113", -193},
    {1.3141682099350709505721423e+45, "1314168209935071", 46},
    {5.2141883784719558347063460e-235, "5214188378471956", -234},
    {8.8677315877347143727942239e-108, "8867731587734714", -107},
    {1.8967244024739504793768767e+82, "18967244024739505", 83},
    {1.8788339383860514638439394e+103, "18788339383860515", 104},
    {2.7490729446255474961022767e+124, "27490729446255475", 125},
    {2.2837006907676587818400464e-54, "22837006907676588", -53},
    {6.4239707411124629038213202e+52, "6423970741112463", 53},
    {5.1666420955855988722760230e+04, "5166642095585599", 5},
    {1.1566344150671457927479078e-18, "11566344150671458", -17},
    {1.0306093077384256303320861e-185, "10306093077384256", -184},
    {2.0581000524097715124388869e-39, "20581000524097715", -38},
    {2.8856110409363324607170821e+263, "28856110409363325", 264},
    {6.2612202919633316753037853e+248, "6261220291963332", 249},
    {4.6966797344936276690111119e+238, "46966797344936277", 239},
    {3.9756955848126741328336931e-81, "3975695584812674", -80},
    {1.6669938818632341793691929e-49, "16669938818632342", -48},
    {2.2413771863059535053010275e-284, "22413771863059535", -283},
    {3.7066202603973842980036274e-40, "3706620260397384", -39},
    {4.3687153091499700834075506e-33, "436871530914997", -32},
    {1.1251227206440686850830168e+277, "11251227206440687", 278},
    {1.1816987130333448532186514e+307, "11816987130333449", 308},
    {1.2092442718441729099958540e+282, "1209244271844173", 283},
    {7.1085401459051152469187392e+199, "7108540145905115", 200},
    {2.0465098678837336033366703e+236, "20465098678837336", 237},
    {1.2074648616971003470349780e+68, "12074648616971003", 69},
    {6.8821833258904962206164582e+26, "6882183325890496", 27},
    {6.4410302730194667864285326e+258, "6441030273019467", 259},
    {7.8115630721831206708745823e-303, "7811563072183121", -302},
    {3.3193079582926032230771123e-13, "3319307958292603", -12},
    {7.3550439936488071545474233e-41, "7355043993648807", -40},
    {5.8756171734115407537810474e-06, "5875617173411541", -5},
    {1.6974465846502092910501698e+267, "16974465846502093", 268},
    {6.6256928306672830085180341e-199, "6625692830667283", -198},
    {2.1590335532027519531250000e+13, "2159033553202752", 14},
    {3.1482904808868076347553997e-291, "31482904808868076", -290},
    {2.3376668243071132841337760e+82, "23376668243071133", 83},
    {5.7011465390877976701108865e+130, "5701146539087798", 131},
    {1.9167257800979286590669219e+107, "19167257800979287", 108},
    {3.7831760757325642320255370e+301, "3783176075732564", 302},
    {1.8094187728754036533387715e+298, "18094187728754037", 299},
    {1.5028695666822024589587460e+266, "15028695666822025", 267},
    {3.2329156088840434615722799e+205, "32329156088840435", 206},
    {1.0698826599970263320710425e+260, "10698826599970263", 261},
    {1.1042626354608613979770376e+197, "11042626354608614", 198},
    {2.9670611360085312198058630e+266, "2967061136008531", 267},
    {3.0461656290795171340133921e-52, "3046165629079517", -51},
    {1.8150535669600085574942720e+24, "18150535669600086", 25},
    {1.9647033895377778697435669e-269, "1964703389537778", -268},
    {2.3657247744059158418791941e-138, "23657247744059158", -137},
    {2.7978952674358557931357517e+150, "27978952674358558", 151},
    {5.8694479610300047483065636e+258, "5869447961030005", 259},
    {1.4345198502074973929991599e-211, "14345198502074974", -210},
    {1.0344458326690136709398462e+263, "10344458326690137", 264},
    {3.4304016192800826837052421e+238, "34304016192800827", 239},
    {1.8215798257888454886009062e+143, "18215798257888455", 144},
    {1.0913354210525475145341489e+223, "10913354210525475", 224},
    {2.9573604624942661609653236e-186, "2957360462494266", -185},
    {1.0338077767351005503298201e+60, "10338077767351006", 61},
    {1.0862686700709148982764563e-291, "10862686700709149", -290},
    {1.5293062469509238972177112e-284, "1529306246950924", -283},
    {1.7415188659915739806532855e-10, "1741518865991574", -9},
    {8.2430319981285234922465046e-130, "8243031998128523", -129},
    {2.6774717351254116515687296e+245, "26774717351254117", 246},
    {5.1761013631406297491908635e+234, "517610136314063", 235},
    {3.0184641592721693683158013e-161, "30184641592721694", -160},
    {9.0933326096302299796570304e+111, "909333260963023", 112},
    {1.8396049645693394217173150e+120, "18396049645693394", 121},
    {1.2629631357584433380139499e+235, "12629631357584433", 236},
    {7.1314298237519169271257004e-247, "7131429823751917", -246},
    {1.4206944254180332542923957e-276, "14206944254180333", -275},
    {9.3211104123548394811074359e+151, "932111041235484", 152},
    {3.9333441452363984568379336e+208, "39333441452363985", 209},
    {8.7641312660780088894817324e-160, "8764131266078009", -159},
    {9.3761487979848893784031022e-43, "937614879798489", -42},
    {8.6743306650430596946413200e-204, "867433066504306", -203},
    {1.0374224260925818682810948e+266, "10374224260925819", 267},
    {3.0042615145865174595039742e-171, "30042615145865175", -170},
    {2.2612407405137128149396002e+241, "22612407405137128", 242},
    {3.6581019762928823588547791e-68, "36581019762928824", -67},
    {3.1635494971465046875000000e+13, "31635494971465047", 14},
    {7.3412712838396622838654120e-80, "7341271283839662", -79},
    {1.3487788582071636247389417e-206, "13487788582071636", -205},
    {1.3602514243621809164604609e+229, "1360251424362181", 230},
    {5.4787687509355469257587121e-92, "5478768750935547", -91},
    {7.7174096391870294481579737e+137, "771740963918703", 138},
    {8.5294656562717580368878741e+118, "8529465656271758", 119},
    {2.4576933843678439633912624e+131, "2457693384367844", 132},
    {2.5633069859419298540669429e+127, "256330698594193", 128},
    {1.1682949917156204634149142e-123, "11682949917156205", -122},
    {1.3959790264633601744571550e-133, "13959790264633602", -132},
    {2.9358629717027217986603640e+113, "29358629717027218", 114},
    {3.3532333492594883691475965e-40, "33532333492594884", -39},
    {1.0057872835623995203658791e+228, "10057872835623995", 229},
    {1.0350041642210813777999596e-285, "10350041642210814", -284},
    {1.6306296372878706252585915e-273, "16306296372878706", -272},
    {8.6682381535643799442710561e+37, "866823815356438", 38},
    {3.0081262797972141885803894e-148, "30081262797972142", -147},
    {8.0557509600699874802055523e+226, "8055750960069987", 227},
    {4.8775485107076067881180827e+42, "4877548510707607", 43},
    {2.9863975824814542103055725e+200, "29863975824814542", 201},
    {1.2698049405759209584392153e-191, "1269804940575921", -190},
    {1.5367577882912403023740225e+129, "15367577882912403", 130},
    {6.8311295070785574583172575e-193, "6831129507078557", -192},
    {1.1831915583817798065524585e-01, "11831915583817798", 0},
    {1.6141529639098414527131194e-170, "16141529639098415", -169},
    {1.7399885632836085531785809e+307, "17399885632836086", 308},
    {4.1411602179663506776312618e+121, "4141160217966351", 122},
    {2.7401473704205117951873803e+76, "27401473704205118", 77},
    {1.0497814602512910935076052e-76, "10497814602512911", -75},
    {2.5355966814652276054067069e-290, "25355966814652276", -289},
    {2.8963936373587204248422889e-216, "28963936373587204", -215},
    {3.6402661857246878797660160e+28, "3640266185724688", 29},
    {1.7890019877833320597488846e-270, "1789001987783332", -269},
    {1.4922763847999264565960516e-200, "14922763847999265", -199},
    {9.3482169809453713819176666e-183, "9348216980945371", -182},
    {7.9052879545609979522298650e+66, "7905287954560998", 67},
    {5.3261710328109171002698817e+91, "5326171032810917", 92},
    {1.7710067096386322335544259e+193, "17710067096386322", 194},
    {2.0255384076440000427868123e+159, "2025538407644", 160},
    {4.6135700374283801799605151e-84, "461357003742838", -83},
    {2.4508346322654094348371578e-141, "24508346322654094", -140},
    {4.1101913050253092897839708e-23, "4110191305025309", -22},
    {2.0283417880398566612615766e+307, "20283417880398567", 308},
    {9.7696223481956948595289986e+154, "9769622348195695", 155},
    {4.2539225977152341274853937e+282, "4253922597715234", 283},
    {3.3386746609449005232511276e+63, "33386746609449005", 64},
    {1.3171880903110549504000000e+20, "1317188090311055", 21},
    {2.2505747342335082740331566e+141, "22505747342335083", 142},
    {4.3693732119300156858118360e+271, "4369373211930016", 272},
    {3.0990501797615208077415636e-200, "3099050179761521", -199},
    {3.8324128467455248005544494e+81, "3832412846745525", 82},
    {4.7871534067828758008776312e-217, "4787153406782876", -216},
    {6.7358399470475247076816802e+297, "6735839947047525", 298},
    {5.9008875433525676734624847e+168, "5900887543352568", 169},
    {2.6147554095018546813484234e-44, "26147554095018547", -43},
    {3.6785048820550048591439649e-210, "3678504882055005", -209},
    {1.7911747561186610489271241e-51, "1791174756118661", -50},
    {1.9139310908206998885558264e+206, "19139310908207", 207},
    {1.5004049577312389664152740e-83, "1500404957731239", -82},
    {7.6978585818131669657494166e+216, "7697858581813167", 217},
    {3.4542435448773534574065298e-284, "34542435448773535", -283},
    {1.5761467104118323768695407e-243, "15761467104118324", -242},
    {4.2737170341888149723552821e+123, "4273717034188815", 124},
    {1.5854706994008256682220923e+233, "15854706994008257", 234},
    {1.9242594548952258737273269e+00, "19242594548952259", 1},
    {1.6699078356792437843978405e+06, "16699078356792438", 7},
    {1.2144139599876685783403130e-265, "12144139599876686", -264},
    {4.7236831843817855099502022e-72, "4723683184381786", -71},
    {1.5738044191772066647112231e-135, "15738044191772067", -134},
    {3.5351121445910875649724110e-28, "35351121445910876", -27},
    {7.0164522297484477272165797e-282, "7016452229748448", -281},
    {4.8312311217059175472004186e-275, "48312311217059175", -274},
    {5.6398438739881832540491653e+140, "5639843873988183", 141},
    {5.6463594009189048116491890e-92, "5646359400918905", -91},
    {6.0854026715378484031185487e-06, "6085402671537848", -5},
    {1.2906299622877188240382126e+46, "12906299622877188", 47},
    {8.6771345705280542870060517e-194, "8677134570528054", -193},
    {8.3051918746616204650601057e+72, "830519187466162", 73},
    {7.4853239504991321903159577e-68, "7485323950499132", -67},
    {2.2825004208543419155449882e+182, "2282500420854342", 183},
    {3.2950476197304244402353448e-287, "32950476197304244", -286},
    {1.9436039244284054994944000e+22, "19436039244284055", 23},
    {2.8716498173843806387445127e+239, "28716498173843806", 240},
    {6.0341956954418339581758426e-242, "6034195695441834", -241},
    {6.9208484812202150089178043e+87, "6920848481220215", 88},
    {5.8944570437651778942719297e-113, "5894457043765178", -112},
    {9.9836485758015259085278523e+63, "9983648575801526", 64},
    {5.6276615973690714096576035e+267, "5627661597369071", 268},
    {1.3482564370212934738077012e-198, "13482564370212935", -197},
    {4.2113407145494413047257953e-175, "42113407145494413", -174},
    {1.3835683340606725334403160e-236, "13835683340606725", -235},
    {2.2649855447570720275657885e+74, "2264985544757072", 75},
    {1.2871901832586117177365107e+177, "12871901832586117", 178},
    {3.4203547889201460454818650e-137, "3420354788920146", -136},
    {4.7806796062067379451817478e-163, "4780679606206738", -162},
    {8.0607431329020735022493244e+268, "8060743132902074", 269},
    {7.3999111796631478419908468e-138, "7399911179663148", -137},
    {5.7777126668155028081861958e-229, "5777712666815503", -228},
    {1.4209494441375604713421174e+270, "14209494441375605", 271},
    {1.0809399296218747874259066e-287, "10809399296218748", -286},
    {5.0711588580753678516099405e+219, "5071158858075368", 220},
    {1.8061426620165381827300837e+151, "18061426620165382", 152},
    {1.0426007768638580620968312e-200, "1042600776863858", -199},
    {1.8379152890722441879910262e-50, "18379152890722442", -49},
    {4.7053009505899965406360719e-226, "47053009505899965", -225},
    {3.9455905309405927543717449e+232, "3945590530940593", 233},
    {4.5281412880593577281125319e-36, "4528141288059358", -35},
    {2.1809493870892580592770063e+258, "2180949387089258", 259},
    {2.2617682343197807712469236e-37, "22617682343197808", -36},
    {1.2860836612188776433876557e-171, "12860836612188776", -170},
    {3.4126654611500422368919631e-261, "34126654611500422", -260},
    {3.4706359534162477879100025e-307, "34706359534162478", -306},
    {1.6925132933950286091077356e-248, "16925132933950286", -247},
    {1.9722043021906556307680096e+30, "19722043021906556", 31},
    {1.5515962068706308148300827e-275, "15515962068706308", -274},
    {3.3103301084572481388415827e-125, "3310330108457248", -124},
    {9.0885352537083887594345530e-119, "9088535253708389", -118},
    {3.5092881418824972927641291e+180, "35092881418824973", 181},
    {1.4101430913620944111814036e+260, "14101430913620944", 261},
    {2.4246476652991371508323555e+89, "24246476652991372", 90},
    {6.3135974289406203716325044e-271, "631359742894062", -270},
    {1.2054012147414557620185588e+55, "12054012147414558", 56},
    {6.3382884176218923250742172e-100, "6338288417621892", -99},
    {1.3427641261079400000000000e+14, "134276412610794", 15},
    {1.2977106275544594398748579e+133, "12977106275544594", 134},
    {3.3361780415732906229120957e+261, "33361780415732906", 262},
    {3.6456309145152419905289160e+255, "3645630914515242", 256},
    {1.9182198257969826859727740e+113, "19182198257969827", 114},
    {5.6161158551409906480894863e-12, "5616115855140991", -11},
    {8.3728984329651330862571726e-63, "8372898432965133", -62},
    {5.5816499030500212414151328e+153, "5581649903050021", 154},
    {1.6734953762089439750566402e-286, "1673495376208944", -285},
    {2.7396958500975774227127076e+171, "27396958500975774", 172},
    {2.5823769236119406773487629e-124, "25823769236119407", -123},
    {1.0012898831454177590143209e+280, "10012898831454178", 281},
    {3.9511983509899061492817302e+197, "3951198350989906", 198},
    {1.1879491457259326238152923e+303, "11879491457259326", 304},
    {4.9639049930323435395443690e-58, "49639049930323435", -57},
    {3.2011589418695800234752904e+207, "320115894186958", 208},
    {3.2812295851890098622498423e+158, "328122958518901", 159},
    {6.7294419431791680758749969e+221, "6729441943179168", 222},
    {1.4005204735582770971204370e-306, "14005204735582771", -305},
    {1.8019374921621486951849602e+124, "18019374921621487", 125},
    {2.3578958096622245757076491e+64, "23578958096622246", 65},
    {6.1441141205813415867493281e+210, "6144114120581342", 211},
    {3.1354564913905433626579141e-145, "31354564913905434", -144},
    {1.3547983799375222365835911e+120, "13547983799375222", 121},
    {2.2490689576347350366441733e+285, "2249068957634735", 286},
    {3.5304963946862358661474501e+129, "3530496394686236", 130},
    {6.9899147820642071385997312e+26, "6989914782064207", 27},
    {4.3432912726185741870051233e-227, "4343291272618574", -226},
    {3.4933015189920647046774764e-100, "34933015189920647", -99},
    {3.6227165055676148310633827e+215, "3622716505567615", 216},
    {5.0725477667451651400885047e-303, "5072547766745165", -302},
    {4.9475048410116501515772746e+207, "494750484101165", 208},
    {8.0810469892475180061489291e-135, "8081046989247518", -134},
    {1.7734381183173425634798995e+302, "17734381183173426", 303},
    {3.3112530164600203254487089e+92, "33112530164600203", 93},
    {3.1465284811269642637895797e+274, "31465284811269643", 275},
    {4.5671705788153691678305687e+85, "4567170578815369", 86},
    {3.4627991770973131071577644e-221, "3462799177097313", -220},
    {3.9610180370143696853953259e+290, "396101803701437", 291},
    {1.8615786990720555488924812e+124, "18615786990720555", 125},
    {1.7268048386864883905970163e-185, "17268048386864884", -184},
    {1.2419056536663269708610975e-247, "1241905653666327", -246},
    {2.6397202637915845273471142e-302, "26397202637915845", -301},
    {3.0895418950404652761805386e+296, "30895418950404653", 297},
    {1.1070793144361075938533697e+140, "11070793144361076", 141},
    {4.0068011823713482871550347e+181, "4006801182371348", 182},
    {1.8004252482767167927679838e-142, "18004252482767168", -141},
    {2.0961575077552820604633501e+172, "2096157507755282", 173},
    {4.7761273135247925586002549e+230, "47761273135247926", 231},
    {4.6840071653923228313630818e-89, "4684007165392323", -88},
    {1.3924252282076272000000000e+17, "13924252282076272", 18},
    {3.4696156956285545846004270e-181, "34696156956285546", -180},
    {4.5341800761608737765946136e-185, "4534180076160874", -184},
    {1.0125499081449119412056309e-260, "1012549908144912", -259},
    {7.9683649243964571402627762e+129, "7968364924396457", 130},
    {1.1915933953652253988287594e-26, "11915933953652254", -25},
    {1.3399510390033772343356245e-151, "13399510390033772", -150},
    {2.2963992786899618750810642e-156, "2296399278689962", -155},
    {3.5606535993096717084775489e+189, "35606535993096717", 190},
    {3.4788422885418702770369146e-137, "34788422885418703", -136},
    {1.5046290559780269956607981e+248, "1504629055978027", 249},
    {1.7658363660708257615947773e+109, "17658363660708258", 110},
    {9.8909582264802911804769137e-108, "9890958226480291", -107},
    {2.7497448691138900290892555e+216, "274974486911389", 217},
    {1.3211683169855903819382313e-06, "13211683169855904", -5},
    {3.6985433138338659885378162e+150, "3698543313833866", 151},
    {1.9367944310172287795820876e+230, "19367944310172288", 231},
    {7.6693175060858990897820952e+48, "7669317506085899", 49},
    {5.1878211941055420183220753e+177, "5187821194105542", 178},
    {3.0584620312195532561525910e+56, "30584620312195533", 57},
    {3.3789738549769810619098304e-41, "3378973854976981", -40},
    {1.8705304423179901864593795e+64, "18705304423179902", 65},
    {1.1741557158699721925495521e-25, "11741557158699722", -24},
    {1.4979373311669731156241114e+189, "1497937331166973", 190},
    {8.2759381212399947241528743e-142, "8275938121239995", -141},
    {7.9560333601694741634964054e-10, "7956033360169474", -9},
    {1.3082785382698348573068810e+153, "13082785382698349", 154},
    {7.7445440513892907400232563e+247, "7744544051389291", 248},
    {7.6308584682795501901495880e+169, "763085846827955", 170},
    {1.8210057009222417246880313e-213, "18210057009222417", -212},
    {1.2792523092258278567673620e+172, "12792523092258279", 173},
    {3.9364908639013912000000000e+16, "3936490863901391", 17},
    {2.3748889596424966998530781e-50, "23748889596424967", -49},
    {4.1668702309625275148476380e+257, "41668702309625275", 258},
    {1.1345948559333293587130350e-180, "11345948559333294", -179},
    {4.1284957804338663676974489e+235, "41284957804338664", 236},
    {2.4314018757438159684617431e-297, "2431401875743816", -296},
    {3.1868638460288923277146111e-103, "31868638460288923", -102},
    {6.1237369502367506709261785e-306, "6123736950236751", -305},
    {1.3781491757539143768685506e+203, "13781491757539144", 204},
    {6.4997793286397852453114459e-240, "6499779328639785", -239},
    {2.0981690185692273185396927e-34, "20981690185692273", -33},
    {4.1957549740590494575356509e-21, "41957549740590495", -20},
    {6.2757366183603090173937474e-229, "6275736618360309", -228},
    {3.6715499969527119885488232e-252, "3671549996952712", -251},
    {4.2244420724584326102496194e+263, "42244420724584326", 264},
    {7.9136628345695134567937786e-275, "7913662834569513", -274},
    {3.8375739618880363664883129e+180, "38375739618880364", 181},
    {1.5675576931901139384427908e+161, "1567557693190114", 162},
    {7.0552409465402538058577836e-63, "7055240946540254", -62},
    {3.9861567732353156639338425e+243, "3986156773235316", 244},
    {1.8441273931498876796869222e-202, "18441273931498877", -201},
    {1.7628775328190804483483451e+45, "17628775328190804", 46},
    {1.0521034679216546175592393e+298, "10521034679216546", 299},
    {2.6462709997096056136023647e-80, "26462709997096056", -79},
    {2.6758547102121412122978976e-175, "2675854710212141", -174},
    {1.0569865652234273617104102e+54, "10569865652234274", 55},
    {1.3361829638951759242207472e+281, "1336182963895176", 282},
    {4.0371544705424147432898582e-205, "4037154470542415", -204},
    {6.2074859424953627565581335e-98, "6207485942495363", -97},
    {8.6148367126820741977444820e-296, "8614836712682074", -295},
    {2.5667338400898385570813203e-86, "25667338400898386", -85},
    {1.5559860783093988862549528e+217, "1555986078309399", 218},
    {5.4851184036646931674506441e-154, "5485118403664693", -153},
    {1.6694830122734885390816413e-72, "16694830122734885", -71},
    {1.8887005302461839286556290e+286, "1888700530246184", 287},
    {8.1052525705108861887184950e-187, "8105252570510886", -186},
    {1.4759311115886141029284734e+278, "1475931111588614", 279},
    {9.3007139271501273548973098e-263, "9300713927150127", -262},
    {1.7007742162119877289100965e-131, "17007742162119877", -130},
    {2.7150778000034926304892639e-97, "27150778000034926", -96},
    {5.8828159937249030366083802e-288, "5882815993724903", -287},
    {3.8814736113475668550558543e-159, "3881473611347567", -158},
    {3.6657806330176565943506705e-186, "36657806330176566", -185},
    {1.8698829061271856602846011e+260, "18698829061271857", 261},
    {1.0394439390925548748800000e+20, "10394439390925549", 21},
    {7.2462034999336346106524214e-55, "7246203499933635", -54},
    {5.5482493092824232447179356e+300, "5548249309282423", 301},
    {1.0288326683469367289175159e+244, "10288326683469367", 245},
    {6.9606202739377556914878584e-171, "6960620273937756", -170},
    {1.6223047588541169045205514e-304, "1622304758854117", -303},
    {8.8649441583379942203908085e+99, "8864944158337994", 100},
    {1.5428883335165843855696880e-208, "15428883335165844", -207},
    {5.3270696942110751789766978e-278, "5327069694211075", -277},
    {2.9095008546796346810078546e-105, "29095008546796347", -104},
    {3.2453619223194241897810040e-305, "3245361922319424", -304},
    {4.2786703282247230529785156e+10, "4278670328224723", 11},
    {1.5397912855779855360000000e+18, "15397912855779855", 19},
    {9.6250678779583517609632115e+114, "9625067877958352", 115},
    {2.7852902302582160030542028e+288, "2785290230258216", 289},
    {3.6614927936573545699213642e-49, "36614927936573546", -48},
    {2.0420366887703581243851600e+95, "2042036688770358", 96},
    {9.5139439180691932424793672e+191, "9513943918069193", 192},
    {9.3400961021213886325678682e-249, "9340096102121389", -248},
    {9.3502884019950899233093138e-239, "935028840199509", -238},
    {2.1780092412223515329890070e-244, "21780092412223515", -243},
    {3.0812849275978446529607483e-182, "30812849275978447", -181},
    {6.0414316430259498891838767e+252, "604143164302595", 253},
    {2.5837905280679173271168915e+32, "25837905280679173", 33},
    {5.7735257772241745390143268e-84, "57735257772241745", -83},
    {2.5192171128915811550000464e-13, "2519217112891581", -12},
    {6.2506161747628200009353838e+106, "625061617476282", 107},
    {1.2351522718317102393946244e-197, "12351522718317102", -196},
    {1.4567187503180897733579298e-250, "14567187503180898", -249},
    {1.8582809643066146025117503e+264, "18582809643066146", 265},
    {3.9845076274485306298871044e+129, "39845076274485306", 130},
    {8.5131785081750805919566052e-160, "851317850817508", -159},
    {3.6669738933819321901090548e-141, "3666973893381932", -140},
    {2.2702054255071384857246447e-17, "22702054255071385", -16},
    {2.2787545650463420159881761e-195, "2278754565046342", -194},
    {2.7133348577099853123330160e-245, "27133348577099853", -244},
    {2.7481205218092034476195956e-219, "27481205218092034", -218},
    {5.2508228709694018257977048e+296, "5250822870969402", 297},
    {4.2613247180477405824734802e-12, "42613247180477406", -11},
    {1.8281238253124698360992548e-177, "18281238253124698", -176},
    {9.6595450374203001729803481e+169, "96595450374203", 170},
    {2.5057184577611389020379310e+300, "2505718457761139", 301},
    {4.2963843714966047573530097e+45, "4296384371496605", 46},
    {5.2257375474296417041658735e+122, "5225737547429642", 123},
    {1.3379097733554886272693750e-62, "13379097733554886", -61},
    {1.2023501972606673960176452e+215, "12023501972606674", 216},
    {3.1147561685808606466122285e+177, "31147561685808606", 178},
    {8.4767736285474249486963792e+50, "8476773628547425", 51},
    {3.8247445996268437521259744e-50, "38247445996268438", -49},
    {8.7368880105065106832426368e+142, "8736888010506511", 143},
    {5.3193219667614259349844153e-136, "5319321966761426", -135},
    {2.2765078383186805125048608e+274, "22765078383186805", 275},
    {1.3031509799936046888100571e+158, "13031509799936047", 159},
    {5.2637176266835028761970283e+166, "5263717626683503", 167},
    {5.7290821688879655429495973e-115, "57290821688879655", -114},
    {2.1170638906794920500175187e-10, "2117063890679492", -9},
    {1.2972142804957798156166548e-166, "12972142804957798", -165},
    {8.2049853278432761450999894e+41, "8204985327843276", 42},
    {6.5717323991779868624016071e-120, "6571732399177987", -119},
    {1.9627358110106918008022617e+207, "19627358110106918", 208},
    {4.0739266919184060977193745e+158, "4073926691918406", 159},
    {2.2348584723602642198116610e+154, "22348584723602642", 155},
    {3.4453651656685255022052048e+248, "34453651656685255", 249},
    {3.5166646375319249283665881e+184, "3516664637531925", 185},
    {1.3959501926242899396114634e-78, "139595019262429", -77},
    {9.1732772704645886170152630e+74, "9173277270464589", 75},
    {4.2721701977627012299039088e+84, "4272170197762701", 85},
    {1.3225161111187985681964867e-131, "13225161111187986", -130},
    {9.0299562778918890495376253e-138, "9029956277891889", -137},
    {8.7065611847747989370907090e-38, "8706561184774799", -37},
    {2.9088652407776896838817694e-307, "29088652407776897", -306},
    {2.4253994228578675468370145e-166, "24253994228578675", -165},
    {1.1800251581948962300960295e+144, "11800251581948962", 145},
    {3.5871092286806242837311193e+245, "35871092286806243", 246},
    {3.8434382294738281250000000e+14, "3843438229473828", 15},
    {4.9595778920037640738024952e-107, "4959577892003764", -106},
    {1.6625343775210052058601891e+216, "16625343775210052", 217},
    {3.4760724933187659421045125e+301, "3476072493318766", 302},
    {2.2821661072826233004586339e-33, "22821661072826233", -32},
    {2.8035281590764224762780743e+99, "28035281590764225", 100},
    {5.9172177720651293024661335e+262, "5917217772065129", 263},
    {7.3579300638377007176513940e+146, "7357930063837701", 147},
    {1.8056807665373139249059173e+216, "1805680766537314", 217},
    {5.6527804491180553476833315e+294, "5652780449118055", 295},
    {8.8269233907037957789164369e+179, "8826923390703796", 180},
    {2.3352915266186264781611109e-147, "23352915266186265", -146},
    {1.2095158763772598404098434e+83, "12095158763772598", 84},
    {4.6187402617102155121357080e-150, "46187402617102155", -149},
    {6.9973802300336798653006554e+06, "699738023003368", 7},
    {7.6199598781123521578140910e-50, "7619959878112352", -49},
    {2.7939770980118384591506160e+224, "27939770980118385", 225},
    {1.7351387287449245760540039e+74, "17351387287449246", 75},
    {1.1533619681376619443884606e-274, "1153361968137662", -273},
    {2.7484430984986513548145848e-242, "27484430984986514", -241},
    {6.2879330345256479726051295e-121, "6287933034525648", -120},
    {1.0094104979604608173448333e+231, "10094104979604608", 232},
    {4.6295626482432276193455483e-16, "4629562648243228", -15},
    {4.5235274299148115698010501e-27, "45235274299148116", -26},
    {2.1667268271436737796759784e-69, "21667268271436738", -68},
    {8.1861797314393647572179267e-145, "8186179731439365", -144},
    {6.2538584188649263123057264e-304, "6253858418864926", -303},
    {1.8622026998438409063747535e+198, "1862202699843841", 199},
    {2.9047557248406644011201322e+51, "29047557248406644", 52},
    {1.6294353952075171269067558e+42, "1629435395207517", 43},
    {6.7748050929366701193735450e+295, "677480509293667", 296},
    {2.0539541741909852280889365e+65, "20539541741909852", 66},
    {8.1141716908017469115579384e-255, "8114171690801747", -254},
    {2.2578185488864834144927527e+198, "22578185488864834", 199},
    {2.1453038544474661437275742e+264, "2145303854447466", 265},
    {4.0999591757848744498179914e-168, "40999591757848744", -167},
    {5.0133773605003177920025337e+00, "5013377360500318", 1},
    {1.7503741548759209062341906e-204, "1750374154875921", -203},
    {8.0014554443642745836633653e-88, "8001455444364275", -87},
    {1.2028254796532536975612107e-154, "12028254796532537", -153},
    {8.1629810955609076063962963e-302, "8162981095560908", -301},
    {2.0759883250751190010977091e-255, "2075988325075119", -254},
    {2.9794291689047454433318657e+108, "29794291689047454", 109},
    {1.6451639762434254993598382e+66, "16451639762434255", 67},
    {1.0107736425376057019174402e-276, "10107736425376057", -275},
    {2.0237848678488947020475127e+282, "20237848678488947", 283},
    {9.4239335768718045666948390e+73, "9423933576871805", 74},
    {5.3874872558964205184107072e-15, "53874872558964205", -14},
    {4.4485838799643956299777881e-261, "4448583879964396", -260},
    {4.6207064294665164427120969e+219, "46207064294665164", 220},
    {1.5071488581893589792091862e+265, "1507148858189359", 266},
    {1.4653931189900533221416206e-172, "14653931189900533", -171},
    {2.9878631387186203607438989e+271, "29878631387186204", 272},
    {2.3936487295275767929334136e+290, "23936487295275768", 291},
    {1.7912619828617795242265651e+147, "17912619828617795", 148},
    {8.1540907358666142973927709e-81, "8154090735866614", -80},
    {3.6367798331860154461701872e-278, "36367798331860154", -277},
    {1.9869468362613145889958660e+180, "19869468362613146", 181},
    {1.5570484828969709450278133e-14, "1557048482896971", -13},
    {1.2825167393775473358233461e-286, "12825167393775473", -285},
    {8.9526206053768923878919679e+194, "8952620605376892", 195},
    {1.4880200534921975468862501e-50, "14880200534921975", -49},
    {5.8593638829411094422413899e+277, "58593638829411094", 278},
    {3.7746729557100769706402141e-115, "3774672955710077", -114},
    {9.5112093383983831285177887e+220, "9511209338398383", 221},
    {6.8811495786075233941800247e+150, "6881149578607523", 151},
    {5.3755547536227111865316645e+304, "5375554753622711", 305},
    {5.2325751161154614015155061e+211, "5232575116115461", 212},
    {1.5183499472377435857258974e+302, "15183499472377436", 303},
    {2.1934971195052625084892207e-208, "21934971195052625", -207},
    {1.2803245321055242022998787e+289, "12803245321055242", 290},
    {1.3610483107243158511271088e-245, "13610483107243159", -244},
    {5.4651925647839892723044613e+58, "5465192564783989", 59},
    {6.6550806563394176257175029e-12, "6655080656339418", -11},
    {5.5663826104844561876735781e-197, "5566382610484456", -196},
    {7.1789348570683956935482195e+222, "7178934857068396", 223},
    {1.9008922516059130057478972e+38, "1900892251605913", 39},
    {9.3130869900147599871157231e-210, "931308699001476", -209},
    {1.3670432664891609483169578e+123, "1367043266489161", 124},
    {9.1286292659529815371835951e-114, "9128629265952982", -113},
    {3.4866894570481911035825702e+96, "3486689457048191", 97},
    {1.5410768184140267896233493e+208, "15410768184140268", 209},
    {6.8082595915326034415571365e+141, "6808259591532603", 142},
    {1.8067335033587528265807539e+219, "18067335033587528", 220},
    {7.8248779656233566970947575e-246, "7824877965623357", -245},
    {3.2104558657403646447562758e-94, "32104558657403646", -93},
    {6.4783955649276735404156306e-128, "6478395564927674", -127},
    {4.4707884677455118134813820e+168, "4470788467745512", 169},
    {2.5051211564181919125647207e+216, "2505121156418192", 217},
    {3.1379985148755205197537267e-173, "31379985148755205", -172},
    {5.1739371188553528816425119e-26, "5173937118855353", -25},
    {2.1049328187381105928626404e+222, "21049328187381106", 223},
    {6.3332315820463639403219771e-106, "6333231582046364", -105},
    {2.5511841039203817802098581e-233, "2551184103920382", -232},
    {4.9757587078957307467706933e-51, "4975758707895731", -50},
    {3.0418664971397518895611318e-291, "3041866497139752", -290},
    {8.8025824746597218314949169e+260, "8802582474659722", 261},
    {1.0265911737295798025770909e+141, "10265911737295798", 142},
    {1.0678183836520018550048512e-286, "10678183836520019", -285},
    {3.1821574651077198458041766e-52, "318215746510772", -51},
    {1.0932885640042455110569514e+262, "10932885640042455", 263},
    {2.2532353412988387297334488e+126, "22532353412988387", 127},
    {1.3985412808666848280470387e+276, "13985412808666848", 277},
    {5.4153575721976158602523538e+98, "5415357572197616", 99},
    {1.0571125074279873690076991e-13, "10571125074279874", -12},
    {2.0306279333000296770160276e-268, "20306279333000297", -267},
    {4.5435681750045845961431543e-190, "4543568175004585", -189},
    {2.7411203482280746349135585e-199, "27411203482280746", -198},
    {2.9004265537354298336660097e-08, "29004265537354298", -7},
    {7.6212710874412378907394918e-43, "7621271087441238", -42},
    {1.7209479929540125879924681e-246, "17209479929540126", -245},
    {4.0098097415957482740523653e+42, "4009809741595748", 43},
    {1.7464028721815423065340895e-304, "17464028721815423", -303},
    {6.2178887661151270919257498e-39, "6217888766115127", -38},
    {1.1179800922518554623607119e-253, "11179800922518555", -252},
    {9.7910720858757170969359731e+68, "9791072085875717", 69},
    {4.5261575417794155384854093e+01, "45261575417794155", 2},
    {1.5276063928655556597475621e-133, "15276063928655557", -132},
    {6.9347090507018463952002312e-281, "6934709050701846", -280},
    {4.0032372281369552986778430e-133, "4003237228136955", -132},
    {1.0223416102250296912185552e-221, "10223416102250297", -220},
    {7.7355771942404486081172496e+123, "7735577194240449", 124},
    {4.4405085419634905002478712e-58, "44405085419634905", -57},
    {1.3045597440143853874764797e-273, "13045597440143854", -272},
    {3.2847973596214558907018627e-241, "3284797359621456", -240},
    {1.3143819107047397396990506e-219, "13143819107047397", -218},
    {3.0600376336501833118258649e-186, "30600376336501833", -185},
    {7.1581202849858278751658291e+306, "7158120284985828", 307},
    {1.0554562833901063011850782e+105, "10554562833901063", 106},
    {1.4499571196288319488401786e-275, "1449957119628832", -274},
    {5.0545122693140162508291168e-192, "5054512269314016", -191},
    {9.1276561030135097503662109e+09, "912765610301351", 10},
    {1.8318607714998256438440697e+258, "18318607714998256", 259},
    {1.2145627180755221906220125e-229, "12145627180755222", -228},
    {1.8178304674422985264594222e+150, "18178304674422985", 151},
    {4.9293405658852591038742089e+179, "4929340565885259", 180},
    {3.2680678703908805661120535e-215, "32680678703908806", -214},
    {1.5240137822392696826605933e+38, "15240137822392697", 39},
    {1.1796746942734021290353228e+139, "11796746942734021", 140},
    {1.5328664431065975482457174e-84, "15328664431065975", -83},
    {3.9489006330263950821833755e-166, "3948900633026395", -165},
    {1.4102535316636906696384962e+229, "14102535316636907", 230},
    {3.6645582564384466563998733e+248, "36645582564384467", 249},
    {1.0105692477832880314898895e+121, "1010569247783288", 122},
    {1.0544872344329860167421503e+257, "1054487234432986", 258},
    {7.0876795307494673430590531e+244, "7087679530749467", 245},
    {1.6066556833431615305974818e-130, "16066556833431615", -129},
    {2.4932816688547161455556634e+75, "2493281668854716", 76},
    {1.3012783409290795746563142e+133, "13012783409290796", 134},
    {1.5559574699840018000000000e+16, "15559574699840018", 17},
    {1.5774090517924899320184684e+193, "157740905179249", 194},
    {1.5494019208874175455799244e-270, "15494019208874175", -269},
    {9.9849773594280863409089477e-02, "9984977359428086", -1},
    {2.4888735302832177256556756e+175, "24888735302832177", 176},
    {5.9705147486816154169620206e-15, "59705147486816154", -14},
    {5.9801911175995486084931739e-100, "5980191117599549", -99},
    {6.2450229874069912482681097e-258, "6245022987406991", -257},
    {1.8424458505497827452262308e-222, "18424458505497827", -221},
    {1.8927005778739273636290837e-169, "18927005778739274", -168},
    {2.3395378369110636644372139e+91, "23395378369110637", 92},
    {4.7667188797031405163296332e+277, "47667188797031405", 278},
    {1.5318392571447809720487873e-123, "1531839257144781", -122},
    {1.4768081512616443370010184e-164, "14768081512616443", -163},
    {2.1126988225016822555381042e-202, "21126988225016823", -201},
    {2.1956669396336560778480784e-43, "2195666939633656", -42},
    {5.2582340214344040799112808e-118, "5258234021434404", -117},
    {2.9373387105813027770893612e-67, "29373387105813028", -66},
    {4.2661598031243086909244786e+110, "4266159803124309", 111},
    {4.8414225606192762630863287e+110, "4841422560619276", 111},
    {1.4139396835026719309004587e-27, "1413939683502672", -26},
    {5.8833214176233073377922676e-260, "5883321417623307", -259},
    {4.1248142035842037832936168e-80, "4124814203584204", -79},
    {4.4544983700079845995031924e+61, "44544983700079846", 62},
    {4.0699291583621172260210807e-33, "4069929158362117", -32},
    {1.3491557395795523451639658e-93, "13491557395795523", -92},
    {1.6348742885877787193158157e-44, "16348742885877787", -43},
    {3.7768278554455929693868461e-269, "3776827855445593", -268},
    {1.3507814737884047093594789e+143, "13507814737884047", 144},
    {4.8192886621742272962152657e-303, "4819288662174227", -302},
    {6.0099233840703198102414663e-237, "600992338407032", -236},
    {1.4948462445972607315347602e-01, "14948462445972607", 0},
    {2.3145211250760398103309637e+71, "231452112507604", 72},
    {1.2304873386028911054677903e-198, "12304873386028911", -197},
    {4.1521031953707628978268197e+297, "4152103195370763", 298},
    {6.5344400927791197518171185e+267, "653444009277912", 268},
    {1.8858976237129074424783582e-87, "18858976237129074", -86},
    {2.9822965472840050000000000e+14, "2982296547284005", 15},
    {2.3744708382934547751177557e+93, "2374470838293455", 94},
    {4.4477543241758556872144117e-121, "4447754324175856", -120},
    {2.2154634288734615367094769e+269, "22154634288734615", 270},
    {3.5369817536001737200476650e-98, "3536981753600174", -97},
    {1.5699080407465206657955972e-200, "15699080407465207", -199},
    {1.0418931441874643659974873e+58, "10418931441874644", 59},
    {5.8744198389711158600837160e-05, "5874419838971116", -4},
    {1.4128303809405937840892875e+02, "14128303809405938", 3},
    {9.1295307259864184458400752e+129, "9129530725986418", 130},
    {1.3654786064613531795408239e+213, "13654786064613532", 214},
    {1.3543373064866376012412193e-307, "13543373064866376", -306},
    {1.2728094410761912320000000e+19, "12728094410761912", 20},
    {1.4344661035372287468957717e-77, "14344661035372287", -76},
    {4.0991048517601954354697931e+179, "40991048517601954", 180},
    {4.3290025240058098561127603e+222, "432900252400581", 223},
    {5.2580500664232390226654657e-194, "5258050066423239", -193},
    {1.0089750307545397800334161e+90, "10089750307545398", 91},
    {1.1587001535944730083090334e+214, "1158700153594473", 215},
    {2.6033447014116678112662950e-93, "2603344701411668", -92},
    {8.9383247989713421333135557e-02, "8938324798971342", -1},
    {2.7672540250933569968174787e-242, "2767254025093357", -241},
    {5.8195575535887244396402442e-194, "5819557553588724", -193},
    {1.5667434675232216351505109e+255, "15667434675232216", 256},
    {5.5499136170388597033368318e+227, "554991361703886", 228},
    {2.2494842656473590377553757e+36, "2249484265647359", 37},
    {3.2179180273779320631117856e+304, "3217918027377932", 305},
    {9.9283337836013861053993193e-222, "9928333783601386", -221},
    {2.5005822865285304320000000e+19, "25005822865285304", 20},
    {1.8295806108296483413770710e-264, "18295806108296483", -263},
    {1.8592074811213013989475680e+77, "18592074811213014", 78},
    {3.1343014873353908472890840e-218, "3134301487335391", -217},
    {1.1773812841026313632814126e-160, "11773812841026314", -159},
    {1.2946238630515423313920000e+21, "12946238630515423", 22},
    {1.0905769869696258110812749e-271, "10905769869696258", -270},
    {1.0749218893429861258994624e+111, "10749218893429861", 112},
    {8.6998672920130308792884802e+157, "8699867292013031", 158},
    {9.8523407239894003486939988e+286, "98523407239894", 287},
    {3.6902442775594942148863220e+143, "3690244277559494", 144},
    {2.6815926908827291231628873e-181, "2681592690882729", -180},
    {3.0531557049276416000000000e+16, "30531557049276416", 17},
    {1.0955686272211039950033999e-169, "1095568627221104", -168},
    {1.5825616830729726554330559e+246, "15825616830729727", 247},
    {3.2075244147050663030135143e-04, "32075244147050663", -3},
    {2.0161733914103451452244780e+173, "20161733914103451", 174},
    {9.5944245277076220992671779e-206, "9594424527707622", -205},
    {1.0942280996015965352991698e-137, "10942280996015965", -136},
    {4.3307879934681785206042506e+188, "43307879934681785", 189},
    {4.3696513358248081525127184e-187, "4369651335824808", -186},
    {1.0283223157204603032613295e-67, "10283223157204603", -66},
    {1.4735476009708224506243116e-50, "14735476009708225", -49},
    {1.4462513695493480995396551e-29, "1446251369549348", -28},
    {2.8008031362026633764328489e-18, "28008031362026634", -17},
    {8.3147852464588961996274246e-208, "8314785246458896", -207},
    {4.1647893828577362099975181e+279, "4164789382857736", 280},
    {1.4893406328705229656468698e+158, "1489340632870523", 159},
    {1.5970346902986791226972958e+116, "1597034690298679", 117},
    {5.3954838513060589695077815e+206, "5395483851306059", 207},
    {1.5099136625633956224690803e+81, "15099136625633956", 82},
    {4.9093478398358422927106975e-92, "4909347839835842", -91},
    {1.9317940446481061297995484e+179, "1931794044648106", 180},
    {7.8747278796821919656844091e+260, "7874727879682192", 261},
    {1.5443886952976854127747560e+79, "15443886952976854", 80},
    {2.1791603403295548198305995e+213, "21791603403295548", 214},
    {3.6136162593446220894378744e+292, "3613616259344622", 293},
    {3.3866304566452242728735457e+42, "3386630456645224", 43},
    {3.6525271993968232899771011e-31, "36525271993968233", -30},
    {2.4891643654725855197956897e+293, "24891643654725855", 294},
    {2.4295448588084290301314393e+243, "2429544858808429", 244},
    {4.2679789931403037382136831e-73, "4267978993140304", -72},
    {5.3019664472895665704823554e-74, "53019664472895666", -73},
    {1.9939600970893887451363367e+37, "19939600970893887", 38},
    {7.5459624288655859568176891e+259, "7545962428865586", 260},
    {1.1655333686517076347661842e-300, "11655333686517076", -299},
    {3.1043641132218570959224832e+25, "3104364113221857", 26},
    {2.9292714431117987929994486e-187, "2929271443111799", -186},
    {9.4250022375476803637444273e+178, "942500223754768", 179},
    {4.0958691109905107634132816e+239, "40958691109905108", 240},
    {8.7231858585930662648069691e+203, "8723185858593066", 204},
    {1.3339401232856898754582099e-99, "13339401232856899", -98},
    {1.2125137944673939246252321e+175, "1212513794467394", 176},
    {4.3995654915947653756959434e+191, "43995654915947654", 192},
    {3.0473134016182686343921424e-239, "30473134016182686", -238},
    {2.3906100322259901662030236e+74, "239061003222599", 75},
    {3.6082225862881216046189447e-41, "36082225862881216", -40},
    {1.3481126309583820484385588e-142, "1348112630958382", -141},
    {1.3464357216536317111027454e+146, "13464357216536317", 147},
    {9.6210379966284623020369020e+270, "9621037996628462", 271},
    {8.7553685068291054592078958e+30, "8755368506829105", 31},
    {1.1656459264447848968583291e+176, "11656459264447849", 177},
    {1.1285406303370301653214094e-185, "11285406303370302", -184},
    {2.0346713756193530377591634e-265, "2034671375619353", -264},
    {1.0142184056088388083796558e+78, "10142184056088388", 79},
    {4.1938097438109126951092271e-68, "4193809743810913", -67},
    {1.7281200998903405936715710e-195, "17281200998903406", -194},
    {9.7484257062062589638406420e+173, "9748425706206259", 174},
    {1.3679623292307763307458377e-98, "13679623292307763", -97},
    {3.5102978355980217109809971e+131, "35102978355980217", 132},
    {5.7846624313032590735303590e-190, "5784662431303259", -189},
    {2.4747619339662182300758915e+305, "24747619339662182", 306},
    {7.1071625109703426048000000e+20, "7107162510970343", 21},
    {5.6070517284104948941561960e-98, "5607051728410495", -97},
    {4.8838449107539776937509867e+55, "48838449107539777", 56},
    {1.7187570634559362135605950e-292, "17187570634559362", -291},
    {4.5451796082267137850816912e-245, "4545179608226714", -244},
    {4.9126582733897490107723638e-61, "4912658273389749", -60},
    {2.0749205024343535964564681e-138, "20749205024343536", -137},
    {8.2021521367990010778651308e+146, "8202152136799001", 147},
    {5.4350411390588006241851600e-246, "5435041139058801", -245},
    {7.1732438506382012553174914e-103, "7173243850638201", -102},
    {6.1079917313060652348200163e-276, "6107991731306065", -275},
    {6.6189075310669348624781956e-304, "6618907531066935", -303},
    {1.3741948708952288877618008e-48, "1374194870895229", -47},
    {1.3986801575312068912637642e-02, "13986801575312069", -1},
    {1.7372852030851518308586804e-276, "17372852030851518", -275},
    {5.9178493574478629341458399e+125, "5917849357447863", 126},
    {6.8634434152912944829109882e+282, "6863443415291294", 283},
    {2.5158127217779692715125827e-278, "25158127217779693", -277},
    {3.1038347376787406322773868e+100, "31038347376787406", 101},
    {1.7888220080695538677327264e+211, "17888220080695539", 212},
    {5.2028021825253196085894985e+244, "52028021825253196", 245},
    {8.8229200198561870125554636e+219, "8822920019856187", 220},
    {1.4675309343198991344799391e+55, "1467530934319899", 56},
    {1.0391393511619595520000000e+18, "10391393511619596", 19},
    {2.0589047376161821290689555e-59, "2058904737616182", -58},
    {1.0262079589862792590665320e-76, "10262079589862793", -75},
    {5.0895329208428245216058750e-108, "50895329208428245", -107},
    {6.6320346387111087411995311e-256, "6632034638711109", -255},
    {1.3686548819675771129672249e+236, "13686548819675771", 237},
    {3.6960121836143231184482103e+110, "3696012183614323", 111},
    {4.9755288538752393962486723e+100, "49755288538752394", 101},
    {2.3130074316337495350545330e+71, "23130074316337495", 72},
    {1.0858332300695556108472378e-145, "10858332300695556", -144},
    {8.8979228667299617929446926e-58, "8897922866729962", -57},
    {1.7120092871157715519488221e-164, "17120092871157716", -163},
    {1.5368047429397295259161082e-138, "15368047429397295", -137},
    {1.1916780625529265331219965e+249, "11916780625529265", 250},
    {5.5470816934672345334851473e+75, "55470816934672345", 76},
    {3.3832221227914648996383584e-122, "3383222122791465", -121},
    {5.5866918009871002286672592e+06, "55866918009871", 7},
    {1.1238626523440099164923093e+201, "11238626523440099", 202},
    {3.9627971108541739845581659e+106, "3962797110854174", 107},
    {9.7028768817603331484401056e-113, "9702876881760333", -112},
    {7.9430644494568064769982618e-16, "7943064449456806", -15},
    {8.1902206910479950626878454e-102, "8190220691047995", -101},
    {2.4954287850303045226182820e+253, "24954287850303045", 254},
    {9.3311060132423976039583341e-39, "9331106013242398", -38},
    {8.6226681552218550608897828e-81, "8622668155221855", -80},
    {2.4521956813878261770426928e+164, "2452195681387826", 165},
    {1.8805919443294952729353826e+119, "18805919443294953", 120},
    {5.1343058601997434498572908e+117, "5134305860199743", 118},
    {3.9793895019054605792577455e+59, "39793895019054606", 60},
    {1.7238089163144224098744956e+292, "17238089163144224", 293},
    {3.0462781620867163959683564e+72, "30462781620867164", 73},
    {1.3241629175982477148875666e+240, "13241629175982477", 241},
    {3.5995969822538732471677732e-78, "35995969822538732", -77},
    {5.4496987927760478495878356e+133, "5449698792776048", 134},
    {1.0826202445969794703873154e-293, "10826202445969795", -292},
    {1.0916560342071715323576954e+238, "10916560342071715", 239},
    {4.7796715626080521896795506e+103, "4779671562608052", 104},
    {2.2616845943628729226949679e-178, "2261684594362873", -177},
    {6.8601577400973225857960890e+246, "68601577400973226", 247},
    {5.2707195358470042108481641e-82, "5270719535847004", -81},
    {3.0240478026830081248888587e-09, "3024047802683008", -8},
    {1.3319589275997619212830148e+168, "1331958927599762", 169},
    {5.2071198540732768983118788e+62, "5207119854073277", 63},
    {1.9577801679929413465716465e-246, "19577801679929413", -245},
    {1.7382636088892785293347904e+137, "17382636088892785", 138},
    {3.6797805647459263241944087e-09, "36797805647459263", -8},
    {2.6879403346145872188382312e-160, "26879403346145872", -159},
    {3.2882745805889557672632037e-223, "32882745805889558", -222},
    {4.6981498600746971297691753e+70, "4698149860074697", 71},
    {1.4897326053164948605269206e-297, "14897326053164949", -296},
    {1.1159431048887605586781051e-264, "11159431048887606", -263},
    {5.9112157850159437944548671e-183, "5911215785015944", -182},
    {2.8572239069501726335477001e+229, "28572239069501726", 230},
    {3.6010681968891812411913590e+134, "36010681968891812", 135},
    {2.8835496344008610832942880e-15, "2883549634400861", -14},
    {6.4484823925005634731588700e-03, "64484823925005635", -2},
    {8.7409641817914620950025200e+95, "8740964181791462", 96},
    {9.0561360824836671875000000e+13, "9056136082483667", 14},
    {5.3806014744983162273738397e+209, "5380601474498316", 210},
    {1.7343299496517874546906898e-277, "17343299496517875", -276},
    {1.1611858541853291653639614e+252, "11611858541853292", 253},
    {1.0489887531066897494239014e-30, "10489887531066897", -29},
    {1.5831619500970529043115675e+05, "1583161950097053", 6},
    {6.3234919585879576985846049e+124, "6323491958587958", 125},
    {2.9199734629788227081298828e+09, "29199734629788227", 10},
    {1.8386520970480404880563837e-209, "18386520970480405", -208},
    {6.2011112808677047416098974e-281, "6201111280867705", -280},
    {6.8462209697945634316061645e-188, "6846220969794563", -187},
    {1.4584795115990743904261343e-206, "14584795115990744", -205},
    {1.0067061409155619661252137e-127, "1006706140915562", -126},
    {6.7638315598540054824255203e-137, "67638315598540055", -136},
    {1.4657148928397164671613553e+192, "14657148928397165", 193},
    {1.6314970765299183863350210e-60, "16314970765299184", -59},
    {4.3712939634702431397231929e+223, "4371293963470243", 224},
    {3.3602157184429886834479222e-259, "33602157184429887", -258},
    {1.3675053384359003067016602e+10, "13675053384359003", 11},
    {2.0695475688533457774998411e+33, "20695475688533458", 34},
    {1.2087645881257886844876702e+57, "12087645881257887", 58},
    {3.7716426474655895633632377e-296, "37716426474655896", -295},
    {1.4616466704303818149748778e-91, "14616466704303818", -90},
    {7.2864427291227917747332453e+33, "7286442729122792", 34},
    {2.7663857057209051330962128e+47, "2766385705720905", 48},
    {6.8574613033847114706986758e+01, "6857461303384711", 2},
    {3.5872121742622071451744257e+87, "3587212174262207", 88},
    {6.7478164537952564922023936e+27, "6747816453795256", 28},
    {2.2360533223705655287309431e-43, "22360533223705655", -42},
    {7.3019086159298455495500349e+211, "7301908615929846", 212},
    {1.1341557360356157053789805e+226, "11341557360356157", 227},
    {8.7301848807909812427742563e-176, "8730184880790981", -175},
    {1.7911474522850688368395427e-266, "1791147452285069", -265},
    {7.9219104087785775975866886e-92, "7921910408778578", -91},
    {1.7625653987495230496757503e-265, "1762565398749523", -264},
    {3.9123116047644663053680228e-182, "3912311604764466", -181},
    {2.4300219619508912387047923e+122, "24300219619508912", 123},
    {2.2822815263961004416368878e+56, "22822815263961004", 57},
    {8.3776232846027530262690770e+183, "8377623284602753", 184},
    {1.6489074119866815874290221e+265, "16489074119866816", 266},
    {4.0890049640026148020323554e-222, "4089004964002615", -221},
    {1.7807030249026641461248000e+22, "17807030249026641", 23},
    {2.1557394986802078360542343e-87, "2155739498680208", -86},
    {2.9815476146105861676357872e+156, "2981547614610586", 157},
    {1.5486745085289257332891430e-55, "15486745085289257", -54},
    {3.7792399789727726286580973e+157, "37792399789727726", 158},
    {2.7509666273757838476749855e+144, "2750966627375784", 145},
    {6.0475072910898493456614589e-90, "6047507291089849", -89},
    {4.7816499951232486333572225e-179, "47816499951232486", -178},
    {1.5479044264063142108243896e+235, "15479044264063142", 236},
    {4.2500716150459176941651325e-110, "42500716150459177", -109},
    {1.9936789789547857334789769e-213, "19936789789547857", -212},
    {6.3631722752186185117499940e+206, "63631722752186185", 207},
    {1.7483733112874849882467369e-35, "1748373311287485", -34},
    {3.3889139892657500115953495e+296, "338891398926575", 297},
    {3.8430157652975743742378806e+282, "38430157652975744", 283},
    {2.7723462001933914126730443e+197, "27723462001933914", 198},
    {2.4027291026607939139722591e-145, "2402729102660794", -144},
    {1.4682192721391879911142035e+252, "1468219272139188", 253},
    {9.3991117210172130536675890e+143, "9399111721017213", 144},
    {6.4647550435527601258264288e+193, "646475504355276", 194},
    {4.8570258740904633001563342e+199, "4857025874090463", 200},
    {8.4942713650402143419293203e+59, "8494271365040214", 60},
    {1.8874091305242204894582936e-178, "18874091305242205", -177},
    {7.4546871919735734518670497e-123, "7454687191973573", -122},
    {2.2447380985663650361365263e+295, "2244738098566365", 296},
    {5.0455918631514070110986449e-70, "5045591863151407", -69},
    {8.8934024971487816569116329e-122, "8893402497148782", -121},
    {2.2971699519741015156667478e-54, "22971699519741015", -53},
    {7.4230652018024374937851447e+148, "7423065201802437", 149},
    {1.4471549294420528096598353e+169, "14471549294420528", 170},
    {2.1128465001869999253767042e+70, "2112846500187", 71},
    {7.6344395307757713037366622e+152, "7634439530775771", 153},
    {6.3448309652081168770662400e+23, "6344830965208117", 24},
    {1.7174495243664408170912287e-241, "17174495243664408", -240},
    {3.6619417411057608036663366e+301, "3661941741105761", 302},
    {7.2112432237899442404698376e-267, "7211243223789944", -266},
    {4.3655295632489840333746786e+54, "4365529563248984", 55},
    {1.0531015598340824915646109e-301, "10531015598340825", -300},
    {2.1460249941484431685884356e-125, "21460249941484432", -124},
    {1.9463543126816855510696769e+05, "19463543126816856", 6},
    {1.5107759810293382451594793e-296, "15107759810293382", -295},
    {2.5128032613684059422935218e+97, "2512803261368406", 98},
    {2.3150523629050355132653834e+49, "23150523629050355", 50},
    {5.6438956835492845329289271e+276, "5643895683549285", 277},
    {1.6233731883483942268287516e-164, "16233731883483942", -163},
    {3.7685253378414299230438786e-100, "376852533784143", -99},
    {1.4159051927699811726561278e-72, "14159051927699812", -71},
    {3.0946847596688070401106639e-261, "3094684759668807", -260},
    {1.7407494760131367426430879e+254, "17407494760131367", 255},
    {8.1418094311335904729572230e+61, "814180943113359", 62},
    {1.6103227146739348425619314e-81, "16103227146739348", -80},
    {4.4309686928913383483886719e+09, "4430968692891338", 10},
    {9.4702563882616577493080214e-280, "9470256388261658", -279},
    {4.7356781164001951247192522e+173, "4735678116400195", 174},
    {1.6577450088642803835102737e+227, "16577450088642804", 228},
    {1.3424946090742800252109967e-298, "134249460907428", -297},
    {1.9696913517182849293520655e-14, "1969691351718285", -13},
    {2.3455507884563374822767455e+102, "23455507884563375", 103},
    {4.0012138103744170760763165e-266, "4001213810374417", -265},
    {2.6134160092223910631323046e+76, "2613416009222391", 77},
    {1.1668741057125037282850112e+151, "11668741057125037", 152},
    {7.0306277028101074218750000e+11, "7030627702810107", 12},
    {3.4272684218828400906213182e-141, "342726842188284", -140},
    {1.2529828202111360914951402e-292, "1252982820211136", -291},
    {4.7542889253124496121287351e+218, "475428892531245", 219},
    {2.2938031627667730356362523e-212, "2293803162766773", -211},
    {1.1939086726658293962731402e+37, "11939086726658294", 38},
    {2.4944338531961312135302656e-19, "2494433853196131", -18},
    {3.5125941319370020809092824e-244, "3512594131937002", -243},
    {4.0583343569866637102547884e-46, "4058334356986664", -45},
    {1.8754964975175682476589972e+185, "18754964975175682", 186},
    {3.6633360330557084299355045e-58, "36633360330557084", -57},
    {2.5869350692053840540161213e-158, "2586935069205384", -157},
    {2.4778684954026471319059857e+139, "2477868495402647", 140},
    {8.3776420581961696896768728e+292, "837764205819617", 293},
    {2.8144615539485420427612824e+184, "2814461553948542", 185},
    {1.2169801969570993322060854e-28, "12169801969570993", -27},
    {4.0395278069080799236309812e-304, "403952780690808", -303},
    {7.3984613452883009710397436e-109, "7398461345288301", -108},
    {1.0304029949288974399325420e+143, "10304029949288974", 144},
    {4.5662823876013441649809399e+239, "4566282387601344", 240},
    {4.0269302501483896832000000e+19, "402693025014839", 20},
    {2.1320654285780988875024833e-144, "2132065428578099", -143},
    {2.2796985797074335704946135e+167, "22796985797074336", 168},
    {1.1768209061950664242704964e-265, "11768209061950664", -264},
    {2.8720661193719963286326050e-132, "28720661193719963", -131},
    {2.4527690512349552616478237e-47, "24527690512349553", -46},
    {4.0066633292917151204068755e+173, "4006663329291715", 174},
    {1.2345716829822064752875121e+01, "12345716829822065", 2},
    {3.2721887132878161581733678e+288, "3272188713287816", 289},
    {2.2831445289702905756353309e+157, "22831445289702906", 158},
    {2.3862432959962253664620792e-146, "23862432959962254", -145},
    {3.1086653656724009256354611e-270, "3108665365672401", -269},
    {3.8262846316066531032774246e-146, "3826284631606653", -145},
    {1.1525878662489888958246659e+144, "11525878662489889", 145},
    {2.5727955828133237690784006e-169, "25727955828133238", -168},
    {3.3646421549330253333873039e+109, "33646421549330253", 110},
    {2.5376362268418694026607174e-125, "25376362268418694", -124},
    {1.6292978536315720816674002e+02, "1629297853631572", 3},
    {8.5022418207363609984634603e-102, "8502241820736361", -101},
    {1.3470289898170735757634891e-171, "13470289898170736", -170},
    {3.7797705527608480325876606e+158, "3779770552760848", 159},
    {4.8144964932444290972560747e-81, "4814496493244429", -80},
    {3.8212561106068628109559565e-186, "3821256110606863", -185},
    {1.9543554779858414133533097e+168, "19543554779858414", 169},
    {7.9811874484712201944002364e-175, "798118744847122", -174},
    {1.0204524333146621517203522e+213, "10204524333146622", 214},
    {9.6003369882244002450967238e-202, "96003369882244", -201},
    {1.6958594795892601311399471e-07, "169585947958926", -6},
    {3.8446247326111898336943487e+66, "384462473261119", 67},
    {2.6045451480089567513685071e+62, "26045451480089568", 63},
    {4.6713549066366019812536032e-271, "4671354906636602", -270},
    {2.4506497164491602847073186e-222, "24506497164491603", -221},
    {3.6470467079490757449329747e-193, "36470467079490757", -192},
    {1.9043721968598830836614385e-115, "1904372196859883", -114},
    {2.4068446777288147725422396e+91, "24068446777288148", 92},
    {1.0204440076247633211507926e-37, "10204440076247633", -36},
    {2.7268936351433956549625230e-236, "27268936351433957", -235},
    {8.1322163884561251877805051e-94, "8132216388456125", -93},
    {5.1989397800687096527122200e+138, "51989397800687097", 139},
    {2.5196420306572612418590784e-175, "25196420306572612", -174},
    {4.1297537884888656605398334e+106, "4129753788488866", 107},
    {3.7318320805452533428028158e-57, "37318320805452533", -56},
    {1.3004240514225456863641739e+06, "13004240514225457", 7},
    {1.7297430741345165314397081e+125, "17297430741345165", 126},
    {1.2645769291289136756540550e+65, "12645769291289137", 66},
    {6.4179197274848473154592461e-308, "6417919727484847", -307},
    {2.9179378235432962866711960e-260, "29179378235432963", -259},
    {1.9700275521442125848127509e-91, "19700275521442126", -90},
    {1.1165723895306619703646475e-213, "1116572389530662", -212},
    {1.9094193043508757707000017e+231, "19094193043508758", 232},
    {1.1869738747640293811610111e+223, "11869738747640294", 224},
    {1.0719886599467610112000000e+19, "1071988659946761", 20},
    {1.3828500794841875619549703e+93, "13828500794841876", 94},
    {2.0933356937742000933130853e-260, "20933356937742", -259},
    {3.1611210186073015751454830e+176, "31611210186073016", 177},
    {2.8414302159788180648466805e-233, "2841430215978818", -232},
    {8.6159815961891503831484857e-218, "861598159618915", -217},
    {1.0541700692439039003852800e+23, "10541700692439039", 24},
    {8.6525470260516399691212239e-244, "865254702605164", -243},
    {1.3041666106830347118556531e+108, "13041666106830347", 109},
    {5.3589203592548766673233105e+53, "5358920359254877", 54},
    {1.7611865155730851047810329e-55, "1761186515573085", -54},
    {5.4023983260812653905245635e-20, "54023983260812654", -19},
    {9.4540753751022169609408682e-235, "9454075375102217", -234},
    {5.6663844522757079549160031e+76, "5666384452275708", 77},
    {3.8523804850665829084570195e-147, "3852380485066583", -146},
    {3.9652862113129861462584354e+145, "3965286211312986", 146},
    {1.6237414456977535389751066e+94, "16237414456977535", 95},
    {1.6730553299356741371783538e-301, "16730553299356741", -300},
    {2.4236366223846982978147542e+270, "24236366223846983", 271},
    {1.7741042336788318397736737e+42, "17741042336788318", 43},
    {8.3178506668506210102082704e+70, "8317850666850621", 71},
    {1.8789891723171854391694069e+06, "18789891723171854", 7},
    {1.5609149308740250512746239e-85, "1560914930874025", -84},
    {6.5417340597386123454230201e+199, "6541734059738612", 200},
    {5.5067660304171709929021276e-274, "5506766030417171", -273},
    {8.1310214205538184131437038e+126, "8131021420553818", 127},
    {1.0015101885562530119262118e+97, "1001510188556253", 98},
    {8.6963330688189501592807865e-23, "869633306881895", -22},
    {4.9210393831022036255157183e-212, "4921039383102204", -211},
    {4.7654283620947594029363608e+266, "47654283620947594", 267},
    {2.4708913548912977897912714e+49, "2470891354891298", 50},
    {2.4046716782376140800000000e+17, "2404671678237614", 18},
    {6.7185669810160906250000000e+13, "6718566981016091", 14},
    {5.3256585900413899935429101e-152, "532565859004139", -151},
    {2.2419547690755982534882654e+231, "22419547690755983", 232},
    {2.0408529810110703493184809e+192, "20408529810110703", 193},
    {2.4509415768525285173126890e-97, "24509415768525285", -96},
    {5.4504089721128429565446698e-08, "5450408972112843", -7},
    {1.7305208517166281516504685e+44, "17305208517166282", 45},
    {2.6123334474844246340271081e-222, "26123334474844246", -221},
    {8.0853421429865937177861535e+205, "8085342142986594", 206},
    {7.6072624644788061639968900e-120, "7607262464478806", -119},
    {3.4797384940634888375110170e+43, "3479738494063489", 44},
    {8.3971692168773004615432064e-59, "83971692168773", -58},
    {5.0749174367761304656224771e+301, "507491743677613", 302},
    {9.3285146681407768776602811e-202, "9328514668140777", -201},
    {2.8812737337774540195196072e-85, "2881273733777454", -84},
    {2.5437893348479950769263258e+243, "2543789334847995", 244},
    {1.0769266003370702095133089e+143, "10769266003370702", 144},
    {3.3252859435838768526737943e+204, "3325285943583877", 205},
    {7.1477113310277305733665057e-300, "714771133102773", -299},
    {9.8980370228524993148225869e-52, "98980370228525", -51},
    {4.6566262403110342029750273e-285, "4656626240311034", -284},
    {7.6596644407073607172808736e-100, "7659664440707361", -99},
    {1.0995107741736046855928669e-254, "10995107741736047", -253},
    {1.4753667565152851436105062e+277, "14753667565152851", 278},
    {1.2021284805702362764677218e+28, "12021284805702363", 29},
    {8.0671475658368104617472169e+198, "806714756583681", 199},
    {1.3731751567482733749776791e-07, "13731751567482734", -6},
    {9.9841819446278910769464669e-73, "9984181944627891", -72},
    {9.4227824109783549414274133e-194, "9422782410978355", -193},
    {1.5336914967120861015145937e-114, "15336914967120861", -113},
    {4.2687603230303328936636680e-188, "4268760323030333", -187},
    {5.5603419830931066417616233e-171, "5560341983093107", -170},
    {3.4562197202483804846273755e+34, "34562197202483805", 35},
    {3.1115323893039421875000000e+13, "3111532389303942", 14},
    {7.4670894725782365834708231e+216, "7467089472578237", 217},
    {1.2143769022940994551692669e-180, "12143769022940995", -179},
    {6.4361095116784347299198286e+123, "6436109511678435", 124},
    {3.6966285202562505799008129e-37, "36966285202562506", -36},
    {7.4291193519374715039831323e-195, "7429119351937472", -194},
    {1.2265149493251968720900832e-279, "12265149493251969", -278},
    {1.2860682985167432651345680e+199, "12860682985167433", 200},
    {6.1583226851078089362341768e+249, "6158322685107809", 250},
    {1.6617783552499465478271141e-160, "16617783552499465", -159},
    {3.7001980132296638598464115e-206, "3700198013229664", -205},
    {6.4865895714612933470684793e+103, "6486589571461293", 104},
    {9.1731676821818908790309652e-176, "9173167682181891", -175},
    {3.0775332776626719677426341e+184, "3077533277662672", 185},
    {2.9200352056533313388544000e+22, "29200352056533313", 23},
    {1.7024190238213690153958491e-71, "1702419023821369", -70},
    {1.9548011602051945647809478e-12, "19548011602051946", -11},
    {4.1340531271879367488100755e+279, "4134053127187937", 280},
    {2.4767671363267214340676701e-203, "24767671363267214", -202},
    {7.8468335027061335551575393e-199, "7846833502706134", -198},
    {1.4471157838941613322088365e+82, "14471157838941613", 83},
    {1.9345773885535388104509477e-281, "19345773885535388", -280},
    {9.7947167636363575001289677e+297, "9794716763636358", 298},
    {3.5663469561124803271278421e+293, "356634695611248", 294},
    {4.2483056546008013780343290e-108, "4248305654600801", -107},
    {1.0959343606499553591031492e-180, "10959343606499554", -179},
    {6.6550814232769434482646201e-25, "6655081423276943", -24},
    {2.0724508714796897529627829e+272, "20724508714796898", 273},
    {9.0364729793876882776792110e+36, "9036472979387688", 37},
    {5.7863720159642445903011979e+136, "5786372015964245", 137},
    {4.6138348617850391414754509e+26, "4613834861785039", 27},
    {1.0612860347503682126419357e+212, "10612860347503682", 213},
    {5.6911775750041757946175801e+231, "5691177575004176", 232},
    {2.6047475835042098250868414e+46, "260474758350421", 47},
    {4.8584460434445245380795069e+235, "48584460434445245", 236},
    {4.9542516802067563245268036e+251, "4954251680206756", 252},
    {6.2929187608896782309013524e-45, "6292918760889678", -44},
    {8.8268037559161735879531577e-68, "8826803755916174", -67},
    {1.3408727393048224295042548e+214, "13408727393048224", 215},
    {1.4505954256433016200088135e-155, "14505954256433016", -154},
    {1.3465947647455086543706362e-209, "13465947647455087", -208},
    {1.8171428014410912749894909e+281, "18171428014410913", 282},
    {1.2092751941651438851849831e-20, "12092751941651439", -19},
    {1.4258779237911987023093566e+91, "14258779237911987", 92},
    {9.4539051504952344786700942e-94, "9453905150495234", -93},
    {5.7599235816554846449068123e-93, "5759923581655485", -92},
    {1.5041129228283748114251835e-46, "15041129228283748", -45},
    {4.9884497052266360304171697e+54, "4988449705226636", 55},
    {8.8620817588970156948605036e-216, "8862081758897016", -215},
    {5.6095506249612147843451728e+285, "5609550624961215", 286},
    {6.7683548351082698409107022e-126, "676835483510827", -125},
    {1.6631345498960971553457777e+202, "16631345498960972", 203},
    {3.2042409000048745641239276e-95, "32042409000048746", -94},
    {7.4038858858621329169262691e-191, "7403885885862133", -190},
    {4.8626806513597671195044581e-275, "4862680651359767", -274},
    {4.5282916577774107905939914e-16, "4528291657777411", -15},
    {3.1189788732800744235280009e-298, "31189788732800744", -297},
    {1.7253224632182598561860885e-98, "172532246321826", -97},
    {5.5561376157086328868391183e+306, "5556137615708633", 307},
    {2.3816399218458786362945495e+303, "23816399218458786", 304},
    {3.4580464925152890247924704e-301, "3458046492515289", -300},
    {1.7627517766391193899620808e+65, "17627517766391194", 66},
    {6.3121309537312759651336555e-196, "6312130953731276", -195},
    {1.8290867156811480807942109e-171, "1829086715681148", -170},
    {5.3854122679691507738345472e+26, "5385412267969151", 27},
    {4.4433668368683141701255133e+220, "4443366836868314", 221},
    {1.6625669283645605443047970e-154, "16625669283645605", -153},
    {1.7990791681072407026708494e-288, "17990791681072407", -287},
    {1.6292382365496721748007689e+123, "16292382365496722", 124},
    {1.8051837510283867163900818e+214, "18051837510283867", 215},
    {9.5447227716289150185119638e-21, "9544722771628915", -20},
    {5.9628441112155058272207599e-134, "5962844111215506", -133},
    {5.4130573320635132805360813e+127, "5413057332063513", 128},
    {9.8513017200289942797888421e+127, "9851301720028994", 128},
    {5.9313696964893620069738176e+196, "5931369696489362", 197},
    {1.5617789231095330164389183e+189, "1561778923109533", 190},
    {1.2346174555939224801494344e-161, "12346174555939225", -160},
    {3.8789056172875297454372654e+214, "38789056172875297", 215},
    {2.3631769587629268204170814e+118, "2363176958762927", 119},
    {4.6281020494408688014449217e+305, "4628102049440869", 306},
    {2.0367542029004104399744985e-122, "20367542029004104", -121},
    {4.3258179463666562698705616e-57, "4325817946366656", -56},
    {5.0552563621612566133925106e+41, "5055256362161257", 42},
    {2.9069448594214454202470429e-219, "29069448594214454", -218},
    {5.8584087639317269401523765e-269, "5858408763931727", -268},
    {2.4055321851640045962056862e-177, "24055321851640046", -176},
    {1.0750747646573669274990217e+223, "10750747646573669", 224},
    {1.2232754500657779113502850e+32, "1223275450065778", 33},
    {4.5073567759524475297547263e-81, "45073567759524475", -80},
    {5.7196173237822458608725038e+278, "5719617323782246", 279},
    {7.2494474647111494813276097e+178, "724944746471115", 179},
    {1.4040135036120826016122312e-111, "14040135036120826", -110},
    {6.1404444754113776258184448e-221, "6140444475411378", -220},
    {2.5848024078183144976303510e+99, "25848024078183145", 100},
    {2.0026215190503882861697213e+60, "20026215190503883", 61},
    {1.0055222411849912511060948e-117, "10055222411849913", -116},
    {2.3106458107157038806012005e-177, "2310645810715704", -176},
    {7.8550058852057898913678589e-11, "785500588520579", -10},
    {5.1206889199799022036980257e-176, "5120688919979902", -175},
    {1.3322499742076564003849786e-50, "13322499742076564", -49},
    {6.2171149282912928000000000e+16, "6217114928291293", 17},
    {2.3014882568776160408836302e+148, "2301488256877616", 149},
    {2.6478679297257463185079054e+225, "26478679297257463", 226},
    {6.1984984022430760890380946e+284, "6198498402243076", 285},
    {8.8717938705497593357899583e+41, "887179387054976", 42},
    {5.1163400819018460197185050e+02, "5116340081901846", 3},
    {1.1688025464149773873813655e-302, "11688025464149774", -301},
    {5.1594922382343710808623220e-39, "5159492238234371", -38},
    {2.0028569591015068338749440e+24, "20028569591015068", 25},
    {9.2898476735827385758696566e-61, "9289847673582739", -60},
    {3.7816167868575764527343206e+26, "37816167868575765", 27},
    {7.6359740403309525611582145e+123, "7635974040330953", 124},
    {1.3031538215124008371699707e-68, "13031538215124008", -67},
    {2.4910702613932336080028288e+235, "24910702613932336", 236},
    {9.8488236356358710103013635e-49, "9848823635635871", -48},
    {1.0499611152642221445496773e-01, "10499611152642221", 0},
    {1.2795855621200764423701419e-250, "12795855621200764", -249},
    {2.8767056254116896503507765e-245, "28767056254116897", -244},
    {1.6576579547817536140905814e-272, "16576579547817536", -271},
    {7.8929634942213458685263085e+52, "7892963494221346", 53},
    {1.4743619650008747558476351e+290, "14743619650008748", 291},
    {3.1105685008991655615684380e-02, "31105685008991656", -1},
    {2.4834062834512538675593696e+107, "2483406283451254", 108},
    {1.8779714858483261757630465e-281, "18779714858483262", -280},
    {6.5786122613603978802011898e+142, "6578612261360398", 143},
    {2.4529951481047161112774720e-79, "2452995148104716", -78},
    {1.1240844716922530431816671e-170, "1124084471692253", -169},
    {5.3960223080674620222980119e-129, "5396022308067462", -128},
    {4.0590457032661781980619234e+93, "4059045703266178", 94},
    {7.7626885917952489329283705e-292, "7762688591795249", -291},
    {1.0214913678770503706534233e-48, "10214913678770504", -47},
    {1.4884593544376457438118634e-93, "14884593544376457", -92},
    {9.4355131877681703076073914e-301, "943551318776817", -300},
    {6.3274665566271042895803235e-152, "6327466556627104", -151},
    {5.2504429290910383369312809e-42, "52504429290910383", -41},
    {1.4194819908289438917219663e-110, "1419481990828944", -109},
    {2.6124410414514939039164021e-41, "2612441041451494", -40},
    {3.9248552913351544039578808e+59, "39248552913351544", 60},
    {4.5476642190716972190804193e-169, "4547664219071697", -168},
    {4.4257147111127580332192153e+165, "4425714711112758", 166},
    {4.5663617645440818611783596e-296, "4566361764544082", -295},
    {1.3324459887390947585011180e+278, "13324459887390948", 279},
    {2.8025560518308766186237335e+06, "28025560518308766", 7},
    {3.1896885887739483538299976e+258, "31896885887739484", 259},
    {4.1336523798674970279019461e-213, "4133652379867497", -212},
    {4.3318988100848843153748898e+133, "43318988100848843", 134},
    {1.0074911346266185326679446e-189, "10074911346266185", -188},
    {3.1914308814474686933840611e+241, "31914308814474687", 242},
    {9.6336277124465367264426153e+247, "9633627712446537", 248},
    {7.1210506162211556487958482e+122, "7121050616221156", 123},
    {9.3067843322475140442859060e-08, "9306784332247514", -7},
    {1.7332699174552859967300590e-207, "1733269917455286", -206},
    {7.5259087798128743989517233e+167, "7525908779812874", 168},
    {2.2783405392037456714640210e+179, "22783405392037457", 180},
    {4.5322809922376715218037015e-193, "4532280992237672", -192},
    {2.7522864370238709121824246e+190, "2752286437023871", 191},
    {9.2453090589269363599803574e-29, "9245309058926936", -28},
    {1.1638494401172272129296622e+191, "11638494401172272", 192},
    {2.1043132587479845543108666e-127, "21043132587479846", -126},
    {1.0467227406985236984112814e+147, "10467227406985237", 148},
    {9.1296394615931884401955273e-107, "9129639461593188", -106},
    {2.9345664953308308111352382e+182, "2934566495330831", 183},
    {1.7965613135113351058634571e+196, "17965613135113351", 197},
    {3.7960655372878389215384286e+259, "3796065537287839", 260},
    {9.9315599033810853070466381e+44, "9931559903381085", 45},
    {2.6960298226644301002932251e+32, "269602982266443", 33},
    {1.1947111986887441675744745e-45, "11947111986887442", -44},
    {1.7312095824809795417160716e+289, "17312095824809795", 290},
    {3.2198258285928619175635384e-103, "3219825828592862", -102},
    {1.4944603151149019703127712e-25, "1494460315114902", -24},
    {1.0084490308211042514471164e-215, "10084490308211043", -214},
    {2.8187649074493024320145626e-269, "28187649074493024", -268},
    {2.1975920098941858535637976e+92, "21975920098941859", 93},
    {1.2754866883596859110868644e+236, "1275486688359686", 237},
    {3.4857091872656791880926217e+135, "3485709187265679", 136},
    {7.4655561383347295890445301e-169, "746555613833473", -168},
    {1.1695150305049957266906342e-99, "11695150305049957", -98},
    {2.6510876374913598510008658e-06, "265108763749136", -5},
    {1.8351182482742384333504012e-203, "18351182482742384", -202},
    {1.3361018785334354784219663e+31, "13361018785334355", 32},
    {2.0730032270610884957756535e+178, "20730032270610885", 179},
    {4.2459388106980445964977071e+251, "42459388106980446", 252},
    {1.3277977444145126640385583e-125, "13277977444145127", -124},
    {5.9465652756720372108201910e-25, "5946565275672037", -24},
    {2.1626790809573521722448714e+247, "21626790809573522", 248},
    {1.4297044149784805969179029e+139, "14297044149784806", 140},
    {1.4012109459878878903129104e-49, "14012109459878879", -48},
    {2.1672405484820304217455251e+236, "21672405484820304", 237},
    {1.4890346683859830454737159e-128, "1489034668385983", -127},
    {3.9182819353492048128239966e-134, "3918281935349205", -133},
    {5.0179352835421326227221530e-211, "5017935283542133", -210},
    {2.6224294235198235438174123e-161, "26224294235198235", -160},
    {6.7954494450331368411826294e-144, "6795449445033137", -143},
    {3.8883859256242349604221483e+270, "3888385925624235", 271},
    {9.7940250814584908800000000e+17, "9794025081458491", 18},
    {1.1600600036902972415675020e+101, "11600600036902972", 102},
    {2.2910191845862582173389425e+51, "22910191845862582", 52},
    {4.8826419437170592943944932e-08, "4882641943717059", -7},
    {1.6812970774390788977634518e+228, "1681297077439079", 229},
    {7.6067495669674180663782146e+277, "7606749566967418", 278},
    {1.8982659965165128664846936e-128, "18982659965165129", -127},
    {7.7589653626181452838854468e-56, "7758965362618145", -55},
    {1.0807651249540696646499848e+169, "10807651249540697", 170},
    {2.8546004561555558425986874e-123, "2854600456155556", -122},
    {1.5890369092586768088799913e-276, "15890369092586768", -275},
    {5.7535695437726637314100815e+237, "5753569543772664", 238},
    {1.1443073573549515393838669e-203, "11443073573549515", -202},
    {6.0579340676218408115333828e-285, "6057934067621841", -284},
    {6.2762753180909759969375736e+134, "6276275318090976", 135},
    {1.9993303018056025990837607e+47, "19993303018056026", 48},
    {2.5562415247950162242893795e-67, "25562415247950162", -66},
    {1.7169233324698230284956629e-37, "1716923332469823", -36},
    {2.4121524563327296139925613e+161, "24121524563327296", 162},
    {1.0121969733893343324098060e+174, "10121969733893343", 175},
    {8.2544017375465753259567119e+164, "8254401737546575", 165},
    {2.3145654104256053667877469e+245, "23145654104256054", 246},
    {5.8265784833159301755288557e-61, "582657848331593", -60},
    {2.6330503121055447787548575e-211, "26330503121055448", -210},
    {1.2164056940968110744985209e+238, "12164056940968111", 239},
    {1.3954633409950144438509824e+222, "13954633409950144", 223},
    {8.8317916930127561021552407e-208, "8831791693012756", -207},
    {5.7627505198827131197730508e-57, "5762750519882713", -56},
    {4.6919800101731065083884321e-121, "46919800101731065", -120},
    {2.6597882189873475257044265e-253, "26597882189873475", -252},
    {2.2425731844515338789392274e-142, "2242573184451534", -141},
    {5.6986621631691880021020468e-21, "5698662163169188", -20},
    {9.9963338821598559138060875e+219, "9996333882159856", 220},
    {3.9338152670435069959373756e+224, "3933815267043507", 225},
    {1.1474388220527801483988711e+189, "11474388220527801", 190},
    {6.0613571871781750706442829e+125, "6061357187178175", 126},
    {4.0826379949957786334832262e+300, "40826379949957786", 301},
    {3.6805007972299071153844363e+78, "3680500797229907", 79},
    {3.7352580699785755835818816e+50, "37352580699785756", 51},
    {2.6242843374546733402974538e-147, "26242843374546733", -146},
    {4.1078543006420325408174318e-128, "41078543006420325", -127},
    {4.3940238675775623748465536e+269, "43940238675775624", 270},
    {2.6088986635041663221976880e-308, "26088986635041663", -307},
    {3.2537424834577357018139455e-170, "32537424834577357", -169},
    {1.1335809777190749147740604e-275, "11335809777190749", -274},
    {3.7419211195770811653358060e-109, "3741921119577081", -108},
    {1.5192595399769463151954735e+88, "15192595399769463", 89},
    {3.2201236494873434521600000e+20, "32201236494873435", 21},
    {1.0796511517943833748262678e-93, "10796511517943834", -92},
    {4.140191060