//===========================================================================
//  CVS Information:                                                         
//                                                                           
//     $RCSfile: ai_cg.cpp,v $  $Revision: 1.3 $  $State: Exp $ 
//     $Author: llee $  $Date: 2001/10/18 15:44:32 $ 
//     $Locker:  $ 
//---------------------------------------------------------------------------
//                                                                           
// DESCRIPTION                                                               
//                                                                           
//---------------------------------------------------------------------------
//                                                                           
// LICENSE AGREEMENT                                                         
// Copyright 1997, University of Notre Dame.
// Authors: Andrew Lumsdaine, Lie-Quan Lee
//
// This file is part of the Iterative Template Library
//
// You should have received a copy of the License Agreement for the
// Iterative Template Library along with the software;  see the
// file LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN  46556.
//
// Permission to modify the code and to distribute modified code is
// granted, provided the text of this NOTICE is retained, a notice that
// the code was modified is included with the above COPYRIGHT NOTICE and
// with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
// file is distributed with the modified code.
//
// LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
// By way of example, but not limitation, Licensor MAKES NO
// REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
// OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
// OR OTHER RIGHTS.
//---------------------------------------------------------------------------
//                                                                           
// REVISION HISTORY:                                                         
//                                                                           
// $Log: ai_cg.cpp,v $
// Revision 1.3  2001/10/18 15:44:32  llee
// compile and test for examples
//
// Revision 1.2  2000/11/14 20:14:44  llee1
// *** empty log message ***
//
// Revision 1.1  2000/11/14 16:36:15  llee1
// *** empty log message ***
//
// Revision 1.3  2000/07/27 15:50:22  llee1
// for vc++
//
// Revision 1.2  2000/07/27 04:39:19  llee1
// *** empty log message ***
//
// Revision 1.1  2000/07/26 21:49:52  llee1
// change file extension from .cc to .cpp
//
// Revision 1.2  2000/07/17 15:44:06  llee1
// *** empty log message ***
//
// Revision 1.1  2000/07/14 20:39:02  llee1
// *** empty log message ***
//
//===========================================================================

#include "mtl/matrix.h"
#include "mtl/mtl.h"
#include "mtl/utils.h"

#include <itl/interface/mtl.h>
#include "itl/preconditioner/approximate_inverse.h"
#include "itl/krylov/cg.h"

#include "laplacian.h"

#include "parser.h"

using namespace mtl;
using namespace itl;

typedef  double Type;

//begin
typedef matrix< Type, 
		//                symmetric<upper>, 
                rectangle<>,
	        array< compressed<> >, 
                column_major >::type Matrix;
//end

int main (int argc, char* argv[]) 
{
  using std::cout;
  using std::endl;
  using std::parser;

  if ( argc == 1 ) {
    cout << argv[0] << " --help will get your the usage of flags." << endl;
  }

  parser myparser(argc, argv);

  myparser.register_flag("--mx", 1, "number of points in x axis in the mesh");
  myparser.register_flag("--my", 1, "number of points in y axis in the mesh");
  myparser.register_flag("--max_it", 1, "maxmal iteration allowed");  
  myparser.register_flag("--ksp_atol", 1, "Absolute tolerance in KSP iteration");  
  myparser.register_flag("--ksp_rtol", 1, "Relative tolerance in KSP iteration");  
  myparser.register_flag("--ai_iter", 1, "Number of iteration should be used in AI");  
  myparser.register_flag("--ai_threshold", 1, "The thershold should be used in AI");  

  myparser.help();
  int mx, my, max_it, ai_iter;
  double ksp_atol, ksp_rtol, ai_threshold;
 
  myparser.get("--mx", mx, 16);
  myparser.get("--my", my, mx);
  myparser.get("--max_it", max_it, 60);
  myparser.get("--ksp_atol", ksp_atol);
  myparser.get("--ksp_rtol", ksp_rtol, 1.0e-6);
  myparser.get("--ai_iter", ai_iter, mx);
  myparser.get("--ai_threshold", ai_threshold, 1.0e-3);
 
  const int N = mx * my;

  Matrix A(N, N);
  generate_laplacian_2D(A, mx, my);

  dense1D<Type> x(A.nrows(), Type(0));
  dense1D<Type> b(A.ncols());
  for (dense1D<Type>::iterator i=b.begin(); i!=b.end(); i++)
    *i = 1;

  approximate_inverse<Matrix> precond(A, ai_iter, ai_threshold);
  approximate_inverse<Matrix>::Precond p = precond();
  //identity_preconditioner p;

  noisy_iteration<double> iter(b, max_it, ksp_rtol, ksp_atol);

  //gmres algorithm
  cg(A, x, b, p, iter);
  //end

  //verify the result
  dense1D<Type> b1(A.ncols());
  itl::mult(A, x, b1);
  itl::add(b1, itl::scaled(b, -1.), b1);

  cout << " True Residual: " << itl::two_norm(b1) << endl;

  return 0;
  }


