//===========================================================================
//  CVS Information:                                                         
//                                                                           
//     $RCSfile: gmres1.cpp,v $  $Revision: 1.4 $  $State: Exp $ 
//     $Author: llee $  $Date: 2001/10/18 14:08:31 $ 
//     $Locker:  $ 
//---------------------------------------------------------------------------
//                                                                           
// DESCRIPTION                                                               
//                                                                           
//---------------------------------------------------------------------------
//                                                                           
// LICENSE AGREEMENT                                                         
// Copyright 1997-2001, University of Notre Dame.
// Authors: Andrew Lumsdaine, Lie-Quan Lee
//
// This file is part of the Iterative Template Library
//
// You should have received a copy of the License Agreement for the
// Iterative Template Library along with the software;  see the
// file LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN  46556.
//
// Permission to modify the code and to distribute modified code is
// granted, provided the text of this NOTICE is retained, a notice that
// the code was modified is included with the above COPYRIGHT NOTICE and
// with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
// file is distributed with the modified code.
//
// LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
// By way of example, but not limitation, Licensor MAKES NO
// REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
// OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
// OR OTHER RIGHTS.
//---------------------------------------------------------------------------
//                                                                           
// REVISION HISTORY:                                                         
//                                                                           
// $Log: gmres1.cpp,v $
// Revision 1.4  2001/10/18 14:08:31  llee
// re-organize the directory structures
//
// Revision 1.3  2001/07/05 22:28:57  llee1
// gcc 3.0 fix
//
// Revision 1.2  2000/07/27 04:39:18  llee1
// *** empty log message ***
//
// Revision 1.1  2000/07/26 21:49:17  llee1
// change file extension from .cc to .cpp
//
// Revision 1.4  2000/07/26 21:34:12  llee1
// *** empty log message ***
//
// Revision 1.3  2000/07/19 19:58:00  llee1
// *** empty log message ***
//
// Revision 1.2  2000/07/17 15:44:04  llee1
// *** empty log message ***
//
//                                                                           
//===========================================================================
#include <mtl/matrix.h>
#include <mtl/mtl.h>
#include <mtl/utils.h>

#include <itl/interface/mtl.h>
#include <itl/krylov/gmres.h>
#include <itl/preconditioner/ssor.h>

/*
  In thsi example, we show how to use GMRES(m) algorithm, the output should be:

iteration 0: resid 0.166147 normb = 0.166147
iteration 1: resid 0.00485013 normb = 0.166147
iteration 2: resid 0.000414322 normb = 0.166147
iteration 3: resid 3.06249e-06 normb = 0.166147
iteration 4: resid 6.13254e-17 normb = 0.166147
iteration 4: resid 2.97233e-17 normb = 0.166147
finished! error code = 0
4 iterations
2.97233e-17 is actual final residual.
1.78897e-16 is actual relative tolerance achieved.
Relative tol: 1e-06  Absolute tol: 0
     6      2      0      0      3   x          0.157123  =       1
     4     11      0      6      0   x         0.0223611  =       1
     0      7     18      0      9   x         0.0447696  =       1
     0      0     10     24     12   x         0.0209227  =       1
     0      0     13      0    100   x        0.00417995  =       1
*/

typedef  double Type;

typedef mtl::matrix< Type, mtl::rectangle<>, 
	         mtl::compressed<int, mtl::external> , mtl::row_major >::type
               Matrix;

int main (int argc, char* argv[]) 
{
  using namespace itl;
 
  using std::cout;
  using std::endl;

  int max_iter = 50;

  std::vector<double> val(14);
  std::vector<int> ind(14);
  std::vector<int> ptr(6);
//   Matrix A(5, 5);
  //  A(0, 0) = 6.0;
  val[0] = 6.0;
  ptr[0] = 0;
  ind[0] = 0;
  //   A(0, 1) = 2.0;
  val[1] = 2.0;
  ind[1] = 1;
//   A(0, 4) = 3.0;
  val[2] = 3.0;
  ind[2] = 4;
  ptr[1] = 3;
//   A(1, 0) = 4.0;
  val[3] = 4.0;
  ind[3] = 0;
//   A(1, 1) = 11.0;
  val[4] = 11;
  ind[4] = 1;
//   A(1, 3) = 6.0;
  val[5] = 6.0;
  ind[5] = 3;
  ptr[2] = 6;
//   A(2, 1) = 7.0;
  val[6] = 7.0;
  ind[6] = 1;
//   A(2, 2) = 18.0;
  val[7] = 18;
  ind[7] = 2;
//   A(2, 4) = 9.0;
  val[8] = 9;
  ind[8] = 4;
  ptr[3] = 9;
//   A(3, 2) = 10.;
  val[9] = 10;
  ind[9] = 2;
//   A(3, 3) = 24.;
  val[10] = 24;
  ind[10] = 3;
//   A(3, 4) = 12.;
  val[11] = 12;
  ind[11] = 4;
  ptr[4] = 12;
//   A(4, 2) = 13.; 
  val[12] = 13;
  ind[12] = 2;
//   A(4, 4) = 100.;
  val[13] = 100;
  ind[13] = 4;
  ptr[5] = 14;
  
  Matrix A(5,5,14,&val[0],&ptr[0],&ind[0]);

  mtl::dense1D<Type> x(A.nrows(), Type(0));
  mtl::dense1D<Type> b(A.ncols());
  for (mtl::dense1D<Type>::iterator k=b.begin(); k!=b.end(); ++k)
    *k = 1.;

  //SSOR preconditioner
  SSOR<Matrix> precond(A);
  SSOR<Matrix>::Precond p = precond();

  mtl::dense1D<Type> b2(A.ncols());
  //gmres needs the preconditioned b to pass into iter object.
  itl::solve(p, b, b2); 
  //iteration
  noisy_iteration<double> iter(b2, max_iter, 1e-6);

  int restart = 10;

  //gmres algorithm
  gmres(A, x, b, p, restart, iter); //restart constant: 10

  //verify the result
  mtl::dense1D<Type> b1(A.ncols());
  itl::mult(A, x, b1);
  itl::add(b1, itl::scaled(b, -1.), b1);

  if ( itl::two_norm(b1) < 1.e-6 ) { //output
    for (int i=0; i<5; i++) {
      for (int j=0; j<5; j++) {
	cout.width(6);
	//!!! it is not recommended to use A(i,j) for large sparse matrices
	cout << A(i, j) << " ";
      }
      cout << "  x  ";
      cout.width(16);
      cout << x[i] << "  =  ";
      cout.width(6);
      cout << b[i] << endl;
    }
  } else {
    cout << "Residual " << iter.resid() << endl;
  }

  return 0;
}


