//===========================================================================
//  CVS Information:                                                         
//                                                                           
//     $RCSfile: gmres.cpp,v $  $Revision: 1.3 $  $State: Exp $ 
//     $Author: llee $  $Date: 2001/10/18 14:08:31 $ 
//     $Locker:  $ 
//---------------------------------------------------------------------------
//                                                                           
// DESCRIPTION                                                               
//                                                                           
//---------------------------------------------------------------------------
//                                                                           
// LICENSE AGREEMENT                                                         
// Copyright 1997, University of Notre Dame.
// Authors: Andrew Lumsdaine, Lie-Quan Lee
//
// This file is part of the Iterative Template Library
//
// You should have received a copy of the License Agreement for the
// Iterative Template Library along with the software;  see the
// file LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN  46556.
//
// Permission to modify the code and to distribute modified code is
// granted, provided the text of this NOTICE is retained, a notice that
// the code was modified is included with the above COPYRIGHT NOTICE and
// with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
// file is distributed with the modified code.
//
// LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
// By way of example, but not limitation, Licensor MAKES NO
// REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
// OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
// OR OTHER RIGHTS.
//---------------------------------------------------------------------------
//                                                                           
// REVISION HISTORY:                                                         
//                                                                           
// $Log: gmres.cpp,v $
// Revision 1.3  2001/10/18 14:08:31  llee
// re-organize the directory structures
//
// Revision 1.2  2000/07/27 04:39:16  llee1
// *** empty log message ***
//
// Revision 1.1  2000/07/26 21:49:15  llee1
// change file extension from .cc to .cpp
//
// Revision 1.3  2000/07/19 19:58:00  llee1
// *** empty log message ***
//
// Revision 1.2  2000/07/17 15:44:04  llee1
// *** empty log message ***
//
//                                                                           
//===========================================================================
#include "mtl/matrix.h"
#include "mtl/mtl.h"
#include "mtl/utils.h"

#include <itl/interface/mtl.h>
#include "itl/preconditioner/ssor.h"
#include "itl/krylov/gmres.h"
/*
  In thsi example, we show how to use GMRES(m) algorithm, the output should be:

iteration 0: resid 0.159609 normb = 0.159609
iteration 1: resid 0.00573065 normb = 0.159609
iteration 2: resid 0.000596876 normb = 0.159609
iteration 3: resid 1.80028e-05 normb = 0.159609
iteration 4: resid 3.01759e-21 normb = 0.159609
iteration 4: resid 4.64946e-17 normb = 0.159609
finished! error code = 0
4 iterations
4.64946e-17 is actual final residual.
2.91302e-16 is actual relative tolerance achieved.
Relative tol: 1e-06  Absolute tol: 0
     6      2      0      0      3   x          0.148804  =       1
     4     11      0      6      0   x         0.0271099  =       1
     0      7     18      0      9   x         0.0361866  =       1
     0      0     10     24     12   x         0.0177627  =       1
     0      0     13      0     30   x         0.0176525  =       1
*/

using namespace mtl;

typedef  double Type;

//begin
typedef matrix< Type, 
                rectangle<>, 
	        array< compressed<> >, 
                row_major >::type Matrix;
//end

int main (int , char* []) 
{
  using namespace itl;
  using std::cout;
  using std::endl;

  int max_iter = 50;
  //begin
  Matrix A(5, 5);
  //end
  A(0, 0) = 6.0;
  A(0, 1) = 2.0;
  A(0, 4) = 3.0;
  A(1, 0) = 4.0;
  A(1, 1) = 11.0;
  A(1, 3) = 6.0;
  A(2, 1) = 7.0;
  A(2, 2) = 18.0;
  A(2, 4) = 9.0;
  A(3, 2) = 10.;
  A(3, 3) = 24.;
  A(3, 4) = 12.;
  A(4, 2) = 13.; 
  A(4, 4) = 30 ;

  dense1D<Type> x(A.nrows(), Type(0));
  dense1D<Type> b(A.ncols());
  for (dense1D<Type>::iterator i=b.begin(); i!=b.end(); i++)
    *i = 1.;
  //begin
  //SSOR preconditioner
  SSOR<Matrix> precond(A);
  SSOR<Matrix>::Precond p = precond();

  dense1D<Type> b2(A.ncols());
  itl::solve(p, b, b2); //gmres needs teh preconditioned b to pass into iter object.
  //iteration
  noisy_iteration<double> iter(b2, max_iter, 1e-6);
  int restart = 10;

  typedef dense1D<Type> Vec;

  classical_gram_schmidt<Vec> orth(restart, size(x));
  //gmres algorithm
  gmres(A, x, b, p, restart, iter, orth); //restart constant: 10
  //end

  //verify the result
  dense1D<Type> b1(A.ncols());
  itl::mult(A, x, b1);
  itl::add(itl::scaled(b, -1.), b1);

  if ( itl::two_norm(b1) < 1.e-6) { //output
    for (int i=0; i<5; i++) {
      for (int j=0; j<5; j++) {
	cout.width(6);
	//!!! it is not recommended to use A(i,j) for large sparse matrices
	cout << A(i, j) << " ";
      }
      cout << "  x  ";
      cout.width(16);
      cout << x[i] << "  =  ";
      cout.width(6);
      cout << b[i] << endl;
    }
  } else {
    cout << "Residual " << iter.resid() << endl;
  }

  return 0;
  }


