//==========================================================================
//       CVS Information:
//
//	     $RCSfile: parser.cpp,v $  $Revision: 1.4 $  $State: Exp $ 	
//	     $Author: llee $  $Date: 2001/10/26 16:33:55 $ 	
//	     $Locker:  $ 	
//---------------------------------------------------------------------------
//	                                                                     
//	 DESCRIPTION                                                         
//	                                                                     
//---------------------------------------------------------------------------
//
//       LICENSE AGREEMENT
//=======================================================================
// Copyright (C) 1997-2001
// Authors: Andrew Lumsdaine <lums@osl.iu.edu> 
//          Lie-Quan Lee     <llee@osl.iu.edu>
//
// This file is part of the Iterative Template Library
//
// You should have received a copy of the License Agreement for the
// Iterative Template Library along with the software;  see the
// file LICENSE.  
//
// Permission to modify the code and to distribute modified code is
// granted, provided the text of this NOTICE is retained, a notice that
// the code was modified is included with the above COPYRIGHT NOTICE and
// with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
// file is distributed with the modified code.
//
// LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
// By way of example, but not limitation, Licensor MAKES NO
// REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
// OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
// OR OTHER RIGHTS.
//=======================================================================
//---------------------------------------------------------------------------
//	                                                                   
//	 REVISION HISTORY:                                                 
//	                                                                   
//	 $Log: parser.cpp,v $
//	 Revision 1.4  2001/10/26 16:33:55  llee
//	 *** empty log message ***
//	
//	 Revision 1.3  2001/10/24 22:07:22  llee
//	 *** empty log message ***
//	
//	 Revision 1.2  2001/10/18 21:37:05  llee
//	 *** empty log message ***
//	
//	 Revision 1.1  2000/07/26 21:49:33  llee1
//	 change file extension from .cc to .cpp
//	
//	 Revision 1.2  2000/07/18 14:30:44  llee1
//	 *** empty log message ***
//	
//	 Revision 1.2  2000/07/17 15:44:06  llee1
//	 *** empty log message ***
//		
//	                                                                    
//===========================================================================
#include <iostream>
#include "parser.h"

#include <stdio.h>
#if defined ITL_NO_SSTREAM
#include <stdio.h>
#else
#include <sstream>
#endif

#include <assert.h>

namespace std {

  parser::parser(int argc, char* argv[], const string& delim) {
    string raw_data;
    //copy argv to raw_data;
    for (int i=1; i<argc; ++i) {
      raw_data += argv[i];
      raw_data += " ";
    }

    remove_special_character(raw_data, '=');
    split(delim, raw_data);
  }
  
  void parser::register_flag (const string& flag, int i, const string& mesg) {
    registers[flag] = i;
    messages[flag] = mesg;
  }

  bool parser::flags_coexist (const string& flag1, const string& flag2, 
			      bool coexist) {
    bool found1 = seg.find(flag1) != seg.end();
    bool found2 = seg.find(flag2) != seg.end();
    
    if ( coexist ) {
      if ( found1 != found2 ) {
	cerr << flag1 << " and " << flag2 
	     << " must be both in the comand line. Exiting ..." << endl;
	assert(false);
      }
    } else if ( found1 && found2 ) {
      cerr << flag1 << " and " << flag2 
	   << " cannot be both in the comand line. Exiting ..." << endl;
      //exit
      assert(false);
    }

    return found1 && found2 != coexist;
  }
  
#if defined ITL_NO_SSTREAM
  void parser::get(const string& flag, double& value, double d) { 
    if ( registers.find(flag) == registers.end() ) {
      cerr << flag << " is not registered! Exiting..." << endl;
      assert(false);
    }

    map<string,string>::iterator i = seg.find(flag);

    if ( i == seg.end() ) 
      value = d;
    else {
      if ( registers[flag] == 0 )
	value = ! d; //not the default
      else if ((*i).second.size()==0) {
	cerr << flag << " requires a value." << endl 
	     << " Please provid it right after the flag with whitespace " 
	     << endl << " or equal sign between flag and value." << endl;
	assert(false);
      } else {
	sscanf((*i).second.data(), "%lf", &value);
      }	  
    }
  }

  void parser::get(const string& flag, int& value, int d) { 
    if ( registers.find(flag) == registers.end() ) {
      cerr << flag << " is not registered! Exiting..." << endl;
      assert(false);
    }

    map<string,string>::iterator i = seg.find(flag);

    if ( i == seg.end() ) 
      value = d;
    else {
      if ( registers[flag] == 0 )
	value = ! d; //not the default
      else if ((*i).second.size()==0) {
	cerr << flag << " requires a value." << endl 
	     << " Please provid it right after the flag with whitespace " 
	     << endl << " or equal sign between flag and value." << endl;
	assert(false);
      } else {
	sscanf((*i).second.data(), "%d", &value);
      }	  
    }
  }

#else
  template <typename T>
  void parser::get(const string& flag, T& value, const T& d) { 
    if ( registers.find(flag) == registers.end() ) {
      cerr << flag << " is not registered! Exiting..." << endl;
      assert(false);
    }

    map<string,string>::iterator i = seg.find(flag);

    if ( i == seg.end() ) 
      value = d;
    else {
      if ( registers[flag] == 0 )
	value = ! d; //not the default
      else if ((*i).second.size()==0) {
	cerr << flag << " requires a value." << endl 
	     << " Please provid it right after the flag with whitespace " << endl
	     << " or equal sign between flag and value." << endl;
	assert(false);
      } else {
	istringstream iss((*i).second);
	iss >> value;
	
	if (iss.fail()) {
	  cerr << flag << " has an invalid value. Exit..." << endl;
	  //exit
	  assert(false);
	}
      }	  
    }
  }
#endif

  void parser::get(const string& flag, string& value, const string& d) { 
    if ( registers.find(flag) == registers.end() ) {
      cerr << flag << " is not registered! Exiting..." << endl;
      assert(false);
    }

    map<string,string>::iterator i = seg.find(flag);

    if ( i == seg.end() ) 
      value = d;
    else {
      if ( registers[flag] == 0  || (*i).second.size()==0) {
	cerr << flag << " requires a value." << endl 
	     << " Please provid it right after the flag with whitespace " 
	     << endl << " or equal sign between flag and value." << endl;
	assert(false);
      } else {
	char data[256];
	assert(i->second.size()<256);
	sscanf((*i).second.data(), "%s", data);
	value = data;
      }	  
    }
  }

  void parser::help() {
    string h("--help");
    bool found = seg.find(h) != seg.end();
    if ( found ) {
      cout << " Usage of flags: " << endl;
      for ( map<string,int>::iterator i = registers.begin();
	    i != registers.end(); ++i) {
	cout << (*i).first;
	if ( (*i).second ) 
	  cout << " <value> ";
	cout << ": " << messages[(*i).first] << endl;
      }
    }
  }
  
  void parser::remove_special_character(string& raw_data, char c) {
    char * temp = const_cast<char*>(raw_data.c_str());
    for (string::size_type i=0; i<raw_data.size(); ++i)
      if ( temp[i] == c )
	temp[i] = ' ';
  }
  
  void parser::split(const string& delim, const string& raw_data) {

    string::size_type pos = 0;
    bool cond = true;
    
    while ( cond ) {
      string::size_type prev = pos+2;
      pos = raw_data.find(delim, prev);
      
      if ( pos == string::npos ) {
	pos = raw_data.size();
	cond = false;
      }

      string::size_type s = pos - prev + 2;
      
      halve( raw_data.substr(prev-2, s) );
    }
  }
  
  //str is one unit include a flag and its (possible) value(s)
  //it is not allowed that str is started " "
  void parser::halve(const string& str) {
    string::size_type pos = str.find(" ");
    if ( pos == string::npos )
      seg[str] = "";
    else
      seg[str.substr(0,pos)] = str.substr(pos, str.size());
  }

#if !defined ITL_NO_SSTREAM
  template 
  void parser::get(const string& flag, int& value, const int& d);
  template 
  void parser::get(const string& flag, double& value, const double& d);
  template
  void parser::get(const string& flag, bool& value, const bool& d);
#endif  
}

