dnl -*- shell-script -*-


AC_DEFUN(AC_ITL_TRY_COMPILE,
[cat > conftest.cpp <<EOF
ifelse(AC_LANG, [FORTRAN77],
[      program main
[$2]
      end],
[dnl This sometimes fails to find confdefs.h, for some reason.
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
[$1]
int main() {
[$2]
; return 0; }
])EOF
ac_mtl_compile='${CXX} -c $CFLAGS conftest.cpp 1>&5'
if AC_TRY_EVAL(ac_mtl_compile); then
  ifelse([$3], , :, [rm -rf conftest*
  $3])
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.cpp >&AC_FD_CC
ifelse([$4], , , [  rm -rf conftest*
  $4
])dnl
fi
rm -f conftest*])

dnl

define([AC_ITL_NO_SSTREAM],[
AC_MSG_CHECKING([if compiler has standard sstream])
cat > conftest.cc <<EOF
#include <sstream>

int main()
{
  return 0;
}
EOF
$CXX $CXXFLAGS -o conftest conftest.cc 1>&5 2>&1

if test -s conftest && (./conftest; exit) 2>/dev/null; then
    AC_MSG_RESULT([yes])
else
    AC_DEFINE(ITL_NO_SSTREAM)
    AC_MSG_RESULT([no])
fi
/bin/rm -rf conftest* ti_files
])dns

define([AC_GGCL_HAVE_STD_ALLOCATOR],[
AC_MSG_CHECKING([if compiler has standard allocator])
cat > conftest.cc <<EOF
#include <vector>
#include <memory>

int main()
{
  std::vector<int, std::allocator<int> > a(10);
}
EOF
$CXX $CXXFLAGS -o conftest conftest.cc 1>&5 2>&1

if test -s conftest && (./conftest; exit) 2>/dev/null; then
    AC_MSG_RESULT([yes])
else
    AC_DEFINE(__STL_USE_OLD_SGI_ALLOCATOR)
    AC_MSG_RESULT([no, use old sgi allocator])
fi
/bin/rm -rf conftest* ti_files
])dns

define([AC_GGCL_HAVE_LIMITS],[

AC_MSG_CHECKING([if there is standard limits header])
cat > conftest.cc <<EOF

#include <limits>

int main()
{
    int a = std::numeric_limits<int>::max();
}
EOF
$CXX $CXXFLAGS -o conftest conftest.cc 1>&5 2>&1

if test -s conftest && (./conftest; exit) 2>/dev/null; then
    AC_DEFINE(_GGCL_HAVE_LIMITS)
    AC_MSG_RESULT([yes])
else
    AC_MSG_RESULT([no])
fi
/bin/rm -rf conftest* ti_files

])dnl

define([AC_GGCL_HAVE_FUNCTION_CONST_TEMPATE_PARAMS], [

AC_MSG_CHECKING([if compiler has constant template parameters])
cat > conftest.cc <<EOF

#include <iostream.h>

struct A {};

template <class T>
void
print(const T& a) {
}

template <class T>
void
print(T& a) {
}


int main ()
{
  A b;
  const A a = b;
  print(a);
  print(b);

}
EOF
$CXX $CXXFLAGS -o conftest conftest.cc 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    AC_DEFINE(_GGCL_HAVE_CONST_TEMPLATE_PARAMS)
    AC_MSG_RESULT([yes])
else
    AC_MSG_RESULT([no])
fi
/bin/rm -rf conftest* ti_files
])dnl


dnl
define([LSC_CXX_TEMPLATE_REPOSITORY],[
#
# See if the compiler makes template repository directories
# Warning: this is a really screwy example! -JMS
#

AC_MSG_CHECKING([for template repository directory])
mkdir conf_tmp_$$
cd conf_tmp_$$
cat > foo.h <<EOF
template <class T>
class foo {
public:
  foo(T yow) : data(yow) { yow.member(3); };
  void member(int i);
private:
  T data;
};

class bar {
public:
  bar(int i) { data = i; };
  void member(int j) { data = data * j; };

private:
  int data;
};
EOF

cat > other.cc <<EOF
#include "foo.h"

void
some_other_function(void)
{
  foo<bar> var1(6);
  foo< foo<bar> > var2(var1);
}
EOF

cat > main.cc <<EOF
#include "foo.h"

void some_other_function(void);

template <class T>
void
foo<T>::member(int i)
{
  i += 2;
}

int
main(int argc, char *argv[])
{
  foo<bar> var1(6);
  foo< foo<bar> > var2(var1);

  some_other_function();
  return 0;
}
EOF

$CXX -c main.cc >/dev/null 2>/dev/null
$CXX -c other.cc >/dev/null 2>/dev/null
rm -rf *.h *.cc *.o

for file in `ls`
do
    if test "$file" != "." -a "$file" != ".."; then
	# Is it a directory?
	if test -d "$file"; then
            TEMPLATE_DIR="$file $TEMPLATE_DIR"

	# Or is it a file?
	else
	    name="`echo $file | cut -d. -f1`"

	    temp_mask=
	    if test "$name" = "main" -o "$name" = "other"; then
		temp_mask="`echo $file | cut -d. -f2`"
		if test "$TEMPLATE_FILEMASK" = ""; then
		   TEMPLATE_FILEMASK="$temp_mask";
		elif test "`echo $TEMPLATE_FILEMASK | grep $temp_mask`" = ""; then
		   TEMPLATE_FILEMASK="$TEMPLATE_FILEMASK $temp_mask"
		fi
	    fi
	fi
    fi
done
if test "$TEMPLATE_FILEMASK" != ""; then
    temp_mask=
    for mask in $TEMPLATE_FILEMASK
    do
	temp_mask="*.$mask $temp_mask"
    done
    TEMPLATE_FILEMASK=$temp_mask
fi
TEMPLATE_REP="$TEMPLATE_DIR $TEMPLATE_FILEMASK"

if test "$TEMPLATE_REP" != ""; then
    AC_MSG_RESULT([$TEMPLATE_REP])
else
    AC_MSG_RESULT([not used])
fi
cd ..
rm -rf conf_tmp_$$
AC_SUBST(TEMPLATE_REP)dnl
])dnl

define([LSC_CHECK_CXX_EXCEPTIONS],[
#
# Check to see if this compiler can handle exceptions 
#

AC_MSG_CHECKING([for throw/catch])
AC_TRY_COMPILE(, int i=1; throw(i);, have_excep=yes, have_excep=no)
if test "$have_excep" = "yes"; then
    LSC_CXX_HAS_EXCEPTIONS=1
    AC_MSG_RESULT([yes])
else
    LSC_CXX_HAS_EXCEPTIONS=0
    AC_MSG_RESULT([no])
fi])dnl

define([LSC_CHECK_SIGNAL_TYPE],[
#
# Do we have BSD or SYSV style signals?
# (or something that we haven't thought of yet?)
#

SAVE_CXXFLAGS=$CXXFLAGS
CXXFLAGS="$SIGNAL_FLAGS $CXXFLAGS"

AC_MSG_CHECKING([for signal declaration])
AC_TRY_COMPILE(#include<signal.h>
, 
void handler(int sig, int code, struct sigcontext *scp, char *addr);
signal(1, handler);, bsd_signal="yes", bsd_signal="no")
if test "$bsd_signal" = "yes"; then
    LSC_SIGNAL_TYPE="BSD"
    AC_MSG_RESULT([BSD])
else

#
# Sanity check.  Make sure that it is SYSV
#

    AC_TRY_COMPILE(#include<signal.h>
, 
void handler(int sig);
signal(1, handler);, sysv_signal="yes", sysv_signal="no")
    if test "$sysv_signal" = "yes"; then
	LSC_SIGNAL_TYPE="SYSV"
        AC_MSG_RESULT([SYSV])
    else
        AC_MSG_RESULT([not found])
        AC_MSG_ERROR([cannot determine if signals are BSD/SYSV])
        exit
    fi
fi
CXXFLAGS=$SAVE_CXXFLAGS
])dnl


#
# Several macro for various compilers
#
AC_DEFUN(AC_PROG_CXX_MWERKS,
[AC_CACHE_CHECK(whether we are using Metrowerks Codewarrior C++, MWERKS_CXX,
[cat > conftest.c <<EOF
#ifdef __MWERKS__
  yes;
#endif
EOF
if AC_TRY_COMMAND(${CXX} -E conftest.c) | egrep yes >/dev/null 2>&1; then
  MWERKS_CXX=yes
  compiler=mwerks
else
  MWERKS_CXX=no
fi])])


AC_DEFUN(AC_PROG_CXX_MSVCPP,
[AC_CACHE_CHECK(whether we are using Visual C++, MSVCPP_CXX,
[cat > conftest.c <<EOF
#if defined(_MSC_VER) && !defined(__MWERKS__) && !defined(__ICL)
  yes;
#endif
EOF
if AC_TRY_COMMAND(${CXX} -E conftest.c) | egrep yes >/dev/null 2>&1; then
  MSVCPP_CXX=yes
  compiler=msvcpp
else
  MSVCPP_CXX=no
fi])])

AC_DEFUN(AC_PROG_CXX_SGICC,
[AC_CACHE_CHECK(whether we are using SGI MIPSpro C++, SGI_CXX,
[cat > conftest.c <<EOF
# if defined(__sgi) && !defined(__GNUC__)
  yes;
#endif
EOF
if AC_TRY_COMMAND(${CXX} -E conftest.c) | egrep yes >/dev/null 2>&1; then
  SGI_CXX=yes
  compiler=sgicc
else
  SGI_CXX=no
fi])])


AC_DEFUN(AC_PROG_CXX_SUNCC,
[AC_CACHE_CHECK(whether we are using Sun C++, SUN_CXX,
[cat > conftest.c <<EOF
# if defined(__SUNPRO_CC) 
  yes;
#endif
EOF
if AC_TRY_COMMAND(${CXX} -E conftest.c) | egrep yes >/dev/null 2>&1; then
  SUN_CXX=yes
  compiler=suncc
else
  SUN_CXX=no
fi])])


AC_DEFUN(AC_PROG_CXX_INTELCC,
[AC_CACHE_CHECK(whether we are using Intel C++, INTEL_CXX,
[cat > conftest.c <<EOF
# if defined(__ICL)
  yes;
#endif
EOF
if AC_TRY_COMMAND(${CXX} -E conftest.c) | egrep yes >/dev/null 2>&1; then
  INTEL_CXX=yes
  compiler=intelcc
else
  INTEL_CXX=no
fi])])

AC_DEFUN(AC_PROG_CXX_KAICC,
[AC_CACHE_CHECK(whether we are using KAI C++, KAI_CXX,
[cat > conftest.c <<EOF
# if defined(__KCC)
  yes;
#endif
EOF
if AC_TRY_COMMAND(${CXX} -E conftest.c) | egrep yes >/dev/null 2>&1; then
  KAI_CXX=yes
  compiler=kaicc
else
  KAI_CXX=no
fi])])



#
# Don't know if it is a good idea to overwrite CXXFLAGS
#

AC_DEFUN(AC_BZ_SET_COMPILER,
  [cxxwith=`echo $1 | sed -e 's/ /@/'`
   case "$cxxwith" in
     *:*@*)                 # Full initialization syntax
       CXX=`echo "$cxxwith" | sed  -n -e 's/.*:\(.*\)@.*/\1/p'`
       CXXFLAGS=`echo "$cxxwith" | sed  -n -e 's/.*:.*@\(.*\)/\1/p'`
     ;;
     *:*)                   # Simple initialization syntax
       CXX=`echo "$cxxwith" | sed  -n -e 's/.*:\(.*\)/\1/p'`
       CXXFLAGS=$3
     ;;
     *)                     # Default values
       CXX=$2
       CXXFLAGS=$3
     ;;
   esac])


