// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/v1/config/client/client_config.proto

package client

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import google_protobuf1 "github.com/gogo/protobuf/types"
import istio_mixer_v1 "istio.io/api/mixer/v1"

import strconv "strconv"

import strings "strings"
import reflect "reflect"
import sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Describes the policy.
type NetworkFailPolicy_FailPolicy int32

const (
	// If network connection fails, request is allowed and delivered to the
	// service.
	FAIL_OPEN NetworkFailPolicy_FailPolicy = 0
	// If network connection fails, request is rejected.
	FAIL_CLOSE NetworkFailPolicy_FailPolicy = 1
)

var NetworkFailPolicy_FailPolicy_name = map[int32]string{
	0: "FAIL_OPEN",
	1: "FAIL_CLOSE",
}
var NetworkFailPolicy_FailPolicy_value = map[string]int32{
	"FAIL_OPEN":  0,
	"FAIL_CLOSE": 1,
}

func (NetworkFailPolicy_FailPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorClientConfig, []int{0, 0}
}

// Specifies the behavior when the client is unable to connect to Mixer.
type NetworkFailPolicy struct {
	// Specifies the behavior when the client is unable to connect to Mixer.
	Policy NetworkFailPolicy_FailPolicy `protobuf:"varint,1,opt,name=policy,proto3,enum=istio.mixer.v1.config.client.NetworkFailPolicy_FailPolicy" json:"policy,omitempty"`
}

func (m *NetworkFailPolicy) Reset()                    { *m = NetworkFailPolicy{} }
func (*NetworkFailPolicy) ProtoMessage()               {}
func (*NetworkFailPolicy) Descriptor() ([]byte, []int) { return fileDescriptorClientConfig, []int{0} }

// Defines the per-service client configuration.
type ServiceConfig struct {
	// If true, do not call Mixer Check.
	DisableCheckCalls bool `protobuf:"varint,1,opt,name=disable_check_calls,json=disableCheckCalls,proto3" json:"disable_check_calls,omitempty"`
	// If true, do not call Mixer Report.
	DisableReportCalls bool `protobuf:"varint,2,opt,name=disable_report_calls,json=disableReportCalls,proto3" json:"disable_report_calls,omitempty"`
	// Send these attributes to Mixer in both Check and Report. This
	// typically includes the "destination.service" attribute.
	// In case of a per-route override, per-route attributes take precedence
	// over the attributes supplied in the client configuration.
	MixerAttributes *istio_mixer_v1.Attributes `protobuf:"bytes,3,opt,name=mixer_attributes,json=mixerAttributes" json:"mixer_attributes,omitempty"`
	// HTTP API specifications to generate API attributes.
	HttpApiSpec []*HTTPAPISpec `protobuf:"bytes,4,rep,name=http_api_spec,json=httpApiSpec" json:"http_api_spec,omitempty"`
	// Quota specifications to generate quota requirements.
	QuotaSpec []*QuotaSpec `protobuf:"bytes,5,rep,name=quota_spec,json=quotaSpec" json:"quota_spec,omitempty"`
	// Specifies the behavior when the client is unable to connect to Mixer.
	// This is the service-level policy. It overrides
	// [mesh-level
	// policy][istio.mixer.v1.config.client.TransportConfig.network_fail_policy].
	NetworkFailPolicy *NetworkFailPolicy `protobuf:"bytes,7,opt,name=network_fail_policy,json=networkFailPolicy" json:"network_fail_policy,omitempty"`
	// Default attributes to forward to upstream. This typically
	// includes the "source.ip" and "source.uid" attributes.
	// In case of a per-route override, per-route attributes take precedence
	// over the attributes supplied in the client configuration.
	//
	// Forwarded attributes take precedence over the static Mixer attributes.
	// The full order of application is as follows:
	// 1. static Mixer attributes from the filter config;
	// 2. static Mixer attributes from the route config;
	// 3. forwarded attributes from the source filter config (if any);
	// 4. forwarded attributes from the source route config (if any);
	// 5. derived attributes from the request metadata.
	ForwardAttributes *istio_mixer_v1.Attributes `protobuf:"bytes,8,opt,name=forward_attributes,json=forwardAttributes" json:"forward_attributes,omitempty"`
}

func (m *ServiceConfig) Reset()                    { *m = ServiceConfig{} }
func (*ServiceConfig) ProtoMessage()               {}
func (*ServiceConfig) Descriptor() ([]byte, []int) { return fileDescriptorClientConfig, []int{1} }

// Defines the transport config on how to call Mixer.
type TransportConfig struct {
	// The flag to disable check cache.
	DisableCheckCache bool `protobuf:"varint,1,opt,name=disable_check_cache,json=disableCheckCache,proto3" json:"disable_check_cache,omitempty"`
	// The flag to disable quota cache.
	DisableQuotaCache bool `protobuf:"varint,2,opt,name=disable_quota_cache,json=disableQuotaCache,proto3" json:"disable_quota_cache,omitempty"`
	// The flag to disable report batch.
	DisableReportBatch bool `protobuf:"varint,3,opt,name=disable_report_batch,json=disableReportBatch,proto3" json:"disable_report_batch,omitempty"`
	// Specifies the behavior when the client is unable to connect to Mixer.
	// This is the mesh level policy. The default value for policy is FAIL_OPEN.
	NetworkFailPolicy *NetworkFailPolicy `protobuf:"bytes,4,opt,name=network_fail_policy,json=networkFailPolicy" json:"network_fail_policy,omitempty"`
	// Specify refresh interval to write mixer client statistics to Envoy share
	// memory. If not specified, the interval is 10 seconds.
	StatsUpdateInterval *google_protobuf1.Duration `protobuf:"bytes,5,opt,name=stats_update_interval,json=statsUpdateInterval" json:"stats_update_interval,omitempty"`
	// Name of the cluster that will forward check calls to a pool of mixer
	// servers. Defaults to "mixer_server". By using different names for
	// checkCluster and reportCluster, it is possible to have one set of
	// mixer servers handle check calls, while another set of mixer servers
	// handle report calls.
	//
	// NOTE: Any value other than the default "mixer_server" will require the
	// Istio Grafana dashboards to be reconfigured to use the new name.
	CheckCluster string `protobuf:"bytes,6,opt,name=check_cluster,json=checkCluster,proto3" json:"check_cluster,omitempty"`
	// Name of the cluster that will forward report calls to a pool of mixer
	// servers. Defaults to "mixer_server". By using different names for
	// checkCluster and reportCluster, it is possible to have one set of
	// mixer servers handle check calls, while another set of mixer servers
	// handle report calls.
	//
	// NOTE: Any value other than the default "mixer_server" will require the
	// Istio Grafana dashboards to be reconfigured to use the new name.
	ReportCluster string `protobuf:"bytes,7,opt,name=report_cluster,json=reportCluster,proto3" json:"report_cluster,omitempty"`
	// Default attributes to forward to mixer upstream. This typically
	// includes the "source.ip" and "source.uid" attributes. These
	// attributes are consumed by the proxy in front of mixer.
	AttributesForMixerProxy *istio_mixer_v1.Attributes `protobuf:"bytes,8,opt,name=attributes_for_mixer_proxy,json=attributesForMixerProxy" json:"attributes_for_mixer_proxy,omitempty"`
}

func (m *TransportConfig) Reset()                    { *m = TransportConfig{} }
func (*TransportConfig) ProtoMessage()               {}
func (*TransportConfig) Descriptor() ([]byte, []int) { return fileDescriptorClientConfig, []int{2} }

// Defines the client config for HTTP.
type HttpClientConfig struct {
	// The transport config.
	Transport *TransportConfig `protobuf:"bytes,1,opt,name=transport" json:"transport,omitempty"`
	// Map of control configuration indexed by destination.service. This
	// is used to support per-service configuration for cases where a
	// mixerclient serves multiple services.
	ServiceConfigs map[string]*ServiceConfig `protobuf:"bytes,2,rep,name=service_configs,json=serviceConfigs" json:"service_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// Default destination service name if none was specified in the
	// client request.
	DefaultDestinationService string `protobuf:"bytes,3,opt,name=default_destination_service,json=defaultDestinationService,proto3" json:"default_destination_service,omitempty"`
	// Default attributes to send to Mixer in both Check and
	// Report. This typically includes "destination.ip" and
	// "destination.uid" attributes.
	MixerAttributes *istio_mixer_v1.Attributes `protobuf:"bytes,4,opt,name=mixer_attributes,json=mixerAttributes" json:"mixer_attributes,omitempty"`
	// Default attributes to forward to upstream. This typically
	// includes the "source.ip" and "source.uid" attributes.
	ForwardAttributes *istio_mixer_v1.Attributes `protobuf:"bytes,5,opt,name=forward_attributes,json=forwardAttributes" json:"forward_attributes,omitempty"`
}

func (m *HttpClientConfig) Reset()                    { *m = HttpClientConfig{} }
func (*HttpClientConfig) ProtoMessage()               {}
func (*HttpClientConfig) Descriptor() ([]byte, []int) { return fileDescriptorClientConfig, []int{3} }

// Defines the client config for TCP.
type TcpClientConfig struct {
	// The transport config.
	Transport *TransportConfig `protobuf:"bytes,1,opt,name=transport" json:"transport,omitempty"`
	// Default attributes to send to Mixer in both Check and
	// Report. This typically includes "destination.ip" and
	// "destination.uid" attributes.
	MixerAttributes *istio_mixer_v1.Attributes `protobuf:"bytes,2,opt,name=mixer_attributes,json=mixerAttributes" json:"mixer_attributes,omitempty"`
	// If set to true, disables mixer check calls.
	DisableCheckCalls bool `protobuf:"varint,3,opt,name=disable_check_calls,json=disableCheckCalls,proto3" json:"disable_check_calls,omitempty"`
	// If set to true, disables mixer check calls.
	DisableReportCalls bool `protobuf:"varint,4,opt,name=disable_report_calls,json=disableReportCalls,proto3" json:"disable_report_calls,omitempty"`
	// Quota specifications to generate quota requirements.
	// It applies on the new TCP connections.
	ConnectionQuotaSpec *QuotaSpec `protobuf:"bytes,5,opt,name=connection_quota_spec,json=connectionQuotaSpec" json:"connection_quota_spec,omitempty"`
	// Specify report interval to send periodical reports for long TCP
	// connections. If not specified, the interval is 10 seconds. This interval
	// should not be less than 1 second, otherwise it will be reset to 1 second.
	ReportInterval *google_protobuf1.Duration `protobuf:"bytes,6,opt,name=report_interval,json=reportInterval" json:"report_interval,omitempty"`
}

func (m *TcpClientConfig) Reset()                    { *m = TcpClientConfig{} }
func (*TcpClientConfig) ProtoMessage()               {}
func (*TcpClientConfig) Descriptor() ([]byte, []int) { return fileDescriptorClientConfig, []int{4} }

func init() {
	proto.RegisterType((*NetworkFailPolicy)(nil), "istio.mixer.v1.config.client.NetworkFailPolicy")
	proto.RegisterType((*ServiceConfig)(nil), "istio.mixer.v1.config.client.ServiceConfig")
	proto.RegisterType((*TransportConfig)(nil), "istio.mixer.v1.config.client.TransportConfig")
	proto.RegisterType((*HttpClientConfig)(nil), "istio.mixer.v1.config.client.HttpClientConfig")
	proto.RegisterType((*TcpClientConfig)(nil), "istio.mixer.v1.config.client.TcpClientConfig")
	proto.RegisterEnum("istio.mixer.v1.config.client.NetworkFailPolicy_FailPolicy", NetworkFailPolicy_FailPolicy_name, NetworkFailPolicy_FailPolicy_value)
}
func (x NetworkFailPolicy_FailPolicy) String() string {
	s, ok := NetworkFailPolicy_FailPolicy_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (m *NetworkFailPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkFailPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Policy != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.Policy))
	}
	return i, nil
}

func (m *ServiceConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DisableCheckCalls {
		dAtA[i] = 0x8
		i++
		if m.DisableCheckCalls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.DisableReportCalls {
		dAtA[i] = 0x10
		i++
		if m.DisableReportCalls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.MixerAttributes != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.MixerAttributes.Size()))
		n1, err := m.MixerAttributes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.HttpApiSpec) > 0 {
		for _, msg := range m.HttpApiSpec {
			dAtA[i] = 0x22
			i++
			i = encodeVarintClientConfig(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.QuotaSpec) > 0 {
		for _, msg := range m.QuotaSpec {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintClientConfig(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.NetworkFailPolicy != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.NetworkFailPolicy.Size()))
		n2, err := m.NetworkFailPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.ForwardAttributes != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.ForwardAttributes.Size()))
		n3, err := m.ForwardAttributes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}

func (m *TransportConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransportConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DisableCheckCache {
		dAtA[i] = 0x8
		i++
		if m.DisableCheckCache {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.DisableQuotaCache {
		dAtA[i] = 0x10
		i++
		if m.DisableQuotaCache {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.DisableReportBatch {
		dAtA[i] = 0x18
		i++
		if m.DisableReportBatch {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.NetworkFailPolicy != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.NetworkFailPolicy.Size()))
		n4, err := m.NetworkFailPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.StatsUpdateInterval != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.StatsUpdateInterval.Size()))
		n5, err := m.StatsUpdateInterval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.CheckCluster) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(len(m.CheckCluster)))
		i += copy(dAtA[i:], m.CheckCluster)
	}
	if len(m.ReportCluster) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(len(m.ReportCluster)))
		i += copy(dAtA[i:], m.ReportCluster)
	}
	if m.AttributesForMixerProxy != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.AttributesForMixerProxy.Size()))
		n6, err := m.AttributesForMixerProxy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}

func (m *HttpClientConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpClientConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Transport != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.Transport.Size()))
		n7, err := m.Transport.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if len(m.ServiceConfigs) > 0 {
		for k, _ := range m.ServiceConfigs {
			dAtA[i] = 0x12
			i++
			v := m.ServiceConfigs[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovClientConfig(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovClientConfig(uint64(len(k))) + msgSize
			i = encodeVarintClientConfig(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintClientConfig(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintClientConfig(dAtA, i, uint64(v.Size()))
				n8, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n8
			}
		}
	}
	if len(m.DefaultDestinationService) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(len(m.DefaultDestinationService)))
		i += copy(dAtA[i:], m.DefaultDestinationService)
	}
	if m.MixerAttributes != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.MixerAttributes.Size()))
		n9, err := m.MixerAttributes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.ForwardAttributes != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.ForwardAttributes.Size()))
		n10, err := m.ForwardAttributes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}

func (m *TcpClientConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TcpClientConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Transport != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.Transport.Size()))
		n11, err := m.Transport.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.MixerAttributes != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.MixerAttributes.Size()))
		n12, err := m.MixerAttributes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.DisableCheckCalls {
		dAtA[i] = 0x18
		i++
		if m.DisableCheckCalls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.DisableReportCalls {
		dAtA[i] = 0x20
		i++
		if m.DisableReportCalls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ConnectionQuotaSpec != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.ConnectionQuotaSpec.Size()))
		n13, err := m.ConnectionQuotaSpec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.ReportInterval != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintClientConfig(dAtA, i, uint64(m.ReportInterval.Size()))
		n14, err := m.ReportInterval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}

func encodeVarintClientConfig(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *NetworkFailPolicy) Size() (n int) {
	var l int
	_ = l
	if m.Policy != 0 {
		n += 1 + sovClientConfig(uint64(m.Policy))
	}
	return n
}

func (m *ServiceConfig) Size() (n int) {
	var l int
	_ = l
	if m.DisableCheckCalls {
		n += 2
	}
	if m.DisableReportCalls {
		n += 2
	}
	if m.MixerAttributes != nil {
		l = m.MixerAttributes.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if len(m.HttpApiSpec) > 0 {
		for _, e := range m.HttpApiSpec {
			l = e.Size()
			n += 1 + l + sovClientConfig(uint64(l))
		}
	}
	if len(m.QuotaSpec) > 0 {
		for _, e := range m.QuotaSpec {
			l = e.Size()
			n += 1 + l + sovClientConfig(uint64(l))
		}
	}
	if m.NetworkFailPolicy != nil {
		l = m.NetworkFailPolicy.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.ForwardAttributes != nil {
		l = m.ForwardAttributes.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	return n
}

func (m *TransportConfig) Size() (n int) {
	var l int
	_ = l
	if m.DisableCheckCache {
		n += 2
	}
	if m.DisableQuotaCache {
		n += 2
	}
	if m.DisableReportBatch {
		n += 2
	}
	if m.NetworkFailPolicy != nil {
		l = m.NetworkFailPolicy.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.StatsUpdateInterval != nil {
		l = m.StatsUpdateInterval.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	l = len(m.CheckCluster)
	if l > 0 {
		n += 1 + l + sovClientConfig(uint64(l))
	}
	l = len(m.ReportCluster)
	if l > 0 {
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.AttributesForMixerProxy != nil {
		l = m.AttributesForMixerProxy.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	return n
}

func (m *HttpClientConfig) Size() (n int) {
	var l int
	_ = l
	if m.Transport != nil {
		l = m.Transport.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if len(m.ServiceConfigs) > 0 {
		for k, v := range m.ServiceConfigs {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovClientConfig(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovClientConfig(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovClientConfig(uint64(mapEntrySize))
		}
	}
	l = len(m.DefaultDestinationService)
	if l > 0 {
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.MixerAttributes != nil {
		l = m.MixerAttributes.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.ForwardAttributes != nil {
		l = m.ForwardAttributes.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	return n
}

func (m *TcpClientConfig) Size() (n int) {
	var l int
	_ = l
	if m.Transport != nil {
		l = m.Transport.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.MixerAttributes != nil {
		l = m.MixerAttributes.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.DisableCheckCalls {
		n += 2
	}
	if m.DisableReportCalls {
		n += 2
	}
	if m.ConnectionQuotaSpec != nil {
		l = m.ConnectionQuotaSpec.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.ReportInterval != nil {
		l = m.ReportInterval.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	return n
}

func sovClientConfig(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozClientConfig(x uint64) (n int) {
	return sovClientConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *NetworkFailPolicy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkFailPolicy{`,
		`Policy:` + fmt.Sprintf("%v", this.Policy) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServiceConfig{`,
		`DisableCheckCalls:` + fmt.Sprintf("%v", this.DisableCheckCalls) + `,`,
		`DisableReportCalls:` + fmt.Sprintf("%v", this.DisableReportCalls) + `,`,
		`MixerAttributes:` + strings.Replace(fmt.Sprintf("%v", this.MixerAttributes), "Attributes", "istio_mixer_v1.Attributes", 1) + `,`,
		`HttpApiSpec:` + strings.Replace(fmt.Sprintf("%v", this.HttpApiSpec), "HTTPAPISpec", "HTTPAPISpec", 1) + `,`,
		`QuotaSpec:` + strings.Replace(fmt.Sprintf("%v", this.QuotaSpec), "QuotaSpec", "QuotaSpec", 1) + `,`,
		`NetworkFailPolicy:` + strings.Replace(fmt.Sprintf("%v", this.NetworkFailPolicy), "NetworkFailPolicy", "NetworkFailPolicy", 1) + `,`,
		`ForwardAttributes:` + strings.Replace(fmt.Sprintf("%v", this.ForwardAttributes), "Attributes", "istio_mixer_v1.Attributes", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TransportConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TransportConfig{`,
		`DisableCheckCache:` + fmt.Sprintf("%v", this.DisableCheckCache) + `,`,
		`DisableQuotaCache:` + fmt.Sprintf("%v", this.DisableQuotaCache) + `,`,
		`DisableReportBatch:` + fmt.Sprintf("%v", this.DisableReportBatch) + `,`,
		`NetworkFailPolicy:` + strings.Replace(fmt.Sprintf("%v", this.NetworkFailPolicy), "NetworkFailPolicy", "NetworkFailPolicy", 1) + `,`,
		`StatsUpdateInterval:` + strings.Replace(fmt.Sprintf("%v", this.StatsUpdateInterval), "Duration", "google_protobuf1.Duration", 1) + `,`,
		`CheckCluster:` + fmt.Sprintf("%v", this.CheckCluster) + `,`,
		`ReportCluster:` + fmt.Sprintf("%v", this.ReportCluster) + `,`,
		`AttributesForMixerProxy:` + strings.Replace(fmt.Sprintf("%v", this.AttributesForMixerProxy), "Attributes", "istio_mixer_v1.Attributes", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpClientConfig) String() string {
	if this == nil {
		return "nil"
	}
	keysForServiceConfigs := make([]string, 0, len(this.ServiceConfigs))
	for k, _ := range this.ServiceConfigs {
		keysForServiceConfigs = append(keysForServiceConfigs, k)
	}
	sortkeys.Strings(keysForServiceConfigs)
	mapStringForServiceConfigs := "map[string]*ServiceConfig{"
	for _, k := range keysForServiceConfigs {
		mapStringForServiceConfigs += fmt.Sprintf("%v: %v,", k, this.ServiceConfigs[k])
	}
	mapStringForServiceConfigs += "}"
	s := strings.Join([]string{`&HttpClientConfig{`,
		`Transport:` + strings.Replace(fmt.Sprintf("%v", this.Transport), "TransportConfig", "TransportConfig", 1) + `,`,
		`ServiceConfigs:` + mapStringForServiceConfigs + `,`,
		`DefaultDestinationService:` + fmt.Sprintf("%v", this.DefaultDestinationService) + `,`,
		`MixerAttributes:` + strings.Replace(fmt.Sprintf("%v", this.MixerAttributes), "Attributes", "istio_mixer_v1.Attributes", 1) + `,`,
		`ForwardAttributes:` + strings.Replace(fmt.Sprintf("%v", this.ForwardAttributes), "Attributes", "istio_mixer_v1.Attributes", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TcpClientConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TcpClientConfig{`,
		`Transport:` + strings.Replace(fmt.Sprintf("%v", this.Transport), "TransportConfig", "TransportConfig", 1) + `,`,
		`MixerAttributes:` + strings.Replace(fmt.Sprintf("%v", this.MixerAttributes), "Attributes", "istio_mixer_v1.Attributes", 1) + `,`,
		`DisableCheckCalls:` + fmt.Sprintf("%v", this.DisableCheckCalls) + `,`,
		`DisableReportCalls:` + fmt.Sprintf("%v", this.DisableReportCalls) + `,`,
		`ConnectionQuotaSpec:` + strings.Replace(fmt.Sprintf("%v", this.ConnectionQuotaSpec), "QuotaSpec", "QuotaSpec", 1) + `,`,
		`ReportInterval:` + strings.Replace(fmt.Sprintf("%v", this.ReportInterval), "Duration", "google_protobuf1.Duration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringClientConfig(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *NetworkFailPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClientConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkFailPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkFailPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policy", wireType)
			}
			m.Policy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Policy |= (NetworkFailPolicy_FailPolicy(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipClientConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClientConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableCheckCalls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableCheckCalls = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableReportCalls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableReportCalls = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixerAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MixerAttributes == nil {
				m.MixerAttributes = &istio_mixer_v1.Attributes{}
			}
			if err := m.MixerAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpApiSpec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HttpApiSpec = append(m.HttpApiSpec, &HTTPAPISpec{})
			if err := m.HttpApiSpec[len(m.HttpApiSpec)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QuotaSpec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QuotaSpec = append(m.QuotaSpec, &QuotaSpec{})
			if err := m.QuotaSpec[len(m.QuotaSpec)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkFailPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NetworkFailPolicy == nil {
				m.NetworkFailPolicy = &NetworkFailPolicy{}
			}
			if err := m.NetworkFailPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ForwardAttributes == nil {
				m.ForwardAttributes = &istio_mixer_v1.Attributes{}
			}
			if err := m.ForwardAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClientConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransportConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClientConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransportConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransportConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableCheckCache", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableCheckCache = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableQuotaCache", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableQuotaCache = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableReportBatch", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableReportBatch = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkFailPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NetworkFailPolicy == nil {
				m.NetworkFailPolicy = &NetworkFailPolicy{}
			}
			if err := m.NetworkFailPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsUpdateInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StatsUpdateInterval == nil {
				m.StatsUpdateInterval = &google_protobuf1.Duration{}
			}
			if err := m.StatsUpdateInterval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CheckCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReportCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributesForMixerProxy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AttributesForMixerProxy == nil {
				m.AttributesForMixerProxy = &istio_mixer_v1.Attributes{}
			}
			if err := m.AttributesForMixerProxy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClientConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpClientConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClientConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpClientConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpClientConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Transport", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Transport == nil {
				m.Transport = &TransportConfig{}
			}
			if err := m.Transport.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceConfigs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ServiceConfigs == nil {
				m.ServiceConfigs = make(map[string]*ServiceConfig)
			}
			var mapkey string
			var mapvalue *ServiceConfig
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowClientConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClientConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthClientConfig
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClientConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthClientConfig
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthClientConfig
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &ServiceConfig{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipClientConfig(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthClientConfig
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ServiceConfigs[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultDestinationService", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultDestinationService = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixerAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MixerAttributes == nil {
				m.MixerAttributes = &istio_mixer_v1.Attributes{}
			}
			if err := m.MixerAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ForwardAttributes == nil {
				m.ForwardAttributes = &istio_mixer_v1.Attributes{}
			}
			if err := m.ForwardAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClientConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TcpClientConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClientConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TcpClientConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TcpClientConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Transport", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Transport == nil {
				m.Transport = &TransportConfig{}
			}
			if err := m.Transport.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixerAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MixerAttributes == nil {
				m.MixerAttributes = &istio_mixer_v1.Attributes{}
			}
			if err := m.MixerAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableCheckCalls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableCheckCalls = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableReportCalls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableReportCalls = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectionQuotaSpec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectionQuotaSpec == nil {
				m.ConnectionQuotaSpec = &QuotaSpec{}
			}
			if err := m.ConnectionQuotaSpec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReportInterval == nil {
				m.ReportInterval = &google_protobuf1.Duration{}
			}
			if err := m.ReportInterval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClientConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipClientConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowClientConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthClientConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowClientConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipClientConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthClientConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowClientConfig   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("mixer/v1/config/client/client_config.proto", fileDescriptorClientConfig)
}

var fileDescriptorClientConfig = []byte{
	// 887 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0x41, 0x6f, 0xdb, 0x36,
	0x14, 0x96, 0x62, 0x27, 0xad, 0xe9, 0x39, 0x71, 0xe8, 0x16, 0x73, 0xbc, 0x41, 0x08, 0x5c, 0x14,
	0xcb, 0x56, 0x4c, 0x5a, 0xbd, 0xcb, 0xd0, 0xc3, 0x00, 0xc7, 0x4d, 0xd0, 0x60, 0x4d, 0xeb, 0x29,
	0x29, 0x06, 0x6c, 0x07, 0x82, 0x96, 0x69, 0x9b, 0xb0, 0x26, 0xaa, 0x14, 0xe5, 0x36, 0xb7, 0xfd,
	0x82, 0x61, 0x87, 0xfd, 0x88, 0xfe, 0x94, 0x1e, 0x7b, 0xdc, 0x71, 0xf6, 0x2e, 0x3b, 0xe6, 0x38,
	0x60, 0x97, 0x41, 0x24, 0x65, 0xc5, 0x8e, 0xed, 0xcc, 0xc3, 0x7a, 0x32, 0xf5, 0xde, 0xf7, 0x1e,
	0xc9, 0xef, 0xbd, 0xf7, 0xd1, 0xe0, 0xb3, 0x1f, 0xe9, 0x6b, 0xc2, 0x9d, 0xd1, 0x43, 0xc7, 0x63,
	0x41, 0x8f, 0xf6, 0x1d, 0xcf, 0xa7, 0x24, 0x10, 0xfa, 0x07, 0x29, 0xa3, 0x1d, 0x72, 0x26, 0x18,
	0xfc, 0x98, 0x46, 0x82, 0x32, 0x5b, 0x46, 0xd8, 0xa3, 0x87, 0xb6, 0x76, 0x2a, 0x68, 0xed, 0x4e,
	0x9f, 0xf5, 0x99, 0x04, 0x3a, 0xc9, 0x4a, 0xc5, 0xd4, 0xac, 0x3e, 0x63, 0x7d, 0x9f, 0x38, 0xf2,
	0xab, 0x13, 0xf7, 0x9c, 0x6e, 0xcc, 0xb1, 0xa0, 0x2c, 0xd0, 0xfe, 0xbd, 0xe9, 0xfe, 0x58, 0x08,
	0x4e, 0x3b, 0xb1, 0x20, 0x91, 0x76, 0xdd, 0x5f, 0x72, 0x34, 0x1c, 0x52, 0x14, 0x85, 0xc4, 0xd3,
	0xb0, 0xfa, 0x12, 0xd8, 0xcb, 0x98, 0x09, 0xac, 0x30, 0xf5, 0x5f, 0x4d, 0xb0, 0xfb, 0x8c, 0x88,
	0x57, 0x8c, 0x0f, 0x8f, 0x31, 0xf5, 0xdb, 0xcc, 0xa7, 0xde, 0x05, 0x74, 0xc1, 0x56, 0x28, 0x57,
	0x55, 0x73, 0xdf, 0x3c, 0xd8, 0x6e, 0x3c, 0xb2, 0x57, 0x5d, 0xd0, 0xbe, 0x96, 0xc0, 0xce, 0x96,
	0xae, 0xce, 0x54, 0x7f, 0x00, 0xc0, 0x95, 0x1d, 0x4a, 0xa0, 0x70, 0xdc, 0x3c, 0x79, 0x8a, 0x9e,
	0xb7, 0x8f, 0x9e, 0x95, 0x0d, 0xb8, 0x0d, 0x80, 0xfc, 0x6c, 0x3d, 0x7d, 0x7e, 0x76, 0x54, 0x36,
	0xeb, 0x7f, 0xe7, 0x40, 0xe9, 0x8c, 0xf0, 0x11, 0xf5, 0x48, 0x4b, 0x6e, 0x05, 0x6d, 0x50, 0xe9,
	0xd2, 0x08, 0x77, 0x7c, 0x82, 0xbc, 0x01, 0xf1, 0x86, 0xc8, 0xc3, 0xbe, 0x1f, 0xc9, 0xf3, 0xdd,
	0x76, 0x77, 0xb5, 0xab, 0x95, 0x78, 0x5a, 0x89, 0x03, 0x7e, 0x01, 0xee, 0xa4, 0x78, 0x4e, 0x42,
	0xc6, 0x85, 0x0e, 0xd8, 0x90, 0x01, 0x50, 0xfb, 0x5c, 0xe9, 0x52, 0x11, 0x47, 0xa0, 0x2c, 0xef,
	0x87, 0x32, 0xbe, 0xab, 0xb9, 0x7d, 0xf3, 0xa0, 0xd8, 0xa8, 0xcd, 0x5f, 0xbf, 0x39, 0x45, 0xb8,
	0x3b, 0xd2, 0x98, 0x19, 0xe0, 0x29, 0x28, 0x0d, 0x84, 0x08, 0x51, 0x5a, 0x8c, 0x6a, 0x7e, 0x3f,
	0x77, 0x50, 0x6c, 0x7c, 0xba, 0x9a, 0xc2, 0x27, 0xe7, 0xe7, 0xed, 0x66, 0xfb, 0xe4, 0x2c, 0x24,
	0x9e, 0x5b, 0x4c, 0xe2, 0x9b, 0x21, 0x4d, 0x3e, 0xe0, 0x31, 0x00, 0xb2, 0x5e, 0x2a, 0xd7, 0xa6,
	0xcc, 0xf5, 0xc9, 0xea, 0x5c, 0xdf, 0x26, 0x78, 0x99, 0xa9, 0xf0, 0x32, 0x5d, 0x42, 0x04, 0x2a,
	0x81, 0x2a, 0x13, 0xea, 0x61, 0xea, 0x23, 0x5d, 0xdf, 0x5b, 0xf2, 0x82, 0xce, 0x9a, 0xf5, 0x75,
	0x77, 0x83, 0x6b, 0x3d, 0x73, 0x02, 0x60, 0x8f, 0xf1, 0x57, 0x98, 0x77, 0xaf, 0x12, 0x78, 0xfb,
	0x46, 0x02, 0x77, 0x75, 0x54, 0x66, 0xaa, 0xff, 0x95, 0x03, 0x3b, 0xe7, 0x1c, 0x07, 0x91, 0x2c,
	0xce, 0xd2, 0xfa, 0x7b, 0x03, 0xb2, 0xb8, 0xfe, 0xde, 0x80, 0x5c, 0xc5, 0x2b, 0xfe, 0x14, 0x7e,
	0x63, 0x06, 0x2f, 0x99, 0x52, 0xf8, 0xeb, 0xfd, 0xd2, 0xc1, 0xc2, 0x1b, 0xc8, 0x0e, 0x98, 0xef,
	0x97, 0xc3, 0xc4, 0xb3, 0x8c, 0xd1, 0xfc, 0xff, 0xc6, 0xe8, 0x29, 0xb8, 0x1b, 0x09, 0x2c, 0x22,
	0x14, 0x87, 0x5d, 0x2c, 0x08, 0xa2, 0x81, 0x20, 0x7c, 0x84, 0xfd, 0xea, 0xa6, 0xdc, 0x62, 0xcf,
	0x56, 0x0a, 0x62, 0xa7, 0x0a, 0x62, 0x3f, 0xd6, 0x0a, 0xe2, 0x56, 0x64, 0xdc, 0x0b, 0x19, 0x76,
	0xa2, 0xa3, 0xe0, 0x3d, 0x50, 0xd2, 0xcc, 0xf9, 0x71, 0x24, 0x08, 0xaf, 0x6e, 0xed, 0x9b, 0x07,
	0x05, 0xf7, 0x03, 0x69, 0x6c, 0x29, 0x1b, 0xbc, 0x0f, 0xb6, 0xd3, 0x71, 0xd1, 0xa8, 0x5b, 0x12,
	0x55, 0x52, 0xd6, 0x14, 0xf6, 0x1d, 0xa8, 0x65, 0x45, 0x46, 0x3d, 0xc6, 0x91, 0x1a, 0x9d, 0x90,
	0xb3, 0xd7, 0x17, 0xff, 0xa2, 0xe8, 0x1f, 0x66, 0xd1, 0xc7, 0x8c, 0x9f, 0x26, 0x88, 0x76, 0x12,
	0x5a, 0xff, 0x39, 0x0f, 0xca, 0x4f, 0x84, 0x08, 0x5b, 0x92, 0x27, 0x5d, 0xfb, 0x6f, 0x40, 0x41,
	0xa4, 0xed, 0x20, 0x2b, 0x5e, 0x6c, 0x7c, 0xbe, 0x9a, 0xdf, 0xb9, 0xee, 0x71, 0xb3, 0x78, 0x38,
	0x04, 0x3b, 0x91, 0x52, 0x16, 0xad, 0xe1, 0x89, 0x26, 0x24, 0x53, 0x75, 0x78, 0xc3, 0x84, 0xce,
	0x9d, 0xca, 0x9e, 0xd1, 0xa7, 0xe8, 0x28, 0x10, 0xfc, 0xc2, 0xdd, 0x8e, 0x66, 0x8c, 0xf0, 0x6b,
	0xf0, 0x51, 0x97, 0xf4, 0x70, 0xec, 0x0b, 0xd4, 0x25, 0x91, 0xa0, 0x81, 0xac, 0x0f, 0xd2, 0x28,
	0xd9, 0x5c, 0x05, 0x77, 0x4f, 0x43, 0x1e, 0x67, 0x08, 0x9d, 0x7b, 0xa1, 0x26, 0xe5, 0xd7, 0xd7,
	0xa4, 0xc5, 0xb3, 0xb9, 0xf9, 0x1f, 0x66, 0xb3, 0x16, 0x80, 0xca, 0x82, 0x8b, 0xc3, 0x32, 0xc8,
	0x0d, 0x89, 0x7a, 0x2e, 0x0a, 0x6e, 0xb2, 0x84, 0x4d, 0xb0, 0x39, 0xc2, 0x7e, 0xac, 0x46, 0xae,
	0xd8, 0x78, 0xb0, 0x9a, 0xdd, 0x99, 0x9c, 0xae, 0x8a, 0x7c, 0xb4, 0xf1, 0x95, 0x59, 0x7f, 0x93,
	0x68, 0x81, 0xf7, 0x1e, 0xfb, 0x61, 0x11, 0xc5, 0x1b, 0xeb, 0x53, 0xbc, 0xe4, 0x7d, 0xca, 0xad,
	0xfb, 0x3e, 0xe5, 0x97, 0xbe, 0x4f, 0x3f, 0x80, 0xbb, 0x1e, 0x0b, 0x02, 0xe2, 0xc9, 0x16, 0x9a,
	0x79, 0x14, 0xcc, 0x75, 0x1e, 0x85, 0x4a, 0x96, 0x65, 0x6a, 0x84, 0x87, 0x60, 0x47, 0x1f, 0x63,
	0xaa, 0x32, 0x5b, 0x37, 0xa9, 0x8c, 0x56, 0x8a, 0x54, 0x60, 0x0e, 0x5f, 0xbc, 0x1d, 0x5b, 0xc6,
	0xbb, 0xb1, 0x65, 0xfc, 0x36, 0xb6, 0x8c, 0xcb, 0xb1, 0x65, 0xfc, 0x34, 0xb1, 0xcc, 0x37, 0x13,
	0xcb, 0x78, 0x3b, 0xb1, 0xcc, 0x77, 0x13, 0xcb, 0xfc, 0x7d, 0x62, 0x99, 0x7f, 0x4e, 0x2c, 0xe3,
	0x72, 0x62, 0x99, 0xbf, 0xfc, 0x61, 0x19, 0xdf, 0xdf, 0x53, 0x47, 0xa6, 0x2c, 0xf9, 0xeb, 0xe2,
	0x2c, 0xfe, 0xbb, 0xd2, 0xd9, 0x92, 0x3b, 0x7f, 0xf9, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20,
	0x16, 0x4a, 0x99, 0x91, 0x09, 0x00, 0x00,
}
