// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/core/address.proto

/*
	Package core is a generated protocol buffer package.

	It is generated from these files:
		envoy/api/v2/core/address.proto
		envoy/api/v2/core/base.proto
		envoy/api/v2/core/config_source.proto
		envoy/api/v2/core/grpc_service.proto
		envoy/api/v2/core/health_check.proto
		envoy/api/v2/core/http_uri.proto
		envoy/api/v2/core/protocol.proto

	It has these top-level messages:
		Pipe
		SocketAddress
		TcpKeepalive
		BindConfig
		Address
		CidrRange
		Locality
		Node
		Metadata
		RuntimeUInt32
		HeaderValue
		HeaderValueOption
		DataSource
		TransportSocket
		SocketOption
		ApiConfigSource
		AggregatedConfigSource
		ConfigSource
		GrpcService
		HealthCheck
		HttpUri
		TcpProtocolOptions
		HttpProtocolOptions
		Http1ProtocolOptions
		Http2ProtocolOptions
		GrpcProtocolOptions
*/
package core

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf1 "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"
import _ "github.com/gogo/protobuf/gogoproto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type SocketAddress_Protocol int32

const (
	TCP SocketAddress_Protocol = 0
	// [#not-implemented-hide:]
	UDP SocketAddress_Protocol = 1
)

var SocketAddress_Protocol_name = map[int32]string{
	0: "TCP",
	1: "UDP",
}
var SocketAddress_Protocol_value = map[string]int32{
	"TCP": 0,
	"UDP": 1,
}

func (x SocketAddress_Protocol) String() string {
	return proto.EnumName(SocketAddress_Protocol_name, int32(x))
}
func (SocketAddress_Protocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorAddress, []int{1, 0}
}

type Pipe struct {
	// Unix Domain Socket path. On Linux, paths starting with '@' will use the
	// abstract namespace. The starting '@' is replaced by a null byte by Envoy.
	// Paths starting with '@' will result in an error in environments other than
	// Linux.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *Pipe) Reset()                    { *m = Pipe{} }
func (m *Pipe) String() string            { return proto.CompactTextString(m) }
func (*Pipe) ProtoMessage()               {}
func (*Pipe) Descriptor() ([]byte, []int) { return fileDescriptorAddress, []int{0} }

func (m *Pipe) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

type SocketAddress struct {
	Protocol SocketAddress_Protocol `protobuf:"varint,1,opt,name=protocol,proto3,enum=envoy.api.v2.core.SocketAddress_Protocol" json:"protocol,omitempty"`
	// The address for this socket. :ref:`Listeners <config_listeners>` will bind
	// to the address. An empty address is not allowed. Specify ``0.0.0.0`` or ``::``
	// to bind to any address. [#comment:TODO(zuercher) reinstate when implemented:
	// It is possible to distinguish a Listener address via the prefix/suffix matching
	// in :ref:`FilterChainMatch <envoy_api_msg_listener.FilterChainMatch>`.] When used
	// within an upstream :ref:`BindConfig <envoy_api_msg_core.BindConfig>`, the address
	// controls the source address of outbound connections. For :ref:`clusters
	// <config_cluster_manager_cluster>`, the cluster type determines whether the
	// address must be an IP (*STATIC* or *EDS* clusters) or a hostname resolved by DNS
	// (*STRICT_DNS* or *LOGICAL_DNS* clusters). Address resolution can be customized
	// via :ref:`resolver_name <envoy_api_field_core.SocketAddress.resolver_name>`.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Types that are valid to be assigned to PortSpecifier:
	//	*SocketAddress_PortValue
	//	*SocketAddress_NamedPort
	PortSpecifier isSocketAddress_PortSpecifier `protobuf_oneof:"port_specifier"`
	// The name of the resolver. This must have been registered with Envoy. If this is
	// empty, a context dependent default applies. If address is a hostname this
	// should be set for resolution other than DNS. If the address is a concrete
	// IP address, no resolution will occur.
	ResolverName string `protobuf:"bytes,5,opt,name=resolver_name,json=resolverName,proto3" json:"resolver_name,omitempty"`
	// When binding to an IPv6 address above, this enables `IPv4 compatibity
	// <https://tools.ietf.org/html/rfc3493#page-11>`_. Binding to ``::`` will
	// allow both IPv4 and IPv6 connections, with peer IPv4 addresses mapped into
	// IPv6 space as ``::FFFF:<IPv4-address>``.
	Ipv4Compat bool `protobuf:"varint,6,opt,name=ipv4_compat,json=ipv4Compat,proto3" json:"ipv4_compat,omitempty"`
}

func (m *SocketAddress) Reset()                    { *m = SocketAddress{} }
func (m *SocketAddress) String() string            { return proto.CompactTextString(m) }
func (*SocketAddress) ProtoMessage()               {}
func (*SocketAddress) Descriptor() ([]byte, []int) { return fileDescriptorAddress, []int{1} }

type isSocketAddress_PortSpecifier interface {
	isSocketAddress_PortSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type SocketAddress_PortValue struct {
	PortValue uint32 `protobuf:"varint,3,opt,name=port_value,json=portValue,proto3,oneof"`
}
type SocketAddress_NamedPort struct {
	NamedPort string `protobuf:"bytes,4,opt,name=named_port,json=namedPort,proto3,oneof"`
}

func (*SocketAddress_PortValue) isSocketAddress_PortSpecifier() {}
func (*SocketAddress_NamedPort) isSocketAddress_PortSpecifier() {}

func (m *SocketAddress) GetPortSpecifier() isSocketAddress_PortSpecifier {
	if m != nil {
		return m.PortSpecifier
	}
	return nil
}

func (m *SocketAddress) GetProtocol() SocketAddress_Protocol {
	if m != nil {
		return m.Protocol
	}
	return TCP
}

func (m *SocketAddress) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *SocketAddress) GetPortValue() uint32 {
	if x, ok := m.GetPortSpecifier().(*SocketAddress_PortValue); ok {
		return x.PortValue
	}
	return 0
}

func (m *SocketAddress) GetNamedPort() string {
	if x, ok := m.GetPortSpecifier().(*SocketAddress_NamedPort); ok {
		return x.NamedPort
	}
	return ""
}

func (m *SocketAddress) GetResolverName() string {
	if m != nil {
		return m.ResolverName
	}
	return ""
}

func (m *SocketAddress) GetIpv4Compat() bool {
	if m != nil {
		return m.Ipv4Compat
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SocketAddress) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SocketAddress_OneofMarshaler, _SocketAddress_OneofUnmarshaler, _SocketAddress_OneofSizer, []interface{}{
		(*SocketAddress_PortValue)(nil),
		(*SocketAddress_NamedPort)(nil),
	}
}

func _SocketAddress_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SocketAddress)
	// port_specifier
	switch x := m.PortSpecifier.(type) {
	case *SocketAddress_PortValue:
		_ = b.EncodeVarint(3<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.PortValue))
	case *SocketAddress_NamedPort:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.NamedPort)
	case nil:
	default:
		return fmt.Errorf("SocketAddress.PortSpecifier has unexpected type %T", x)
	}
	return nil
}

func _SocketAddress_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SocketAddress)
	switch tag {
	case 3: // port_specifier.port_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.PortSpecifier = &SocketAddress_PortValue{uint32(x)}
		return true, err
	case 4: // port_specifier.named_port
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PortSpecifier = &SocketAddress_NamedPort{x}
		return true, err
	default:
		return false, nil
	}
}

func _SocketAddress_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SocketAddress)
	// port_specifier
	switch x := m.PortSpecifier.(type) {
	case *SocketAddress_PortValue:
		n += proto.SizeVarint(3<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.PortValue))
	case *SocketAddress_NamedPort:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.NamedPort)))
		n += len(x.NamedPort)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type TcpKeepalive struct {
	// Maximum number of keepalive probes to send without response before deciding
	// the connection is dead. Default is to use the OS level configuration (unless
	// overridden, Linux defaults to 9.)
	KeepaliveProbes *google_protobuf1.UInt32Value `protobuf:"bytes,1,opt,name=keepalive_probes,json=keepaliveProbes" json:"keepalive_probes,omitempty"`
	// The number of seconds a connection needs to be idle before keep-alive probes
	// start being sent. Default is to use the OS level configuration (unless
	// overridden, Linux defaults to 7200s (ie 2 hours.)
	KeepaliveTime *google_protobuf1.UInt32Value `protobuf:"bytes,2,opt,name=keepalive_time,json=keepaliveTime" json:"keepalive_time,omitempty"`
	// The number of seconds between keep-alive probes. Default is to use the OS
	// level configuration (unless overridden, Linux defaults to 75s.)
	KeepaliveInterval *google_protobuf1.UInt32Value `protobuf:"bytes,3,opt,name=keepalive_interval,json=keepaliveInterval" json:"keepalive_interval,omitempty"`
}

func (m *TcpKeepalive) Reset()                    { *m = TcpKeepalive{} }
func (m *TcpKeepalive) String() string            { return proto.CompactTextString(m) }
func (*TcpKeepalive) ProtoMessage()               {}
func (*TcpKeepalive) Descriptor() ([]byte, []int) { return fileDescriptorAddress, []int{2} }

func (m *TcpKeepalive) GetKeepaliveProbes() *google_protobuf1.UInt32Value {
	if m != nil {
		return m.KeepaliveProbes
	}
	return nil
}

func (m *TcpKeepalive) GetKeepaliveTime() *google_protobuf1.UInt32Value {
	if m != nil {
		return m.KeepaliveTime
	}
	return nil
}

func (m *TcpKeepalive) GetKeepaliveInterval() *google_protobuf1.UInt32Value {
	if m != nil {
		return m.KeepaliveInterval
	}
	return nil
}

type BindConfig struct {
	// The address to bind to when creating a socket.
	SourceAddress SocketAddress `protobuf:"bytes,1,opt,name=source_address,json=sourceAddress" json:"source_address"`
	// Whether to set the *IP_FREEBIND* option when creating the socket. When this
	// flag is set to true, allows the :ref:`source_address
	// <envoy_api_field_UpstreamBindConfig.source_address>` to be an IP address
	// that is not configured on the system running Envoy. When this flag is set
	// to false, the option *IP_FREEBIND* is disabled on the socket. When this
	// flag is not set (default), the socket is not modified, i.e. the option is
	// neither enabled nor disabled.
	Freebind *google_protobuf1.BoolValue `protobuf:"bytes,2,opt,name=freebind" json:"freebind,omitempty"`
	// Additional socket options that may not be present in Envoy source code or
	// precompiled binaries.
	SocketOptions []*SocketOption `protobuf:"bytes,3,rep,name=socket_options,json=socketOptions" json:"socket_options,omitempty"`
}

func (m *BindConfig) Reset()                    { *m = BindConfig{} }
func (m *BindConfig) String() string            { return proto.CompactTextString(m) }
func (*BindConfig) ProtoMessage()               {}
func (*BindConfig) Descriptor() ([]byte, []int) { return fileDescriptorAddress, []int{3} }

func (m *BindConfig) GetSourceAddress() SocketAddress {
	if m != nil {
		return m.SourceAddress
	}
	return SocketAddress{}
}

func (m *BindConfig) GetFreebind() *google_protobuf1.BoolValue {
	if m != nil {
		return m.Freebind
	}
	return nil
}

func (m *BindConfig) GetSocketOptions() []*SocketOption {
	if m != nil {
		return m.SocketOptions
	}
	return nil
}

// Addresses specify either a logical or physical address and port, which are
// used to tell Envoy where to bind/listen, connect to upstream and find
// management servers.
type Address struct {
	// Types that are valid to be assigned to Address:
	//	*Address_SocketAddress
	//	*Address_Pipe
	Address isAddress_Address `protobuf_oneof:"address"`
}

func (m *Address) Reset()                    { *m = Address{} }
func (m *Address) String() string            { return proto.CompactTextString(m) }
func (*Address) ProtoMessage()               {}
func (*Address) Descriptor() ([]byte, []int) { return fileDescriptorAddress, []int{4} }

type isAddress_Address interface {
	isAddress_Address()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Address_SocketAddress struct {
	SocketAddress *SocketAddress `protobuf:"bytes,1,opt,name=socket_address,json=socketAddress,oneof"`
}
type Address_Pipe struct {
	Pipe *Pipe `protobuf:"bytes,2,opt,name=pipe,oneof"`
}

func (*Address_SocketAddress) isAddress_Address() {}
func (*Address_Pipe) isAddress_Address()          {}

func (m *Address) GetAddress() isAddress_Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Address) GetSocketAddress() *SocketAddress {
	if x, ok := m.GetAddress().(*Address_SocketAddress); ok {
		return x.SocketAddress
	}
	return nil
}

func (m *Address) GetPipe() *Pipe {
	if x, ok := m.GetAddress().(*Address_Pipe); ok {
		return x.Pipe
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Address) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Address_OneofMarshaler, _Address_OneofUnmarshaler, _Address_OneofSizer, []interface{}{
		(*Address_SocketAddress)(nil),
		(*Address_Pipe)(nil),
	}
}

func _Address_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Address)
	// address
	switch x := m.Address.(type) {
	case *Address_SocketAddress:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SocketAddress); err != nil {
			return err
		}
	case *Address_Pipe:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Pipe); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Address.Address has unexpected type %T", x)
	}
	return nil
}

func _Address_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Address)
	switch tag {
	case 1: // address.socket_address
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SocketAddress)
		err := b.DecodeMessage(msg)
		m.Address = &Address_SocketAddress{msg}
		return true, err
	case 2: // address.pipe
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Pipe)
		err := b.DecodeMessage(msg)
		m.Address = &Address_Pipe{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Address_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Address)
	// address
	switch x := m.Address.(type) {
	case *Address_SocketAddress:
		s := proto.Size(x.SocketAddress)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Address_Pipe:
		s := proto.Size(x.Pipe)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// CidrRange specifies an IP Address and a prefix length to construct
// the subnet mask for a `CIDR <https://tools.ietf.org/html/rfc4632>`_ range.
type CidrRange struct {
	// IPv4 or IPv6 address, e.g. ``192.0.0.0`` or ``2001:db8::``.
	AddressPrefix string `protobuf:"bytes,1,opt,name=address_prefix,json=addressPrefix,proto3" json:"address_prefix,omitempty"`
	// Length of prefix, e.g. 0, 32.
	PrefixLen *google_protobuf1.UInt32Value `protobuf:"bytes,2,opt,name=prefix_len,json=prefixLen" json:"prefix_len,omitempty"`
}

func (m *CidrRange) Reset()                    { *m = CidrRange{} }
func (m *CidrRange) String() string            { return proto.CompactTextString(m) }
func (*CidrRange) ProtoMessage()               {}
func (*CidrRange) Descriptor() ([]byte, []int) { return fileDescriptorAddress, []int{5} }

func (m *CidrRange) GetAddressPrefix() string {
	if m != nil {
		return m.AddressPrefix
	}
	return ""
}

func (m *CidrRange) GetPrefixLen() *google_protobuf1.UInt32Value {
	if m != nil {
		return m.PrefixLen
	}
	return nil
}

func init() {
	proto.RegisterType((*Pipe)(nil), "envoy.api.v2.core.Pipe")
	proto.RegisterType((*SocketAddress)(nil), "envoy.api.v2.core.SocketAddress")
	proto.RegisterType((*TcpKeepalive)(nil), "envoy.api.v2.core.TcpKeepalive")
	proto.RegisterType((*BindConfig)(nil), "envoy.api.v2.core.BindConfig")
	proto.RegisterType((*Address)(nil), "envoy.api.v2.core.Address")
	proto.RegisterType((*CidrRange)(nil), "envoy.api.v2.core.CidrRange")
	proto.RegisterEnum("envoy.api.v2.core.SocketAddress_Protocol", SocketAddress_Protocol_name, SocketAddress_Protocol_value)
}
func (this *Pipe) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Pipe)
	if !ok {
		that2, ok := that.(Pipe)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *SocketAddress) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SocketAddress)
	if !ok {
		that2, ok := that.(SocketAddress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Protocol != that1.Protocol {
		return false
	}
	if this.Address != that1.Address {
		return false
	}
	if that1.PortSpecifier == nil {
		if this.PortSpecifier != nil {
			return false
		}
	} else if this.PortSpecifier == nil {
		return false
	} else if !this.PortSpecifier.Equal(that1.PortSpecifier) {
		return false
	}
	if this.ResolverName != that1.ResolverName {
		return false
	}
	if this.Ipv4Compat != that1.Ipv4Compat {
		return false
	}
	return true
}
func (this *SocketAddress_PortValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SocketAddress_PortValue)
	if !ok {
		that2, ok := that.(SocketAddress_PortValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PortValue != that1.PortValue {
		return false
	}
	return true
}
func (this *SocketAddress_NamedPort) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SocketAddress_NamedPort)
	if !ok {
		that2, ok := that.(SocketAddress_NamedPort)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamedPort != that1.NamedPort {
		return false
	}
	return true
}
func (this *TcpKeepalive) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TcpKeepalive)
	if !ok {
		that2, ok := that.(TcpKeepalive)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.KeepaliveProbes.Equal(that1.KeepaliveProbes) {
		return false
	}
	if !this.KeepaliveTime.Equal(that1.KeepaliveTime) {
		return false
	}
	if !this.KeepaliveInterval.Equal(that1.KeepaliveInterval) {
		return false
	}
	return true
}
func (this *BindConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*BindConfig)
	if !ok {
		that2, ok := that.(BindConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SourceAddress.Equal(&that1.SourceAddress) {
		return false
	}
	if !this.Freebind.Equal(that1.Freebind) {
		return false
	}
	if len(this.SocketOptions) != len(that1.SocketOptions) {
		return false
	}
	for i := range this.SocketOptions {
		if !this.SocketOptions[i].Equal(that1.SocketOptions[i]) {
			return false
		}
	}
	return true
}
func (this *Address) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Address)
	if !ok {
		that2, ok := that.(Address)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Address == nil {
		if this.Address != nil {
			return false
		}
	} else if this.Address == nil {
		return false
	} else if !this.Address.Equal(that1.Address) {
		return false
	}
	return true
}
func (this *Address_SocketAddress) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Address_SocketAddress)
	if !ok {
		that2, ok := that.(Address_SocketAddress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SocketAddress.Equal(that1.SocketAddress) {
		return false
	}
	return true
}
func (this *Address_Pipe) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Address_Pipe)
	if !ok {
		that2, ok := that.(Address_Pipe)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Pipe.Equal(that1.Pipe) {
		return false
	}
	return true
}
func (this *CidrRange) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CidrRange)
	if !ok {
		that2, ok := that.(CidrRange)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.AddressPrefix != that1.AddressPrefix {
		return false
	}
	if !this.PrefixLen.Equal(that1.PrefixLen) {
		return false
	}
	return true
}
func (m *Pipe) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Pipe) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Path) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAddress(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	return i, nil
}

func (m *SocketAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SocketAddress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Protocol != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.Protocol))
	}
	if len(m.Address) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAddress(dAtA, i, uint64(len(m.Address)))
		i += copy(dAtA[i:], m.Address)
	}
	if m.PortSpecifier != nil {
		nn1, err := m.PortSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if len(m.ResolverName) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAddress(dAtA, i, uint64(len(m.ResolverName)))
		i += copy(dAtA[i:], m.ResolverName)
	}
	if m.Ipv4Compat {
		dAtA[i] = 0x30
		i++
		if m.Ipv4Compat {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *SocketAddress_PortValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x18
	i++
	i = encodeVarintAddress(dAtA, i, uint64(m.PortValue))
	return i, nil
}
func (m *SocketAddress_NamedPort) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x22
	i++
	i = encodeVarintAddress(dAtA, i, uint64(len(m.NamedPort)))
	i += copy(dAtA[i:], m.NamedPort)
	return i, nil
}
func (m *TcpKeepalive) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TcpKeepalive) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.KeepaliveProbes != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.KeepaliveProbes.Size()))
		n2, err := m.KeepaliveProbes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.KeepaliveTime != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.KeepaliveTime.Size()))
		n3, err := m.KeepaliveTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.KeepaliveInterval != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.KeepaliveInterval.Size()))
		n4, err := m.KeepaliveInterval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *BindConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BindConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAddress(dAtA, i, uint64(m.SourceAddress.Size()))
	n5, err := m.SourceAddress.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if m.Freebind != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.Freebind.Size()))
		n6, err := m.Freebind.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if len(m.SocketOptions) > 0 {
		for _, msg := range m.SocketOptions {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintAddress(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Address) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Address) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Address != nil {
		nn7, err := m.Address.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn7
	}
	return i, nil
}

func (m *Address_SocketAddress) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SocketAddress != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.SocketAddress.Size()))
		n8, err := m.SocketAddress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *Address_Pipe) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Pipe != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.Pipe.Size()))
		n9, err := m.Pipe.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *CidrRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CidrRange) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.AddressPrefix) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAddress(dAtA, i, uint64(len(m.AddressPrefix)))
		i += copy(dAtA[i:], m.AddressPrefix)
	}
	if m.PrefixLen != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.PrefixLen.Size()))
		n10, err := m.PrefixLen.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}

func encodeVarintAddress(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Pipe) Size() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovAddress(uint64(l))
	}
	return n
}

func (m *SocketAddress) Size() (n int) {
	var l int
	_ = l
	if m.Protocol != 0 {
		n += 1 + sovAddress(uint64(m.Protocol))
	}
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovAddress(uint64(l))
	}
	if m.PortSpecifier != nil {
		n += m.PortSpecifier.Size()
	}
	l = len(m.ResolverName)
	if l > 0 {
		n += 1 + l + sovAddress(uint64(l))
	}
	if m.Ipv4Compat {
		n += 2
	}
	return n
}

func (m *SocketAddress_PortValue) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovAddress(uint64(m.PortValue))
	return n
}
func (m *SocketAddress_NamedPort) Size() (n int) {
	var l int
	_ = l
	l = len(m.NamedPort)
	n += 1 + l + sovAddress(uint64(l))
	return n
}
func (m *TcpKeepalive) Size() (n int) {
	var l int
	_ = l
	if m.KeepaliveProbes != nil {
		l = m.KeepaliveProbes.Size()
		n += 1 + l + sovAddress(uint64(l))
	}
	if m.KeepaliveTime != nil {
		l = m.KeepaliveTime.Size()
		n += 1 + l + sovAddress(uint64(l))
	}
	if m.KeepaliveInterval != nil {
		l = m.KeepaliveInterval.Size()
		n += 1 + l + sovAddress(uint64(l))
	}
	return n
}

func (m *BindConfig) Size() (n int) {
	var l int
	_ = l
	l = m.SourceAddress.Size()
	n += 1 + l + sovAddress(uint64(l))
	if m.Freebind != nil {
		l = m.Freebind.Size()
		n += 1 + l + sovAddress(uint64(l))
	}
	if len(m.SocketOptions) > 0 {
		for _, e := range m.SocketOptions {
			l = e.Size()
			n += 1 + l + sovAddress(uint64(l))
		}
	}
	return n
}

func (m *Address) Size() (n int) {
	var l int
	_ = l
	if m.Address != nil {
		n += m.Address.Size()
	}
	return n
}

func (m *Address_SocketAddress) Size() (n int) {
	var l int
	_ = l
	if m.SocketAddress != nil {
		l = m.SocketAddress.Size()
		n += 1 + l + sovAddress(uint64(l))
	}
	return n
}
func (m *Address_Pipe) Size() (n int) {
	var l int
	_ = l
	if m.Pipe != nil {
		l = m.Pipe.Size()
		n += 1 + l + sovAddress(uint64(l))
	}
	return n
}
func (m *CidrRange) Size() (n int) {
	var l int
	_ = l
	l = len(m.AddressPrefix)
	if l > 0 {
		n += 1 + l + sovAddress(uint64(l))
	}
	if m.PrefixLen != nil {
		l = m.PrefixLen.Size()
		n += 1 + l + sovAddress(uint64(l))
	}
	return n
}

func sovAddress(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAddress(x uint64) (n int) {
	return sovAddress(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Pipe) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Pipe: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Pipe: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAddress(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAddress
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SocketAddress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SocketAddress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SocketAddress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Protocol |= (SocketAddress_Protocol(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortValue", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PortSpecifier = &SocketAddress_PortValue{v}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamedPort", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortSpecifier = &SocketAddress_NamedPort{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolverName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResolverName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ipv4Compat", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ipv4Compat = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAddress(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAddress
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TcpKeepalive) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TcpKeepalive: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TcpKeepalive: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeepaliveProbes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KeepaliveProbes == nil {
				m.KeepaliveProbes = &google_protobuf1.UInt32Value{}
			}
			if err := m.KeepaliveProbes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeepaliveTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KeepaliveTime == nil {
				m.KeepaliveTime = &google_protobuf1.UInt32Value{}
			}
			if err := m.KeepaliveTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeepaliveInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KeepaliveInterval == nil {
				m.KeepaliveInterval = &google_protobuf1.UInt32Value{}
			}
			if err := m.KeepaliveInterval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAddress(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAddress
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BindConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BindConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BindConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SourceAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Freebind", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Freebind == nil {
				m.Freebind = &google_protobuf1.BoolValue{}
			}
			if err := m.Freebind.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SocketOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SocketOptions = append(m.SocketOptions, &SocketOption{})
			if err := m.SocketOptions[len(m.SocketOptions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAddress(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAddress
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Address) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Address: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Address: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SocketAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SocketAddress{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Address = &Address_SocketAddress{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pipe", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Pipe{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Address = &Address_Pipe{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAddress(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAddress
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CidrRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CidrRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CidrRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddressPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AddressPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrefixLen", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PrefixLen == nil {
				m.PrefixLen = &google_protobuf1.UInt32Value{}
			}
			if err := m.PrefixLen.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAddress(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAddress
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAddress(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAddress
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAddress
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAddress(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAddress = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAddress   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/api/v2/core/address.proto", fileDescriptorAddress) }

var fileDescriptorAddress = []byte{
	// 691 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x53, 0xc1, 0x6e, 0x13, 0x3b,
	0x14, 0x8d, 0x33, 0x69, 0x9b, 0xdc, 0x34, 0x79, 0xa9, 0xf5, 0xa4, 0x8e, 0xa2, 0xbe, 0x24, 0x4a,
	0xf5, 0xa4, 0x50, 0xc1, 0x0c, 0x4a, 0x11, 0x7b, 0x26, 0x88, 0xb6, 0x2a, 0x82, 0x30, 0xb4, 0xb0,
	0x1c, 0x39, 0x89, 0x13, 0xac, 0x4e, 0xc6, 0x96, 0x67, 0x3a, 0xc0, 0x0e, 0xb1, 0x40, 0x88, 0x3d,
	0x5f, 0xc0, 0x86, 0x4f, 0x40, 0xac, 0xba, 0xec, 0x92, 0x2d, 0x1b, 0x84, 0x22, 0xb1, 0xe8, 0x57,
	0x14, 0xd9, 0x33, 0x93, 0x0a, 0x02, 0x2a, 0xec, 0xec, 0x73, 0xcf, 0x39, 0x3e, 0xd7, 0xbe, 0x86,
	0x26, 0x0d, 0x62, 0xfe, 0xdc, 0x26, 0x82, 0xd9, 0x71, 0xd7, 0x1e, 0x72, 0x49, 0x6d, 0x32, 0x1a,
	0x49, 0x1a, 0x86, 0x96, 0x90, 0x3c, 0xe2, 0x78, 0x4d, 0x13, 0x2c, 0x22, 0x98, 0x15, 0x77, 0x2d,
	0x45, 0xa8, 0x6f, 0x2c, 0x6a, 0x06, 0x24, 0xa4, 0x89, 0xa0, 0xde, 0x98, 0x70, 0x3e, 0xf1, 0xa9,
	0xad, 0x77, 0x83, 0xe3, 0xb1, 0xfd, 0x54, 0x12, 0x21, 0xa8, 0x4c, 0x0d, 0xeb, 0xeb, 0x31, 0xf1,
	0xd9, 0x88, 0x44, 0xd4, 0xce, 0x16, 0x69, 0xe1, 0xdf, 0x09, 0x9f, 0x70, 0xbd, 0xb4, 0xd5, 0x2a,
	0x41, 0xdb, 0xff, 0x43, 0xa1, 0xcf, 0x04, 0xc5, 0xff, 0x41, 0x41, 0x90, 0xe8, 0x89, 0x89, 0x5a,
	0xa8, 0x53, 0x72, 0x4a, 0x1f, 0xcf, 0x4e, 0x8c, 0x82, 0xcc, 0xb7, 0x90, 0xab, 0xe1, 0xf6, 0xe7,
	0x3c, 0x54, 0x1e, 0xf2, 0xe1, 0x11, 0x8d, 0x6e, 0x25, 0xf1, 0xf1, 0x03, 0x28, 0x6a, 0x87, 0x21,
	0xf7, 0xb5, 0xa8, 0xda, 0xbd, 0x62, 0x2d, 0xf4, 0x62, 0xfd, 0xa0, 0xb1, 0xfa, 0xa9, 0xc0, 0x01,
	0xe5, 0xbf, 0xf4, 0x12, 0xe5, 0x6b, 0xc8, 0x9d, 0xdb, 0xe0, 0x4d, 0x58, 0x49, 0x2f, 0xc7, 0xcc,
	0xff, 0x1c, 0x23, 0xab, 0xe0, 0xab, 0x00, 0x82, 0xcb, 0xc8, 0x8b, 0x89, 0x7f, 0x4c, 0x4d, 0xa3,
	0x85, 0x3a, 0x15, 0xa7, 0xac, 0x78, 0xcb, 0x5b, 0x05, 0xf3, 0xfc, 0xdc, 0xd8, 0xcd, 0xb9, 0x25,
	0x45, 0x78, 0xa4, 0xea, 0xb8, 0x09, 0x10, 0x90, 0x29, 0x1d, 0x79, 0x0a, 0x32, 0x0b, 0xca, 0x55,
	0x11, 0x34, 0xd6, 0xe7, 0x32, 0xc2, 0x9b, 0x50, 0x91, 0x34, 0xe4, 0x7e, 0x4c, 0xa5, 0xa7, 0x50,
	0x73, 0x49, 0x71, 0xdc, 0xd5, 0x0c, 0xbc, 0x47, 0xa6, 0xca, 0xa5, 0xcc, 0x44, 0x7c, 0xc3, 0x1b,
	0xf2, 0xa9, 0x20, 0x91, 0xb9, 0xdc, 0x42, 0x9d, 0xa2, 0x0b, 0x0a, 0xea, 0x69, 0xa4, 0xdd, 0x86,
	0x62, 0xd6, 0x1b, 0x5e, 0x01, 0xe3, 0xa0, 0xd7, 0xaf, 0xe5, 0xd4, 0xe2, 0xf0, 0x76, 0xbf, 0x86,
	0xea, 0x85, 0xd7, 0xef, 0x1a, 0x39, 0x67, 0x1d, 0xaa, 0x3a, 0x78, 0x28, 0xe8, 0x90, 0x8d, 0x19,
	0x95, 0x78, 0xe9, 0xc3, 0xd9, 0x89, 0x81, 0xda, 0x67, 0x08, 0x56, 0x0f, 0x86, 0x62, 0x9f, 0x52,
	0x41, 0x7c, 0x16, 0x53, 0xbc, 0x03, 0xb5, 0xa3, 0x6c, 0xe3, 0x09, 0xc9, 0x07, 0x34, 0xd4, 0x57,
	0x5c, 0xee, 0x6e, 0x58, 0xc9, 0xeb, 0x5b, 0xd9, 0xeb, 0x5b, 0x87, 0x7b, 0x41, 0xb4, 0xdd, 0xd5,
	0xcd, 0xba, 0xff, 0xcc, 0x55, 0x7d, 0x2d, 0xc2, 0x3d, 0xa8, 0x5e, 0x18, 0x45, 0x6c, 0x4a, 0xf5,
	0xbd, 0x5e, 0x66, 0x53, 0x99, 0x6b, 0x0e, 0xd8, 0x94, 0xe2, 0x7d, 0xc0, 0x17, 0x26, 0x2c, 0x88,
	0xa8, 0x8c, 0x89, 0xaf, 0x2f, 0xfe, 0x32, 0xa3, 0xb5, 0xb9, 0x6e, 0x2f, 0x95, 0xb5, 0xbf, 0x21,
	0x00, 0x87, 0x05, 0xa3, 0x1e, 0x0f, 0xc6, 0x6c, 0x82, 0x1f, 0x43, 0x35, 0xe4, 0xc7, 0x72, 0x48,
	0xbd, 0xec, 0xe1, 0x93, 0x3e, 0x5b, 0x97, 0x8d, 0x92, 0x53, 0x3d, 0xfd, 0xd2, 0xcc, 0xe9, 0x29,
	0x7a, 0xa3, 0xa7, 0xa8, 0x92, 0xf8, 0x64, 0xd3, 0x79, 0x13, 0x8a, 0x63, 0x49, 0xe9, 0x80, 0x05,
	0xa3, 0xb4, 0xe7, 0xfa, 0x42, 0x54, 0x87, 0x73, 0x3f, 0x09, 0x3a, 0xe7, 0xe2, 0x3b, 0x2a, 0x90,
	0x3a, 0xc7, 0xe3, 0x22, 0x62, 0x3c, 0x08, 0x4d, 0xa3, 0x65, 0x74, 0xca, 0xdd, 0xe6, 0x6f, 0x03,
	0xdd, 0xd7, 0x3c, 0x75, 0xfe, 0xc5, 0x2e, 0x6c, 0xbf, 0x45, 0xb0, 0x92, 0x65, 0xd9, 0x9b, 0x7b,
	0xfe, 0x65, 0x93, 0xbb, 0xb9, 0xcc, 0x36, 0xb3, 0xba, 0x06, 0x05, 0xc1, 0x44, 0xf6, 0x8c, 0xeb,
	0xbf, 0x30, 0x50, 0x9f, 0x79, 0x37, 0xe7, 0x6a, 0x9a, 0x53, 0x9b, 0x7f, 0xa8, 0x6c, 0xd6, 0x5e,
	0x21, 0x28, 0xf5, 0xd8, 0x48, 0xba, 0x24, 0x98, 0x50, 0x7c, 0x1d, 0xaa, 0x69, 0xdd, 0x13, 0x92,
	0x8e, 0xd9, 0xb3, 0xc5, 0xef, 0x5f, 0x49, 0x09, 0x7d, 0x5d, 0xc7, 0x3b, 0x00, 0x09, 0xd3, 0xf3,
	0x69, 0xf0, 0x27, 0xd3, 0x94, 0x7e, 0xf5, 0x2d, 0xc3, 0x7c, 0x81, 0xdc, 0x52, 0xa2, 0xbd, 0x4b,
	0x03, 0xa7, 0xf6, 0x7e, 0xd6, 0x40, 0xa7, 0xb3, 0x06, 0xfa, 0x34, 0x6b, 0xa0, 0xaf, 0xb3, 0x06,
	0x1a, 0x2c, 0x6b, 0xf9, 0xf6, 0xf7, 0x00, 0x00, 0x00, 0xff, 0xff, 0x27, 0x78, 0x14, 0x9e, 0x33,
	0x05, 0x00, 0x00,
}
