// Copyright 2018 Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by go-bindata.
// sources:
// assets/static/css/all.css
// assets/static/css/dark_syntax.css
// assets/static/favicons/android-144x144.png
// assets/static/favicons/android-192x192.png
// assets/static/favicons/android-36x36.png
// assets/static/favicons/android-48x48.png
// assets/static/favicons/android-72x72.png
// assets/static/favicons/android-96x196.png
// assets/static/favicons/apple-touch-icon-180x180.png
// assets/static/favicons/favicon-16x16.png
// assets/static/favicons/favicon-32x32.png
// assets/static/favicons/favicon.ico
// assets/static/favicons/pwa-192x192.png
// assets/static/favicons/pwa-512x512.png
// assets/static/favicons/tile150x150.png
// assets/static/favicons/tile310x150.png
// assets/static/favicons/tile310x310.png
// assets/static/favicons/tile70x70.png
// assets/static/img/exclamation-mark.svg
// assets/static/js/misc.js
// assets/static/js/prism.js
// assets/static/js/prism.min.js
// assets/static/manifest.json
// assets/templates/404.html
// assets/templates/home.html
// assets/templates/layouts/base.html
// assets/templates/layouts/main.html
// assets/templates/modules/header.html
// assets/templates/modules/last-refresh.html
// assets/templates/modules/sidebar.html
// DO NOT EDIT!

package ctrlz

import (
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)
type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _assetsStaticCssAllCss = []byte(`@media screen {
    h1:before, h2:before, h3:before, h4:before {
        display: block;
        content: ' ';
        margin-top: -1.8em;
        height: 1.8em;
        visibility: hidden
    }

    html {
        overflow-y: scroll;
        position: relative;
        min-height: 100%
    }

    body {
        padding-top: 3.7rem;
        font-family: "Roboto", "Helvetica Neue", Helvetica, Arial, sans-serif;
        color: #ddd;
        background-color: #5a5a5a;
        font-weight: 300
    }
}

a {
    color: #e9ffaa;
    text-decoration: none;
    font-weight: 300
}

a:hover, a:focus {
    color: #de7d40;
    text-decoration: underline;
    font-weight: 300
}

a.disabled {
    color: #444;
    text-decoration: none;
    font-weight: 300
}

a.active {
    color: #de7d40;
    text-decoration: none;
    font-weight: 300
}

table, th, td, tr {
    padding: .5em
}

table {
    margin-left: 1em;
    margin-right: 1em
}

table p:first-of-type {
    margin-top: 0
}

table p:last-of-type {
    margin-bottom: 0
}

th {
    color: #fff;
    background-color: #68AAF7;
    font-weight: 400
}

tr.oneof > td {
    border-bottom: 1px dashed rgba(255, 255, 255, 0.1);
    border-top: 1px dashed rgba(255, 255, 255, 0.1)
}

table {
    border-collapse: separate;
    border-spacing: 0
}

th, td {
    border-left: 1px solid #ddd;
    border-top: 1px solid #ddd
}

tr:first-child th:first-child {
    border-radius: 4px 0 0 0
}

tr:first-child td:first-child {
    border-radius: 4px 0 0 0
}

tr:first-child th:last-child {
    border-radius: 0 4px 0 0
}

tr:first-child td:last-child {
    border-radius: 0 4px 0 0
}

tr:last-child td {
    border-bottom: 1px solid #ddd
}

tr:last-child td:first-child {
    border-radius: 0 0 0 4px
}

tr:last-child td:last-child {
    border-radius: 0 0 4px 0
}

tr th:last-child {
    border-right: 1px solid #ddd
}

tr td:last-child {
    border-right: 1px solid #ddd
}

thead + tbody tr:first-child td:first-child {
    border-radius: 0
}

thead + tbody tr:first-child td:last-child {
    border-radius: 0
}

code {
    color: #ccc;
    font-size: 80%;
    font-weight: 300;
    word-break: normal
}

pre {
    margin: 1em;
    max-height: 31em;
    border: 1px solid #777;
    border-left: 5px solid #777;
    border-radius: 4px;
    box-shadow: 3px 3px 8px #777;
    font-family: Consolas, Monaco, 'Andale Mono', 'Ubuntu Mono', monospace;
    text-align: left;
    white-space: pre;
    word-spacing: normal;
    word-break: normal;
    word-wrap: normal;
    line-height: 1.5;
    tab-size: 4;
    hyphens: none;
    background: #2d2d2d
}

pre code {
    display: block;
    color: #ddd;
    padding: .5em
}

pre code.command-output {
    padding: 0
}

pre code.command-output .command {
    padding: .5em .5em 0 .5em
}

pre code.command-output .output {
    color: #ddd;
    background-color: #404040;
    font-style: italic;
    padding: 0 .5em .5em .5em
}

pre code.command-output div:only-of-type {
    padding: .5em
}

@media print {
    pre {
        max-height: unset
    }
}

div.highlight {
    position: relative
}

button.copy {
    font-size: .8em;
    padding: 0 .5em;
    border-radius: .3em;
    background-color: #68AAF7;
    cursor: pointer;
    color: #fff;
    text-decoration: none;
    border: 0;
    position: absolute;
    top: 3px;
    right: 1.3em;
    z-index: 5
}

button.copy-hide {
    transition: opacity .4s ease-in-out;
    opacity: 0
}

button.copy-show {
    transition: opacity 1.2s ease-in-out;
    opacity: 1
}

p {
    font-size: 1rem;
    font-weight: 300;
    line-height: 1.5;
    margin: .25em 0
}

@media (min-width: 768px) {
    p {
        margin: 1.5em 0
    }
}

li, dt, dd {
    font-size: 1rem;
    font-weight: 300;
    line-height: 1.5;
    margin: .25em
}

ol, ul, dl {
    list-style: initial;
    font-size: 1rem;
    font-weight: 300;
    margin: 0 0 0 1.5em;
    padding: 0
}

li p, dt p, dd p {
    margin: .4em 0
}

ol {
    list-style: decimal
}

h1, h2, h3, h4, h5, h6 {
    border: 0
}

h1 {
    font-size: 2.5rem;
    color: #fff;
    font-weight: 400;
    margin: 30px 0
}

h2 {
    font-size: 2rem;
    color: #fff;
    font-weight: 400;
    margin-bottom: 20px;
    margin-top: 30px;
    padding-bottom: 10px;
    border-bottom: 1px solid #737373
}

h3 {
    font-size: 1.85rem;
    color: #f8f8f8;
    font-weight: 500;
    letter-spacing: 1px;
    margin-bottom: 20px;
    margin-top: 30px
}

h4 {
    font-size: 1.85rem;
    color: #f8f8f8;
    font-weight: 500;
    margin: 30px 0 20px
}

h4 + p {
    margin: 5px 0
}

@media (min-width: 768px) {
    h4 + p {
        margin: 10px 0
    }
}

h5 {
    font-size: 1.15rem;
    color: #f8f8f8;
    font-weight: 500
}

h6 {
    font-size: .9rem;
    color: #f8f8f8;
    font-weight: 500
}

.header-link {
    position: relative;
    left: 0.5em;
    top: -.1em;
    opacity: 0;
    font-size: 0.6em
}

h2:hover .header-link, h3:hover .header-link, h4:hover .header-link, h5:hover .header-link, h6:hover .header-link, dt:hover .header-link {
    transition: opacity .4s ease-in-out;
    opacity: 1
}

@media print {
    .header-link {
        display: none
    }
}

em {
    font-style: italic
}

strong {
    font-weight: 600
}

img {
    width: 100%
}

blockquote {
    display: block;
    margin: 1em 3em;
    padding-left: 1em;
    padding-right: 1em;
    background-color: #404040;
    border-radius: 4px 4px 4px 4px
}

.spacer {
    height: .1rem
}

@media (min-width: 768px) {
    .spacer {
        height: 1rem
    }
}

.deprecated {
    background: silver
}

.card {
    background-color: #5a5a5a;
    border-color: rgba(255, 255, 255, 0.1)
}

.card-header {
    border-bottom-color: rgba(255, 255, 255, 0.1)
}

#scroll-to-top {
    display: none;
    position: fixed;
    top: 3.7rem;
    right: 10px;
    z-index: 99;
    outline: none;
    background-color: rgba(90, 90, 90, 0.7);
    color: rgba(0, 0, 0, 0.4);
    cursor: pointer;
    padding: 3px 5px;
    border-radius: 10px;
    font-size: 1rem;
    border: 0;
    box-shadow: 0 0 2px 2px rgba(0, 0, 0, 0.4)
}

#scroll-to-top:hover {
    color: #de7d40
}

@media screen {
    .endnote-ref {
        display: none
    }
}

@media print {
    .col-md-9, .col-lg-7, .col-xl-8 {
        max-width: 83.2%;
        flex: 0 0 83.2%
    }

    .col-12 {
        max-width: 100%;
        flex: 0 0 100%
    }

    h1, h2, h3 {
        color: #000;
        background: none;
        page-break-after: avoid
    }

    img {
        max-width: 100% !important
    }

    pre, blockquote, img {
        page-break-inside: avoid
    }
}

header .navbar {
    background-image: linear-gradient(to right, #466BB0, #68AAF7);
    box-shadow: 0 0 2px 2px rgba(0, 0, 0, 0.14), 0 2px 4px 2px rgba(0, 0, 0, 0.28);
    padding-top: .2em;
    padding-bottom: .2em
}

header .navbar .logo {
    width: 2em;
    top: 3px;
    left: 1.3em;
    position: fixed;
    fill: #fff
}

header .navbar .logo circle {
    fill: #466BB0;
    stroke: #fff
}

@media (min-width: 768px) {
    header .navbar .logo {
        width: 3em;
        left: 0.8em
    }
}

header .navbar .brand-name {
    color: #fff;
    font-size: 1em;
    font-weight: 400;
    vertical-align: bottom;
    line-height: 1.1em;
    margin-left: 3.7em
}

header .navbar a {
    font-weight: 500
}

header .navbar a.active {
    border-bottom: solid 3px #fff;
    border-radius: 2px
}

header .navbar a.nav-link {
    color: #fff;
    font-size: .9em
}

header .navbar a.nav-link:hover {
    color: #de7d40
}

header .navbar .dropdown-menu {
    padding: 0;
    background-color: #5a5a5a;
    border-color: #ddd
}

header .navbar .dropdown-menu a {
    font-weight: 300
}

header .navbar .dropdown-menu i {
    color: #ddd
}

header .navbar-dark .navbar-nav .nav-link {
    color: #fff
}

header .navbar-dark .navbar-nav .nav-link:hover {
    color: #de7d40
}

header .navbar-dark .navbar-nav .nav-link:active {
    color: #de7d40
}

header .navbar-dark .navbar-nav .nav-link.active {
    color: #fff;
    cursor: default
}

header .navbar-dark .navbar-nav .nav-link.active:hover {
    color: #fff
}

header .navbar-dark .navbar-nav .nav-link.active:active {
    color: #fff
}

body.theme-dark i.dark {
    visibility: visible
}

body.theme-dark i.light {
    visibility: hidden
}

body.theme-light i.dark {
    visibility: hidden
}

body.theme-light i.light {
    visibility: visible
}

#navbar-links {
    position: static
}

#search_form {
    position: static;
    display: flex
}

#search_close {
    display: none
}

#search_show {
    display: none
}

#search_textbox {
    margin: 4px 0 5px 0;
    width: 100%
}

@media (min-width: 768px) {
    #navbar-links {
        position: absolute;
        right: -700px;
        transition: right 0.5s
    }

    #navbar-links.active {
        right: 1rem;
        transition: right 0.5s
    }

    #search_form {
        position: absolute;
        right: -700px;
        transition: right 0.5s
    }

    #search_form.active {
        right: 1rem;
        transition: right 0.5s
    }

    #search_close {
        display: block;
        background-color: transparent;
        color: #fff;
        border-width: 0;
        cursor: pointer
    }

    #search_close:hover {
        color: #de7d40
    }

    #search_show {
        display: block
    }

    #search_textbox {
        width: calc(1rem * 22)
    }
}

footer {
    background-image: linear-gradient(to right, #466BB0, #68AAF7);
    color: #fff;
    position: absolute;
    bottom: 0;
    width: 100%;
    height: 7rem;
    overflow: hidden;
    padding: 1rem 0 1.5rem;
    text-align: center
}

@media (min-width: 576px) {
    footer {
        padding: 1.5rem 0 1rem 0
    }
}

footer .icon {
    position: relative;
    display: inline-flex;
    padding: 4px;
    border-width: 2px;
    border-color: transparent;
    border-style: solid;
    border-radius: 2px;
    color: #fff
}

footer .icon a {
    text-decoration: none
}

footer .icon svg {
    width: 35px;
    height: 35px;
    fill: #fff
}

footer .icon span {
    opacity: 0;
    background-color: transparent;
    color: #fff;
    text-align: center;
    position: absolute;
    z-index: 1;
    width: 200px;
    left: -78px;
    top: -23px;
    font-size: 75%
}

footer .icon:hover {
    border-color: white;
    border-radius: 25px;
    box-shadow: 0 0 2px 2px #fff;
    transition: border-radius 1s, border-color 1s ease
}

footer .icon:hover span {
    opacity: 1;
    transition: opacity .5s
}

footer .copyright {
    padding: 0;
    margin: 0;
    color: #ccc;
    line-height: 1.6em;
    font-size: 0.7em;
    text-align: right !important
}

@media (min-width: 992px) {
    footer .copyright {
        text-align: center !important
    }
}

footer .tag {
    padding: 0;
    font-style: italic;
    margin: 0;
    line-height: 1.6em;
    font-size: 0.8em
}

@media screen {
    .row-offcanvas .sidebar-offcanvas {
        transition: all .4s ease;
        z-index: 42;
        left: -1500px;
        width: auto;
        max-width: 80%;
        top: 3.7rem;
        position: absolute
    }

    .row-offcanvas.active .sidebar-offcanvas {
        left: 2rem
    }
}

@media screen and (min-width: 768px) {
    .row-offcanvas .sidebar-offcanvas {
        position: unset
    }
}

.sidebar {
    order: 0;
    font-size: 85%
}

@media (min-width: 992px) {
    .sidebar {
        font-size: 100%
    }
}

@supports (position: -webkit-sticky) or (position: sticky) {
    .sidebar {
        position: -webkit-sticky;
        position: sticky;
        top: 3.7rem;
        z-index: 1000
    }
}

@supports (position: -webkit-sticky) or (position: sticky) {
    .sidebar .directory {
        max-height: calc(100vh - 9rem)
    }
}

@media (min-width: 1200px) {
    .sidebar .directory {
        max-width: 25em
    }
}

@media (min-width: 768px) {
    .sidebar .directory {
        display: block !important
    }

    @supports (position: -webkit-sticky) or (position: sticky) {
        .sidebar .directory {
            max-height: calc(100vh - 9rem);
            overflow-y: auto
        }
    }
}

.sidebar .directory a {
    font-weight: 300
}

.sidebar .directory ul {
    list-style: none;
    padding: 0;
    padding-left: .2em;
    margin-bottom: 0;
    margin-left: 0;
    margin-right: .3em
}

.sidebar .directory li {
    display: inline-block;
    padding: 2px 0 1px 16px;
    width: 100%;
    font-size: 85%
}

.sidebar .directory li .current {
    color: #de7d40;
    font-weight: 500
}

.sidebar .directory li.sublist {
    padding-left: 0
}

.sidebar .directory li.sublist i {
    width: 12px
}

.sidebar .directory .card-body {
    padding: .5em .1em
}

.sidebar .directory .card-body > ul {
    padding-left: 0
}

.sidebar .directory .card {
    margin-top: .1rem;
    margin-bottom: .1rem
}

.sidebar .directory .card-header {
    padding: 0
}

.sidebar .directory .card-header div {
    padding: .75em 1.25em
}

@media (min-width: 992px) {
    .sidebar .directory .card-body {
        padding-left: 1.25rem;
        padding-right: 1.25rem
    }

    .sidebar .directory li {
        font-size: 100%
    }

    .sidebar .directory ul {
        padding-left: 1em
    }
}

.tree-toggle {
    cursor: pointer;
    margin-bottom: 0
}

.sidebar-toggler {
    position: absolute;
    top: 0;
    left: 10px;
    z-index: 99;
    outline: none;
    background-color: rgba(90, 90, 90, 0.7);
    color: rgba(0, 0, 0, 0.4);
    cursor: pointer;
    padding: 3px 5px;
    border-radius: 10px;
    font-size: 1rem;
    border: 0;
    box-shadow: 0 0 2px 2px rgba(0, 0, 0, 0.4)
}

.sidebar-toggler:hover {
    color: #de7d40
}

@media print {
    .sidebar-toggler {
        display: none
    }
}

.toc {
    order: 0
}

@supports (position: -webkit-sticky) or (position: sticky) {
    .toc {
        position: -webkit-sticky;
        position: sticky;
        top: 3.7rem;
        z-index: 1000
    }
}

.toc .directory {
    border-left: 1px solid rgba(255, 255, 255, 0.1);
    padding-left: .5em
}

@supports (position: -webkit-sticky) or (position: sticky) {
    .toc .directory {
        max-height: calc(100vh - 9rem)
    }
}

@media (min-width: 1200px) {
    .toc .directory {
        max-width: 25em
    }
}

@media (min-width: 768px) {
    .toc .directory {
        display: block !important
    }

    @supports (position: -webkit-sticky) or (position: sticky) {
        .toc .directory {
            max-height: calc(100vh - 9rem);
            overflow-y: auto
        }
    }
}

.toc .directory li {
    font-size: .9rem
}

.toc .directory li a {
    font-weight: 300
}

.toc .directory li a.current {
    color: #de7d40;
    font-weight: bold
}

.toc .directory ul {
    list-style-type: none !important;
    padding-left: 0;
    padding-bottom: 0;
    margin: 0
}

.toc .directory ul ul {
    padding-left: 1em
}

.toc-inlined {
    padding-bottom: 1em
}

.toc-inlined .directory {
    border-left: 0
}

.toc-inlined .directory li {
    font-size: 1rem
}

.toc-inlined .directory ul {
    list-style-type: none !important;
    padding-left: 0;
    padding-bottom: 0;
    margin: 0
}

.toc-inlined .directory ul ul {
    padding-left: 1em
}

.toc-inlined .directory ul a {
    font-weight: 300
}

figure {
    margin: 1.5rem auto;
    padding: .5rem;
    background-color: #a3a3a3;
    border-radius: 4px 4px 4px 4px
}

figure .wrapper-with-intrinsic-ratio {
    position: relative;
    height: 0
}

figure .element-to-stretch {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%
}

figcaption {
    text-align: center;
    font-size: 1.15rem;
    font-style: italic;
    font-weight: 400;
    color: #fff;
    padding-top: .5rem
}

.faq .card {
    border-color: #ddd;
    margin-bottom: 2em;
    border-radius: 4px
}

.faq .card-header {
    color: #fff;
    background-color: #ddd
}

.glossary .trampolines {
    font-size: 1.85rem;
    text-align: center;
    padding-top: .8rem
}

.glossary .entries h4 {
    font-size: 1.65rem;
    font-weight: 300;
    border-bottom: 1px solid;
    color: #ccc;
    border-color: #ccc;
    margin-top: 2.2rem;
    margin-bottom: .15rem
}

.glossary .entries dl {
    margin-left: 0
}

.glossary .entries dl dt {
    font-weight: 600;
    list-style-type: none;
    margin-bottom: 0;
    margin-top: .8rem;
    margin-left: 0
}

.glossary .entries dl dd {
    list-style-type: none;
    margin-left: 2rem;
    margin-top: 0;
    line-height: 130%
}

.section-index li.directory {
    margin: 0;
    padding: 0;
    margin-top: 15px;
    margin-left: 0
}

.section-index li.file {
    margin: 0;
    padding: 0;
    margin-top: 10px
}

.section-index a {
    font-weight: 400
}

.section-index ul {
    list-style: disc
}

.section-index ul > li > ul {
    list-style: circle
}

.section-index ul > li > ul > li > ul {
    list-style: square
}

.section-index ul > li > ul > li > ul > li > ul {
    list-style: disc
}

.btn.btn-istio {
    background-color: #68AAF7;
    color: #fff;
    font-weight: 400;
    letter-spacing: 1px;
    cursor: pointer
}

.btn.btn-istio:hover {
    background-color: #466BB0
}

.btn.btn-istio:active {
    background-color: #e07484
}

.notfound {
    text-align: center
}

.notfound .icon {
    margin-top: 9rem
}

.notfound .icon img {
    height: 12rem
}

.notfound .error {
    padding: 2rem 0 0 0;
    font-weight: 70%;
    font-size: 200%
}

.notfound .explanation {
    padding: 2rem 0 9rem 0;
    font-weight: 300;
    font-size: 100%
}

p.last-refresh {
    font-style: italic;
    font-size: 80%;
}
`)

func assetsStaticCssAllCssBytes() ([]byte, error) {
	return _assetsStaticCssAllCss, nil
}

func assetsStaticCssAllCss() (*asset, error) {
	bytes, err := assetsStaticCssAllCssBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/css/all.css", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticCssDark_syntaxCss = []byte(`/* // Copyright 2018 Istio Authors */
/* // */
/* // Licensed under the Apache License, Version 2.0 (the "License"); */
/* // you may not use this file except in compliance with the License. */
/* // You may obtain a copy of the License at */
/* // */
/* //     http://www.apache.org/licenses/LICENSE-2.0 */
/* // */
/* // Unless required by applicable law or agreed to in writing, software */
/* // distributed under the License is distributed on an "AS IS" BASIS, */
/* // WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. */
/* // See the License for the specific language governing permissions and */
/* // limitations under the License. */

/* PrismJS 1.14.0
http://prismjs.com/download.html#themes=prism-tomorrow&languages=clike+javascript+bash+docker+go+java+protobuf+python+yaml */
/**
 * prism.js tomorrow night eighties for JavaScript, CoffeeScript, CSS and HTML
 * Based on https://github.com/chriskempson/tomorrow-theme
 * @author Rose Pritchard
 */

.token.comment,
.token.block-comment,
.token.prolog,
.token.doctype,
.token.cdata {
    color: #999;
}

.token.punctuation {
    color: #ccc;
}

.token.tag,
.token.attr-name,
.token.namespace,
.token.deleted {
    color: #e2777a;
}

.token.function-name {
    color: #6196cc;
}

.token.boolean,
.token.number,
.token.function {
    color: #f08d49;
}

.token.property,
.token.class-name,
.token.constant,
.token.symbol {
    color: #f8c555;
}

.token.selector,
.token.important,
.token.atrule,
.token.keyword,
.token.builtin {
    color: #cc99cd;
}

.token.string,
.token.char,
.token.attr-value,
.token.regex,
.token.variable {
    color: #7ec699;
}

.token.operator,
.token.entity,
.token.url {
    color: #67cdcc;
}

.token.important,
.token.bold {
    font-weight: bold;
}
.token.italic {
    font-style: italic;
}

.token.entity {
    cursor: help;
}

.token.inserted {
    color: green;
}

`)

func assetsStaticCssDark_syntaxCssBytes() ([]byte, error) {
	return _assetsStaticCssDark_syntaxCss, nil
}

func assetsStaticCssDark_syntaxCss() (*asset, error) {
	bytes, err := assetsStaticCssDark_syntaxCssBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/css/dark_syntax.css", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsAndroid144x144Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x90\x00\x00\x00\x90\b\x03\x00\x00\x00\u0418\x12\x8a\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x00\xc3PLTEFk\xb0n\x8b\xc1\xa2\xb5\xd8b\x82\xbc\xa3\xb5\u063a\xc8\xe2\xfc\xfc\xfdYz\xb8\xff\xff\xff\xa8\xba\xda\xf2\xf5\xf9Lp\xb2\x91\xa7\xd0\xe2\xe8\xf2Hm\xb1\x85\x9e\xcb\xd7\xdf\xee\xc0\xcc\xe4b\x81\xbc\xb4\xc3\xdf\xf8\xf9\xfcRt\xb5\x9d\xb0\xd5\xeb\xef\xf6\x8b\xa2\xcez\x94\xc6\xcb\xd6\xe9\xfe\xfe\xfet\x90\xc4\xd1\xda\xec\xd1\xda\xeb\xf0\xf3\xf9\xd2\xdb\xec\xb1\xc1\xdew\x92\u0178\xc6\xe0\xcc\xd6\xe9\xe1\xe7\xf2\xf6\xf7\xfb\xf4\xf6\xfaOr\xb4\xf0\xf3\xf8\xb2\xc1\u0793\xa9\xd1u\x90\xc4Uw\xb6e\x83\xbd\x8e\xa5\u03e3\xb5\u05f7\xc5\xe0\xe0\xe7\xf2\xf5\xf7\xfb\xc2\xce\xe5\xcd\xd7\u95ec\xd3`\x80\xbbt\x90\xc3\xd0\xda\xeb\xe3\xe9\xf3\xab\xbc\xdb\xfd\xfd\xfe\x9a\xaf\u053d\xca\u319e\xccRu\xb5\xeb<&\xab\x00\x00\x00\x01bKGD\b\x86\u0795z\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x02tIDATx\xda\xed\xd6\xdbR\xd4P\x10\x85\xe1\x80\x02[p`\x06\x0f@L#\x8a\a\xd4Q9\xa8\b\n\xf8\xfeO\xe5\x85U\x90\xc4}Jfw\xf7\xaa\xa2\xd7u\xaa\xe6\xab\xdes\xf1W\x95\xcdf\xb3\xd9l6\x9b\xcd\u01bd%4\xd0\xf2\x030\xd0\xc3\x154\xd0\xea\x1a\x18\xc8=B\x03\xado\x80\x81\xdcc4\xd0d\x13\f\xe4\xb6\xd0@S4\x90[B\x03\xcd\xd0@\xab\xdb` \xf7\x04\r\xf4\xf4\x19\x18\xc8=G\x03\xedl\x82\x81\xdc.\x1ah\x82\x06r{h\xa0\x1a\r\xf4b\x1b\f\xe4V\xd0@ q}\a\x02\x89\xeb\x16\b#\xae[ \x8c\xb8n\x83 \xe2\xba\r\x82\x88\xeb\x0eh\x8a\x06B\x88\xeb.h\x86\x06\x02\x88\xeb.\b \xae{ \xfd\xb8\xee\x81T\xe3\xba\xf1\x814\xe3\x9a| \u0178n\x9c\x17\xa4\x17\xd7\xe4\a\xa9\xc5u\xe3\x02\xa0Z\xed@\x01\x90R\\7.\x04R\x8ak\n\x83T\xe2\xbaqa\x90J\\S\f\xa4\x10\u05cd\x8b\x81\x14\xe2\x9a\xe2 \xf1\xb8\xfew\xa00H<\xae)\x05\x9a\xaa\x1c(\x02\x12\x8ekJ\x83f\x1a\a\x8a\x81D\xe3\x9a2@\x92q}{\xa0(H0\xae)\v$\x17\xd7w\a\x8a\x83\xc4\xe2\x9a2ARq\xdd:P\x024\x11?P\x02$\x13\xd7\xed\x03\xa5@\xb5\xf4\x81R \x89\xb8\xee\x1c(\x05\x92\x88k\x1a\x04\xe2\x8f\xeb\ue052 \xfe\xb8\xa6\x81 \xee\xb8\xee\x1d(\r\xe2\x8ek\x1a\f\xe2\x8d\xeb\xfe\x812@\xbcqM#@S\xc9\x03\xe5\x808\xe3\x9aF\x81f\x82\a\xca\x02\xf1\xc55\x8d\x03\xb1\u0175\xe7@y \xae\xb8\xa6\xb1 \xa6\xb8\xf6\x1d(\x13\xc4\x13\xd74\x1e\xc4\x12\xd7\xde\x03\xe5\x82&R\a\xca\x051\u0135\xff@\u0660Z\xe8@\u0660\xe2q\x1d8P6\xa8x\\\u04e2\xa0\xc2q\x1d:P>\xa8p\\\xef{\u007f\xe3\xe5\xc1\xab\xaa\xaa\xaa\u05c7o\u07beK\x82\xde\x1fq\x1e\xe8\xc3\xfe\xc7O\xf3\xcf\xedO\x8e\xbe\xec}=>\xa9O\xcfD\xe2\x9ab\x94\u0782\xb2\x82q\xdd\xe4QR\xb2rq\xfdm % \xfb^\xd9l(\x9b\x1f\x97\u060f\xf3r\xa2\x9f\x17n\xc1]\xfe\x9a\x97\xcd\xd8EH\xbf\x0f\xae\xce\x19\xdem$i\xfd\xfa\xe6\x0f\xd7_i8\xa9\xf8C-Bbz\xa8\x91$\u0387\x1aNb\u007f\xa8!$\xa1\x87\xca$I>T\x9a$\xfeP1\x92\xd2C\x05H\x9a\x0f\xf5?I\xfd\xa1l6\x9b\xcdf\xb3\xd9l\xf7m\u007f\x01\u00d0\x88\xfcT!\x89\xc6\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsAndroid144x144PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsAndroid144x144Png, nil
}

func assetsStaticFaviconsAndroid144x144Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsAndroid144x144PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/android-144x144.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsAndroid192x192Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\xc0\x00\x00\x00\xc0\b\x03\x00\x00\x00e\x02\x9c5\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x01qPLTEFk\xb0\x85\x9e\xcb\xc3\xcf\xe5Z{\xb8\xc5\xd1\u7a3a\xda\xf2\xf5\xf9Rt\xb5\xff\xff\xff\x9d\xb0\xd5\xeb\xef\xf6Hm\xb1\xd7\xdf\xeet\x90\xc4\xcb\xd6\xe9\xfe\xfe\xfeb\x81\xbc\xb4\xc3\xdf\xf8\xf9\xfc\xa3\xb5\xd8Lp\xb2\x91\xa7\xd0\xe2\xe8\xf2z\x94\xc6\xd1\xda\xecn\x8b\xc1\xc0\xcc\xe4\xfc\xfc\xfdYz\xb8_\u007f\xbb\xae\xbe\u073a\xc8\xe2Qt\xb4\xf3\xf5\xfa\xf3\xf6\xfa\xf4\xf6\xfa\xa2\xb4\u05e9\xba\xda\xe9\xee\xf6\xf6\xf8\xfb\xd8\xe0\xee\xb9\xc7\u16ae\xd4z\x95\xc7[|\xb9Gl\xb1o\x8c\u0083\x9c\u0298\xad\u04ed\xbd\xdc\xc2\xce\xe5\xeb\xef\xf7\xda\xe1\xef\xbb\xc8\u2730\xd5|\x96\xc7]}\xbaGl\xb0\\|\xb9q\x8d\u0086\x9e\u031b\xaf\u0570\xc0\xdd\xc4\xd0\xe6\xd9\xe1\xef\xee\xf2\xf8\xfe\xfe\xff\xf9\xfa\xfd\xdc\xe3\xf0\xbd\xca\u3771\xd6~\x98\xc8Jn\xb2\x89\xa1\u0372\xc1\xde\xc7\xd2\xe7\xf1\xf4\xf9\xfb\xfc\xfd\xde\xe5\xf1\xbe\xcb\u37f3\u0580\x9a\xc9a\x81\xbcKo\xb2v\x91\u014b\xa2\u03a0\xb3\u05f5\xc4\xdf\xca\xd5\xe8e\x84\xbd\x84\x9c\xcbe\x83\xbdMq\xb3\x8f\xa5\xcfg\x85\xbeQt\xb5\xa5\xb7\xd8\xd1\xda\xebMp\xb3\xd3\xdc\xec\xcf\xd9\ua5ec\xd3`\x80\xbbPs\xb4r\x8e\xc3\xe0\xe6\xf2l\x89\xc0\xf0\xf3\xf8\xba\xc8\u109b\xca\xdd\xe4\xf0\xfa\xfb\xfd\x94\xa9\xd1\xed\xf0\xf7\xb6\xc5\xe0\u007f\x99\xc9Nq\xb3\xc6\xd1\xe6\xf8\xfa\xfc\xc8\xd3\xe7j\x88\xc0\x8d\xa4\xcfWx\xb7[\xdb\xea\xcf\x00\x00\x00\x01bKGD\b\x86\u0795z\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x03DIDATx\xda\xed\x9ciS\xd3`\x18E\x83H\xfb*m@\"\xa5\xadV[\x04q\xab\xfbB\x05\x05\x11\xc1\rpGEk\xc5\x05D\xc5\x15\xb7_\xef\a)$i\x967\xa5c\x9e;s\xcf\u7d1337I{\xa635\fB\b!\x84\x10B\b!\x84\x10B\b!\x84\x10B\b!\xa45\xb4\xa1\vlk\a\x17\xd8\u0781.\x90H\x82\v\xa8\x1d\xe8\x02;;\xc1\x05T\x1b\xba@\n]@\xa5\xd1\x05Lt\x81\xaenp\x01\xb5\v]\xa0'\t.\xa0,t\x81\xc4np\x01\u054b.\x90A\x17P}\xe8\x02Yt\x01\x95C\x17\u0223\v\xec\xd9\v.\xa0:\xd0\x05@\xe3xS\x004\x8em\x02\x98ql\x13\xc0\x8cc\xbb@\n]\x002\x8e\x1d\x02&\xba\x00b\x1c;\x04\x10\xe3\xd8)\x00\x18\xc7N\x01\xc08v\t\xe0\u0171K\x00/\x8e\xdd\x02Hq\\\xf0\x12\x00\x8a\xe3\xe4>O\x01\x9c8\xb6\xf6{\n\xc0\xc4q\xb1\xe4#\x80\x12\u01d6\xf2\x11\x00\x89\xe3b\xc9O\x00$\x8e-\xe5+\x00\x11\xc7\u0152\xbf\x00D\x1c[*@\x00 \x8e\x8b\xa5 \x01\x808\xb6T\xa0@\nb\x80\x00\x01\xf1ql\xa9\x10\x01\x13a\x80 \x01\xe1q\xfco\x80 \x01\xd9q\xbc>@\xa0\x80\xe88^\x1f P@r\x1c\xd7\a\b\x16\x10\x1c\xc7\xf5\x01\x82\x05\xe4\xc6\xf1\xc6\x00!\x02\x19\xf1\x03\x84\bH\x8d\xe3\xcd\x01\xc2\x04\xb2\xd2\a\b\x13\x90\x19\u01f6\x01B\x05\xf2\xc2\a\b\x15\x90\x18\xc7\xf6\x01B\x05$\u01b1}\x80p\x01yq\xec\x18 \\@^\x1c;\x06\xd0\x10\x90\x16\xc7\xce\x014\x04\xa4\u0171s\x00\x1d\x81\x94\xe4\x01t\x04d\u0171k\x00-\x01S\xf0\x00Z\x02\x92\xe2\xd8=\x80\x96\x80\xa08n\x18@O@N\x1c7\f\xa0' &\x8e\x1b\a\xd0\x14\x90\x12\u01cd\x03h\n\b\x89c\x8f\x01t\x052R\a\xd0\x15\x10\x11\xc7^\x03h\vd\x85\x0e\xa0-  \x8e=\a\xd0\x17\xc8\xcb\x1c@_ \xf68\xf6\x1e@_ \xf68\xf6\x1e \x82@\xccq\xec3@\x04\x81\x98\xe3\xd8g\x80(\x02\xb1\u01b1\xdf\x00Q\x04b\x8dc\xbf\x01\"\t\xc4\x18\xc7\xc9~\x9fs:0`\x18\x861xP\xcf -i\x80\xa1C\x87\x8f\x1c=V?\xa0\xdc~\xfc\xc4\xc9S\xa7Sg\xbaD\u01b1\xf3\x0e\xe89{\xee\xfc\x85\xe1\x8a\xf7\xa1\x9d\x17GF/]\x1e\x1b\xbf2!)\x8e\xeb\x03\\\x9d\xbc65]\xa8h\xbd\xe6z!}c\xea\xe6\xad\xc9\xdb\x02\xe2\xb8XR3\xb3sw\xee\xde+7\xf3\xea\xfb\xdd\x0f\x1e>\x9a\u007f<\xdb\x1f_\x1c?y\xba\u040a\xb7y\xb6\xd0\xf7\xbcj\x10B\xfe?/j/[\xc3\xfc\xf4bL\n#\xaf\xd4V\x99y\xfd\xe6m\x9c+lM!17\xba\x14\xfb\x85\xb4l6y\xf6\xef\x06\x97\x85\xfcL\xb6b6s\xe1\fK\xba\x9d\xa3)\xbc\xff\xf0qI\xdc\x13I[a\xb5\x96+\xcb|\xa8j(|2?\x8b\xfe\xe7\xb9`\x85/_\xbf}\x17\xff\xd1\u6af0Z\xcbU\f\bV\xd6\x1aN\xfe\xc7\xcf^\xa8\xbf,\xac\xae\xb9.\x9cE\x03\x8d\xba\xc2\xc4\xf8\xc0\xaf\x8a\x01IuM\r\x8d\xfd\xfe\x83\xfcM\xb5\xc0/\xeb\x84\x10B\b!\x84\x10B\b!\x84\x10B\b!\x84\x10\"\x93\xbfC\u0375\xbd\x1b<\xccs\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsAndroid192x192PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsAndroid192x192Png, nil
}

func assetsStaticFaviconsAndroid192x192Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsAndroid192x192PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/android-192x192.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsAndroid36x36Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00$\x00\x00\x00$\b\x03\x00\x00\x00\xd6\xdeh\xaa\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x00<PLTEFk\xb0\x8b\xa2\xce\xd1\xda\xec\xff\xff\xfft\x90\u013a\xc8\xe2]}\xba\xf3\xf6\xfaQt\xb5\xa3\xb5\xd8\xe8\xec\xf5\xd0\xda\xeb\xc5\xd1\u7bbe\u0757\xac\xd3h\x86\xbf\x80\x99\xc9\xe8\xed\xf6\xdd\xe4\xf1\xf4\xf6\xfb0V\x8c\xd7\x00\x00\x00\x01bKGD\x03\x11\fL\xf2\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x00\x98IDAT8\xcb\xdd\xd4\xdb\x0e\x83 \f\x80a{R\xf1\xec\xf6\xfe\xef\xaa\xe8\x14\x97\xd8\xd2\xec\xceq\xfd\xe5\x0f\x14\xb1(\xfef\x81\a\xa1\a\x11{\x90x\x10\x95\x1e$\x1eT\xd5\x0eD!C\ua21a\f\n\x11\x91=P\xc6\r\xd9)\u07119P\xa6\x0fj\xad\u0401\x8c\x812\x9dH\x8c\u0409\xd4\xd4\x1aJ(\u8844\x94\xbb\x89\xa1\x84\x94\x81\xe27j\xd4\xd0\x05\u0766:\xec\a\xde622\x84\x1e\x11\u007f}J\xa5\xb4\xd7%\xd3\xfd\xf1`>\xb6\xf3\x1aF\xe3a\xae\xec\xddA\xee\xf3\x85\xe9!?\x9a\x059\xa5\x03\xf1\xc2@\xcb\xf6\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsAndroid36x36PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsAndroid36x36Png, nil
}

func assetsStaticFaviconsAndroid36x36Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsAndroid36x36PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/android-36x36.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsAndroid48x48Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\x00\x000\b\x03\x00\x00\x00`\xdc\t\xb5\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x00\x93PLTEFk\xb0n\x8b\xc1\xa2\xb4\xd7b\x81\xbc\xa3\xb5\u063a\xc8\xe2\xfc\xfd\xfeYz\xb8\xff\xff\xff\xa8\xba\xda\xf2\xf5\xfaLp\xb2\x91\xa7\xd0\xe2\xe8\xf3Hm\xb1\x85\x9e\xcb\xd7\xdf\xee\xc0\xcc\xe4t\x90\xc4\xd1\xda\xec\xb4\xc3\xdf\xf8\xfa\xfcRt\xb5\x9d\xb0\xd5\xeb\xef\xf7\x8b\xa2\xcez\x94\xc6\xcb\xd6\xe9\xfe\xfe\xff\xf4\xf6\xfb\xae\xbe\xddv\x91\u0138\xc6\xe1\xcc\xd6\xe9\xe1\xe7\xf2\xf5\xf7\xfb\x83\x9b\xca\xc5\xd1\u75ec\xd3Qt\xb5Nq\xb3d\x83\xbdy\x94\u018d\xa4\u03b7\xc5\xe0\xe0\xe6\xf2\xcd\xd7\xea]}\xba\xe8\xed\xf6\x91\xef\xc6\xe0\x00\x00\x00\x01bKGD\b\x86\u0795z\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x00\xd9IDATH\xc7\xed\xd4\xc7\x12\x820\x10\x80a\xaa\xae\x05\xd4\u0106\bv\xb0\xeb\xfb?\x9d\x87P\"b\xb2\xebxdo\xcc\xf0\xf1\x93\x19\x16\xc3h\xe6\xe71\xa9\xc0\xb2\x89\xc0q\xa9\xa0\xd5&\x02\xe8PA\xb7G\x04\u0427\x02\xcf'\x02\x18P\xc1\x90\n\xc0\xa4\x82\x11\xfav&@\v\xfd}p\x01`\x8c\r@\x06&Sd \a0C\x06\n0\xf7q\x81\x02@\x80\v\x94\xc0\xc3\x05J\x00\vT@\x02!* \x81\xa5\x8d\tH\x00\\L@\x06\x9a\xe5\x16\x01\x19h\x96\x9b\u007f\x02\xe5rg\x817\xa0\\n^\a\x14\xcb-\x02\x11\x8f\x8d\xd5z\xb3\xdd\xe5b\xff\x15\x1cx\x9c\xb0\xb4\xb8<\x9e\xce\x17\xe7\x1a\xde\xee\xff\xfb\xc93\xabn\x92\x87Bp\xa8\xcc3f\x9a\x88L\xb8\xea\xe1U\x12\xb9A\x8a>\n\u05feH3\xeay\x01\x19\x82\x10\xf6\xd8\xcdg\xff\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsAndroid48x48PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsAndroid48x48Png, nil
}

func assetsStaticFaviconsAndroid48x48Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsAndroid48x48PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/android-48x48.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsAndroid72x72Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00H\x00\x00\x00H\b\x03\x00\x00\x00b3Cu\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x00\xc0PLTEFk\xb0h\x86\xbfMp\xb3t\x90\u0111\xa7\xd0\xe2\xe8\xf2Hm\xb1\xff\xff\xff\x85\x9e\xcb\xd7\xdf\xeen\x8b\xc1\xc0\xcc\xe4\xfc\xfc\xfdb\x81\xbc\xb4\xc3\xdf\xf8\xf9\xfcRt\xb5\x9d\xb0\xd5\xeb\xef\xf6\x8b\xa2\xcez\x94\xc6\xcb\xd6\xe9\xfe\xfe\xfe\xba\xc8\xe2Yz\xb8\xa3\xb5\u0628\xba\xda\xd1\xda\xec\xf2\xf5\xf9Lp\xb2\xf4\xf6\xfb\xe0\xe7\xf2\xf5\xf7\xfb\xe5\xea\xf4\xae\xbe\u0757\xac\xd3Qt\xb5Or\xb4e\x83\xbd\x8e\xa5\u03e3\xb5\u05f7\xc5\xe0\xc5\xd1\xe7\xcd\xd7\xe9r\x8e\xc3\xc6\xd1\xe6\xd1\xda\xeb\xca\xd5\u86ae\xd4`\x80\xbb\xf4\xf6\xfa\xed\xf0\xf7\xb6\xc5\xe0\u007f\x98\xc8\xfe\xfe\xff\xd9\xe1\uf8b4\xd7j\x88\xbfGl\xb0\xf8\xfa\xfc\xc8\xd3\u7426\xd0Wx\xb7\xee\xf1\xf8`\xaf(N\x00\x00\x00\x01bKGD\a\x16a\x88\xeb\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x01JIDATX\xc3\xed\xd7\xd9N\xc2P\x10\x80\xe1b-#\x02\"Bq\x19EQ@T6\xf7]\xdf\xff\xad\xb8@\xca\xd9\xdat\xe6LbH:\x97M\xe6\xcb9M\xf3'\r\x82b\x8a\u0668)m\tA\xe1\xb6\x14\x14\x95\x85 \u0611\x82*R\x10\xecJAU)\xa8V\x17\x82`O\nj\xec\vA\u0414\x82\x0e\xcaB\x10\xb4\xa4\xa0H\n\x82\xb6\x14\x14KA\x9d\xba\x10\x04\x87\x9eL\x02\u054e\xbc\x9c\xe3\x04\x82\x13\x1f\b\x15\xe8\xf4\xcc\xe7\xfd(\x10x\xc4\x1b5\x88\x1f\xef\x104\x88\x1fo4\xa0\x8a\xc7\x17\xa4A\xdcx\xa3\x05U\xf9\x9f\xb4\x0e\xf1\xe2\x8d6\u010a\xf7\x120 N\xbc\xd1\x051\xe2\xfd\xb7oB\xf4x\xa3\x1b\"\xc7{\xb5nA\x11\xef@6D\x8cw\xb2mC1\xeb@\x0e\x88\x14\xef\xf5\xb2\r\x91\xe2\x8dY\x10!\xde\u02ae\x03\"\xc4\x1b\xb3\xa1\xdc\xf1VW]P\xeex+\a\uad82\xd2\xf9\x85\t\xf5(\a\xea\xe2\xe5U\xd8_>\x19\f\xdb\u05e3\x9bx-\xe6\x8b\xf7\xadB\x18\xb3\x12\xef6\xf4\xbfj<\x99f\xcfl~\x9fO\xea\x8f\x1e u\x1e\x9f\x9e\t?p)\xd4\xcb\xeb\xdb\xfb\a\xf1~6\xf5\xf9\xf5\xfd\xc3zU\x1aE\xbbP\n\u0179\x90M\xfdr/TL1\xff:\v\xae\xfd*u?\xc5R\xa1\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsAndroid72x72PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsAndroid72x72Png, nil
}

func assetsStaticFaviconsAndroid72x72Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsAndroid72x72PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/android-72x72.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsAndroid96x196Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00`\x00\x00\x00`\b\x03\x00\x00\x00\xd5F\x87\n\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x00\x9cPLTEFk\xb0n\x8b\xc1\xc0\xcc\xe4\xfc\xfc\xfdb\x81\xbc\xff\xff\xff\xb4\xc3\xdf\xf8\xf9\xfcRt\xb5\x9d\xb0\xd5\xeb\xef\xf6Hm\xb1\x8b\xa2\xce\xe2\xe8\xf2z\x94\xc6\xcb\xd6\xe9\xfe\xfe\xfe\xba\xc8\xe2Yz\xb8\xa8\xba\xda\xf2\xf5\xf9Lp\xb2\x91\xa7\u0405\x9e\xcb\xd7\xdf\xeet\x90\xc4\xd1\xda\xec\xf0\xf3\xf9\xb2\xc1\u0793\xa8\xd1Tv\xb6Or\xb4e\x83\xbd\x8e\xa5\u03e3\xb5\u05f7\xc5\xe0\xe0\xe7\xf2\xf5\xf7\xfb\xc2\xce\xe5\xcd\xd7\xe9t\x90\xc3\xd0\xda\xeb\xfd\xfd\xfe\xd2\xdb\uc6af\xd4`\x80\xbb\xbd\xca\u319e\xccRu\xb5\xe3\xe9\xf3\xab\xbc\xdbu\x90\xc4\xc2C\x12C\x00\x00\x00\x01bKGD\x05\xf8o\xe9\xc7\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x01}IDATh\xde\xed\xd5\xd7N\xc40\x10\x85ao\x19Z\u0206\xb2\xc0z\xe8\xbd\xf7\xf7\u007f7.@\x10;\x1e'\xd8s\x90\x90<\x0f\xe0O\xc77\xbf1\xe5\u0295+\xf7\xdfn\x84\x06\xc6h`2\x05\x03\xb4\x84\x06\x96W\xc0\x00\xad\xa2\x81\xb5\n\f\xd0:\x1a\xa8\xd1\x00\xcd\xd0@\x83\x066\xa6`\x806\xd1\xc0d\v\f\xd06\x1a\x98\xef\x80\x01\xdaE\x03u\x05\x06h\x0f\r,\xd0\x00\x8d\xd0\xc0\x18\r\xa0\xe2\xfc\r \xe2l\x1d\x00\x10gv\x00\xfd8[r\x01\xf58\xb3\ah\xc7\u0652\x0f\xd4\xda\x03|@7\u0396\xba@\xa3<\xa0\x03h\xc6\xd9R\x00\u040c3\a\x01\xbd8[\n\x02zqf\x01\u040a\xf3\xe7\x80\x00\xa0\x15g\x16\x01\x9d8\u007f\r\b\x01:q\xe6\b\xb0P\x1c\x10\x044\xe2\xccQ`\xac7 \f\xe4\u01d9\xe3@v\x9c\u007f\x06\b@n\x9c\xb9\x0f\u020csk\x80\x04\xe4\u0159\xfb\x81\xac8\xb7\a\x88@\xad4@\x042\xe2\xec\f\x90\x81Fg\x80\f$\xc7\xd9\x1d \x03\xc9q\xe6\xa1@b\x9c\xbd\x01\x11 1\xce<\x1cH\x8a\xb3? \x06$\u01795`\x9f\x0f\x0e\xed\x911\xe6\xf8dvzv\xde\\\\*\xc4\u067aO{\u05d1~\x1f\xe7+\xe1iA\xba6\xe5\xd4\xef\xe6\x96\x06\xdf\xdd\xfd\xc3#\x8e\x98?=\xbf\xe0V\xbc\xbe\xbdW\xb0\x8fJ\xfc\x98\x81D\xce\xc7\xf4\x13\xd9\x1f\x13#\x94>F 4?\xa6K\xa8\u007fL\xb9r\xe5\xca\xfd\xd9}\x00M\x9b+\xf0\xf0Z_}\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsAndroid96x196PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsAndroid96x196Png, nil
}

func assetsStaticFaviconsAndroid96x196Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsAndroid96x196PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/android-96x196.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsAppleTouchIcon180x180Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\xb4\x00\x00\x00\xb4\b\x03\x00\x00\x00\n\x13\xf6\x00\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x01qPLTEFk\xb0\x85\x9e\xcb\xc3\xcf\xe5Z{\xb8\xc5\xd1\u7a3a\xda\xf2\xf5\xf9Rt\xb5\xff\xff\xff\x9d\xb0\xd5\xeb\xef\xf6Hm\xb1\xd7\xdf\xeet\x90\xc4\xcb\xd6\xe9\xfe\xfe\xfeb\x81\xbc\xb4\xc3\xdf\xf8\xf9\xfc\xa3\xb5\xd8Lp\xb2\x91\xa7\xd0\xe2\xe8\xf2z\x94\xc6\xd1\xda\xecn\x8b\xc1\xc0\xcc\xe4\xfc\xfc\xfdYz\xb8_\u007f\xbb\xae\xbe\u073a\xc8\xe2Qt\xb4\xf3\xf5\xfa\xf3\xf6\xfa\xf4\xf6\xfa\xa2\xb4\u05e9\xba\xda\xe9\xee\xf6\xf6\xf8\xfb\xd8\xe0\xee\xb9\xc7\u16ae\xd4z\x95\xc7[|\xb9Gl\xb1o\x8c\u0083\x9c\u0298\xad\u04ed\xbd\xdc\xc2\xce\xe5\xeb\xef\xf7\xda\xe1\xef\xbb\xc8\u2730\xd5|\x96\xc7]}\xbaGl\xb0\\|\xb9q\x8d\u0086\x9e\u031b\xaf\u0570\xc0\xdd\xc4\xd0\xe6\xd9\xe1\xef\xee\xf2\xf8\xfe\xfe\xff\xf9\xfa\xfd\xdc\xe3\xf0\xbd\xca\u3771\xd6~\x98\xc8Jn\xb2\x89\xa1\u0372\xc1\xde\xc7\xd2\xe7\xf1\xf4\xf9\xfb\xfc\xfd\xde\xe5\xf1\xbe\xcb\u37f3\u0580\x9a\xc9a\x81\xbcKo\xb2v\x91\u014b\xa2\u03a0\xb3\u05f5\xc4\xdf\xca\xd5\xe8e\x84\xbd\x84\x9c\xcbe\x83\xbdMq\xb3\x8f\xa5\xcfg\x85\xbeQt\xb5\xa5\xb7\xd8\xd1\xda\xebMp\xb3\xd3\xdc\xec\xcf\xd9\ua5ec\xd3`\x80\xbbPs\xb4r\x8e\xc3\xe0\xe6\xf2l\x89\xc0\xf0\xf3\xf8\xba\xc8\u109b\xca\xdd\xe4\xf0\xfa\xfb\xfd\x94\xa9\xd1\xed\xf0\xf7\xb6\xc5\xe0\u007f\x99\xc9Nq\xb3\xc6\xd1\xe6\xf8\xfa\xfc\xc8\xd3\xe7j\x88\xc0\x8d\xa4\xcfWx\xb7[\xdb\xea\xcf\x00\x00\x00\x01bKGD\b\x86\u0795z\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x03?IDATx\xda\xed\x9ciS\xd3P\x18F\x83H{\x956 \x91\xd2V\xab-\x8b\xb8\xd5}\xa1\x82\x82\x88 *\xe0\x8e\x8a\u058a\v\x88\x8ak\xdd~\xbd\x1f\xa4\x92\xa4\xb977\x85\xc9}\u07d9\xe7|N:g\x9eI\u04dc\xe9L,\v\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00 \x1am\x1c\xa5w\xb43\x94\xde\xd9\xc1Q:\x91d(-vq\x94\xde\xdd\xc9PZ\xb4q\x94Nq\x94\x16i\x8e\xd26G\xe9\xaen\x86\xd2b\x0fG\xe9\x9e$Ci\xe1p\x94N\xece(-z9Jg8J\x8b>\x8e\xd2Y\x8e\xd2\"\xc7Q:\xcfQz\xdf~\x86\u04a2\x83\xa34\xa3X\u0714f\x14\x8b.i>\xb1\xe8\x92\xe6\x13\x8bn\xe9\x14Gi6\xb1\u84769Js\x89E\x8f4\x97X\xf4J3\x89E\xaf4\x93X\xf4I\xf3\x88E\x9f4\x8fX\xf4KS\x8f\xc5B\x904\xf1XL\x1e\b\x94\xa6\x1d\x8b\xce\xc1@i\u04b1X,I\xa4)\u01e2#$\u0484c\xb1X\x92I\x13\x8eEGH\xa5\xc9\xc6b\xb1$\x97&\x1b\x8b\x8ePH\x13\x8d\xc5bI%M4\x16\x1d\xa1\x94N\x91\x1dZ!M2\x16\x1d\x11\"mS\x1dZ%M0\x16\xff\r\xad\x92\xa6\x17\x8b\x1bC+\xa5\xc9\xc5\xe2\xc6\xd0Jij\xb1\xd8\x18Z-M,\x16\x1bC\xab\xa5i\xc5\xe2\xff\xa1C\xa43$\x87\x0e\x91\xa6\x14\x8b\x9bC\x87Ig)\x0e\x1d&M'\x16]C\x87J\xe7\t\x0e\x1d*M%\x16\xddC\x87JS\x89E\xf7\xd0\xe1\xd24b\xd13t\xb84\x8dX\xf4\f\xad!M!\x16\xbdCkHS\x88E\xef\xd0:\xd2)jC\xebH\x9b\x8fE\xdf\xd0Z\xd26\xb1\xa1\xb5\xa4M\u01e2\u007fh-i\u00f1\xd84\xb4\x9e\xb4\xd9Xl\x1aZO\xdah,6\x0f\xad)m2\x16\x9b\x87\u05946\x18\x8b\x01C\xebJg(\r\xad+m,\x16\x83\x86\u0596\xce\x12\x1aZ[\xdaP,\x06\x0e\xad/\x9d\xa73\xb4\xbe\xb4\x91X\f\x1eZ_\xdaH,\x06\x0f\x1dA\xda@,J\x86\x8e m \x16%CG\x91\x8e=\x16eCG\x91\x8e=\x16eCG\x92\x8e9\x16\x93\xfd\x12\x8f\x81A\u02f2\xac\xa1Cz\xd6i\xd3C\x0f\x1f>r\xf4\xd8\xf1\xc6\x01\xe5\xf6\x13'O\x9d>\x93:\xdbE&\x16\xbdWt\u03f9\xf3\x17.\x8eT\x82\x0f\xed\xbc4:v\xf9\xca\xf8\xc4\xd5I\u04f1\xd8\x18\xfa\xda\xd4\xf5\xe9\x99BE\xeb\x9c\x1b\x85\xf4\xec\xf4\xcd[S\xb7\r\xc5b\xb1$\xe6\xe6\x17\xee\u073dWn\xe5\xec\xfb\xdd\x0f\x1e>Z|<\xdf\x1fo,>y\xba\xb4\x1d\x1f\xf3l\xa9\xefy\xd5\x02\x00\xb4\u018b\xda\xcb\xedaqf9F\xed\xd1Wb\xab\u033d~\xf36\ued77\xa6\x9dX\x18[1r\x91\xac\xda-\x1a\xbf\x1bZ5\xf8\xb7\u02da\xdd\xcaE1b\xfa+\x19M\xfb\xfd\x87\x8f+$\xee$\xda\xda\xeb\xb5\\\x99\xce\rPC\xfb\x93\xfd\x99\u071b\x99\xd4\xda_\xbe~\xfbN\xf2\xe7F\xaa\xbd^\xcbU,\xb2\xac\u055b\x84\u007f\xfc\xec%\xff\xba\xaej\xddwQ,[\x1chhON\f\xfe\xaaXl\xa8\xd6\xc5\xf0\xf8\xef?\u071e\x00\vx\b\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\xf0\x17\xd6\u0135\xbd*z\x00\xb8\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsAppleTouchIcon180x180PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsAppleTouchIcon180x180Png, nil
}

func assetsStaticFaviconsAppleTouchIcon180x180Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsAppleTouchIcon180x180PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/apple-touch-icon-180x180.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsFavicon16x16Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\x00\x00\x00\x10\b\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\xeaIDAT8Oct\xcb\xde\xf0\x9f\x81\x02\xc0HS\x03\xf4TE\x18.\xdd~\x83\xd7}x]\x10\xeb\xa5\xc1\xb0\xeb\xc4#\x86\x97\xef\xbe\xe14\x84\xa0\x01\xe2\xc2\\\f=\x8b\u03d1o@\x8c\x97:C\\\xddn\x9c\xae\xc0\xe9\x02\x90\xff\xf5UE\x18@\x06,\xd9v\x93a\xf1\xb6\x1bX]\x81\u04c0\xee|\x1bp\x00\x82\f\xf8\xf2\xfd7\xd8\x15_\xbf\xff\xc60\x04\xab\x01 \u06fb\xf3\xad\xc16\x83\f\x00\x81\x9e\xc5\xe7\x19v\x9f|D\x9c\x01 \xdb\xf5T\x85Q\fx\xf9\xf6\x1bC\\\xfdn\xc2\x06\xc0l\a\xa9Dv\x01.W`x\xa1>\u035c\x81\x87\x93\x95\xe1\ue4cf\f\xc7.=g\xb0\u0493dP\x96\xe1\x87\xdb\\:\xf1\b\x8a+0\f\x00\xb9@OE\x18\u00e9_\u007f\xfca8v\xf19Ft\xe2\fDP*\x04%\"\x90&\x90Kp%i\xdaf&br9\x00Ea\x80\x11\x91vC1\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsFavicon16x16PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsFavicon16x16Png, nil
}

func assetsStaticFaviconsFavicon16x16Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsFavicon16x16PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/favicon-16x16.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsFavicon32x32Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\x00\x00 \b\x03\x00\x00\x00D\xa4\x8a\xc6\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x006PLTEFk\xb0t\x90\u013a\xc8\xe2\xff\xff\xff]}\xba\xf3\xf6\xfaQt\xb5\xa3\xb5\xd8\xe8\xec\xf5\x8b\xa2\xce\xd1\xda\xec\xd0\xda\xeb\xc5\xd1\u7bbe\u0757\xac\xd3h\x86\xbf\xf4\xf6\xfb\xe8\xed\xf6\xb0\x1c\xe1\xc1\x00\x00\x00\x01bKGD\x03\x11\fL\xf2\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x00\u007fIDAT8\xcb\xcd\xd3I\x0e\x80 \x10DQ\x9bR\x91V\x1c\xee\u007fYG\xd4\x05e'\xae`\xfd\xf2I*PU\xe5\x1d\xb1\x80\xb3\x00j\vX\t4\xad\x01\xe0-\xd0Y\x00\xe1s\x05|'t\a\xe0c\t\x0e\xd0\xf3\xc0\t\xe8X\x82\v8\x1a\xb8\x00Il\x81\x04<\v$\x90\xdd{\x0f$\x90\x1dK\u07e0#\x81\x1bd\x12\x83\xc6Q\xb6\xab'\t>\xaa\xea\x8f\u05eax\x8e\x8e5'\xb3\v-\xaf,Q\n\xfc\x8b+\x8f\xe7\x02\xff\xa5\xfb\xeca\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsFavicon32x32PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsFavicon32x32Png, nil
}

func assetsStaticFaviconsFavicon32x32Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsFavicon32x32PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/favicon-32x32.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsFaviconIco = []byte("\x00\x00\x01\x00\x01\x00\x10\x10\x00\x00\x01\x00 \x00h\x04\x00\x00\x16\x00\x00\x00(\x00\x00\x00\x10\x00\x00\x00 \x00\x00\x00\x01\x00 \x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\u03a3\x8c\xff\xf5\xed\xe8\xff\xf0\xe4\xdd\xff\u05f5\xa3\xff\xbf\x87i\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\u03a3\x8c\xff\xf5\xed\xe8\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\xed\xe8\xff\xe1\u023a\xff\u025a\x80\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\u0110u\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb5tR\xff\u0110u\xff\xb7wU\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xeb\xda\xd1\xff\xff\xff\xff\xff\xf5\xed\xe8\xff\u073e\xae\xff\u03a3\x8c\xff\xeb\xda\xd1\xff\xf5\xed\xe8\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb7wU\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\u0110u\xff\xff\xff\xff\xff\xff\xff\xff\xff\xeb\xda\xd1\xff\u05f5\xa3\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\u023a\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xeb\xda\xd1\xff\xff\xff\xff\xff\xeb\xda\xd1\xff\u05f5\xa3\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\u0110u\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\u0110u\xff\xff\xff\xff\xff\xeb\xda\xd1\xff\u05f5\xa3\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xeb\xda\xd1\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xeb\xda\xd1\xff\xeb\xda\xd1\xff\u05f5\xa3\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\u03a3\x8c\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\u0110u\xff\xeb\xda\xd1\xff\u05f5\xa3\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\xec\xe8\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\u05f5\xa3\xff\u05f5\xa3\xff\xff\xff\xff\xff\xff\xff\xff\xff\u03a3\x8c\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb5tR\xff\u05f5\xa3\xff\xff\xff\xff\xff\xfa\xf6\xf3\xff\xb5tR\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\u05f5\xa3\xff\xff\xff\xff\xff\u05f5\xa3\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\u05f5\xa3\xff\xff\xff\xff\xff\xba~]\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\u05f5\xa3\xff\xe1\u023a\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\u05f5\xa3\xff\xba~]\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\u0110u\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\xb0kF\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00")

func assetsStaticFaviconsFaviconIcoBytes() ([]byte, error) {
	return _assetsStaticFaviconsFaviconIco, nil
}

func assetsStaticFaviconsFaviconIco() (*asset, error) {
	bytes, err := assetsStaticFaviconsFaviconIcoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/favicon.ico", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsPwa192x192Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\xc0\x00\x00\x00\xc0\b\x03\x00\x00\x00e\x02\x9c5\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x01qPLTEFk\xb0\x85\x9e\xcb\xc3\xcf\xe5Z{\xb8\xc5\xd1\u7a3a\xda\xf2\xf5\xf9Rt\xb5\xff\xff\xff\x9d\xb0\xd5\xeb\xef\xf6Hm\xb1\xd7\xdf\xeet\x90\xc4\xcb\xd6\xe9\xfe\xfe\xfeb\x81\xbc\xb4\xc3\xdf\xf8\xf9\xfc\xa3\xb5\xd8Lp\xb2\x91\xa7\xd0\xe2\xe8\xf2z\x94\xc6\xd1\xda\xecn\x8b\xc1\xc0\xcc\xe4\xfc\xfc\xfdYz\xb8_\u007f\xbb\xae\xbe\u073a\xc8\xe2Qt\xb4\xf3\xf5\xfa\xf3\xf6\xfa\xf4\xf6\xfa\xa2\xb4\u05e9\xba\xda\xe9\xee\xf6\xf6\xf8\xfb\xd8\xe0\xee\xb9\xc7\u16ae\xd4z\x95\xc7[|\xb9Gl\xb1o\x8c\u0083\x9c\u0298\xad\u04ed\xbd\xdc\xc2\xce\xe5\xeb\xef\xf7\xda\xe1\xef\xbb\xc8\u2730\xd5|\x96\xc7]}\xbaGl\xb0\\|\xb9q\x8d\u0086\x9e\u031b\xaf\u0570\xc0\xdd\xc4\xd0\xe6\xd9\xe1\xef\xee\xf2\xf8\xfe\xfe\xff\xf9\xfa\xfd\xdc\xe3\xf0\xbd\xca\u3771\xd6~\x98\xc8Jn\xb2\x89\xa1\u0372\xc1\xde\xc7\xd2\xe7\xf1\xf4\xf9\xfb\xfc\xfd\xde\xe5\xf1\xbe\xcb\u37f3\u0580\x9a\xc9a\x81\xbcKo\xb2v\x91\u014b\xa2\u03a0\xb3\u05f5\xc4\xdf\xca\xd5\xe8e\x84\xbd\x84\x9c\xcbe\x83\xbdMq\xb3\x8f\xa5\xcfg\x85\xbeQt\xb5\xa5\xb7\xd8\xd1\xda\xebMp\xb3\xd3\xdc\xec\xcf\xd9\ua5ec\xd3`\x80\xbbPs\xb4r\x8e\xc3\xe0\xe6\xf2l\x89\xc0\xf0\xf3\xf8\xba\xc8\u109b\xca\xdd\xe4\xf0\xfa\xfb\xfd\x94\xa9\xd1\xed\xf0\xf7\xb6\xc5\xe0\u007f\x99\xc9Nq\xb3\xc6\xd1\xe6\xf8\xfa\xfc\xc8\xd3\xe7j\x88\xc0\x8d\xa4\xcfWx\xb7[\xdb\xea\xcf\x00\x00\x00\x01bKGD\b\x86\u0795z\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x03DIDATx\xda\xed\x9ciS\xd3`\x18E\x83H\xfb*m@\"\xa5\xadV[\x04q\xab\xfbB\x05\x05\x11\xc1\rpGEk\xc5\x05D\xc5\x15\xb7_\xef\a)$i\x967\xa5c\x9e;s\xcf\u7d1337I{\xa635\fB\b!\x84\x10B\b!\x84\x10B\b!\x84\x10B\b!\xa45\xb4\xa1\vlk\a\x17\xd8\u0781.\x90H\x82\v\xa8\x1d\xe8\x02;;\xc1\x05T\x1b\xba@\n]@\xa5\xd1\x05Lt\x81\xaenp\x01\xb5\v]\xa0'\t.\xa0,t\x81\xc4np\x01\u054b.\x90A\x17P}\xe8\x02Yt\x01\x95C\x17\u0223\v\xec\xd9\v.\xa0:\xd0\x05@\xe3xS\x004\x8em\x02\x98ql\x13\xc0\x8cc\xbb@\n]\x002\x8e\x1d\x02&\xba\x00b\x1c;\x04\x10\xe3\xd8)\x00\x18\xc7N\x01\xc08v\t\xe0\u0171K\x00/\x8e\xdd\x02Hq\\\xf0\x12\x00\x8a\xe3\xe4>O\x01\x9c8\xb6\xf6{\n\xc0\xc4q\xb1\xe4#\x80\x12\u01d6\xf2\x11\x00\x89\xe3b\xc9O\x00$\x8e-\xe5+\x00\x11\xc7\u0152\xbf\x00D\x1c[*@\x00 \x8e\x8b\xa5 \x01\x808\xb6T\xa0@\nb\x80\x00\x01\xf1ql\xa9\x10\x01\x13a\x80 \x01\xe1q\xfco\x80 \x01\xd9q\xbc>@\xa0\x80\xe88^\x1f P@r\x1c\xd7\a\b\x16\x10\x1c\xc7\xf5\x01\x82\x05\xe4\xc6\xf1\xc6\x00!\x02\x19\xf1\x03\x84\bH\x8d\xe3\xcd\x01\xc2\x04\xb2\xd2\a\b\x13\x90\x19\u01f6\x01B\x05\xf2\xc2\a\b\x15\x90\x18\xc7\xf6\x01B\x05$\u01b1}\x80p\x01yq\xec\x18 \\@^\x1c;\x06\xd0\x10\x90\x16\xc7\xce\x014\x04\xa4\u0171s\x00\x1d\x81\x94\xe4\x01t\x04d\u0171k\x00-\x01S\xf0\x00Z\x02\x92\xe2\xd8=\x80\x96\x80\xa08n\x18@O@N\x1c7\f\xa0' &\x8e\x1b\a\xd0\x14\x90\x12\u01cd\x03h\n\b\x89c\x8f\x01t\x052R\a\xd0\x15\x10\x11\xc7^\x03h\vd\x85\x0e\xa0-  \x8e=\a\xd0\x17\xc8\xcb\x1c@_ \xf68\xf6\x1e@_ \xf68\xf6\x1e \x82@\xccq\xec3@\x04\x81\x98\xe3\xd8g\x80(\x02\xb1\u01b1\xdf\x00Q\x04b\x8dc\xbf\x01\"\t\xc4\x18\xc7\xc9~\x9fs:0`\x18\x861xP\xcf -i\x80\xa1C\x87\x8f\x1c=V?\xa0\xdc~\xfc\xc4\xc9S\xa7Sg\xbaD\u01b1\xf3\x0e\xe89{\xee\xfc\x85\xe1\x8a\xf7\xa1\x9d\x17GF/]\x1e\x1b\xbf2!)\x8e\xeb\x03\\\x9d\xbc65]\xa8h\xbd\xe6z!}c\xea\xe6\xad\xc9\xdb\x02\xe2\xb8XR3\xb3sw\xee\xde+7\xf3\xea\xfb\xdd\x0f\x1e>\x9a\u007f<\xdb\x1f_\x1c?y\xba\u040a\xb7y\xb6\xd0\xf7\xbcj\x10B\xfe?/j/[\xc3\xfc\xf4bL\n#\xaf\xd4V\x99y\xfd\xe6m\x9c+lM!17\xba\x14\xfb\x85\xb4l6y\xf6\xef\x06\x97\x85\xfcL\xb6b6s\xe1\fK\xba\x9d\xa3)\xbc\xff\xf0qI\xdc\x13I[a\xb5\x96+\xcb|\xa8j(|2?\x8b\xfe\xe7\xb9`\x85/_\xbf}\x17\xff\xd1\u6af0Z\xcbU\f\bV\xd6\x1aN\xfe\xc7\xcf^\xa8\xbf,\xac\xae\xb9.\x9cE\x03\x8d\xba\xc2\xc4\xf8\xc0\xaf\x8a\x01IuM\r\x8d\xfd\xfe\x83\xfcM\xb5\xc0/\xeb\x84\x10B\b!\x84\x10B\b!\x84\x10B\b!\x84\x10\"\x93\xbfC\u0375\xbd\x1b<\xccs\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsPwa192x192PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsPwa192x192Png, nil
}

func assetsStaticFaviconsPwa192x192Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsPwa192x192PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/pwa-192x192.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsPwa512x512Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x02\x00\x00\x00\x02\x00\b\x03\x00\x00\x00\u00e6$\xc8\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x00\xa5PLTEFk\xb0j\x87\xbf\xbc\xc9\xe2\xc5\xd1\xe6_\u007f\xbb\xab\xbc\xdb\xf7\xf8\xfcNr\xb3\xff\xff\xff\x9a\xae\xd4\xe6\xeb\xf4\x89\xa1\xcd\xd5\xdd\xedx\x93\xc5\xc4\xd0\xe6g\x86\xbe\xb3\xc2\xdfWx\xb7\xa2\xb5\xd7\xee\xf2\xf8\x92\xa7\xd0\xde\xe4\xf1\x81\x9a\xc9\xcd\xd7\xeap\x8d\xc2Ps\xb4\xba\xc7\xe1\xf5\xf7\xfb\xfe\xfe\xfe\xe0\xe6\xf2\xf4\xf6\xfa\xdf\xe6\xf1\xc1\xcd\u411d\xcbf\x84\xbeGl\xb1Qt\xb5e\x84\xbdz\x94\u018e\xa5\u03f7\xc5\xe0\xcb\xd6\xe9o\x8c\xc1\xc2\xce\xe5\xdc\xe3\xf0\xd5\xde\xed\xa0\xb3\xd7k\x89\xc0\xf9\xfa\xfc\x8f\xa5\xcfY{\xb8\xe7\xec\xf5\xb2\xc1\xde}\x97\xc7Hl\xb1Tdz\xaf\x00\x00\x00\x01bKGD\b\x86\u0795z\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x03\xb2IDATx\xda\xed\u06b7\x96\xd4@\x14EQ\xe1\v\xdf4~\x18\xbc\xf7\x9e\xff\xff4\x12\x12X\xadR\tH\xf4\xee\u07b1\xa2\xd2Y/\xba\xd3\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb0\x19'<A\xb6\x93\x9e \u06e9\xd3\xde ;\x803\xde ;\x80\xb3\xe7<Bt\x00\xed\xbcG\xc8\x0e\xe0\x82G\xc8\x0e\xa0]\xf4\n\xd9\x01\\\xf2\n\xd9\x01\xb4\u02de!;\x80+\x9e!;\x80v\xd5;d\a\xb0\xf3\x0e\xd9\x01\xb4k\x1e\";\x80\xbd\x87\xc8\x0e\u0e87\xc8\x0e\xa0\xdd\xf0\x12\xd9\x01\xdc\xf4\x12\xd9\x01\xb4[\x9e\";\x80\u06de\";\x80v\xc7[d\a`\x1c\x18\x1e@3\x0e\f\x0f\xc080<\x00\xe3\xc0\xf0\x00\x8c\x03\xd3\x030\x0e\f\x0f\xc080=\x00\xe3\xc0\xf0\x00\x8c\x03\xd3\x030\x0e\f\x0f\xc080=\x80\x9d\a\xc9\x0e\xc080=\x00\xe3\xc0\xf0\x00\x8c\x03\xc3\x030\x0eL\x0f\xc080\xc7\xfeP\x00\u01811\xee\x1e\x1d\f\xc080\xe6\x00\x1c\x0e\xc080\xe5\x00\u071b\t\xc080\xe4\x00\xb4\x99\x00\x8c\x03C\x0e\xc0l\x00\u0181\x19\a`6\x00\xe3\xc0\x8c\x030\x1b\x80q`\xc6\x01\x98\x0f\xc080\xe2\x00\xcc\a`\x1c\x18q\x00:\x01\x18\a&\x1c\x80N\x00\u0181\t\a\xa0\x17\x80q`\xc0\x01\xe8\x05`\x1c\x18p\x00\xba\x01\xec\xbcR\xf9\x03\xd0\r\xc08\xb0\xfe\x01\xe8\a`\x1cX\xfe\x00\xf4\x030\x0e,\u007f\x00\xfa\x01\x18\a\x96?\x00\v\x01\x18\aV?\x00\v\x01\x18\aV?\x00K\x01\x18\a\x16?\x00K\x01\x18\a\x16?\x00\x8b\x01\x18\a\xd6>\x00\x8b\x01\x18\a\xd6>\x00\xcb\x01\x18\a\x96>\x00\xcb\x01\x18\a\x96>\x00\xcb\x01\x18\a\x96>\x00\x03\x01\x18\aV>\x00\x03\x01\x18\aV>\x00#\x01\x18\a\x16>\x00#\x01\x18\a\x16>\x00C\x01\x18\a\xd6=\x00C\x01\x18\a\xd6=\x00c\x01\xec<\\\xd5\x030\x16\x80q`\xd9\x030\x18\x80q`\xd5\x030\x18\x80q`\xd5\x030\x18\x80q`\xd5\x030\x1a\x80q`\xd1\x030\x1a\x80q`\xd1\x030\x1c\x80q`\xcd\x030\x1c\x80q`\xcd\x030\x1e\x80q`\xc9\x030\x1e\x80q`\xc9\x03\xb0\"\x00\xe3\xc0\x8a\a`E\x00\u0181\x15\x0f\xc0\x8a\x00\x8c\x03+\x1e\x805\x01\x18\a\x16<\x00k\x020\x0e,x\x00V\x05`\x1cX\xef\x00\x1c\x1fM\xd34\xdd\u007f0V\x80q`\xa1\x03p\xfc\xf0\xd1\xfe\U000539ff>x\xf6\xfc\xc5\xcb\xfd\xab\xd7\v%\x18\a\x968\x00\xbf\xff\xfa?\xf4K0\x0e\xdc\xf6\x01\xe8\xfe\xfa\x91\x12v\xder\x93\a`\u076f\xef\x95`\x1c\xb8\xc9\x03\xf0\x97\xbf\xfeP\t^\x13\x00`#\u07bcm\xef\xfe\x8b\xf7\x1f>z\u036d&\xf0\xaf>]\xf9\xfc\xc5C\xa6&\xf0\xf5\xdb\xf7\x1f\xde05\x01\x87?8\x01\x87?9\x01\x87?9\x01\x87?8\x01\x87?9\x01\x87?9\x01\x87?8\x01\x87?9\x01\x87?9\x01\x87?8\x01\x87?<\x01\x87\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u062a\x9f\xad\ub3a4\xf9?Qa\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsPwa512x512PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsPwa512x512Png, nil
}

func assetsStaticFaviconsPwa512x512Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsPwa512x512PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/pwa-512x512.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsTile150x150Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x01\x0e\x00\x00\x01\x0e\b\x03\x00\x00\x00Oo\t\x97\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x00\xa5PLTEFk\xb0j\x87\xbf\xbc\xc9\xe2\xc5\xd1\xe6_\u007f\xbb\xab\xbc\xdb\xf7\xf8\xfcNr\xb3\xff\xff\xff\x9a\xae\xd4\xe6\xeb\xf4\x89\xa1\xcd\xd5\xdd\xedx\x93\xc5\xc4\xd0\xe6g\x86\xbe\xb3\xc2\xdfWx\xb7\xa2\xb5\xd7\xee\xf2\xf8\x92\xa7\xd0\xde\xe4\xf1\x81\x9a\xc9\xcd\xd7\xeap\x8d\xc2Ps\xb4\xba\xc7\xe1\xf5\xf7\xfb\xfe\xfe\xfe\xe0\xe6\xf2\xf4\xf6\xfa\xdf\xe6\xf1\xc1\xcd\u411d\xcbf\x84\xbeGl\xb1Qt\xb5e\x84\xbdz\x94\u018e\xa5\u03f7\xc5\xe0\xcb\xd6\xe9o\x8c\xc1\xc2\xce\xe5\xdc\xe3\xf0\xd5\xde\xed\xa0\xb3\xd7k\x89\xc0\xf9\xfa\xfc\x8f\xa5\xcfY{\xb8\xe7\xec\xf5\xb2\xc1\xde}\x97\xc7Hl\xb1Tdz\xaf\x00\x00\x00\x01bKGD\b\x86\u0795z\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x02\xe4IDATx\xda\xed\xd8\xd9RSA\x14\x86\u0448F\x8f1\x84p\x02b\x00\xe7y\x9ey\xffG\xf3BJ\xbb\xe1\f\x9d@iU\ufd6e\xfb\uaaffo\xf6d\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xd8\r\tR;\x12\xa4n\xde\xd2 \xcd1\xd5 \xcdq\xfb\x8e\bI\x8e\xe6\xae\bi\x8e\x99\bi\x8e\xe6\x9e\ni\x8e\xb9\ni\x8efW\x864\xc7B\x864G\xb3\xa7C\x9ac\xa9C\x9a\xa3\xd9\x17\"\xcd\xd1\n\x91\xe6X\t\x91\xe6h\x0e\x94Hs\x1c*\x91\xe6h\xeeK\x91\xe68\x92\"\xcd\xd1<\xd0\"\xcd\xe1h\x9a\xe5h\x1cM\xb3\x1c\x8e\xa6Y\x0eG\xd3,\x87\xa3i\x9e\xc3\xd14\xcb\xe1h\x9a\xe7p4\xcdr8\x9a\xe69\x1cM\xb3\x1c\x8e\xa6y\x8e\xa5\x1c\x99}9R\xad\x1c\xa9\x95\x1c\x99\x039Rq\x8f\xa6mW\x8e\xb0G\xd3\xf5qg\x8e\xa8G\u04f6;G\u0423\xe9\xfa\xa4'G\u0323i\xdb\xf4\xe4\by4]\x9f\xf4\u6606\x1cGo\x8e\x80G\xd3\xf5I\u007f\x8e\x80G\u04f6\x19\xc81\x8b8\x8e\xfe\x1c\u13a6m3\x98c\x1ep\x1c\x039\x82\x1dM\xdbf$\xc7\"\xde8\x86r\x84:\x9a\xfe\x1e\xc7`\x8ee\xb8q\f\xe6\bt4=\x1f\xc7p\x8e6\xda8\x86s\xac\xa2\x8dc8G\x94\xa3\xe9\x9fq\x8c\xe48\f6\x8e\x91\x1c1\x8e\xa6\u007f\xc71\x96\xe3(\xd68\xc6rD8\x9a&\xe3\x18\u0371\x13j\x1c\xa39\xea?\x9a\xa6\xe3\x18\xcf1\x8d4\x8e\xf1\x1c\xb5\x1fM\xb3q\x8c\xe7\xa8\xfdh\x9a\x8d\xa3 \xc7,\xd08\nr\xd4}4\xcd\xc7Q\x92c\x1eg\x1c%9j>\x9a^\x18GQ\x8eE\x98q\x14\xe5\xa8\xf7hzq\x1ce9\x96Q\xc6Q\x96\xa3\u05a3\xe9\xa5q\x14\xe6h\x83\x8c\xa30\xc7*\xc88\nsTy4\xed\x18Gi\x8e\xc3\x18\xe3(\xcdQ\xe1\u0474k\x1c\xc59\x8eB\x8c\xa38GuG\xd3\xceq\x94\xe7\u06090\x8e\xf2\x1c\x95\x1dM\xbb\u01f1A\x8ei\x80ql\x90\xa3\xaa\xa3i\xcf86\xc8Q\xd5\u0474g\x1c\x9b\xe4\x98\xd5?\x8eMrTt4\xed\x1b\xc7F9\xe6\u054f\xe3\xf4x2\x99L\x1e>*\xeb\xb1[\xef8N\x1f?i\x9f>{~\xfe\xe0\xc5\xcbW\xaf\xdb7oG\xba,j\x1cG\x1e\xe2\x82\xe1.{U\x8dc0DI\x97e\x15\xe3\xd8,\xc4P\x97\x1a\x8e\xa6\u06c6\xe8\xea2\x01\x88\xe9\xdd\xfb\xe6\u00f5\xf8\xf8\xe9s-A\xae\xea\xcb\xe2\ubdea\x16r\x05\xdf\u007f\xfc<\xab\xef\xcbl\xa7\x96/r\rA\xea\xfa\"W\vR\xe1\x17\xd9:H\xad_d\x8b u\u007f\x91\u0342\x04\xf8\"\xc5A\xa2|\x91\x82 \xb1\xbe\xc8p\x90\x80_\xa47H\xd4/\xd2\x11$\xf6\x17\xb9\x14\xe4L\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xab_\x11\u007f\x8e\xa4\x06*\u030b\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsTile150x150PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsTile150x150Png, nil
}

func assetsStaticFaviconsTile150x150Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsTile150x150PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/tile150x150.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsTile310x150Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x02.\x00\x00\x01\x0e\b\x03\x00\x00\x00\x99\xd0lF\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x00\xa5PLTEFk\xb0j\x87\xbf\xbc\xc9\xe2\xc5\xd1\xe6_\u007f\xbb\xab\xbc\xdb\xf7\xf8\xfcNr\xb3\xff\xff\xff\x9a\xae\xd4\xe6\xeb\xf4\x89\xa1\xcd\xd5\xdd\xedx\x93\xc5\xc4\xd0\xe6g\x86\xbe\xb3\xc2\xdfWx\xb7\xa2\xb5\xd7\xee\xf2\xf8\x92\xa7\xd0\xde\xe4\xf1\x81\x9a\xc9\xcd\xd7\xeap\x8d\xc2Ps\xb4\xba\xc7\xe1\xf5\xf7\xfb\xfe\xfe\xfe\xe0\xe6\xf2\xf4\xf6\xfa\xdf\xe6\xf1\xc1\xcd\u411d\xcbf\x84\xbeGl\xb1Qt\xb5e\x84\xbdz\x94\u018e\xa5\u03f7\xc5\xe0\xcb\xd6\xe9o\x8c\xc1\xc2\xce\xe5\xdc\xe3\xf0\xd5\xde\xed\xa0\xb3\xd7k\x89\xc0\xf9\xfa\xfc\x8f\xa5\xcfY{\xb8\xe7\xec\xf5\xb2\xc1\xde}\x97\xc7Hl\xb1Tdz\xaf\x00\x00\x00\x01bKGD\b\x86\u0795z\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x03-IDATx\xda\xed\xda\u01ce\xd4P\x14E\xd1&?RS\x14\x19\x9a\x9cir\xfa\xffOCB\f\xca.\xfb\xf9\x1e\xe8\x01\x92\xd7\x1a{\xf4\xb4u=9\a\a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x000r\xca\x13Pw\xda\x13Pw\xe6\xac7\xa0\x9e\xcb9o@=\x97\xf3\x17<\x02\xe5\\\xdaE\x8f@=\x97K\x1e\x81z.\xed\xb2W\xa0\x9e\xcb\x15\xaf@=\x97v\xd53P\xcf\xe5\xd03P\u03e5]\xf3\x0e\xd4s\xd9x\a\uae74\xeb\x1e\x82z.[\x0fA=\x97\x1b\x1e\x82z.\xed\xa6\x97\xa0\x9e\xcb-/A=\x97v\xdbSP\xcf\u53a7\xa0\x9eK\xbb\xeb-\xa8\xe7b\xb4K\x90K3\xda%\xc8\xc5h\x97 \x17\xa3]\x82\\\x8cvIr1\xda%\xc8\xc5h\x97$\x17\xa3]\x82\\\x8cvIr1\xda%\xc8\xc5h\x97$\x97\x8d\a\xa1\x9e\x8b\xd1.I.F\xbb\x04\xb9\x18\xed\x12\xe4b\xb4K\x92\x8b\xd1.\u04f6S\xb9\x18\xed2\xe9\xde\xfd\xc9\\\x8cv\x99<.\u04f9\x18\xed2u\\\x1e\xcc\xe4b\xb4\xcb\xc4qi3\xb9\x18\xed2q\\fs1\xdae\xff\xb8\xcc\xe6b\xb4\xcb\xfeq\x99\xcd\xc5h\x97\xfd\xe32\x9f\x8b\xd1.{\xc7e>\x17\xa3]\xf6\x8eK'\x17\xa3]\xc6\u01e5\x93\x8b\xd1.\xe3\xe3\xd2\xcb\xc5h\x97\xd1q\xe9\xe5b\xb4\xcb\xe8\xb8ts\xd9x%\x06\u01e5\x9b\x8b\xd1.\xc3\xe3\xd2\xcf\xc5h\x97\xc1q\xe9\xe7b\xb4\xcb\xe0\xb8\xf4s1\xdaep\\\x16r1\xdae\xf7\xb8,\xe4b\xb4\xcb\xeeqY\xca\xc5h\x97\x9d\u3c94\x8b\xd1.;\xc7e1\x17\xa3]\u01e5\xd5s1\xdau\\\x92\\\x8cv\x1d\x97 \x17\xa3]\xc7%\xc8\xc5h\xd7qIr1\xdau\\\x82\\\x8cv\x1d\x97$\x17\xa3]\xc7%\xc8\xc5h\xd7qIr1\xdau\\\x82\\\x8cv\x1d\x97$\x97\x8d\x87s\\\xea\xb9\x18\xed:.I.F\xbb\x8eK\x90\x8b\u046e\xe3\x12\xe4b\xb4\xeb\xb8$\xb9\x18\xed:.A.F\xbb\x8eK\x92\x8b\u046e\xe3\x12\xe4b\xb4\xeb\xb8$\xb9\x18\xed:.A.F\xbb\x8eK\x92\x8b\u046e\xe3\x12\xe4b\xb4\xeb\xb8\x04\xb9\x18\xed:.I.F\xbb\xab?.I.F\xbb\xab?.Q.F\xbbk?.G\xbfsy\xf8\xa8\u058b\xd1\xeej\x8f\xcb\xd1\xe3'\u06e7\u03de\xff\xf9\xe0\xc5\xcbW\xaf\xb7o\xde.tc\xb4\xbb\xc2\xe32\fe\xa4\u07cd\xd1\ue68eK7\x94J7\x1bo\xb9\x82\u3485\xd2\xeb\xc6hw\x05\xc7\xe5/C\x99\xea\xc6k\x02\x00\xf0\x1fyw\xdc\u079f\x88\x0f\x1f?y\xcdu\x04\xf3\xaf>\x1f~\xf9\xea!\x05S\xf1\xed\xfb\x8f\x9f\xdeP0\x15~A\x82\xf1\v\u2103\xf1\v\x12\u0331_\x10'\x1b\x8c_\x10\xd5`\xfc\x82\xa8\x06\xe3\x17D1\x18\xbf \xaa\xc1\xf8\x05Q\r\xc6/\x88b0~A\x04\xc1\xf8\x05\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\xf7\v\xd93\x8e\xa4\x14\x1c\xf2\xaf\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsTile310x150PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsTile310x150Png, nil
}

func assetsStaticFaviconsTile310x150Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsTile310x150PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/tile310x150.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsTile310x310Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x02.\x00\x00\x02.\b\x03\x00\x00\x00\xaf\x94s\xed\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x00\xa5PLTEFk\xb0j\x87\xbf\xbc\xc9\xe2\xc5\xd1\xe6_\u007f\xbb\xab\xbc\xdb\xf7\xf8\xfcNr\xb3\xff\xff\xff\x9a\xae\xd4\xe6\xeb\xf4\x89\xa1\xcd\xd5\xdd\xedx\x93\xc5\xc4\xd0\xe6g\x86\xbe\xb3\xc2\xdfWx\xb7\xa2\xb5\xd7\xee\xf2\xf8\x92\xa7\xd0\xde\xe4\xf1\x81\x9a\xc9\xcd\xd7\xeap\x8d\xc2Ps\xb4\xba\xc7\xe1\xf5\xf7\xfb\xfe\xfe\xfe\xe0\xe6\xf2\xf4\xf6\xfa\xdf\xe6\xf1\xc1\xcd\u411d\xcbf\x84\xbeGl\xb1Qt\xb5e\x84\xbdz\x94\u018e\xa5\u03f7\xc5\xe0\xcb\xd6\xe9o\x8c\xc1\xc2\xce\xe5\xdc\xe3\xf0\xd5\xde\xed\xa0\xb3\xd7k\x89\xc0\xf9\xfa\xfc\x8f\xa5\xcfY{\xb8\xe7\xec\xf5\xb2\xc1\xde}\x97\xc7Hl\xb1Tdz\xaf\x00\x00\x00\x01bKGD\b\x86\u0795z\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x03\xc9IDATx\xda\xed\xda\u01ce\xd4P\x14E\xd1&?RS\x14\x19\x9a\x9cir\xfa\xffOCB\f\xca.\xfb\xf9\x1e\xe8\x01\x92\xd7\x1a{\xf4\xb4u=9\a\a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x000r\xca\x13Pw\xda\x13Pw\xe6\xac7\xa0\x9e\xcb9o@=\x97\xf3\x17<\x02\xe5\\\xdaE\x8f@=\x97K\x1e\x81z.\xed\xb2W\xa0\x9e\xcb\x15\xaf@=\x97v\xd53P\xcf\xe5\xd03P\u03e5]\xf3\x0e\xd4s\xd9x\a\uae74\xeb\x1e\x82z.[\x0fA=\x97\x1b\x1e\x82z.\xed\xa6\x97\xa0\x9e\xcb-/A=\x97v\xdbSP\xcf\u53a7\xa0\x9eK\xbb\xeb-\xa8\xe7b\xb4K\x90K3\xda%\xc8\xc5h\x97 \x17\xa3]\x82\\\x8cvIr1\xda%\xc8\xc5h\x97$\x17\xa3]\x82\\\x8cvIr1\xda%\xc8\xc5h\x97$\x97\x8d\a\xa1\x9e\x8b\xd1.I.F\xbb\x04\xb9\x18\xed\x12\xe4b\xb4K\x92\x8b\xd1.\u04f6S\xb9\x18\xed2\xe9\xde\xfd\xc9\\\x8cv\x99<.\u04f9\x18\xed2u\\\x1e\xcc\xe4b\xb4\xcb\xc4qi3\xb9\x18\xed2q\\fs1\xdae\xff\xb8\xcc\xe6b\xb4\xcb\xfeq\x99\xcd\xc5h\x97\xfd\xe32\x9f\x8b\xd1.{\xc7e>\x17\xa3]\xf6\x8eK'\x17\xa3]\xc6\u01e5\x93\x8b\xd1.\xe3\xe3\xd2\xcb\xc5h\x97\xd1q\xe9\xe5b\xb4\xcb\xe8\xb8ts\xd9x%\x06\u01e5\x9b\x8b\xd1.\xc3\xe3\xd2\xcf\xc5h\x97\xc1q\xe9\xe7b\xb4\xcb\xe0\xb8\xf4s1\xdaep\\\x16r1\xdae\xf7\xb8,\xe4b\xb4\xcb\xeeqY\xca\xc5h\x97\x9d\u3c94\x8b\xd1.;\xc7e1\x17\xa3]\u01e5\xd5s1\xdau\\\x92\\\x8cv\x1d\x97 \x17\xa3]\xc7%\xc8\xc5h\xd7qIr1\xdau\\\x82\\\x8cv\x1d\x97$\x17\xa3]\xc7%\xc8\xc5h\xd7qIr1\xdau\\\x82\\\x8cv\x1d\x97$\x97\x8d\x87s\\\xea\xb9\x18\xed:.I.F\xbb\x8eK\x90\x8b\u046e\xe3\x12\xe4b\xb4\xeb\xb8$\xb9\x18\xed:.A.F\xbb\x8eK\x92\x8b\u046e\xe3\x12\xe4b\xb4\xeb\xb8$\xb9\x18\xed:.A.F\xbb\x8eK\x92\x8b\u046e\xe3\x12\xe4b\xb4\xeb\xb8\x04\xb9\x18\xed:.I.F\xbb\xab?.I.F\xbb\xab?.Q.F\xbbk?.G\xbfsy\xf8\xa8\u058b\xd1\xeej\x8f\xcb\xd1\xe3'\u06e7\u03de\xff\xf9\xe0\xc5\xcbW\xaf\xb7o\xde.tc\xb4\xbb\xc2\xe32\fe\xa4\u07cd\xd1\ue68eK7\x94J7\x1bo\xb9\x82\u3485\xd2\xeb\xc6hw\x05\xc7\xe5/C\x99\xea\xc6k\x02\x00\xf0\x1fyw\xdc\u079f\x88\x0f\x1f?y\xcdu\x04\xf3\xaf>\x1f~\xf9\xea!\x05S\xf1\xed\xfb\x8f\x9f\xdeP0\x15~A\x82\xf1\v\u2103\xf1\v\x12\u0331_\x10'\x1b\x8c_\x10\xd5`\xfc\x82\xa8\x06\xe3\x17D1\x18\xbf \xaa\xc1\xf8\x05Q\r\xc6/\x88b0~A\x04\xc1\xf8\x05\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\xf7\v\xe8\x14\x8e\xa4\xe6-B1\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsTile310x310PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsTile310x310Png, nil
}

func assetsStaticFaviconsTile310x310Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsTile310x310PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/tile310x310.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticFaviconsTile70x70Png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x80\x00\x00\x00\x80\b\x03\x00\x00\x00\xf4\xe0\x91\xf9\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\v\xfca\x05\x00\x00\x00 cHRM\x00\x00z&\x00\x00\x80\x84\x00\x00\xfa\x00\x00\x00\x80\xe8\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17p\x9c\xbaQ<\x00\x00\x00\x9fPLTEFk\xb0n\x8b\xc1\xc0\xcc\xe4\xfc\xfc\xfdb\x81\xbc\xff\xff\xff\xb4\xc3\xdf\xf8\xf9\xfcRt\xb5\x9d\xb0\xd5\xeb\xef\xf6Hm\xb1\x8b\xa2\xce\xe2\xe8\xf2z\x94\xc6\xcb\xd6\xe9\xfe\xfe\xfe\xba\xc8\xe2Yz\xb8\xa8\xba\xda\xf2\xf5\xf9Lp\xb2\x91\xa7\u0405\x9e\xcb\xd7\xdf\xeet\x90\xc4\xd1\xda\xec\xf0\xf3\xf8\xd1\xda\xeb\xb2\xc1\u0793\xa9\xd1u\x90\xc4Uw\xb6Or\xb4e\x83\xbd\x8e\xa5\u03e3\xb5\u05f7\xc5\xe0\xe0\xe7\xf2\xf5\xf7\xfb\xc2\xce\xe5\xcd\xd7\xe9t\x90\xc3\xd0\xda\xeb\xfd\xfd\xfe\xd2\xdb\uc6af\xd4`\x80\xbb\xbd\xca\u319e\xccRu\xb5\xe3\xe9\xf3\xab\xbc\xdb\xe66K\xb8\x00\x00\x00\x01bKGD\x05\xf8o\xe9\xc7\x00\x00\x00\atIME\a\xe1\f\x11\x13&3^\xf7@g\x00\x00\x02\nIDATx\xda\xed\xd6\xd7R\xc30\x10\x85a\xa7\x88\x16\x8c)\x01\u2944\xde;\xbc\xff\xb3q\x01$N,\xc9r\xb2\xbbg\x86\xd9}\x01}st\xf3g\x99\x9d\x9d\x9d\x9d\x9d\x9d\x9d\xdd\x12\xd7A\x03\xbah@\xaf\x0f\x06\xb8\x154`u\r\fp\xebh\xc0\xc6\x00\fp\x9bh@\x8e\x06\xb8-4\xa0@\x03\xb6\xfb`\x80\xdbA\x03z\xbb`\x80\xdbC\x03\x86\xfb`\x80;@\x03\xf2\x01\x18\xe0\x0e\u0440\x11\x1a\xe0:h@\x17\r@\xc5\xe1\x04\x80\x8a\xc3)\x00\x14\x87S\x00(\x0e+\x00L\x1cV\x00\x988\xac\x02r4\x00\x12\x873\x80\x02\rP\x8e\u00f2\x06P\x8eC\xaa\x03T\xe3\xb0tu\x80j\x1c\x92\x0f\xa0\x18\x87\xa5\xf3\x01\x14\xe3\x90\xfc\x00\xb58,\x9d\x1f\xa0\x16\x87\x14\x02\x8c\xf4\x06\xf0\x03\x94\xe2\x90\u0080\xae\xda\x00\x01\x80J\x1cR\x04\xa0\x11\x87?\x03\x84\x00\nqHQ\x80|\x1c\xfe\x0e\x10\x04\x88\xc7!5\x00\xa4\xe3\xf0o\x800 \xd7\x19 \f\x90\x8d\xc3\xc9\x00\x11@\xa12@\x04 \x19\x87\xd3\x01\"\x00\xc98\xa4$\x80\\\x1cV\x06\x88\x01\xe4\xe2\x90\x12\x01RqX\x1d \n\x90\x8aCJ\x06\xc8\xc4\xe1\xcc\x00q\x80L\x1cR\v\xc0H|\x80\x06\x80D\x1cR+@Wz\x80&\x00\u007f\x1cR;\x00{\x1c\xce\x0f\xd0\b\xe0\x8eCj\v`\x8e\xc3\xda\x00\xcd\x00\xde8\xa4\xf6\x00\xd68\xac\x0f\x90\x00\xc8E\aH\x000\u01a1g\x80\x14@!9@\n\x80-\x0e}\x03\xa4\x00\xd8\xe2\x90\x16\x050\u0161w\x80$\x00S\x1c\xd2\xe2\x00\x968\xac\rpt|r:>\u02f2,;\xbf\u063a\xbc\xba.nnE\xe3\x90|O\xcf]P\xc2\x10\x87e\xfc\xe9&\xc9\xf2qx\x97\xf8t@r\x9f\xd9\xd9-{\x0f\x8fn\xe1{z~y\xc5\x11\x86o\xef\x1f\xb8\x15>\xbf\xc6\x03\xd8G0\r\xbf \x81s\xf8\xf6\x04\xf6\xe1\xdb\x10\x84\x86O$H\x0e\xdfL\x10\x1f>FP\x1a>@\xd0\x1c\xbeNP\x1f\xde\xce\xce\xce\xce\xce\xce\xee\xdf\xde7\u05ffFR8\xbdML\x00\x00\x00%tEXtdate:create\x002017-12-17T19:38:51+00:00\n\x14\xa7\xb5\x00\x00\x00%tEXtdate:modify\x002017-12-17T19:38:51+00:00{I\x1f\t\x00\x00\x00\x00IEND\xaeB`\x82")

func assetsStaticFaviconsTile70x70PngBytes() ([]byte, error) {
	return _assetsStaticFaviconsTile70x70Png, nil
}

func assetsStaticFaviconsTile70x70Png() (*asset, error) {
	bytes, err := assetsStaticFaviconsTile70x70PngBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/favicons/tile70x70.png", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticImgExclamationMarkSvg = []byte(`<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<svg
   xmlns:svg="http://www.w3.org/2000/svg"
   xmlns="http://www.w3.org/2000/svg"
   xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"
   xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"
   width="1370.6239"
   height="1370.6239"
   viewBox="-50 -30 137.06242 137.06239"
   version="1.1"
   inkscape:version="0.48.4 r9939"
   sodipodi:docname="AJAX1.svg">
  <path
     style="font-size:medium;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-indent:0;text-align:start;text-decoration:none;line-height:normal;letter-spacing:normal;word-spacing:normal;text-transform:none;direction:ltr;block-progression:tb;writing-mode:lr-tb;text-anchor:start;baseline-shift:baseline;color:#000000;fill:#000000;fill-opacity:1;stroke:none;stroke-width:5;marker:none;visibility:visible;display:inline;overflow:visible;enable-background:accumulate;font-family:Sans;-inkscape-font-specification:Sans"
     d="m -47.981023,33.625635 c -2.69197,2.691972 -2.691968,7.119136 0,9.811108 l 61.606686,61.606687 c 2.691971,2.69197 7.119132,2.69197 9.811105,0 l 61.60668,-61.606687 c 2.691969,-2.691972 2.691969,-7.119135 0,-9.811108 L 23.436767,-27.981027 c -2.691972,-2.69197 -7.119155,-2.691992 -9.811126,-2e-5 z"
     inkscape:connector-curvature="0"
     sodipodi:nodetypes="sssssssss" />
  <path
     style="fill:#ffeb00;fill-opacity:1;stroke:none"
     d="m 83.269048,35.386778 c 1.736669,1.736669 1.736669,4.552163 0,6.288831 L 21.675621,103.26905 c -1.736667,1.73666 -4.552161,1.73666 -6.28883,-2e-5 L -46.206617,41.675608 c -1.73667,-1.736669 -1.73667,-4.552162 -9e-6,-6.288829 l 61.593414,-61.593416 c 1.73667,-1.73667 4.552164,-1.73667 6.288831,0 z"
     inkscape:connector-curvature="0"
     sodipodi:nodetypes="sssssssss" />
  <path
     style="fill:#000000;fill-rule:nonzero;stroke:none"
     d="m 18.531222,-4.4321889 c -7.218623,-0.0089 -13.2767282,5.736028 -13.2780102,13.117923 8.84e-4,1.9253769 0.472226,3.2494629 0.472226,3.2494629 l 11.1810322,44.972299 1.624752,0 1.624719,0 11.181058,-44.972299 c 0,0 0.470918,-1.324086 0.4722,-3.2494629 -8.84e-4,-7.381895 -6.059362,-13.126913 -13.277977,-13.117923 z"
     inkscape:connector-curvature="0" />
  <path
     sodipodi:nodetypes="sssss"
     style="fill:#000000;fill-opacity:1;stroke:none"
     d="m 29.302818,70.722988 c 0,5.949 -4.822614,10.771611 -10.771585,10.771611 -5.949006,0 -10.7716206,-4.822611 -10.7716206,-10.771611 0,-5.948992 4.8226146,-10.771594 10.7716206,-10.771594 5.948971,0 10.771585,4.822602 10.771585,10.771594 z"
     inkscape:connector-curvature="0" />
</svg>
`)

func assetsStaticImgExclamationMarkSvgBytes() ([]byte, error) {
	return _assetsStaticImgExclamationMarkSvg, nil
}

func assetsStaticImgExclamationMarkSvg() (*asset, error) {
	bytes, err := assetsStaticImgExclamationMarkSvgBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/img/exclamation-mark.svg", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticJsMiscJs = []byte(`"use strict"
`)

func assetsStaticJsMiscJsBytes() ([]byte, error) {
	return _assetsStaticJsMiscJs, nil
}

func assetsStaticJsMiscJs() (*asset, error) {
	bytes, err := assetsStaticJsMiscJsBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/js/misc.js", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticJsPrismJs = []byte(`/* PrismJS 1.14.0
http://prismjs.com/download.html#themes=prism&languages=clike+javascript+bash+docker+go+java+protobuf+python+yaml */
var _self = (typeof window !== 'undefined')
	? window   // if in browser
	: (
		(typeof WorkerGlobalScope !== 'undefined' && self instanceof WorkerGlobalScope)
		? self // if in worker
		: {}   // if in node js
	);

/**
 * Prism: Lightweight, robust, elegant syntax highlighting
 * MIT license http://www.opensource.org/licenses/mit-license.php/
 * @author Lea Verou http://lea.verou.me
 */

var Prism = (function(){

// Private helper vars
var lang = /\blang(?:uage)?-([\w-]+)\b/i;
var uniqueId = 0;

var _ = _self.Prism = {
	manual: _self.Prism && _self.Prism.manual,
	disableWorkerMessageHandler: _self.Prism && _self.Prism.disableWorkerMessageHandler,
	util: {
		encode: function (tokens) {
			if (tokens instanceof Token) {
				return new Token(tokens.type, _.util.encode(tokens.content), tokens.alias);
			} else if (_.util.type(tokens) === 'Array') {
				return tokens.map(_.util.encode);
			} else {
				return tokens.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/\u00a0/g, ' ');
			}
		},

		type: function (o) {
			return Object.prototype.toString.call(o).match(/\[object (\w+)\]/)[1];
		},

		objId: function (obj) {
			if (!obj['__id']) {
				Object.defineProperty(obj, '__id', { value: ++uniqueId });
			}
			return obj['__id'];
		},

		// Deep clone a language definition (e.g. to extend it)
		clone: function (o, visited) {
			var type = _.util.type(o);
			visited = visited || {};

			switch (type) {
				case 'Object':
					if (visited[_.util.objId(o)]) {
						return visited[_.util.objId(o)];
					}
					var clone = {};
					visited[_.util.objId(o)] = clone;

					for (var key in o) {
						if (o.hasOwnProperty(key)) {
							clone[key] = _.util.clone(o[key], visited);
						}
					}

					return clone;

				case 'Array':
					if (visited[_.util.objId(o)]) {
						return visited[_.util.objId(o)];
					}
					var clone = [];
					visited[_.util.objId(o)] = clone;

					o.forEach(function (v, i) {
						clone[i] = _.util.clone(v, visited);
					});

					return clone;
			}

			return o;
		}
	},

	languages: {
		extend: function (id, redef) {
			var lang = _.util.clone(_.languages[id]);

			for (var key in redef) {
				lang[key] = redef[key];
			}

			return lang;
		},

		/**
		 * Insert a token before another token in a language literal
		 * As this needs to recreate the object (we cannot actually insert before keys in object literals),
		 * we cannot just provide an object, we need anobject and a key.
		 * @param inside The key (or language id) of the parent
		 * @param before The key to insert before. If not provided, the function appends instead.
		 * @param insert Object with the key/value pairs to insert
		 * @param root The object that contains `+"`"+`inside`+"`"+`. If equal to Prism.languages, it can be omitted.
		 */
		insertBefore: function (inside, before, insert, root) {
			root = root || _.languages;
			var grammar = root[inside];

			if (arguments.length == 2) {
				insert = arguments[1];

				for (var newToken in insert) {
					if (insert.hasOwnProperty(newToken)) {
						grammar[newToken] = insert[newToken];
					}
				}

				return grammar;
			}

			var ret = {};

			for (var token in grammar) {

				if (grammar.hasOwnProperty(token)) {

					if (token == before) {

						for (var newToken in insert) {

							if (insert.hasOwnProperty(newToken)) {
								ret[newToken] = insert[newToken];
							}
						}
					}

					ret[token] = grammar[token];
				}
			}

			// Update references in other language definitions
			_.languages.DFS(_.languages, function(key, value) {
				if (value === root[inside] && key != inside) {
					this[key] = ret;
				}
			});

			return root[inside] = ret;
		},

		// Traverse a language definition with Depth First Search
		DFS: function(o, callback, type, visited) {
			visited = visited || {};
			for (var i in o) {
				if (o.hasOwnProperty(i)) {
					callback.call(o, i, o[i], type || i);

					if (_.util.type(o[i]) === 'Object' && !visited[_.util.objId(o[i])]) {
						visited[_.util.objId(o[i])] = true;
						_.languages.DFS(o[i], callback, null, visited);
					}
					else if (_.util.type(o[i]) === 'Array' && !visited[_.util.objId(o[i])]) {
						visited[_.util.objId(o[i])] = true;
						_.languages.DFS(o[i], callback, i, visited);
					}
				}
			}
		}
	},
	plugins: {},

	highlightAll: function(async, callback) {
		_.highlightAllUnder(document, async, callback);
	},

	highlightAllUnder: function(container, async, callback) {
		var env = {
			callback: callback,
			selector: 'code[class*="language-"], [class*="language-"] code, code[class*="lang-"], [class*="lang-"] code'
		};

		_.hooks.run("before-highlightall", env);

		var elements = env.elements || container.querySelectorAll(env.selector);

		for (var i=0, element; element = elements[i++];) {
			_.highlightElement(element, async === true, env.callback);
		}
	},

	highlightElement: function(element, async, callback) {
		// Find language
		var language, grammar, parent = element;

		while (parent && !lang.test(parent.className)) {
			parent = parent.parentNode;
		}

		if (parent) {
			language = (parent.className.match(lang) || [,''])[1].toLowerCase();
			grammar = _.languages[language];
		}

		// Set language on the element, if not present
		element.className = element.className.replace(lang, '').replace(/\s+/g, ' ') + ' language-' + language;

		if (element.parentNode) {
			// Set language on the parent, for styling
			parent = element.parentNode;

			if (/pre/i.test(parent.nodeName)) {
				parent.className = parent.className.replace(lang, '').replace(/\s+/g, ' ') + ' language-' + language;
			}
		}

		var code = element.textContent;

		var env = {
			element: element,
			language: language,
			grammar: grammar,
			code: code
		};

		_.hooks.run('before-sanity-check', env);

		if (!env.code || !env.grammar) {
			if (env.code) {
				_.hooks.run('before-highlight', env);
				env.element.textContent = env.code;
				_.hooks.run('after-highlight', env);
			}
			_.hooks.run('complete', env);
			return;
		}

		_.hooks.run('before-highlight', env);

		if (async && _self.Worker) {
			var worker = new Worker(_.filename);

			worker.onmessage = function(evt) {
				env.highlightedCode = evt.data;

				_.hooks.run('before-insert', env);

				env.element.innerHTML = env.highlightedCode;

				callback && callback.call(env.element);
				_.hooks.run('after-highlight', env);
				_.hooks.run('complete', env);
			};

			worker.postMessage(JSON.stringify({
				language: env.language,
				code: env.code,
				immediateClose: true
			}));
		}
		else {
			env.highlightedCode = _.highlight(env.code, env.grammar, env.language);

			_.hooks.run('before-insert', env);

			env.element.innerHTML = env.highlightedCode;

			callback && callback.call(element);

			_.hooks.run('after-highlight', env);
			_.hooks.run('complete', env);
		}
	},

	highlight: function (text, grammar, language) {
		var env = {
			code: text,
			grammar: grammar,
			language: language
		};
		_.hooks.run('before-tokenize', env);
		env.tokens = _.tokenize(env.code, env.grammar);
		_.hooks.run('after-tokenize', env);
		return Token.stringify(_.util.encode(env.tokens), env.language);
	},

	matchGrammar: function (text, strarr, grammar, index, startPos, oneshot, target) {
		var Token = _.Token;

		for (var token in grammar) {
			if(!grammar.hasOwnProperty(token) || !grammar[token]) {
				continue;
			}

			if (token == target) {
				return;
			}

			var patterns = grammar[token];
			patterns = (_.util.type(patterns) === "Array") ? patterns : [patterns];

			for (var j = 0; j < patterns.length; ++j) {
				var pattern = patterns[j],
					inside = pattern.inside,
					lookbehind = !!pattern.lookbehind,
					greedy = !!pattern.greedy,
					lookbehindLength = 0,
					alias = pattern.alias;

				if (greedy && !pattern.pattern.global) {
					// Without the global flag, lastIndex won't work
					var flags = pattern.pattern.toString().match(/[imuy]*$/)[0];
					pattern.pattern = RegExp(pattern.pattern.source, flags + "g");
				}

				pattern = pattern.pattern || pattern;

				// Don’t cache length as it changes during the loop
				for (var i = index, pos = startPos; i < strarr.length; pos += strarr[i].length, ++i) {

					var str = strarr[i];

					if (strarr.length > text.length) {
						// Something went terribly wrong, ABORT, ABORT!
						return;
					}

					if (str instanceof Token) {
						continue;
					}

					if (greedy && i != strarr.length - 1) {
						pattern.lastIndex = pos;
						var match = pattern.exec(text);
						if (!match) {
							break;
						}

						var from = match.index + (lookbehind ? match[1].length : 0),
						    to = match.index + match[0].length,
						    k = i,
						    p = pos;

						for (var len = strarr.length; k < len && (p < to || (!strarr[k].type && !strarr[k - 1].greedy)); ++k) {
							p += strarr[k].length;
							// Move the index i to the element in strarr that is closest to from
							if (from >= p) {
								++i;
								pos = p;
							}
						}

						// If strarr[i] is a Token, then the match starts inside another Token, which is invalid
						if (strarr[i] instanceof Token) {
							continue;
						}

						// Number of tokens to delete and replace with the new match
						delNum = k - i;
						str = text.slice(pos, p);
						match.index -= pos;
					} else {
						pattern.lastIndex = 0;

						var match = pattern.exec(str),
							delNum = 1;
					}

					if (!match) {
						if (oneshot) {
							break;
						}

						continue;
					}

					if(lookbehind) {
						lookbehindLength = match[1] ? match[1].length : 0;
					}

					var from = match.index + lookbehindLength,
					    match = match[0].slice(lookbehindLength),
					    to = from + match.length,
					    before = str.slice(0, from),
					    after = str.slice(to);

					var args = [i, delNum];

					if (before) {
						++i;
						pos += before.length;
						args.push(before);
					}

					var wrapped = new Token(token, inside? _.tokenize(match, inside) : match, alias, match, greedy);

					args.push(wrapped);

					if (after) {
						args.push(after);
					}

					Array.prototype.splice.apply(strarr, args);

					if (delNum != 1)
						_.matchGrammar(text, strarr, grammar, i, pos, true, token);

					if (oneshot)
						break;
				}
			}
		}
	},

	tokenize: function(text, grammar, language) {
		var strarr = [text];

		var rest = grammar.rest;

		if (rest) {
			for (var token in rest) {
				grammar[token] = rest[token];
			}

			delete grammar.rest;
		}

		_.matchGrammar(text, strarr, grammar, 0, 0, false);

		return strarr;
	},

	hooks: {
		all: {},

		add: function (name, callback) {
			var hooks = _.hooks.all;

			hooks[name] = hooks[name] || [];

			hooks[name].push(callback);
		},

		run: function (name, env) {
			var callbacks = _.hooks.all[name];

			if (!callbacks || !callbacks.length) {
				return;
			}

			for (var i=0, callback; callback = callbacks[i++];) {
				callback(env);
			}
		}
	}
};

var Token = _.Token = function(type, content, alias, matchedStr, greedy) {
	this.type = type;
	this.content = content;
	this.alias = alias;
	// Copy of the full string this token was created from
	this.length = (matchedStr || "").length|0;
	this.greedy = !!greedy;
};

Token.stringify = function(o, language, parent) {
	if (typeof o == 'string') {
		return o;
	}

	if (_.util.type(o) === 'Array') {
		return o.map(function(element) {
			return Token.stringify(element, language, o);
		}).join('');
	}

	var env = {
		type: o.type,
		content: Token.stringify(o.content, language, parent),
		tag: 'span',
		classes: ['token', o.type],
		attributes: {},
		language: language,
		parent: parent
	};

	if (o.alias) {
		var aliases = _.util.type(o.alias) === 'Array' ? o.alias : [o.alias];
		Array.prototype.push.apply(env.classes, aliases);
	}

	_.hooks.run('wrap', env);

	var attributes = Object.keys(env.attributes).map(function(name) {
		return name + '="' + (env.attributes[name] || '').replace(/"/g, '&quot;') + '"';
	}).join(' ');

	return '<' + env.tag + ' class="' + env.classes.join(' ') + '"' + (attributes ? ' ' + attributes : '') + '>' + env.content + '</' + env.tag + '>';

};

if (!_self.document) {
	if (!_self.addEventListener) {
		// in Node.js
		return _self.Prism;
	}

	if (!_.disableWorkerMessageHandler) {
		// In worker
		_self.addEventListener('message', function (evt) {
			var message = JSON.parse(evt.data),
				lang = message.language,
				code = message.code,
				immediateClose = message.immediateClose;

			_self.postMessage(_.highlight(code, _.languages[lang], lang));
			if (immediateClose) {
				_self.close();
			}
		}, false);
	}

	return _self.Prism;
}

//Get current script and highlight
var script = document.currentScript || [].slice.call(document.getElementsByTagName("script")).pop();

if (script) {
	_.filename = script.src;

	if (!_.manual && !script.hasAttribute('data-manual')) {
		if(document.readyState !== "loading") {
			if (window.requestAnimationFrame) {
				window.requestAnimationFrame(_.highlightAll);
			} else {
				window.setTimeout(_.highlightAll, 16);
			}
		}
		else {
			document.addEventListener('DOMContentLoaded', _.highlightAll);
		}
	}
}

return _self.Prism;

})();

if (typeof module !== 'undefined' && module.exports) {
	module.exports = Prism;
}

// hack for components to work correctly in node.js
if (typeof global !== 'undefined') {
	global.Prism = Prism;
}
;
Prism.languages.clike = {
	'comment': [
		{
			pattern: /(^|[^\\])\/\*[\s\S]*?(?:\*\/|$)/,
			lookbehind: true
		},
		{
			pattern: /(^|[^\\:])\/\/.*/,
			lookbehind: true,
			greedy: true
		}
	],
	'string': {
		pattern: /(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,
		greedy: true
	},
	'class-name': {
		pattern: /((?:\b(?:class|interface|extends|implements|trait|instanceof|new)\s+)|(?:catch\s+\())[\w.\\]+/i,
		lookbehind: true,
		inside: {
			punctuation: /[.\\]/
		}
	},
	'keyword': /\b(?:if|else|while|do|for|return|in|instanceof|function|new|try|throw|catch|finally|null|break|continue)\b/,
	'boolean': /\b(?:true|false)\b/,
	'function': /[a-z0-9_]+(?=\()/i,
	'number': /\b0x[\da-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?/i,
	'operator': /--?|\+\+?|!=?=?|<=?|>=?|==?=?|&&?|\|\|?|\?|\*|\/|~|\^|%/,
	'punctuation': /[{}[\];(),.:]/
};

Prism.languages.javascript = Prism.languages.extend('clike', {
	'keyword': /\b(?:as|async|await|break|case|catch|class|const|continue|debugger|default|delete|do|else|enum|export|extends|finally|for|from|function|get|if|implements|import|in|instanceof|interface|let|new|null|of|package|private|protected|public|return|set|static|super|switch|this|throw|try|typeof|var|void|while|with|yield)\b/,
	'number': /\b(?:0[xX][\dA-Fa-f]+|0[bB][01]+|0[oO][0-7]+|NaN|Infinity)\b|(?:\b\d+\.?\d*|\B\.\d+)(?:[Ee][+-]?\d+)?/,
	// Allow for all non-ASCII characters (See http://stackoverflow.com/a/2008444)
	'function': /[_$a-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*\()/i,
	'operator': /-[-=]?|\+[+=]?|!=?=?|<<?=?|>>?>?=?|=(?:==?|>)?|&[&=]?|\|[|=]?|\*\*?=?|\/=?|~|\^=?|%=?|\?|\.{3}/
});

Prism.languages.insertBefore('javascript', 'keyword', {
	'regex': {
		pattern: /((?:^|[^$\w\xA0-\uFFFF."'\])\s])\s*)\/(\[[^\]\r\n]+]|\\.|[^/\\\[\r\n])+\/[gimyu]{0,5}(?=\s*($|[\r\n,.;})\]]))/,
		lookbehind: true,
		greedy: true
	},
	// This must be declared before keyword because we use "function" inside the look-forward
	'function-variable': {
		pattern: /[_$a-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*=\s*(?:function\b|(?:\([^()]*\)|[_$a-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*)\s*=>))/i,
		alias: 'function'
	},
	'constant': /\b[A-Z][A-Z\d_]*\b/
});

Prism.languages.insertBefore('javascript', 'string', {
	'template-string': {
		pattern: /`+"`"+`(?:\\[\s\S]|[^\\`+"`"+`])*`+"`"+`/,
		greedy: true,
		inside: {
			'interpolation': {
				pattern: /\$\{[^}]+\}/,
				inside: {
					'interpolation-punctuation': {
						pattern: /^\$\{|\}$/,
						alias: 'punctuation'
					},
					rest: Prism.languages.javascript
				}
			},
			'string': /[\s\S]+/
		}
	}
});

if (Prism.languages.markup) {
	Prism.languages.insertBefore('markup', 'tag', {
		'script': {
			pattern: /(<script[\s\S]*?>)[\s\S]*?(?=<\/script>)/i,
			lookbehind: true,
			inside: Prism.languages.javascript,
			alias: 'language-javascript',
			greedy: true
		}
	});
}

Prism.languages.js = Prism.languages.javascript;

(function(Prism) {
	var insideString = {
		variable: [
			// Arithmetic Environment
			{
				pattern: /\$?\(\([\s\S]+?\)\)/,
				inside: {
					// If there is a $ sign at the beginning highlight $(( and )) as variable
					variable: [{
							pattern: /(^\$\(\([\s\S]+)\)\)/,
							lookbehind: true
						},
						/^\$\(\(/
					],
					number: /\b0x[\dA-Fa-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:[Ee]-?\d+)?/,
					// Operators according to https://www.gnu.org/software/bash/manual/bashref.html#Shell-Arithmetic
					operator: /--?|-=|\+\+?|\+=|!=?|~|\*\*?|\*=|\/=?|%=?|<<=?|>>=?|<=?|>=?|==?|&&?|&=|\^=?|\|\|?|\|=|\?|:/,
					// If there is no $ sign at the beginning highlight (( and )) as punctuation
					punctuation: /\(\(?|\)\)?|,|;/
				}
			},
			// Command Substitution
			{
				pattern: /\$\([^)]+\)|`+"`"+`[^`+"`"+`]+`+"`"+`/,
				greedy: true,
				inside: {
					variable: /^\$\(|^`+"`"+`|\)$|`+"`"+`$/
				}
			},
			/\$(?:[\w#?*!@]+|\{[^}]+\})/i
		]
	};

	Prism.languages.bash = {
		'shebang': {
			pattern: /^#!\s*\/bin\/bash|^#!\s*\/bin\/sh/,
			alias: 'important'
		},
		'comment': {
			pattern: /(^|[^"{\\])#.*/,
			lookbehind: true
		},
		'string': [
			//Support for Here-Documents https://en.wikipedia.org/wiki/Here_document
			{
				pattern: /((?:^|[^<])<<\s*)["']?(\w+?)["']?\s*\r?\n(?:[\s\S])*?\r?\n\2/,
				lookbehind: true,
				greedy: true,
				inside: insideString
			},
			{
				pattern: /(["'])(?:\\[\s\S]|\$\([^)]+\)|`+"`"+`[^`+"`"+`]+`+"`"+`|(?!\1)[^\\])*\1/,
				greedy: true,
				inside: insideString
			}
		],
		'variable': insideString.variable,
		// Originally based on http://ss64.com/bash/
		'function': {
			pattern: /(^|[\s;|&])(?:alias|apropos|apt-get|aptitude|aspell|awk|basename|bash|bc|bg|builtin|bzip2|cal|cat|cd|cfdisk|chgrp|chmod|chown|chroot|chkconfig|cksum|clear|cmp|comm|command|cp|cron|crontab|csplit|curl|cut|date|dc|dd|ddrescue|df|diff|diff3|dig|dir|dircolors|dirname|dirs|dmesg|du|egrep|eject|enable|env|ethtool|eval|exec|expand|expect|export|expr|fdformat|fdisk|fg|fgrep|file|find|fmt|fold|format|free|fsck|ftp|fuser|gawk|getopts|git|grep|groupadd|groupdel|groupmod|groups|gzip|hash|head|help|hg|history|hostname|htop|iconv|id|ifconfig|ifdown|ifup|import|install|jobs|join|kill|killall|less|link|ln|locate|logname|logout|look|lpc|lpr|lprint|lprintd|lprintq|lprm|ls|lsof|make|man|mkdir|mkfifo|mkisofs|mknod|more|most|mount|mtools|mtr|mv|mmv|nano|netstat|nice|nl|nohup|notify-send|npm|nslookup|open|op|passwd|paste|pathchk|ping|pkill|popd|pr|printcap|printenv|printf|ps|pushd|pv|pwd|quota|quotacheck|quotactl|ram|rar|rcp|read|readarray|readonly|reboot|rename|renice|remsync|rev|rm|rmdir|rsync|screen|scp|sdiff|sed|seq|service|sftp|shift|shopt|shutdown|sleep|slocate|sort|source|split|ssh|stat|strace|su|sudo|sum|suspend|sync|tail|tar|tee|test|time|timeout|times|touch|top|traceroute|trap|tr|tsort|tty|type|ulimit|umask|umount|unalias|uname|unexpand|uniq|units|unrar|unshar|uptime|useradd|userdel|usermod|users|uuencode|uudecode|v|vdir|vi|vmstat|wait|watch|wc|wget|whereis|which|who|whoami|write|xargs|xdg-open|yes|zip)(?=$|[\s;|&])/,
			lookbehind: true
		},
		'keyword': {
			pattern: /(^|[\s;|&])(?:let|:|\.|if|then|else|elif|fi|for|break|continue|while|in|case|function|select|do|done|until|echo|exit|return|set|declare)(?=$|[\s;|&])/,
			lookbehind: true
		},
		'boolean': {
			pattern: /(^|[\s;|&])(?:true|false)(?=$|[\s;|&])/,
			lookbehind: true
		},
		'operator': /&&?|\|\|?|==?|!=?|<<<?|>>|<=?|>=?|=~/,
		'punctuation': /\$?\(\(?|\)\)?|\.\.|[{}[\];]/
	};

	var inside = insideString.variable[1].inside;
	inside.string = Prism.languages.bash.string;
	inside['function'] = Prism.languages.bash['function'];
	inside.keyword = Prism.languages.bash.keyword;
	inside.boolean = Prism.languages.bash.boolean;
	inside.operator = Prism.languages.bash.operator;
	inside.punctuation = Prism.languages.bash.punctuation;
	
	Prism.languages.shell = Prism.languages.bash;
})(Prism);

Prism.languages.docker = {
	'keyword': {
		pattern: /(^\s*)(?:ADD|ARG|CMD|COPY|ENTRYPOINT|ENV|EXPOSE|FROM|HEALTHCHECK|LABEL|MAINTAINER|ONBUILD|RUN|SHELL|STOPSIGNAL|USER|VOLUME|WORKDIR)(?=\s)/mi,
		lookbehind: true
	},
	'string': /("|')(?:(?!\1)[^\\\r\n]|\\(?:\r\n|[\s\S]))*\1/,
	'comment': /#.*/,
	'punctuation': /---|\.\.\.|[:[\]{}\-,|>?]/
};

Prism.languages.dockerfile = Prism.languages.docker;

Prism.languages.go = Prism.languages.extend('clike', {
	'keyword': /\b(?:break|case|chan|const|continue|default|defer|else|fallthrough|for|func|go(?:to)?|if|import|interface|map|package|range|return|select|struct|switch|type|var)\b/,
	'builtin': /\b(?:bool|byte|complex(?:64|128)|error|float(?:32|64)|rune|string|u?int(?:8|16|32|64)?|uintptr|append|cap|close|complex|copy|delete|imag|len|make|new|panic|print(?:ln)?|real|recover)\b/,
	'boolean': /\b(?:_|iota|nil|true|false)\b/,
	'operator': /[*\/%^!=]=?|\+[=+]?|-[=-]?|\|[=|]?|&(?:=|&|\^=?)?|>(?:>=?|=)?|<(?:<=?|=|-)?|:=|\.\.\./,
	'number': /(?:\b0x[a-f\d]+|(?:\b\d+\.?\d*|\B\.\d+)(?:e[-+]?\d+)?)i?/i,
	'string': {
		pattern: /(["'`+"`"+`])(\\[\s\S]|(?!\1)[^\\])*\1/,
		greedy: true
	}
});
delete Prism.languages.go['class-name'];

Prism.languages.java = Prism.languages.extend('clike', {
	'keyword': /\b(?:abstract|continue|for|new|switch|assert|default|goto|package|synchronized|boolean|do|if|private|this|break|double|implements|protected|throw|byte|else|import|public|throws|case|enum|instanceof|return|transient|catch|extends|int|short|try|char|final|interface|static|void|class|finally|long|strictfp|volatile|const|float|native|super|while)\b/,
	'number': /\b0b[01]+\b|\b0x[\da-f]*\.?[\da-fp-]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?[df]?/i,
	'operator': {
		pattern: /(^|[^.])(?:\+[+=]?|-[-=]?|!=?|<<?=?|>>?>?=?|==?|&[&=]?|\|[|=]?|\*=?|\/=?|%=?|\^=?|[?:~])/m,
		lookbehind: true
	}
});

Prism.languages.insertBefore('java','function', {
	'annotation': {
		alias: 'punctuation',
		pattern: /(^|[^.])@\w+/,
		lookbehind: true
	}
});

Prism.languages.insertBefore('java', 'class-name', {
	'generics': {
		pattern: /<\s*\w+(?:\.\w+)?(?:\s*,\s*\w+(?:\.\w+)?)*>/i,
		alias: 'function',
		inside: {
			keyword: Prism.languages.java.keyword,
			punctuation: /[<>(),.:]/
		}
	}
});

Prism.languages.protobuf = Prism.languages.extend('clike', {
	keyword: /\b(?:package|import|message|enum)\b/,
	builtin: /\b(?:required|repeated|optional|reserved)\b/,
	primitive: {
		pattern: /\b(?:double|float|int32|int64|uint32|uint64|sint32|sint64|fixed32|fixed64|sfixed32|sfixed64|bool|string|bytes)\b/,
		alias: 'symbol'
	}
});

Prism.languages.python = {
	'comment': {
		pattern: /(^|[^\\])#.*/,
		lookbehind: true
	},
	'triple-quoted-string': {
		pattern: /("""|''')[\s\S]+?\1/,
		greedy: true,
		alias: 'string'
	},
	'string': {
		pattern: /("|')(?:\\.|(?!\1)[^\\\r\n])*\1/,
		greedy: true
	},
	'function': {
		pattern: /((?:^|\s)def[ \t]+)[a-zA-Z_]\w*(?=\s*\()/g,
		lookbehind: true
	},
	'class-name': {
		pattern: /(\bclass\s+)\w+/i,
		lookbehind: true
	},
	'keyword': /\b(?:as|assert|async|await|break|class|continue|def|del|elif|else|except|exec|finally|for|from|global|if|import|in|is|lambda|nonlocal|pass|print|raise|return|try|while|with|yield)\b/,
	'builtin':/\b(?:__import__|abs|all|any|apply|ascii|basestring|bin|bool|buffer|bytearray|bytes|callable|chr|classmethod|cmp|coerce|compile|complex|delattr|dict|dir|divmod|enumerate|eval|execfile|file|filter|float|format|frozenset|getattr|globals|hasattr|hash|help|hex|id|input|int|intern|isinstance|issubclass|iter|len|list|locals|long|map|max|memoryview|min|next|object|oct|open|ord|pow|property|range|raw_input|reduce|reload|repr|reversed|round|set|setattr|slice|sorted|staticmethod|str|sum|super|tuple|type|unichr|unicode|vars|xrange|zip)\b/,
	'boolean': /\b(?:True|False|None)\b/,
	'number': /(?:\b(?=\d)|\B(?=\.))(?:0[bo])?(?:(?:\d|0x[\da-f])[\da-f]*\.?\d*|\.\d+)(?:e[+-]?\d+)?j?\b/i,
	'operator': /[-+%=]=?|!=|\*\*?=?|\/\/?=?|<[<=>]?|>[=>]?|[&|^~]|\b(?:or|and|not)\b/,
	'punctuation': /[{}[\];(),.:]/
};

Prism.languages.yaml = {
	'scalar': {
		pattern: /([\-:]\s*(?:![^\s]+)?[ \t]*[|>])[ \t]*(?:((?:\r?\n|\r)[ \t]+)[^\r\n]+(?:\2[^\r\n]+)*)/,
		lookbehind: true,
		alias: 'string'
	},
	'comment': /#.*/,
	'key': {
		pattern: /(\s*(?:^|[:\-,[{\r\n?])[ \t]*(?:![^\s]+)?[ \t]*)[^\r\n{[\]},#\s]+?(?=\s*:\s)/,
		lookbehind: true,
		alias: 'atrule'
	},
	'directive': {
		pattern: /(^[ \t]*)%.+/m,
		lookbehind: true,
		alias: 'important'
	},
	'datetime': {
		pattern: /([:\-,[{]\s*(?:![^\s]+)?[ \t]*)(?:\d{4}-\d\d?-\d\d?(?:[tT]|[ \t]+)\d\d?:\d{2}:\d{2}(?:\.\d*)?[ \t]*(?:Z|[-+]\d\d?(?::\d{2})?)?|\d{4}-\d{2}-\d{2}|\d\d?:\d{2}(?::\d{2}(?:\.\d*)?)?)(?=[ \t]*(?:$|,|]|}))/m,
		lookbehind: true,
		alias: 'number'
	},
	'boolean': {
		pattern: /([:\-,[{]\s*(?:![^\s]+)?[ \t]*)(?:true|false)[ \t]*(?=$|,|]|})/im,
		lookbehind: true,
		alias: 'important'
	},
	'null': {
		pattern: /([:\-,[{]\s*(?:![^\s]+)?[ \t]*)(?:null|~)[ \t]*(?=$|,|]|})/im,
		lookbehind: true,
		alias: 'important'
	},
	'string': {
		pattern: /([:\-,[{]\s*(?:![^\s]+)?[ \t]*)("|')(?:(?!\2)[^\\\r\n]|\\.)*\2(?=[ \t]*(?:$|,|]|}))/m,
		lookbehind: true,
		greedy: true
	},
	'number': {
		pattern: /([:\-,[{]\s*(?:![^\s]+)?[ \t]*)[+-]?(?:0x[\da-f]+|0o[0-7]+|(?:\d+\.?\d*|\.?\d+)(?:e[+-]?\d+)?|\.inf|\.nan)[ \t]*(?=$|,|]|})/im,
		lookbehind: true
	},
	'tag': /![^\s]+/,
	'important': /[&*][\w]+/,
	'punctuation': /---|[:[\]{}\-,|>?]|\.\.\./
};

`)

func assetsStaticJsPrismJsBytes() ([]byte, error) {
	return _assetsStaticJsPrismJs, nil
}

func assetsStaticJsPrismJs() (*asset, error) {
	bytes, err := assetsStaticJsPrismJsBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/js/prism.js", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticJsPrismMinJs = []byte(`var _self='undefined'==typeof window?'undefined'!=typeof WorkerGlobalScope&&self instanceof WorkerGlobalScope?self:{}:window,Prism=function(){var a=/\blang(?:uage)?-([\w-]+)\b/i,b=0,c=_self.Prism={manual:_self.Prism&&_self.Prism.manual,disableWorkerMessageHandler:_self.Prism&&_self.Prism.disableWorkerMessageHandler,util:{encode:function(f){return f instanceof d?new d(f.type,c.util.encode(f.content),f.alias):'Array'===c.util.type(f)?f.map(c.util.encode):f.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/\u00a0/g,' ')},type:function(f){return Object.prototype.toString.call(f).match(/\[object (\w+)\]/)[1]},objId:function(f){return f.__id||Object.defineProperty(f,'__id',{value:++b}),f.__id},clone:function(f,g){var h=c.util.type(f);switch(g=g||{},h){case'Object':if(g[c.util.objId(f)])return g[c.util.objId(f)];var l={};for(var m in g[c.util.objId(f)]=l,f)f.hasOwnProperty(m)&&(l[m]=c.util.clone(f[m],g));return l;case'Array':if(g[c.util.objId(f)])return g[c.util.objId(f)];var l=[];return g[c.util.objId(f)]=l,f.forEach(function(n,q){l[q]=c.util.clone(n,g)}),l;}return f}},languages:{extend:function(f,g){var h=c.util.clone(c.languages[f]);for(var l in g)h[l]=g[l];return h},insertBefore:function(f,g,h,l){l=l||c.languages;var m=l[f];if(2==arguments.length){for(var n in h=arguments[1],h)h.hasOwnProperty(n)&&(m[n]=h[n]);return m}var q={};for(var r in m)if(m.hasOwnProperty(r)){if(r==g)for(var n in h)h.hasOwnProperty(n)&&(q[n]=h[n]);q[r]=m[r]}return c.languages.DFS(c.languages,function(s,t){t===l[f]&&s!=f&&(this[s]=q)}),l[f]=q},DFS:function(f,g,h,l){for(var m in l=l||{},f)f.hasOwnProperty(m)&&(g.call(f,m,f[m],h||m),'Object'!==c.util.type(f[m])||l[c.util.objId(f[m])]?'Array'===c.util.type(f[m])&&!l[c.util.objId(f[m])]&&(l[c.util.objId(f[m])]=!0,c.languages.DFS(f[m],g,m,l)):(l[c.util.objId(f[m])]=!0,c.languages.DFS(f[m],g,null,l)))}},plugins:{},highlightAll:function(f,g){c.highlightAllUnder(document,f,g)},highlightAllUnder:function(f,g,h){var l={callback:h,selector:'code[class*="language-"], [class*="language-"] code, code[class*="lang-"], [class*="lang-"] code'};c.hooks.run('before-highlightall',l);for(var q,m=l.elements||f.querySelectorAll(l.selector),n=0;q=m[n++];)c.highlightElement(q,!0===g,l.callback)},highlightElement:function(f,g,h){for(var l,m,n=f;n&&!a.test(n.className);)n=n.parentNode;n&&(l=(n.className.match(a)||[,''])[1].toLowerCase(),m=c.languages[l]),f.className=f.className.replace(a,'').replace(/\s+/g,' ')+' language-'+l,f.parentNode&&(n=f.parentNode,/pre/i.test(n.nodeName)&&(n.className=n.className.replace(a,'').replace(/\s+/g,' ')+' language-'+l));var q=f.textContent,r={element:f,language:l,grammar:m,code:q};if(c.hooks.run('before-sanity-check',r),!r.code||!r.grammar)return r.code&&(c.hooks.run('before-highlight',r),r.element.textContent=r.code,c.hooks.run('after-highlight',r)),void c.hooks.run('complete',r);if(c.hooks.run('before-highlight',r),g&&_self.Worker){var s=new Worker(c.filename);s.onmessage=function(t){r.highlightedCode=t.data,c.hooks.run('before-insert',r),r.element.innerHTML=r.highlightedCode,h&&h.call(r.element),c.hooks.run('after-highlight',r),c.hooks.run('complete',r)},s.postMessage(JSON.stringify({language:r.language,code:r.code,immediateClose:!0}))}else r.highlightedCode=c.highlight(r.code,r.grammar,r.language),c.hooks.run('before-insert',r),r.element.innerHTML=r.highlightedCode,h&&h.call(f),c.hooks.run('after-highlight',r),c.hooks.run('complete',r)},highlight:function(f,g,h){var l={code:f,grammar:g,language:h};return c.hooks.run('before-tokenize',l),l.tokens=c.tokenize(l.code,l.grammar),c.hooks.run('after-tokenize',l),d.stringify(c.util.encode(l.tokens),l.language)},matchGrammar:function(f,g,h,l,m,n,q){var r=c.Token;for(var s in h)if(h.hasOwnProperty(s)&&h[s]){if(s==q)return;var t=h[s];t='Array'===c.util.type(t)?t:[t];for(var u=0;u<t.length;++u){var w=t[u],x=w.inside,y=!!w.lookbehind,z=!!w.greedy,A=0,B=w.alias;if(z&&!w.pattern.global){var C=w.pattern.toString().match(/[imuy]*$/)[0];w.pattern=RegExp(w.pattern.source,C+'g')}w=w.pattern||w;for(var F,D=l,E=m;D<g.length;E+=g[D].length,++D){if(F=g[D],g.length>f.length)return;if(!(F instanceof r)){if(z&&D!=g.length-1){w.lastIndex=E;var G=w.exec(f);if(!G)break;for(var H=G.index+(y?G[1].length:0),I=G.index+G[0].length,J=D,K=E,L=g.length;J<L&&(K<I||!g[J].type&&!g[J-1].greedy);++J)K+=g[J].length,H>=K&&(++D,E=K);if(g[D]instanceof r)continue;M=J-D,F=f.slice(E,K),G.index-=E}else{w.lastIndex=0;var G=w.exec(F),M=1}if(!G){if(n)break;continue}y&&(A=G[1]?G[1].length:0);var H=G.index+A,G=G[0].slice(A),I=H+G.length,N=F.slice(0,H),O=F.slice(I),P=[D,M];N&&(++D,E+=N.length,P.push(N));var Q=new r(s,x?c.tokenize(G,x):G,B,G,z);if(P.push(Q),O&&P.push(O),Array.prototype.splice.apply(g,P),1!=M&&c.matchGrammar(f,g,h,D,E,!0,s),n)break}}}}},tokenize:function(f,g){var l=[f],m=g.rest;if(m){for(var n in m)g[n]=m[n];delete g.rest}return c.matchGrammar(f,l,g,0,0,!1),l},hooks:{all:{},add:function(f,g){var h=c.hooks.all;h[f]=h[f]||[],h[f].push(g)},run:function(f,g){var h=c.hooks.all[f];if(h&&h.length)for(var m,l=0;m=h[l++];)m(g)}}},d=c.Token=function(f,g,h,l,m){this.type=f,this.content=g,this.alias=h,this.length=0|(l||'').length,this.greedy=!!m};if(d.stringify=function(f,g,h){if('string'==typeof f)return f;if('Array'===c.util.type(f))return f.map(function(q){return d.stringify(q,g,f)}).join('');var l={type:f.type,content:d.stringify(f.content,g,h),tag:'span',classes:['token',f.type],attributes:{},language:g,parent:h};if(f.alias){var m='Array'===c.util.type(f.alias)?f.alias:[f.alias];Array.prototype.push.apply(l.classes,m)}c.hooks.run('wrap',l);var n=Object.keys(l.attributes).map(function(q){return q+'="'+(l.attributes[q]||'').replace(/"/g,'&quot;')+'"'}).join(' ');return'<'+l.tag+' class="'+l.classes.join(' ')+'"'+(n?' '+n:'')+'>'+l.content+'</'+l.tag+'>'},!_self.document)return _self.addEventListener?(c.disableWorkerMessageHandler||_self.addEventListener('message',function(f){var g=JSON.parse(f.data),h=g.language,l=g.code,m=g.immediateClose;_self.postMessage(c.highlight(l,c.languages[h],h)),m&&_self.close()},!1),_self.Prism):_self.Prism;var e=document.currentScript||[].slice.call(document.getElementsByTagName('script')).pop();return e&&(c.filename=e.src,!c.manual&&!e.hasAttribute('data-manual')&&('loading'===document.readyState?document.addEventListener('DOMContentLoaded',c.highlightAll):window.requestAnimationFrame?window.requestAnimationFrame(c.highlightAll):window.setTimeout(c.highlightAll,16))),_self.Prism}();'undefined'!=typeof module&&module.exports&&(module.exports=Prism),'undefined'!=typeof global&&(global.Prism=Prism);Prism.languages.clike={comment:[{pattern:/(^|[^\\])\/\*[\s\S]*?(?:\*\/|$)/,lookbehind:!0},{pattern:/(^|[^\\:])\/\/.*/,lookbehind:!0,greedy:!0}],string:{pattern:/(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:!0},'class-name':{pattern:/((?:\b(?:class|interface|extends|implements|trait|instanceof|new)\s+)|(?:catch\s+\())[\w.\\]+/i,lookbehind:!0,inside:{punctuation:/[.\\]/}},keyword:/\b(?:if|else|while|do|for|return|in|instanceof|function|new|try|throw|catch|finally|null|break|continue)\b/,boolean:/\b(?:true|false)\b/,'function':/[a-z0-9_]+(?=\()/i,number:/\b0x[\da-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?/i,operator:/--?|\+\+?|!=?=?|<=?|>=?|==?=?|&&?|\|\|?|\?|\*|\/|~|\^|%/,punctuation:/[{}[\];(),.:]/},Prism.languages.javascript=Prism.languages.extend('clike',{keyword:/\b(?:as|async|await|break|case|catch|class|const|continue|debugger|default|delete|do|else|enum|export|extends|finally|for|from|function|get|if|implements|import|in|instanceof|interface|let|new|null|of|package|private|protected|public|return|set|static|super|switch|this|throw|try|typeof|var|void|while|with|yield)\b/,number:/\b(?:0[xX][\dA-Fa-f]+|0[bB][01]+|0[oO][0-7]+|NaN|Infinity)\b|(?:\b\d+\.?\d*|\B\.\d+)(?:[Ee][+-]?\d+)?/,'function':/[_$a-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*\()/i,operator:/-[-=]?|\+[+=]?|!=?=?|<<?=?|>>?>?=?|=(?:==?|>)?|&[&=]?|\|[|=]?|\*\*?=?|\/=?|~|\^=?|%=?|\?|\.{3}/}),Prism.languages.insertBefore('javascript','keyword',{regex:{pattern:/((?:^|[^$\w\xA0-\uFFFF."'\])\s])\s*)\/(\[[^\]\r\n]+]|\\.|[^/\\\[\r\n])+\/[gimyu]{0,5}(?=\s*($|[\r\n,.;})\]]))/,lookbehind:!0,greedy:!0},'function-variable':{pattern:/[_$a-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*=\s*(?:function\b|(?:\([^()]*\)|[_$a-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*)\s*=>))/i,alias:'function'},constant:/\b[A-Z][A-Z\d_]*\b/}),Prism.languages.insertBefore('javascript','string',{'template-string':{pattern:/`+"`"+`(?:\\[\s\S]|[^\\`+"`"+`])*`+"`"+`/,greedy:!0,inside:{interpolation:{pattern:/\$\{[^}]+\}/,inside:{'interpolation-punctuation':{pattern:/^\$\{|\}$/,alias:'punctuation'},rest:Prism.languages.javascript}},string:/[\s\S]+/}}}),Prism.languages.markup&&Prism.languages.insertBefore('markup','tag',{script:{pattern:/(<script[\s\S]*?>)[\s\S]*?(?=<\/script>)/i,lookbehind:!0,inside:Prism.languages.javascript,alias:'language-javascript',greedy:!0}}),Prism.languages.js=Prism.languages.javascript,function(a){var b={variable:[{pattern:/\$?\(\([\s\S]+?\)\)/,inside:{variable:[{pattern:/(^\$\(\([\s\S]+)\)\)/,lookbehind:!0},/^\$\(\(/],number:/\b0x[\dA-Fa-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:[Ee]-?\d+)?/,operator:/--?|-=|\+\+?|\+=|!=?|~|\*\*?|\*=|\/=?|%=?|<<=?|>>=?|<=?|>=?|==?|&&?|&=|\^=?|\|\|?|\|=|\?|:/,punctuation:/\(\(?|\)\)?|,|;/}},{pattern:/\$\([^)]+\)|`+"`"+`[^`+"`"+`]+`+"`"+`/,greedy:!0,inside:{variable:/^\$\(|^`+"`"+`|\)$|`+"`"+`$/}},/\$(?:[\w#?*!@]+|\{[^}]+\})/i]};a.languages.bash={shebang:{pattern:/^#!\s*\/bin\/bash|^#!\s*\/bin\/sh/,alias:'important'},comment:{pattern:/(^|[^"{\\])#.*/,lookbehind:!0},string:[{pattern:/((?:^|[^<])<<\s*)["']?(\w+?)["']?\s*\r?\n(?:[\s\S])*?\r?\n\2/,lookbehind:!0,greedy:!0,inside:b},{pattern:/(["'])(?:\\[\s\S]|\$\([^)]+\)|`+"`"+`[^`+"`"+`]+`+"`"+`|(?!\1)[^\\])*\1/,greedy:!0,inside:b}],variable:b.variable,'function':{pattern:/(^|[\s;|&])(?:alias|apropos|apt-get|aptitude|aspell|awk|basename|bash|bc|bg|builtin|bzip2|cal|cat|cd|cfdisk|chgrp|chmod|chown|chroot|chkconfig|cksum|clear|cmp|comm|command|cp|cron|crontab|csplit|curl|cut|date|dc|dd|ddrescue|df|diff|diff3|dig|dir|dircolors|dirname|dirs|dmesg|du|egrep|eject|enable|env|ethtool|eval|exec|expand|expect|export|expr|fdformat|fdisk|fg|fgrep|file|find|fmt|fold|format|free|fsck|ftp|fuser|gawk|getopts|git|grep|groupadd|groupdel|groupmod|groups|gzip|hash|head|help|hg|history|hostname|htop|iconv|id|ifconfig|ifdown|ifup|import|install|jobs|join|kill|killall|less|link|ln|locate|logname|logout|look|lpc|lpr|lprint|lprintd|lprintq|lprm|ls|lsof|make|man|mkdir|mkfifo|mkisofs|mknod|more|most|mount|mtools|mtr|mv|mmv|nano|netstat|nice|nl|nohup|notify-send|npm|nslookup|open|op|passwd|paste|pathchk|ping|pkill|popd|pr|printcap|printenv|printf|ps|pushd|pv|pwd|quota|quotacheck|quotactl|ram|rar|rcp|read|readarray|readonly|reboot|rename|renice|remsync|rev|rm|rmdir|rsync|screen|scp|sdiff|sed|seq|service|sftp|shift|shopt|shutdown|sleep|slocate|sort|source|split|ssh|stat|strace|su|sudo|sum|suspend|sync|tail|tar|tee|test|time|timeout|times|touch|top|traceroute|trap|tr|tsort|tty|type|ulimit|umask|umount|unalias|uname|unexpand|uniq|units|unrar|unshar|uptime|useradd|userdel|usermod|users|uuencode|uudecode|v|vdir|vi|vmstat|wait|watch|wc|wget|whereis|which|who|whoami|write|xargs|xdg-open|yes|zip)(?=$|[\s;|&])/,lookbehind:!0},keyword:{pattern:/(^|[\s;|&])(?:let|:|\.|if|then|else|elif|fi|for|break|continue|while|in|case|function|select|do|done|until|echo|exit|return|set|declare)(?=$|[\s;|&])/,lookbehind:!0},boolean:{pattern:/(^|[\s;|&])(?:true|false)(?=$|[\s;|&])/,lookbehind:!0},operator:/&&?|\|\|?|==?|!=?|<<<?|>>|<=?|>=?|=~/,punctuation:/\$?\(\(?|\)\)?|\.\.|[{}[\];]/};var c=b.variable[1].inside;c.string=a.languages.bash.string,c['function']=a.languages.bash['function'],c.keyword=a.languages.bash.keyword,c.boolean=a.languages.bash.boolean,c.operator=a.languages.bash.operator,c.punctuation=a.languages.bash.punctuation,a.languages.shell=a.languages.bash}(Prism),Prism.languages.docker={keyword:{pattern:/(^\s*)(?:ADD|ARG|CMD|COPY|ENTRYPOINT|ENV|EXPOSE|FROM|HEALTHCHECK|LABEL|MAINTAINER|ONBUILD|RUN|SHELL|STOPSIGNAL|USER|VOLUME|WORKDIR)(?=\s)/mi,lookbehind:!0},string:/("|')(?:(?!\1)[^\\\r\n]|\\(?:\r\n|[\s\S]))*\1/,comment:/#.*/,punctuation:/---|\.\.\.|[:[\]{}\-,|>?]/},Prism.languages.dockerfile=Prism.languages.docker,Prism.languages.go=Prism.languages.extend('clike',{keyword:/\b(?:break|case|chan|const|continue|default|defer|else|fallthrough|for|func|go(?:to)?|if|import|interface|map|package|range|return|select|struct|switch|type|var)\b/,builtin:/\b(?:bool|byte|complex(?:64|128)|error|float(?:32|64)|rune|string|u?int(?:8|16|32|64)?|uintptr|append|cap|close|complex|copy|delete|imag|len|make|new|panic|print(?:ln)?|real|recover)\b/,boolean:/\b(?:_|iota|nil|true|false)\b/,operator:/[*\/%^!=]=?|\+[=+]?|-[=-]?|\|[=|]?|&(?:=|&|\^=?)?|>(?:>=?|=)?|<(?:<=?|=|-)?|:=|\.\.\./,number:/(?:\b0x[a-f\d]+|(?:\b\d+\.?\d*|\B\.\d+)(?:e[-+]?\d+)?)i?/i,string:{pattern:/(["'`+"`"+`])(\\[\s\S]|(?!\1)[^\\])*\1/,greedy:!0}}),delete Prism.languages.go['class-name'],Prism.languages.java=Prism.languages.extend('clike',{keyword:/\b(?:abstract|continue|for|new|switch|assert|default|goto|package|synchronized|boolean|do|if|private|this|break|double|implements|protected|throw|byte|else|import|public|throws|case|enum|instanceof|return|transient|catch|extends|int|short|try|char|final|interface|static|void|class|finally|long|strictfp|volatile|const|float|native|super|while)\b/,number:/\b0b[01]+\b|\b0x[\da-f]*\.?[\da-fp-]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?[df]?/i,operator:{pattern:/(^|[^.])(?:\+[+=]?|-[-=]?|!=?|<<?=?|>>?>?=?|==?|&[&=]?|\|[|=]?|\*=?|\/=?|%=?|\^=?|[?:~])/m,lookbehind:!0}}),Prism.languages.insertBefore('java','function',{annotation:{alias:'punctuation',pattern:/(^|[^.])@\w+/,lookbehind:!0}}),Prism.languages.insertBefore('java','class-name',{generics:{pattern:/<\s*\w+(?:\.\w+)?(?:\s*,\s*\w+(?:\.\w+)?)*>/i,alias:'function',inside:{keyword:Prism.languages.java.keyword,punctuation:/[<>(),.:]/}}}),Prism.languages.protobuf=Prism.languages.extend('clike',{keyword:/\b(?:package|import|message|enum)\b/,builtin:/\b(?:required|repeated|optional|reserved)\b/,primitive:{pattern:/\b(?:double|float|int32|int64|uint32|uint64|sint32|sint64|fixed32|fixed64|sfixed32|sfixed64|bool|string|bytes)\b/,alias:'symbol'}}),Prism.languages.python={comment:{pattern:/(^|[^\\])#.*/,lookbehind:!0},'triple-quoted-string':{pattern:/("""|''')[\s\S]+?\1/,greedy:!0,alias:'string'},string:{pattern:/("|')(?:\\.|(?!\1)[^\\\r\n])*\1/,greedy:!0},'function':{pattern:/((?:^|\s)def[ \t]+)[a-zA-Z_]\w*(?=\s*\()/g,lookbehind:!0},'class-name':{pattern:/(\bclass\s+)\w+/i,lookbehind:!0},keyword:/\b(?:as|assert|async|await|break|class|continue|def|del|elif|else|except|exec|finally|for|from|global|if|import|in|is|lambda|nonlocal|pass|print|raise|return|try|while|with|yield)\b/,builtin:/\b(?:__import__|abs|all|any|apply|ascii|basestring|bin|bool|buffer|bytearray|bytes|callable|chr|classmethod|cmp|coerce|compile|complex|delattr|dict|dir|divmod|enumerate|eval|execfile|file|filter|float|format|frozenset|getattr|globals|hasattr|hash|help|hex|id|input|int|intern|isinstance|issubclass|iter|len|list|locals|long|map|max|memoryview|min|next|object|oct|open|ord|pow|property|range|raw_input|reduce|reload|repr|reversed|round|set|setattr|slice|sorted|staticmethod|str|sum|super|tuple|type|unichr|unicode|vars|xrange|zip)\b/,boolean:/\b(?:True|False|None)\b/,number:/(?:\b(?=\d)|\B(?=\.))(?:0[bo])?(?:(?:\d|0x[\da-f])[\da-f]*\.?\d*|\.\d+)(?:e[+-]?\d+)?j?\b/i,operator:/[-+%=]=?|!=|\*\*?=?|\/\/?=?|<[<=>]?|>[=>]?|[&|^~]|\b(?:or|and|not)\b/,punctuation:/[{}[\];(),.:]/},Prism.languages.yaml={scalar:{pattern:/([\-:]\s*(?:![^\s]+)?[ \t]*[|>])[ \t]*(?:((?:\r?\n|\r)[ \t]+)[^\r\n]+(?:\2[^\r\n]+)*)/,lookbehind:!0,alias:'string'},comment:/#.*/,key:{pattern:/(\s*(?:^|[:\-,[{\r\n?])[ \t]*(?:![^\s]+)?[ \t]*)[^\r\n{[\]},#\s]+?(?=\s*:\s)/,lookbehind:!0,alias:'atrule'},directive:{pattern:/(^[ \t]*)%.+/m,lookbehind:!0,alias:'important'},datetime:{pattern:/([:\-,[{]\s*(?:![^\s]+)?[ \t]*)(?:\d{4}-\d\d?-\d\d?(?:[tT]|[ \t]+)\d\d?:\d{2}:\d{2}(?:\.\d*)?[ \t]*(?:Z|[-+]\d\d?(?::\d{2})?)?|\d{4}-\d{2}-\d{2}|\d\d?:\d{2}(?::\d{2}(?:\.\d*)?)?)(?=[ \t]*(?:$|,|]|}))/m,lookbehind:!0,alias:'number'},boolean:{pattern:/([:\-,[{]\s*(?:![^\s]+)?[ \t]*)(?:true|false)[ \t]*(?=$|,|]|})/im,lookbehind:!0,alias:'important'},'null':{pattern:/([:\-,[{]\s*(?:![^\s]+)?[ \t]*)(?:null|~)[ \t]*(?=$|,|]|})/im,lookbehind:!0,alias:'important'},string:{pattern:/([:\-,[{]\s*(?:![^\s]+)?[ \t]*)("|')(?:(?!\2)[^\\\r\n]|\\.)*\2(?=[ \t]*(?:$|,|]|}))/m,lookbehind:!0,greedy:!0},number:{pattern:/([:\-,[{]\s*(?:![^\s]+)?[ \t]*)[+-]?(?:0x[\da-f]+|0o[0-7]+|(?:\d+\.?\d*|\.?\d+)(?:e[+-]?\d+)?|\.inf|\.nan)[ \t]*(?=$|,|]|})/im,lookbehind:!0},tag:/![^\s]+/,important:/[&*][\w]+/,punctuation:/---|[:[\]{}\-,|>?]|\.\.\./};
`)

func assetsStaticJsPrismMinJsBytes() ([]byte, error) {
	return _assetsStaticJsPrismMinJs, nil
}

func assetsStaticJsPrismMinJs() (*asset, error) {
	bytes, err := assetsStaticJsPrismMinJsBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/js/prism.min.js", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsStaticManifestJson = []byte(`{
    "name": "Istio Controlz",
    "short_name": "Controlz",
    "icons": [
        {
            "src": "favicons/pwa-192x192.png",
            "sizes": "192x192",
            "type": "image/png"
        },

        {
            "src": "favicons/pwa-512x512.png",
            "sizes": "512x512",
            "type": "image/png"
        }
    ],
    "theme_color": "#466BB0",
    "background_color": "#ffffff",
    "display": "standalone"
}`)

func assetsStaticManifestJsonBytes() ([]byte, error) {
	return _assetsStaticManifestJson, nil
}

func assetsStaticManifestJson() (*asset, error) {
	bytes, err := assetsStaticManifestJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/static/manifest.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsTemplates404Html = []byte(`{{ define "title" }}Page Not Found{{ end }}
{{ define "content" }}
<div class="notfound">
    <div class="icon">
        <img alt="Warning" title="Uh-ho" src="/img/exclamation-mark.svg" />
    </div>

    <div class="error">
        We're sorry, the page you requested cannot be found
    </div>

    <div class="explanation">
        The URL may be misspelled
    </div>
</div>
{{ end }}
`)

func assetsTemplates404HtmlBytes() ([]byte, error) {
	return _assetsTemplates404Html, nil
}

func assetsTemplates404Html() (*asset, error) {
	bytes, err := assetsTemplates404HtmlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/templates/404.html", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsTemplatesHomeHtml = []byte(`{{ define "title" }}Istio ControlZ{{ end }}
{{ define "content" }}

<p>
    Make a selection in the left sidebar to inspect & control aspects of this process.
</p>

<table>
    <tbody>
    <tr>
        <td>Process Name</td>
        <td>{{.ProcessName}}</td>
    </tr>

    <tr>
        <td>Heap Size</td>
        <td id="HeapSize">{{.HeapSize}} bytes</td>
    </tr>

    <tr>
        <td>Num Garbage Collections</td>
        <td id="NumGC">{{.NumGC}}</td>
    </tr>

    <tr>
        <td>Current Time</td>
        <td id="CurrentTime"></td>
    </tr>

    <script>
        // we do this so there's a useful date in the table, which avoids things shifting around during initial paint
        var d = new Date().toLocaleString();
        document.getElementById("CurrentTime").innerText = d;
    </script>

    <tr>
        <td>Hostname</td>
        <td>{{.Hostname}}</td>
    </tr>

    <tr>
        <td>IP Address</td>
        <td>{{.IP}}</td>
    </tr>

    </tbody>
</table>

<br/>
<button id="terminate" class="btn btn-istio" onclick="terminateProcess()">Terminate Process</button>
<p id="terminated" style="display:none">Process Terminated</p>

{{ template "last-refresh" .}}

<script>
    "use strict"

    function refreshHomeInfo() {
        var url = window.location.protocol + "//" + window.location.host + "/homej/";

        var ajax = new XMLHttpRequest();
        ajax.onload = onload;
        ajax.onerror = onerror;
        ajax.open("GET", url, true);
        ajax.send();

        function onload() {
            if (this.status == 200) { // request succeeded
                var hi = JSON.parse(this.responseText);
                document.getElementById("HeapSize").innerText = hi.HeapSize.toLocaleString() + " bytes";
                document.getElementById("NumGC").innerText = hi.NumGC.toLocaleString();

                var d = new Date(hi.CurrentTime / 1000000).toLocaleString();
                document.getElementById("CurrentTime").innerText = d;

                updateRefreshTime();
            }
        }

        function onerror(e) {
            console.error(e);
        }
    }

    function terminateProcess() {
        document.getElementById("terminate").style.display = "none";
        document.getElementById("terminated").style.display = "block";

        var url = window.location.protocol + "//" + window.location.host + "/homej/exit";

        var ajax = new XMLHttpRequest();
        ajax.onload = onload;
        ajax.onerror = onerror;
        ajax.open("PUT", url, true);
        ajax.send();

        function onload() {
            if (this.status == 200) { // request succeeded
            }
        }

        function onerror(e) {
            console.error(e);
        }
    }

    refreshHomeInfo();
    window.setInterval(refreshHomeInfo, 1000);
</script>

{{ end }}
`)

func assetsTemplatesHomeHtmlBytes() ([]byte, error) {
	return _assetsTemplatesHomeHtml, nil
}

func assetsTemplatesHomeHtml() (*asset, error) {
	bytes, err := assetsTemplatesHomeHtmlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/templates/home.html", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsTemplatesLayoutsBaseHtml = []byte(`<!DOCTYPE html>
<html lang="en" itemscope itemtype="https://schema.org/WebPage">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="theme-color" content="#466BB0"/>
        <meta name="title" content="ControlZ / {{template "title" .}}">

        <title>ControlZ / {{template "title" .}}</title>

        <link rel="shortcut icon" href="/favicons/favicon.ico" >
        <link rel="apple-touch-icon" href="/favicons/apple-touch-icon-180x180.png" sizes="180x180">
        <link rel="icon" type="image/png" href="/favicons/favicon-16x16.png" sizes="16x16">
        <link rel="icon" type="image/png" href="/favicons/favicon-32x32.png" sizes="32x32">
        <link rel="icon" type="image/png" href="/favicons/android-36x36.png" sizes="36x36">
        <link rel="icon" type="image/png" href="/favicons/android-48x48.png" sizes="48x48">
        <link rel="icon" type="image/png" href="/favicons/android-72x72.png" sizes="72x72">
        <link rel="icon" type="image/png" href="/favicons/android-96x196.png" sizes="96x196">
        <link rel="icon" type="image/png" href="/favicons/android-144x144.png" sizes="144x144">
        <link rel="icon" type="image/png" href="/favicons/android-192x192.png" sizes="192x192">

        <!-- app manifests -->
        <link rel="manifest" href="/manifest.json">
        <meta name="apple-mobile-web-app-title" content="Istio ControlZ">
        <meta name="application-name" content="Istio">

        <!-- style sheets -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,100,100italic,300,300italic,400italic,500,500italic,700,700italic,900,900italic">
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.0.6/css/all.css">
        <link rel="stylesheet" href="/css/all.css">
        <link rel="stylesheet" href="/css/dark_syntax.css">
    </head>

    <body>
        {{template "header" .}}
        {{template "main" .}}

        <!-- libraries we pull in -->
        <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/1.7.1/clipboard.min.js"></script>
        <script src="/js/prism.min.js"></script>

        <!-- our own scripts -->
        <script src="/js/misc.js"></script>
    </body>
</html>
`)

func assetsTemplatesLayoutsBaseHtmlBytes() ([]byte, error) {
	return _assetsTemplatesLayoutsBaseHtml, nil
}

func assetsTemplatesLayoutsBaseHtml() (*asset, error) {
	bytes, err := assetsTemplatesLayoutsBaseHtmlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/templates/layouts/base.html", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsTemplatesLayoutsMainHtml = []byte(`{{ define "main" }}
<main>
    <div class="container-fluid">
        <div class="row row-offcanvas">
            <div class="col-0 col-md-3 col-xl-2 sidebar-offcanvas">
                {{ template "sidebar" . }}
            </div>

            <div class="col-12 col-md-9 col-xl-10">
                <main aria-labelledby="title">
                    <h1 id="title">{{template "title" .}}</h1>
                    {{ template "content" . }}
                </main>
            </div>
        </div>
    </div>
</main>
{{ end }}
`)

func assetsTemplatesLayoutsMainHtmlBytes() ([]byte, error) {
	return _assetsTemplatesLayoutsMainHtml, nil
}

func assetsTemplatesLayoutsMainHtml() (*asset, error) {
	bytes, err := assetsTemplatesLayoutsMainHtmlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/templates/layouts/main.html", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsTemplatesModulesHeaderHtml = []byte(`{{ define "header" }}
<header>
    <nav class="navbar navbar-expand-xs navbar-dark fixed-top bg-dark justify-content-between">
        <a class="navbar-brand" href="/">
            <span class="logo">
                <svg viewBox="0 0 300 300">
                    <circle cx="150" cy="150" r="150" stroke-width="2" />
                    <polygon points="65,240 225,240 125,270"/>
                    <polygon points="65,230 125,220 125,110"/>
                    <polygon points="135,220 225,230 135,30"/>
                </svg>
            </span>
            <span class="brand-name">Istio ControlZ [{{ template "instance" }}]</span>
        </a>
    </nav>
</header>
{{ end }}
`)

func assetsTemplatesModulesHeaderHtmlBytes() ([]byte, error) {
	return _assetsTemplatesModulesHeaderHtml, nil
}

func assetsTemplatesModulesHeaderHtml() (*asset, error) {
	bytes, err := assetsTemplatesModulesHeaderHtmlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/templates/modules/header.html", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsTemplatesModulesLastRefreshHtml = []byte(`{{ define "last-refresh" }}
<p class="last-refresh">Last refreshed: <span id="last-refresh"></span></p>
<script>
    function updateRefreshTime() {
        var d = new Date();
        document.getElementById("last-refresh").innerText = d.toLocaleString();
    }
    updateRefreshTime()
</script>
{{ end }}
`)

func assetsTemplatesModulesLastRefreshHtmlBytes() ([]byte, error) {
	return _assetsTemplatesModulesLastRefreshHtml, nil
}

func assetsTemplatesModulesLastRefreshHtml() (*asset, error) {
	bytes, err := assetsTemplatesModulesLastRefreshHtmlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/templates/modules/last-refresh.html", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _assetsTemplatesModulesSidebarHtml = []byte(`{{ define "sidebar" }}
<nav class="sidebar">
    <div class="spacer"></div>
    <div class="directory" role="tablist">

    <div class="card">
        <div class="card-header" role="tab" id="header">
            <div>ControlZ</div>
        </div>

        <div class="card-body">
            <ul class="tree">
                {{ range getTopics }}
                    <li>
                        <a href="{{.URL}}">{{.Name}}</a>
                    </li>
                {{ end }}
            </ul>
        </div>
    </div>
</nav>
{{ end }}
`)

func assetsTemplatesModulesSidebarHtmlBytes() ([]byte, error) {
	return _assetsTemplatesModulesSidebarHtml, nil
}

func assetsTemplatesModulesSidebarHtml() (*asset, error) {
	bytes, err := assetsTemplatesModulesSidebarHtmlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/templates/modules/sidebar.html", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"assets/static/css/all.css": assetsStaticCssAllCss,
	"assets/static/css/dark_syntax.css": assetsStaticCssDark_syntaxCss,
	"assets/static/favicons/android-144x144.png": assetsStaticFaviconsAndroid144x144Png,
	"assets/static/favicons/android-192x192.png": assetsStaticFaviconsAndroid192x192Png,
	"assets/static/favicons/android-36x36.png": assetsStaticFaviconsAndroid36x36Png,
	"assets/static/favicons/android-48x48.png": assetsStaticFaviconsAndroid48x48Png,
	"assets/static/favicons/android-72x72.png": assetsStaticFaviconsAndroid72x72Png,
	"assets/static/favicons/android-96x196.png": assetsStaticFaviconsAndroid96x196Png,
	"assets/static/favicons/apple-touch-icon-180x180.png": assetsStaticFaviconsAppleTouchIcon180x180Png,
	"assets/static/favicons/favicon-16x16.png": assetsStaticFaviconsFavicon16x16Png,
	"assets/static/favicons/favicon-32x32.png": assetsStaticFaviconsFavicon32x32Png,
	"assets/static/favicons/favicon.ico": assetsStaticFaviconsFaviconIco,
	"assets/static/favicons/pwa-192x192.png": assetsStaticFaviconsPwa192x192Png,
	"assets/static/favicons/pwa-512x512.png": assetsStaticFaviconsPwa512x512Png,
	"assets/static/favicons/tile150x150.png": assetsStaticFaviconsTile150x150Png,
	"assets/static/favicons/tile310x150.png": assetsStaticFaviconsTile310x150Png,
	"assets/static/favicons/tile310x310.png": assetsStaticFaviconsTile310x310Png,
	"assets/static/favicons/tile70x70.png": assetsStaticFaviconsTile70x70Png,
	"assets/static/img/exclamation-mark.svg": assetsStaticImgExclamationMarkSvg,
	"assets/static/js/misc.js": assetsStaticJsMiscJs,
	"assets/static/js/prism.js": assetsStaticJsPrismJs,
	"assets/static/js/prism.min.js": assetsStaticJsPrismMinJs,
	"assets/static/manifest.json": assetsStaticManifestJson,
	"assets/templates/404.html": assetsTemplates404Html,
	"assets/templates/home.html": assetsTemplatesHomeHtml,
	"assets/templates/layouts/base.html": assetsTemplatesLayoutsBaseHtml,
	"assets/templates/layouts/main.html": assetsTemplatesLayoutsMainHtml,
	"assets/templates/modules/header.html": assetsTemplatesModulesHeaderHtml,
	"assets/templates/modules/last-refresh.html": assetsTemplatesModulesLastRefreshHtml,
	"assets/templates/modules/sidebar.html": assetsTemplatesModulesSidebarHtml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}
var _bintree = &bintree{nil, map[string]*bintree{
	"assets": &bintree{nil, map[string]*bintree{
		"static": &bintree{nil, map[string]*bintree{
			"css": &bintree{nil, map[string]*bintree{
				"all.css": &bintree{assetsStaticCssAllCss, map[string]*bintree{}},
				"dark_syntax.css": &bintree{assetsStaticCssDark_syntaxCss, map[string]*bintree{}},
			}},
			"favicons": &bintree{nil, map[string]*bintree{
				"android-144x144.png": &bintree{assetsStaticFaviconsAndroid144x144Png, map[string]*bintree{}},
				"android-192x192.png": &bintree{assetsStaticFaviconsAndroid192x192Png, map[string]*bintree{}},
				"android-36x36.png": &bintree{assetsStaticFaviconsAndroid36x36Png, map[string]*bintree{}},
				"android-48x48.png": &bintree{assetsStaticFaviconsAndroid48x48Png, map[string]*bintree{}},
				"android-72x72.png": &bintree{assetsStaticFaviconsAndroid72x72Png, map[string]*bintree{}},
				"android-96x196.png": &bintree{assetsStaticFaviconsAndroid96x196Png, map[string]*bintree{}},
				"apple-touch-icon-180x180.png": &bintree{assetsStaticFaviconsAppleTouchIcon180x180Png, map[string]*bintree{}},
				"favicon-16x16.png": &bintree{assetsStaticFaviconsFavicon16x16Png, map[string]*bintree{}},
				"favicon-32x32.png": &bintree{assetsStaticFaviconsFavicon32x32Png, map[string]*bintree{}},
				"favicon.ico": &bintree{assetsStaticFaviconsFaviconIco, map[string]*bintree{}},
				"pwa-192x192.png": &bintree{assetsStaticFaviconsPwa192x192Png, map[string]*bintree{}},
				"pwa-512x512.png": &bintree{assetsStaticFaviconsPwa512x512Png, map[string]*bintree{}},
				"tile150x150.png": &bintree{assetsStaticFaviconsTile150x150Png, map[string]*bintree{}},
				"tile310x150.png": &bintree{assetsStaticFaviconsTile310x150Png, map[string]*bintree{}},
				"tile310x310.png": &bintree{assetsStaticFaviconsTile310x310Png, map[string]*bintree{}},
				"tile70x70.png": &bintree{assetsStaticFaviconsTile70x70Png, map[string]*bintree{}},
			}},
			"img": &bintree{nil, map[string]*bintree{
				"exclamation-mark.svg": &bintree{assetsStaticImgExclamationMarkSvg, map[string]*bintree{}},
			}},
			"js": &bintree{nil, map[string]*bintree{
				"misc.js": &bintree{assetsStaticJsMiscJs, map[string]*bintree{}},
				"prism.js": &bintree{assetsStaticJsPrismJs, map[string]*bintree{}},
				"prism.min.js": &bintree{assetsStaticJsPrismMinJs, map[string]*bintree{}},
			}},
			"manifest.json": &bintree{assetsStaticManifestJson, map[string]*bintree{}},
		}},
		"templates": &bintree{nil, map[string]*bintree{
			"404.html": &bintree{assetsTemplates404Html, map[string]*bintree{}},
			"home.html": &bintree{assetsTemplatesHomeHtml, map[string]*bintree{}},
			"layouts": &bintree{nil, map[string]*bintree{
				"base.html": &bintree{assetsTemplatesLayoutsBaseHtml, map[string]*bintree{}},
				"main.html": &bintree{assetsTemplatesLayoutsMainHtml, map[string]*bintree{}},
			}},
			"modules": &bintree{nil, map[string]*bintree{
				"header.html": &bintree{assetsTemplatesModulesHeaderHtml, map[string]*bintree{}},
				"last-refresh.html": &bintree{assetsTemplatesModulesLastRefreshHtml, map[string]*bintree{}},
				"sidebar.html": &bintree{assetsTemplatesModulesSidebarHtml, map[string]*bintree{}},
			}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}

