%{!?rel:%define rel 1%{?dist}}
%{!?ver:%define ver 2.2.0}
%{!?pkgname:%define pkgname iplike-pgsql10}
%{!?postgresql_dev:%define postgresql_dev postgresql-devel}

%define srcdir iplike-%{ver}
%define install_iplike install_iplike-10.sh

Name: %{pkgname}
Version: %{ver}
Release: %{rel}
License: GPL
Group: Applications/Databases
Summary: PostgreSQL complex IP Address text field query
Source: %{srcdir}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root

BuildRequires: %{postgresql_dev}, gcc, make
Requires: sudo

Provides: iplike = %{version}-%{release}

%description
PostgreSQL function for doing complex IP address queries
on a text field.

%prep
%setup -n %{srcdir}

%build
export PG_PLUGINDIR="%{_libdir}/iplike/10"
%configure
make

%install
make install DESTDIR="$RPM_BUILD_ROOT"
mv "%{buildroot}%{_sbindir}/install_iplike.sh" "%{buildroot}%{_sbindir}/%{install_iplike}"

%post

if [ -z "$SKIP_IPLIKE_INSTALL" ]; then

	FAILED=0

	echo -e "- installing iplike into the opennms db (if it exists)... \c"
	if %{_sbindir}/%{install_iplike} -s postgres -d opennms >>/tmp/install_iplike.log 2>&1; then
		echo "OK"
	else
		echo "failed"
#		FAILED=1
	fi

	if [ $FAILED -eq 1 ]; then
		cat <<END

!!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!

Failed to install iplike into the opennms database.
See /tmp/install_iplike.log for details.

To install iplike into your database, use the %{_sbindir}/%{install_iplike}
script.  See \`%{install_iplike} -h\` for more details.

END

		exit 0
	fi

fi

if [ -x /usr/sbin/update-alternatives ]; then
	/usr/sbin/update-alternatives --install "%{_sbindir}/install_iplike.sh" "install_iplike.sh" "%{_sbindir}/install_iplike-10.sh" "10"
fi

exit 0

%preun

if [ -x /usr/sbin/update-alternatives ]; then
	/usr/sbin/update-alternatives --remove "install_iplike.sh" "%{_sbindir}/install_iplike-10.sh"
fi

%clean
if [ "$RPM_BUILD_ROOT" != "/" ]; then
	rm -rf "$RPM_BUILD_ROOT"
fi

%files
%attr(755,root,root) %{_libdir}/iplike/10
%attr(755,root,root) %{_sbindir}/%{install_iplike}

%changelog
* Wed Oct 23 2019 Benjamin Reed <ranger@opennms.org>
- convert to support multi-postgresql builds

* Mon Jun 18 2007 Benjamin Reed <ranger@opennms.org>
- add RPM build to the autotools stuff
- add postinstall to insert iplike into template1
- many other RPM-related fixes

* Wed Jun 13 2007 Benjamin Reed <ranger@opennms.org>
- initial package
