// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: circuit.proto

package circuit_pb

import (
	fmt "fmt"
	github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type Status int32

const (
	Status_OK                      Status = 100
	Status_RESERVATION_REFUSED     Status = 200
	Status_RESOURCE_LIMIT_EXCEEDED Status = 201
	Status_PERMISSION_DENIED       Status = 202
	Status_CONNECTION_FAILED       Status = 203
	Status_NO_RESERVATION          Status = 204
	Status_MALFORMED_MESSAGE       Status = 400
	Status_UNEXPECTED_MESSAGE      Status = 401
)

var Status_name = map[int32]string{
	100: "OK",
	200: "RESERVATION_REFUSED",
	201: "RESOURCE_LIMIT_EXCEEDED",
	202: "PERMISSION_DENIED",
	203: "CONNECTION_FAILED",
	204: "NO_RESERVATION",
	400: "MALFORMED_MESSAGE",
	401: "UNEXPECTED_MESSAGE",
}

var Status_value = map[string]int32{
	"OK":                      100,
	"RESERVATION_REFUSED":     200,
	"RESOURCE_LIMIT_EXCEEDED": 201,
	"PERMISSION_DENIED":       202,
	"CONNECTION_FAILED":       203,
	"NO_RESERVATION":          204,
	"MALFORMED_MESSAGE":       400,
	"UNEXPECTED_MESSAGE":      401,
}

func (x Status) Enum() *Status {
	p := new(Status)
	*p = x
	return p
}

func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}

func (x *Status) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Status_value, data, "Status")
	if err != nil {
		return err
	}
	*x = Status(value)
	return nil
}

func (Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ed01bbc211f15e47, []int{0}
}

type HopMessage_Type int32

const (
	HopMessage_RESERVE HopMessage_Type = 0
	HopMessage_CONNECT HopMessage_Type = 1
	HopMessage_STATUS  HopMessage_Type = 2
)

var HopMessage_Type_name = map[int32]string{
	0: "RESERVE",
	1: "CONNECT",
	2: "STATUS",
}

var HopMessage_Type_value = map[string]int32{
	"RESERVE": 0,
	"CONNECT": 1,
	"STATUS":  2,
}

func (x HopMessage_Type) Enum() *HopMessage_Type {
	p := new(HopMessage_Type)
	*p = x
	return p
}

func (x HopMessage_Type) String() string {
	return proto.EnumName(HopMessage_Type_name, int32(x))
}

func (x *HopMessage_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(HopMessage_Type_value, data, "HopMessage_Type")
	if err != nil {
		return err
	}
	*x = HopMessage_Type(value)
	return nil
}

func (HopMessage_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ed01bbc211f15e47, []int{0, 0}
}

type StopMessage_Type int32

const (
	StopMessage_CONNECT StopMessage_Type = 0
	StopMessage_STATUS  StopMessage_Type = 1
)

var StopMessage_Type_name = map[int32]string{
	0: "CONNECT",
	1: "STATUS",
}

var StopMessage_Type_value = map[string]int32{
	"CONNECT": 0,
	"STATUS":  1,
}

func (x StopMessage_Type) Enum() *StopMessage_Type {
	p := new(StopMessage_Type)
	*p = x
	return p
}

func (x StopMessage_Type) String() string {
	return proto.EnumName(StopMessage_Type_name, int32(x))
}

func (x *StopMessage_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(StopMessage_Type_value, data, "StopMessage_Type")
	if err != nil {
		return err
	}
	*x = StopMessage_Type(value)
	return nil
}

func (StopMessage_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ed01bbc211f15e47, []int{1, 0}
}

type HopMessage struct {
	Type                 *HopMessage_Type `protobuf:"varint,1,req,name=type,enum=circuit.pb.HopMessage_Type" json:"type,omitempty"`
	Peer                 *Peer            `protobuf:"bytes,2,opt,name=peer" json:"peer,omitempty"`
	Reservation          *Reservation     `protobuf:"bytes,3,opt,name=reservation" json:"reservation,omitempty"`
	Limit                *Limit           `protobuf:"bytes,4,opt,name=limit" json:"limit,omitempty"`
	Status               *Status          `protobuf:"varint,5,opt,name=status,enum=circuit.pb.Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *HopMessage) Reset()         { *m = HopMessage{} }
func (m *HopMessage) String() string { return proto.CompactTextString(m) }
func (*HopMessage) ProtoMessage()    {}
func (*HopMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed01bbc211f15e47, []int{0}
}
func (m *HopMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HopMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HopMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HopMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HopMessage.Merge(m, src)
}
func (m *HopMessage) XXX_Size() int {
	return m.Size()
}
func (m *HopMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_HopMessage.DiscardUnknown(m)
}

var xxx_messageInfo_HopMessage proto.InternalMessageInfo

func (m *HopMessage) GetType() HopMessage_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return HopMessage_RESERVE
}

func (m *HopMessage) GetPeer() *Peer {
	if m != nil {
		return m.Peer
	}
	return nil
}

func (m *HopMessage) GetReservation() *Reservation {
	if m != nil {
		return m.Reservation
	}
	return nil
}

func (m *HopMessage) GetLimit() *Limit {
	if m != nil {
		return m.Limit
	}
	return nil
}

func (m *HopMessage) GetStatus() Status {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return Status_OK
}

type StopMessage struct {
	Type                 *StopMessage_Type `protobuf:"varint,1,req,name=type,enum=circuit.pb.StopMessage_Type" json:"type,omitempty"`
	Peer                 *Peer             `protobuf:"bytes,2,opt,name=peer" json:"peer,omitempty"`
	Limit                *Limit            `protobuf:"bytes,3,opt,name=limit" json:"limit,omitempty"`
	Status               *Status           `protobuf:"varint,4,opt,name=status,enum=circuit.pb.Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *StopMessage) Reset()         { *m = StopMessage{} }
func (m *StopMessage) String() string { return proto.CompactTextString(m) }
func (*StopMessage) ProtoMessage()    {}
func (*StopMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed01bbc211f15e47, []int{1}
}
func (m *StopMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StopMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StopMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StopMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopMessage.Merge(m, src)
}
func (m *StopMessage) XXX_Size() int {
	return m.Size()
}
func (m *StopMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_StopMessage.DiscardUnknown(m)
}

var xxx_messageInfo_StopMessage proto.InternalMessageInfo

func (m *StopMessage) GetType() StopMessage_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return StopMessage_CONNECT
}

func (m *StopMessage) GetPeer() *Peer {
	if m != nil {
		return m.Peer
	}
	return nil
}

func (m *StopMessage) GetLimit() *Limit {
	if m != nil {
		return m.Limit
	}
	return nil
}

func (m *StopMessage) GetStatus() Status {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return Status_OK
}

type Peer struct {
	Id                   []byte   `protobuf:"bytes,1,req,name=id" json:"id,omitempty"`
	Addrs                [][]byte `protobuf:"bytes,2,rep,name=addrs" json:"addrs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Peer) Reset()         { *m = Peer{} }
func (m *Peer) String() string { return proto.CompactTextString(m) }
func (*Peer) ProtoMessage()    {}
func (*Peer) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed01bbc211f15e47, []int{2}
}
func (m *Peer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Peer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Peer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Peer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Peer.Merge(m, src)
}
func (m *Peer) XXX_Size() int {
	return m.Size()
}
func (m *Peer) XXX_DiscardUnknown() {
	xxx_messageInfo_Peer.DiscardUnknown(m)
}

var xxx_messageInfo_Peer proto.InternalMessageInfo

func (m *Peer) GetId() []byte {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Peer) GetAddrs() [][]byte {
	if m != nil {
		return m.Addrs
	}
	return nil
}

type Reservation struct {
	Expire               *uint64  `protobuf:"varint,1,req,name=expire" json:"expire,omitempty"`
	Addrs                [][]byte `protobuf:"bytes,2,rep,name=addrs" json:"addrs,omitempty"`
	Voucher              []byte   `protobuf:"bytes,3,opt,name=voucher" json:"voucher,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Reservation) Reset()         { *m = Reservation{} }
func (m *Reservation) String() string { return proto.CompactTextString(m) }
func (*Reservation) ProtoMessage()    {}
func (*Reservation) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed01bbc211f15e47, []int{3}
}
func (m *Reservation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Reservation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Reservation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Reservation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Reservation.Merge(m, src)
}
func (m *Reservation) XXX_Size() int {
	return m.Size()
}
func (m *Reservation) XXX_DiscardUnknown() {
	xxx_messageInfo_Reservation.DiscardUnknown(m)
}

var xxx_messageInfo_Reservation proto.InternalMessageInfo

func (m *Reservation) GetExpire() uint64 {
	if m != nil && m.Expire != nil {
		return *m.Expire
	}
	return 0
}

func (m *Reservation) GetAddrs() [][]byte {
	if m != nil {
		return m.Addrs
	}
	return nil
}

func (m *Reservation) GetVoucher() []byte {
	if m != nil {
		return m.Voucher
	}
	return nil
}

type Limit struct {
	Duration             *uint32  `protobuf:"varint,1,opt,name=duration" json:"duration,omitempty"`
	Data                 *uint64  `protobuf:"varint,2,opt,name=data" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Limit) Reset()         { *m = Limit{} }
func (m *Limit) String() string { return proto.CompactTextString(m) }
func (*Limit) ProtoMessage()    {}
func (*Limit) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed01bbc211f15e47, []int{4}
}
func (m *Limit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Limit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Limit.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Limit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Limit.Merge(m, src)
}
func (m *Limit) XXX_Size() int {
	return m.Size()
}
func (m *Limit) XXX_DiscardUnknown() {
	xxx_messageInfo_Limit.DiscardUnknown(m)
}

var xxx_messageInfo_Limit proto.InternalMessageInfo

func (m *Limit) GetDuration() uint32 {
	if m != nil && m.Duration != nil {
		return *m.Duration
	}
	return 0
}

func (m *Limit) GetData() uint64 {
	if m != nil && m.Data != nil {
		return *m.Data
	}
	return 0
}

func init() {
	proto.RegisterEnum("circuit.pb.Status", Status_name, Status_value)
	proto.RegisterEnum("circuit.pb.HopMessage_Type", HopMessage_Type_name, HopMessage_Type_value)
	proto.RegisterEnum("circuit.pb.StopMessage_Type", StopMessage_Type_name, StopMessage_Type_value)
	proto.RegisterType((*HopMessage)(nil), "circuit.pb.HopMessage")
	proto.RegisterType((*StopMessage)(nil), "circuit.pb.StopMessage")
	proto.RegisterType((*Peer)(nil), "circuit.pb.Peer")
	proto.RegisterType((*Reservation)(nil), "circuit.pb.Reservation")
	proto.RegisterType((*Limit)(nil), "circuit.pb.Limit")
}

func init() { proto.RegisterFile("circuit.proto", fileDescriptor_ed01bbc211f15e47) }

var fileDescriptor_ed01bbc211f15e47 = []byte{
	// 514 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x92, 0xcf, 0x8a, 0xd3, 0x50,
	0x18, 0xc5, 0xe7, 0xa6, 0x69, 0x47, 0xbe, 0x76, 0x4a, 0xe6, 0x1b, 0x99, 0x06, 0x1d, 0x6a, 0x29,
	0x82, 0x65, 0x90, 0x2a, 0xdd, 0x88, 0xcb, 0xda, 0x7c, 0xd5, 0x60, 0x93, 0x94, 0x7b, 0x53, 0x99,
	0x5d, 0x89, 0xcd, 0x45, 0x03, 0x6a, 0x43, 0x92, 0x0e, 0xce, 0x5b, 0xe8, 0x23, 0xf8, 0x22, 0xae,
	0xc7, 0x3f, 0x0b, 0xf7, 0x6e, 0xa4, 0x4f, 0x22, 0xb9, 0xe9, 0xb4, 0x19, 0x10, 0x14, 0xdc, 0xf5,
	0xdc, 0x73, 0x0e, 0xb7, 0xbf, 0x73, 0x03, 0x07, 0x8b, 0x28, 0x59, 0xac, 0xa2, 0xac, 0x1f, 0x27,
	0xcb, 0x6c, 0x89, 0xb0, 0x95, 0x2f, 0xbb, 0x9f, 0x34, 0x80, 0x67, 0xcb, 0xd8, 0x91, 0x69, 0x1a,
	0xbc, 0x92, 0xf8, 0x00, 0xf4, 0xec, 0x22, 0x96, 0x26, 0xeb, 0x68, 0xbd, 0xe6, 0xe0, 0x76, 0x7f,
	0x97, 0xec, 0xef, 0x52, 0x7d, 0xff, 0x22, 0x96, 0x5c, 0x05, 0xf1, 0x2e, 0xe8, 0xb1, 0x94, 0x89,
	0xa9, 0x75, 0x58, 0xaf, 0x3e, 0x30, 0xca, 0x85, 0xa9, 0x94, 0x09, 0x57, 0x2e, 0x3e, 0x86, 0x7a,
	0x22, 0x53, 0x99, 0x9c, 0x07, 0x59, 0xb4, 0x7c, 0x67, 0x56, 0x54, 0xb8, 0x55, 0x0e, 0xf3, 0x9d,
	0xcd, 0xcb, 0x59, 0xbc, 0x07, 0xd5, 0x37, 0xd1, 0xdb, 0x28, 0x33, 0x75, 0x55, 0x3a, 0x2c, 0x97,
	0x26, 0xb9, 0xc1, 0x0b, 0x1f, 0x4f, 0xa1, 0x96, 0x66, 0x41, 0xb6, 0x4a, 0xcd, 0x6a, 0x87, 0xf5,
	0x9a, 0x03, 0x2c, 0x27, 0x85, 0x72, 0xf8, 0x26, 0xd1, 0xbd, 0x0f, 0x7a, 0xce, 0x80, 0x75, 0xd8,
	0xe7, 0x24, 0x88, 0xbf, 0x20, 0x63, 0x2f, 0x17, 0x23, 0xcf, 0x75, 0x69, 0xe4, 0x1b, 0x0c, 0x01,
	0x6a, 0xc2, 0x1f, 0xfa, 0x33, 0x61, 0x68, 0xdd, 0x9f, 0x0c, 0xea, 0x22, 0xdb, 0x8d, 0xf4, 0xf0,
	0xda, 0x48, 0x27, 0xd7, 0xef, 0xf9, 0x8f, 0x95, 0xb6, 0xa8, 0x95, 0x7f, 0x46, 0xd5, 0xff, 0x8a,
	0x7a, 0x67, 0x87, 0x7a, 0x45, 0xb7, 0x57, 0xa2, 0x63, 0xf9, 0x16, 0xf9, 0x7f, 0xc0, 0x26, 0x68,
	0x51, 0xa8, 0x98, 0x1a, 0x5c, 0x8b, 0x42, 0xbc, 0x09, 0xd5, 0x20, 0x0c, 0x93, 0xd4, 0xd4, 0x3a,
	0x95, 0x5e, 0x83, 0x17, 0xa2, 0x3b, 0x83, 0x7a, 0xe9, 0xa9, 0xf0, 0x18, 0x6a, 0xf2, 0x7d, 0x1c,
	0x25, 0xc5, 0x18, 0x3a, 0xdf, 0xa8, 0x3f, 0x97, 0xd1, 0x84, 0xfd, 0xf3, 0xe5, 0x6a, 0xf1, 0x5a,
	0x26, 0x0a, 0xb1, 0xc1, 0xaf, 0x64, 0xf7, 0x11, 0x54, 0x15, 0x21, 0xde, 0x82, 0x1b, 0xe1, 0x2a,
	0x29, 0x3e, 0x13, 0xd6, 0x61, 0xbd, 0x03, 0xbe, 0xd5, 0x88, 0xa0, 0x87, 0x41, 0x16, 0xa8, 0x15,
	0x75, 0xae, 0x7e, 0x9f, 0x7e, 0x66, 0x50, 0x2b, 0x88, 0xb1, 0x06, 0x9a, 0xf7, 0xdc, 0x08, 0xd1,
	0x84, 0xa3, 0xe2, 0x51, 0x87, 0xbe, 0xed, 0xb9, 0x73, 0x4e, 0xe3, 0x99, 0x20, 0xcb, 0xb8, 0x64,
	0x78, 0x02, 0x2d, 0x4e, 0xc2, 0x9b, 0xf1, 0x11, 0xcd, 0x27, 0xb6, 0x63, 0xfb, 0x73, 0x3a, 0x1b,
	0x11, 0x59, 0x64, 0x19, 0x5f, 0x18, 0x1e, 0xc3, 0xe1, 0x94, 0xb8, 0x63, 0x0b, 0x91, 0xd7, 0x2c,
	0x72, 0x6d, 0xb2, 0x8c, 0xaf, 0xea, 0x7c, 0xb3, 0x5c, 0x7e, 0x3e, 0x1e, 0xda, 0x13, 0xb2, 0x8c,
	0x6f, 0x0c, 0x8f, 0xa0, 0xe9, 0x7a, 0xf3, 0xd2, 0x55, 0xc6, 0x77, 0x15, 0x76, 0x86, 0x93, 0xb1,
	0xc7, 0x1d, 0xb2, 0xe6, 0x0e, 0x09, 0x31, 0x7c, 0x4a, 0xc6, 0x87, 0x0a, 0xb6, 0x00, 0x67, 0x2e,
	0x9d, 0x4d, 0x69, 0xe4, 0x97, 0x8c, 0x8f, 0x95, 0x27, 0x8d, 0xcb, 0x75, 0x9b, 0xfd, 0x58, 0xb7,
	0xd9, 0xaf, 0x75, 0x9b, 0xfd, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x63, 0x19, 0x1e, 0x6c, 0xaa, 0x03,
	0x00, 0x00,
}

func (m *HopMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HopMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HopMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Status != nil {
		i = encodeVarintCircuit(dAtA, i, uint64(*m.Status))
		i--
		dAtA[i] = 0x28
	}
	if m.Limit != nil {
		{
			size, err := m.Limit.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCircuit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Reservation != nil {
		{
			size, err := m.Reservation.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCircuit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Peer != nil {
		{
			size, err := m.Peer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCircuit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		i = encodeVarintCircuit(dAtA, i, uint64(*m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *StopMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StopMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StopMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Status != nil {
		i = encodeVarintCircuit(dAtA, i, uint64(*m.Status))
		i--
		dAtA[i] = 0x20
	}
	if m.Limit != nil {
		{
			size, err := m.Limit.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCircuit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Peer != nil {
		{
			size, err := m.Peer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCircuit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		i = encodeVarintCircuit(dAtA, i, uint64(*m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Peer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Peer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Peer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Addrs) > 0 {
		for iNdEx := len(m.Addrs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Addrs[iNdEx])
			copy(dAtA[i:], m.Addrs[iNdEx])
			i = encodeVarintCircuit(dAtA, i, uint64(len(m.Addrs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Id == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	} else {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintCircuit(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Reservation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Reservation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Reservation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Voucher != nil {
		i -= len(m.Voucher)
		copy(dAtA[i:], m.Voucher)
		i = encodeVarintCircuit(dAtA, i, uint64(len(m.Voucher)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Addrs) > 0 {
		for iNdEx := len(m.Addrs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Addrs[iNdEx])
			copy(dAtA[i:], m.Addrs[iNdEx])
			i = encodeVarintCircuit(dAtA, i, uint64(len(m.Addrs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Expire == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("expire")
	} else {
		i = encodeVarintCircuit(dAtA, i, uint64(*m.Expire))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Limit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Limit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Limit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Data != nil {
		i = encodeVarintCircuit(dAtA, i, uint64(*m.Data))
		i--
		dAtA[i] = 0x10
	}
	if m.Duration != nil {
		i = encodeVarintCircuit(dAtA, i, uint64(*m.Duration))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintCircuit(dAtA []byte, offset int, v uint64) int {
	offset -= sovCircuit(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *HopMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovCircuit(uint64(*m.Type))
	}
	if m.Peer != nil {
		l = m.Peer.Size()
		n += 1 + l + sovCircuit(uint64(l))
	}
	if m.Reservation != nil {
		l = m.Reservation.Size()
		n += 1 + l + sovCircuit(uint64(l))
	}
	if m.Limit != nil {
		l = m.Limit.Size()
		n += 1 + l + sovCircuit(uint64(l))
	}
	if m.Status != nil {
		n += 1 + sovCircuit(uint64(*m.Status))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StopMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovCircuit(uint64(*m.Type))
	}
	if m.Peer != nil {
		l = m.Peer.Size()
		n += 1 + l + sovCircuit(uint64(l))
	}
	if m.Limit != nil {
		l = m.Limit.Size()
		n += 1 + l + sovCircuit(uint64(l))
	}
	if m.Status != nil {
		n += 1 + sovCircuit(uint64(*m.Status))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Peer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != nil {
		l = len(m.Id)
		n += 1 + l + sovCircuit(uint64(l))
	}
	if len(m.Addrs) > 0 {
		for _, b := range m.Addrs {
			l = len(b)
			n += 1 + l + sovCircuit(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Reservation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Expire != nil {
		n += 1 + sovCircuit(uint64(*m.Expire))
	}
	if len(m.Addrs) > 0 {
		for _, b := range m.Addrs {
			l = len(b)
			n += 1 + l + sovCircuit(uint64(l))
		}
	}
	if m.Voucher != nil {
		l = len(m.Voucher)
		n += 1 + l + sovCircuit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Limit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Duration != nil {
		n += 1 + sovCircuit(uint64(*m.Duration))
	}
	if m.Data != nil {
		n += 1 + sovCircuit(uint64(*m.Data))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovCircuit(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozCircuit(x uint64) (n int) {
	return sovCircuit(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *HopMessage) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCircuit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HopMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HopMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v HopMessage_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= HopMessage_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCircuit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCircuit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Peer == nil {
				m.Peer = &Peer{}
			}
			if err := m.Peer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reservation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCircuit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCircuit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Reservation == nil {
				m.Reservation = &Reservation{}
			}
			if err := m.Reservation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCircuit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCircuit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Limit == nil {
				m.Limit = &Limit{}
			}
			if err := m.Limit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var v Status
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= Status(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Status = &v
		default:
			iNdEx = preIndex
			skippy, err := skipCircuit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCircuit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StopMessage) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCircuit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StopMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StopMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v StopMessage_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= StopMessage_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCircuit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCircuit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Peer == nil {
				m.Peer = &Peer{}
			}
			if err := m.Peer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCircuit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCircuit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Limit == nil {
				m.Limit = &Limit{}
			}
			if err := m.Limit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var v Status
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= Status(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Status = &v
		default:
			iNdEx = preIndex
			skippy, err := skipCircuit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCircuit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Peer) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCircuit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Peer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Peer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthCircuit
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthCircuit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = append(m.Id[:0], dAtA[iNdEx:postIndex]...)
			if m.Id == nil {
				m.Id = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addrs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthCircuit
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthCircuit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addrs = append(m.Addrs, make([]byte, postIndex-iNdEx))
			copy(m.Addrs[len(m.Addrs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCircuit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCircuit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Reservation) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCircuit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reservation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reservation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expire", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Expire = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addrs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthCircuit
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthCircuit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addrs = append(m.Addrs, make([]byte, postIndex-iNdEx))
			copy(m.Addrs[len(m.Addrs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Voucher", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthCircuit
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthCircuit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Voucher = append(m.Voucher[:0], dAtA[iNdEx:postIndex]...)
			if m.Voucher == nil {
				m.Voucher = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCircuit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCircuit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("expire")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Limit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCircuit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Limit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Limit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Duration = &v
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Data = &v
		default:
			iNdEx = preIndex
			skippy, err := skipCircuit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCircuit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCircuit(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCircuit
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCircuit
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCircuit
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupCircuit
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthCircuit
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthCircuit        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCircuit          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupCircuit = fmt.Errorf("proto: unexpected end of group")
)
