"use strict";

var _interopRequire = function (obj) { return obj && obj.__esModule ? obj["default"] : obj; };

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

Object.defineProperty(exports, "__esModule", {
    value: true
});
/*
  Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

var Syntax = require("estraverse").Syntax;

var Map = _interopRequire(require("es6-map"));

var Reference = _interopRequire(require("./reference"));

var Variable = _interopRequire(require("./variable"));

var Definition = _interopRequire(require("./definition"));

var assert = _interopRequire(require("assert"));

function isStrictScope(scope, block, isMethodDefinition, useDirective) {
    var body, i, iz, stmt, expr;

    // When upper scope is exists and strict, inner scope is also strict.
    if (scope.upper && scope.upper.isStrict) {
        return true;
    }

    // ArrowFunctionExpression's scope is always strict scope.
    if (block.type === Syntax.ArrowFunctionExpression) {
        return true;
    }

    if (isMethodDefinition) {
        return true;
    }

    if (scope.type === "class" || scope.type === "module") {
        return true;
    }

    if (scope.type === "block" || scope.type === "switch") {
        return false;
    }

    if (scope.type === "function") {
        if (block.type === "Program") {
            body = block;
        } else {
            body = block.body;
        }
    } else if (scope.type === "global") {
        body = block;
    } else {
        return false;
    }

    // Search 'use strict' directive.
    if (useDirective) {
        for (i = 0, iz = body.body.length; i < iz; ++i) {
            stmt = body.body[i];
            if (stmt.type !== "DirectiveStatement") {
                break;
            }
            if (stmt.raw === "\"use strict\"" || stmt.raw === "'use strict'") {
                return true;
            }
        }
    } else {
        for (i = 0, iz = body.body.length; i < iz; ++i) {
            stmt = body.body[i];
            if (stmt.type !== Syntax.ExpressionStatement) {
                break;
            }
            expr = stmt.expression;
            if (expr.type !== Syntax.Literal || typeof expr.value !== "string") {
                break;
            }
            if (expr.raw != null) {
                if (expr.raw === "\"use strict\"" || expr.raw === "'use strict'") {
                    return true;
                }
            } else {
                if (expr.value === "use strict") {
                    return true;
                }
            }
        }
    }
    return false;
}

function registerScope(scopeManager, scope) {
    var scopes;

    scopeManager.scopes.push(scope);

    scopes = scopeManager.__nodeToScope.get(scope.block);
    if (scopes) {
        scopes.push(scope);
    } else {
        scopeManager.__nodeToScope.set(scope.block, [scope]);
    }
}

function shouldBeStatically(def) {
    return def.type === Variable.ClassName || def.type === Variable.Variable && def.parent.kind !== "var";
}

/**
 * @class Scope
 */

var Scope = (function () {
    function Scope(scopeManager, type, upperScope, block, isMethodDefinition) {
        _classCallCheck(this, Scope);

        /**
         * One of 'TDZ', 'module', 'block', 'switch', 'function', 'catch', 'with', 'function', 'class', 'global'.
         * @member {String} Scope#type
         */
        this.type = type;
        /**
        * The scoped {@link Variable}s of this scope, as <code>{ Variable.name
        * : Variable }</code>.
        * @member {Map} Scope#set
        */
        this.set = new Map();
        /**
         * The tainted variables of this scope, as <code>{ Variable.name :
         * boolean }</code>.
         * @member {Map} Scope#taints */
        this.taints = new Map();
        /**
         * Generally, through the lexical scoping of JS you can always know
         * which variable an identifier in the source code refers to. There are
         * a few exceptions to this rule. With 'global' and 'with' scopes you
         * can only decide at runtime which variable a reference refers to.
         * Moreover, if 'eval()' is used in a scope, it might introduce new
         * bindings in this or its prarent scopes.
         * All those scopes are considered 'dynamic'.
         * @member {boolean} Scope#dynamic
         */
        this.dynamic = this.type === "global" || this.type === "with";
        /**
         * A reference to the scope-defining syntax node.
         * @member {esprima.Node} Scope#block
         */
        this.block = block;
        /**
        * The {@link Reference|references} that are not resolved with this scope.
        * @member {Reference[]} Scope#through
        */
        this.through = [];
        /**
        * The scoped {@link Variable}s of this scope. In the case of a
        * 'function' scope this includes the automatic argument <em>arguments</em> as
        * its first element, as well as all further formal arguments.
        * @member {Variable[]} Scope#variables
        */
        this.variables = [];
        /**
        * Any variable {@link Reference|reference} found in this scope. This
        * includes occurrences of local variables as well as variables from
        * parent scopes (including the global scope). For local variables
        * this also includes defining occurrences (like in a 'var' statement).
        * In a 'function' scope this does not include the occurrences of the
        * formal parameter in the parameter list.
        * @member {Reference[]} Scope#references
        */
        this.references = [];

        /**
        * For 'global' and 'function' scopes, this is a self-reference. For
        * other scope types this is the <em>variableScope</em> value of the
        * parent scope.
        * @member {Scope} Scope#variableScope
        */
        this.variableScope = this.type === "global" || this.type === "function" || this.type === "module" ? this : upperScope.variableScope;
        /**
        * Whether this scope is created by a FunctionExpression.
        * @member {boolean} Scope#functionExpressionScope
        */
        this.functionExpressionScope = false;
        /**
        * Whether this is a scope that contains an 'eval()' invocation.
        * @member {boolean} Scope#directCallToEvalScope
        */
        this.directCallToEvalScope = false;
        /**
        * @member {boolean} Scope#thisFound
        */
        this.thisFound = false;

        this.__left = [];

        /**
        * Reference to the parent {@link Scope|scope}.
        * @member {Scope} Scope#upper
        */
        this.upper = upperScope;
        /**
        * Whether 'use strict' is in effect in this scope.
        * @member {boolean} Scope#isStrict
        */
        this.isStrict = isStrictScope(this, block, isMethodDefinition, scopeManager.__useDirective());

        /**
        * List of nested {@link Scope}s.
        * @member {Scope[]} Scope#childScopes
        */
        this.childScopes = [];
        if (this.upper) {
            this.upper.childScopes.push(this);
        }

        registerScope(scopeManager, this);
    }

    _createClass(Scope, {
        __shouldStaticallyClose: {
            value: function __shouldStaticallyClose(scopeManager) {
                return !this.dynamic || scopeManager.__isOptimistic();
            }
        },
        __shouldStaticallyCloseForGlobal: {
            value: function __shouldStaticallyCloseForGlobal(ref) {
                // On global scope, let/const/class declarations should be resolved statically.
                var name = ref.identifier.name;
                if (!this.set.has(name)) {
                    return false;
                }

                var variable = this.set.get(name);
                var defs = variable.defs;
                return defs.length > 0 && defs.every(shouldBeStatically);
            }
        },
        __staticCloseRef: {
            value: function __staticCloseRef(ref) {
                if (!this.__resolve(ref)) {
                    this.__delegateToUpperScope(ref);
                }
            }
        },
        __dynamicCloseRef: {
            value: function __dynamicCloseRef(ref) {
                // notify all names are through to global
                var current = this;
                do {
                    current.through.push(ref);
                    current = current.upper;
                } while (current);
            }
        },
        __globalCloseRef: {
            value: function __globalCloseRef(ref) {
                // let/const/class declarations should be resolved statically.
                // others should be resolved dynamically.
                if (this.__shouldStaticallyCloseForGlobal(ref)) {
                    this.__staticCloseRef(ref);
                } else {
                    this.__dynamicCloseRef(ref);
                }
            }
        },
        __close: {
            value: function __close(scopeManager) {
                var closeRef;
                if (this.__shouldStaticallyClose(scopeManager)) {
                    closeRef = this.__staticCloseRef;
                } else if (this.type !== "global") {
                    closeRef = this.__dynamicCloseRef;
                } else {
                    closeRef = this.__globalCloseRef;
                }

                // Try Resolving all references in this scope.
                for (var i = 0, iz = this.__left.length; i < iz; ++i) {
                    var ref = this.__left[i];
                    closeRef.call(this, ref);
                }
                this.__left = null;

                return this.upper;
            }
        },
        __resolve: {
            value: function __resolve(ref) {
                var variable, name;
                name = ref.identifier.name;
                if (this.set.has(name)) {
                    variable = this.set.get(name);
                    variable.references.push(ref);
                    variable.stack = variable.stack && ref.from.variableScope === this.variableScope;
                    if (ref.tainted) {
                        variable.tainted = true;
                        this.taints.set(variable.name, true);
                    }
                    ref.resolved = variable;
                    return true;
                }
                return false;
            }
        },
        __delegateToUpperScope: {
            value: function __delegateToUpperScope(ref) {
                if (this.upper) {
                    this.upper.__left.push(ref);
                }
                this.through.push(ref);
            }
        },
        __defineGeneric: {
            value: function __defineGeneric(name, set, variables, node, def) {
                var variable;

                variable = set.get(name);
                if (!variable) {
                    variable = new Variable(name, this);
                    set.set(name, variable);
                    variables.push(variable);
                }

                if (def) {
                    variable.defs.push(def);
                }
                if (node) {
                    variable.identifiers.push(node);
                }
            }
        },
        __define: {
            value: function __define(node, def) {
                if (node && node.type === Syntax.Identifier) {
                    this.__defineGeneric(node.name, this.set, this.variables, node, def);
                }
            }
        },
        __referencing: {
            value: function __referencing(node, assign, writeExpr, maybeImplicitGlobal, partial, init) {
                // because Array element may be null
                if (!node || node.type !== Syntax.Identifier) {
                    return;
                }

                // Specially handle like `this`.
                if (node.name === "super") {
                    return;
                }

                var ref = new Reference(node, this, assign || Reference.READ, writeExpr, maybeImplicitGlobal, !!partial, !!init);
                this.references.push(ref);
                this.__left.push(ref);
            }
        },
        __detectEval: {
            value: function __detectEval() {
                var current;
                current = this;
                this.directCallToEvalScope = true;
                do {
                    current.dynamic = true;
                    current = current.upper;
                } while (current);
            }
        },
        __detectThis: {
            value: function __detectThis() {
                this.thisFound = true;
            }
        },
        __isClosed: {
            value: function __isClosed() {
                return this.__left === null;
            }
        },
        resolve: {

            /**
             * returns resolved {Reference}
             * @method Scope#resolve
             * @param {Esprima.Identifier} ident - identifier to be resolved.
             * @return {Reference}
             */

            value: function resolve(ident) {
                var ref, i, iz;
                assert(this.__isClosed(), "Scope should be closed.");
                assert(ident.type === Syntax.Identifier, "Target should be identifier.");
                for (i = 0, iz = this.references.length; i < iz; ++i) {
                    ref = this.references[i];
                    if (ref.identifier === ident) {
                        return ref;
                    }
                }
                return null;
            }
        },
        isStatic: {

            /**
             * returns this scope is static
             * @method Scope#isStatic
             * @return {boolean}
             */

            value: function isStatic() {
                return !this.dynamic;
            }
        },
        isArgumentsMaterialized: {

            /**
             * returns this scope has materialized arguments
             * @method Scope#isArgumentsMaterialized
             * @return {boolean}
             */

            value: function isArgumentsMaterialized() {
                return true;
            }
        },
        isThisMaterialized: {

            /**
             * returns this scope has materialized `this` reference
             * @method Scope#isThisMaterialized
             * @return {boolean}
             */

            value: function isThisMaterialized() {
                return true;
            }
        },
        isUsedName: {
            value: function isUsedName(name) {
                if (this.set.has(name)) {
                    return true;
                }
                for (var i = 0, iz = this.through.length; i < iz; ++i) {
                    if (this.through[i].identifier.name === name) {
                        return true;
                    }
                }
                return false;
            }
        }
    });

    return Scope;
})();

exports["default"] = Scope;

var GlobalScope = exports.GlobalScope = (function (_Scope) {
    function GlobalScope(scopeManager, block) {
        _classCallCheck(this, GlobalScope);

        _get(Object.getPrototypeOf(GlobalScope.prototype), "constructor", this).call(this, scopeManager, "global", null, block, false);
        this.implicit = {
            set: new Map(),
            variables: [],
            /**
            * List of {@link Reference}s that are left to be resolved (i.e. which
            * need to be linked to the variable they refer to).
            * @member {Reference[]} Scope#implicit#left
            */
            left: []
        };
    }

    _inherits(GlobalScope, _Scope);

    _createClass(GlobalScope, {
        __close: {
            value: function __close(scopeManager) {
                var implicit = [];
                for (var i = 0, iz = this.__left.length; i < iz; ++i) {
                    var ref = this.__left[i];
                    if (ref.__maybeImplicitGlobal && !this.set.has(ref.identifier.name)) {
                        implicit.push(ref.__maybeImplicitGlobal);
                    }
                }

                // create an implicit global variable from assignment expression
                for (var i = 0, iz = implicit.length; i < iz; ++i) {
                    var info = implicit[i];
                    this.__defineImplicit(info.pattern, new Definition(Variable.ImplicitGlobalVariable, info.pattern, info.node, null, null, null));
                }

                this.implicit.left = this.__left;

                return _get(Object.getPrototypeOf(GlobalScope.prototype), "__close", this).call(this, scopeManager);
            }
        },
        __defineImplicit: {
            value: function __defineImplicit(node, def) {
                if (node && node.type === Syntax.Identifier) {
                    this.__defineGeneric(node.name, this.implicit.set, this.implicit.variables, node, def);
                }
            }
        }
    });

    return GlobalScope;
})(Scope);

var ModuleScope = exports.ModuleScope = (function (_Scope2) {
    function ModuleScope(scopeManager, upperScope, block) {
        _classCallCheck(this, ModuleScope);

        _get(Object.getPrototypeOf(ModuleScope.prototype), "constructor", this).call(this, scopeManager, "module", upperScope, block, false);
    }

    _inherits(ModuleScope, _Scope2);

    return ModuleScope;
})(Scope);

var FunctionExpressionNameScope = exports.FunctionExpressionNameScope = (function (_Scope3) {
    function FunctionExpressionNameScope(scopeManager, upperScope, block) {
        _classCallCheck(this, FunctionExpressionNameScope);

        _get(Object.getPrototypeOf(FunctionExpressionNameScope.prototype), "constructor", this).call(this, scopeManager, "function-expression-name", upperScope, block, false);
        this.__define(block.id, new Definition(Variable.FunctionName, block.id, block, null, null, null));
        this.functionExpressionScope = true;
    }

    _inherits(FunctionExpressionNameScope, _Scope3);

    return FunctionExpressionNameScope;
})(Scope);

var CatchScope = exports.CatchScope = (function (_Scope4) {
    function CatchScope(scopeManager, upperScope, block) {
        _classCallCheck(this, CatchScope);

        _get(Object.getPrototypeOf(CatchScope.prototype), "constructor", this).call(this, scopeManager, "catch", upperScope, block, false);
    }

    _inherits(CatchScope, _Scope4);

    return CatchScope;
})(Scope);

var WithScope = exports.WithScope = (function (_Scope5) {
    function WithScope(scopeManager, upperScope, block) {
        _classCallCheck(this, WithScope);

        _get(Object.getPrototypeOf(WithScope.prototype), "constructor", this).call(this, scopeManager, "with", upperScope, block, false);
    }

    _inherits(WithScope, _Scope5);

    _createClass(WithScope, {
        __close: {
            value: function __close(scopeManager) {
                if (this.__shouldStaticallyClose(scopeManager)) {
                    return _get(Object.getPrototypeOf(WithScope.prototype), "__close", this).call(this, scopeManager);
                }

                for (var i = 0, iz = this.__left.length; i < iz; ++i) {
                    var ref = this.__left[i];
                    ref.tainted = true;
                    this.__delegateToUpperScope(ref);
                }
                this.__left = null;

                return this.upper;
            }
        }
    });

    return WithScope;
})(Scope);

var TDZScope = exports.TDZScope = (function (_Scope6) {
    function TDZScope(scopeManager, upperScope, block) {
        _classCallCheck(this, TDZScope);

        _get(Object.getPrototypeOf(TDZScope.prototype), "constructor", this).call(this, scopeManager, "TDZ", upperScope, block, false);
    }

    _inherits(TDZScope, _Scope6);

    return TDZScope;
})(Scope);

var BlockScope = exports.BlockScope = (function (_Scope7) {
    function BlockScope(scopeManager, upperScope, block) {
        _classCallCheck(this, BlockScope);

        _get(Object.getPrototypeOf(BlockScope.prototype), "constructor", this).call(this, scopeManager, "block", upperScope, block, false);
    }

    _inherits(BlockScope, _Scope7);

    return BlockScope;
})(Scope);

var SwitchScope = exports.SwitchScope = (function (_Scope8) {
    function SwitchScope(scopeManager, upperScope, block) {
        _classCallCheck(this, SwitchScope);

        _get(Object.getPrototypeOf(SwitchScope.prototype), "constructor", this).call(this, scopeManager, "switch", upperScope, block, false);
    }

    _inherits(SwitchScope, _Scope8);

    return SwitchScope;
})(Scope);

var FunctionScope = exports.FunctionScope = (function (_Scope9) {
    function FunctionScope(scopeManager, upperScope, block, isMethodDefinition) {
        _classCallCheck(this, FunctionScope);

        _get(Object.getPrototypeOf(FunctionScope.prototype), "constructor", this).call(this, scopeManager, "function", upperScope, block, isMethodDefinition);

        // section 9.2.13, FunctionDeclarationInstantiation.
        // NOTE Arrow functions never have an arguments objects.
        if (this.block.type !== Syntax.ArrowFunctionExpression) {
            this.__defineArguments();
        }
    }

    _inherits(FunctionScope, _Scope9);

    _createClass(FunctionScope, {
        isArgumentsMaterialized: {
            value: function isArgumentsMaterialized() {
                // TODO(Constellation)
                // We can more aggressive on this condition like this.
                //
                // function t() {
                //     // arguments of t is always hidden.
                //     function arguments() {
                //     }
                // }
                if (this.block.type === Syntax.ArrowFunctionExpression) {
                    return false;
                }

                if (!this.isStatic()) {
                    return true;
                }

                var variable = this.set.get("arguments");
                assert(variable, "Always have arguments variable.");
                return variable.tainted || variable.references.length !== 0;
            }
        },
        isThisMaterialized: {
            value: function isThisMaterialized() {
                if (!this.isStatic()) {
                    return true;
                }
                return this.thisFound;
            }
        },
        __defineArguments: {
            value: function __defineArguments() {
                this.__defineGeneric("arguments", this.set, this.variables, null, null);
                this.taints.set("arguments", true);
            }
        }
    });

    return FunctionScope;
})(Scope);

var ForScope = exports.ForScope = (function (_Scope10) {
    function ForScope(scopeManager, upperScope, block) {
        _classCallCheck(this, ForScope);

        _get(Object.getPrototypeOf(ForScope.prototype), "constructor", this).call(this, scopeManager, "for", upperScope, block, false);
    }

    _inherits(ForScope, _Scope10);

    return ForScope;
})(Scope);

var ClassScope = exports.ClassScope = (function (_Scope11) {
    function ClassScope(scopeManager, upperScope, block) {
        _classCallCheck(this, ClassScope);

        _get(Object.getPrototypeOf(ClassScope.prototype), "constructor", this).call(this, scopeManager, "class", upperScope, block, false);
    }

    _inherits(ClassScope, _Scope11);

    return ClassScope;
})(Scope);

/* vim: set sw=4 ts=4 et tw=80 : */
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNjb3BlLmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztJQXdCUyxNQUFNLFdBQVEsWUFBWSxFQUExQixNQUFNOztJQUNSLEdBQUcsMkJBQU0sU0FBUzs7SUFFbEIsU0FBUywyQkFBTSxhQUFhOztJQUM1QixRQUFRLDJCQUFNLFlBQVk7O0lBQzFCLFVBQVUsMkJBQU0sY0FBYzs7SUFDOUIsTUFBTSwyQkFBTSxRQUFROztBQUUzQixTQUFTLGFBQWEsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLGtCQUFrQixFQUFFLFlBQVksRUFBRTtBQUNuRSxRQUFJLElBQUksRUFBRSxDQUFDLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUM7OztBQUc1QixRQUFJLEtBQUssQ0FBQyxLQUFLLElBQUksS0FBSyxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUU7QUFDckMsZUFBTyxJQUFJLENBQUM7S0FDZjs7O0FBR0QsUUFBSSxLQUFLLENBQUMsSUFBSSxLQUFLLE1BQU0sQ0FBQyx1QkFBdUIsRUFBRTtBQUMvQyxlQUFPLElBQUksQ0FBQztLQUNmOztBQUVELFFBQUksa0JBQWtCLEVBQUU7QUFDcEIsZUFBTyxJQUFJLENBQUM7S0FDZjs7QUFFRCxRQUFJLEtBQUssQ0FBQyxJQUFJLEtBQUssT0FBTyxJQUFJLEtBQUssQ0FBQyxJQUFJLEtBQUssUUFBUSxFQUFFO0FBQ25ELGVBQU8sSUFBSSxDQUFDO0tBQ2Y7O0FBRUQsUUFBSSxLQUFLLENBQUMsSUFBSSxLQUFLLE9BQU8sSUFBSSxLQUFLLENBQUMsSUFBSSxLQUFLLFFBQVEsRUFBRTtBQUNuRCxlQUFPLEtBQUssQ0FBQztLQUNoQjs7QUFFRCxRQUFJLEtBQUssQ0FBQyxJQUFJLEtBQUssVUFBVSxFQUFFO0FBQzNCLFlBQUksS0FBSyxDQUFDLElBQUksS0FBSyxTQUFTLEVBQUU7QUFDMUIsZ0JBQUksR0FBRyxLQUFLLENBQUM7U0FDaEIsTUFBTTtBQUNILGdCQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztTQUNyQjtLQUNKLE1BQU0sSUFBSSxLQUFLLENBQUMsSUFBSSxLQUFLLFFBQVEsRUFBRTtBQUNoQyxZQUFJLEdBQUcsS0FBSyxDQUFDO0tBQ2hCLE1BQU07QUFDSCxlQUFPLEtBQUssQ0FBQztLQUNoQjs7O0FBR0QsUUFBSSxZQUFZLEVBQUU7QUFDZCxhQUFLLENBQUMsR0FBRyxDQUFDLEVBQUUsRUFBRSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxDQUFDLEVBQUU7QUFDNUMsZ0JBQUksR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQ3BCLGdCQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssb0JBQW9CLEVBQUU7QUFDcEMsc0JBQU07YUFDVDtBQUNELGdCQUFJLElBQUksQ0FBQyxHQUFHLEtBQUssZ0JBQWMsSUFBSSxJQUFJLENBQUMsR0FBRyxLQUFLLGNBQWdCLEVBQUU7QUFDOUQsdUJBQU8sSUFBSSxDQUFDO2FBQ2Y7U0FDSjtLQUNKLE1BQU07QUFDSCxhQUFLLENBQUMsR0FBRyxDQUFDLEVBQUUsRUFBRSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxDQUFDLEVBQUU7QUFDNUMsZ0JBQUksR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQ3BCLGdCQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssTUFBTSxDQUFDLG1CQUFtQixFQUFFO0FBQzFDLHNCQUFNO2FBQ1Q7QUFDRCxnQkFBSSxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUM7QUFDdkIsZ0JBQUksSUFBSSxDQUFDLElBQUksS0FBSyxNQUFNLENBQUMsT0FBTyxJQUFJLE9BQU8sSUFBSSxDQUFDLEtBQUssS0FBSyxRQUFRLEVBQUU7QUFDaEUsc0JBQU07YUFDVDtBQUNELGdCQUFJLElBQUksQ0FBQyxHQUFHLElBQUksSUFBSSxFQUFFO0FBQ2xCLG9CQUFJLElBQUksQ0FBQyxHQUFHLEtBQUssZ0JBQWMsSUFBSSxJQUFJLENBQUMsR0FBRyxLQUFLLGNBQWdCLEVBQUU7QUFDOUQsMkJBQU8sSUFBSSxDQUFDO2lCQUNmO2FBQ0osTUFBTTtBQUNILG9CQUFJLElBQUksQ0FBQyxLQUFLLEtBQUssWUFBWSxFQUFFO0FBQzdCLDJCQUFPLElBQUksQ0FBQztpQkFDZjthQUNKO1NBQ0o7S0FDSjtBQUNELFdBQU8sS0FBSyxDQUFDO0NBQ2hCOztBQUVELFNBQVMsYUFBYSxDQUFDLFlBQVksRUFBRSxLQUFLLEVBQUU7QUFDeEMsUUFBSSxNQUFNLENBQUM7O0FBRVgsZ0JBQVksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDOztBQUVoQyxVQUFNLEdBQUcsWUFBWSxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQ3JELFFBQUksTUFBTSxFQUFFO0FBQ1IsY0FBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUN0QixNQUFNO0FBQ0gsb0JBQVksQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBRSxLQUFLLENBQUUsQ0FBQyxDQUFDO0tBQzFEO0NBQ0o7O0FBRUQsU0FBUyxrQkFBa0IsQ0FBQyxHQUFHLEVBQUU7QUFDN0IsV0FDSSxBQUFDLEdBQUcsQ0FBQyxJQUFJLEtBQUssUUFBUSxDQUFDLFNBQVMsSUFDL0IsR0FBRyxDQUFDLElBQUksS0FBSyxRQUFRLENBQUMsUUFBUSxJQUFJLEdBQUcsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLEtBQUssQUFBQyxDQUMvRDtDQUNMOzs7Ozs7SUFLb0IsS0FBSztBQUNYLGFBRE0sS0FBSyxDQUNWLFlBQVksRUFBRSxJQUFJLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxrQkFBa0IsRUFBRTs4QkFEdEQsS0FBSzs7Ozs7O0FBTWxCLFlBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDOzs7Ozs7QUFNakIsWUFBSSxDQUFDLEdBQUcsR0FBRyxJQUFJLEdBQUcsRUFBRSxDQUFDOzs7OztBQUtyQixZQUFJLENBQUMsTUFBTSxHQUFHLElBQUksR0FBRyxFQUFFLENBQUM7Ozs7Ozs7Ozs7O0FBV3hCLFlBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLElBQUksS0FBSyxRQUFRLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxNQUFNLENBQUM7Ozs7O0FBSzlELFlBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDOzs7OztBQUtuQixZQUFJLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQzs7Ozs7OztBQU9sQixZQUFJLENBQUMsU0FBUyxHQUFHLEVBQUUsQ0FBQzs7Ozs7Ozs7OztBQVVwQixZQUFJLENBQUMsVUFBVSxHQUFHLEVBQUUsQ0FBQzs7Ozs7Ozs7QUFRckIsWUFBSSxDQUFDLGFBQWEsR0FDZCxBQUFDLElBQUksQ0FBQyxJQUFJLEtBQUssUUFBUSxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssVUFBVSxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssUUFBUSxHQUFJLElBQUksR0FBRyxVQUFVLENBQUMsYUFBYSxDQUFDOzs7OztBQUtySCxZQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDOzs7OztBQUtyQyxZQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDOzs7O0FBSW5DLFlBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDOztBQUV2QixZQUFJLENBQUMsTUFBTSxHQUFHLEVBQUUsQ0FBQzs7Ozs7O0FBTWpCLFlBQUksQ0FBQyxLQUFLLEdBQUcsVUFBVSxDQUFDOzs7OztBQUt4QixZQUFJLENBQUMsUUFBUSxHQUFHLGFBQWEsQ0FBQyxJQUFJLEVBQUUsS0FBSyxFQUFFLGtCQUFrQixFQUFFLFlBQVksQ0FBQyxjQUFjLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7QUFNOUYsWUFBSSxDQUFDLFdBQVcsR0FBRyxFQUFFLENBQUM7QUFDdEIsWUFBSSxJQUFJLENBQUMsS0FBSyxFQUFFO0FBQ1osZ0JBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUNyQzs7QUFFRCxxQkFBYSxDQUFDLFlBQVksRUFBRSxJQUFJLENBQUMsQ0FBQztLQUNyQzs7aUJBdkdnQixLQUFLO0FBeUd0QiwrQkFBdUI7bUJBQUEsaUNBQUMsWUFBWSxFQUFFO0FBQ2xDLHVCQUFRLENBQUMsSUFBSSxDQUFDLE9BQU8sSUFBSSxZQUFZLENBQUMsY0FBYyxFQUFFLENBQUU7YUFDM0Q7O0FBRUQsd0NBQWdDO21CQUFBLDBDQUFDLEdBQUcsRUFBRTs7QUFFbEMsb0JBQUksSUFBSSxHQUFHLEdBQUcsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO0FBQy9CLG9CQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUU7QUFDckIsMkJBQU8sS0FBSyxDQUFDO2lCQUNoQjs7QUFFRCxvQkFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDbEMsb0JBQUksSUFBSSxHQUFHLFFBQVEsQ0FBQyxJQUFJLENBQUM7QUFDekIsdUJBQU8sSUFBSSxDQUFDLE1BQU0sR0FBRyxDQUFDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO2FBQzVEOztBQUVELHdCQUFnQjttQkFBQSwwQkFBQyxHQUFHLEVBQUU7QUFDbEIsb0JBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxFQUFFO0FBQ3RCLHdCQUFJLENBQUMsc0JBQXNCLENBQUMsR0FBRyxDQUFDLENBQUM7aUJBQ3BDO2FBQ0o7O0FBRUQseUJBQWlCO21CQUFBLDJCQUFDLEdBQUcsRUFBRTs7QUFFbkIsb0JBQUksT0FBTyxHQUFHLElBQUksQ0FBQztBQUNuQixtQkFBRztBQUNDLDJCQUFPLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztBQUMxQiwyQkFBTyxHQUFHLE9BQU8sQ0FBQyxLQUFLLENBQUM7aUJBQzNCLFFBQVEsT0FBTyxFQUFFO2FBQ3JCOztBQUVELHdCQUFnQjttQkFBQSwwQkFBQyxHQUFHLEVBQUU7OztBQUdsQixvQkFBSSxJQUFJLENBQUMsZ0NBQWdDLENBQUMsR0FBRyxDQUFDLEVBQUU7QUFDNUMsd0JBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsQ0FBQztpQkFDOUIsTUFBTTtBQUNILHdCQUFJLENBQUMsaUJBQWlCLENBQUMsR0FBRyxDQUFDLENBQUM7aUJBQy9CO2FBQ0o7O0FBRUQsZUFBTzttQkFBQSxpQkFBQyxZQUFZLEVBQUU7QUFDbEIsb0JBQUksUUFBUSxDQUFDO0FBQ2Isb0JBQUksSUFBSSxDQUFDLHVCQUF1QixDQUFDLFlBQVksQ0FBQyxFQUFFO0FBQzVDLDRCQUFRLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDO2lCQUNwQyxNQUFNLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxRQUFRLEVBQUU7QUFDL0IsNEJBQVEsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUM7aUJBQ3JDLE1BQU07QUFDSCw0QkFBUSxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztpQkFDcEM7OztBQUdELHFCQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxFQUFFLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEVBQUUsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLENBQUMsRUFBRTtBQUNsRCx3QkFBSSxHQUFHLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUN6Qiw0QkFBUSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsR0FBRyxDQUFDLENBQUM7aUJBQzVCO0FBQ0Qsb0JBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDOztBQUVuQix1QkFBTyxJQUFJLENBQUMsS0FBSyxDQUFDO2FBQ3JCOztBQUVELGlCQUFTO21CQUFBLG1CQUFDLEdBQUcsRUFBRTtBQUNYLG9CQUFJLFFBQVEsRUFBRSxJQUFJLENBQUM7QUFDbkIsb0JBQUksR0FBRyxHQUFHLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztBQUMzQixvQkFBSSxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsRUFBRTtBQUNwQiw0QkFBUSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFDO0FBQzlCLDRCQUFRLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztBQUM5Qiw0QkFBUSxDQUFDLEtBQUssR0FBRyxRQUFRLENBQUMsS0FBSyxJQUFJLEdBQUcsQ0FBQyxJQUFJLENBQUMsYUFBYSxLQUFLLElBQUksQ0FBQyxhQUFhLENBQUM7QUFDakYsd0JBQUksR0FBRyxDQUFDLE9BQU8sRUFBRTtBQUNiLGdDQUFRLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQztBQUN4Qiw0QkFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQztxQkFDeEM7QUFDRCx1QkFBRyxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7QUFDeEIsMkJBQU8sSUFBSSxDQUFDO2lCQUNmO0FBQ0QsdUJBQU8sS0FBSyxDQUFDO2FBQ2hCOztBQUVELDhCQUFzQjttQkFBQSxnQ0FBQyxHQUFHLEVBQUU7QUFDeEIsb0JBQUksSUFBSSxDQUFDLEtBQUssRUFBRTtBQUNaLHdCQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7aUJBQy9CO0FBQ0Qsb0JBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO2FBQzFCOztBQUVELHVCQUFlO21CQUFBLHlCQUFDLElBQUksRUFBRSxHQUFHLEVBQUUsU0FBUyxFQUFFLElBQUksRUFBRSxHQUFHLEVBQUU7QUFDN0Msb0JBQUksUUFBUSxDQUFDOztBQUViLHdCQUFRLEdBQUcsR0FBRyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUN6QixvQkFBSSxDQUFDLFFBQVEsRUFBRTtBQUNYLDRCQUFRLEdBQUcsSUFBSSxRQUFRLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3BDLHVCQUFHLENBQUMsR0FBRyxDQUFDLElBQUksRUFBRSxRQUFRLENBQUMsQ0FBQztBQUN4Qiw2QkFBUyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztpQkFDNUI7O0FBRUQsb0JBQUksR0FBRyxFQUFFO0FBQ0wsNEJBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO2lCQUMzQjtBQUNELG9CQUFJLElBQUksRUFBRTtBQUNOLDRCQUFRLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztpQkFDbkM7YUFDSjs7QUFFRCxnQkFBUTttQkFBQSxrQkFBQyxJQUFJLEVBQUUsR0FBRyxFQUFFO0FBQ2hCLG9CQUFJLElBQUksSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLE1BQU0sQ0FBQyxVQUFVLEVBQUU7QUFDekMsd0JBQUksQ0FBQyxlQUFlLENBQ1osSUFBSSxDQUFDLElBQUksRUFDVCxJQUFJLENBQUMsR0FBRyxFQUNSLElBQUksQ0FBQyxTQUFTLEVBQ2QsSUFBSSxFQUNKLEdBQUcsQ0FBQyxDQUFDO2lCQUNoQjthQUNKOztBQUVELHFCQUFhO21CQUFBLHVCQUFDLElBQUksRUFBRSxNQUFNLEVBQUUsU0FBUyxFQUFFLG1CQUFtQixFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUU7O0FBRXZFLG9CQUFJLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssTUFBTSxDQUFDLFVBQVUsRUFBRTtBQUMxQywyQkFBTztpQkFDVjs7O0FBR0Qsb0JBQUksSUFBSSxDQUFDLElBQUksS0FBSyxPQUFPLEVBQUU7QUFDdkIsMkJBQU87aUJBQ1Y7O0FBRUQsb0JBQUksR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLElBQUksRUFBRSxJQUFJLEVBQUUsTUFBTSxJQUFJLFNBQVMsQ0FBQyxJQUFJLEVBQUUsU0FBUyxFQUFFLG1CQUFtQixFQUFFLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDO0FBQ2pILG9CQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztBQUMxQixvQkFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7YUFDekI7O0FBRUQsb0JBQVk7bUJBQUEsd0JBQUc7QUFDWCxvQkFBSSxPQUFPLENBQUM7QUFDWix1QkFBTyxHQUFHLElBQUksQ0FBQztBQUNmLG9CQUFJLENBQUMscUJBQXFCLEdBQUcsSUFBSSxDQUFDO0FBQ2xDLG1CQUFHO0FBQ0MsMkJBQU8sQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDO0FBQ3ZCLDJCQUFPLEdBQUcsT0FBTyxDQUFDLEtBQUssQ0FBQztpQkFDM0IsUUFBUSxPQUFPLEVBQUU7YUFDckI7O0FBRUQsb0JBQVk7bUJBQUEsd0JBQUc7QUFDWCxvQkFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUM7YUFDekI7O0FBRUQsa0JBQVU7bUJBQUEsc0JBQUc7QUFDVCx1QkFBTyxJQUFJLENBQUMsTUFBTSxLQUFLLElBQUksQ0FBQzthQUMvQjs7QUFRRCxlQUFPOzs7Ozs7Ozs7bUJBQUEsaUJBQUMsS0FBSyxFQUFFO0FBQ1gsb0JBQUksR0FBRyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUM7QUFDZixzQkFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsRUFBRSx5QkFBeUIsQ0FBQyxDQUFDO0FBQ3JELHNCQUFNLENBQUMsS0FBSyxDQUFDLElBQUksS0FBSyxNQUFNLENBQUMsVUFBVSxFQUFFLDhCQUE4QixDQUFDLENBQUM7QUFDekUscUJBQUssQ0FBQyxHQUFHLENBQUMsRUFBRSxFQUFFLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLENBQUMsRUFBRTtBQUNsRCx1QkFBRyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7QUFDekIsd0JBQUksR0FBRyxDQUFDLFVBQVUsS0FBSyxLQUFLLEVBQUU7QUFDMUIsK0JBQU8sR0FBRyxDQUFDO3FCQUNkO2lCQUNKO0FBQ0QsdUJBQU8sSUFBSSxDQUFDO2FBQ2Y7O0FBT0QsZ0JBQVE7Ozs7Ozs7O21CQUFBLG9CQUFHO0FBQ1AsdUJBQU8sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDO2FBQ3hCOztBQU9ELCtCQUF1Qjs7Ozs7Ozs7bUJBQUEsbUNBQUc7QUFDdEIsdUJBQU8sSUFBSSxDQUFDO2FBQ2Y7O0FBT0QsMEJBQWtCOzs7Ozs7OzttQkFBQSw4QkFBRztBQUNqQix1QkFBTyxJQUFJLENBQUM7YUFDZjs7QUFFRCxrQkFBVTttQkFBQSxvQkFBQyxJQUFJLEVBQUU7QUFDYixvQkFBSSxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsRUFBRTtBQUNwQiwyQkFBTyxJQUFJLENBQUM7aUJBQ2Y7QUFDRCxxQkFBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsRUFBRSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxFQUFFLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxDQUFDLEVBQUU7QUFDbkQsd0JBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxLQUFLLElBQUksRUFBRTtBQUMxQywrQkFBTyxJQUFJLENBQUM7cUJBQ2Y7aUJBQ0o7QUFDRCx1QkFBTyxLQUFLLENBQUM7YUFDaEI7Ozs7V0FyVGdCLEtBQUs7OztxQkFBTCxLQUFLOztJQXdUYixXQUFXLFdBQVgsV0FBVztBQUNULGFBREYsV0FBVyxDQUNSLFlBQVksRUFBRSxLQUFLLEVBQUU7OEJBRHhCLFdBQVc7O0FBRWhCLG1DQUZLLFdBQVcsNkNBRVYsWUFBWSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBRTtBQUNsRCxZQUFJLENBQUMsUUFBUSxHQUFHO0FBQ1osZUFBRyxFQUFFLElBQUksR0FBRyxFQUFFO0FBQ2QscUJBQVMsRUFBRSxFQUFFOzs7Ozs7QUFNYixnQkFBSSxFQUFFLEVBQUU7U0FDWCxDQUFDO0tBQ0w7O2NBYlEsV0FBVzs7aUJBQVgsV0FBVztBQWVwQixlQUFPO21CQUFBLGlCQUFDLFlBQVksRUFBRTtBQUNsQixvQkFBSSxRQUFRLEdBQUcsRUFBRSxDQUFDO0FBQ2xCLHFCQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxFQUFFLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEVBQUUsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLENBQUMsRUFBRTtBQUNsRCx3QkFBSSxHQUFHLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUN6Qix3QkFBSSxHQUFHLENBQUMscUJBQXFCLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFO0FBQ2pFLGdDQUFRLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO3FCQUM1QztpQkFDSjs7O0FBR0QscUJBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLEVBQUUsR0FBRyxRQUFRLENBQUMsTUFBTSxFQUFFLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxDQUFDLEVBQUU7QUFDL0Msd0JBQUksSUFBSSxHQUFHLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUN2Qix3QkFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxPQUFPLEVBQzFCLElBQUksVUFBVSxDQUNWLFFBQVEsQ0FBQyxzQkFBc0IsRUFDL0IsSUFBSSxDQUFDLE9BQU8sRUFDWixJQUFJLENBQUMsSUFBSSxFQUNULElBQUksRUFDSixJQUFJLEVBQ0osSUFBSSxDQUNQLENBQUMsQ0FBQztpQkFFZDs7QUFFRCxvQkFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQzs7QUFFakMsa0RBekNLLFdBQVcseUNBeUNLLFlBQVksRUFBRTthQUN0Qzs7QUFFRCx3QkFBZ0I7bUJBQUEsMEJBQUMsSUFBSSxFQUFFLEdBQUcsRUFBRTtBQUN4QixvQkFBSSxJQUFJLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxNQUFNLENBQUMsVUFBVSxFQUFFO0FBQ3pDLHdCQUFJLENBQUMsZUFBZSxDQUNaLElBQUksQ0FBQyxJQUFJLEVBQ1QsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQ2pCLElBQUksQ0FBQyxRQUFRLENBQUMsU0FBUyxFQUN2QixJQUFJLEVBQ0osR0FBRyxDQUFDLENBQUM7aUJBQ2hCO2FBQ0o7Ozs7V0FyRFEsV0FBVztHQUFTLEtBQUs7O0lBd0R6QixXQUFXLFdBQVgsV0FBVztBQUNULGFBREYsV0FBVyxDQUNSLFlBQVksRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFOzhCQURwQyxXQUFXOztBQUVoQixtQ0FGSyxXQUFXLDZDQUVWLFlBQVksRUFBRSxRQUFRLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxLQUFLLEVBQUU7S0FDM0Q7O2NBSFEsV0FBVzs7V0FBWCxXQUFXO0dBQVMsS0FBSzs7SUFNekIsMkJBQTJCLFdBQTNCLDJCQUEyQjtBQUN6QixhQURGLDJCQUEyQixDQUN4QixZQUFZLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRTs4QkFEcEMsMkJBQTJCOztBQUVoQyxtQ0FGSywyQkFBMkIsNkNBRTFCLFlBQVksRUFBRSwwQkFBMEIsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBRTtBQUMxRSxZQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxFQUFFLEVBQ2QsSUFBSSxVQUFVLENBQ1YsUUFBUSxDQUFDLFlBQVksRUFDckIsS0FBSyxDQUFDLEVBQUUsRUFDUixLQUFLLEVBQ0wsSUFBSSxFQUNKLElBQUksRUFDSixJQUFJLENBQ1AsQ0FBQyxDQUFDO0FBQ1gsWUFBSSxDQUFDLHVCQUF1QixHQUFHLElBQUksQ0FBQztLQUN2Qzs7Y0FiUSwyQkFBMkI7O1dBQTNCLDJCQUEyQjtHQUFTLEtBQUs7O0lBZ0J6QyxVQUFVLFdBQVYsVUFBVTtBQUNSLGFBREYsVUFBVSxDQUNQLFlBQVksRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFOzhCQURwQyxVQUFVOztBQUVmLG1DQUZLLFVBQVUsNkNBRVQsWUFBWSxFQUFFLE9BQU8sRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBRTtLQUMxRDs7Y0FIUSxVQUFVOztXQUFWLFVBQVU7R0FBUyxLQUFLOztJQU14QixTQUFTLFdBQVQsU0FBUztBQUNQLGFBREYsU0FBUyxDQUNOLFlBQVksRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFOzhCQURwQyxTQUFTOztBQUVkLG1DQUZLLFNBQVMsNkNBRVIsWUFBWSxFQUFFLE1BQU0sRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBRTtLQUN6RDs7Y0FIUSxTQUFTOztpQkFBVCxTQUFTO0FBS2xCLGVBQU87bUJBQUEsaUJBQUMsWUFBWSxFQUFFO0FBQ2xCLG9CQUFJLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxZQUFZLENBQUMsRUFBRTtBQUM1QyxzREFQQyxTQUFTLHlDQU9XLFlBQVksRUFBRTtpQkFDdEM7O0FBRUQscUJBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLEVBQUUsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sRUFBRSxDQUFDLEdBQUcsRUFBRSxFQUFFLEVBQUUsQ0FBQyxFQUFFO0FBQ2xELHdCQUFJLEdBQUcsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQ3pCLHVCQUFHLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQztBQUNuQix3QkFBSSxDQUFDLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxDQUFDO2lCQUNwQztBQUNELG9CQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQzs7QUFFbkIsdUJBQU8sSUFBSSxDQUFDLEtBQUssQ0FBQzthQUNyQjs7OztXQWxCUSxTQUFTO0dBQVMsS0FBSzs7SUFxQnZCLFFBQVEsV0FBUixRQUFRO0FBQ04sYUFERixRQUFRLENBQ0wsWUFBWSxFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUU7OEJBRHBDLFFBQVE7O0FBRWIsbUNBRkssUUFBUSw2Q0FFUCxZQUFZLEVBQUUsS0FBSyxFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsS0FBSyxFQUFFO0tBQ3hEOztjQUhRLFFBQVE7O1dBQVIsUUFBUTtHQUFTLEtBQUs7O0lBTXRCLFVBQVUsV0FBVixVQUFVO0FBQ1IsYUFERixVQUFVLENBQ1AsWUFBWSxFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUU7OEJBRHBDLFVBQVU7O0FBRWYsbUNBRkssVUFBVSw2Q0FFVCxZQUFZLEVBQUUsT0FBTyxFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsS0FBSyxFQUFFO0tBQzFEOztjQUhRLFVBQVU7O1dBQVYsVUFBVTtHQUFTLEtBQUs7O0lBTXhCLFdBQVcsV0FBWCxXQUFXO0FBQ1QsYUFERixXQUFXLENBQ1IsWUFBWSxFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUU7OEJBRHBDLFdBQVc7O0FBRWhCLG1DQUZLLFdBQVcsNkNBRVYsWUFBWSxFQUFFLFFBQVEsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBRTtLQUMzRDs7Y0FIUSxXQUFXOztXQUFYLFdBQVc7R0FBUyxLQUFLOztJQU16QixhQUFhLFdBQWIsYUFBYTtBQUNYLGFBREYsYUFBYSxDQUNWLFlBQVksRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLGtCQUFrQixFQUFFOzhCQUR4RCxhQUFhOztBQUVsQixtQ0FGSyxhQUFhLDZDQUVaLFlBQVksRUFBRSxVQUFVLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxrQkFBa0IsRUFBRTs7OztBQUl2RSxZQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxLQUFLLE1BQU0sQ0FBQyx1QkFBdUIsRUFBRTtBQUNwRCxnQkFBSSxDQUFDLGlCQUFpQixFQUFFLENBQUM7U0FDNUI7S0FDSjs7Y0FUUSxhQUFhOztpQkFBYixhQUFhO0FBV3RCLCtCQUF1QjttQkFBQSxtQ0FBRzs7Ozs7Ozs7O0FBU3RCLG9CQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxLQUFLLE1BQU0sQ0FBQyx1QkFBdUIsRUFBRTtBQUNwRCwyQkFBTyxLQUFLLENBQUM7aUJBQ2hCOztBQUVELG9CQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxFQUFFO0FBQ2xCLDJCQUFPLElBQUksQ0FBQztpQkFDZjs7QUFFRCxvQkFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsV0FBVyxDQUFDLENBQUM7QUFDekMsc0JBQU0sQ0FBQyxRQUFRLEVBQUUsaUNBQWlDLENBQUMsQ0FBQztBQUNwRCx1QkFBTyxRQUFRLENBQUMsT0FBTyxJQUFJLFFBQVEsQ0FBQyxVQUFVLENBQUMsTUFBTSxLQUFNLENBQUMsQ0FBQzthQUNoRTs7QUFFRCwwQkFBa0I7bUJBQUEsOEJBQUc7QUFDakIsb0JBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLEVBQUU7QUFDbEIsMkJBQU8sSUFBSSxDQUFDO2lCQUNmO0FBQ0QsdUJBQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQzthQUN6Qjs7QUFFRCx5QkFBaUI7bUJBQUEsNkJBQUc7QUFDaEIsb0JBQUksQ0FBQyxlQUFlLENBQ1osV0FBVyxFQUNYLElBQUksQ0FBQyxHQUFHLEVBQ1IsSUFBSSxDQUFDLFNBQVMsRUFDZCxJQUFJLEVBQ0osSUFBSSxDQUFDLENBQUM7QUFDZCxvQkFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxDQUFDO2FBQ3RDOzs7O1dBaERRLGFBQWE7R0FBUyxLQUFLOztJQW1EM0IsUUFBUSxXQUFSLFFBQVE7QUFDTixhQURGLFFBQVEsQ0FDTCxZQUFZLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRTs4QkFEcEMsUUFBUTs7QUFFYixtQ0FGSyxRQUFRLDZDQUVQLFlBQVksRUFBRSxLQUFLLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxLQUFLLEVBQUU7S0FDeEQ7O2NBSFEsUUFBUTs7V0FBUixRQUFRO0dBQVMsS0FBSzs7SUFNdEIsVUFBVSxXQUFWLFVBQVU7QUFDUixhQURGLFVBQVUsQ0FDUCxZQUFZLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRTs4QkFEcEMsVUFBVTs7QUFFZixtQ0FGSyxVQUFVLDZDQUVULFlBQVksRUFBRSxPQUFPLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxLQUFLLEVBQUU7S0FDMUQ7O2NBSFEsVUFBVTs7V0FBVixVQUFVO0dBQVMsS0FBSyIsImZpbGUiOiJzY29wZS5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG4gIENvcHlyaWdodCAoQykgMjAxNSBZdXN1a2UgU3V6dWtpIDx1dGF0YW5lLnRlYUBnbWFpbC5jb20+XG5cbiAgUmVkaXN0cmlidXRpb24gYW5kIHVzZSBpbiBzb3VyY2UgYW5kIGJpbmFyeSBmb3Jtcywgd2l0aCBvciB3aXRob3V0XG4gIG1vZGlmaWNhdGlvbiwgYXJlIHBlcm1pdHRlZCBwcm92aWRlZCB0aGF0IHRoZSBmb2xsb3dpbmcgY29uZGl0aW9ucyBhcmUgbWV0OlxuXG4gICAgKiBSZWRpc3RyaWJ1dGlvbnMgb2Ygc291cmNlIGNvZGUgbXVzdCByZXRhaW4gdGhlIGFib3ZlIGNvcHlyaWdodFxuICAgICAgbm90aWNlLCB0aGlzIGxpc3Qgb2YgY29uZGl0aW9ucyBhbmQgdGhlIGZvbGxvd2luZyBkaXNjbGFpbWVyLlxuICAgICogUmVkaXN0cmlidXRpb25zIGluIGJpbmFyeSBmb3JtIG11c3QgcmVwcm9kdWNlIHRoZSBhYm92ZSBjb3B5cmlnaHRcbiAgICAgIG5vdGljZSwgdGhpcyBsaXN0IG9mIGNvbmRpdGlvbnMgYW5kIHRoZSBmb2xsb3dpbmcgZGlzY2xhaW1lciBpbiB0aGVcbiAgICAgIGRvY3VtZW50YXRpb24gYW5kL29yIG90aGVyIG1hdGVyaWFscyBwcm92aWRlZCB3aXRoIHRoZSBkaXN0cmlidXRpb24uXG5cbiAgVEhJUyBTT0ZUV0FSRSBJUyBQUk9WSURFRCBCWSBUSEUgQ09QWVJJR0hUIEhPTERFUlMgQU5EIENPTlRSSUJVVE9SUyBcIkFTIElTXCJcbiAgQU5EIEFOWSBFWFBSRVNTIE9SIElNUExJRUQgV0FSUkFOVElFUywgSU5DTFVESU5HLCBCVVQgTk9UIExJTUlURUQgVE8sIFRIRVxuICBJTVBMSUVEIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZIEFORCBGSVRORVNTIEZPUiBBIFBBUlRJQ1VMQVIgUFVSUE9TRVxuICBBUkUgRElTQ0xBSU1FRC4gSU4gTk8gRVZFTlQgU0hBTEwgPENPUFlSSUdIVCBIT0xERVI+IEJFIExJQUJMRSBGT1IgQU5ZXG4gIERJUkVDVCwgSU5ESVJFQ1QsIElOQ0lERU5UQUwsIFNQRUNJQUwsIEVYRU1QTEFSWSwgT1IgQ09OU0VRVUVOVElBTCBEQU1BR0VTXG4gIChJTkNMVURJTkcsIEJVVCBOT1QgTElNSVRFRCBUTywgUFJPQ1VSRU1FTlQgT0YgU1VCU1RJVFVURSBHT09EUyBPUiBTRVJWSUNFUztcbiAgTE9TUyBPRiBVU0UsIERBVEEsIE9SIFBST0ZJVFM7IE9SIEJVU0lORVNTIElOVEVSUlVQVElPTikgSE9XRVZFUiBDQVVTRUQgQU5EXG4gIE9OIEFOWSBUSEVPUlkgT0YgTElBQklMSVRZLCBXSEVUSEVSIElOIENPTlRSQUNULCBTVFJJQ1QgTElBQklMSVRZLCBPUiBUT1JUXG4gIChJTkNMVURJTkcgTkVHTElHRU5DRSBPUiBPVEhFUldJU0UpIEFSSVNJTkcgSU4gQU5ZIFdBWSBPVVQgT0YgVEhFIFVTRSBPRlxuICBUSElTIFNPRlRXQVJFLCBFVkVOIElGIEFEVklTRUQgT0YgVEhFIFBPU1NJQklMSVRZIE9GIFNVQ0ggREFNQUdFLlxuKi9cblxuaW1wb3J0IHsgU3ludGF4IH0gZnJvbSAnZXN0cmF2ZXJzZSc7XG5pbXBvcnQgTWFwIGZyb20gJ2VzNi1tYXAnO1xuXG5pbXBvcnQgUmVmZXJlbmNlIGZyb20gJy4vcmVmZXJlbmNlJztcbmltcG9ydCBWYXJpYWJsZSBmcm9tICcuL3ZhcmlhYmxlJztcbmltcG9ydCBEZWZpbml0aW9uIGZyb20gJy4vZGVmaW5pdGlvbic7XG5pbXBvcnQgYXNzZXJ0IGZyb20gJ2Fzc2VydCc7XG5cbmZ1bmN0aW9uIGlzU3RyaWN0U2NvcGUoc2NvcGUsIGJsb2NrLCBpc01ldGhvZERlZmluaXRpb24sIHVzZURpcmVjdGl2ZSkge1xuICAgIHZhciBib2R5LCBpLCBpeiwgc3RtdCwgZXhwcjtcblxuICAgIC8vIFdoZW4gdXBwZXIgc2NvcGUgaXMgZXhpc3RzIGFuZCBzdHJpY3QsIGlubmVyIHNjb3BlIGlzIGFsc28gc3RyaWN0LlxuICAgIGlmIChzY29wZS51cHBlciAmJiBzY29wZS51cHBlci5pc1N0cmljdCkge1xuICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICB9XG5cbiAgICAvLyBBcnJvd0Z1bmN0aW9uRXhwcmVzc2lvbidzIHNjb3BlIGlzIGFsd2F5cyBzdHJpY3Qgc2NvcGUuXG4gICAgaWYgKGJsb2NrLnR5cGUgPT09IFN5bnRheC5BcnJvd0Z1bmN0aW9uRXhwcmVzc2lvbikge1xuICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICB9XG5cbiAgICBpZiAoaXNNZXRob2REZWZpbml0aW9uKSB7XG4gICAgICAgIHJldHVybiB0cnVlO1xuICAgIH1cblxuICAgIGlmIChzY29wZS50eXBlID09PSAnY2xhc3MnIHx8IHNjb3BlLnR5cGUgPT09ICdtb2R1bGUnKSB7XG4gICAgICAgIHJldHVybiB0cnVlO1xuICAgIH1cblxuICAgIGlmIChzY29wZS50eXBlID09PSAnYmxvY2snIHx8IHNjb3BlLnR5cGUgPT09ICdzd2l0Y2gnKSB7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG5cbiAgICBpZiAoc2NvcGUudHlwZSA9PT0gJ2Z1bmN0aW9uJykge1xuICAgICAgICBpZiAoYmxvY2sudHlwZSA9PT0gJ1Byb2dyYW0nKSB7XG4gICAgICAgICAgICBib2R5ID0gYmxvY2s7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBib2R5ID0gYmxvY2suYm9keTtcbiAgICAgICAgfVxuICAgIH0gZWxzZSBpZiAoc2NvcGUudHlwZSA9PT0gJ2dsb2JhbCcpIHtcbiAgICAgICAgYm9keSA9IGJsb2NrO1xuICAgIH0gZWxzZSB7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG5cbiAgICAvLyBTZWFyY2ggJ3VzZSBzdHJpY3QnIGRpcmVjdGl2ZS5cbiAgICBpZiAodXNlRGlyZWN0aXZlKSB7XG4gICAgICAgIGZvciAoaSA9IDAsIGl6ID0gYm9keS5ib2R5Lmxlbmd0aDsgaSA8IGl6OyArK2kpIHtcbiAgICAgICAgICAgIHN0bXQgPSBib2R5LmJvZHlbaV07XG4gICAgICAgICAgICBpZiAoc3RtdC50eXBlICE9PSAnRGlyZWN0aXZlU3RhdGVtZW50Jykge1xuICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHN0bXQucmF3ID09PSAnXCJ1c2Ugc3RyaWN0XCInIHx8IHN0bXQucmF3ID09PSAnXFwndXNlIHN0cmljdFxcJycpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICAgIGZvciAoaSA9IDAsIGl6ID0gYm9keS5ib2R5Lmxlbmd0aDsgaSA8IGl6OyArK2kpIHtcbiAgICAgICAgICAgIHN0bXQgPSBib2R5LmJvZHlbaV07XG4gICAgICAgICAgICBpZiAoc3RtdC50eXBlICE9PSBTeW50YXguRXhwcmVzc2lvblN0YXRlbWVudCkge1xuICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgZXhwciA9IHN0bXQuZXhwcmVzc2lvbjtcbiAgICAgICAgICAgIGlmIChleHByLnR5cGUgIT09IFN5bnRheC5MaXRlcmFsIHx8IHR5cGVvZiBleHByLnZhbHVlICE9PSAnc3RyaW5nJykge1xuICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKGV4cHIucmF3ICE9IG51bGwpIHtcbiAgICAgICAgICAgICAgICBpZiAoZXhwci5yYXcgPT09ICdcInVzZSBzdHJpY3RcIicgfHwgZXhwci5yYXcgPT09ICdcXCd1c2Ugc3RyaWN0XFwnJykge1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIGlmIChleHByLnZhbHVlID09PSAndXNlIHN0cmljdCcpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgfVxuICAgIHJldHVybiBmYWxzZTtcbn1cblxuZnVuY3Rpb24gcmVnaXN0ZXJTY29wZShzY29wZU1hbmFnZXIsIHNjb3BlKSB7XG4gICAgdmFyIHNjb3BlcztcblxuICAgIHNjb3BlTWFuYWdlci5zY29wZXMucHVzaChzY29wZSk7XG5cbiAgICBzY29wZXMgPSBzY29wZU1hbmFnZXIuX19ub2RlVG9TY29wZS5nZXQoc2NvcGUuYmxvY2spO1xuICAgIGlmIChzY29wZXMpIHtcbiAgICAgICAgc2NvcGVzLnB1c2goc2NvcGUpO1xuICAgIH0gZWxzZSB7XG4gICAgICAgIHNjb3BlTWFuYWdlci5fX25vZGVUb1Njb3BlLnNldChzY29wZS5ibG9jaywgWyBzY29wZSBdKTtcbiAgICB9XG59XG5cbmZ1bmN0aW9uIHNob3VsZEJlU3RhdGljYWxseShkZWYpIHtcbiAgICByZXR1cm4gKFxuICAgICAgICAoZGVmLnR5cGUgPT09IFZhcmlhYmxlLkNsYXNzTmFtZSkgfHxcbiAgICAgICAgKGRlZi50eXBlID09PSBWYXJpYWJsZS5WYXJpYWJsZSAmJiBkZWYucGFyZW50LmtpbmQgIT09IFwidmFyXCIpXG4gICAgKTtcbn1cblxuLyoqXG4gKiBAY2xhc3MgU2NvcGVcbiAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU2NvcGUge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlTWFuYWdlciwgdHlwZSwgdXBwZXJTY29wZSwgYmxvY2ssIGlzTWV0aG9kRGVmaW5pdGlvbikge1xuICAgICAgICAvKipcbiAgICAgICAgICogT25lIG9mICdURFonLCAnbW9kdWxlJywgJ2Jsb2NrJywgJ3N3aXRjaCcsICdmdW5jdGlvbicsICdjYXRjaCcsICd3aXRoJywgJ2Z1bmN0aW9uJywgJ2NsYXNzJywgJ2dsb2JhbCcuXG4gICAgICAgICAqIEBtZW1iZXIge1N0cmluZ30gU2NvcGUjdHlwZVxuICAgICAgICAgKi9cbiAgICAgICAgdGhpcy50eXBlID0gdHlwZTtcbiAgICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgc2NvcGVkIHtAbGluayBWYXJpYWJsZX1zIG9mIHRoaXMgc2NvcGUsIGFzIDxjb2RlPnsgVmFyaWFibGUubmFtZVxuICAgICAgICAgKiA6IFZhcmlhYmxlIH08L2NvZGU+LlxuICAgICAgICAgKiBAbWVtYmVyIHtNYXB9IFNjb3BlI3NldFxuICAgICAgICAgKi9cbiAgICAgICAgdGhpcy5zZXQgPSBuZXcgTWFwKCk7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgdGFpbnRlZCB2YXJpYWJsZXMgb2YgdGhpcyBzY29wZSwgYXMgPGNvZGU+eyBWYXJpYWJsZS5uYW1lIDpcbiAgICAgICAgICogYm9vbGVhbiB9PC9jb2RlPi5cbiAgICAgICAgICogQG1lbWJlciB7TWFwfSBTY29wZSN0YWludHMgKi9cbiAgICAgICAgdGhpcy50YWludHMgPSBuZXcgTWFwKCk7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBHZW5lcmFsbHksIHRocm91Z2ggdGhlIGxleGljYWwgc2NvcGluZyBvZiBKUyB5b3UgY2FuIGFsd2F5cyBrbm93XG4gICAgICAgICAqIHdoaWNoIHZhcmlhYmxlIGFuIGlkZW50aWZpZXIgaW4gdGhlIHNvdXJjZSBjb2RlIHJlZmVycyB0by4gVGhlcmUgYXJlXG4gICAgICAgICAqIGEgZmV3IGV4Y2VwdGlvbnMgdG8gdGhpcyBydWxlLiBXaXRoICdnbG9iYWwnIGFuZCAnd2l0aCcgc2NvcGVzIHlvdVxuICAgICAgICAgKiBjYW4gb25seSBkZWNpZGUgYXQgcnVudGltZSB3aGljaCB2YXJpYWJsZSBhIHJlZmVyZW5jZSByZWZlcnMgdG8uXG4gICAgICAgICAqIE1vcmVvdmVyLCBpZiAnZXZhbCgpJyBpcyB1c2VkIGluIGEgc2NvcGUsIGl0IG1pZ2h0IGludHJvZHVjZSBuZXdcbiAgICAgICAgICogYmluZGluZ3MgaW4gdGhpcyBvciBpdHMgcHJhcmVudCBzY29wZXMuXG4gICAgICAgICAqIEFsbCB0aG9zZSBzY29wZXMgYXJlIGNvbnNpZGVyZWQgJ2R5bmFtaWMnLlxuICAgICAgICAgKiBAbWVtYmVyIHtib29sZWFufSBTY29wZSNkeW5hbWljXG4gICAgICAgICAqL1xuICAgICAgICB0aGlzLmR5bmFtaWMgPSB0aGlzLnR5cGUgPT09ICdnbG9iYWwnIHx8IHRoaXMudHlwZSA9PT0gJ3dpdGgnO1xuICAgICAgICAvKipcbiAgICAgICAgICogQSByZWZlcmVuY2UgdG8gdGhlIHNjb3BlLWRlZmluaW5nIHN5bnRheCBub2RlLlxuICAgICAgICAgKiBAbWVtYmVyIHtlc3ByaW1hLk5vZGV9IFNjb3BlI2Jsb2NrXG4gICAgICAgICAqL1xuICAgICAgICB0aGlzLmJsb2NrID0gYmxvY2s7XG4gICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHtAbGluayBSZWZlcmVuY2V8cmVmZXJlbmNlc30gdGhhdCBhcmUgbm90IHJlc29sdmVkIHdpdGggdGhpcyBzY29wZS5cbiAgICAgICAgICogQG1lbWJlciB7UmVmZXJlbmNlW119IFNjb3BlI3Rocm91Z2hcbiAgICAgICAgICovXG4gICAgICAgIHRoaXMudGhyb3VnaCA9IFtdO1xuICAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBzY29wZWQge0BsaW5rIFZhcmlhYmxlfXMgb2YgdGhpcyBzY29wZS4gSW4gdGhlIGNhc2Ugb2YgYVxuICAgICAgICAgKiAnZnVuY3Rpb24nIHNjb3BlIHRoaXMgaW5jbHVkZXMgdGhlIGF1dG9tYXRpYyBhcmd1bWVudCA8ZW0+YXJndW1lbnRzPC9lbT4gYXNcbiAgICAgICAgICogaXRzIGZpcnN0IGVsZW1lbnQsIGFzIHdlbGwgYXMgYWxsIGZ1cnRoZXIgZm9ybWFsIGFyZ3VtZW50cy5cbiAgICAgICAgICogQG1lbWJlciB7VmFyaWFibGVbXX0gU2NvcGUjdmFyaWFibGVzXG4gICAgICAgICAqL1xuICAgICAgICB0aGlzLnZhcmlhYmxlcyA9IFtdO1xuICAgICAgICAgLyoqXG4gICAgICAgICAqIEFueSB2YXJpYWJsZSB7QGxpbmsgUmVmZXJlbmNlfHJlZmVyZW5jZX0gZm91bmQgaW4gdGhpcyBzY29wZS4gVGhpc1xuICAgICAgICAgKiBpbmNsdWRlcyBvY2N1cnJlbmNlcyBvZiBsb2NhbCB2YXJpYWJsZXMgYXMgd2VsbCBhcyB2YXJpYWJsZXMgZnJvbVxuICAgICAgICAgKiBwYXJlbnQgc2NvcGVzIChpbmNsdWRpbmcgdGhlIGdsb2JhbCBzY29wZSkuIEZvciBsb2NhbCB2YXJpYWJsZXNcbiAgICAgICAgICogdGhpcyBhbHNvIGluY2x1ZGVzIGRlZmluaW5nIG9jY3VycmVuY2VzIChsaWtlIGluIGEgJ3Zhcicgc3RhdGVtZW50KS5cbiAgICAgICAgICogSW4gYSAnZnVuY3Rpb24nIHNjb3BlIHRoaXMgZG9lcyBub3QgaW5jbHVkZSB0aGUgb2NjdXJyZW5jZXMgb2YgdGhlXG4gICAgICAgICAqIGZvcm1hbCBwYXJhbWV0ZXIgaW4gdGhlIHBhcmFtZXRlciBsaXN0LlxuICAgICAgICAgKiBAbWVtYmVyIHtSZWZlcmVuY2VbXX0gU2NvcGUjcmVmZXJlbmNlc1xuICAgICAgICAgKi9cbiAgICAgICAgdGhpcy5yZWZlcmVuY2VzID0gW107XG5cbiAgICAgICAgIC8qKlxuICAgICAgICAgKiBGb3IgJ2dsb2JhbCcgYW5kICdmdW5jdGlvbicgc2NvcGVzLCB0aGlzIGlzIGEgc2VsZi1yZWZlcmVuY2UuIEZvclxuICAgICAgICAgKiBvdGhlciBzY29wZSB0eXBlcyB0aGlzIGlzIHRoZSA8ZW0+dmFyaWFibGVTY29wZTwvZW0+IHZhbHVlIG9mIHRoZVxuICAgICAgICAgKiBwYXJlbnQgc2NvcGUuXG4gICAgICAgICAqIEBtZW1iZXIge1Njb3BlfSBTY29wZSN2YXJpYWJsZVNjb3BlXG4gICAgICAgICAqL1xuICAgICAgICB0aGlzLnZhcmlhYmxlU2NvcGUgPVxuICAgICAgICAgICAgKHRoaXMudHlwZSA9PT0gJ2dsb2JhbCcgfHwgdGhpcy50eXBlID09PSAnZnVuY3Rpb24nIHx8IHRoaXMudHlwZSA9PT0gJ21vZHVsZScpID8gdGhpcyA6IHVwcGVyU2NvcGUudmFyaWFibGVTY29wZTtcbiAgICAgICAgIC8qKlxuICAgICAgICAgKiBXaGV0aGVyIHRoaXMgc2NvcGUgaXMgY3JlYXRlZCBieSBhIEZ1bmN0aW9uRXhwcmVzc2lvbi5cbiAgICAgICAgICogQG1lbWJlciB7Ym9vbGVhbn0gU2NvcGUjZnVuY3Rpb25FeHByZXNzaW9uU2NvcGVcbiAgICAgICAgICovXG4gICAgICAgIHRoaXMuZnVuY3Rpb25FeHByZXNzaW9uU2NvcGUgPSBmYWxzZTtcbiAgICAgICAgIC8qKlxuICAgICAgICAgKiBXaGV0aGVyIHRoaXMgaXMgYSBzY29wZSB0aGF0IGNvbnRhaW5zIGFuICdldmFsKCknIGludm9jYXRpb24uXG4gICAgICAgICAqIEBtZW1iZXIge2Jvb2xlYW59IFNjb3BlI2RpcmVjdENhbGxUb0V2YWxTY29wZVxuICAgICAgICAgKi9cbiAgICAgICAgdGhpcy5kaXJlY3RDYWxsVG9FdmFsU2NvcGUgPSBmYWxzZTtcbiAgICAgICAgIC8qKlxuICAgICAgICAgKiBAbWVtYmVyIHtib29sZWFufSBTY29wZSN0aGlzRm91bmRcbiAgICAgICAgICovXG4gICAgICAgIHRoaXMudGhpc0ZvdW5kID0gZmFsc2U7XG5cbiAgICAgICAgdGhpcy5fX2xlZnQgPSBbXTtcblxuICAgICAgICAgLyoqXG4gICAgICAgICAqIFJlZmVyZW5jZSB0byB0aGUgcGFyZW50IHtAbGluayBTY29wZXxzY29wZX0uXG4gICAgICAgICAqIEBtZW1iZXIge1Njb3BlfSBTY29wZSN1cHBlclxuICAgICAgICAgKi9cbiAgICAgICAgdGhpcy51cHBlciA9IHVwcGVyU2NvcGU7XG4gICAgICAgICAvKipcbiAgICAgICAgICogV2hldGhlciAndXNlIHN0cmljdCcgaXMgaW4gZWZmZWN0IGluIHRoaXMgc2NvcGUuXG4gICAgICAgICAqIEBtZW1iZXIge2Jvb2xlYW59IFNjb3BlI2lzU3RyaWN0XG4gICAgICAgICAqL1xuICAgICAgICB0aGlzLmlzU3RyaWN0ID0gaXNTdHJpY3RTY29wZSh0aGlzLCBibG9jaywgaXNNZXRob2REZWZpbml0aW9uLCBzY29wZU1hbmFnZXIuX191c2VEaXJlY3RpdmUoKSk7XG5cbiAgICAgICAgIC8qKlxuICAgICAgICAgKiBMaXN0IG9mIG5lc3RlZCB7QGxpbmsgU2NvcGV9cy5cbiAgICAgICAgICogQG1lbWJlciB7U2NvcGVbXX0gU2NvcGUjY2hpbGRTY29wZXNcbiAgICAgICAgICovXG4gICAgICAgIHRoaXMuY2hpbGRTY29wZXMgPSBbXTtcbiAgICAgICAgaWYgKHRoaXMudXBwZXIpIHtcbiAgICAgICAgICAgIHRoaXMudXBwZXIuY2hpbGRTY29wZXMucHVzaCh0aGlzKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHJlZ2lzdGVyU2NvcGUoc2NvcGVNYW5hZ2VyLCB0aGlzKTtcbiAgICB9XG5cbiAgICBfX3Nob3VsZFN0YXRpY2FsbHlDbG9zZShzY29wZU1hbmFnZXIpIHtcbiAgICAgICAgcmV0dXJuICghdGhpcy5keW5hbWljIHx8IHNjb3BlTWFuYWdlci5fX2lzT3B0aW1pc3RpYygpKTtcbiAgICB9XG5cbiAgICBfX3Nob3VsZFN0YXRpY2FsbHlDbG9zZUZvckdsb2JhbChyZWYpIHtcbiAgICAgICAgLy8gT24gZ2xvYmFsIHNjb3BlLCBsZXQvY29uc3QvY2xhc3MgZGVjbGFyYXRpb25zIHNob3VsZCBiZSByZXNvbHZlZCBzdGF0aWNhbGx5LlxuICAgICAgICB2YXIgbmFtZSA9IHJlZi5pZGVudGlmaWVyLm5hbWU7XG4gICAgICAgIGlmICghdGhpcy5zZXQuaGFzKG5hbWUpKSB7XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cblxuICAgICAgICB2YXIgdmFyaWFibGUgPSB0aGlzLnNldC5nZXQobmFtZSk7XG4gICAgICAgIHZhciBkZWZzID0gdmFyaWFibGUuZGVmcztcbiAgICAgICAgcmV0dXJuIGRlZnMubGVuZ3RoID4gMCAmJiBkZWZzLmV2ZXJ5KHNob3VsZEJlU3RhdGljYWxseSk7XG4gICAgfVxuXG4gICAgX19zdGF0aWNDbG9zZVJlZihyZWYpIHtcbiAgICAgICAgaWYgKCF0aGlzLl9fcmVzb2x2ZShyZWYpKSB7XG4gICAgICAgICAgICB0aGlzLl9fZGVsZWdhdGVUb1VwcGVyU2NvcGUocmVmKTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIF9fZHluYW1pY0Nsb3NlUmVmKHJlZikge1xuICAgICAgICAvLyBub3RpZnkgYWxsIG5hbWVzIGFyZSB0aHJvdWdoIHRvIGdsb2JhbFxuICAgICAgICBsZXQgY3VycmVudCA9IHRoaXM7XG4gICAgICAgIGRvIHtcbiAgICAgICAgICAgIGN1cnJlbnQudGhyb3VnaC5wdXNoKHJlZik7XG4gICAgICAgICAgICBjdXJyZW50ID0gY3VycmVudC51cHBlcjtcbiAgICAgICAgfSB3aGlsZSAoY3VycmVudCk7XG4gICAgfVxuXG4gICAgX19nbG9iYWxDbG9zZVJlZihyZWYpIHtcbiAgICAgICAgLy8gbGV0L2NvbnN0L2NsYXNzIGRlY2xhcmF0aW9ucyBzaG91bGQgYmUgcmVzb2x2ZWQgc3RhdGljYWxseS5cbiAgICAgICAgLy8gb3RoZXJzIHNob3VsZCBiZSByZXNvbHZlZCBkeW5hbWljYWxseS5cbiAgICAgICAgaWYgKHRoaXMuX19zaG91bGRTdGF0aWNhbGx5Q2xvc2VGb3JHbG9iYWwocmVmKSkge1xuICAgICAgICAgICAgdGhpcy5fX3N0YXRpY0Nsb3NlUmVmKHJlZik7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICB0aGlzLl9fZHluYW1pY0Nsb3NlUmVmKHJlZik7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBfX2Nsb3NlKHNjb3BlTWFuYWdlcikge1xuICAgICAgICB2YXIgY2xvc2VSZWY7XG4gICAgICAgIGlmICh0aGlzLl9fc2hvdWxkU3RhdGljYWxseUNsb3NlKHNjb3BlTWFuYWdlcikpIHtcbiAgICAgICAgICAgIGNsb3NlUmVmID0gdGhpcy5fX3N0YXRpY0Nsb3NlUmVmO1xuICAgICAgICB9IGVsc2UgaWYgKHRoaXMudHlwZSAhPT0gJ2dsb2JhbCcpIHtcbiAgICAgICAgICAgIGNsb3NlUmVmID0gdGhpcy5fX2R5bmFtaWNDbG9zZVJlZjtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIGNsb3NlUmVmID0gdGhpcy5fX2dsb2JhbENsb3NlUmVmO1xuICAgICAgICB9XG5cbiAgICAgICAgLy8gVHJ5IFJlc29sdmluZyBhbGwgcmVmZXJlbmNlcyBpbiB0aGlzIHNjb3BlLlxuICAgICAgICBmb3IgKGxldCBpID0gMCwgaXogPSB0aGlzLl9fbGVmdC5sZW5ndGg7IGkgPCBpejsgKytpKSB7XG4gICAgICAgICAgICBsZXQgcmVmID0gdGhpcy5fX2xlZnRbaV07XG4gICAgICAgICAgICBjbG9zZVJlZi5jYWxsKHRoaXMsIHJlZik7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5fX2xlZnQgPSBudWxsO1xuXG4gICAgICAgIHJldHVybiB0aGlzLnVwcGVyO1xuICAgIH1cblxuICAgIF9fcmVzb2x2ZShyZWYpIHtcbiAgICAgICAgdmFyIHZhcmlhYmxlLCBuYW1lO1xuICAgICAgICBuYW1lID0gcmVmLmlkZW50aWZpZXIubmFtZTtcbiAgICAgICAgaWYgKHRoaXMuc2V0LmhhcyhuYW1lKSkge1xuICAgICAgICAgICAgdmFyaWFibGUgPSB0aGlzLnNldC5nZXQobmFtZSk7XG4gICAgICAgICAgICB2YXJpYWJsZS5yZWZlcmVuY2VzLnB1c2gocmVmKTtcbiAgICAgICAgICAgIHZhcmlhYmxlLnN0YWNrID0gdmFyaWFibGUuc3RhY2sgJiYgcmVmLmZyb20udmFyaWFibGVTY29wZSA9PT0gdGhpcy52YXJpYWJsZVNjb3BlO1xuICAgICAgICAgICAgaWYgKHJlZi50YWludGVkKSB7XG4gICAgICAgICAgICAgICAgdmFyaWFibGUudGFpbnRlZCA9IHRydWU7XG4gICAgICAgICAgICAgICAgdGhpcy50YWludHMuc2V0KHZhcmlhYmxlLm5hbWUsIHRydWUpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmVmLnJlc29sdmVkID0gdmFyaWFibGU7XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuXG4gICAgX19kZWxlZ2F0ZVRvVXBwZXJTY29wZShyZWYpIHtcbiAgICAgICAgaWYgKHRoaXMudXBwZXIpIHtcbiAgICAgICAgICAgIHRoaXMudXBwZXIuX19sZWZ0LnB1c2gocmVmKTtcbiAgICAgICAgfVxuICAgICAgICB0aGlzLnRocm91Z2gucHVzaChyZWYpO1xuICAgIH1cblxuICAgIF9fZGVmaW5lR2VuZXJpYyhuYW1lLCBzZXQsIHZhcmlhYmxlcywgbm9kZSwgZGVmKSB7XG4gICAgICAgIHZhciB2YXJpYWJsZTtcblxuICAgICAgICB2YXJpYWJsZSA9IHNldC5nZXQobmFtZSk7XG4gICAgICAgIGlmICghdmFyaWFibGUpIHtcbiAgICAgICAgICAgIHZhcmlhYmxlID0gbmV3IFZhcmlhYmxlKG5hbWUsIHRoaXMpO1xuICAgICAgICAgICAgc2V0LnNldChuYW1lLCB2YXJpYWJsZSk7XG4gICAgICAgICAgICB2YXJpYWJsZXMucHVzaCh2YXJpYWJsZSk7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoZGVmKSB7XG4gICAgICAgICAgICB2YXJpYWJsZS5kZWZzLnB1c2goZGVmKTtcbiAgICAgICAgfVxuICAgICAgICBpZiAobm9kZSkge1xuICAgICAgICAgICAgdmFyaWFibGUuaWRlbnRpZmllcnMucHVzaChub2RlKTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIF9fZGVmaW5lKG5vZGUsIGRlZikge1xuICAgICAgICBpZiAobm9kZSAmJiBub2RlLnR5cGUgPT09IFN5bnRheC5JZGVudGlmaWVyKSB7XG4gICAgICAgICAgICB0aGlzLl9fZGVmaW5lR2VuZXJpYyhcbiAgICAgICAgICAgICAgICAgICAgbm9kZS5uYW1lLFxuICAgICAgICAgICAgICAgICAgICB0aGlzLnNldCxcbiAgICAgICAgICAgICAgICAgICAgdGhpcy52YXJpYWJsZXMsXG4gICAgICAgICAgICAgICAgICAgIG5vZGUsXG4gICAgICAgICAgICAgICAgICAgIGRlZik7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBfX3JlZmVyZW5jaW5nKG5vZGUsIGFzc2lnbiwgd3JpdGVFeHByLCBtYXliZUltcGxpY2l0R2xvYmFsLCBwYXJ0aWFsLCBpbml0KSB7XG4gICAgICAgIC8vIGJlY2F1c2UgQXJyYXkgZWxlbWVudCBtYXkgYmUgbnVsbFxuICAgICAgICBpZiAoIW5vZGUgfHwgbm9kZS50eXBlICE9PSBTeW50YXguSWRlbnRpZmllcikge1xuICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG5cbiAgICAgICAgLy8gU3BlY2lhbGx5IGhhbmRsZSBsaWtlIGB0aGlzYC5cbiAgICAgICAgaWYgKG5vZGUubmFtZSA9PT0gJ3N1cGVyJykge1xuICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG5cbiAgICAgICAgbGV0IHJlZiA9IG5ldyBSZWZlcmVuY2Uobm9kZSwgdGhpcywgYXNzaWduIHx8IFJlZmVyZW5jZS5SRUFELCB3cml0ZUV4cHIsIG1heWJlSW1wbGljaXRHbG9iYWwsICEhcGFydGlhbCwgISFpbml0KTtcbiAgICAgICAgdGhpcy5yZWZlcmVuY2VzLnB1c2gocmVmKTtcbiAgICAgICAgdGhpcy5fX2xlZnQucHVzaChyZWYpO1xuICAgIH1cblxuICAgIF9fZGV0ZWN0RXZhbCgpIHtcbiAgICAgICAgdmFyIGN1cnJlbnQ7XG4gICAgICAgIGN1cnJlbnQgPSB0aGlzO1xuICAgICAgICB0aGlzLmRpcmVjdENhbGxUb0V2YWxTY29wZSA9IHRydWU7XG4gICAgICAgIGRvIHtcbiAgICAgICAgICAgIGN1cnJlbnQuZHluYW1pYyA9IHRydWU7XG4gICAgICAgICAgICBjdXJyZW50ID0gY3VycmVudC51cHBlcjtcbiAgICAgICAgfSB3aGlsZSAoY3VycmVudCk7XG4gICAgfVxuXG4gICAgX19kZXRlY3RUaGlzKCkge1xuICAgICAgICB0aGlzLnRoaXNGb3VuZCA9IHRydWU7XG4gICAgfVxuXG4gICAgX19pc0Nsb3NlZCgpIHtcbiAgICAgICAgcmV0dXJuIHRoaXMuX19sZWZ0ID09PSBudWxsO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIHJldHVybnMgcmVzb2x2ZWQge1JlZmVyZW5jZX1cbiAgICAgKiBAbWV0aG9kIFNjb3BlI3Jlc29sdmVcbiAgICAgKiBAcGFyYW0ge0VzcHJpbWEuSWRlbnRpZmllcn0gaWRlbnQgLSBpZGVudGlmaWVyIHRvIGJlIHJlc29sdmVkLlxuICAgICAqIEByZXR1cm4ge1JlZmVyZW5jZX1cbiAgICAgKi9cbiAgICByZXNvbHZlKGlkZW50KSB7XG4gICAgICAgIHZhciByZWYsIGksIGl6O1xuICAgICAgICBhc3NlcnQodGhpcy5fX2lzQ2xvc2VkKCksICdTY29wZSBzaG91bGQgYmUgY2xvc2VkLicpO1xuICAgICAgICBhc3NlcnQoaWRlbnQudHlwZSA9PT0gU3ludGF4LklkZW50aWZpZXIsICdUYXJnZXQgc2hvdWxkIGJlIGlkZW50aWZpZXIuJyk7XG4gICAgICAgIGZvciAoaSA9IDAsIGl6ID0gdGhpcy5yZWZlcmVuY2VzLmxlbmd0aDsgaSA8IGl6OyArK2kpIHtcbiAgICAgICAgICAgIHJlZiA9IHRoaXMucmVmZXJlbmNlc1tpXTtcbiAgICAgICAgICAgIGlmIChyZWYuaWRlbnRpZmllciA9PT0gaWRlbnQpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gcmVmO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiBudWxsO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIHJldHVybnMgdGhpcyBzY29wZSBpcyBzdGF0aWNcbiAgICAgKiBAbWV0aG9kIFNjb3BlI2lzU3RhdGljXG4gICAgICogQHJldHVybiB7Ym9vbGVhbn1cbiAgICAgKi9cbiAgICBpc1N0YXRpYygpIHtcbiAgICAgICAgcmV0dXJuICF0aGlzLmR5bmFtaWM7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogcmV0dXJucyB0aGlzIHNjb3BlIGhhcyBtYXRlcmlhbGl6ZWQgYXJndW1lbnRzXG4gICAgICogQG1ldGhvZCBTY29wZSNpc0FyZ3VtZW50c01hdGVyaWFsaXplZFxuICAgICAqIEByZXR1cm4ge2Jvb2xlYW59XG4gICAgICovXG4gICAgaXNBcmd1bWVudHNNYXRlcmlhbGl6ZWQoKSB7XG4gICAgICAgIHJldHVybiB0cnVlO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIHJldHVybnMgdGhpcyBzY29wZSBoYXMgbWF0ZXJpYWxpemVkIGB0aGlzYCByZWZlcmVuY2VcbiAgICAgKiBAbWV0aG9kIFNjb3BlI2lzVGhpc01hdGVyaWFsaXplZFxuICAgICAqIEByZXR1cm4ge2Jvb2xlYW59XG4gICAgICovXG4gICAgaXNUaGlzTWF0ZXJpYWxpemVkKCkge1xuICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICB9XG5cbiAgICBpc1VzZWROYW1lKG5hbWUpIHtcbiAgICAgICAgaWYgKHRoaXMuc2V0LmhhcyhuYW1lKSkge1xuICAgICAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgICAgIH1cbiAgICAgICAgZm9yICh2YXIgaSA9IDAsIGl6ID0gdGhpcy50aHJvdWdoLmxlbmd0aDsgaSA8IGl6OyArK2kpIHtcbiAgICAgICAgICAgIGlmICh0aGlzLnRocm91Z2hbaV0uaWRlbnRpZmllci5uYW1lID09PSBuYW1lKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbn1cblxuZXhwb3J0IGNsYXNzIEdsb2JhbFNjb3BlIGV4dGVuZHMgU2NvcGUge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlTWFuYWdlciwgYmxvY2spIHtcbiAgICAgICAgc3VwZXIoc2NvcGVNYW5hZ2VyLCAnZ2xvYmFsJywgbnVsbCwgYmxvY2ssIGZhbHNlKTtcbiAgICAgICAgdGhpcy5pbXBsaWNpdCA9IHtcbiAgICAgICAgICAgIHNldDogbmV3IE1hcCgpLFxuICAgICAgICAgICAgdmFyaWFibGVzOiBbXSxcbiAgICAgICAgICAgIC8qKlxuICAgICAgICAgICAgKiBMaXN0IG9mIHtAbGluayBSZWZlcmVuY2V9cyB0aGF0IGFyZSBsZWZ0IHRvIGJlIHJlc29sdmVkIChpLmUuIHdoaWNoXG4gICAgICAgICAgICAqIG5lZWQgdG8gYmUgbGlua2VkIHRvIHRoZSB2YXJpYWJsZSB0aGV5IHJlZmVyIHRvKS5cbiAgICAgICAgICAgICogQG1lbWJlciB7UmVmZXJlbmNlW119IFNjb3BlI2ltcGxpY2l0I2xlZnRcbiAgICAgICAgICAgICovXG4gICAgICAgICAgICBsZWZ0OiBbXVxuICAgICAgICB9O1xuICAgIH1cblxuICAgIF9fY2xvc2Uoc2NvcGVNYW5hZ2VyKSB7XG4gICAgICAgIGxldCBpbXBsaWNpdCA9IFtdO1xuICAgICAgICBmb3IgKGxldCBpID0gMCwgaXogPSB0aGlzLl9fbGVmdC5sZW5ndGg7IGkgPCBpejsgKytpKSB7XG4gICAgICAgICAgICBsZXQgcmVmID0gdGhpcy5fX2xlZnRbaV07XG4gICAgICAgICAgICBpZiAocmVmLl9fbWF5YmVJbXBsaWNpdEdsb2JhbCAmJiAhdGhpcy5zZXQuaGFzKHJlZi5pZGVudGlmaWVyLm5hbWUpKSB7XG4gICAgICAgICAgICAgICAgaW1wbGljaXQucHVzaChyZWYuX19tYXliZUltcGxpY2l0R2xvYmFsKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIC8vIGNyZWF0ZSBhbiBpbXBsaWNpdCBnbG9iYWwgdmFyaWFibGUgZnJvbSBhc3NpZ25tZW50IGV4cHJlc3Npb25cbiAgICAgICAgZm9yIChsZXQgaSA9IDAsIGl6ID0gaW1wbGljaXQubGVuZ3RoOyBpIDwgaXo7ICsraSkge1xuICAgICAgICAgICAgbGV0IGluZm8gPSBpbXBsaWNpdFtpXTtcbiAgICAgICAgICAgIHRoaXMuX19kZWZpbmVJbXBsaWNpdChpbmZvLnBhdHRlcm4sXG4gICAgICAgICAgICAgICAgICAgIG5ldyBEZWZpbml0aW9uKFxuICAgICAgICAgICAgICAgICAgICAgICAgVmFyaWFibGUuSW1wbGljaXRHbG9iYWxWYXJpYWJsZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIGluZm8ucGF0dGVybixcbiAgICAgICAgICAgICAgICAgICAgICAgIGluZm8ubm9kZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgbnVsbFxuICAgICAgICAgICAgICAgICAgICApKTtcblxuICAgICAgICB9XG5cbiAgICAgICAgdGhpcy5pbXBsaWNpdC5sZWZ0ID0gdGhpcy5fX2xlZnQ7XG5cbiAgICAgICAgcmV0dXJuIHN1cGVyLl9fY2xvc2Uoc2NvcGVNYW5hZ2VyKTtcbiAgICB9XG5cbiAgICBfX2RlZmluZUltcGxpY2l0KG5vZGUsIGRlZikge1xuICAgICAgICBpZiAobm9kZSAmJiBub2RlLnR5cGUgPT09IFN5bnRheC5JZGVudGlmaWVyKSB7XG4gICAgICAgICAgICB0aGlzLl9fZGVmaW5lR2VuZXJpYyhcbiAgICAgICAgICAgICAgICAgICAgbm9kZS5uYW1lLFxuICAgICAgICAgICAgICAgICAgICB0aGlzLmltcGxpY2l0LnNldCxcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5pbXBsaWNpdC52YXJpYWJsZXMsXG4gICAgICAgICAgICAgICAgICAgIG5vZGUsXG4gICAgICAgICAgICAgICAgICAgIGRlZik7XG4gICAgICAgIH1cbiAgICB9XG59XG5cbmV4cG9ydCBjbGFzcyBNb2R1bGVTY29wZSBleHRlbmRzIFNjb3BlIHtcbiAgICBjb25zdHJ1Y3RvcihzY29wZU1hbmFnZXIsIHVwcGVyU2NvcGUsIGJsb2NrKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlTWFuYWdlciwgJ21vZHVsZScsIHVwcGVyU2NvcGUsIGJsb2NrLCBmYWxzZSk7XG4gICAgfVxufVxuXG5leHBvcnQgY2xhc3MgRnVuY3Rpb25FeHByZXNzaW9uTmFtZVNjb3BlIGV4dGVuZHMgU2NvcGUge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlTWFuYWdlciwgdXBwZXJTY29wZSwgYmxvY2spIHtcbiAgICAgICAgc3VwZXIoc2NvcGVNYW5hZ2VyLCAnZnVuY3Rpb24tZXhwcmVzc2lvbi1uYW1lJywgdXBwZXJTY29wZSwgYmxvY2ssIGZhbHNlKTtcbiAgICAgICAgdGhpcy5fX2RlZmluZShibG9jay5pZCxcbiAgICAgICAgICAgICAgICBuZXcgRGVmaW5pdGlvbihcbiAgICAgICAgICAgICAgICAgICAgVmFyaWFibGUuRnVuY3Rpb25OYW1lLFxuICAgICAgICAgICAgICAgICAgICBibG9jay5pZCxcbiAgICAgICAgICAgICAgICAgICAgYmxvY2ssXG4gICAgICAgICAgICAgICAgICAgIG51bGwsXG4gICAgICAgICAgICAgICAgICAgIG51bGwsXG4gICAgICAgICAgICAgICAgICAgIG51bGxcbiAgICAgICAgICAgICAgICApKTtcbiAgICAgICAgdGhpcy5mdW5jdGlvbkV4cHJlc3Npb25TY29wZSA9IHRydWU7XG4gICAgfVxufVxuXG5leHBvcnQgY2xhc3MgQ2F0Y2hTY29wZSBleHRlbmRzIFNjb3BlIHtcbiAgICBjb25zdHJ1Y3RvcihzY29wZU1hbmFnZXIsIHVwcGVyU2NvcGUsIGJsb2NrKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlTWFuYWdlciwgJ2NhdGNoJywgdXBwZXJTY29wZSwgYmxvY2ssIGZhbHNlKTtcbiAgICB9XG59XG5cbmV4cG9ydCBjbGFzcyBXaXRoU2NvcGUgZXh0ZW5kcyBTY29wZSB7XG4gICAgY29uc3RydWN0b3Ioc2NvcGVNYW5hZ2VyLCB1cHBlclNjb3BlLCBibG9jaykge1xuICAgICAgICBzdXBlcihzY29wZU1hbmFnZXIsICd3aXRoJywgdXBwZXJTY29wZSwgYmxvY2ssIGZhbHNlKTtcbiAgICB9XG5cbiAgICBfX2Nsb3NlKHNjb3BlTWFuYWdlcikge1xuICAgICAgICBpZiAodGhpcy5fX3Nob3VsZFN0YXRpY2FsbHlDbG9zZShzY29wZU1hbmFnZXIpKSB7XG4gICAgICAgICAgICByZXR1cm4gc3VwZXIuX19jbG9zZShzY29wZU1hbmFnZXIpO1xuICAgICAgICB9XG5cbiAgICAgICAgZm9yIChsZXQgaSA9IDAsIGl6ID0gdGhpcy5fX2xlZnQubGVuZ3RoOyBpIDwgaXo7ICsraSkge1xuICAgICAgICAgICAgbGV0IHJlZiA9IHRoaXMuX19sZWZ0W2ldO1xuICAgICAgICAgICAgcmVmLnRhaW50ZWQgPSB0cnVlO1xuICAgICAgICAgICAgdGhpcy5fX2RlbGVnYXRlVG9VcHBlclNjb3BlKHJlZik7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5fX2xlZnQgPSBudWxsO1xuXG4gICAgICAgIHJldHVybiB0aGlzLnVwcGVyO1xuICAgIH1cbn1cblxuZXhwb3J0IGNsYXNzIFREWlNjb3BlIGV4dGVuZHMgU2NvcGUge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlTWFuYWdlciwgdXBwZXJTY29wZSwgYmxvY2spIHtcbiAgICAgICAgc3VwZXIoc2NvcGVNYW5hZ2VyLCAnVERaJywgdXBwZXJTY29wZSwgYmxvY2ssIGZhbHNlKTtcbiAgICB9XG59XG5cbmV4cG9ydCBjbGFzcyBCbG9ja1Njb3BlIGV4dGVuZHMgU2NvcGUge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlTWFuYWdlciwgdXBwZXJTY29wZSwgYmxvY2spIHtcbiAgICAgICAgc3VwZXIoc2NvcGVNYW5hZ2VyLCAnYmxvY2snLCB1cHBlclNjb3BlLCBibG9jaywgZmFsc2UpO1xuICAgIH1cbn1cblxuZXhwb3J0IGNsYXNzIFN3aXRjaFNjb3BlIGV4dGVuZHMgU2NvcGUge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlTWFuYWdlciwgdXBwZXJTY29wZSwgYmxvY2spIHtcbiAgICAgICAgc3VwZXIoc2NvcGVNYW5hZ2VyLCAnc3dpdGNoJywgdXBwZXJTY29wZSwgYmxvY2ssIGZhbHNlKTtcbiAgICB9XG59XG5cbmV4cG9ydCBjbGFzcyBGdW5jdGlvblNjb3BlIGV4dGVuZHMgU2NvcGUge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlTWFuYWdlciwgdXBwZXJTY29wZSwgYmxvY2ssIGlzTWV0aG9kRGVmaW5pdGlvbikge1xuICAgICAgICBzdXBlcihzY29wZU1hbmFnZXIsICdmdW5jdGlvbicsIHVwcGVyU2NvcGUsIGJsb2NrLCBpc01ldGhvZERlZmluaXRpb24pO1xuXG4gICAgICAgIC8vIHNlY3Rpb24gOS4yLjEzLCBGdW5jdGlvbkRlY2xhcmF0aW9uSW5zdGFudGlhdGlvbi5cbiAgICAgICAgLy8gTk9URSBBcnJvdyBmdW5jdGlvbnMgbmV2ZXIgaGF2ZSBhbiBhcmd1bWVudHMgb2JqZWN0cy5cbiAgICAgICAgaWYgKHRoaXMuYmxvY2sudHlwZSAhPT0gU3ludGF4LkFycm93RnVuY3Rpb25FeHByZXNzaW9uKSB7XG4gICAgICAgICAgICB0aGlzLl9fZGVmaW5lQXJndW1lbnRzKCk7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBpc0FyZ3VtZW50c01hdGVyaWFsaXplZCgpIHtcbiAgICAgICAgLy8gVE9ETyhDb25zdGVsbGF0aW9uKVxuICAgICAgICAvLyBXZSBjYW4gbW9yZSBhZ2dyZXNzaXZlIG9uIHRoaXMgY29uZGl0aW9uIGxpa2UgdGhpcy5cbiAgICAgICAgLy9cbiAgICAgICAgLy8gZnVuY3Rpb24gdCgpIHtcbiAgICAgICAgLy8gICAgIC8vIGFyZ3VtZW50cyBvZiB0IGlzIGFsd2F5cyBoaWRkZW4uXG4gICAgICAgIC8vICAgICBmdW5jdGlvbiBhcmd1bWVudHMoKSB7XG4gICAgICAgIC8vICAgICB9XG4gICAgICAgIC8vIH1cbiAgICAgICAgaWYgKHRoaXMuYmxvY2sudHlwZSA9PT0gU3ludGF4LkFycm93RnVuY3Rpb25FeHByZXNzaW9uKSB7XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoIXRoaXMuaXNTdGF0aWMoKSkge1xuICAgICAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgICAgIH1cblxuICAgICAgICBsZXQgdmFyaWFibGUgPSB0aGlzLnNldC5nZXQoJ2FyZ3VtZW50cycpO1xuICAgICAgICBhc3NlcnQodmFyaWFibGUsICdBbHdheXMgaGF2ZSBhcmd1bWVudHMgdmFyaWFibGUuJyk7XG4gICAgICAgIHJldHVybiB2YXJpYWJsZS50YWludGVkIHx8IHZhcmlhYmxlLnJlZmVyZW5jZXMubGVuZ3RoICAhPT0gMDtcbiAgICB9XG5cbiAgICBpc1RoaXNNYXRlcmlhbGl6ZWQoKSB7XG4gICAgICAgIGlmICghdGhpcy5pc1N0YXRpYygpKSB7XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gdGhpcy50aGlzRm91bmQ7XG4gICAgfVxuXG4gICAgX19kZWZpbmVBcmd1bWVudHMoKSB7XG4gICAgICAgIHRoaXMuX19kZWZpbmVHZW5lcmljKFxuICAgICAgICAgICAgICAgICdhcmd1bWVudHMnLFxuICAgICAgICAgICAgICAgIHRoaXMuc2V0LFxuICAgICAgICAgICAgICAgIHRoaXMudmFyaWFibGVzLFxuICAgICAgICAgICAgICAgIG51bGwsXG4gICAgICAgICAgICAgICAgbnVsbCk7XG4gICAgICAgIHRoaXMudGFpbnRzLnNldCgnYXJndW1lbnRzJywgdHJ1ZSk7XG4gICAgfVxufVxuXG5leHBvcnQgY2xhc3MgRm9yU2NvcGUgZXh0ZW5kcyBTY29wZSB7XG4gICAgY29uc3RydWN0b3Ioc2NvcGVNYW5hZ2VyLCB1cHBlclNjb3BlLCBibG9jaykge1xuICAgICAgICBzdXBlcihzY29wZU1hbmFnZXIsICdmb3InLCB1cHBlclNjb3BlLCBibG9jaywgZmFsc2UpO1xuICAgIH1cbn1cblxuZXhwb3J0IGNsYXNzIENsYXNzU2NvcGUgZXh0ZW5kcyBTY29wZSB7XG4gICAgY29uc3RydWN0b3Ioc2NvcGVNYW5hZ2VyLCB1cHBlclNjb3BlLCBibG9jaykge1xuICAgICAgICBzdXBlcihzY29wZU1hbmFnZXIsICdjbGFzcycsIHVwcGVyU2NvcGUsIGJsb2NrLCBmYWxzZSk7XG4gICAgfVxufVxuXG4vKiB2aW06IHNldCBzdz00IHRzPTQgZXQgdHc9ODAgOiAqL1xuIl0sInNvdXJjZVJvb3QiOiIvc291cmNlLyJ9