validate-npm-package-license
============================

Give me a string and I'll tell you if it's a valid npm package license string.

<!-- js var valid = require('./'); -->

```js
var noWarnings = {
  validForNewPackages: true,
  validForOldPackages: true
};

// SPDX license identifier for common open-source licenses
valid('MIT'); // => noWarnings
valid('BSD-2-Clause'); // => noWarnings
valid('Apache-2.0'); // => noWarnings
valid('ISC'); // => noWarnings

// Simple SPDX license expression for dual licensing
valid('(GPL-3.0 OR BSD-2-Clause)'); // => noWarnings

// Refer to a non-standard license found in the package
valid('SEE LICENSE IN LICENSE.txt'); // => noWarnings
valid('SEE LICENSE IN license.md'); // => noWarnings

// No license
valid('UNLICENSED'); // => noWarnings
valid('UNLICENCED'); // => noWarnings

var warningsWithSuggestion = {
  validForOldPackages: false,
  validForNewPackages: false,
  warnings: [
    'license should be ' +
    'a valid SPDX license expression without "LicenseRef", ' +
    '"UNLICENSED", or ' +
    '"SEE LICENSE IN <filename>"',
    'license is similar to the valid expression "Apache-2.0"'
  ]
};

// Almost a valid SPDX license identifier
valid('Apache 2.0'); // => warningsWithSuggestion

var warningAboutLicenseRef = {
  validForOldPackages: false,
  validForNewPackages: false,
  warnings: [
    'license should be ' +
    'a valid SPDX license expression without "LicenseRef", ' +
    '"UNLICENSED", or ' +
    '"SEE LICENSE IN <filename>"',
  ]
};

// LicenseRef-* identifiers are valid SPDX expressions,
// but not valid in package.json
valid('LicenseRef-Made-Up'); // => warningAboutLicenseRef
valid('(MIT OR LicenseRef-Made-Up)'); // => warningAboutLicenseRef
```
