{
  'target_defaults': {
    'type': 'loadable_module',
    'win_delay_load_hook': 'true',
    'product_prefix': '',

    'include_dirs': [
      '<(node_root_dir)/include/node',
      '<(node_root_dir)/src',
      '<(node_root_dir)/deps/uv/include',
      '<(node_root_dir)/deps/v8/include'
    ],
    'defines': [
      'NODE_GYP_MODULE_NAME=>(_target_name)'
    ],

    'target_conditions': [
      ['_type=="loadable_module"', {
        'product_extension': 'node',
        'defines': [
          'BUILDING_NODE_EXTENSION'
        ],
        'xcode_settings': {
          'OTHER_LDFLAGS': [
            '-undefined dynamic_lookup'
          ],
        },
      }],

      ['_type=="static_library"', {
        # set to `1` to *disable* the -T thin archive 'ld' flag.
        # older linkers don't support this flag.
        'standalone_static_library': '<(standalone_static_library)'
      }],

      ['_win_delay_load_hook=="true"', {
        # If the addon specifies `'win_delay_load_hook': 'true'` in its
        # binding.gyp, link a delay-load hook into the DLL. This hook ensures
        # that the addon will work regardless of whether the node/iojs binary
        # is named node.exe, iojs.exe, or something else.
        'conditions': [
          [ 'OS=="win"', {
            'sources': [
              '<(node_gyp_dir)/src/win_delay_load_hook.c',
            ],
            'msvs_settings': {
              'VCLinkerTool': {
                'DelayLoadDLLs': [ 'iojs.exe', 'node.exe' ],
                # Don't print a linker warning when no imports from either .exe
                # are used.
                'AdditionalOptions': [ '/ignore:4199' ],
              },
            },
          }],
        ],
      }],
    ],

    'conditions': [
      [ 'OS=="mac"', {
        'defines': [
          '_DARWIN_USE_64_BIT_INODE=1'
        ],
        'xcode_settings': {
          'DYLIB_INSTALL_NAME_BASE': '@rpath'
        },
      }],
      [ 'OS=="win"', {
        'libraries': [
          '-lkernel32.lib',
          '-luser32.lib',
          '-lgdi32.lib',
          '-lwinspool.lib',
          '-lcomdlg32.lib',
          '-ladvapi32.lib',
          '-lshell32.lib',
          '-lole32.lib',
          '-loleaut32.lib',
          '-luuid.lib',
          '-lodbc32.lib',
          '-lDelayImp.lib',
          '-l"<(node_root_dir)/$(ConfigurationName)/iojs.lib"'
        ],
        'msvs_disabled_warnings': [
          # warning C4251: 'node::ObjectWrap::handle_' : class 'v8::Persistent<T>'
          # needs to have dll-interface to be used by
          # clients of class 'node::ObjectWrap'
          4251
        ],
      }, {
        # OS!="win"
        'defines': [
          '_LARGEFILE_SOURCE',
          '_FILE_OFFSET_BITS=64'
        ],
      }],
      [ 'OS=="freebsd" or OS=="openbsd" or OS=="solaris" or (OS=="linux" and target_arch!="ia32")', {
        'cflags': [ '-fPIC' ],
      }]
    ]
  }
}
