var common = require('../common');
var assert = require('assert');
var path = require('path');
var fs = require('fs');

if (process.platform === 'darwin') {
  var watchSeenOne = 0;

  var testDir = common.tmpDir;

  var filenameOne = 'watch.txt';
  var testsubdirName = 'testsubdir';
  var testsubdir = path.join(testDir, testsubdirName);
  var relativePathOne = path.join('testsubdir', filenameOne);
  var filepathOne = path.join(testsubdir, filenameOne);

  process.on('exit', function() {
    assert.ok(watchSeenOne > 0);
  });

  function cleanup() {
    try { fs.unlinkSync(filepathOne); } catch (e) { }
    try { fs.rmdirSync(testsubdir); } catch (e) { }
  };

  try { fs.mkdirSync(testsubdir, 0700); } catch (e) {}

  assert.doesNotThrow(function() {
    var watcher = fs.watch(testDir, {recursive: true});
    watcher.on('change', function(event, filename) {
      assert.ok('change' === event || 'rename' === event);

      // Ignore stale events generated by mkdir
      if (filename === testsubdirName)
        return;

      assert.equal(relativePathOne, filename);

      watcher.close();
      cleanup();
      ++watchSeenOne;
    });
  });

  setTimeout(function() {
    fs.writeFileSync(filepathOne, 'world');
  }, 10);
}
