# io.js TC Meeting 2015-01-21

## Links

* **Google Hangouts Video**: http://www.youtube.com/watch?v=OUoWlIshY9s
* **GitHub Issue**: https://github.com/iojs/io.js/issues/509
* **Original Minutes Google Doc**: https://docs.google.com//document/d/1yOS17cUt7QUHJXxdVmEpS1ZS_N32HMO9QTHb2qL-KHk

## Agenda

Extracted from https://github.com/iojs/io.js/labels/tc-agenda prior to meeting.

* Invite Domenic Denicola to the TC Meetings (https://github.com/iojs/io.js/issues/403)
* Governance: Add new collaborators (https://github.com/iojs/io.js/issues/234)
* Stabilization and Release Cycles and Process (https://github.com/iojs/io.js/issues/405)
  * also: the state of ES6 on io.js (re: V8 upgrade policy) (https://github.com/iojs/io.js/issues/251)
* doc: bump punycode api stability to ‘stable’ (https://github.com/iojs/io.js/issues/470)
* Working group reports
 * Streams
 * Website
* ICU

## Minutes

### Present

* Bert (TC)
* Ben (TC)
* Chris (TC)
* Colin (TC)
* Fedor (TC)
* Isaac (TC)
* Mikeal
* Rod
* Domenic

### Mini stand-up

* Bert: Release, polish, Windows installer, Windows XP, ICU
* Ben: Fixing bugs, reviewing PRs, maintenance
* Chris: Cleaning up points where core reaches in to private state of streams, TLS bug with New Relic
* Colin: Reviewing PRs, moving vars to ES6 consts
* Fedor: Commenting, working on replacement for GYP, written in C: https://github.com/indutny/pyg
* Isaac: npm stuff, some streams discussing
* Mikeal: Website WG, social media accounts, facebook, G+, etc. 
* Domenic: Changelog & Release, clarifying V8 stuff
* Rod: Release, etc.

### Review of last meeting

* File copyright policy #216 
  - LICENSE file
* governance: Add new Collaborators #234 
  - Deferred to this meeting
* The state of ES6 on io.js _(re V8 upgrade policy)_ #251 
  - Only discussed V8 upgrade policy, re 3.31 vs 3.30
* 1.0.0 release checklist


### Invite Domenic Denicola to the TC Meetings

(https://github.com/iojs/io.js/issues/403)

Enough agreement on GitHub and in private communications amongst TC. **Done.**

### Governance: Add new collaborators 

(https://github.com/iojs/io.js/issues/234)

* Mikeal: Proposed Chris leads an onboarding process, do a Hangout with a group of people from the original list who are willing to go through the process and take them in the first week and iterate from there.
* Bert: +1 for an onboarding process, more interested in handing out voting rights to a larger group.
* Mikeal: Would rather separate the voting rights issue from adding contributors, make a separate issue for this with ideas and come back to it at next meeting.
* Ben: is an onboarding process necessary? New contributor should pick it up fairly quickly.
* Chris: How we review code and deal with issues (cultural things) is hard to get across with just a written process.
* Isaac: Basically apprentice model for joyent/node but faster and more inclusive. Some brief instruction on how to do things.
* Mikeal: adding collaborators gives us an informal voting process, +/-1s on issues with the “collaborator” badge
* Bert: would like to widen and formalise the voting process
* Mikeal: wants to tackle the issue by bringing org to the roadmap repo, will bring Bert in on the process

Discussed whether onboarding should be mandatory.

Proposal: **take anyone proposed that +1s in that thread, mandatory onboarding process by Chris, limited by how many he can take.**

Passed


### Stabilization and Release Cycles and Process 

(https://github.com/iojs/io.js/issues/405)

#### V8

* Mikeal:
  - how to align with V8 process and increase collaboration
  - semver + V8 introduces some challenges
* Domenic: V8 is synced to Chrome releases, Beta should ship with the version that ships with release
* Ben: is the proposal to stick with stable V8 release that’s in stable Chrome?
* Domenic: ideally some “beta” version of io.js that uses a Beta V8
* Mikeal: we need more releases to get experience with this, assumption is that at some point we say “this is stable” and have a stable and unstable branch.
* Discussed current release patterns, how they map to minor/patch
* Domenic: we are in a “danger zone”
* Mikeal & Domenic discussed how you might achieve a “canary”
* Bert: proposal:
  - io.js track stable V8, bump minor and possibly major as required
  - have a pre-release that tracks the Beta
* Domenic: would like to keep V8 version upgrades as a separate concern to other experimental additions to io.js, decouple from io.js releases / semver?
* Ben: happy with stable proposal, want to move discussion on unstable to an issue for further discussion.
* Action: **Ben file an issue to discuss how unstable works**
* **Agreement: V8 should track stable**

#### Logo

* Discussed logo-per-release
* Mikeal: we need a versatile logo to use across all web / social presences. Having a logo to designate a release would be good.
* Mikeal: ideally website team would like JSON file containing release info to be checked in to the website repo upon completion.

#### Releases

* Rod: patch releases should be frequent, there have been 4 so far, it seems to be working well but we should monitor
* Domenic: frequent releases should be normal, patch & minor should just be part of the normal process
* Bert: would be good to have API change notes into the git log
* Discussed further about how to deal with API changes minor/major, unstable branches, etc.
* **Agreement: patch and minor releases are merged as part of normal business, a release then is either a patch or minor bump depending on what was merged.**
* Move discussion about tagging vs git log recording for patch/minor/major to GitHub.
* **Punt on discussions about who can release and how that happens**
* **Punt on discussions about synchronizing with important ecosystem projects (NAN, node-gyp, nvm, etc.)**



### also: the state of ES6 on io.js (re: V8 upgrade policy) 

(https://github.com/iojs/io.js/issues/251)

Part of previous discussion

### doc: bump punycode api stability to ‘stable’ 

(https://github.com/iojs/io.js/issues/470)

* **Agreement**

### Working group reports

* Mikeal and Chris to semi-formalise the model
* Mikeal: 6 people actively engaged and growing, “could not be going better”
* Chris: streams group has initial set of members, some discussions going on, first meeting pending
  * initial set of members: https://github.com/iojs/readable-stream/issues/97#issuecomment-70399923
* Rod:
  - The Docker sub-group is going great and has even got the docker-iojs images accepted as the official Docker "iojs" images.
  - Other "build" efforts are all release-focused for now, trying to streamline the process to make it possible to have multiple people able to cut releases.


### ICU

* Bert:
  - joyent/node has small-icu enabled by default making `Intl` work
  - can get it working but it makes the binary twice as big (~8M more)
* Domenic: ideally we would track browsers and just include it
* Ben: V8 adds ICU by default but you need to opt-out, which we do
* Action: **Invite Steven Loomis to the next TC meeting to discuss further**


### Next meeting

* 28th January 2015

