# io.js TC Meeting 2015-01-13

## Links

* **Google Hangouts Video**: http://www.youtube.com/watch?v=Z0KHYPlFI3E
* **GitHub Issue**: https://github.com/iojs/io.js/issues/300
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1HDUayYxTjolYZhu_hGm9hc-6MGAwWrHlNGT2Zo708ck

## Agenda

Extracted from https://github.com/iojs/io.js/labels/tc-agenda prior to meeting.

* File copyright policy #216 https://github.com/iojs/io.js/issues/216
* governance: Add new Collaborators #234 https://github.com/iojs/io.js/issues/234
* The state of ES6 on io.js _(re V8 upgrade policy)_ #251 https://github.com/iojs/io.js/issues/251
  Quick recap:
  - Whether if it is ok to release 1.0.0 with V8 3.31.74 minus ES6 Classes and Object Literals Extensions, considering that the initial version of io.js will be "beta" quality and probably the stable version will coincide with the stable release of V8 3.31 (~6 weeks), which will have these features reinstated.
  - How to handle V8 updates with semver so that if the same issue arised with a different timing it could mean a bump to 2.0.0.
  - Community suggestions:
    * Different version naming (e.g. 1.x+v8beta, 1.x+v8dev, 1.x+v8canary)
    * Avoid BC by moving from tip-of-stable-Chrome-branch to the next tip-of-stable-Chrome-branch (~6 weeks release cycle)
  - How do nightly builds fit into the process.
* 1.0.0 release checklist https://github.com/iojs/io.js/issues/302

## Minutes

### Present

* Trevor (TC)
* Chris (TC)
* Ben (TC)
* Bert (TC)
* Rod (facilitator)

### Mini stand-up

* Ben: 1.0.0 work
* Bert: 1.0.0 work (and other things)
* Chris: Docs mainly, made a new repo for it
* Trevor: Stuff
* Rod: tons of 1.0.0 release prep work, tidying up test slaves, preparing fresh release slaves and configuring release builds & installers

### Review of last meeting

* Invite Colin Ihrig to the TC #223 https://github.com/iojs/io.js/issues/223
* File copyright policy #216 https://github.com/iojs/io.js/issues/216
* Doc: clarified & split up contribution docs #233 https://github.com/iojs/io.js/pull/233
* Governance: Add new Collaborators #234 https://github.com/iojs/io.js/issues/234
* deps: upgrade v8 to 3.31.74.1 #243 https://github.com/iojs/io.js/pull/243
* Build & release (& Intl)


### File copyright policy #216 

https://github.com/iojs/io.js/issues/216

Rod: prepared a proposed new LICENSE file, needed for release, adds a new license block for io.js at the top, shifts the Joyent copyright block down but still acknowledges their claim on inherited work. https://github.com/iojs/io.js/pull/294

Group agreed to merge for now until a better (or more legally appropriate) solution is proposed.

### governance: Add new Collaborators #234 

https://github.com/iojs/io.js/issues/234

Rod asked if we should punt to next meeting since the group was small and we’re 1.0.0 obsessed.

Group agreed.

### The state of ES6 on io.js _(re V8 upgrade policy)_ #251 

https://github.com/iojs/io.js/issues/251

Rod: this is about V8 version matching and V8 version stability. We’re going live with 3.31.

Discussion with the V8 team suggests that 3.31 is probably not appropriate because of stability concerns. We have already had to disable class support because the V8 team announced their intention to disable it in the next release anyway.

Group agreed to stick with 3.31, too late to do otherwise. Come up with a more solid stability policy later.

### v1.0.0 release checklist

https://github.com/iojs/io.js/issues/302

* Rod will land LICENSE change after meeting
* Bert spoke about the v0.10 and the things that remain unmerged
  - abort on uncaughtException for domains not landed, so may be missed; feature used by Hapi / Walmart Labs for postmoretem debugging
  - private buffer object patch not landed, repl will crash if you do this currently
  - sslv2 & sslv3 fixes -- we have agreed to disable these completely
  - re timers slowness - Bert and Ben don’t like the 0.10 fix, need to find our own - not landing in 1.0.0, probably our own fix in 1.0.1
* Bert spoke about node.exe, has code for it but it’s crashy, could release with a symlink for 1.0.0. Asked for input on the approach.
* Discussed node-gyp - Ben to PR node-gyp (and maybe land a modified version in io.js codebase) for iojs.org/dist/vx.y.z/... for source tarball.
  - discussed process.versions.iojs property, https://github.com/iojs/io.js/issues/269 - group agreed to do nothing on this. Rod to find discussion or create issue to have discussion on this.
  - discussed visual assets not being in the repo, currently copied by CI manually into src, Rod to land a PR with them
* Rod: Changelog, we don’t have one.
  - https://github.com/joyent/node/wiki/API-changes-between-v0.10-and-v0.12
  - Rod: is it a blocker? Ben: not per-se but very good to have.
  - Rod: proposed to come up with something on GitHub and ask for people to take work. Trevor will do Buffer, Chris streams, Bert child processes.


### Next meeting

* Back to normal schedule next week
