# Copyright 2013 the V8 project authors. All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimer in the documentation and/or other materials provided
#       with the distribution.
#     * Neither the name of Google Inc. nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# This file is automatically generated from the V8 source and should not
# be modified manually, run 'make grokdump' instead to update this file.

# List of known V8 instance types.
INSTANCE_TYPES = {
  64: "STRING_TYPE",
  68: "ONE_BYTE_STRING_TYPE",
  65: "CONS_STRING_TYPE",
  69: "CONS_ONE_BYTE_STRING_TYPE",
  67: "SLICED_STRING_TYPE",
  71: "SLICED_ONE_BYTE_STRING_TYPE",
  66: "EXTERNAL_STRING_TYPE",
  70: "EXTERNAL_ONE_BYTE_STRING_TYPE",
  74: "EXTERNAL_STRING_WITH_ONE_BYTE_DATA_TYPE",
  82: "SHORT_EXTERNAL_STRING_TYPE",
  86: "SHORT_EXTERNAL_ONE_BYTE_STRING_TYPE",
  90: "SHORT_EXTERNAL_STRING_WITH_ONE_BYTE_DATA_TYPE",
  0: "INTERNALIZED_STRING_TYPE",
  4: "ONE_BYTE_INTERNALIZED_STRING_TYPE",
  2: "EXTERNAL_INTERNALIZED_STRING_TYPE",
  6: "EXTERNAL_ONE_BYTE_INTERNALIZED_STRING_TYPE",
  10: "EXTERNAL_INTERNALIZED_STRING_WITH_ONE_BYTE_DATA_TYPE",
  18: "SHORT_EXTERNAL_INTERNALIZED_STRING_TYPE",
  22: "SHORT_EXTERNAL_ONE_BYTE_INTERNALIZED_STRING_TYPE",
  26: "SHORT_EXTERNAL_INTERNALIZED_STRING_WITH_ONE_BYTE_DATA_TYPE",
  128: "SYMBOL_TYPE",
  129: "MAP_TYPE",
  130: "CODE_TYPE",
  131: "ODDBALL_TYPE",
  132: "CELL_TYPE",
  133: "PROPERTY_CELL_TYPE",
  134: "HEAP_NUMBER_TYPE",
  135: "MUTABLE_HEAP_NUMBER_TYPE",
  136: "FOREIGN_TYPE",
  137: "BYTE_ARRAY_TYPE",
  138: "FREE_SPACE_TYPE",
  139: "EXTERNAL_INT8_ARRAY_TYPE",
  140: "EXTERNAL_UINT8_ARRAY_TYPE",
  141: "EXTERNAL_INT16_ARRAY_TYPE",
  142: "EXTERNAL_UINT16_ARRAY_TYPE",
  143: "EXTERNAL_INT32_ARRAY_TYPE",
  144: "EXTERNAL_UINT32_ARRAY_TYPE",
  145: "EXTERNAL_FLOAT32_ARRAY_TYPE",
  146: "EXTERNAL_FLOAT64_ARRAY_TYPE",
  147: "EXTERNAL_UINT8_CLAMPED_ARRAY_TYPE",
  148: "FIXED_INT8_ARRAY_TYPE",
  149: "FIXED_UINT8_ARRAY_TYPE",
  150: "FIXED_INT16_ARRAY_TYPE",
  151: "FIXED_UINT16_ARRAY_TYPE",
  152: "FIXED_INT32_ARRAY_TYPE",
  153: "FIXED_UINT32_ARRAY_TYPE",
  154: "FIXED_FLOAT32_ARRAY_TYPE",
  155: "FIXED_FLOAT64_ARRAY_TYPE",
  156: "FIXED_UINT8_CLAMPED_ARRAY_TYPE",
  158: "FILLER_TYPE",
  159: "DECLARED_ACCESSOR_DESCRIPTOR_TYPE",
  160: "DECLARED_ACCESSOR_INFO_TYPE",
  161: "EXECUTABLE_ACCESSOR_INFO_TYPE",
  162: "ACCESSOR_PAIR_TYPE",
  163: "ACCESS_CHECK_INFO_TYPE",
  164: "INTERCEPTOR_INFO_TYPE",
  165: "CALL_HANDLER_INFO_TYPE",
  166: "FUNCTION_TEMPLATE_INFO_TYPE",
  167: "OBJECT_TEMPLATE_INFO_TYPE",
  168: "SIGNATURE_INFO_TYPE",
  169: "TYPE_SWITCH_INFO_TYPE",
  171: "ALLOCATION_MEMENTO_TYPE",
  170: "ALLOCATION_SITE_TYPE",
  172: "SCRIPT_TYPE",
  173: "CODE_CACHE_TYPE",
  174: "POLYMORPHIC_CODE_CACHE_TYPE",
  175: "TYPE_FEEDBACK_INFO_TYPE",
  176: "ALIASED_ARGUMENTS_ENTRY_TYPE",
  177: "BOX_TYPE",
  180: "FIXED_ARRAY_TYPE",
  157: "FIXED_DOUBLE_ARRAY_TYPE",
  181: "CONSTANT_POOL_ARRAY_TYPE",
  182: "SHARED_FUNCTION_INFO_TYPE",
  183: "WEAK_CELL_TYPE",
  187: "JS_MESSAGE_OBJECT_TYPE",
  186: "JS_VALUE_TYPE",
  188: "JS_DATE_TYPE",
  189: "JS_OBJECT_TYPE",
  190: "JS_CONTEXT_EXTENSION_OBJECT_TYPE",
  191: "JS_GENERATOR_OBJECT_TYPE",
  192: "JS_MODULE_TYPE",
  193: "JS_GLOBAL_OBJECT_TYPE",
  194: "JS_BUILTINS_OBJECT_TYPE",
  195: "JS_GLOBAL_PROXY_TYPE",
  196: "JS_ARRAY_TYPE",
  197: "JS_ARRAY_BUFFER_TYPE",
  198: "JS_TYPED_ARRAY_TYPE",
  199: "JS_DATA_VIEW_TYPE",
  185: "JS_PROXY_TYPE",
  200: "JS_SET_TYPE",
  201: "JS_MAP_TYPE",
  202: "JS_SET_ITERATOR_TYPE",
  203: "JS_MAP_ITERATOR_TYPE",
  204: "JS_WEAK_MAP_TYPE",
  205: "JS_WEAK_SET_TYPE",
  206: "JS_REGEXP_TYPE",
  207: "JS_FUNCTION_TYPE",
  184: "JS_FUNCTION_PROXY_TYPE",
  178: "DEBUG_INFO_TYPE",
  179: "BREAK_POINT_INFO_TYPE",
}

# List of known V8 maps.
KNOWN_MAPS = {
  0x08081: (137, "ByteArrayMap"),
  0x080a9: (129, "MetaMap"),
  0x080d1: (131, "NullMap"),
  0x080f9: (131, "UndefinedMap"),
  0x08121: (180, "FixedArrayMap"),
  0x08149: (4, "OneByteInternalizedStringMap"),
  0x08171: (134, "HeapNumberMap"),
  0x08199: (138, "FreeSpaceMap"),
  0x081c1: (158, "OnePointerFillerMap"),
  0x081e9: (158, "TwoPointerFillerMap"),
  0x08211: (131, "TheHoleMap"),
  0x08239: (131, "BooleanMap"),
  0x08261: (131, "UninitializedMap"),
  0x08289: (131, "ExceptionMap"),
  0x082b1: (132, "CellMap"),
  0x082d9: (133, "GlobalPropertyCellMap"),
  0x08301: (182, "SharedFunctionInfoMap"),
  0x08329: (135, "MutableHeapNumberMap"),
  0x08351: (180, "NativeContextMap"),
  0x08379: (130, "CodeMap"),
  0x083a1: (180, "ScopeInfoMap"),
  0x083c9: (180, "FixedCOWArrayMap"),
  0x083f1: (157, "FixedDoubleArrayMap"),
  0x08419: (181, "ConstantPoolArrayMap"),
  0x08441: (183, "WeakCellMap"),
  0x08469: (131, "NoInterceptorResultSentinelMap"),
  0x08491: (180, "HashTableMap"),
  0x084b9: (180, "OrderedHashTableMap"),
  0x084e1: (131, "ArgumentsMarkerMap"),
  0x08509: (131, "TerminationExceptionMap"),
  0x08531: (128, "SymbolMap"),
  0x08559: (64, "StringMap"),
  0x08581: (68, "OneByteStringMap"),
  0x085a9: (65, "ConsStringMap"),
  0x085d1: (69, "ConsOneByteStringMap"),
  0x085f9: (67, "SlicedStringMap"),
  0x08621: (71, "SlicedOneByteStringMap"),
  0x08649: (66, "ExternalStringMap"),
  0x08671: (74, "ExternalStringWithOneByteDataMap"),
  0x08699: (70, "ExternalOneByteStringMap"),
  0x086c1: (70, "NativeSourceStringMap"),
  0x086e9: (82, "ShortExternalStringMap"),
  0x08711: (90, "ShortExternalStringWithOneByteDataMap"),
  0x08739: (0, "InternalizedStringMap"),
  0x08761: (2, "ExternalInternalizedStringMap"),
  0x08789: (10, "ExternalInternalizedStringWithOneByteDataMap"),
  0x087b1: (6, "ExternalOneByteInternalizedStringMap"),
  0x087d9: (18, "ShortExternalInternalizedStringMap"),
  0x08801: (26, "ShortExternalInternalizedStringWithOneByteDataMap"),
  0x08829: (22, "ShortExternalOneByteInternalizedStringMap"),
  0x08851: (86, "ShortExternalOneByteStringMap"),
  0x08879: (139, "ExternalInt8ArrayMap"),
  0x088a1: (140, "ExternalUint8ArrayMap"),
  0x088c9: (141, "ExternalInt16ArrayMap"),
  0x088f1: (142, "ExternalUint16ArrayMap"),
  0x08919: (143, "ExternalInt32ArrayMap"),
  0x08941: (144, "ExternalUint32ArrayMap"),
  0x08969: (145, "ExternalFloat32ArrayMap"),
  0x08991: (146, "ExternalFloat64ArrayMap"),
  0x089b9: (147, "ExternalUint8ClampedArrayMap"),
  0x089e1: (149, "FixedUint8ArrayMap"),
  0x08a09: (148, "FixedInt8ArrayMap"),
  0x08a31: (151, "FixedUint16ArrayMap"),
  0x08a59: (150, "FixedInt16ArrayMap"),
  0x08a81: (153, "FixedUint32ArrayMap"),
  0x08aa9: (152, "FixedInt32ArrayMap"),
  0x08ad1: (154, "FixedFloat32ArrayMap"),
  0x08af9: (155, "FixedFloat64ArrayMap"),
  0x08b21: (156, "FixedUint8ClampedArrayMap"),
  0x08b49: (180, "SloppyArgumentsElementsMap"),
  0x08b71: (180, "FunctionContextMap"),
  0x08b99: (180, "CatchContextMap"),
  0x08bc1: (180, "WithContextMap"),
  0x08be9: (180, "BlockContextMap"),
  0x08c11: (180, "ModuleContextMap"),
  0x08c39: (180, "ScriptContextMap"),
  0x08c61: (180, "ScriptContextTableMap"),
  0x08c89: (187, "JSMessageObjectMap"),
  0x08cb1: (136, "ForeignMap"),
  0x08cd9: (189, "NeanderMap"),
  0x08d01: (170, "AllocationSiteMap"),
  0x08d29: (171, "AllocationMementoMap"),
  0x08d51: (174, "PolymorphicCodeCacheMap"),
  0x08d79: (172, "ScriptMap"),
  0x08dc9: (189, "ExternalMap"),
  0x08f09: (177, "BoxMap"),
  0x08f31: (161, "ExecutableAccessorInfoMap"),
  0x08f59: (162, "AccessorPairMap"),
  0x08f81: (163, "AccessCheckInfoMap"),
  0x08fa9: (164, "InterceptorInfoMap"),
  0x08fd1: (165, "CallHandlerInfoMap"),
  0x08ff9: (166, "FunctionTemplateInfoMap"),
  0x09021: (167, "ObjectTemplateInfoMap"),
  0x09049: (169, "TypeSwitchInfoMap"),
  0x09071: (173, "CodeCacheMap"),
  0x09099: (175, "TypeFeedbackInfoMap"),
  0x090c1: (176, "AliasedArgumentsEntryMap"),
  0x090e9: (178, "DebugInfoMap"),
  0x09111: (179, "BreakPointInfoMap"),
}

# List of known V8 objects.
KNOWN_OBJECTS = {
  ("OLD_POINTER_SPACE", 0x08081): "NullValue",
  ("OLD_POINTER_SPACE", 0x08091): "UndefinedValue",
  ("OLD_POINTER_SPACE", 0x080a1): "TheHoleValue",
  ("OLD_POINTER_SPACE", 0x080b1): "TrueValue",
  ("OLD_POINTER_SPACE", 0x080c1): "FalseValue",
  ("OLD_POINTER_SPACE", 0x080d1): "UninitializedValue",
  ("OLD_POINTER_SPACE", 0x080e1): "Exception",
  ("OLD_POINTER_SPACE", 0x080f1): "NoInterceptorResultSentinel",
  ("OLD_POINTER_SPACE", 0x08101): "ArgumentsMarker",
  ("OLD_POINTER_SPACE", 0x08111): "NumberStringCache",
  ("OLD_POINTER_SPACE", 0x08919): "SingleCharacterStringCache",
  ("OLD_POINTER_SPACE", 0x08d21): "StringSplitCache",
  ("OLD_POINTER_SPACE", 0x09129): "RegExpMultipleCache",
  ("OLD_POINTER_SPACE", 0x09531): "TerminationException",
  ("OLD_POINTER_SPACE", 0x09541): "MessageListeners",
  ("OLD_POINTER_SPACE", 0x0955d): "CodeStubs",
  ("OLD_POINTER_SPACE", 0x0f555): "NonMonomorphicCache",
  ("OLD_POINTER_SPACE", 0x0fb69): "PolymorphicCodeCache",
  ("OLD_POINTER_SPACE", 0x0fb71): "NativesSourceCache",
  ("OLD_POINTER_SPACE", 0x0fbe1): "EmptyScript",
  ("OLD_POINTER_SPACE", 0x0fc1d): "IntrinsicFunctionNames",
  ("OLD_POINTER_SPACE", 0x15c39): "ObservationState",
  ("OLD_POINTER_SPACE", 0x15c45): "SymbolRegistry",
  ("OLD_POINTER_SPACE", 0x16601): "EmptySlowElementDictionary",
  ("OLD_POINTER_SPACE", 0x1679d): "AllocationSitesScratchpad",
  ("OLD_POINTER_SPACE", 0x43e61): "StringTable",
  ("OLD_DATA_SPACE", 0x08081): "EmptyDescriptorArray",
  ("OLD_DATA_SPACE", 0x08089): "EmptyFixedArray",
  ("OLD_DATA_SPACE", 0x080a9): "NanValue",
  ("OLD_DATA_SPACE", 0x08159): "EmptyByteArray",
  ("OLD_DATA_SPACE", 0x08161): "EmptyConstantPoolArray",
  ("OLD_DATA_SPACE", 0x08241): "EmptyExternalInt8Array",
  ("OLD_DATA_SPACE", 0x0824d): "EmptyExternalUint8Array",
  ("OLD_DATA_SPACE", 0x08259): "EmptyExternalInt16Array",
  ("OLD_DATA_SPACE", 0x08265): "EmptyExternalUint16Array",
  ("OLD_DATA_SPACE", 0x08271): "EmptyExternalInt32Array",
  ("OLD_DATA_SPACE", 0x0827d): "EmptyExternalUint32Array",
  ("OLD_DATA_SPACE", 0x08289): "EmptyExternalFloat32Array",
  ("OLD_DATA_SPACE", 0x08295): "EmptyExternalFloat64Array",
  ("OLD_DATA_SPACE", 0x082a1): "EmptyExternalUint8ClampedArray",
  ("OLD_DATA_SPACE", 0x082ad): "EmptyFixedUint8Array",
  ("OLD_DATA_SPACE", 0x082b5): "EmptyFixedInt8Array",
  ("OLD_DATA_SPACE", 0x082bd): "EmptyFixedUint16Array",
  ("OLD_DATA_SPACE", 0x082c5): "EmptyFixedInt16Array",
  ("OLD_DATA_SPACE", 0x082cd): "EmptyFixedUint32Array",
  ("OLD_DATA_SPACE", 0x082d5): "EmptyFixedInt32Array",
  ("OLD_DATA_SPACE", 0x082dd): "EmptyFixedFloat32Array",
  ("OLD_DATA_SPACE", 0x082e5): "EmptyFixedFloat64Array",
  ("OLD_DATA_SPACE", 0x082ed): "EmptyFixedUint8ClampedArray",
  ("OLD_DATA_SPACE", 0x082f5): "InfinityValue",
  ("OLD_DATA_SPACE", 0x08301): "MinusZeroValue",
  ("CODE_SPACE", 0x15fa1): "JsEntryCode",
  ("CODE_SPACE", 0x243c1): "JsConstructEntryCode",
}
