subroutine com_support(line,error)
  use gildas_def
  use gkernel_interfaces
  use imager_interfaces, only : map_message, mask_clean, sub_support_mask
  use clean_default
  use clean_arrays
  use clean_support
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private
  !
  ! IMAGER  
  !   Support routine for command
  !	  SUPPORT [/PLOT] [/CURSOR] [/RESET] [/MASK] [/VARIABLE]
  !           [/THRESHOLD  Raw Smooth [SmoothingLength]
  !---------------------------------------------------------------------
  character(len=*), intent(in)  :: line  ! Commandand line
  logical,          intent(out) :: error ! Logical error flag
  !
  ! Local variables
  character(len=*), parameter :: rname='SUPPORT'
  integer(kind=4), parameter :: o_name=0
  integer(kind=4), parameter :: o_curs=1
  integer(kind=4), parameter :: o_mask=2
  integer(kind=4), parameter :: o_plot=3
  integer(kind=4), parameter :: o_rese=4
  integer(kind=4), parameter :: o_thre=5 ! Obsolete
  integer(kind=4), parameter :: o_vari=6
  !
  logical :: fromfile, do_plot
  character(len=filename_length) :: file
  character(len=80) :: mess
  integer(kind=4) :: ier, n
  !
  do_plot = sic_present(o_plot,0)
  !
  if (sic_present(o_curs,0)) then  ! /CURSOR
    call map_message(seve%i,rname,'Use cursor to define polygon')
    user_method%do_mask = .true.
    file = ' '
    fromfile = .false.
    hmask%loca%size = 0
    !
  else if (sic_present(o_rese,0)) then  ! /RESET
    call greg_poly_reset(supportpol,supportvar,error)
    if (error)  return
    user_method%do_mask = .true.  ! The mask HAS changed...
    support_type = support_none
    !
    ! Delete the "supportvar" structure
    call sic_delvariable(supportvar,.false.,error)
    return
    !
  else if (sic_present(o_mask,0)) then  ! /MASK
    call sub_support_mask(rname,.true.,do_plot,error)
    return
  else if (sic_present(o_thre,0)) then
    ! This is obsolescent...
    !
    ! SUPPORT /THRESHOLD Raw Smooth [Length]
    !
    !  Raw      Thresholding (in Sigma) of the Clean image
    !  Smooth   Thresholding (in Sigma) after smoothing
    !  Length   Smoothing length: default is Clean beam major axis
    !
    call map_message(seve%e,rname,'/THRESHOLD option is Obsolete, use MASK THRESHOLD instead')
    error = .true.
    return
  else if (do_plot.and.sic_narg(o_name).eq.0) then  
    ! SUPPORT /PLOT 
    !
    ! Just plot
    if (support_type.eq.support_poly) then
      call greg_poly_plot(supportpol,error)
    else if (support_type.ne.support_none) then
      call sub_support_mask(rname,.false.,.true.,error)
      support_type = support_mask
    else
      call map_message(seve%w,rname,'No support defined')
      error  = .true.      
    endif
    return
  else
    !
    ! Test the SUPPORT ?  syntax
    if (sic_narg(o_name).ge.1) then
      if (sic_narg(o_name).eq.1) then
        if (.not.sic_present(o_vari,0)) then
          call sic_ch(line,o_name,1,mess,n,.true.,error)
          if (mess.eq."?") then
            select case (support_type)
            case (support_none)
              call map_message(seve%i,rname,'No support active')
            case (support_poly)
              if (supportpol%ngon.lt.3) then
                call map_message(seve%w,rname,'No current support defined')
              else
                write(mess,'(A,I0,A)') 'Support is a polygon of ',supportpol%ngon,' sides'
                call map_message(seve%i,rname,mess)
              endif
            case default
              call map_message(seve%i,rname,'Support is defined by the MASK')
            end select
            return
          endif
        endif
      endif
      user_method%do_mask = .true.
      ! Parse the filename
      call greg_poly_parsename(line,o_name,o_vari,fromfile,file,error)
      if (error) return
    else
      ! No argument, no /CURSOR option either: re-instate the
      ! current Polygon as a SUPPORT if any.
      if (supportpol%ngon.lt.3) then
        if (support_type.gt.0) then
          call map_message(seve%w,rname,'No current support defined, MASK in use')
        else
          call map_message(seve%e,rname,'No current support defined')
          support_type = support_none
          error = .true.
        endif
        return
      endif
      support_type = support_poly
      return
    endif
  endif
  !
  ! File, /VARIABLE or /CURSOR option
  !
  ! Define the polygon from file or cursor:
  call sic_delvariable(supportvar,.false.,error)
  call sic_defstructure(supportvar,.true.,error)
  support_type = support_none
  call greg_poly_define(rname,file,fromfile,supportpol,supportvar,error)
  if (error)  return
  support_type = support_poly
  !
  ! /PLOT if needed
  if (do_plot) call greg_poly_plot(supportpol,error)
  !
end subroutine com_support
!
subroutine sub_support_mask(rname,do_def,do_plot,error)
  use gildas_def
  use gkernel_interfaces
  use imager_interfaces, only : map_message
  use clean_default
  use clean_arrays
  use clean_support
  use gbl_message
  !
  !---------------------------------------------------------------------
  ! @ private
  !
  ! IMAGER  
  !   Support routine for command
  !	  SUPPORT /MASK [/PLOT] 
  !---------------------------------------------------------------------
  !
  character(len=*), intent(in) :: rname
  logical, intent(in) :: do_def
  logical, intent(in) :: do_plot
  logical, intent(inout) :: error
  !
  real(kind=4), allocatable, target :: imask(:,:)
  integer :: ier
  !
  if (do_def) then
    if (allocated(dmask)) then
      call sic_delvariable('MASK',.false.,error)
      call sic_mapgildas ('MASK',hmask,error,dmask)
      !
      user_method%do_mask = .true.
      support_type = 1 ! First plane will be used by default      
    else
      call map_message(seve%e,rname,'No mask defined')
      error  = .true.
      return
    endif
  endif
  !
  ! Show it if asked for by /PLOT option
  if (do_plot) then
    allocate (imask(hmask%gil%dim(1),hmask%gil%dim(2)),stat=ier)
    imask = 0.0
    where (dmask(:,:,1).ne.0) imask = 1.0
    call sic_def_real ('BITMAP_MASK',imask,hmask%gil%ndim,   &
     &        hmask%gil%dim,.true.,error)
    call gr_exec2('PLOT BITMAP_MASK /SCALING LIN -0.5 1.5')
    error = gr_error()
    call sic_delvariable('BITMAP_MASK',.false.,error)
    deallocate (imask,stat=ier)
  endif
end subroutine sub_support_mask
