! Code for command DISCARD
! Code for command BUFFERS
! and some generic routines to support Buffers
! Specific UV routines in uv_buffers.f90
!
subroutine comm_discard(line,comm,error)
  use clean_def
  use clean_arrays
  use clean_default
  use clean_types
  use gbl_message
  use gkernel_interfaces
  use imager_interfaces, only : map_message, sub_discard
  !---------------------------------------------------------------------
  ! @ private
  !
  ! IMAGER
  !   Support for command DISCARD
  !
  ! Delete some internal buffer and its associated SIC variable
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line
  character(len=*), intent(in) :: comm
  logical, intent(out) :: error
  !
  ! Local
  character(len=32) :: key
  character(len=256) :: str
  integer :: nk,i
  logical :: doall, douv
  !
  ! Code
  error = .false.
  !
  str = ' '
  doall = .false.
  douv = .false.
  do i=1,sic_narg(0)
    !
    call sic_ke(line,0,i,key,nk,.true.,error)
    if (error) exit 
    !
    if (doall.or.douv) then
      if (len_trim(str).gt.0) then
        str(len_trim(str):len_trim(str)) = ']'
        call map_message(seve%i,comm,'Deallocated ['//trim(str))
      endif    
      str = ' '
    endif
    !
    doall = key.eq.'*'
    douv  = key.eq.'UV*'
    call sub_discard(str,key,doall,douv)
    !
    if (doall.or.douv) then
      if (len_trim(str).gt.0) then
        str(len_trim(str):len_trim(str)) = ']'
        call map_message(seve%i,comm,'Deallocated ['//trim(str))
      endif    
      str = ' '
    endif
  enddo
  !
  if (len_trim(str).gt.0) then
    str(len_trim(str):len_trim(str)) = ']'
    call map_message(seve%i,comm,'Deallocated ['//trim(str))
  endif    
end subroutine comm_discard
!
subroutine sub_discard(str,key,doall,douv)  
  use clean_def
  use clean_arrays
  use clean_default
  use clean_types
  use clean_support
  use gbl_message
  use gkernel_interfaces, only : sic_delvariable, locwrd, gildas_null
  use imager_interfaces, only : map_message
  !---------------------------------------------------------------------
  ! @ private
  !   Support for command DISCARD
  !
  ! Delete some internal buffer and its associated SIC variable
  !---------------------------------------------------------------------
  character(len=*), intent(inout) :: str
  character(len=*), intent(in) :: key
  logical :: doall
  logical :: douv
  !
  integer :: ier
  logical :: error
  !
  error = .false.
  ier = 0
  !
  if ((key.eq.'UV').or.(key.eq.'UV_DATA').or.douv) then
    call discard_uvdata(error)
    if (error) ier = 1
    str = 'UV_DATA,'//trim(str)
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'UVCONT').or.douv) then
    ! Delete the CONTINUUM UV data if defined
    call sic_delvariable ('UVCONT',.false.,error)
    if (allocated(duvc)) then
      str = 'UVCONT, '//trim(str)
      deallocate(duvc,stat=ier)
    endif
    huvc%loca%size = 0
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'UVSELF').or.douv) then
    !
    ! Delete the SELF array if defined
    call sic_delvariable ('UVSELF',.false.,error)
    if (allocated(duvself)) then
      str = 'UVSELF, '//trim(str)
      deallocate(duvself,stat=ier)
    endif
    hself%loca%size = 0
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'UV_MODEL').or.douv) then
    ! Free the previous zone
    call sic_delvariable ('UV_MODEL',.false.,error)
    if (allocated(duvm)) then
      str = 'UV_MODEL, '//trim(str)
      deallocate(duvm,stat=ier)
      huvm%loca%size = 0
    endif
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'BEAM').or.doall) then
    save_data(code_save_beam) = .false.
    call sic_delvariable ('BEAM',.false.,error)
    if (allocated(dbeam)) then
      str = 'BEAM, '//trim(str)
      deallocate(dbeam,stat=ier)
    endif
    hbeam%loca%size = 0
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'CONTINUUM').or.doall) then
    ! Delete the CONTINUUM image if defined
    save_data(code_save_cont) = .false.
    call sic_delvariable ('CONTINUUM',.false.,error)
    if (allocated(dcont)) then
      deallocate(dcont,stat=ier)
      str = 'CONTINUUM, '//trim(str)
    endif
    hcont%loca%size = 0
    if (.not.doall) goto 100
  endif
  !
  !
  if ((key.eq.'DIRTY').or.doall) then
    save_data(code_save_dirty) = .false.
    call sic_delvariable ('DIRTY',.false.,error)
    if (allocated(ddirty)) then
      str = 'DIRTY, '//trim(str)
      deallocate(ddirty,stat=ier)
    endif
    hdirty%loca%size = 0
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'RESIDUAL').or.doall) then
    save_data(code_save_resid) = .false.
    call sic_delvariable ('RESIDUAL',.false.,error)
    if (allocated(dresid)) then
      str = 'RESIDUAL, '//trim(str)
      deallocate(dresid,stat=ier)
    endif
    hresid%loca%size = 0
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'CLEAN').or.doall) then
    save_data(code_save_clean) = .false.
    call sic_delvariable ('CLEAN',.false.,error)
    if (allocated(dclean)) then
      str = 'CLEAN, '//trim(str)
      deallocate(dclean,stat=ier)
    endif
    hclean%loca%size = 0
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'SKY').or.doall) then
    save_data(code_save_sky) = .false.
    call sic_delvariable ('SKY',.false.,error)
    if (allocated(dsky)) then
      str = 'SKY, '//trim(str)
      deallocate(dsky,stat=ier)
    endif
    hsky%loca%size = 0
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'MASK').or.doall) then
    save_data(code_save_mask) = .false.
    call sic_delvariable ('MASK',.false.,error)
    if (allocated(dmask)) then
      str = 'MASK, '//trim(str)
      deallocate(dmask,stat=ier)
    endif
    hmask%loca%size = 0
    user_method%do_mask = .true.  ! The mask HAS changed...
    if (support_type.gt.0) support_type = support_none
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'PRIMARY').or.doall) then
    save_data(code_save_primary) = .false.
    call sic_delvariable ('PRIMARY',.false.,error)
    if (allocated(dprim)) then
      str = 'PRIMARY, '//trim(str)
      deallocate(dprim,stat=ier)
    endif
    hprim%loca%size = 0
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'CCT').or.doall) then
    save_data(code_save_cct) = .false.
    call sic_delvariable ('CCT',.false.,error)
    if (allocated(dcct)) then
      str = 'CCT, '//trim(str)
      deallocate(dcct,stat=ier)
    endif
    hcct%loca%size = 0
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'SINGLEDISH').or.doall) then
    save_data(code_save_single) = .false.
    call sic_delvariable ('SINGLE',.false.,error)
    call sic_delvariable ('SHORT',.false.,error)
    if (allocated(dshort)) then
      str = 'SHORT, '//trim(str)
      deallocate(dshort,stat=ier)
    endif
    hshort%loca%size = 0
    call gildas_null(hshort) ! Play safe
    if (allocated(dsingle)) then
      str = 'SINGLE, '//trim(str)
      deallocate(dsingle,stat=ier)
    endif
    hsingle%loca%size = 0
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'SHORT').or.doall) then
    save_data(code_save_single) = .false.
    call sic_delvariable ('SHORT',.false.,error)
    if (allocated(dshort)) then
      str = 'SHORT, '//trim(str)
      deallocate(dshort,stat=ier)
    endif
    hshort%loca%size = 0
    call gildas_null(hshort) ! Play safe
    if (.not.doall) goto 100
  endif
  !
  if ((key.eq.'SUPPORT').or.doall) then
    call greg_poly_reset(supportpol,supportvar,error)
    if (error)  return
    user_method%do_mask = .true.  ! The mask HAS changed...
    support_type = support_none
    !
    ! Delete the "supportvar" structure
    call sic_delvariable(supportvar,.false.,error)
    if (.not.doall) goto 100
  endif
  !
  if (.not.(doall.or.douv)) then
    call map_message(seve%w,'DISCARD','No code for '//key)
    error = .true.
    return
  endif
  !
100 continue
  if (ier.ne.0) then
    call map_message(seve%e,'DISCARD',trim(key)//' deallocation error')
    error = .true.
  endif
end subroutine sub_discard
!
subroutine buffers_comm(line,error)
  use gkernel_interfaces
  use clean_types
  !---------------------------------------------------------------------
  ! @ private
  !
  ! IMAGER
  !   Support for command BUFFERS
  !
  ! List known buffer status
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line    
  logical :: error
  !
  type(sic_descriptor_t) :: desc   ! Descriptor
  logical :: found
  character(len=32) :: chain
  character(len=12) :: cmem
  character(len=12) :: ctotal
  integer :: i, j, nc
  real :: tmem, rmem
  !
  tmem = 0.
  chain = '  Size'
  cmem =  '  Memory'
  write(*,'(A,A,A,A)') 'Name        ',chain,cmem, ' Purpose '
  do i=1,mbuffer
    call sic_descriptor(cbuffer(i),desc,found)  
    if (found) then
      if (desc%ndim.eq.0) then
        chain = '(undefined)'
        cmem = ' '
      else
        chain='['
        nc = 2
        do j=1,desc%ndim
          write(chain(nc:),'(I0,A)') desc%dims(j),','
          nc = len_trim(chain)+1
        enddo
        nc = nc-1
        chain(nc:nc) = ']'
        !
        rmem = product(desc%dims(1:desc%ndim))*4/1024./1024./1024.
        write(cmem,'(F9.2)') rmem
        tmem = tmem+rmem
      endif
    else
      chain = '(undefined)  '
      cmem = ' '
    endif
    write(*,'(A,A,A,A)') cbuffer(i), chain, cmem, sbuffer(i)
  enddo
  !
  ctotal = ' '
  chain  = '   ----- Total memory ---- '
  write(cmem,'(F9.2)') tmem
  write(*,'(A,A,A,A)') ctotal, chain, cmem,'(Gbytes)'
end subroutine buffers_comm
!
subroutine dump_memory(error)
  use clean_default
  use gbl_message
  use gkernel_interfaces
  use imager_interfaces, only : map_message
  !
  logical, intent(out) :: error
  !
  ! There is no generic code to retrieve the memory use.
  !
  ! On Linux, one could scan directly the /proc/self/status   file,
  !  if at all possible (it cannot be seen by a TYPE command)
  !
  ! Most efficient would be to call the C Posix standard "getrusage"
  ! but that only returns the Maximum used memory, not the current one.
  ! 
  ! Other methods are system dependent, and require to fork a child, 
  ! which duplicates the memory content and can lead to Crashes !...
  !
  character(len=256) :: tmp, str, line
  character(len=16) :: cpid
  real(8) :: umem, pmem, pcpu, vsz
  integer :: ilun, idx, pid, ier
  integer(8) :: valueRSS
  ! 
  error = .true.
#if defined(DARWIN)
  !
  ! System fork uses extra memory...
  ier = sic_getlog("GAG_SCRATCH:",tmp)
  ier = gag_system("LANG=US; ps -awxm -o %mem,vsz,rss,comm | sort -nr | grep imager > "// &
    & trim(tmp)//"top.tmp" )
  if (ier.eq.0) then
    ier = sic_getlun(ilun)
    open(unit=ilun,file=trim(tmp)//'top.tmp',status='old',iostat=ier)
    if (ier.eq.0) then
      read(ilun,*) pmem
      umem = (pmem*sys_ramsize/100)/1024
      write(tmp,'(A,F8.1,A,F5.1,A)') 'Current memory used ',umem,' Gbytes (',pmem,' %) of available'
      close(unit=ilun)
      call sic_message(seve%i,'DEBUG',tmp)
    endif
    call sic_frelun(ilun)
  endif
  !
  ! This only returns the max in history, not the current value...
  valueRSS = 0
  valueRSS = systMemUsageC()
  umem = valueRSS/1024.0/1024.0
  pmem = umem*100.0/sys_ramsize
  umem = umem/1024.0
  write(tmp,'(AF8.1,A,F5.1,A)') 'Maximum memory used ',umem,' Gbytes (',pmem,' %) of available'
  call map_message(seve%i,'DEBUG',tmp)
#elif defined(LINUX)
  ier = sic_getlun(ilun)
  !
  ! Data is available in a virtual file 
  valueRSS = -1   
  open(unit=ilun, file='/proc/self/status', action='read')
  do
    read(ilun, '(a)',iostat=ier ) line
    if (ier /=0) exit
    if (line(1:6) == 'VmRSS:') then
      read(line(7:), *) valueRSS
      exit
    endif
  enddo
  close(ilun)
  call sic_frelun(ilun)
  !! Print *,'ValueRSS ',valueRSS
  umem = valueRSS/1024.0/1024.0
  pmem = umem/sys_ramsize*100.
  write(tmp,'(AF8.1,A,F5.1,A)') 'Current memory used ',umem,' Gbytes (',pmem,' %) of available'
  call map_message(seve%i,'DEBUG',tmp)
  !
  ! This only returns the max in history, not the current value...
  valueRSS = 0
  valueRSS = systMemUsageC()
  !! Print *,'ValueRSS ',valueRSS
  umem = valueRSS/1024.0/1024.0
  pmem = umem/sys_ramsize*100.
  write(tmp,'(AF8.1,A,F5.1,A)') 'Maximum memory used ',umem,' Gbytes (',pmem,' %) of available'
  call map_message(seve%i,'DEBUG',tmp)
#else
  ! May work on generic Unix system, but doubles the memory usage
  ! while using "system" fork. So it is prompt to crashes when
  ! reaching memory limits. This is exactly when one wants to 
  ! monitor the use, so a real issue...
  ier = sic_getlog("GAG_SCRATCH:",tmp)
  pid = gag_getpid()
  write(cpid,'(I0)') pid
  ier = gag_system("ps aux | grep imager | grep "//trim(cpid)//" > "// &
    & trim(tmp)//"ps.tmp" )
  if (ier.ne.0) return
  ier = sic_getlun(ilun)
  open(unit=ilun,file=trim(tmp)//'ps.tmp',status='old',iostat=ier)
  if (ier.ne.0) then
    call sic_frelun(ilun)
    return
  endif
  do 
    read(ilun,'(A)',iostat=ier) str
    if (ier.ne.0) exit
    idx = index(str,trim(cpid))
    if ((idx.ne.0).and.(idx.lt.16)) then
      read(str(idx:),*,iostat=ier) pid, pcpu, pmem, vsz
      umem = (pmem*sys_ramsize/100)/1024
      write(tmp,'(AF8.1,A,F5.1,A)') 'Used memory ',umem,' Gbytes (',pmem,' % of available'
      exit
    endif
  enddo
  close(unit=ilun)
  call sic_frelun(ilun)
  if (idx.ne.0) call map_message(seve%i,'DEBUG',tmp)
#endif
  error = .false.
  !
contains
!
function systMemUsageC() result(valueRSS)
  use iso_c_binding
  interface
    subroutine getSize(val) bind(c, name='getSize')
      import :: c_long
      integer(kind=c_long) :: val
    end
  end interface
  integer(kind=8) :: valueRSS
  !
  call getSize(valueRSS)
end
end subroutine dump_memory
