subroutine compare_comm(line,error)
  use gkernel_interfaces
  use gkernel_types
  use gbl_message
  use imager_interfaces, only : map_message
  !-------------------------------------------------------------------
  ! @ private
  ! IMAGER
  !   Support for command COMPARE Left Right [/DIRECTORY <top]
  !   and COMPARE ? or COMPARE ??
  !-------------------------------------------------------------------
  character(len=*), intent(in) :: line    ! Command line
  logical, intent(inout) :: error         ! Error flag
  !
  ! Global
  integer, parameter :: o_dir=1
  character(len=*), parameter :: rname='COMPARE'
  integer, parameter :: mvoc=4
  character(len=8) :: argum, vocab(mvoc), key
  data vocab /'LEFT','RIGHT','JOINT','EACH'/
  !
  ! Local
  type(sic_descriptor_t) :: ldesc, rdesc
  character(len=256) :: chain
  character(len=64), save :: cleft, cright
  character(len=4) :: trail
  character(len=commandline_length) :: cline
  character(len=12) :: comm
  integer :: i, n, narg, ikey
  logical, save :: todo=.true.
  logical, save :: is2d=.false.
  logical :: found, do_insert, isfile
  !
  ! Code
  do_insert = (sic_lire().eq.0)
  narg = sic_narg(0)
  trail = ' '
  if (narg.eq.1) then
    call sic_ch(line,0,1,chain,i,.true.,error)
    if (error) return
    if ((chain.eq.'?').or.(chain.eq.'??')) then
      call exec_program('@ i_compare '//chain)
      return
    else
      call sic_ke(line,0,1,argum,n,.true.,error)
      call sic_ambigs (rname,argum,key,ikey,vocab,mvoc,error)
      if (error) return
      trail(2:3) = key(1:2)
    endif
  endif
  !
  if ((narg.gt.1).or.todo) then
    todo = .true.
    ! Define CMP_LEFT or CMP_RIGHT if any argument is a File
    call compare_comm_args(line,cleft,cright,isfile,error)
    if (error) return
    if (narg.gt.2) then
      call sic_ke(line,0,3,argum,n,.true.,error)
      call sic_ambigs (rname,argum,key,ikey,vocab,mvoc,error)
      if (error) return
      trail(2:3) = key(1:2)
    endif
    !
    if (isfile) then
      cline = 'COMPARE '//trim(cleft)//' '//trim(cright)
      i = len_trim(cline)
      call sic_analyse(comm,cline,i,error)
      call compare_comm_args(cline,cleft,cright,isfile,error)
      if (error) return
    endif
    !
    call sic_descriptor(cleft,ldesc,found)
    if ((ldesc%ndim.eq.3).and.(ldesc%dims(3).eq.1)) ldesc%ndim = 2
    call sic_descriptor(cright,rdesc,found)
    if ((rdesc%ndim.eq.3).and.(rdesc%dims(3).eq.1)) rdesc%ndim = 2
    !
    if ( (ldesc%ndim.eq.2).and.(rdesc%ndim.eq.2) ) then
      is2d = .true.
    else 
      is2D = .false.
    endif
    if (sic_varexist('CMP%FIRST')) call exec_program('LET CMP%FIRST YES')
    !!Print *,'Is 2D ? ',is2d,' Left ',ldesc%dims(1:ldesc%ndim),' Right ',rdesc%dims(1:rdesc%ndim)
    !
  endif
  !
  todo = .false.
  call get_topdir(line,o_dir)
  call exec_program('@ p_clear')
  !
  if (is2d) then  
    call exec_program('@ p_compare_map '//trim(cleft)//' '//trim(cright)//trail)
  else
    call exec_program('@ p_compare_sub '//trim(cleft)//' '//trim(cright)//trail)
  endif
  !
  if (do_insert) call sic_insert_log(line)
end subroutine compare_comm
   
subroutine compare_comm_args(line,cleft,cright,isfile,error)
  use gkernel_interfaces
  use gkernel_types
  use gbl_message
  use imager_interfaces, only : map_message
  !-------------------------------------------------------------------
  ! @ private
  ! IMAGER
  !   Support for command COMPARE Left Right [/DIRECTORY <top]
  !   and COMPARE ? or COMPARE ??
  !-------------------------------------------------------------------
  character(len=*), intent(in) :: line    ! Command line
  character(len=*), intent(out) :: cleft
  character(len=*), intent(out) :: cright
  logical, intent(out) :: isfile        ! One of these is a file
  logical, intent(out) :: error         ! Error flag
  !
  ! Global
  integer, parameter :: o_dir=1
  character(len=*), parameter :: rname='COMPARE'
  !
  ! Local
  character(len=filename_length) :: chain
  character(len=filename_length) :: file, leftfile, rightfile
  integer :: n
  !
  logical :: found, ileft, iright
  !
  type(gildas), save :: hleft, hright
  !
  ! Code
  call sic_ch(line,0,1,chain,n,.true.,error)
  ! Is it a file ?
  if (index(chain,'.').ne.0) then
    !
    ! Discard the default image
    if (sic_varexist('CMP_LEFT')) call sic_delvariable('CMP_LEFT',.false.,error)
    found = sic_findfile(chain,file,' ',' ')
    if (.not.found) then
      call map_message(seve%e,rname,'No such file '//trim(file))
      error = .true.
    else
      cleft =' CMP_LEFT'
      leftfile = file
    endif
    ileft = .true. ! It is an image
  else
    cleft = chain
    call sic_upper(cleft)
    ileft = .false. ! A Variable
  endif
  !
  call sic_ch(line,0,2,chain,n,.true.,error)
  ! Is it a file ?
  if (index(chain,'.').ne.0) then
    !
    ! Discard the default image
    if (sic_varexist('CMP_RIGHT')) call sic_delvariable('CMP_RIGHT',.False.,error)
    found = sic_findfile(chain,file,' ',' ')
    if (.not.found) then
      call map_message(seve%e,rname,'No such file  '//trim(file))
      error = .true.
    else
      cright =' CMP_RIGHT'
      rightfile = file
    endif
    iright = .true. ! It is an image
  else
    cright = chain
    call sic_upper(cright)
    iright = .false. ! It is a variable
  endif
  if (error) return
  !
  if (ileft) then
    call read_and_map('CMP_LEFT',hleft,leftfile,error)
  else if (.not.sic_varexist(cleft)) then
    call map_message(seve%e,rname,'No such variable '//trim(cleft))
    error = .true.
  endif
  if (iright) then
    call read_and_map('CMP_RIGHT',hright,rightfile,error)
  else if (.not.sic_varexist(cright)) then
    call map_message(seve%e,rname,'No such variable '//trim(cright))
    error = .true.
  endif
  isfile = ileft.or.iright
end subroutine compare_comm_args
   
subroutine read_and_map(name,head,file,error)
  use gkernel_types
  use gbl_message
  use gkernel_interfaces
  use imager_interfaces, only : map_message
  !
  character(len=*), intent(in) :: name
  character(len=*), intent(inout) :: file
  type(gildas), intent(inout) :: head
  logical, intent(out) :: error
  !
  character(len=*), parameter :: rname='COMPARE'
  logical :: err
  integer :: ier
  !
  err = .false.
  error = .false.
  ier = 0
  if (associated(head%r3d)) deallocate(head%r3d,stat=ier)
  if (ier.ne.0) call map_message(seve%w,rname,'Deallocation error')
  call gildas_null(head)
  call gdf_read_gildas(head, file,' ', error, data=.false.)
  if (error) return
  !
  if (product(head%gil%dim(4:)).gt.1) then
    call map_message(seve%e,rname,'Only Maps and Cubes supported')
    call gdf_close_image(head,err)
    error = .true.
    return
  endif
  !
  allocate(head%r3d(head%gil%dim(1),head%gil%dim(2),   &
   &        head%gil%dim(3)),stat=ier)
  if (ier.ne.0) then
    call map_message(seve%w,rname,'Data Allocation error')
    call gdf_close_image(head,err)
    error = .true.
    return
  endif
  call gdf_read_data(head,head%r3d,error)
  call gdf_close_image(head,err)
  if (error) return
  if (product(head%gil%dim(3:)).le.1) head%gil%ndim = 2
  call sic_mapgildas (name,head,error,head%r3d)
  !  
end subroutine read_and_map
