###########################################################################
#
# This file defines useful bash functions for GILDAS/USERS interaction
# at IRAM Grenoble.
#
# Warnings:
#
#   This files is loaded very early in the logging process.
#   You thus must put here only fonction and variable definitions.
#
#   Forbidden stuffs: 
#      1. DISPLAY and KEYBOARD related variable definitions.
#      2. Any executable commands.
#
# J.Pety and P.Dumontroty 2004
#
###########################################################################
#
# This function loads the GILDAS environment of the corresponding version.
# Type "gagiram -h" for more details. 
#
function gagiram() { 
    export gaghome=~gildas/gildas
    source $gaghome/gildas-admin/source-gag.sh "$@"
    set --
    if [ -f ~gildas/bin/set-iram-gag-search-path ]; then
        source ~gildas/bin/set-iram-gag-search-path
    fi
}
#
function gagiramgit() { 
    # Non-public function which loads Gildas compiled from git
    export gaghome=~gildas/gildas-git
    source $gaghome/gildas-admin/source-gag.sh "$@"
    set --
    if [ -f ~gildas/bin/set-iram-gag-search-path ]; then
        source ~gildas/bin/set-iram-gag-search-path
    fi
}
#
# This function enables easy browsing of the GILDAS source or executable 
# tree. $gagsrcdir and $gagexedir must be defined. You can use 
# "gagiram -ms" or "gagiram -me" to define them. 
# Type "go -h" for more details.
#
function go() {
    if [ -z "$gagadmdir" ]; then
	echo 'Please select first a GILDAS version using gagiram' 1>&2
    else
	source $gagadmdir/go.sh "$@"
    fi
}
#
# Gfortran compiler is different from one OS to another
if [ `cut -d" " -f1 /etc/redhat-release` = "CentOS" ]; then
    GAGIRAM_GFORTRAN=gfortran81  # For CentOS 7.4
else
    GAGIRAM_GFORTRAN=gfortran62  # for Scientific Linux 6.4 and 6.8
fi
#
# Shortcut for parallel version compiled at IRAM. This hides details
# about compiler (kind and version) and config used:
function gagpara() {
    gagiram -c $GAGIRAM_GFORTRAN -o openmp "$@"
}
#
# Shortcut for profiling version compiled at IRAM. This hides details
# about compiler (kind and version) and config used:
function gagprofile() {
    gagiram -c $GAGIRAM_GFORTRAN -o profile "$@"
}
#
# Shortcut for sanitizer version compiled at IRAM. This hides details
# about compiler (kind and version) and config used:
function gagsanitize() {
    gagiram -c $GAGIRAM_GFORTRAN -o sanitize "$@"
}
#
# GIT public shortcuts
function gitiram() {  # Default is parallel version
    gagiramgit -c $GAGIRAM_GFORTRAN -o openmp "$@"
}
function gitpara() {
    gagiramgit -c $GAGIRAM_GFORTRAN -o openmp "$@"
}
function gitserial() {
    gagiramgit -c $GAGIRAM_GFORTRAN "$@"
}
#
# PIIC shortcut
function gagpiic() {
    export gaghome=~gildas/piic
    source $gaghome/gildas-admin/source-gag.sh "$@"
    set --
    if [ -f ~gildas/bin/set-iram-gag-search-path ]; then
        source ~gildas/bin/set-iram-gag-search-path
    fi
}
#
export -f gagiram gagiramgit go gagpara gagprofile gagsanitize gitiram gitpara gitserial gagpiic
export GAGIRAM_GFORTRAN
#
# The next command automatically loads the environment variables
# needed for the default GILDAS version (ie last fully compiled).
# That standard IRAM users will have a working GILDAS version without
# any personal customization. The user (in particular developers) may
# decide to avoid this just by creating the following file:
# $HOME/.no-initial-gagiram
#
if [ ! -e $HOME/.no-initial-gagiram ]; then
    gagiram > /dev/null 2>&1
fi
#
###########################################################################
