###########################################################################
#
# Shell verification. Try to be robust => very simple.
#
GAG_SHELL_TEST="shell test" || echo "define-version.sh error: You must be under a sh-compatible shell!"
GAG_SHELL_TEST="shell test" || exit 1
unset GAG_SHELL_TEST
#
###########################################################################
#
# Main function definition
#
gagdefver() {
    #
    # Variable and function definitions
    #
    DEFVER_AUTHOR='J. Pety <pety@iram.fr>'
    DEFVER_PROJECT='GILDAS  <http://www.iram.fr/IRAMFR/GILDAS>'
    DEFVER_PROGNAME='gagdefver'
    #
    defver_usage() {
	cat <<EOF 1>&2

Define standard directory name conventions used by the "build" and
"source-gag.sh" scripts to enable easy coexistence of different GILDAS
version. To do this, define the following environment variables: 
   GAG_VERS, GAG_TAG, SRCDIR, EXEDIR, LOGDIR

usage: source $DEFVER_PROGNAME [version]

options:
  -d     Refine GAG_VERS with tag date if possible
  -n     Do not translate 'day' or 'month' to current day or month, but
         assume that directories (or symlinks to) exist with the input
         version name.
  -r     Mark the version as reference
  -h     Show this help page
  -v     Show version information

EOF
	defver_clean
    }
    #
    defver_showversion() {
	echo "$DEFVER_PROGNAME, by $DEFVER_AUTHOR"
	echo "Project: $DEFVER_PROJECT"
	defver_clean
    }
    #
    defver_message() {
	echo "$DEFVER_PROGNAME: $1"
    }
    #
    defver_error() {
	echo 1>&2
	echo "$DEFVER_PROGNAME error: $1" 1>&2
	echo 1>&2
	defver_clean
    }
    #
    defver_clean() {
	unset defver_usage defver_showversion defver_message 
	unset defver_error defver_clean defver_ref
	unset defver_tagdate defver_date
	unset DEFVER_AUTHOR DEFVER_PROGNAME DEFVER_PROJECT
	unset DEFVER_INVERS DEFVER_OUTVERS
    }
    #
    #######################################################################
    #
    # Option parsing
    #
    temp=`getopt "dnrhv" "$@"`
    if [ $? -ne 0 ]; then defver_usage; return 2; fi
    eval set -- "$temp"
    unset temp
    while [ $1 != -- ]; do
	case $1 in
	-d) defver_date=1 ;;
	-r) defver_ref=1 ;;
	-n) defver_not=1 ;;
	-v) defver_showversion; return 0 ;;
	-h) defver_usage; return 0 ;;
	esac
	shift # Next flag
    done
    shift # Skip double dash
    case $# in
	0) DEFVER_INVERS="default";; # Default version defined below!
	1) DEFVER_INVERS=$1;;
	*) defver_usage;  return 2 ;;
    esac
    set abc; shift # This line to avoid remanence effect in a portable way
    #
    #######################################################################
    #
    # day is an alias for the current day
    # (ie 2 digit day + the first 3 letters of the current month)
    #
    # month is an alias for the current month
    # (ie the first 3 letters of the current month + last 2 digits of current year).
    #
    case $DEFVER_INVERS in
	day)     if [ "$defver_not" ]; then DEFVER_OUTVERS=$DEFVER_INVERS; else DEFVER_OUTVERS=`date '+%d%b' | tr '[:upper:]' '[:lower:]'`; fi ;;
	month)   if [ "$defver_not" ]; then DEFVER_OUTVERS=$DEFVER_INVERS; else DEFVER_OUTVERS=`date '+%b%y' | tr '[:upper:]' '[:lower:]'`; fi ;;
	default) DEFVER_OUTVERS="last";;
	*)       if [ "$defver_ref" ]; then DEFVER_OUTVERS="ref"; else DEFVER_OUTVERS=$DEFVER_INVERS; fi
    esac
    #
    #######################################################################
    #
    # dev is equivalent to main trunk.
    #
    case $DEFVER_INVERS in
	default|month) GAG_TAG=$DEFVER_OUTVERS;;
	dev)           GAG_TAG="HEAD";;
	*)             GAG_TAG=$DEFVER_INVERS
    esac
    export GAG_TAG
    #
    #######################################################################
    #
    # Refine GAG_VERS with tag date when asked and possible
    #
    GAG_VERS=$DEFVER_OUTVERS
    if [ "$defver_date" ]; then
	unset defver_tagdate
	if [ "$GAG_TAG" = "HEAD" ]; then
	    defver_tagdate=`date -R`
	elif cvs history -aT 2> /dev/null  | grep "${GAG_TAG}" > /dev/null; then
	    defver_tagdate=`cvs history -aT | grep ${GAG_TAG} | tail -1 | cut -d' ' -f2-4`
	fi
	if [ -n "$defver_tagdate" ]; then
	    defver_date=`date -d "${defver_tagdate}" "+%d%b%y %H:%M %Z"` || defver_date=$defver_tagdate
	    if [ $? -eq 0 ]; then
		defver_date=`echo ${defver_date} | tr '[:upper:]' '[:lower:]'`
	    fi
	    GAG_VERS="${GAG_VERS} (${defver_date})"
	fi
    fi
    export GAG_VERS
    #
    #######################################################################
    #
    if [ -z "$gaghome" ]; then
	gaghome=$HOME/gildas
    fi
    export gaghome
    #
    #######################################################################
    #
    SRCDIR=$gaghome/gildas-src-$DEFVER_OUTVERS
    EXEDIR=$gaghome/gildas-exe-$DEFVER_OUTVERS
    LOGDIR=$gaghome/logs/$DEFVER_OUTVERS
    export SRCDIR EXEDIR LOGDIR
    #
    #######################################################################
    #
    defver_clean
}
#
###########################################################################
