/*
Copyright (c) 2002 Regents of The University of Michigan.
All Rights Reserved.

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appears in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of The University
of Michigan not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission. This software is supplied as is without expressed or
implied warranties of any kind.

Research Systems Unix Group
The University of Michigan
c/o Wesley Craig
4251 Plymouth Road B1F2, #2600
Ann Arbor, MI 48105-2785

http://rsug.itd.umich.edu/software/ihook
ihook@umich.edu
*/

#import "LHWindow.h"

@implementation LHWindow

- ( id )init
{
    self = [ super init ];
    if ( self ) {
	windowZoom = YES;
    }
    
    return( self );
}

/* window will not respond to update messages unless this returns true */
- ( BOOL )canBecomeKeyWindow
{
    return( YES );
}

- ( void )setWindowZoomEnabled: ( BOOL )wz
{
    windowZoom = wz;
}

- ( BOOL )windowZoom
{
    return( windowZoom );
}

- ( NSPoint )centeredOriginForWindowSize: ( NSSize )wSize
{
    NSRect	screensize = [[ NSScreen mainScreen ] frame ];
    NSPoint	op;
    float	newx, newy;
        
    newx = (( screensize.size.width - wSize.width ) / 2 );
    newy = (( screensize.size.height - wSize.height ) / 2 );
    op = NSMakePoint( newx, newy );
    
    return( op );
}

- ( NSPoint )quadrantOneOriginForWindowSize: ( NSSize )wSize
{
    NSRect 	screensize = [[ NSScreen mainScreen ] frame ];
    NSPoint	op;
    float	newx, newy;
    
    newx = (( screensize.size.width - wSize.width ) - 20 );
    newy = (( screensize.size.height - wSize.height ) - 30 );
    op = NSMakePoint( newx, newy );
    
    return( op );
}

- ( NSPoint )quadrantTwoOriginForWindowSize: ( NSSize )wSize
{
    NSRect 	screensize = [[ NSScreen mainScreen ] frame ];
    NSPoint	op;
    float	newx, newy;
    
    newx = 20;
    newy = (( screensize.size.height - wSize.height ) - 30 );
    op = NSMakePoint( newx, newy );
    
    return( op );
}

- ( NSPoint )quadrantThreeOriginForWindowSize: ( NSSize )wSize
{
    NSPoint	op;
    float	newx, newy;
    
    newx = 20;
    newy = 20;
    op = NSMakePoint( newx, newy );
    
    return( op );
}

- ( NSPoint )quadrantFourOriginForWindowSize: ( NSSize )wSize
{
    NSRect 	screensize = [[ NSScreen mainScreen ] frame ];
    NSPoint	op;
    float	newx, newy;
    
    newx = (( screensize.size.width - wSize.width ) - 20 );
    newy = 20;
    op = NSMakePoint( newx, newy );
    
    return( op );
}

@end
