//
//  AMAuthorization.m
//  rsm
//
//  Created by Andrew Mortensen on 6/23/08.
//  Copyright 2008 University of Michigan, The. All rights reserved.
//

#import "AMAuthorization.h"

@implementation AMAuthorization

+ ( AMAuthorization * )authorizationWithName: ( NSString * )name
{
    return( [ AMAuthorization authorizationWithName: name preAuthorize: NO
				   allowInteraction: NO extendRights: NO ] );
}

+ ( AMAuthorization * )authorizationWithName: ( NSString * )name
			        preAuthorize: ( BOOL )preAuthorize
			    allowInteraction: ( BOOL )allowInteraction
			        extendRights: ( BOOL )extendRights
{
    AMAuthorization	    *auth;
    
    auth = [[[ AMAuthorization alloc ] init ] autorelease ];
    
    return( [ auth initWithName: name preAuthorize: preAuthorize
	       allowInteraction: allowInteraction extendRights: extendRights ]);
}

- ( AMAuthorization * )initWithName: ( NSString * )name
{
    return( [ self initWithName: name preAuthorize: NO
	       allowInteraction: NO extendRights: NO ] );
}

- ( AMAuthorization * )initWithName: ( NSString * )name
		       preAuthorize: ( BOOL )preAuthorize
		   allowInteraction: ( BOOL )allowInteraction
		       extendRights: ( BOOL )extendRights
{
    OSStatus		    status;
    
    memset( &authorizationItem, 0, sizeof( AuthorizationItem ));
    if (( authorizationItem.name = strdup( [ name UTF8String ] )) == NULL ) {
	return( nil );
    }
    
    authorizationRights.count = 1;
    authorizationRights.items = &authorizationItem;
    
    authorizationFlags = kAuthorizationFlagDefaults;
    if ( preAuthorize ) {
	authorizationFlags |= kAuthorizationFlagPreAuthorize;
    }
    if ( allowInteraction ) {
	authorizationFlags |= kAuthorizationFlagInteractionAllowed;
    }
    if ( extendRights ) {
	authorizationFlags |= kAuthorizationFlagExtendRights;
    }
    
    authorizationRef = NULL;
    status = AuthorizationCreate( NULL, kAuthorizationEmptyEnvironment,
			     kAuthorizationFlagDefaults, &authorizationRef );
    if ( status != errAuthorizationSuccess ) {
	free(( void * )authorizationItem.name );
	return( nil );
    }
    
    return( self );
}

- ( BOOL )authorize
{
    OSStatus		status;
    
    status = AuthorizationCopyRights( authorizationRef, &authorizationRights,
				     kAuthorizationEmptyEnvironment,
				     authorizationFlags, NULL );
    if ( status != errAuthorizationSuccess ) {
	AuthorizationFree( authorizationRef, kAuthorizationFlagDefaults );
	return( NO );
    }
    
    return( YES );
}

- ( BOOL )makeExternalForm: ( AuthorizationExternalForm * )externalForm
{
    if ( AuthorizationMakeExternalForm( authorizationRef,
				   externalForm ) != errAuthorizationSuccess ) {
	return( NO );
    }
    
    return( YES );
}

/* for managed memory environments */
- ( void )dealloc
{
    if ( authorizationItem.name != NULL ) {
	free(( void * )authorizationItem.name );
	memset( &authorizationItem, 0, sizeof( AuthorizationItem ));
    }
    if ( authorizationRef != NULL ) {
	AuthorizationFree( authorizationRef, kAuthorizationFlagDefaults );
	authorizationRef = NULL;
    }
    
    [ super dealloc ];
}

/* for garbage collection environments */
- ( void )finalize
{
    if ( authorizationItem.name != NULL ) {
	free(( void * )authorizationItem.name );
	memset( &authorizationItem, 0, sizeof( AuthorizationItem ));
    }
    if ( authorizationRef != NULL ) {
	AuthorizationFree( authorizationRef, kAuthorizationFlagDefaults );
	authorizationRef = NULL;
    }
    
    [ super finalize ];
}

/* synthesized accessors */
@synthesize	    authorizationRef;
@synthesize	    authorizationFlags;
@synthesize	    authorizationItem;
@synthesize	    authorizationRights;

@end
