/* A structure which contains information on 
   the commands this program can understand. */

typedef  IFF_INTERN(int) Func(); 

typedef struct {
  char *name;	  /* function name */
  Func *func;     /* internal function to call to do the job. */
  char *desc;	  /* brief description of this function.  */
  char *doc;	  /* full documentation for this function.  */
} COMMAND;

COMMAND commands[] = {
  {"read_data",  iff_exec, 
   "read from data file",
   "read_data(file=input.xmu, group=input, label='energy xmu')"},
  {"write_data", iff_exec, 
   "write to data file",
   "write_data(file=out.dat, group.1, group.2, ...)"},
  {"plot",       iff_exec, 
   "plot x-y arrays (overplot)",
   "plot(group.x, group.y)"},
  {"newplot",    iff_exec, 
   "start a new plot",
   "newplot(group.x, group.y)"},
  {"zoom",        iff_exec, 
   "choose plotting window with cursor",  
   "zoom"},
  {"cursor",      iff_exec, 
   "get the coordinates of the cursor",
   "cursor(show)\n    to put cursor positions to variables cursor_x and cursor_y "},
  {"color",       iff_exec, 
   "update an index in the plotting color table",
   "color(bg= white, 1=red, 2=blue)"},
  {"linestyle",   iff_exec, 
   "update an index in the plotting style table",
   "linestyle(1=solid, 2=linestyle2, 3=dashed) "},
  {"pre_edge",   iff_exec, 
   "pre_edge removal of mu(E) data",
   "pre_edge(group.energy, group.xmu)"},
  {"spline",     iff_exec, 
   "autobk-style background",
   "spline(group.energy, group.xmu, rbkg=1.0, kweight=1)"},
  {"fftf",       iff_exec, 
   "forward XAFS Fourier Transform",
   "fftf(real=group.chi, kmin=1.0, kmax=16, kweight=2)"},
  {"fftr",       iff_exec, 
   "reverse XAFS Fourier Transform",
   "fftr(real=group.chir_re, imag=group.chir_im,\n          rmin=1.0, rmax=2.8, dr=0.1)"},
  {"path",       iff_exec, 
   "define a FEFF path and path parameters",
   "path(001, feff= ../feff0001.dat,\n          e0 = e0_var, s02 = s02_var)"},
  {"ff2chi",      iff_exec, 
   "convert list of paths to chi(k) (see also: paths,feffit)",
   "ff2chi(1,2,3, group=f)"},
  { "feffit",     iff_exec, 
    "fit chi(k) data to a set of paths (see also: paths,ff2chi)",
    "feffit(data = input.chi, 001,002, kmin=2,\n            kmax=15, rmin=1, rmax=3.)"},
  {"minimize",    iff_exec, 
   "generalized fitting", " "},
  { "set",        iff_exec, 
    "set variable value, without storing definition",
    "set xvar = 1.2\n     set yvar = 3 * xvar\n     set group.x = indarr(100)\n     set group.y = sin(group.x)"},
  { "def",        iff_exec, 
    "define variables, store definition (see also: set)",
    "def yvar = xvar * 3"},
  {"guess",       iff_exec, 
   "define a variable as a fitting parameter",
   "guess s02 = 0.9, del_r = 0.01 "},
  {"rename", iff_exec, "rename a variable",
   "rename old_var  new_var "},
  { "load",       iff_exec, 
    "load a command file", 
    "load Fit_data.iff"},
  { "erase",      iff_exec, 
    "erase variables" , 
    "erase xvar, yvar, group.x"},
  {"macro",       iff_exec, 
   "define a macro",
   "macro  'default 1'\n         print $1\n    end macro"},
  { "show",       iff_exec, 
    "show variables, paths, macros, etc" , 
    "show xvar"},
  { "print",      iff_exec, 
    "print variables or expression (see also: show)" , 
    "print xvar\n     print 3*xvar, $my_string"},
  {"echo",        iff_exec, 
   "write to screen",
   "echo 'This is a message'"},
  {"pause",       iff_exec, 
   "wait for user input",
   " pause == hit any key to continue =="},
  {"restore", iff_exec, 
   "restore session from save file (see also: save)",
   "restore(cu_analysis.sav)"},
  {"save", iff_exec, 
   "save session to a save file (see also: restore)",
   "save(cu_analysis.sav)"},
  { "quit",       iff_exec, "exit the program", "quit" },
  { "exit",       iff_exec, "exit the program", "exit" },
  { "help",       sys_help, "Display help on commands", 
    "help        \n to get list of commands with brief description \n     help read_data\n to get more complete documentation on a command" },
  { "dir",        com_list, "file listing", "dir *.dat" },
  { "cd",         com_cd,   "change directory" , "cd ../"},
  { "pwd",        com_pwd,  "print working directory", "pwd" },
  { "more",       com_more, "view file contents one page at a time", 
    "more cu.xmu" },
  { "!",          sys_exec, "send commands to DOS shell", 
    "! emacs My.iff &" },
  {(char *)NULL, (Func *)NULL, (char *)NULL ,  (char *)NULL }
};

COMMAND *find_command ();
