/* Current File: icoconvert.h
 * 
 * Chris Moates  05/31/2001
 * six@mox.net
 * 
 */

/* Original File : icod.h

   Simon Drabble	02/05/99
   madlather@syspac.com

   (C) 1998 - 1999  Simon Drabble


   This program and its associated code are released under
   the Gnu Public Licence (GPL). This basically states you
   are free to modify and distribute the software provided
   you do not prevent anyone else doing the same.        
   For a full copy of the licence, see www.gnu.org/copyleft/gpl.html

*/


#ifndef ICOCONVERT_H
#define ICOCONVERT_H

typedef unsigned char	BYTE;
typedef	short int	WORD;
typedef int		DWORD;
typedef long		LONG;


typedef struct {

  BYTE	bWidth;
  BYTE	bHeight;
  BYTE	bColourCount;
  BYTE	bReserved;
  WORD	wPlanes;
  WORD	wBitCount;
  DWORD	dwBytesInRes;
  DWORD	dwImageOffset;

} ICONDIRENTRY;


typedef struct {

  WORD		idReserved;
  WORD		idType;
  WORD		idCount;
  ICONDIRENTRY *idEntries;

} ICONDIR;
  
typedef struct {

  DWORD		biSize;
  LONG		biWidth;
  LONG		biHeight;
  WORD		biPlanes;
  WORD		biBitCount;
  DWORD		biCompression;
  DWORD		biSizeImage;
  LONG		biXPelsPerMeter;
  LONG		biYPelsPerMeter;
  DWORD		biClrUsed;
  DWORD		biClrImportant;

} BITMAPINFOHEADER;

typedef struct {

  BYTE	blue;
  BYTE	green;
  BYTE	red;
  BYTE	alpha;

} RGBQUAD;

typedef struct {
 
  BITMAPINFOHEADER	icHeader;
  RGBQUAD		*icColours;
  BYTE			*icXOR;
  BYTE			*icAND;

} ICONIMAGE;

// Defs for Mr. -Wall
int check_transparency(int, int, ICONIMAGE *);
int ico2png(ICONIMAGE *);
int load_icon(char *);
int load_icon_file(FILE *);
int load_icon_image(FILE *, int, ICONDIR *);
int process_24bit(ICONIMAGE *);
int process_32bit(ICONIMAGE *);
int write_png(ICONIMAGE *, gdImage *);

#ifdef DEBUG
int dump_andmask(ICONIMAGE *);
#endif // DEBUG

#endif
