//
//  NSCharacterSet+iTerm.m
//  iTerm2
//
//  Created by George Nachman on 3/29/15.
//
//

#import "NSCharacterSet+iTerm.h"
#import "iTermAdvancedSettingsModel.h"

@implementation NSCharacterSet (iTerm)
// Ranges are generated list list_to_range.py and range_to_range.py scripts in the tools folder.

// http://unicode.org/reports/tr36/idn-chars.html
+ (instancetype)idnCharacters {
    static dispatch_once_t onceToken;
    static NSCharacterSet *idnCharacters;
    dispatch_once(&onceToken, ^{
        NSMutableCharacterSet *set = [[[NSMutableCharacterSet alloc] init] autorelease];
        [set addCharactersInRange:NSMakeRange(0x61, 1)];
        [set addCharactersInRange:NSMakeRange(0x27, 1)];
        [set addCharactersInRange:NSMakeRange(0x2d, 2)];
        [set addCharactersInRange:NSMakeRange(0x30, 11)];
        [set addCharactersInRange:NSMakeRange(0x41, 26)];
        [set addCharactersInRange:NSMakeRange(0x62, 25)];
        [set addCharactersInRange:NSMakeRange(0xa1, 7)];
        [set addCharactersInRange:NSMakeRange(0xa9, 6)];
        [set addCharactersInRange:NSMakeRange(0xb0, 4)];
        [set addCharactersInRange:NSMakeRange(0xb5, 3)];
        [set addCharactersInRange:NSMakeRange(0xb9, 360)];
        [set addCharactersInRange:NSMakeRange(0x222, 18)];
        [set addCharactersInRange:NSMakeRange(0x250, 94)];
        [set addCharactersInRange:NSMakeRange(0x2b0, 40)];
        [set addCharactersInRange:NSMakeRange(0x2de, 114)];
        [set addCharactersInRange:NSMakeRange(0x360, 16)];
        [set addCharactersInRange:NSMakeRange(0x374, 2)];
        [set addCharactersInRange:NSMakeRange(0x386, 5)];
        [set addCharactersInRange:NSMakeRange(0x38c, 1)];
        [set addCharactersInRange:NSMakeRange(0x38e, 20)];
        [set addCharactersInRange:NSMakeRange(0x3a3, 44)];
        [set addCharactersInRange:NSMakeRange(0x3d0, 39)];
        [set addCharactersInRange:NSMakeRange(0x400, 135)];
        [set addCharactersInRange:NSMakeRange(0x488, 71)];
        [set addCharactersInRange:NSMakeRange(0x4d0, 38)];
        [set addCharactersInRange:NSMakeRange(0x4f8, 2)];
        [set addCharactersInRange:NSMakeRange(0x500, 16)];
        [set addCharactersInRange:NSMakeRange(0x531, 38)];
        [set addCharactersInRange:NSMakeRange(0x559, 7)];
        [set addCharactersInRange:NSMakeRange(0x561, 39)];
        [set addCharactersInRange:NSMakeRange(0x589, 2)];
        [set addCharactersInRange:NSMakeRange(0x591, 17)];
        [set addCharactersInRange:NSMakeRange(0x5a3, 23)];
        [set addCharactersInRange:NSMakeRange(0x5bb, 10)];
        [set addCharactersInRange:NSMakeRange(0x5d0, 27)];
        [set addCharactersInRange:NSMakeRange(0x5f0, 5)];
        [set addCharactersInRange:NSMakeRange(0x60c, 1)];
        [set addCharactersInRange:NSMakeRange(0x61b, 1)];
        [set addCharactersInRange:NSMakeRange(0x61f, 1)];
        [set addCharactersInRange:NSMakeRange(0x621, 26)];
        [set addCharactersInRange:NSMakeRange(0x640, 22)];
        [set addCharactersInRange:NSMakeRange(0x660, 125)];
        [set addCharactersInRange:NSMakeRange(0x6de, 16)];
        [set addCharactersInRange:NSMakeRange(0x6f0, 15)];
        [set addCharactersInRange:NSMakeRange(0x700, 14)];
        [set addCharactersInRange:NSMakeRange(0x710, 29)];
        [set addCharactersInRange:NSMakeRange(0x730, 27)];
        [set addCharactersInRange:NSMakeRange(0x780, 50)];
        [set addCharactersInRange:NSMakeRange(0x901, 3)];
        [set addCharactersInRange:NSMakeRange(0x905, 53)];
        [set addCharactersInRange:NSMakeRange(0x93c, 18)];
        [set addCharactersInRange:NSMakeRange(0x950, 5)];
        [set addCharactersInRange:NSMakeRange(0x958, 25)];
        [set addCharactersInRange:NSMakeRange(0x981, 3)];
        [set addCharactersInRange:NSMakeRange(0x985, 8)];
        [set addCharactersInRange:NSMakeRange(0x98f, 2)];
        [set addCharactersInRange:NSMakeRange(0x993, 22)];
        [set addCharactersInRange:NSMakeRange(0x9aa, 7)];
        [set addCharactersInRange:NSMakeRange(0x9b2, 1)];
        [set addCharactersInRange:NSMakeRange(0x9b6, 4)];
        [set addCharactersInRange:NSMakeRange(0x9bc, 1)];
        [set addCharactersInRange:NSMakeRange(0x9be, 7)];
        [set addCharactersInRange:NSMakeRange(0x9c7, 2)];
        [set addCharactersInRange:NSMakeRange(0x9cb, 3)];
        [set addCharactersInRange:NSMakeRange(0x9d7, 1)];
        [set addCharactersInRange:NSMakeRange(0x9dc, 2)];
        [set addCharactersInRange:NSMakeRange(0x9df, 5)];
        [set addCharactersInRange:NSMakeRange(0x9e6, 21)];
        [set addCharactersInRange:NSMakeRange(0xa02, 1)];
        [set addCharactersInRange:NSMakeRange(0xa05, 6)];
        [set addCharactersInRange:NSMakeRange(0xa0f, 2)];
        [set addCharactersInRange:NSMakeRange(0xa13, 22)];
        [set addCharactersInRange:NSMakeRange(0xa2a, 7)];
        [set addCharactersInRange:NSMakeRange(0xa32, 2)];
        [set addCharactersInRange:NSMakeRange(0xa35, 2)];
        [set addCharactersInRange:NSMakeRange(0xa38, 2)];
        [set addCharactersInRange:NSMakeRange(0xa3c, 1)];
        [set addCharactersInRange:NSMakeRange(0xa3e, 5)];
        [set addCharactersInRange:NSMakeRange(0xa47, 2)];
        [set addCharactersInRange:NSMakeRange(0xa4b, 3)];
        [set addCharactersInRange:NSMakeRange(0xa59, 4)];
        [set addCharactersInRange:NSMakeRange(0xa5e, 1)];
        [set addCharactersInRange:NSMakeRange(0xa66, 15)];
        [set addCharactersInRange:NSMakeRange(0xa81, 3)];
        [set addCharactersInRange:NSMakeRange(0xa85, 7)];
        [set addCharactersInRange:NSMakeRange(0xa8d, 1)];
        [set addCharactersInRange:NSMakeRange(0xa8f, 3)];
        [set addCharactersInRange:NSMakeRange(0xa93, 22)];
        [set addCharactersInRange:NSMakeRange(0xaaa, 7)];
        [set addCharactersInRange:NSMakeRange(0xab2, 2)];
        [set addCharactersInRange:NSMakeRange(0xab5, 5)];
        [set addCharactersInRange:NSMakeRange(0xabc, 10)];
        [set addCharactersInRange:NSMakeRange(0xac7, 3)];
        [set addCharactersInRange:NSMakeRange(0xacb, 3)];
        [set addCharactersInRange:NSMakeRange(0xad0, 1)];
        [set addCharactersInRange:NSMakeRange(0xae0, 1)];
        [set addCharactersInRange:NSMakeRange(0xae6, 10)];
        [set addCharactersInRange:NSMakeRange(0xb01, 3)];
        [set addCharactersInRange:NSMakeRange(0xb05, 8)];
        [set addCharactersInRange:NSMakeRange(0xb0f, 2)];
        [set addCharactersInRange:NSMakeRange(0xb13, 22)];
        [set addCharactersInRange:NSMakeRange(0xb2a, 7)];
        [set addCharactersInRange:NSMakeRange(0xb32, 2)];
        [set addCharactersInRange:NSMakeRange(0xb36, 4)];
        [set addCharactersInRange:NSMakeRange(0xb3c, 8)];
        [set addCharactersInRange:NSMakeRange(0xb47, 2)];
        [set addCharactersInRange:NSMakeRange(0xb4b, 3)];
        [set addCharactersInRange:NSMakeRange(0xb56, 2)];
        [set addCharactersInRange:NSMakeRange(0xb5c, 2)];
        [set addCharactersInRange:NSMakeRange(0xb5f, 3)];
        [set addCharactersInRange:NSMakeRange(0xb66, 11)];
        [set addCharactersInRange:NSMakeRange(0xb82, 2)];
        [set addCharactersInRange:NSMakeRange(0xb85, 6)];
        [set addCharactersInRange:NSMakeRange(0xb8e, 3)];
        [set addCharactersInRange:NSMakeRange(0xb92, 4)];
        [set addCharactersInRange:NSMakeRange(0xb99, 2)];
        [set addCharactersInRange:NSMakeRange(0xb9c, 1)];
        [set addCharactersInRange:NSMakeRange(0xb9e, 2)];
        [set addCharactersInRange:NSMakeRange(0xba3, 2)];
        [set addCharactersInRange:NSMakeRange(0xba8, 3)];
        [set addCharactersInRange:NSMakeRange(0xbae, 8)];
        [set addCharactersInRange:NSMakeRange(0xbb7, 3)];
        [set addCharactersInRange:NSMakeRange(0xbbe, 5)];
        [set addCharactersInRange:NSMakeRange(0xbc6, 3)];
        [set addCharactersInRange:NSMakeRange(0xbca, 4)];
        [set addCharactersInRange:NSMakeRange(0xbd7, 1)];
        [set addCharactersInRange:NSMakeRange(0xbe7, 12)];
        [set addCharactersInRange:NSMakeRange(0xc01, 3)];
        [set addCharactersInRange:NSMakeRange(0xc05, 8)];
        [set addCharactersInRange:NSMakeRange(0xc0e, 3)];
        [set addCharactersInRange:NSMakeRange(0xc12, 23)];
        [set addCharactersInRange:NSMakeRange(0xc2a, 10)];
        [set addCharactersInRange:NSMakeRange(0xc35, 5)];
        [set addCharactersInRange:NSMakeRange(0xc3e, 7)];
        [set addCharactersInRange:NSMakeRange(0xc46, 3)];
        [set addCharactersInRange:NSMakeRange(0xc4a, 4)];
        [set addCharactersInRange:NSMakeRange(0xc55, 2)];
        [set addCharactersInRange:NSMakeRange(0xc60, 2)];
        [set addCharactersInRange:NSMakeRange(0xc66, 10)];
        [set addCharactersInRange:NSMakeRange(0xc82, 2)];
        [set addCharactersInRange:NSMakeRange(0xc85, 8)];
        [set addCharactersInRange:NSMakeRange(0xc8e, 3)];
        [set addCharactersInRange:NSMakeRange(0xc92, 23)];
        [set addCharactersInRange:NSMakeRange(0xcaa, 10)];
        [set addCharactersInRange:NSMakeRange(0xcb5, 5)];
        [set addCharactersInRange:NSMakeRange(0xcbe, 7)];
        [set addCharactersInRange:NSMakeRange(0xcc6, 3)];
        [set addCharactersInRange:NSMakeRange(0xcca, 4)];
        [set addCharactersInRange:NSMakeRange(0xcd5, 2)];
        [set addCharactersInRange:NSMakeRange(0xcde, 1)];
        [set addCharactersInRange:NSMakeRange(0xce0, 2)];
        [set addCharactersInRange:NSMakeRange(0xce6, 10)];
        [set addCharactersInRange:NSMakeRange(0xd02, 2)];
        [set addCharactersInRange:NSMakeRange(0xd05, 8)];
        [set addCharactersInRange:NSMakeRange(0xd0e, 3)];
        [set addCharactersInRange:NSMakeRange(0xd12, 23)];
        [set addCharactersInRange:NSMakeRange(0xd2a, 16)];
        [set addCharactersInRange:NSMakeRange(0xd3e, 6)];
        [set addCharactersInRange:NSMakeRange(0xd46, 3)];
        [set addCharactersInRange:NSMakeRange(0xd4a, 4)];
        [set addCharactersInRange:NSMakeRange(0xd57, 1)];
        [set addCharactersInRange:NSMakeRange(0xd60, 2)];
        [set addCharactersInRange:NSMakeRange(0xd66, 10)];
        [set addCharactersInRange:NSMakeRange(0xd82, 2)];
        [set addCharactersInRange:NSMakeRange(0xd85, 18)];
        [set addCharactersInRange:NSMakeRange(0xd9a, 24)];
        [set addCharactersInRange:NSMakeRange(0xdb3, 9)];
        [set addCharactersInRange:NSMakeRange(0xdbd, 1)];
        [set addCharactersInRange:NSMakeRange(0xdc0, 7)];
        [set addCharactersInRange:NSMakeRange(0xdca, 1)];
        [set addCharactersInRange:NSMakeRange(0xdcf, 6)];
        [set addCharactersInRange:NSMakeRange(0xdd6, 1)];
        [set addCharactersInRange:NSMakeRange(0xdd8, 8)];
        [set addCharactersInRange:NSMakeRange(0xdf2, 3)];
        [set addCharactersInRange:NSMakeRange(0xe01, 58)];
        [set addCharactersInRange:NSMakeRange(0xe3f, 29)];
        [set addCharactersInRange:NSMakeRange(0xe81, 2)];
        [set addCharactersInRange:NSMakeRange(0xe84, 1)];
        [set addCharactersInRange:NSMakeRange(0xe87, 2)];
        [set addCharactersInRange:NSMakeRange(0xe8a, 1)];
        [set addCharactersInRange:NSMakeRange(0xe8d, 1)];
        [set addCharactersInRange:NSMakeRange(0xe94, 4)];
        [set addCharactersInRange:NSMakeRange(0xe99, 7)];
        [set addCharactersInRange:NSMakeRange(0xea1, 3)];
        [set addCharactersInRange:NSMakeRange(0xea5, 1)];
        [set addCharactersInRange:NSMakeRange(0xea7, 1)];
        [set addCharactersInRange:NSMakeRange(0xeaa, 2)];
        [set addCharactersInRange:NSMakeRange(0xead, 13)];
        [set addCharactersInRange:NSMakeRange(0xebb, 3)];
        [set addCharactersInRange:NSMakeRange(0xec0, 5)];
        [set addCharactersInRange:NSMakeRange(0xec6, 1)];
        [set addCharactersInRange:NSMakeRange(0xec8, 6)];
        [set addCharactersInRange:NSMakeRange(0xed0, 10)];
        [set addCharactersInRange:NSMakeRange(0xedc, 2)];
        [set addCharactersInRange:NSMakeRange(0xf00, 72)];
        [set addCharactersInRange:NSMakeRange(0xf49, 34)];
        [set addCharactersInRange:NSMakeRange(0xf71, 27)];
        [set addCharactersInRange:NSMakeRange(0xf90, 8)];
        [set addCharactersInRange:NSMakeRange(0xf99, 36)];
        [set addCharactersInRange:NSMakeRange(0xfbe, 15)];
        [set addCharactersInRange:NSMakeRange(0xfcf, 1)];
        [set addCharactersInRange:NSMakeRange(0x1000, 34)];
        [set addCharactersInRange:NSMakeRange(0x1023, 5)];
        [set addCharactersInRange:NSMakeRange(0x1029, 2)];
        [set addCharactersInRange:NSMakeRange(0x102c, 7)];
        [set addCharactersInRange:NSMakeRange(0x1036, 4)];
        [set addCharactersInRange:NSMakeRange(0x1040, 26)];
        [set addCharactersInRange:NSMakeRange(0x10a0, 38)];
        [set addCharactersInRange:NSMakeRange(0x10d0, 41)];
        [set addCharactersInRange:NSMakeRange(0x10fb, 1)];
        [set addCharactersInRange:NSMakeRange(0x1200, 7)];
        [set addCharactersInRange:NSMakeRange(0x1208, 63)];
        [set addCharactersInRange:NSMakeRange(0x1248, 1)];
        [set addCharactersInRange:NSMakeRange(0x124a, 4)];
        [set addCharactersInRange:NSMakeRange(0x1250, 7)];
        [set addCharactersInRange:NSMakeRange(0x1258, 1)];
        [set addCharactersInRange:NSMakeRange(0x125a, 4)];
        [set addCharactersInRange:NSMakeRange(0x1260, 39)];
        [set addCharactersInRange:NSMakeRange(0x1288, 1)];
        [set addCharactersInRange:NSMakeRange(0x128a, 4)];
        [set addCharactersInRange:NSMakeRange(0x1290, 31)];
        [set addCharactersInRange:NSMakeRange(0x12b0, 1)];
        [set addCharactersInRange:NSMakeRange(0x12b2, 4)];
        [set addCharactersInRange:NSMakeRange(0x12b8, 7)];
        [set addCharactersInRange:NSMakeRange(0x12c0, 1)];
        [set addCharactersInRange:NSMakeRange(0x12c2, 4)];
        [set addCharactersInRange:NSMakeRange(0x12c8, 7)];
        [set addCharactersInRange:NSMakeRange(0x12d0, 7)];
        [set addCharactersInRange:NSMakeRange(0x12d8, 23)];
        [set addCharactersInRange:NSMakeRange(0x12f0, 31)];
        [set addCharactersInRange:NSMakeRange(0x1310, 1)];
        [set addCharactersInRange:NSMakeRange(0x1312, 4)];
        [set addCharactersInRange:NSMakeRange(0x1318, 7)];
        [set addCharactersInRange:NSMakeRange(0x1320, 39)];
        [set addCharactersInRange:NSMakeRange(0x1348, 19)];
        [set addCharactersInRange:NSMakeRange(0x1361, 28)];
        [set addCharactersInRange:NSMakeRange(0x13a0, 85)];
        [set addCharactersInRange:NSMakeRange(0x1401, 630)];
        [set addCharactersInRange:NSMakeRange(0x1681, 28)];
        [set addCharactersInRange:NSMakeRange(0x16a0, 81)];
        [set addCharactersInRange:NSMakeRange(0x1700, 13)];
        [set addCharactersInRange:NSMakeRange(0x170e, 7)];
        [set addCharactersInRange:NSMakeRange(0x1720, 23)];
        [set addCharactersInRange:NSMakeRange(0x1740, 20)];
        [set addCharactersInRange:NSMakeRange(0x1760, 13)];
        [set addCharactersInRange:NSMakeRange(0x176e, 3)];
        [set addCharactersInRange:NSMakeRange(0x1772, 2)];
        [set addCharactersInRange:NSMakeRange(0x1780, 93)];
        [set addCharactersInRange:NSMakeRange(0x17e0, 10)];
        [set addCharactersInRange:NSMakeRange(0x1800, 14)];
        [set addCharactersInRange:NSMakeRange(0x1810, 10)];
        [set addCharactersInRange:NSMakeRange(0x1820, 88)];
        [set addCharactersInRange:NSMakeRange(0x1880, 42)];
        [set addCharactersInRange:NSMakeRange(0x1e00, 156)];
        [set addCharactersInRange:NSMakeRange(0x1ea0, 90)];
        [set addCharactersInRange:NSMakeRange(0x1f00, 22)];
        [set addCharactersInRange:NSMakeRange(0x1f18, 6)];
        [set addCharactersInRange:NSMakeRange(0x1f20, 38)];
        [set addCharactersInRange:NSMakeRange(0x1f48, 6)];
        [set addCharactersInRange:NSMakeRange(0x1f50, 8)];
        [set addCharactersInRange:NSMakeRange(0x1f59, 1)];
        [set addCharactersInRange:NSMakeRange(0x1f5b, 1)];
        [set addCharactersInRange:NSMakeRange(0x1f5d, 1)];
        [set addCharactersInRange:NSMakeRange(0x1f5f, 31)];
        [set addCharactersInRange:NSMakeRange(0x1f80, 53)];
        [set addCharactersInRange:NSMakeRange(0x1fb6, 7)];
        [set addCharactersInRange:NSMakeRange(0x1fbe, 1)];
        [set addCharactersInRange:NSMakeRange(0x1fc2, 3)];
        [set addCharactersInRange:NSMakeRange(0x1fc6, 7)];
        [set addCharactersInRange:NSMakeRange(0x1fd0, 4)];
        [set addCharactersInRange:NSMakeRange(0x1fd6, 6)];
        [set addCharactersInRange:NSMakeRange(0x1fe0, 13)];
        [set addCharactersInRange:NSMakeRange(0x1ff2, 3)];
        [set addCharactersInRange:NSMakeRange(0x1ff6, 7)];
        [set addCharactersInRange:NSMakeRange(0x200b, 3)];
        [set addCharactersInRange:NSMakeRange(0x2010, 7)];
        [set addCharactersInRange:NSMakeRange(0x2018, 12)];
        [set addCharactersInRange:NSMakeRange(0x2027, 1)];
        [set addCharactersInRange:NSMakeRange(0x2030, 12)];
        [set addCharactersInRange:NSMakeRange(0x203d, 1)];
        [set addCharactersInRange:NSMakeRange(0x203f, 8)];
        [set addCharactersInRange:NSMakeRange(0x204a, 9)];
        [set addCharactersInRange:NSMakeRange(0x2057, 1)];
        [set addCharactersInRange:NSMakeRange(0x2060, 1)];
        [set addCharactersInRange:NSMakeRange(0x2070, 2)];
        [set addCharactersInRange:NSMakeRange(0x2074, 6)];
        [set addCharactersInRange:NSMakeRange(0x207b, 1)];
        [set addCharactersInRange:NSMakeRange(0x207f, 11)];
        [set addCharactersInRange:NSMakeRange(0x208b, 1)];
        [set addCharactersInRange:NSMakeRange(0x20a0, 18)];
        [set addCharactersInRange:NSMakeRange(0x20d0, 27)];
        [set addCharactersInRange:NSMakeRange(0x2100, 59)];
        [set addCharactersInRange:NSMakeRange(0x213d, 15)];
        [set addCharactersInRange:NSMakeRange(0x2153, 49)];
        [set addCharactersInRange:NSMakeRange(0x2190, 575)];
        [set addCharactersInRange:NSMakeRange(0x2400, 39)];
        [set addCharactersInRange:NSMakeRange(0x2440, 11)];
        [set addCharactersInRange:NSMakeRange(0x2460, 20)];
        [set addCharactersInRange:NSMakeRange(0x24b6, 73)];
        [set addCharactersInRange:NSMakeRange(0x2500, 276)];
        [set addCharactersInRange:NSMakeRange(0x2616, 2)];
        [set addCharactersInRange:NSMakeRange(0x2619, 101)];
        [set addCharactersInRange:NSMakeRange(0x2680, 10)];
        [set addCharactersInRange:NSMakeRange(0x2701, 4)];
        [set addCharactersInRange:NSMakeRange(0x2706, 4)];
        [set addCharactersInRange:NSMakeRange(0x270c, 28)];
        [set addCharactersInRange:NSMakeRange(0x2729, 35)];
        [set addCharactersInRange:NSMakeRange(0x274d, 1)];
        [set addCharactersInRange:NSMakeRange(0x274f, 4)];
        [set addCharactersInRange:NSMakeRange(0x2756, 1)];
        [set addCharactersInRange:NSMakeRange(0x2758, 7)];
        [set addCharactersInRange:NSMakeRange(0x2761, 52)];
        [set addCharactersInRange:NSMakeRange(0x2798, 24)];
        [set addCharactersInRange:NSMakeRange(0x27b1, 14)];
        [set addCharactersInRange:NSMakeRange(0x27d0, 28)];
        [set addCharactersInRange:NSMakeRange(0x27f0, 644)];
        [set addCharactersInRange:NSMakeRange(0x2a77, 137)];
        [set addCharactersInRange:NSMakeRange(0x2e80, 26)];
        [set addCharactersInRange:NSMakeRange(0x2e9b, 89)];
        [set addCharactersInRange:NSMakeRange(0x3001, 32)];
        [set addCharactersInRange:NSMakeRange(0x302a, 14)];
        [set addCharactersInRange:NSMakeRange(0x303b, 5)];
        [set addCharactersInRange:NSMakeRange(0x3041, 86)];
        [set addCharactersInRange:NSMakeRange(0x3099, 2)];
        [set addCharactersInRange:NSMakeRange(0x309d, 99)];
        [set addCharactersInRange:NSMakeRange(0x3105, 40)];
        [set addCharactersInRange:NSMakeRange(0x3190, 40)];
        [set addCharactersInRange:NSMakeRange(0x31f0, 16)];
        [set addCharactersInRange:NSMakeRange(0x3251, 15)];
        [set addCharactersInRange:NSMakeRange(0x327f, 77)];
        [set addCharactersInRange:NSMakeRange(0x32d0, 47)];
        [set addCharactersInRange:NSMakeRange(0x3300, 119)];
        [set addCharactersInRange:NSMakeRange(0x337b, 71)];
        [set addCharactersInRange:NSMakeRange(0x33c3, 4)];
        [set addCharactersInRange:NSMakeRange(0x33c8, 16)];
        [set addCharactersInRange:NSMakeRange(0x33d9, 5)];
        [set addCharactersInRange:NSMakeRange(0x33e0, 31)];
        [set addCharactersInRange:NSMakeRange(0xa000, 1165)];
        [set addCharactersInRange:NSMakeRange(0xa490, 55)];
        [set addCharactersInRange:NSMakeRange(0xa700, 23)];
        [set addCharactersInRange:NSMakeRange(0xfa10, 3)];
        [set addCharactersInRange:NSMakeRange(0xfa1f, 4)];
        [set addCharactersInRange:NSMakeRange(0xfb00, 7)];
        [set addCharactersInRange:NSMakeRange(0xfb13, 5)];
        [set addCharactersInRange:NSMakeRange(0xfb1e, 1)];
        [set addCharactersInRange:NSMakeRange(0xfb20, 9)];
        [set addCharactersInRange:NSMakeRange(0xfb4f, 99)];
        [set addCharactersInRange:NSMakeRange(0xfbd3, 136)];
        [set addCharactersInRange:NSMakeRange(0xfc64, 44)];
        [set addCharactersInRange:NSMakeRange(0xfc91, 72)];
        [set addCharactersInRange:NSMakeRange(0xfcda, 24)];
        [set addCharactersInRange:NSMakeRange(0xfcf5, 71)];
        [set addCharactersInRange:NSMakeRange(0xfd3e, 2)];
        [set addCharactersInRange:NSMakeRange(0xfd50, 64)];
        [set addCharactersInRange:NSMakeRange(0xfd92, 54)];
        [set addCharactersInRange:NSMakeRange(0xfdf0, 10)];
        [set addCharactersInRange:NSMakeRange(0xfdfc, 1)];
        [set addCharactersInRange:NSMakeRange(0xfe00, 16)];
        [set addCharactersInRange:NSMakeRange(0xfe20, 4)];
        [set addCharactersInRange:NSMakeRange(0xfe31, 2)];
        [set addCharactersInRange:NSMakeRange(0xfe39, 14)];
        [set addCharactersInRange:NSMakeRange(0xfe51, 1)];
        [set addCharactersInRange:NSMakeRange(0xfe58, 1)];
        [set addCharactersInRange:NSMakeRange(0xfe5d, 2)];
        [set addCharactersInRange:NSMakeRange(0xfe73, 1)];
        [set addCharactersInRange:NSMakeRange(0xfe80, 125)];
        [set addCharactersInRange:NSMakeRange(0xfeff, 1)];
        [set addCharactersInRange:NSMakeRange(0xff10, 10)];
        [set addCharactersInRange:NSMakeRange(0xff21, 26)];
        [set addCharactersInRange:NSMakeRange(0xff41, 26)];
        [set addCharactersInRange:NSMakeRange(0xff5f, 65)];
        [set addCharactersInRange:NSMakeRange(0xffe0, 3)];
        [set addCharactersInRange:NSMakeRange(0xffe4, 3)];
        [set addCharactersInRange:NSMakeRange(0xffe8, 7)];
        [set addCharactersInRange:NSMakeRange(0x10300, 31)];
        [set addCharactersInRange:NSMakeRange(0x10320, 4)];
        [set addCharactersInRange:NSMakeRange(0x10330, 27)];
        [set addCharactersInRange:NSMakeRange(0x10400, 38)];
        [set addCharactersInRange:NSMakeRange(0x10428, 38)];
        [set addCharactersInRange:NSMakeRange(0x1d000, 246)];
        [set addCharactersInRange:NSMakeRange(0x1d100, 39)];
        [set addCharactersInRange:NSMakeRange(0x1d12a, 73)];
        [set addCharactersInRange:NSMakeRange(0x1d17b, 99)];
        [set addCharactersInRange:NSMakeRange(0x1d400, 85)];
        [set addCharactersInRange:NSMakeRange(0x1d456, 71)];
        [set addCharactersInRange:NSMakeRange(0x1d49e, 2)];
        [set addCharactersInRange:NSMakeRange(0x1d4a2, 1)];
        [set addCharactersInRange:NSMakeRange(0x1d4a5, 2)];
        [set addCharactersInRange:NSMakeRange(0x1d4a9, 4)];
        [set addCharactersInRange:NSMakeRange(0x1d4ae, 12)];
        [set addCharactersInRange:NSMakeRange(0x1d4bb, 1)];
        [set addCharactersInRange:NSMakeRange(0x1d4bd, 4)];
        [set addCharactersInRange:NSMakeRange(0x1d4c2, 2)];
        [set addCharactersInRange:NSMakeRange(0x1d4c5, 65)];
        [set addCharactersInRange:NSMakeRange(0x1d507, 4)];
        [set addCharactersInRange:NSMakeRange(0x1d50d, 8)];
        [set addCharactersInRange:NSMakeRange(0x1d516, 7)];
        [set addCharactersInRange:NSMakeRange(0x1d51e, 28)];
        [set addCharactersInRange:NSMakeRange(0x1d53b, 4)];
        [set addCharactersInRange:NSMakeRange(0x1d540, 5)];
        [set addCharactersInRange:NSMakeRange(0x1d546, 1)];
        [set addCharactersInRange:NSMakeRange(0x1d54a, 7)];
        [set addCharactersInRange:NSMakeRange(0x1d552, 338)];
        [set addCharactersInRange:NSMakeRange(0x1d6a8, 290)];
        [set addCharactersInRange:NSMakeRange(0x1d7ce, 50)];
        [set addCharactersInRange:NSMakeRange(0x1100, 90)];
        [set addCharactersInRange:NSMakeRange(0x115f, 68)];
        [set addCharactersInRange:NSMakeRange(0x11a8, 82)];
        [set addCharactersInRange:NSMakeRange(0xac00, 11172)];
        [set addCharactersInRange:NSMakeRange(0x3131, 94)];
        [set addCharactersInRange:NSMakeRange(0x3260, 28)];
        [set addCharactersInRange:NSMakeRange(0xffa0, 31)];
        [set addCharactersInRange:NSMakeRange(0xffc2, 6)];
        [set addCharactersInRange:NSMakeRange(0xffca, 6)];
        [set addCharactersInRange:NSMakeRange(0xffd2, 6)];
        [set addCharactersInRange:NSMakeRange(0xffda, 3)];
        [set addCharactersInRange:NSMakeRange(0x3021, 9)];
        [set addCharactersInRange:NSMakeRange(0x3400, 6582)];
        [set addCharactersInRange:NSMakeRange(0x4e00, 20902)];
        [set addCharactersInRange:NSMakeRange(0xfa0e, 2)];
        [set addCharactersInRange:NSMakeRange(0xfa13, 2)];
        [set addCharactersInRange:NSMakeRange(0xfa23, 2)];
        [set addCharactersInRange:NSMakeRange(0xfa27, 3)];
        [set addCharactersInRange:NSMakeRange(0x20000, 42711)];
        [set addCharactersInRange:NSMakeRange(0x2e80, 26)];
        [set addCharactersInRange:NSMakeRange(0x2e9b, 4)];
        [set addCharactersInRange:NSMakeRange(0x2ea0, 83)];
        [set addCharactersInRange:NSMakeRange(0x2f00, 214)];
        [set addCharactersInRange:NSMakeRange(0x3038, 3)];
        [set addCharactersInRange:NSMakeRange(0xf900, 270)];
        [set addCharactersInRange:NSMakeRange(0xfa15, 10)];
        [set addCharactersInRange:NSMakeRange(0xfa25, 2)];
        [set addCharactersInRange:NSMakeRange(0xfa2a, 4)];
        [set addCharactersInRange:NSMakeRange(0xfa30, 59)];
        [set addCharactersInRange:NSMakeRange(0x2f800, 542)];

        idnCharacters = [set copy];
    });
    return idnCharacters;
}

+ (instancetype)fullWidthCharacterSetForUnicodeVersion:(NSInteger)version {
    static NSMutableCharacterSet *sFullWidth8;
    static NSMutableCharacterSet *sFullWidth9;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        sFullWidth8 = [[NSMutableCharacterSet alloc] init];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x1100, 0x115f - 0x1100 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x11a3, 0x11a7 - 0x11a3 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x11fa, 0x11ff - 0x11fa + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x2329, 0x232a - 0x2329 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x2e80, 0x2e99 - 0x2e80 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x2e9b, 0x2ef3 - 0x2e9b + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x2f00, 0x2fd5 - 0x2f00 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x2ff0, 0x2ffb - 0x2ff0 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x3000, 0x303e - 0x3000 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x3041, 0x3096 - 0x3041 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x3099, 0x30ff - 0x3099 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x3105, 0x312d - 0x3105 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x3131, 0x318e - 0x3131 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x3190, 0x31ba - 0x3190 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x31c0, 0x31e3 - 0x31c0 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x31f0, 0x321e - 0x31f0 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x3220, 0x3247 - 0x3220 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x3250, 0x32fe - 0x3250 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x3300, 0x4dbf - 0x3300 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x4e00, 0xa48c - 0x4e00 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0xa490, 0xa4c6 - 0xa490 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0xa960, 0xa97c - 0xa960 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0xac00, 0xd7a3 - 0xac00 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0xd7b0, 0xd7c6 - 0xd7b0 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0xd7cb, 0xd7fb - 0xd7cb + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0xf900, 0xfaff - 0xf900 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0xfe10, 0xfe19 - 0xfe10 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0xfe30, 0xfe52 - 0xfe30 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0xfe54, 0xfe66 - 0xfe54 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0xfe68, 0xfe6b - 0xfe68 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0xff01, 0xff60 - 0xff01 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0xffe0, 0xffe6 - 0xffe0 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x1b000, 0x1b001 - 0x1b000 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x1f200, 0x1f202 - 0x1f200 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x1f210, 0x1f23a - 0x1f210 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x1f240, 0x1f248 - 0x1f240 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x1f250, 0x1f251 - 0x1f250 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x20000, 0x2fffd - 0x20000 + 1)];
        [sFullWidth8 addCharactersInRange:NSMakeRange(0x30000, 0x3fffd - 0x30000 + 1)];
        
        sFullWidth9 = [[NSMutableCharacterSet alloc] init];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1100, 0x115f - 0x1100 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x231a, 0x231b - 0x231a + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2329, 0x232a - 0x2329 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x23e9, 0x23ec - 0x23e9 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x25fd, 0x25fe - 0x25fd + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2614, 0x2615 - 0x2614 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2648, 0x2653 - 0x2648 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x26aa, 0x26ab - 0x26aa + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x26bd, 0x26be - 0x26bd + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x26c4, 0x26c5 - 0x26c4 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x26f2, 0x26f3 - 0x26f2 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x270a, 0x270b - 0x270a + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2753, 0x2755 - 0x2753 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2795, 0x2797 - 0x2795 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2b1b, 0x2b1c - 0x2b1b + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2e80, 0x2e99 - 0x2e80 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2e9b, 0x2ef3 - 0x2e9b + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2f00, 0x2fd5 - 0x2f00 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2ff0, 0x2ffb - 0x2ff0 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x3001, 0x303e - 0x3001 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x3041, 0x3096 - 0x3041 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x3099, 0x30ff - 0x3099 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x3105, 0x312d - 0x3105 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x3131, 0x318e - 0x3131 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x3190, 0x31ba - 0x3190 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x31c0, 0x31e3 - 0x31c0 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x31f0, 0x321e - 0x31f0 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x3220, 0x3247 - 0x3220 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x3250, 0x32fe - 0x3250 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x3300, 0x4dbf - 0x3300 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x4e00, 0xa48c - 0x4e00 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0xa490, 0xa4c6 - 0xa490 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0xa960, 0xa97c - 0xa960 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0xac00, 0xd7a3 - 0xac00 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0xf900, 0xfaff - 0xf900 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0xfe10, 0xfe19 - 0xfe10 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0xfe30, 0xfe52 - 0xfe30 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0xfe54, 0xfe66 - 0xfe54 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0xfe68, 0xfe6b - 0xfe68 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0xff01, 0xff60 - 0xff01 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0xffe0, 0xffe6 - 0xffe0 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x17000, 0x187ec - 0x17000 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x18800, 0x18af2 - 0x18800 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1b000, 0x1b001 - 0x1b000 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f191, 0x1f19a - 0x1f191 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f200, 0x1f202 - 0x1f200 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f210, 0x1f23b - 0x1f210 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f240, 0x1f248 - 0x1f240 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f250, 0x1f251 - 0x1f250 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f300, 0x1f320 - 0x1f300 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f32d, 0x1f335 - 0x1f32d + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f337, 0x1f37c - 0x1f337 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f37e, 0x1f393 - 0x1f37e + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f3a0, 0x1f3ca - 0x1f3a0 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f3cf, 0x1f3d3 - 0x1f3cf + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f3e0, 0x1f3f0 - 0x1f3e0 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f3f8, 0x1f43e - 0x1f3f8 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f442, 0x1f4fc - 0x1f442 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f4ff, 0x1f53d - 0x1f4ff + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f54b, 0x1f54e - 0x1f54b + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f550, 0x1f567 - 0x1f550 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f595, 0x1f596 - 0x1f595 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f5fb, 0x1f64f - 0x1f5fb + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f680, 0x1f6c5 - 0x1f680 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f6d0, 0x1f6d2 - 0x1f6d0 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f6eb, 0x1f6ec - 0x1f6eb + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f6f4, 0x1f6f6 - 0x1f6f4 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f910, 0x1f91e - 0x1f910 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f920, 0x1f927 - 0x1f920 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f933, 0x1f93e - 0x1f933 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f940, 0x1f94b - 0x1f940 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f950, 0x1f95e - 0x1f950 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f980, 0x1f991 - 0x1f980 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x20000, 0x2fffd - 0x20000 + 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x30000, 0x3fffd - 0x30000 + 1)];

        [sFullWidth9 addCharactersInRange:NSMakeRange(0x23f0, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x23f3, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x267f, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2693, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x26a1, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x26ce, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x26d4, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x26ea, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x26f5, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x26fa, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x26fd, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2705, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2728, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x274c, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x274e, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2757, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x27b0, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x27bf, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2b50, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x2b55, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x3000, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x16fe0, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f004, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f0cf, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f18e, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f3f4, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f440, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f57a, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f5a4, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f6cc, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f930, 1)];
        [sFullWidth9 addCharactersInRange:NSMakeRange(0x1f9c0, 1)];

    });

    if (version >= 9) {
        return sFullWidth9;
    } else {
        return sFullWidth8;
    }
}

+ (instancetype)ambiguousWidthCharacterSetForUnicodeVersion:(NSInteger)version {
    static NSMutableCharacterSet *sAmbiguousWidth8;
    static NSMutableCharacterSet *sAmbiguousWidth9;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        sAmbiguousWidth8 = [[NSMutableCharacterSet alloc] init];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x300, 0x36f - 0x300 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x391, 0x3a1 - 0x391 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3b1, 0x3c1 - 0x3b1 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x410, 0x44f - 0x410 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2160, 0x216b - 0x2160 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2170, 0x2179 - 0x2170 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2190, 0x2199 - 0x2190 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2460, 0x24e9 - 0x2460 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x24eb, 0x254b - 0x24eb + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2550, 0x2573 - 0x2550 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2580, 0x258f - 0x2580 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x26c4, 0x26cd - 0x26c4 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x26cf, 0x26e1 - 0x26cf + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x26e8, 0x26ff - 0x26e8 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2776, 0x277f - 0x2776 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3248, 0x324f - 0x3248 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xe000, 0xf8ff - 0xe000 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xfe00, 0xfe0f - 0xfe00 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x1f100, 0x1f10a - 0x1f100 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x1f110, 0x1f12d - 0x1f110 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x1f130, 0x1f169 - 0x1f130 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x1f170, 0x1f19a - 0x1f170 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xe0100, 0xe01ef - 0xe0100 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xf0000, 0xffffd - 0xf0000 + 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x100000, 0x10fffd - 0x100000 + 1)];

        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xa1, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xa4, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xa7, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xa8, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xaa, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xad, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xae, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xb0, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xb1, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xb2, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xb3, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xb4, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xb6, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xb7, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xb8, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xb9, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xba, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xbc, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xbd, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xbe, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xbf, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xc6, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xd0, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xd7, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xd8, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xde, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xdf, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xe0, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xe1, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xe6, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xe8, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xe9, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xea, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xec, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xed, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xf0, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xf2, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xf3, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xf7, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xf8, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xf9, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xfa, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xfc, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xfe, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x101, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x111, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x113, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x11b, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x126, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x127, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x12b, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x131, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x132, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x133, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x138, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x13f, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x140, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x141, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x142, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x144, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x148, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x149, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x14a, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x14b, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x14d, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x152, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x153, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x166, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x167, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x16b, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x1ce, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x1d0, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x1d2, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x1d4, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x1d6, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x1d8, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x1da, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x1dc, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x251, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x261, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2c4, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2c7, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2c9, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2ca, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2cb, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2cd, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2d0, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2d8, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2d9, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2da, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2db, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2dd, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2df, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3a3, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3a4, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3a5, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3a6, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3a7, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3a8, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3a9, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3c3, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3c4, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3c5, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3c6, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3c7, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3c8, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x3c9, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x401, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x451, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2010, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2013, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2014, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2015, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2016, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2018, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2019, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x201c, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x201d, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2020, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2021, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2022, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2024, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2025, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2026, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2027, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2030, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2032, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2033, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2035, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x203b, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x203e, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2074, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x207f, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2081, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2082, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2083, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2084, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x20ac, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2103, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2105, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2109, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2113, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2116, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2121, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2122, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2126, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x212b, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2153, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2154, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x215b, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x215c, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x215d, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x215e, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2189, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x21b8, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x21b9, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x21d2, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x21d4, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x21e7, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2200, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2202, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2203, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2207, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2208, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x220b, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x220f, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2211, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2215, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x221a, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x221d, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x221e, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x221f, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2220, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2223, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2225, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2227, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2228, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2229, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x222a, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x222b, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x222c, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x222e, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2234, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2235, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2236, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2237, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x223c, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x223d, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2248, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x224c, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2252, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2260, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2261, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2264, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2265, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2266, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2267, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x226a, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x226b, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x226e, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x226f, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2282, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2283, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2286, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2287, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2295, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2299, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x22a5, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x22bf, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2312, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2592, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2593, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2594, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2595, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25a0, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25a1, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25a3, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25a4, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25a5, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25a6, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25a7, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25a8, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25a9, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25b2, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25b3, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25b6, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25b7, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25bc, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25bd, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25c0, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25c1, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25c6, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25c7, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25c8, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25cb, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25ce, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25cf, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25d0, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25d1, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25e2, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25e3, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25e4, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25e5, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x25ef, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2605, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2606, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2609, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x260e, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x260f, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2614, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2615, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x261c, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x261e, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2640, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2642, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2660, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2661, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2663, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2664, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2665, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2667, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2668, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2669, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x266a, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x266c, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x266d, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x266f, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x269e, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x269f, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x26be, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x26bf, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x26e3, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x273d, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2757, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2b55, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2b56, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2b57, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2b58, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0x2b59, 1)];
        [sAmbiguousWidth8 addCharactersInRange:NSMakeRange(0xfffd, 1)];
        
        sAmbiguousWidth9 = [[NSMutableCharacterSet alloc] init];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xa7, 0xa8 - 0xa7 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xad, 0xae - 0xad + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xb0, 0xb4 - 0xb0 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xb6, 0xba - 0xb6 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xbc, 0xbf - 0xbc + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xd7, 0xd8 - 0xd7 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xde, 0xe1 - 0xde + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xe8, 0xea - 0xe8 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xec, 0xed - 0xec + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xf2, 0xf3 - 0xf2 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xf7, 0xfa - 0xf7 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x126, 0x127 - 0x126 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x131, 0x133 - 0x131 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x13f, 0x142 - 0x13f + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x148, 0x14b - 0x148 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x152, 0x153 - 0x152 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x166, 0x167 - 0x166 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2c9, 0x2cb - 0x2c9 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2d8, 0x2db - 0x2d8 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x300, 0x36f - 0x300 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x391, 0x3a1 - 0x391 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x3a3, 0x3a9 - 0x3a3 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x3b1, 0x3c1 - 0x3b1 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x3c3, 0x3c9 - 0x3c3 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x410, 0x44f - 0x410 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2013, 0x2016 - 0x2013 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2018, 0x2019 - 0x2018 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x201c, 0x201d - 0x201c + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2020, 0x2022 - 0x2020 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2024, 0x2027 - 0x2024 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2032, 0x2033 - 0x2032 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2081, 0x2084 - 0x2081 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2121, 0x2122 - 0x2121 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2153, 0x2154 - 0x2153 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x215b, 0x215e - 0x215b + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2160, 0x216b - 0x2160 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2170, 0x2179 - 0x2170 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2190, 0x2199 - 0x2190 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x21b8, 0x21b9 - 0x21b8 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2202, 0x2203 - 0x2202 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2207, 0x2208 - 0x2207 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x221d, 0x2220 - 0x221d + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2227, 0x222c - 0x2227 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2234, 0x2237 - 0x2234 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x223c, 0x223d - 0x223c + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2260, 0x2261 - 0x2260 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2264, 0x2267 - 0x2264 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x226a, 0x226b - 0x226a + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x226e, 0x226f - 0x226e + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2282, 0x2283 - 0x2282 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2286, 0x2287 - 0x2286 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2460, 0x24e9 - 0x2460 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x24eb, 0x254b - 0x24eb + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2550, 0x2573 - 0x2550 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2580, 0x258f - 0x2580 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2592, 0x2595 - 0x2592 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x25a0, 0x25a1 - 0x25a0 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x25a3, 0x25a9 - 0x25a3 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x25b2, 0x25b3 - 0x25b2 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x25b6, 0x25b7 - 0x25b6 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x25bc, 0x25bd - 0x25bc + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x25c0, 0x25c1 - 0x25c0 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x25c6, 0x25c8 - 0x25c6 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x25ce, 0x25d1 - 0x25ce + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x25e2, 0x25e5 - 0x25e2 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2605, 0x2606 - 0x2605 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x260e, 0x260f - 0x260e + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2660, 0x2661 - 0x2660 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2663, 0x2665 - 0x2663 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2667, 0x266a - 0x2667 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x266c, 0x266d - 0x266c + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x269e, 0x269f - 0x269e + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x26c6, 0x26cd - 0x26c6 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x26cf, 0x26d3 - 0x26cf + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x26d5, 0x26e1 - 0x26d5 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x26e8, 0x26e9 - 0x26e8 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x26eb, 0x26f1 - 0x26eb + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x26f6, 0x26f9 - 0x26f6 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x26fb, 0x26fc - 0x26fb + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x26fe, 0x26ff - 0x26fe + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2776, 0x277f - 0x2776 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2b56, 0x2b59 - 0x2b56 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x3248, 0x324f - 0x3248 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xe000, 0xf8ff - 0xe000 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xfe00, 0xfe0f - 0xfe00 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1f100, 0x1f10a - 0x1f100 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1f110, 0x1f12d - 0x1f110 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1f130, 0x1f169 - 0x1f130 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1f170, 0x1f18d - 0x1f170 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1f18f, 0x1f190 - 0x1f18f + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1f19b, 0x1f1ac - 0x1f19b + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xe0100, 0xe01ef - 0xe0100 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xf0000, 0xffffd - 0xf0000 + 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x100000, 0x10fffd - 0x100000 + 1)];

        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xa1, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xa4, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xaa, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xc6, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xd0, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xe6, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xf0, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xfc, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xfe, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x101, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x111, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x113, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x11b, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x12b, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x138, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x144, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x14d, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x16b, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1ce, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1d0, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1d2, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1d4, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1d6, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1d8, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1da, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x1dc, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x251, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x261, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2c4, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2c7, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2cd, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2d0, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2dd, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2df, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x401, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x451, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2010, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2030, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2035, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x203b, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x203e, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2074, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x207f, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x20ac, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2103, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2105, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2109, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2113, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2116, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2126, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x212b, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2189, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x21d2, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x21d4, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x21e7, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2200, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x220b, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x220f, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2211, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2215, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x221a, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2223, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2225, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x222e, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2248, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x224c, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2252, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2295, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2299, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x22a5, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x22bf, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2312, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x25cb, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x25ef, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2609, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x261c, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x261e, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2640, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x2642, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x266f, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x26bf, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x26e3, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x26f4, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0x273d, 1)];
        [sAmbiguousWidth9 addCharactersInRange:NSMakeRange(0xfffd, 1)];
    });
    
    if (version >= 9) {
        return sAmbiguousWidth9;
    } else {
        return sAmbiguousWidth8;
    }
}

+ (instancetype)zeroWidthSpaceCharacterSetForUnicodeVersion:(NSInteger)version {
    static dispatch_once_t onceToken;
    static NSCharacterSet *characterSet;
    dispatch_once(&onceToken, ^{
        NSString *string =
            @"\ufeff"  // zero width no-break space
            @"\u200c"  // zero width non-joiner
            @"\u200d";  // zero width joiner
        if (![iTermAdvancedSettingsModel zeroWidthSpaceAdvancesCursor]) {
            string = [string stringByAppendingString:@"\u200b"];  // zero width space
        }
        characterSet = [[NSCharacterSet characterSetWithCharactersInString:string] retain];
    });
    return characterSet;
}

+ (NSCharacterSet *)filenameCharacterSet {
    static NSMutableCharacterSet* filenameChars;
    if (!filenameChars) {
        filenameChars = [[NSCharacterSet whitespaceCharacterSet] mutableCopy];
        [filenameChars formUnionWithCharacterSet:[self urlCharacterSet]];
    }

    return filenameChars;
}

+ (NSCharacterSet *)urlCharacterSet {
    static NSMutableCharacterSet* urlChars;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        NSString *chars = [iTermAdvancedSettingsModel URLCharacterSet];
        urlChars = [[NSMutableCharacterSet characterSetWithCharactersInString:chars] retain];
        [urlChars formUnionWithCharacterSet:[NSCharacterSet idnCharacters]];
        [urlChars retain];
    });

    return urlChars;
}

@end
