//
//    Copyright 2007 Andreas Pfeiffer
//
/*
 *  This file is part of iAIDA.
 *
 *  iAIDA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as 
 *  published by the Free Software Foundation, either version 3 of 
 *  the License.
 *
 *  iAIDA is distributed in the hope that it will be useful, but 
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public 
 *  License along with iAIDA.  If not, see <http://www.gnu.org/licenses/>.
 */

// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_Dev_IDEVFUNCTIONCATALOG_H
#define AIDA_Dev_IDEVFUNCTIONCATALOG_H 1

#include <string>

#include "AIDA/IFunction.h"
#include "AIDA/IFunctionCatalog.h"

namespace AIDA {
namespace Dev {

/** @interface IDevFunctionCatalog
 *
 * Developer interface for function catalog.
 *
 * @author Jakub Moscicki, Max Turri, Victor Serbo
 * @author Andreas Pfeiffer, Max Sang, Tony Johnson, Lorenzo Moneta
 *
 * @stereotype developer
 */

class IDevFunctionCatalog : virtual public AIDA::IFunctionCatalog {

public: 
    /// Destructor.
    virtual ~IDevFunctionCatalog() { /* nop */; }

    /**
     * Load implementation of a model function from a persistent storage
     * and create a new object.
     *
     * Look-up for the proper shared library with the code for the function
     * and load if not already loaded.
     *
     * This is much more that a simple factory method and in fact is a part of
     * developper interface - user can use createFunctionByName from
     * IFunctionFactory.
     */
    virtual AIDA::IFunction * create(std::string name) = 0;
}; // class
} // namespace Dev
} // namespace AIDA
#endif /* ifndef AIDA_Dev_IDEVFUNCTIONCATALOG_H */
