//
//    Copyright 2007 Andreas Pfeiffer
//
/*
 *  This file is part of iAIDA.
 *
 *  iAIDA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as 
 *  published by the Free Software Foundation, either version 3 of 
 *  the License.
 *
 *  iAIDA is distributed in the hope that it will be useful, but 
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public 
 *  License along with iAIDA.  If not, see <http://www.gnu.org/licenses/>.
 */

// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_Dev_IDEVFITDATAITERATOR_H
#define AIDA_Dev_IDEVFITDATAITERATOR_H 1

#include <vector>

namespace AIDA {
namespace Dev {

/** @interface
 *
 * Iterator for the fit data allows to decouple abstract representation of data
 * and independently traverse the data in the inner fitting loop.
 *
 * @author The AIDA team.
 * 
 * @stereotype developer
 *
 */


class IDevFitDataIterator {

public: 
    /// Destructor.
    virtual ~IDevFitDataIterator() { /* nop */; }

    /**
     * Position the iterator at the start. The starting position
     * is right before the first element.
     *
     */
    virtual void start() = 0;

    /**
     * Move the iterator to the next element of the IFitData.
     * @return <code>true</code> If the iterator is positioned on a
     *         valide element.
     *
     */
    virtual bool next() = 0;

    /**
     * Get the total number of entries on which the
     * iterator is supposed to loop on. This is needed to calculate the Chi2 of a fit.
     * @return The total number of entries.
     *
     */
    virtual int entries() const = 0;

    /**
     * Get the array containing the variables for
     * the current data element. The variables should
     * be already in the right order for the value() method
     * of the IFunction.
     * @return The array of variables for the current data element.
     *
     */
    virtual const std::vector<double>  & vars() const = 0;

    /**
     * For Chi2-type fits it returns the "height" for evaluating
     * the contribution to the chi2 for the current element.
     * @return The value for the current element.
     *         unbinned-type fits.
     *
     */
    virtual double value() const = 0;

    /**
     * For Chi2-type fits it returns the error for the current element for the
     * evaluation of the chi2 contribution of the current element.
     * If the IFitData provides asymmetric errors it returns the positive error.
     * @return The error for the current element.
     *         unbinned-type fits.
     *
     */
    virtual double error() const = 0;

    /**
     * If the IFitData provides asymmetric errors it returns
     * the negative error on the current element. Otherwise it
     * returns the same value returned by the method error().
     * @return The minus error.
     *         unbinned-type fits.
     *
     */
    virtual double minusError() const = 0;
}; // class
} // namespace Dev
} // namespace AIDA
#endif /* ifndef AIDA_Dev_IDEVFITDATAITERATOR_H */
