//
//    Copyright 2007 Andreas Pfeiffer
//
/*
 *  This file is part of iAIDA.
 *
 *  iAIDA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as 
 *  published by the Free Software Foundation, either version 3 of 
 *  the License.
 *
 *  iAIDA is distributed in the hope that it will be useful, but 
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public 
 *  License along with iAIDA.  If not, see <http://www.gnu.org/licenses/>.
 */

// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_Dev_IDEVFITDATA_H
#define AIDA_Dev_IDEVFITDATA_H 1

#include "AIDA/IFitData.h"

namespace AIDA {
namespace Dev {

class IDevFitDataIterator;

/** @interface
 *
 * Developer interface for the IFitData.
 *
 * @author The AIDA team.
 * 
 * @stereotype developer
 *
 */

class IDevFitData : virtual public AIDA::IFitData {

public: 
    /// Destructor.
    virtual ~IDevFitData() { /* nop */; }

    /**
     * Get the iterator on the data.
     * @return The iterator.
     *
     */
    virtual IDevFitDataIterator * dataIterator() const = 0;

    /**
     * Get the type of fit this data is suitable for.
     * @return The type fit. Either IDevFitter.BINNED_FIT or IDevFitter.UNBINNED_FIT.
     *
     */
    virtual int fitType() const = 0;
}; // class
} // namespace Dev
} // namespace AIDA
#endif /* ifndef AIDA_Dev_IDEVFITDATA_H */
