//
//    Copyright 2007 Andreas Pfeiffer
//
/*
 *  This file is part of iAIDA.
 *
 *  iAIDA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as 
 *  published by the Free Software Foundation, either version 3 of 
 *  the License.
 *
 *  iAIDA is distributed in the hope that it will be useful, but 
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public 
 *  License along with iAIDA.  If not, see <http://www.gnu.org/licenses/>.
 */

// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_CPP_HISTOGRAMFACTORY_H
#define AIDA_CPP_HISTOGRAMFACTORY_H 1

//  This file is part of the AIDA_CPP library
//  Copyright (C) 2002 by the AIDA_CPP team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include "AIDA_CPP/GenFactory.h"



namespace AIDA_CPP {

  class IHistogram1D;
  class IHistogram2D;
  class IProfile1D;

  /**
   * User level interface for factory classes of Histograms (binned, unbinned, and profile)
   * The created objects are assumed to be managed by the tree which is associated to the factory.
   *
   * @author The AIDA_CPP team (http://aida.freehep.org/)
   *
   */
  template<typename Traits>
  class HistogramFactory : public GenFactory {

  public: 
    /*
    typedef typename Traits::BaseHistogram BaseHistogram;
    typedef typename Traits::Cloud1D Cloud1D;
    typedef typename Traits::Cloud2D Cloud2D;
    typedef typename Traits::Cloud3D Cloud3D;
    */
    typedef typename Traits::Histogram1D Histogram1D;
    typedef typename Traits::Histogram2D Histogram2D;
    typedef typename Traits::Histogram3D Histogram3D;
    typedef typename Traits::Profile1D Profile1D;
    typedef typename Traits::Profile2D Profile2D;

    
  public: 
    HistogramFactory() {
      // put<ICloud1D,Cloud1D>();
      put<IHistogram1D,Histogram1D>();
      put<IHistogram2D,Histogram2D>();
      put<IHistogram3D,Histogram3D>();
      put<IProfile1D,Profile1D>();
      put<IProfile2D,Profile2D>();
      // for creating from interfaces
      put<AIDA::IHistogram1D,Histogram1D>();
      put<AIDA::IHistogram2D,Histogram2D>();
      put<AIDA::IHistogram3D,Histogram3D>();
      put<AIDA::IProfile1D,Profile1D>();
      put<AIDA::IProfile2D,Profile2D>();

    }
    
    
    /// Destructor.
    virtual ~HistogramFactory() {}
    

}; // class

} // namespace AIDA_CPP
#endif /* ifndef AIDA_CPP_HISTOGRAMFACTORY_H */
