/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.jni;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.hyperic.jni.ArchLoader;
import org.hyperic.jni.ArchName;
import org.hyperic.jni.ArchNotSupportedException;

public class ArchNameTask
extends Task {
    public void execute() throws BuildException {
        String compiler;
        String archName;
        String osArch = System.getProperty("os.arch");
        if (this.getProject().getProperty("jni.dmalloc") != null) {
            ArchName.useDmalloc = true;
        }
        try {
            archName = ArchName.getName();
        }
        catch (ArchNotSupportedException e) {
            System.out.println(e.getMessage());
            return;
        }
        System.out.println(archName);
        this.getProject().setProperty("jni.libarch", archName);
        this.getProject().setProperty("jni.libpre", ArchLoader.getLibraryPrefix());
        this.getProject().setProperty("jni.libext", ArchLoader.getLibraryExtension());
        if (ArchLoader.IS_WIN32) {
            compiler = "msvc";
        } else if (ArchLoader.IS_HPUX) {
            compiler = "hp";
        } else if (ArchLoader.IS_AIX) {
            compiler = "xlc_r";
        } else {
            compiler = "gcc";
            this.getProject().setProperty("jni.compiler.isgcc", "true");
        }
        this.getProject().setProperty("jni.compiler", compiler);
        if (ArchName.is64()) {
            this.getProject().setProperty("jni.arch64", "true");
            if (ArchLoader.IS_LINUX && !osArch.equals("ia64")) {
                this.getProject().setProperty("jni.usem64", "true");
            }
        }
    }
}

