from distutils.core import setup, Extension

import os
import re

def get_libs(cmdline):
	s = os.popen(cmdline).read()
	return re.findall(r'-l(\w+)', s)

module1 = Extension(
			'_HyperEstraier',
			sources = ['HyperEstraier.i'],
			libraries = get_libs('estconfig --libs') + ['stdc++'])

setup(
	name = 'HyperEstraier',
	version = '0.01',
	py_modules = ['HyperEstraier'],
	description = 'Wrapper for Hyper Estraier, the full text search engine',
	ext_modules = [module1,])

