from subway.view import views
from subway import controller, util
from cherrypy import cpg

from HyperEstraier import *

views = views

class Root(controller.Controller):
	def index(self):
		return views.index()
	index.exposed = True

	def search(self, keyword=""):
		cond = Condition()
		cond.set_phrase(keyword)
		cond.set_order('@mdate STRD')
		numbers = self.db.search(cond, 0)
		return views.search(db = self.db, numbers=numbers)
	search.exposed = True

	def mail(self, id=""):
		return views.mail(doc=self.db.get_doc(int(id), 0))
	mail.exposed = True

	def __init__(self):
		self.db = Database()
		if not self.db.open('/tmp/casket', Database.DBREADER):
			raise "cannot open db"

controller = Root()
